<?php

function object_to_array($data)
{
    if (is_array($data) || is_object($data)) {
        $result = array();
        foreach ($data as $key => $value) {
            $result[$key] = object_to_array($value);
        }
        return $result;
    }
    return $data;
}

function objectToArray($object)
{
    if (! is_object($object) && ! is_array($object)) {
        return $object;
    }
    if (is_object($object)) {
        $object = get_object_vars($object);
    }
    return array_map('objectToArray', $object);
}

class Billing_c2 extends CI_Controller
{
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->load->model('frontdesk');
        $this->load->model('Curl_model');
        $this->load->model('mlanguages');
        $this->load->model('Appex');
        $this->load->model('Stripe');
        $this->Authorization->IsLogined();
    }
    
    function blist($id_c = 1)
    {
        if (isset($_GET["hms_id"])) {
            $this->session->unset_userdata('hms_id');
            $hms_id = $_GET["hms_id"];
            $newdata = array(
                'hms_id' => $hms_id
            );
            $this->session->set_userdata($newdata);
        }
        if (isset($_GET["doctype"])) {
            $this->session->unset_userdata('doctype');
            $doctype = $_GET["doctype"];
            $newdata = array(
                'doctype' => $doctype
            );
            $this->session->set_userdata($newdata);
        }
        
        $data = array(
            'id' => $id_c
        );
        $this->load->view('billing_c2_list_view', $data);
    }
    
    function redirect_payment()
    {
        
        $hms_id = $this->config->item('hotel_id');
        $postdata = array('hms_id' => $hms_id, 'user' => 'verified_user', 'pass' => 'nihuhrymuhry');
        $postdata = array('postdata' => json_encode($postdata));
        $srt_init = "https://cpcrm-dev.otelms.com/gate/get_bill_info";
        $ch = curl_init($srt_init);
        curl_setopt($ch, CURLOPT_POST,true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        $responce = json_decode($result, true);
        //print_r($responce);
        
        if (isset($responce['currency'])) {
            die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/" . $responce['currency'] . "/" . $responce['ratevalue'] . "'>");
        } else {
            echo "Please contact to support team. Undefined currency code! ";
            return;
        }
        
        
        return;
        
        
        // old logic
        $id_country_3c = "???";
        $hms_id = $this->config->item('hotel_id');
        $query = $this->db->query("select id_country_3c from visitka.config where id=" . $hms_id);
        if ($query->num_rows()) {
            $row = $query->row();
            $id_country_3c = $row->id_country_3c;
        } else {
            echo "hms_id error";
            return;
        }
        // if(isset($_SESSION ['user'] ["config_id_country"])){
        $config_id_country = $_SESSION['user']["config_id_country"];
        switch ($id_country_3c) {
            case "UKR":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/liqpay'>");
                break;
            case "RUS":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/appex'>");
                // die ( "<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/rub'>" );
                break;
            case "GEO":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/gel'>");
                break;
            case "POL":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/pln'>");
                break;
            case "GBR":
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/gbp'>");
                break;
            case "THA": // Тайланд
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "TJK": // Таджикистан
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "ARM": // Armenija
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "KAZ": // Raz
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "SVN": // Таджикистан
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "AZE": // Azer
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "HUN": // HUN
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "BLR": // BLR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "ESP": // BLR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "ALB": // ALB
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "BGR": // BGR
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "MDA": // MDA
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "ROU": // ROU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "KGZ": // KGZ
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
                
            case "MYS": // MYS
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "GRC": // GRC
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "NIC": // NIC
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "NPL": // NPL
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "CHL": // CHL
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "LVA": // LVA
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/usd'>");
                break;
            case "DEU": // DEU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            case "LTU": // LTU
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe/eur'>");
                break;
            default:
                echo "Please contact to support team. Undefined country code! ";
                echo $id_country_3c;
                return;
                die("<meta http-equiv='refresh' content='0;url=/billing_c2/stripe'>");
                break;
        }
        // }
    }
    
    function appex_v2($amount = 0)  // 2022-03-14
    {
        $data = array('amount' => $amount);
        $this->load->library('parser');
        $this->load->view('billing_c2_appex_v2_view.php', $data);
    }
    
    function appex_v2_response(){
        echo "OK";
    }
    
    function appex()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('billing_c2_appex_view.php', $data);
    }
    
    function appex_post()
    {
        if ($_POST["amount"] > 0) {
            // $main_guest_id = $this->frontdesk_c2->get_main_guest_id ( $_POST ["reservation_id"] );
            $exp_date_arr = explode("/", $_POST["exp_date"]);
            
            $cc_data = array();
            
            // $cc_data ["guest_id"] = $main_guest_id;
            $cc_data["cardnumber"] = $_POST["cardnumber"];
            $cc_data["cardholder"] = $_POST["cardholder"];
            $cc_data["cvc"] = $_POST["cvc"];
            $cc_data["active"] = 1;
            $cc_data["expmonth"] = $exp_date_arr[0];
            $cc_data["expyear"] = $exp_date_arr[1];
            $cc_data["amount"] = $_POST["amount"];
            $cc_data["hms_payment_id"] = 0;
            $cc_data["number"] = $this->config->item('hotel_id');
            $result = $this->Appex->billing_pay_request($cc_data);
            // die(1);
            // print_r($result);
            // die();
            
            switch ($result['status']) {
                case "authorise":
                    $hotel_id = $this->config->item('hotel_id');
                    $db3 = $this->load->database('db3', TRUE);
                    $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
						VALUES('" . $hotel_id . "', '2', '" . $_POST["amount"] . "', '" . $result['transID'] . "',
						'rub', '" . date("Y-m-d H:i:s") . "')";
                    // echo $sql;
                    $query = $db3->query($sql);
                    $billingdoc_id = $db3->insert_id();
                    $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
                    
                    $query = $db3->query($sql);
                    die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
                    break;
                case "OK":
                    $hotel_id = $this->config->item('hotel_id');
                    $db3 = $this->load->database('db3', TRUE);
                    $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
						VALUES('" . $hotel_id . "', '2', '" . $_POST["amount"] . "', '" . $result['transID'] . "',
						'rub', '" . date("Y-m-d H:i:s") . "')";
                    // echo $sql;
                    $query = $db3->query($sql);
                    $billingdoc_id = $db3->insert_id();
                    $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
                    
                    $query = $db3->query($sql);
                    die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
                    break;
                case "error":
                    $menu_data = $this->htmltpl->get_left_settings_menu(9, 2);
                    $html_data = array();
                    $html_data['errortext'] = $result['errortext'];
                    $html_data['header'] = $this->htmltpl->getHeader_new(0, 0);
                    $html_data["settings_main_menu"] = $menu_data["main_menu"];
                    $html_data["settings_sub_menu"] = $menu_data["sub_menu"];
                    echo $this->parser->parse('templates/billing_c2_appex_error_view.html', $html_data, TRUE);
                    return;
                    break;
                case "wait":
                    $data = array();
                    // $data ['pay_id'] = $pay_id;
                    $data['ACSURL'] = $result['ACSURL'];
                    $data['PaReq'] = $result['PaReq'];
                    $data['MD'] = $result['MD'];
                    $this->load->library('parser');
                    $this->load->view('billing_c2_appex_3ds_view.php', $data);
                    return;
                    break;
                default:
                    print_r($result);
                    // die();
                    break;
            }
        } else {
            echo "Error. Amount";
        }
        
        // ============================================================================
    }
    
    function biiling_response_3d()
    {
        $postdata = file_get_contents("php://input");
        $postdata = str_replace('\\\\', '\\', $postdata);
        
        if (isset($_POST["MD"])) {
            $jsonstr = $_POST["MD"];
            ;
        } else {
            $jsonstr = "unknown";
        }
        
        $post = array(
            'get' => $_SERVER['QUERY_STRING'],
            'post' => json_encode($_POST),
            'rawpost' => $postdata,
            'response' => $jsonstr,
            'server' => ""
        );
        
        $appex_param = $this->Appex->get_param_hms_billing();
        
        $sql = "select * from appex_payments_hms_billing where MD = '" . $jsonstr . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $id = $row->id;
            $amount = $row->amount;
            
            $data['PaRes'] = $_POST["PaRes"];
            $data['MD'] = $row->MD;
            $data['transID'] = $row->transID;
            $datetime = date('Y-m-d H:i:s');
            $data['datetime'] = $datetime;
            
            $key1 = $appex_param['key1'];
            $key2 = $appex_param['key2'];
            
            // signature
            $signature = '';
            $signature .= "{$data['PaRes']}:{$data['MD']}:{$data['transID']}:{$data['datetime']}";
            $signature .= ":{$key1}:{$key2}";
            $signature = strtoupper(md5($signature));
            
            $data['signature'] = $signature;
            
            $url = $appex_param['url_pares'];
            
            $response = $this->Curl_model->CurlAppex("", $data, $url);
            
            $res = json_decode($response, true);
            // echo "<pre>";
            // print_r($postdata);
            // print_r($res);
            // die();
            if (isset($res['status'])) {
                if ($res['status'] === "authorise") {
                    $this->db->query("update appex_payments set status_id=1, status='authorise' where transID=" . $res['transID']);
                    $hotel_id = $this->config->item('hotel_id');
                    $db3 = $this->load->database('db3', TRUE);
                    $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
						VALUES('" . $hotel_id . "', '2', '" . $amount . "', '" . $res['transID'] . "',
						'rub', '" . date("Y-m-d H:i:s") . "')";
                    // echo $sql;
                    $query = $db3->query($sql);
                    $billingdoc_id = $db3->insert_id();
                    $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`)
					VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',	'new')";
                    $query = $db3->query($sql);
                    
                    die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
                } else {
                    if ($res['status'] === "OK") {
                        $this->db->query("update appex_payments set status_id=1, status='authorise' where transID=" . $res['transID']);
                        $hotel_id = $this->config->item('hotel_id');
                        $db3 = $this->load->database('db3', TRUE);
                        $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
						VALUES('" . $hotel_id . "', '2', '" . $amount . "', '" . $res['transID'] . "',
						'rub', '" . date("Y-m-d H:i:s") . "')";
                        // echo $sql;
                        $query = $db3->query($sql);
                        $billingdoc_id = $db3->insert_id();
                        $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`)
					VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',	'new')";
                        $query = $db3->query($sql);
                        
                        die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
                    } else {
                        $menu_data = $this->htmltpl->get_left_settings_menu(9, 2);
                        $html_data = array();
                        $html_data['errortext'] = "status" . $res['status'];
                        $html_data['header'] = $this->htmltpl->getHeader_new(0, 0);
                        $html_data["settings_main_menu"] = $menu_data["main_menu"];
                        $html_data["settings_sub_menu"] = $menu_data["sub_menu"];
                        echo $this->parser->parse('templates/billing_c2_appex_error_view.html', $html_data, TRUE);
                        return;
                    }
                }
            } else {
                $menu_data = $this->htmltpl->get_left_settings_menu(9, 2);
                $html_data = array();
                $html_data['errortext'] = "no respone";
                $html_data['header'] = $this->htmltpl->getHeader_new(0, 0);
                $html_data["settings_main_menu"] = $menu_data["main_menu"];
                $html_data["settings_sub_menu"] = $menu_data["sub_menu"];
                echo $this->parser->parse('templates/billing_c2_appex_error_view.html', $html_data, TRUE);
                return;
            }
        } else {
            $menu_data = $this->htmltpl->get_left_settings_menu(9, 2);
            $html_data = array();
            $html_data['errortext'] = "no records!";
            $html_data['header'] = $this->htmltpl->getHeader_new(0, 0);
            $html_data["settings_main_menu"] = $menu_data["main_menu"];
            $html_data["settings_sub_menu"] = $menu_data["sub_menu"];
            echo $this->parser->parse('templates/billing_c2_appex_error_view.html', $html_data, TRUE);
            return;
        }
    }
    
    function firstdatapayment()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('billing_c2_firstdatapayment_view.php', $data);
    }
    
    function stripe($currency = "", $ratevalue = 1)
    {
        $data = array(
            "currency" => $currency,
            "ratevalue" => $ratevalue
            
        );
        $this->load->library('parser');
        $this->load->view('billing_c2_stripe_view.php', $data);
    }
    
    function liqpay()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('billing_c2_liqpay_view.php', $data);
    }
    
    function liqpay_post()
    {
        $postdata = $_POST;
        $amount = $postdata["amount"];
        $data = array(
            "amount" => $amount
        );
        $this->load->library('parser');
        $this->load->view('billing_c2_liqpay_post_view.php', $data);
    }
    
    function firstdata_post()
    {
        require_once (APPPATH . 'libraries/FirstData.php');
        $data = $this->input->post();
        
        $sql = "SELECT value FROM hotelix_config WHERE name LIKE 'firstdatatestmode'";
        $query = $this->db->query($sql);
        if ($query->num_rows()) {
            $row = $query->row();
            $testmode = $row->value;
        } else {
            $testmode = 0;
        }
        
        if ($testmode == 1) {
            define("API_LOGIN", "AH0568-01");
            define("API_KEY", "id9c816n7l896fsm5k949ik8xak069h0");
            $firstData = new FirstData(API_LOGIN, API_KEY, true);
        } else {
            define("API_LOGIN", "C72993-01");
            define("API_KEY", "nmrj0lntlww62kmaj385ymp86s1147tp");
            $firstData = new FirstData(API_LOGIN, API_KEY, false);
        }
        // setCreditCardType($data['type'])->
        // Charge
        
        $data['ccexp'] = preg_replace("/[^0-9]/", "", $data['ccexp']);
        
        $timestamp = time();
        $firstData->setTransactionType(FirstData::TRAN_PURCHASE);
        $firstData->setCreditCardNumber($data['ccnumber'])
        ->setCreditCardVerification($data['cccvv'])
        ->setCreditCardName($data['ccname'])
        ->setCreditCardExpiration($data['ccexp'])
        ->setAmount($data['ccamount'])
        ->setCustomerReferenceNumber($data['orderid'] . "-" . $timestamp)
        ->setReferenceNumber("hms-" . $data['orderid'] . "-" . $timestamp);
        
        if (isset($data['zip'])) {
            $firstData->setCreditCardZipCode($data['zip']);
        }
        
        if (isset($data['cvv'])) {
            $firstData->setCreditCardVerification($data['cvv']);
        }
        
        if (isset($data['address'])) {
            $firstData->setCreditCardAddress($data['address']);
        }
        
        $firstData->process();
        
        // Check
        
        if ($firstData->isError()) {
            // there was an error
            // echo "<pre>" . $firstData->getErrorMessage();
            // print_r($data);
            // print_r(json_decode($firstData->getResponse(), true));
            // echo "333";
            // print_r($firstData);
            
            $datap = array();
            $datap['error'] = $firstData->getErrorMessage() . "<br>" . $firstData->getBankResponseMessage();
            $datap['ccname'] = $data['ccname'];
            $datap['ccnumber'] = $data['ccnumber'];
            $datap['cccvv'] = $data['cccvv'];
            $datap['ccexp'] = $data['ccexp'];
            $datap['ccamount'] = $data['ccamount'];
            $this->load->library('parser');
            $this->load->view('billing_c2_firstdatapayment_view.php', $datap);
        } else {
            // transaction passed
            $response = $firstData->getResponse();
            $response_array = json_decode($response, true);
            if (! true) {
                echo "<pre>";
                echo "\n";
                echo $response_array['transaction_approved'];
                echo "\n";
                echo $response_array['ctr'];
                echo "\n\n";
                echo $response;
                echo "\n\n";
                print_r($response_array);
            }
            $hotel_id = $this->config->item('hotel_id');
            $db3 = $this->load->database('db3', TRUE);
            $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, datetime) VALUES('" . $hotel_id . "', '2', '" . $response_array["amount"] . "', '" . $response_array["reference_no"] . "', '" . date("Y-m-d H:i:s") . "')";
            // echo $sql;
            $query = $db3->query($sql);
            $billingdoc_id = $db3->insert_id();
            $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
		'new')";
            
            $query = $db3->query($sql);
            $data = array();
            $data['ctr'] = $response_array['ctr'];
            $this->load->library('parser');
            $this->parser->parse('templates/billing_c2_firstdata_success_view.html', $data);
        }
        // die();
        // ======================sql=========================
    }
    
    function stripepayment()
    {
        echo "<pre>";
        print_r($_POST);
        // require_once(APPPATH.'libraries/stripe/Stripe.php');
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        $stripe = array(
            'secret_key' => "sk_test_d19ipvh8ROnGPZ4L6q96S4BO",
            'publishable_key' => "pk_test_0toHn3UsTJbzBwO5WIhtQNBK"
        );
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        /*
         *
         * $customer = \Stripe\Stripe_Customer::create(array(
         * 'email' => $_POST['stripeEmail'],
         * 'card' => $_POST['stripeToken']
         * ));
         *
         * $charge = \Stripe\Stripe_Charge::create(array(
         * 'customer' => $customer->id,
         * 'amount' => 2000,
         * 'currency' => 'uah'
         * ));
         *
         */
        $charge = \Stripe\Charge::create(array(
            'amount' => 2001,
            'currency' => 'uah',
            'source' => $_POST['stripeToken']
        ));
        
        print_r($charge->getLastResponse());
        echo "<br><br><br>============== $ CHARGE =================<br><br><br>";
        print_r($charge);
    }
    
    function stripe_post($stripe_account)
    {
        // echo "<pre>";
        // print_r($_POST);
        // require_once(APPPATH.'libraries/stripe/Stripe.php');
        require_once (APPPATH . 'libraries/stripe/init.php');
        
        switch ($stripe_account) {
            case "us":
                $stripe = $this->Stripe->get_param_hms_billing();
                break;
            case "uk":
                $stripe = $this->Stripe->get_param_hms_billing_uk();
                break;
            default:
                die("Bill error");
                break;
        }
        
        \Stripe\Stripe::setApiKey($stripe['secret_key']);
        
        /*
         *
         * $customer = \Stripe\Stripe_Customer::create(array(
         * 'email' => $_POST['stripeEmail'],
         * 'card' => $_POST['stripeToken']
         * ));
         *
         * $charge = \Stripe\Stripe_Charge::create(array(
         * 'customer' => $customer->id,
         * 'amount' => 2000,
         * 'currency' => 'uah'
         * ));
         *
         */
        // $post = $this->input->post($_POST, true);
        $amount = $_POST['amount'];
        $currency = $_POST['currency'];
        
        $hotel_id = $this->config->item('hotel_id');
        $invoice = $hotel_id . "-" . time();
        
        /*
         * ===SAVE TOKEN LOG
         *
         */
        
        //         $data = array();
        //         $data['hms_id'] = $hotel_id;
        //         $data['token'] = $_POST['stripeToken'];
        //         $data['amount'] = $amount;
        //         $data['operation_type'] = "charge";
        //         $data['description'] = "hms-" . $invoice;
        
        //         $this->db->insert('global_hotelix.stripe_token_log', $data);
        
        try {
            $charge = \Stripe\Charge::create(array(
                'amount' => $amount * 100,
                'currency' => $currency,
                'description' => "hms-" . $invoice,
                'metadata' => array(
                    'order_id' => $invoice
                ),
                'source' => $_POST['stripeToken']
            ));
        } catch (Exception $e) {
            echo "<pre>";
            echo "error stored";
            $data = array();
            $data['hms_id'] = $hotel_id;
            $data['data'] = json_encode($e);
            
            $this->db->insert('global_hotelix.stripe_log', $data);
            
            $res = json_decode($data['data'], true);
            echo "\n";
            echo $res['jsonBody']['error']['code'];
            echo "\n";
            echo $res['jsonBody']['error']['message'];
            echo "\n";
            
            if ($_SERVER['REMOTE_ADDR'] == "217.65.249.175") {
                echo "<pre>";
                //print_r($e);
                //print_r($stripe);
                //die();
            }
            
        }
        
        
        
        
        $LastResponse = $charge->getLastResponse();
        $response = $LastResponse->json;
        // print_r($response);
        //print_r($response);
        //die();
        if ($response["paid"] == 1) {
            $hotel_id = $this->config->item('hotel_id');
            $db3 = $this->load->database('db3', TRUE);
            $sql = "INSERT INTO test.billingdoc (hmsID, doctype, amount, ref, currency, datetime)
			VALUES('" . $hotel_id . "', '2', '" . $response["amount"] / 100 . "', '" . $response["id"] . "',
			'" . $response["currency"] . "', '" . date("Y-m-d H:i:s") . "')";
            // echo $sql;
            $query = $db3->query($sql);
            $billingdoc_id = $db3->insert_id();
            $sql = "INSERT INTO test.log (`user_id`, `time`, `billingdoc_id`, `operation`) VALUES('0', '" . date("Y-m-d H:i:s") . "', '" . $billingdoc_id . "',
				'new')";
            
            $query = $db3->query($sql);
            
            die("<meta http-equiv='refresh' content='0;url=/billing_c2/blist/1'>");
        } else {
            echo "<pre>";
            print_r($_POST);
            
            echo "Payment error";
            
            print_r($response);
        }
    }
}
?>