<?php
class Ajax extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'debugmodel' );
		$this->load->model ( 'geoip_model' );
		$this->load->model ( 'dcm_booking_fsi' );
		$this->Authorization->IsLogined ();
	}
	
	function get_booking_misconduct_subcategories(){
	    $post = $_POST;
	    $category_value = $post["category_value"];
	    $return_data = array();
	    $misconduct_data = $this->dcm_booking_fsi->get_misconduct_categories();
	    foreach ($misconduct_data['subcategories'] as $cell) {
	        if ($cell['category_id'] == $category_value) {
	            array_push($return_data, array(
	                'value_name' => $cell['subc_type'],
	                'value_id' => $cell['subc_id']
	            ));
	        }
	    }
	   
	    echo json_encode ( $return_data );
	}
	
	function ajax_json() {
		require_once ('JSON.php');
		$json = new Services_JSON ();
		$reservations = array_values ( $_POST ['reservations'] );
		// print_r ($reservations);
		if (! isset ( $reservations [0] ["guest_id"] )) {
			$res_id = 0;
			
			$typeid = $reservations [0] ["typeid"];
			$roomid = $reservations [0] ["roomid"];
			$datein = $reservations [0] ["datein"];
			$dateout = $reservations [0] ["dateout"];
			$addplace_form = $reservations [0] ["addplace"];
			$babyplace_form = $reservations [0] ["babyplace"];
			$price_type = $reservations [0] ["price_type"];
			$post_data = array ();
			
			$post_data ["type_id"] = $reservations [0] ["typeid"];
			
			if (isset ( $reservations [0] ["ud_price_category"] )) {
				$post_data ["ud_price_category"] = $reservations [0] ["ud_price_category"];
			}
			
			$post_data ["room_id"] = $reservations [0] ["roomid"];
			$post_data ["datein"] = $reservations [0] ["datein"];
			$post_data ["dateout"] = $reservations [0] ["dateout"];
			
			$post_data ["add_places"] = $reservations [0] ["addplace"];
			$post_data ["baby_places"] = $reservations [0] ["babyplace"];
			$post_data ["price_type"] = $reservations [0] ["price_type"];
			if (! isset ( $reservations [0] ["discount"] )) {
				$post_data ["discount"] = 0;
			} else {
				$post_data ["discount"] = $reservations [0] ["discount"];
			}
			$post_data ["percent_discount"] = $reservations [0] ["percent_discount"];
			
			$post_data ["babyplace2"] = $reservations [0] ["babyplace2"];
			$post_data ["addbedplace"] = $reservations [0] ["addbedplace"];
			// echo "<pre>";
			// print_r($post_data);
			if (isset ( $reservations [0] ["div_guests"] )) {
				$div_guests = $reservations [0] ["div_guests"];
			} else {
				$div_guests = "";
			}
			
			if ($typeid == 0) {
				$s_1 = "<select id='addplace' class='forms' name='add_places' onchange='makeRequest(3);'>";
				$s_1 .= "<option value='0'>0</option>";
				$s_1 .= "</select>";
				$s_2 = "<select id='babyplace' class='forms' name='baby_places' onchange='makeRequest(3);'>";
				$s_2 .= "<option value='0'>0</option>";
				$s_2 .= "</select>";
				$select_div_guests = "<select id='div_guests' name='div_guests' class='forms' onchange='makeRequest(0);'>";
				for($i = 0; $i <= $addplaces - 1; $i ++) {
					// if ($div_guests <> "" AND $div_guests <> 0){
					if ($div_guests == $i) {
						$select_div_guests .= "<option selected value='" . $i . "'>" . $i . "</option>";
					} else {
						$select_div_guests .= "<option value='" . $i . "'>" . $i . "</option>";
					}
					// }
				}
				$select_div_guests .= "</select>";
				if ($datein != "" and $dateout != "") {
					list ( $year_in, $month_in, $day_in ) = explode ( "-", $datein );
					// transform datain in unix
					$date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
					// echo $date_in_unix."===";
					// parse dataout
					
					// $dateout = "2010-11-25";
					list ( $year_out, $month_out, $day_out ) = explode ( "-", $dateout );
					// transform dataout in unix
					$date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) );
					// echo $date_out_unix."====";
					// $sss .= "date_in_unix - $date_in_unix ; date_out_unix -
					// $date_out_unix ;";
					
					$duration = $date_out_unix - $date_in_unix;
					$parametres = array (
							"select_div_guests" => $select_div_guests,
							"add_baby" => "",
							"s1" => $s_1,
							"bool" => $reservations [0] ["bool"],
							"s2" => $s_2,
							"s3" => "",
							"total" => "",
							"duration" => $duration,
							"res_id" => $res_id 
					);
				} else {
					$parametres = array (
							"select_div_guests" => $select_div_guests,
							"add_baby" => "",
							"s1" => $s_1,
							"bool" => $reservations [0] ["bool"],
							"s2" => $s_2,
							"s3" => "",
							"total" => "",
							"duration" => "",
							"res_id" => $res_id 
					);
				}
			} else {
				if ($datein == "" or $dateout == "") {
					$s_1 = "<select id='addplace' class='forms' name='add_places' onchange='makeRequest(3);'>";
					$s_1 .= "<option value='0'>0</option>";
					$s_1 .= "</select>";
					$s_2 = "<select id='babyplace' class='forms' name='baby_places' onchange='makeRequest(3);'>";
					$s_2 .= "<option value='0'>0</option>";
					$s_2 .= "</select>";
					$select_div_guests = "<select id='div_guests' name='div_guests' class='forms' onchange='makeRequest(0);'>";
					for($i = 0; $i <= $addplaces - 1; $i ++) {
						// if ($div_guests <> "" AND $div_guests <> 0){
						if ($div_guests == $i) {
							$select_div_guests .= "<option selected value='" . $i . "'>" . $i . "</option>";
						} else {
							$select_div_guests .= "<option value='" . $i . "'>" . $i . "</option>";
						}
						// }
					}
					$select_div_guests .= "</select>";
					$parametres = array (
							"select_div_guests" => $select_div_guests,
							"add_baby" => "",
							"s1" => $s_1,
							"bool" => $reservations [0] ["bool"],
							"s2" => $s_2,
							"s3" => "",
							"total" => "",
							"duration" => "",
							"res_id" => $res_id 
					);
				} else {
					
					/*
					 * $addplace_form = 0; $babyplace_form = 0; $typeid = 2; $roomid = 0; $datein = "2011-12-01"; $dateout = "2011-12-03"; $price_type = 1;
					 */
					
					$sss = "";
					list ( $year_in, $month_in, $day_in ) = explode ( "-", $datein );
					// transform datain in unix
					$date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
					// echo $date_in_unix."===";
					// parse dataout
					
					// $dateout = "2010-11-25";
					list ( $year_out, $month_out, $day_out ) = explode ( "-", $dateout );
					// transform dataout in unix
					$date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) );
					// echo $date_out_unix."====";
					// $sss .= "date_in_unix - $date_in_unix ; date_out_unix -
					// $date_out_unix ;";
					
					$duration = $date_out_unix - $date_in_unix;
					
					$sql = "SELECT * FROM categories WHERE id = $typeid";
					
					$query = $this->db->query ( $sql );
					if ($query->num_rows () > 0) {
						$row = $query->row ();
						$addplaces = $row->add_places;
						$places = $row->places;
						$add_price = $row->add_price;
						$base_price = $row->base_price;
						$babyplaces = $row->baby_places;
						$baby_price = $row->baby_price;
					}
					$s_1 = "<select id='addplace' class='forms' name='add_places' onchange='makeRequest(3);'>";
					// if ($reservations [0] ["bool"] != 1)
					// $s_1 .= "<option selected value='" . $addplace_form . "'>" . $addplace_form . "</option>";
					// if ($addplace_form != 0)
					// $s_1 .= "<option value='0'>0</option>";
					for($i = 0; $i <= $addplaces - $places; $i ++) {
						// if ($reservations [0] ["bool"] != 1) {
						if ($i == $addplace_form) {
							$s_1 .= "<option selected value='" . $i . "'>" . $i . "</option>";
						} else {
							$s_1 .= "<option value='" . $i . "'>" . $i . "</option>";
						}
						// } else {
						// $s_1 .= "<option value='" . $i . "'>" . $i . "</option>";
						// }
					}
					$s_1 .= "</select>";
					$s_2 = "<select id='babyplace' class='forms' name='baby_places' onchange='makeRequest(3);'>";
					// if ($reservations [0] ["bool"] != 1)
					// $s_2 .= "<option selected value='" . $babyplace_form . "'>" . $babyplace_form . "</option>";
					// if ($babyplace_form != 0)
					// $s_2 .= "<option value='0'>0</option>";
					
					for($i = 0; $i <= $babyplaces; $i ++) {
						// if ($reservations [0] ["bool"] != 1) {
						if ($i == $babyplace_form) {
							$s_2 .= "<option selected value='" . $i . "'>" . $i . "</option>";
						} else {
							$s_2 .= "<option value='" . $i . "'>" . $i . "</option>";
						}
						// } else {
						// $s_2 .= "<option value='" . $i . "'>" . $i . "</option>";
						// }
					}
					$s_2 .= "</select>";
					
					$select_div_guests = "<select id='div_guests' name='div_guests' class='forms' onchange='makeRequest(0);'>";
					for($i = 0; $i <= $addplaces - 1; $i ++) {
						// if ($div_guests <> "" AND $div_guests <> 0){
						if ($div_guests == $i) {
							$select_div_guests .= "<option selected value='" . $i . "'>" . $i . "</option>";
						} else {
							$select_div_guests .= "<option value='" . $i . "'>" . $i . "</option>";
						}
						// }
					}
					$select_div_guests .= "</select>";
					$reservation_id = $reservations [0] ["reservation_id"];
					// $reservation_id = "{reservation_id}";
					// print_r($post_data);
					// echo $reservation_id;
					if (($datein == "") and ($dateout == "")) {
						$select = "";
					} else {
						if ($reservation_id != "") {
							$select = $this->FreeRooms ( $datein, $dateout, $reservation_id );
							
							$sss = $this->frontdesk->getpricecalculation ( $post_data, $reservation_id, 1 );
						} else {
							$select = $this->FreeRooms ( $datein, $dateout, 0 );
							$sss = $this->frontdesk->getpricecalculation ( $post_data, 0 );
						}
						// echo "<pre>";
						// print_r($sss);
						// $select = "";
					}
					$total = 0;
					for($i = 0; $i < count ( $sss ); $i ++) {
						$total += $sss [$i] ["amount"];
					}
					// echo $total;
					
					if ($post_data ["percent_discount"] != 0) {
						$discount = ($total / 100) * $post_data ["percent_discount"];
					} else {
						$discount = $post_data ["discount"];
					}
					// $total = $total - $post_data["discount"];
					
					$sql = "SELECT rooms.name, rooms.id FROM rooms WHERE rooms.category_id = $typeid AND $select GROUP BY rooms.id";
					// echo $sql;
					$query = $this->db->query ( $sql );
					
					$s_3 = "";
					foreach ( $query->result () as $row ) {
						if ($reservations [0] ["bool"] == 0) {
							if ($row->id == $roomid) {
								$s_3 .= "<option selected value='" . $row->id . "'>" . $row->name . "</option>";
							} else {
								$s_3 .= "<option value='" . $row->id . "'>" . $row->name . "</option>";
							}
						} else {
							$s_3 .= "<option value='" . $row->id . "'>" . $row->name . "</option>";
						}
					}
					
					$ratetocategory_array = array ();
					$query = $this->db->query ( "SELECT ratetocategory.*, categories.places  FROM ratetocategory INNER JOIN categories ON categories.id = ratetocategory.category_id" );
					foreach ( $query->result () as $row ) {
						if ($row->onlinebook == 1) {
							$onlinebook_str = "";
						} else {
							$onlinebook_str = ", не активный) ";
						}
						$ratetocategory_array [$row->rate_id] [$row->category_id] ["onlinebook_str"] = $onlinebook_str;
						if ($row->baseplace == 0) {
							$ratetocategory_array [$row->rate_id] [$row->category_id] ["baseplace"] = $row->places;
						} else {
							$ratetocategory_array [$row->rate_id] [$row->category_id] ["baseplace"] = $row->baseplace;
						}
					}
					
					$price_types = array ();
					$query = $this->db->query ( "SELECT * FROM rate" );
					foreach ( $query->result () as $row ) {
						array_push ( $price_types, array (
								"id" => $row->id,
								"name" => $row->caption 
						) );
					}
					$pricetypeselect = "";
					if ($price_type != 0) {
						
						for($i = 0; $i < count ( $price_types ); $i ++) {
							$select_rate_str = "";
							if (isset ( $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] )) {
								$select_rate_str .= ' (' . $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["baseplace"] . 'м';
								if ($ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["onlinebook_str"] != "") {
									$select_rate_str .= $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["onlinebook_str"];
								} else {
									$select_rate_str .= ')';
								}
							}
							if ($price_type != $price_types [$i] ["id"]) {
								$pricetypeselect .= " <option value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . $select_rate_str . "</option>";
							} else {
								$pricetypeselect .= " <option selected value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . $select_rate_str . "</option>";
							}
						}
					} else {
						for($i = 0; $i < count ( $price_types ); $i ++) {
							$select_rate_str = "";
							if (isset ( $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] )) {
								$select_rate_str .= ' (' . $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["baseplace"] . 'м';
								if ($ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["onlinebook_str"] != "") {
									$select_rate_str .= $ratetocategory_array [$price_types [$i] ["id"]] [$typeid] ["onlinebook_str"];
								} else {
									$select_rate_str .= ')';
								}
							}
							$pricetypeselect .= " <option value='" . $price_types [$i] ["id"] . "'>" . $price_types [$i] ["name"] . $select_rate_str . "</option>";
						}
					}
					
					$add_baby = "";
					
					$b = 1;
					if ($reservations [0] ["bool"] == 3 or $reservations [0] ["bool"] == 0 or $reservations [0] ["bool"] == 1) {
						if ($reservations [0] ["bool"] == 1) {
							$div_guests = 0;
							// echo "dfsdf";
						}
						// $add_div_count = $addplace_form;
						$add_div_count = $div_guests;
						if ($reservation_id != "" and $reservation_id != "{reservation_id}") {
							$query2 = $this->db->query ( "SELECT guests.* FROM guests INNER JOIN guests_deskofreservation
							ON guests_deskofreservation.guest_id = guests.id WHERE
							guests_deskofreservation.reservation_id = $reservation_id" );
							$i = 1;
							if ($query2->num_rows () > 0) {
								$i = 1;
								foreach ( $query2->result () as $row2 ) {
									
									$type = "Место $i";
									switch ($row2->gender) {
										case 0 :
											$select_1 = "";
											$select_2 = "";
											break;
										case 1 :
											$select_1 = "checked";
											$select_2 = "";
											break;
										case 2 :
											$select_1 = "";
											$select_2 = "checked";
											break;
									}
									
									$gender = "";
									if ($row2->gender != 0) {
										switch ($row2->gender) {
											case 1 :
												$gender .= " <option value='0'> </option>";
												$gender .= " <option selected value='1'>Мужской</option>";
												$gender .= " <option value='2'>Женский</option>";
												break;
											case 2 :
												$gender .= " <option value='0'> </option>";
												$gender .= " <option value='1'>Мужской</option>";
												$gender .= " <option selected value='2'>Женский</option>";
												break;
											default :
												$gender .= " <option selected value='0'> </option>";
												$gender .= " <option value='1'>Мужской</option>";
												$gender .= " <option value='2'>Женский</option>";
												break;
										}
									} else {
										$gender .= " <option selected value='0'> </option>";
										$gender .= " <option value='1'>Мужской</option>";
										$gender .= " <option value='2'>Женский</option>";
									}
									
									$data = array (
											'gender' => $gender,
											"select_1" => $select_1,
											"email" => $row2->email,
											"select_2" => $select_2,
											"a" => $i,
											"who" => "old",
											"guest_id" => $row2->id,
											"type" => $type,
											"firstname" => $row2->firstname,
											"lastname" => $row2->lastname,
											"passportid" => $row2->passportid,
											"dob" => $row2->dob,
											"address" => $row2->address 
									);
									if ($i <= $div_guests) {
										
										$add_baby .= $this->parser->parse ( 'templates/guest_addbaby_view.html', $data, true );
									}
									$i ++;
								}
							}
							// $add_div_count = $addplace_form-($i-1);
							$b = $i;
							$add_div_count = $div_guests - ($i - 1);
						}
						if ($div_guests != "" and $div_guests != 0) {
							for($a = 1; $a <= $add_div_count; $a ++) {
								$add_baby .= '<div class="box_bog_border">

<div id="fbFormPreamble" class="divPad">
<h3>Место ' . $b . '</h3></div>
<table class="content_forms">
<input type="hidden" value="1" name="add_' . $b . '">
<input type="hidden" value="new" name="who_' . $b . '">
<input type="hidden" value="" name="guest_id_' . $b . '">
<tbody>
<tr>
<td class="b">
Имя
<br>
<input class="forms" type="text" size="30" value="" name="firstname_' . $b . '">
</td>
<td class="b" colspan="2">
Фамилия
<br>
<input class="forms" type="text" size="30" value="" name="lastname_' . $b . '">
</td>
</tr>
<tr>
<td class="b">
Код паспорта
<br>
<input class="forms" type="text" size="30" value="" name="passportid_' . $b . '">
</td>
<td class="b">
Дата рождения
<br>
<input class="forms" type="text" size="16" value="0000-00-00" name="dob_' . $b . '">
</td>
<td class="b">
E-mail
<br>
<input class="forms" type="text" size="16" value="" name="email_' . $b . '">
</td>
</tr>
<tr>
<td class="b">
Адрес
<br>
<input class="forms" type="text" size="40" value="" name="address_' . $b . '">
</td>
<td class="b">
Пол
<br>
<select name="gender_' . $b . '" class="forms">
<option selected value="0"> </option>
<option value="1">Мужской</option>
<option value="2">Женский</option>
</select>
</td>
</tr>
</tbody>
</table>
</div><br>';
								$b ++;
							}
						}
					}
					
					$parametres = array (
							"select_div_guests" => $select_div_guests,
							"add_baby" => $add_baby,
							"s1" => $s_1,
							"bool" => $reservations [0] ["bool"],
							"s2" => $s_2,
							"s3" => $s_3,
							"pricetype" => $pricetypeselect,
							"total" => $total,
							"discount" => $discount,
							"duration" => $duration,
							"res_id" => $res_id 
					);
				}
			}
		} else {
			$guest_id = $_POST ["guest_id"];
			$sql = "SELECT * FROM guests WHERE id = $guest_id";
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row = $query->row ();
				
				$parametres = array (
						"guest_ids" => $guest_id,
						"firstname" => $row->firstname,
						"lastname" => $row->lastname,
						"phone" => $row->phone,
						"passportid" => $row->passportid,
						"address" => $row->address,
						"nationality" => $row->nationality,
						"dob" => $row->dob,
						"gender" => $row->gender,
						"postcode" => $row->postcode,
						"country" => $row->country,
						"state" => $row->state,
						"city" => $row->city 
				);
			}
		}
		$output = $json->encode ( $parametres );
		print_r ( $output );
	}
	function FreeRooms($datein, $dateout, $reservation_id) {
		$date_in_unix = $this->DateToUnixIn ( $datein );
		// echo "date_in_unix".$date_in_unix;
		$date_out_unix = $this->DateToUnixIn ( $dateout );
		// echo "date_out_unix".$date_out_unix;
		if ($reservation_id == 0) {
			$sql = "SELECT id, room_id, datein, dateout FROM deskofreservation WHERE deleted = 0 AND cancel = 0";
		} else {
			$sql = "SELECT id, room_id, datein, dateout FROM deskofreservation WHERE id <> $reservation_id and deleted = 0 AND cancel = 0";
		}
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$data [$row->id] ["datein"] = $this->DateToUnixIn ( $row->datein );
				$data [$row->id] ["dateout"] = $this->DateToUnixOut ( $row->dateout );
				$data [$row->id] ["room_id"] = $row->room_id;
			}
			// print_r($data);
			$keys = array_keys ( $data );
			$i = 0;
			$select = "";
			foreach ( $keys as $key ) {
				// echo "---";
				$in = $data [$key] ["datein"];
				$out = $data [$key] ["dateout"];
				// if ($key == 13)
				// echo "($in <= $date_in_unix) and ($in <= $date_out_unix) and
				// ($out >= $date_out_unix) and ($out >= $date_in_unix)||||";
				if ((($data [$key] ["datein"] <= $date_in_unix) and ($data [$key] ["dateout"] >= $date_in_unix)) or (($data [$key] ["datein"] >= $date_in_unix) and ($data [$key] ["datein"] < $date_out_unix) and ($data [$key] ["dateout"] <= $date_out_unix)) or (($data [$key] ["datein"] >= $date_in_unix) and ($data [$key] ["datein"] < $date_out_unix) and ($data [$key] ["dateout"] >= $date_out_unix))) {
					// /echo "7777777 ";
					$mass_not_free_rooms [$i] = $key;
					$i ++;
					/*
					 * if ($data[$key]["room_id"] == 138){ echo $key." ".$data[$key]["datein"]." ".$data[$key]["dateout"]." ".$date_in_unix." ".$date_out_unix; break; }
					 */
					$select .= "rooms.id <> " . $data [$key] ["room_id"] . " AND ";
					// echo $select;
				}
			}
			$select .= "1=1";
			/*
			 * $sql = "SELECT * FROM rooms WHERE $select"; //echo $sql; $result = mysql_query($sql, $link); $i = 0; $select = ""; while ($row = mysql_fetch_assoc($result)) { $free_rooms[$i] = $row["id"]; $select .= "rooms.id <> ".$row["id"]." AND "; $i++; } $select .= "1=1";
			 */
		} else {
			$select = "";
			$select .= "1=1";
		}
		return $select;
	}
	function DateToUnixIn($date) {
		list ( $year_in, $month_in, $day_in ) = explode ( "-", $date );
		$date_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
		return $date_unix;
	}
	function DateToUnixOut($date) {
		list ( $year_in, $month_in, $day_in ) = explode ( "-", $date );
		$date_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in - 1, $year_in ) ) / (3600 * 24) );
		return $date_unix;
	}
	
	/*
	 * function getpricecalculation($data, $reservetion_id) { //if($reservetion_id <> 0){ //	$data = $this->frontdesk->GetReservation ( $reservetion_id ); //} $tarif = array (); //echo "dateIN - ".$datein." dateOUT - ". $dateout; list ( $year_in, $month_in, $day_in ) = explode ( "-", $data ["datein"] ); //transform datain in unix $date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) ); //echo $date_in_unix."==="; //parse dataout //$dateout = "2010-11-25"; list ( $year_out, $month_out, $day_out ) = explode ( "-", $data ["dateout"] ); //transform dataout in unix $date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) ); //echo $date_out_unix."===="; //$sss .= "date_in_unix - $date_in_unix ; date_out_unix - $date_out_unix ;"; $duration = $date_out_unix - $date_in_unix; //$date_out_unix = round(date("U", mktime(0, 0, 0, $month_out, $day_out-1, $year_out))/(3600*24)); $sql = "SELECT * FROM seasons"; $query = $this->db->query ( $sql ); $season_data = array (); foreach ( $query->result () as $row ) { //echo $row['mp_street'] . "\n"; $season_data [$row->id] ["from"] = $row->startdate; $season_data [$row->id] ["to"] = $row->enddate; } //print_r($season_data); $keys = array_keys ( $season_data ); foreach ( $keys as $key ) { $from = $season_data [$key] ["from"]; list ( $from_year_season, $from_month_season, $from_day_season ) = explode ( "-", $from ); $from_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $from_month_season, $from_day_season, $from_year_season ) ) / (3600 * 24) ); //echo $key." - ".$from_date_season_unix."===="; $to = $season_data [$key] ["to"]; list ( $to_year_season, $to_month_season, $to_day_season ) = explode ( "-", $to ); $to_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $to_month_season, $to_day_season, $to_year_season ) ) / (3600 * 24) ); //echo $key." - ".$to_date_season_unix."===="; if (($date_in_unix <= $to_date_season_unix) and ($date_in_unix >= $from_date_season_unix)) { $tarif [$key] = ($to_date_season_unix - $date_in_unix) + 1; $sss = "$to_date_season_unix - $date_in_unix "; //echo $sss."+++".$tarif[$key]; //echo $duration; if ($date_out_unix <= $to_date_season_unix) { $tarif [$key] = $duration; //$sss .= "from_date_season_unix - $from_date_season_unix ; to_date_season_unix - $to_date_season_unix"; break; } } if (($date_out_unix >= $from_date_season_unix) and ($date_out_unix <= $to_date_season_unix)) { $tarif [$key] = $date_out_unix - $from_date_season_unix; //echo "+++".$date_out_unix."-".$from_date_season_unix; //$sss = $tarif[$key]; if ($tarif [$key] == "") { //echo "++++"; //$tarif[$key] = 1; } //$sss = $tarif[$key]."sss"; //$sss .= "from_date_season_unix - $from_date_season_unix ; to_date_season_unix - $to_date_season_unix"; } } //print_r($tarif); $tarif = $this->getcosttable ( $data ['datein'], $data ['dateout'], $season_data ); //print_r($tarif); $seasons_toprice = array_keys ( $tarif ); $total = 0; $seasons_days_count = 0; if ($data ["price_type"] == 0 or $data ["price_type"] == '') { $price_name_id = 1; } else { //$sql = "SELECT table_name FROM rate WHERE id = " . $data ["price_type"]; //$query = $this->db->query ( $sql ); //$row = $query->row (); $price_name_id = $data ["price_type"]; } $k = 0; $typeid = $data ['type_id']; foreach ( $seasons_toprice as $key ) { if ($key == 0) { $query = $this->db->query ( "SELECT * FROM categories WHERE id = $typeid" ); if ($query->num_rows () > 0) { $row = $query->row (); //$seasons_days_count += $tarif [$key]; $total += $tarif [$key] * $row->base_price; $temp = $tarif [$key] * $row->base_price; $result [$k] ["category_id"] = $typeid; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["season_id"] = $key; $result [$k] ["type_place"] = 1; $result [$k] ["price"] = $row->base_price; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } else { $query = $this->db->query ( "SELECT seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price FROM seasonspricelist INNER JOIN seasons ON seasons.id = seasonspricelist.season_id INNER JOIN rate ON rate.id = seasonspricelist.rate_id WHERE rate.id = $price_name_id AND seasons.id LIKE '$key' AND seasonspricelist.category_id = $typeid" ); if ($query->num_rows () > 0) { $row = $query->row (); $seasons_days_count += $tarif [$key]; $total += $tarif [$key] * $row->price; $temp = $tarif [$key] * $row->price; $result [$k] ["category_id"] = $row->category_id; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["season_id"] = $key; $result [$k] ["type_place"] = 1; $result [$k] ["price"] = $row->price; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } } if (count ( $seasons_toprice ) > 1) { if ($seasons_days_count < $duration) { $base_count = $duration - $seasons_days_count; $sql = "SELECT * FROM categories WHERE id = $typeid"; //echo $sql; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { $row = $query->row (); $base_price = $row->base_price; } $total += $base_count * $base_price; //echo "+++$duration-$seasons_days_count+++"; } } if ($total == 0) { $query = $this->db->query ( "SELECT base_price FROM categories WHERE id = $typeid" ); if ($query->num_rows () > 0) { $row = $query->row (); $total += $duration * $row->base_price; } } //$sql = "SELECT * FROM categories WHERE id = ".$typeid; //echo $sql; if (count ( $seasons_toprice ) != 0) { foreach ( $seasons_toprice as $key ) { if ($key == 0) { $query = $this->db->query ( "SELECT * FROM categories WHERE id = $typeid" ); if ($query->num_rows () > 0) { $row = $query->row (); //$seasons_days_count += $tarif[$key]; //$total += $tarif[$key]*$row->price; if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) { $total += $tarif [$key] * $row->add_price * $data ['add_places']; $temp = $tarif [$key] * $row->add_price * $data ['add_places']; for($i = 1; $i <= 1; $i ++) { $result [$k] ["season_id"] = $key; $result [$k] ["category_id"] = $row->id; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["type_place"] = 2; $result [$k] ["price"] = $row->add_price * $data ['add_places']; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) { $total += $tarif [$key] * $row->baby_price * $data ['baby_places']; $temp = $tarif [$key] * $row->baby_price * $data ['baby_places']; for($i = 1; $i <= 1; $i ++) { $result [$k] ["season_id"] = $key; $result [$k] ["category_id"] = $row->id; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["type_place"] = 3; $result [$k] ["price"] = $row->baby_price * $data ['baby_places']; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } } } else { $sql = "SELECT seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price FROM seasonspricelist INNER JOIN seasons ON seasons.id = seasonspricelist.season_id INNER JOIN rate ON rate.id = seasonspricelist.rate_id WHERE rate.id = $price_name_id AND seasons.id = $key AND seasonspricelist.category_id = $typeid"; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { $row = $query->row (); //$seasons_days_count += $tarif[$key]; //$total += $tarif[$key]*$row->price; if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) { $total += $tarif [$key] * $row->perperson_price * $data ['add_places']; $temp = $tarif [$key] * $row->perperson_price * $data ['add_places']; for($i = 1; $i <= 1; $i ++) { $result [$k] ["season_id"] = $key; $result [$k] ["category_id"] = $row->category_id; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["type_place"] = 2; $result [$k] ["price"] = $row->perperson_price * $data ['add_places']; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) { $total += $tarif [$key] * $row->extrabed_price * $data ['baby_places']; $temp = $tarif [$key] * $row->extrabed_price * $data ['baby_places']; for($i = 1; $i <= 1; $i ++) { $result [$k] ["season_id"] = $key; $result [$k] ["category_id"] = $row->category_id; $result [$k] ["price_type"] = $data ["price_type"]; $result [$k] ["type_place"] = 3; $result [$k] ["price"] = $row->extrabed_price * $data ['baby_places']; $result [$k] ["count"] = $tarif [$key]; $result [$k] ["amount"] = $temp; $k ++; } } } } } } //print_r($result); return $result; }
	 */
	function getcosttable($from, $to, $a) {
		// $to = date('Y-m-d',(intval(strtotime($to)/3600/24) - 0)*3600*24);
		$newdate = strtotime ( '-1 day', strtotime ( $to ) );
		$newdate = date ( 'Y-m-j', $newdate );
		$to = $newdate;
		
		$r = array ();
		$from = intval ( strtotime ( $from ) / 3600 / 24 );
		$to = intval ( strtotime ( $to ) / 3600 / 24 );
		$in_range = range ( $from, $to );
		
		foreach ( $a as $k => $v ) {
			$v_from = intval ( strtotime ( $v ['from'] ) / 3600 / 24 );
			$v_to = intval ( strtotime ( $v ['to'] ) / 3600 / 24 );
			$test_range = range ( $v_from, $v_to );
			$x = count ( array_intersect ( $in_range, $test_range ) );
			$x > 0 ? $r [$k] = $x : 0;
		}
		$diff = $to - $from + 1 - array_sum ( $r );
		$diff > 0 ? $r [0] = $diff : 0;
		return $r;
	}
	function ajax_check_print() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"] 
		);
		if (isset ( $post ["reservations"] [0] ["type"] )) {
			$data ["type"] = $post ["reservations"] [0] ["type"];
		}
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_check_print_view.php', $data );
	}
	
	function ajax_print_template() {
		$post = $_POST;
		$is_guest_active = 0;
		if(isset($post ["reservations"] [0] ["template_id"])){
			$sql = "SELECT is_guest_active FROM templates WHERE id = ".$post ["reservations"] [0] ["template_id"];
			$query = $this->db->query ( $sql );
			if ($query->num_rows() > 0)
			{
				$row = $query->row ();
				$is_guest_active = $row->is_guest_active;
			}
			
			if($is_guest_active == 0){
				die ( "<meta http-equiv='refresh' content='0;url=/formsprinter/print_template/".$post ["reservations"] [0] ["template_id"]."/".$post ["reservations"] [0] ["id"]."'>" );
			}
			
			$data = array (
					'reservation_id' => $post ["reservations"] [0] ["id"],
					'guest_id' => $post ["reservations"] [0] ["guest_id"],
					'template_id' => $post ["reservations"] [0] ["template_id"]
			);
		}else{
			$data = array (
					'reservation_id' => $post ["reservations"] [0] ["id"],
					'guest_id' => $post ["reservations"] [0] ["guest_id"],
					'template_id' => ""
			);
		}
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_print_template_view.php', $data );
	}
	function desk_option() {
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_desk_option_view.php', $data );
	}
	function desk_calendar2_option(){
		$data = array ();
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_desk_calendar2_option_view.php', $data );
	}
	function ajax_check_Allprint() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"],
				'guest_id' => $post ["reservations"] [0] ["guest_id"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_check_allprint_view.php', $data );
	}
	function ajax_guest_map() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"],
				'guest_id' => $post ["reservations"] [0] ["guest_id"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_guest_map_view.php', $data );
	}
	function ajax_fms() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"],
				'guest_id' => $post ["reservations"] [0] ["guest_id"]
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_fms_view.php', $data );
	}
	
	function get_category_list_by_property(){
	    $post = $_POST;
	    //echo "<pre>";
	    //print_r($post);
	    $property_id = 0;
	    if(isset($post["property_id"])){
	        $property_id = $post["property_id"];
	    }
	    $property_information = $this->frontdesk_c2->get_property_names();
	    
	    $result_array = array();
	    if($property_id > 0){
	       $result_array = $this->frontdesk_c2->get_categories($property_id);
	       foreach($result_array as $cat_id => $cell){
	           $category_property_id = $cell["category_property_id"];
	           $result_array[$cat_id]["category_property_name"] = "";
	           if(isset($property_information[$category_property_id])){
	               $result_array[$cat_id]["category_property_name"] = $property_information[$category_property_id]["name"];
	           }
	       }
	    }
        $html_data = array(
            "categories" => $result_array
        );
        $this->mlanguages->getdictionary ( "wizard_c2_step3", "", $html_data );
        $this->mlanguages->getdictionary ( "wizard_c2_tablist", "", $html_data );
	    echo $this->parser->parse ( 'templates/wizard_c2/wizard_c2_step3_ajax_list_view.html', $html_data, true );
	}
	
	function get_room_list_by_category(){
	    $post = $_POST;
	    //echo "<pre>";
	    //print_r($post);
	    $category_id = 0;
	    if(isset($post["category_id"])){
	        $category_id = $post["category_id"];
	    }
	    $result_array = array();
	    if($category_id > 0){
	        $result_array = $this->frontdesk_c2->get_rooms_info($category_id);
	    }
	    $html_data = array(
	        "rooms" => $result_array
	    );
	    $this->mlanguages->getdictionary ( "wizard_c2_step4", "", $html_data );
	    $this->mlanguages->getdictionary ( "wizard_c2_tablist", "", $html_data );
	    echo $this->parser->parse ( 'templates/wizard_c2/wizard_c2_step4_ajax_list_view.html', $html_data, true );
	}
	
	function ajax_fms_c2() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"],
				'guest_id' => $post ["reservations"] [0] ["guest_id"]
		);
		$this->load->library ( 'parser' );
		$this->load->view ( '/ajax/ajax_fms_c2_view.php', $data );
	}
	function ajax_bso() {
		$post = $_POST;
		$data = array (
				'payment_id' => $post ["reservations"] [0] ["id"]
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_bso_view.php', $data );
	}
	function ajax_balance() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_balance_view.php', $data );
	}
	function upload_foto() {
		$post = $_POST;
		$data = array (
				'guest_id' => $post ["reservations"] [0] ["id"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_upload_foto_view.php', $data );
	}
	function upload_category_foto() {
		$post = $_POST;
		// print_r($post);
		// die();
		$data = array (
				'id' => $post ["reservations"] [0] ["id"],
				'id_position' => $post ["reservations"] [0] ["id_position"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_upload_categoryfoto_view.php', $data );
	}
	function upload_document() {
		$post = $_POST;
		// print_r($post);
		// die();
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"] 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_upload_document_view.php', $data );
	}
	function send_feedback() {
		$post = $_POST;
		$reservation_id = $post ["reservations"] [0] ["id"];
		$hotel_id = 0;
		if (isset ( $_SERVER ["HTTP_HOST"] )) {
			$host = $_SERVER ["HTTP_HOST"];
			$sql = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
			// echo $query;
			$query = $this->db->query ( $sql );
			
			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$hotel_id = $row->id;
			}
		}
		
		$data = array (
				"reservation_id" => $reservation_id,
				"hotel_id" => $hotel_id 
		);
		$url = "http://revizor.guestbe.com/orders/SendMail_from_otelms/" . $reservation_id . "/" . $hotel_id;
		
		$output = json_encode ( $data );
		$result = $this->Curl_model->CurlPlugMass ( $output, $url );
		echo $result;
	}
	function delete_category_foto() {
		$post = $_POST;
		// print_r($post);
		// die();
		$query = $this->db->query ( "DELETE FROM categories_images WHERE category_id = " . $post ["reservations"] [0] ["id"] . " AND id_position = " . $post ["reservations"] [0] ["id_position"] );
	}
	function upload_hotel_foto($type_backpage) {
		$post = $_POST;
		// print_r($post);
		// die();
		$data = array (
				'id_position' => $post ["reservations"] [0] ["id_position"],
				"type_backpage" => $type_backpage 
		);
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_upload_hotelfoto_view.php', $data );
	}
	function delete_hotel_foto() {
		$post = $_POST;
		// print_r($post);
		// die();
		if ($post ["reservations"] [0] ["id_position"] == "classic") {
			$query = $this->db->query ( "DELETE FROM hotel_images WHERE classic_img = 1" );
		} else {
			$query = $this->db->query ( "DELETE FROM hotel_images WHERE type = " . $post ["reservations"] [0] ["id_position"] );
		}
	}
	function ajax_setservice_price() {
		$post = $_POST;
		// print_r($post);
		// die();
		$amount = 0;
		$query = $this->db->query ( "SELECT baseprice FROM services_types WHERE id = " . $post ["reservations"] [0] ["type"] );
		
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$amount = $row->baseprice;
		}
		
		$parametres = array (
				"amount" => $amount 
		);
		
		$output = json_encode ( $parametres );
		print_r ( $output );
	}
	function update_time() {
		echo date ( "d.m.Y H:i" );
	}
	
	function update_time_c2() {
		echo date ( "H:i" );
	}
	function message_setimportant() {
		$post = $_POST;
		// print_r($_POST);
		$id = $post ["reservations"] [0] ["msg_id"];
		$value = $post ["reservations"] [0] ["value"];
		$query = $this->db->query ( "UPDATE messages SET important = " . $value . " WHERE id = " . $id );
		if ($value == 1) {
			echo 0;
		} else {
			echo 1;
		}
	}
	function message_setread() {
		$post = $_POST;
		// print_r($_POST);
		$id = $post ["reservations"] [0] ["msg_id"];
		$value = $post ["reservations"] [0] ["value"];
		$query = $this->db->query ( "UPDATE messages SET isread = " . $value . " WHERE id = " . $id );
		if ($value == 1) {
			echo 0;
		} else {
			echo 1;
		}
	}
	function change_totalprice(){
		$post = $_POST;
		
		$pricetype = $post ["reservations"] [0] ["pricetype"];
		$total_price = 0;
		//print_r($_SESSION ["reservations"]);
		if (isset ( $_SESSION ["reservations"] )) {
			$rooms_categories = array ();
			$query = $this->db->query ( "SELECT * FROM rooms" );
			foreach ( $query->result () as $row ) {
				$rooms_categories[$row->id] = $row->category_id;
			}
			foreach ( $_SESSION ["reservations"] as $cell ) {
				$price_data = array();
				$price_data["datein"] = $cell["fulldate"];
		
				$price_data["dateout"] = date("Y-m-d", ($cell["date"]+1)*86400);
				$price_data["type_id"] = $rooms_categories[$cell["room"]];
				$price_data["price_type"] = $pricetype;
				$price_data["add_places"] = 0;
				$price_data["baby_places"] = 0;
				$price_data["babyplace2"] = 0;
				$price_data["addbedplace"] = 0;
				$temp_amount = $this->frontdesk->getpricecalculation($price_data, 0, 0);
				for($i = 0; $i < count ( $temp_amount ); $i ++) {
					$total_price += $temp_amount [$i] ["amount"];
				}
			}
		}
		echo $total_price;
	}
	function online_pay() {
		$post = $_POST;
		$data = array (
				'reservation_id' => $post ["reservations"] [0] ["id"]
		);
		if (isset ( $post ["reservations"] [0] ["type"] )) {
			$data ["type"] = $post ["reservations"] [0] ["type"];
		}
		$this->load->library ( 'parser' );
		$this->load->view ( 'ajax_online_pay_view.php', $data );
	}
	
	function get_entrygoal_select(){
		$post = $_POST;
		$id = $post["id"];
		$return_data = array();
		
		$legalsystem = $this->frontdesk->getlegalsystem();
		$legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
		
		$sql = "SELECT * FROM $legalsystem_db.dict_entrygoal WHERE VISACATEGORY_ID = ".$id;
		
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push($return_data, array(
				"value_id" => $row->id,
				"value_name" => $row->NAME,
				));
			}
		}
		echo json_encode ( $return_data );

	}
	function getdaterange($period) {//повертає стрічку дат старт-кінець: поточний тиждень, минулий тиждень, місяць і рік відповідно
		$result_str = "";
		switch ($period) {
			case 'week' :
				$result_str = date('d/m/Y', strtotime('Mon this week')) . '—' . date('d/m/Y', strtotime('Sun this week'));
				break;
			case 'month' :
				$result_str = date('d/m/Y', strtotime('first day of this month')) . '—' . date('d/m/Y', strtotime('last day of this month'));
				break;
			case 'year' :
				$result_str = date('d/m/Y', strtotime('first day of january this year')) . '—' . date('d/m/Y', strtotime('last day of december this year'));
// 				$result_str = date('01/01/Y') . '—' . date('31/12/Y');
				break;
			case 'lweek' :
				$result_str = date('d/m/Y', strtotime('Mon last week')) . '—' . date('d/m/Y', strtotime('Sun last week'));
				break;
			case 'lmonth' :
				$result_str = date('d/m/Y', strtotime('first day of last month')) . '—' . date('d/m/Y', strtotime('last day of last month'));
				break;
			case 'lyear' :
				$result_str = date('d/m/Y', strtotime('first day of january last year')) . '—' . date('d/m/Y', strtotime('last day of december last year'));
// 				$result_str = date('d/m/Y', strtotime('01-01-'.(date("Y")-1))) . '—' . date('d/m/Y', strtotime('31-12-'.(date("Y")-1)));
				break;
			default :
				$result_str = date('d/m/Y', strtotime('Mon this week')) . '—' . date('d/m/Y', strtotime('Sun this week'));
		}
		echo $result_str;
		return $result_str;
	}
	
	function get_property_block(){
		$post = $_POST;
		$dwelling_value = $post["dwelling_value"];
		$return_data = array();
		
		//$sql = "SELECT id, name FROM property_type WHERE dwelling = ".$dwelling_value;
		$sql = "SELECT id, name FROM global_hotelix_common.property_type WHERE dwelling = ".$dwelling_value;
		
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$trans_word = $this->mlanguages->getdictionaryword("tbl_property_types", $lang = "", "{-".$row->name."-}");
				if ($trans_word == "") {
					$trans_word = "{-".$row->name."-}";
				}
				
				$value_selected = "";
				if($dwelling_value == 2){
				    if($row->id == 14)
				        $value_selected = "selected";
				}
				array_push($return_data, array(
				"value_id" => $row->id,
				"value_name" => $trans_word,//"{-".$row->name."-}",
				"value_selected" => $value_selected
				));
			}			
		}
		echo json_encode ( $return_data );
	}
	
	function get_categories_by_property(){
	    $post = $_POST;
	    $property_id = $post["property_id"];
	    $return_data = array();
	    
	    $sql = "SELECT id, shortname FROM categories WHERE is_active = 1 AND property_id = ".$property_id;
	    
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            array_push($return_data, array(
	                "value_id" => $row->id,
	                "value_name" => $row->shortname
	            ));
	        }
	    }
	    echo json_encode ( $return_data );
	}
	
	function get_property_cordinat_old(){
	    $post = $_POST;
	    $street_value = $post["street_value"];
	    $city_value = $post["city_value"];
	    $country_value = $post["country_value"];
	    
	    //echo $street_value."::".$city_value."::".$country_value;
	    //die();
	    $address = $street_value . ',' . $city_value . ',' . $country_value;
	    
	    $lang = "eng";
	    $response = $this->geoip_model->get_coordinates( $address, $lang);
	    
	    echo $response;
	    
	    $geo_array = json_decode($response->raw_body, true);
	    
	    $lat = "";
	    $lng = "";
	    if(isset($geo_array["results"][0]["geometry"]["location"])){
	        $lat = $geo_array["results"][0]["geometry"]["location"]["lat"];
	        $lng = $geo_array["results"][0]["geometry"]["location"]["lng"];
	    }
	    echo $lat.",".$lng;
	    
	    
	}
	
	function get_property_cordinat(){
	    $post = $_POST;
	    $street_value = $post["street_value"];
	    $city_value = $post["city_value"];
	    $country_value = $post["country_value"];
	    
	    $address = $street_value . ',' . $city_value;
	    
	    $response = $this->geoip_model->get_coordinates( $address, $country_value);
	    
	    echo $response;
	}
	
	function check_valid_property(){
	    $return_data = array();
	    $property_data = $this->frontdesk_c2->get_property_data();
// 	    echo "<pre>";
// 	    print_r($property_data);
	    $return_data["error"] = 0;
	    $return_data["message"] = "";
	    $skip_dwelling = $this->frontdesk_c2->skip_dwelling();
	    if(($property_data["hotel_count"] > 0) 
	        && ($skip_dwelling == 0)
	        ){
// 	        $message_str = '<h3>{mlw_system_message}</h3>
//             {mlw_error_property_message}';
// 	        $return_data["message"] = $this->debugmodel->make_up_messege($message_str);
	        $return_data["error"] = 1;
	        
	        $data_msg = array(
	            "id" => 111
	        );
	        $message_str = $this->load->view ( 'header_msg_view', $data_msg, true );
	        $return_data["message"] = $message_str;
	    }
	    echo json_encode ( $return_data );
	}
}
?>