<?php
$start_date = "2015-11-01";
$end_date = "2017-11-11";

if($this->session->userdata ( 'reports_demographic_date' ) == ""){
	$date = $start_date." - ".$end_date;
}else{
	$date = $this->session->userdata ( 'reports_demographic_date' );
}
$array_date = explode(" - ", $date);

if(isset($array_date[0])){
	$start_date = trim($array_date[0]);
}
if(isset($array_date[1])){
	$end_date = trim($array_date[1]);
}

$start_date_shift = $start_date;
$end_date_shift = $end_date;
$period_shift = 7;

if ($this->session->userdata ( 'reports_demographic_period_shift' ) != "") {
	$period_shift = $this->session->userdata ( 'reports_demographic_period_shift' );
}
list ( $year, $month, $day ) = explode ( "-", $start_date );
$start_date_int = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
list ( $year, $month, $day ) = explode ( "-", $end_date );
$end_date_int = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

$new_start_date_int = $start_date_int - $period_shift;
$new_end_date_int = $end_date_int - $period_shift;

$start_date_shift = date ( "Y-m-d", $new_start_date_int * 86400 );
$end_date_shift = date ( "Y-m-d", $new_end_date_int * 86400 );

$shift_periods = array (
		'1' => " - 1 {mlw_day1}",
		'7' => " - 7 {mlw_day2}",
		'30' => " - 30 {mlw_day2}",
		'90' => " - 90 {mlw_day2}",
		'365' => " - 365 {mlw_day2}"
);
$shift_periods_options = array();
foreach ( $shift_periods as $key_value => $txt_value ) {
	array_push ( $shift_periods_options, array (
	'value_periods_options' => $key_value,
	'txt_periods_options' => $txt_value,
	'selected' => ($key_value == $period_shift) ? "selected" : ""
			) );
}
//echo $start_date." ".$end_date."<br>";
//echo $start_date_shift." ".$end_date_shift;
$demographic_data_1 = $this->report_model->get_demographic_data($start_date, $end_date);

$demographic_data_2 = $this->report_model->get_demographic_data($start_date_shift, $end_date_shift);
//echo "<pre>";
//print_r($demographic_data_1);
//print_r($demographic_data_2);
//die();



$data = array (
		'date' => $date,
		'shift_periods_options' => $shift_periods_options,
		'header' => $this->htmltpl->getHeader_new (),
        'footer_html' => $this->htmltpl->getFooter_new (),
		'left_menu' => $this->htmltpl->get_left_menu (3) 
);

$data ["graf_column_age_1"] = $this->report_model->get_columngraph_draw_data($demographic_data_1['graph_age'], $div_id_name = "div_column_age_1");
$data ["graf_column_age_2"] = $this->report_model->get_columngraph_draw_data($demographic_data_2['graph_age'], $div_id_name = "div_column_age_2");

$data ["graph_citizenship_1"] = "";
if(isset($demographic_data_1['graph_citizenship'])){
	$data ["graph_citizenship_1"] = $this->report_model->get_columngraph_draw_data($demographic_data_1['graph_citizenship'], $div_id_name = "div_column_citizenship_1");
}

$data ["graph_citizenship_2"] = "";
if(isset($demographic_data_2['graph_citizenship'])){
	$data ["graph_citizenship_2"] = $this->report_model->get_columngraph_draw_data($demographic_data_2['graph_citizenship'], $div_id_name = "div_column_citizenship_2");
}

$data ["graf_gender_1"] = $this->report_model->get_piegraph_draw_data($demographic_data_1['graph_gender'], $div_id_name = "div_pie_gender_1");
$data ["graf_gender_2"] = $this->report_model->get_piegraph_draw_data($demographic_data_2['graph_gender'], $div_id_name = "div_pie_gender_2");

$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse ( 'templates/reports_c2_demographic_reports_view.html', $data );
?>