<?php
$days_numbers = $this->report_model->get_days_numbers();
$months = $this->report_model->get_months();
$selected_year_period = $this->session->userdata ( 'report_occupancy_selected_year_period' );
if($selected_year_period == ""){
		$selected_year_period = date("Y");
}

$select_option_categories = $this->report_model->get_active_and_isactiveroom_categories();
$selected_categories = $this->session->userdata ( 'report_occupancy_selected_categories' );
if ($selected_categories == ""){
	$selected_categories = array();
	foreach ($select_option_categories as $cat) {
		array_push($selected_categories, $cat['id']);
	}
}
foreach ($select_option_categories as &$category_data) {
	if(!in_array($category_data['id'], $selected_categories)){
		$category_data['selected'] = "";
	}
	unset($category_data);
}
$select_option_dealers = $this->report_model->get_active_dealers();
$selected_dealers = $this->session->userdata ( 'report_occupancy_selected_dealers' );
if ($selected_dealers == ""){
	$selected_dealers = array();
	foreach ($select_option_dealers as $deal) {
		array_push($selected_dealers, $deal['id']);
	}
}
foreach ($select_option_dealers as &$dealer_data) {
	if(!in_array($dealer_data['id'], $selected_dealers)){
		$dealer_data['selected'] = "";
	}
	unset($dealer_data);
}
$bar_curr_period_data = array();
$categories_occ = array();
foreach ($selected_categories as $cat_id) {
	$categories_occ[$cat_id] = 0;
}
$month_data_pars_arr = array();
$year_room_reserved = 0;
$correction_curr_month_data['till_today'] = $correction_curr_month_data['past_today'] = 1;
$today_month = date("n");
$today_year = date("Y");
foreach ($months as $month) {
	$month_days_pars_arr = array();
	$start_intdate = round(strtotime("first day of ".$month['Full_name']." $selected_year_period") / 86400);
	$end_intdate = round(strtotime("last day of ".$month['Full_name']." $selected_year_period") / 86400);
	$temp_data = $this->report_model->get_ADRREV_graphycs_data($start_intdate, $end_intdate, $selected_categories, $selected_dealers);
	$year_room_reserved += $temp_data['total_all_period_all_categories']['all']['room_reserved'];
	$today_int = round(strtotime("today") / 86400);
	foreach ($temp_data['dates_per_all_categories'] as $intday_of_month => $day_of_month_data) {
		$occ_val = $day_of_month_data['ocupancy_4digit'] * 100;
		$occ_day_class = $intday_of_month > $today_int ? "bgbox_gray" . ceil ( $occ_val / 10 ) : "bgbox_blue" . ceil ( $occ_val / 10 );
		array_push ( $month_days_pars_arr, array (
				'occ_val' => $this->frontdesk->showcurrency($occ_val),
				'occ_day_class' => $occ_day_class,
		) );
		if ($selected_year_period == $today_year && $month['number'] == $today_month){
			if ($intday_of_month <= $today_int){
				$correction_curr_month_data['till_today'] += $day_of_month_data['room_reserved'];
			}else {
				$correction_curr_month_data['past_today'] += $day_of_month_data['room_reserved'];
			}
		}
	}
	$del = 31 - count($month_days_pars_arr);
	if ($del > 0){
		for ($i = 0; $i < $del; $i++) {
			array_push ( $month_days_pars_arr, array (
			'occ_val' => "",//$this->frontdesk->showcurrency(0),
			'occ_day_class' => ""
			) );
		}
	}
	array_push ( $bar_curr_period_data, $this->frontdesk->showcurrency(round($temp_data['total_all_period_all_categories']['all']['ocupancy_4digit'] * 100, 2)));
	foreach ($temp_data['total_all_period_all_categories'] as $cat_id => $cat_data) {
		if ($cat_id != "all"){
			$categories_occ[$cat_id] += $cat_data['ocupancy_4digit'];
		}
	}
	array_push ( $month_data_pars_arr, array (
			'name' => $month ['clt_name'],
			'month_days_pars_arr' => $month_days_pars_arr,
			'month_occ' => $temp_data['total_all_period_all_categories']['all']['ocupancy'] * 100,
			'month_ADR' => $this->frontdesk->showcurrency($temp_data['total_all_period_all_categories']['all']['ADR']),
			'month_room_reserved' => $temp_data['total_all_period_all_categories']['all']['room_reserved'],
	) );
}
foreach ($month_data_pars_arr as &$month_data) {
    $month_data['month_year_occ'] = ($year_room_reserved !=0) ? $this->frontdesk->showcurrency(round($month_data['month_room_reserved']/$year_room_reserved * 100, 2)) : 0;
// 	$month_data['year_room_reserved'] = $year_room_reserved;//для переревірки, так не потрібне
	unset($month_data);
}
$data = array (
		'days_numbers' => $days_numbers,
		'month_data_pars_arr' => $month_data_pars_arr,
		'select_option_categories' => $select_option_categories,
		'select_option_dealers' => $select_option_dealers,
		'year_period' => $selected_year_period,
);
//========== graf bars data START =================
$bar_months_names = array();
foreach ($months as $month) {
	array_push($bar_months_names, $month['clt_name']);
}
$prev_year_period = date("Y", strtotime("01-01-$selected_year_period - 1 year"));
$bar_prev_period_data = array();
foreach ($months as $month) {
	$start_prev_intdate = round(strtotime("first day of ".$month['Full_name']." $prev_year_period") / 86400);
	$end_prev_intdate = round(strtotime("last day of ".$month['Full_name']." $prev_year_period") / 86400);
	$temp_prev_data = $this->report_model->get_ADRREV_graphycs_data($start_prev_intdate, $end_prev_intdate, $selected_categories, $selected_dealers);
	array_push ( $bar_prev_period_data, $temp_prev_data['total_all_period_all_categories']['all']['ocupancy_4digit'] * 100);
}
$bar_grey_period_data = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
if ($selected_year_period == $today_year){// && $month['number'] == $today_month
	$bar_grey_period_data = $bar_curr_period_data;
	foreach ($months as $month) {
		if ($month['number'] < $today_month){
			$bar_grey_period_data[$month['number'] - 1] = 0;
		}elseif($month['number'] > $today_month) {
			$bar_curr_period_data[$month['number'] - 1] = 0;
		}else {
			$grey_koef_percent = round($correction_curr_month_data['past_today'] / ($correction_curr_month_data['past_today'] + $correction_curr_month_data['till_today']) * 100, 2);
			$bar_grey_period_data[$month['number'] - 1] = $this->frontdesk->showcurrency(round($bar_curr_period_data[$month['number'] - 1] * $grey_koef_percent / 100, 2));
			$bar_curr_period_data[$month['number'] - 1] -= $bar_grey_period_data[$month['number'] - 1];
		}
	}
}
$data["bar_months_names"] = json_encode($bar_months_names);
$data["prev_year_period"] = $prev_year_period;
$data["bar_curr_period_data"] = json_encode($bar_curr_period_data);
$data["bar_prev_period_data"] = json_encode($bar_prev_period_data);
$data["bar_grey_period_data"] = json_encode($bar_grey_period_data);
//========== graf pie data START =================
$pie_categories_names = array();
$pie_data = array();
foreach ($selected_categories as $cat_id) {
	array_push($pie_categories_names, $select_option_categories[$cat_id]['name']);
	array_push($pie_data, round($categories_occ[$cat_id] /12 * 100, 2));
}
$data["pie_categories_names"] = json_encode($pie_categories_names);
$data["pie_data"] = json_encode($pie_data);
//========== graf pie data FINAL =================
$data["left_menu"] = $this->htmltpl->get_left_menu (4, 1);
$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse ( 'templates/reports_c2/occupancy_view.html', $data );

?>