<?php
class Eb_ep_mdl extends CI_Model {
	const  reference_tbl = "`global_hotelix`.`dc_tvg_hotels`";
	const  log_pushes_tbl = "`dc_booking`.`tvg_http_push`";
	public $gate_curls;
	public function __construct(){
		parent::__construct();
		$this->gate_curls = new GateCurls();
	}

	public function log_http_push () {
        $this->db->insert($this::log_pushes_tbl, [
            'get' => $_SERVER['QUERY_STRING'],
            'post' => json_encode($_POST),
            'rawpost' => file_get_contents("php://input"),
            'server' => json_encode($_SERVER)
        ]);
	}

	public function curl_get_requested_data($requested_data, $url) {
        $headers = array('Content-Type: application/json');
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $requested_data);
        $result = curl_exec($ch);
        curl_close($ch);
        if (Eb_ep::$die_in_curl){
            echo "<pre>";
            print_r($requested_data);
            print_r(json_decode($requested_data));
            echo "result:";
            print_r($result);
            print_r(json_decode($result));
            die("DIED by A Department at eb_ep_mdl.php curl_get_requested_data() coz Eb_ep::die_in_curl == TRUE");
        }
        return $result;
	}

	public function get_hotels_hms_data($reference_code = "") {//$reference_code looks like hms_id_prop_id, reference from tvg
	    $tbl = $this::reference_tbl;
	    $response_filds = array('host', 'partner_reference', 'name', 'street', 'city', 'postal_code', 'state', 'country', 'latitude', 'longitude', 'phone', 'email', 'url');
	    $where_arr = array('validated' => 1);
	    if (!empty($reference_code)){
	        $parsed_ids_arr = explode('_', $reference_code);
	        $where_arr['hms_id'] = $parsed_ids_arr[0];
	        $where_arr['prop_id'] = $parsed_ids_arr[1];
	    }
	    $hotels_list = $this->db->select($response_filds)->get_where($tbl, $where_arr)->result();
	    return (!empty($reference_code)) ? isset($hotels_list[0]) ? $hotels_list[0] : [] : $hotels_list;
	}

	public function get_booking_availability_data($requested_data = stdClass) {
	    $hotel = $this->get_hotels_hms_data($requested_data->hotel->partner_reference);
	    if (empty($hotel)){return false;}
	    $url = $this->gate_curls->booking_availability;
	    $url = "https://$hotel->host/$url";
        return json_decode($this->curl_get_requested_data(json_encode($requested_data), $url));
	}

	public function get_booking_submit_data($requested_data = stdClass) {
	    $hotel = $this->get_hotels_hms_data($requested_data->partner_reference);
	    if (empty($hotel)){return false;}
	    $requested_data->hotel_host = $hotel->host;
	    $url = $this->gate_curls->booking_submit;
	    $url = "https://$hotel->host/$url";
	    return json_decode($this->curl_get_requested_data(json_encode($requested_data), $url));
	}

	public function get_booking_cancelation_data($requested_data = stdClass) {
	    $hotel = $this->get_hotels_hms_data($requested_data->partner_reference);
	    if (empty($hotel)){return false;}
	    $url = $this->gate_curls->booking_cancel;
	    $url = "https://$hotel->host/$url";
	    return json_decode($this->curl_get_requested_data(json_encode($requested_data), $url));
	}

	function get_ta_hotels_inventory($hotel_code = "") {
	    $tbl = $this::reference_tbl;
	    $where_arr = array('active' => 1);
	    if (!empty($hotel_code)){
	        $parsed_ids_arr = explode('_', $hotel_code);
	        $where_arr['hms_id'] = $parsed_ids_arr[0];
	        $where_arr['prop_id'] = $parsed_ids_arr[1];
	    }
	    $hotels_list = $this->db->get_where($tbl, $where_arr)->result_array();
	    return (!empty($hotel_code)) ? $hotels_list[0] : $hotels_list;
	}


	function get_hotel_inventory_data($requested_hotel) {
		$curl_url = $requested_hotel['host']. $this->curl_urls->hotel_inventory;
		$curl_url = "https://" . $curl_url;
		$hotel_inventory_data = json_decode($this->curl_get_requested_data(json_encode($requested_hotel), $curl_url));
		return $hotel_inventory_data;
	}
	function get_booking_availability_data11($availability_requested_data = []) {
		$curl_url = $this->curl_urls->availability_data;
		$curl_url = $availability_requested_data['host'].$curl_url;
		$curl_url = "https://" . $curl_url;
		$hms_availability_data = json_decode($this->curl_get_requested_data(json_encode($availability_requested_data), $curl_url));
		return $hms_availability_data;//json_decode(json_encode($result_arr), FALSE);//(object)$result_arr;
	}
}