<?php
class setup_taxesfees_c2 extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->load->model('taxesfees_model');
        $this->Authorization->IsLogined();
    }
    
    function tax_fee_policies ($property_id = 0) {
        // витягуєм з бази даних структуру масиву для розпаршення на сторінці зі всіма даними
        $taxes_fees_array = $this->taxesfees_model->get_property_tf_data($property_id);
        
        $data = array (
            "property_id" => $property_id,
            "taxes_fees_array" => $taxes_fees_array
        );
        $this->load->library ( 'parser' );
        $this->load->view ( '/taxes_fees_c2/setup_taxesfees_c2_tax_fee_policies_view.php', $data );
    }
    
    function tax_fee_policies_v2 ($property_id = 0) {
        // витягуєм з бази даних структуру масиву для розпаршення на сторінці зі всіма даними
        //$taxes_fees_array = $this->taxesfees_model->get_property_tf_data_new($property_id);
    
        $data = array (
            "property_id" => $property_id,
            //"taxes_fees_array" => $taxes_fees_array
        );
        $this->load->library ( 'parser' );
        $this->load->view ( '/taxes_fees_c2/setup_taxesfees_c2_tax_fee_policies_view_v2.php', $data );
    }
    
    function save_tax_fee_policies () {
	    $postdata = $_POST;
// 	    echo "<pre>";
//         print_r($postdata);
//         die();
	    $property_id =  $postdata["property_id"];
	    // видалення всіх позицій з бази даний таблиця taxes_fees2property для конкретного property
	    $this->taxesfees_model->delete_property_tf_data($property_id);
	    // збереження даних
	    $this->taxesfees_model->save_property_tf_data($postdata);
	    
	    die ( "<meta http-equiv='refresh' content='0;url=/setup_taxesfees_c2/tax_fee_policies/$property_id'>" );
    }
    
    // видалення всіх позицій з бази даний таблиця taxes_fees2property для конкретного property
    function delete_property_tf_data($property_id){
        $this->taxesfees_model->delete_property_tf_data($property_id);
        die ( "<meta http-equiv='refresh' content='0;url=/setup_taxesfees_c2/tax_fee_policies/$property_id'>" );
    }
    
    function insert_tax_fee($id = -1){
        $data = array (
            "id" => $id
        );
        $this->load->library ( 'parser' );
        $this->load->view ( '/taxes_fees_c2/setup_taxesfees_c2_edit_tax_fee_view.php', $data );
    }
    
    function edit_tax_fee($id){
        $data = array (
            "id" => $id
        );
        $this->load->library ( 'parser' );
        $this->load->view ( '/taxes_fees_c2/setup_taxesfees_c2_edit_tax_fee_view.php', $data );
    }
    
    function save_tax_fee_policies_new () {
        $postdata = $_POST;
//         echo "<pre>";
//         print_r($postdata);
//         die();
        
        $tf_id = $postdata["taxe_fee_id"];
        
        $main_data = array();
	    $main_data["property_id"] = 0;
	
	    $main_data["type_id"] = $postdata["type"];
	    $main_data["name"] = $postdata["name"];
	    $main_data["ta_subtype_id"] = $postdata["ta_code"];
	    $main_data["quantity_type"] = $postdata["quantity_type"];
	    $main_data["calculate_guests_logic"] = $postdata["calculate_guests_logic"];
	
	    //$db_data["taxes_fees_id"] = $taxes_fees_id;
	
	    if (isset($postdata["object_type"])) {
	        $main_data["object_type"] = $postdata["object_type"];
	    } else {
	        $main_data["object_type"] = 1;
	    }
	
	    if (isset($postdata["period_type"])) {
	        $main_data["period_type"] = $postdata["period_type"];
	    } else {
	        $main_data["period_type"] = 1;
	    }
	
	    if (isset($postdata["calc_type"])) {
	        $main_data["calc_type"] = $postdata["calc_type"];
	    } else {
	        $main_data["calc_type"] = 1;
	    }
	
	    $main_data["calc_value"] = 0;
	
	    if($postdata["type"] == 2){
	        $main_data["vat_value"] = $postdata["vat_value"];
	    }else{
	        $main_data["vat_value"] = 0;
	    }
	    
	    if (isset($postdata["automatic_accruals"])) {
	        $main_data["automatic_accruals"] = $postdata["automatic_accruals"];
	    } else {
	        $main_data["automatic_accruals"] = 0;
	    }
	    
	    $main_data["range_id"] = $postdata["range_id"];
// 	    print_r($main_data);
// 	    die();
	    
        if($tf_id > 0){
            //$this->taxesfees_model->delete_property_tf_data_by_tfid($tf_id);
            $this->taxesfees_model->delete_items_by_tfid($tf_id);
            $this->taxesfees_model->delete_property_links_by_tfid($tf_id);
            
            $this->taxesfees_model->update_property_tf_data($main_data, $tf_id);
        }else{  
            $tf_id = $this->taxesfees_model->insert_property_tf_data($main_data);
        }
        
        // вставляємо зв'язки по об'эктам
        foreach($postdata["properties"] as $property_id){
            $link_data = array();
            $link_data["taxes_fees_id"] = $tf_id;
            $link_data["property_id"] = $property_id;
            $this->taxesfees_model->insert_property_tf_links($link_data);
        }
        
        
        
        // збереження даних
        //$postdata["property_id"] = 0; 
        //$this->taxesfees_model->save_property_tf_data_new($postdata, $tf_id);
        
        // set ages array
        $data_items = array();
        switch ($postdata["quantity_type"]) {
            case 1:
                
                $data_items[0]["period_id"] = 0;
                $data_items[0]["taxes_fees_id"] = $tf_id;
                $data_items[0]["value"] = $postdata["calc_value"];
                break;
            case 2:
                foreach ($postdata["range_value"] as $period_id => $value) {
                    array_push($data_items, array(
                        "period_id" => $period_id,
                        "taxes_fees_id" => $tf_id,
                        "value" => $value
                    ));
                }
                break;
            case 3:
                foreach ($postdata["range_value"] as $period_id => $value) {
                    array_push($data_items, array(
                        "period_id" => $period_id,
                        "taxes_fees_id" => $tf_id,
                        "value" => $value
                    ));
                }
                break;
        }
        
        // insert ages if exists 
        $this->taxesfees_model->insert_tf_items($data_items);
        
        die ( "<meta http-equiv='refresh' content='0;url=/setup_taxesfees_c2/tax_fee_policies_v2'>" );
    }
    
    function ajax_get_ta_codes_list(){
        $tf_type = $_POST["type_val"];
        //echo $tf_type;
        $tf_items = $this->taxesfees_model->get_ta_tax_fee_subtypes($tf_type);
        
        $output = array();
        $output["tf_items"] = $tf_items;
        $output["tf_items"][0]["id"] = 0;
        $output["tf_items"][0]["name"] = "---";
        $output["tf_items"][0]["selected"] = "";
        
        $output = json_encode($output);
        
        echo $output;
    }
    
    function delete_tf_data($tf_id){
        $this->taxesfees_model->delete_property_tf_data_by_tfid($tf_id);
        $this->taxesfees_model->delete_items_by_tfid($tf_id);
        $this->taxesfees_model->delete_property_links_by_tfid($tf_id);
        $this->taxesfees_model->delete_tf_main_data($tf_id);
        
        die ( "<meta http-equiv='refresh' content='0;url=/setup_taxesfees_c2/tax_fee_policies_v2'>" );
    }
    
    function delete_selected_tf()
    {
        if (isset($_POST['selected_tf'])) {
            foreach (array_keys($_POST['selected_tf']) as $tf_id) {
                $this->taxesfees_model->delete_property_tf_data_by_tfid($tf_id);
                $this->taxesfees_model->delete_items_by_tfid($tf_id);
                $this->taxesfees_model->delete_property_links_by_tfid($tf_id);
                $this->taxesfees_model->delete_tf_main_data($tf_id);
            }
        }
        die("<meta http-equiv='refresh' content='0;url=/setup_taxesfees_c2/tax_fee_policies_v2'>");
    }
    
    function ajax_show_ta_code_info(){
        $data = array();
        $this->load->library('parser');
        echo $this->load->view('/taxes_fees_c2/setup_taxesfees_c2_ajax_show_ta_code_info_view.php', $data, true);
    }
    
    function ajax_get_age_ranges_block(){
        $quantity_type = $_POST["quantity_type"];
        $tf_id = $_POST["tf_id"];
        $range_id = @$_POST["range_id"];
        $calc_type = @$_POST["calc_type"];
//         echo "<pre>";
//         print_r($_POST);
        $tf_items = $this->taxesfees_model->get_tf_items($tf_id, $quantity_type, $range_id, $calc_type);
        $data = array();
        $data["tf_items"] = $tf_items;
        $this->mlanguages->getdictionary("tbl_fee_tax_policies_new", "", $data );
        echo $this->parser->parse('templates/taxes_fees_c2/setup_taxesfees_c2_edit_tax_fee_items_block_view.html', $data, TRUE);
    }
    
    function ajax_get_ranges_list(){
        $ranges_array = $this->taxesfees_model->get_quantity_types();
        $output = array();
//         echo "<pre>";
//         print_r($ranges_array);
//         die();
        $output ["ranges"] = $ranges_array;
        echo json_encode($output);
    }
}
?>