<?php 
class Availability extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model ( 'Curl_model' );
    }
    	
	function index () {
		header ( 'Content-Type: application/json' );
    	$hms_id = "92";
    	$dc_category = array();
    	
    	$query = $this->db->query("SELECT category_id, dc_room_id, dc_room_name FROM dc_tripadvisor_rooms_link");
    	
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$dc_category[$row->category_id]["dc_room_id"] = $row->dc_room_id;
    			$dc_category[$row->category_id]["dc_room_name"] = $row->dc_room_name;
    			$dc_category[$row->category_id]["tripadvisor_catid"] = $hms_id."-".$row->dc_room_id;
    		}
    	}
    	$array = array();
    	$array["api_version"] = 8;
    	$array["lang"] = "en_US";
    	$array["hotels"][0]["ta_id"] = 258705;
    	$array["hotels"][0]["partner_id"] = "hc";
    	$array["hotels"][0]["name"] = "Hotel Commonwealth";
    	$array["hotels"][0]["street"] = "500 Commonwealth Avenue";
    	$array["hotels"][0]["city"] = "Boston";
    	$array["hotels"][0]["postal_code"] = "02215";
    	$array["hotels"][0]["state"] = "Massachusetts";
    	$array["hotels"][0]["country"] = "USA";
    	$array["hotels"][0]["latitude"] = 42.348808;
    	$array["hotels"][0]["longitude"] = -71.094971;
    	$array["hotels"][0]["desc"] = "The Hotel Commonwealth stands above the Kenmore Square \"T\" subway station in Boston, Mass. Fenway Park is located two blocks away, while the shops along Newbury Street are three blocks from the hotel.";
    	$array["hotels"][0]["amenities"][0] = "RESTAURANT";
    	$array["hotels"][0]["amenities"][1] = "NON_SMOKING";
    	$array["hotels"][0]["url"] = "http://www.partner-site.com/hotelcommonwealth";
    	$array["hotels"][0]["email"] = "concierge@example.com";
    	$array["hotels"][0]["phone"] = "555-555-5555";
    	$array["hotels"][0]["fax"] = "555-555-5555";
    	$array["hotels"][0]["room_types"] = array();
    	foreach($dc_category as $category_id => $cell){
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["url"] = "http://www.partner-site.com/hotel_commonwealth/".$cell["dc_room_id"];
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["desc"] = "One king bed with pillowtop mattress, Frette Italian linens, down bedding, multiple pillows. View of Fenway Park.";
    	}
    	echo json_encode($array, true);
	}
}