<?php 
class dc_ibapi extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->model ( 'Curl_model' );
    }
    
    function index() {
        //echo "Hello world!";
        //$startdate = ""
        
        $date_in_unix = (int) (time() / 60/60/24);
        $date_out_unix = (int) (time() / 60/60/24) + 5;
        echo $date_in_unix ;
        echo "-";
        echo $date_out_unix ;
        
        
        
        $sql = "SELECT deskofdaysseason.intdate, rate.caption, categories.id,
        
        IF (ratetocategory.baseplace > 0, ratetocategory.baseplace, categories.places) as pl,
        IF (ratetocategory.maxplace > 0, ratetocategory.maxplace, categories.add_places) as maxpl,
        
        seasonspricelist.rate_id,
        
        IF (yieldprice.price > 0, yieldprice.price, seasonspricelist.price) as fpr,
        IF (yieldprice.perperson_price > 0, yieldprice.perperson_price, seasonspricelist.perperson_price) as fpr2,
        IF (yieldprice.extrabed_price > 0, yieldprice.extrabed_price, seasonspricelist.extrabed_price) as fprb
        FROM deskofdaysseason
        INNER JOIN seasonspricelist ON seasonspricelist.season_id = deskofdaysseason.seasonid
        INNER JOIN categories ON  categories.id = seasonspricelist.category_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        
        INNER JOIN ratetocategory on 
        seasonspricelist.category_id = ratetocategory.category_id
        AND seasonspricelist.rate_id = ratetocategory.rate_id
        
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        LEFT JOIN yieldprice 
        on seasonspricelist.rate_id = yieldprice.id_restrict_rate
        AND  seasonspricelist.category_id = yieldprice.category_id
        AND  deskofdaysseason.intdate = yieldprice.intdate
        
                
        WHERE categories.web_booking =1 AND deskofdaysseason.intdate >= $date_in_unix AND deskofdaysseason.intdate <= $date_out_unix-1 AND 1
        ORDER by categories.id, seasonspricelist.rate_id";
        //rate.id = $price_name_id AND seasonspricelist.category_id = $typeid";
        echo "<br>";
        echo $sql;
        echo "<br>";
        
        $sql = "SELECT rate.caption, categories.id,
        seasonspricelist.rate_id,
        IF (ratetocategory.baseplace > 0, ratetocategory.baseplace, categories.places) as pl,
        IF (ratetocategory.maxplace > 0, ratetocategory.maxplace, categories.add_places) as maxpl,
        
                
        SUM(IF (yieldprice.price > 0, yieldprice.price, seasonspricelist.price)) as fpr,
        SUM(IF (yieldprice.perperson_price > 0, yieldprice.perperson_price, seasonspricelist.perperson_price)) as fpr2,
        SUM(IF (yieldprice.extrabed_price > 0, yieldprice.extrabed_price, seasonspricelist.extrabed_price)) as fprb,
        
        count(deskofdaysseason.intdate) as days
        
        FROM deskofdaysseason
        INNER JOIN seasonspricelist ON seasonspricelist.season_id = deskofdaysseason.seasonid
        INNER JOIN categories ON  categories.id = seasonspricelist.category_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        
        INNER JOIN ratetocategory on 
        seasonspricelist.category_id = ratetocategory.category_id
        AND seasonspricelist.rate_id = ratetocategory.rate_id
        
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        LEFT JOIN yieldprice
        on seasonspricelist.rate_id = yieldprice.id_restrict_rate
        AND  seasonspricelist.category_id = yieldprice.category_id
        AND  deskofdaysseason.intdate = yieldprice.intdate
        
        WHERE categories.web_booking =1 AND deskofdaysseason.intdate >= $date_in_unix AND deskofdaysseason.intdate <= $date_out_unix-1 AND 1
        GROUP by categories.id, seasonspricelist.rate_id
        ORDER by categories.id, seasonspricelist.rate_id";
        //rate.id = $price_name_id AND seasonspricelist.category_id = $typeid";
        echo "<br>";
        echo $sql;
        echo "<br>";
    }
    
    function config() {
        $data = array();
        $data['api_version'] = 7;
        $data['configuration'] = array();
        $data['configuration']['emergency_contacts'] = array();
        $data['configuration']['emergency_contacts'][0]['full_name'] = "Volodimir";
        $data['configuration']['emergency_contacts'][0]['email'] = "volodimir@otelms.com";
        $data['configuration']['emergency_contacts'][0]['phone_number'] = "911";
        $data['configuration']['emergency_contacts'][1]['full_name'] = "Volodimir";
        $data['configuration']['emergency_contacts'][1]['email'] = "volodimir@otelms.com";
        $data['configuration']['emergency_contacts'][1]['phone_number'] = "911";
        $data['configuration']['info_contacts'] = array();
        $data['configuration']['info_contacts'][0]['full_name'] = "Volodimir";
        $data['configuration']['info_contacts'][0]['email'] = "volodimir@otelms.com";
        $data['configuration']['info_contacts'][0]['phone_number'] = "16469348422x911";
        $data['configuration']['languages'] = array();
        $data['configuration']['languages'][0] = "en";
        $data['configuration']['pref_hotels'] = 50;
        $data['configuration']['five_min_rate_limit'] = 1000;
        $data['debug_info'] = "Debug message";
        
        header ( 'Content-Type: application/json' );       
        $json = json_encode($data);
        echo $json;
    }
    
    function hotel_inventory_OLD() {
        header ( 'Content-Type: application/json' );
        echo <<<EOT
        {
    "api_version" : 7,
    "lang" : "en_US",
    "hotels" :
        [
            {
                "ta_id" : 258705 ,
                "partner_id" : "hc",
                "name" : "Hotel Commonwealth",
                "street" : "500 Commonwealth Avenue",
                "city" : "Boston",
                "postal_code" : "02215",
                "state" : "Massachusetts",
                "country" : "USA",
                "latitude" : 42.348808,
                "longitude" : -71.094971,
                "desc" : "The Hotel Commonwealth stands above the Kenmore Square \"T\" subway station in Boston, Mass. Fenway Park is located two blocks away, while the shops along Newbury Street are three blocks from the hotel.",
                "amenities" : ["RESTAURANT","NON_SMOKING"],
                "url" : "http://www.partner-site.com/hotelcommonwealth",
                "email" : "concierge@example.com",
                "phone" : "555-555-5555",
                "fax" : "555-555-5555",
                "room_types"  :
                    {
                        "Fenway Room" :
                            {
                                "url" : "http://www.partner-site.com/hotel_commonwealth/fenway_room",
                                "desc" : "One king bed with pillowtop mattress, Frette Italian linens, down bedding, multiple pillows. View of Fenway Park."
                            },
                        "Commonwealth Room" :
                            {
                                "url" : "http://www.partner-site.com/hotel_commonwealth/commonwealth_room",
                                "desc" : "One king bed with pillowtop mattress, Frette Italian linens, down bedding, multiple pillows. View of Commonwealth Avenue."
                            }
                    }
            }
        ]
}
EOT;
        
        
        //$this->config();
    }
    
    function hotel_inventory() {
    	header ( 'Content-Type: application/json' );
    	$hms_id = "92";
    	$dc_category = array();
    	
    	$query = $this->db->query("SELECT category_id, dc_room_id, dc_room_name FROM dc_tripadvisor_rooms_link");
    	
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$dc_category[$row->category_id]["dc_room_id"] = $row->dc_room_id;
    			$dc_category[$row->category_id]["dc_room_name"] = $row->dc_room_name;
    			$dc_category[$row->category_id]["tripadvisor_catid"] = $hms_id."-".$row->dc_room_id;
    		}
    	}
    	$array = array();
    	$array["api_version"] = 8;
    	$array["lang"] = "en_US";
    	$array["hotels"][0]["ta_id"] = 258705;
    	$array["hotels"][0]["partner_id"] = "hc";
    	$array["hotels"][0]["name"] = "Hotel Commonwealth";
    	$array["hotels"][0]["street"] = "500 Commonwealth Avenue";
    	$array["hotels"][0]["city"] = "Boston";
    	$array["hotels"][0]["postal_code"] = "02215";
    	$array["hotels"][0]["state"] = "Massachusetts";
    	$array["hotels"][0]["country"] = "USA";
    	$array["hotels"][0]["latitude"] = 42.348808;
    	$array["hotels"][0]["longitude"] = -71.094971;
    	$array["hotels"][0]["desc"] = "The Hotel Commonwealth stands above the Kenmore Square \"T\" subway station in Boston, Mass. Fenway Park is located two blocks away, while the shops along Newbury Street are three blocks from the hotel.";
    	$array["hotels"][0]["amenities"][0] = "RESTAURANT";
    	$array["hotels"][0]["amenities"][1] = "NON_SMOKING";
    	$array["hotels"][0]["url"] = "http://www.partner-site.com/hotelcommonwealth";
    	$array["hotels"][0]["email"] = "concierge@example.com";
    	$array["hotels"][0]["phone"] = "555-555-5555";
    	$array["hotels"][0]["fax"] = "555-555-5555";
    	$array["hotels"][0]["room_types"] = array();
    	foreach($dc_category as $category_id => $cell){
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["url"] = "http://www.partner-site.com/hotel_commonwealth/".$cell["dc_room_id"];
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["desc"] = "One king bed with pillowtop mattress, Frette Italian linens, down bedding, multiple pillows. View of Fenway Park.";
    	}
    	echo json_encode($array, true);
    }
	function hotel_availability() {
		header ( 'Content-Type: application/json' );
		$from = "2016-11-04";
		$to = "2016-11-05";
		$hms_id = "92";
		
		$config = array ();
		$config ['hostname'] = $this->config->item ( 'visitka_host' );
		$config ['username'] = $this->config->item ( 'visitka_user' );
		$config ['password'] = $this->config->item ( 'visitka_pass' );
		$config ['database'] = "visitka";
		$config ['dbdriver'] = "mysqli";
		$config ['dbprefix'] = "";
		$config ['pconnect'] = FALSE;
		$config ['db_debug'] = TRUE;
		$config ['cache_on'] = FALSE;
		$config ['cachedir'] = "";
		$config ['char_set'] = "utf8";
		$config ['dbcollat'] = "utf8_general_ci";
		
		$this->db = $this->load->database ( $config, true );
		
		$sql = "SELECT host FROM visitka.config WHERE id = " . 92;
		$query = $this->db->query ( $sql );
		
		// echo $sql;
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			
			$array_post = array ();
			$array_post ["api_version"] = 7;
			$array_post ["hotels"] [0] ["ta_id"] = $hms_id;
			$array_post ["hotels"] [0] ["partner_id"] = "hc";
			$array_post ["hotels"] [0] ["partner_url"] = "http://partner.com/deeplink/to/229547";
			$array_post ["start_date"] = "2016-11-06";
			$array_post ["end_date"] = "2016-11-07";
			$array_post ["party"] [0] ["adults"] = 2;
			// $array_post["party"]["children"] = array();
			$array_post ["lang"] = "en_US";
			$array_post ["currency"] = "USD";
			$array_post ["user_country"] = "US";
			$array_post ["device_type"] = "d";
			$array_post ["query_key"] = "TripAdvisorAPITest_53d5934c-656d-4bd1-9bf6-4bfc3eb13c7b";
			if (isset ( $_POST )) {
				$array_json = json_encode ( $_POST );
			} else {
				$array_json = json_encode ( $array_post );
			}
			$url = "https://" . $row->host . "/dc_echannel_gate/get_rna_tripadvisor/";
			// echo $url;
			// die();
			$data_result = $this->Curl_model->CurlPlugRaw_echannel ( $array_json, $url );
			echo $data_result;
			// $array = json_decode ( $data_result, true );
			
			// echo "<pre>";
			// print_r ( $array );
		}
	}
	function booking_availability() {
		header ( 'Content-Type: application/json' );
		$from = "2016-11-04";
		$to = "2016-11-05";
		$hms_id = "92";
	
		$config = array ();
		$config ['hostname'] = $this->config->item ( 'visitka_host' );
		$config ['username'] = $this->config->item ( 'visitka_user' );
		$config ['password'] = $this->config->item ( 'visitka_pass' );
		$config ['database'] = "visitka";
		$config ['dbdriver'] = "mysqli";
		$config ['dbprefix'] = "";
		$config ['pconnect'] = FALSE;
		$config ['db_debug'] = TRUE;
		$config ['cache_on'] = FALSE;
		$config ['cachedir'] = "";
		$config ['char_set'] = "utf8";
		$config ['dbcollat'] = "utf8_general_ci";
	
		$this->db = $this->load->database ( $config, true );
	
		$sql = "SELECT host FROM visitka.config WHERE id = " . 92;
		$query = $this->db->query ( $sql );
	
		// echo $sql;
		if ($query->num_rows () > 0) {
			$row = $query->row ();
				
			$array_post = array ();
			$array_post ["api_version"] = 7;
			$array_post ["hotel"]["ta_id"] = $hms_id;
			$array_post ["hotel"]["partner_id"] = "hc";
			$array_post ["hotel"]["partner_url"] = "http://partner.com/deeplink/to/229547";
			$array_post ["start_date"] = "2016-11-06";
			$array_post ["end_date"] = "2016-11-07";
			$array_post ["party"] [0] ["adults"] = 2;
			// $array_post["party"]["children"] = array();
			$array_post ["lang"] = "en_US";
			$array_post ["currency"] = "USD";
			$array_post ["user_country"] = "US";
			$array_post ["device_type"] = "d";
			$array_post ["query_key"] = "TripAdvisorAPITest_53d5934c-656d-4bd1-9bf6-4bfc3eb13c7b";
			$array_post ["booking_session_id"] = "c575ec5ae3c84294bf67c1b05590b3c2";
			$array_post ["booking_request_id"] = "CSI-xkundqpe4nfrtem2ypq2ygjfde";
			if (isset ( $_POST )) {
				$array_json = json_encode ( $_POST );
			} else {
				$array_json = json_encode ( $array_post );
			}
			$url = "https://" . $row->host . "/dc_echannel_gate/get_booking_availability/";
			// echo $url;
			// die();
			$data_result = $this->Curl_model->CurlPlugRaw_echannel ( $array_json, $url );
			echo $data_result;
			// $array = json_decode ( $data_result, true );
				
			// echo "<pre>";
			// print_r ( $array );
		}
	}
	
	function availability () {
		header ( 'Content-Type: application/json' );
    	$hms_id = "92";
    	$dc_category = array();
    	
    	$query = $this->db->query("SELECT category_id, dc_room_id, dc_room_name FROM dc_tripadvisor_rooms_link");
    	
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$dc_category[$row->category_id]["dc_room_id"] = $row->dc_room_id;
    			$dc_category[$row->category_id]["dc_room_name"] = $row->dc_room_name;
    			$dc_category[$row->category_id]["tripadvisor_catid"] = $hms_id."-".$row->dc_room_id;
    		}
    	}
    	$array = array();
    	$array["api_version"] = 8;
    	$array["lang"] = "en_US";
    	$array["hotels"][0]["ta_id"] = 258705;
    	$array["hotels"][0]["partner_id"] = "hc";
    	$array["hotels"][0]["name"] = "Hotel Commonwealth";
    	$array["hotels"][0]["street"] = "500 Commonwealth Avenue";
    	$array["hotels"][0]["city"] = "Boston";
    	$array["hotels"][0]["postal_code"] = "02215";
    	$array["hotels"][0]["state"] = "Massachusetts";
    	$array["hotels"][0]["country"] = "USA";
    	$array["hotels"][0]["latitude"] = 42.348808;
    	$array["hotels"][0]["longitude"] = -71.094971;
    	$array["hotels"][0]["desc"] = "The Hotel Commonwealth stands above the Kenmore Square \"T\" subway station in Boston, Mass. Fenway Park is located two blocks away, while the shops along Newbury Street are three blocks from the hotel.";
    	$array["hotels"][0]["amenities"][0] = "RESTAURANT";
    	$array["hotels"][0]["amenities"][1] = "NON_SMOKING";
    	$array["hotels"][0]["url"] = "http://www.partner-site.com/hotelcommonwealth";
    	$array["hotels"][0]["email"] = "concierge@example.com";
    	$array["hotels"][0]["phone"] = "555-555-5555";
    	$array["hotels"][0]["fax"] = "555-555-5555";
    	$array["hotels"][0]["room_types"] = array();
    	foreach($dc_category as $category_id => $cell){
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["url"] = "http://www.partner-site.com/hotel_commonwealth/".$cell["dc_room_id"];
    		$array["hotels"][0]["room_types"][$cell["tripadvisor_catid"]]["desc"] = "One king bed with pillowtop mattress, Frette Italian linens, down bedding, multiple pillows. View of Fenway Park.";
    	}
    	echo json_encode($array, true);
	}
	
	function booking_submit() {
		echo "<pre>";
		print_r($_GET);
		print_r($_POST);
		die("DIED by A Department on dc_ibapi.php booking_submit() at 11.09.2019 18:36:01");
		$array = array();
    	$array["api_version"] = 8;
    	$array["lang"] = "en_US";
    	echo json_encode($array, true);
	}
	
	function booking_verify() {
		$test_str = '{
  "api_version": 8,
  "problems": [],
  "reference_id": "766588a634734cc8b60dd6a66b2561c4",
  "status": "Success",
  "reservation": {
    "reservation_id": "AB0005",
    "status": "Booked",
    "confirmation_url": "http://www.tripadvisor.com",
    "start_date": "2016-10-28",
    "end_date": "2016-10-29",
    "partner_hotel_code": "sfssc1",
    "hotel": {
      "name": "Hotel Commonwealth",
      "address1": "500 Commonwealth Avenue",
      "address2": "",
      "city": "Boston",
      "state": "Massachusetts",
      "postal_code": "02492",
      "phone": "8001234567",
      "checkin_checkout_policy": "For early check in, please contact hotel.",
      "checkin_time": "12:00",
      "checkout_time": "14:00",
      "hotel_smoking_policy": {
        "standard": [
          47
        ],
        "custom": [
          "Strict non smoking policy"
        ]
      },
      "pet_policy": {
        "standard": [
          6
        ],
        "custom": [
          "My own pet policy if applicable"
        ]
      },
      "child_policy": "All children are welcome",
      "parking_shuttle": {
        "standard": [
          185
        ],
        "custom": [
          "You can park on curbside in a metered spot"
        ]
      },
      "hotel_extra_bed": "Rollaway beds and cribs available on request",
      "hotel_amenities": {
        "standard": [
          5,
          15
        ],
        "custom": [
          "Bean bag chairs"
        ]
      },
      "photos": [
        {
          "url": "https://www.example.com/hotel_lobby.png",
          "width": 480,
          "height": 270,
          "caption": "Hotel Lobby"
        },
        {
          "url": "https://www.example.com/hotel_cafe.png",
          "width": 480,
          "height": 270,
          "caption": "Hotel Cafe"
        }
      ]
    },
    "customer": {
      "first_name": "Paul",
      "last_name": "Rever",
      "phone_number": 5555555555,
      "email": "paul.revere@tripadvisor.com",
      "country": "US"
    },
    "rooms": [
      {
        "party": {
          "adults": 2,
          "children": [
            9,
            5
          ]
        },
        "traveler_first_name": "Paul",
        "traveler_last_name": "Revere"
      }
    ],
    "legal_text": "Hotel Commonwealth is committed to privacy for everyone who accesses our website. This site, Hotel Commonwealth.com, only collects personal data about you as needed to provide you with outstanding service, and to help process your request or provide you with information.",
    "comments": "But only if you are of age.",
    "line_items": [
      {
        "price": {
          "currency_of_charge_price": {
            "amount": 100,
            "currency": "USD"
          }
        },
        "type": "rate",
        "paid_at_checkout": false
      },
      {
        "price": {
          "requested_currency_price": {
            "amount": 50,
            "currency": "USD"
          },
          "currency_of_charge_price": {
            "amount": 40,
            "currency": "GBP"
          }
        },
        "type": "tax",
        "sub_type": "tax_vat",
        "paid_at_checkout": true
      }
    ]
  },
  "customer_support": {
    "phone_numbers": {
      "standard": [],
      "custom": []
    },
    "emails": [],
    "urls": []
  }
}';
		echo $test_str;
	}
}