<?php 
class dc_academ_service_c2 extends CI_Controller {
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'dcm_abstract' );
        $this->load->model ( 'dcm_academservice' );
        $this->load->model ( 'dcm_academservice_v2' );
        $this->load->model ( 'dc_model' );
        $this->load->model ( 'htmltpl' );
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'service_model' );
        $this->load->model ( 'Authorization' );
        $this->load->model ( 'Loger_admin' );
        $this->Authorization->IsLogined ( "admin_access" );
        
        // ==== billing plan access start ==========
        $data_access = array('module_name' => 'channel_manager');
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if($billing_plan_access == 0){
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
        }
        // ==== billing plan access end ==========
    }

    function get_room_categories($die_option = 0) {
        $curl_result = "";
        $sql = "SELECT dc_account_id FROM dc_academ_service_xml_cfg WHERE dc_account_id <> 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {           
            $authparam = $this->dcm_academservice->getauthparam($row->dc_account_id);
            
            $dc_hotel_id = $authparam["hotel_id"];
            $username = $authparam["eqc_user"];
            $password = $authparam["eqc_password"];
            
            $request = array ();
            $request ["jsonrpc"] = "2.0";
            $request ["method"] = "RoomRateList";
            $request ["params"]["systemId"] = 13;
            $request ["params"]["systemName"] = "otelms";
            $request ["params"]["login"] = $username;
            $request ["params"]["password"] = $password;
            $request ["params"]["language"] = "ru";
            $request ["params"]["hotelId"] = intval($dc_hotel_id);
            $request ["id"] = md5( "3170" . microtime(true) * 1000 );
            //sleep(5);
            //echo "<pre>";
            //print_r($request);
             
            $json_request =  json_encode( $request);
             
            if ($die_option == 0) {
                echo $request;
                echo "<pre>";
                print_r ( $json_request );
            
            }
             
            $url = $authparam["url"];
                
                // save log
            if ($this->config->item('loger_v2') == 0) {
                $data_log = array(
                    'request' => $json_request,
                    'url' => $url
                );
                $this->db->insert('dc_academ_service_log', $data_log);
                $log_id = $this->db->insert_id();
            }
             
            $result = $this->Curl_model->CurlPlugRaw_clean ( $json_request, $url );
//             echo $result;
//            die();
            $array = json_decode($result, true);
            //print_r($array);
//             die();
            $curl_result .= print_r(json_decode($result, true), true);

            $result_array = json_decode ( $result, 1 );

            // save log
            $data_log = array(
                'response' => $result,
                'responseint' => ""
            );
            if ($this->config->item('loger_v2') == 0) {
                $this->db->update('dc_academ_service_log', $data_log, array(
                    'id' => $log_id
                ));
            } else {
                $dc_id = 27;
                $data_log["request"] = $json_request;
                $data_log["url"] = $url;
                $data_log["dc_id"] = $dc_id;
                $log_id = $this->loger_dc->SaveLog_v2($data_log);
            }
            
            $responsebody = "";
            if (isset($array["result"]["hotelId"])) {
                if ($array["result"]["hotelId"] == $dc_hotel_id) {
                    $responsebody = "success";
                }else{
                    $responsebody = "error";
                }
            }else{
                $responsebody = "error";
            }
            
            $this->Loger_admin->Save_SyncData ( "", "", $responsebody, 27, 13, $log_id, false, "import", "-" );
             
            if ($die_option == 0) {
                echo $result;
                echo "<pre>";
                print_r ( $result_array );
                die ();
            }

            if (isset($result_array["result"]["rooms"])) {
                //$occupancy_inc = 1;
                $sql = "UPDATE dc_academ_service_room_categories SET active = 0 WHERE 1 AND dc_hotel_id = " . $dc_hotel_id;
                $query = $this->db->query($sql);
                foreach ($result_array["result"]["rooms"] as $room) {
                    
                    
                    // $roomsAndRatePlans = $result_array ["data"] ["roomsAndRatePlans"];
                    // foreach ( $roomsAndRatePlans as $room ) {
                    $sql = "INSERT INTO dc_academ_service_room_categories(dc_hotel_id, name, dc_room_id, active)
						VALUES('" . $dc_hotel_id . "', '" . addslashes($room["roomName"]) . "','" . $room["roomId"] . "',  1)
						ON DUPLICATE KEY UPDATE name = '" . addslashes($room["roomName"]) . "', active = 1";
                    // echo $sql;
                    $query = $this->db->query($sql);
                    
                    $sql = "INSERT INTO  dc_academ_service_room_categories_link(dc_category_id)
					VALUES('" . $room["roomId"] . "')
					ON DUPLICATE KEY UPDATE hms_category_id = hms_category_id";
                    // echo $sql . "<br>";
                    $query = $this->db->query($sql);
                    
                    if (isset($room["occupancies"])) {
                        
                        foreach ($room["occupancies"] as $occupancy) {
                            $occupancy_id = $this->db->select('id')
                                                     ->get_where('dc_academ_service_occupancy', 
                                                         array(
                                                            'name' => $occupancy, 
                                                            'roomcategory' => $room["roomId"])
                                                         )
                                                     ->row()->id;

                            $sql = "INSERT INTO dc_academ_service_occupancy(name, roomcategory)
								VALUES('" . $occupancy . "', '" . $room["roomId"] . "')
								ON DUPLICATE KEY UPDATE name = '" . $occupancy . "', roomcategory = '" . $room["roomId"] . "'";
                            //echo $sql;
                            $query = $this->db->query($sql);
                            
                            if($occupancy_id == null){
                                $occupancy_id = $this->db->insert_id();
                            }
                            
                            if ($occupancy_id > 0) {
                                $sql = "INSERT INTO dc_academ_service_category2occupancy(dc_category_id, hms_occupancy_id)
								VALUES('" . $room["roomId"] . "', '" . $occupancy_id . "')
								ON DUPLICATE KEY UPDATE state = state";
                                // echo $sql;
                                $query = $this->db->query($sql);
                            }
                            //$occupancy_inc ++;
                        }
                    }
                    
                    $occupancy_array = array();
                    $sql = "SELECT id as hms_occupancy_id, roomcategory FROM dc_academ_service_occupancy WHERE roomcategory = ".$room["roomId"];
                    $query = $this->db->query($sql);
                    foreach ($query->result() as $row) {
                        $occupancy_array[$row->hms_occupancy_id] = 1;
                    }
                    
                    if (isset($room["rates"])) {
                        $sql = "UPDATE dc_academ_service_rates SET active = 0 WHERE 1 AND dc_hotel_id = " . $dc_hotel_id;
                        $query = $this->db->query($sql);
                        foreach ($room["rates"] as $rate) {
                            $sql = "INSERT INTO dc_academ_service_rates(dc_hotel_id, dc_rate_id, name, active)
								VALUES('" . $dc_hotel_id . "', '" . $rate["rateId"] . "', '" . $rate["rateName"] . "', 1)
								ON DUPLICATE KEY UPDATE name = '" . $rate["rateName"] . "', active = 1";
                            // echo $sql;
                            $query = $this->db->query($sql);
                            
                            foreach ($occupancy_array as $hms_occupancy_id => $value) {
                                $sql = "INSERT INTO dc_academ_service_rate2category_link(dc_rate_id, dc_category_id, hms_occupancy_id)
																VALUES('" . $rate["rateId"] . "', '" . $room["roomId"] . "', '" . $hms_occupancy_id . "')
																ON DUPLICATE KEY UPDATE hms_price_func_id = hms_price_func_id";
                                $query = $this->db->query($sql);
                            }
                        }
                        
                        
                    }
                }
                               
                // }
            }
        }
        //die();
        if ($die_option == 1) {
            $_SESSION ["dc_msg"] ["text"] = $curl_result;
            die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/catgories_edit'>" );
        }
    }
    
    function catgories_edit() {
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_academ_service_c2/dc_academ_service_c2_catgories_edit_view.php', $data );
    }
    
    function categories_edit_post(){

//         print_r($_POST);
//         die();
        $categories_link = $this->input->post ( 'categories', true );
        $data_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_academ_service_room_categories_link" );
        $data_category2occupancy_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_academ_service_category2occupancy", 1 );
        $c2o = $_POST['c2o'];
        
        $this->dcm_academservice_v2->category2occupancy_save($c2o);
    
        $data_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_academ_service_room_categories_link" );
        $data_category2occupancy_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_academ_service_category2occupancy", 1 );
    
        $this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_academ_service_room_categories_link", "edit" );
        $this->Loger_admin->SaveLog_dc_multicol ( $data_category2occupancy_1, $data_category2occupancy_2, "loger_admin", "dc_academ_service_category2occupancy", "edit", 2 );
        // exit();
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/catgories_edit'>" );
    }
    
    function rates_edit() {
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_academ_service_c2/dc_academ_service_c2_rates_edit_view.php', $data );
    }
    
    function rates_edit_post() {
        $r2c = $_POST['r2c'];
//         echo "<pre>";
//         print_r($r2c);
//         die();
        $data_rate2category_link_1 = $this->Loger_admin->get_dcrate_multivalues ( "dc_academ_service_rate2category_link", 1 );
    
        $this->dcm_academservice_v2->rate2category_save($r2c);
    
        $data_rate2category_link_2 = $this->Loger_admin->get_dcrate_multivalues ( "dc_academ_service_rate2category_link", 1 );
        $this->Loger_admin->SaveLog_dc_multicol ( $data_rate2category_link_1, $data_rate2category_link_2, "loger_admin", "dc_academ_service_rate2category_link", "edit", 1 );
    
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/rates_edit'>" );
    }
    
    function options() {
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_academ_service_c2/dc_academ_service_c2_options_view.php', $data );
    }
    function options_post() {
        $post = $_POST;
        $this->dcm_academservice->options_save ( $post );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/options'>" );
    }
    
    function ra_params_edit() {
    
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_academ_service_c2/dc_academ_service_c2_ra_params_edit_view.php', $data );
    
    }
    function ra_params_edit_post() {
        $ra_params = $this->input->post ( 'ra' );
        $rooms = $this->input->post ( 'rooms' );
        $restrict_rate = $this->input->post ( 'restrict_rate' );
    
        foreach ( $rooms as $dc_room_id => $cell ) {
            $this->db->update ( 'dc_academ_service_room_categories_link', array (
                'min' => $cell ['min'],
                'max' => $cell ['max']
            ), array (
                'dc_category_id' => $dc_room_id
            ) );
        }
    
        $this->dcm_academservice->save_restrict_rate ( $restrict_rate );
    
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/ra_params_edit'>" );
    }
    
    function reservations_form() {
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_academ_service_c2/dc_academ_service_c2_reservations_form_view.php', $data );
    }
    
    function reservations_post() {
        $post = $_POST;
    
        $dc_account_id = 0;
        $sql = "SELECT dc_account_id FROM dc_academ_service_xml_cfg WHERE name LIKE 'hotel_id' AND int_value = ".$post["dc_hotel_id"];
        $query = $this->db->query ( $sql );
        if($query->num_rows() > 0){
            $row = $query->row ();
            $dc_account_id = $row->dc_account_id;
        }
        if ($dc_account_id > 0) {
            $authparam = $this->dcm_academservice->getauthparam($row->dc_account_id);
            
            $dc_hotel_id = $authparam["hotel_id"];
            $username = $authparam["eqc_user"];
            $password = $authparam["eqc_password"];
            
            $request = array ();
            $request ["jsonrpc"] = "2.0";
            $request ["method"] = "ReservationPull";
            $request ["params"]["systemId"] = 13;
            $request ["params"]["systemName"] = "otelms";
            $request ["params"]["login"] = $username;
            $request ["params"]["password"] = $password;
            $request ["params"]["language"] = "ru";
            $request ["id"] = md5( "3170" . microtime(true) * 1000 );
            
            //echo "<pre>";
            //print_r($request);
            $json_request =  json_encode( $request);
            
            $url = $authparam["url"];
            $data_result = $this->Curl_model->CurlPlugRaw_academservice ( $json_request, $url, array("returntype" => "array"));
            
            $result_array = json_decode ( $data_result ["result"], 1 );
            
            //echo $data_result ["result"]."++++";
            //print_r ( $data_result );
            //die();
            $dc_account_data = array();
            $dc_account_data ["username"] = $username;
            $dc_account_data ["password"] = $password;
            $dc_account_data ["dc_hotel_id"] = $post["dc_hotel_id"];
            $hms_result = $this->dcm_academservice->get_bookings ( $result_array, $dc_account_data );
        }else{
            echo "WRONG DC_HOTEL_ID";
        }
    }
    
    function get_bookings_formfile(){
        $str_data = file_get_contents ( $_FILES ['file_data'] ['tmp_name'] );
        
        $encoding = $this->input->post ( 'encoding' );
        switch ($encoding) {
            case "windows1251" :
                $str_data = iconv ( "windows-1251", "utf-8", $str_data );
                break;
            case "utf8" :
                break;
            default :
                //$str_data = iconv ( "windows-1251", "utf-8", $str_data );
                break;
        }
        echo $str_data;
        $result_array = json_decode($str_data, 1);
        $this->dcm_academservice->get_bookings ( $result_array );
    }
    
    function get_bookings_withID() {
//         echo "<pre>";
//         print_r ( $_POST );
        //die();
        $post = $_POST;
         
        $dc_account_id = 0;
        $sql = "SELECT dc_account_id FROM dc_academ_service_xml_cfg WHERE name LIKE 'hotel_id' AND int_value = ".$post["dc_hotel_id"];
        $query = $this->db->query ( $sql );
        if($query->num_rows() > 0){
            $row = $query->row ();
            $dc_account_id = $row->dc_account_id;
        }
        if ($dc_account_id > 0) {
            $authparam = $this->dcm_academservice->getauthparam($dc_account_id);
	        $dc_hotel_id = $authparam ["hotel_id"];
             
            $username = $authparam["eqc_user"];
	        $password = $authparam["eqc_password"];
	        
	        $request = array ();
	        $request ["jsonrpc"] = "2.0";
	        $request ["method"] = "ReservationPull";
	        $request ["params"]["systemId"] = 13;
	        $request ["params"]["systemName"] = "otelms";
	        $request ["params"]["login"] = $username;
	        $request ["params"]["password"] = $password;
	        $request ["params"]["language"] = "ru";
	        $request ["params"]["accomodationNumber"] = intval($post["dc_reservation_id"]);
	        $request ["id"] = md5( "3170" . microtime(true) * 1000 );
	        
	        //echo "<pre>";
	        //print_r($request);
	         
	        $json_request =  json_encode( $request);
	        //echo "<br>".$json_request."<br>";;
	        $url = $authparam["url"];
	        $data_result = $this->Curl_model->CurlPlugRaw_academservice ( $json_request, $url, array("returntype" => "array"));
	        	
	        $result_array = json_decode ( $data_result ["result"], 1 );
	        	
	        //echo $data_result ["result"]."++++";
	        //print_r ( $data_result );
	        //print_r ( $result_array );
	        //die();
            $dc_account_data = array();
            $dc_account_data ["username"] = $username;
            $dc_account_data ["password"] = $password;
            $dc_account_data ["dc_hotel_id"] = $post["dc_hotel_id"];
            $hms_result = $this->dcm_academservice->get_bookings ( $result_array, $dc_account_data );
            
            $this->Loger_admin->Save_SyncData("", "", $hms_result, 27, 10, $data_result["dc_log_id"]);
        }else{
            echo "WRONG DC_HOTEL_ID";
        }
    }
    
    function category_delete($dc_category_id){
        $sql = "DELETE FROM dc_academ_service_room_categories WHERE dc_room_id = ".$dc_category_id;
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_room_categories_link WHERE dc_category_id = ".$dc_category_id;
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_category2occupancy WHERE dc_category_id = ".$dc_category_id;
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_rate2category_link WHERE dc_category_id = ".$dc_category_id;
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/catgories_edit'>" );
    }
    
    function truncate_categories(){
        $sql = "DELETE FROM dc_academ_service_room_categories WHERE 1";
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_room_categories_link WHERE 1";
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_category2occupancy WHERE 1";
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_academ_service_occupancy WHERE 1";
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/catgories_edit'>" );
    }
    
    function rate_delete($dc_rate_id, $dc_category_id){
        $sql = "DELETE FROM  dc_academ_service_rate2category_link WHERE dc_rate_id = " . $dc_rate_id . " AND dc_category_id = " . $dc_category_id;
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/rates_edit'>" );
    }
    
    function rate_full_delete($dc_rate_id) {
        $sql = "DELETE FROM  dc_academ_service_rate2category_link WHERE dc_rate_id = " . $dc_rate_id;
        $query = $this->db->query ( $sql );
    
        $sql = "DELETE FROM  dc_academ_service_rates WHERE dc_rate_id = " . $dc_rate_id;
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/rates_edit'>" );
    }
    
    function truncate_rates(){
        $sql = "DELETE FROM dc_academ_service_rates WHERE 1";
        $query = $this->db->query ( $sql );
    
        $sql = "DELETE FROM dc_academ_service_rate2category_link WHERE 1";
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_academ_service_c2/rates_edit'>" );
    }
}
?>