<?php

class tw_tasks_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->model ( 'loger' );
    }

    function save_task($data)
    {
        $data["subject"] = trim($data["subject"]);
        $data["description"] = trim($data["description"]);
        if ($data["subject"] == "") {
            if ($data["description"] != "") {
                $data["subject"] = substr($data["description"], 0, 150);
            } else {
                $data["subject"] = "...";
            }
        }
        $sql = "INSERT INTO tw_tasks(assigned_user, subject, description, timestamp, sortid) 
        VALUES('" . $data["assigned_user"] . "', '" . addslashes($data["subject"]) . "', '" . addslashes($data["description"]) . "', '" . time() . "', '" . time() . "')";
        $this->db->query($sql);
        $id = mysql_insert_id();
        // $sql = "UPDATE tw_tasks SET sortid = " . $id . " WHERE id = " . $id;
        // $this->db->query ( $sql );
        $data["position"] = preg_replace("([^0-9])", "", $data["position"]);
        if ($data["position"] != "" and $data["position"] != 0) {
            $tasks = $this->get_list();
            if (isset($tasks[$data["position"] - 1]["sortid"])) {
                $sql = "UPDATE tw_tasks SET sortid = '" . $tasks[$data["position"] - 1]["sortid"] . "', timestamp = " . ($tasks[$data["position"] - 1]["timestamp"] + 1) . " WHERE id = " . $id;
                $this->db->query($sql);
            }
        }
        
        $data_log = array();
        $data_log["s_id"] = $id;
        $data_log["description"] = "";
        $data_log["cmd"] = 1;
        $this->loger->SaveLog($data_log);
    }

    function update_task($data, $id)
    {
        $data["subject"] = trim($data["subject"]);
        $data["description"] = trim($data["description"]);
        if ($data["subject"] == "") {
            if ($data["description"] != "") {
                $data["subject"] = substr($data["description"], 0, 150);
            } else {
                $data["subject"] = "...";
            }
        }
        $sql = "UPDATE tw_tasks SET assigned_user = '" . $data["assigned_user"] . "', timestamp = '" . time() . "', subject = '" . addslashes($data["subject"]) . "', description = '" . addslashes($data["description"]) . "' WHERE id = " . $id;
        $this->db->query($sql);
        
        $data["position"] = preg_replace("([^0-9])", "", $data["position"]);
        if ($data["position"] != "" and $data["position"] != 0) {
            $tasks = $this->get_list();
            if (isset($tasks[$data["position"] - 1]["sortid"])) {
                $sql = "UPDATE tw_tasks SET sortid = '" . $tasks[$data["position"] - 1]["sortid"] . "', timestamp = " . ($tasks[$data["position"] - 1]["timestamp"] + 1) . " WHERE id = " . $id;
                $this->db->query($sql);
            }
        }
    }

    function delete_task($id)
    {
        $sql = "DELETE FROM tw_tasks WHERE id = " . $id;
        $this->db->query($sql);
    }
    function get_admin_users_data(){
    	$admin_users_data = array();
    	$query = $this->db->query("SELECT id, login FROM admin_users");
    	
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			array_push($admin_users_data, array(
    			"id" => $row->id,
    			"login" => $row->login,
    			"selected" => ""
    			));
    		}
    	}
    	
    	return $admin_users_data;
    }
    function get_data($id, $return_format = 0, $extraparse = 0)
    {
        $data = array();
        $statuses = $this->get_task_statuses(1);
        
        $query = $this->db->query("SELECT * FROM tw_tasks WHERE id = " . $id);
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            if ($return_format == 0) {
                switch ($row->isapproved) {
                    case 0:
                        $isapproved_name = "No";
                        break;
                    case 1:
                        $isapproved_name = "Yes";
                        break;
                    default:
                        $isapproved_name = "Err";
                        break;
                }
                
                if (isset($statuses[$row->status_id])) {
                    $status_name = $statuses[$row->status_id]["name"];
                } else {
                    $status_name = "Err";
                }
                if ($extraparse == 2) {
                    $format = "((([A-Za-z]{3,9}:(?:\/\/)?)(?:[-;:&=\+\$,\w]+@)?[A-Za-z0-9.-]+|(?:www.|[-;:&=\+\$,\w]+@)[A-Za-z0-9.-]+)((?:\/[\+~%\/.\w-_]*)?\??(?:[-\+=&;%@.\w_]*)#?(?:[\w]*))?)";
                    $description = preg_replace($format, "<a href=\"$1\">$1</a>", $row->description);
                } else {
                    $description = $row->description;
                }
                
                array_push($data, array(
                    "id" => $row->id,
                    "sortid" => $row->sortid,
                    "status_id" => $row->status_id,
                    "assigned_user" => $row->assigned_user,
                    "isapproved" => $row->isapproved,
                    "isapproved_name" => $isapproved_name,
                    "status_name" => $status_name,
                    "subject" => $row->subject,
                    "description" => $description,
                    "timestamp" => $row->timestamp,
                    "timer_work" => $row->timer_work,
                    "timer_pause" => $row->timer_pause,
                    "timer_stay" => $row->timer_stay,
                    "chkpt_work" => $row->chkpt_work,
                    "chekpt_pause" => $row->chekpt_pause,
                    "done_time" => $row->done_time
                ));
            } else {
                $data = $row;
            }
        }
        return $data;
    }

    function get_list()
    {
        $tasks = array();
        $b = 1;
        
        $statuses = $this->get_task_statuses(1);
        $select = " WHERE ";
        
        $status = $this->session->userdata('status');
        
        $isuppruved = $this->session->userdata('isuppruved');
        $not_uppruved = $this->session->userdata('not_uppruved');
        $session_type_search = $this->session->userdata ( 'type_search' );
        $tasks_search = $this->session->userdata ( 'tasks_search' );
        if($isuppruved == 1 && $not_uppruved == 1){
        	
        }else{
        	if($isuppruved == 1){
        		$select .= " isapproved = 1 AND ";
        	}
        	if($not_uppruved == 1){
        		$select .= " isapproved = 0 AND ";
        	}
        }
        
        $session_status_arr = $this->session->userdata ( 'statuses' );
        $count_session_statuses = count($session_status_arr);
       
        if($count_session_statuses == 0 OR $session_status_arr == ""){
        	$statuses = $this->get_task_statuses(1);
        	$count_statuses = count($statuses);
        	$select .= " status_id IN (";
        	$i = 1;
        	$checked_items = "";
        	foreach($statuses as $cell){
        		if($cell["checked"] <> ""){
        			$checked_items .= $cell["id"].", ";
        		}
        		$i++;
        	}
        	if(strlen($checked_items) > 0 ){
        		$length = strlen($checked_items);
        		$checked_items = substr_replace($checked_items, '', strlen($checked_items)-2, strlen($checked_items));
        		$select .= $checked_items;
        	}
        	$select .= ") AND ";
        }else{
        	$select .= " status_id IN (";
        	$i = 1;
        	foreach($session_status_arr as $id_status){
        		if($i == $count_session_statuses){
        			$select .= $id_status;
        		}else{
        			
        			$select .= $id_status.", ";
        		}
        		$i++;
        	}
        	$select .= ") AND ";
        }
        
        $sql2 = "";
        $comment_sql_bol = 0;


        if (is_array($session_type_search) && trim($tasks_search) != '') {
			$select .= " (";
			foreach ( $session_type_search as $type_search ) {
				
				switch ($type_search) {
					case 0 :
						$select .= " tw_tasks.subject LIKE '%" . $tasks_search . "%' OR ";
						break;
					case 1 :
						$select .= " tw_tasks.description LIKE '%" . $tasks_search . "%' OR ";
						break;
					case 2 :
						$select .= "  tw_task_comments.text LIKE '%" . $tasks_search . "%' OR ";
						$comment_sql_bol = 1;
						
						break;
				}
				
			}
			$select = substr($select, 0, strlen($select) - 3 ); // возвращает "bcd"
			
			$select .= " ) AND ";
			
		}
       
        $select .= " 1 ";
        if($comment_sql_bol == 1){
        	$sql2 = "SELECT tw_tasks.*, admin_users.login as assigned_user_name FROM tw_tasks 
        	LEFT JOIN admin_users ON admin_users.id = tw_tasks.assigned_user
        	LEFT JOIN tw_task_comments ON tw_tasks.id = tw_task_comments.task_id " . $select . " ORDER BY sortid DESC, timestamp DESC";
        }
        if($sql2 == ""){
        	$sql = "SELECT tw_tasks.*, admin_users.login as assigned_user_name FROM tw_tasks 
        	LEFT JOIN admin_users ON admin_users.id = tw_tasks.assigned_user " . $select . " ORDER BY sortid DESC, timestamp DESC";
        }else{
        	$sql = $sql2;
        }
        //$sql = "SELECT * FROM tw_tasks " . $sql_tw_task_comments." ".$select . " ORDER BY sortid DESC, timestamp DESC";
        
        $_SESSION["tw_tasks_list_sql"] = $sql;
        //$newdata = array (
        //		'sql_list' => $sql
        //);
        //$this->session->set_userdata ( $newdata );
        //echo $this->session->userdata('sql_list');
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $i = 0;
            foreach ($query->result_array() as $row) {
                switch ($row["isapproved"]) {
                    case 0:
                        $tasks[$i]["isapproved_name"] = "No";
                        break;
                    case 1:
                        $tasks[$i]["isapproved_name"] = "Yes";
                        break;
                    default:
                        $tasks[$i]["isapproved_name"] = "Err";
                        break;
                }
                
                if (isset($statuses[$row["status_id"]])) {
                    $tasks[$i]["status_name"] = $statuses[$row["status_id"]]["name"];
                } else {
                    $tasks[$i]["status_name"] = "Err";
                }
                $tasks[$i]["b"] = $b;
                $tasks[$i]["id"] = $row["id"];
                $tasks[$i]["assigned_user_name"] = $row["assigned_user_name"];
                $tasks[$i]["subject"] = $row["subject"];
                $tasks[$i]["createtime"] = $row["createtime"];
                $tasks[$i]["sortid"] = $row["sortid"];
                $tasks[$i]["updatetime"] = date("Y-m-d H:i:s", $row["timestamp"]);
                $tasks[$i]["status_id"] = $row["status_id"];
                $tasks[$i]["isapproved"] = $row["isapproved"];
                $i ++;
                $b ++;
            }
        }
        return $tasks;
    }

    function up_item($id)
    {
        $tasks = $this->get_list();
        
        $count = count($tasks);
        for ($i = 0; $i < $count; $i ++) {
            if ($tasks[$i]["id"] == $id) {
                if (isset($tasks[$i - 1]["id"])) {
                    $sql = "UPDATE tw_tasks SET sortid = '" . $tasks[$i - 1]["sortid"] . "', timestamp = " . ($tasks[$i - 1]["timestamp"] + 1) . " WHERE id = " . $id;
                    $this->db->query($sql);
                }
                break;
            }
        }
    }
    
    function down_item($id)
    {
    	$tasks = $this->get_list();
    
    	$count = count($tasks);
    	for ($i = 0; $i < $count; $i ++) {
    		if ($tasks[$i]["id"] == $id) {
    			if (isset($tasks[$i + 1]["id"])) {
    				$sql = "UPDATE tw_tasks SET sortid = '" . $tasks[$i + 1]["sortid"] . "', timestamp = " . ($tasks[$i + 1]["timestamp"] - 1) . " WHERE id = " . $id;
    				$this->db->query($sql);
    			}
    			break;
    		}
    	}
    }

    function first_item($id)
    {
        $tasks = $this->get_list();
        
        $count = count($tasks);
        
        $sql = "UPDATE tw_tasks SET sortid = '" . $tasks[0]["sortid"] . "', timestamp = " . time() . " WHERE id = " . $id;
        $this->db->query($sql);
    }
    
    function last_item($id)
    {
    	$tasks = $this->get_list();
    
    	$count = count($tasks);
    
    	$sql = "UPDATE tw_tasks SET sortid = '" . $tasks[$count-1]["sortid"] . "', timestamp = " . ($tasks[$count-1]["timestamp"] - 1) . " WHERE id = " . $id;
    	$this->db->query($sql);
    }

    function get_task_statuses($format = 0)
    {
        $data = array();
        $not_selected = array();
        $not_selected[-2] = 1;
        $not_selected[-1] = 1;
        $not_selected[3] = 1;
        $not_selected[6] = 1;
        $session_status_arr = $this->session->userdata ( 'statuses' );
        $sql = "SELECT * FROM tw_task_status";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $i = 0;
            
            foreach ($query->result_array() as $row) {
                if ($format == 1) {
					$data [$row ["id"]] ["name"] = $row ["name"];
					$data [$row ["id"]] ["id"] = $row ["id"];
					
					$count_session_statuses = count ( $session_status_arr );
					if ($count_session_statuses == 0 OR $session_status_arr == "") {
						
						if(isset($not_selected[$row ["id"]])){
							$data [$row ["id"]] ["checked"] = "";
						} else {
							$data [$row ["id"]] ["checked"] = "checked";
							
						}
					} else {
						if (isset ( $session_status_arr [$row ["id"]] )) {
							$data [$row ["id"]] ["checked"] = "checked";
							
						}else{
							$data [$row ["id"]] ["checked"] = "";
						}
					}
				} else {
					$data [$i] ["status_id"] = $row ["id"];
					$data [$i] ["name"] = $row ["name"];
					$i ++;
				}
			}
        }

        return $data;
    }

    function set_status($task_id, $status_id)
    {
        $sql = "UPDATE tw_tasks SET isapproved = 0, status_id = '" . $status_id . "' WHERE id = " . $task_id;
        $this->db->query($sql);
    }
    
    function get_task_status($task_id){
    	$task_status = 0;
    	$sql = "SELECT status_id FROM tw_tasks WHERE id = ".$task_id;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		$task_status = $row->status_id;
    	}
    	return $task_status;
    }
    
    function get_task_data($task_id){
    	$data = array();
    	$sql = "SELECT * FROM tw_tasks WHERE id = ".$task_id;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row_array();
    		$data = $row;
    	}
    	return $data;
    }
    
    function set_status_new($task_id, $status_id)
    {
    	$now_datetime = date("Y-m-d H:i:s");
    	$status_data = $this->get_task_data($task_id);
    	$old_task_status = $status_data["status_id"];
    	$old_timer_work = $status_data["timer_work"];
    	$old_timer_pause = $status_data["timer_pause"];
    	$old_timer_stay = $status_data["timer_stay"];
    	switch ($status_id) {
			case 0 :
				$sql = "UPDATE tw_tasks SET createtime = '" . $now_datetime . "' WHERE id = " . $task_id;
				$this->db->query($sql);
				break;
			case 1 :
				$sql = "UPDATE tw_tasks SET chkpt_work = '" . $now_datetime . "' WHERE id = " . $task_id;
				$this->db->query($sql);
				
				switch ($old_task_status) {
					case 0 :
						$timer_stay = strtotime ( $now_datetime ) - strtotime ( $status_data ["createtime"] );
						$new_timer_stay = $old_timer_stay + $timer_stay; 
						$sql = "UPDATE tw_tasks SET timer_stay = '" . $new_timer_stay . "' WHERE id = " . $task_id;
						echo $sql;
						$this->db->query ( $sql );
						break;
					case 2 :
						$timer_pause = strtotime ( $now_datetime ) - strtotime ( $status_data ["chekpt_pause"] );
						$new_timer_pause = $old_timer_pause + $timer_pause;
						$sql = "UPDATE tw_tasks SET timer_pause = '" . $new_timer_pause . "' WHERE id = " . $task_id;
						$this->db->query ( $sql );
						break;
					case 4 :
						$timer_stay = strtotime ( $now_datetime ) - strtotime ( $status_data ["createtime"] );
						$new_timer_stay = $old_timer_stay + $timer_stay;
						$sql = "UPDATE tw_tasks SET timer_stay = '" . $new_timer_stay . "' WHERE id = " . $task_id;
						echo $sql;
						$this->db->query ( $sql );
						break;
				}
				break;
			case 2 :
				$sql = "UPDATE tw_tasks SET chekpt_pause = '" . $now_datetime . "' WHERE id = " . $task_id;
				$this->db->query ( $sql );
				switch ($old_task_status) {
					case 1 :
						$timer_work = strtotime ( $now_datetime ) - strtotime ( $status_data ["chkpt_work"] );
						$new_timer_work = $old_timer_work + $timer_work;
						$sql = "UPDATE tw_tasks SET timer_work = '" . $new_timer_work . "' WHERE id = " . $task_id;
						$this->db->query ( $sql );
						break;
				}
				break;
			case 3 :
				$sql = "UPDATE tw_tasks SET done_time = '" . $now_datetime . "' WHERE id = " . $task_id;
				$this->db->query ( $sql );
				switch ($old_task_status) {
					case 1 :
						$timer_work = strtotime ( $now_datetime ) - strtotime ( $status_data ["chkpt_work"] );
						$new_timer_work = $old_timer_work + $timer_work;
						$sql = "UPDATE tw_tasks SET timer_work = '" . $new_timer_work . "' WHERE id = " . $task_id;
						$this->db->query ( $sql );
						break;
					case 2 :
						$timer_pause = strtotime ( $now_datetime ) - strtotime ( $status_data ["chekpt_pause"] );
						$new_timer_pause = $old_timer_pause + $timer_pause;
						$sql = "UPDATE tw_tasks SET timer_pause = '" . $new_timer_pause . "' WHERE id = " . $task_id;
						$this->db->query ( $sql );
						break;
				}
				break;
			case 4 :
				$sql = "UPDATE tw_tasks SET createtime = '" . $now_datetime . "' WHERE id = " . $task_id;
				$this->db->query($sql);
				break;
		}
		//================ SET STATUS ==============
    	$sql = "UPDATE tw_tasks SET isapproved = 0, status_id = '" . $status_id . "' WHERE id = " . $task_id;
    	$this->db->query($sql);
    }

    function set_isapproved($task_id, $isapproved)
    {
        $sql = "UPDATE tw_tasks SET isapproved = '" . $isapproved . "' WHERE id = " . $task_id;
        $this->db->query($sql);
    }
    function get_task_log($task_id){
    	$data = array();
    	$user_data = array();
    	$sql = "SELECT * FROM admin_users WHERE 1";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$user_data[$row->id] = $row->login;
    		}
    	}
    	
    	$sql = "SELECT * FROM tw_tasks_log WHERE task_id = ".$task_id;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		
    		foreach ($query->result() as $row) {
    			$description = "";
    			if (trim ( $row->description ) != "") {
    				$temp_description_mass = explode ( "},", $row->description );
    				for($il = 0; $il < count ( $temp_description_mass )-1; $il ++) {
    					$bool = strstr ( $temp_description_mass [$il], "all fields" );
    					if ($bool == false)
    						$description .= $this->loger->db_parse_logs ( $temp_description_mass [$il] );
    				}
    			}
    			$user = $user_data[$row->user];
    			array_push($data, array(
    				"task_id" => $row->task_id,
    				"user" => $user,
    				"description" => $description,
    				"datetime" => $row->datetime
    			));
    		}
    	}
    	
    	return $data;
    }
    function get_task_comments($task_id){
    	$data = array();
    	$user_data = array();
    	$sql = "SELECT * FROM admin_users WHERE 1";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		foreach ($query->result() as $row) {
    			$user_data[$row->id] = $row->login;
    		}
    	}
    	 
    	$sql = "SELECT * FROM tw_task_comments WHERE task_id = ".$task_id;
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    
    		foreach ($query->result() as $row) {
    			$user = $user_data[$row->user_id];
    			array_push($data, array(
    			"comment_id" => $row->id,
    			"task_id" => $row->task_id,
    			"user_name" => $user,
    			"text" => stripslashes($row->text),
    			"time" => $row->time
    			));
    		}
    	}
    	 
    	return $data;
    }
    
    function get_prev_next($task_id){
    	$data = array();
    	$sql_list = $_SESSION["tw_tasks_list_sql"];
    	echo $sql_list>"=====";
    	if(trim($sql_list) <> ""){
    	$query = $this->db->query($sql_list);
    	
    	if ($query->num_rows() > 0) {
    		$i = 0;
    		foreach ($query->result_array() as $row) {
    			$data[$i] = $row["id"];
    			$i ++;
    		}
    	}
    	}
    	
    	$count = count($data);
    	$prev = 0;
    	$next = 0;
    	for($i = 0; $i < $count; $i++){
    		if($task_id == $data[$i]){
    			if($i <> 0){
    				$prev = $data[$i-1];
    			}else{
    				$prev = $data[0];
    			}
    			
    			$next = $data[$i+1];
    		}
    	}
    	return array("prev" => $prev, "next" => $next);
    }
    function save_comment($data){
    	if (isset ( $_SESSION ["user"] ["user_id"] )) {
    		$user_id = $_SESSION ["user"] ["user_id"];
    	} else {
    		$user_id = - 1;
    	}
    	$sql = "INSERT INTO tw_task_comments(user_id, task_id, text, time) VALUES('".$user_id."', '".$data["task_id"]."', '".addslashes($data["comment"])."', '".date("Y-m-d H:i:s")."')";
    	$this->db->query($sql);
    	$sql = "UPDATE tw_tasks SET timestamp = " . time() . " WHERE id = ".$data["task_id"];
    	$this->db->query($sql);
    	if($data["return_type"] == 1){
    		$sql = "UPDATE tw_tasks SET timestamp = ".time().", isapproved = 0, status_id = 4 WHERE id = ".$data["task_id"];
    		$this->db->query($sql);
    	}
    }
    
    function delete_comment($id){
    	$sql = "DELETE FROM tw_task_comments WHERE id = ".$id;
    	$this->db->query($sql);
    }
}
?>