<?php
class Admin_model extends CI_model {
	function __construct() {
		parent::__construct ();

		$this->load->model ( 'authorization');
		$this->load->model ( 'curl_model' );
	}
	
	function get_order_log_states(){
	    $states = array();
	    $states[0]['state_name'] = "insert";
	    $states[0]['state_value'] = 1;
	    $states[0]['state_selected'] = "";
	    $states[1]['state_name'] = "update";
	    $states[1]['state_value'] = 3;
	    $states[1]['state_selected'] = "";
	    $states[2]['state_name'] = "delete";
	    $states[2]['state_value'] = 2;
	    $states[2]['state_selected'] = "";
	    
	    return $states;
	}
	
	function get_hotel_bookings() {
		$hotel_bookings = array ();
		$sql = "SELECT id, db_name, host FROM config WHERE bup = 1";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$db_name = $row->db_name;
				$booking_ids_str = "";
				$sql2 = "SELECT * FROM `$db_name`.dc_booking_xml_cfg WHERE dc_account_id <> 0 AND name LIKE 'hotel_id'";
				$query2 = $this->db->query ( $sql2 );
				foreach ( $query2->result () as $row2) {
					$booking_ids_str .= $row2->int_value."<br>";
				}

				array_push ( $hotel_bookings, array (
						"hotel_id" => $row->id,
						"host" => $row->host,
						"db_name" => $row->db_name,
						"booking_id" => $booking_ids_str
				) );
			}
		}
		return $hotel_bookings;
	}

	function get_hotels_airbnb() {
	    $hotels_airbnb = array ();
	    $sql = "SELECT id, db_name, host FROM config WHERE bup = 1";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $db_name = $row->db_name;
	            $airbnb_ids_str = "";
	            $sql2 = "SELECT * FROM `$db_name`.dc_airbnb_xml_cfg WHERE name LIKE 'user_id'";
	            $query2 = $this->db->query ( $sql2 );
	            foreach ( $query2->result () as $row2) {
	                $airbnb_ids_str .= $row2->int_value."<br>";
	            }

	            array_push ( $hotels_airbnb, array (
	                "hotel_id" => $row->id,
	                "host" => $row->host,
	                "db_name" => $row->db_name,
	                "booking_id" => $airbnb_ids_str
	            ) );
	        }
	    }
	    return $hotels_airbnb;
	}

	function get_dc_all_booking($limit = 50){
	    $dc_id = $this->session->userdata ( 'session_dc_all_bookings_dc_id' );
	    $state = $this->session->userdata ( 'session_dc_all_bookings_state' );
	    $select = "WHERE";
	    if($dc_id > 0){
	        $select .= " order_log.dc_id = $dc_id AND";
	    }
	    if($state > 0){
	        $select .= " order_log.state = $state AND";
	    }
	    $select .= " 1";
	    if ($limit < 50){
	        $limit = 50;
	    }
	    $limit_step = 50;
	    $limit_start = $limit - $limit_step;
	    $limit_step = 200;
	    $hotel_bookings = array();
	    $sql = "SELECT order_log.hotel_id, order_log.reservation_id, order_log.dc_id, order_log.datetime, visitka.config.host
	    FROM global_hotelix.order_log
	    INNER JOIN visitka.config ON visitka.config.id = global_hotelix.order_log.hotel_id
	    $select
	    ORDER BY order_log.id DESC
	    LIMIT 0, $limit_step";

	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $n = 0;
	        foreach ( $query->result () as $row ) {
	            $n++;
	            array_push ( $hotel_bookings, array (
	                "n" => $n,
	                "hms_hotel_id" => $row->hotel_id,
	                "dc_id" => $row->dc_id,
	                "host" => $row->host,
	                "hms_reservation_id" => $row->reservation_id,
	                "time" => $row->datetime
	            ) );
	        }
	    }
	    return $hotel_bookings;
	}

	function get_hotel_bookings_v2($limit = 50) {
		$hotel_bookings = array ();
		$tbl_1 = "dc_booking.dc_booking_orders_get";
		$tbl_2 = "dc_booking.dc_booking_hotels";
		if ($limit < 50){
			$limit = 50;
		}
		$limit_step = 50;
		$limit_start = $limit - $limit_step;
		$sql = "SELECT dc_hotel_id, hms_hotel_id, dc_reservation_id, $tbl_1.timestamp as time, dc_status, hms_url, dbname
				FROM $tbl_1
				JOIN $tbl_2 ON dc_hotel_id = hotel_id
				ORDER BY time DESC
				LIMIT $limit_start, $limit_step";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$n = $limit_start;
			foreach ( $query->result () as $row ) {
				$n++;
				$db_name = $row->dbname;
				$hms_reservation_id = "";
				$tbl = "`$db_name`.`deskofreservation`";
				$sql2 = "SELECT id FROM $tbl WHERE dc_reservationid = $row->dc_reservation_id";
				$query2 = $this->db->query ( $sql2 )->row();
				array_push ( $hotel_bookings, array (
						"n" => $n,
						"hms_hotel_id" => $row->hms_hotel_id,
						"host" => $row->hms_url,
						"hms_reservation_id" => $query2->id,
						"dc_reservation_id" => $row->dc_reservation_id,
						"dc_status" => $row->dc_status,
						"time" => $row->time
				) );
			}
		}
		return $hotel_bookings;
	}
	
	function get_hotel_bookings_push($limit = 50) {
	    $hotel_bookings = array ();
	    $tbl_1 = "dc_booking.dc_booking_orders_get_pull";
	    $tbl_2 = "dc_booking.dc_booking_hotels";
	    
	    $dc_reservation_id = $this->session->userdata ( 'session_booking_push_dc_reservation_id' );
	    $hms_id = $this->session->userdata ( 'session_booking_push_hms_id' );
	    $select = "WHERE";
	    if($dc_reservation_id > 0){
	        $select .= " $tbl_1.dc_reservation_id = $dc_reservation_id AND";
	    }
	    if($hms_id > 0){
	        $select .= " $tbl_2.hms_hotel_id = $hms_id AND";
	    }
	    $select .= " 1";

	    if ($limit < 50){
	        $limit = 50;
	    }
	    $limit_step = 50;
	    $limit_start = $limit - $limit_step;
	    $sql = "SELECT $tbl_1.id as pull_id, dc_hotel_id, hms_hotel_id, dc_reservation_id, $tbl_1.timestamp as time, dc_status, hms_url, dbname
	    FROM $tbl_1
	    JOIN $tbl_2 ON dc_hotel_id = hotel_id
	    $select
	    ORDER BY time DESC
	    LIMIT $limit_start, $limit_step";
	    //echo $sql;
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $n = $limit_start;
	        foreach ( $query->result () as $row ) {
	            $n++;
	            $db_name = $row->dbname;
	            $hms_reservation_id = "";
	            $tbl = "`$db_name`.`deskofreservation`";
	            $sql2 = "SELECT id FROM $tbl WHERE dc_reservationid = $row->dc_reservation_id";
	            $query2 = $this->db->query ( $sql2 )->row();
	            array_push ( $hotel_bookings, array (
	                "n" => $n,
	                "pull_id" => $row->pull_id,
	                "hms_hotel_id" => $row->hms_hotel_id,
	                "host" => $row->hms_url,
	                "hms_reservation_id" => $query2->id,
	                "dc_reservation_id" => $row->dc_reservation_id,
	                "dc_status" => $row->dc_status,
	                "time" => $row->time
	            ) );
	        }
	    }
	    return $hotel_bookings;
	}

	function get_hotel_bookings_expedia() {
	    $hotel_bookings = array ();
	    $sql = "SELECT visitka.config.id as hms_id, dc_booking.expedia_hms_hotels.* FROM dc_booking.expedia_hms_hotels
	    LEFT JOIN visitka.config ON dc_booking.expedia_hms_hotels.db_name LIKE visitka.config.db_name
	    WHERE 1 ORDER BY visitka.config.id ASC";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $inc = 1;
	        foreach ( $query->result () as $row ) {
	            $db_name = $row->db_name;
	            $booking_ids_str = "";

	            array_push ( $hotel_bookings, array (
	                "id" => $inc,
	                "hotel_id" => $row->hms_id,
	                "host" => $row->host,
	                "db_name" => $row->db_name,
	                "booking_id" => $row->hotel_id
	            ) );
	            $inc++;
	        }
	    }
	    return $hotel_bookings;
	}

	function get_visitka_hotels_bup($return_type = 0)
    {
        $hotels = array();
        switch ($return_type) {
            case 0:
                $sql = "SELECT visitka.config.*, visitka.users.company, visitka.users.userlastname,
                        visitka.users.userfirstname, visitka.users.useremail
                        FROM visitka.config
                        LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url
                        WHERE visitka.config.bup = 1";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        array_push($hotels, array(
                            "hotel_id" => $row->id,
                            "host" => $row->host,
                            "db_name" => $row->db_name,
                            "company" => $row->company,
                            "user" => $row->userfirstname . " " . $row->userlastname,
                            "email" => $row->useremail
                        ));
                    }
                }
                break;
            case 1:
                $sql = "SELECT visitka.config.id, visitka.config.host
                        FROM visitka.config
                        WHERE visitka.config.bup = 1
                        ORDER BY visitka.config.id ASC";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        $hotels[$row->id]["hms_id"] = $row->id;
                        $hotels[$row->id]["hms_host"] = $row->host;
                        $hotels[$row->id]["hms_selected"] = "";
                    }
                }
                break;
        }
        return $hotels;
    }

	function get_visitka_hotel_legalsystem_arr() {
		$legalsystems = array ();
		$sql = "SELECT * FROM visitka.legalsystems ";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $legalsystems, array (
						"id" => $row->id,
						"value" => $row->value,
						"description" => $row->description
				) );
			}
		}
		return $legalsystems;
	}
	function get_visitka_hotel_cities() {
		$cities = array ();
		$sql = "SELECT * FROM visitka.tbl_city";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $cities, array (
				"id" => $row->id,
				"name" => $row->name
				) );
			}
		}
		return $cities;
	}
	function get_visitka_hotel_property_types() {
		$property_types = array ();
		$sql = "SELECT * FROM visitka.property_types";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $property_types, array (
				"id" => $row->id,
				"name" => $row->name
				) );
			}
		}
		return $property_types;
	}
	function get_visitka_hotel_countries() {
		$countries = array ();
		$sql = "SELECT * FROM visitka.tbl_country";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $countries, array (
				"id" => $row->id,
				"name" => $row->name
				) );
			}
		}
		return $countries;
	}

	function get_hotelstates() {
		$hotelstates = array ();
		$sql = "SELECT * FROM hotelstates";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {

				$hotelstates[$row->id]["state_id"] = $row->id;
				$hotelstates[$row->id]["state_name"] = $row->name;
			}
		}
		return $hotelstates;
	}

	function get_regstates() {
		$regstates = array ();
		$sql = "SELECT * FROM regstates";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {

				$regstates[$row->id]["state_id"] = $row->id;
				$regstates[$row->id]["state_name"] = $row->name;
			}
		}
		return $regstates;
	}

	function get_visitka_hotel($hotel_id) {
		$hotel_data = array ();
		$sql = "SELECT visitka.config.*, visitka.users.company, visitka.users.time as reg_datetime,
		    visitka.users.userlastname, visitka.users.userfirstname, visitka.users.useremail, visitka.users.userphone
		    FROM visitka.config LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url WHERE visitka.config.id = " . $hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$hotel_data = array (
					"hotel_id" => $row->id,
					"host" => $row->host,
					"db_name" => $row->db_name,
					"personal_url" => $row->personal_url,
					"company" => $row->company,
					"bup" => $row->bup,
					"user" => $row->userfirstname . " " . $row->userlastname,
					"email" => $row->useremail,
					"phone" => $row->userphone,
					"dc_cron_rate" => $row->dc_cron_rate,
					"hotelstateid" => $row->hotelstateid,
					"id_city" => $row->id_city,
					"id_country" => $row->id_country,
			        "id_country_3c" => $row->id_country_3c,
					"property_type" => $row->property_type,
			        "reg_datetime" => $row->reg_datetime,
			);
		}
		return $hotel_data;
	}
	
	function get_visitka_hotel_db_name($hotel_id) {
	    $hotel_data = array ();
	    $sql = "SELECT visitka.config.id, visitka.config.db_name, visitka.config.host FROM visitka.config WHERE visitka.config.id = $hotel_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $hotel_data = array (
	            "hotel_id" => $row->id,
	            "host" => $row->host,
	            "db_name" => $row->db_name,
	        );
	    }
	    return $hotel_data;
	}
	
	function get_visitka_hotels_userlist($current_page) {

	    $res = $this->db->query("select * from global_fms_base.dict_country order by NAME_LAT ASC");
	    $countries = array();
	    foreach ($res->result() as $row) {
	        $countries[$row->id] = $row->NAME;
	    }

		$search_name = $this->session->userdata ( 'search_name' );
		$search_id = $this->session->userdata ( 'search_id' );
		$search_email = $this->session->userdata ( 'search_email' );
		$search_groupid = $this->session->userdata ( 'search_groupid' );
		$search_bookingid = $this->session->userdata ( 'search_bookingid' );
		$search_hotelstateid = $this->session->userdata ( 'search_hotelstateid' );
		$search_type_form = $this->session->userdata ( 'type_form' );
		$search_country = $this->session->userdata ( 'search_country' );
		$search_version = $this->session->userdata ( 'search_version' );
		$search_stripe = $this->session->userdata ( 'search_stripe' );
		$search_billing_version = $this->session->userdata ( 'search_billing_version' );
		$search_2way_auth_mode = $this->session->userdata ( 'search_2way_auth_mode' );

		$sort_stripe_ballance = $this->session->userdata ( 'sort_stripe_ballance' );
		$sort_hms_id = $this->session->userdata ( 'sort_hms_id' );
		//echo "<pre>";
		//print_r($search_hotelstateid);
		//die();
//==================pagination START
		if ($this->session->userdata ( 'hlist_lines_per_page' ) != ""){
			$lines_per_page = $this->session->userdata ( 'hlist_lines_per_page' );
		}else{
			$lines_per_page = 50;
		}
		$cur_page = $current_page;
		$page_first_line = ($cur_page - 1) * $lines_per_page;
		$url_for_pagination = "/users/hlist/";
//==================pagination END

		// build sort select
		$select_sort = "";
		if ($sort_stripe_ballance != "" or $sort_hms_id != "") {
		    switch ($sort_stripe_ballance) {
		        case 11 :
		            $select_sort = "ORDER by visitka.config.stripe_ballance ASC";
		            break;
		        case 12 :
		             $select_sort = "ORDER by visitka.config.stripe_ballance DESC";
		            break;
		    }
		    switch ($sort_hms_id) {
		        case "21" :
		            $select_sort = "ORDER by visitka.config.id ASC";
		            break;
		        case "22" :
		            $select_sort = "ORDER by visitka.config.id DESC";
		            break;
		    }

		} else {
		    $select_sort = "ORDER by visitka.config.id DESC";
		}

		// build select
		$select = " WHERE ";


		if ($search_country === '0') {
		    $select .= "visitka.config.id_country_3c = '' AND ";
		} else {
            if ($search_country != "") {
                $select .= "visitka.config.id_country_3c = '" . $search_country . "' AND ";
            }
        }

        if ($search_2way_auth_mode != "" && $search_2way_auth_mode != 0) {
        
            $select .= "visitka.config.2way_auth_mode = ".$search_2way_auth_mode." AND ";
        }
        
		if ($search_version != "") {

		    $select .= "visitka.config.version = '".$search_version."' AND ";
		}

		$select_stripe_join = "";
		if ($search_stripe == 2) {

		    $select_stripe_join = " INNER JOIN global_hotelix_stripe.hms_allowed_to_all_skiped_hms_ids ON global_hotelix_stripe.hms_allowed_to_all_skiped_hms_ids.hms_id = visitka.config.id";
		}

		if ($search_stripe == 1) {

		    $select_stripe_join = " LEFT JOIN global_hotelix_stripe.hms_allowed_to_all_skiped_hms_ids ON global_hotelix_stripe.hms_allowed_to_all_skiped_hms_ids.hms_id = visitka.config.id";
		    $select .= "global_hotelix_stripe.hms_allowed_to_all_skiped_hms_ids.hms_id IS NULL AND ";
		}



		if ($search_billing_version != "") {

		    $select .= "visitka.config.hms_billing_version = '".$search_billing_version."' AND ";
		}

		if ($search_type_form == 2 && $search_hotelstateid != "") {

			$count_hotelstates = count ( $search_hotelstateid );
			if ($count_hotelstates != 0 && $search_hotelstateid != "") {
				$select .= "visitka.config.hotelstateid IN (";

				$i = 1;
				foreach ( $search_hotelstateid as $cell ) {
					if ($count_hotelstates == $i) {
						$select .= $cell ["id"];
					} else {
						$select .= $cell ["id"] . ", ";
					}
					$i ++;
				}
				$select .= ") AND ";
			}
		}

		$select .= " 1 ";
		// echo $select;
		if ($search_name != "") {
			$select = "";
			$limit_records = "";
			$select .= " WHERE
	visitka.users.company LIKE '%" . $search_name . "%' OR
	visitka.users.site_address LIKE '%" . $search_name . "%' OR
	visitka.users.userlastname LIKE '%" . $search_name . "%' OR
	visitka.users.userfirstname LIKE '%" . $search_name . "%' OR
	visitka.users.useremail LIKE '%" . $search_name . "%' OR
	visitka.users.userphone LIKE '%" . $search_name . "%' OR
	visitka.config.host LIKE '%" . $search_name . "%' ";
		} else {
			$limit_records = "  ";
		}
		if ($search_id != "") {
			$select = "";
			$limit_records = "";
			$select .= " WHERE visitka.config.id = " . $search_id . " ";
		} else {
			$limit_records = "  ";
		}
		if ($search_email != "") {
			$select = "";
			$limit_records = "";
			$select .= " WHERE visitka.users.useremail LIKE '%" . $search_email . "%' ";
		} else {
			$limit_records = "  ";
		}
		if ($search_groupid != "") {
			$limit_records = "";
			$select = "";
			$h_ids = array ();
			$select_chain = " WHERE global_chain_hotelix.chains.chainid = " . $search_groupid . " ";
			$sql = "SELECT global_chain_hotelix.chains.* FROM global_chain_hotelix.chains $select_chain";
			//echo $sql;
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					array_push ( $h_ids, array (
							"hotel_id" => $row->hotelid
					) );
				}
			}
			$count_h = count ( $h_ids );
			if ($count_h > 0) {
				$select .= " WHERE visitka.config.id IN (";
				for($i = 0; $i < $count_h; $i ++) {
					if ($i == ($count_h - 1)) {
						$select .= $h_ids [$i] ["hotel_id"] . " ";
					} else {
						$select .= $h_ids [$i] ["hotel_id"] . ", ";
					}
				}
				$select .= ") ";
			}
		} else {
			$limit_records = "  ";
		}
		$lines_per_current_page = $page_first_line+1;

		$hotelstates = array ();
		$query = $this->db->query ( "SELECT * FROM  hotelstates" );
		$i = 0;
		if ($query->num_rows () > 0) {
		    foreach ( $query->result () as $row ) {
		        $hotelstates [$row->id]["id_state"] = $row->id;
		        $hotelstates [$row->id]["name"] = $row->name;

		    }
		}

		$hotels = array ();

		$sql = "SELECT SQL_CALC_FOUND_ROWS visitka.config.*, tbl_city.name as city_name,  tbl_country.name as country_name,
		visitka.users.promocode, visitka.users.company, visitka.users.userlastname, visitka.users.time as reg_datetime,
		visitka.users.userfirstname, visitka.users.useremail, visitka.users.userphone, visitka.config.stripe_ballance
		FROM visitka.config
		$select_stripe_join
		LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url
		LEFT JOIN visitka.tbl_city ON visitka.tbl_city.id = visitka.config.id_city
		LEFT JOIN visitka.tbl_country ON visitka.tbl_country.id = visitka.config.id_country

		" . $select . " ".$select_sort." " . $limit_records . " LIMIT ".$page_first_line.", ".$lines_per_page;
//   		echo $sql;
//   		die();
		$_SESSION["hlist_sql"] = $sql;
//  		die();
		$query = $this->db->query ( $sql );
		$query_p = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row();
		$all_lines_count = $query_p->all_lines_count;
		if ($query->num_rows () > 0) {
// 			$id_r = 1;
			foreach ( $query->result () as $row ) {
				$status = "";
				if(isset($hotelstates[$row->hotelstateid])){
				    $status = $hotelstates[$row->hotelstateid]["name"];
				}

// 				switch ($row->hotelstateid) {
// 					case 0 :
// 						$status = "Новый";
// 						break;
// 					case 1 :
// 						$status = "Настроен";
// 						break;
// 					case 2 :
// 						$status = "Обучен";
// 						break;
// 					case 3 :
// 						$status = "Подключен";
// 						break;
// 					case 4 :
// 						$status = "Думает";
// 						break;
// 					case 5 :
// 						$status = "Отключился";
// 						break;
// 					case 6 :
// 						$status = "Заблокирован";
// 						break;
// 					case 7 :
// 						$status = "Лишний";
// 						break;
// 				}

				if (isset($countries[$row->id_country_3c])) {
				    $country_3c = $countries[$row->id_country_3c];
				} else {
				    $country_3c = "???";
				}
				
				$rreg_time = date("Y-m-d H:i:s", strtotime($row->reg_datetime) + $_SESSION['user']['user_id']) . "";
				//$rreg_time = date("Y-m-d H:i:s", strtotime($row->reg_datetime) + $_SESSION['user']['user_id']) . "";
				
				if ($_SERVER['REMOTE_ADDR'] == "93.75.194.242") {
// 				    echo "<pre>";
				    
// 				    echo $_SESSION['user']['user_id'];
				    
// 				    print_r($_SESSION);
// 				    die();
// 				    print_r($_SESSION);
				
				}
				
// 				if(trim($row->referer) != ""){
// 				    $referer = '<a target="_blank" href="'.stripslashes($row->referer).'">referer</a>';
// 				}else{
// 				    $referer = '---';
// 				}
				
				array_push ( $hotels, array (
						"hotel_id" => $row->id,
						"host" => $row->host,
						"db_name" => $row->db_name,
						"status" => $status,
						"promocode" => $row->promocode,
				        "reg_datetime" => $rreg_time,
						"company" => $row->company,
						"user" => $row->userfirstname . " " . $row->userlastname,
						"email" => $row->useremail,
						"phone" => $row->userphone . $this->session->userdata ( 'id' ),
						"city" => $row->city_name,
						"country" => $row->country_name,
				        "id_country_3c" => $country_3c,
				        "stripe_ballance" => $row->stripe_ballance,
						"id_r" => $lines_per_current_page, //$id_r
				        //"referer" => $referer
				) );
				$lines_per_current_page++;
// 				$id_r ++;
			}
		}
		$data = array();
		$data["hotels"] = $hotels;
		$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);
		return $data;
	}
	function get_review_status($hotel_data) {
		$review_status = 0;
		$db_name = $hotel_data ["db_name"];

		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'reviews'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$review_status = $row->is_active;
		}

		return $review_status;
	}
	function set_unset_review_status($hotel_id) {
		$review_status = 0;
		$db_name = $this->get_hotel_db ( $hotel_id );
		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'reviews'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$review_status = $row->is_active;
		}

		if ($review_status == 1) {
			$review_new = 0;
		} else {
			$review_new = 1;
		}
		$sql = "INSERT INTO  `$db_name`.modules (name, is_active) VALUES ('reviews', " . $review_new . ") ON DUPLICATE KEY UPDATE is_active=" . $review_new;
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
	}

	function get_dc_booking_data($hotel_id, $db_name){
		$data = array();
		$sql = "SELECT int_value FROM `$db_name`. dc_booking_xml_cfg WHERE name LIKE 'hotel_id'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$data[$hotel_id]["booking_id"] = $row->int_value;
		}

		$sql = "SELECT int_value FROM `$db_name`. dc_booking_xml_cfg WHERE name LIKE 'general_update'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$data[$hotel_id]["active"] = $row->int_value;
		}
		return $data;
	}
	
	function get_hms_access_code(){
	    $hms_access_code = '';
	    $ip = $this->authorization->GetRealIp();;
	    $login = $_SESSION ['user']['login'];
	    $sql = "SELECT hms_access_code FROM `visitka`. admin_users WHERE login LIKE '$login' AND ip LIKE '$ip'";
	    //echo $sql;
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $hms_access_code = $row->hms_access_code;
	    }
	
	    return $hms_access_code;
	}

	function user_edit_save($data) {
		$db_name = $this->get_hotel_db ( $data ["hotel_id"] );
		$sql = "UPDATE `$db_name`.users SET chainid = " . $data ["chainid"] . " WHERE id = " . $data ["user_id"];
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
	}
	function get_dc_xml_cfg($hotels) {
		$data = array ();
		for($i = 0; $i < count ( $hotels ); $i ++) {
			$data [$i] ["host"] = $hotels [$i] ["host"];
			$data [$i] ["hotel_id"] = $hotels [$i] ["hotel_id"];

			$db_name = $hotels [$i] ["db_name"];

			// booking
			$sql = "SELECT * FROM `$db_name`.dc_booking_xml_cfg";
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );

			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					switch ($row->name) {
						case "dealer_id" :
							$data [$i] ["booking"] ["dealer_id"] = $row->int_value;
							break;
						case "overbooking_category_id" :
							$data [$i] ["booking"] ["overbooking_category_id"] = $row->int_value;
							break;
						case "hotel_id" :
							$data [$i] ["booking"] ["dc_hotel_id"] = $row->int_value;
							break;
						case "general_update" :
							$data [$i] ["booking"] ["general_update"] = $row->int_value;
							break;
					}
				}
			}

			// ostrovok
			$sql = "SELECT * FROM `$db_name`.dc_ostrovok_xml_cfg";
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );

			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					switch ($row->name) {
						case "dealer_id" :
							$data [$i] ["ostrovok"] ["dealer_id"] = $row->int_value;
							break;
						case "overbooking_category_id" :
							$data [$i] ["ostrovok"] ["overbooking_category_id"] = $row->int_value;
							break;
						case "hotel_id" :
							$data [$i] ["ostrovok"] ["dc_hotel_id"] = $row->int_value;
							break;
						case "general_update" :
							$data [$i] ["ostrovok"] ["general_update"] = $row->int_value;
							break;
					}
				}
			}

			// expedia
			$sql = "SELECT * FROM `$db_name`.dc_expedia_xml_cfg";
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );

			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					switch ($row->name) {
						case "dealer_id" :
							$data [$i] ["expedia"] ["dealer_id"] = $row->int_value;
							break;
						case "overbooking_category_id" :
							$data [$i] ["expedia"] ["overbooking_category_id"] = $row->int_value;
							break;
						case "hotel_id" :
							$data [$i] ["expedia"] ["dc_hotel_id"] = $row->int_value;
							break;
						case "general_update" :
							$data [$i] ["expedia"] ["general_update"] = $row->int_value;
							break;
					}
				}
			}
		}

		return $data;
	}
	function get_hotelix_personal_url($db_name) {
		$personal_url = "";
		$sql = "SELECT str_value FROM `$db_name`.hotelix_config WHERE name LIKE 'personal_url'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$personal_url = $row ['str_value'];
		}
		return $personal_url;
	}

	function get_visitka_hotel_legalsystem($db_name) {
		$legalsystem = "";
		$sql = "SELECT str_value FROM `$db_name`.hotelix_config WHERE name LIKE 'legalsystem'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$legalsystem = $row ['str_value'];
		}
		return $legalsystem;
	}
	function get_visitka_hotel_version($db_name) {
		$version = "";
		$sql = "SELECT value FROM `$db_name`.hotelix_config WHERE name LIKE 'version'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$version = $row ['value'];
		}
		return $version;
	}

	function get_visitka_hotel_version_1_disallow($db_name) {
		$version_1_disallow = "";
		$sql = "SELECT value FROM `$db_name`.hotelix_config WHERE name LIKE 'version_1_disallow'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$version_1_disallow = $row ['value'];
		}
		return $version_1_disallow;
	}

	function get_visitka_hotel_custom_debug($db_name) {
		$custom_debug = "";
		$sql = "SELECT str_value FROM `$db_name`.hotelix_config WHERE name LIKE 'custom_debug'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$custom_debug = $row ['str_value'];
		}
		return $custom_debug;
	}
	function get_single_dc_xml_cfg($hotel_data) {
		$data = array ();

		// $data ["host"] = $hotel_data ["host"];
		// $data ["hotel_id"] = $hotel_data ["hotel_id"];

		$db_name = $hotel_data ["db_name"];
		$data [0] ["dc_name"] = "booking";
		$data [0] ["dealer_id"] = "";
		$data [0] ["overbooking_category_id"] = "";
		$data [0] ["dc_hotel_id"] = "";
		$data [0] ["username"] = "";
		$data [0] ["general_update"] = "";
		$data [0] ["dc_id"] = "1";
		$data [0] ["eqc_user"] = "";
		$data [0] ["currency"] = "";
		$data [0] ["prop_pass"] = "";
		$data [0] ["api_key"] = "";

		$data [1] ["dc_name"] = "ostrovok";
		$data [1] ["dealer_id"] = "";
		$data [1] ["overbooking_category_id"] = "";
		$data [1] ["dc_hotel_id"] = "";
		$data [1] ["username"] = "";
		$data [1] ["general_update"] = "";
		$data [1] ["dc_id"] = "2";
		$data [1] ["eqc_user"] = "";
		$data [1] ["currency"] = "";
		$data [1] ["prop_pass"] = "";
		$data [1] ["api_key"] = "";

		$data [2] ["dc_name"] = "expedia";
		$data [2] ["dealer_id"] = "";
		$data [2] ["username"] = "";
		$data [2] ["overbooking_category_id"] = "";
		$data [2] ["dc_hotel_id"] = "";
		$data [2] ["general_update"] = "";
		$data [2] ["dc_id"] = "3";
		$data [2] ["eqc_user"] = "";
		$data [2] ["eqc_password"] = "";
		$data [2] ["currency"] = "";
		$data [2] ["prop_pass"] = "";
		$data [2] ["api_key"] = "";

		$data [3] ["dc_name"] = "HsClub";
		$data [3] ["dealer_id"] = "";
		$data [3] ["overbooking_category_id"] = "";
		$data [3] ["dc_hotel_id"] = "";
		$data [3] ["username"] = "";
		$data [3] ["general_update"] = "";
		$data [3] ["dc_id"] = "4";
		$data [3] ["eqc_user"] = "";
		$data [3] ["eqc_password"] = "";
		$data [3] ["currency"] = "";
		$data [3] ["prop_pass"] = "";
		$data [3] ["api_key"] = "";

		$data [4] ["dc_name"] = "HW";
		$data [4] ["dealer_id"] = "";
		$data [4] ["overbooking_category_id"] = "";
		$data [4] ["dc_hotel_id"] = "";
		$data [4] ["username"] = "";
		$data [4] ["general_update"] = "";
		$data [4] ["dc_id"] = "8";
		$data [4] ["eqc_user"] = "";
		$data [4] ["eqc_password"] = "";
		$data [4] ["currency"] = "";
		$data [4] ["prop_pass"] = "";
		$data [4] ["api_key"] = "";

		$data [5] ["dc_name"] = "OKTOGO";
		$data [5] ["dealer_id"] = "";
		$data [5] ["overbooking_category_id"] = "";
		$data [5] ["dc_hotel_id"] = "";
		$data [5] ["username"] = "";
		$data [5] ["general_update"] = "";
		$data [5] ["dc_id"] = "7";
		$data [5] ["eqc_user"] = "";
		$data [5] ["eqc_password"] = "";
		$data [5] ["currency"] = "";
		$data [5] ["prop_pass"] = "";
		$data [5] ["api_key"] = "";

		$data [6] ["dc_name"] = "101otel";
		$data [6] ["dealer_id"] = "";
		$data [6] ["overbooking_category_id"] = "";
		$data [6] ["dc_hotel_id"] = "";
		$data [6] ["username"] = "";
		$data [6] ["general_update"] = "";
		$data [6] ["dc_id"] = "9";
		$data [6] ["eqc_user"] = "";
		$data [6] ["eqc_password"] = "";
		$data [6] ["currency"] = "";
		$data [6] ["prop_pass"] = "";
		$data [6] ["api_key"] = "";

		// booking
		$sql = "SELECT * FROM `$db_name`.dc_booking_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [0] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [0] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [0] ["dc_hotel_id"] = $row->int_value;
						break;
					case "general_update" :
						$data [0] ["general_update"] = $row->int_value;
						break;
				}
			}
		} else {
		}

		// ostrovok
		$sql = "SELECT * FROM `$db_name`.dc_ostrovok_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [1] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [1] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [1] ["dc_hotel_id"] = $row->int_value;
						break;
					case "general_update" :
						$data [1] ["general_update"] = $row->int_value;
						break;
				}
			}
		}

		// expedia
		$sql = "SELECT * FROM `$db_name`.dc_expedia_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [2] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [2] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [2] ["dc_hotel_id"] = $row->int_value;
						break;
					case "general_update" :
						$data [2] ["general_update"] = $row->int_value;
						break;
					case "eqc_user" :
						$data [2] ["eqc_user"] = $row->str_value;
						break;
					case "eqc_password" :
						$data [2] ["eqc_password"] = $row->str_value;
						break;
					case "prop_pass" :
						$data [4] ["prop_pass"] = $row->str_value;
						break;
					case "currency" :
						$data [2] ["currency"] = $row->str_value;
						break;
				}
			}
		}

		// HsClub
		$sql = "SELECT * FROM `$db_name`.dc_hostelsclub_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [3] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [3] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [3] ["dc_hotel_id"] = $row->int_value;
						break;
					case "general_update" :
						$data [3] ["general_update"] = $row->int_value;
						break;
					case "eqc_user" :
						$data [3] ["eqc_user"] = $row->str_value;
						break;
					case "eqc_password" :
						$data [3] ["eqc_password"] = $row->str_value;
						break;
					case "prop_pass" :
						$data [4] ["prop_pass"] = $row->str_value;
						break;
					case "currency" :
						$data [3] ["currency"] = $row->str_value;
						break;
				}
			}
		}

		// HW
		$sql = "SELECT * FROM `$db_name`.dc_hostelworld_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [4] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [4] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [4] ["dc_hotel_id"] = $row->int_value;
						break;
					case "general_update" :
						$data [4] ["general_update"] = $row->int_value;
						break;
					case "eqc_user" :
						$data [4] ["eqc_user"] = $row->str_value;
						break;
					case "eqc_password" :
						$data [4] ["eqc_password"] = $row->str_value;
						break;
					case "prop_pass" :
						$data [4] ["prop_pass"] = $row->str_value;
						break;
					case "currency" :
						$data [4] ["currency"] = $row->str_value;
						break;
				}
			}
		}

		// OKTOGO
		$sql = "SELECT * FROM `$db_name`.dc_oktogo_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [5] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [5] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [5] ["dc_hotel_id"] = $row->int_value;
						break;
					case "username" :
						$data [5] ["username"] = $row->str_value;
						break;
					case "general_update" :
						$data [5] ["general_update"] = $row->int_value;
						break;
					case "eqc_user" :
						$data [5] ["eqc_user"] = $row->str_value;
						break;
					case "eqc_password" :
						$data [5] ["eqc_password"] = $row->str_value;
						break;
					case "prop_pass" :
						$data [5] ["prop_pass"] = $row->str_value;
						break;
					case "currency" :
						$data [5] ["currency"] = $row->str_value;
						break;
				}
			}
		}

		// OKTOGO
		$sql = "SELECT * FROM `$db_name`.dc_101otel_xml_cfg";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );

		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				switch ($row->name) {
					case "dealer_id" :
						$data [6] ["dealer_id"] = $row->int_value;
						break;
					case "overbooking_category_id" :
						$data [6] ["overbooking_category_id"] = $row->int_value;
						break;
					case "hotel_id" :
						$data [6] ["dc_hotel_id"] = $row->int_value;
						break;
					case "username" :
						$data [6] ["username"] = $row->str_value;
						break;
					case "general_update" :
						$data [6] ["general_update"] = $row->int_value;
						break;
					case "eqc_user" :
						$data [6] ["eqc_user"] = $row->str_value;
						break;
					case "eqc_password" :
						$data [6] ["eqc_password"] = $row->str_value;
						break;
					case "prop_pass" :
						$data [6] ["prop_pass"] = $row->str_value;
						break;
					case "currency" :
						$data [6] ["currency"] = $row->str_value;
						break;
					case "api_key" :
						$data [6] ["api_key"] = $row->str_value;
						break;
				}
			}
		}

		return $data;
	}
	function get_hotel_db($hotel_id) {
		$db_name = "";
		$sql = "SELECT db_name FROM config  WHERE config.id = " . $hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$db_name = $row->db_name;
		}
		return $db_name;
	}
	function insert_user($user, $hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );
		$pass = 'user03#sdfdsfa';
		$pass_md5 = md5 ( $pass );

		switch ($user) {
			case "info@otelms.com" :
				$firstname = "support";
				$lastname = "info";
				$restrictdelete = 0;
				$pass = 'M26kECaA3rRn97ye7Y';
				$pass_md5 = md5 ( $pass );
				break;
			case "support@otelms.com" :
				$firstname = "support";
				$lastname = "it";
				$restrictdelete = 1;
				$pass = 'empireimpact0309#';
				$pass_md5 = md5 ( $pass );
				break;
			default :
				$firstname = "user";
				$lastname = "user";
				$restrictdelete = 0;
				$pass_md5 = md5 ( $pass );
				break;
		}
		if ($db_name != "") {
			$sql = "SELECT id FROM `" . $db_name . "`.users WHERE login = '" . $user . "'";
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$sql = "UPDATE `" . $db_name . "`.users SET password = '" . $pass_md5 . "', is_active = 1, isAdministrator = 1, restrictdelete = " . $restrictdelete . ",
				fullname = '" . $firstname . "', lastname = '" . $lastname . "' WHERE login = '" . $user . "'";
				$query = $this->db->query ( $sql );
			} else {
				$sql = "INSERT INTO `" . $db_name . "`.users (login, password, is_active, isAdministrator, restrictdelete, fullname, lastname)
				VALUES('" . $user . "', '" . $pass_md5 . "', 1, 1, " . $restrictdelete . ", '" . $firstname . "', '" . $lastname . "')";
				$query = $this->db->query ( $sql );
			}

			return true;
		} else {
			return false;
		}
	}
	function activate_user($user, $hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );
		if ($db_name != "") {
			$sql = "UPDATE `" . $db_name . "`.users SET is_active = 1 WHERE login = '" . $user . "'";
			$query = $this->db->query ( $sql );
			return true;
		} else {
			return false;
		}
	}
	function deactivate_user($user, $hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );
		if ($db_name != "") {
			$sql = "UPDATE `" . $db_name . "`.users SET is_active = 0 WHERE login = '" . $user . "'";
			$query = $this->db->query ( $sql );
			return true;
		} else {
			return false;
		}
	}
	function set_unset_bup($hotel_id) {
		$sql = "SELECT bup FROM config  WHERE id = " . $hotel_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$bup = $row->bup;
			if ($bup == 0) {
				$bup = 1;
			} else {
				$bup = 0;
			}
			$sql = "UPDATE config SET bup = " . $bup . " WHERE id = " . $hotel_id;
			$query = $this->db->query ( $sql );
			return true;
		} else {
			return false;
		}
	}
	
	function set_2way_auth($hotel_id, $auth_value) {
	    $sql = "UPDATE config SET 2way_auth_mode = " . $auth_value . " WHERE id = " . $hotel_id;
	    $query = $this->db->query ( $sql );
	}
	
	function get_visitka_hotels_stats() {
		$hotels = array ();
		$sql = "SELECT visitka.config.*, visitka.users.company, visitka.users.userlastname, visitka.users.userfirstname, visitka.users.useremail   FROM visitka.config INNER JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url
				WHERE (config.id> 1890 OR config.id< 183 OR config.id IN (79, 109)) AND config.id NOT IN (116, 3810, 3811) AND config.bup=1  ORDER BY config.id DESC  ";
		$query = $this->db->query ( $sql );
		//die($sql);
		if ($query->num_rows () > 0) {
			$id_r = 1;

			$count_7d = 0;
			$count_90d = 0;
			$counter_90d = 0;

			foreach ( $query->result () as $row ) {
				$datefirst = "";
				$loger_count = 0;
				$last7count = 0;

				$last7count_activity = "0/";
				$all_activity = "0/";
				list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
				$date_last7 = floor ( mktime ( 0, 0, 0, $month, $day - 7, $year ) / 86400 );
				// echo $date_last7;
				$sql = "SELECT SUM(count_view) as sum_count_view FROM `" . $row->db_name . "`.activity WHERE intday > " . $date_last7;
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$last7count_activity = $row2->sum_count_view;
					if ($last7count_activity > 0) {
						$count_7d ++;
					}
				}

				$sql = "SELECT SUM(count_view) as sum_count_view FROM `" . $row->db_name . "`.activity WHERE 1";
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					if ($row2->sum_count_view != "")
						$all_activity = $row2->sum_count_view . "/";
				}

				$sql = "SELECT data FROM `" . $row->db_name . "`.loger ORDER BY id ASC LIMIT 0,1";
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$datefirst = $row2->data;
					$datefirst2 = $row2->data;
				}

				$sql = "SELECT intday FROM `" . $row->db_name . "`.activity ORDER BY intday ASC LIMIT 0,1";
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$datefirst = date ( "Y-m-d", $row2->intday * 86400 );
				}

				$sql = "SELECT count(1) as loger_count FROM `" . $row->db_name . "`.loger ";
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$loger_count = $row2->loger_count;
				}

				$sql = "SELECT count(1) as last7count FROM `" . $row->db_name . "`.loger WHERE data > DATE_SUB(CURDATE(), INTERVAL 7 day)";
				$query2 = $this->db->query ( $sql );
				if ($query2->num_rows () > 0) {
					$row2 = $query2->row ();
					$last7count = $row2->last7count;
					// if ($last7count > 0 ) {
					// $count_7d++;
					// }
				}

				$days = "";
				$counter_90d = "";

				if ($datefirst != "") {
					$temp = explode ( " ", $datefirst );
					list ( $year, $month, $day ) = explode ( "-", $temp [0] );
					$intdatefirst = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
					list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );

					$intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
					$int_temp = $intdatenow - $intdatefirst;
					$days = $int_temp;

					if ($days > 89) {
						$count_90d ++;
						$counter_90d = $count_90d;
					}
				}

				array_push ( $hotels, array (
						"hotel_id" => $row->id,
						"host" => $row->host,
						"db_name" => $row->db_name,
						"company" => $row->company,
						"datefirst" => $datefirst,
						"days" => $days,
						"counter_90d" => $counter_90d,
						"loger_count" => $loger_count,
						"last7count" => $last7count,

						"all_activity" => $all_activity,
						"last7count_activity" => $last7count_activity . "/",

						"user" => $row->userfirstname . " " . $row->userlastname,
						"email" => $row->useremail,
						"id_r" => $id_r
				) );
				$id_r ++;
			}
		}
		return array (
				"hotels" => $hotels,
				"count_90d" => $count_90d,
				"count_7d" => $count_7d
		);
	}
	function get_user_list($hotel_data) {
		$db_name = $hotel_data ["db_name"];
		$users = array ();
		if ($db_name != "") {
			$sql = "SELECT * FROM `" . $db_name . "`.users WHERE is_active = 1";
			$query = $this->db->query ( $sql );
			foreach ( $query->result () as $row ) {
				if ($row->chainallow == 1) {
					$chainallow_link = "<a
				name='modal' class='linkcliks_chainallow' user_id = '" . $row->id . "' hotel_id='" . $hotel_data ["hotel_id"] . "'
				href='#dialog'><span id='chainallow[" . $row->id . "]'>UnSet</span></a>";
				} else {
					$chainallow_link = "<a
				name='modal' class='linkcliks_chainallow' user_id = '" . $row->id . "'hotel_id='" . $hotel_data ["hotel_id"] . "'
				href='#dialog'><span id='chainallow[" . $row->id . "]'>Set</span></a>";
				}

				array_push ( $users, array (
						"id" => $row->id,
						"chainallow" => $row->chainallow,
						"chainid" => $row->chainid,
						"chain_unique" => $row->chain_unique,
						"login" => $row->login,
						"fullname" => $row->fullname,
						"lastname" => $row->lastname,
						"chainallow_link" => $chainallow_link
				) );
			}
		}
		return $users;
	}
	function get_logauthip_list($hotel_data) {
		$db_name = $hotel_data ["db_name"];
		$logauthip = array ();
		if ($db_name != "") {
			$sql = "SELECT logauthip.*, users.fullname, users.lastname, users.login FROM `" . $db_name . "`.logauthip INNER JOIN `" . $db_name . "`.users ON users.id = logauthip.id_user ORDER BY logauthip.id DESC LIMIT 0,200";
			$query = $this->db->query ( $sql );
			foreach ( $query->result () as $row ) {

				array_push ( $logauthip, array (
						"id" => $row->id,
						"ip" => $row->ip,
						"time" => $row->time,
						"login" => $row->login,
						"fullname" => $row->fullname,
						"lastname" => $row->lastname
				) );
			}
		}
		return $logauthip;
	}
	function get_activity_list($hotel_data) {
		$db_name = $hotel_data ["db_name"];
		$activity = array ();
		if ($db_name != "") {
			$sql = "SELECT activity.* FROM `" . $db_name . "`.activity ORDER BY intday DESC LIMIT 0,20";
			$query = $this->db->query ( $sql );
			foreach ( $query->result () as $row ) {

				array_push ( $activity, array (
						"date" => date ( "Y-m-d", $row->intday * 86400 ),
						"count_view" => $row->count_view,
						"count_edit" => $row->count_edit
				) );
			}
		}
		return $activity;
	}
	function set_chainallow($data) {
		$chainallow = 0;
		$db_name = $this->get_hotel_db ( $data ["hotel_id"] );
		$sql = "SELECT chainallow FROM `$db_name`.users WHERE id = " . $data ["user_id"];
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$chainallow = $row->chainallow;
		}

		if ($chainallow == 1) {
			$chainallow_new = 0;
		} else {
			$chainallow_new = 1;
		}
		$sql = "UPDATE `$db_name`.users SET chainallow = " . $chainallow_new . " WHERE id = " . $data ["user_id"];
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
	}
	function calculate_feadback_rate($rid) {
		$feadbacks = array ();
		$sql = "SELECT reviews.* FROM otelms_tripadvisor.reservations
		LEFT JOIN otelms_tripadvisor.reviews ON reviews.reservation_id = reservations.rid
		WHERE reservations.rid = $rid";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$i = 0;
			foreach ( $query->result () as $row ) {
				$feadbacks [$i] ["hotel_staff"] = $row->hotel_staff;
				$feadbacks [$i] ["hotel_service"] = $row->hotel_service;
				$feadbacks [$i] ["room_clean"] = $row->room_clean;
				$feadbacks [$i] ["comfort"] = $row->comfort;
				$feadbacks [$i] ["performence_price_ratio"] = $row->performence_price_ratio;
				$feadbacks [$i] ["hotel_location"] = $row->hotel_location;
				$feadbacks [$i] ["recomend_opinion"] = $row->recomend_opinion;
				$feadbacks [$i] ["hotel_positive"] = $row->hotel_positive;
				$feadbacks [$i] ["hotel_not_positive"] = $row->hotel_not_positive;
				$i ++;
			}
		}
		$hotel_staff = 0;
		$hotel_staff_count = 0;
		$hotel_service = 0;
		$hotel_service_count = 0;
		$room_clean = 0;
		$room_clean_count = 0;
		$comfort = 0;
		$comfort_count = 0;
		$performence_price_ratio = 0;
		$performence_price_ratio_count = 0;
		$hotel_location = 0;
		$hotel_location_count = 0;
		$recomend_opinion = 0;
		$bool = 0;
		for($i = 0; $i < count ( $feadbacks ); $i ++) {
			if ($feadbacks [$i] ["hotel_staff"] != 0) {
				$hotel_staff += $feadbacks [$i] ["hotel_staff"];
				$hotel_staff_count ++;
				$bool = 1;
			}
			if ($feadbacks [$i] ["hotel_service"] != 0) {
				$hotel_service += $feadbacks [$i] ["hotel_service"];
				$hotel_service_count ++;
				$bool = 1;
			}
			if ($feadbacks [$i] ["room_clean"] != 0) {
				$room_clean += $feadbacks [$i] ["room_clean"];
				$room_clean_count ++;
				$bool = 1;
			}
			if ($feadbacks [$i] ["comfort"] != 0) {
				$comfort = $feadbacks [$i] ["comfort"];
				$comfort_count ++;
				$bool = 1;
			}
			if ($feadbacks [$i] ["performence_price_ratio"] != 0) {
				$performence_price_ratio += $feadbacks [$i] ["performence_price_ratio"];
				$performence_price_ratio_count ++;
				$bool = 1;
			}
			if ($feadbacks [$i] ["hotel_location"] != 0) {
				$hotel_location += $feadbacks [$i] ["hotel_location"];
				$hotel_location_count ++;
				$bool = 1;
			}
			$recomend_opinion += $feadbacks [$i] ["recomend_opinion"];
		}
		$count_feadbacks = count ( $feadbacks );

		$data = array ();
		if ($bool != 0) {
			$data ["recomend_opinion"] = ($hotel_staff + $hotel_service + $room_clean + $comfort + $performence_price_ratio + $hotel_location) / ($hotel_location_count + $performence_price_ratio_count + $comfort_count + $room_clean_count + $hotel_service_count + $hotel_staff_count);
		} else {
			$data ["recomend_opinion"] = 0;
		}
		// $data["recomend_opinion"] = $recomend_opinion/$count_feadbacks;
		if ($hotel_staff_count != 0) {
			$data ["hotel_staff"] = $hotel_staff / $hotel_staff_count;
		} else {
			$data ["hotel_staff"] = 0;
		}
		if ($hotel_service_count != 0) {
			$data ["hotel_service"] = $hotel_service / $hotel_service_count;
		} else {
			$data ["hotel_service"] = 0;
		}
		if ($room_clean_count != 0) {
			$data ["room_clean"] = $room_clean / $room_clean_count;
		} else {
			$data ["room_clean"] = 0;
		}
		if ($comfort_count != 0) {
			$data ["comfort"] = $comfort / $comfort_count;
		} else {
			$data ["comfort"] = 0;
		}
		if ($performence_price_ratio_count != 0) {
			$data ["performence_price_ratio"] = $performence_price_ratio / $performence_price_ratio_count;
		} else {
			$data ["performence_price_ratio"] = 0;
		}
		if ($hotel_location_count != 0) {
			$data ["hotel_location"] = $hotel_location / $hotel_location_count;
		} else {
			$data ["hotel_location"] = 0;
		}

		return $data;
	}
	function inserttoxmlotelmst($data) {
		$host = "";
		$db_name = "";
		if (isset ( $data ["hotel_id"] )) {
			$sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $data ["hotel_id"];
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$host = $row->host;
				$db_name = $row->db_name;
			}
		}

		@$link = mysql_connect ( "xml.otelms.com", "xmluser", "user00" );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		mysql_select_db ( 'dc_booking', $link );
		// установки кодировки
		mysql_query ( 'SET NAMES utf8' );

		switch ($data ["id"]) {
			case 1 :
				$sql = "INSERT INTO `dc_booking`.hms_hotels (hotel_id, hms_url) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/dc_booking_gate/reservations')";
				mysql_query ( $sql, $link );
				break;
			case 2 :
				$sql = "INSERT INTO `dc_booking`.ostrovok_hms_hotels (hotel_id, hms_url) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/')";
				mysql_query ( $sql, $link );
				break;
			case 3 :
				$sql = "INSERT INTO `dc_booking`.expedia_hms_hotels (hotel_id, hms_url, host, db_name) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/', '" . $host . "', '" . $db_name . "')";
				// echo $sql;
				$query = $this->db->query ( $sql );
				break;
			case 4 :
				$sql = "INSERT INTO `dc_booking`.hsclub_hms_hotels (hotel_id, hms_url) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/reservations')";
				mysql_query ( $sql, $link );
				break;
			case 7 :
				$sql = "INSERT INTO `dc_booking`.oktogo_hms_hotels (hotel_id, hms_url) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/dc_oktogo_gate/reservations')";
				mysql_query ( $sql, $link );
				break;
			case 8 :
				$sql = "INSERT INTO `global_hotelix`.dc_hostelworld_hotels (hotelid, host, dbname) VALUES('" . $data ["dc_hotel_id"] . "', '" . $host . "', '" . $db_name . "')";
				// echo $sql;
				$query = $this->db->query ( $sql );
				break;
			case 9 :
				$sql = "INSERT INTO dc_booking.101otel_hms_hotels (hotel_id, hms_url) VALUES('" . $data ["dc_hotel_id"] . "', 'https://" . $host . "/dc_101otel_gate/reservations')";
				mysql_query ( $sql, $link );
				break;
		}

		// if ($data ["id"] == 3) {
		// echo "+++".$query;
		// } else {

		if (mysql_errno ()) {
			$error = "MySQL error " . mysql_errno () . ": " . mysql_error ();
			return "MySQL error " . mysql_errno () . ": " . mysql_error ();
		} else {
			return 1;
		}
		// }
	}
	function get_dc_rates_categories($data) {
		$host = "";
		$db_name = "";
		if (isset ( $data ["hotel_id"] )) {
			$sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $data ["hotel_id"];
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$host = $row->host;
				$db_name = $row->db_name;
			}
		}
		$result = "";
		$c_data = array ();

		if ($db_name != "") {
			switch ($data ["id"]) {
				case 1 :

					// rates

					$url = "https://" . $host . "/dc_booking_gate/get_rates_plans";
					// echo $url."<br>";
					$result .= $this->curl_model->CurlPlug ( $c_data, $url );
					// echo $result;

					// end rates

					// categories

					$url = "https://" . $host . "/dc_booking_gate/get_room_categories";
					// echo $url."<br>";
					$result .= $this->curl_model->CurlPlug ( $c_data, $url );
					// echo $result;

					// end categories
					// return 1;
					break;
				case 2 :

					// rates

					$url = "https://" . $host . "/dc_ostrovok_gate/get_rates_plans";
					// echo $url."<br>";
					$result .= $this->curl_model->CurlPlug ( $c_data, $url );
					// echo $result;

					// end rates

					// categories

					$url = "https://" . $host . "/dc_ostrovok_gate/get_room_categories";
					// echo $url."<br>";
					$result .= $this->curl_model->CurlPlug ( $c_data, $url );
					// echo $result;

					// end categories

					// occupancies

					$url = "https://" . $host . "/dc_ostrovok_gate/get_occupancies";
					$result .= $this->curl_model->CurlPlug ( $c_data, $url );
					// echo $result;

					// end occupancies
					// return 1;
					break;
			}
			// return 1;
			return $result;
		} else {
			// return 0;
		}
	}
	private function stdToArray($obj) {
		$rc = ( array ) $obj;
		foreach ( $rc as $key => &$field ) {
			if (is_object ( $field ))
				$field = $this->stdToArray ( $field );
		}
		return $rc;
	}
	function get_dc_booking_rates($dbname) {
		$rates = array ();
		$sql = "SELECT * FROM `$dbname`.dc_booking_rates WHERE 1";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $rates, array (
						"dc_id" => $row->dc_rate_id,
						"name" => $row->name
				) );
			}
		}
		return $rates;
	}
	function get_dc_booking_categories($dbname) {
		$rooms = array ();
		$sql = "SELECT * FROM `$dbname`.dc_booking_rooms_link WHERE 1";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $rooms, array (
						"dc_id" => $row->dc_room_id,
						"name" => $row->dc_room_name
				) );
			}
		}
		return $rooms;
	}
	function get_dc_ostrovok_rates($dbname) {
		$rates = array ();
		$sql = "SELECT * FROM `$dbname`.dc_ostrovok_rates WHERE 1";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $rates, array (
						"dc_id" => $row->rate_id,
						"name" => $row->name
				) );
			}
		}
		return $rates;
	}
	function get_dc_ostrovok_categories($dbname) {
		$rooms = array ();
		$sql = "SELECT * FROM `$dbname`.dc_ostrovok_room_categories WHERE 1";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $rooms, array (
						"dc_id" => $row->id,
						"name" => $row->name
				) );
			}
		}
		return $rooms;
	}
	function get_chain_list() {
		$chains = array ();

		$h_ids = array ();

		$sql = "SELECT global_chain_hotelix.chains.* FROM global_chain_hotelix.chains";
		// echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push ( $h_ids, array (
						"hotel_id" => $row->hotelid
				) );
			}
		}
		$count_h = count ( $h_ids );
		$select = "";
		$select .= " WHERE visitka.config.id IN (";
		for($i = 0; $i < $count_h; $i ++) {
			if ($i == ($count_h - 1)) {
				$select .= $h_ids [$i] ["hotel_id"] . " ";
			} else {
				$select .= $h_ids [$i] ["hotel_id"] . ", ";
			}
		}
		$select .= ") ";
		$hotels_names = array ();
		$sql = "SELECT visitka.config.id, visitka.users.company FROM visitka.config LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url " . $select . " ORDER BY config.id DESC ";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$id_r = 1;
			foreach ( $query->result () as $row ) {
				$hotels_names [$row->id] = $row->company;
			}
		}

		$sql = "SELECT * FROM `global_chain_hotelix`.chains WHERE 1 ";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$chains [$row->chainid] ["chainid"] = $row->chainid;
				$chains [$row->chainid] ["hotels"] [$row->hotelid] ["hotel_id"] = $row->hotelid;
				$chains [$row->chainid] ["hotels"] [$row->hotelid] ["host"] = $row->host;
				if (isset ( $hotels_names [$row->hotelid] )) {
					$chains [$row->chainid] ["hotels"] [$row->hotelid] ["hotel_name"] = $hotels_names [$row->hotelid];
				} else {
					$chains [$row->chainid] ["hotels"] [$row->hotelid] ["hotel_name"] = "";
				}
				// $get_user_data = array("db_name" => $row->db_name, "hotel_id" => $row->hotelid );
				// $chains[$row->chainid]["hotels"][$row->hotelid]["users"] = $this->get_user_list ( $get_user_data );
			}
		}
		return $chains;
	}
	function get_dc_booking_list() {
		$booking_hotels = array ();
		$sql = "SELECT * FROM `global_hotelix`.dc_booking_hotels WHERE 1";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ($query->result_array() as $row)
			{
				array_push ( $booking_hotels, $row );
			}
		}
		return $booking_hotels;
	}
	function get_dc_log($hotel_id = 0, $db_name = "", $type = "a", $host = "") {
		$hotels_log = array ();


		if($hotel_id <> 0){
			$hotels_log[$hotel_id]["hotel_id"] = $hotel_id;
			if ($type == "a" or $type == "l") {
			    $hotels_log[$hotel_id]["log_updatetime"] = "-";
			    $hotels_log[$hotel_id]["log_inserttime"] = "-";
			}
			if ($type == "a" or $type == "r") {
			    $hotels_log[$hotel_id]["log_rate_updatetime"] = "-";
			    $hotels_log[$hotel_id]["log_rate_inserttime"] = "-";
			}
			if ($type == "a" or $type == "y") {
			    $hotels_log[$hotel_id]["log_yield_updatetime"] = "-";
			    $hotels_log[$hotel_id]["log_yield_inserttime"] = "-";
			}
			if ($type == "a" or $type == "restrict") {
				$hotels_log[$hotel_id]["log_restrict_updatetime"] = "-";
				$hotels_log[$hotel_id]["log_restrict_inserttime"] = "-";
			}


		}

		$select = "";
		if($hotel_id <> 0){
			$select .=" hotelid = ".$hotel_id." ";
		}else{
			$select .=" 1 ";
		}

		if ($type == "a" or $type == "r") {
		$sql = "SELECT * FROM `global_hotelix`.dc_log_rate_semafor WHERE " . $select;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ($query->result() as $row)
			{
				$updatetime = date("Y-m-d H:i:s", $row->updatetime);
				$inserttime = date("Y-m-d H:i:s", $row->inserttime);
				$hotels_log[$row->hotelid]["hotel_id"] = $row->hotelid;
				$hotels_log[$row->hotelid]["log_rate_updatetime"] = $updatetime;
				$hotels_log[$row->hotelid]["log_rate_inserttime"] = $inserttime;
			}
		}
		}

		if ($type == "a" or $type == "l") {
		$sql = "SELECT * FROM `global_hotelix`.dc_log_semafor WHERE " . $select;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ($query->result() as $row)
			{
				$updatetime = date("Y-m-d H:i:s", $row->updatetime);
				$inserttime = date("Y-m-d H:i:s", $row->inserttime);
				$hotels_log[$row->hotelid]["hotel_id"] = $row->hotelid;
				$hotels_log[$row->hotelid]["log_updatetime"] = $updatetime;
				$hotels_log[$row->hotelid]["log_inserttime"] = $inserttime;
			}
		}
		}

		if ($type == "a" or $type == "y") {
		$sql = "SELECT * FROM `global_hotelix`.dc_log_yield_semafor WHERE " . $select;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ($query->result() as $row)
			{
				$updatetime = date("Y-m-d H:i:s", $row->updatetime);
				$inserttime = date("Y-m-d H:i:s", $row->inserttime);
				$hotels_log[$row->hotelid]["hotel_id"] = $row->hotelid;
				$hotels_log[$row->hotelid]["log_yield_updatetime"] = $updatetime;
				$hotels_log[$row->hotelid]["log_yield_inserttime"] = $inserttime;
			}
		}
		}

		if ($type == "a" or $type == "restrict") {
			$sql = "SELECT * FROM `global_hotelix`.dc_log_restrict_semafor WHERE " . $select;
			//echo $sql."<br>";
			$query = $this->db->query ( $sql );
			if ($query->num_rows () > 0) {
				foreach ($query->result() as $row)
				{
					$updatetime = date("Y-m-d H:i:s", $row->updatetime);
					$inserttime = date("Y-m-d H:i:s", $row->inserttime);
					$hotels_log[$row->hotelid]["hotel_id"] = $row->hotelid;
					$hotels_log[$row->hotelid]["log_restrict_updatetime"] = $updatetime;
					$hotels_log[$row->hotelid]["log_restrict_inserttime"] = $inserttime;
				}
			}
		}

		if($hotel_id <> 0){
			$dc_log_syn = $this->get_dc_log_sync($hotel_id, $db_name, $type, $host);
			//echo $hotel_id." ".$type." ".$host;
			//print_r($dc_log_syn);
			if ($type == "a" or $type == "l") {
				$hotels_log[$hotel_id]["log_count"] = $dc_log_syn["log_count"];
				$hotels_log[$hotel_id]["channels_list"] = $dc_log_syn["channels_list"];
				$hotels_log[$hotel_id]["log_channels_ids"] = $dc_log_syn["log_channels_ids"];
			}
			if ($type == "a" or $type == "r") {
				$hotels_log[$hotel_id]["log_rate_count"] = $dc_log_syn["log_rate_count"];
				$hotels_log[$hotel_id]["channels_list"] = $dc_log_syn["channels_list"];
				$hotels_log[$hotel_id]["log_channels_ids"] = $dc_log_syn["log_channels_ids"];
			}
			if ($type == "a" or $type == "y") {
				$hotels_log[$hotel_id]["log_yield_count"] = $dc_log_syn["log_yield_count"];
				$hotels_log[$hotel_id]["channels_list"] = $dc_log_syn["channels_list"];
				$hotels_log[$hotel_id]["log_channels_ids"] = $dc_log_syn["log_channels_ids"];
			}
			if ($type == "a" or $type == "restrict") {
				$hotels_log[$hotel_id]["log_restrict_count"] = $dc_log_syn["log_restrict_count"];
				$hotels_log[$hotel_id]["channels_list"] = $dc_log_syn["channels_list"];
				$hotels_log[$hotel_id]["log_channels_ids"] = $dc_log_syn["log_channels_ids"];
			}
		}

		return $hotels_log;
	}
	function get_channels_names (){
		$channels = array();
		$channels[1] = "Booking";
		$channels[2] = "Ostrovok";
		$channels[3] = "Expedia";
		$channels[4] = "HsClub";
		$channels[5] = "Agoda";
		$channels[6] = "Hotel-Inn";
		$channels[7] = "Oktogo";
		$channels[8] = "HW";
		$channels[9] = "101Otel";
		//$channels[10] = "Wubook";
		$channels[11] = "HRS";
		$channels[12] = "Vashotel";
		$channels[13] = "Bronevik";
		$channels[14] = "Hotels24";
		$channels[15] = "Ozon";
		$channels[16] = "Tripadvisor";
		$channels[17] = "Hotelbook";
		$channels[18] = "Eholiday";
		$channels[19] = "Dobovo";
		$channels[20] = "Dorms";
		$channels[21] = "C-booking";
		$channels[22] = "Airbnb";
		$channels[23] = "Roomp";
		$channels[24] = "AxisTravel";
		$channels[25] = "OneTwoTrip";
		$channels[26] = "Tvil";
		$channels[27] = "AcademService";
		$channels[28] = "A&A";
		$channels[29] = "Nash Travel";
		$channels[30] = "Sutochno";		
		$channels[31] = "Google";
		$channels[33] = "101hotels";
		$channels[34] = "Ctrip";
		$channels[35] = "-35-";
		$channels[36] = "Ya";
		return $channels;
		
	}
	function get_channels_indclog($log_channels){
		$channels = $this->get_channels_names();
		$channels_list_str = "";
		foreach($log_channels as $dc_id){
			if(isset($channels[$dc_id])){
				$channels_list_str .= $channels[$dc_id]."($dc_id), ";
			}
		}
		$channels_list_str = substr($channels_list_str, 0, strlen($channels_list_str)-2);
		return $channels_list_str;
	}

    function get_dc_log_sync($hotel_id = 0, $db_name = "", $type = "a", $host = "")
    {
        $return_data = array();
        if ($db_name != "") {
            $sql_m = "SHOW DATABASES LIKE '$db_name'";
            $query_m = $this->db->query($sql_m);
            if ($query_m->num_rows() > 0) {
                if ($type == "a" or $type == "l") {
                    $sql = "SELECT * FROM `" . $db_name . "`.dc_log WHERE 1 GROUP BY intdate";
                    //echo $sql;
                    $query = $this->db->query($sql);
                    $return_data["log_count"] = $query->num_rows();
                    
                    $log_channels = array();
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $row) {
                            $log_channels[$row->dc_id] = $row->dc_id;
                        }
                    }
                    $return_data["channels_list"] = $this->get_channels_indclog($log_channels);
                    $return_data["log_channels_ids"] = $log_channels;
                }
                
                if ($type == "a" or $type == "r") {
                    $sql = "SELECT * FROM `" . $db_name . "`.dc_log_rate WHERE 1 GROUP BY intdate";
                    $query = $this->db->query($sql);
                    $return_data["log_rate_count"] = $query->num_rows();
                    $return_data["log_count"] = $query->num_rows();
                    $log_channels = array();
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $row) {
                            $log_channels[$row->dc_id] = $row->dc_id;
                        }
                    }
                    $return_data["channels_list"] = $this->get_channels_indclog($log_channels);
                    $return_data["log_channels_ids"] = $log_channels;
                }
                
                if ($type == "a" or $type == "y") {
                    $sql = "SELECT * FROM `" . $db_name . "`.dc_log_yieldprice WHERE 1 GROUP BY intdate";
                    $query = $this->db->query($sql);
                    $return_data["log_yield_count"] = $query->num_rows();
                    $return_data["log_count"] = $query->num_rows();
                    $log_channels = array();
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $row) {
                            $log_channels[$row->dc_id] = $row->dc_id;
                        }
                    }
                    $return_data["channels_list"] = $this->get_channels_indclog($log_channels);
                    $return_data["log_channels_ids"] = $log_channels;
                }
                
                if ($type == "a" or $type == "restrict") {
                    $sql = "SELECT * FROM `" . $db_name . "`.dc_log_restrict WHERE 1 GROUP BY intdate";
                    $query = $this->db->query($sql);
                    $return_data["log_restrict_count"] = $query->num_rows();
                    $return_data["log_count"] = $query->num_rows();
                    $log_channels = array();
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $row) {
                            $log_channels[$row->dc_id] = $row->dc_id;
                        }
                    }
                    $channels_str = $this->get_channels_indclog($log_channels);
                    // echo $channels_str."<br>";
                    $channels_array = explode(", ", $channels_str);
                    
                    $channels_names = $this->get_channels_names();
                    
                    $channels_str_new = "";
                    if (isset($channels_array[0])) {
                        foreach ($channels_array as $dc_channel_name) {
                            $dc_id = 0;
                            foreach ($channels_names as $dc_id_func => $channels_name_func) {
                                if ($channels_name_func == $dc_channel_name) {
                                    $dc_id = $dc_id_func;
                                    break;
                                }
                            }
                            $upload_restrict_link = '<a target="_blank" href="https://' . $host . '/dc_cron/upload_restrict_lastchanged/' . $dc_id . '/' . $db_name . '">' . $dc_channel_name . '</a>';
                            
                            $channels_str_new .= $upload_restrict_link . ", ";
                        }
                    }
                    
                    $return_data["channels_list"] = $channels_str_new;
                    $return_data["log_channels_ids"] = $log_channels;
                }
            }else{
                //echo $db_name."<br>";
                $return_data["log_restrict_count"] = -1;
                $return_data["log_rate_count"] = -1;
                $return_data["log_yield_count"] = -1;
                $return_data["log_count"] = -1;
                $return_data["channels_list"] = array();
                $return_data["log_channels_ids"] = array();
            }
        }
        return $return_data;
	}
	function get_chain_detailslist($chain_id) {
		$hotels = array ();
		$sql = "SELECT * FROM `global_chain_hotelix`.chains WHERE chainid = " . $chain_id;
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$get_user_data = array (
						"db_name" => $row->db_name,
						"hotel_id" => $row->hotelid
				);
				$users = $this->get_user_list ( $get_user_data );
				foreach ( $users as $i => $cell ) {
					if ($cell ["chainid"] == $chain_id && $cell ["chainallow"] == 1) {
						$users [$i] ["checked"] = "checked";
					} else {
						$users [$i] ["checked"] = "";
					}
				}
				array_push ( $hotels, array (
						"hotel_id" => $row->hotelid,
						"host" => $row->host,
						"users" => $users
				) );
			}
		}
		return $hotels;
	}
	function add_chain($data) {
		if (isset ( $data ["chainid"] )) {
			if ($data ["chainid"] != "" and $data ["chainid"] != 0) {
				$sql = "INSERT INTO `global_chain_hotelix`.chains (chainid) VALUES('" . $data ["chainid"] . "')";
				// echo $sql."<br>";
				$query = $this->db->query ( $sql );
			}
		}
	}
	function add_group($data) {
		if ($data ["groupid"] != "" and $data ["groupid"] != 0) {
			$booking_host = "46.23.72.66";
			$booking_user = "rbooking";
			$booking_pass = "ghtcnj23";
			@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
			if (! $link) {
				return 'Could not connect: ' . mysql_error ();
				// die ( 'Could not connect: ' . mysql_error () );
			}
			// выбор базы даных
			mysql_select_db ( 'booking_otelms', $link );
			// установки кодировки
			mysql_query ( 'SET NAMES utf8' );
			$sql = "INSERT INTO personal_groups_widget (groupid, hotelid) VALUES('" . $data ["groupid"] . "', '" . $data ["hotel_id"] . "')";
			$result = mysql_query ( $sql, $link );

			mysql_close ( $link );
		}
	}
	function add_chainhotel($hotel_id, $chainid) {
		if ($chainid != "" and $chainid != 0) {
			$query = $this->db->query ( "SELECT * FROM visitka.config WHERE id = " . $hotel_id );

			if ($query->num_rows () > 0) {
				$row = $query->row ();
				$host = $row->host;
				$db_name = $row->db_name;
			}
			$sql = "INSERT INTO `global_chain_hotelix`.chains (chainid, hotelid, db_name, host) VALUES('" . $chainid . "', '" . $hotel_id . "', '" . $db_name . "', '" . $host . "')";
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );
		}
	}
	function delete_chain($chainid) {
		if ($chainid != "" and $chainid != 0) {
			$sql = "DELETE FROM `global_chain_hotelix`.chains WHERE chainid = " . $chainid;
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );
		}
	}
	function delete_group($group_id) {
		if ($group_id != "" and $group_id != 0) {
			$booking_host = "46.23.72.66";
			$booking_user = "rbooking";
			$booking_pass = "ghtcnj23";
			@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
			if (! $link) {
				return 'Could not connect: ' . mysql_error ();
				// die ( 'Could not connect: ' . mysql_error () );
			}
			// выбор базы даных
			mysql_select_db ( 'booking_otelms', $link );
			// установки кодировки
			mysql_query ( 'SET NAMES utf8' );
			$data = array ();
			$sql = "DELETE FROM personal_groups_widget WHERE groupid = " . $group_id;

			$result = mysql_query ( $sql, $link );

			mysql_close ( $link );
		}
	}
	function delete_group_hotel($group_id, $hotel_id) {
		if ($group_id != "" and $group_id != 0) {
			$booking_host = "46.23.72.66";
			$booking_user = "rbooking";
			$booking_pass = "ghtcnj23";
			@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
			if (! $link) {
				return 'Could not connect: ' . mysql_error ();
				// die ( 'Could not connect: ' . mysql_error () );
			}
			// выбор базы даных
			mysql_select_db ( 'booking_otelms', $link );
			// установки кодировки
			mysql_query ( 'SET NAMES utf8' );
			$data = array ();
			$sql = "DELETE FROM personal_groups_widget WHERE groupid = " . $group_id . " AND hotelid = " . $hotel_id;

			$result = mysql_query ( $sql, $link );

			mysql_close ( $link );
		}
	}
	function add_chainhotel_delete($hotel_id, $chainid) {
		if ($chainid != "" and $chainid != 0) {
			$sql = "DELETE FROM `global_chain_hotelix`.chains WHERE chainid = " . $chainid . " AND hotelid = " . $hotel_id;
			// echo $sql."<br>";
			$query = $this->db->query ( $sql );
		}
	}
	function export_crm($hotel_id) {
		$hotel_data = $this->Admin_model->get_visitka_hotel ( $hotel_id );
		//echo "<pre>";
		//print_r ( $hotel_data );
		// die();
		$link = mysqli_connect ( "st-crm.otelms.com", "xmluser", "user00", 'st-crm' );
		if (! $link) {
		    return 'Could not connect: ' . mysqli_error ($link);
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		
		mysqli_query ($link,  'SET NAMES utf8' );
		$hmsID_bool = 0;
		$result = mysqli_query ( $link, "SELECT id FROM `st-crm`.leads WHERE hmsID = " . $hotel_id );

		while ( $row = mysqli_fetch_array ( $result , MYSQLI_ASSOC) ) {
			$hmsID_bool = 1;
			$lead_id = $row ["id"];
			break;
		}

		if ($hmsID_bool == 0) {
			$sql = "INSERT INTO `st-crm`.leads (name, contactname, hmsID, email, hms_url) VALUES('" . addslashes($hotel_data ["company"]) . "', '" . $hotel_data ["user"] . "', '" . $hotel_id . "', '" . $hotel_data ["email"] . "', '" . $hotel_data ["host"] . "')";
		} else {
			$sql = "UPDATE `st-crm`.leads SET contactname = '" . $hotel_data ["user"] . "', name =  '" . addslashes($hotel_data ["company"]) . "', email = '" . $hotel_data ["email"] . "', hms_url = '" . $hotel_data ["host"] . "' WHERE hmsID = $hotel_id";
		}
		//echo $sql;
		mysqli_query ( $link, $sql  );

		if (mysqli_errno ($link)) {
		    $error = "MySQL error " . mysqli_errno ($link) . ": " . mysqli_error ($link);
		    return "MySQL error " . mysqli_errno ($link) . ": " . mysqli_error ($link);
		} else {
			if ($hmsID_bool != 1) {
			    $lead_id = mysqli_insert_id ($link);
			}

			$sql = "INSERT INTO `st-crm`.lead_emails (leadID, email) VALUES('" . $lead_id . "', '" . $hotel_data ["email"] . "')";
			mysqli_query ( $link, $sql);
			$sql = "INSERT INTO `st-crm`.lead_phones (leadID, phone_num) VALUES('" . $lead_id . "', '" . $hotel_data ["phone"] . "')";
			mysqli_query ( $link, $sql);
		}
	}
	function export_all() {
		$query = $this->db->query ( "SELECT id FROM config" );

		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$this->export_crm ( $row->id );
			}
		}
	}
	function users_set_chains($data, $chainid) {
		foreach ( $data ["hotel_id"] as $key => $hotel_id ) {
			$db_name = $this->get_hotel_db ( $hotel_id );

			/*
			 * SET CHAIN OPTION
			 */
			if (isset ( $data ["user_chain_set"] [$hotel_id] )) {
				$user_array = $data ["user_chain_set"] [$hotel_id];
				if ($db_name != "") {
					$sql = "UPDATE `" . $db_name . "`.users SET chainallow = 0 WHERE chainid = " . $chainid;
					$query = $this->db->query ( $sql );
					for($i = 0; $i < count ( $user_array ); $i ++) {
						$sql = "UPDATE `" . $db_name . "`.users SET chainallow = 1, chainid = " . $chainid . " WHERE id = " . $user_array [$i];
						$query = $this->db->query ( $sql );
					}
				}
			} else {
				if ($db_name != "") {
					$sql = "UPDATE `" . $db_name . "`.users SET chainallow = 0 WHERE chainid = " . $chainid;
					$query = $this->db->query ( $sql );
				}
			}

			/*
			 * SET CHAIN UNIQUE
			 */
			foreach ( $data ["user_chain_unique"] [$hotel_id] as $user_id => $value ) {
				if (trim ( $value [0] ) != "") {
					$sql = "UPDATE `" . $db_name . "`.users SET chain_unique = '" . $value [0] . "' WHERE id = " . $user_id;
					$query = $this->db->query ( $sql );
				}
			}
		}
	}
	
	function get_personal_data($hotel_id, $personal_id = 0) {
	    return $data;
		$booking_host = "46.23.72.66";
		$booking_user = "rbooking";
		$booking_pass = "ghtcnj23";
		@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
		
		
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		mysql_select_db ( 'booking_otelms', $link );
		// установки кодировки
		mysql_query ( 'SET NAMES utf8' );
		$data = array ();
		$personal_id_select = "";
		if ($personal_id != 0) {
			$personal_id_select .= " AND id = " . $personal_id;
		}
		$sql = "SELECT * FROM personal WHERE hotel_id = " . $hotel_id . $personal_id_select;

		$result = mysql_query ( $sql, $link );
		while ( $row = mysql_fetch_array ( $result ) ) {
			if($row ["logo_link_type"] == 0){
				$checked_logo_link_type = "";
			}else{
				$checked_logo_link_type = "checked";
			}
			array_push ( $data, array (
					"personal_id" => $row ["id"],
					"hotel_id" => $row ["hotel_id"],
					"host" => $row ["host"],
					"inlinestyle" => $row ["inlinestyle"],
			        "view_style" => $row ["view_style"],
					"showloaddesk" => $row ["showloaddesk"],
					"favicon" => $row ["favicon"],
					"templatetype" => $row ["templatetype"],
					"checked_logo_link_type" => $checked_logo_link_type,
					"logo_link" => $row ["logo_link"],
					"home_logo" => $row ["home_logo"],
					"header_name" => $row ["header_name"],
					"footer_name" => $row ["footer_name"],
					"mobile_logo" => $row ["mobile_logo"],
					"email_logo" => $row ["email_logo"],
					"css" => $row ["css"],
					"analitycs" => $row ["analitycs"],
			) );
		}
		mysql_close ( $link );
		return $data;
	}
	
	
	function update_personal_data($hotel_id, $personal_id, $data) {
		$booking_host = "46.23.72.66";
		$booking_user = "rbooking";
		$booking_pass = "ghtcnj23";
		@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		mysql_select_db ( 'booking_otelms', $link );
		// установки кодировки
		mysql_query ( 'SET NAMES utf8' );
		if(isset($data ["logo_link_type"])){
			$logo_link_type = 1;
		}else{
			$logo_link_type = 0;
		}
		$sql = "UPDATE personal SET analitycs = '" . mysql_real_escape_string($data ["analitycs"]) . "', favicon = '" . $data ["favicon"] . "', showloaddesk = '" . $data ["showloaddesk"] . "',
		    inlinestyle = '" . $data ["inlinestyle"] . "',
		        view_style = '" . $data ["view_style"] . "',
		        css = '" . $data ["css"] . "', logo_link = '" . $data ["logo_link"] . "', logo_link_type = '" . $logo_link_type . "',
				templatetype = '" . $data ["templatetype"] . "', header_name = '" . $data ["header_name"] . "',
				footer_name = '" . $data ["footer_name"] . "',home_logo = '" . $data ["home_logo"] . "',mobile_logo = '" . $data ["mobile_logo"] . "',
				email_logo = '" . $data ["email_logo"] . "' WHERE hotel_id = " . $hotel_id . " AND id = " . $personal_id;
		// echo $sql;
		// die();
		$result = mysql_query ( $sql, $link );
		mysql_close ( $link );
	}
	function make_personal($data, $hotel_id) {
		if (isset ( $data ["host"] )) {
			$booking_host = "46.23.72.66";
			$booking_user = "rbooking";
			$booking_pass = "ghtcnj23";
			@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
			if (! $link) {
				return 'Could not connect: ' . mysql_error ();
				// die ( 'Could not connect: ' . mysql_error () );
			}
			// выбор базы даных
			mysql_select_db ( 'booking_vhost', $link );
			// установки кодировки
			mysql_query ( 'SET NAMES utf8' );

			$sql = "INSERT INTO vhostlist (id, vhost) VALUES(" . $hotel_id . ", '" . str_replace ( ".otelms.com", "", $data ["host"] ) . "')";
			// echo $sql."<br>";
			mysql_query ( $sql, $link );

			mysql_close ( $link );
		}
	}

	function make_fr_online($data, $hotel_id) {
// 	    echo "+++";
// 	    print_r($data);
		if (isset ( $data ["host"] )) {
			$booking_host = "FR-ONLINE-BOOKING.OTELMS.COM";
			$booking_user = "rbooking";
			$booking_pass = "ghtcnj23";
			@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
			if (! $link) {
				//return 'Could not connect: ' . mysql_error ();
				 die ( 'Could not connect: ' . mysql_error () );
			}
			// выбор базы даных
			mysql_select_db ( 'booking_vhost', $link );
			// установки кодировки
			mysql_query ( 'SET NAMES utf8' );

			$sql = "INSERT INTO vhostlist (id, vhost) VALUES(" . $hotel_id . ", '" . str_replace ( ".otelms.com", "", $data ["host"] ) . "')";
			// echo $sql."<br>";
			mysql_query ( $sql, $link );

			mysql_close ( $link );
		}

	}

	function get_widget_groups_list() {
		$widget_groups = array ();
		$hotels_names = array ();
		$booking_host = "46.23.72.66";
		$booking_user = "rbooking";
		$booking_pass = "ghtcnj23";
		@$link = mysql_connect ( $booking_host, $booking_user, $booking_pass );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		mysql_select_db ( 'booking_otelms', $link );
		// установки кодировки
		mysql_query ( 'SET NAMES utf8' );
		$data = array ();
		$sql = "SELECT * FROM personal_groups_widget ORDER BY groupid ASC";

		$result = mysql_query ( $sql, $link );
		while ( $row = mysql_fetch_array ( $result ) ) {

			array_push ( $data, array (
					"hotel_id" => $row ["hotelid"],
					"group_id" => $row ["groupid"]
			) );
		}
		mysql_close ( $link );

		$count_h = count ( $data );
		$select = "";
		$select .= " WHERE visitka.config.id IN (";
		for($i = 0; $i < $count_h; $i ++) {
			if ($i == ($count_h - 1)) {
				$select .= $data [$i] ["hotel_id"] . " ";
			} else {
				$select .= $data [$i] ["hotel_id"] . ", ";
			}
		}
		$select .= ") ";

		$sql = "SELECT visitka.config.id, visitka.config.host, visitka.users.company FROM visitka.config LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url " . $select . " ORDER BY config.id DESC ";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$id_r = 1;
			foreach ( $query->result () as $row ) {
				$hotels_names [$row->id] ["hotel_name"] = $row->company;
				$hotels_names [$row->id] ["host"] = $row->host;
			}
		}
		$result_array = array ();
		for($i = 0; $i < $count_h; $i ++) {
			$hotel_id = $data [$i] ["hotel_id"];
			if (isset ( $hotels_names [$hotel_id] )) {
				$result_array [$data [$i] ["group_id"]] ["groupid"] = $data [$i] ["group_id"];
				$result_array [$data [$i] ["group_id"]] ["hotels"] [$i] ["hotel_name"] = $hotels_names [$hotel_id] ["hotel_name"];
				$result_array [$data [$i] ["group_id"]] ["hotels"] [$i] ["host"] = $hotels_names [$hotel_id] ["host"];
				$result_array [$data [$i] ["group_id"]] ["hotels"] [$i] ["hotel_id"] = $data [$i] ["hotel_id"];
			}
		}

		return $result_array;
	}
	function set_dc_cron_rate($hotel_id) {
		$sql = "UPDATE config SET dc_cron_rate = 1 WHERE id = " . $hotel_id;
		$query = $this->db->query ( $sql );
	}

	function set_hotel_state($hotel_id, $state_id) {
		$sql = "UPDATE config SET hotelstateid = $state_id WHERE id = " . $hotel_id;
		$query = $this->db->query ( $sql );
	}

	function get_hotel_state_data($hotel_id) {
		$sql = "SELECT hotelstateid as id, t2.name
				FROM config as t1
				JOIN hotelstates as t2 ON t2.id = t1.hotelstateid
				WHERE t1.id = $hotel_id";
		$query = $this->db->query ( $sql );
		return $query->row_array();
	}

	function set_reg_state($user_id, $state_id) {
		$sql = "UPDATE users SET regstateid = $state_id WHERE id = " . $user_id;
		$query = $this->db->query ( $sql );
	}

	function unset_dc_cron_rate($hotel_id) {
		$sql = "UPDATE config SET dc_cron_rate = 0 WHERE id = " . $hotel_id;
		$query = $this->db->query ( $sql );
	}

	function save_site_address($data){
		$sql = "UPDATE users SET site_address = '".$data["site_address"]."' WHERE id = " . $data["id_user"];
		//echo $sql;
		//die();
		$query = $this->db->query ( $sql );
	}
	function get_hotelix_payments_555(){
		$hotels = array ();
		$sql = "SELECT visitka.config.*, visitka.users.company, visitka.users.userlastname, visitka.users.userfirstname, visitka.users.useremail   FROM visitka.config INNER JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url
				WHERE (config.id> 1890 OR config.id< 183 OR config.id IN (79, 109)) AND config.id NOT IN (116, 3810, 3811) AND config.bup=1  ORDER BY config.id DESC  ";
		$query = $this->db->query ( $sql );
		//die($sql);
		if ($query->num_rows () > 0) {
			$id_r = 1;

			foreach ( $query->result () as $row ) {
				array_push ( $hotels, array (
				"hotel_id" => $row->id,
				"host" => $row->host,
				"db_name" => $row->db_name,
				"id_r" => $id_r
				) );
				$id_r ++;
			}
		}

		$count_hotels = count($hotels);

		$payments = array();
		for($i = 0; $i <= $count_hotels; $i++){
			if (trim ( $hotels [$i] ["db_name"] ) != "") {
				$db_name = $hotels [$i] ["db_name"];
				$payment_type = 0;
				$query = $this->db->query ( "SELECT value FROM `$db_name`.hotelix_config WHERE name LIKE 'uniteller_pay_type'" );

				if ($query->num_rows () > 0) {
					$row = $query->row ();
					$payment_type = $row->value;
				}

				$sql = "SELECT * FROM `$db_name`.payment WHERE 1 LIMIT 0, 2";
				$query = $this->db->query ( $sql );
				if ($query->num_rows () > 0) {
					foreach ( $query->result () as $row ) {
						if($row->type == $payment_type){
							$uniteller_pay = "UNITELLER";
						}else{
							$uniteller_pay = "";
						}
						array_push ( $payments, array (
								"hms_id" => $hotels [$i] ["hotel_id"],
								"reservation_id" => $row->reservation_id,
								"uniteller_pay" => $uniteller_pay
						) );
					}
				}
			}
		}

		return $payments;
	}

	function get_hotelix_payments(){
		@$link = mysql_connect ( "xml.otelms.com", "xmluser", "user00" );
		if (! $link) {
			return 'Could not connect: ' . mysql_error ();
			// die ( 'Could not connect: ' . mysql_error () );
		}
		// выбор базы даных
		$db_selected = mysql_select_db('uniteller_otelms', $link);
		if (!$db_selected) {
			die ('Не удалось выбрать базу uniteller_otelms: ' . mysql_error());
		}
		// установки кодировки
		mysql_query ( 'SET NAMES utf8' );

		$payments = array();
		$sql = "SELECT uni_push.*, uni_sync.rawpost, uni_sync.hms_response FROM `uniteller_otelms`.uni_push
		INNER JOIN `uniteller_otelms`.uni_sync ON uni_sync.push_id = uni_push.id ORDER by uni_push.id DESC";

		$result = mysql_query ( $sql, $link );
		$num_rows = mysql_num_rows($result);
		for ($c=0; $c < $num_rows; $c++){
			$f = mysql_fetch_array($result);
			$bool_count = substr_count($f["hms_response"], 'paymentOK');
			if($bool_count == 0){
				$f["pay_link"] = '<a href="/admin/set_pay/'.$f["id"].'">Оплатить</a>';
			}else{
				$f["pay_link"] = '';
			}
			array_push($payments, $f);
		}
		mysql_close($link);

		return $payments;
	}
	function get_users(){
		$access_pages = $this->get_access_pages();
		$users = array ();
		$sql = "SELECT admin_users.*, visitka.access.* FROM visitka.admin_users
				LEFT JOIN visitka.access ON visitka.access.userid = visitka.admin_users.id ORDER by login, page ASC";
		$query = $this->db->query ( $sql );
		//die($sql);
		if ($query->num_rows () > 0) {
			$id_r = 1;

			foreach ( $query->result () as $row ) {
				$users[$row->id]["login"] = $row->login;
				$users[$row->id]["user_id"] = $row->id;
				$users[$row->id]["id_r"] = $id_r;

				$count_pages = count($access_pages);
				for($i = 0; $i < $count_pages; $i++){
					$users[$row->id]["pages"][$i]["page_name"] = $access_pages[$i]["page"];
					$users[$row->id]["pages"][$i]["edit"] = "Нет";
					$users[$row->id]["pages"][$i]["view"] = "Нет";
					echo $row->login." ".$access_pages[$i]["page"] ."||".$row->page."<br>";
					if($access_pages[$i]["page"] == $row->page){
						if($row->edit == 1){
							$users[$row->id]["pages"][$i]["edit"] = "Да";
						}else{
							$users[$row->id]["pages"][$i]["edit"] = "Нет";
						}
						if($row->view == 1){
							$users[$row->id]["pages"][$i]["view"] = "Да";
						}else{
							$users[$row->id]["pages"][$i]["view"] = "Нет";
						}
					}
				}

				$id_r ++;
			}
		}


		return $users;
	}
	function get_access_pages(){
		$access_pages = array ();
		$sql = "SELECT visitka.access_pages.* FROM visitka.access_pages WHERE 1";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {

			foreach ( $query->result () as $row ) {
				array_push($access_pages, array(
					"id" => $row->id,
					"page_name" => $row->name
				));
			}
		}


		return $access_pages;
	}
	function access_page_insert($data){
		$sql = "INSERT INTO visitka.access_pages (name) values('".$data["page_name"]."')";
		$query = $this->db->query ( $sql );
	}
	function access_page_edit($data){
		$sql = "UPDATE visitka.access_pages SET name =  '".$data["page_name"]."' WHERE id = ".$data["id"];
		$query = $this->db->query ( $sql );
	}
	function access_page_delete($id){
		$sql = "DELETE FROM visitka.access_pages WHERE id = ".$id;
		$query = $this->db->query ( $sql );
	}
	function get_user_data($user_id) {
		$user_data = array ();

		$access_pages = $this->get_access_pages();

		$sql = "SELECT * FROM visitka.admin_users WHERE id = " . $user_id;
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$user_data["login"] = $row->login;
			$user_data["user_id"] = $user_id;
			$user_data["user_name"] = $row->login;
			$count = count($access_pages);
			for($i = 0; $i < $count; $i++){
				$user_data["pages"][$access_pages[$i]["id"]] = $access_pages[$i];
				$user_data["pages"][$access_pages[$i]["id"]]["view"] = 0;
				$user_data["pages"][$access_pages[$i]["id"]]["edit"] = 0;
			}
		}

		$sql = "SELECT * FROM visitka.access WHERE userid = " . $user_id;
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$user_data["pages"][$row->page]["view"] = $row->view;
				$user_data["pages"][$row->page]["edit"] = $row->edit;
			}
		}

		return $user_data;
	}

	function save_user($user_data){
		//echo "<pre>";
		//print_r ( $user_data );
		//die ();
		$user_id = $user_data["user_id"];
		foreach ( $user_data["page"] as $id_page => $value ) {
			$sql = "INSERT INTO  `visitka`.access (userid, page, edit, view) VALUES ('".$user_id."', $id_page, '".$value["edit"]."', '".$value["view"]."')
			ON DUPLICATE KEY UPDATE view = '".$value["view"]."', edit = '".$value["edit"]."'";
			$query = $this->db->query ( $sql );
		}
	}
	function get_page_access($page, $type){
		$user_id = $_SESSION ['user']["user_id"];
		$access = 0;
		$sql = "SELECT access.".$type." FROM access INNER JOIN access_pages ON access_pages.id = access.page WHERE access.userid = " . $user_id." AND access_pages.name LIKE '".$page."'";
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			$row = $query->row();
			$access = $row->$type;
		}

		return $access;
	}

	function set_legalsystem($data) {
		$hotel_id = $data["hotel_id"];
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, str_value) VALUES ('legalsystem', '".$data["legalsystem"]."')
		ON DUPLICATE KEY UPDATE str_value = '".$data["legalsystem"]."'";
		$query = $this->db->query ( $sql );
	}

	function set_version($data) {
		$hotel_id = $data["hotel_id"];
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('version', '".$data["version"]."')
		ON DUPLICATE KEY UPDATE value = '".$data["version"]."'";
		$query = $this->db->query ( $sql );

		//==== visitka update version =======

		$query = $this->db->query ( "UPDATE `visitka`.config SET version = '".$data["version"]."' WHERE id = '" . $hotel_id . "'" );
	}

	function set_version_1_disallow($data) {
		$hotel_id = $data["hotel_id"];
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('version_1_disallow', '".$data["version_1_disallow"]."')
		ON DUPLICATE KEY UPDATE value = '".$data["version_1_disallow"]."'";
		$query = $this->db->query ( $sql );
	}

	function set_custom_debug($data) {
		$hotel_id = $data["hotel_id"];
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, str_value) VALUES ('custom_debug', '".$data["custom_debug"]."')
		ON DUPLICATE KEY UPDATE str_value = '".$data["custom_debug"]."'";
		$query = $this->db->query ( $sql );
	}

	function save_location_opt($data){
	    $log_data = array();
	    $log_data['subject'] = $log_subject = "id_country_3c";
	    $hotel_id = $log_data['hotel_id'] = $data["hotel_id"];
	    $log_data['user_id'] = $_SESSION ['user']["user_id"];
	    $id_country_3c = $data ["id_country_3c"];
	    $log_data['body']["b: "] = $this->db->select($log_subject)->get_where('visitka.config', array('id'=>$hotel_id))->row()->$log_subject;

		if (trim ( $data ["city_name"] ) != "") {
			$sql = "INSERT INTO  visitka.tbl_city (name) VALUES ('" . $data ["city_name"] . "')
						ON DUPLICATE KEY UPDATE name = '" . $data ["city_name"] . "'";
			$query = $this->db->query ( $sql );
		}

		$id_city = 0;
		$sql = "SELECT * FROM visitka.tbl_city WHERE name LIKE '" . $data ["city_name"] . "'";
		$query = $this->db->query ( $sql );
		// die($sql);
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$id_city = $row->id;
		}
		$sql = "UPDATE visitka.config SET id_city =  '".$id_city."', id_country_3c =  '".$id_country_3c."', property_type =  '".$data["property_type"]."' WHERE id = ".$data["hotel_id"];
		$query = $this->db->query ( $sql );

		$log_data['body']["a: "] = $this->db->select($log_subject)->get_where('visitka.config', array('id'=>$hotel_id))->row()->$log_subject;
		$this->loger->save_stripe_changes_to_log($log_data);

		// ==== LOCAL DB SAVE COUNTRY

// 		$db_name = $this->get_hotel_db ( $data["hotel_id"] );

// 		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('id_country', '".$id_country."')
// 		ON DUPLICATE KEY UPDATE value = '".$id_country."'";
// 		$query = $this->db->query ( $sql );
	}

	function set_tasks($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('tasks', 1)
		ON DUPLICATE KEY UPDATE is_active = 1";
		$query = $this->db->query ( $sql );
	}
	function unset_tasks($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('tasks', 0)
		ON DUPLICATE KEY UPDATE is_active = 0";
		$query = $this->db->query ( $sql );
	}

	function set_shared_guests($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('shared_guests', 1)
		ON DUPLICATE KEY UPDATE value = 1";
		$query = $this->db->query ( $sql );
	}
	function unset_shared_guests($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('shared_guests', 0)
		ON DUPLICATE KEY UPDATE value = 0";
		$query = $this->db->query ( $sql );
	}

	function set_appex($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('appex', 1)
		ON DUPLICATE KEY UPDATE is_active = 1";
		$query = $this->db->query ( $sql );
	}
	function unset_appex($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('appex', 0)
		ON DUPLICATE KEY UPDATE is_active = 0";
		$query = $this->db->query ( $sql );
	}

	function set_fms_module($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('fms', 1)
		ON DUPLICATE KEY UPDATE is_active = 1";
		$query = $this->db->query ( $sql );
	}
	
	function set_fms_skala($hotel_id) {
	    $db_name = $this->get_hotel_db ( $hotel_id );
	
	    $sql = "INSERT INTO  `$db_name`.hotelix_config (name, value) VALUES ('fms_skala_activity', 1)
		ON DUPLICATE KEY UPDATE value = 1";
	    $query = $this->db->query ( $sql );
	}
	
	function unset_fms_skala($hotel_id) {
	    $db_name = $this->get_hotel_db ( $hotel_id );
	
	    $sql = "INSERT INTO  `$db_name`.hotelix_config (name, value) VALUES ('fms_skala_activity', 0)
		ON DUPLICATE KEY UPDATE value = 0";
	    $query = $this->db->query ( $sql );
	}
	
	function unset_fms_module($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('fms', 0)
		ON DUPLICATE KEY UPDATE is_active = 0";
		$query = $this->db->query ( $sql );
	}

	function set_kkm_module($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('kkm', 1)
		ON DUPLICATE KEY UPDATE is_active = 1";
		$query = $this->db->query ( $sql );
	}
	function unset_kkm_module($hotel_id) {
		$db_name = $this->get_hotel_db ( $hotel_id );

		$sql = "INSERT INTO  `".$db_name."`.modules (name, is_active) VALUES ('kkm', 0)
		ON DUPLICATE KEY UPDATE is_active = 0";
		$query = $this->db->query ( $sql );
	}


	function set_online_module_v2($hotel_id) {
	    $db_name = $this->get_hotel_db ( $hotel_id );

	    $sql = "INSERT INTO  `$db_name`.hotelix_config (name, value) VALUES ('online_module', 1)
		ON DUPLICATE KEY UPDATE value = 1";
	    $query = $this->db->query ( $sql );
	}
	function unset_online_module_v2($hotel_id) {
	    $db_name = $this->get_hotel_db ( $hotel_id );

	    $sql = "INSERT INTO  `".$db_name."`.hotelix_config (name, value) VALUES ('online_module', 0)
		ON DUPLICATE KEY UPDATE value = 0";
	    $query = $this->db->query ( $sql );
	}

	function get_visitka_hotel_tasks($db_name) {
		$tasks = "";
		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'tasks'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$tasks = $row ['is_active'];
		}
		return $tasks;
	}
	function get_visitka_hotel_shared_guests($db_name) {
		$shared_guests = 0;
		$sql = "SELECT value FROM `$db_name`.hotelix_config WHERE name LIKE 'shared_guests'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$shared_guests = $row ['value'];
		}
		return $shared_guests;
	}

	function get_visitka_hotel_online_module_v2($db_name) {
		$online_module = 0;
		$sql = "SELECT value FROM `$db_name`.hotelix_config WHERE name LIKE 'online_module'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$online_module = $row ['value'];
		}
		return $online_module;
	}

	function get_visitka_hotel_appex($db_name) {
		$appex = 0;
		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'appex'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$appex = $row ['is_active'];
		}
		return $appex;
	}

	function get_visitka_hotel_fms_module($db_name) {
		$fms_module = 0;
		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'fms'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$fms_module = $row ['is_active'];
		}
		return $fms_module;
	}

	function get_visitka_hotel_kkm_module($db_name) {
		$kkm_module = 0;
		$sql = "SELECT is_active FROM `$db_name`.modules WHERE name LIKE 'kkm'";
		// echo $sql."<br>";
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row_array ();

			$kkm_module = $row ['is_active'];
		}
		return $kkm_module;
	}

	function updateUserMainData($data, $id){

	    $this->db->where('id', $id);
	    $this->db->update('admin_users', $data);

	}

	function insertUserMainData($data){

	    $this->db->insert('admin_users', $data);
	    $id = $this->db->insert_id ();
	    return $id;
	}

	function get_hotel_id_by_dbname($db_name) {
	    $hotel_id = 0;
	    $sql = "SELECT id FROM visitka.config WHERE db_name LIKE '".$db_name."'";
	    // echo $sql."<br>";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row_array ();

	        $hotel_id = $row ['id'];
	    }
	    return $hotel_id;
	}
	
	function get_dbname_by_hotel_id($hotel_id) {
	    $db_name = '';
	    $sql = "SELECT db_name FROM visitka.config WHERE id = $hotel_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row_array ();
	        $db_name = $row ['db_name'];
	    }
	    return $db_name;
	}
	
	function get_host_by_hotel_id($hotel_id) {
	    $host = '';
	    $sql = "SELECT host FROM visitka.config WHERE id = $hotel_id";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row_array ();
	        $host = $row ['host'];
	    }
	    return $host;
	}

	function get_hotel_2way_auth_mode($db_name) {
	    $hotel_2way_auth_mode = 1;
	    $sql = "SELECT 2way_auth_mode as hotel_2way_auth_mode FROM visitka.config WHERE db_name LIKE '".$db_name."'";
	    $query = $this->db->query ( $sql );
	    if ($query->num_rows () > 0) {
	        $row = $query->row_array ();
	        $hotel_2way_auth_mode = $row ['hotel_2way_auth_mode'];
	    }
	    return $hotel_2way_auth_mode;
	}
	
	function get_2way_auth_values(){
	    $return_array = array();
	    
	    $return_array[1]["name"] = "1";
	    $return_array[1]["value"] = 1;
	    $return_array[1]["selected"] = "";
	    $return_array[2]["name"] = "2";
	    $return_array[2]["value"] = 2;
	    $return_array[2]["selected"] = "";
	    $return_array[3]["name"] = "3";
	    $return_array[3]["value"] = 3;
	    $return_array[3]["selected"] = "";
	    
	    return $return_array;
	}
	
	function save_2way_auth($data){
	    $sql = "UPDATE visitka.config SET 2way_auth_mode =  '".$data["2way_auth_mode"]."' WHERE id = ".$data["hotel_id"];
	    $query = $this->db->query ( $sql );
	}
}
?>