<?php 
class gateway extends CI_Controller {
    public function __construct() {
        parent::__construct ();

        $this->load->model ( 'hms_mail' );
        $this->load->model ( 'mlanguages' );
        $this->load->model('gateway_model');
    }
    
    function genRandomString() {
        $length = 10;
        $characters = "0123456789abcdefghijklmnopqrstuvwxyz";
        $string = "";
    
        for ($p = 0; $p < $length; $p++) {
            $string .= $characters[mt_rand(0, strlen($characters)-1)];
        }
    
        return $string;
    }
    function getip() {
        if(getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } elseif(getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        $ip = htmlspecialchars(substr($ip,0,15), ENT_QUOTES);
        return $ip;
    }
    
    function getip2() {
        if(getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } elseif(getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        $ip = htmlspecialchars(substr($ip,0,15), ENT_QUOTES);
        echo $ip;
    }
    
    
    function otelms_registration(){
        $postdata = file_get_contents("php://input");
        //echo "<pre>+++";
        
        $log_data = array (
            'get' => $_SERVER ['QUERY_STRING'],
            'post' => json_encode ( $_POST ),
            'state' => 'reg',
            'rawpost' => $postdata,
            'server' => "" //json_encode ( $_SERVER ),
                
        );
        $this->db->insert ( 'reg_log', $log_data );
        $id = $this->db->insert_id ();
        
        $postdata = json_decode($postdata, true);
//         echo "++";
//         print_r($postdata);
//         die();
        
        
         
        $return_array = array();
         
        $data = $postdata["data"];
        //die();
        $locale = $data["locale"];
        $userfirstname = htmlspecialchars($data["userfirstname"]);
        $userlastname = htmlspecialchars($data["userlastname"]);
        $useremail = htmlspecialchars($data["useremail"]);
         
        $origin = htmlspecialchars($data["origin"]);
        
        $phone = htmlspecialchars($data["phone"]);
        $email = htmlspecialchars($data["useremail"]);
        $data["password_1"] = stripslashes ($data["password_1"]);
        $pass_uniq = $data["password_1"];
        $data["password_1"] = htmlspecialchars ($data["password_1"]);
        $password = md5($data["password_1"]);
        $company = htmlspecialchars($data["company"]);
        $domainPrefix = $data["domainPrefix"];
         
        $promocode = htmlspecialchars($data["promocode"]);
        $language = $data["locale"];
    
        $domainPrefix = strtolower($domainPrefix);
         
        $domainPrefix = preg_replace('/[^a-z0-9-]*/i', "", $domainPrefix);
         
        if( preg_match( '/[!@#\\$%\\^&\\*\\.]/', $domainPrefix) ){
            $return_array["response"] = "error";
            $return_array["error_code"] = 1;
            $return_array["error_description"] = "wrong_domain!";
            
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
            
            echo json_encode($return_array);
            return;
            //echo "fail";
        }
    
        $domain = "otelms.com";
        $site_address = strtolower($domainPrefix) . "." . $domain;
         
        $query = $this->db->query("SELECT site_address FROM visitka.users");
        if ($query->num_rows() > 0)
        {
            foreach ($query->result() as $row)
            {
                if ( $site_address == $row->site_address){
                    $return_array["response"] = "error";
                    $return_array["error_code"] = 2;
                    $return_array["error_description"] = $site_address." exist!";
                    
                    //log return
                    $log_data = array (
                        'get' => "",
                        'post' => "",
                        'rawpost' => json_encode($return_array),
                        'server' => ""
                    );
                    $this->db->insert ( 'reg_log', $log_data );
                    
                    echo json_encode($return_array);
                    return;
                    //echo "fail";
                }
            }
        }
        
        $id_unique = $this->genRandomString();
        
        $curUser = array('email'=>$email,
            'fname'=>'',
            'lname'=>''
        );
         
        $timezoneId = "";
        $config_email_name = $this->config->item('email_name');
        $config_email_password = $this->config->item('email_password');
        $config_url_address = $this->config->item('url_address');
        //$ip_address = $this->getip();
        if (isset($data['client_ip'])) {
            $ip_address = $data['client_ip'];
        }  else {
            $ip_address = "direct";
        }
        
        if (isset($data['referer'])) {
            $referer = addslashes($data['referer']);
        }  else {
            $referer = "";
        }
        
        $query = $this->db->query ( "INSERT INTO users (origin, locale, userphone, password,pass_uniq,userlastname,userfirstname,useremail,company,site_address,timezone,id_unique, ip, language, promocode, referer)
            VALUES ('$origin', '$locale', '$phone', '$password','$pass_uniq','$userlastname','$userfirstname','$useremail','$company','$site_address','$timezoneId',
            '$id_unique', '$ip_address', '$language', '$promocode', '$referer')");
        $insert_id = $this->db->insert_id ();
        
        $data_mail = array();
        $data_mail['userfirstname'] = $userfirstname;
        $data_mail['userlastname'] = $userlastname;
        $data_mail['config_url_address'] = $config_url_address;
        $data_mail['insert_id'] = $insert_id;
        $data_mail['id_unique'] = $id_unique;
        $data_mail['config_url_address'] = $config_url_address;
        $data_mail['company'] = $company;
        switch ($locale) {
            case "pl" :
                $data_mail['lang'] = $data ['back_site_language'];
                break;
            case "en" :
                $data_mail['lang'] = $data ['back_site_language'];
                break;
            case "ru" :
                $data_mail['lang'] = "";
                break;
            default :
                $data_mail['lang'] = "en";
                break;
        }
        
        
        $data_mail["http_url"] = "http://www.otelms.com/debug/authorized";
        $data_mail["http_url"] = "https://wp-otelms.otelms.com";
        
        
        $email_cfg_way = 3;
        if ($origin == "agast") {
            $data_mail["http_url"] = "https://agast.ru";
            $email_cfg_way = 5;
        } else {
            $data_mail["http_url"] = "https://www.otelms.com";
        }
        
        if ($promocode == 9191 || true) {
            // ------------------------------
            
            $this->load->library('email');
            //$email_cfg_way = 3;
            
            $lang_char_array = array();
            $query = $this->db->query("SELECT 2char as char_2_lang, 3char as char_3_lang FROM global_hotelix.dic_languages");
            if ($query->num_rows() > 0)
            {
                foreach ($query->result() as $row)
                {
                    $lang_char_array[$row->char_2_lang] = $row->char_3_lang;
                }
            }
            
//             $data_mail["lang_char_array"] = json_encode($lang_char_array);
//             $data_mail["locale"] = $locale;
//             echo "<pre>".$locale;
//             print_r($lang_char_array);
//             die();
            
            switch ($locale) {
                case "ua":
                    $locale = "uk";
                    break;
                case "ge":
                    $locale = "ka";
                    break;
            }
            
            $char_3_lang = "eng";
            if(isset($lang_char_array[$locale])){
                $char_3_lang = $lang_char_array[$locale];
            }
            
            $subj = $this->mlanguages->getdictionaryword ( "confirm_user_email", $char_3_lang, "{clt_registration_request}" );
            
            $this->mlanguages->getdictionary("footer", $char_3_lang, $data_mail);
            $this->mlanguages->getdictionary("confirm_user_email", $char_3_lang, $data_mail);
            $data_mail["current_year"] = date("Y");
            if ($origin == "agast") {
                $mail_msg = $this->parser->parse('templates/registration_c2_verify_agast.html', $data_mail, true);
            } else {
                $mail_msg = $this->parser->parse('templates/registration_c2_verify.html', $data_mail, true);
            }
            // $mail_msg = "TEST EMAIL VERIFY";
            //$mail_msg = iconv("utf-8", "windows-1251", $mail_msg);
            $config = array();
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->set_mailtype("html");
            // $email = "ferents.yurij@gmail.com";
            
            $this->email->to($email);
            $this->email->subject($subj);
            $this->email->message($mail_msg);
            
            $this->email->from($config['from']);
            
            $log_data = array(
                'state' => "pre email"
            );
            $this->db->insert('reg_log', $log_data);
            
            if (! $this->email->send()) {
                
                $log_data = array(
                    'state' => "fail email 1"
                );
                $this->db->insert('reg_log', $log_data);
                $email_cfg_way = 1;
                
                $config = $this->hms_mail->getparam($email_cfg_way);
                $this->email->initialize($config);
                $this->email->from($config['from']);
                // $this->email->send ();
                if (! $this->email->send()) {
                    
                    $return_array["response"] = "error";
                    $return_array["error_code"] = 3;
                    $return_array["error_message"] = show_error($this->email->print_debugger());
                    $return_array["error_description"] = "Email error!";
                    
                    // log return
                    $log_data = array(
                        'get' => "",
                        'post' => "",
                        'rawpost' => json_encode($return_array),
                        'server' => ""
                    );
                    $this->db->insert('reg_log', $log_data);
                    
                    echo json_encode($return_array);
                    return;
                } else {
                    $return_array["response"] = "ok";
                    $return_array["error_code"] = 0;
                    
                    // log return
                    $log_data = array(
                        'get' => "",
                        'post' => "",
                        'rawpost' => json_encode($return_array),
                        'server' => ""
                    );
                    $this->db->insert('reg_log', $log_data);
                    
                    echo json_encode($return_array);
                    return;
                }
            } else {
                
                $log_data = array(
                    'state' => "success email 1"
                );
                $this->db->insert('reg_log', $log_data);
                
                $return_array["response"] = "ok";
                $return_array["error_code"] = 0;
                
                // log return
                $log_data = array(
                    'get' => "",
                    'post' => "",
                    'rawpost' => json_encode($return_array),
                    'server' => ""
                );
                $this->db->insert('reg_log', $log_data);
                
                echo json_encode($return_array);
                return;
            }
        }else{
            switch ($data['locale']) {
                case "pl" :
                    $message = $this->parser->parse('templates/mail_new_reg_pl_v2.html', $data_mail, TRUE);
                    break;
                case "en" :
                    $message = $this->parser->parse('templates/mail_new_reg_en_v2.html', $data_mail, TRUE);
                    break;
                case "ru" :
                    $message = $this->parser->parse('templates/mail_new_reg_ru_v2.html', $data_mail, TRUE);
                    $message = iconv("utf-8", "windows-1251", $message);
                    break;
                default :
                    $message = $this->parser->parse('templates/mail_new_reg_en_v2.html', $data_mail, TRUE);
                    break;
            }
            
            
            
            
            require_once ('class.phpmailer.php');
            
            $path_img='/var/vhosts/otelms.com/html/images/';
            $mail = new PHPMailer(true); // the true param means it will throw exceptions on errors, which we need to catch
            
            $mail->IsSMTP(); // telling the class to use SMTP
            try {
                if (false) {
                    $mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
                    $mail->SMTPAuth = true; // enable SMTP authentication
                    $mail->SMTPSecure = "ssl"; // sets the prefix to the servier
                    $mail->Host = "postoffice.otelms.com"; // sets GMAIL as the SMTP server
                    $mail->Port = 465; // set the SMTP port for the GMAIL server
                    $mail->Username = $config_email_name; // GMAIL username
                    $mail->Password = $config_email_password; // GMAIL password
                    $mail->AddReplyTo($email, '');
                    $mail->AddAddress($email, '');
                    $mail->SetFrom($config_email_name, '');
                    $mail->ClearAttachments();
                    $mail->AddAddress($curUser['email'], $curUser['fname'] . ' ' . $curUser['lname']);
                } else {
                    //echo "++";
                    $mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
                    $mail->SMTPAuth = true; // enable SMTP authentication
                    $mail->SMTPSecure = "tls"; // sets the prefix to the servier
                    $mail->Host = "mailing-service.otelms.com"; // sets GMAIL as the SMTP server
                    $mail->Port = 25; // set the SMTP port for the GMAIL server
                    $mail->Username = "otelms-hms"; // GMAIL username
                    $mail->Password = "BnCrU8k8ZXwJRYmAlNoxrvBm"; // GMAIL password
                    $mail->AddReplyTo($curUser['email'], '');
                    //$mail->AddAddress($email, '');
                    $mail->SetFrom("noreply@mailing-service.otelms.com", '');
                    $mail->ClearAttachments();
                    $mail->AddAddress($curUser['email'], $curUser['fname'] . ' ' . $curUser['lname']);
                }
                 
                 
                switch ($data['locale']) {
                    case "pl":
                        $mail->CharSet = 'UTF-8';
                        $mail->Subject = "Identyfikacja użytkownika";
                        break;
                         
                    case "en":
                        $mail->CharSet = 'UTF-8';
                        $mail->Subject = "Application for registration";
                        break;
                         
                    case "ru":
                        $mail->Subject = iconv("utf-8", "windows-1251","Заявка на регистрацию");
                        break;
                         
                    default:
                        $mail->CharSet = 'UTF-8';
                        $mail->Subject = "Application for registration";
                        break;
                }
            
                $mail->MsgHTML(str_replace(array('{FNAME}','{LNAME}'),array($curUser['fname'],$curUser['lname']) ,$message), $path_img);
            
                $mail->Send();
                $mail->ClearAllRecipients();
            
                $return_array["response"] = "ok";
                $return_array["error_code"] = 0;
            
                //log return
                $log_data = array (
                    'get' => "",
                    'post' => "",
                    'rawpost' => json_encode($return_array),
                    'server' => ""
                );
                $this->db->insert ( 'reg_log', $log_data );
            
                echo json_encode($return_array);
                return;
            } catch (phpmailerException $e) {
                //echo "111";
                //echo $e->errorMessage(); //Pretty error messages from PHPMailer
                $return_array["response"] = "error";
                $return_array["error_code"] = 3;
                $return_array["error_message"] = $e->errorMessage();
                $return_array["error_description"] ="Email error!";
            
                //log return
                $log_data = array (
                    'get' => "",
                    'post' => "",
                    'rawpost' => json_encode($return_array),
                    'server' => ""
                );
                $this->db->insert ( 'reg_log', $log_data );
            
                echo json_encode($return_array);
                return;
            } catch (Exception $e) {
                //echo "222";
                //echo $e->getMessage(); //Boring error messages from anything else!
                $return_array["response"] = "error";
                $return_array["error_code"] = 3;
                $return_array["error_description"] ="Email error!";
            
                //log return
                $log_data = array (
                    'get' => "",
                    'post' => "",
                    'rawpost' => json_encode($return_array),
                    'server' => ""
                );
                $this->db->insert ( 'reg_log', $log_data );
            
                echo json_encode($return_array);
                return;
            }
            
        }
        
        //echo "ok";
    }
    
    
    function send_registration_confitmation_mail($userid)
    {
        $this->db->query("SET NAMES 'utf8'");
        
        $this->load->library('email');
        
        
        $hms_id = 0;
        $query = $this->db->query("SELECT `visitka`.config.id as hms_id, `visitka`.config.host FROM visitka.users INNER JOIN `visitka`.config ON visitka.users.site_address = `visitka`.config.host WHERE visitka.users.id = $userid");
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hms_id = $row->hms_id;
        }
        
        $data_mail = array();
        $sql = "SELECT * FROM visitka.users WHERE id = " . $userid;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $data_mail = $query->row_array();
        }
        
        $email = $data_mail["useremail"];
        
        $origin = $data_mail["origin"];
        
        $email_cfg_way = 3;
        if ($origin == "agast") {
            $email_cfg_way = 5;
        } else {}
        
        $domain = explode(".", $data_mail["site_address"]);
        $sufix = $domain[0];
        
        $lang_char_array = array();
        $query = $this->db->query("SELECT 2char as char_2_lang, 3char as char_3_lang FROM global_hotelix.dic_languages");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $lang_char_array[$row->char_2_lang] = $row->char_3_lang;
            }
        }
        
        $locale = $data_mail["locale"];
        
        switch ($locale) {
            case "ua":
                $locale = "uk";
                break;
            case "ge":
                $locale = "ka";
                break;
        }
        
        $char_3_lang = "eng";
        if (isset($lang_char_array[$locale])) {
            $char_3_lang = $lang_char_array[$locale];
        }
        
        $subj = $this->mlanguages->getdictionaryword("confirm_user_email", $char_3_lang, "{clt_domain_accepted}");
        $data_mail["current_year"] = date("Y");
        $this->mlanguages->getdictionary("footer", $char_3_lang, $data_mail);
        $this->mlanguages->getdictionary("confirm_user_email", $char_3_lang, $data_mail);
        
        if ($origin == "agast") {
            //$data_mail["site_address"] = $sufix . ".agast.ru";
            $data_mail["site_address"] = "https://desktop.agast.ru/?hmsid=$hms_id";
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation_agast.html', $data_mail, true);
        } else {
            $data_mail["site_address"] = "https://desktop.otelms.com/?hmsid=$hms_id";
            $mail_msg = $this->parser->parse('templates/registration_c2_confitmation.html', $data_mail, true);
        }
        
        // echo $char_3_lang."<pre>";
        // print_r($data_mail);
        // die();
        
        $config = array();
        $config = $this->hms_mail->getparam($email_cfg_way);
        $this->email->initialize($config);
        
        // $email_to = "ferents.yurij@gmail.com";
        $this->email->set_mailtype("html");
        $this->email->to($email);
        $this->email->subject($subj);
        $this->email->message($mail_msg);
        
        $this->email->from($config['from']);
        
        if (! $this->email->send()) {
            
            show_error($this->email->print_debugger());
            echo 'E-mail error!\n';
            
            $email_cfg_way = 1;
            
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->from($config['from']);
            // $this->email->send ();
            if (! $this->email->send()) {
                show_error($this->email->print_debugger());
                echo 'E-mail error!\n';
            } else {
                echo 'Your e-mail has been sent!';
            }
        } else {
            echo 'Your e-mail has been sent!\n';
        }
    }
    
    
    function test_email($email_to = "") {
        
        $email_to = "volodimir@cellreload.com";
        
        require_once ('class.phpmailer.php');
        $mail = new PHPMailer(true); // the true param means it will throw exceptions on errors, which we need to catch
        
        $mail->IsSMTP(); // telling the class to use SMTP
        try {
        $mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
        $mail->SMTPAuth = true; // enable SMTP authentication
        //$mail->SMTPSecure = "tls"; // sets the prefix to the servier
        $mail->SMTPSecure = "SSL/TLS"; // sets the prefix to the servier
        //$mail->SMTPSecure = "TLS"; // sets the prefix to the servier
        
        $mail->Host = "mailing-service.otelms.com"; // sets GMAIL as the SMTP server
        $mail->Port = 587; // set the SMTP port for the GMAIL server
        //$mail->Port = 25; // set the SMTP port for the GMAIL server
        $mail->Username = "otelms-hms"; // GMAIL username
        $mail->Password = "BnCrU8k8ZXwJRYmAlNoxrvBm"; // GMAIL password
        //$mail->AddReplyTo($email_to, '');
        //$mail->AddAddress($email, '');
        $mail->SetFrom("noreply@mailing-service.otelms.com", '');
        
        $mail->AddAddress($email_to, $email_to);
        $path_img='/var/vhosts/otelms.com/html/images/';
        
        $mail->CharSet = 'UTF-8';
        $mail->Subject = "Application for test";
        $mail->MsgHTML("message !!!!!!!");
        
        $mail->Send();
        
        } catch (phpmailerException $e) {

            echo $e->errorMessage(); //Pretty error messages from PHPMailer
            
        }
        
    }
    
    
    function test_email2($email_to = "") {
    
    $email_to = "volodimir@cellreload.com";
    
    
    $data_return = array();
    $data_return ["response"] = 1;
    
    $this->load->library ( 'email' );
    
    $config = array ();
    $config ['protocol'] = "smtp";
    $config ['smtp_host'] = "mailing-service.otelms.com2";
    $config ['smtp_user'] = "otelms-hms";
    $config ['smtp_pass'] = "BnCrU8k8ZXwJRYmAlNoxrvBm";
    $config ['smtp_port'] = 25;
    $config ["smtp_crypto"] = "TLS";
    
    
    
    $config2 = array ();
    $config2 = array(
        //'useragent'			=>	'OTELMS HMS',
        'protocol' 			=> 'smtp',
        'smtp_host' 		=> 'mailing-service.otelms.com2',
        'smtp_user' 		=> 'otelms-hms',
        'smtp_pass' 		=> 'BnCrU8k8ZXwJRYmAlNoxrvBm',
        'smtp_port' 		=> 25,
        'smtp_timeout' 		=> 5,
        'smtp_keepalive'	=> FALSE,
        'smtp_crypto' 		=> 'tls',
        //'wordwrap'			=>	true,
        //'wrapchars'			=>	76,
        //'mailtype'			=>	'html',
        //'charset'			=>	'utf-8',
        //'validate'			=>	true,
        //'priority'			=>	3,
        //'crlf'				=>	"\r\n",
        //'newline'			=>	"\r\n",
        //'bcc_batch_mode'	=>	false,
        //'bcc_batch_size'	=>	'',
        //'dsn'				=>	false
    );
    
//     $config ['smtp_port'] = 25;
//     $config ["smtp_crypto"] = "TLS";
    
    //$config = array ();
    
    $this->email->initialize ( $config );
    
    $this->email->from ( "noreply@mailing-service.otelms.com", 'noreply@mailing-service.otelms.com' );
    $this->email->to ( $email_to );
    $this->email->subject ( "subj " .  $config ['smtp_port'] . " " . $config ['smtp_host']);
    
    $this->email->message ( "test test message" );
    
    if (! $this->email->send ()) {
        $data_return ["error"] = show_error ( $this->email->print_debugger () ); // Pretty error messages from PHPMailer
        $data_return ["response"] = 0;
    }
    
    
    echo "<pre>";
    
    print_r($data_return);
    
    }
    
    function otelms_authorized(){
        $postdata = file_get_contents("php://input");
        
        $data = array (
            'get' => $_SERVER ['QUERY_STRING'],
            'post' => json_encode ( $_POST ),
            'state' => 'auth',
            'rawpost' => $postdata,
            'server' => "" //json_encode ( $_SERVER )
        );
        $this->db->insert ( 'reg_log', $data );
        $id = $this->db->insert_id ();
        
        //echo "<pre>";
        $postdata = json_decode($postdata, true);
        $return_array = array();
        
        
        //$postdata = $postdata["data"];  
        
        $id_user = $postdata["id_user"];
        $id_unique = $postdata["id_unique"];
         
        $query = $this->db->query("SELECT * FROM users WHERE id = $id_user");
         
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            $db_id_unique = $row->id_unique;
        }
        if($db_id_unique == $id_unique){
            $query = $this->db->query("UPDATE `users` SET authorized = 1 WHERE id = $id_user");
            $return_array["response"] = "ok";
            $return_array["error_code"] = 0;
            
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
            
            echo json_encode($return_array);
            return;       
        }else{
            $return_array["response"] = "error";
            $return_array["error_code"] = 4;
            $return_array["error_description"] ="not authorized!";
            
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
            
            echo json_encode($return_array);
            return;
        }
    }
    
    function otelms_registration_old(){
        $postdata = file_get_contents("php://input");
        //echo "<pre>+++";
    
        $log_data = array (
            'get' => $_SERVER ['QUERY_STRING'],
            'post' => json_encode ( $_POST ),
            'state' => 'reg',
            'rawpost' => $postdata,
            'server' => "" //json_encode ( $_SERVER ),
    
        );
        $this->db->insert ( 'reg_log', $log_data );
        $id = $this->db->insert_id ();
    
        $postdata = json_decode($postdata, true);
        //print_r($postdata);
        //die();
    
    
         
        $return_array = array();
         
        $data = $postdata["data"];
        //die();
        $locale = $data["locale"];
        $userfirstname = htmlspecialchars($data["userfirstname"]);
        $userlastname = htmlspecialchars($data["userlastname"]);
        $useremail = htmlspecialchars($data["useremail"]);
         
        $phone = htmlspecialchars($data["phone"]);
        $email = htmlspecialchars($data["useremail"]);
        $data["password_1"] = stripslashes ($data["password_1"]);
        $pass_uniq = $data["password_1"];
        $data["password_1"] = htmlspecialchars ($data["password_1"]);
        $password = md5($data["password_1"]);
        $company = htmlspecialchars($data["company"]);
        $domainPrefix = $data["domainPrefix"];
         
        $promocode = htmlspecialchars($data["promocode"]);
        $language = $data["locale"];
    
        $domainPrefix = strtolower($domainPrefix);
         
        $domainPrefix = preg_replace('/[^a-z0-9-]*/i', "", $domainPrefix);
         
        if( preg_match( '/[!@#\\$%\\^&\\*\\.]/', $domainPrefix) ){
            $return_array["response"] = "error";
            $return_array["error_code"] = 1;
            $return_array["error_description"] = "wrong_domain!";
    
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
    
            echo json_encode($return_array);
            return;
            //echo "fail";
        }
    
        $domain = "otelms.com";
        $site_address = strtolower($domainPrefix) . "." . $domain;
         
        $query = $this->db->query("SELECT site_address FROM visitka.users");
        if ($query->num_rows() > 0)
        {
            foreach ($query->result() as $row)
            {
                if ( $site_address == $row->site_address){
                    $return_array["response"] = "error";
                    $return_array["error_code"] = 2;
                    $return_array["error_description"] = $site_address." exist!";
    
                    //log return
                    $log_data = array (
                        'get' => "",
                        'post' => "",
                        'rawpost' => json_encode($return_array),
                        'server' => ""
                    );
                    $this->db->insert ( 'reg_log', $log_data );
    
                    echo json_encode($return_array);
                    return;
                    //echo "fail";
                }
            }
        }
    
        $id_unique = $this->genRandomString();
    
        $curUser = array('email'=>$email,
            'fname'=>'',
            'lname'=>''
        );
         
        $timezoneId = "";
        $config_email_name = $this->config->item('email_name');
        $config_email_password = $this->config->item('email_password');
        $config_url_address = $this->config->item('url_address');
        //$ip_address = $this->getip();
        if (isset($data['client_ip'])) {
            $ip_address = $data['client_ip'];
        }  else {
            $ip_address = "direct";
        }
        $query = $this->db->query ( "INSERT INTO users (locale, userphone, password,pass_uniq,userlastname,userfirstname,useremail,company,site_address,timezone,id_unique, ip, language, promocode)
            VALUES ('$locale', '$phone', '$password','$pass_uniq','$userlastname','$userfirstname','$useremail','$company','$site_address','$timezoneId','$id_unique', '$ip_address', '$language', '$promocode')");
        $insert_id = $this->db->insert_id ();
    
        $data_mail = array();
        $data_mail['userfirstname'] = $userfirstname;
        $data_mail['userlastname'] = $userlastname;
        $data_mail['config_url_address'] = $config_url_address;
        $data_mail['insert_id'] = $insert_id;
        $data_mail['id_unique'] = $id_unique;
        $data_mail['config_url_address'] = $config_url_address;
        $data_mail['company'] = $company;
        switch ($locale) {
            case "pl" :
                $data_mail['lang'] = $data ['back_site_language'];
                break;
            case "en" :
                $data_mail['lang'] = $data ['back_site_language'];
                break;
            case "ru" :
                $data_mail['lang'] = "";
                break;
            default :
                $data_mail['lang'] = "en";
                break;
        }
    
    
        $data_mail["http_url"] = "http://www.otelms.com/debug/authorized";
        $data_mail["http_url"] = "https://wp-otelms.otelms.com";
        $data_mail["http_url"] = "https://www.otelms.com";
    
        switch ($data['locale']) {
            case "pl" :
                $message = $this->parser->parse('templates/mail_new_reg_pl_v2.html', $data_mail, TRUE);
                break;
            case "en" :
                $message = $this->parser->parse('templates/mail_new_reg_en_v2.html', $data_mail, TRUE);
                break;
            case "ru" :
                $message = $this->parser->parse('templates/mail_new_reg_ru_v2.html', $data_mail, TRUE);
                $message = iconv("utf-8", "windows-1251", $message);
                break;
            default :
                $message = $this->parser->parse('templates/mail_new_reg_en_v2.html', $data_mail, TRUE);
                break;
        }
    
    
    
    
        require_once ('class.phpmailer.php');
    
        $path_img='/var/vhosts/otelms.com/html/images/';
        $mail = new PHPMailer(true); // the true param means it will throw exceptions on errors, which we need to catch
    
        $mail->IsSMTP(); // telling the class to use SMTP
        try {
            if (false) {
                $mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
                $mail->SMTPAuth = true; // enable SMTP authentication
                $mail->SMTPSecure = "ssl"; // sets the prefix to the servier
                $mail->Host = "postoffice.otelms.com"; // sets GMAIL as the SMTP server
                $mail->Port = 465; // set the SMTP port for the GMAIL server
                $mail->Username = $config_email_name; // GMAIL username
                $mail->Password = $config_email_password; // GMAIL password
                $mail->AddReplyTo($email, '');
                $mail->AddAddress($email, '');
                $mail->SetFrom($config_email_name, '');
                $mail->ClearAttachments();
                $mail->AddAddress($curUser['email'], $curUser['fname'] . ' ' . $curUser['lname']);
            } else {
                //echo "++";
                $mail->SMTPDebug = 2; // enables SMTP debug information (for testing)
                $mail->SMTPAuth = true; // enable SMTP authentication
                $mail->SMTPSecure = "tls"; // sets the prefix to the servier
                $mail->Host = "mailing-service.otelms.com"; // sets GMAIL as the SMTP server
                $mail->Port = 25; // set the SMTP port for the GMAIL server
                $mail->Username = "otelms-hms"; // GMAIL username
                $mail->Password = "BnCrU8k8ZXwJRYmAlNoxrvBm"; // GMAIL password
                $mail->AddReplyTo($curUser['email'], '');
                //$mail->AddAddress($email, '');
                $mail->SetFrom("noreply@mailing-service.otelms.com", '');
                $mail->ClearAttachments();
                $mail->AddAddress($curUser['email'], $curUser['fname'] . ' ' . $curUser['lname']);
            }
             
             
            switch ($data['locale']) {
                case "pl":
                    $mail->CharSet = 'UTF-8';
                    $mail->Subject = "Identyfikacja użytkownika";
                    break;
                     
                case "en":
                    $mail->CharSet = 'UTF-8';
                    $mail->Subject = "Application for registration";
                    break;
                     
                case "ru":
                    $mail->Subject = iconv("utf-8", "windows-1251","Заявка на регистрацию");
                    break;
                     
                default:
                    $mail->CharSet = 'UTF-8';
                    $mail->Subject = "Application for registration";
                    break;
            }
    
            $mail->MsgHTML(str_replace(array('{FNAME}','{LNAME}'),array($curUser['fname'],$curUser['lname']) ,$message), $path_img);
    
            $mail->Send();
            $mail->ClearAllRecipients();
    
            $return_array["response"] = "ok";
            $return_array["error_code"] = 0;
    
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
    
            echo json_encode($return_array);
            return;
        } catch (phpmailerException $e) {
            //echo "111";
            //echo $e->errorMessage(); //Pretty error messages from PHPMailer
            $return_array["response"] = "error";
            $return_array["error_code"] = 3;
            $return_array["error_message"] = $e->errorMessage();
            $return_array["error_description"] ="Email error!";
    
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
    
            echo json_encode($return_array);
            return;
        } catch (Exception $e) {
            //echo "222";
            //echo $e->getMessage(); //Boring error messages from anything else!
            $return_array["response"] = "error";
            $return_array["error_code"] = 3;
            $return_array["error_description"] ="Email error!";
    
            //log return
            $log_data = array (
                'get' => "",
                'post' => "",
                'rawpost' => json_encode($return_array),
                'server' => ""
            );
            $this->db->insert ( 'reg_log', $log_data );
    
            echo json_encode($return_array);
            return;
        }
    
    
        //echo "ok";
    }
    
    function send_registration_verify_mail()
    {
        $this->load->library ( 'email' );
        $email_cfg_way = 3;

            
            $lang_char_array = array();
            $query = $this->db->query("SELECT 2char as char_2_lang, 3char as char_3_lang FROM global_hotelix.dic_languages");
            if ($query->num_rows() > 0)
            {
                foreach ($query->result() as $row)
                {
                    $lang_char_array[$row->char_2_lang] = $row->char_3_lang;
                }
            }
            
            $char_3_lang = "pol";
            if(isset($lang_char_array[$locale])){
                $char_3_lang = $lang_char_array[$locale];
            }
            
            $subj = $this->mlanguages->getdictionaryword ( "confirm_user_email", $char_3_lang, "{clt_registration_request}" );
            
            $this->mlanguages->getdictionary("footer", $char_3_lang, $data_mail);
            $this->mlanguages->getdictionary("confirm_user_email", $char_3_lang, $data_mail);
            $data_mail["current_year"] = date("Y");
            $mail_msg = $this->parser->parse('templates/registration_c2_verify.html', $data_mail, true);
        //$mail_msg = "TEST EMAIL VERIFY";
        //$mail_msg = iconv("utf-8", "windows-1251", $mail_msg);
        $config = array();
        $config = $this->hms_mail->getparam($email_cfg_way);
        $this->email->initialize($config);
    
        //$subj = 'HMS Otelms, TEST REGISTRATION VERIFY';
    
        $email_to = "ferents.yurij@gmail.com";
        $this->email->set_mailtype("html");
        $this->email->to($email_to);
        $this->email->subject($subj);
        $this->email->message($mail_msg);
    
        $this->email->from($config['from'], 'TEST REGISTRATION VERIFY (HMS OtelMS)');
    
        if (! $this->email->send()) {
    
            show_error($this->email->print_debugger());
            echo 'E-mail error!\n';
    
            $email_cfg_way = 1;
    
            $config = $this->hms_mail->getparam($email_cfg_way);
            $this->email->initialize($config);
            $this->email->from($config['from'], 'TEST REGISTRATION VERIFY (HMS OtelMS)');
            // $this->email->send ();
            if (! $this->email->send()) {
                show_error($this->email->print_debugger());
                echo 'E-mail error!\n';
            } else {
                echo 'Your e-mail has been sent!';
            }
        } else {
            echo 'Your e-mail has been sent!\n';
        }
    }
    
    
    function get_registration_data(){
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
        
        $reg_data = array();
        if (isset($postdata['data']['host'])) {
            $password = "otelms00#";
            $signature = md5(json_encode($postdata['data']) . $password);
            if ($signature != $postdata['signature']) {
                $reg_data['error'] = "fail signature";
            } else {
                
                $host = $postdata['data']['host'];
                $user_data = $this->db->get_where('users', array(
                    'site_address' => $host
                ))->row_array();
                
                $reg_data['registrationID'] = $user_data['id'];
                $reg_data['confirmed'] = $user_data['authorized'];
                $reg_data['lastname'] = $user_data['userlastname'];
                $reg_data['firstname'] = $user_data['userfirstname'];
                $reg_data['email'] = $user_data['useremail'];
                $reg_data['phone'] = $user_data['userphone'];
                $reg_data['name'] = $user_data['company'];
                $reg_data['ip'] = $user_data['ip'];
                $reg_data['registrationLanguage'] = $user_data['language'];
                $reg_data['registrationDate'] = ($user_data['time'] == '0000-00-00 00:00:00') ? null : $user_data['time'];
                $reg_data['promocode'] = (strlen($user_data['promocode']) > 50) ? '!!! spam promocode !!!' : $user_data['promocode'];
                $reg_data['registrationDomain'] = $user_data['site_address'];
                $reg_data['referer'] = $user_data['referer'];
            }
        }
        
        echo json_encode($reg_data);
        
    }
    
    function get_account_data(){
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);

        $account_data = array();
        if(isset($postdata['data']['host'])){
            $password = "otelms00#";
            $signature = md5(json_encode($postdata['data']) . $password);
            if($signature != $postdata['signature']){
                $account_data['error'] = "fail signature";
            }else{
                $host = $postdata['data']['host'];
                $hotel_data = $this->db->get_where('config', array('host' => $host))->row_array();
                
                $account_data['hms_id'] = $hotel_data['id'];
                $account_data['language'] = $hotel_data['language'];
                $account_data['id_city'] = $hotel_data['id_city'];
                $account_data['id_country_3c'] = $hotel_data['id_country_3c'];
                $account_data['balance'] = $hotel_data['stripe_ballance'];
                $account_data['sub_current_period_end'] = $hotel_data['stripe_sub_current_period_end'];
                $account_data['2way_auth_mode'] = $hotel_data['2way_auth_mode'];
                $account_data['version'] = $hotel_data['version'];
                $account_data['status'] = $hotel_data['hotelstateid'];
            }
        }
        echo json_encode($account_data);
    }
    
    public function get_extended_acc()
    {
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);
    
        $extended_data = array();
        if (isset($postdata['method'])) {
            $password = "otelms00#";
            $signature = md5(json_encode($postdata['data']) . $password);
            if ($signature != $postdata['signature']) {
                $extended_data['error'] = "fail signature";
                //echo "+++";
            } else {
                $hms_id = $postdata['data']['hms_id'];
                $hotel_data = $this->db->get_where('config', array(
                    'id' => $hms_id
                ))->row_array();
                $db_name = $hotel_data['db_name'];
    
                $hotel_statuses_names = $this->gateway_model->get_hotel_statuses_names();
                $hotelstateid = $hotel_data['hotelstateid'];
                $hotel_statuses_name = "";
                if (isset($hotel_statuses_names[$hotelstateid])) {
                    $hotel_statuses_name = $hotel_statuses_names[$hotelstateid]['name'];
                }
    
                $overbooking_category_id = $this->db->select('value')
                ->get_where('`'.$db_name.'`'.'.hotelix_config', array(
                    'name' => 'overbooking_category_id'
                ))
                ->row()->value;
    
                $sql = "SELECT SUM(1) as count_rooms FROM `$db_name`.rooms
                INNER JOIN `$db_name`.categories ON categories.id = rooms.category_id
                WHERE categories.is_active = 1 AND categories.id <> $overbooking_category_id";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $count_rooms = $row->count_rooms;
                }
    
                $hotel_users = array();
                $hotel_users_data = $this->gateway_model->get_hotel_users($db_name);
                foreach ($hotel_users_data as $user_cell) {
                    $isAdministrator = false;
                    if ($user_cell['isAdministrator'] == 1) {
                        $isAdministrator = true;
                    }
                    array_push($hotel_users, array(
                        'firstName' => $user_cell['fullname'],
                        'lastName' => $user_cell['lastname'],
                        'middleName' => $user_cell['middlename'],
                        'admin' => $isAdministrator,
                        'position' => $user_cell['position'],
                        'systemLang' => $user_cell['language'],
                        'emailAddress' => $user_cell['login']
                    ));
                }
    
                //$last_logs_data = $this->gateway_model->get_last_logs($db_name);
                $last_logs_data = $this->gateway_model->get_logauthip_list($db_name);
    
                $channels_data = $this->gateway_model->get_channels_data($db_name);
    
                $properties = $this->gateway_model->get_properties_data($db_name);
    
                $legal_entities = $this->gateway_model->get_legal_entities_data($db_name);
                
                $additional_services = $this->gateway_model->get_additional_services_data($db_name);
                
                $errors_count = $this->db->select('COUNT(1) as errors_count')->get($db_name.'.dc_log_errors')->row()->errors_count;
                
                $partners_data = array();
                foreach ($legal_entities as $parner_cell) {
                    array_push($partners_data, array(
                        'name' => $parner_cell['name'],
                        'country' => $parner_cell['country'],
                        'typeOfCompany' => $parner_cell['type_of_company'],
                        'addrLine1' => $parner_cell['addrLine1'],
                        'addrLine2' => $parner_cell['addrLine2'],
                        'city' => $parner_cell['city'],
                        'state' => $parner_cell['state'],
                        'postcode' => $parner_cell['postcode'],
                        'email' => $parner_cell['email'],
                        'docSn' => $parner_cell['DOC_SN'],
                        'docInn' => $parner_cell['DOC_INN'],
                        'docType' => $parner_cell['DOC_type'],
                        'zkpo' => $parner_cell['ZKPO'],
                        'nds' => $parner_cell['nds'],
                        'ndsNumber' => $parner_cell['nds_number'],
                        'isFiscalable' => $parner_cell['is_fiscalable'],
                        'bankName' => $parner_cell['bankname'],
                        'swift' => $parner_cell['swift'],
                        'bic' => $parner_cell['bic'],
                        'accountNumber' => $parner_cell['accountnumber'],
                        'correspondentAccount' => $parner_cell['correspondent_account'],
                        'is_default' => $parner_cell['isdefault']
                    ));
                }
    
                $extended_data['hmsID'] = $hms_id;
                $extended_data['billingAddressCountry'] = $hotel_data['id_country_3c'];
                $extended_data['hmsUrl'] = $hotel_data['base_url'];
                $extended_data['status'] = $hotelstateid;
                $extended_data['status_str'] = $hotel_statuses_name;
                $extended_data['happines'] = "";
                $extended_data['rooms'] = $count_rooms;
                $extended_data['errors'] = $errors_count;
                $extended_data['version'] = $hotel_data['version'];
                $extended_data['hms_users'] = $hotel_users;
                $extended_data['activity_log'] = $last_logs_data;
                $extended_data['channels'] = $channels_data;
                $extended_data['properties'] = $properties;
                $extended_data['legal_entities'] = $partners_data;
                $extended_data['additional_services'] = $additional_services;
            }
        }
//         echo "<pre>";
//         print_r($extended_data);
        echo json_encode($extended_data);
    }
}
?>