<?php
class Tasks_m extends CI_model {
    const img_base_url = '/mobile/images/svg/';
    public $tables;
	public function __construct() {
		parent::__construct ();
		$this->tables = new stdClass();
		$this->tables->tasks = "`hk_tasks`";
		$this->tables->tasks_types = "`hk_task_types`";
		$this->tables->cleanings_types = "`hk_cleaning_schedule`";
		$this->tables->task2cleaning_type = "`hk_tasks2cs`";
		$this->tables->cleaning_operations = "`hk_cleaning_tasks`";
		$this->tables->cleaning_operation2cleanings_type = "`hk_ct2cs`";
		$this->tables->tasks_statuses = "`hk_task_statuses`";
		$this->tables->rooms = "`rooms`";
		$this->tables->cats = "`categories`";
	}

	public function get_tasks_list($p='') {
	    $user = $this->session->userdata('user');
	    $uset_id = isset($user['id']) ? $user['id'] : 0;
	    $show_tasks_asigned_for = $this->hotelix_config->get_record ("hk_show_tasks_asigned_for", "int"); //1- All users, 0 - Logined user
	    $where_tasks_asigned_for_str =  $show_tasks_asigned_for ? '' : " AND (t1.assignedto = $uset_id)";//t1.assignedto = 0 OR
	    $t = $this->tables;
	    $start_date = (isset($p->start_date) && !empty($p->start_date)) ? $p->start_date : date('Y-m-d');
	    $where_changeable_str = "(t1.startdate BETWEEN '$start_date 00:00:00' AND '$start_date 23:59:59' OR (t1.startdate < '$start_date 00:00:00' AND t1.status != 3)) $where_tasks_asigned_for_str";
	    if (isset($p->single_task_id)&&!empty($p->single_task_id)){
	        $where_changeable_str = "t1.id = $p->single_task_id";
	    }
	    $sql = "SELECT  t1.*,
                        t2.name AS room_name,
                        t3.shortname AS cat_name,
                        t4.name AS type_name,
                        t6.name AS cleaning_type_name, t6.id AS cleaning_type_id
                FROM $t->tasks AS t1
                JOIN $t->rooms AS t2 ON t1.room_id = t2.id
                JOIN $t->cats AS t3 ON t2.category_id = t3.id
                JOIN $t->tasks_types AS t4 ON t1.task_type = t4.id AND t1.task_type = 1 /* only cleaning on now */
                LEFT JOIN $t->task2cleaning_type AS t5 ON t1.id = t5.task_id
                LEFT JOIN $t->cleanings_types AS t6 ON t5.cs_id = t6.id
                WHERE $where_changeable_str
	           ORDER BY t1.is_urgent DESC, t1.status DESC";
	    $res = $this->db->query($sql)->result();
	    return $res;
	}

	public function parse_tasks_list($list=array()) {
	    $res = new stdClass();
	    $res->group_tabs = array();
	    $start_date = date('Y-m-d');
	    foreach ($list as &$task) {
	        $task->img_url = $this::img_base_url;
	        if ($task->status != 3){
	            if ($task->is_urgent || $task->startdate < "$start_date 00:00:00"){
	                if (!isset($res->group_tabs[0])){
	                    $res->group_tabs[0] = array('groupclass'=>'urgent_tasks', 'tab_clt'=>'{clt_urgent}');
	                }
	                $task->groupclass = 'urgent_tasks';
	                if ($task->is_urgent){
	                    $task->color_schema_class = 'row_orange';
	                    $task->img_url .= $task->status == 2 ? 'sync-circle.svg' : 'warning.svg';
	                } else {
	                    $task->color_schema_class = $task->status == 2 ? 'row_blue' : '';
	                    $task->img_url .= $task->status == 2 ? 'sync-circle.svg' : 'disc-outline.svg';
	                }
	            }else {
	                if (!isset($res->group_tabs[1])){
	                    $res->group_tabs[1] = array('groupclass'=>'today_tasks', 'tab_clt'=>'{clt_today}');
	                }
	                $task->groupclass = 'today_tasks';
	                $task->color_schema_class = $task->status == 2 ? 'row_blue' : '';
	                $task->img_url .= $task->status == 2 ? 'sync-circle.svg' : 'disc-outline.svg';
	            }
	        }else {
	            if (!isset($res->group_tabs[2])){
	                $res->group_tabs[2] = array('groupclass'=>'done_tasks', 'tab_clt'=>'{clt_done}');
	            }
	            $task->groupclass = 'done_tasks';
	            $task->color_schema_class = 'row_green';
	            $task->img_url .= 'checkmark-circle-sharp.svg';
	        }
	    }
	    unset($task);
	    ksort($res->group_tabs);
	    $res->tasks_list = $list;
	    return $res;
	}

	public function get_task_data_byid ($id=0) {
	    $res = new stdClass();
	    if ($id){
	        $res = $this->get_tasks_list((object)array('single_task_id'=>$id));
	        $res = isset($res[0])? $res[0] : '';
	        if (isset($res->cleaning_type_id)&&!empty($res->cleaning_type_id)){
	            $res->clening_operations = $this->get_clianing_operations_by_cleaning_type_id($res->cleaning_type_id);
	        }
	    }
	    return $res;
	}

	public function get_clianing_operations_by_cleaning_type_id($cleaning_type_id=0) {
	    $res = new stdClass();
	    if ($cleaning_type_id){
	        $t = $this->tables;
	        $sql = "SELECT t1.*
                    FROM $t->cleaning_operations AS t1
                    JOIN $t->cleaning_operation2cleanings_type AS t2 ON t2.ct_id = t1.id
                    WHERE t2.cst_id = $cleaning_type_id";
	        $res = $this->db->query($sql)->result();
	    }
	    return $res;
	}

	public function set_task_status($pa) {
	    $this->db->update($this->tables->tasks, array('status'=>$pa['status']), array('id'=>$pa['id']));
	}

	public function get_tasks_statuses() {
	    $res = array();
	    $statuses = $this->db->get($this->tables->tasks_statuses)->result();
	    foreach ($statuses as $status) {
	        $res[$status->id] = $status;
	    }
	    return $res;
	}

	public function save_task_resolution($pa) {
	    $this->db->update($this->tables->tasks, array('resolution'=>$pa['resolution']), array('id'=>$pa['id']));
	}
}