<?php
$date_today = $tasks_date_option = date('Y-m-d');
if ($this->session->userdata ( 'tasks_list_date' ) != ""){
    $tasks_date_option = $this->session->userdata ( 'tasks_list_date' );
}
list($year, $month, $day) = explode("-", $tasks_date_option);

$date_from = $tasks_date_option;
$intdate_from = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
$day_from = $day;

$date_right = $date_middle = date('Y-m-d', mktime ( 0, 0, 0, $month, $day + 1, $year ));
$date_left = date('Y-m-d', mktime ( 0, 0, 0, $month, $day - 1, $year ));

$intdate_middle = round ( mktime ( 0, 0, 0, $month, $day + 1, $year ) / 86400 );
$temp = explode("-", $date_middle);
$day_middle = $temp[2];

$date_to = date('Y-m-d', mktime ( 0, 0, 0, $month, $day + 2, $year ));
$intdate_to = round ( mktime ( 0, 0, 0, $month, $day + 2, $year ) / 86400 );
$temp = explode("-", $date_to);
$day_to = $temp[2];

$dates_titles = array();
$dates_titles[0]['date'] = $date_from;
$dates_titles[0]['var_day'] = $day;
$dates_titles[0]['var_dayofweek'] = "{mlw_week_".strtolower(gmdate ( 'l', $intdate_from * 86400 ))."}";
$dates_titles[1]['date'] = $date_middle;
$dates_titles[1]['var_day'] = $day_middle;
$dates_titles[1]['var_dayofweek'] = "{mlw_week_".strtolower(gmdate ( 'l', $intdate_middle * 86400 ))."}";
$dates_titles[2]['date'] = $date_to;
$dates_titles[2]['var_day'] = $day_to;
$dates_titles[2]['var_dayofweek'] = "{mlw_week_".strtolower(gmdate ( 'l', $intdate_to * 86400 ))."}";

$overbooking_id = $this->hotelix_config->get_record('overbooking_category_id', 'int');

$icons_array = $this->tasks_model->get_task_icons();

$categories_tasks = array();
$sql = "SELECT categories.id AS cat_id, rooms.id AS room_id, categories.shortname AS cat_shortname, rooms.name as room_name, 
deskofdays.reservation_id, deskofdays.intdate, deskofdays.date, hk_task_statuses.name as task_status_name,
guests.id as guest_id, guests.firstname as guest_firstname, guests.lastname as guest_lastname, hk_tasks.id task_id, 
DATE(hk_tasks.startdate) as task_startdate, CONCAT(users.fullname, ' ', users.lastname) as user_name, 
hk_task_types.id as task_type_id, hk_task_types.name as task_type_name, hk_task_types.icon as task_type_icon, hk_task_types.color as task_type_color
                FROM rooms
                INNER JOIN categories ON categories.id = rooms.category_id AND categories.id != $overbooking_id
                LEFT JOIN hk_tasks ON rooms.id = hk_tasks.room_id AND DATE(hk_tasks.startdate) BETWEEN '$date_from' AND '$date_to'
                LEFT JOIN deskofreservation ON rooms.id = deskofreservation.room_id AND deskofreservation.dateout >= '$date_from' AND datein <= '$date_to' 
                AND deskofreservation.cancel = 0 AND deskofreservation.deleted = 0 
                LEFT JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id AND deskofdays.intdate >= $intdate_from AND deskofdays.intdate <= $intdate_to
                LEFT JOIN guests ON guests.id = deskofreservation.guest_id
                LEFT JOIN users ON users.id = hk_tasks.assignedto
                LEFT JOIN hk_task_types ON hk_tasks.task_type = hk_task_types.id 
                LEFT JOIN hk_task_statuses ON hk_tasks.status = hk_task_statuses.id 
                WHERE rooms.is_active = 1 AND categories.is_active = 1";

//echo $sql."<br>";
//die();
$query = $this->db->query($sql);
foreach ($query->result() as $row) {
    $categories_tasks[$row->cat_id]['cat_id'] = $row->cat_id;
    $categories_tasks[$row->cat_id]['category_name'] = $row->cat_shortname;
    if(!isset($categories_tasks[$row->cat_id]['dates_titles'])){
        $categories_tasks[$row->cat_id]['dates_titles'] = $dates_titles;
    }
    
    $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['room_id'] = $row->room_id;
    $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['room_name'] = $row->room_name;

    if($row->reservation_id > 0){
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$row->intdate]['guest_name'] = $row->guest_lastname." ".$row->guest_firstname;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$row->intdate]['room_status'] = "{clt_booked}";
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$row->intdate]['room_status_class'] = "room_booked";
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$row->intdate]['var_res_id'] = $row->reservation_id;
    }
    
    if($row->task_id > 0){
        list ( $year_task, $month_task, $day_task ) = explode ( "-", $row->task_startdate );
        $intdate_task = round ( mktime ( 0, 0, 0, $month_task, $day_task, $year_task ) / 86400 );
        
        $task_type_name = $row->task_type_name;
        if($row->task_type_id == 1){
            $task_type_name = "{-".$row->task_type_name."-}";
        }

        $task_status_name = "{-".$row->task_status_name."-}";
        
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['cat_id'] = $row->cat_id;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_id'] = $row->task_id;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_type'] = $task_type_name;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_subtype'] = $this->tasks_model->getTask_subtype_name($row->task_type_id, $row->task_id);
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_status_name'] = $task_status_name;
        $task_type_icon = "";
        if(isset($icons_array[$row->task_type_icon])){
            $task_type_icon = $icons_array[$row->task_type_icon]['icon_class'];
        }
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_icon'] = $task_type_icon;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['task_color'] = $row->task_type_color;
        $categories_tasks[$row->cat_id]['rooms'][$row->room_id]['rooms_dates'][$intdate_task]['room_tasks'][$row->task_id]['user_name'] = $row->user_name;
    }    
}

foreach ($categories_tasks as $cat_id => $rooms) {
    foreach ($rooms['rooms'] as $room_id => $rooms_data) {
        for ($intdate = $intdate_from; $intdate <= $intdate_to; $intdate ++) {
            if (!isset($categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate])) {
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_tasks'] = array();
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['guest_name'] = "";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_status'] = "{clt_available}";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_status_class'] = "room_available";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['var_res_id'] = "";
            }
            
            if (!isset($categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_status'])) {
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['guest_name'] = "";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_status'] = "{clt_available}";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_status_class'] = "room_available";
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['var_res_id'] = "";
            }
            
            if (!isset($categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_tasks'])) {
                $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_tasks'] = array();
            }
            
            $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['room_id'] = $room_id;
            $categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates'][$intdate]['intdate'] = $intdate;
        }
        
        ksort($categories_tasks[$cat_id]['rooms'][$room_id]['rooms_dates']);
    }
}

// echo "<pre>";
// print_r($categories_tasks);
// die();

//$menu_data = $this->htmltpl->get_left_settings_menu (10, 1);
$data = array (
		'header' => $this->htmltpl->getHeader_new (),
		'footer_html' => $this->htmltpl->getFooter_new(),
        //'settings_main_menu' => $menu_data["main_menu"],
        //'settings_sub_menu' => $menu_data["sub_menu"],
        'categories' => $categories_tasks,
        'date_left' => $date_left,
        'date_right' => $date_right,
        'date_today' => $date_today,
        'var_month' => "{mlw_month_".strtolower(gmdate ( 'F', $intdate_from * 86400))."}",
        'var_year' => $year
);
$data["left_menu"] = $this->htmltpl->get_left_menu (8);
$this->mlanguages->getdictionary ( "tasks_c2", "", $data );
$this->parser->parse ( 'templates/tasks_c2/tasks_c2_tasks_desk_view.html', $data );
?>
