<?php
$start_date = "2017-11-01";
$end_date = "2017-11-11";



if($this->session->userdata ( 'reports_date' ) == ""){
	$date = $start_date." - ".$end_date;
}else{
	$date = $this->session->userdata ( 'reports_date' );
}
$array_date = explode(" - ", $date);

if(isset($array_date[0])){
	$start_date = trim($array_date[0]);
}
if(isset($array_date[1])){
	$end_date = trim($array_date[1]);
}

$start_date_shift = $start_date;
$end_date_shift = $end_date;
$period_shift = 7;

if ($this->session->userdata ( 'reports_period_shift' ) != "") {
	$period_shift = $this->session->userdata ( 'reports_period_shift' );
}
list ( $year, $month, $day ) = explode ( "-", $start_date );
$start_date_int = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
list ( $year, $month, $day ) = explode ( "-", $end_date );
$end_date_int = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

$new_start_date_int = $start_date_int - $period_shift;
$new_end_date_int = $end_date_int - $period_shift;

$start_date_shift = date ( "Y-m-d", $new_start_date_int * 86400 );
$end_date_shift = date ( "Y-m-d", $new_end_date_int * 86400 );

$shift_periods = array (
		'7' => " - 7 {mlw_day2}",
		'30' => " - 30 {mlw_day2}",
		'90' => " - 90 {mlw_day2}",
		'365' => " - 365 {mlw_day2}"
);
$shift_periods_options = array();
foreach ( $shift_periods as $key_value => $txt_value ) {
	array_push ( $shift_periods_options, array (
	'value_periods_options' => $key_value,
	'txt_periods_options' => $txt_value,
	'selected' => ($key_value == $period_shift) ? "selected" : ""
			) );
}

$data = array (
		'date' => $date,
		'header' => $this->htmltpl->getHeader_new (),
		'left_menu' => $this->htmltpl->get_left_menu (4) 
);
$data["footer_html"] = $this->htmltpl->getFooter_new();
$res = $this->report_model->data_by_sources($start_date, $end_date);

//echo "<pre>";
//print_r($res);
//print_r($res['count2day_total']);
//print_r($res['count2day_total']);
//die();

$res_shift = $this->report_model->data_by_sources($start_date_shift, $end_date_shift);

$data ['shift_periods_options'] = $shift_periods_options;

$data ["graf"] = $this->report_model->get_linegraph_draw_data($res['count2day'], "div_1");
$data ["graf_2"] = $this->report_model->get_linegraph_draw_data($res_shift['count2day'], "div_2");

$data ["graf_amount_1"] = $this->report_model->get_linegraph_draw_data($res['amount2day'], "div_3");
$data ["graf_amount_2"] = $this->report_model->get_linegraph_draw_data($res_shift['amount2day'], "div_4");

$data ["graf_pie"] = $this->report_model->get_piegraph_draw_data($res['count2day_total'], $div_id_name = "div_pie_1");
$data ["graf_pie2"] = $this->report_model->get_piegraph_draw_data($res_shift['count2day_total'], $div_id_name = "div_pie_2");

$data ["graf_pie_amount_1"] = $this->report_model->get_piegraph_draw_data($res['amount2day_total'], $div_id_name = "div_pie_3");
$data ["graf_pie_amount_2"] = $this->report_model->get_piegraph_draw_data($res_shift['amount2day_total'], $div_id_name = "div_pie_4");

$data ["graf_column_1"] = $this->report_model->get_columngraph_draw_data($res['count2day_total'], $div_id_name = "div_column_1");
$data ["graf_column_2"] = $this->report_model->get_columngraph_draw_data($res_shift['count2day_total'], $div_id_name = "div_column_2");

$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse ( 'templates/reports_c2_dc_sources_view.html', $data );
?>