<?php 
$template_data = array ();
$number_threshold = $this->config->item('report_number_threshold');
// get reservations info
// =============================================================================================
$template_data["check_in_count"] = 0;
$template_data["check_out_count"] = 0;
$template_data["canceled_count"] = 0;

// $sql = "SELECT COUNT(deskofreservation.id) as counts FROM deskofreservation
//         WHERE datein = CURDATE() AND cancel = 0 AND deleted = 0
//         UNION
//         SELECT COUNT(deskofreservation.id) as counts FROM deskofreservation
//         WHERE dateout = CURDATE() AND cancel = 0 AND deleted = 0
//         UNION
//         SELECT COUNT(deskofreservation.id) as counts FROM deskofreservation
//         WHERE datein <= CURDATE() AND dateout >= CURDATE() AND cancel = 1 AND deleted = 0
// ";

$sql = "SELECT
    SUM(if(cancel = 0 AND datein = CURDATE(), 1, 0)) as check_in_count,
    SUM(if(cancel = 0 AND dateout = CURDATE(), 1, 0)) as check_out_count,
    SUM(if((cancel = 1 AND datein <= CURDATE() AND dateout >= CURDATE()), 1, 0)) as canceled_count
    FROM deskofreservation
    WHERE deleted = 0";
$query = $this->db->query($sql);
if ($query->num_rows() > 0) {
    $row = $query->row();
    $template_data["check_in_count"] = $row->check_in_count;
    $template_data["check_out_count"] = $row->check_out_count;
    $template_data["canceled_count"] = $row->canceled_count;
}

// get_channels info
// =============================================================================================
$channels_names = $this->dc_model->get_dc_channels_names();
$dc_data = array();
$dc_total_price = 0;
$sql = "SELECT deskofreservation.dc_id, SUM(deskofdays.price) as res_amount FROM deskofreservation
        INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id AND deskofdays.date <= CURDATE()
        WHERE deskofreservation.datein <= CURDATE() AND deskofreservation.dateout >= CURDATE()
        AND deskofreservation.cancel = 0 AND deskofreservation.deleted = 0
        GROUP BY deskofreservation.dc_id, deskofreservation.id";

$query = $this->db->query ( $sql );
foreach ( $query->result () as $row ) {
   $dc_name = "";
   switch($row->dc_id){
       case 0:
           $dc_name = "Direct";
           break;
       case 999:
           $dc_name = "On-line";
           break;
       default:
           if(isset($channels_names[$row->dc_id])){
               $dc_name = $channels_names[$row->dc_id];
           }
           break;
   }
   
   if(isset($dc_data[$row->dc_id])){
       $dc_data[$row->dc_id]["dc_reservation_price"] += $row->res_amount;
       $dc_data[$row->dc_id]["dc_reservations_count"] += 1;
   }else{
       $dc_data[$row->dc_id]["dc_reservation_price"] = $row->res_amount;
       $dc_data[$row->dc_id]["dc_reservations_count"] = 1;
   }
   $dc_data[$row->dc_id]["dc_name"] = $dc_name;
   $dc_total_price += $row->res_amount;
}

// echo "<pre>";
// print_r($dc_data);
// die();
foreach($dc_data as $dc_id => $cell){
    $dc_data[$dc_id]["dc_reservation_price"] = $this->frontdesk->showcurrency ($cell["dc_reservation_price"]);
}
$template_data["dc_data"] = $dc_data;
$template_data["dc_total_price"] = $this->frontdesk->showcurrency ( $dc_total_price);

// get_guest info
// =============================================================================================
$general_guests_count = 0;
$baby_count = 0;
$car_count = 0;
$reserved_rooms_array = array();
$reserved_rooms = 0;
$sql = "SELECT deskofreservation.is_car, deskofreservation.adults, deskofreservation.room_id, 
        deskofreservation.baby_places, deskofreservation.babyplace2 
        FROM deskofreservation
        WHERE deskofreservation.datein <= CURDATE() AND deskofreservation.dateout >= CURDATE()
        AND deskofreservation.cancel = 0 AND deskofreservation.deleted = 0";
$query = $this->db->query ( $sql );
foreach ( $query->result () as $row ) {
    $general_guests_count += $row->adults + $row->baby_places + $row->babyplace2;
    $baby_count += $row->baby_places + $row->babyplace2;
    if($row->is_car == 1){
        $car_count += 1;
    }
    $reserved_rooms_array[$row->room_id] = 1;
}
$template_data["reserved_rooms"] = count($reserved_rooms_array);
$template_data["general_guests_count"] = $general_guests_count;
$template_data["baby_count"] = $baby_count;
$template_data["car_count"] = $car_count;

//==================== ADR, RevPAR, Occupancy getting data START ==========================
$query_active_categories = $this->db->select('id')->get_where('categories', array('is_active' => 1))->result_array();
$active_categories = array();
foreach ($query_active_categories as $category) {
	array_push($active_categories, $category['id']);
}
$active_categories = array_values(array_values($active_categories));
$int_today = floor (time()/86400);
$rev_adr_data = $this->report_model->get_ADRREV_graphycs_data($int_today, $int_today, $active_categories);
$rev_adr_data_parsing_arr = array (
// 		'amount' => number_format($rev_adr_data ['total_all_period_all_categories'] ['all'] ['amount'], 2, $number_threshold, ' '),
// 		'ADR' => number_format($rev_adr_data ['total_all_period_all_categories'] ['all'] ['ADR'], 2, $number_threshold, ' '),
// 		'REV' => number_format($rev_adr_data ['total_all_period_all_categories'] ['all'] ['REV'], 2, $number_threshold, ' '),
        'amount' => $this->frontdesk->showcurrency ($rev_adr_data ['total_all_period_all_categories'] ['all'] ['amount']),
        'ADR' => $this->frontdesk->showcurrency ($rev_adr_data ['total_all_period_all_categories'] ['all'] ['ADR']),
        'REV' => $this->frontdesk->showcurrency ($rev_adr_data ['total_all_period_all_categories'] ['all'] ['REV']),
		'ocupancy' => $rev_adr_data ['total_all_period_all_categories'] ['all'] ['ocupancy'] * 100,
		'room_reserved' => $rev_adr_data ['total_all_period_all_categories'] ['all']['room_reserved'] 
);
$template_data["rev_adr_data_parsing_arr"] = array(0=>$rev_adr_data_parsing_arr);
//==================== ADR, RevPAR, Occupancy getting data FINAL ==========================

$template_data["today_date"] = date("d/m/Y");
$template_data["current_year"] = date("Y");
$this->mlanguages->getdictionary("footer", $lang, $template_data);
$this->mlanguages->getdictionary("email_daily", $lang, $template_data);

echo $this->parser->parse ( 'templates/email_daily_new.html', $template_data, true );
?>