<?php 
class echannel_model extends CI_Model {
    private $lang = 'eng';
    public function __construct() {
        parent::__construct ();        
        $this->load->model ( 'Curl_model' );
        $this->load->model ( 'loger' );
    }

    function get_echannel_clients_list(){
        $clients = array();
        $sql = "SELECT * FROM `global_hotelix_common`.echannel_clients WHERE 1";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            array_push($clients, array(
                'id' => $row->id,
                'dc_id' => $row->dc_id,
                'name' => $row->name,
                'client_logo' => $row->logo_url
            ));
        }
        
        return $clients;
    }
    
    function get_echannel_clients_by_country($country = "ALL"){
        // 501 - innbi
        // 502 - kvartyrka (37)
        // 505 - checkin (38)
        // 506 - kvartirka (41)
        // 509 - gethotel (43)
        // 511 - wtb (42)
        
        $channels_for_all_countries = array();
        $country_channels = array();
        switch($country){
            case "RUS":
                $country_channels = array(501, 502, 505, 506, 509, 511, 545, 555);
                break;   
        }
    
        $return_data = array_merge($country_channels, $channels_for_all_countries);
    
        return $return_data;
    }
    
    function unset_echannel_clients_by_country($data){
        if ($this->releases->check_block_dc_channels_by_country() == 1) {
            $country = $this->frontdesk->get_visitka_id_country_3c();
            $country_dc_channels = $this->get_echannel_clients_by_country($country);
            $return_data = array();
            foreach ($data as $key => $cell) {
                $dc_id = $cell['dc_id'];
                $is_dc = 0;
                foreach ($country_dc_channels as $country_dc_id) {
                    if ($dc_id == $country_dc_id) {
                        $is_dc = 1;
                        break;
                    }
                }
                if ($is_dc == 1) {
                    $return_data[$key] = $data[$key];
                }
            }
        }else{
            $return_data = $data;
        }

        return $return_data;
    }
    
    function get_payment_types(){
        $query = $this->db->query ( "SELECT payment_types.* FROM payment_types WHERE is_echannel = 1" );
        $row = $query->row ();
        $payment_types = array ();
        foreach ( $query->result () as $row ) {
            array_push ( $payment_types, array (
                'id' => $row->id,
                'name' => $row->name
            ) );
        }
        return $payment_types;
    }
    
    function get_rooms(){
        $global_language = $this->hotelix_config->get_record("global_language", "int");
        $room_types = $this->mCategory->get_room_types();
        $size_types  = $this->mCategory->get_room_sizetype();
        $beds2rooms_data = $this->mCategory->get_beds2rooms_data();
        $beds = $this->dcm_airbnb->get_beds_list_options();
        $photos  = $this->mCategory->get_photos();
        
        $subrooms_data = $this->mCategory->get_category_room_param();
        $bed_room_view_type_data = $this->mCategory->get_bed_room_view_type();
//                     echo "<pre>";
//                     print_r($photos);
//                     die();

        $languages_comment_array = array();
        $sql = "SELECT * FROM `descriptionlanguages`  WHERE is_active = 1";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $languages_comment_array[$row->id]["id"] = $row->id;
                $languages_comment_array[$row->id]["lang_name"] = $row->name_original;
                $languages_comment_array[$row->id]["international_comment"] = "";
                $languages_comment_array[$row->id]["dir_tag"] = ""; 
            }
        }
        
        $category_amenities = array();
        
        $sql = "SELECT category_amenety_type.id as amenety_type_id, category_amenety_type.name as amenety_type_name,
category_ameneties.id as amenety_id, category_ameneties.name as amenety_name, category2amenities.amenity_id AS amenity_in_category,
category2amenities.category_id
FROM category2amenities
INNER JOIN global_hotelix_common.category_ameneties ON global_hotelix_common.category_ameneties.id = category2amenities.amenity_id
INNER JOIN global_hotelix_common.category_amenety_type ON global_hotelix_common.category_amenety_type.id = global_hotelix_common.category_ameneties.type_id 
GROUP BY category2amenities.category_id, global_hotelix_common.category_ameneties.id";
        
        //echo $sql;
        //die();
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            if($row->amenety_id != NULL){
                $category_amenities[$row->category_id][$row->amenety_type_id]["amenity_type_id"] = $row->amenety_type_id;
                $category_amenities[$row->category_id][$row->amenety_type_id]["amenity_type_name"] = $this->mlanguages->getdictionaryword("tbl_roomscategories_equipment", $this->lang, "{-" . $row->amenety_type_name . "-}");
                $category_amenities[$row->category_id][$row->amenety_type_id]["amenities"][$row->amenety_id]["amenity_id"] = $row->amenety_id;
                $category_amenities[$row->category_id][$row->amenety_type_id]["amenities"][$row->amenety_id]["amenity_name"] = $this->mlanguages->getdictionaryword("tbl_roomscategories_equipment", $this->lang, "{-" . $row->amenety_name . "-}");
            }
        }
        
        $categories = array ();
        $sql = "SELECT categories.id as category_id, categories.property_id, categories.base_price, categories.add_price, categories.baby_price, 
            categories.name as c_name, categories.shortname, categories.comment, categories.bedrooms, categories.places, categories.add_places, 
            categories.baby_places, categories.gender,
            categories.room_type_id, categories.size, categories.size_type, categories.is_coomon_room, count(rooms.id) as room_count 
            FROM categories 
            LEFT JOIN rooms ON rooms.category_id = categories.id 
            WHERE categories.is_active = 1 AND rooms.is_active = 1 AND categories.is_echannel = 1 
            GROUP BY categories.id";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $international_comment_array = $this->internationalfields->get_value("category", $row ["category_id"], "international_comment");
                $descriptions  = array();
                foreach ($languages_comment_array as $lang_cell) {
                    array_push($descriptions, array(
                        'lang_id' => $lang_cell['id'],
                        'lang_name' => $lang_cell['lang_name'],
                        'comment' => isset($international_comment_array[$lang_cell['id']]) ? $international_comment_array[$lang_cell['id']] : '',
                    ));
                }
                $room_type = isset($room_types[$row ["room_type_id"]]) ? $room_types[$row ["room_type_id"]]['name'] : "";
                $size_type = isset($size_types[$row ["size_type"]]) ? 
                            $this->mlanguages->getdictionaryword("admin_roomscategories_insert", $this->lang, $size_types[$row ["size_type"]]['name']) : "";
                $amenities = isset($category_amenities[$row ["category_id"]]) ? $category_amenities[$row ["category_id"]] : array();
                $category_photos = isset($photos[$row ["category_id"]]) ? $photos[$row ["category_id"]] : array();
                $category_photos_new = array();
                foreach($category_photos as $photos_data){
                    array_push($category_photos_new, array(
                       'img_url' => $photos_data['img_url'],
                       'is_main' => (bool)$photos_data['is_main']
                    ));
                }
                $bedrooms = $row ["bedrooms"];
                $is_coomon_room = $row ["is_coomon_room"];
                $room_beds = array();
                if ($bedrooms > 0) {
                    for ($room_i = 0; $room_i <= $bedrooms; $room_i ++) {
                        if ($is_coomon_room == 0 && $room_i == 0) {
                            continue;
                        }
                        $room_beds[$room_i]["room_inc"] = $room_i;
                        if ($room_i == 0) {
                            $room_beds[$room_i]["room_name"] = $this->mlanguages->getdictionaryword("admin_roomscategories_insert", $this->lang, "{caption_Living_Room}");
                        } else {
                            $room_beds[$room_i]["room_name"] = $this->mlanguages->getdictionaryword("admin_roomscategories_insert", $this->lang, "{caption_Room}") . $room_i;
                            
                            if(isset($subrooms_data[$row ["category_id"]][$room_i])){
                                $view_id = $subrooms_data[$row ["category_id"]][$room_i]["view"];
                                $view_name = '';
                                if(isset($bed_room_view_type_data[$view_id]["view_type_name"])){
                                    $view_caption = $bed_room_view_type_data[$view_id]["view_type_name"];
                                    $view_name = $this->mlanguages->getdictionaryword("tbl_roomscategories_views", $this->lang, "$view_caption");
                                }
                                
                                //$room_beds[$room_i]["view"] = $view_name;
                                $room_beds[$room_i]["view"] = $view_id;
                            }
                        }
                                                
                        $b_i = 1;
                        $room_beds[$room_i]["beds_array"] = array();
                        if (isset($beds2rooms_data[$row ["category_id"]][$room_i])){
                            foreach ($beds2rooms_data[$row ["category_id"]][$room_i] as $bed_id => $quantity) {
                                if ($quantity == 0) {
                                    continue;
                                }
                                //$room_beds[$room_i]["beds_array"][$b_i]["beds_inc"] = $b_i;
                                $room_beds[$room_i]["beds_array"][$b_i]["beds_quantity"] = $quantity;
                                if(isset($beds[$bed_id])){
                                    $room_beds[$room_i]["beds_array"][$b_i]["beds_type"] = $this->mlanguages->getdictionaryword("tbl_dc_bed_types", $this->lang, $beds[$bed_id]['bed_name']);
                                }
                                
                                $b_i ++;
                            }
                        }
                        
                        //$room_beds[$room_i]["bed_count"] = $b_i - 1;
                    }
                    $room_beds_new = array();
                    foreach($room_beds as $room_beds_cell){
                        $beds_array_new = array();
                        foreach($room_beds_cell['beds_array'] as $beds_array_cell){
                            array_push($beds_array_new, $beds_array_cell);
                        }
                        $view_str = '';
                        if(isset($room_beds_cell['view'])){
                            $view_str = $room_beds_cell['view'];
                        }
                        array_push($room_beds_new, array(
                            'room_inc' => $room_beds_cell['room_inc'],
                            'room_name' => $room_beds_cell['room_name'],
                            'view' => (int)$view_str,
                            'beds_array' => $beds_array_new
                        ));
                    }
                }
                $fullname = '';
                $international_name_array = $this->internationalfields->get_value("category", $row ["category_id"], "international_name");
                
                if(isset($international_name_array[$global_language])){
                    $fullname = $international_name_array[$global_language];
                }
                $categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
                $categories [$row ["category_id"]] ["property_id"] = $row ["property_id"];
                //$categories [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $categories [$row ["category_id"]] ["shortname"] = $fullname;
                $categories [$row ["category_id"]] ["fullname"] = $fullname;
                $categories [$row ["category_id"]] ["basic_occupancy"] = $row ["places"];
                $categories [$row ["category_id"]] ["max_occupancy"] = $row ["add_places"];
                $categories [$row ["category_id"]] ["baby_places"] = $row ["baby_places"];
                $categories [$row ["category_id"]] ["room_type"] = $room_type;
                $categories [$row ["category_id"]] ["descriptions"] = $descriptions;
                $categories [$row ["category_id"]] ["size"] = $row ["size"];
                $categories [$row ["category_id"]] ["size_type"] = $size_type;
                $categories [$row ["category_id"]] ["size"] = $row ["size"];
                $categories [$row ["category_id"]] ["gender"] = $row ["gender"];
                $categories [$row ["category_id"]] ["photos"] = $category_photos_new;
                $categories [$row ["category_id"]] ["amenities_types"] = $amenities;
                $categories [$row ["category_id"]] ["beds"] = $room_beds_new;
                $categories [$row ["category_id"]] ["room_count"] = $row ["room_count"];
                //$categories [$row ["category_id"]] ["subrooms_data"] = (isset($subrooms_data[$row ["category_id"]])) ? $subrooms_data[$row ["category_id"]] : array();
            }
        }
        
        foreach($categories as &$cell){
            $amenities_types_new = array();
            foreach($cell['amenities_types'] as $amenities_types){
                $amenities = array();
                foreach($amenities_types["amenities"] as $amenities_cell){
                    array_push($amenities, $amenities_cell);
                }
                array_push($amenities_types_new, array(
                    'amenity_type_id' => $amenities_types['amenity_type_id'],
                    'amenity_type_name' => $amenities_types['amenity_type_name'],
                    'amenities' => $amenities
                ));
            }
            $cell['amenities_types'] = array();
            $cell['amenities_types'] = $amenities_types_new;
        }
        
        return $categories;
    }
    
    function get_rates(){
        $meal_policies = $this->mRates->get_meal_policies();
        $cancelation_policies = $this->mRates->get_cancelation_policies($this->lang);
        $languages_comment_array = array();
        $sql = "SELECT * FROM `descriptionlanguages`  WHERE is_active = 1";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $languages_comment_array[$row->id]["id"] = $row->id;
                $languages_comment_array[$row->id]["lang_name"] = $row->name_original;
                $languages_comment_array[$row->id]["international_comment"] = "";
                $languages_comment_array[$row->id]["dir_tag"] = "";
            }
        }
        $rates_data = array ();
        $sql = "SELECT rate.id as rate_id, rate.caption as rate_name, categories.id as category_id, 
        ratetocategory.maxplace, ratetocategory.baseplace, categories.places as category_places, 
        categories.add_places as category_add_places, rate.cancellation_policy_id, rate.meal_policy_id 
        FROM ratetocategory
        INNER JOIN rate ON rate.id = ratetocategory.rate_id
        INNER JOIN categories ON categories.id = ratetocategory.category_id
        INNER JOIN onlinerates_echannel ON rate.id = onlinerates_echannel.rateid
       
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1";

//         	    	    echo $sql."<br>";
//         	    	    die();
        $query = $this->db->query ( $sql );
        $counter = 0;
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $meal_policy = '';
                if(isset($meal_policies[$row['meal_policy_id']])){
                    $meal_policy_clt = $meal_policies[$row['meal_policy_id']]['meal_policy_name'];
                    $meal_policy = $this->mlanguages->getdictionaryword("tbl_meal_policies", $this->lang, $meal_policy_clt);
                }
                $cancellation_policy = array();
                if(isset($cancelation_policies[$row['cancellation_policy_id']])){
                    $cancellation_policy = $cancelation_policies[$row['cancellation_policy_id']];
                }
                $international_comment_array = $this->internationalfields->get_value("rate", $row ["rate_id"], "international_description");
                $descriptions  = array();
                foreach ($languages_comment_array as $lang_cell) {
                    array_push($descriptions, array(
                        'lang_id' => $lang_cell['id'],
                        'lang_name' => $lang_cell['lang_name'],
                        'comment' => isset($international_comment_array[$lang_cell['id']]) ? $international_comment_array[$lang_cell['id']] : '',
                    ));
                }
                $rates_data [$row ["rate_id"]] ["rate_id"] = $row ["rate_id"];
                $rates_data [$row ["rate_id"]] ["rate_name"] = $row ["rate_name"];
                $rates_data [$row ["rate_id"]] ["meal_policy_id"] = $row['meal_policy_id'];
                $rates_data [$row ["rate_id"]] ["meal_policy"] = $meal_policy;
                if(count($cancellation_policy) > 0){
                    $rates_data [$row ["rate_id"]] ["cancellation_policy"] = $cancellation_policy;
                }
                $rates_data [$row ["rate_id"]] ["descriptions"] = $descriptions;
                $rates_data [$row ["rate_id"]] ["categories"][$row ["category_id"]]["category_id"] = $row ["category_id"];
                $rates_data [$row ["rate_id"]] ["categories"][$row ["category_id"]]["category_places"] = $row ["category_places"];
                $rates_data [$row ["rate_id"]] ["categories"][$row ["category_id"]]["category_add_places"] = $row ["category_add_places"];
            }
        }
    
        return $rates_data;
    }
    
    function room_rates_sync()
    {
        if ($this->releases->get_echannel_state() == 1) {
            $property_data = $this->property_model->get_property_data_echannel();
            foreach($property_data as &$cell){
                $without_foto_src = 1; // без повернення тега src
                $property_fotos = $this->property_model->get_property_fotos_echannel($cell['property_id'], $without_foto_src);
                $cell['property_fotos'] = $property_fotos;
            }
            $categories_data = $this->get_rooms();
            $rates_data = $this->get_rates();
            $payment_types_data = $this->get_payment_types();
//             echo "<pre>";
//             print_r($property_data);
//             die();
            $echannel_host = $this->config->item('echannel_host');
            $arr = array();
            $arr['hotel_id'] = $this->config->item('hotel_id');
            //$arr['hotel_name'] = $this->config->item('hotel_id');
            $arr['properties'] = $property_data;
            $arr['categories'] = $categories_data;
            $arr['rates'] = $rates_data;
            $arr['payment_types'] = $payment_types_data;
//                         echo "<pre>";
//                         print_r($arr);
//                         die();
            $array_json = json_encode($arr);
            $url = "https://$echannel_host/echannel/set_room_rates";
            $data_result = $this->Curl_model->CurlPlugRaw_echannel($array_json, $url);

            $sync_status = "Failed";
            if($data_result == "OK"){
                $sync_status = "OK";
            }
            
            /*
             *
             * ==== SAVE SYNC LOG =====
             *
             */
            $sync_log_data = array();
            $sync_log_data["date"] = date("Y-m-d H:i:s");
            $sync_log_data["user_id"] = $_SESSION["user"]["id"];
            $sync_log_data["status"] = $sync_status;
            if($sync_status == "Failed"){
                $sync_log_data["details"] = $data_result;
            }else{
                $sync_log_data["details"] = "";
            }
//             echo "<pre>";
//             print_r($sync_log_data);
//             die();
            $this->save_sync_log($sync_log_data);
        }
    }
    
    function sync_data()
    {
        if ($this->releases->get_echannel_state() == 1) {
            $categories_data = $this->get_rooms();
            $rates_data = $this->get_rates();
    
            $echannel_host = $this->config->item('echannel_host');
            $arr = array();
            $arr['hotel_id'] = $this->config->item('hotel_id');
            $arr['categories'] = $categories_data;
            $arr['rates'] = $rates_data;
            $array_json = json_encode($arr);
            $url = "https://$echannel_host/echannel/set_room_rates";
            $data_result = $this->Curl_model->CurlPlugRaw_echannel($array_json, $url);
            $sync_status = "Failed";
            if($data_result == "OK"){
                $sync_status = "OK";
            }
    
            /*
             *
             * ==== SAVE SYNC LOG =====
             *
             */
            $sync_log_data = array();
            $sync_log_data["date"] = date("Y-m-d H;i:s");
            $sync_log_data["user_id"] = $_SESSION["user"]["id"];
            $sync_log_data["status"] = $sync_status;
            if($sync_status == "Failed"){
                $sync_log_data["details"] = $data_result;
            }else{
                $sync_log_data["details"] = "";
            }
    
            $this->save_sync_log($sync_log_data);
        }
    }
    
    function save_sync_log($data){
        $this->db->insert('echannel_log', $data);
    }
    
    function save_additional_options($data){
        $this->db->query("INSERT INTO hotelix_config (name, value) VALUES ('echannel_source_id', " .
            $data['source_id'] .
            ") ON DUPLICATE KEY UPDATE value = " .
            $data['source_id']);
    }
    
    function insert_payment($data)
    {
        $payment_type_id = 1;
//         $query2 = $this->db->query("SELECT int_value FROM dc_onetwotrip_xml_cfg WHERE name LIKE 'payment_type'");
    
//         if ($query2->num_rows() > 0) {
//             $row2 = $query2->row();
//             $payment_type_id = $row2->int_value;
//         }
    
        $partner_id = 1;
        $query = $this->db->query ( "SELECT id FROM partners WHERE isdefault = 1" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $partner_id = $row->id;
        }
    
        $sql = "INSERT INTO payment (reservation_id, amount, create_time, operationtime, description, type, id_partner) VALUES('" . $data["reservation_id"] . "', '" . $data["amount"] . "',
        '" . date("Y-m-d") . "', '" . date("Y-m-d") . "', '" . addslashes($data["description"]) . "', $payment_type_id, $partner_id)";
        $query = $this->db->query($sql);
        $pay_id = $this->db->insert_id ();
    
        // log data
        $log_data = array();
        $log_data ["s_id"] = $pay_id;
        $log_data ["description"] = "all fields";
        $log_data ["res_id"] = $data["reservation_id"];
        $log_data ["amount"] = $data["amount"];
        $this->loger->SaveLog ( $log_data, "pay", "save" );
    
        // recalculate reservation balance
        $this->frontdesk->SetReservationBalance ( $data ["reservation_id"] );
    }
    
    function Insert_refund($data, $need_return = 0) {
		$time = date ( "Y-m-d H:i:s" );
		$this->db->trans_begin ();
		$id_user = isset($_SESSION ['user'] ["id"]) ? $_SESSION ['user'] ["id"] : -1;

		if (!isset($data ["id_partner"])){
			$data ["id_partner"] = 0;
		}
		$sql = "INSERT INTO `refund` (reservation_id, id_user, id_partner, amount, type, reason, description, time, operationtime)
		VALUES(" . $data ["res_id"] . ", '".$id_user."', " . $data ["id_partner"] . ", " . $this->tofloat ( $data ["amount"] ) . ", " . $data ["type"] . ", '" . $data ["reason"] . "', '" . addslashes ( $data ["description"] ) . "', '" . $time . "', '" . $data ["operationtime"] . "')";
		echo $sql;
		$query = $this->db->query ( $sql );
		$refund_id = $this->db->insert_id ();
		$this->SetReservationBalance ( $data ["res_id"] );

		$log_data ["s_id"] = $refund_id;
		$log_data ["res_id"] = $data ["res_id"];
		$log_data ["description"] = "all fields";
		$log_data ["amount"] = $data ["amount"];
		$this->loger->SaveLog ( $log_data, "refund", "save" );
		if ($this->db->trans_status () === FALSE) {
			$this->db->trans_rollback ();
			redirect ( '/reservations/error/' );
		}
		return $refund_id;
	}
}
?>