<?
class dcm_su_api extends dcm_abstract {
	public function __construct() {
	    $this->load->model ( 'dcm_su' );
	}
	
	function delete_property_su_value(){
	    $sql = "TRUNCATE TABLE dc_su_api_properties_active";
	    $query = $this->db->query ( $sql );
	}
	
	function update_property_su($hms_property_id){
	    $sql = "INSERT INTO dc_su_api_properties_active (hms_property_id) VALUES($hms_property_id)";
	    $query = $this->db->query ( $sql );
	}
	
	function delete_category_su_value(){
	    $sql = "TRUNCATE TABLE dc_su_api_categories_active";
	    $query = $this->db->query ( $sql );
	}
	
	function update_category_su($hms_cat_id){
	    $sql = "INSERT INTO dc_su_api_categories_active (hms_category_id) VALUES($hms_cat_id)";
	    $query = $this->db->query ( $sql );
	}
	
	function delete_rates_su_value(){
	    $sql = "TRUNCATE TABLE dc_su_api_rates_active";
	    $query = $this->db->query ( $sql );
	}
	
	function update_rates_su( $data ){
	    foreach($data["web_active"] as $rate_id => $web_active){
	        $restrictid = (isset($data["restrictid"][$rate_id])) ? $data["restrictid"][$rate_id] : 0;
	        $sql = "INSERT INTO dc_su_api_rates_active (hms_rate_id, restrictid) VALUES('".$rate_id."', '".$restrictid."')";
	        $this->db->query ( $sql );
	    }
	}
	
	function delete_contacts_su_value(){
	    $sql = "TRUNCATE TABLE dc_su_api_contacts_active";
	    $query = $this->db->query ( $sql );
	}
	
	function update_contacts_su($hms_contact_id){
	    $sql = "INSERT INTO dc_su_api_contacts_active (hms_contact_id) VALUES($hms_contact_id)";
	    $query = $this->db->query ( $sql );
	}
	
	function sync(){
	    $sync_status = 'OK';
	    $curl_results = array();
	    // ====== CREATE | UPDATE PROPERTIES ====================
	    $su_properties_response = $this->dcm_su->get_hotels();
	    $su_properties = array();
	    if(isset($su_properties_response['properties'])){
	       foreach($su_properties_response['properties'] as $cell){
	           $su_properties[$cell['propertyid']] = 1;
	       }
	    }
	    
	    $su_properties_link = array();
	    $sql = "SELECT * FROM dc_su_properties_link";
	    $query = $this->db->query( $sql );
	    foreach($query->result() as $row) {
	        $su_properties_link[$row->hms_property_id] = $row->su_property_id;
	    }
	    
	    $curl_results['create_properties'] = array();
	    $sql = "SELECT hms_property_id FROM dc_su_api_properties_active";
	    $query = $this->db->query( $sql );
	    foreach($query->result() as $row) {
	        if(isset($su_properties_link[$row->hms_property_id]) && isset($su_properties[$su_properties_link[$row->hms_property_id]])){
	            $data = array('su_property_id' => $su_properties_link[$row->hms_property_id], 'get_result' => 1);
	            $result_property = $this->dcm_su->property_update($data);
	        }else{
	            $data = array('property_id' => $row->hms_property_id, 'get_result' => 1);
	            $result_property = $this->dcm_su->property_create($data);
	        }
            $curl_results['create_properties'][$row->hms_property_id] = $result_property;
            if($result_property['create_status'] != 'Success'){
                $sync_status = 'Failed';
            }
	    }
	    
	    // ====== CREATE | UPDATE CATEGORIES =====================
	    $curl_results['create_categories'] = array();
	    $sql_active = "SELECT hms_category_id FROM dc_su_api_categories_active";
        $query_active = $this->db->query($sql_active);
        foreach ($query_active->result() as $row_active) {
            $hms_category_id = $row_active->hms_category_id;
            $su_property_id = '';
            $sql = "SELECT dc_su_properties_link.su_property_id FROM categories 
	                   INNER JOIN dc_su_properties_link ON categories.property_id = dc_su_properties_link.hms_property_id 
	                   WHERE categories.id = $hms_category_id";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $su_property_id = $row->su_property_id;
            }
            
            if ($su_property_id != '') {
                $data = array(
                    'su_property_id' => $su_property_id,
                    'hms_category_id' => $hms_category_id
                );
                $create_result = $this->dcm_su->create_room($data);
                echo "<pre>";
                print_r($create_result);
                echo "<br>";
                $curl_results['create_categories'][$hms_category_id] = $create_result;
                if (isset($create_result['curl_response']['Status'])) {
                    if ($create_result['curl_response']['Status'] == 'Success') {
                        // ========= IMPORT DATA ========
                        $this->dcm_su->import_room_rates();
                        // ========= BIND ========
                        $hms_id = $this->config->item('hotel_id');
                        $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                        $su_room_id = "$hms_id-$hms_property_id-$hms_category_id";
                        $this->dcm_su->bind_rooms(array(
                            'hms_room_id' => $hms_category_id,
                            'su_room_id' => $su_room_id,
                            'su_property_id' => $su_property_id
                        ));
                    } else {
                        $sync_status = 'Failed';
                        if ($create_result['curl_response']['Status'] == 'Fail') {
                            if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                                if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exists') {
                                    // $this->dcm_su->update_su_properties_cfg(array('su_property_id' => $create_result['su_property_id']));
                                    $this->dcm_su->import_room_rates();
                                    
                                    // ========= BIND ========
                                    $hms_id = $this->config->item('hotel_id');
                                    $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                                    $su_room_id = "$hms_id-$hms_property_id-$hms_category_id";
                                    $this->dcm_su->bind_rooms(array(
                                        'hms_room_id' => $hms_category_id,
                                        'su_room_id' => $su_room_id,
                                        'su_property_id' => $su_property_id
                                    ));
                                }
                            }
                        }
                    }
                    
                    $session_data = array(
                        'header_msg_text' => json_encode($create_result['curl_response'])
                    );
                    $this->session->set_userdata($session_data);
                }
            }
	    }
            
            // ====== CREATE | UPDATE RATES ======================
	    $curl_results['create_rates'] = array();
        $sql_active = "SELECT hms_rate_id FROM dc_su_api_rates_active";
        $query_active = $this->db->query($sql_active);
        foreach ($query_active->result() as $row_active) {
            $hms_rate_id = $row_active->hms_rate_id;
            
            $sql = "SELECT su_property_id FROM dc_su_properties_link";
            $query = $this->db->query($sql);
            foreach ($query->result() as $row) {
                $su_property_id = $row->su_property_id;
                $data = array(
                    'su_property_id' => $su_property_id,
                    'hms_rate_id' => $hms_rate_id
                );
                $create_result = $this->dcm_su->create_rate($data);
                echo "<pre>";
                print_r($create_result);
                echo "<br>";
                $curl_results['create_rates'][$hms_rate_id] = $create_result;
                if (isset($create_result['curl_response']['Status'])) {
                    if ($create_result['curl_response']['Status'] == 'Success') {
                        // ========= IMPORT DATA ========
                        $this->dcm_su->import_room_rates();
                        // ========= BIND ========
                        $hms_id = $this->config->item('hotel_id');
                        $hms_property_id = $this->dcm_su->get_hms_prop_id_by_su_prop_id($su_property_id);
                        $su_rate_id = "$hms_id-$hms_property_id-$hms_rate_id";
                        $this->dcm_su->bind_rates(array(
                            'hms_rate_id' => $hms_rate_id,
                            'su_rate_id' => $su_rate_id,
                            'su_property_id' => $su_property_id
                        ));
                    } else {
                        $sync_status = 'Failed';
                        if ($create_result['curl_response']['Status'] == 'Fail') {
                            if (isset($create_result['curl_response']['Errors']['ShortText'])) {
                                if ($create_result['curl_response']['Errors']['ShortText'] == 'Room Already Exist') {
                                    // ========= IMPORT DATA ========
                                    $this->dcm_su->import_room_rates();
                                    // ========= BIND ========
                                    $hms_id = $this->config->item('hotel_id');
                                    $hms_property_id = $this->get_hms_prop_id_by_su_prop_id($su_property_id);
                                    $su_rate_id = "$hms_id-$hms_property_id-$hms_rate_id";
                                    $this->dcm_su->bind_rates(array(
                                        'hms_rate_id' => $hms_rate_id,
                                        'su_rate_id' => $su_rate_id,
                                        'su_property_id' => $su_property_id
                                    ));
                                }
                            }
                        }
                    }
                    
                    $session_data = array(
                        'header_msg_text' => json_encode($create_result['curl_response'])
                    );
                    $this->session->set_userdata($session_data);
                }
            }
        }
        
        // ==== SAVE SYNC LOG =====        
        $sync_log_data = array();
        $sync_log_data["date"] = date("Y-m-d H:i:s");
        $sync_log_data["user_id"] = $_SESSION["user"]["id"];
        $sync_log_data["status"] = $sync_status;
        if($sync_status == "Failed"){
            $sync_log_data["details"] = json_encode($curl_results);
        }else{
            $sync_log_data["details"] = "";
        }
        //             echo "<pre>";
        //             print_r($sync_log_data);
        //             die();
        $this->save_sync_log($sync_log_data);
    }
	
    function save_sync_log($data){
        $this->db->insert('dc_su_api_log', $data);
    }
    
    public function get_su_channels() {
        $su_channels = array();
        $sql = "SELECT * FROM dc_su_channels WHERE display = 1";
        $query = $this->db->query( $sql );
        foreach($query->result() as $row) {
            $su_channels[$row->channel_code]['channel_code'] = $row->channel_code;
            $su_channels[$row->channel_code]['channel_name'] = $row->channel_name;
            $su_channels[$row->channel_code]['encrypted_channel_code'] = $row->encrypted_channel_code;
        }
        return $su_channels;
    }
    
    public function get_mappings( $hotel_id )
    {
    
        $url = $this->url . 'mappings';
    
        $data = [
            'hotelid' 	=> $hotel_id,
            //'channelid' => $channel
        ];
    
        if($this->test_mode == 1){
            $headers = array(
                'Authorization: Basic ' . $this->auth,
                'Content-Type: application/json'
            );
        }else{
            $headers = array(
                'Authorization: Basic ' . $this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json'
            );
        }
    
        $ch = curl_init();
    
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data) );
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');
    
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
    
    
        curl_close($ch);
    
        $result = json_decode($buffer, true);
        //echo "<pre>";
        //print_r( [ $information, $buffer, json_encode($data) ] );
        
        return $result;
         
    }
    
    public function mapping( $hotel_id, $channel = 0 )
    {
        $url = 'https://connect.su-api.com/SUAPI/jservice/widget/getWidgetAccessToken';
    
        $data = [
            'hotelid' 	=> $hotel_id
        ];
    
        if($this->test_mode == 1){
            $headers = array(
                'Authorization: Basic ' . $this->auth,
                'Content-Type: application/json'
            );
        }else{
            $headers = array(
                'Authorization: Basic ' . $this->auth,
                'app-id: b3RlbG1zLnN1aXNzdS5jb20=',
                'Content-Type: application/json'
            );
        }
    
        //array_push($headers, 'Content-Type: application/json');
         
        $ch = curl_init();
    
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data) );
        curl_setopt($ch, CURLOPT_USERAGENT, 'Otelms');
    
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
    
    
        curl_close($ch);
    
        $result = json_decode($buffer, true);
    
        return $result;
    }
    
    
}