<?php 
class dcm_hotelbook extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 17;
        $this->table_name_r2c = "dc_hotelbook_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_hotelbook_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_hotelbook_room_categories_link";
        
        
        $this->sql_dc_rates = "select  dc_hotel_id, dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_hotelbook_rates";
        $this->sql_dc_category_link = "select dc_hotelbook_room_categories.dc_hotel_id, dc_hotelbook_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_category_id as dc_category_id,
            hms_category_id as hms_category_id
            from dc_hotelbook_room_categories_link 
            inner join dc_hotelbook_room_categories on 
            dc_hotelbook_room_categories_link.dc_category_id = dc_hotelbook_room_categories.dc_room_id 
        	LEFT join categories on 
            categories.id = dc_hotelbook_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_hotelbook_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_hotelbook_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select dc_hotel_id, name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_hotelbook_room_categories";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_hotelbook_category2occupancy";
        $this->form_action_c2o_post = "/dc_hotelbook/categories_edit_post";
        $this->form_action_r2c_post = "/dc_hotelbook/rates_edit_post";
        
        $this->form_action_c2o_post_c2 = "/dc_hotelbook_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_hotelbook_c2/rates_edit_post";
    }
    
    function gethotelid($dc_account_id = 1) {
    	$hotelid = 0;
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name='hotel_id' AND dc_account_id = " . $dc_account_id);
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$hotelid = $row->int_value;
    	}
    	return $hotelid;
    }
    function get_api_url($dc_account_id = 1) { 
    	$data = array();
    	
    	$test_mode = 0;
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'test_mode' AND dc_account_id = " . $dc_account_id);
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$test_mode = $row->int_value;
    	}
    	$data["api_url"] = "http://api.hbconnect.ru";
    	
    	switch ($test_mode) {
    		case 0 :
    			//$data["api_url"] = "http://api.hbconnect.ru";    			
    			$data["api_url"] = "https://cm.hbconnect.ru/api/cm/otelms/endpoint";
    			
    			
    			break;
    		case 1 :
    			//$data["api_url"] = "http://api.test.hbconnect.ru";
    		    $data["api_url"] = "http://dev.hbconnect.ru/api/cm/otelms/endpoint";
    			break;
    	}
    	return $data;
    }
    function get_auth_api($dc_account_id = "") {
    	$data = array ();
    	if($dc_account_id <> ""){
			$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'hotel_id' AND dc_account_id = ".$dc_account_id;
    	}else{
    		$sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'hotel_id'";
    	}
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$hotel_id = $row->int_value;
		} else {
			$hotel_id = "none";
		}
		if($dc_account_id <> ""){
			$sql = "SELECT str_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'currency' AND dc_account_id = ".$dc_account_id;
		}else{
			$sql = "SELECT str_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'currency'";
		}
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$currency = $row->str_value;
		} else {
			$currency = "none";
		}
		
		$data ['hotel_id'] = $hotel_id;
		$data ['currency'] = $currency;
		
		return $data;
    }
    
    function get_version() {
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'version'" );
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$version = $row->int_value;
    	} else {
    		$version = 1;
    	}
    	$version = 2;
    	return $version;
    }
    
    function options_save($data) {
    	$data_1 = $this->Loger_admin->get_values_col("dc_hotelbook_xml_cfg");
    
    	$sql = "INSERT INTO dc_hotelbook_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotelbook_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotelbook_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotelbook_xml_cfg (name, int_value) VALUES('restrict_rate_id', '" . $data ["restrict_rate"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["restrict_rate"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_hotelbook_xml_cfg (name, int_value) VALUES('version', '" . $data ["version"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["version"];
    	$query = $this->db->query ( $sql );
    	
    	$data_2 = $this->Loger_admin->get_values_col("dc_hotelbook_xml_cfg");
    	$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "dc_hotelbook_xml_cfg", "edit");
    }
	function bokking_xml_parse_repair($data, $hms_hotel_id) {
    	$rates = array ();
    	//echo "+++";
    	//echo "<pre>";
    	//print_r ( $data );
    	//die();
    
    	$result_array = array ();
    	 
    	foreach ( $data ["data"] as $dc_reservationid => $reservations ) {
    		$query = $this->db->query ( "SELECT id, room_id, dc_uuid, datein, dateout FROM deskofreservation WHERE cancel = 1 AND dc_id = 17 AND dc_uuid = " . $dc_reservationid );
    			
    		if ($query->num_rows () > 0) {
    			foreach ( $query->result () as $row ) {
    				if ($reservations ["orderStatusTitle"] == "CONFIRMED" || $reservations ["orderStatusTitle"] == "CHANGES_PENDING") {
    					list ( $year, $month, $day ) = explode ( "-", $row->datein );
    					$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
    					list ( $year, $month, $day ) = explode ( "-", $row->dateout );
    					$intdateout = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );
    					
    					$query2 = $this->db->query ( "SELECT id FROM deskofdays WHERE room_id = ".$row->room_id." AND intdate >= ".$intdatein." AND intdate <= ".$intdateout);
    					if ($query2->num_rows () > 0) {
    						echo "break!!! hmsid-".$hms_hotel_id." rid-".$row->id."<br>";
    					}else{
    					
    						echo "repair hmsid-".$hms_hotel_id." rid-".$row->id."<br>";
    						$this->Cancel->CancelBack($row->id, 0, 1);
    					}
    				}
    			}
    		}
    	}
    }
    function bokking_xml_parse($data, $send_notification = 1, $special = array()) {
    	$rates = array ();
    	//echo "+++";
    	//echo "<pre>";
    	//print_r ( $data );
    	//die();
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id, dc_category_id FROM  dc_hotelbook_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_hotelbook_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    			$rates_names [$row->dc_rate_id] ["dc_rate_id"] = $row->dc_rate_id;
    		}
    	}
    
    	$categories = array ();
    
    	$query = $this->db->query ( "SELECT dc_category_id, roomtypeid, hms_category_id FROM dc_hotelbook_room_categories_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->roomtypeid] = $row->hms_category_id;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
        
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    
    	$checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
    	
    	if(isset($data ["data"]["response"])){
    		return json_encode($data ["data"], true);
    	}
    	if(isset($data ["data"]["results"])){
    		if($data ["data"]["results"] == 0){
    			return json_encode($data ["data"], true);
    		}
    	}
    	
    	$result_array = array ();
    	$i = 0;
    	foreach ( $data ["data"] as $dc_reservationid => $reservations ) {
			$result_array ["reservations"] [$i] ["reservation"] ["hotelbook_original_id"] = $dc_reservationid;
			$otelms_rooms = array ();
			$query = $this->db->query ( "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 17 AND dc_reservationid = " . $dc_reservationid );
			
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$otelms_rooms [$row->dc_uuid] ["otelms_reservation_id"] = $row->id;
					$otelms_rooms [$row->dc_uuid] ["dc_uuid"] = $row->dc_uuid;
					$otelms_rooms [$row->dc_uuid] ["status"] = 0;
				}
			}
			
			// print_r ( $otelms_rooms );
			
			$result_array ["reservations"] [$i] ["dc_rate_id"] = 1;
			$result_array ["reservations"] [$i] ["currencycode"] = "";
			
			$result_array ["reservations"] [$i] ["card"] ["cc_cvc"] = "";
			
			$result_array ["reservations"] [$i] ["card"] ["ExpMonth"] = "";
			$result_array ["reservations"] [$i] ["card"] ["ExpYear"] = "";
			$result_array ["reservations"] [$i] ["card"] ["CardHolder"] = "";
			$result_array ["reservations"] [$i] ["card"] ["CardNumber"] = "";
			$result_array ["reservations"] [$i] ["card"] ["cc_type"] = "";
			
			$result_array ["reservations"] [$i] ["guest"] ["address"] = "";
			$result_array ["reservations"] [$i] ["guest"] ["city"] = "";
			$result_array ["reservations"] [$i] ["guest"] ["country"] = "";
			$result_array ["reservations"] [$i] ["guest"] ["email"] = "";
			
			$result_array ["reservations"] [$i] ["guest"] ["firstname"] = $reservations["clients"];
			$result_array ["reservations"] [$i] ["guest"] ["lastname"] = "";
			$result_array ["reservations"] [$i] ["guest"] ["phone"] = "";
			$result_array ["reservations"] [$i] ["guest"] ["passportid"] = "";
			
			$result_array ["reservations"] [$i] ["status"] = $reservations["orderStatusTitle"];
			$result_array ["reservations"] [$i] ["dc_reservationid"] = $dc_reservationid;
			
			$created_at_arr = explode ( " ", $reservations["createDate"] );
			$created_at = $created_at_arr [0];
			$created_at_time = $created_at_arr [1];
			
			$result_array ["reservations"] [$i] ["reservation"] ["dc_id"] = 17;
			
			$result_array ["reservations"] [$i] ["reservation"] ["commissionamount"] = 0;
			$result_array ["reservations"] [$i] ["reservation"] ["date"] = $created_at;
			$result_array ["reservations"] [$i] ["reservation"] ["dc_reservationid"] = $dc_reservationid;
			$result_array ["reservations"] [$i] ["reservation"] ["time"] = $created_at_time;
			$result_array ["reservations"] [$i] ["reservation"] ["isNew"] = 1;
			
			$result_array ["reservations"] [$i] ["reservation"] ["checkintime"] = $reservations["checkInTime"];
			$result_array ["reservations"] [$i] ["reservation"] ["checkouttime"] = $reservations["checkOutTime"];
			
			$datein = $reservations["dateIn"];
			$dateout = $reservations["dateOut"];
			$checkintime = $reservations["checkInTime"];
			$checkouttime = $reservations["checkOutTime"];
			
			$result_array ["reservations"] [$i] ["reservation"] ["datein"] = $datein;
			$result_array ["reservations"] [$i] ["reservation"] ["dateout"] = $dateout;
			
			list ( $year, $month, $day ) = explode ( "-", $datein );
			$intdate_in = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
			list ( $year, $month, $day ) = explode ( "-", $dateout );
			$intdate_out = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
			
			$result_array ["reservations"] [$i] ["reservation"] ["early_check_in_close"] = 0;
			$result_array ["reservations"] [$i] ["reservation"] ["late_check_out_close"] = 0;
			
			if ($intdate_in == $intdate_out || 1) {
				
				$str_checkintime = strtotime ( $checkintime );
				$str_checkouttime = strtotime ( $checkouttime );
				$system_checkouttime = strtotime ( $checkin_checkout_arr ["checkouttime"] );
				$system_checkintime = strtotime ( $checkin_checkout_arr ["checkintime"] );
				if ($str_checkintime < $system_checkouttime) {
					$result_array ["reservations"] [$i] ["reservation"] ["early_check_in_close"] = 1;
					$result_array ["reservations"] [$i] ["reservation"] ["early_check_in"] = 1;
					$datein_temp = gmdate ( "Y-m-d", ($intdate_in - 1) * 86400 );
					list ( $year, $month, $day ) = explode ( "-", $datein_temp );
					$intdate_in = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				}
				if ($str_checkouttime > $system_checkintime) {
					$result_array ["reservations"] [$i] ["reservation"] ["late_check_out_close"] = 1;
					$result_array ["reservations"] [$i] ["reservation"] ["late_check_out"] = 1;
					$dateout_temp = gmdate ( "Y-m-d", ($intdate_out + 1) * 86400 );
					list ( $year, $month, $day ) = explode ( "-", $dateout_temp );
					$intdate_out = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				}
			}
			
			
			
			
			
			$result_array ["reservations"] [$i] ["reservation"] ["dc_roomreservation_id"] = "";
			$result_array ["reservations"] [$i] ["reservation"] ["dc_uuid"] = $dc_reservationid;
			
			$result_array ["reservations"] [$i] ["reservation"] ["add_places"] = 0;
			$result_array ["reservations"] [$i] ["reservation"] ["baby_places"] = 0;
			$result_array ["reservations"] [$i] ["reservation"] ["amount"] = 0;
			
			$result_array ["reservations"] [$i] ["reservation"] ["description"] = "";
			
			if (isset ( $_SESSION ["user"] ["id"] )) {
				$result_array ["reservations"] [$i] ["reservation"] ["user"] = $_SESSION ["user"] ["id"];
			} else {
				$result_array ["reservations"] [$i] ["reservation"] ["user"] = -1;
			}
			
			$result_array ["reservations"] [$i] ["reservation"] ["category_id"] = $reservations ["roomType"];
			
			if (isset ( $categories [$reservations ["roomType"]] )) {
				$room_id = $categories [$reservations ["roomType"]];
				$result_array ["reservations"] [$i] ["reservation"] ["type_id"] = $room_id;
				$result_array ["reservations"] [$i] ["reservation"] ["reservation_type_name"] = "";
			} else {
				$result_array ["reservations"] [$i] ["reservation"] ["type_id"] = 0;
				$result_array ["reservations"] [$i] ["reservation"] ["reservation_type_name"] = "";
			}
			
			$result_array ["reservations"] [$i] ["reservation"] ["dealer"] = $dealer;
			$result_array ["reservations"] [$i] ["reservation"] ["dc_guestname"] = $reservations["clients"];
			$result_array ["reservations"] [$i] ["reservation"] ["dc_numberofguest"] = 1;
			$result_array ["reservations"] [$i] ["reservation"] ["dc_countrycode"] = "";
			$result_array ["reservations"] [$i] ["reservation"] ["dc_currencycode"] = $reservations["currencyCode"];
			$result_array ["reservations"] [$i] ["reservation"] ["dc_city"] = "";
			$result_array ["reservations"] [$i] ["reservation"] ["dc_customerremarks"] = $reservations["notes"];
			$result_array ["reservations"] [$i] ["reservation"] ["dc_roomremarks"] = "";
			if(isset($reservations["lastModified"])){
				$result_array ["reservations"] [$i] ["reservation"] ["dc_updatetime"] = $reservations["lastModified"];
			}
			
			$result_array ["reservations"] [$i] ["reservation"] ["dc_totalprice"] = $reservations["totalCost"];
			
			$result_array ["reservations"] [$i] ["reservation"] ["groupid"] = $reservations["connectedOrders"];
			
			$result_array ["reservations"] [$i] ["reservation"] ["smoking"] = "";
			$result_array ["reservations"] [$i] ["roomreservation_id"] = "";
			
			$p = 1;
			$duration = $intdate_out - $intdate_in;
			if ($duration > 0) {
				$day_price = $reservations["totalCost"] / $duration;
			} else {
				$day_price = 0;
			}
			
			$result_array ["reservations"] [$i] ["reservation"] ["service_main_amount_2"] = 2;
			
			foreach($reservations["costPerDay"] as $date => $cell){
				$dc_rate_id = $cell["rate_id"];
				list ( $year, $month, $day ) = explode ( "-", $date );
				$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["dc_reservation_id"] = $dc_reservationid;
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["price"] = $cell["price"];
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["dc_rate_id"] = $cell["rate_id"];
				if(isset($rates_names[$cell["rate_id"]])){
					$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["dc_rate_name"] = $rates_names [$cell["rate_id"]] ["dc_rate_name"];
				}else{
					$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["dc_rate_name"] = "";
				}
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["dc_currencycode"] = $reservations["currencyCode"];
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["intdate"] = $intdate;
				$result_array ["reservations"] [$i] ["per_day"] [$intdate] ["date_rate"] = $date;
				
				$result_array ["reservations"] [$i] ["reservation"] ["day_price"] [$intdate] = $cell["price"];
				
				
			}
			
			if (isset ( $rates [$dc_rate_id] [$reservations ["roomType"]]  )) {
				$result_array ["reservations"] [$i] ["reservation"] ["price_type"] = $rates [$dc_rate_id] [$reservations ["roomType"]];
			} else {
				$result_array ["reservations"] [$i] ["reservation"] ["price_type"] = $price_type;
			}
			$i ++;
		}
    	
    	echo "<pre>";
    	print_r ( $result_array );
    	//die();
    		
    	$host = "";
    	if ($_SERVER ["HTTP_HOST"]) {
    		$host = $_SERVER ["HTTP_HOST"];
    	}
    		
    		
    	$reservationpush = array ();
    	$log_data = array();
    	$log_data = "empty";
    	
    	if (isset ( $result_array ["reservations"] )) {
    		$k = 0;
    		$bool_guest = 0;
    		$bool_cancel = 0;
    		$guest_array = array ();
    		$guest_counter = 1;
    		$r_i = 0;
    		foreach ( $result_array ["reservations"] as $reservations ) {
    			$query = $this->db->query("SELECT id, dc_updatetime FROM deskofreservation WHERE dc_id = 17 AND dc_uuid LIKE '" . $reservations ["reservation"] ["dc_uuid"] . "'");
    			
    			if ($query->num_rows() > 0) {
    				$row_sql = $query->row();
    				if($row_sql->dc_updatetime == $reservations["reservation"]["dc_updatetime"]){
    					$reservationpush[$k]["response"] = "skip";
    					$reservationpush[$k]["text"] = "modified time is simple";
    					$reservationpush[$k]["alert"] = "modified time is simple";
    					$reservationpush[$k]["status"] = $reservations ["status"];
    					$reservationpush[$k]["hms_reservation_id"] = $row_sql->id;
    					$reservationpush[$k]["dc_reservationid"] = $reservations ["reservation"] ["dc_uuid"];
    					$reservationpush[$k]["dc_roomreservation_id"] = "";
    					$reservationpush[$k]["dc_room_id"] = $reservations["reservation"]["category_id"];
    					
    					$result_array ["reservations"] [$r_i]["status"] = "skip";
    					
    					if(isset($otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"])){
    						$otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"] = 1;
    					}
    					$k++;
    					$r_i++;
    					continue;
    				}
    			}
    			$amount = 0;
    			foreach ( $reservations ["per_day"] as $per_day ) {
    				$amount += $per_day["price"];
    			}
    			$reservations["reservation"] ["amount"] = $amount;
    	
    			$calculate_data = array ();
    			$calculate_data ["type_id"] = $reservations["reservation"] ["type_id"];
    			$calculate_data ["datein"] = $reservations["reservation"] ["datein"];
    			$calculate_data ["dateout"] = $reservations["reservation"] ["dateout"];
    			$calculate_data ["add_places"] = $reservations["reservation"] ["add_places"];
    			$calculate_data ["baby_places"] = $reservations["reservation"] ["baby_places"];
    			$calculate_data ["addbedplace"] = 0;
    			$calculate_data ["babyplace2"] = 0;
    			$calculate_data ["price_type"] = $reservations["reservation"] ["price_type"];
    	
    			$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
    			$otelms_amount = 0;
    			for($p = 0; $p < count ( $temp_amount ); $p ++) {
    				$otelms_amount += $temp_amount [$p] ["amount"];
    			}
    			$booking_amount = $reservations["reservation"] ["amount"];
    			$reservations["reservation"] ["discount"] = 0;
    			if ($booking_amount != $otelms_amount) {
    				//if ($otelms_amount != 0) {
    					$reservations["reservation"] ["discount"] = $otelms_amount - $booking_amount;
    				//}
    			}
    	
    			//=====================================================
    			//=====================================================
    			//=====================================================
    	
    			$datein = $reservations["reservation"] ["datein"];
    			$dateout = $reservations["reservation"] ["dateout"];
    			$type_id = $reservations["reservation"] ["type_id"];
    			//$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel = 0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations["reservation"] ["dc_uuid"] . "' ORDER BY id DESC ";
    				
    			$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel = 0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations ["reservation"] ["dc_uuid"] . "' ORDER BY id DESC ";
    			//echo $sql."<br>";
    			$query = $this->db->query ( $sql );
    			$hms_reservation_id = 0;
    			$otelms_room_id = 0;
    			if ($query->num_rows () > 0) {
    				$row = $query->row ();
    				$hms_reservation_id = $row->id;
    				$otelms_room_id = $row->room_id;
    			}
    			echo $hms_reservation_id."+++++++++++++++";
    			//die ();
    			//$reservations["reservation"] ["dc_totalprice"] = 0;
    			foreach ( $reservations["per_day"] as $cell ) {
    				//$reservations["reservation"] ["dc_totalprice"] += $cell ["price"];
    				$reservations["reservation"] ["amount"] += $cell ["price"];
    			}
    			if (isset ( $reservations["per_day"] )) {
    	
    				$this->dc_rate_intdate_insert ( $reservations["per_day"] );
    			}
    	
    			if ($reservations ["status"] == "Correction") {
    				$reservations["reservation"] ["specialstatus"] = "Correction";
    			}
    	
    			if ($reservations["status"] == "CANCELLED") {
    	
    				$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $hms_reservation_id" );
    					
    				if ($query2->num_rows () > 0) {
    					$row2 = $query2->row ();
    					$datein = $row2->datein;
    					$dateout = $row2->dateout;
    					$type_id = $row2->category_id;
    				}
    	
    				$time2 = date ( "Y-m-d H:i:s" );
    				$status = 5;
    				$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    	
    				if ($query2->num_rows () > 0) {
    					$reservationpush [$k] ["response"] = "failed";
    					$reservationpush [$k] ["text"] = "есть уже отмена";
    					$reservationpush [$k] ["status"] = "cancel";
    					$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    					$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    					$reservationpush [$k] ["dc_reservationid"] = $reservations ["reservation"] ["dc_reservationid"];
    					
    					$k ++;
    	
    					$dc_log_data = array ();
    					$dc_log_data ["datein"] = $datein;
    					$dc_log_data ["dateout"] = $dateout;
    					$dc_log_data ["category_id"] = $type_id;
    					$this->frontdesk->dc_log_update ( $dc_log_data );
    				} else {
    					$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id );
    	
    					if ($query2->num_rows () > 0) {
    						$data_cancel = array ();
    	
    						$data_cancel ["res_id"] = $hms_reservation_id;
    						$data_cancel ["charge"] = 0;
    						$data_cancel ["status"] = 5;
    						;
    						$data_cancel ["description"] = "cancel from 101otel";
    						$data_cancel ["guestbe_request"] = 0;
    						$data_cancel ["user"] = - 1;
    						// ====================
    						$this->Cancel->Insert ( $data_cancel );
    						// ====================
    						$reservationpush [$k] ["response"] = "ok";
    						$reservationpush [$k] ["text"] = "";
    						$reservationpush [$k] ["status"] = "cancel";
    						$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						
    						$k ++;
    					} else {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "нет брони для отмены";
    						$reservationpush [$k] ["status"] = "cancel";
    						$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = 0;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						
    						$k ++;
    					}
    				}
    			} else {
    	
    				if($hms_reservation_id == 0){
    					/*
    					 * NEW RESERVATION BLOCK
    					*/
    	
    					$room_id = 0;
    	
    					if ($type_id == 0 or $type_id == "") {
    						$query2 = $this->db->query ( "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    						if ($query2->num_rows () > 0) {
    							$row2 = $query2->row ();
    							$type_id = $row2->int_value;
    							$reservations["reservation"]["origin_categoryid"] = -1;
    						}
    					}
    						
    					if ($type_id == 0 or $type_id == "") {
    						$reservationpush [$k] ["response"] = "error";
    						$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    						$reservationpush [$k] ["status"] = "update";
    						$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						
    						$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k ++;
    					} else {
    						$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservations["reservation"]["early_check_in_close"], $reservations["reservation"]["late_check_out_close"] );
    	
    						if ($room_id == 0) {
    							$reservations["reservation"] ["is_overbook"] = 1;
    							if (isset ( $overbooking_category_id )) {
    								$reservations["reservation"] ["origin_categoryid"] = $type_id;
    								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservations["reservation"]["early_check_in_close"], $reservations["reservation"]["late_check_out_close"]  );
    	
    								$insert_over_room_bool = 0;
    								if ($room_id == 0) {
    									$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    									$insert_over_room_bool = 1;
    								}
    								
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "no overbooking_category_id";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    								
    								$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							}
    						}
    						$reservations["reservation"] ["room_id"] = $room_id;
    	
    						if ($bool_guest == 0) {
    							if ($reservations ["status"] == "Correction") {
    								if (isset ( $guest_array [$i])) {
    									$guest_id = $guest_array [$i];
    								} else {
    									$guest_id = $this->frontdesk->Guest_insert ( $reservations["guest"] );
    								}
    							} else {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations["guest"] );
    								//$bool_guest = 1;
    							}
    						}
    	
    						// echo "<pre>";
    						// print_r ( $reservations["reservation"] );
    						// die ();
    						$reservation_id = $this->frontdesk->Reservation_insert ( $reservations["reservation"], $guest_id, 0, 1 );
    						//echo $reservation_id;
    						//die();
    						if(isset($otelms_rooms[$reservations ["reservation"] ["dc_uuid"]])){
    							$otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    	
    						if (isset ( $reservations["card"] )) {
    							$this->frontdesk->insert_tbl_CreditCards ( $reservations["card"], $guest_id, $reservation_id );
    						}
    	
    						if ($reservation_id > 0) {
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "new";
    							$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							
    							$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						} else {
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "undferror";
    							$reservationpush [$k] ["status"] = "new";
    							$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							
    							$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						}
    					}
    				}else{
    					/*
    					 * UPDATE RESERVATION BLOCK
    					*
    					*/
    					if($reservations ["status"] == "Booking"){
    						if(isset($otelms_rooms[$reservations ["reservation"] ["dc_uuid"]])){
    							$otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    						$reservationpush [$k] ["response"] = "okskip";
    						$reservationpush [$k] ["text"] = "есть в системе";
    						$reservationpush [$k] ["status"] = "new";
    						$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    						
    						$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    						$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    						$k++;
    						continue;
    					}
    	
    					$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
    						
    					//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
    	
    					$reservation_data ["firstname"] = $reservations["guest"] ["firstname"];
    					$reservation_data ["lastname"] = $reservations["guest"] ["lastname"];
    					$reservation_data ["phone"] = $reservations["guest"] ["phone"];
    					$reservation_data ["email"] = $reservations["guest"] ["email"];
    	
    					$reservation_data ["amount"] = $reservations["reservation"] ["amount"];
    					$reservation_data ["discount"] = $reservations["reservation"] ["discount"];
    					$reservation_data ["date"] = $reservations["reservation"] ["date"];
    					$reservation_data ["add_places"] = $reservations["reservation"] ["add_places"];
    					$reservation_data ["baby_places"] = $reservations["reservation"] ["baby_places"];
    					$reservation_data ["datein"] = $reservations["reservation"] ["datein"];
    					$reservation_data ["dateout"] = $reservations["reservation"] ["dateout"];
    						
    						
    						
    					$reservation_data ["checkintime"] = $reservations["reservation"] ["checkintime"];
    					$reservation_data ["checkouttime"] = $reservations["reservation"] ["checkouttime"];
    	
    	
    					//$reservation_data ["type_id"] = $reservations["reservation"] ["type_id"];
    					$reservation_data ["price_type"] = $reservations["reservation"] ["price_type"];
    					$reservation_data ["guest_id_new"] = 0;
    					$reservation_data ["free_places"] = 0;
    					$reservation_data ["maid_description"] = "";
    					$reservation_data ["isread"] = 0;
    					$reservation_data ["dc_guestname"] = $reservations["reservation"] ["dc_guestname"];
    					$reservation_data ["dc_currencycode"] = $reservations["reservation"] ["dc_currencycode"];
    					$reservation_data ["dc_countrycode"] = $reservations["reservation"] ["dc_countrycode"];
    					$reservation_data ["dc_city"] = $reservations["reservation"] ["dc_city"];
    					$reservation_data ["dc_customerremarks"] = $reservations["reservation"] ["dc_customerremarks"];
    					$reservation_data ["dc_roomremarks"] = $reservations["reservation"] ["dc_roomremarks"];
    					$reservation_data ["dc_numberofguest"] = $reservations["reservation"] ["dc_numberofguest"];
    					$reservation_data ["dc_totalprice"] = $reservations["reservation"] ["dc_totalprice"];
    					$reservation_data ["smoking"] = $reservations["reservation"] ["smoking"];
    					$reservation_data ["late_check_out_close"] = $reservations["reservation"] ["late_check_out_close"];
    					$reservation_data ["early_check_in_close"] = $reservations["reservation"] ["early_check_in_close"];
    					if(isset($reservations["reservation"] ["dc_updatetime"]))
    						$reservation_data ["dc_updatetime"] = $reservations["reservation"] ["dc_updatetime"];
    					//$origin_categoryid = $reservation_data["origin_categoryid"];
    	
    					//print_r($reservation_data);
    	
    					if ($reservation_data ["type_id"] == $type_id) {
    						$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    					} else {
    						$can_resize = 0;
    						$reservation_data ["type_id"] = $type_id;
    					}
    	
    					//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    	
    					if($can_resize == 1){
    						if ($reservation_data["origin_categoryid"] <> ""){
    							$reservation_data["origin_categoryid"] = "";
    						}
    						$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    	
    						if(isset($otelms_rooms[$reservations ["reservation"] ["dc_uuid"]])){
    							$otelms_rooms[$reservations ["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    						if ($update_res == "FreeError") {
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							
    							$k ++;
    						}else{
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["alert"] = "";
    							$reservationpush [$k] ["status"] = "modified";
    							$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							
    							$k ++;
    						}
    					}else{
    						if ($type_id == 0 or $type_id == "") {
    							$query2 = $this->db->query ( "SELECT int_value FROM dc_bronevik_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    							if ($query2->num_rows () > 0) {
    								$row2 = $query2->row ();
    								$type_id = $row2->int_value;
    								$reservations["reservation"]["origin_categoryid"] = $reservation_data ["type_id"];
    							}
    						}
    						if ($type_id == 0 or $type_id == "") {
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    							$reservationpush [$k] ["status"] = "update";
    							$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    							$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    							
    							$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						} else {
    							if ($reservation_data["origin_categoryid"] <> ""){
    								$reservation_data["origin_categoryid"] = "";
    							}
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservations["reservation"]["early_check_in_close"], $reservations["reservation"]["late_check_out_close"]  );
    							if ($room_id == 0) {
    								$reservation_data ["is_overbook"] = 1;
    								if (isset ( $overbooking_category_id )) {
    									$reservation_data ["origin_categoryid"] = $type_id;
    									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservations["reservation"]["early_check_in_close"], $reservations["reservation"]["late_check_out_close"]  );
    	
    									$insert_over_room_bool = 0;
    									if ($room_id == 0) {
    										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    										$insert_over_room_bool = 1;
    									}
    									
    								} else {
    									$reservationpush [$k] ["response"] = "failed";
    									$reservationpush [$k] ["text"] = "no overbooking_category_id";
    									$reservationpush [$k] ["status"] = "new";
    									$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    									$reservationpush [$k] ["hms_reservation_id"] = 0;
    									$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    									
    									$reservationpush [$k] ["dc_room_id"] = $reservations["reservation"] ["category_id"];
    									$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    									$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								}
    							}
    							$reservation_data ["room_id"] = $room_id;
    	
    							$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    	
    							if(isset($otelms_rooms[$reservations["reservation"] ["dc_uuid"]])){
    								$otelms_rooms[$reservations["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    	
    							if ($update_res == "FreeError") {
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["dc_reservationid"];
    								
    								$k ++;
    							}else{
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["alert"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hotelbook_status"] = $reservations ["status"];
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$r_i]["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$r_i]["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$r_i]["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations["reservation"]["bronevik_original_id"];
    								
    								$k ++;
    							}
    						}
    					}
    				}
    			}
    			$r_i ++;
    		}
    		//die ();
    		//print_r ( $reservationpush );
    		//print_r ( $otelms_rooms );
    		//die();
    		foreach($otelms_rooms as $cell){
    			if($cell["status"] == 0){
    				//$this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
    				$status = 5;
    				$data_cancel = array ();
    				$data_cancel ["res_id"] = $cell["otelms_reservation_id"];
    				$data_cancel ["charge"] = 0;
    				$data_cancel ["status"] = $status;
    				$data_cancel ["description"] = "cancel from Hotelbook";
    				$data_cancel ["guestbe_request"] = 0;
    				$data_cancel ["user"] = - 1;
    				// ====================
    				$this->Cancel->Insert ( $data_cancel );
    			}
    		}
    	
    		//die();
    			
    		
    			
    		$counter_r = 0;
    		$new_mass = array ();
    		foreach ( $result_array ["reservations"] as $cell ) {
    	
    			if ($cell["status"] == "CONFIRMED" or $cell["status"] == "CHANGES_PENDING") {
    				$new_mass ['dcname'] = "Hotelbook";
    				$new_mass ['status'] = $cell["status"];
    				$new_mass ['dc_reservationid'] = $cell["reservation"]["dc_reservationid"];
    				$new_mass ['dc_channel_name'] = "Hotelbook";
    				$new_mass ['hotel_name'] = "hotel_name";
    				$new_mass ['guest_firstname'] = $cell["guest"]  ["firstname"];
    				$new_mass ['guest_lastname'] = $cell["guest"]  ["lastname"];
    				$new_mass ['guest_phone'] = $cell["guest"] ["phone"];
    				$new_mass ['guest_email'] = $cell["guest"] ["email"];
    				$new_mass ['hms_reservation_id'] = $cell["reservation"] ["hms_reservation_id"];
    	
    				$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
    				$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell["reservation"] ["reservation_alert"];
    				$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell["reservation"] ["hms_reservation_id"];
    				$new_mass ["room"] [$counter_r]["url"] = $cell["reservation"] ["url"];
    				$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Hotelbook";
    	
    				$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell["reservation"] ["dc_reservationid"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell["reservation"] ["dc_roomreservation_id"];
    				$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
    				$new_mass ["room"] [$counter_r]["reservation_date"] = $cell["reservation"]["date"];
    				$new_mass ["room"] [$counter_r]["status"] = $cell["status"];
    				$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell["reservation"]["datein"];
    				$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell["reservation"]["dateout"];
    				$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell["reservation"]["reservation_type_name"];
    				$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell["reservation"]["type_id"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell["reservation"]["dc_totalprice"];
    				$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = "";
    	
    				$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell["per_day"];
    	
    				$counter_r++;
    			}
    	
    	
    		}
    		if(count($new_mass) > 0){
    			//print_r($new_mass);
    			$this->dc_model->send_notifyarray_new ( $new_mass );
    		}
    	
    	}
    	
    	print_r ( $reservationpush );
    	//die();
    	foreach ( $reservationpush as $arg ) {
    		if ($arg ['status'] == "cancel") {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "Hotelbook";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			$this->dc_model->send_notifyarray ( $data );
    		}
    	}
    	
    	return json_encode($reservationpush, true);
    }
    
    function bokking_xml_parse_v2($data, $send_notification = 1, $db_name = "") {
    	    	 
    	$rates = array ();
    
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id, dc_category_id FROM dc_hotelbook_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_hotelbook_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    		}
    	}
    
    	$categories = array ();
    
    	$query = $this->db->query ( "SELECT dc_category_id, hms_category_id FROM  dc_hotelbook_room_categories_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_category_id] = $row->hms_category_id;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
    
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}   	 
    	 
    	 
    	$checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
    
    	$result_array = array ();
    	print_r($data );
    	if (isset ( $data ["data"] )) {
    		if (isset ( $data ["data"] ["bookings"])) {
    			$reservations = array ();
    			if (isset ( $data ["data"] ["bookings"] [0] )) {
    				$reservations = $data ["data"] ["bookings"];
    			} else {
    				$reservations [0] = $data ["data"] ["bookings"];
    			}
    			 
    			$counter = 0;
    			//echo "<pre>";
    			//print_r($reservations);
    			$otelms_rooms = array();
    			foreach ( $reservations as $reservation ) {
    				$reservation ["booking_id"] = $reservation ["bookingId"];
    				$sql = "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 17 AND dc_reservationid = ". $reservation ["booking_id"];
    				//echo $sql."<pre>";
    				$query = $this->db->query ( $sql );
    
    				if ($query->num_rows () > 0) {
    					foreach ( $query->result () as $row ) {
    						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid]["otelms_reservation_id"] = $row->id;
    						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid]["dc_uuid"] = $row->dc_uuid;
    						$otelms_rooms [$reservation ["booking_id"]] [$row->dc_uuid]["status"] = 0;
    					}
    				}
    				//print_r($otelms_rooms);
    				$rooms_data = array();
    				if(!isset($reservation["rooms"][0])){
    
    					$rooms_data [0] = $reservation["rooms"];
    				}else{
    					$rooms_data = $reservation["rooms"];
    				}
    				//print_r($rooms_data);
    				$qty = count($rooms_data);
    				for($j = 0; $j < $qty; $j ++) {
    					$dc_room_id = $rooms_data[$j]["roomId"];
    					$dc_total_price = 0;
    					$k = 0;
    					$PerDay_data = array();
    					if(!isset($rooms_data[$j]["dailyPrices"][0])){
    							
    						$PerDay_data [0] = $rooms_data[$j]["dailyPrices"];
    					}else{
    						$PerDay_data = $rooms_data[$j]["dailyPrices"];
    					}
    					foreach($PerDay_data as $key => $daily_price){
    						$date = $daily_price["date"];
    						$dc_rate_id = $daily_price["rateId"];
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_currencycode"] = $reservation["currency"];
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_reservation_id"] = $reservation ["booking_id"] . "_" . $dc_room_id . "_" . $j;
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["price"] = $daily_price["price"];
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_id"] = "";
    							
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["dc_rate_name"] = $rates_names[$dc_rate_id]["dc_rate_name"];
    						if(trim($date) <> ""){
    							list ( $year, $month, $day ) = explode ( "-", $date );
    							$intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
    						}else{
    							$intdate = "";
    						}
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["intdate"] = $intdate;
    						$result_array ["reservations"] [$counter] [$j] ["per_day"] [$k] ["date_rate"] = $date;
    						if(isset($rates [$dc_rate_id] [$dc_room_id])){
    							$price_type = $rates [$dc_rate_id] [$dc_room_id];
    						}
    						$dc_total_price += $daily_price["price"];
    						$k++;
    					}
    						
    					
    
    					$result_array ["reservations"] [$counter] [$j] ["guests"] = array();
    					if(!isset($rooms_data[$j]["guests"][0])){
    						$guests [0] = $rooms_data[$j]["guests"];
    					}else{
    						$guests = $rooms_data[$j]["guests"];
    					}
    					//print_r ( $services );
    					$guest_inc = 0;
    					foreach ( $guests as $guest ) {
    						$guest_name_arr = explode(" ", $guest);
    						$result_array ["reservations"] [$counter] [$j] ["guests"] [$guest_inc] ["firstname"] = "";
    						$result_array ["reservations"] [$counter] [$j] ["guests"] [$guest_inc] ["lastname"] = "";
    						if(isset($guest_name_arr[0])){
    							$result_array ["reservations"] [$counter] [$j] ["guests"] [$guest_inc] ["firstname"] = $guest_name_arr[0];
    						}
    						if(isset($guest_name_arr[1])){
    							$result_array ["reservations"] [$counter] [$j] ["guests"] [$guest_inc] ["lastname"] = $guest_name_arr[1];
    						}
    						$guest_inc ++;
    					}
    						
    
    					$result_array ["reservations"] [$counter] [$j] ["dc_rate_id"] = $dc_rate_id;
    					$result_array ["reservations"] [$counter] [$j] ["currencycode"] = $reservation["currency"];
    
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_cvc"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpMonth"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpYear"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["CardHolder"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["CardNumber"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_type"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["address"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["city"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["email"] = $reservation["customer"]["email"];
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["firstname"] = $reservation["customer"]["firstName"];
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["lastname"] = $reservation["customer"]["lastName"];
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["phone"] = $reservation["customer"]["phone"];
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["country"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["guest"] ["passportid"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["status"] = $reservation["status"];
    					$result_array ["reservations"] [$counter] [$j] ["dc_reservationid"] = $reservation ["booking_id"];
    
    					$created_datetime = explode(" ", $reservation ["created"]);
    					$created_date = $created_datetime[0];
    					$created_time = $created_datetime[1];
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_id"] = 17;
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["commissionamount"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["date"] = $created_date;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_reservationid"] = $reservation ["booking_id"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["time"] = $created_time;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_date"] = $created_date;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_time"] = $created_time;
    					
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_updatetime"] = $reservation ["modified"];
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["isNew"] = 1;
    						
    					//$datetime_in = $this->frontdesk->convert_to_user_date($reservation ["arrivalTime"], "Y-m-d H:i:s", $timezone);
//     					$arrivalTime_datetime = explode(" ", $reservation ["arrivalDate"]);
    						
//     					$arrivalTime_date = $arrivalTime_datetime[0];
//     					$arrivalTime_time = $arrivalTime_datetime[1];
    						
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["datein"] = $reservation ["arrivalDate"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkintime"] = $reservation ["arrivalTime"];
    						
    					//$datetime_out = $this->frontdesk->convert_to_user_date($reservation ["departureTime"], "Y-m-d H:i:s", $timezone);
//     					$departureTime_datetime = explode(" ", $reservation ["departureDate"]);
    						
//     					$departureTime_date = $departureTime_datetime[0];
//     					$departureTime_time = $departureTime_datetime[1];
    						
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dateout"] = $reservation ["departureDate"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkouttime"] = $reservation ["departureTime"];
    						
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomreservation_id"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_uuid"] = $reservation ["booking_id"] . "_" . $dc_room_id . "_" . $j;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["category_id"] = $dc_room_id;
    					if (isset ( $categories_names [$categories [$dc_room_id]] )) {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = $categories_names [$categories [$dc_room_id]];
    					} else {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = "";
    					}
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["placement_id"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["add_places"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["baby_places"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["amount"] = $dc_total_price;
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["price_type"] = $price_type;
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = "";
    					if(isset($_SESSION["user"]["id"])){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"]  = $_SESSION["user"]["id"];
    					}else{
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"] = - 1;
    					}
    
    					if (isset ( $categories [$dc_room_id] )) {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = $categories [$dc_room_id];
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = $dc_room_id;
    					} else {
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = 0;
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = 0;
    					}
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dealer"] = $dealer;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_guestname"] = $reservation["customer"]["lastName"]." ".$reservation["customer"]["firstName"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_numberofguest"] = $rooms_data [$j]["adultsNumber"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_countrycode"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_currencycode"] = $reservation["currency"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_city"] = "";
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_customerremarks"] = $reservation["note"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomremarks"] = $reservation["note"];
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = $reservation["note"];
    
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] =  $dc_total_price;
    					
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["smoking"] = "";
    
    					$result_array ["reservations"] [$counter] [$j] ["roomreservation_id"] = "";
    
    					//=============================================================================
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["early_check_in_close"] = 0;
    					$result_array ["reservations"] [$counter] [$j] ["reservation"] ["late_check_out_close"] = 0;
    					
    						
    					//=============================================================================
    						
    					if($qty > 1){
    						$result_array ["reservations"] [$counter] [$j] ["reservation"] ["groupid"] = $reservation ["booking_id"];
    					}
    
    
    				}
    				$counter++;
    			}
    		}
    	}
    	echo "<pre>";
    	print_r ( $result_array );
    	//die ();
    
    	$host = "";
    	if($db_name <> ""){
    		$query = $this->db->query ( "SELECT host FROM visitka.config WHERE db_name LIKE '".$db_name."'" );
    
    		if ($query->num_rows () > 0) {
    			$row = $query->row ();
    			$host = $row->host;
    		}
    	}else{
    		if ($_SERVER ["HTTP_HOST"]) {
    			$host = $_SERVER ["HTTP_HOST"];
    		}
    	}
    
    	$reservationpush = array ();
    
    	if (isset ( $result_array ["reservations"] )) {
    		$k = 0;
    
    		$bool_cancel = 0;
    		$guest_array = array ();
    		$guest_counter = 1;
    		foreach ( $result_array ["reservations"] as $key => $reservations ) {
    			$dc_reservationid = $reservations [0] ["reservation"] ["dc_reservationid"];
    			$dc_status = $reservations [0] ["status"];
    			$res_count = count ( $reservations );
    			$bool_guest = 0;
    			for($i = 0; $i < $res_count; $i ++) {
    				$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' AND dc_id = 17 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    
    					if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    						$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    					}
    
    				}
    
    				if ($reservations [$i] ["status"] == "new") {
    					$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_date = '" . $reservations [$i] ["reservation"] ["dc_date"] . "' AND dc_time = '" . $reservations [$i] ["reservation"] ["dc_time"] . "' AND dc_id = 17 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = " . $reservations [$i] ["reservation"] ["dc_reservationid"] . " ORDER BY id DESC ";
    
    					$query = $this->db->query ( $sql );
    					$hms_reservation_id = 0;
    					$otelms_room_id = 0;
    					if ($query->num_rows () > 0) {
    						$row = $query->row ();
    							
    						if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    							$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    						}
    							
    						$reservationpush [$k] ["status"] = "skip";
    						$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    						$reservationpush [$k] ["dc_reservationid"] = $dc_reservationid;
    						$result_array ["reservations"] [$key] [$i] ["status"] = "skip";
    						$k ++;
    						// die();
    						continue;
    					}
    				}
    
    				//=========================================================================
    
    				$calculate_data = array ();
    				$calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    				$calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    				$calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    				$calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    				$calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    				$calculate_data ["addbedplace"] = 0;
    				$calculate_data ["babyplace2"] = 0;
    				$calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    
    				$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
    				$otelms_amount = 0;
    				for($p = 0; $p < count ( $temp_amount ); $p ++) {
    					$otelms_amount += $temp_amount [$p] ["amount"];
    				}
    				$booking_amount = $reservations [$i] ["reservation"] ["amount"];
    				//$reservations [$i] ["reservation"] ["discount"] = 0;
    				if ($booking_amount != $otelms_amount) {
    					//if ($otelms_amount != 0) {
    					$reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
    					//}
    				}
    
    				//=====================================================
    				//=====================================================
    				//=====================================================
    
    				$datein = $reservations [$i] ["reservation"] ["datein"];
    				$dateout = $reservations [$i] ["reservation"] ["dateout"];
    				$type_id = $reservations [$i] ["reservation"] ["type_id"];
    				$sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = 17 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
    				//echo $sql;
    				$query = $this->db->query ( $sql );
    				$hms_reservation_id = 0;
    				$otelms_room_id = 0;
    				if ($query->num_rows () > 0) {
    					$row = $query->row ();
    					$hms_reservation_id = $row->id;
    					$otelms_room_id = $row->room_id;
    				}
    
    				if (isset ( $reservations [$i] ["per_day"] )) {
    
    					$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
    				}
    
    				if ($reservations [$i] ["status"] == "cancelled") {
    					if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    						$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    					}
    					$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE dc_id = 17 AND deskofreservation.id = $hms_reservation_id" );
    
    					if ($query2->num_rows () > 0) {
    						$row2 = $query2->row ();
    						$datein = $row2->datein;
    						$dateout = $row2->dateout;
    						$type_id = $row2->category_id;
    					}
    
    					$time2 = date ( "Y-m-d H:i:s" );
    					$status = 5;
    					$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    
    					if ($query2->num_rows () > 0) {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "есть уже отмена";
    						$reservationpush [$k] ["status"] = "cancel";
    
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    						$k ++;
    
    						$dc_log_data = array ();
    						$dc_log_data ["datein"] = $datein;
    						$dc_log_data ["dateout"] = $dateout;
    						$dc_log_data ["category_id"] = $type_id;
    						$this->frontdesk->dc_log_update ( $dc_log_data );
    					} else {
    						$sql = "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id;
    						echo $sql;
    						$query2 = $this->db->query ( $sql );
    
    						if ($query2->num_rows () > 0) {
    							$data_cancel = array ();
    
    							$data_cancel ["res_id"] = $hms_reservation_id;
    							$data_cancel ["charge"] = 0;
    							$data_cancel ["status"] = 5;
    							;
    							$data_cancel ["description"] = "cancel from 101otel";
    							$data_cancel ["guestbe_request"] = 0;
    							$data_cancel ["user"] = - 1;
    							// ====================
    							$this->Cancel->Insert ( $data_cancel );
    							// ====================
    							$query2 = $this->db->query ( "UPDATE deskofreservation SET dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' WHERE id = " . $hms_reservation_id );
    							$reservationpush [$k] ["response"] = "ok";
    							$reservationpush [$k] ["text"] = "";
    							$reservationpush [$k] ["status"] = "cancel";
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						} else {
    							
    							$reservationpush [$k] ["response"] = "failed";
    							$reservationpush [$k] ["text"] = "нет брони для отмены";
    							$reservationpush [$k] ["status"] = "skip";
    
    							$reservationpush [$k] ["hms_reservation_id"] = 0;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$k ++;
    						}
    					}
    				} else {
    
    					if($hms_reservation_id == 0){
    						/*
    						 * NEW RESERVATION BLOCK
    						*/

    						$room_id = 0;
    
    						if ($type_id == 0 or $type_id == "") {
    							$query2 = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    							if ($query->num_rows () > 0) {
    								$row2 = $query2->row ();
    								$type_id = $row2->int_value;
    							}
    						}
    						if ($type_id == 0 or $type_id == "") {
    							
    							$reservationpush [$k] ["response"] = "error";
    							$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    							$reservationpush [$k] ["status"] = "new";
    							$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    							$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    							$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    							$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    							$k ++;
    						} else {
    							$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservations [$i] ["reservation"]["early_check_in_close"], $reservations [$i] ["reservation"]["late_check_out_close"] );
    							if ($room_id == 0) {
    							    $reservations ["reservation"] ["is_overbook"] = 1;
    								if (isset ( $overbooking_category_id )) {
    									$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
    									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservations [$i] ["reservation"]["early_check_in_close"], $reservations [$i] ["reservation"]["late_check_out_close"] );
    
    									$insert_over_room_bool = 0;
    									if ($room_id == 0) {
    										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    										$insert_over_room_bool = 1;
    									}
    								} else {
    									
    									$reservationpush [$k] ["response"] = "failed";
    									$reservationpush [$k] ["text"] = "no overbooking_category_id";
    									$reservationpush [$k] ["status"] = "new";
    									$reservationpush [$k] ["hms_reservation_id"] = 0;
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    									$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								}
    							}
    							$reservations [$i] ["reservation"] ["room_id"] = $room_id;
    
    							if ($bool_guest == 0) {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
    								$bool_guest = 1;
    							}
    							//print_r($reservations [$i] ["reservation"]);
    							//die();
    							$hms_reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
    
    							if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i] ["reservation"] ["dc_uuid"]])){
    								$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    
    							if (isset ( $reservations [$i] ["card"] )) {
    								$this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $hms_reservation_id );
    							}
    
    							if ($hms_reservation_id > 0) {
    								
    								/*
    								 * =========================
    								*/
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "undferror";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							}
    						}
    					}else{
    						/*
    						 * UPDATE RESERVATION BLOCK
    						*
    						*/
    
    
    						$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
    
    						//$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
    						$reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
    						$reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
    						$reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
    						$reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
    
    						$reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
    						$reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
    						$reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
    						$reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
    						$reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
    						$reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
    						$reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
    						$reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
    						$reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
    
    
    						//$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
    						$reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
    						$reservation_data ["guest_id_new"] = 0;
    						$reservation_data ["free_places"] = 0;
    						$reservation_data ["maid_description"] = "";
    						$reservation_data ["isread"] = 0;
    						$reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
    						$reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
    						$reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
    						$reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
    						$reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    						$reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
    						$reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
    						$reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
    						$reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
    
    						$reservation_data ["description"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
    							
    						$reservation_data ["dc_date"] = $reservations [$i] ["reservation"] ["dc_date"];
    						$reservation_data ["dc_time"] = $reservations [$i] ["reservation"] ["dc_time"];
    						$reservation_data ["dc_updatetime"] = $reservations [$i] ["reservation"] ["dc_updatetime"];
    
    						$reservation_data ["early_check_in_close"] = $reservations [$i] ["reservation"] ["early_check_in_close"];
    						$reservation_data ["late_check_out_close"] = $reservations [$i] ["reservation"] ["late_check_out_close"];
    
    
    						//=============================================================================
    						if ($autoclosedaychicho == 1) {
    							$str_checkintime = strtotime ( $reservations [$i] ["reservation"] ["checkintime"] );
    							$str_checkouttime = strtotime ( $reservations [$i] ["reservation"] ["checkouttime"] );
    
    							$system_checkouttime = strtotime ( $checkin_checkout_arr ["checkouttime"] );
    							$system_checkintime = strtotime ( $checkin_checkout_arr ["checkintime"] );
    
    							if ($str_checkintime < $system_checkouttime) {
    								$reservation_data ["early_check_in_close"] = 1;
    							}
    							if ($str_checkouttime > $system_checkouttime) {
    								$reservation_data ["late_check_out_close"] = 1;
    							}
    						}
    						//=============================================================================
    						// print_r($reservation_data);
    
    						if ($reservation_data ["type_id"] == $type_id) {
    							$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"]  );
    						} else {
    							$can_resize = 0;
    							$reservation_data ["type_id"] = $type_id;
    						}
    
    						//$can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout );
    
    						if($can_resize == 1){
    
    							$this->service_model->DeleteServicesDc($hms_reservation_id);
    							$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    							if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    								$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    							if ($update_res == "FreeError") {
    								
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}else{
    								
    								/*
    								 * =========================
    								*/
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["alert"] = "";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    								$k ++;
    							}
    						}else{
    							if ($type_id == 0 or $type_id == "") {
    								$query2 = $this->db->query ( "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    								if ($query->num_rows () > 0) {
    									$row2 = $query2->row ();
    									$type_id = $row2->int_value;
    								}
    							}
    							if ($type_id == 0 or $type_id == "") {
    								
    								$reservationpush [$k] ["response"] = "error";
    								$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
    								$reservationpush [$k] ["status"] = "modified";
    								$reservationpush [$k] ["hms_reservation_id"] = $row->id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"] );
    								if ($room_id == 0) {
    								    $reservation_data ["is_overbook"] = 1;
    									if (isset ( $overbooking_category_id )) {
    										$reservation_data ["origin_categoryid"] = $type_id;
    										$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"] );
    
    										$insert_over_room_bool = 0;
    										if ($room_id == 0) {
    											$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    											$insert_over_room_bool = 1;
    										}
    									} else {
    										
    										$reservationpush [$k] ["response"] = "failed";
    										$reservationpush [$k] ["text"] = "no overbooking_category_id";
    										$reservationpush [$k] ["status"] = "new";
    										$reservationpush [$k] ["hms_reservation_id"] = 0;
    										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    										$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    										$result_array ["reservations"] [$key] [$i] ["status"] = "new";
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    										$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									}
    								}
    								$reservation_data ["room_id"] = $room_id;
    
    								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
    
    								if(isset($otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]])){
    									$otelms_rooms [$dc_reservationid] [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
    								}
    
    								if ($update_res == "FreeError") {
    									
    									$reservationpush [$k] ["response"] = "error";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}else{
    									$reservationpush [$k] ["response"] = "ok";
    									$reservationpush [$k] ["text"] = "";
    									$reservationpush [$k] ["alert"] = "";
    									$reservationpush [$k] ["status"] = "modified";
    									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    									$result_array ["reservations"] [$key] [$i] ["status"] = "modified";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
    									$k ++;
    								}
    							}
    						}
    					}
    				}
    				// }
    
    			}
    
    			//echo "=======================================";
    			//print_r ( $otelms_rooms );
    			if (isset ( $otelms_rooms [$dc_reservationid] )) {
    				foreach ( $otelms_rooms [$dc_reservationid] as $cell ) {
    					if ($cell ["status"] == 0) {
    						// $this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
    						$status = 5;
    						$data_cancel = array ();
    						$data_cancel ["res_id"] = $cell ["otelms_reservation_id"];
    						$data_cancel ["charge"] = 0;
    						$data_cancel ["status"] = $status;
    						$data_cancel ["description"] = "cancel from Hotelbook";
    						$data_cancel ["guestbe_request"] = 0;
    						$data_cancel ["user"] = - 1;
    						// ====================
    						$this->Cancel->Insert ( $data_cancel );
    					}
    				}
    			}
    			
    		}
    
    		//print_r ( $result_array );
    		//print_r ( $otelms_rooms );
    		//die();
    
    		$hotel_name = "";
    		$query = $this->db->query("SELECT * FROM logo");
    		if ($query->num_rows() > 0) {
    			$row = $query->row();
    			$hotel_name = stripslashes($row->logo_title);
    		}
    		//die();
    		$counter_r = 0;
    		$new_mass = array ();
    		foreach ( $result_array ["reservations"] as $cell ) {
    
    			//print_r($cell);
    			$res_count = count ( $cell );
    			//echo "+++++++++++++++++++++++".$res_count;
    			for($i = 0; $i < $res_count; $i ++) {
    				if ($cell [$i] ["status"] == "modified" or $cell [$i] ["status"] == "new") {
    					$new_mass ['dcname'] = "Hotelbook";
    					$new_mass ['status'] = $cell [$i] ["status"];
    					$new_mass ['dc_reservationid'] = $cell [$i] ["reservation"]["dc_reservationid"];
    					$new_mass ['dc_channel_name'] = "Hotelbook";
    					$new_mass ['hotel_name'] = $hotel_name;
    					$new_mass ['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
    					$new_mass ['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
    					$new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
    					$new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
    
    					$new_mass ["room"] [$counter_r]["reservation_current"] = $i;
    					$new_mass ["room"] [$counter_r]["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
    					$new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
    					$new_mass ["room"] [$counter_r]["url"] = $cell [$i] ["reservation"] ["url"];
    					$new_mass ["room"] [$counter_r]["dc_channel_name"] = "Hotelbook";
    
    					$new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
    					$new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
    					$new_mass ["room"] [$counter_r]["reservation_date"] = $cell [$i] ["reservation"]["date"];
    					$new_mass ["room"] [$counter_r]["status"] = $cell [$i] ["status"];
    					$new_mass ["room"] [$counter_r]["reservation_datein"] = $cell [$i] ["reservation"]["datein"];
    					$new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell [$i] ["reservation"]["dateout"];
    					$new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell [$i] ["reservation"]["reservation_type_name"];
    					$new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell [$i] ["reservation"]["type_id"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell [$i] ["reservation"]["dc_totalprice"];
    					$new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = $cell [$i] ["reservation"]["dc_customerremarks"];
    
    					$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
    					$max_key = max( array_keys( $new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] ) );
    					$intdate_temp = $max_key;
    					$max_key += 1;
//     					foreach($cell [$i] ["addons"] as $cell_addons){
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["dc_rate_name"] = $cell_addons["name"];
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["price"] = $cell_addons["price_per_unit"];
    
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["dc_currencycode"] = $new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$intdate_temp]["dc_currencycode"];
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["dc_reservation_id"] = "";
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["dc_rate_id"] = "";
    
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["intdate"] = "";
//     						$new_mass ["room"] [$counter_r]["dc_rate_intdate_data"][$max_key] ["date_rate"] = "";
//     						$new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] += $cell_addons["price_per_unit"];
//     						$max_key++;
//     					}
    					$counter_r++;
    				}
    			}
    
    		}
    		if(count($new_mass) > 0){
    			//print_r($new_mass);
    			$this->dc_model->send_notifyarray_new ( $new_mass );
    		}
    
    	}
    
    	 
    	echo "<pre>";
    	echo "\n\n --- XML reservationpush START --- \n\n";
    	print_r ( $reservationpush );
    	echo "\n\n --- XML reservationpush END --- \n\n";
    	 
    	foreach ( $reservationpush as $arg ) {
    		if ($arg ['status'] == "cancel") {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "Hotelbook";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			$this->dc_model->send_notifyarray ( $data );
    		}
    	}
    	return json_encode($reservationpush, true);
    }
    
    function dc_rate_intdate_insert($data) {
    	$count = count ( $data );
    	if ($count != 0) {
    		foreach ( $data as $cell ) {
    			$query = $this->db->query ( "DELETE FROM dc_hotelbook_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
    			break;
    		}
    		foreach ( $data as $cell ) {
    			$sql = "INSERT INTO dc_hotelbook_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
    			// echo $sql;
    			$query = $this->db->query ( $sql );
    		}
    	}
    }
}