<?php 
class dcm_eholiday extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        if (isset($GLOBALS['cron_last_changed'])) {
        
        }else{
            $this->load->model ( 'frontdesk' );
            $this->load->model ( 'dc_model' );
        }


        $this->table_name_r2c = "dc_eholiday_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_eholiday_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_eholiday_rooms_link";
        
        
        $this->sql_dc_rates = "select dc_eholiday_rates.dc_rate_id as dc_rate_id, dc_eholiday_rates.active, dc_eholiday_rates.name as dc_rate_name, 
        		dc_global_restrict_rate.name as restrict_name
        		from dc_eholiday_rates 
        		LEFT JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = dc_eholiday_rates.restrict_id";
        $this->sql_dc_category_link = "select dc_room_name as dc_category_name,
            dc_room_id	 as dc_category_id,
            category_id as hms_category_id
            from dc_eholiday_rooms_link";
        $this->sql_roomstorate = " INNER JOIN dc_eholiday_rate2category_link ON  dc_eholiday_rate2category_link.dc_category_id = dc_eholiday_rooms_link.dc_room_id 
        WHERE dc_eholiday_rate2category_link.dc_rate_id = ";
        $this->sql_dc_r2rlink = "select dc_rate_id as dc_rate_id, restrict_id as hms_restrict_id from dc_eholiday_rates";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_eholiday_rate2category_link";
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_eholiday_occupancy";
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select dc_room_name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_eholiday_rooms_link";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_eholiday_category2occupancy";
        $this->form_action_c2o_post = "/dc_eholiday/categories_edit_post";
        $this->form_action_r2c_post = "/dc_eholiday/rates_edit_post";
        
        $this->form_action_c2o_post_c2= "/dc_eholiday_c2/categories_edit_post";
        $this->form_action_r2c_post_c2 = "/dc_eholiday_c2/rates_edit_post";
    }
    
    function options_save($data) {
    	$data_1 = $this->Loger_admin->get_values_col("dc_eholiday_xml_cfg");
    
    	$sql = "INSERT INTO dc_eholiday_xml_cfg (name, int_value) VALUES('dealer_id', '" . $data ["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["dealer"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_eholiday_xml_cfg (name, int_value) VALUES('overbooking_category_id', '" . $data ["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["overbooking_category"];
    	$query = $this->db->query ( $sql );
    	$sql = "INSERT INTO dc_eholiday_xml_cfg (name, int_value) VALUES('general_update', '" . $data ["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data ["general_update"];
    	$query = $this->db->query ( $sql );
    
    	$data_2 = $this->Loger_admin->get_values_col("dc_eholiday_xml_cfg");
    	$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "dc_eholiday_xml_cfg", "edit");
    }
    
    function category2occupancy_save_eholiday($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_category_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_room_id, category_id) values
    		($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
    function rate2category_save_eholiday($r2c)
    {
    	if (sizeof($r2c)) {
    
    	} else {
    		return;
    	}
    	$this->db->query("delete from " . $this->table_name_r2c);
    
    	foreach ($r2c as $dc_rate_id => $dc_category_list) {
    		foreach ($dc_category_list['room_list'] as $dc_category_id => $occupancy) {
    			foreach ($occupancy as $key => $cell) {
    				$sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_occupancy_id,  hms_rate_id, hms_price_func_id) values
    				($dc_rate_id, $dc_category_id, " . $cell['hms_occupancy_id'] . ", " . $cell['hms_rate_id'] . ", " . $cell['hms_price_func_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . ", hms_price_func_id=" . $cell['hms_price_func_id'] . "
                    , hms_occupancy_id=" . $cell['hms_occupancy_id'] . "";
    				// echo $sql . "\n";
    				$this->db->query($sql);
    			}
    		}
    		$sql = "INSERT INTO dc_eholiday_rates (dc_rate_id, restrict_id) values ($dc_rate_id, ".$r2c[$dc_rate_id]['hms_restrict_id'].")
			on duplicate key update restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
    		//echo $sql;
    		$this->db->query ( $sql );
    	}
    }
    
    function save_eholiday_log($request = 0, $response = 0) {
    	$data = array (
    			'request' => $request,
    			'response' => $response
    	);
    	$this->db->insert ( 'dc_eholiday_log', $data );
    	return $this->db->insert_id ();
    
    }
    function get_bookings($reservation_data, $iscancel = 0, $debug = 0) {
    	//echo "<pre>";
    	//print_r($reservation_data);
    	// die ();
    	$return_data = array();
    	if($debug == 1)
    		$return_data["debug"] = array();
    	$i = 0;
    
   		$rates = array ();
    
    	$query = $this->db->query ( "SELECT hms_rate_id, dc_rate_id, dc_category_id FROM  dc_eholiday_rate2category_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates [$row->dc_rate_id] [$row->dc_category_id] = $row->hms_rate_id;
    		}
    	}
    
    	$rates_names = array ();
    
    	$query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_eholiday_rates" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
    			$rates_names [$row->dc_rate_id] ["dc_rate_id"] = $row->dc_rate_id;
    		}
    	}
    
    	$categories = array ();
    
    	$query = $this->db->query ( "SELECT dc_room_id, category_id FROM dc_eholiday_rooms_link" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_room_id] = $row->category_id;
    		}
    	}
    
    	$categories_names = array ();
    
    	$query = $this->db->query ( "SELECT id, name FROM categories" );
    
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories_names [$row->id] = $row->name;
    		}
    	}
    
    	$query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$price_type = $row->id;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'dealer_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$dealer = $row->int_value;
    	}
    
    	$query = $this->db->query ( "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
    
    	if ($query->num_rows () > 0) {
    		$row = $query->row ();
    		$overbooking_category_id = $row->int_value;
    	}
    
    	$result_array = array ();
    
    	//$this->hash_transfer($reservation_data);
    	$k = 0;
    	if ($iscancel == 1) {
    		$query3 = $this->db->query ( "SELECT id FROM deskofreservation WHERE dc_reservationid = " . $reservation_data ["ord_id"] );
    		if ($query3->num_rows () > 0) {
    			foreach ( $query3->result () as $row3 ) {
    				$hms_reservation_id = $row3->id;
    					
    				$query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = $hms_reservation_id" );
    					
    				if ($query2->num_rows () > 0) {
    					$row2 = $query2->row ();
    					$datein = $row2->datein;
    					$dateout = $row2->dateout;
    					$type_id = $row2->category_id;
    				}else{
    					$reservationpush [$k] ["response"] = "failed";
    					$reservationpush [$k] ["text"] = "order not found";
    					$reservationpush [$k] ["status"] = "cancel";
    						
    					$reservationpush [$k] ["hms_reservation_id"] = 0;
    					$reservationpush [$k] ["dc_reservationid"] = $reservation_data ["ord_id"];
    					$k ++;
    					continue;
    				}
    					
    				$time2 = date ( "Y-m-d H:i:s" );
    				$status = 5;
    				$query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
    					
    				if ($query2->num_rows () > 0) {
    					$reservationpush [$k] ["response"] = "failed";
    					$reservationpush [$k] ["text"] = "order is already canceled";
    					$reservationpush [$k] ["status"] = "cancel";
    						
    					$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    					$reservationpush [$k] ["dc_reservationid"] = $reservation_data ["ord_id"];
    					$k ++;
    						
    					$dc_log_data = array ();
    					$dc_log_data ["datein"] = $datein;
    					$dc_log_data ["dateout"] = $dateout;
    					$dc_log_data ["category_id"] = $type_id;
    					$this->frontdesk->dc_log_update ( $dc_log_data );
    				} else {
    					$query2 = $this->db->query ( "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id );
    						
    					if ($query2->num_rows () > 0) {
    						$data_cancel = array ();
    							
    						$data_cancel ["res_id"] = $hms_reservation_id;
    						$data_cancel ["charge"] = 0;
    						$data_cancel ["status"] = 5;
    						;
    						$data_cancel ["description"] = "cancel from eholiday";
    						$data_cancel ["guestbe_request"] = 0;
    						$data_cancel ["user"] = - 1;
    						// ====================
    						$this->Cancel->Insert ( $data_cancel );
    						// ====================
    						$reservationpush [$k] ["response"] = "ok";
    						$reservationpush [$k] ["text"] = "";
    						$reservationpush [$k] ["status"] = "cancel";
    						$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
    						$reservationpush [$k] ["dc_reservationid"] = $reservation_data ["ord_id"];
    						$k ++;
    					} else {
    						$reservationpush [$k] ["response"] = "failed";
    						$reservationpush [$k] ["text"] = "order not found";
    						$reservationpush [$k] ["status"] = "cancel";
    							
    						$reservationpush [$k] ["hms_reservation_id"] = 0;
    						$reservationpush [$k] ["dc_reservationid"] = $reservation_data ["ord_id"];
    						$k ++;
    					}
    				}
    			}
			} else {
				$reservationpush [$k] ["response"] = "failed";
				$reservationpush [$k] ["text"] = "order not found";
				$reservationpush [$k] ["status"] = "cancel";
				
				$reservationpush [$k] ["hms_reservation_id"] = 0;
				$reservationpush [$k] ["dc_reservationid"] = $reservation_data ["ord_id"];
				$k ++;
			}
    	} else {
			
			$otelms_rooms = array ();
			$query = $this->db->query ( "SELECT id, dc_uuid FROM deskofreservation WHERE deleted = 0 AND cancel = 0 AND dc_id = 18 AND dc_reservationid = " . $reservation_data ["ord_id"] );
			
			if ($query->num_rows () > 0) {
				foreach ( $query->result () as $row ) {
					$otelms_rooms [$row->dc_uuid] ["otelms_reservation_id"] = $row->id;
					$otelms_rooms [$row->dc_uuid] ["dc_uuid"] = $row->dc_uuid;
					$otelms_rooms [$row->dc_uuid] ["status"] = 0;
				}
			}
			
			// print_r ( $otelms_rooms );
			
			if (isset ( $reservation_data ["rooms"] )) {
				list ( $year, $month, $day ) = explode ( "-", $reservation_data ["ord_date_from"] );
				$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				list ( $year, $month, $day ) = explode ( "-", $reservation_data ["ord_date_to"] );
				$intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				$duration = $intdateout - $intdatein;
				$per_day_price = $reservation_data ["ord_total_price"] / $duration;
				$count_rooms = count ( $reservation_data ["rooms"] );
				for($i = 0; $i < $count_rooms; $i ++) {
					if (isset ( $reservation_data ["rooms"] [$i] ["ordr_room_cnt"] )) {
						$counter = $reservation_data ["rooms"] [$i] ["vr_id"] . "-" . $i;
						$qty = $reservation_data ["rooms"] [$i] ["ordr_room_cnt"];
						for($j = 1; $j <= $qty; $j ++) {
							$dc_rate_id = $reservation_data ["rooms"] [$i] ["rp_id"];
							for($intdate = $intdatein; $intdate < $intdateout; $intdate ++) {
								$date = gmdate ( "Y-m-d", $intdate * 86400 );
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["dc_reservation_id"] = $reservation_data ["ord_id"] . "_" . $reservation_data ["rooms"] [$i] ["vr_id"] . "_" . $j;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["price"] = $per_day_price;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["dc_rate_id"] = $reservation_data ["rooms"] [$i] ["rp_id"];
								if (isset ( $rates_names [$reservation_data ["rooms"] [$i] ["rp_id"]] )) {
									$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["dc_rate_name"] = $rates_names [$reservation_data ["rooms"] [$i] ["rp_id"]] ["dc_rate_name"];
								} else {
									$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["dc_rate_name"] = "";
								}
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["dc_currencycode"] = "";
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["intdate"] = $intdate;
								$result_array ["reservations"] [$counter] [$j] ["per_day"] [$intdate] ["date_rate"] = $date;
							}
							
							// ========================================================================================
							
							$result_array ["reservations"] [$counter] [$j] ["dc_rate_id"] = $dc_rate_id;
							$result_array ["reservations"] [$counter] [$j] ["currencycode"] = "";
							
							$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_cvc"] = "";
							
							$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpMonth"] = "";
							$result_array ["reservations"] [$counter] [$j] ["card"] ["ExpYear"] = "";
							$result_array ["reservations"] [$counter] [$j] ["card"] ["CardHolder"] = "";
							$result_array ["reservations"] [$counter] [$j] ["card"] ["CardNumber"] = "";
							$result_array ["reservations"] [$counter] [$j] ["card"] ["cc_type"] = "";
							
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["address"] = "";
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["city"] = "";
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["country"] = "";
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["email"] = "";
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["firstname"] = $reservation_data ["ord_firstname"];
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["lastname"] = $reservation_data ["ord_lastname"];
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["phone"] = "";
							$result_array ["reservations"] [$counter] [$j] ["guest"] ["passportid"] = "";
							
							if ($iscancel == 1) {
								$result_array ["reservations"] [$counter] [$j] ["status"] = "canceled";
							} else {
								$result_array ["reservations"] [$counter] [$j] ["status"] = "";
							}
							// $result_array ["reservations"] [$i] ["status"] = "cancelled";
							$result_array ["reservations"] [$counter] [$j] ["dc_reservationid"] = $reservation_data ["ord_id"];
							
							$created_at = date ( "Y-m-d", strtotime ( $reservation_data ["ord_created"] ) );
							$created_at_time = date ( "H:i:s", strtotime ( $reservation_data ["ord_created"] ) );
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_id"] = 18;
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["commissionamount"] = 0;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["date"] = $created_at;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_reservationid"] = $reservation_data ["ord_id"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["time"] = $created_at_time;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["isNew"] = 1;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["datein"] = $reservation_data ["ord_date_from"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dateout"] = $reservation_data ["ord_date_to"];
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkintime"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["checkouttime"] = "";
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomreservation_id"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_uuid"] = $reservation_data ["ord_id"] . "_" . $reservation_data ["rooms"] [$i] ["vr_id"] . "_" . $j;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["category_id"] = $reservation_data ["rooms"] [$i] ["vr_id"];
							if (isset ( $categories [$reservation_data ["rooms"] [$i] ["vr_id"]] )) {
								if (isset ( $categories_names [$categories [$reservation_data ["rooms"] [$i] ["vr_id"]]] )) {
									$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = $categories_names [$categories [$reservation_data ["rooms"] [$i] ["vr_id"]]];
								} else {
									$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = "";
								}
							} else {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["reservation_type_name"] = "";
							}
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["placement_id"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["add_places"] = $reservation_data ["rooms"] [$i] ["ordr_adults_cnt"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["baby_places"] = $reservation_data ["rooms"] [$i] ["ordr_childs_cnt"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["amount"] = $reservation_data ["ord_total_price"];
							if (isset ( $rates [$reservation_data ["rooms"] [$i] ["rp_id"]] [$reservation_data ["rooms"] [$i] ["vr_id"]] )) {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["price_type"] = $rates [$reservation_data ["rooms"] [$i] ["rp_id"]] [$reservation_data ["rooms"] [$i] ["vr_id"]];
							} else {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["price_type"] = $this->frontdesk->get_default_rate ();
							}
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["description"] = "";
							if (isset ( $_SESSION ["user"] ["id"] )) {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"] = $_SESSION ["user"] ["id"];
							} else {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["user"] = - 1;
							}
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["isNew"] = 1;
							
							if (isset ( $categories [$reservation_data ["rooms"] [$i] ["vr_id"]] )) {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = $categories [$reservation_data ["rooms"] [$i] ["vr_id"]];
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = $reservation_data ["rooms"] [$i] ["vr_id"];
							} else {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["type_id"] = 0;
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_type_id"] = 0;
							}
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dealer"] = $dealer;
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_guestname"] = $reservation_data ["ord_firstname"] . " " . $reservation_data ["ord_lastname"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_numberofguest"] = $reservation_data ["rooms"] [$i] ["ordr_adults_cnt"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_countrycode"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_currencycode"] = $reservation_data ["cu_symbol"];
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_city"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_customerremarks"] = "";
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_roomremarks"] = "";
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["dc_totalprice"] = $reservation_data ["ord_total_price"];
							
							$result_array ["reservations"] [$counter] [$j] ["reservation"] ["smoking"] = "";
							if ($qty > 1 || $count_rooms > 1) {
								$result_array ["reservations"] [$counter] [$j] ["reservation"] ["groupid"] = $reservation_data ["ord_id"];
							}
							$result_array ["reservations"] [$counter] [$j] ["roomreservation_id"] = "";
						}
					}
				}
			}
			if ($debug == 1) {
				$return_data ["debug"] ["reservations_array"] = $result_array;
			}
			// die ();
			$host = "";
			if (isset ( $_SERVER ["HTTP_HOST"] )) {
				$host = $_SERVER ["HTTP_HOST"];
			}
			$reservationpush = array ();
			$cancel_done = 0;
			if (isset ( $result_array ["reservations"] )) {
				
				$bool_guest = 0;
				$bool_cancel = 0;
				$guest_array = array ();
				$guest_counter = 1;
				foreach ( $result_array ["reservations"] as $counter => $reservations ) {
					$res_count = count ( $reservations );
					
					for($i = 1; $i <= $res_count; $i ++) {
						
						if (isset ( $reservations [$i] ["per_day"] )) {
							
							$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
						}
						
						$calculate_data = array ();
						$calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
						$calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
						$calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
						$calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
						$calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
						$calculate_data ["addbedplace"] = 0;
						$calculate_data ["babyplace2"] = 0;
						$calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
						
						$temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
						$otelms_amount = 0;
						for($p = 0; $p < count ( $temp_amount ); $p ++) {
							$otelms_amount += $temp_amount [$p] ["amount"];
						}
						$booking_amount = $reservations [$i] ["reservation"] ["dc_totalprice"];
						$reservations [$i] ["reservation"] ["discount"] = 0;
						if ($booking_amount != $otelms_amount) {
							if ($otelms_amount != 0) {
								$reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
							}
						}
						
						// =====================================================
						// =====================================================
						// =====================================================
						
						$datein = $reservations [$i] ["reservation"] ["datein"];
						$dateout = $reservations [$i] ["reservation"] ["dateout"];
						$type_id = $reservations [$i] ["reservation"] ["type_id"];
						$sql = "SELECT id, room_id FROM deskofreservation WHERE cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' ORDER BY id DESC ";
						// echo $sql;
						$query = $this->db->query ( $sql );
						$hms_reservation_id = 0;
						$otelms_room_id = 0;
						if ($query->num_rows () > 0) {
							$row = $query->row ();
							$hms_reservation_id = $row->id;
							$otelms_room_id = $row->room_id;
						}
						// echo $hms_reservation_id."+++++++++++++++";
						
						if (isset ( $reservations [$i] ["per_day"] )) {
							
							$this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
						}
						
						if ($reservations [1] ["status"] == "modified") {
							$reservations [$i] ["reservation"] ["specialstatus"] = "modified";
						}
						if ($hms_reservation_id == 0) {
							/*
							 * NEW RESERVATION BLOCK
							 */
							
							$room_id = 0;
							
							/*
							 * if ($type_id == 0 or $type_id == "") { $query2 = $this->db->query ( "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'overbooking_category_id'" ); if ($query->num_rows () > 0) { $row2 = $query2->row (); $type_id = $row2->int_value; } }
							 */
							if ($type_id == 0 or $type_id == "") {
								$reservationpush [$k] ["response"] = "error";
								$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
								// $reservationpush [$k] ["text"] = "fail";
								$reservationpush [$k] ["status"] = "fail";
								$reservationpush [$k] ["hms_reservation_id"] = 0;
								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
								$k ++;
							} else {
							/*
								 * ===== CAN INSERT BLOCK =======
								 * 
								 */
								$cat_mass_avail = $this->frontdesk->get_categories_freerooms_period( $datein, $dateout, 1 );
								//print_r($cat_mass_avail);
								$can_insert_arr = $cat_mass_avail[$type_id];
								$can_insert = 1;
								$min_avail = 1;
								foreach($can_insert_arr as $cell){
									if($cell["availability"] < $min_avail){
										$can_insert = 0;
										break;
									}
								}
								
								//echo $can_insert;
								//die();
								/*
								 * ===== END CAN INSERT BLOCK =======
								*
								*/
								
								$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
    							if ($room_id == 0) {
    								$reservations [$i] ["reservation"] ["is_overbook"] = 1;
    								if (isset ( $overbooking_category_id ) && $can_insert == 1) {
    									$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
    									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
    									//echo $room_id;
    									$insert_over_room_bool = 0;
    									if ($room_id == 0) {
    										$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
    										$insert_over_room_bool = 1;
    									}
    								} else {
    									$reservationpush [$k] ["response"] = "failed";
    									$reservationpush [$k] ["text"] = "no overbooking_category_id";
    									$reservationpush [$k] ["status"] = "new";
    									$reservationpush [$k] ["hms_reservation_id"] = 0;
    									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    									$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    									$result_array ["reservations"] [$counter] [$i] ["status"] = "new";
    									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    									
    									if(isset($otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]])){
    										$otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]]["status"] = 1;
    									}
    									continue;
    								}
    							}
    							$reservations [$i] ["reservation"] ["room_id"] = $room_id;
    
    							if ($bool_guest == 0) {
    								$guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
    								$bool_guest = 1;
    							}
								//print_r($reservations [$i] ["reservation"]);
    							$reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
    
								if(isset($otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]])){
    								$otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]]["status"] = 1;
    							}
    
    							if (isset ( $reservations [$i] ["card"] )) {
    								$this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $reservation_id );
    							}
    
    							if ($reservation_id > 0) {
    								$reservationpush [$k] ["response"] = "ok";
    								$reservationpush [$k] ["text"] = "";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = $reservation_id;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$counter] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							} else {
    								$reservationpush [$k] ["response"] = "failed";
    								$reservationpush [$k] ["text"] = "undferror";
    								$reservationpush [$k] ["status"] = "new";
    								$reservationpush [$k] ["hms_reservation_id"] = 0;
    								$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
    								$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
    								$result_array ["reservations"] [$counter] [$i] ["status"] = "new";
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
    								$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
    								$k ++;
    							}
							}
						} else {
							/*
							 * UPDATE RESERVATION BLOCK
							 */
							
							$reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
							
							// $reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
							$reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
							$reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
							$reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
							$reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
							
							$reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
							$reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
							$reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
							$reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
							$reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
							$reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
							$reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
							$reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
							$reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
							if ($reservation_data ["type_id"] == $type_id) {
								$reservation_data ["room_id"] = $row->room_id;
							} else {
								$reservation_data ["room_id"] = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
							}
							// $reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
							$reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
							$reservation_data ["guest_id_new"] = 0;
							$reservation_data ["free_places"] = 0;
							$reservation_data ["maid_description"] = "";
							$reservation_data ["isread"] = 0;
							$reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
							$reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
							$reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
							$reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
							$reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
							$reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
							$reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
							$reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
							$reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
							
							if ($reservation_data ["type_id"] == $type_id) {
								$can_resize = $this->frontdesk->qd_canresize ( $hms_reservation_id, $datein, $dateout );
							} else {
								$can_resize = 0;
								$reservation_data ["type_id"] = $type_id;
							}
							if ($can_resize == 1) {
								
								$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
								
								if (isset ( $otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]] )) {
									$otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]] ["status"] = 1;
								}
								if ($update_res == "FreeError") {
									$reservationpush [$k] ["response"] = "error";
									$reservationpush [$k] ["text"] = "";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = "";
									$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"] ["dc_reservationid"];
									$k ++;
								} else {
									$reservationpush [$k] ["response"] = "ok";
									$reservationpush [$k] ["text"] = "";
									$reservationpush [$k] ["alert"] = "";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = "";
									$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"] ["dc_reservationid"];
									$k ++;
								}
							} else {
								if ($type_id == 0 or $type_id == "") {
									$query2 = $this->db->query ( "SELECT int_value FROM dc_101otel_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
									if ($query->num_rows () > 0) {
										$row2 = $query2->row ();
										$type_id = $row2->int_value;
									}
								}
								if ($type_id == 0 or $type_id == "") {
									$reservationpush [$k] ["response"] = "error";
									$reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
									$reservationpush [$k] ["status"] = "modified";
									$reservationpush [$k] ["hms_reservation_id"] = $row->id;
									$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
									$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
									$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
									$k ++;
								} else {
									$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id );
									if ($room_id == 0) {
										$reservation_data ["is_overbook"] = 1;
										if (isset ( $overbooking_category_id )) {
											$reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
											$room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id );
											
											$insert_over_room_bool = 0;
											if ($room_id == 0) {
												$room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
												$insert_over_room_bool = 1;
											}
										} else {
											$reservationpush [$k] ["response"] = "failed";
											$reservationpush [$k] ["text"] = "no overbooking_category_id";
											$reservationpush [$k] ["status"] = "modified";
											$reservationpush [$k] ["hms_reservation_id"] = 0;
											$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
											$reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
											$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
											$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
											$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
											$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										}
									}
									$reservation_data ["room_id"] = $room_id;
									
									$update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
									
									if (isset ( $otelms_rooms [$dc_reservationid] [$reservations [$i] ["reservation"] ["dc_uuid"]] )) {
										$otelms_rooms [$dc_reservationid] [$reservations [$i] ["reservation"] ["dc_uuid"]] ["status"] = 1;
									}
									
									if ($update_res == "FreeError") {
										$reservationpush [$k] ["response"] = "error";
										$reservationpush [$k] ["text"] = "";
										$reservationpush [$k] ["status"] = "modified";
										$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
										$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = "";
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"] ["dc_reservationid"];
										$k ++;
									} else {
										$reservationpush [$k] ["response"] = "ok";
										$reservationpush [$k] ["text"] = "";
										$reservationpush [$k] ["alert"] = "";
										$reservationpush [$k] ["status"] = "modified";
										$reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
										$result_array ["reservations"] [$counter] [$i] ["status"] = "modified";
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["reservation_alert"] = "";
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
										$result_array ["reservations"] [$counter] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
										$reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"] ["dc_reservationid"];
										$k ++;
									}
								}
							}
							
							// }
						}
					}
				}
				
				// print_r ( $reservationpush );
				// print_r ( $otelms_rooms );
				// die();
				foreach ( $otelms_rooms as $cell ) {
					if ($cell ["status"] == 0) {
						// $this->frontdesk->DeleteReservation($cell["otelms_reservation_id"]);
						$status = 5;
						$data_cancel = array ();
						$data_cancel ["res_id"] = $cell ["otelms_reservation_id"];
						$data_cancel ["charge"] = 0;
						$data_cancel ["status"] = $status;
						$data_cancel ["description"] = "cancel from 101otel";
						$data_cancel ["guestbe_request"] = 0;
						$data_cancel ["user"] = - 1;
						// ====================
						$this->Cancel->Insert ( $data_cancel );
					}
				}
				
				// die();
				$counter_r = 0;
				$new_mass = array ();
				foreach ( $result_array ["reservations"] as $cell ) {
					
					$res_count = count ( $cell );
					for($i = 1; $i <= $res_count; $i ++) {
						if ($cell [$i] ["status"] == "new" or $cell [$i] ["status"] == "modified") {
							$new_mass ['dcname'] = "Eholiday";
							$new_mass ['status'] = $cell [$i] ["status"];
							$new_mass ['dc_reservationid'] = $cell [$i] ["reservation"] ["dc_reservationid"];
							$new_mass ['dc_channel_name'] = "Eholiday";
							$new_mass ['hotel_name'] = "hotel_name";
							$new_mass ['guest_firstname'] = $cell [$i] ["guest"] ["firstname"];
							$new_mass ['guest_lastname'] = $cell [$i] ["guest"] ["lastname"];
							$new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
							$new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
							
							$new_mass ["room"] [$counter_r] ["reservation_current"] = $i;
							$new_mass ["room"] [$counter_r] ["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
							$new_mass ["room"] [$counter_r] ["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
							$new_mass ["room"] [$counter_r] ["url"] = $cell [$i] ["reservation"] ["url"];
							$new_mass ["room"] [$counter_r] ["dc_channel_name"] = "Eholiday";
							
							$new_mass ["room"] [$counter_r] ["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
							$new_mass ["room"] [$counter_r] ["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
							$new_mass ["room"] [$counter_r] ["hotel_name"] = "hotel_name";
							$new_mass ["room"] [$counter_r] ["reservation_date"] = $cell [$i] ["reservation"] ["date"];
							$new_mass ["room"] [$counter_r] ["status"] = $cell [$i] ["status"];
							$new_mass ["room"] [$counter_r] ["reservation_datein"] = $cell [$i] ["reservation"] ["datein"];
							$new_mass ["room"] [$counter_r] ["reservation_dateout"] = $cell [$i] ["reservation"] ["dateout"];
							$new_mass ["room"] [$counter_r] ["reservation_type_name"] = $cell [$i] ["reservation"] ["reservation_type_name"];
							$new_mass ["room"] [$counter_r] ["reservation_category_id"] = $cell [$i] ["reservation"] ["type_id"];
							$new_mass ["room"] [$counter_r] ["reservation_dc_totalprice"] = $cell [$i] ["reservation"] ["dc_totalprice"];
							$new_mass ["room"] [$counter_r] ["reservation_dc_customerremarks"] = "";
							
							$new_mass ["room"] [$counter_r] ["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
							
							$counter_r ++;
						}
					}
				}
				if (count ( $new_mass ) > 0) {
					// print_r($new_mass);
					if ($debug == 1) {
						$this->dc_model->send_notifyarray_new ( $new_mass, 0 );
					} else {
						$this->dc_model->send_notifyarray_new ( $new_mass );
					}
				}
			}
		}
    	if($debug == 1){
    		$return_data["debug"]["reservationpush"] = $reservationpush;
    	}
    	//print_r ( $reservationpush );
    	foreach ( $reservationpush as $arg ) {
    		if ($iscancel == 1) {
    			$data = array ();
    			$data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
    			$data ['response'] = $arg ['response'];
    			$data ['resid'] = $arg ['dc_reservationid'];
    			$data ['dcname'] = "Eholiday";
    			$data ['status'] = $arg ['status'];
    			$data ['text'] = $arg ['text'];
    			
    			if ($debug == 1) {
    				$this->dc_model->send_notifyarray ( $data, 0 );
    			} else {
    				$this->dc_model->send_notifyarray ( $data );
    			}
    			
    		}
    	}
    	
    	$return_data ["data"] = $reservationpush;
    	return $return_data;
    }
    
    function dc_rate_intdate_insert($data) {
    	$count = count ( $data );
    	if ($count != 0) {
    		foreach ( $data as $cell ) {
    			$query = $this->db->query ( "DELETE FROM dc_eholiday_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
    			break;
    		}
    		foreach ( $data as $cell ) {
    			$sql = "INSERT INTO dc_eholiday_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
    			// echo $sql;
    			$query = $this->db->query ( $sql );
    		}
    	}
    }
    function check_insert($data){
    	$categories = array ();
    	$query = $this->db->query ( "SELECT dc_room_id, category_id FROM dc_eholiday_rooms_link" );
    	
    	if ($query->num_rows () > 0) {
    		foreach ( $query->result () as $row ) {
    			$categories [$row->dc_room_id] = $row->category_id;
    		}
    	}
    	
    	$check = 1;
    	    	
    	foreach ( $data ["rooms"] as $room ) {
			$qty = $room ["ordr_room_cnt"];
			if(isset($categories [$room ["vr_id"]])){
				$count_free_rooms = $this->frontdesk->getfreeroomlist_forallperiod_new ( $data ["ord_date_from"], $data ["ord_date_to"], $categories [$room ["vr_id"]]);
			}else{
				$check = 0;
				break;
			}
			//die();
			if (isset ( $categories [$room ["vr_id"]] )) {
				//echo "|||||".$count_free_rooms."||||-----".$qty."\\\\\\";
				if ($count_free_rooms >= $qty) {
				} else {
					$check = 0;
					break;
				}
			} else {
				$check = 0;
				break;
			}
		}
    	return $check;
    }
    function getauthparam()
    {
    	$data = array();
    	$dc_hotel_id = 0;    	
    	$sql = "SELECT int_value FROM dc_eholiday_xml_cfg WHERE name LIKE 'hotel_id'";
    	$query = $this->db->query($sql);
    	if ($query->num_rows() > 0) {
    		$row = $query->row();
    		if($row->int_value <> 0)
    			$dc_hotel_id = $row->int_value;
    	}
    
    
    	$data['dc_hotel_id'] = $dc_hotel_id;
    	return $data;
    }
}