<?php

class dcm_booking_fsi_v extends CI_Model
{

    public function __construct ()
    {
        parent::__construct();
        $this->load->model('curl_model');
    }

    public function get_checkin_variations_dictionary ($type = 'primary')
    {
        $variation = $type == 'primary' ? 'primary_checkin_method' : 'alternative_checkin_method';
        
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = "https://supply-xml.booking.com/checkin-methods-api/checkin-methods?stream_variation_name=$variation";
        
        $headers = array(
                'Authorization: Basic ' . base64_encode($auth)
        );
        
        $result = $this->curlExecution("", $url, $headers, "GET");
        
        return $result['data']['checkin_methods'] ? $result['data']['checkin_methods'] : array();
    }

    public function curlExecution ($data, $url, 
            $header = array('Content-Type: application/json'), $method = "POST")
    {
        $ch = curl_init($url);
        
        curl_setopt_array($ch, 
                array(
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_HTTPHEADER => $header,
                        CURLOPT_CONNECTTIMEOUT => 60,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
                    // CURLOPT_SSL_VERIFYHOST => false,
                    // CURLOPT_SSL_VERIFYPEER => false,
                ));
        
        switch ($method) {
            case 'GET':
                break;
            
            case 'POST':
                curl_setopt($ch, CURLOPT_POST, true);
                if (! empty($data)) {
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                }
                break;
            
            case 'PUT':
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                if (! empty($data)) {
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                }
                break;
            
            case 'DELETE':
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
                break;
            
            case 'PATCH':
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
                if (! empty($data)) {
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                }
                break;
            
            default:
                die('Unsupported HTTP method: ' . $method);
        }
        
        $response = curl_exec($ch);
        if ($response === false) {
            die(curl_error($ch));
        }
        curl_close($ch);
        if ($this->isJson($response)) {
            $response = json_decode($response, true);
        }
        return $response;
    }

    private function isJson ($string)
    {
        json_decode($string);
        return json_last_error() === JSON_ERROR_NONE;
    }

    public function getCuisineCodes ()
    {
        $res = $this->db->select('*')
            ->get('global_hotelix_common.booking_rest_cuisine_codes')
            ->result_array('id');
        return $res;
    }

    public function getOperationDays ()
    {
        return array(
                array(
                        'day_name' => 'Monday',
                        'day_code' => 'Mon',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Tuesday',
                        'day_code' => 'Tue',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Wednesday',
                        'day_code' => 'Weds',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Thursday',
                        'day_code' => 'Thur',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Friday',
                        'day_code' => 'Fri',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Saturday',
                        'day_code' => 'Sat',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                ),
                array(
                        'day_name' => 'Sunday',
                        'day_code' => 'Sun',
                        'day_checked' => '',
                        'Start' =>'',
                        'End' =>''
                )
        );
    }

    public function getRestaurantFeatures ()
    {
        return array(
                array(
                        'code' => 'a la carte',
                        'name' => 'The restaurant offers à la carte dining'
                ),
                array(
                        'code' => 'buffet',
                        'name' => 'The restaurant has a buffet'
                ),
                array(
                        'code' => 'guests only',
                        'name' => 'The restaurant only serves guests of the property'
                ),
                array(
                        'code' => 'accepts reservations',
                        'name' => 'Customers can reserve a table at the restaurant'
                ),
                array(
                        'code' => 'outdoor seating',
                        'name' => 'The restaurant offers outdoor seating'
                )
        );
    }

    public function geRestaurantAmbiances ()
    {
        return array(
                array(
                        'code' => 'family/kids friendly'
                ),
                array(
                        'code' => 'modern'
                ),
                array(
                        'code' => 'romantic'
                ),
                array(
                        'code' => 'traditional'
                )
        );
    }

    public function getRestaurantDietaryOptions ()
    {
        return array(
                array(
                        'code' => 'dairy free'
                ),
                array(
                        'code' => 'gluten free'
                ),
                array(
                        'code' => 'halal'
                ),
                array(
                        'code' => 'kosher'
                ),
                array(
                        'code' => 'vegan'
                ),
                array(
                        'code' => 'vegetarian'
                )
        );
    }
    public function create_or_update_restaurant($post = array()) {
        $restaurant_id = isset($post['hms_restaurant_id']) ? $post['hms_restaurant_id'] : null;//
        $hms_property_id = $post['hms_property_id'] ? $post['hms_property_id'] : null;
        $Restaurant_data = $post['Restaurant'] ? $post['Restaurant'] : array();
        $data = json_encode($Restaurant_data);
        $tbl = 'restaurants';
        if ($restaurant_id) {//update
            $update = array(
                    'data' => $data
            );
            $where = array(
                    'id' => $restaurant_id
            );
            $this->db->update($tbl, $update, $where);
        }else{ // create
            $create = array(
                    'hms_property_id' => $hms_property_id,
                    'data' => $data
            );
            $this->db->insert($tbl, $create);
            $restaurant_id = $this->db->insert_id();
        }
        $result = array(
                'hms_restaurant_id' => $restaurant_id
        );
        return $result;
    }

    function getPropertyList ()
    {
        $property_information = array();
        $query = $this->db->select('*')->get('property_information');
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $property_information[$row->id]["id"] = $row->id;
                $property_information[$row->id]["name"] = $row->property_name;
            }
        }
        return $property_information;
    }
    function getRestaurantList ()
    {
        $restaurants = array();
        $query = $this->db->select('restaurants.*,property_information.property_name as property_name')->from('restaurants')->join('property_information','property_information.id=restaurants.hms_property_id','left')->get();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $row_json=$row->data;
                unset ($row->data);
                $restaurants[$row->id] = (array)$row;
                $restaurants[$row->id] += (array)json_decode($row_json);

                
            }
        }
        return $restaurants;
    }
    function getRestaurantsDataForXml(){
        
        $restaurants=$this->getRestaurantList();
        $structure_new=array();
        foreach($restaurants as $restaurant){
            $structure_new[]=$this->dcm_booking_fsi_v->createRestaurantArray($restaurant);
        }
        return array('Restaurants'=>array('Restaurant'=>$structure_new));        
    }
    
    public function createRestaurantArray($data)
    {
        $result=array(
                'OfferBreakfast'=>$data['OfferBreakfast'],
                'OfferBrunch'=>$data['OfferBrunch'],
                'OfferDinner'=>$data['OfferDinner'],
                'OfferLunch'=>$data['OfferLunch'],
                'RestaurantName'=>$data['RestaurantName']
        );
        if(isset($data['CuisineCodes'])){
            foreach($data['CuisineCodes'] as $code){
                $result['CuisineCodes']['CuisineCode'][]=array('Code'=>$code);
                
            }
        }
        if(isset($data['Features'])){
            foreach($data['Features'] as $el){
                $result['Features']['Feature'][]=array('DescriptiveText'=>$el);
                
            }
        }
        if(isset($data['Ambiances'])){
            foreach($data['Ambiances'] as $el){
                $result['TPA_Extensions']['Ambiances']['Ambiance'][]=array('Name'=>$el);
                
            }
        }
        if(isset($data['DietaryOptions'])){
            foreach($data['DietaryOptions'] as $el){
                $result['TPA_Extensions']['DietaryOptions']['DietaryOption'][]=array('Name'=>$el);
                
            }
        }
        if(isset($data['OperationTimes'])){
            foreach($data['OperationTimes'] as $key=>$el){
                $result['OperationSchedules']['OperationSchedule']['OperationTimes']['OperationTime'][$key]=(array)$el;
                
            }
        }
        
        return $result;
    }
}
?>