<?php

class dcm_booking_fsi extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('curl_model');
    }
    
    
    public function update_property__($p = array('data', 'booking_property_id', 'action'/* create, update */))
    {
        $booking_property_id = $p['booking_property_id'];
        
        switch ($p['action']) {
            case 'create':
                $HotelDescriptiveContent = array(
                //                 "@HotelCode" => "4386613", // remove node for a new property
                //                 "@HotelName" => "Vit Hotel",
                //                 "@LanguageCode" => "uk",
                //                 "@CurrencyCode" => "INR",
                //                 "@HotelDescriptiveContentNotifType" => "New"
                
                );
                break;
            case 'update':
                $HotelDescriptiveContent = array(
                "@HotelCode" => $booking_property_id, // remove node for a new property
                "@LanguageCode" => "uk",
                "@HotelDescriptiveContentNotifType" => "Overlay"
                    );
                break;
                
            default:
                echo '<pre>';
                print_r('Invalid action!');
                die("Died by Andrew at booking_api_mdl.php on 3 лист. 2023 р.  16:18:32");
                break;
        }
        
        $HotelDescriptiveContent += $this->get_HotelDescriptiveContent_parsed_structure(array('data' => $p['data']));
        $data_for_xml = array(
            '@xmlns' => 'http://www.opentravel.org/OTA/2003/05',
            '@xmlns:xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
            '@xsi:schemaLocation' => 'http://www.opentravel.org/2014B/OTA_HotelDescriptiveContentNotifRQ.xsd',
            '@TimeStamp' => date('c'),
            '@Target' => $this->is_test_env ? 'Test' : 'Production',
            'HotelDescriptiveContents' => array(
                'HotelDescriptiveContent' => $HotelDescriptiveContent,
            )
        );
        $xml = new SimpleXMLElement('<OTA_HotelDescriptiveContentNotifRQ></OTA_HotelDescriptiveContentNotifRQ>');
        $this->createXmlFromArray($data_for_xml, $xml);
        $post_data = $xml->asXML();
        
        $api_url = 'https://supply-xml.booking.com/hotels/ota/OTA_HotelDescriptiveContentNotif';
        
        if ($this->fsi_request_to_session) {
            //             $this->session->set_userdata(array('fsi_prop_upd_last_req' => ''));
            //             $this->session->set_userdata(array('fsi_prop_upd_last_req' => $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)))));
            
            $_SESSION['fsi_prop_upd_last_req'] = $this->prettyPrint(json_encode(array('url' => $api_url, 'data' => $data_for_xml)));
        }
        
        if($this->debug){
            $response = 'Have not been sent to Booking API, DEBUG is ON!';
        }else {
            $response = $this->request_api(array(
                'post_data' => $post_data,
                'api_url' => $api_url
            ));
            $response = new SimpleXMLElement($response);
        }
        return $response;
    }
    
    public function get_hmspropid_by_bkpropid($booking_prop_id = NULL) {
        $hms_prop_id = NULL;
        $tbl = 'dc_booking2hms_properties';
        $where_arr = array('booking_property_id' => $booking_prop_id);
        $query_row = $this->db->select()->get_where($tbl, $where_arr)->row();
        if ($query_row) {
            $hms_prop_id = $query_row->hms_property_id;
        }
        return $hms_prop_id;
    }
    
    public function update_property($booking_prop_id) {
        $this->load->model ( 'booking_api_mdl' );
        $hms_prop_id = $this->get_hmspropid_by_bkpropid($booking_prop_id);
        $hms_prop_data = $this->get_property_alldata_for_update($hms_prop_id);
        $prepeared_data = $this->prepeare_property_data_for_update_booking_property($hms_prop_data);
        $result = $this->booking_api_mdl->crup_property(array(
            'data' => $prepeared_data,
            'booking_property_id' => $booking_prop_id,
            'action' => 'update'
        ));
        return $result;
    }
    
    public function prepeare_property_data_for_update_booking_property($hms_prop_data) {
        
        $this->load->model ( 'property_model' );
        $AffiliationInfo = array();
        $HotelInfo = array();
        $mealtype_services_codes = $this->property_model->get_property_mealtype_amenety_codes();
        $services = array('Services' => array('Service' => array()));
        foreach ($hms_prop_data->ameneties as $amenety_data) {
            if (!in_array($amenety_data['bk_amenety_code'], $mealtype_services_codes)) {//temp eliminate mealtype_services_codes before price etc.
                array_push($services['Services']['Service'], array('Code' => $amenety_data['bk_amenety_code']));
            }
        }
        $HotelInfo += $services;
        
        $AffiliationInfo['Awards'] = array(
            'Award' => array(
                'Provider' => 'Star rating',
                'Rating' => $hms_prop_data->star_rating
            )
        );
                
        $Policies = array();
        
        if (count($hms_prop_data->cancellationpolicies)) {
            $CancelPolicy = array();
            foreach ($hms_prop_data->cancellationpolicies as $cancellationpolicy_data) {
                $CancelPolicy['CancelPenalty'][] = array('PolicyCode' => $cancellationpolicy_data->booking_code);
            }
            $Policies['Policy'] = array(
                'CancelPolicy' => $CancelPolicy
            );
        }
        
        $prepeared_data = array(
            'LanguageCode' => 'en',
            'HotelName' => $hms_prop_data->property_name_lat,
            'AffiliationInfo' => $AffiliationInfo,
            'HotelInfo' => $HotelInfo,
            'Policies' => $Policies,
        );
        
        return $prepeared_data;
    }
    
    public function get_property_alldata_for_update($hms_prop_id) {
        $this->load->model ( 'property_model' );
        $hms_properties = $this->property_model->get_hms_properties_data(array('hms_prop_id' => $hms_prop_id));
        $hms_prop_data = $hms_properties[$hms_prop_id];
        
        $hms_prop_data->ameneties = $this->property_model->get_property_ameneties($hms_prop_id, 2);
        $hms_prop_data->cancellationpolicies = $this->property_model->get_property_cancellationpolicies_data();
        
        return $hms_prop_data;
    }
    
    public function get_photos( $property_id )
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/photos";
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
    
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($curl);
    
        curl_close($curl);

        return json_decode( $response ,1 );
    }
    
    function get_property_rooms($property_id){
        $return_data = array();
        $query = $this->db->get_where("dc_booking_rooms_link", array('dc_hotel_id' => $property_id));
        if($query->num_rows()> 0) {
            foreach($query->result_array() as $row){
                array_push($return_data, array(
                    'property_id' => $row['dc_hotel_id'],
                    'room_id' => $row['dc_room_id'],
                    'room_name' => $row['dc_room_name'],
                ));
            }
        }
        
        return $return_data;
    }
    
    public function add_to_gallery( $data )
    {
        $property_id = $data ['property_id'];
        //$room_id = null;
        
        $url = isset($data ['room_id']) ? "https://supply-xml.booking.com/photo-api/properties/$property_id/rooms/".$data ['room_id']."/gallery"
                                        : "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";
    
        $photos = array(
            "insert_photos" => $data ['photo_ids']
        );
    
        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $photos );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    public function remove_from_gallery( $data )
    {
        $property_id = $data ['property_id'];
        //$room_id = null;
        //$room_id = $data ['room_id'];
        $url = isset($data ['room_id']) ? "https://supply-xml.booking.com/photo-api/properties/$property_id/rooms/".$data ['room_id']."/gallery"
                                        : "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";    
        $photos = array("remove_photos" => $data ['photo_ids']);
    
        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $photos );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    public function delete_photo( $data )
    {
        $property_id = $data ['property_id'];
        $photo_id = $data ['photo_id'];
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
    
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/photos/$photo_id";
        //echo $url;
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
    
        $curl = curl_init();
         
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
    
        curl_close($curl);
    
        echo '<pre>';
        print_r( $response );
    }
    
    function get_modal_ajax_edit_photo_tags($property_id, $photo_id){
        $data = array(
            'property_id' => $property_id,
            'photo_id' => $photo_id,
        );
        $this->load->library('parser');
        return $this->load->view('/dc_booking/fsi/ajax_edit_photo_tags_view.php', $data, true);
    }
    
    public function get_photo_info($property_id = 0, $photo_id = '')
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/photos/$photo_id";
        
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $buffer = curl_exec($curl);
        
        curl_close($curl);
        
        $response = json_decode($buffer, 1);
//         echo '<pre>';
//         print_r($response);
//         die();
        
        return json_decode($buffer, 1);
    }
    
    public function update_photo_tags( $data )
    {
        $property_id = $data ['property_id'];
        $photo_id = $data ['photo_id'];
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/photos/$photo_id/tags";
    
        $tags = array('tag_ids' => $data ['tags']);
    
        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $tags );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    public function get_panoramic_photos( $property_id )
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/panoramic-photos";
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
    
        $curl = curl_init();
         
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
    
        curl_close($curl);
        
        return json_decode( $response ,1 );
    }
    
    public function upload_panoramic_photo( $data )
    {
        echo "<pre>";
        print_r($data);
        print_r($_FILES);
        $property_id = $data ['property_id'];
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/panoramic-photos";
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: multipart/form-data'
        );
    
        //$file = 'https://topview.co.nz/wp-content/uploads/2019/08/Screenshot-of-2-to-1-ratio-360-image.png';
        $file = $data ['file_path'];
        $extension = pathinfo(parse_url($file, PHP_URL_PATH), PATHINFO_EXTENSION);
    
        $local = "image.$extension";
        echo $local;
        file_put_contents($local, fopen($file, 'r'));
    
        $curl = curl_init();
         
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('photo'=> "@{$local}"),
            //CURLOPT_POSTFIELDS => array('photo'=> new CURLFILE($local)),
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
    
        $err = curl_error($curl);
        $information = curl_getinfo($curl);
        curl_close($curl);
    
        unlink($local);
    
        echo '<pre>';
        print_r( array($err, $information, $response));
    }
    
    public function delete_panoramic_photos( $property_id, $photo_id )
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/panoramic-photos/$photo_id";
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
    
        $curl = curl_init();
         
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
        ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
    
        curl_close($curl);
    
        echo '<pre>';
        print_r( $response );
    }
    
    public function set_main_photo( $property_id, $photo_id )
    {
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";
        $photos = array("main_photo" => $photo_id);

        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $photos );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    public function get_galery( $property_id = 4386613, $room_id = null )
    {
        $user = $this->config->item('dc_booking_xml_user');
        $pwd = $this->config->item('dc_booking_xml_pwd');
        $auth = "$user:$pwd";
        //$auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
    
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";
    
        if( $room_id != null ){
            $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/rooms/$room_id/gallery";
        }
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
            'Content-Type: application/json'
        );
    
        $has_next = false;
        $galery = array();
    
        do {
            $curl = curl_init();
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_HTTPHEADER => $headers,
            ));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            $buffer = curl_exec($curl);
            	
            curl_close($curl);
            	
            $response = json_decode( $buffer ,1 );
            	
            if( isset( $response['data'] ) && ! empty( $response['data']['order'] ) ){
                $has_next = true;
                $url = $response['meta']['next_page'];
                if( empty( $galery ) ){
                    $galery = $response;
                } else {
                    $galery['data']['order'] = array_merge($galery['data']['order'], $response['data']['order']);
                }
            } else {
                $has_next = false;
            }
            	
        } while( $has_next );
        
        return $galery;
    }
    
    public function set_order( $data )
    {
        $property_id = $data ['property_id'];
        $room_id = $data ['room_id'];
    
        if( $room_id != null ){
            $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/rooms/$room_id/gallery";
        } else {
            $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";
        }

        $post_data['order'] = $data['order'];
    
        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $post_data );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    public function switch_smart_ordering( $property_id, $on = false )
    {
        $url = "https://supply-xml.booking.com/photo-api/properties/$property_id/gallery";
        $post_data = array( "smart_ordering" => (int)$on );

        $curl_data = array();
        $curl_data ['url'] = $url;
        $curl_data ['post'] = json_encode( $post_data );
        $curl_data ["returntype"] = 'array';
        $data_result = $this->curl_model->curl_post_booking_fsi($curl_data);
        
        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 1, 20, $data_result ["dc_log_id"] );
    }
    
    function get_roomrates_link(){
//         $room_data = array();
//         $rates_data = array();
        $data = array();
        
        $sql = "SELECT r2c.rate_id, r2c.category_id, dc_booking_rates_link.dc_rate_id, dc_booking_rooms_link.dc_room_id,
        dc_booking_rates.dc_hotel_id
        FROM ratetocategory as r2c
        INNER JOIN categories ON categories.id = r2c.category_id
        INNER JOIN rate ON rate.id = r2c.rate_id
        INNER JOIN dc_booking_rates_link ON dc_booking_rates_link.hms_rate_id = r2c.rate_id
        INNER JOIN dc_booking_rates ON dc_booking_rates.dc_rate_id = dc_booking_rates_link.dc_rate_id
        INNER JOIN dc_booking_rooms_link ON dc_booking_rooms_link.category_id = r2c.category_id 
        AND dc_booking_rooms_link.dc_hotel_id = dc_booking_rates.dc_hotel_id
        WHERE r2c.onlinebook = 1";
        //echo $sql."<br><br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                //$room_data[$row->dc_room_id] = $row->dc_room_id;
                //$rates_data[$row->dc_rate_id] = $row->dc_rate_id;
                $data[$row->dc_hotel_id][$row->dc_rate_id][$row->dc_room_id] = 1;
            }
        }
        
        return $data;
        //return array('rooms' => $room_data, 'rates' => $rates_data);
    }
    
    public function get_misconduct_categories()
    {
        $auth = 'Otelms-otelms2021:WHbML/sYYs^!67S2ZEskq=xw??JB2^Rd)wdvcLaV';
        //$auth = html_entity_decode('otelmsxml3:1-L^&#43;!bOE31e&gt;BZbXBM=Z2AUx8M(wF');
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth),
        );
        $url = 'https://supply-xml.booking.com/hotels/xml/misconductcategory';
    
        //echo '<pre>';
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
    
        $xml = new SimpleXMLElement($buffer);
        $result = $xml->xpath('category');
    
        $categories = array();
        $sub_categories = array();
        $sub_categories = array();
    
        $i = 0;
        foreach( $result as $k => $category ){
            	
            if( isset($category->subcategories) ){
                array_push($categories, array(
                    'category_id'		=> intval($category->attributes()->id),
                    'category_type'		=> strval($category->title),
                    'has_subcategories'	=> true
                ));
                
    
                foreach( $category->subcategories->subcategory as $subc ){
                    $sub_categories[$i] = array(
                        'subc_type'			=> strval($subc->title),
                        'subc_id' 			=> intval($subc->attributes()->id),
                        'category_id'		=> intval($category->attributes()->id),
                    );
                    $i++;
                }
            } else {
               array_push($categories, array(
                    'category_id'		=> intval($category->attributes()->id),
                    'category_type'		=> strval($category->title),
                    'has_subcategories'	=> true
                ));
    
                $i++;
            }
        }
    
//         echo "<pre>";
//         print_r(array('categories' => $categories, 'subcategories' => $sub_categories));
        return array('categories' => $categories, 'subcategories' => $sub_categories);
    }
    
    public function report_misconduct($data)
    {
        $auth = 'Otelms-vit:@z.!BV8bZ2)Z.?8(E*Eep?cga_jAG.ost=f!UBTr';
        $url = 'https://supply-xml.booking.com/hotels/xml/reporting';
    
        $headers = array(
            'Authorization: Basic ' . base64_encode($auth)
        );
    
        $subcategory_id = 0;
        if(isset($data ['subcategories'])){
            $subcategory_id = $data ['subcategories'];
        }
        
        if($data ['damage_type_id'] == '' ){
        $update = array(
            "reservation_id"		=> $data ['dc_reservationid'],
            "report"				=> 'guest_misconduct',
            "misconduct_details"	=> array(
                "category_id" 		=> $data ['misconduct_category'],
                'subcategory_id' 	=> $subcategory_id,
                'details_text'		=> $data ['message'],
                'escalate_report'	=> 0,
                'rebooking_allowed'	=> 0
            )
        );
        }else{
            $update = array(
                "reservation_id"		=> $data ['dc_reservationid'],
                "report"				=> 'guest_misconduct',
                "misconduct_details"	=> array(
                    "category_id" 			=> $data ['misconduct_category'],
                    'damage_type_id' 		=> $data ['damage_type_id'],
                    'damage_cost'			=> $data ['damage_cost'],
                    'damage_unavailable'	=> $data ['damage_unavailable'],
                    'details_text'			=> $data ['message'],
                    'escalate_report'		=> 1,
                    'rebooking_allowed'		=> 0
                )
            );
        }
    
        
    
        $xml = new SimpleXMLElement('<request></request>');
        $this->createXmlFromArray($update, $xml);
    
        // Output the formatted XML string
        $data = $xml->asXML();
        echo '<pre>';
        echo htmlentities($data);
        echo "<hr>";
        //print_r($rooms);
        //die();
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        $buffer = curl_exec($ch);
        curl_close($ch);
    
        print_r( htmlentities( $buffer ) );
    }
    
    private function createXmlFromArray( $array, &$xml )
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                if (is_numeric($key)) {
                    $key = 'item' . $key; // Change numeric key to a valid XML element name
                }
    
                if ( isset($value[0]) && is_array($value[0])) {
                    foreach ($value as $item) {
                        $subnode = $xml->addChild($key);
                        $this->createXmlFromArray($item, $subnode);
                    }
                } else {
                    $subnode = $xml->addChild($key);
                    $this->createXmlFromArray($value, $subnode);
                }
            } else {
                if (strpos($key, '@') === 0) {
                    if ($key === "@xmlns:xsi") {
                        $xml->addAttribute("xmlns:xsi", $value);
                    } else {
                        $xml->addAttribute(substr($key, 1), htmlspecialchars($value));
                    }
                } else {
                    if( is_numeric( $key) ){
                        $xml->$key = $value;
                    } else {
                        $xml->addChild($key, htmlspecialchars($value));
                    }
                }
            }
        }
    }
}
?>