<?
class Dc_dev extends CI_Model {
	function __construct() {
		parent::__construct ();
		
		$this->load->model ( 'frontdesk_c2' );
	}
	
	function get_demographic_data($startdate, $enddate){
		$result_array = array();
	
		list ( $year, $month, $day ) = explode ( "-", $startdate );
		$intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		list ( $year, $month, $day ) = explode ( "-", $enddate );
		$intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
		$sql = "SELECT  guests.id, COUNT(1) as count, TIMESTAMPDIFF(YEAR,guests.dob,curdate()) as guest_old_year
				FROM guests
				GROUP BY guests.id, guest_old_year";
	
		$query = $this->db->query ( $sql );
		//echo $sql;
		//die();
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				$result_array[$row->id_dealer]["name"] = $row->dealer_name;
				$result_array[$row->id_dealer]["count2day"][$row->intdate]["day"] = date ( "Y-m-d", $row->intdate * 86400 );
				$result_array[$row->id_dealer]["count2day"][$row->intdate]["count"] = (int)$row->count;
			}
		}
	
		for($i = $intdatein; $i <= $intdateout; $i++){
			foreach($result_array as $id_dealer => $cell){
				if(!isset($result_array[$id_dealer]["count2day"][$i])){
					$result_array[$id_dealer]["count2day"][$i]["day"] = date ( "Y-m-d", $i * 86400 );
					$result_array[$id_dealer]["count2day"][$i]["count"] = 0;
				}
			}
		}
		return $result_array;
	}
	
	function get_RA($room_id, $rate_id, $shift_from, $shift_to) {
		$today_date = date("Y-m-d");
		
		list ( $year, $month, $day ) = explode ( "-", $today_date );
		$intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
		
		$intdate_from = $intdate_today + $shift_from;
		$intdate_to = $intdate_today + $shift_to;
		$date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
		$date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
		
		$sql = "SELECT category_id FROM rooms WHERE id = ".$room_id;
		$query = $this->db->query( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$category_id = $row->category_id;
		}
		
		
		$availability_array = array();
		$price_array = array();
		for($i = $intdate_from; $i <= $intdate_to; $i++){
			$availability_array[$i]["date"] = date( "Y-m-d", $i * 86400 );
			$availability_array[$i]["availability"] = 1;
			
			$price_array[$i]["date"] = date( "Y-m-d", $i * 86400 );
			$price_array[$i]["price"] = 0;
		}
		
		$not_available_array = array();
		$sql = "SELECT * from deskofdays WHERE room_id = ".$room_id." AND intdate >= ".$intdate_from." AND intdate <= ".$intdate_to;
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$k = 0;
			foreach ( $query->result () as $row ) {
				if (isset($availability_array[$row->intdate])){
					$availability_array[$i]["availability"] = 0;
				}
			}
		}
		
		$prices = $this->frontdesk_c2->get_prices($intdate_from, $intdate_to, $category_id, $rate_id);
		
		$yield_prices = $this->frontdesk_c2->get_yield_prices($intdate_from, $intdate_to, $category_id, $rate_id);
		
		foreach($price_array as $intdate => $cell){
			if(isset($prices[$category_id][$rate_id][$intdate])){
				$price_array[$intdate]["price"] = $prices[$category_id][$rate_id][$intdate]["price"];
			}
			if(isset($yield_prices[$category_id][$rate_id][$intdate])){
				$price_array[$intdate]["price"] = $yield_prices[$category_id][$rate_id][$intdate]["price"];
			}
		}
		
		$result_array = array();
		
		$result_array ["start_date"] = $date_from;
		$result_array ["end_date"] = $date_to;
		
		$result_array ["availability"] = $availability_array;
		$result_array ["prices"] = $price_array;
		
		echo "<pre>";
		print_r($result_array);
		die();
		
		return $result_array;
	}
	
	function get_amenity($room_id) {
		$sql = "SELECT category_id FROM rooms WHERE id = ".$room_id;
		$query = $this->db->query( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$category_id = $row->category_id;
		}
		$category_amenities = array();
		$sql = "SELECT amenity_type.* FROM amenity_type2categories 
		INNER JOIN amenity_type ON amenity_type.id = amenity_type2categories.amenity_id AND amenity_type2categories.category_id = ".$category_id;
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push($category_amenities, array(
					"id" => $row->id,
					"name" => $row->name,
				));
			}
		}
		echo "<pre>";
		print_r($category_amenities);
		die();
		return $category_amenities;
	}
	
	function get_availability($room_id, $shift_from, $shift_to) {
		$today_date = date("Y-m-d");
	
		list ( $year, $month, $day ) = explode ( "-", $today_date );
		$intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
		$intdate_from = $intdate_today + $shift_from;
		$intdate_to = $intdate_today + $shift_to;
		$date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
		$date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
	
		$availability_array = array();
		$price_array = array();
		for($i = $intdate_from; $i <= $intdate_to; $i++){
			$availability_array[$i]["from"] = date( "Y-m-d", $i * 86400 );
			$availability_array[$i]["to"] = date( "Y-m-d", $i * 86400 );
			$availability_array[$i]["availability"] = 1;
			$availability_array[$i]["availability_line"] = "";
		}
		
		$not_available_array = array();
		$sql = "SELECT * from deskofdays WHERE room_id = ".$room_id." AND intdate >= ".$intdate_from." AND intdate <= ".$intdate_to;
		//echo $sql;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			$k = 0;
			foreach ( $query->result () as $row ) {
				if (isset($availability_array[$row->intdate])){
					$availability_array[$row->intdate]["availability"] = 0;
				}
			}
		}
		
		foreach ($availability_array as $intdate => $cell) {
			$prev = $intdate - 1;
			if (isset($availability_array[$prev])) {
				$availability_1 = $availability_array[$prev]["availability"];
				$availability_2 = $availability_array[$intdate]["availability"];
		
				if ($availability_1 == $availability_2) {
					$availability_array[$intdate]["from"] = $availability_array[$prev]["from"];
					unset($availability_array[$prev]);
				}
			}
		}
		
		foreach ($availability_array as $intdate => $cell) {
			list ( $year, $month, $day ) = explode ( "-", $cell["from"] );
			$int_from = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
			
			list ( $year, $month, $day ) = explode ( "-", $cell["to"] );
			$int_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
			
			for($i = $int_from; $i <= $int_to; $i++){
				if($availability_array[$intdate]["availability"] == 1){
					if($i == $int_to){
						$availability_array[$intdate]["availability_line"] .= "A";
					}else{
						$availability_array[$intdate]["availability_line"] .= "A,";
					}
				}else{
					if($i == $int_to){
						$availability_array[$intdate]["availability_line"] .= "U";
					}else{
						$availability_array[$intdate]["availability_line"] .= "U,";
					}
				}
			}
		}
		
		$result_array = array();
	
		$result_array ["start_date"] = $date_from;
		$result_array ["end_date"] = $date_to;
	
		$result_array ["availability"] = $availability_array;
	
		echo "<pre>";
		print_r($result_array);
		die();
	
		return $result_array;
	}
	
	function get_prices($room_id, $rate_id, $shift_from, $shift_to) {
		$today_date = date("Y-m-d");
	
		list ( $year, $month, $day ) = explode ( "-", $today_date );
		$intdate_today = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	
		$intdate_from = $intdate_today + $shift_from;
		$intdate_to = $intdate_today + $shift_to;
		$date_from = date( "Y-m-d", ($intdate_today + $shift_from) * 86400 );
		$date_to = date( "Y-m-d", ($intdate_today + $shift_to) * 86400 );
	
		$sql = "SELECT category_id FROM rooms WHERE id = ".$room_id;
		$query = $this->db->query( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$category_id = $row->category_id;
		}
	
	
		$availability_array = array();
		$price_array = array();
		for($i = $intdate_from; $i <= $intdate_to; $i++){				
			$price_array[$i]["from"] = date( "Y-m-d", $i * 86400 );
			$price_array[$i]["to"] = date( "Y-m-d", $i * 86400 );
			$price_array[$i]["price"] = 0;
			$price_array[$i]["price_line"] = "";
		}
	
		$prices = $this->frontdesk_c2->get_prices($intdate_from, $intdate_to, $category_id, $rate_id);
	
		$yield_prices = $this->frontdesk_c2->get_yield_prices($intdate_from, $intdate_to, $category_id, $rate_id);
	
		foreach($price_array as $intdate => $cell){
			if(isset($prices[$category_id][$rate_id][$intdate])){
				$price_array[$intdate]["price"] = $prices[$category_id][$rate_id][$intdate]["price"];
			}
			if(isset($yield_prices[$category_id][$rate_id][$intdate])){
				$price_array[$intdate]["price"] = $yield_prices[$category_id][$rate_id][$intdate]["price"];
			}
		}
		
		foreach ($price_array as $intdate => $cell) {
			$prev = $intdate - 1;
			if (isset($price_array[$prev])) {
				$price_1 = $price_array[$prev]["price"];
				$price_2 = $price_array[$intdate]["price"];
		
				if ($price_1 == $price_2) {
					$price_array[$intdate]["from"] = $price_array[$prev]["from"];
					unset($price_array[$prev]);
				}
			}
		}
		
		foreach ($price_array as $intdate => $cell) {
			list ( $year, $month, $day ) = explode ( "-", $cell["from"] );
			$int_from = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				
			list ( $year, $month, $day ) = explode ( "-", $cell["to"] );
			$int_to = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
				
			for($i = $int_from; $i <= $int_to; $i++){	
				if($i == $int_to){
					$price_array[$intdate]["price_line"] .= $price_array[$intdate]["price"];
				}else{
					$price_array[$intdate]["price_line"] .= $price_array[$intdate]["price"].",";
				}
			}
		}
	
		$result_array = array();
	
		$result_array ["start_date"] = $date_from;
		$result_array ["end_date"] = $date_to;

		$result_array ["prices"] = $price_array;
	
		echo "<pre>";
		print_r($result_array);
		die();
	
		return $result_array;
	}
	
	function get_category_images($room_id){
		$category_images = array();
		$host = $_SERVER ["HTTP_HOST"];
	
		$category_id = 0;
		$sql = "SELECT category_id FROM rooms WHERE id = ".$room_id;
		$query = $this->db->query( $sql );
		if ($query->num_rows () > 0) {
			$row = $query->row ();
			$category_id = $row->category_id;
		}
	
		$sql = "SELECT id_position  FROM categories_images WHERE category_id = ".$category_id;
		$query = $this->db->query ( $sql );
		if ($query->num_rows () > 0) {
			foreach ( $query->result () as $row ) {
				array_push($category_images, array(
				"id_position" => $row->id_position,
				"img_url" => "http://".$host."/gatepublic//showimage/".$category_id."/".$row->id_position,
				));
			}
		}
	
		echo "<pre>";
		print_r($category_images);
	
		return $category_images;
	}
}
?>