<?php
//require_once ('application/controllers/rro.php');
//define('RROCHECKBOX_ID', 0);
const RROCHECKBOX_ID = 1;
const RROCHECKBOX_MODEL = 'rro_model';
const RROVCHASNO_ID = 2;
const RROVCHASNO_MODEL = 'rro_vchasno_mdl';

class Rro extends CI_Controller
{
    public $provider, $rro_mdl_name, $url_prefix;
    public static $providers = array(RROCHECKBOX_ID => 'checkbox', RROVCHASNO_ID => 'vchasno');
    public static $modeles = array(RROCHECKBOX_ID => RROCHECKBOX_MODEL, RROVCHASNO_ID => RROVCHASNO_MODEL);
    public $debug = FALSE;
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Authorization');
        $this->load->model('htmltpl');
        $this->load->model('rro_mdl');

        $this->load->model('rro_vchasno_mdl');

        $this->Authorization->IsLogined();

        $this->set_active_rro_provider();
        $this->set_rro_mdl_name();
        $this->set_url_prefix();
        $this->load->model($this->rro_mdl_name);
        
        $this->debug = (bool) $this->session->userdata('global_debug');
    }

    private function set_active_rro_provider() {
        $this->provider = $this->get_active_rro_provider();
    }

    public static function get_active_rro_provider() {
        $hotelix_config = new hotelix_config();
        $rro_active_provider = $hotelix_config->get_record ("rro_active_provider", "int");
        $rro_active_provider = $rro_active_provider == 0 ? 1 : $rro_active_provider;
        unset($hotelix_config);
        return $rro_active_provider;
    }

    public static function get_rro_module_status() {
        $releases = new releases();
        $rro_status = $releases->rro_activity();
        unset($releases);
        return $rro_status;
    }

    private function set_rro_mdl_name() {
        $this->rro_mdl_name = self::get_rro_mdl_name();
    }

    public static function get_rro_mdl_name() {
        return self::$modeles[self::get_active_rro_provider()];
    }

    private function set_url_prefix() {
        $this->url_prefix = self::get_url_prefix();
    }

    public static function get_url_prefix() {
        switch (self::get_active_rro_provider()) {
            case 2:
                $prefix = 'vchasno';
                break;

            default:
                $prefix = 'checkbox';
                break;
        }
        return $prefix;
    }

    public function devices_operations() {
        $data = array();
        $this->load->view ( "rro/{$this->url_prefix}/devices_operations_view.php", $data );
    }

    public function signin()
    {
        $this->session->set_userdata(array('rro_func_name' => 'signin'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function signout()
    {
        $this->session->set_userdata(array('rro_func_name' => 'signout'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function open_shift()
    {
        $this->session->set_userdata(array('rro_func_name' => 'open_shift'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function get_shifts( )
    {
        $this->session->set_userdata(array('rro_func_name' => 'get_shifts'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function close_shift()
    {
        $this->session->set_userdata(array('rro_func_name' => 'close_shift'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function x_report()
    {
        $this->session->set_userdata(array('rro_func_name' => 'x_report'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function last_check()
    {
        $this->session->set_userdata(array('rro_func_name' => 'last_check'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function cash_in($amount=0, $pay_type=0)
    {
        $data = array(
            'amount' => $amount,
            'pay_type' => $pay_type
        );
        $this->session->set_userdata(array('rro_func_data_'.__FUNCTION__ => $data));
        $this->session->set_userdata(array('rro_func_name' => 'cash_in'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function cash_out($amount=0, $pay_type=0)
    {
        $data = array(
            'amount' => $amount,
            'pay_type' => $pay_type
        );
        $this->session->set_userdata(array('rro_func_data_'.__FUNCTION__ => $data));
        $this->session->set_userdata(array('rro_func_name' => 'cash_out'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function get_cash_registers()
    {
        $this->session->set_userdata(array('rro_func_name' => 'get_cash_registers'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function get_cashier_profile()
    {
        $this->session->set_userdata(array('rro_func_name' => 'get_cashier_profile'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function print_html_receipt( $check_id )
    {
        $this->{$this->rro_mdl_name}->print_receipt(array(
            'check_id' => $check_id,
            'receipt_format' => 'html'
        ));
    }

    public function print_pdf_receipt( $check_id )
    {
        $this->{$this->rro_mdl_name}->print_receipt(array(
            'check_id' => $check_id,
            'receipt_format' => 'pdf'
        ));
    }

    public function get_status( )
    {
        $this->session->set_userdata(array('rro_func_name' => 'get_status'));
        die ( "<meta http-equiv='refresh' content='0;url=/rro/devices_operations'>" );
    }

    public function for_testing($p=null) {
        echo "<pre>";
        print_r($this->rro_vchasno_mdl->get_api_error_description($p));
        die("DIED by A Department on rro.php for_testing() at 30 окт. 2022 г. 16:09:34");
        $method_name = 'notify_customer';//get_status open_shift close_shift
//          $method_name = 'x_report';
        $method_name = 'last_check';

//        $method_name = 'get_check_task';
        if (method_exists($this->{$this->rro_mdl_name}, $method_name)) {
            $result = $this->{$this->rro_mdl_name}->$method_name('TEST_fyzy6TVHXtKzng');

            $result = json_decode($result);
            $xml_body = base64_decode($result->xml_body);
            //echo '<pre>', htmlentities($xml_body, ENT_IGNORE, "windows-1251");
            echo '<pre>';
            print_r(htmlentities($xml_body, ENT_IGNORE, "windows-1251"));

        }else {
            echo "Method '$method_name' not exist in '$this->rro_mdl_name'";
        }

    }

    public function settings() {
        $data = array();
        $this->load->view ( '/rro/vchasno/settings_view.php', $data );
    }

    public function settings_post() {
        $post = $this->input->post();
        $this->rro_mdl->save_settings_vchasno($post);
        die ( "<meta http-equiv='refresh' content='0;url=/rro/settings'>" );
    }

    public function settings_vchasno_test_token() {
        $ajax_post = json_decode(file_get_contents('php://input'));
        $this->rro_vchasno_mdl->set_token($ajax_post->token);
        $testing_result = json_decode($this->rro_vchasno_mdl->x_report());
        if ($testing_result->res > 0) {//so error
            $testing_result = $this->rro_vchasno_mdl->api_error_code_descriptions[$testing_result->res];
        }else{
            $testing_result = 'success';
        }
        echo json_encode(array('result_testing' =>$testing_result));
    }

    public function fetch_vchasno_settings_by_partner_id($partner_id) {
        $data = $this->rro_mdl->get_vchasno_settings_by_partner_id($partner_id);
        $token = '';
        $allowed_users = array();
        foreach ($data as $set) {
            if (isset($set->token)) {
                $token = $set->token;
            }
            if (isset($set->user_id) && $set->user_id != '') {
                array_push($allowed_users, $set->user_id);
            }
        }
        $res_arr = array('token' => $token, 'users' => $allowed_users);
        echo json_encode($res_arr);
    }
    
    public function view_logs() {
        $get = $this->input->get();
        $limit = isset($get['limit']) ? $get['limit'] : 10;
        $date = isset($get['date']) && $get['date'] ? $get['date'] : date('Y-m-d', strtotime('-1 month'));
        $logs = $this->{$this->rro_mdl_name}->get_logs(array('limit'=>$limit, 'date' => $date));
        foreach ($logs as &$log) {
            $log->strings = htmlspecialchars(print_r($log->strings, 1));
            $log->response = htmlspecialchars(print_r($log->response, 1));
            $log->pay_or_ref = $log->pay_or_ref ? 'refund' : 'payment';
        }
        unset($log);
        echo $this->parser->parse ( "templates/rro/{$this->url_prefix}/log_operations.html", array('logs' => $logs), true );
    }

}