<?php
class Tables {
	var $ta_hotels = "`global_hotelix`.`dc_ta_hotels`";
	var $h_config = 'hotelix_config';
	var $prop_info = "property_information";//property_custom_information
	var $prop_ameneties = "property_ameneties";
	var $prop2amenety = "property2ameneties";
	var $currency_rates_today = "`global_hotelix`.currency_rates_today";
	var $currencies = '`global_hotelix`.`currency`';
	var $supported_langs = 'descriptionlanguages';
	var $availability = "deskofdays_availability";
	var $inter = "internationalfields";
	var $room_views = "global_hotelix_common.room_view_type";
	var $beds2rooms = "beds2rooms";
	var $room_params = "category_room_param";
	var $bed_types = "`global_hotelix_common`.`bed_types`";
	var $room_photos = "category_images_registry";
	var $category2amenities = "category2amenities";
	var $category_ameneties = "global_hotelix_common.category_ameneties";
	var $cancelations = "`global_hotelix_common`.`dc_cancelationpolicy_list`";
	var $cancelation_types = "`global_hotelix_common`.`cancellationpolicy_types`";
	var $meal_policies = "meal_policies";
	var $age_ranges = "age_ranges_acb";
	var $reservations = "deskofreservation";
	var $groups = "groupreservations";
	var $servises = "services_main";
	var $servises_tf = "services_tf";
	var $countries = "global_fms_base.dict_country";
	var $ta_reservations = "ta_reservations";
}
class Gate_ta extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		ini_set('error_reporting', E_STRICT);
		$this->db_tables =  new Tables();
		$this->load->model ( 'dc_model' );//для якоїсь ОДНОЇ хні у фронтдеску для ОДНОГО каналу... ну ок, грузим
		$this->load->model ( 'cancel' );// модель санцель грузить 2 фронта і логер
		$this->load->model ( 'taxesfees_model' );
	}
	function booking_request() {//curl
		$t = &$this->db_tables;
		$booking_request_data = file_get_contents("php://input");
		$booking_request_data = json_decode($booking_request_data);
		$rooms_count = count($booking_request_data->rooms);
		$date_in = $booking_request_data->start_date;
		$date_out = $booking_request_data->end_date;
		$category_id = $booking_request_data->partner_data->category_id;
		$rate_id = $booking_request_data->partner_data->rate_id;

		$customer['firstname'] = $booking_request_data->customer->first_name;
		$customer['lastname'] = $booking_request_data->customer->last_name;
		$customer['phone'] = $booking_request_data->customer->phone_number;
		$customer['email'] = $booking_request_data->customer->email;
		$customer['country'] = $booking_request_data->customer->country;

		$customer_id = $this->frontdesk->Guest_insert ( $customer );

		$insert_reservation_data = array (
// 				'origin_categoryid' => $category_id,
				'dc_id' => 16,
				'dc_uuid' => $booking_request_data->reference_id,//$data ['dc_uuid'],
				'dc_source' => 'TripAdvisor',
// 				'dc_reservationid' => ,
// 				'dc_numberofguest' => $data ['dc_numberofguest'],
				'dc_currencycode' => $booking_request_data->final_price_at_booking->currency,
				// 				'dc_countrycode' => $data ['dc_countrycode'],
				'dc_customerremarks' => isset($booking_request_data->special_requests)?$booking_request_data->special_requests:'',
				'dc_totalprice' => round(($booking_request_data->final_price_at_booking->amount + $booking_request_data->final_price_at_checkout->amount)/$rooms_count, 0),
				'is_guest' => 0,
				'datein' => $date_in,
				'dateout' => $date_out,
				'price_type' => $rate_id
// 				'description' => $data ['description'],
		);
		$card_data = array (
				"CardHolder" => $booking_request_data->payment_method->cardholder_name,
				"CardNumber" => $booking_request_data->payment_method->card_number,
				"cc_type" => $booking_request_data->payment_method->card_type,
				"cc_cvc" => $booking_request_data->payment_method->cvv,
				"ExpMonth" => $booking_request_data->payment_method->expiration_month,
				"ExpYear" => $booking_request_data->payment_method->expiration_year
		);
		$complex_hms_reservation_ids_for_ta = "";
		$ta_res_id_for_url = "";
		$parties = array();
		foreach ($booking_request_data->rooms as $party_set) {
			array_push($parties, $party_set->party);
			$insert_reservation_data['room_id'] = $this->frontdesk->getfreeroomlist($date_in, $date_out, $category_id);
			$insert_reservation_data = array_merge($insert_reservation_data, $this->party_to_hms_guests($party_set->party, $category_id));
			$hms_reservation_id = $this->frontdesk->Reservation_insert ( $insert_reservation_data, $customer_id, 0, 1 );
			$complex_hms_reservation_ids_for_ta .= $hms_reservation_id."_";
			$this->frontdesk->insert_tbl_CreditCards ( $card_data, $customer_id, $hms_reservation_id );
			$this->db->insert($t->ta_reservations, array('hms_res_id'=>$hms_reservation_id));
			$ta_res_id_for_url = $this->db->insert_id();
			$guests_ages = $this->party_to_hms_guests_ages($party_set->party);
			foreach ($guests_ages as $guest_age) {
			    $insert_guest_data = array();
			    $insert_guest_data['dob'] = date('Y-m-d', strtotime("$date_in - $guest_age year"));
			    $insert_guest_data['lastname'] = '---';
			    $insert_guest_data['firstname'] = '---';
			    $guest_id = $this->frontdesk->Guest_insert($insert_guest_data);
			    $this->frontdesk->guests_reservation_insert($guest_id, $hms_reservation_id);
			}
			$this->frontdesk->save_taxesfees($hms_reservation_id);
			$this->frontdesk->SetReservationBalance ( $hms_reservation_id );
		}
		$complex_hms_reservation_ids_for_ta = substr($complex_hms_reservation_ids_for_ta, 0, -1);
		$if_complex_reservation = explode("_", $complex_hms_reservation_ids_for_ta);
		if (count($if_complex_reservation)>1){
			$this->db->insert($t->groups, array('name'=>'TA_GR_'.$complex_hms_reservation_ids_for_ta));
			$group_id = $this->db->insert_id();
			foreach ($if_complex_reservation as $reservation_id) {
				$this->db->update($t->reservations, array('intgroupid'=>$group_id), array('id'=>$reservation_id));
			}
			$this->db->insert($t->ta_reservations, array('hms_group_id'=>$group_id));
			$ta_res_id_for_url = $this->db->insert_id();
		}
		$data_for_line_items['prop_id'] = $booking_request_data->partner_data->prop_id;
		$data_for_line_items['parties'] = $parties;
		$data_for_line_items['type_id'] = $category_id;
		$data_for_line_items['price_type'] = $rate_id;
		$data_for_line_items['datein'] = $date_in;
		$data_for_line_items['dateout'] = $date_out;
		$data_for_line_items['hotel_currency'] = $this->get_hotel_currency();
		$data_for_line_items['requested_currency'] = $booking_request_data->final_price_at_booking->currency;
		$result_data = array (
				'hms_reservation_id' => $complex_hms_reservation_ids_for_ta,
				'hotel_details' => $this->get_hotel_details ( $booking_request_data->partner_data->prop_id ),
				'line_items' => $this->get_price_line_items($data_for_line_items),
				'confirmation_url' => "$ta_res_id_for_url",
				'requested_currency' => $booking_request_data->partner_data->requested_currency,
				'responsed_lang' => $booking_request_data->partner_data->responsed_lang
		);
		echo json_encode($result_data);
	}

	function cancel_booking() {//curl
		$requested_data = json_decode( file_get_contents("php://input"));
		$if_complex_reservation = explode("_", $requested_data->reservation_id);
		foreach ($if_complex_reservation as $reservation_id) {
			$data_for_cancelation = array (
				'res_id' => $reservation_id,
				'description' => 'Cancelation from TA, maybe cancelation policy is needed?',
				'charge' => 0,//cancelation policy penalty?
				'guestbe_request' => 'Once more durnia',//щоб не вмирати у ф-ції канцелювання
			);
			$this->cancel->Insert($data_for_cancelation);
			//Дурня звичайно, вона нічого не вертає, завжди вважаємо що успішно кансельнули
		}
		$response_data['status']= 'Success';
		$response_data['cancellation_number'] = 'TA_CA_'.$requested_data->reservation_id;
		echo json_encode($response_data);
	}
	function hotel_inventory(){//curl
		$requested_data = json_decode( file_get_contents("php://input"));
		$inventory_data = $this->get_hotel_details($requested_data->prop_id);
		$inventory_data->ta_id = $requested_data->ta_id;
		$inventory_data->partner_id = $requested_data->partner_id;
		$inventory_data->country = $inventory_data->country_str_name;
		echo json_encode($inventory_data);
	}
	function get_ability_hotel_responce_language($requested_lang) {
		$t = &$this->db_tables;
		$requested_lang = (!empty($requested_lang)) ? substr ( $requested_lang, 0, 2 ) : "";
		$lang_code = $this->db->select('code')->get_where($t->supported_langs, array('name'=>$requested_lang))->row();
		if (!empty($lang_code)){
			$lang_code = $lang_code->code;
		}else {
			$lang_code = 45; //english by default? ili kak?
		}
		return $lang_code;
	}
	function get_hotel_currency() {
		$t = &$this->db_tables;
		$sql = "SELECT t1.name AS hotel_currency
		FROM $t->currencies AS t1
		JOIN $t->h_config AS t2 ON t1.id = t2.value
		WHERE t2.name = 'global_currency'";
		return ($this->db->query ( $sql )->row()->hotel_currency);
	}
	function convert_currency_from_amount_to($currency_from="", $amount=0, $currency_to=""){
		$t = &$this->db_tables;
		if($currency_from != "" && $currency_from != "" && $amount != 0){
			$sql = "SELECT t1.rate AS $currency_from, t2.rate AS $currency_to
			FROM $t->currency_rates_today as t1, $t->currency_rates_today as t2
			WHERE t1.name = '$currency_from' AND t2.name = '$currency_to'";
			$rate = $this->db->query($sql)->row();
			$rates_koef = $rate->$currency_to/$rate->$currency_from;
			$converted_amount = doubleval(round($amount * $rates_koef, 2));
			return $converted_amount;
		}
		return 0;
	}
	function get_hotel_details($prop_id, $requested_lang="") {
		$t = &$this->db_tables;
		if (!empty($requested_lang)){
			$resp_language_id = $this->get_ability_hotel_responce_language($requested_lang);
		}
		$sql = "SELECT t1.property_name_lat AS name, t1.street_lat AS street, t1.street_lat AS address1, t1.additional_information_lat AS address2, t1.city_lat AS city, t1.state_lat AS state, t1.post_code AS postal_code,
						t2.id_2ch AS country, t2.native_name AS country_str_name, t1.gps_coordinates,t1.reception_phone AS phone,t1.web_address AS url, t1.email,
						t1.check_in_time AS checkin_time,t1.check_out_time AS checkout_time
				FROM $t->prop_info AS t1
				JOIN $t->countries AS t2 ON t2.id = t1.country
				WHERE t1.id = $prop_id";
 		$hotel_details = $this->db->query($sql)->row();
 		list ($latitude,$longitude ) = explode(',', $hotel_details->gps_coordinates);
 		$hotel_details->latitude = $latitude;
 		$hotel_details->longitude = $longitude;
		$hotel_aneneties = $this->get_prop_anenties($prop_id);
		$hotel_details->hotel_amenities = new stdClass();
		$hotel_details->hotel_amenities->standard = $hotel_aneneties;
		return $hotel_details;
	}
	function get_prop_anenties($prop_id) {
		$t = &$this->db_tables;
		$sql = "SELECT t2.tripadvisor AS ota_amenety_id
				FROM $t->prop2amenety AS t1
				JOIN $t->prop_ameneties AS t2 ON t1.amenity_id = t2.id
				WHERE t1.property_id = $prop_id AND t2.tripadvisor !=''";
		$query_res_arr = $this->db->query($sql)->result_array();
		$anenties = array();
		foreach ($query_res_arr as $res_arr) {
			array_push($anenties, (int)$res_arr['ota_amenety_id']);
		}
		return $anenties;
	}
	function availability_data() {//curl
	    $resp_only_one_category_with_best_price_at_all = 0;
	    $resp_each_category_with_best_price = 1;
	    $room_rate_responce_strategy = $resp_each_category_with_best_price;//or prev concept $resp_only_one_category_with_best_price_at_all
		$requested_data = file_get_contents("php://input");
		$requested_data = json_decode($requested_data);
		$t = &$this->db_tables;
		$resp_language_id = $this->get_ability_hotel_responce_language($requested_data->language);
		$hotel_currency = $this->get_hotel_currency();
		$int_datein = $requested_data->start_intday;
		$int_dateout = $requested_data->end_intday;
		$requested_rooms = count($requested_data->parties);
		$requested_persons = $requested_data->persons;
		$flags = $requested_data->requested_flags;
		$prop_id = $requested_data->prop_id;



		/* $sql = "SELECT  t1.category_id, MIN(t1.count) as rooms_available, COUNT(1) AS duration,
		categories.property_id, IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
		IF(ratetocategory.baseplace, ratetocategory.baseplace, categories.places) AS min_room_places,
		ratetocategory.rate_id, categories.baby_places as max_children,
		rate.ccforce as ccforce, online_rate_data.ccamount_type as ccamount_type, online_rate_data.ccamount as ccamount,
		MAX(IF(deskofrate.intdate != $r_d->int_dateout, deskofrate.closed, 0)) AS isclosed, MAX(deskofrate.minstaythrought) AS maxminstaythrought
		FROM $t->availability AS t1
		JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
		JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
		JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
		JOIN online_rate_data ON online_rate_data.rate_id = rate.id
		JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
		LEFT JOIN deskofrate ON deskofrate.rate_id = onlinerates.restrictid AND deskofrate.category_id = categories.id  AND deskofrate.intdate BETWEEN $r_d->int_datein AND $r_d->int_dateout
		WHERE t1.intdate >= $r_d->int_datein AND t1.intdate < $r_d->int_dateout AND t1.count >= $r_d->rooms AND categories.property_id = $r_d->prop_id
		GROUP BY t1.category_id, rate.id
		HAVING duration >= ($r_d->int_dateout-$r_d->int_datein) AND max_room_places >= $r_d->persons AND min_room_places <= $r_d->persons
		AND (isclosed = 0 OR ISNULL(isclosed)) AND (maxminstaythrought <= ($r_d->int_dateout-$r_d->int_datein) OR ISNULL(maxminstaythrought))"; */




		$sql = "SELECT  t1.category_id, MIN(t1.count) as rooms_remaining, COUNT(1) AS days_count,
                        categories.property_id, IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
                        IF(ratetocategory.baseplace, ratetocategory.baseplace, categories.places) AS min_room_places,
                        ratetocategory.rate_id, categories.baby_places as max_children,
                        rate.ccforce as ccforce, online_rate_data.ccamount_type as ccamount_type, online_rate_data.ccamount as ccamount,
                        MAX(IF(deskofrate.intdate != $int_dateout, deskofrate.closed, 0)) AS isclosed, MAX(deskofrate.minstaythrought) AS maxminstaythrought,
						t_inter_1.value AS category_name, t_inter_2.value AS rate_name,
						$resp_language_id AS resp_language_id, '$hotel_currency' AS hotel_currency
				FROM $t->availability AS t1
				JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
				JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
				JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
                JOIN online_rate_data ON online_rate_data.rate_id = rate.id
				JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
				LEFT JOIN deskofrate ON deskofrate.rate_id = onlinerates.restrictid AND deskofrate.category_id = categories.id  AND deskofrate.intdate BETWEEN $int_datein AND $int_dateout
				LEFT JOIN $t->inter AS t_inter_1 ON t_inter_1.table_id = categories.id AND t_inter_1.language_id = $resp_language_id
							AND t_inter_1.table_type = 'category' AND t_inter_1.name = 'international_name'
				LEFT JOIN $t->inter AS t_inter_2 ON t_inter_2.table_id = onlinerates.rateid AND t_inter_2.language_id = $resp_language_id
							AND t_inter_2.table_type = 'rate' AND t_inter_2.name = 'international_name'
				WHERE 	t1.intdate BETWEEN $int_datein AND $int_dateout	AND t1.count >= $requested_rooms AND categories.property_id = $prop_id
				GROUP BY t1.category_id, rate.id
				HAVING 	days_count >= ($int_dateout-$int_datein) AND max_room_places >= $requested_persons AND min_room_places <= $requested_persons
				AND (isclosed = 0 OR ISNULL(isclosed)) AND (maxminstaythrought <= ($int_dateout-$int_datein) OR ISNULL(maxminstaythrought))";

        $base_result = $this->db->query($sql)->result();
		if (empty ( $base_result )) {
			return NULL;
		}
		if (!$flags->multiple_room_rates && ($room_rate_responce_strategy == $resp_only_one_category_with_best_price_at_all)){
	        $base_result = array($base_result[0]);
		}
		$result = new stdClass();
		$min_prices_by_cats = array();
		foreach ($base_result as $data_set) {
			$room_type_id = $data_set->category_id;
			if (!isset($result->room_types->$room_type_id)){
				$result->room_types->$room_type_id = (object)array (
						'persistent_room_type_code' => $room_type_id,
						'name' => $data_set->category_name
				);
				if ($flags->room_type_details){
					$result->room_types->$room_type_id->max_occupancy->number_of_adults = $data_set->max_room_places;
					$result->room_types->$room_type_id->max_occupancy->number_of_children = 0;
					$room_type_conditions_data = new stdClass();
					$room_type_conditions_data->hms_id = $requested_data->hms_id;
					$room_type_conditions_data->room_type_id = $room_type_id;
					$room_type_conditions_data->photos = $flags->photos;
					$room_type_conditions_data->text = $flags->text;
					$room_type_conditions_data->resp_language_id = $data_set->resp_language_id;
					$room_type_details = $this->get_room_type_details($room_type_conditions_data);
					unset($room_type_conditions_data);
					foreach ($room_type_details as $p_name => $p_val) {
						$result->room_types->$room_type_id->$p_name = $p_val;
					}
				}
				$min_prices_by_cats[$room_type_id] = array();
			}
			$rate_plan_id = $data_set->rate_id;
			if (!isset($result->rate_plans->$rate_plan_id)){
				$result->rate_plans->$rate_plan_id = (object) array (
						'persistent_rate_plan_code' => $rate_plan_id,
						'name' => $data_set->rate_name
				);
				if ($flags->rate_plan_details){
					$rate_plan_conditions_data = new stdClass();
					$rate_plan_conditions_data->rate_plan_id = $rate_plan_id;
					$rate_plan_conditions_data->photos = $flags->photos;
					$rate_plan_conditions_data->text = $flags->text;
					$rate_plan_conditions_data->resp_language_id = $data_set->resp_language_id;
					$rate_plan_conditions_data->start_date = $requested_data->start_date;
					$rate_plan_conditions_data->prop_id = $prop_id;
					$rate_plan_details = $this->get_rate_plan_details($rate_plan_conditions_data);
					unset($rate_plan_conditions_data);
					foreach ($rate_plan_details as $p_name => $p_val) {
						$result->rate_plans->$rate_plan_id->$p_name = $p_val;
					}
				}
			}
			$room_rate_id = $room_type_id."_".$rate_plan_id;
			$data_for_line_items = array();
			$data_for_line_items['parties'] = $requested_data->parties;
			$data_for_line_items['type_id'] = $room_type_id;
			$data_for_line_items['price_type'] = $rate_plan_id;
			$data_for_line_items['prop_id'] = $prop_id;
			$data_for_line_items['datein'] = $requested_data->start_date;
			$data_for_line_items['dateout'] = $requested_data->end_date;
			$data_for_line_items['hotel_currency'] = $data_set->hotel_currency;
			$data_for_line_items['requested_currency'] = $requested_data->currency;
			$line_items = $this->get_price_line_items($data_for_line_items);
			$total_room_rate_amount = 0;
			foreach ($line_items as $line_item) {
			    $total_room_rate_amount += $line_item['price']['currency_of_charge_price']['amount'];
			}
			$need_to_put_item_in_result = 1;
			if (!$flags->multiple_room_rates && ($room_rate_responce_strategy == $resp_each_category_with_best_price)){
			    if (isset($min_prices_by_cats[$room_type_id]['min_price'])){
			        if ($total_room_rate_amount < $min_prices_by_cats[$room_type_id]['min_price']){
			            $old_room_rate_id_min_price = $min_prices_by_cats[$room_type_id]['room_rate_id'];
			            unset($result->room_rates->$old_room_rate_id_min_price);
			            $min_prices_by_cats[$room_type_id]['min_price'] = $total_room_rate_amount;
			            $min_prices_by_cats[$room_type_id]['room_rate_id'] = $room_rate_id;
			        }else{
			            $need_to_put_item_in_result = 0;
			        }
			    }else{
		            $min_prices_by_cats[$room_type_id]['min_price'] = $total_room_rate_amount;
		            $min_prices_by_cats[$room_type_id]['room_rate_id'] = $room_rate_id;
			    }
			}
			if ($need_to_put_item_in_result){
    			$result->room_rates->$room_rate_id = (object) array (
    					'persistent_room_rate_code' => $room_rate_id,
    					'room_type_key' => $data_set->category_id,
    					'rate_plan_key' => $data_set->rate_id,
    					'line_items' => $line_items,
    					'rooms_remaining' => ($flags->room_rate_details) ? $data_set->rooms_remaining : NULL,
    					'url' => "https://book-".$requested_data->host."/reservations/ta_booking/?".
                			    http_build_query(array(
                			        'checkin' => str_replace('-', '', $requested_data->start_date),
                			        'checkout' => str_replace('-', '', $requested_data->end_date),
                			        'room' => $data_set->category_id,
                			        'rate' => $data_set->rate_id,
                			        'parties' => $requested_data->parties,
                			        'amount' => $total_room_rate_amount,
                			        'lang' => $resp_language_id
                			    )),
    					'partner_data' => ( object ) array (
    							'rate_id' => $rate_plan_id,
    							'category_id' => $room_type_id,
    							'prop_id' => $prop_id,
    							'requested_currency' => $requested_data->currency,
    							'responsed_lang' => $resp_language_id
    					)
    			);
    			if ($flags->room_rate_details){
    				$result->room_rates->$room_rate_id->rooms_remaining = $data_set->rooms_remaining;
    				if ($flags->text){
    					$result->room_rates->$room_rate_id->payment_policy = "Hotel payment policy some text";
    					$result->room_rates->$room_rate_id->payment_policy = "Hotel miscellaneous policies some text";
    				}
    			}
    			if ($flags->hotel_details){
    				$result->hotel_details = $this->get_hotel_details ( $prop_id, $requested_data->language);
    			}
    			if ($flags->partner_booking_data){
    				$result->partner_booking_details = (object)array();
    				if ($flags->text){
    					$result->partner_booking_details->terms_and_conditions = "General terms and conditions text.";
    					$result->partner_booking_details->terms_and_conditions_url = "https://book-".$requested_data->host;
    					$result->partner_booking_details->payment_policy = "Describes how the partner will use the credit card information, e.g. charged immediately or hold";
    				}
    			}
			}
		}
		echo json_encode($result);
	}
	function get_room_type_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = array();
			$sql = "SELECT t1.id_position AS position
					FROM $t->room_photos AS t1
					WHERE t1.category_id = $requested_data->room_type_id";
			$photos = $this->db->query($sql)->result_array();
			foreach ($photos as $photo_data) {
				array_push($result->photos, array('url'=>'https://fr-online-booking.otelms.com/himages/'.$requested_data->hms_id.'_'.$requested_data->room_type_id.'_'.$photo_data['position'].'_500.jpg'));
			}
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
					FROM $t->room_params AS t1
					LEFT JOIN $t->inter AS inter ON inter.table_id = t1.catID AND inter.language_id = $requested_data->resp_language_id
					AND inter.table_type = 'category' AND inter.name = 'international_comment'
					WHERE t1.catID = $requested_data->room_type_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get category amenities
		$sql = "SELECT t2.tripadvisor AS amenity_code
				FROM $t->category2amenities AS t1
				JOIN $t->category_ameneties AS t2 ON t1.amenity_id = t2.id
				WHERE t1.category_id = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$amenities_query_result = $this->db->query($sql)->result();
		$amenities = array();
		foreach ($amenities_query_result as $amenity) {
			array_push($amenities, $amenity->amenity_code);
		}
		// FREE WiFi 900126
		array_push($amenities, '900126');
		$result->room_amenities->standard = $amenities;
		$result->room_amenities->custom = array();
		//======================================  get category room size
		$sql = "SELECT  size as value, size_type as unit
        		FROM categories AS t1
        		WHERE t1.id = $requested_data->room_type_id";
		$row = $this->db->query($sql)->row();
		if (!empty($row->value)){
            switch ($row->unit) {
                case 1:
                    $unit = 'square_feet';
                    break;
                case 2:
                    $unit = 'square_feet';;
                    break;
                default:
                    $unit = 'square_feet';;
                    break;
            }
            $result->room_size->value = (int)$row->value;
		    $result->room_size->unit = $unit;
		}
		//======================================  get category bed_configurations and extra_bed_configurations
		$result->bed_configurations = array();
		$sql = "SELECT SUM(t1.value) as count, t2.ta as code
        		FROM beds2rooms AS t1
        		JOIN global_hotelix_common.bed_types as t2 ON t2.id = t1.bedID
        		WHERE t1.catID = $requested_data->room_type_id
		        GROUP BY t1.bedID";
		$query_res = $this->db->query($sql)->result();
		if (!empty($query_res)){
		    foreach ($query_res as $bed_configuration) {
		        if (is_null($bed_configuration->code)){//unspecified_bed 900303
		            $bed_configuration->code = 900303;
		        }
		        array_push($result->bed_configurations, array('standard' => array($bed_configuration)));
		    }
		}
		$result->extra_bed_configurations[0] = array('standard' => array(array('count'=>1, 'code'=>900303)));
		//======================================  get category room_view_types
		$sql = "SELECT DISTINCT t2.tripadvisor AS view_code
				FROM $t->room_params AS t1
				JOIN $t->room_views AS t2 ON t1.view = t2.id
				WHERE t1.catID = $requested_data->room_type_id AND t2.tripadvisor != ''";
		$views_query_result = $this->db->query($sql)->result();
		$views = array();
		foreach ($views_query_result as $view) {
			array_push($views, $view->view_code);
		}
		$result->room_view_types->standard = $views;
		$result->room_view_types->custom = array();
		//======================================  get category accessibility_features
		$result->accessibility_features = NULL;
		//======================================  get category room_smoking_policy, smoking, non_smoking
		$result->room_smoking_policy = in_array('74', $amenities)?'smoking':'non_smoking';//74 is OTA amenity smoking code

		return $result;
	}

	function get_rate_plan_details($requested_data) {
		$result = new stdClass();
		$t = &$this->db_tables;
		if ($requested_data->photos){
			$result->photos = NULL;
		}
		if ($requested_data->text){
			$sql = "SELECT  inter.value AS description
			FROM rate AS t1
			LEFT JOIN $t->inter AS inter ON inter.table_id = t1.id AND inter.language_id = $requested_data->resp_language_id
			AND inter.table_type = 'rate' AND inter.name = 'international_description'
			WHERE t1.id = $requested_data->rate_plan_id";
			$row = $this->db->query($sql)->row();
			if (isset($row->description)){
				$result->description = $row->description;
			}
		}
		//======================================  get rate amenities
		$result->rate_amenities->standard = array();
		$result->rate_amenities->custom = array();
		//======================================  get rate cancellation_policy
		$result->cancellation_policy  = NULL;
		$hotel_timezone = $this->db->get_where('hotelix_config', array('name'=>'timezone'))->row()->str_value;
		if (!empty($hotel_timezone)){
		    date_default_timezone_set("$hotel_timezone");
		}
		$check_in_time = $this->db->select('check_in_time')->get_where($t->prop_info, array('id'=>$requested_data->prop_id))->row()->check_in_time;
		$common_start_date = date('c', strtotime("now"));
		$common_end_date = date('c', strtotime("$requested_data->start_date $check_in_time"));
		$sql = "SELECT  t2.name AS cancelation_name_code, t3.id AS cancelation_type_id, t4.id AS meal_plan,
						t2.penalty_ar,t2.deadline_days, t2.deadline_hours, t2.penalty_ad, t2.penalty_ad_nights, t2.description
				FROM rate AS t1
				JOIN $t->cancelations AS t2 ON t2.id = t1.cancellation_policy_id
				JOIN $t->cancelation_types AS t3 ON t3.id = t2.type_id
				JOIN $t->meal_policies as t4 ON t1.meal_policy_id = t4.id
				WHERE t1.id = $requested_data->rate_plan_id";
		$row_rate_rezult = $this->db->query($sql)->row();
		$hms_cancel_policy = $row_rate_rezult->cancelation_type_id;
        switch ($hms_cancel_policy) {
            case 1:
                $ta_cancel_type = 'none';//Non-Refundable
                $result->cancellation_policy->cancellation_rules = array();
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $common_start_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
            case 2:
                $ta_cancel_type = 'full';//Free Cancellations
                $deadline_date = date('c', strtotime("$common_end_date - $row_rate_rezult->deadline_hours hours"));
                $result->cancellation_policy->cancellation_summary->cancellation_deadline = $deadline_date;
                $result->cancellation_policy->cancellation_rules = array();
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $deadline_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
            case 3:
                $ta_cancel_type = 'partial';//Non-Free Cancellations
                $result->cancellation_policy->cancellation_rules = array();
                $deadline_date = date('c', strtotime("$common_end_date - $row_rate_rezult->deadline_hours hours"));
                if ($deadline_date > $common_start_date){
                    $cancellation_rule = new stdClass();
                    $cancellation_rule->start_datetime = $common_start_date;
                    $cancellation_rule->end_datetime = $deadline_date;
                    $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ar)? (double)($row_rate_rezult->penalty_ar / 100) : NUll;
                    $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                    array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                }
                $cancellation_rule = new stdClass();
                $cancellation_rule->start_datetime = $deadline_date;
                $cancellation_rule->end_datetime = $common_end_date;
                $cancellation_rule->percent_fee->amount = !empty($row_rate_rezult->penalty_ad)? (double)($row_rate_rezult->penalty_ad / 100) : NUll;
                $cancellation_rule->night_fee->num_nights = !empty($row_rate_rezult->penalty_ad_nights)? $row_rate_rezult->penalty_ad_nights : NUll;
                array_push($result->cancellation_policy->cancellation_rules, $cancellation_rule);
                break;
        }
		$result->cancellation_policy->cancellation_summary->refundable = $ta_cancel_type;
		if ($requested_data->text){
		    $result->cancellation_policy->cancellation_summary->unstructured_cancellation_text = $row_rate_rezult->description;
		}
		//======================================  get rate meal_plan
		$result->meal_plan->standard = array($row_rate_rezult->meal_plan);
		$result->meal_plan->custom = array();
		return $result;
	}
	function party_to_hms_guests($party, $cat_id=0) {
		$t = &$this->db_tables;
		$babies_count = 0;
		$over_children_count = 0;
		$ta_children = (isset($party->children)) ? $party->children : array();
		if (!empty($ta_children) && $cat_id){
			$sql = "SELECT t1.baby_places, t3.to AS max_baby_age, t4.to AS max_child_age
					FROM categories AS t1
					JOIN $t->prop_info AS t2 ON t1.property_id = t2.id
					LEFT JOIN $t->age_ranges AS t3 ON t2.range_id = t3.range_id AND t3.id = 1
                    LEFT JOIN $t->age_ranges AS t4 ON t2.range_id = t4.range_id AND t4.id = 2
					WHERE t1.id = $cat_id";
			$row_rezult = $this->db->query($sql)->row();
			if (!empty($row_rezult)){
				$max_babies_and_children_places = $row_rezult->baby_places;
				$max_baby_age = isset($row_rezult->max_baby_age) ? (int)$row_rezult->max_baby_age : 0;
				$max_child_age = isset($row_rezult->max_child_age) ? (int)$row_rezult->max_child_age : 0;
				foreach ($ta_children as $ta_child_age) {
				    if($ta_child_age <= $max_baby_age){
						$babies_count ++;
				    }elseif (($ta_child_age <= $max_child_age) && $max_babies_and_children_places > 0){
						$max_babies_and_children_places--;
					}else{
						$over_children_count++;
					}
				}
			}
		}
		$guests = array();
		$guests['adults'] = $party->adults + $over_children_count;
		$guests['baby_places'] = count($ta_children) - $over_children_count - $babies_count;
		$guests['babyplace2'] = $babies_count;
		return $guests;
	}

	function party_to_hms_guests_ages($party) {
	    //$t = &$this->db_tables;
	    $ages = array();
	    $adults_min_age = 35;
	    $adults = $party->adults;
	    while ($adults > 0) {
	        array_push($ages, $adults_min_age);
	        $adults--;
	    }
	    if (isset($party->children)){
	        foreach ($party->children as $child_age) {
	            array_push($ages, $child_age);
	        }
	    }
	    return $ages;
	}

	function get_price_line_items($data) {
		//два варіанта стратегії ціни: 1) повернення для ціни для максимальної партії; 2) повернення суми цін всіх партій
		//1)
		$price_strategy = 2;//2
		if ($price_strategy == 1){
			// get max party id is parties array
			$max_party_id = 0;//first party
			$max_guests_count = 1;
			foreach ($data['parties'] as $party_id => $party) {
				$children_count = (isset($party->children)) ? count($party->children) : 0;
				$room_guests_count = $party->adults + $children_count;
				if ($room_guests_count > $max_guests_count) {
					$max_guests_count = $room_guests_count;
					$max_party_id = $party_id;
				}
			}
			$data = array_merge($data, $this->party_to_hms_guests($data['parties'][$max_party_id], $data['type_id']));
			$hms_amount = $converted_amount = $this->frontdesk->get_otelms_amount ( $data );
			if ($data['hotel_currency'] != $data['requested_currency']){
				$converted_amount = $this->convert_currency_from_amount_to ( $data['hotel_currency'], $hms_amount, $data['requested_currency'] );
			}
			$result = array (
					array (
							'price' => array (
									'requested_currency_price' => array (
											'amount'=>$converted_amount,
											'currency'=>$data['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount'=>$hms_amount,
											'currency'=>$data['hotel_currency']
									)
							),
							'type' => 'rate',
							'paid_at_checkout' => true
					)
			);
		}
		if ($price_strategy == 2){
			$summary_amount = 0;
			$taxes_fees_all_parties_arr = array();
			foreach ($data['parties'] as $party) {
				$hms_guests = $this->party_to_hms_guests($party, $data['type_id']);
				$hms_guests_ages = $this->party_to_hms_guests_ages($party);
// 				$hms_guests_count = $hms_guests['adults']+$hms_guests['baby_places']+$hms_guests['babyplace2'];

				$data_for_party = array_merge($data, $hms_guests);
				$hms_amount_for_single_rarty = $this->frontdesk->get_otelms_amount ( $data_for_party );
				$summary_amount += $hms_amount_for_single_rarty;
				$data_for_tf = array (
						'prop_id' => $data ['prop_id'],
				        'guests' => $hms_guests,//$hms_guests_count,
                        'guest_ages' => $hms_guests_ages,
						'amount' => $hms_amount_for_single_rarty,
						'duration' => round((strtotime( $data['dateout'])-strtotime( $data['datein']))/ (3600 * 24))
				);
				$taxes_fees_party_arr = $this->get_taxes_fees_arr($data_for_tf);
				foreach ($taxes_fees_party_arr as $name_code => $tax_or_fee) {
					if (isset($taxes_fees_all_parties_arr[$name_code])){
						$taxes_fees_all_parties_arr[$name_code]['amount'] += $tax_or_fee['amount'];
					}else{
						$taxes_fees_all_parties_arr[$name_code]['amount'] = $tax_or_fee['amount'];
						$taxes_fees_all_parties_arr[$name_code]['type'] = $tax_or_fee['type'];
					}
				}
			}
			$summary_amount = (double)round($summary_amount, 2);
			$converted_amount = $summary_amount;
			$need_convertation = false;
			if ($data['hotel_currency'] != $data['requested_currency']){
				$converted_amount = $this->convert_currency_from_amount_to ( $data['hotel_currency'], $summary_amount, $data['requested_currency'] );
				$need_convertation = true;
			}
			$result = array (
					array (
							'price' => array (
									'requested_currency_price' => array (
											'amount' => $converted_amount,
											'currency' => $data ['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount' => $summary_amount,
											'currency' => $data ['hotel_currency']
									)
							),
							'type' => 'rate',
							'paid_at_checkout' => true
					)
			);
			if (!empty($taxes_fees_all_parties_arr)){
				foreach ($taxes_fees_all_parties_arr as $name_code => $tax_or_fee){
					array_push ( $result, array (
							'price' => array (
									'requested_currency_price' => array (
                                            'amount' => ($need_convertation)? $this->convert_currency_from_amount_to ( $data['hotel_currency'], $tax_or_fee['amount'], $data['requested_currency'] ) : (double)$tax_or_fee['amount'],
											'currency' => $data ['requested_currency']
									),
									'currency_of_charge_price' => array (
											'amount' => (double)$tax_or_fee['amount'],
											'currency' => $data ['hotel_currency']
									)
							),
							'type' => $tax_or_fee['type'],
							'sub_type'=> $name_code,
							'paid_at_checkout' => true
					) );
				}
			}
		}
		return $result;
	}

	function sync_booking() {//curl
		$requested_data = file_get_contents("php://input");
		$requested_data = json_decode($requested_data);
		$t = &$this->db_tables;
		$complex_reservation = explode("_", $requested_data->reservation_id);
		$where_res_in_arr = "";
		foreach ($complex_reservation as $hms_reservation_id) {
			$where_res_in_arr .= $hms_reservation_id.', ';
		}
		$where_res_in_arr = substr($where_res_in_arr, 0, -2);
		$where_res_in_arr = " IN ($where_res_in_arr) ";
		$sql = "SELECT t1.datein AS checkin_date, t1.dateout AS checkout_date, SUM(t1.amount) AS total_booking_rate,
						DATE_FORMAT(t2.time, '%Y-%m-%d') AS cancelled_date
				FROM $t->reservations AS t1
				LEFT JOIN $t->servises AS t2 ON t1.id = t2.reservation_id AND t2.type = 2
				WHERE t1.id $where_res_in_arr
				GROUP BY t1.id";
		$query_result = $this->db->query($sql)->row();
		$requested_data->status = "Booked";
		if (!is_null($query_result->cancelled_date)){//booking is canceled
			$requested_data->status = "Cancelled";
			$requested_data->cancellation_number = "TA_CA_".$requested_data->reservation_id;
		}
		$hotel_currency = $this->get_hotel_currency();
		$requested_data->total_rate = array (
				'amount' => (int)$query_result->total_booking_rate,
				'currency' => $hotel_currency
		);
		$sql_tf = "SELECT LEFT(t3.name_code, 3) AS type, SUM(t1.value) AS amount
                    FROM services_tf AS t1
                    JOIN taxes_fees AS t2 ON t2.id = t1.taxes_fees_id
					JOIN ta_tax_fee_subtypes AS t3 ON t3.id = t2.ta_subtype_id
                    WHERE t1.reservation_id $where_res_in_arr
                    GROUP BY type";
		$query_result_tf = $this->db->query($sql_tf)->result();
		$total_taxes_amount = 0;
		$total_fees_amount = 0;
		if (!empty($query_result_tf)){
		    foreach ($query_result_tf as $t_or_f) {
                switch ($t_or_f->type) {
                    case 'tax':
                        $total_taxes_amount = (int)$t_or_f->amount;
                        break;
                    case 'fee':
                        $total_fees_amount = (int)$t_or_f->amount;
                        break;
                }
		    }
		}
		$requested_data->total_taxes = array (
		    'amount' => $total_taxes_amount,
		    'currency' => $hotel_currency
		);
		$requested_data->total_fees = array (
		    'amount' => $total_fees_amount,
		    'currency' => $hotel_currency
		);
 		$requested_data = (object) array_merge((array) $requested_data, (array) $query_result);
		echo json_encode($requested_data);
	}

	function get_taxes_fees_arr($data) {
		$guests = $data['guests'];
		$guests_ages = $data['guest_ages'];
        $request_data_arr = array(
            'property_id' => $data['prop_id'],
            'amount' => $data['amount'],
            'duration' => $data['duration'],
            'guests' => $guests,
            'guest_ages' => $guests_ages
        );
		$res_arr = array();
		if ($this->config->item('trip_taxes_fees_new')){// process new logig with Taxes&Fees by property
		    $tfs = $this->taxesfees_model->get_services_tf_data_by_property($request_data_arr);
		    foreach ($tfs as $tf_data) {
		        if (!isset($res_arr[$tf_data['name_code']])){
		            $res_arr[$tf_data['name_code']]['type'] = $tf_data['type'];
		            $res_arr[$tf_data['name_code']]['amount'] = $tf_data['amount'];
		        }else{
		            $res_arr[$tf_data['name_code']]['amount'] += $tf_data['amount'];
		        }
		    }
// 			$sql = "SELECT t3.name_code, LEFT(t3.name_code, 3) as type,
// 							SUM(IF(t1.object_type=2, $guests, 1)*IF(t1.period_type=1, $duration, 1)*IF(t1.calc_type=2, TRUNCATE($amount*t1.calc_value/100, 2), t1.calc_value)) as amount
// 					FROM taxes_fees2property AS t1
// 					JOIN taxes_fees AS t2 ON t2.id = t1.taxes_fees_id
// 					JOIN ta_tax_fee_subtypes AS t3 ON t3.id = t2.ta_subtype_id
// 					WHERE t1.property_id = $prop_id
// 					GROUP BY t3.id";
// 			$temp_res_arr = $this->db->query($sql)->result_array();
// 			foreach ($temp_res_arr as $tax_or_fee) {
// 				$res_arr[$tax_or_fee['name_code']] = $tax_or_fee;
// 			}
//(IF(t1.object_type=1, IF(t1.calc_type=2, TRUNCATE($amount*t4.value/100, 2), t4.value), 1)*IF(t1.period_type=1, $duration, 1)) as amount
		}else{
			$partner_texes_fees = $this->db->select('tour_fee_value, nds, nds_value')->get_where('partners', array('isdefault'=>1))->row();
			if (isset($partner_texes_fees->tour_fee_value) && $partner_texes_fees->tour_fee_value != 0){
				$res_arr['taxes']['tax_city'] = $partner_texes_fees->tour_fee_value;
			}
			if (isset($partner_texes_fees->nds) && isset($partner_texes_fees->nds_value) && $partner_texes_fees->nds_value != 0 && $partner_texes_fees->nds != 0){
				$res_arr['taxes']['tax_vat'] = $partner_texes_fees->nds_value;
			}
		}
		return $res_arr;
	}

	function modul_booking_request() {//curl
	    $t = &$this->db_tables;
	    $request_data = file_get_contents("php://input");
	    $request_data = json_decode($request_data, true);
	    $date_in = $request_data['booking_data']['date_in'];
	    $date_out = $request_data['booking_data']['date_out'];
	    $category_id = $request_data['booking_data']['selected_category'];
	    $rate_id = $request_data['booking_data']['selected_rate'];
	    $request_data['customer']['lastname'] = empty($request_data['customer']['lastname']) ? '---' : $request_data['customer']['lastname'];
	    $request_data['customer']['firstname'] = empty($request_data['customer']['firstname']) ? '---' : $request_data['customer']['firstname'];
	    $customer_id = $this->frontdesk->Guest_insert ( $request_data['customer'] );

	    $insert_reservation_data = array (
	        'dc_id' => $request_data['booking_data']['dc_id'],
	        'dc_uuid' => '',
	        'dc_source' => 'TripAdvisor',
	        'dc_currencycode' => '',
	        'dc_customerremarks' => '',
	        'dc_totalprice' => '',
	        'is_guest' => 0,
	        'datein' => $date_in,
	        'dateout' => $date_out,
	        'price_type' => $rate_id
	    );
	    $complex_hms_reservation_ids_for_ta = "";
	    $ta_res_id_for_url = "";
	    $group_id = 'NoGroup';
	    foreach ($request_data['booking_data']['parties'] as $master_key => $party_set) {
	        $room_number = $master_key+1;
	        $request_data['guests'][$room_number]['hms_ids'] = array();
            foreach ($request_data['guests'][$room_number]['adults'] as $adult_numder => &$adult) {
                //$adult['dob'] = date('Y-m-d', strtotime("$date_in - 35 year"));
                $adult['lastname'] = empty($adult['lastname']) ? '---' : $adult['lastname'];
                $adult['firstname'] = empty($adult['firstname']) ? '---' : $adult['firstname'];
                array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($adult));
            }
            if (isset($request_data['guests'][$room_number]['children'])){
                foreach ($request_data['guests'][$room_number]['children'] as $age => &$child) {
                    //$child['dob'] = date('Y-m-d', strtotime("$date_in - $age year"));
                    $child['lastname'] = empty($child['lastname']) ? '---' : $child['lastname'];
                    $child['firstname'] = empty($child['firstname']) ? '---' : $child['firstname'];
                    array_push( $request_data['guests'][$room_number]['hms_ids'], $this->frontdesk->Guest_insert($child));
                }
            }
	        $insert_reservation_data['room_id'] = $this->frontdesk->getfreeroomlist($date_in, $date_out, $category_id);
	        $acb_set = $this->party_to_hms_guests((object)$party_set, $category_id);
	        $insert_reservation_data = array_merge($insert_reservation_data, $acb_set);
	        $hms_reservation_id = $this->frontdesk->Reservation_insert ( $insert_reservation_data, $customer_id, 0, 1 );
	        $complex_hms_reservation_ids_for_ta .= $hms_reservation_id."_";
            $this->db->insert($t->ta_reservations, array('hms_res_id'=>$hms_reservation_id));
	        $ta_res_id_for_url = $this->db->insert_id();
	        foreach ($request_data['guests'][$room_number]['hms_ids'] as $guest_id) {
	            $this->frontdesk->guests_reservation_insert($guest_id, $hms_reservation_id);
	        }
	         $this->frontdesk->save_taxesfees($hms_reservation_id);
	         $this->frontdesk->SetReservationBalance ( $hms_reservation_id );
	    }
	    $complex_hms_reservation_ids_for_ta = substr($complex_hms_reservation_ids_for_ta, 0, -1);
	    $if_complex_reservation = explode("_", $complex_hms_reservation_ids_for_ta);
	    if (count($if_complex_reservation)>1){
            $this->db->insert($t->groups, array('name'=>'TA_GR_'.$complex_hms_reservation_ids_for_ta));
	        $group_id = $this->db->insert_id();
	        foreach ($if_complex_reservation as $reservation_id) {
	           $this->db->update($t->reservations, array('intgroupid'=>$group_id), array('id'=>$reservation_id));
	        }
	        $this->db->insert($t->ta_reservations, array('hms_group_id'=>$group_id));
	        $ta_res_id_for_url = $this->db->insert_id();
	    }
        echo json_encode(array(
            'rezult' => 'ok',
            'bid' => $ta_res_id_for_url,
            'resevation_ids' => $complex_hms_reservation_ids_for_ta,
            'ta_resevation_id' => $ta_res_id_for_url,
            'group_id' => $group_id,
            'guests' => $request_data['guests'],
        ));
	}

	function modul_booking_page() {//curl
	    $t = &$this->db_tables;
	    $request = file_get_contents("php://input");
	    $request = json_decode($request, true);
	    $response_data = array('request' => $request);
	    $response = array();
	    $date_range_exploded = explode(" - ", $request['date_range']);
	    $date_in = $response['date_in'] = $date_range_exploded[0];
	    $date_out = $response['date_out'] = $date_range_exploded[1];
	    $int_datein = round (strtotime($date_in)/86400);
	    $int_dateout = round (strtotime($date_out)/86400);
	    $requested_rooms_count = $response['requested_rooms_count'] = count($request['parties']);
	    $hms_guests_set = array();
	    $max_requested_persons = 1;
	    foreach ($request['parties'] as $party) {
	        $hms_guests = $this->party_to_hms_guests($party);
	        array_push($hms_guests_set, $hms_guests);
	        $children_count = (isset($party['children'])) ? count($party['children']) : 0;
	        $party_guests_count = $party['adults'] + $children_count;
	        if ($party_guests_count > $max_requested_persons){ $max_requested_persons = $party_guests_count;}
	    }
	    $response['max_requested_persons'] = $max_requested_persons;
        $sql = "SELECT  t1.category_id, t1.count as rooms_remaining, COUNT(1) AS duration, categories.property_id,
                        IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places, ratetocategory.rate_id
                FROM deskofdays_availability AS t1
                JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
                JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
                JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
                JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
                WHERE t1.intdate BETWEEN $int_datein AND $int_dateout AND t1.count >= $requested_rooms_count
                GROUP BY t1.category_id, rate.id
                HAVING 	duration >= ($int_dateout-$int_datein) AND max_room_places >= $max_requested_persons";
//         $sql = "SELECT  t1.category_id, t1.count as rooms_remaining,
//         COUNT(1) AS duration, SUM(IFNULL(yieldprice.price, seasonspricelist.price)) AS total_price,
//         IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
//         ratetocategory.rate_id
//         FROM deskofdays_availability AS t1
//         JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
//         JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
//         JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
//         JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
//         LEFT JOIN yieldprice ON yieldprice.id_restrict_rate	= rate.id AND yieldprice.category_id = categories.id AND yieldprice.intdate = t1.intdate
//         JOIN deskofdaysseason ON deskofdaysseason.intdate = t1.intdate
//         JOIN seasons ON seasons.id = deskofdaysseason.seasonid AND seasons.is_active = 1
//         JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id AND seasonspricelist.category_id = categories.id AND seasonspricelist.season_id = seasons.id
//         WHERE 	t1.intdate BETWEEN $int_datein AND $int_dateout	AND t1.count >= $requested_rooms_count
//         GROUP BY t1.category_id, rate.id
//         HAVING 	duration >= ($int_dateout-$int_datein+1) AND max_room_places >= $max_requested_persons";


        $query_res = $this->db->query($sql)->result_array();
        $free_rooms = $suitable_categories = $suitable_rates = array();

        $TEMP_hms_guests = array();

        foreach ($query_res as $set) {
            if (!isset($response['duration'])){
                $response['duration'] = $set['duration'];
            }
            $hms_parties_total_amount = 0;
            $data_for_hms_party_amount = array();
            $data_for_hms_party_tf_amount = array();
            $data_for_hms_party_amount['prop_id'] = $data_for_hms_party_tf_amount['property_id'] = $set['property_id'];
            $data_for_hms_party_amount['type_id'] = $set['category_id'];
            $data_for_hms_party_amount['price_type'] = $set['rate_id'];
            $data_for_hms_party_amount['datein'] = $date_in;
            $data_for_hms_party_amount['dateout'] = $date_out;
            $hms_all_parties_amount = 0;
            $data_for_hms_party_tf_amount['duration'] = $response['duration'];
            $hms_all_parties_tf_amount = 0;
            foreach ($request['parties'] as $party) {
                $hms_guests = $data_for_hms_party_tf_amount['guests'] = $this->party_to_hms_guests((object)$party, $set['category_id']);
                $data_for_hms_party_amount = array_merge($data_for_hms_party_amount, $hms_guests);
                $hms_party_amount = $this->frontdesk->get_otelms_amount ( $data_for_hms_party_amount );
                $hms_all_parties_amount += $hms_party_amount;
                $data_for_hms_party_tf_amount['amount'] = $hms_party_amount;
                $data_for_hms_party_tf_amount['guest_ages'] = $this->party_to_hms_guests_ages((object)$party);
                $tfs = $this->taxesfees_model->get_services_tf_data_by_property($data_for_hms_party_tf_amount);
                $hms_party_tf_amount = 0;
                foreach ($tfs as $tf_data) {
                    $hms_party_tf_amount += $tf_data['amount'];
                }
                $hms_all_parties_tf_amount += $hms_party_tf_amount;
                array_push($TEMP_hms_guests, array('data'=>$data_for_hms_party_amount, 'guest_ages' => $data_for_hms_party_tf_amount['guest_ages'], 'amount'=>$hms_party_amount, 'tf_amount'=>$hms_party_tf_amount));
            }
            $hms_parties_total_amount = $hms_all_parties_amount + $hms_all_parties_tf_amount;

            array_push($TEMP_hms_guests, array('total'=>$hms_parties_total_amount, 'price'=>$hms_all_parties_amount, 'tf'=>$hms_all_parties_tf_amount));


            if (!isset($free_rooms[$set['category_id']])){
                if (!in_array($set['category_id'], $suitable_categories)){
                    array_push($suitable_categories, $set['category_id']);
                }
                $free_rooms[$set['category_id']] = array(
                    'category_id' => $set['category_id'],
                    'rooms_remaining' => $set['rooms_remaining'],
                    'max_room_places' => $set['max_room_places'],
                );
            }
            $free_rooms[$set['category_id']]['rates'][$set['rate_id']] = array('rate_id' => $set['rate_id'], 'price' => $hms_parties_total_amount);
            if (!in_array($set['rate_id'], $suitable_rates)){
                array_push($suitable_rates, $set['rate_id']);
            }
        }
        $response['suitable_categories'] = $suitable_categories;
        $response['suitable_rates'] = $suitable_rates;
        $response['hms_free_rooms'] = $free_rooms;

        $response['TEMP_hms_guests'] =  $TEMP_hms_guests;

        $response_data['response'] = $response;
	    echo json_encode($response_data);
	}
}