<?php

class Dc_expedia_promo extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        /*
         * $this->username = 'EQCOtelmsTEST';
         * $this->password = 'lzEh!EA9H!4uZ@Vl';
         * $this->property_id = '15239907';
         *
         * $this->user = 'EQC17113535hotel';
         * $this->pass = 'RK3cfnK^8RzL*l7AE3B';
         * $this->expedia_id = '17113535';
         *
         * $this->hotel_id = 17093355;
         * $this->user = 'EQC17093355hotel';
         * $this->pass = 'oiugrAGF865427!@ffffffi';
         *
         * $this->booking_retrieval_url = 'https://int.services.expediapartnercentral.com/eqc/br';
         * $this->endpoint = 'https://services.expediapartnercentral.com/';
         */
        
        $this->load->library('MutationBuilder');
        
        $this->max_lib = new MutationBuilder();
        $this->load->model('dcm_expedia');
        $this->load->model('dc_expedia_promo_model');
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->Authorization->IsLogined("admin_access");
    }

    public function index()
    {
        header("Location: /dc_expedia_promo/get_promotions");
    }

    public function get_bookings()
    {
        $auth = $this->username . ':' . $this->password;
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $request_body = '<BookingRetrievalRQ xmlns="http://www.expediaconnect.com/EQC/BR/2014/01">
			<Authentication username="' . $this->username . '" password="' . $this->password . '" />
			<Hotel id="' . $this->property_id . '" />
			<ParamSet>
				<NbDaysInPast>15</NbDaysInPast>
			</ParamSet>
		</BookingRetrievalRQ>';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->booking_retrieval_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request_body);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $xml = simplexml_load_string($buffer);
        
        $this->dump(json_decode(json_encode($xml), true));
        
        // $this->dump(htmlentities($buffer));
    }

    public function get_booking_by_id($booking_id)
    {
        $auth = $this->username . ':' . $this->password;
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $request_body = '<BookingRetrievalRQ xmlns="http://www.expediaconnect.com/EQC/BR/2014/01">
			<Authentication username="' . $this->username . '" password="' . $this->password . '" />
			<Hotel id="' . $this->property_id . '" />
			<ParamSet>
				<Booking id="' . $booking_id . '" />
			</ParamSet>
		</BookingRetrievalRQ>';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->booking_retrieval_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request_body);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        $xml = simplexml_load_string($buffer);
        
        $this->dump(json_decode(json_encode($xml), true));
    }

    public function get_token($debug = false)
    {
        $token = $this->db->limit(1)
            ->order_by('id', 'DESC')
            ->get('expedia_tokens')
            ->row_array();
        
        if (count($token)) {
            if (strtotime($token['expires_at']) > strtotime('now')) {
                if ($debug) {
                    $this->dump($token);
                }
                return $token['token'];
            }
        }
        
        $url = 'https://apis.expediaconnectivity.com/oauth/token';
        
        $auth = $this->user . ':' . $this->pass;
        
        $headers = array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $body = 'grant_type=client_credentials';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        $result = json_decode($buffer, true);
        
        $token_data = array(
            'timestamp' => date('Y-m-d H:i:s'),
            'token' => $result['access_token'],
            'expires_at' => date('Y-m-d H:i:s', strtotime('now') + $result['expires_in'])
        );
        
        $this->db->insert('expedia_tokens', $token_data);
        
        $token = $this->db->limit(1)
            ->order_by('id', 'DESC')
            ->get('expedia_tokens')
            ->row_array();
        
        if ($debug) {
            $this->dump($token);
        }
        return $token['token'];
    }

    public function get_promotions($property = '')
    {
        $hasNextPage = false;
        $after = "";
        $promotions = array();
        $per_page = 25;
        $property = $property != '' ? $property : $this->dc_expedia_promo_model->get_property();

        do {
            $request = $this->dc_expedia_promo_model->graphql_query($this->dc_expedia_promo_model->getQueryPromotions($property, $per_page, $after));

            if (isset($request['errors'])) {
                echo "<pre>";
                print_r($request);
                die();
                //$this->dump($request['errors'][0]['message']);
            }
            
            $promotions = array_merge($promotions, $request['data']['property']['promotions']['edges']);
            if ($request['data']['property']['promotions']['pageInfo']['hasNextPage'] === true) {
                $hasNextPage = true;
                $after = $request['data']['property']['promotions']['pageInfo']['endCursor'];
            } else {
                $hasNextPage = false;
                $after = "";
            }
        } while ($hasNextPage);
        
        $data['promotions'] = array();
        // $this->dump($promotions);
        foreach ($promotions as $key => $promotion) {
            if ($promotion['node']['status'] == 'INACTIVE') {
                continue;
            }
            $recurring = $promotion['node']['name'] == 'MULTI_NIGHT_PROMOTION' ? $promotion['node']['discount']['isRecurring'] : null;
            
            $data['promotions'][$key] = array(
                'promo_id' => $promotion['node']['id'],
                'property' => $property,
                'name' => $promotion['node']['code'],
                'status' => $promotion['node']['status'],
                'type' => $promotion['node']['name'],
                'category' => $promotion['node']['category'],
                'isMemberOnly' => $promotion['node']['restrictions']['isMemberOnly'] ? '<span class="text-blue"><i class="ion ion-checkmark statusicon"></i></span>' : null,
                'isMobileUserOnly' => $promotion['node']['restrictions']['isMobileUserOnly'],
                'minLengthOfStay' => $promotion['node']['restrictions']['minLengthOfStay'],
                'maxLengthOfStay' => $promotion['node']['restrictions']['maxLengthOfStay'],
                'minAdvanceBookingDays' => $promotion['node']['restrictions']['minAdvanceBookingDays'],
                'maxAdvanceBookingDays' => $promotion['node']['restrictions']['maxAdvanceBookingDays'],
                'bookingLocalDateTimeFrom' => $promotion['node']['restrictions']['bookingLocalDateTimeFrom'],
                'bookingLocalDateTimeTo' => $promotion['node']['restrictions']['bookingLocalDateTimeTo'],
                'travelDateFrom' => $promotion['node']['restrictions']['travelDateFrom'],
                'travelDateTo' => $promotion['node']['restrictions']['travelDateTo'],
                'sameDayBookingStartTime' => $promotion['node']['restrictions']['sameDayBookingStartTime'],
                'eligibleRatePlans' => $promotion['node']['eligibleRatePlans'],
                'unit' => $promotion['node']['discount']['unit'],
                'applicableNight' => $promotion['node']['name'] == 'MULTI_NIGHT_PROMOTION' ? $promotion['node']['discount']['applicableNight'] : null,
                'isRecurring' => '',
                'dof' => array(
                    array(
                        'day' => null,
                        'value' => null
                    )
                )
            ); // $promotion['discount'][''],
            
            if ($recurring == 1) {
                $data['promotions'][$key]['isRecurring'] = '<span class="text-blue"><i class="ion ion-checkmark statusicon"></i></span>';
            }
            
            if (isset($promotion['node']['discount']['value'])) {
                $data['promotions'][$key]['value'] = $promotion['node']['discount']['value'];
            } else {
                $data['promotions'][$key]['value'] = null;
            }
            
            if (isset($promotion['node']['discount']['memberOnlyAdditionalValue'])) {
                $data['promotions'][$key]['memberOnlyAdditionalValue'] = $promotion['node']['discount']['memberOnlyAdditionalValue'];
            } else {
                $data['promotions'][$key]['memberOnlyAdditionalValue'] = null;
            }
            
            if (isset($promotion['node']['discount']['monday'])) {
                $data['promotions'][$key]['dof'] = array(
                    array(
                        'day' => '{mlw_week_monday}',
                        'value' => $promotion['node']['discount']['monday']
                    ),
                    array(
                        'day' => '{mlw_week_tuesday}',
                        'value' => $promotion['node']['discount']['tuesday']
                    ),
                    array(
                        'day' => '{mlw_week_wednesday}',
                        'value' => $promotion['node']['discount']['wednesday']
                    ),
                    array(
                        'day' => '{mlw_week_thursday}',
                        'value' => $promotion['node']['discount']['thursday']
                    ),
                    array(
                        'day' => '{mlw_week_friday}',
                        'value' => $promotion['node']['discount']['friday']
                    ),
                    array(
                        'day' => '{mlw_week_saturday}',
                        'value' => $promotion['node']['discount']['saturday']
                    ),
                    array(
                        'day' => '{mlw_week_sunday}',
                        'value' => $promotion['node']['discount']['sunday']
                    )
                );
                $data['promotions'][$key]['value'] = null;
            } else {
                $data['promotions'][$key]['value'] = $promotion['node']['discount']['value'];
            }
        }
        
        $data['property'] = $property;
        
        $this->load->view('dc_expedia_promo/get_promotions.php', $data);
    }

    public function get_property_data()
    {
        $url = $this->endpoint . 'products/properties/17113535';
        
        $auth = $this->user . ':' . $this->pass;
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        $this->dump(json_decode($buffer, true));
    }

    public function get_rooms($debug = false)
    {
        $url = $this->endpoint . 'products/properties/' . $this->hotel_id . '/roomTypes';
        
        $auth = $this->user . ':' . $this->pass;
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        if ($debug) {
            $this->dump(json_decode($buffer, true));
        } else {
            $buf = json_decode($buffer, true);
            return $buf['entity'];
        }
    }

    public function get_rates($debug = false)
    {
        $rooms = $this->get_rooms();
        $rates = array();
        
        foreach ($rooms as $room) {
            $url = 'https://services.expediapartnercentral.com/properties/' . $this->hotel_id . '/roomTypes/' . $room['resourceId'] . '/ratePlans';
            
            $auth = $this->user . ':' . $this->pass;
            $headers = array(
                'Content-Type:application/vnd.expedia.eps.product-v3+json',
                'Authorization: Basic ' . base64_encode($auth)
            );
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $buffer = curl_exec($ch);
            curl_close($ch);
            $buf = json_decode($buffer, true);
            $rates = array_merge($rates, $buf['entity']);
        }
        
        $rate_arr = array();
        foreach ($rates as $rate) {
            if ($rate['status'] != 'Active') {
                continue;
            } else {
                foreach ($rate['distributionRules'] as $subrate) {
                    if ($subrate['manageable']) {
                        $rate_arr[] = array(
                            'id' => (int) $subrate['expediaId'],
                            'name' => $subrate['partnerCode']
                        );
                    }
                }
            }
        }
        
        if ($debug) {
            $this->dump($rates);
        } else {
            return $rate_arr;
        }
    }

    public function add_promotion($property = null)
    {
        $data['page_title'] = 'Add promotion';
        $data['save_method'] = 'save_promotion';
        $data['property'] = $property;
        $data['rates'] = $this->dc_expedia_promo_model->get_rates();
        $this->load->view('dc_expedia_promo/add_promotion.php', $data);
    }

    public function save_promotion($property = '')
    {
        $property = $property != '' ? $property : $this->dc_expedia_promo_model->get_property();
        
        $promotion_data = $this->input->post();
        if (isset($promotion_data['bookingLocalDateTime'])) {
            $promotion_data['bookingLocalDateTimeFrom'] = str_replace(' ', 'T', stristr($promotion_data['bookingLocalDateTime'], ' - ', true));
            $promotion_data['bookingLocalDateTimeTo'] = str_replace(' ', 'T', substr(stristr($promotion_data['bookingLocalDateTime'], ' - '), 3));
        }
        if (isset($promotion_data['travelDate'])) {
            $promotion_data['travelDateFrom'] = stristr($promotion_data['travelDate'], ' - ', true);
            $promotion_data['travelDateTo'] = substr(stristr($promotion_data['travelDate'], ' - '), 3);
        }
        
        if (isset($promotion_data['BlackouttravelDate'])) {
            
            foreach ($promotion_data['BlackouttravelDate'] as $value) {
                $promotion_data['blackoutTravelDateFrom'][] = stristr($value, ' - ', true);
                $promotion_data['blackoutTravelDateTo'][] = substr(stristr($value, ' - '), 3);
            }
        }
        
        $promotion_data['property'] = $property;
        
        $promotion_data['category'] = 'DISCOUNT_PROMOTION';
        $promotion_data['status'] = 'ACTIVE';
        if (empty($promotion_data)) {
            die('Not sure what are you doing here');
        }
        
        switch ($promotion_data['type']) {
            case 'basic':
                $promotion_data['name'] = 'BASIC_PROMOTION';
                
                if (! empty($promotion_data['rates'])) {
                    for ($i = 0; $i < count($promotion_data['rates']); $i ++) {
                        $promotion_data['ratess'][$i]['rate_id'] = $promotion_data['rates'][$i];
                        if ($i != count($promotion_data['rates']) - 1) {
                            $promotion_data['ratess'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['ratess'][$i]['coma'] = null;
                        }
                    }
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['isMemberOnly'] = $this->input->post('isMemberOnly') == true ? "true" : "false";
                $promotion_data['isMobileUserOnly'] = $this->input->post('isMobileUserOnly') == true ? "true" : "false";
                
                if (isset($promotion_data['isMemberOnly'])) {
                    $promotion_data['mo_coma'] = null;
                    $promotion_data['memberOnlyAdditionalValue'] = null;
                } else 
                    if ($promotion_data['memberOnlyAdditionalValue'] > 0) {
                        $promotion_data['mo_coma'] = ',';
                        $promotion_data['memberOnlyAdditionalValue'] = 'memberOnlyAdditionalValue: ' . $promotion_data['memberOnlyAdditionalValue'];
                    }
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                        
                        if ($i != count($promotion_data['blackoutTravelDateFrom']) - 1) {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = null;
                        }
                    }
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                    // $this->dump($promotion_data);
                }
                
                $promotion_data['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                $promotion_data['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                
                $query = $this->parser->parse('/templates/dc_expedia_promo/basic_graphql.html', $promotion_data, true);
                break;
            
            case 'early_booker':
                $promotion_data['name'] = 'EARLY_BOOKING_PROMOTION';
                if (! empty($promotion_data['rates'])) {
                    for ($i = 0; $i < count($promotion_data['rates']); $i ++) {
                        $promotion_data['ratess'][$i]['rate_id'] = $promotion_data['rates'][$i];
                        if ($i != count($promotion_data['rates']) - 1) {
                            $promotion_data['ratess'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['ratess'][$i]['coma'] = null;
                        }
                    }
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['isMemberOnly'] = $this->input->post('isMemberOnly') == true ? "true" : "false";
                $promotion_data['isMobileUserOnly'] = $this->input->post('isMobileUserOnly') == true ? "true" : "false";
                $promotion_data['mo_coma'] = $this->input->post('memberOnlyAdditionalValue') == true ? "," : null;
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                        
                        if ($i != count($promotion_data['blackoutTravelDateFrom']) - 1) {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = null;
                        }
                    }
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                    // $this->dump($promotion_data);
                }
                
                $promotion_data['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                $promotion_data['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                
                $query = $this->parser->parse('/templates/dc_expedia_promo/early_booker_graphql.html', $promotion_data, true);
                
                break;
            
            case 'same_day':
                $promotion_data['name'] = 'SAME_DAY_PROMOTION';
                if (! empty($promotion_data['rates'])) {
                    for ($i = 0; $i < count($promotion_data['rates']); $i ++) {
                        $promotion_data['ratess'][$i]['rate_id'] = $promotion_data['rates'][$i];
                        if ($i != count($promotion_data['rates']) - 1) {
                            $promotion_data['ratess'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['ratess'][$i]['coma'] = null;
                        }
                    }
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['isMemberOnly'] = $this->input->post('isMemberOnly') == true ? "true" : "false";
                $promotion_data['isMobileUserOnly'] = $this->input->post('isMobileUserOnly') == true ? "true" : "false";
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                        
                        if ($i != count($promotion_data['blackoutTravelDateFrom']) - 1) {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = null;
                        }
                    }
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                    // $this->dump($promotion_data);
                }
                
                $promotion_data['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                $promotion_data['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                $travelDateFrom1 = explode('T', $promotion_data['bookingLocalDateTimeFrom']);
                $bookingLocalDateTimeTo1 = explode('T', $promotion_data['bookingLocalDateTimeTo']);
                $promotion_data['travelDateFrom'] = $travelDateFrom1[0];
                $promotion_data['travelDateTo'] = $bookingLocalDateTimeTo1[0];
                
                $promotion_data['sameDayBookingStartTime'] = $promotion_data['sameDayBookingStartTime'] . ':00';
                
                $query = $this->parser->parse('/templates/dc_expedia_promo/same_day_graphql.html', $promotion_data, true);
                
                break;
            
            case 'dof':
                $promotion_data['name'] = 'BASIC_PROMOTION';
                if (! empty($promotion_data['rates'])) {
                    for ($i = 0; $i < count($promotion_data['rates']); $i ++) {
                        $promotion_data['ratess'][$i]['rate_id'] = $promotion_data['rates'][$i];
                        if ($i != count($promotion_data['rates']) - 1) {
                            $promotion_data['ratess'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['ratess'][$i]['coma'] = null;
                        }
                    }
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['isMemberOnly'] = $this->input->post('isMemberOnly') == true ? "true" : "false";
                $promotion_data['isMobileUserOnly'] = $this->input->post('isMobileUserOnly') == true ? "true" : "false";
                
                if (isset($promotion_data['isMemberOnly'])) {
                    $promotion_data['mo_coma'] = null;
                    $promotion_data['memberOnlyAdditionalValue'] = null;
                } else 
                    if ((double) $promotion_data['memberOnlyAdditionalValue'] > 0) {
                        $promotion_data['mo_coma'] = ',';
                        $promotion_data['memberOnlyAdditionalValue'] = 'memberOnlyAdditionalValue: ' . $promotion_data['memberOnlyAdditionalValue'];
                    }
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                        
                        if ($i != count($promotion_data['blackoutTravelDateFrom']) - 1) {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = null;
                        }
                    }
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                
                $promotion_data['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                $promotion_data['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                $query = $this->parser->parse('/templates/dc_expedia_promo/dof_graphql.html', $promotion_data, true);
                
                break;
            
            case 'multi_nights':
                $promotion_data['name'] = 'MULTI_NIGHT_PROMOTION';
                if (! empty($promotion_data['rates'])) {
                    for ($i = 0; $i < count($promotion_data['rates']); $i ++) {
                        $promotion_data['ratess'][$i]['rate_id'] = $promotion_data['rates'][$i];
                        if ($i != count($promotion_data['rates']) - 1) {
                            $promotion_data['ratess'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['ratess'][$i]['coma'] = null;
                        }
                    }
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['isMemberOnly'] = $this->input->post('isMemberOnly') == true ? "true" : "false";
                $promotion_data['isMobileUserOnly'] = $this->input->post('isMobileUserOnly') == true ? "true" : "false";
                $promotion_data['isRecurring'] = $this->input->post('isRecurring') == true ? "true" : "false";
                
                if (isset($promotion_data['isMemberOnly'])) {
                    $promotion_data['mo_coma'] = null;
                    $promotion_data['memberOnlyAdditionalValue'] = null;
                } else 
                    if ($promotion_data['memberOnlyAdditionalValue'] > 0) {
                        $promotion_data['mo_coma'] = ',';
                        $promotion_data['memberOnlyAdditionalValue'] = 'memberOnlyAdditionalValue: ' . $promotion_data['memberOnlyAdditionalValue'];
                    }
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutTravelDates'][$i]['blackoutTravelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                        
                        if ($i != count($promotion_data['blackoutTravelDateFrom']) - 1) {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = ',';
                        } else {
                            $promotion_data['blackoutTravelDates'][$i]['coma'] = null;
                        }
                    }
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                
                $promotion_data['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                $promotion_data['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                
                if ($promotion_data['minLengthOfStay'] < $promotion_data['applicableNight']) {
                    $promotion_data['minLengthOfStay'] = $promotion_data['applicableNight'];
                }
                $query = $this->parser->parse('/templates/dc_expedia_promo/multi_nights_graphql.html', $promotion_data, true);
                
                break;
            
            default:
                exit('Not valid type');
                break;
        }
        
        $result = $this->dc_expedia_promo_model->graphql_query($query);
        //die();
        if (isset($result['errors'])) {
            
            if (stripos($promotion_data['code'], "_") !== false) {
                
                $newdata = array(
                    'header_msg_text' => "The name mustn't contain a character '_'"
                );
                $this->session->set_userdata($newdata);
            }
            foreach ($result['errors'] as $key => $value) {
                
                if ($result['errors'][$key]['extensions']['code'] == 'BAD_USER_INPUT') {
                    
                    $newdata = array(
                        'header_msg_text' => $result['errors'][$key]['message']
                    );
                    $this->session->set_userdata($newdata);
                }
            }
            
            $data['json'] = json_encode(array(
                'request' => $query,
                'error' => $result['errors']
            ));
            $this->Loger_admin->SaveLog_json($data, 'loger_admin', 'expedia_promotion', 'add', 0, 0, 3);
            
            exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/add_promotion">');
        } elseif (isset($result['data'])) {
            $data['json'] = json_encode(array(
                'request' => $query,
                'result' => $result['data']
            ));
            $this->Loger_admin->SaveLog_json($data, 'loger_admin', 'expedia_promotion', 'add', 0, 0, 3);
            
            exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/get_promotions">');
        } //
    }

    public function edit_promotion($id, $property = '')
    {
        $property = $property != '' ? $property : $this->dc_expedia_promo_model->get_property();
        
        $request = $this->dc_expedia_promo_model->graphql_query($this->dc_expedia_promo_model->get_promotion($property, $id));
        $data['id'] = $id;
        $data['property'] = $property;
        if (isset($request['errors'])) {
            $this->dump($request['errors'][0]['message']);
        } else {
            $data['promotion_data'] = $request['data']['property']['promotions']['edges'][0]['node'];
        }
        
        $this->load->view("dc_expedia_promo/edit_promotion", $data);
    }

    public function get_rates2($hotel)
    {
        $rooms = $this->get_rooms2($hotel);
        $rates = array();
        
        foreach ($rooms as $room) {
            $url = 'https://services.expediapartnercentral.com/properties/' . $hotel . '/roomTypes/' . $room['resourceId'] . '/ratePlans';
            
            $auth = 'EQCOtelmsMaster:yRH73gVGzll@ib8M';
            $headers = array(
                'Content-Type:application/vnd.expedia.eps.product-v3+json',
                'Authorization: Basic ' . base64_encode($auth)
            );
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $buffer = curl_exec($ch);
            curl_close($ch);
            $buf = json_decode($buffer, true);
            $rates = array_merge($rates, $buf['entity']);
        }
        
        $rate_arr = array();
        foreach ($rates as $rate) {
            if ($rate['status'] != 'Active') {
                continue;
            } else {
                foreach ($rate['distributionRules'] as $subrate) {
                    if ($subrate['manageable']) {
                        $rate_arr[] = array(
                            'id' => (int) $subrate['expediaId'],
                            'name' => $subrate['partnerCode']
                        );
                    }
                }
            }
        }
        
        $this->dump($rates);
    }

    public function get_rooms2($hotel, $debug = false)
    {
        $url = 'https://services.expediapartnercentral.com/products/properties/' . $hotel . '/roomTypes';
        
        $auth = 'EQCOtelmsMaster:yRH73gVGzll@ib8M';
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        curl_close($ch);
        
        if ($debug) {
            $this->dump(json_decode($buffer, true));
        } else {
            $buf = json_decode($buffer, true);
            return $buf['entity'];
        }
    }

    public function get_property($hotel)
    {
        $url = 'https://services.expediapartnercentral.com/properties/v1/Otelms/' . $hotel;
        
        $auth = 'EQCOtelmsMaster:yRH73gVGzll@ib8M';
        $headers = array(
            'Content-Type:application/vnd.expedia.eps.product-v3+json',
            'Authorization: Basic ' . base64_encode($auth)
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $buffer = curl_exec($ch);
        $information = curl_getinfo($ch);
        curl_close($ch);
        
        // $this->dump( json_decode( $buffer, true ) );
        $this->dump(array(
            $information,
            $buffer
        ));
    }

    public function update_promotion($id, $property = '')
    {
        $property = $property != '' ? $property : $this->dc_expedia_promo_model->get_property();
        $request = $this->dc_expedia_promo_model->graphql_query($this->dc_expedia_promo_model->get_promotion($property, $id));
        
        if (isset($request['errors'])) {
            var_dump($request['errors'][0]['message']);
            die();
        } else {
            $old_promotion = $request['data']['property']['promotions']['edges'][0]['node'];
        }
        
        $promotion_data = $this->input->post();
        
        if (isset($promotion_data['bookingLocalDateTime'])) {
            $promotion_data['bookingLocalDateTimeFrom'] = str_replace(' ', 'T', stristr($promotion_data['bookingLocalDateTime'], ' - ', true));
            $promotion_data['bookingLocalDateTimeTo'] = str_replace(' ', 'T', substr(stristr($promotion_data['bookingLocalDateTime'], ' - '), 3));
        }
        unset($promotion_data['bookingLocalDateTime']);
        if (isset($promotion_data['travelDate'])) {
            $promotion_data['travelDateFrom'] = stristr($promotion_data['travelDate'], ' - ', true);
            $promotion_data['travelDateTo'] = substr(stristr($promotion_data['travelDate'], ' - '), 3);
            unset($promotion_data['travelDate']);
        }
        
        if (isset($promotion_data['BlackouttravelDate'])) {
            
            foreach ($promotion_data['BlackouttravelDate'] as $value) {
                $promotion_data['blackoutTravelDateFrom'][] = stristr($value, ' - ', true);
                $promotion_data['blackoutTravelDateTo'][] = substr(stristr($value, ' - '), 3);
            }
            unset($promotion_data['BlackouttravelDate']);
        }
        
        if (isset($old_promotion['discount']['monday'])) {
            $promotion_type = 'dof';
        } else {
            
            $prom_map = array(
                'BASIC_PROMOTION' => 'basic',
                'EARLY_BOOKING_PROMOTION' => 'early_booker',
                'MULTI_NIGHT_PROMOTION' => 'multi_nights',
                'SAME_DAY_PROMOTION' => 'same_day'
            );
            $promotion_type = $prom_map[$old_promotion['name']];
        }
        // print_r($promotion_data);
        switch ($promotion_type) {
            case 'basic':
            case 'early_booker':
                if (! empty($promotion_data['rates'])) {
                    foreach ($promotion_data['rates'] as $rate) {
                        $promotion_data['eligibleRatePlans'][]['id'] = $rate;
                    }
                    unset($promotion_data['rates']);
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['restrictions']['isMemberOnly'] = isset($promotion_data['isMemberOnly']) ? true : false;
                $promotion_data['restrictions']['isMobileUserOnly'] = isset($promotion_data['isMobileUserOnly']) ? true : false;
                if (isset($promotion_data['isMemberOnly'])) {
                    $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval(0);
                } else 
                    if ($promotion_data['memberOnlyAdditionalValue'] > 0) {
                        $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval($promotion_data['memberOnlyAdditionalValue']);
                    } else {
                        $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval(0);
                    }
                unset($promotion_data['isMemberOnly']);
                unset($promotion_data['memberOnlyAdditionalValue']);
                unset($promotion_data['isMobileUserOnly']);
                
                $promotion_data['restrictions']['maxLengthOfStay'] = (int) $promotion_data['maxLengthOfStay'];
                unset($promotion_data['maxLengthOfStay']);
                
                $promotion_data['restrictions']['minLengthOfStay'] = (int) $promotion_data['minLengthOfStay'];
                unset($promotion_data['minLengthOfStay']);
                
                $promotion_data['restrictions']['minAdvanceBookingDays'] = (int) $promotion_data['minAdvanceBookingDays'];
                unset($promotion_data['minAdvanceBookingDays']);
                
                $promotion_data['restrictions']['maxAdvanceBookingDays'] = (int) $promotion_data['maxAdvanceBookingDays'];
                unset($promotion_data['maxAdvanceBookingDays']);
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        
                        $promotion_data['blackoutDates'][$i]['travelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutDates'][$i]['travelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                    }
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                } else {
                    $promotion_data['blackoutDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                
                if (count(explode(':', $promotion_data['bookingLocalDateTimeFrom'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                }
                if (count(explode(':', $promotion_data['bookingLocalDateTimeTo'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                }
                unset($promotion_data['bookingLocalDateTimeFrom']);
                unset($promotion_data['bookingLocalDateTimeTo']);
                
                $promotion_data['restrictions']['travelDateFrom'] = $promotion_data['travelDateFrom'];
                $promotion_data['restrictions']['travelDateTo'] = $promotion_data['travelDateTo'];
                unset($promotion_data['travelDateFrom']);
                unset($promotion_data['travelDateTo']);
                
                $promotion_data['discount']['unit'] = $promotion_data['discount_unit'];
                $promotion_data['discount']['value'] = floatval($promotion_data['discount_value']);
                unset($promotion_data['discount_unit']);
                unset($promotion_data['discount_value']);
                $to_update = $this->checkModify($promotion_data, $old_promotion);
                
                $query = 'mutation {
  updateSingleDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      ' . $this->max_lib->convert($to_update) . '
    }
  ) {
    __typename
    id
    status
  }
}';
                break;
            
            case 'same_day':
                if (! empty($promotion_data['rates'])) {
                    foreach ($promotion_data['rates'] as $rate) {
                        $promotion_data['eligibleRatePlans'][]['id'] = $rate;
                    }
                    unset($promotion_data['rates']);
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['restrictions']['isMemberOnly'] = isset($promotion_data['isMemberOnly']) ? true : false;
                $promotion_data['restrictions']['isMobileUserOnly'] = isset($promotion_data['isMobileUserOnly']) ? true : false;
                unset($promotion_data['isMemberOnly']);
                unset($promotion_data['isMobileUserOnly']);
                unset($promotion_data['memberOnlyAdditionalValue']);
                
                $promotion_data['restrictions']['maxLengthOfStay'] = (int) $promotion_data['maxLengthOfStay'];
                unset($promotion_data['maxLengthOfStay']);
                
                $promotion_data['restrictions']['minLengthOfStay'] = (int) $promotion_data['minLengthOfStay'];
                unset($promotion_data['minLengthOfStay']);
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        
                        $promotion_data['blackoutDates'][$i]['travelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutDates'][$i]['travelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                    }
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                if (count(explode(':', $promotion_data['bookingLocalDateTimeFrom'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                }
                if (count(explode(':', $promotion_data['bookingLocalDateTimeTo'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                }
                $promotion_data['restrictions']['travelDateFrom'] = substr($promotion_data['bookingLocalDateTimeFrom'], 0, 10);
                $promotion_data['restrictions']['travelDateTo'] = substr($promotion_data['bookingLocalDateTimeTo'], 0, 10);
                
                if (count(explode(':', $promotion_data['sameDayBookingStartTime'])) == 3) {
                    $promotion_data['restrictions']['sameDayBookingStartTime'] = $promotion_data['sameDayBookingStartTime'];
                } else {
                    $promotion_data['restrictions']['sameDayBookingStartTime'] = $promotion_data['sameDayBookingStartTime'] . ':00';
                }
                unset($promotion_data['bookingLocalDateTimeFrom']);
                unset($promotion_data['bookingLocalDateTimeTo']);
                unset($promotion_data['sameDayBookingStartTime']);
                
                $promotion_data['discount']['unit'] = $promotion_data['discount_unit'];
                $promotion_data['discount']['value'] = floatval($promotion_data['discount_value']);
                unset($promotion_data['discount_unit']);
                unset($promotion_data['discount_value']);
                $to_update = $this->checkModify($promotion_data, $old_promotion);
                
                $query = 'mutation {
  updateSingleDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      ' . $this->max_lib->convert($to_update) . '
    }
  ) {
    __typename
    id
    status
  }
}';
                break;
            
            case 'dof':
                if (! empty($promotion_data['rates'])) {
                    foreach ($promotion_data['rates'] as $rate) {
                        $promotion_data['eligibleRatePlans'][]['id'] = $rate;
                    }
                    unset($promotion_data['rates']);
                } else {
                    die('No rates selected');
                }
                
                $promotion_data['restrictions']['isMemberOnly'] = isset($promotion_data['isMemberOnly']) ? true : false;
                $promotion_data['restrictions']['isMobileUserOnly'] = isset($promotion_data['isMobileUserOnly']) ? true : false;
                unset($promotion_data['isMemberOnly']);
                unset($promotion_data['isMobileUserOnly']);
                unset($promotion_data['memberOnlyAdditionalValue']);
                
                $promotion_data['restrictions']['maxLengthOfStay'] = (int) $promotion_data['maxLengthOfStay'];
                unset($promotion_data['maxLengthOfStay']);
                
                $promotion_data['restrictions']['minLengthOfStay'] = (int) $promotion_data['minLengthOfStay'];
                unset($promotion_data['minLengthOfStay']);
                
                $promotion_data['restrictions']['minAdvanceBookingDays'] = (int) $promotion_data['minAdvanceBookingDays'];
                unset($promotion_data['minAdvanceBookingDays']);
                
                $promotion_data['restrictions']['maxAdvanceBookingDays'] = (int) $promotion_data['maxAdvanceBookingDays'];
                unset($promotion_data['maxAdvanceBookingDays']);
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        
                        $promotion_data['blackoutDates'][$i]['travelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutDates'][$i]['travelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                    }
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                
                if (count(explode(':', $promotion_data['bookingLocalDateTimeFrom'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                }
                if (count(explode(':', $promotion_data['bookingLocalDateTimeTo'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                }
                unset($promotion_data['bookingLocalDateTimeFrom']);
                unset($promotion_data['bookingLocalDateTimeTo']);
                
                $promotion_data['restrictions']['travelDateFrom'] = $promotion_data['travelDateFrom'];
                $promotion_data['restrictions']['travelDateTo'] = $promotion_data['travelDateTo'];
                unset($promotion_data['travelDateFrom']);
                unset($promotion_data['travelDateTo']);
                
                $promotion_data['discount']['unit'] = $promotion_data['discount_unit'];
                $promotion_data['discount']['monday'] = floatval($promotion_data['monday']);
                $promotion_data['discount']['tuesday'] = floatval($promotion_data['tuesday']);
                $promotion_data['discount']['wednesday'] = floatval($promotion_data['wednesday']);
                $promotion_data['discount']['thursday'] = floatval($promotion_data['thursday']);
                $promotion_data['discount']['friday'] = floatval($promotion_data['friday']);
                $promotion_data['discount']['saturday'] = floatval($promotion_data['saturday']);
                $promotion_data['discount']['sunday'] = floatval($promotion_data['sunday']);
                unset($promotion_data['discount_unit']);
                unset($promotion_data['monday']);
                unset($promotion_data['tuesday']);
                unset($promotion_data['wednesday']);
                unset($promotion_data['thursday']);
                unset($promotion_data['friday']);
                unset($promotion_data['saturday']);
                unset($promotion_data['sunday']);
                
                $to_update = $this->checkModify($promotion_data, $old_promotion);
                
                $query = 'mutation {
  updateDayOfWeekDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
     ' . $this->max_lib->convert($to_update) . '
    }
  ) {
    __typename
    id
    status
  }
}';
                // print_r($to_update);
                
                break;
            
            case 'multi_nights':
                
                if (! empty($promotion_data['rates'])) {
                    foreach ($promotion_data['rates'] as $rate) {
                        $promotion_data['eligibleRatePlans'][]['id'] = $rate;
                    }
                    unset($promotion_data['rates']);
                } else {
                    die('No rates selected');
                }
                $promotion_data['restrictions']['isMemberOnly'] = isset($promotion_data['isMemberOnly']) ? true : false;
                $promotion_data['restrictions']['isMobileUserOnly'] = isset($promotion_data['isMobileUserOnly']) ? true : false;
                if (isset($promotion_data['isMemberOnly'])) {
                    $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval(0);
                } else 
                    if ($promotion_data['memberOnlyAdditionalValue'] > 0) {
                        $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval($promotion_data['memberOnlyAdditionalValue']);
                    } else {
                        $promotion_data['discount']['memberOnlyAdditionalValue'] = floatval(0);
                    }
                unset($promotion_data['isMemberOnly']);
                unset($promotion_data['isMobileUserOnly']);
                unset($promotion_data['memberOnlyAdditionalValue']);
                
                $promotion_data['restrictions']['maxLengthOfStay'] = (int) $promotion_data['maxLengthOfStay'];
                unset($promotion_data['maxLengthOfStay']);
                
                $promotion_data['restrictions']['minLengthOfStay'] = (int) $promotion_data['minLengthOfStay'];
                unset($promotion_data['minLengthOfStay']);
                
                $promotion_data['restrictions']['minAdvanceBookingDays'] = (int) $promotion_data['minAdvanceBookingDays'];
                unset($promotion_data['minAdvanceBookingDays']);
                
                $promotion_data['restrictions']['maxAdvanceBookingDays'] = (int) $promotion_data['maxAdvanceBookingDays'];
                unset($promotion_data['maxAdvanceBookingDays']);
                
                if (! empty($promotion_data['blackoutTravelDateFrom']) && strlen(($promotion_data['blackoutTravelDateFrom'][0])) > 0) {
                    
                    for ($i = 0; $i < count($promotion_data['blackoutTravelDateFrom']); $i ++) {
                        
                        $promotion_data['blackoutDates'][$i]['travelDateFrom'] = $promotion_data['blackoutTravelDateFrom'][$i];
                        $promotion_data['blackoutDates'][$i]['travelDateTo'] = $promotion_data['blackoutTravelDateTo'][$i];
                    }
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                } else {
                    $promotion_data['blackoutTravelDates'] = array();
                    unset($promotion_data['blackoutTravelDateFrom']);
                    unset($promotion_data['blackoutTravelDateTo']);
                }
                
                if (count(explode(':', $promotion_data['bookingLocalDateTimeFrom'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeFrom'] = $promotion_data['bookingLocalDateTimeFrom'] . ':00';
                }
                if (count(explode(':', $promotion_data['bookingLocalDateTimeTo'])) == 3) {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'];
                } else {
                    $promotion_data['restrictions']['bookingLocalDateTimeTo'] = $promotion_data['bookingLocalDateTimeTo'] . ':00';
                }
                unset($promotion_data['bookingLocalDateTimeFrom']);
                unset($promotion_data['bookingLocalDateTimeTo']);
                
                $promotion_data['restrictions']['travelDateFrom'] = $promotion_data['travelDateFrom'];
                $promotion_data['restrictions']['travelDateTo'] = $promotion_data['travelDateTo'];
                unset($promotion_data['travelDateFrom']);
                unset($promotion_data['travelDateTo']);
                
                $promotion_data['discount']['unit'] = $promotion_data['discount_unit'];
                $promotion_data['discount']['value'] = floatval($promotion_data['discount_value']);
                $promotion_data['discount']['applicableNight'] = (int) $promotion_data['applicableNight'];
                $promotion_data['discount']['isRecurring'] = isset($promotion_data['isRecurring']) ? true : false;
                
                unset($promotion_data['applicableNight']);
                unset($promotion_data['isRecurring']);
                unset($promotion_data['discount_unit']);
                unset($promotion_data['discount_value']);
                unset($promotion_data['bookingLocalDateTimeTo']);
                unset($promotion_data['travelDate']);
                $to_update = $this->checkModify($promotion_data, $old_promotion);
                
                $query = 'mutation {
  updateMultiNightDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      ' . $this->max_lib->convert($to_update) . '
    }
  ) {
    __typename
    id
    status
  }
}';
        }
        
        $result = $this->dc_expedia_promo_model->graphql_query($query);
        
        if (isset($result['errors'])) {
            
            foreach ($result['errors'] as $key => $value) {
                
                if ($result['errors'][$key]['extensions']['code'] == 'BAD_USER_INPUT') {
                    
                    $newdata = array(
                        'header_msg_text' => $result['errors'][$key]['message']
                    );
                    
                    $this->session->set_userdata($newdata);
                } elseif ($result['errors'][$key]['extensions']['code'] == 'INTERNAL_SERVER_ERROR') {
                    
                    $newdata = array(
                        'header_msg_text' => $result['errors'][$key]['message']
                    );
                    
                    $this->session->set_userdata($newdata);
                }
            }
            $data['json'] = json_encode(array(
                'request' => $query,
                'error' => $result['errors']
            ));
            $this->Loger_admin->SaveLog_json($data, 'loger_admin', 'expedia_promotion', 'update', 0, 0, 3);
            
            exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/edit_promotion/' . $id . '">');
        } elseif (isset($result['data'])) {
            $data['json'] = json_encode(array(
                'request' => $query,
                'result' => $result['data']
            ));
            $this->Loger_admin->SaveLog_json($data, 'loger_admin', 'expedia_promotion', 'update', 0, 0, 3);
            
            exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/get_promotions">');
        }
    }

    public function deactivate_promotion($id, $property = '')
    {
        $property = $property != '' ? $property : $this->dc_expedia_promo_model->get_property();
        
        $request = $this->dc_expedia_promo_model->graphql_query($this->dc_expedia_promo_model->get_promotion($property, $id));
        
        if (isset($request['errors'])) {
            $this->dump($request['errors'][0]['message']);
        } else {
            $promotion_data = $request['data']['property']['promotions']['edges'][0]['node'];
        }
        
        if (isset($promotion_data['discount']['monday'])) {
            $promotion_type = 'dof';
        } else {
            
            $prom_map = array(
                'BASIC_PROMOTION' => 'basic',
                'EARLY_BOOKING_PROMOTION' => 'early_booker',
                'MULTI_NIGHT_PROMOTION' => 'multi_nights',
                'SAME_DAY_PROMOTION' => 'same_day'
            );
            $promotion_type = $prom_map[$promotion_data['name']];
        }
        
        switch ($promotion_type) {
            case 'basic':
            case 'early_booker':
            case 'same_day':
                $query = 'mutation {
  updateSingleDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      status: INACTIVE
    }
  ) {
    __typename
    id
    status
  }
}';
                break;
            
            case 'dof':
                $query = 'mutation {
  updateDayOfWeekDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      status: INACTIVE
    }
  ) {
    __typename
    id
    status
  }
}';
                break;
            
            case 'multi_nights':
                $query = 'mutation {
  updateMultiNightDiscountPromotion(
    propertyId: "' . $property . '",
    propertyIdSource: EXPEDIA,
    promotion: {
      id: "' . $id . '",
      status: INACTIVE
    }
  ) {
    __typename
    id
    status
  }
}';
                break;
            
            default:
                exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/get_promotions">');
        }
        
        $res = $this->dc_expedia_promo_model->graphql_query($query);
        $data['json'] = json_encode(array(
             'request' => $query,
            'result' => $res['data']
        ));
        $this->Loger_admin->SaveLog_json($data, 'loger_admin', 'expedia_promotion', 'delete', 0, 0, 3);
        
        exit('<meta http-equiv="refresh" content="0;url=/dc_expedia_promo/get_promotions">');
    }

    public function checkModify($form, $oldPromotion)
    {
        $toBeUpdated = array();
        
        foreach ($oldPromotion as $index => $value) {
            if (isset($form[$index])) {
                if (is_array($form[$index])) {
                    if ($index == 'eligibleRatePlans') {
                        if ($form[$index] != $oldPromotion[$index]) {
                            $toBeUpdated[$index] = $form[$index];
                        }
                    } elseif ($index == 'blackoutDates') {
                        if ($form[$index] != $oldPromotion[$index]) {
                            $toBeUpdated[$index] = $form[$index];
                        }
                    } else {
                        foreach ($form[$index] as $formIndex => $formValue) {
                            
                            if (isset($oldPromotion[$index][$formIndex])) {
                                if ($oldPromotion[$index][$formIndex] != $form[$index][$formIndex]) {
                                    $toBeUpdated[$index][$formIndex] = $formValue;
                                }
                            } else {
                                $toBeUpdated[$index][$formIndex] = $formValue;
                            }
                        }
                    }
                } else {
                    if ($form[$index] != $oldPromotion[$index]) {
                        $toBeUpdated[$index] = $form[$index];
                    }
                }
            }
        }
        switch ($oldPromotion['name']) {
            case 'MULTI_NIGHT_PROMOTION':
                $toBeUpdated['discount']['applicableNight'] = $oldPromotion['discount']['applicableNight'];
                break;
            case 'BASIC_PROMOTION':
                if ($oldPromotion['discount']['type'] == 'DAY_OF_WEEK_DISCOUNT') {
                    $day_arr = array(
                        'monday',
                        'tuesday',
                        'wednesday',
                        'thursday',
                        'friday',
                        'saturday',
                        'sunday'
                    );
                    foreach ($day_arr as $value) {
                        if ($oldPromotion['discount'][$value] != $form['discount'][$value]) {
                            $toBeUpdated['discount'][$value] = $form['discount'][$value];
                        } else {
                            $toBeUpdated['discount'][$value] = $oldPromotion['discount'][$value];
                        }
                    }
                }
                break;
        }
        
        return $toBeUpdated;
    }
}