<?php
require_once (APPPATH . 'third_party/stripe/init.php');
class Stripe_m extends CI_model {
    function __construct(){
        parent::__construct();
        $this->customer = new \Stripe\Customer();
        $this->stripe = new \Stripe\Stripe();
        $this->invoice = new \Stripe\Invoice();
    }

    function get_secret_key($account_id = 0)
    {
        if ($account_id == 0) {

            $region_id = $this->get_property_region_id_for_plans();

            $query = $this->db->query("select account_id from global_hotelix.stripe_region2account where region_id=" . $region_id);
            if ($query->num_rows()) {
                $row = $query->row();
                $account_id = $row->account_id;
            }
        }
        //$account_id = 2;
        if ($this->config->item('hms_stripe_billing_test') == 1) {
            switch ($account_id) {
                case 1: // UK
                    return "sk_test_D44UtbmH0yoFWIh8mj7q3Jcc";
                    break;
                case 2: // US
                    return "sk_test_d19ipvh8ROnGPZ4L6q96S4BO";
                    break;
                default:
                    break;
            }
        } else {
            switch ($account_id) {
                case 1: // UK
                    return "sk_live_iE2mMoPUDp3VxXlAbEjEnXA0";
                    break;
                case 2: // US
                    return "sk_live_ULSdkctCLcUFaOamwoEjKQIe";
                    break;
                default:
                    break;
            }
        }

    }

    function get_publish_key($account_id = 0) {
        if ($account_id == 0) {
            $region_id = $this->hotelix_config->get_record("stripe_region_id", "int");
            $query = $this->db->query("select account_id from global_hotelix.stripe_region2account where region_id=" . $region_id);
            if ($query->num_rows()) {
                $row = $query->row();
                $account_id = $row->account_id;
            }
        }

        if ($this->config->item('hms_stripe_billing_test') == 1) {
            switch ($account_id) {
                case 1:
                    return "pk_test_caLBCpBpAkubeVHjTb1vosaf";
                    break;
                case 2:
                    return "pk_test_0toHn3UsTJbzBwO5WIhtQNBK";
                    break;
                default:
                    break;
            }
        } else  {
            switch ($account_id) {
                case 1:
                    return "pk_live_Qdoy21Zg2qo4i8ONbXTL7Ga1";
                    break;
                case 2:
                    return "pk_live_gNXbdh4NAgjogKhNKmXEhIV9";
                    break;
                default:
                    break;
            }
        }
    }

    function create_customer($param) {
//     	$secret_key = $this->Stripe_m->get_secret_key();
//     	$this->stripe->setApiKey($secret_key);
    	$data = array();
    	$data['email'] = "hms_customer_" . $param['hms_id'] . "@otelms.com";
    	$data['description'] = "HMS customer " . $param['hms_id'] . "";
    	$data['metadata'] = array(
    	    'hms_id' 	=> $param['hms_id'],
    	    'hms_url' 	=> $param['host'],
    	);
    	if (isset($param['coupon'])){
    		$data['coupon'] = $param['coupon'];
    	}
    	$response = $this->customer->create($data);
    	$customer = $response->__toArray(true);
//     	$this->hotelix_config->set_record("stripe_billing_customer_id", $customer['id']);
    	//set region ID

    	return $customer;
    }

    function get_customer() {
    	$stripe_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
    	$secret_key = $this->Stripe_m->get_secret_key();
    	$this->stripe->setApiKey($secret_key);
    	$response = $this->customer->retrieve($stripe_customer_id);
    	$customer = $response->__toArray(true);
    	return $customer;
    }

    function get_plans_ranges() {
		$base_ranges = array (
				1 => array (
						'mcount_value' => 1,
						'mcount_pars_value' => 1,
						'mcount_clt' => '{clt_month}',
						'active_class' => '',
				),
				3 => array (
						'mcount_value' => 3,
						'mcount_pars_value' => 3,
						'mcount_clt' => '{clt_3months}',
						'active_class' => '',
				),
				6 => array (
						'mcount_value' => 6,
						'mcount_pars_value' => 6,
						'mcount_clt' => '{clt_months}',
						'active_class' => '',
				),
				12 => array (
						'mcount_value' => 12,
						'mcount_pars_value' => 1,
						'mcount_clt' => '{clt_year}',
						'active_class' => '',
				),

		);
		$type_id = $this->Stripe_m->get_property_type_id_arr_for_plans();
		$type_id = $type_id['type_id'];

		//$type_id = 2;  // !!!!!!!!!!!!!!!!!

		$region_id = $this->Stripe_m->get_stripe_region_id();

		if ($this->config->item('hms_stripe_billing_test') == 1) {
		    $table_stripe_plans = "stripe_plans_test";
		} else {
		    $table_stripe_plans = "stripe_plans";
		}

		$sql = "SELECT DISTINCT mcount FROM `global_hotelix`." . $table_stripe_plans . "
				WHERE region_id = $region_id AND type_id = $type_id AND(`mcount` BETWEEN 1 AND 12) ORDER BY mcount";
		$existing_ranges = $this->db->query($sql)->result_array();
		$ranges = array();
		foreach ($existing_ranges as $range) {
			$ranges[$range['mcount']] = $base_ranges[$range['mcount']];
		}
		return $ranges;
    }

    function save_stripe_workshop_settings($data){//застаріла здається, див майстерню
    	$tbl_name = "`stripe_info`";
    	$keys = array("property_type", "stripe_region", "stripe_version");
    	$insert_arr = array();
    	foreach ($keys as $insrting_item) {
    		if (isset($_POST[$insrting_item])){
    			$insert_arr['name'] = $insrting_item;
    			$insert_arr['value'] = $_POST[$insrting_item];
    			$this->frontdesk->db_insert_on_duplicate_key_update($tbl_name, $insert_arr, $keys);
    		}
    	}
    }

    function save_hms_billing_version($data){
    	$this->hotelix_config->set_record("hms_billing_version", $data['hms_billing_version'], 'int');
    }

    function save_stripe_billing_offline($data){
    	$this->hotelix_config->set_record("stripe_billing_offline", $data['stripe_billing_offline'], 'int');
    }

    function save_lock_till_open($data){
    	$this->hotelix_config->set_record("lock_till_open", $data['lock_till_open']);
    }

    function save_hms_property_type4stripe($data){
    	$this->hotelix_config->set_record("hms_property_type4stripe", $data['hms_property_type4stripe'], 'int');
    }

    function save_hms_property_count4stripe($data){
    	$this->hotelix_config->set_record("hms_property_count4stripe", $data['hms_property_count4stripe'], 'int');
    }

    function get_db_plans_data_by_month_count ($month_count) {
   		$type_id_arr = $this->Stripe_m->get_property_type_id_arr_for_plans();
   		$type_id = $type_id_arr['type_id'];
   		$region_id = $this->Stripe_m->get_stripe_region_id();
   		$return_array = array();

   		if ($this->config->item('hms_stripe_billing_test') == 1) {
   		    $table_stripe_plans = "stripe_plans_test";
   		} else {
   		    $table_stripe_plans = "stripe_plans";
   		}
   		if ($type_id == 2){//hotels
   			$sql = "SELECT plan_id, amount, currency, is_premium FROM `global_hotelix`." . $table_stripe_plans . "
   			WHERE `region_id` = $region_id AND  `type_id` = $type_id AND mcount = " . $month_count;
   			$query = $this->db->query($sql);
   			if ($query->num_rows() > 0) {
   				foreach ($query->result() as $row) {
   					switch ($row->is_premium) {
   						case 0:
   							$return_array["standart"]["plan_id"] = $row->plan_id;
   							$return_array["standart"]["is_premium"] = $row->is_premium;
   							$return_array["standart"]["price"] = number_format($row->amount, 2, '.', '');
   							$return_array["standart"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
   							$return_array["standart"]["plan_currency"] = strtoupper($row->currency);
   							break;
   						case 1:
   							$return_array["premium"]["plan_id"] = $row->plan_id;
   							$return_array["premium"]["is_premium"] = $row->is_premium;
   							$return_array["premium"]["price"] = number_format($row->amount, 2, '.', '');
   							$return_array["premium"]["monthly_price"] = number_format($row->amount / $month_count, 2, '.', '');
   							$return_array["premium"]["plan_currency"] = strtoupper($row->currency);
   							break;
   					}
   				}
   			}
   		}
   		if ($type_id == 1){//aparts
   			$sql = "SELECT $table_stripe_plans.plan_id, $table_stripe_plans.currency, stripe_plans_tiers.*
   					FROM `global_hotelix`.$table_stripe_plans
   					JOIN global_hotelix.stripe_plans_tiers ON stripe_plans_tiers.plan_id = $table_stripe_plans.plan_id
   					WHERE `region_id` = $region_id AND  `type_id` = $type_id AND mcount = " . $month_count;
   			$query = $this->db->query($sql);
   			if ($query->num_rows() > 0) {
   				$res_tier_arr = $query->result_array();
   				$tiers_price = $this->Stripe_m->tiers_price($res_tier_arr, $type_id_arr['price_count']);
   				$return_array["standart"]["plan_id"] = $res_tier_arr[0]['plan_id'];
   				$return_array["standart"]["price"] = number_format($tiers_price, 2, '.', '');
   				$return_array["standart"]["monthly_price"] = number_format($tiers_price / $month_count, 2, '.', '');
   				$return_array["standart"]["plan_currency"] = strtoupper($res_tier_arr[0]['currency']);
   			}else{//NO TIRES? ANOMAL
   			}
   		}
//================= врахування скидки (купона) при існуючому кастомері START ==========================
   		$discount = "";
   		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
   		if ($stripe_billing_customer_id != ""){//є кастомер
   			$customer_id = $stripe_billing_customer_id;
   			$secret_key = $this->Stripe_m->get_secret_key();
   			$this->stripe->setApiKey ( $secret_key );
   			$customer_obj = $this->customer->retrieve ($customer_id);
   			$customer = $customer_obj->__toArray(true);
   			if (!is_null($customer['discount'])){
   				$coupon_arr = $customer['discount']['coupon'];
   				if (isset($coupon_arr['id']) && $coupon_arr['id'] != ""){
   					if ($coupon_arr['amount_off'] != ""){//скидка фіксованва
   						$discount = $this->frontdesk->showcurrency(((int)$coupon_arr['amount_off'])/100);
   						$discount_in_percents = false;
   					}else{//скидка відсоткова
   						$discount = (int)$coupon_arr['percent_off'];
   						$discount_in_percents = true;
   					}
   				}
   			}
   		}
   		if ($discount != ""){//була встановлена знижка, отже був кастомер, оновлюєм масив цін
	   		foreach ($return_array as &$plan) {
	   			//наразі виводимо ціну зі знижкою, її і міняємо, в майбутніх планах виводити 3: ціну, ціну зі знижкою, знижку
	   			if($discount_in_percents){
// 	   				$plan['price_with_discount'] = $price_with_discount;
// 	   				$plan['discount'] = $discount;
	   				$plan['price'] = number_format($plan['price']*(1 - $discount / 100), 2, '.', '');
	   				$plan['monthly_price'] = number_format($plan['monthly_price']*(1 - $discount / 100), 2, '.', '');
	   			}else{
	   			//вияснити і доробити коли знижка не відсоткова!!!!!!!!!!!!!!!
// 	   				$plan['price_with_discount'] = $price_with_discount;
// 	   				$plan['discount'] = $discount;
// 	   				$plan['price'] = $plan['price'];
// 	   				$plan['monthly_price'] = $plan['monthly_price'];
	   			}
	   			unset($plan);
	   		}
   		}
//================= врахування скидки (купона) при існуючому кастомері FINAL ==========================
    	return $return_array;
    }

	function get_property_type_id_arr_for_plans() {
		$res_arr = array();

		$res_arr['type_id'] = $this->hotelix_config->get_record("hms_property_type4stripe", "int");
		$res_arr['price_count'] = $this->hotelix_config->get_record("hms_property_count4stripe", "int");

		if ($res_arr['type_id'] == 0) {
		    $res_arr['type_id'] = 2;
		}

		if ($res_arr['type_id'] == 2) {
		    $res_arr['price_count'] = 1;
		}

		if ($res_arr['price_count'] == 0) {
		    $res_arr['price_count'] = 1;
		}

		return $res_arr;

		$property_data = $this->frontdesk_c2->get_property_data ();
		if ($property_data ['hotel_count'] > 0) {
			$res_arr['type_id'] = 2;
			$res_arr['price_count'] = 1;
		} else {
			$res_arr['type_id'] = 1;
			$res_arr['price_count'] = $property_data['apart_count'];
		}
		return $res_arr;
	}

	function get_property_region_id_for_plans() {
		$country = $this->frontdesk->get_visitka_id_country_3c();
		$region_id = $this->db->get_where('global_fms_base.dict_country', array('id' => $country))->row()->region_id;
		if ($region_id == 0){
			$region_id = 17;//International Market(USD)
		}
		return $region_id;
	}

	function get_stripe_region_id() {
	    $region_id = 4;
	    $region_id = $this->hotelix_config->get_record("stripe_region_id", "int");
	    if ($region_id == 0) $region_id = 4;
	    return $region_id;
	}

	function tiers_price($arr, $top){
		$unit_amount_array=array();
		$flat_amount_array= array();
		$sum=0;
		$start = 1;
		foreach ($arr as $k=>$v){
			for ($x=$start;$x <= $v['up_to'];$x++){
				$unit_amount_array[$x]=$v["unit_amount"];
			}
			$start = $v['up_to'] + 1;
			$flat_amount_array[$v['up_to']] = $v["flat_amount"];
		}
		for ($x=1;$x<=$top;$x++){
			$sum+=$unit_amount_array[$x];
			if(isset($flat_amount_array[$x])){
				$sum+=$flat_amount_array[$x];
			}
		}
	    return $sum;
	}

	function add_pay_method($stripe_token) {
		$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$secret_key = $this->Stripe_m->get_secret_key();
		$this->stripe->setApiKey ( $secret_key );
		$customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
		try {
			$new_source = $customer_obj->sources->create(array("source" => $stripe_token));
		} catch ( \Stripe\Error\Card $e ) {
			$this->session->set_userdata ( array('header_msg' => 110) );
			$body = $e->getJsonBody();
			$error = $body['error']['decline_code'];
			echo "<script>console.log( 'decline_code: ".$error."' );</script>";
		}
		if (isset($new_source['id'])){
			return $new_source['id'];
		}else{
			return null;
		}
	}

	function get_opened_invoices () {
		$customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id", "str");
		$secret_key = $this->Stripe_m->get_secret_key();
		$this->stripe->setApiKey ( $secret_key );
		$limit = 100;
		$all_invoices = array();
		$current_list = $this->invoice->all ( array (
				"customer" => $customer_id,
				"limit" => $limit,
// 				"created" => array (
// 						"gte" => $start_date_timestamp,
// 						"lte" => $end_date_timestamp
// 				)
		) );
		$current_list = $current_list->__toArray(true);
		$all_invoices = array_merge($all_invoices, $current_list['data']);
		while ($current_list['has_more']){
			$starting_after = $current_list['data'][$limit-1]['id'];
			$current_list = $this->invoice->all ( array (
					"customer" => $customer_id,
					"starting_after" => $starting_after,
					"limit" => $limit,
// 					"created" => array (
// 							"gte" => $start_date_timestamp,
// 							"lte" => $end_date_timestamp
// 					)
			) );
			$current_list = $current_list->__toArray(true);
			$all_invoices = array_merge($all_invoices, $current_list['data']);
		};
		$opened_invoices_arr = array();
		foreach ($all_invoices as $invoice) {
			if ($invoice ['status'] == 'open'){
				array_push ( $opened_invoices_arr, array (
						'id' => $invoice ['id'],
						'number' => $invoice ['number'],
						'amount_total' => (int)$invoice ['total'] / 100 ,
						'amount_paid' => (int)$invoice ['amount_paid'] / 100 ,
						'amount_due' => ( int ) $invoice ['amount_due'] / 100 ,
						'created' => date ( "Y-m-d H:i", $invoice ['created'] ),
						'currency' => strtoupper ( $invoice ['currency'] ),
						'description' => $invoice ['description'],
						'status' => $invoice ['status']
				) );
			}
		}
		return $opened_invoices_arr;
	}

	function pay_invoice($invioce_id) {
		$secret_key = $this->Stripe_m->get_secret_key();
		$this->stripe->setApiKey($secret_key);
		try {
			$invoice = $this->invoice->retrieve($invioce_id);
			$invoice->pay();
			$this->hms_routing_m->check_states_set_routing();
// 			$this->check_expired_invioces_set_states();//previous function, to delete
		} catch ( \Stripe\Error\Card $e ) {
			$this->session->set_userdata ( array (
					'header_msg' => 110
			) );
		}
	}

	function check_expired_invioces_set_states() {//previous function, to delete
		$has_exiped_invoices = $this->hotelix_config->get_record("stripe_has_exiped_invoices", "int");
		$expired_days = $this->hotelix_config->get_record("stripe_opened_invoices_expired_days", "int");
		if ($expired_days == 0){
			$expired_days = 3;
		}
		$hms_allowed = $this->hotelix_config->get_record("hms_allowed", "int");
		if ($has_exiped_invoices > 0 && $hms_allowed == 0){
			$no_expired_invoices = true;
			$opened_invoices = $this->Stripe_m->get_opened_invoices();
			if (count($opened_invoices) > 0){
				$this->hotelix_config->set_record("stripe_has_opened_invoices",  1, "int");
				$expired_date = strtotime("-$expired_days days");
				foreach ($opened_invoices as $invoice) {
					if(strtotime($invoice['created']) <= $expired_date){
						$no_expired_invoices = false;
						break;
					};
				}
			}else{
				$this->hotelix_config->set_record("stripe_has_opened_invoices",  0, "int");
			}
			if ($no_expired_invoices) {
				$this->hotelix_config->set_record ( "hms_allowed", 1, "int" );
				$this->hotelix_config->set_record ( "stripe_has_exiped_invoices", 0, "int" );
				$this->hotelix_config->set_record ( "hms_route", "stripe_rate" );
			}
		}
	}

	function make_adjustment($data) {
		$secret_key = 'sk_live_iE2mMoPUDp3VxXlAbEjEnXA0';
		$this->stripe->setApiKey($secret_key);
		$local_tbl = "`hotelix_config`";
		$customer_id = $this->db->get_where($local_tbl, ['name' => "stripe_billing_customer_id"])->row();
		$response = [];
		if (empty($customer_id)){
			$hms_id = $data['hms_id'];
			$sql = "SELECT * FROM `global_hotelix_stripe`.`ajustment4customers` WHERE hms_id = $hms_id";
			$ajustment = $this->db->query($sql)->row();
			if (!empty($ajustment)){
				$coupon = $ajustment->coupon;
				$billing = $ajustment->billing;
				$amount = $ajustment->amount;
				$param = ['hms_id'=>$hms_id, 'host'=>$data['host']];
				if ($coupon != ""){
					$param['coupon']=$coupon;
				}
				$customer_arr = $this->create_customer($param);
				if (isset($customer_arr['id'])){
					$customer_id = $customer_arr['id'];
					$inserting_arr = ['name' => 'stripe_billing_customer_id', 'str_value' => "$customer_id"];
					$this->db->insert($local_tbl, $inserting_arr);
					$this->db->delete($local_tbl, ['name' => 'stripe_billing_offline']);
					$inserting_arr = ['name' => 'stripe_billing_offline', 'value' => ($billing == 1) ? 1 : 0];
					$this->db->insert($local_tbl, $inserting_arr);
					$this->db->delete($local_tbl, ['name' => 'lock_till_open']);
					$this->db->insert($local_tbl, ['name'=>'lock_till_open', 'str_value'=>'2019-07-26']);
					$this->db->delete($local_tbl, ['name' => 'hms_allowed']);
					$this->db->insert($local_tbl, ['name'=>'hms_allowed', 'value'=>0]);
					$this->db->delete($local_tbl, ['name' => 'hms_billing_version']);
					$this->db->insert($local_tbl, ['name'=>'hms_billing_version', 'value'=>2]);

					$response = $this->customer->createBalanceTransaction ( $customer_id, [
							'amount' => $amount,
							'currency' => "RUB"
							] );
					$response = $response->__toArray(true);
				}
			}
		}
		return $response;
	}

	function make_adjustment_wasted($data) {
		$secret_key = 'sk_live_iE2mMoPUDp3VxXlAbEjEnXA0';
		$this->stripe->setApiKey($secret_key);
		$local_tbl = "`hotelix_config`";
		$customer_id = $this->db->get_where($local_tbl, ['name' => "stripe_billing_customer_id"])->row();
		$response = [];
		if (!empty($customer_id)){
			$hms_id = $data['hms_id'];
			$sql = "SELECT * FROM `global_hotelix_stripe`.`ajustment4customers` WHERE hms_id = $hms_id";
			$ajustment = $this->db->query($sql)->row();
			if (!empty($ajustment)){
				$coupon = $ajustment->coupon;
				$billing = $ajustment->billing;
				$amount = $ajustment->amount;
				if ($coupon != ""){
					$this->customer->update($customer_id, ['coupon'=>$coupon]);
				}
				$this->db->delete($local_tbl, ['name' => 'stripe_billing_offline']);
				$inserting_arr = ['name' => 'stripe_billing_offline', 'value' => ($billing == 1) ? 1 : 0];
				$this->db->insert($local_tbl, $inserting_arr);
				$this->db->delete($local_tbl, ['name' => 'lock_till_open']);
				$this->db->insert($local_tbl, ['name'=>'lock_till_open', 'str_value'=>'2019-07-26']);
				$this->db->delete($local_tbl, ['name' => 'hms_allowed']);
				$this->db->insert($local_tbl, ['name'=>'hms_allowed', 'value'=>0]);
				$this->db->delete($local_tbl, ['name' => 'hms_billing_version']);
				$this->db->insert($local_tbl, ['name'=>'hms_billing_version', 'value'=>2]);
				$response = $this->customer->createBalanceTransaction ( $customer_id, [
					'amount' => $amount,
					'currency' => "RUB"
				] );
				$response = $response->__toArray(true);
			}
		}
		return $response;
	}
}