//https://echarts.apache.org/examples/en/
let Charts = {
		Ages : echarts.init(document.getElementById('chart_by_ages')),
		Check : echarts.init(document.getElementById('chart_by_avg_check')),
		GenderShift : echarts.init(document.getElementById('chart_by_gender_shift')),
		Gender : echarts.init(document.getElementById('chart_by_gender')),
		//ChildrenShift : echarts.init(document.getElementById('chart_by_children_shift')),
		//Children : echarts.init(document.getElementById('chart_by_children')),
		Stay : echarts.init(document.getElementById('chart_by_avg_stay')),
		//Citizenship : echarts.init(document.getElementById('chart_by_citizenship')),
		Rooms : echarts.init(document.getElementById('chart_by_rooms'))
}

Object.values(Charts).forEach((Chart) => Chart.showLoading());
setTimeout(() => {
	Object.values(Charts).forEach((Chart) => Chart.hideLoading());
	Charts.Ages.resize({
		  height: 400
		});
	Charts.Ages.setOption({
		tooltip: {},
		legend: {
		 data: ChartsData.Ages.legend
		},
		xAxis: {
		 data: ChartsData.Ages.xData
		},
		yAxis: {
			type : 'value',
			axisLabel: {
				formatter: '{value}%'
			}
		},
		series: [
		 {
		   name: ChartsData.Ages.legend[0],
		   type: 'bar',
		   barGap: 0.1,
		   label: {
		        show: true,
		        position: 'top',
		        formatter: '{c}%'
		      },
		   data: ChartsData.Ages.series_data.base
		 },
		 {
		   name: ChartsData.Ages.legend[1],
		   type: 'bar',
		   label: {
		        show: true,
		        position: 'top',
		        formatter: '{c}%'
		      },
		   data: ChartsData.Ages.series_data.shift
		 }
		]
	});

	Charts.Stay.resize({
		  height: 400
		});
	Charts.Stay.setOption({
		tooltip: {},
		legend: {
		 data: ChartsData.Stay.legend
		},
		xAxis: {
		 data: ChartsData.Stay.xData
		},
		yAxis: {
			type : 'value',
			axisLabel: {
				formatter: '{value}'
			}
		},
		series: [
		 {
		   name: ChartsData.Stay.legend[0],
		   type: 'bar',
		   barGap: 0.1,
		   label: {
		        show: true,
		        position: 'top',
		      },
		   data: ChartsData.Stay.series_data.base
		 },
		 {
		   name: ChartsData.Stay.legend[1],
		   type: 'bar',
		   label: {
		        show: true,
		        position: 'top',
		      },
		   data: ChartsData.Stay.series_data.shift
		 }
		]
	});

	Charts.Check.resize({
		  height: 400
		});
	Charts.Check.setOption({
		tooltip: {},
		legend: {
		 data: ChartsData.Check.legend
		},
		xAxis: {
		 data: ChartsData.Check.xData
		},
		yAxis: {
			type : 'value',
			axisLabel: {
				formatter: '{value}'
			}
		},
		series: [
		 {
		   name: ChartsData.Check.legend[0],
		   type: 'bar',
		   barGap: 0.1,
		   label: {
		        show: true,
		        position: 'top',
		      },
		   data: ChartsData.Check.series_data.base
		 },
		 {
		   name: ChartsData.Check.legend[1],
		   type: 'bar',
		   label: {
		        show: true,
		        position: 'top',
		      },
		   data: ChartsData.Check.series_data.shift
		 }
		]
	});

	Charts.GenderShift.resize({
		  height: 400
		});
	Charts.Gender.resize({
		  height: 400
		});
	Charts.GenderShift.setOption({
		title: {
		    text: ChartsData.GenderShift.titletext,
		    top: '5%',
		    left: 'center'
		  },
		tooltip: {
		    trigger: 'item'
		  },
		  legend: {
			  top: '40%',
			  right: '10%',
			  orient: '',
		  },
		  series: [
		    {
		      type: 'pie',
		      radius: ['25%', '70%'],
		      avoidLabelOverlap: false,
		      label: {
		        show: false,
		        position: 'center'
		      },
		      /*emphasis: {
		        label: {
		          show: true,
		          fontSize: '40',
		          fontWeight: 'bold'
		        }
		      },
		      labelLine: {
		        show: false
		      },*/
		      data: ChartsData.GenderShift.series_data
		    }
		  ]
	});

	Charts.Gender.setOption({
		title: {
		    text: ChartsData.Gender.titletext,
		    top: '5%',
		    left: 'center'
		  },
		tooltip: {
		    trigger: 'item'
		  },
		  legend: {
			  top: '40%',
			  right: '10%',
			  orient: '',
		  },
		  series: [
		    {
		      type: 'pie',
		      radius: ['25%', '70%'],
		      avoidLabelOverlap: false,
		      label: {
		        show: false,
		        position: 'center'
		      },
		      /*emphasis: {
		        label: {
		          show: true,
		          fontSize: '40',
		          fontWeight: 'bold'
		        }
		      },*/
		      labelLine: {
		        show: false
		      },
		      data: ChartsData.Gender.series_data
		    }
		  ]
	});

	let Roomsoptions = {
			  tooltip: {
			    trigger: 'axis',
			    axisPointer: {
			      type: 'shadow'
			    },
			    showContent: false
			  },
			  legend: {
//				type: 'scroll',
//			    orient: 'vertical',
//			    right: 10,
//				top: 'auto',
//				bottom: 'auto',
////				  orient: '',
////				  right: '1%',
////				  top: '25%'
			  },

			  yAxis: {
			    type: 'value',
			    axisLabel: {
					formatter: '{value}%'
				},
				max: 100
			  },
			  xAxis: {
			    type: 'category',
			    data: ChartsData.Rooms.xData
			  },
			  series: []
			};
	ChartsData.Rooms.series_data.base.forEach(set => {
		Roomsoptions.series.push(
				{
			      itemStyle: {},
			      name: set.name,
			      type: 'bar',
			      stack: set.stack,
			      label: {
			        show: true,
			        formatter: '{c}%'
			      },
			      emphasis: {
			        focus: 'series'
			      },
			      data: set.data
			    }
			);
	});
	ChartsData.Rooms.series_data.shift.forEach(set => {
		Roomsoptions.series.push(
				{
			      itemStyle: {
			        opacity: 0.6
			      },
			      name: set.name,
			      type: 'bar',
			      stack: set.stack,
			      label: {
			        show: true,
			        formatter: '{c}%'
			      },
			      emphasis: {
			        focus: 'series'
			      },
			      data: set.data
			    }
			);
	});
	Charts.Rooms.resize({
		  height: 500
		});
	Charts.Rooms.setOption(Roomsoptions);

	google.charts.setOnLoadCallback(drawRegionsMap);
}, 1000);

google.charts.load('current', {'packages':['geochart']});


  function drawRegionsMap() {
    let data = google.visualization.arrayToDataTable(ChartsData.Citizenship);
    let options = {
    		//region: 150,
    		geochartVersion: 10,
    		height: 500
    };
    let Citizenship = new google.visualization.GeoChart(document.getElementById('chart_by_citizenship'));
    $('#chart_by_citizenship_legend').removeClass('d0');
    Citizenship.draw(data, options);
  }