﻿$('.kkm_overlay_btn').on('click', function(){
	$('.kkm_overlay').css('display','none');
	$('#reopen_session_btn').remove();
});
window.addEventListener('unhandledrejection', function(e) {
	ConsoleLogDebug && console.log(e);
});
const ConsoleLogDebug = true;
const DebudMode = true;
const DebudModeEXECUTE = true;
const KKmTimeoutRequest = 1000;//2000


let ResolvingTimeout = 0;
if (DebudMode) ResolvingTimeout = 1000;
const SessionStatesTxt = ['', ' закрыта', ' открыта', ' открыта, но закончилась'];

function Register_Fiscal_Check(Data){
	$('.kkm_loader').removeClass('d0');
  return new Promise (function(resolve, reject){
	  Get_Cashier_Data_With_Ajax(Data)
	  .then(Explore_Kkm_Device_Session_State)
	  .then(Session_Sequence)
	  .then(Data => {Data.IdCommand = guid(); return Data})
	  .then(Get_Check_Strings_With_Ajax)
	  .then(Print_Check)
	  .then(GetDataCheck)
	  .then(Data => resolve(Data))
	  .catch(function (err) {
		  ConsoleLogDebug && console.log('Catched in Register_Fiscal_Check', err);
		  reject(err);
		})
	  .finally(() => $('.kkm_loader').addClass('d0'));
  });
}

function GetDataCheck(Data) {
	const CommandData = {
			Command: 'GetDataCheck',
			IdDevice: Data.SelectedDevice.Id,
			FiscalNumber: Data.PrintResult.CheckNumber,
			NumberCopies: 0,// Количество копий документа (копии печатаются на ленте)
			IdCommand: guid(),
	};
	DebudMode &&$('.kkm_overlay_text').html('Получение копии чека по ФН...');
	return new Promise(function (resolve, reject) {
		setTimeout(() => {
			ExecuteCommand_on_KKM(CommandData)
			.then(Analyze_KKM_Responce)
			.then(GetDataCheckResult => {
				if (!GetDataCheckResult.Error){
					DebudMode && $('.kkm_overlay_text').html('Копия получена.');
					Data.GetDataCheckResult = GetDataCheckResult;
					setTimeout(() => resolve(Data), ResolvingTimeout);
				}else{
					reject('Ошибка получения копии чека:', Error);
				}
			})
			.catch(function (err) {
				ConsoleLogDebug && console.log('Catched in Explore_Kkm_Device_Session_State', err);
				reject(err);
			});
		}, ResolvingTimeout);
	});
}

function Print_Check(Data) {
	DebudMode &&$('.kkm_overlay_text').html('Печать чека...');
	return new Promise(function (resolve, reject) {
		setTimeout(() => {
			ExecuteCommand_on_KKM(Data.CheckStrings)
			.then(Analyze_KKM_Responce)
			.then(PrintResult => {
				if (!PrintResult.Error){
					DebudMode && $('.kkm_overlay_text').html('Чек успешно напечатан.');
					Data.PrintResult = PrintResult;
					setTimeout(() => resolve(Data), ResolvingTimeout);
				}else{
					reject(`<p>Ошибка печати чека:</p><p>${PrintResult.Error}</p>`);
				}
			})
			.catch(function (err) {
				ConsoleLogDebug && console.log('Catched in Explore_Kkm_Device_Session_State', err);
				reject(err);
			});
		}, ResolvingTimeout);
	});
}
function Get_Check_Strings_With_Ajax(Data){
	DebudMode &&$('.kkm_overlay_text').html('Формирование чека...');
	return new Promise(function(resolve, reject) {
		 $.ajax({
	       type: 'POST',
	       url: '/kkm/ajax_Get_Check_Strings_best',//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	       data: Data,
	       dataType: 'json',
	       success: function(GetCheckStringsResult){
	    	   if (GetCheckStringsResult.errors.length){
	    		   let err_str = '<p>Ошибки при формировании чека:</p>';
					$.each( GetCheckStringsResult.errors, function( index, error ){
						ConsoleLogDebug && console.log('Ошибки чека: ', error, index);
						err_str += `<p>${index+1}) ${error.msg}</p>`;
					});
					setTimeout(() => reject(err_str), ResolvingTimeout);
				}else{
					setTimeout(() => {
						DebudMode && $('.kkm_overlay_text').html('Чек успешно сформирован.');
						Data.CheckStrings = GetCheckStringsResult.check;
						setTimeout(() => resolve(Data), ResolvingTimeout);
					}, ResolvingTimeout);
				}
			},
			error: function (xhrObj, textStatus, err){
				reject('Ошибка получения строк чека!'+err);
			}
		});
	});
}

function Explore_Kkm_Device_Session_State(Data) {
	console.log(Data);
	DebudMode &&$('.kkm_overlay_text').html(`Проверка состояния устройства ${Data.SelectedDevice.Name}`);
	return new Promise(function (resolve, reject) {
		const CommandData = {
				Command: 'GetDataKKT',
				NumDevice: 0, // Номер устройства. Если 0 то первое не блокированное на сервере
				IdDevice: Data.SelectedDevice.Id || (()=>{throw 'Устройство не выбрано!'})(),
				IdCommand: guid(),
		};
		console.log(CommandData);
		setTimeout(() => {
			ExecuteCommand_on_KKM(CommandData)
			.then(Analyze_KKM_Responce)
			.then(Result => {
				if (!Result.Error){
					DebudMode && $('.kkm_overlay_text').html('Проверка завершена.');
					Data.Session = {Number : Result.SessionNumber, State : Result.Info.SessionState, CheckNumber : Result.CheckNumber}
					setTimeout(() => resolve(Data), ResolvingTimeout);
				}else{
					reject(Result.Error.replace(/\(.+\)/, Data.SelectedDevice.Name));
				}
			})
			.catch(function (err) {
				ConsoleLogDebug && console.log('Catched in Explore_Kkm_Device_Session_State', err);
				reject(err);
			});
		}, ResolvingTimeout);
	})
}
function Session_Sequence(Data){
	ConsoleLogDebug && console.log('Data IN Start Session_Sequence: ', Data);
	return new Promise(function(resolve, reject) {
		const SessionState = Data.Session.State;//3;//
		Data.Session.SequenceProcess =  `Start with SessionState: ${SessionState}; `;
		DebudMode && $('.kkm_overlay_text').html(`<p>Устройство ${Data.SelectedDevice.Name}</p><p>Смена ${SessionStatesTxt[SessionState]}</p><p>Касcир: ${Data.Cashier.name}</p>`);
		if (SessionState !== 2){// Статус сессии 1-Закрыта, 2-Открыта, 3-Открыта, но закончилась (3 статус на старых ККМ может быть не опознан)
			$('.kkm_loader').addClass('d0');
			const session_btn_txt = SessionState == 3 ? 'Закрыть и открыть смену?' : 'Открыть смену?';
			$('.kkm_overlay').append(`<button id='reopen_session_btn'>${session_btn_txt}</button><button id='dissmiss_reopen_btn'>Ньенадо</button>`);
			$('#reopen_session_btn').on('click', function(){
				$('.kkm_loader').removeClass('d0')
				$('#reopen_session_btn').remove();
				$('#dissmiss_reopen_btn').remove();
				if (SessionState === 1) {
					Open_Session(Data)
					.then(Data => resolve(Data))
					.catch(function (err) {
						ConsoleLogDebug && console.log('Catched in Session_Sequence Open Session', err);
						reject(err);
					});
				}
				if (SessionState === 3) {
					Close_Session(Data)
					.then(Open_Session)
					.then(Data => resolve(Data))
					.catch(function (err) {
						ConsoleLogDebug && console.log('Catched in Session_Sequence Close + Open Session', err);
						reject(err);
					});
				}
			});
			$('#dissmiss_reopen_btn').on('click', function(){
				reject('Выбрать другое устройство?');
				$('#reopen_session_btn').remove();
				$('#dissmiss_reopen_btn').remove();
			});
		}else{
			Data.Session.SequenceProcess += `Then Session Okay SessionState: ${SessionState} `;
			setTimeout(() => resolve(Data), ResolvingTimeout);
		}
	});
}
function Close_Session(Data) {
	DebudMode && $('.kkm_overlay_text').html('<p>Закрытие смены...</p><p>Касcир: ' + Data.Cashier.name + '</p>');
	return new Promise(function (resolve, reject) {
		let ShiftComandData = {
				Command: 'CloseShift',
				IdDevice: Data.SelectedDevice.Id,
				CashierName: Data.Cashier.name, // Продавец, тег ОФД 1021
				CashierVATIN: Data.Cashier.vatin, // ИНН продавца тег ОФД 1203
				NotPrint: true, // Не печатать чек на бумагу
				IdCommand: guid(),
		};
		setTimeout(() => {
			ExecuteCommand_on_KKM(ShiftComandData)
			.then(Analyze_KKM_Responce)
			.then(CloseShiftResult => {
				ConsoleLogDebug && console.log('Close_Session Result after CloseShiftCommand ', CloseShiftResult);
				if (CloseShiftResult.Error != undefined && CloseShiftResult.Error != '') {
					Data.Session.SequenceProcess = CloseShiftResult.Error;
					reject('<p>Устройство: ' + Data.SelectedDevice.Name + '</p>' + CloseShiftResult.Error);
				} else {
					DebudMode && $('.kkm_overlay_text').html('<p>Смена закрыта</p><p>Касcир: ' + Data.Cashier.name + '</p>');
					Data.Session.Number = CloseShiftResult.SessionNumber;
					Data.Session.CheckNumber = CloseShiftResult.CheckNumber;
					Data.Session.SequenceProcess += 'Then Session was Closed; ';
					return new Promise(function(resolve, reject) {setTimeout(() => resolve({request : ShiftComandData, responce : CloseShiftResult}), ResolvingTimeout)});
				}
			})
			.then(Log_KKM_Shift_operation)
			.then(() => setTimeout(() => resolve(Data), ResolvingTimeout))
			.catch(function (err) {
				ConsoleLogDebug && console.log('Catched in Close_Session', err);
				reject(err);
			});
		}, ResolvingTimeout)
	});
}
function Open_Session(Data) {
	DebudMode && $('.kkm_overlay_text').html('<p>Открытие смены...</p><p>Касcир: ' + Data.Cashier.name + '</p>');
	return new Promise(function (resolve, reject) {
		let ShiftComandData = {
				Command: 'OpenShift',
				IdDevice: Data.SelectedDevice.Id,
				CashierName: Data.Cashier.name, // Продавец, тег ОФД 1021
				CashierVATIN: Data.Cashier.vatin, // ИНН продавца тег ОФД 1203
				NotPrint: true, // Не печатать чек на бумагу
				IdCommand: guid(),
		};
		setTimeout(() => {
			ExecuteCommand_on_KKM(ShiftComandData)
			.then(Analyze_KKM_Responce)
			.then(OpenShiftResult => {
				ConsoleLogDebug && console.log('Open_Session Result after OpenShiftCommand ', OpenShiftResult);
				if (OpenShiftResult.Error != undefined && OpenShiftResult.Error != '') {
					Data.Session.SequenceProcess = OpenShiftResult.Error;
					reject('<p>Устройство: ' + Data.SelectedDevice.Name + '</p>' + OpenShiftResult.Error);
				} else {
					DebudMode && $('.kkm_overlay_text').html('<p>Смена открыта</p><p>Касcир: ' + Data.Cashier.name + '</p>');
					Data.Session.Number = OpenShiftResult.SessionNumber;
					Data.Session.CheckNumber = OpenShiftResult.CheckNumber;
					Data.Session.SequenceProcess += 'Then Session was Opened; ';
					return new Promise(function(resolve, reject) {setTimeout(() => resolve({request : ShiftComandData, responce : OpenShiftResult}), ResolvingTimeout)});
					//setTimeout(() => Promise.resolve(Data), ResolvingTimeout);
				}
			})
			.then(Log_KKM_Shift_operation)
			.then(() => setTimeout(() => resolve(Data), ResolvingTimeout))
			.catch(function (err) {
				ConsoleLogDebug && console.log('Catched in Open_Session', err);
				reject(err);
			});
		}, ResolvingTimeout)
	});
}
function Log_KKM_Shift_operation (Data){
	ConsoleLogDebug && console.log('Log_KKM_Shift_operation outProm ------', Data);
	DebudMode && $('.kkm_overlay_text').html('Сохранение данных смены...');
	return new Promise(function(resolve, reject) {
		$.ajax({
			dataType: 'json',
			url: "/kkm/ajax_Log_KKM_Operation",
			type : "POST",
			data: Data,
			success: function (Res_from_hms) {
				setTimeout(() => {
					DebudMode && $('.kkm_overlay_text').html('Данные смены успешно сохранены.');
					setTimeout(() => resolve(Res_from_hms), ResolvingTimeout);
				}, ResolvingTimeout);
				//resolve(Res_from_hms);
			},
			error: function (xhrObj, textStatus, err){
				reject('Error Shiftoperation HMS Saving!'+err);
			}
		});
	});
}
function Get_Cashier_Data_With_Ajax(Data){

	return new Promise(function(resolve, reject) {
		DebudMode && $('.kkm_overlay_text').html('Получение данных касира...');
		$.ajax({
			type: 'POST',
			url: '/kkm/ajax_get_cashier_data',
			data: {},
			dataType: 'json',
			success: function(response, statusText, xhrObj){
				setTimeout(() => {
				if(DebudMode) $('.kkm_overlay_text').html(`<p>Kасир: ${response.name}</p><p>ИНН: ${response.vatin}</p>`);
				Data.Cashier = response;
				setTimeout(() => resolve(Data), ResolvingTimeout);
				}, ResolvingTimeout);
	   	    },
	   	    error: function(xhrObj, textStatus, err){
	   	    	reject(xhrObj)
	   	    }
		});
	});
}




function ExecuteCommand_on_KKM (Data, Execute_Path = 'AddIn', timeout) {
//////////////////////////////////////////////////////////////////////////////////////////
// Вызов команды на сервере KKM-----------------------------------------------------------
//////////////////////////////////////////////////////////////////////////////////////////
	return new Promise(function(resolve, reject) {
		DebudModeEXECUTE && $('.kkm_overlay_text').html('<p>Запрос к серверу ККМ</p>');
		if (typeof(KkmServer) !== 'undefined' && Execute_Path !== 'Server') {//Проверка стоит ли расширение, и если стоит то отправка через расширение
			try {
				DebudModeEXECUTE && $('.kkm_overlay_text p').append(' через РАСШИРЕНИЕ браузера');
	    		window.setTimeout(function(){

		        if (typeof (Data) == "string") Data = JSON.parse(Data);// Если данные - строка JSON конвентируем в объект
	        	KkmServer.Execute(function(response, statusText, xhrObj){resolve(response)}, Data);// Выполняем команду через расширение
		        return; //Возврат - вызов по Http не нужен

	    		}, KKmTimeoutRequest);
			}catch {
	   	    	reject('ERROR IN ExecuteCommand_on_KKM');
			}
		};
		// Если нет расширения - далее отправляем команду по http
		var UrlServer = ( typeof KKMS_Server_Url !== 'undefined') ? KKMS_Server_Url : "https://localhost:5893";
		var User = "User"; // Пользователь доступа к серверу торгового оборудования
		var Password = ""; // Пароль доступа к серверу торгового оборудования
		if (timeout == undefined) {
		    timeout = 60000; //Минута - некоторые драйверы при работе выполняют интерактивные действия с пользователем - тогда увеличте тайм-аут.
		}
		if (typeof (Data) != "string") {
			Data = JSON.stringify(Data);
		}
	   	$.support.cors = true;
	   	var request_kkm = $.ajax({
	   	    type: 'POST',
	   	    async: true,
	   	    timeout: timeout,
	   	    url: UrlServer+ '/Execute',// + ((UrlServer == "") ? window.location.protocol + "//" + window.location.host + "/" : "/") + 'Execute',
	   	    crossDomain: true,
	   	    dataType: 'json',
	   	    contentType: 'application/json; charset=UTF-8',
	   	    processData: false,
	   	    data: Data,
	   	    headers: (User !== "" || Password !== "") ? { "Authorization": "Basic " + btoa(User + ":" + Password) } : "",
	   	    success: function(response, statusText, xhrObj){
	   	    	setTimeout(() => resolve(response), KKmTimeoutRequest);
	   	    },//ExecuteSuccess,
	   	    error: function(xhrObj, textStatus, err){
	   	    	reject(new Error('Сервер ККМ не отвечает. Перезапустите сервер.'))//ErrorSuccess
	   	    }

	   	});
	});
}
// Герерация GUID
function guid() {
    function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
}
function Register_Check (Data){
	ExecuteCommand_on_KKM(Data).then(
			function(Register_Check_Success){
				Analyze_KKM_Responce(Register_Check_Success).then(
		    			function(Result_Register_Check){
		    				ConsoleLogDebug && console.log('Result after Analyze_KKM_Responce', Result_Register_Check);
		    				if (!Result_Register_Check.Error){
		    					$('.kkm_overlay_text').html('Чек напечатан...');
		    					window.setTimeout(function(){
		    					$('.kkm_overlay_text').text('Сохранение данных чека в HMS...');
		    					}, 2000);
		    					Result_Register_Check.PaymentID = PaymentID;
		    					Insert_Kkm_Check_With_Ajax(Result_Register_Check).then(
		    							function(Inserting_Kkm_Check_Result){
		    								$('.kkm_overlay_text').text('Чек успешно сохранен в системе. Перезагрузка.');
		    								ConsoleLogDebug && console.log('Чек успешно сохранен в системе.', Inserting_Kkm_Check_Result);
		    								$('.kkm_overlay_btn').off( 'click' );
		    								$('.kkm_overlay_btn').on('click', function(event){
		    									event.stopImmediatePropagation();
		    									location.reload();
		    								});
		    							}
		    					);
		    				}else{
								$('.kkm_overlay_text').html('<p>Ошибка печати...</p>'+Result_Register_Check.Error);/* .responseJSON.Error */
							}
		    			}
		    	);
			},
			function(Register_Check_Error){
				$('.kkm_overlay_text').html('<p>Ошибка печати через сервер...</p>'+Register_Check_Error.responseJSON.Error);
				ConsoleLogDebug && console.log(Register_Check_Error);
			}
	);
}
const ServerResponceStatuses = [
	  {
	    id: 0,
	    txt: '<p>Команда выполненa без ошибок</p>',
	    final: true,
	  },
	  {
	    id: 1,
	    txt: '<p>Команда запущена на выполнение но еще не выполнена</p>',
	    final: false,
	  },
	  {
	    id: 2,
	    txt: '<p>Команда выполнена, есть ошибка</p>',
	    final: true,
	  },
	  {
	    id: 3,
	    txt: '<p>Устройство не найдено или не найдена ранее запущенная команда</p>',
	    final: true,
	  },
	  {
	    id: 4,
	    txt:
	      '<p>Команда еще не запущена на выполнение (ожидание готовности устройства)</p>',
	    final: false,
	  },
	  {
	    id: 5,
	    txt: '<p>Команда уже была выполнена или выполняется в текущий момент</p>',
	    final: false,
	  },
	];

	async function Analyze_KKM_Responce(ServerResponce) {
	  const IdCommand = ServerResponce.IdCommand;
	  let Times = 3;
	  ConsoleLogDebug && console.log(ServerResponceStatuses[ServerResponce.Status].txt, 'Times - ', Times);
	  DebudMode && $('.kkm_overlay_text').html(ServerResponceStatuses[ServerResponce.Status].txt);
	  while (!ServerResponceStatuses[ServerResponce.Status].final && Times > 0) {
	    ServerResponce = await Get_KKM_Command_Result(IdCommand);
	    Times--;
	    DebudMode && $('.kkm_overlay_text').html(ServerResponceStatuses[ServerResponce.Status].txt);
	    ConsoleLogDebug && console.log(ServerResponceStatuses[ServerResponce.Status].txt, 'Times - ', Times);

	  }
	  return new Promise ((resolve, reject) => {
		  setTimeout(() => {
			  if (ServerResponceStatuses[ServerResponce.Status].final){
				  ConsoleLogDebug && console.log('Result after Analyze_KKM_Responce INSIDE Analyze promise === ', ServerResponce);
				  resolve(ServerResponce);
			  }else{
				  resolve({Error: 'Слишком много запросов к серверу ККМ'});
			  }
		  }, ResolvingTimeout);
	  });
	}

	function Get_KKM_Command_Result(IdCommand) {// Вызываем запрос на получение результата с задержкой 2 секунды
		return new Promise(function (resolve, reject) {
			let CommandData = {
					Command: 'GetRezult', // Команда серверу - запрос выполнения команды
					IdCommand: IdCommand, // Уникальный идентификатор ранее поданной команды
			};
			ConsoleLogDebug && console.log('COMMAND DATA: ', CommandData);
			setTimeout(() => {
				ExecuteCommand_on_KKM(CommandData)
				.then(KkmServerResponce => {
					ConsoleLogDebug && console.log('Result IN Get_KKM_Command_Result IdCommand', KkmServerResponce);
					resolve(KkmServerResponce.Rezult);
				});
			}, KKmTimeoutRequest);// Вызываем запрос на получение результата с задержкой 2 секунды
		});
	}