<?php
$pie_slices_limit = 10;
$report_number_threshold = $this->config->item('report_number_threshold');
$system_dateformat = $this->frontdesk->get_systemdateformat();
$picker_dateformat = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata('report_pay_methods_date_range');
if (empty($date_range)) {
    $start_date = date($system_dateformat, strtotime("first day of last month"));
    $end_date = date($system_dateformat, strtotime("last day of last month"));
} else {
    list ($start_date, $end_date) = explode(' - ', $date_range);
    $start_date = date($system_dateformat, strtotime($start_date));
    $end_date = date($system_dateformat, strtotime($end_date));
}
$prev_start_date = date($system_dateformat, strtotime("$start_date -1 year"));
$prev_end_date = date($system_dateformat, strtotime("$end_date -1 year"));
$cur_data = $this->report_model->get_pay_methods_graphycs_data(array(
    'start_date' => $start_date,
    'end_date' => $end_date
));
$prev_data = $this->report_model->get_pay_methods_graphycs_data(array(
    'start_date' => $prev_start_date,
    'end_date' => $prev_end_date
));
// ==================== вирівнювання даних СТАРТ ================
foreach ($cur_data as $method_id => $method_data) {
    if(!isset($prev_data[$method_id])){
        $prev_data[$method_id]['amount'] = 0;
        $prev_data[$method_id]['name'] = $method_data['name'];
    }
}
foreach ($prev_data as $method_id => $method_data) {
    if(!isset($cur_data[$method_id])){
        $cur_data[$method_id]['amount'] = 0;
        $cur_data[$method_id]['name'] = $method_data['name'];
    }
}
// ==================== вирівнювання даних ФІНІШ ================
$pies_parsing_arr = array(
    'methods_cur_labels' => array(),
    'methods_prev_labels' => array(),
    'pie_cur_data' => array(),
    'pie_prev_data' => array(),
);
$parsing_arr = array(
    'pay_methods' => array(),
    'total' => array()
);
$total_cur_amount = 0;
$total_prev_amount = 0;
foreach ($cur_data as $method_id => $method_data) {
    $parsing_arr['pay_methods'][$method_id]['name'] = $method_data['name'];
    $parsing_arr['pay_methods'][$method_id]['redirect_url'] = "/reports_c2/redirect_from_pay_methods?id=$method_id&start_date=$start_date&end_date=$end_date";
    $cur_amount = $method_data['amount'];
    $parsing_arr['pay_methods'][$method_id]['cur_amount'] = number_format($cur_amount, 2, ".", $report_number_threshold);
    $prev_amount = $prev_data[$method_id]['amount'];
    $parsing_arr['pay_methods'][$method_id]['prev_amount'] = number_format($prev_amount, 2, ".", $report_number_threshold);
    $diff_amount = $cur_amount - $prev_amount;
    $parsing_arr['pay_methods'][$method_id]['diff_amount'] = number_format($diff_amount, 2, ".", $report_number_threshold);
    $arrow_class = "d0";
    $diff_percent = 0;
    if ($diff_amount > 0) {
        $arrow_class = 'ion-arrow-up-c green';
        $diff_percent = round(abs($diff_amount / $cur_amount) * 100, 2);
    } elseif ($diff_amount < 0) {
        $arrow_class = 'ion-arrow-down-c red';
        $diff_percent = round(abs($diff_amount / $prev_amount) * 100, 2);
    }
    $parsing_arr['pay_methods'][$method_id]['arrow_class'] = $arrow_class;
    $parsing_arr['pay_methods'][$method_id]['diff_percent'] = number_format($diff_percent, 2);
    $total_cur_amount += $cur_amount;
    $total_prev_amount += $prev_amount;
    if ($cur_amount != 0){
        array_push($pies_parsing_arr['methods_cur_labels'], $method_data['name']);
        array_push($pies_parsing_arr['pie_cur_data'], $cur_amount);
    }
    if ($prev_amount != 0){
        array_push($pies_parsing_arr['methods_prev_labels'], $method_data['name']);
        array_push($pies_parsing_arr['pie_prev_data'], $prev_amount);
    }
}
$cur_amount = $total_cur_amount;
$prev_amount = $total_prev_amount;
$diff_amount = $cur_amount - $prev_amount;
$arrow_class = "d0";
$diff_percent = 0;
if ($diff_amount > 0) {
    $arrow_class = 'ion-arrow-up-c green';
    $diff_percent = round(abs($diff_amount / $cur_amount) * 100, 2);
} elseif ($diff_amount < 0) {
    $arrow_class = 'ion-arrow-down-c red';
    $diff_percent = round(abs($diff_amount / $prev_amount) * 100, 2);
}
$parsing_arr['total'] = array(
    array(
        'cur_amount' => number_format($cur_amount, 2, ".", $report_number_threshold),
        'prev_amount' => number_format($prev_amount, 2, ".", $report_number_threshold),
        'diff_amount' => number_format($diff_amount, 2, ".", $report_number_threshold),
        'diff_percent' => number_format($diff_percent, 2),
        'arrow_class' => $arrow_class
    )
);
foreach ($pies_parsing_arr['pie_cur_data'] as $key => $amount) {
    $pies_parsing_arr['pie_cur_data'][$key] = round(($amount / $total_cur_amount) * 100, 2);
}
foreach ($pies_parsing_arr['pie_prev_data'] as $key => $amount) {
    $pies_parsing_arr['pie_prev_data'][$key] = round(($amount / $total_prev_amount) * 100, 2);
}
$data = array();
foreach ($pies_parsing_arr as $label => $value) {
    $data[$label] = json_encode($value);
}
$data["picker_dateformat"] = $picker_dateformat;
$data["parsing_arr"] = array($parsing_arr);
$data["start_date"] = $start_date;
$data["end_date"] = $end_date;
$data["curr_period"] = "$start_date - $end_date";
$data["prev_period"] = "$prev_start_date - $prev_end_date";
$data["left_menu"] = $this->htmltpl->get_left_menu(1, 6);
$data["header"] = $this->htmltpl->getHeader_new();
$data["footer_html"] = $this->htmltpl->getFooter_new();
$this->mlanguages->getdictionary("reports_c2_fraphs", "", $data);
$this->parser->parse('templates/reports_c2/pay_methods_view.html', $data);
?>