<?php
$chs_list_arr = $this->echannel_model->get_echannel_clients_list();


// ----- show channels by country -----
$chs_list_arr = $this->echannel_model->unset_echannel_clients_by_country($chs_list_arr);

$data_access = array('module_name' => 'channel_manager');
$billing_plan_access = $this->Access->get_billing_plan_access($data_access);
// ==== billing plan access end ==========

$channels_data = array();
foreach ($chs_list_arr as $ch_id => $ch_data) {
    $is_active_query_row = $this->db->like('name', 'general_update')
        ->get_where('echannel_clients_data', array('dc_id' => $ch_data['dc_id'], 'name' => 'general_update'))
        ->row();
    $is_active = ($is_active_query_row) ? $is_active_query_row->int_value : 0;
    
    array_push($channels_data, array(
        'ch_id' => $ch_id,
        'short_name' => $ch_data['name'],
        'small_logo' => $ch_data['client_logo'],
        'is_active' => $is_active,
        'ch_edit_url' => "/echannel/clients_edit/".$ch_data['dc_id'],
        'unactive_class' => ($is_active == 1) ? "" : "unactive",
        'is_noactive_class' => ($is_active == 1) ? "d0" : "",
        'is_active_class' => ($is_active == 1) ? "" : "d0"
    ));
}

$data = array();
$menu_data = $this->htmltpl->get_left_settings_menu ( 7, 1 );
$echannel_menu = $this->navigation->get_echannel_menu ( 4 );
$data ["header"] = $this->htmltpl->getHeader_new ();
$data ["footer_html"] = $this->htmltpl->getFooter_new();
$data ["settings_main_menu"] = $menu_data ["main_menu"];
$data ["settings_sub_menu"] = $menu_data ["sub_menu"];
$data ["echannel_menu"] = $echannel_menu;
$data ["channels"] = $channels_data;
$this->mlanguages->getdictionary("chmanager_chanel_list", "", $data);
$this->parser->parse ( 'templates/echannel/clients.html', $data );
?>