<?php
class navigation extends CI_model {
	function __construct() {
		parent::__construct ();
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'frontdesk_c2' );
		$this->load->model ( 'bso_core' );
		$this->load->model ( 'dcm_wubook' );
		$this->load->model ( 'kkm_model' );
		$this->load->model ( 'hotelix_config' );
		$this->load->model ( 'mwizard_c2' );
		$this->load->model ( 'visitka_model' );
	}

	function get_messages_c2_menu($active_id = 1){
	    //$threads_count = $this->messages_model->get_threads_count();
	    $threads_count = $this->messages_model->get_mc_threads_count();
	    $system_msg_count = $this->messages_model->get_system_msg_count();
	    $isread_messages_count = $this->frontdesk->get_count_isread_messages ();

	    $menu_array = array();
	    $navMenuDic = array();
	    $this->mlanguages->getdictionary("mailbox_showmessages", "", $navMenuDic);

	    //$menu_array ["1"] ["name"] = "{clt_system}";
	    $class_count = "";
	    if($system_msg_count == 0 || $system_msg_count < 0){
	        $class_count = "d0";
	    }
	    $menu_array ["1"] ["name"] = $navMenuDic['clt_system'];
	    $menu_array ["1"] ["url"] = "/messages_c2/system_msg_list";
	    $menu_array ["1"] ["class"] = "mail_t_green";
	    $menu_array ["1"] ["class_active"] = "";
	    $menu_array ["1"] ["class_count"] = $class_count;
	    $menu_array ["1"] ["icon"] = "icon_m_system.svg";
	    $menu_array ["1"] ["count"] = $system_msg_count;

	    //$menu_array ["2"] ["name"] = "{clt_support}";
	    $menu_array ["2"] ["name"] = $navMenuDic['clt_support'];
	    $menu_array ["2"] ["url"] = "/messages_c2/support_msgs_list/1";
	    $menu_array ["2"] ["class"] = "mail_t_red";
	    $menu_array ["2"] ["class_active"] = "";
	    $menu_array ["2"] ["class_count"] = "d0";
	    $menu_array ["2"] ["icon"] = "icon_m_support.svg";
	    $menu_array ["2"] ["count"] = 0;

	    //$menu_array ["3"] ["name"] = "{caption_case}";
	    $class_count = "";
	    if($isread_messages_count == 0 || $threads_count < 0){
	        $class_count = "d0";
	    }
	    $menu_array ["3"] ["name"] = $navMenuDic['clt_channels'];
	    $menu_array ["3"] ["url"] = "/messages_c2/channel_msg_list/1";
	    $menu_array ["3"] ["class"] = "mail_t_yellow";
	    $menu_array ["3"] ["class_active"] = "";
	    $menu_array ["3"] ["class_count"] = $class_count;
	    $menu_array ["3"] ["icon"] = "icon_m_group.svg";
	    $menu_array ["3"] ["count"] = $isread_messages_count;

	    //$menu_array ["4"] ["name"] = "{clt_clients}";
	    $class_count = "";
	    if($threads_count == 0 || $threads_count < 0){
	        $class_count = "d0";
	    }
// 	    $menu_array ["4"] ["name"] = $navMenuDic['clt_clients'];
// 	    $menu_array ["4"] ["url"] = "/messages_c2/threads_list/1";
// 	    $menu_array ["4"] ["class"] = "mail_t_blue";
// 	    $menu_array ["4"] ["class_active"] = "";
// 	    $menu_array ["4"] ["class_count"] = $class_count;
// 	    $menu_array ["4"] ["icon"] = "icon_m_people.svg";
// 	    $menu_array ["4"] ["count"] = $threads_count;

	    if ($this->releases->booking_messages() == 1) {
            //$menu_array["5"]["name"] = $navMenuDic['clt_booking_clients'];
//             $menu_array["5"]["name"] = "{clt_booking_clients}";
//             $menu_array["5"]["url"] = "/dc_booking_c2/messages_list";
//             $menu_array["5"]["class"] = "mail_t_blue";
//             $menu_array["5"]["class_active"] = "";
//             $menu_array["5"]["class_count"] = $class_count;
//             $menu_array["5"]["icon"] = "icon_m_people.svg";
//             $menu_array["5"]["count"] = $threads_count;

            $menu_array["6"]["name"] = $navMenuDic['clt_clients'];
            $menu_array["6"]["url"] = "/messages_c2/channel_mc";
            $menu_array["6"]["class"] = "mail_t_blue";
            $menu_array["6"]["class_active"] = "";
            $menu_array["6"]["class_count"] = $class_count;
            $menu_array["6"]["icon"] = "icon_m_people.svg";
            $menu_array["6"]["count"] = $threads_count;
        }


	    if(isset($menu_array[$active_id])){
	        $menu_array[$active_id]['class_active'] = "active";
	    }
	    return $menu_array;
	}

	function get_wizard_fms_tools_menu($contry = ""){
		if ($contry!= ""){
			$contry .= "_";
		}
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);

		$menu_array ["1"] ["name"] = "Граждантсво";
		$menu_array ["1"] ["name"] = $navMenuDic['caption_fms_citizenship'];
		$menu_array ["1"] ["url"] = "/wizard_fms_tools/".$contry."step1";
		$menu_array ["1"] ["class"] = "";

		$menu_array ["2"] ["name"] = "Документ удостоверяющий личность";
		$menu_array ["2"] ["name"] = $navMenuDic['caption_identity_document'];
		$menu_array ["2"] ["url"] = "/wizard_fms_tools/".$contry."step2";
		$menu_array ["2"] ["class"] = "";

		$menu_array ["3"] ["name"] = "Персональные данные";
		$menu_array ["3"] ["name"] = $navMenuDic['caption_personaldata'];
		$menu_array ["3"] ["url"] = "/wizard_fms_tools/".$contry."step3";
		$menu_array ["3"] ["class"] = "";

		$menu_array ["4"] ["name"] = "Регистрация";
		$menu_array ["4"] ["name"] = $navMenuDic['caption_fms_registration'];
		$menu_array ["4"] ["url"] = "/wizard_fms_tools/".$contry."step4";
		$menu_array ["4"] ["class"] = "";

		return $menu_array;
	}
	function get_wizard_fms_menu($reservation_id, $guest_id){
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);
		$this->mlanguages->getdictionary("reservations_reservationviewform", "", $navMenuDic);

		$menu_array ["1"] ["name"] = "Граждантсво";
		$menu_array ["1"] ["name"] = $navMenuDic['caption_fms_citizenship'];
		$menu_array ["1"] ["url"] = "/wizard_fms/step1";
		$menu_array ["1"] ["class"] = "";

		$menu_array ["2"] ["name"] = "Документ удостоверяющий личность";
		$menu_array ["2"] ["name"] = $navMenuDic['caption_identity_document'];
		$menu_array ["2"] ["url"] = "/wizard_fms/step2";
		$menu_array ["2"] ["class"] = "";

		$menu_array ["3"] ["name"] = "Персональные данные";
		$menu_array ["3"] ["name"] = $navMenuDic['caption_personaldata'];
		$menu_array ["3"] ["url"] = "/wizard_fms/step3";
		$menu_array ["3"] ["class"] = "";

		$db_guest_data = $this->frontdesk->GetGuest($guest_id);
		$res_data = $this->db->select('datein')->get_where('deskofreservation', array('id' => $reservation_id))->row_array();

		$representative_bool = $this->frontdesk_c2->check_representative($db_guest_data['dob'], $res_data['datein']);

		if($representative_bool == 1){
		    $menu_array["5"]["name"] = $navMenuDic['caption_representative'];
            // $menu_array ["5"] ["name"] = $navMenuDic['caption_fms_registration'];
            $menu_array["5"]["url"] = "/wizard_fms/step5";
            $menu_array["5"]["class"] = "";
		}

		$menu_array ["4"] ["name"] = "Регистрация";
		$menu_array ["4"] ["name"] = $navMenuDic['caption_fms_registration'];
		$menu_array ["4"] ["url"] = "/wizard_fms/step4";
		$menu_array ["4"] ["class"] = "";

		return $menu_array;
	}
	
	function get_ya_export_menu($id_active){
	    $menu_array [1] ["name"] = "{clt_ya_step1}";
	    $menu_array [1] ["url"] = "/dc_yandex/export_step_1";
	    $menu_array [1] ["class_active"] = "";
	    $menu_array [1] ["info_check"] = "1";
	    $menu_array [1] ["menu_id"] = 1;
	    
	    $menu_array [2] ["name"] = "{clt_ya_step2}";
	    $menu_array [2] ["url"] = "/dc_yandex/export_step_2";
	    $menu_array [2] ["class_active"] = "";
	    $menu_array [2] ["info_check"] = "2";
	    $menu_array [2] ["menu_id"] = 2;
	    
	    $menu_array [3] ["name"] = "{clt_ya_step3}";
	    $menu_array [3] ["url"] = "/dc_yandex/export_step_3";
	    $menu_array [3] ["class_active"] = "";
	    $menu_array [3] ["info_check"] = "3";
	    $menu_array [3] ["menu_id"] = 3;
	    
	    $menu_array [4] ["name"] = "{clt_ya_finish}";
	    $menu_array [4] ["url"] = "/dc_yandex/export_links";
	    $menu_array [4] ["class_active"] = "";
	    $menu_array [4] ["info_check"] = "4";
	    $menu_array [4] ["menu_id"] = 4;
	    
	    if(isset($menu_array [$id_active] ["class_active"])){
	        foreach($menu_array as $key => $cell){
	            if($key <= $id_active){
	                $menu_array [$key] ["class_active"] = "active";
	    
	            }
	    
	            if(isset($_SESSION["wizard_c2"]["confirmed_step_ids"][$key])){
	                if($key != $id_active){
	                    $menu_array [$key] ["info_check"] = "<i class=\"fa fa-check\"></i>";
	                }
	            }
	        }
	    }

	    return $menu_array;
	}

	function get_wizard_c2_menu($id_active){

	    $first_property_id = $this->mwizard_c2->get_first_property_id();

	    $first_category_id = $this->mwizard_c2->get_first_category_id();

        $first_room_id = $this->mwizard_c2->get_first_room_id();

	    $first_season_id = $this->mwizard_c2->get_first_season_id();

	    $first_rate_id = $this->mwizard_c2->get_first_rate_id();

	    //$first_dealer_id = $this->mwizard_c2->get_first_dealer_id();

	    $menu_array = array();
	    $navMenuDic = array();
	    $this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);

	    $menu_array ["1"] ["name"] = $navMenuDic['caption_lets_start'];
	    $menu_array ["1"] ["url"] = "/wizard_c2/step_1";
	    $menu_array ["1"] ["class_active"] = "";
	    $menu_array ["1"] ["info_check"] = "1";
	    $menu_array ["1"] ["menu_id"] = 1;

	    $menu_array ["2"] ["name"] = $navMenuDic['caption_object_info'];
	    $menu_array ["2"] ["url"] = "/wizard_c2/step_2/".$first_property_id;
	    $menu_array ["2"] ["class_active"] = "";
	    $menu_array ["2"] ["info_check"] = "2";
	    $menu_array ["2"] ["menu_id"] = 2;

	    $menu_array ["3"] ["name"] = $navMenuDic['caption_add_categories'];
	    $menu_array ["3"] ["url"] = "/wizard_c2/step_3/".$first_category_id;
	    $menu_array ["3"] ["class_active"] = "";
	    $menu_array ["3"] ["info_check"] = "3";
	    $menu_array ["3"] ["menu_id"] = 3;

	    $menu_array ["4"] ["name"] = $navMenuDic['caption_add_rooms'];
	    $menu_array ["4"] ["url"] = "/wizard_c2/step_4/".$first_room_id;
	    $menu_array ["4"] ["class_active"] = "";
	    $menu_array ["4"] ["info_check"] = "4";
	    $menu_array ["4"] ["menu_id"] = 4;

	    $menu_array ["5"] ["name"] = $navMenuDic['caption_season'];
	    $menu_array ["5"] ["url"] = "/wizard_c2/step_5/".$first_season_id;
	    $menu_array ["5"] ["class_active"] = "";
	    $menu_array ["5"] ["info_check"] = "5";
	    $menu_array ["5"] ["menu_id"] = 5;

	    $menu_array ["6"] ["name"] = $navMenuDic['caption_tariffs'];
	    $menu_array ["6"] ["url"] = "/wizard_c2/step_6/".$first_rate_id;
	    $menu_array ["6"] ["class_active"] = "";
	    $menu_array ["6"] ["info_check"] = "6";
	    $menu_array ["6"] ["menu_id"] = 6;

	    $menu_array ["7"] ["name"] = $navMenuDic['caption_legal_data'];
	    $menu_array ["7"] ["url"] = "/wizard_c2/step_7";
	    $menu_array ["7"] ["class_active"] = "";
	    $menu_array ["7"] ["info_check"] = "7";
	    $menu_array ["7"] ["menu_id"] = 7;

	    $menu_array ["8"] ["name"] = $navMenuDic['caption_sources'];
	    $menu_array ["8"] ["url"] = "/wizard_c2/step_8";
	    $menu_array ["8"] ["class_active"] = "";
	    $menu_array ["8"] ["info_check"] = "8";
	    $menu_array ["8"] ["menu_id"] = 8;

	    $menu_array ["9"] ["name"] = $navMenuDic['caption_taxes_fees'];
	    $menu_array ["9"] ["url"] = "/wizard_c2/step_9";
	    $menu_array ["9"] ["class_active"] = "";
	    $menu_array ["9"] ["info_check"] = "9";
	    $menu_array ["9"] ["menu_id"] = 9;

	    if(isset($menu_array [$id_active] ["class_active"])){
	        foreach($menu_array as $key => $cell){
// 	            if($key < $id_active){
// 	                $menu_array [$key] ["info_check"] = "<i class=\"fa fa-check\"></i>";
// 	            }
	            if($key <= $id_active){
	                $menu_array [$key] ["class_active"] = "active";

	            }

	            if(isset($_SESSION["wizard_c2"]["confirmed_step_ids"][$key])){
	                if($key != $id_active){
	                   $menu_array [$key] ["info_check"] = "<i class=\"fa fa-check\"></i>";
	                }
	                //$menu_array [$key] ["class_active"] = "active";
	            }
	        }
	    }
// 	    echo "<pre>";
// 	    print_r($menu_array);
// 	    die();
	    return $menu_array;
	}

	function get_online_module_menu($id_active){
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("online_module_menu", "", $navMenuDic);

		//$menu_array ["1"] ["name"] = "Categories";
		$menu_array ["1"] ["name"] = $navMenuDic['caption_categories'];
		$menu_array ["1"] ["url"] = "/online_module/categories";
		$menu_array ["1"] ["class"] = "";

		//$menu_array ["2"] ["name"] = "Tariffs";
		$menu_array ["2"] ["name"] = $navMenuDic['caption_rates'];
		$menu_array ["2"] ["url"] = "/online_module/rates";
		$menu_array ["2"] ["class"] = "";

		//$menu_array ["3"] ["name"] = "Services";
		$menu_array ["3"] ["name"] = $navMenuDic['caption_services'];
		$menu_array ["3"] ["url"] = "/online_module/services";
		$menu_array ["3"] ["class"] = "";

		if ($this->releases->online_propmocodes_veersion() == 1) {
            // $menu_array ["4"] ["name"] = "Promo codes";
            $menu_array["4"]["name"] = $navMenuDic['caption_promocodes'];
            $menu_array["4"]["url"] = "/online_module/promocodes/1";
            $menu_array["4"]["class"] = "";
        }

        if ($this->releases->online_propmocodes_veersion() == 2) {
            // $menu_array ["4"] ["name"] = "Promo codes";
            $menu_array["4"]["name"] = $navMenuDic['caption_promocodes'];
            $menu_array["4"]["url"] = "/online_module/promocodes_v2/1";
            $menu_array["4"]["class"] = "";
        }

		//$menu_array ["5"] ["name"] = "Additional Options";
		$menu_array ["5"] ["name"] = $navMenuDic['caption_additional_options'];
		$menu_array ["5"] ["url"] = "/online_module/additional_options";
		$menu_array ["5"] ["class"] = "";

		$online_faq_switch = $this->releases->online_faq_switch();
		if($online_faq_switch == 1){
		  $menu_array ["7"] ["name"] = $navMenuDic['clt_faq'];
		  $menu_array ["7"] ["url"] = "/online_module/faq";
		  $menu_array ["7"] ["class"] = "";
		}

		//$menu_array ["6"] ["name"] = "Sync";
		$menu_array ["6"] ["name"] = $navMenuDic['caption_sync'];
		$menu_array ["6"] ["url"] = "/online_module/sync";
		$menu_array ["6"] ["class"] = "";

		if(isset($menu_array [$id_active] ["class"])){
			$menu_array [$id_active] ["class"] = "active";
		}

		return $menu_array;
	}
	
	function get_echannel_menu($id_active){
	    $menu_array = array();
	    $navMenuDic = array();
	    $this->mlanguages->getdictionary("online_module_menu", "", $navMenuDic);
	    $this->mlanguages->getdictionary("admin_payment_paymenttype", "", $navMenuDic);
	
	    //$menu_array ["1"] ["name"] = "Categories";
	    $menu_array ["1"] ["name"] = $navMenuDic['caption_categories'];
	    $menu_array ["1"] ["url"] = "/echannel/categories";
	    $menu_array ["1"] ["class"] = "";
	
	    //$menu_array ["2"] ["name"] = "Tariffs";
	    $menu_array ["2"] ["name"] = $navMenuDic['caption_rates'];
	    $menu_array ["2"] ["url"] = "/echannel/rates";
	    $menu_array ["2"] ["class"] = "";
	    
	    $menu_array ["5"] ["name"] = $navMenuDic['caption_payments_type'];
	    $menu_array ["5"] ["url"] = "/echannel/payment_types";
	    $menu_array ["5"] ["class"] = "";
	    
	    $menu_array ["4"] ["name"] = $navMenuDic['caption_additional_options'];
	    $menu_array ["4"] ["url"] = "/echannel/additional_options";
	    $menu_array ["4"] ["class"] = "";
	
	   
	    $menu_array ["3"] ["name"] = $navMenuDic['caption_sync'];
	    $menu_array ["3"] ["url"] = "/echannel/sync";
	    $menu_array ["3"] ["class"] = "";
	    
	    $menu_array ["4"] ["name"] = "{caption_clients}";
	    $menu_array ["4"] ["url"] = "/echannel/clients";
	    $menu_array ["4"] ["class"] = "";

	    if(isset($menu_array [$id_active] ["class"])){
	        $menu_array [$id_active] ["class"] = "active";
	    }
	
	    return $menu_array;
	}

	function get_dc_google_menu($id_active){
	    $menu_array = array();
	    $navMenuDic = array();
	    $this->mlanguages->getdictionary("online_module_menu", "", $navMenuDic);

	    if ($this->session->userdata('global_debug') == 1) {
            $menu_array["1"]["name"] = $navMenuDic['caption_categories'];
            $menu_array["1"]["url"] = "/dc_google/categories";
            $menu_array["1"]["class"] = "";

            $menu_array["2"]["name"] = $navMenuDic['caption_rates'];
            $menu_array["2"]["url"] = "/dc_google/rates";
            $menu_array["2"]["class"] = "";

            $menu_array["3"]["name"] = $navMenuDic['caption_sync']. "(debug)";
            $menu_array["3"]["url"] = "/dc_google/sync_debug";
            $menu_array["3"]["class"] = "";
        }

	    $menu_array ["4"] ["name"] = $navMenuDic['caption_additional_options'];
	    $menu_array ["4"] ["url"] = "/dc_google/additional_options";
	    $menu_array ["4"] ["class"] = "";

	    $menu_array ["5"] ["name"] = $navMenuDic['caption_sync'];
	    $menu_array ["5"] ["url"] = "/dc_google/sync";
	    $menu_array ["5"] ["class"] = "";

	    if(isset($menu_array [$id_active] ["class"])){
	        $menu_array [$id_active] ["class"] = "active";
	    }

	    return $menu_array;
	}

	function get_master_c2_menu(){
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);

		$menu_array ["1"] ["name"] = "Детали бронирования";
		$menu_array ["1"] ["name"] = $navMenuDic['caption_zasel_booking_details'];
		$menu_array ["1"] ["url"] = "/master_c2/step_1";
		$menu_array ["1"] ["class"] = "";

		$menu_array ["2"] ["name"] = "Сведения о гостях";
		$menu_array ["2"] ["name"] = $navMenuDic['caption_zasel_guest_details'];
		$menu_array ["2"] ["url"] = "/master_c2/step_2";
		$menu_array ["2"] ["class"] = "";

		$menu_array ["3"] ["name"] = "Услуги. Оплаты.";
		$menu_array ["3"] ["name"] = $navMenuDic['caption_zasel_services_and_payments'];
		$menu_array ["3"] ["url"] = "/master_c2/step_3";
		$menu_array ["3"] ["class"] = "";

		$menu_array ["4"] ["name"] = "Заселение";
		$menu_array ["4"] ["name"] = $navMenuDic['caption_zasel_settlement'];
		$menu_array ["4"] ["url"] = "/master_c2/step_4";
		$menu_array ["4"] ["class"] = "";

		return $menu_array;
	}

	function get_chmanager_c2_menu(){
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);

		$menu_array ["1"] ["name"] = "{caption_smenu_nventory_upload}";
		$menu_array ["1"] ["url"] = "/chmanager_c2/uploadrooms";
		$menu_array ["1"] ["class"] = "";
		$menu_array ["1"] ["icon_class"] = "fa fa-suitcase";
		$menu_array ["1"] ["child_list"] = array ();

		$menu_array ["2"] ["name"] = "{caption_smenu_prices_upload}";
		$menu_array ["2"] ["url"] = "/chmanager_c2/uploadrates";
		$menu_array ["2"] ["class"] = "";
		$menu_array ["2"] ["icon_class"] = "fa fa-tasks";
		$menu_array ["2"] ["child_list"] = array ();

		$menu_array ["3"] ["name"] = "{caption_smenu_queue}";
		$menu_array ["3"] ["url"] = "/chmanager_c2/syncstatus";
		$menu_array ["3"] ["class"] = "";
		$menu_array ["3"] ["icon_class"] = "fa fa-random";
		$menu_array ["3"] ["child_list"] = array ();

		$menu_array ["4"] ["name"] = "{caption_smenu_errors}";
		$menu_array ["4"] ["url"] = "/chmanager_c2/dcerrors";
		$menu_array ["4"] ["class"] = "";
		$menu_array ["4"] ["icon_class"] = "fa fa-exclamation-triangle";
		$menu_array ["4"] ["child_list"] = array ();

		return $menu_array;
	}

	function get_master_checkout_c2_menu(){
		$menu_array = array();
		$navMenuDic = array();
		$this->mlanguages->getdictionary("wizards_c2_menus", "", $navMenuDic);

		$menu_array ["1"] ["name"] = "Изменение дат проживания";
		$menu_array ["1"] ["name"] = $navMenuDic['caption_visel_change_dates'];
		$menu_array ["1"] ["url"] = "/master_c2/checkout_step_1";
		$menu_array ["1"] ["class"] = "";

		$menu_array ["2"] ["name"] = "Предварительный счет";
		$menu_array ["2"] ["name"] = $navMenuDic['caption_visel_pre_invoice'];
		$menu_array ["2"] ["url"] = "/master_c2/checkout_step_2";
		$menu_array ["2"] ["class"] = "";

		$menu_array ["3"] ["name"] = "Финальный счет";
		$menu_array ["3"] ["name"] = $navMenuDic['caption_visel_final_invoice'];
		$menu_array ["3"] ["url"] = "/master_c2/checkout_step_3";
		$menu_array ["3"] ["class"] = "";


		return $menu_array;
	}
	function get_left_munu(){
		$legalsystem_is_rus = 0;
		$id_country_3c = strtoupper($this->frontdesk->get_visitka_id_country_3c());
// 		$lgs = strtoupper($this->frontdesk->getlegalsystem());
// 		if ($lgs === "RUSS") {
// 			$lgs = "RUS";
// 		}
		if($id_country_3c == "RUS"){
			$legalsystem_is_rus = 1;
		}
		$fms_module_state = $this->frontdesk_c2->get_fms_module_state();
		$is_active_module = $this->kkm_model->get_isactive_modules ('kkm', 'bso', 'reviews_v2');
		$menu_array = array();

		$menu_array ["1"] ["name"] = "{caption_menu_financial}";
		$menu_array ["1"] ["url"] = "#";///payments_c2/payment_listdate/1
		$menu_array ["1"] ["class"] = "";
		$menu_array ["1"] ["icon_class"] = "fa fa-money";
		$menu_array ["1"] ["child_list"] = array ();
		$menu_array ["1"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_payments}";
		$menu_array ["1"] ["child_list"] ["1"] ["child_url"] = "/payments_c2/payment_listdate/1";
		if ($legalsystem_is_rus && $is_active_module['bso']){
			$menu_array ["1"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_bso}";
			$menu_array ["1"] ["child_list"] ["2"] ["child_url"] = "/bso/records_list_c2";
		}
		/*$menu_array ["1"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_dealerbalance}";
		$menu_array ["1"] ["child_list"] ["3"] ["child_url"] = "/payments_c2/dealerbalance";
		*/
		if ($this->releases->revenue_report_allow_drowing()){
			$menu_array ["1"] ["child_list"] ["4"] ["child_name"] = '{clt_smenu_revenue}';
			$menu_array ["1"] ["child_list"] ["4"] ["child_url"] = "/reports_c2/revenue";
		}
		if ($this->releases->revenue_rooms_report_allow_drowing()){
		    $menu_array ["1"] ["child_list"] ["10"] ["child_name"] = '{clt_revenue_room}';
		    $menu_array ["1"] ["child_list"] ["10"] ["child_url"] = "/reports_c2/revenue_rooms";
		}		
		if ($this->releases->revenue_report_allow_drowing()){
		    $menu_array ["1"] ["child_list"] ["9"] ["child_name"] = '{clt_smenu_revenue_paid}<span class="icon_sm_new">new</span>';
		    $menu_array ["1"] ["child_list"] ["9"] ["child_url"] = "/reports_c2/revenue_paid";
		}
		if ($this->config->item('kkm_report_drow') == 1 && $this->releases->kkm_activity()){
			$menu_array ["1"] ["child_list"] ["5"] ["child_name"] = '{clt_smenu_kkm_shifts_report}<span class="icon_sm_new">new</span>';
			$menu_array ["1"] ["child_list"] ["5"] ["child_url"] = "/reports_c2/kkm_shiftslist";
		}
		if ($this->releases->pay_methods_report_allow_drowing()){
		    $menu_array ["1"] ["child_list"] ["6"] ["child_name"] = '{caption_smenu_payment_methods}<span class="icon_sm_new">new</span>';
		    $menu_array ["1"] ["child_list"] ["6"] ["child_url"] = "/reports_c2/pay_methods";
		}
		if ($this->releases->sources_report_allow_drowing()){
		    $menu_array ["1"] ["child_list"] ["7"] ["child_name"] = '{caption_smenu_sources}<span class="icon_sm_new">new</span>';
		    $menu_array ["1"] ["child_list"] ["7"] ["child_url"] = "/reports_c2/sources";
		}
		if ($this->releases->show_report_virtual_cc()){
		    $menu_array ["1"] ["child_list"] ["8"] ["child_name"] = '{caption_smenu_virtual_cc}<span class="icon_sm_new">new</span>';
		    //$menu_array ["1"] ["child_list"] ["8"] ["child_url"] = "/reports_c2/virtual_cc_list/1";
		    $menu_array ["1"] ["child_list"] ["8"] ["child_url"] = "/reports_c2/virtual_cc_vpos_list/1";
		}
		$menu_array ["2"] ["name"] = "{caption_menu_byorders}";
		$menu_array ["2"] ["url"] = "#";
		$menu_array ["2"] ["class"] = "";
		$menu_array ["2"] ["icon_class"] = "fa fa-book";
		$menu_array ["2"] ["child_list"] = array ();
		$menu_array ["2"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_orderlist}";
		$menu_array ["2"] ["child_list"] ["1"] ["child_url"] = "/reservation_c2/rlist/1";
		$menu_array ["2"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_guestslist}";
		$menu_array ["2"] ["child_list"] ["2"] ["child_url"] = "/reservation_c2/guestslist";
		$menu_array ["2"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_grouplist}";
		$menu_array ["2"] ["child_list"] ["3"] ["child_url"] = "/reservation_c2/group_list";
		$menu_array ["2"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_serviceslist}";
		$menu_array ["2"] ["child_list"] ["4"] ["child_url"] = "/services_c2/services_list";
		
		if($fms_module_state == 1){
			switch ($id_country_3c) {
				case "RUS":
					//$menu_array ["2"] ["child_list"] ["5"] ["child_name"] = "{caption_smenu_fms_today_map}";
					//$menu_array ["2"] ["child_list"] ["5"] ["child_url"] = "/reservation_c2/fms_map/1";
					
				    $fms_records_url = $this->releases->fmss_activity() ? '/fms_c2/recordslist' : '/fms_c2/recordlist/1';
				    
				    $menu_array ["2"] ["child_list"] ["7"] ["child_name"] = "{caption_smenu_fms_recordlist}";
				    $menu_array ["2"] ["child_list"] ["7"] ["child_url"] = $fms_records_url;
					break;
				case "ESP":
// 					$menu_array ["2"] ["child_list"] ["5"] ["child_name"] = "{caption_smenu_fms_today_map}";
// 					$menu_array ["2"] ["child_list"] ["5"] ["child_url"] = "/reservation_c2/fms_map/1";
					$menu_array ["2"] ["child_list"] ["7"] ["child_name"] = "{caption_smenu_fms_recordlist_esp}";
					$menu_array ["2"] ["child_list"] ["7"] ["child_url"] = "/fms_c2/recordlist_esp/1";
					break;
			}
		}

		$menu_array ["2"] ["child_list"] ["6"] ["child_name"] = "{caption_smenu_company_partners}";
		$menu_array ["2"] ["child_list"] ["6"] ["child_url"] = "/setup_company_customers_c2/CustomersList/1";
		//$menu_array ["2"] ["child_list"] ["6"] ["child_name"] = "{caption_smenu_dc_sources}";
		//$menu_array ["2"] ["child_list"] ["6"] ["child_url"] = "/reports_c2/dc_sources";

		$menu_array ["2"] ["child_list"] ["8"] ["child_name"] = "{caption_smenu_send_log}";
		$menu_array ["2"] ["child_list"] ["8"] ["child_url"] = "/reservation_c2/templates_send_log";
		
		$menu_array ["3"] ["name"] = "{caption_menu_demographic}";
		$menu_array ["3"] ["url"] = "";
		$menu_array ["3"] ["class"] = "";
		$menu_array ["3"] ["icon_class"] = "fa fa-globe";
		$menu_array ["3"] ["child_list"] = array ();
		$menu_array ["3"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_demographic}";
		$menu_array ["3"] ["child_list"] ["1"] ["child_url"] = "/reports_c2/demographic_reports";

		$menu_array ["4"] ["name"] = "{caption_menu_efficiency}";
		$menu_array ["4"] ["url"] = "#";
		$menu_array ["4"] ["class"] = "";
		$menu_array ["4"] ["icon_class"] = "fa fa-line-chart";
		$menu_array ["4"] ["child_list"] = array ();
// 		$menu_array ["4"] ["child_list"] ["1"] ["child_name"] = "ADR/RevPAR";
// 		$menu_array ["4"] ["child_list"] ["1"] ["child_url"] = "/reports_c2/adrrev";
// 		$menu_array ["4"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_by_sources}";
// 		$menu_array ["4"] ["child_list"] ["2"] ["child_url"] = "/reports_c2/dc_sources";
		$menu_array ["4"] ["child_list"] ["1"] ["child_name"] = '{caption_smenu_occupancy}<span class="icon_sm_new">new</span>';
		$menu_array ["4"] ["child_list"] ["1"] ["child_url"] = "/reports_c2/occupancy";

// 		if($this->hotelix_config->get_record("ADR_new_show", "int") == 1){
		$menu_array ["4"] ["child_list"] ["2"] ["child_name"] = '{clt_ADR_report} <span class="icon_sm_new">new</span>';
		$menu_array ["4"] ["child_list"] ["2"] ["child_url"] = "/reports_c2/adr_compare";
// 		}
// 		if($this->hotelix_config->get_record("REV_new_show", "int") == 1){
		$menu_array ["4"] ["child_list"] ["3"] ["child_name"] = '{clt_RevPAR_report} <span class="icon_sm_new">new</span>';
		$menu_array ["4"] ["child_list"] ["3"] ["child_url"] = "/reports_c2/rev_compare";
// 		}
// 		if($this->hotelix_config->get_record("debug_trev_TEMP", "int") == 1){
		$menu_array ["4"] ["child_list"] ["4"] ["child_name"] = '{clt_TRevPAR_report} <span class="icon_sm_new">new</span>';
		$menu_array ["4"] ["child_list"] ["4"] ["child_url"] = "/reports_c2/trev_compare";
// 		}

		$menu_array ["5"] ["name"] = "{caption_menu_audit}";
		$menu_array ["5"] ["url"] = "/admin_logers_c2/LogList/1";
		$menu_array ["5"] ["class"] = "";
		$menu_array ["5"] ["icon_class"] = "fa fa-folder-open";
		$menu_array ["5"] ["child_list"] = array ();
		$menu_array ["5"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_working_with_orders}";
		$menu_array ["5"] ["child_list"] ["1"] ["child_url"] = "/admin_logers_c2/LogList/1";
		$menu_array ["5"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_system_administration}";
		$menu_array ["5"] ["child_list"] ["2"] ["child_url"] = "/admin_logers_c2/AdminLogList/1";

		/*$menu_array ["6"] ["name"] = "{Channel Manager}";
		$menu_array ["6"] ["url"] = "/chmanager_c2/uploadrooms";
		$menu_array ["6"] ["class"] = "";
		$menu_array ["6"] ["icon_class"] = "ion-ios-world";
		$menu_array ["6"] ["child_list"] = array ();
		$menu_array ["6"] ["child_list"] ["1"] ["child_name"] = "{Вивантаження заселеності}";
		$menu_array ["6"] ["child_list"] ["1"] ["child_url"] = "/chmanager_c2/uploadrooms";
		$menu_array ["6"] ["child_list"] ["2"] ["child_name"] = "{Вивантаження тарифів}";
		$menu_array ["6"] ["child_list"] ["2"] ["child_url"] = "/chmanager_c2/uploadrates";
		$menu_array ["6"] ["child_list"] ["3"] ["child_name"] = "{Черга}";
		$menu_array ["6"] ["child_list"] ["3"] ["child_url"] = "/chmanager_c2/syncstatus";
		$menu_array ["6"] ["child_list"] ["4"] ["child_name"] = "{Помилки}";
		$menu_array ["6"] ["child_list"] ["4"] ["child_url"] = "/chmanager_c2/dcerrors";
		*/

		if ((isset($is_active_module['reviews_v2']) && $is_active_module['reviews_v2'] == 1) || $this->releases->show_newest_reviews_pages()) {
    		$menu_array ["7"] ["name"] = '{clt_menu_reviews} <span class="icon_sm_new">new</span>';
    		$menu_array ["7"] ["url"] = "#";
    		$menu_array ["7"] ["class"] = "";
    		$menu_array ["7"] ["icon_class"] = "fa fa-comments-o";
    		$menu_array ["7"] ["child_list"] = array ();
		}

// 		if (isset($is_active_module['reviews_v2'])) {
// 		    if ($is_active_module['reviews_v2']) {
		        if ($this->releases->show_newest_reviews_pages()) {
		          $menu_array ["7"] ["child_list"] ["1"] ["child_name"] = "{caption_menu_reviews_list}";
		          $menu_array ["7"] ["child_list"] ["1"] ["child_url"] = "/reviews_c2/reviews_list";
		        }
// 		    }
// 		}

		if ($this->releases->show_newest_reviews_pages('reputation')) {
		    $menu_array ["7"] ["child_list"] ["2"] ["child_name"] = '{mlw_reputation}';
		    $menu_array ["7"] ["child_list"] ["2"] ["child_url"] = "/reviews_c2/dashboard";
		}

		if ($this->releases->is_tasks_allow() == 1) {
            $menu_array["8"]["name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_menu_tasks}");
            $menu_array["8"]["url"] = "/tasks_c2/tasks_desk";
            $menu_array["8"]["class"] = "";
            $menu_array["8"]["icon_class"] = "fa fa-calendar";
            $menu_array["8"]["child_list"] = array();
            $menu_array["8"]["child_list"]["1"]["child_name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_menu_tasks_calendar}");
            $menu_array["8"]["child_list"]["1"]["child_url"] = "/tasks_c2/tasks_desk";
            $menu_array["8"]["child_list"]["2"]["child_name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_menu_room_state}");
            $menu_array["8"]["child_list"]["2"]["child_url"] = "/cst_c2/cst_desk";
            $menu_array["8"]["child_list"]["3"]["child_name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_menu_tasks_list}");
            $menu_array["8"]["child_list"]["3"]["child_url"] = "/tasks_c2/tasks_list";
        }

        if ($this->releases->show_newest_recommendation_page() == 1) {
            $menu_array["9"]["name"] = $this->mlanguages->getdictionaryword("recommendations", "", "{clt_menu_recommendations}");
            $menu_array["9"]["url"] = "/recommendations/recommendations_list";
            $menu_array["9"]["class"] = "";
            $menu_array["9"]["icon_class"] = "fa fa-tasks";
            $menu_array["9"]["child_list"] = array();
            $menu_array["9"]["child_list"]["1"]["child_name"] = $this->mlanguages->getdictionaryword("recommendations", "", "{clt_menu_recommendations}");
            $menu_array["9"]["child_list"]["1"]["child_url"] = "/recommendations/recommendations_list";
        }
		return $menu_array;
	}

	function get_settings_c2_menu(){
		$navMenuDic = array();
		$this->mlanguages->getdictionary("navigation_root_list", "", $navMenuDic);
		$legalsystem_is_rus = 0;
// 		$lgs = strtoupper($this->frontdesk->getlegalsystem());

		$id_country_3c = strtoupper($this->frontdesk->get_visitka_id_country_3c());
		$country_3c = $this->visitka_model->get_config_value($this->config->item("hotel_id"), "id_country_3c");

// 		if ($lgs === "RUSS") {
// 			$lgs = "RUS";
// 		}
		if($id_country_3c == "RUS"){
			$legalsystem_is_rus = 1;
		}
		$fms_module_state = $this->frontdesk_c2->get_fms_module_state();
		$is_active_module = $this->kkm_model->get_isactive_modules ('kkm', 'rro', 'bso', 'fms', 'reviews_v2');
		$menu_array = array();

		$menu_array ["1"] ["name"] = "{caption_menu_general_settings}";
		$menu_array ["1"] ["url"] = "/setup_payment_types_c2/type_list/1";
		$menu_array ["1"] ["class"] = "";
		$menu_array ["1"] ["icon_class"] = "ion-gear-b";
		$menu_array ["1"] ["child_list"] = array ();
		//$menu_array ["1"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_hotel_info}";
		//$menu_array ["1"] ["child_list"] ["1"] ["child_url"] = "/admin_settings_c2/hotel_information";
		//$menu_array ["1"] ["child_list"] ["1"] ["child_class"] = "";
		//$menu_array ["1"] ["child_list"] ["1"] ["child_icon_class"] = "fa fa-info";

		$menu_array ["1"] ["child_list"] ["11"] ["child_name"] = "{caption_smenu_global_settings}";
		$menu_array ["1"] ["child_list"] ["11"] ["child_url"] = "/admin_settings_c2/global_settings";
		$menu_array ["1"] ["child_list"] ["11"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["11"] ["child_icon_class"] = "fa fa-gears";

		$menu_array ["1"] ["child_list"] ["9"] ["child_name"] = "{caption_smenu_hotel_info}";
		$menu_array ["1"] ["child_list"] ["9"] ["child_url"] = "/setup_property_c2/property_information";
		$menu_array ["1"] ["child_list"] ["9"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["9"] ["child_icon_class"] = "fa fa-info";

		$menu_array ["1"] ["child_list"] ["8"] ["child_name"] = "{caption_smenu_property_description}";
		$menu_array ["1"] ["child_list"] ["8"] ["child_url"] = "/setup_property_c2/property_description";
		$menu_array ["1"] ["child_list"] ["8"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["8"] ["child_icon_class"] = "fa fa-building";

		$menu_array ["1"] ["child_list"] ["12"] ["child_name"] = "{caption_smenu_property_foto}";
		$menu_array ["1"] ["child_list"] ["12"] ["child_url"] = "/setup_property_c2/property_foto";
		$menu_array ["1"] ["child_list"] ["12"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["12"] ["child_icon_class"] = "fa fa-file";

		$menu_array ["1"] ["child_list"] ["10"] ["child_name"] = "{caption_smenu_property_custominfo}";
		$menu_array ["1"] ["child_list"] ["10"] ["child_url"] = "/setup_property_c2/property_custom_information";
		$menu_array ["1"] ["child_list"] ["10"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["10"] ["child_icon_class"] = "fa fa-building";



		$menu_array ["1"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_legalhotel_info}";
		$menu_array ["1"] ["child_list"] ["2"] ["child_url"] = "/setup_partners_c2/partners_list/1";
		$menu_array ["1"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-folder-open";

		$menu_array ["1"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_smtp_settings}";
		$menu_array ["1"] ["child_list"] ["3"] ["child_url"] = "/setup_smtp_c2/configuration";
		$menu_array ["1"] ["child_list"] ["3"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-cogs";

// 		$menu_array ["1"] ["child_list"] ["13"] ["child_name"] = "{caption_smenu_property_tax_fee}";
// 		$menu_array ["1"] ["child_list"] ["13"] ["child_url"] = "/setup_property_c2/property_fee_tax_policies";
// 		$menu_array ["1"] ["child_list"] ["13"] ["child_class"] = "";
// 		$menu_array ["1"] ["child_list"] ["13"] ["child_icon_class"] = "fa fa-building";



		$menu_array ["1"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_form_templates}";
		//if($this->hotelix_config->get_record("print_form_version", "int") == 1){
			$menu_array ["1"] ["child_list"] ["4"] ["child_url"] = "/setup_templates_c2/templates_list";
		//}else{
		//	$menu_array ["1"] ["child_list"] ["4"] ["child_url"] = "/setup_templates_c2";
		//}
		$menu_array ["1"] ["child_list"] ["4"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["4"] ["child_icon_class"] = "fa fa-files-o";
		$menu_array ["1"] ["child_list"] ["5"] ["child_name"] = "{caption_smenu_payment_methods}";
		$menu_array ["1"] ["child_list"] ["5"] ["child_url"] = "/setup_payment_types_c2/type_list/1";
		$menu_array ["1"] ["child_list"] ["5"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["5"] ["child_icon_class"] = "fa fa-bank";
// 		$menu_array ["1"] ["child_list"] ["6"] ["child_name"] = "{caption_smenu_basic_settings}";
// 		$menu_array ["1"] ["child_list"] ["6"] ["child_url"] = "/settings_c2/config";
// 		$menu_array ["1"] ["child_list"] ["6"] ["child_class"] = "";
// 		$menu_array ["1"] ["child_list"] ["6"] ["child_icon_class"] = "fa fa-square-o";
		$menu_array ["1"] ["child_list"] ["7"] ["child_name"] = "{caption_smenu_change_language}";
		$menu_array ["1"] ["child_list"] ["7"] ["child_url"] = "/setup_languages_c2";
		$menu_array ["1"] ["child_list"] ["7"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["7"] ["child_icon_class"] = "fa fa-language";
		$menu_array ["1"] ["child_list"] ["14"] ["child_name"] = "{caption_smenu_wizard}";

		$wizardsetup_type = $this->config->item('wizardsetup_type');
		switch ($wizardsetup_type) {
		    case 0:
		        $wizard_url = "/wizard/step1";
		        break;
		    case 1:
		        $wizard_url = "/wizard/step1";
		        break;
		    case 2:
		        $wizard_url = "/wizard_c2/step_1";
		        break;
		    default:
		        $wizard_url = "/wizard/step1";
		        break;
		}

		$menu_array ["1"] ["child_list"] ["14"] ["child_url"] = $wizard_url;
		$menu_array ["1"] ["child_list"] ["14"] ["child_class"] = "";
		$menu_array ["1"] ["child_list"] ["14"] ["child_icon_class"] = "fa fa-keyboard-o";

// 		if($id_country_3c == "UKR"){
// 			$menu_array ["1"] ["child_list"] ["15"] ["child_name"] = "{caption_smenu_active_liqpay}";
// 			$menu_array ["1"] ["child_list"] ["15"] ["child_url"] = "/reservation_c2/active_liqpay";
// 			$menu_array ["1"] ["child_list"] ["15"] ["child_class"] = "";
// 			$menu_array ["1"] ["child_list"] ["15"] ["child_icon_class"] = "fa fa-keyboard-o";
// 		}

		if ($this->releases->contacts_page_isactive()) {
		    $menu_array["1"]["child_list"]["16"]["child_name"] = "{caption_smenu_contacts}";
		    $menu_array["1"]["child_list"]["16"]["child_url"] = "/contacts/list_all";
		    $menu_array["1"]["child_list"]["16"]["child_class"] = "";
		    $menu_array["1"]["child_list"]["16"]["child_icon_class"] = "fa fa-address-book-o";
		}
		
		$develop = $this->session->userdata('global_modify') ? true : false;
		if ($develop) {
		    $menu_array["1"]["child_list"]["17"]["child_name"] = "{caption_smenu_restaurant}";
		    $menu_array["1"]["child_list"]["17"]["child_url"] = "/dc_booking_fsi_v/restaurant_list";
		    $menu_array["1"]["child_list"]["17"]["child_class"] = "";
		    $menu_array["1"]["child_list"]["17"]["child_icon_class"] = "fa fa-address-book-o";
		}

		$menu_array ["2"] ["name"] = "{caption_menu_partnership}";
		$menu_array ["2"] ["url"] = "/setup_dealers_c2/dealers_list/1";
		$menu_array ["2"] ["class"] = "";
		$menu_array ["2"] ["icon_class"] = "fa fa-handshake-o";
		$menu_array ["2"] ["child_list"] = array ();
		$menu_array ["2"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_sources}";
		$menu_array ["2"] ["child_list"] ["1"] ["child_url"] = "/setup_dealers_c2/dealers_list/1";
		$menu_array ["2"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["2"] ["child_list"] ["1"] ["child_icon_class"] = "ion-android-sunny";
		//$menu_array ["2"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_partners}";
		//$menu_array ["2"] ["child_list"] ["2"] ["child_url"] = "/admin_partners_c2/PartnersList/1";
		//$menu_array ["2"] ["child_list"] ["2"] ["child_class"] = "";
		//$menu_array ["2"] ["child_list"] ["2"] ["child_icon_class"] = "ion-android-people";

		$menu_array ["3"] ["name"] = "{caption_menu_roomslist}";
		$menu_array ["3"] ["url"] = "/setup_categories_c2/categories_list";
		$menu_array ["3"] ["class"] = "";
		$menu_array ["3"] ["icon_class"] = "ion-ios-browsers";
		$menu_array ["3"] ["child_list"] = array ();
		$menu_array ["3"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_categories}";
		$menu_array ["3"] ["child_list"] ["1"] ["child_url"] = "/setup_categories_c2/categories_list";
		$menu_array ["3"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["3"] ["child_list"] ["1"] ["child_icon_class"] = "fa fa-building-o";
		$menu_array ["3"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_rooms}";
		$menu_array ["3"] ["child_list"] ["2"] ["child_url"] = "/setup_rooms_c2/room_list/1";
		$menu_array ["3"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["3"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-bed";

		$menu_array ["4"] ["name"] = "{caption_menu_tariffication}";
		$menu_array ["4"] ["url"] = "/setup_seasons_c2/seasons_list";
		$menu_array ["4"] ["class"] = "";
		$menu_array ["4"] ["icon_class"] = "ion-stats-bars";
		$menu_array ["4"] ["child_list"] = array ();
		$menu_array ["4"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_seasons}";
		$menu_array ["4"] ["child_list"] ["1"] ["child_url"] = "/setup_seasons_c2/seasons_list";
		$menu_array ["4"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["1"] ["child_icon_class"] = "fa fa-sun-o";

		$menu_array ["4"] ["child_list"] ["10"] ["child_name"] = "{caption_smenu_hms_cancellation_policy}";
		$menu_array ["4"] ["child_list"] ["10"] ["child_url"] = "/setup_policy_c2/policylist/1";
		$menu_array ["4"] ["child_list"] ["10"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["10"] ["child_icon_class"] = "fa fa-minus-circle";

		$menu_array ["4"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_rates}";
		$dev_revision = $this->frontdesk_c2->get_dev_revision_value();
		//if($dev_revision < 1007){
		//	$menu_array ["4"] ["child_list"] ["2"] ["child_url"] = "/setup_rates_c2/RateList/1";
		//}else{
			$menu_array ["4"] ["child_list"] ["2"] ["child_url"] = "/setup_rates_c2/RateList_v2/1/0/1";
		//}
		//$menu_array ["4"] ["child_list"] ["2"] ["child_url"] = "/setup_rates_c2/RateList/1";
		$menu_array ["4"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-bar-chart";

		//$menu_array ["4"] ["child_list"] ["9"] ["child_name"] = "{caption_smenu_hms_cancellation_policy}";
		//$menu_array ["4"] ["child_list"] ["9"] ["child_url"] = "/setup_hms_cancellationpolicy_c2";
		//$menu_array ["4"] ["child_list"] ["9"] ["child_class"] = "";
		//$menu_array ["4"] ["child_list"] ["9"] ["child_icon_class"] = "fa fa-minus-circle";

		$menu_array ["4"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_services}";
		$menu_array ["4"] ["child_list"] ["3"] ["child_url"] = "/setup_services_c2/services_list/1";
		$menu_array ["4"] ["child_list"] ["3"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-th-list";

		$menu_array ["4"] ["child_list"] ["8"] ["child_name"] = "{caption_smenu_services_types}";
		$menu_array ["4"] ["child_list"] ["8"] ["child_url"] = "/setup_services_c2/services_types_list/1";
		$menu_array ["4"] ["child_list"] ["8"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["8"] ["child_icon_class"] = "ion-drag";

		$menu_array ["4"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_main_services}";
		$menu_array ["4"] ["child_list"] ["4"] ["child_url"] = "/setup_mainservices_c2/services_list/1";
		$menu_array ["4"] ["child_list"] ["4"] ["child_class"] = "";

		if ($this->releases->is_taxes_fees_allow() == 1) {
// 		    $menu_array["4"]["child_list"]["12"]["child_name"] = "{caption_smenu_property_tax_fee_2}";
// 		    $first_property_id = $this->frontdesk_c2->get_first_prperty_id();
// 		    $menu_array["4"]["child_list"]["12"]["child_url"] = "/setup_taxesfees_c2/tax_fee_policies/$first_property_id";
// 		    $menu_array["4"]["child_list"]["12"]["child_class"] = "";
// 		    $menu_array["4"]["child_list"]["12"]["child_icon_class"] = "fa fa-building";

		    $menu_array["4"]["child_list"]["13"]["child_name"] = "{caption_smenu_property_tax_fee_2}";
		    $menu_array["4"]["child_list"]["13"]["child_url"] = "/setup_taxesfees_c2/tax_fee_policies_v2";
		    $menu_array["4"]["child_list"]["13"]["child_class"] = "";
		    $menu_array["4"]["child_list"]["13"]["child_icon_class"] = "fa fa-building";
		}

		$menu_array ["4"] ["child_list"] ["4"] ["child_icon_class"] = "fa fa-th-large";
// 		$menu_array ["4"] ["child_list"] ["5"] ["child_name"] = "{caption_smenu_ratesonline}";
// 		$menu_array ["4"] ["child_list"] ["5"] ["child_url"] = "/setup_onlinerates_c2/RateList/1";
// 		$menu_array ["4"] ["child_list"] ["5"] ["child_class"] = "";
// 		$menu_array ["4"] ["child_list"] ["5"] ["child_icon_class"] = "fa fa-area-chart";
// 		$menu_array ["4"] ["child_list"] ["6"] ["child_name"] = "{caption_smenu_discountonline}";
// 		$menu_array ["4"] ["child_list"] ["6"] ["child_url"] = "/setup_onlinediscount_c2/DiscountList/1";
// 		$menu_array ["4"] ["child_list"] ["6"] ["child_class"] = "";
// 		$menu_array ["4"] ["child_list"] ["6"] ["child_icon_class"] = "fa fa-percent";
		$menu_array ["4"] ["child_list"] ["7"] ["child_name"] = "{caption_smenu_restrictions}";
		$menu_array ["4"] ["child_list"] ["7"] ["child_url"] = "/setup_restrictions_c2/restrictionsList/1";
		$menu_array ["4"] ["child_list"] ["7"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["7"] ["child_icon_class"] = "fa fa-window-close-o";
		$menu_array ["4"] ["child_list"] ["11"] ["child_name"] = "{caption_smenu_children_settings}";
		//$menu_array ["4"] ["child_list"] ["11"] ["child_url"] = "/setup_property_c2/children_settings";
		$menu_array ["4"] ["child_list"] ["11"] ["child_url"] = "/setup_age_ranges_c2/ranges_list";
		$menu_array ["4"] ["child_list"] ["11"] ["child_class"] = "";
		$menu_array ["4"] ["child_list"] ["11"] ["child_icon_class"] = "fa fa-child";

		$menu_array ["5"] ["name"] = "{caption_menu_design}";
		$menu_array ["5"] ["url"] = "/outward_c2/color_scheme";
		$menu_array ["5"] ["class"] = "";
		$menu_array ["5"] ["icon_class"] = "ion-paintbucket";
		$menu_array ["5"] ["child_list"] = array ();
		$menu_array ["5"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_color_scheme}";
		$menu_array ["5"] ["child_list"] ["1"] ["child_url"] = "/outward_c2/color_scheme";
		$menu_array ["5"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["5"] ["child_list"] ["1"] ["child_icon_class"] = "fa fa-cube";
		$menu_array ["5"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_markers}";
		$menu_array ["5"] ["child_list"] ["2"] ["child_url"] = "/outward_c2/markers_list/1";
		$menu_array ["5"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["5"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-paint-brush";

		//$stripe_version = $this->frontdesk_c2->stripe_basic_data_get_record("stripe_version", "int");
		$hms_billing_version = $this->hotelix_config->get_record("hms_billing_version", "int");
// 		$stripe_test_mode = $this->session->userdata( 'global_stripe_test' );
		$spripe_sca = $this->config->item('spripe_sca');
		if ($hms_billing_version == 2){
			if ($spripe_sca){
				$menu_array ["99"] ["name"] = "{caption_menu_payments}";
				$menu_array ["99"] ["url"] = "/stripe_concept2/summary";
				$menu_array ["99"] ["class"] = "";
				$menu_array ["99"] ["icon_class"] = "fa fa-university";
				$menu_array ["99"] ["child_list"] = array ();
				$menu_array ["99"] ["child_list"] ["1"] ["child_name"] = "{clt_smenu_basic_data}";
				$menu_array ["99"] ["child_list"] ["1"] ["child_url"] = "/stripe_concept2/basic_data";
				$menu_array ["99"] ["child_list"] ["1"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["1"] ["child_icon_class"] = "ion-gear-b";
				$menu_array ["99"] ["child_list"] ["2"] ["child_name"] = "{clt_smenu_summary}";
				$menu_array ["99"] ["child_list"] ["2"] ["child_url"] = "/stripe_concept2/summary";
				$menu_array ["99"] ["child_list"] ["2"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-th-list";
				$menu_array ["99"] ["child_list"] ["3"] ["child_name"] = "{clt_smenu_plans}";
				$menu_array ["99"] ["child_list"] ["3"] ["child_url"] = "/stripe_concept2/plans";
				$menu_array ["99"] ["child_list"] ["3"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["3"] ["child_icon_class"] = "ion-stats-bars";

				if (!$this->releases->is_hotel_country_in_shitcountries()) {
				    $menu_array ["99"] ["child_list"] ["4"] ["child_name"] = "{clt_smenu_pay_method}";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_url"] = "/stripe_concept2/manage_payment_methods";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_class"] = "";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_icon_class"] = "ion-cash";
				}

				$menu_array ["99"] ["child_list"] ["5"] ["child_name"] = "{clt_smenu_charges}";
				$menu_array ["99"] ["child_list"] ["5"] ["child_url"] = "/stripe_concept2/charges";
				$menu_array ["99"] ["child_list"] ["5"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["5"] ["child_icon_class"] = "fa fa-file";
				$menu_array ["99"] ["child_list"] ["6"] ["child_name"] = "{clt_smenu_invoices}";
				$menu_array ["99"] ["child_list"] ["6"] ["child_url"] = "/stripe_concept2/invoices";
				$menu_array ["99"] ["child_list"] ["6"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["6"] ["child_icon_class"] = "fa fa-file";

				$menu_array ["99"] ["child_list"] ["7"] ["child_name"] = "{clt_smenu_billing_archive}";
				$menu_array ["99"] ["child_list"] ["7"] ["child_url"] = "/billing_c2/blist";
				$menu_array ["99"] ["child_list"] ["7"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["7"] ["child_icon_class"] = "fa fa-file";
			}else{
				$menu_array ["99"] ["name"] = "{caption_menu_payments}";
				$menu_array ["99"] ["url"] = "/stripe_concept/summary";
				$menu_array ["99"] ["class"] = "";
				$menu_array ["99"] ["icon_class"] = "fa fa-university";
				$menu_array ["99"] ["child_list"] = array ();
				$menu_array ["99"] ["child_list"] ["1"] ["child_name"] = "{clt_smenu_basic_data}";
				$menu_array ["99"] ["child_list"] ["1"] ["child_url"] = "/stripe_concept/basic_data";
				$menu_array ["99"] ["child_list"] ["1"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["1"] ["child_icon_class"] = "ion-gear-b";
				$menu_array ["99"] ["child_list"] ["2"] ["child_name"] = "{clt_smenu_summary}";
				$menu_array ["99"] ["child_list"] ["2"] ["child_url"] = "/stripe_concept/summary";
				$menu_array ["99"] ["child_list"] ["2"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-th-list";
				$menu_array ["99"] ["child_list"] ["3"] ["child_name"] = "{clt_smenu_plans}";
				$menu_array ["99"] ["child_list"] ["3"] ["child_url"] = "/stripe_concept/plans";
				$menu_array ["99"] ["child_list"] ["3"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["3"] ["child_icon_class"] = "ion-stats-bars";

				if (!$this->releases->is_hotel_country_in_shitcountries()) {
				    $menu_array ["99"] ["child_list"] ["4"] ["child_name"] = "{clt_smenu_pay_method}";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_url"] = "/stripe_concept/manage_payment_methods";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_class"] = "";
				    $menu_array ["99"] ["child_list"] ["4"] ["child_icon_class"] = "ion-cash";
				}

				$menu_array ["99"] ["child_list"] ["5"] ["child_name"] = "{clt_smenu_charges}";
				$menu_array ["99"] ["child_list"] ["5"] ["child_url"] = "/stripe_concept/charges";
				$menu_array ["99"] ["child_list"] ["5"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["5"] ["child_icon_class"] = "fa fa-file";
				$menu_array ["99"] ["child_list"] ["6"] ["child_name"] = "{clt_smenu_invoices}";
				$menu_array ["99"] ["child_list"] ["6"] ["child_url"] = "/stripe_concept/invoices";
				$menu_array ["99"] ["child_list"] ["6"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["6"] ["child_icon_class"] = "fa fa-file";

				$menu_array ["99"] ["child_list"] ["7"] ["child_name"] = "{clt_smenu_billing_archive}";
				$menu_array ["99"] ["child_list"] ["7"] ["child_url"] = "/billing_c2/blist";
				$menu_array ["99"] ["child_list"] ["7"] ["child_class"] = "";
				$menu_array ["99"] ["child_list"] ["7"] ["child_icon_class"] = "fa fa-file";
			}
		}else{
			$menu_array ["9"] ["name"] = "{caption_menu_payments}";
			$menu_array ["9"] ["url"] = "/billing_c2/blist/1";
			$menu_array ["9"] ["class"] = "";
			$menu_array ["9"] ["icon_class"] = "fa fa-university";
			$menu_array ["9"] ["child_list"] = array ();
			$menu_array ["9"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_accruals_and_payments}";
			$menu_array ["9"] ["child_list"] ["1"] ["child_url"] = "/billing_c2/blist/1";
			$menu_array ["9"] ["child_list"] ["1"] ["child_class"] = "";
			$menu_array ["9"] ["child_list"] ["1"] ["child_icon_class"] = "fa fa-thumb-tack";
			$menu_array ["9"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_by_ccard}";
			$menu_array ["9"] ["child_list"] ["2"] ["child_url"] = "/billing_c2/redirect_payment";
			$menu_array ["9"] ["child_list"] ["2"] ["child_class"] = "";
			$menu_array ["9"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-credit-card-alt";
		}

		//$menu_array ["9"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_by_liqpay}";
		//$menu_array ["9"] ["child_list"] ["3"] ["child_url"] = "/billing_c2/liqpay";
		//$menu_array ["9"] ["child_list"] ["3"] ["child_class"] = "";
		//$menu_array ["9"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-angle-double-right";
		//$menu_array ["9"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_by_stripe_ccard}";
		//$menu_array ["9"] ["child_list"] ["4"] ["child_url"] = "/billing_c2/stripe";
		//$menu_array ["9"] ["child_list"] ["4"] ["child_class"] = "";
		//$menu_array ["9"] ["child_list"] ["4"] ["child_icon_class"] = "fa fa-credit-card-alt";

		$menu_array ["6"] ["name"] = "{caption_menu_users}";
		$menu_array ["6"] ["url"] = "/users_c2/ulist";
		$menu_array ["6"] ["class"] = "";
		$menu_array ["6"] ["icon_class"] = "ion-android-contacts";
		$menu_array ["6"] ["child_list"] = array ();
		$menu_array ["6"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_users_list}";
		$menu_array ["6"] ["child_list"] ["1"] ["child_url"] = "/users_c2/ulist";
		$menu_array ["6"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["6"] ["child_list"] ["1"] ["child_icon_class"] = "ion-android-contacts";
		$menu_array ["6"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_page_access}";
		$menu_array ["6"] ["child_list"] ["2"] ["child_url"] = "/users_c2/page_access_list";
		$menu_array ["6"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["6"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-id-card-o";
		if ($this->releases->user_access_v2()) {
		  $menu_array ["6"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_page_access} v2";
		  $menu_array ["6"] ["child_list"] ["3"] ["child_url"] = "/users_c2/edit_access";
		  $menu_array ["6"] ["child_list"] ["3"] ["child_class"] = "";
		  $menu_array ["6"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-id-card-o";
		}

		$menu_array ["7"] ["name"] = "Channel Manager";
		$menu_array ["7"] ["url"] = "/chmanager_c2/chanel_list2";
		$menu_array ["7"] ["class"] = "";
		$menu_array ["7"] ["icon_class"] = "ion-ios-world";
		$menu_array ["7"] ["child_list"] = array ();

		$menu_array ["7"] ["child_list"] ["1"] ["child_name"] = "{caption_smenu_сhannels_setting}";
		$menu_array ["7"] ["child_list"] ["1"] ["child_url"] = "/chmanager_c2/chanel_list2";
		$menu_array ["7"] ["child_list"] ["1"] ["child_class"] = "";
		$menu_array ["7"] ["child_list"] ["1"] ["child_icon_class"] = "ion-ios-world";
		$menu_array ["7"] ["child_list"] ["2"] ["child_name"] = "{caption_smenu_update_rates}";
		$menu_array ["7"] ["child_list"] ["2"] ["child_url"] = "/admin_settings_c2/menu_page/7/3";
		$menu_array ["7"] ["child_list"] ["2"] ["child_class"] = "";
		$menu_array ["7"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-refresh";
		$menu_array ["7"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_update_quotas}";
		$menu_array ["7"] ["child_list"] ["3"] ["child_url"] = "/dc_booking_c2/ra_params_edit";
		$menu_array ["7"] ["child_list"] ["3"] ["child_class"] = "";
		$menu_array ["7"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-retweet";
		$menu_array ["7"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_queue}";
		$menu_array ["7"] ["child_list"] ["4"] ["child_url"] = "/admin_settings_c2/menu_page/7/5";
		$menu_array ["7"] ["child_list"] ["4"] ["child_class"] = "";
		$menu_array ["7"] ["child_list"] ["4"] ["child_icon_class"] = "fa fa-random";

		$menu_array ["8"] ["name"] = "{caption_menu_additional_settings}";
		$menu_array ["8"] ["url"] = "/reservation_c2/additional_settings";
		$menu_array ["8"] ["class"] = "";
		$menu_array ["8"] ["icon_class"] = "ion-settings";
		$menu_array ["8"] ["child_list"] = array ();

        if ($is_active_module['bso'] == 1 && $country_3c == 'RUS') {
            $menu_array["8"]["child_list"]["1"]["child_name"] = "{caption_smenu_bso}";
            $menu_array["8"]["child_list"]["1"]["child_url"] = "/bso_c2/options";
            $menu_array["8"]["child_list"]["1"]["child_class"] = "";
            $menu_array["8"]["child_list"]["1"]["child_icon_class"] = "fa fa-file";
        }
		switch ($id_country_3c) {
			case "RUS":
				$menu_array ["8"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_fms}";
				$menu_array ["8"] ["child_list"] ["3"] ["child_url"] = "/fms_c2/options";
				$menu_array ["8"] ["child_list"] ["3"] ["child_class"] = "";
				$menu_array ["8"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-suitcase";
				break;
			case "ESP":
				$menu_array ["8"] ["child_list"] ["3"] ["child_name"] = "{caption_smenu_fms_esp}";
				$menu_array ["8"] ["child_list"] ["3"] ["child_url"] = "/fms_c2/options_esp";
				$menu_array ["8"] ["child_list"] ["3"] ["child_class"] = "";
				$menu_array ["8"] ["child_list"] ["3"] ["child_icon_class"] = "fa fa-suitcase";
				break;
		}
// 		}
// 		$menu_array ["8"] ["child_list"] ["4"] ["child_name"] = "{caption_smenu_aquiring}";
// 		$menu_array ["8"] ["child_list"] ["4"] ["child_url"] = "/admin_aquiring_c2";
// 		$menu_array ["8"] ["child_list"] ["4"] ["child_class"] = "";
// 		$menu_array ["8"] ["child_list"] ["4"] ["child_icon_class"] = "fa fa-credit-card";
// 		$menu_array ["8"] ["child_list"] ["5"] ["child_name"] = "{caption_smenu_maids_module}";
// 		$menu_array ["8"] ["child_list"] ["5"] ["child_url"] = "/admin_maid_c2";
// 		$menu_array ["8"] ["child_list"] ["5"] ["child_class"] = "";
// 		$menu_array ["8"] ["child_list"] ["5"] ["child_icon_class"] = "fa fa-female";

		if ($this->releases->kkm_activity()) {
			$menu_array ["8"] ["child_list"] ["6"] ["child_name"] = "{caption_smenu_kkm}";
			$menu_array ["8"] ["child_list"] ["6"] ["child_url"] = "/kkm/use_conditions";
			$menu_array ["8"] ["child_list"] ["6"] ["child_class"] = "";
			$menu_array ["8"] ["child_list"] ["6"] ["child_icon_class"] = "fa fa-keyboard-o";
		}

		if ($this->releases->rro_activity()) {
		    $rro_active_provider = $this->hotelix_config->get_record ("rro_active_provider", "int");
		    if ($rro_active_provider == 2) {//vchasno
		        $menu_array ["8"] ["child_list"] ["2"] ["child_name"] = "PPO";
		        $menu_array ["8"] ["child_list"] ["2"] ["child_url"] = "/rro/settings";
		        $menu_array ["8"] ["child_list"] ["2"] ["child_class"] = "";
		        $menu_array ["8"] ["child_list"] ["2"] ["child_icon_class"] = "fa fa-keyboard-o";
		    }
		}

        if (isset($is_active_module['reviews_v2'])) {
            if ($is_active_module['reviews_v2']) {
                $menu_array["8"]["child_list"]["9"]["child_name"] = "{caption_smenu_reviews}";
                $menu_array["8"]["child_list"]["9"]["child_url"] = "/reviews_c2/settings";
                $menu_array["8"]["child_list"]["9"]["child_class"] = "";
                $menu_array["8"]["child_list"]["9"]["child_icon_class"] = "fa fa-comment";
            }
        }

//         if ($this->frontdesk_c2->get_stripe_acquiring_available_in_country($id_country_3c)){
//         	$stripe_subaccount = 0;
//         	$stripe_subaccount = $this->hotelix_config->get_record("stripe_subaccount", "int");

//         	switch ($stripe_subaccount) {
//         		case 1:
//         			$menu_array["8"]["child_list"]["10"]["child_name"] = "{clt_cc_processing}";
//         			$menu_array["8"]["child_list"]["10"]["child_url"] = "/cc_c2/stripe_partner";
//         			$menu_array["8"]["child_list"]["10"]["child_class"] = "";
//         			$menu_array["8"]["child_list"]["10"]["child_icon_class"] = "fa fa-file";
//         			break;
//         		case 2:
//         			$menu_array["8"]["child_list"]["10"]["child_name"] = "{clt_stripe_connect}";
//         			$menu_array["8"]["child_list"]["10"]["child_url"] = "/stripe_standart/connect";
//         			$menu_array["8"]["child_list"]["10"]["child_class"] = "";
//         			$menu_array["8"]["child_list"]["10"]["child_icon_class"] = "fa fa-file";
//         			break;
//  	            default:
//  	                $menu_array["8"]["child_list"]["10"]["child_name"] = "{clt_stripe_connect}";
//  	                $menu_array["8"]["child_list"]["10"]["child_url"] = "/stripe_standart/connect";
//  	                $menu_array["8"]["child_list"]["10"]["child_class"] = "";
//  	                $menu_array["8"]["child_list"]["10"]["child_icon_class"] = "fa fa-file";
//         	}
//         }

        $wifi_allow = $this->releases->is_wifi_allow();
        if ($wifi_allow == 1) {
            $menu_array["8"]["child_list"]["11"]["child_name"] = $this->mlanguages->getdictionaryword ( "wifi_settings", "", "{clt_wifi_guest_network}" );
            $menu_array["8"]["child_list"]["11"]["child_url"] = "/reservation_c2/wifi_settings";
            $menu_array["8"]["child_list"]["11"]["child_class"] = "";
            $menu_array["8"]["child_list"]["11"]["child_icon_class"] = "fa fa-comment";
        }

        /* if ($this->releases->paypal_aquring()) {//!!!DONT DELETE!!
            $menu_array["8"]["child_list"]["12"]["child_name"] = "PayPal";
            $menu_array["8"]["child_list"]["12"]["child_url"] = "/paypal/settings";
            $menu_array["8"]["child_list"]["12"]["child_class"] = "";
            $menu_array["8"]["child_list"]["12"]["child_icon_class"] = "fa fa-file";
        } */

        if ($this->releases->fmss_activity()) {
            $menu_array["8"]["child_list"]["14"]["child_name"] = "Скала";
            $menu_array["8"]["child_list"]["14"]["child_url"] = "/fmss/skala_settings";
            $menu_array["8"]["child_list"]["14"]["child_class"] = "";
            $menu_array["8"]["child_list"]["14"]["child_icon_class"] = "fa fa-file";
        }


        $tasks_allow = $this->releases->is_tasks_allow();
        if ($tasks_allow == 1) {
            if (true) {
                $menu_array["10"]["child_list"]["4"]["child_name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_tasks_types}");
                $menu_array["10"]["child_list"]["4"]["child_url"] = "/tasks_c2/tasks_types_list";
                $menu_array["10"]["child_list"]["4"]["child_class"] = "";
                $menu_array["10"]["child_list"]["4"]["child_icon_class"] = "fa fa-tasks";

                $menu_array["10"]["child_list"]["5"]["child_name"] = $this->mlanguages->getdictionaryword("tasks_c2", "", "{clt_tasks_sub_types}");
                $menu_array["10"]["child_list"]["5"]["child_url"] = "/tasks_c2/tasks_subtypes_list";
                $menu_array["10"]["child_list"]["5"]["child_class"] = "";
                $menu_array["10"]["child_list"]["5"]["child_icon_class"] = "fa fa-sitemap";
            }

            $menu_array["10"]["child_list"]["3"]["child_name"] = $this->mlanguages->getdictionaryword ( "tasks_c2", "", "{clt_cst_tasks}" );
            $menu_array["10"]["child_list"]["3"]["child_url"] = "/cst_c2/cst_tasks";
            $menu_array["10"]["child_list"]["3"]["child_class"] = "";
            $menu_array["10"]["child_list"]["3"]["child_icon_class"] = "fa fa-cubes";

            $menu_array["10"]["name"] = $this->mlanguages->getdictionaryword ( "tasks_c2", "", "{clt_cst_list}" );
            $menu_array["10"]["icon_class"] = "fa fa-leaf";
            $menu_array["10"]["url"] = "/cst_c2/cst_list";
            $menu_array["10"]["child_list"]["2"]["child_name"] = $this->mlanguages->getdictionaryword ( "tasks_c2", "", "{clt_cst_list}" );
            $menu_array["10"]["child_list"]["2"]["child_url"] = "/cst_c2/cst_list";
            $menu_array["10"]["child_list"]["2"]["child_class"] = "";
            $menu_array["10"]["child_list"]["2"]["child_icon_class"] = "fa fa-leaf";
        }

            if ($this->releases->new_pay_settings_menu()) {

                $menu_array["11"]["name"] = "{clt_pay_mod}";
                $menu_array["11"]["class"] = "";
                $menu_array["11"]["icon_class"] = "ion-card";
                $menu_array["11"]["child_list"] = array();
                $equiring_base_url = "";
                switch ($country_3c) {
                case "GEO":
                    $equiring_base_url = "/bog/settings";
                    $menu_array["11"]["child_list"]["1"]["child_name"] = "{clt_ipay}";
                    $menu_array["11"]["child_list"]["1"]["child_url"] = "/bog/settings";
                    $menu_array["11"]["child_list"]["1"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["1"]["child_icon_class"] = "fa fa-file";


                    if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                        $equiring_base_url = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["3"]["child_url"] = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["3"]["child_icon_class"] = "fa fa-file";
                    }

                    if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                        $equiring_base_url = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["4"]["child_url"] = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["4"]["child_icon_class"] = "fa fa-file";
                    }

                    break;
                case "RUS":
                    $equiring_base_url = "/mandarin/settings";
                    $menu_array["11"]["child_list"]["2"]["child_name"] = "Mandarin";
                    $menu_array["11"]["child_list"]["2"]["child_url"] = "/mandarin/settings";
                    $menu_array["11"]["child_list"]["2"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["2"]["child_icon_class"] = "fa fa-file";
                    break;
                case "UKR":
                    $equiring_base_url = "/reservation_c2/active_liqpay";
                    $menu_array["11"]["child_list"]["5"]["child_name"] = "{caption_smenu_active_liqpay}";
                    $menu_array["11"]["child_list"]["5"]["child_url"] = "/reservation_c2/active_liqpay";
                    $menu_array["11"]["child_list"]["5"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["5"]["child_icon_class"] = "fa fa-keyboard-o";
                    
                    $menu_array["11"]["child_list"]["7"]["child_name"] = "Monobank";
                    $menu_array["11"]["child_list"]["7"]["child_url"] = "/monobank/settings";
                    $menu_array["11"]["child_list"]["7"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["7"]["child_icon_class"] = "fa fa-keyboard-o";
                    break;
                case "CHL":
                    $equiring_base_url = "/transbank/settings";
                    $menu_array["11"]["child_list"]["5"]["child_name"] = "Transbank";
                    $menu_array["11"]["child_list"]["5"]["child_url"] = "/transbank/settings";
                    $menu_array["11"]["child_list"]["5"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["5"]["child_icon_class"] = "fa fa-file";


                    if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                        $equiring_base_url = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["3"]["child_url"] = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["3"]["child_icon_class"] = "fa fa-file";
                    }

                    if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                        $equiring_base_url = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["4"]["child_url"] = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["4"]["child_icon_class"] = "fa fa-file";
                    }

                    break;
                default:
                    if ($this->frontdesk_c2->get_stripe_acquiring_available_in_country($id_country_3c)){
                        $stripe_subaccount = 0;
                        $stripe_subaccount = $this->hotelix_config->get_record("stripe_subaccount", "int");

                        switch ($stripe_subaccount) {
                            case 1:
                                $menu_array["11"]["child_list"]["6"]["child_name"] = "{clt_cc_processing}";
                                $menu_array["11"]["child_list"]["6"]["child_url"] = "/cc_c2/stripe_partner";
                                $menu_array["11"]["child_list"]["6"]["child_class"] = "";
                                $menu_array["11"]["child_list"]["6"]["child_icon_class"] = "fa fa-file";
                                break;
                            case 2:
                                $menu_array["11"]["child_list"]["6"]["child_name"] = "{clt_stripe_connect}";
                                $menu_array["11"]["child_list"]["6"]["child_url"] = "/stripe_standart/connect";
                                $menu_array["11"]["child_list"]["6"]["child_class"] = "";
                                $menu_array["11"]["child_list"]["6"]["child_icon_class"] = "fa fa-file";
                                break;
                            default:
                                $menu_array["11"]["child_list"]["6"]["child_name"] = "{clt_stripe_connect}";
                                $menu_array["11"]["child_list"]["6"]["child_url"] = "/stripe_standart/connect";
                                $menu_array["11"]["child_list"]["6"]["child_class"] = "";
                                $menu_array["11"]["child_list"]["6"]["child_icon_class"] = "fa fa-file";
                        }
                    }


                    if ($this->releases->paypal_v2_aquring() && $this->config->item('paypal_version_aquring') == 2) {
                        $equiring_base_url = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["3"]["child_url"] = "/paypal/settings_v2";
                        $menu_array["11"]["child_list"]["3"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["3"]["child_icon_class"] = "fa fa-file";
                    }

                    if ($this->releases->paypal_aquring() && $this->config->item('paypal_version_aquring') == 1) {
                        $equiring_base_url = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_name"] = "PayPal";
                        $menu_array["11"]["child_list"]["4"]["child_url"] = "/paypal/settings";
                        $menu_array["11"]["child_list"]["4"]["child_class"] = "";
                        $menu_array["11"]["child_list"]["4"]["child_icon_class"] = "fa fa-file";
                    }

                    break;
            }

                if ($this->releases->przelewy_aquring()) {
                    $menu_array["11"]["child_list"]["5"]["child_name"] = "Przelewy24";
                    $menu_array["11"]["child_list"]["5"]["child_url"] = "/przelewy/settings";
                    $menu_array["11"]["child_list"]["5"]["child_class"] = "";
                    $menu_array["11"]["child_list"]["5"]["child_icon_class"] = "fa fa-file";
                }

                $menu_array["11"]["url"] = $equiring_base_url;
            }

		return $menu_array;
	}

	function getrootlist($id_m = 0 ) {

		if ($id_m == 2) {
			$isread_count = $this->frontdesk->get_count_isread_reservarions ();
			$expected_count = $this->frontdesk->get_count_expected_reservarions ();
			$close_day_count = $this->frontdesk->get_count_late_order ();
		} else {
			$isread_count = 0;
			$expected_count = 0;
			$close_day_count = 0;
		}
		if ($id_m == 14 or $id_m == 0) {
			$isread_messages_count = $this->frontdesk->get_count_isread_messages ();
			$important_messages_count = $this->frontdesk->get_count_important_messages ();
		} else {
			$isread_messages_count = 0;
			$important_messages_count = 0;
		}

		$bso_config_arr = $this->bso_core->get_bso_config ();
		$bso_active = $bso_config_arr["bso_active"];

		$fms_active = $this->fms_core->get_fms_active ();
		//$fms_active = 1;
		//print_r($bso_config_arr);
		$navMenuDic = array();

		$this->mlanguages->getdictionary("navigation_root_list", "", $navMenuDic);


		$navMenu = array ();
		// if ($_SESSION ['user'] ['role_name'] == 5) {
		$navMenu ["1"] ["name"] = "Главная";
		$navMenu ["1"] ["name"] = $navMenuDic['navigation_root_list_main'];
		$navMenu ["1"] ["url"] = "/reservations/calendar";
		$navMenu ["1"] ["count_list_main"] = "";
		// }
		$navMenu ["1"] ["list"] = array ();
		$navMenu ["2"] ["name"] = "Заказы";
		$navMenu ["2"] ["name"] = $navMenuDic['navigation_root_list_orders'];
		$navMenu ["2"] ["url"] = "/reservations/RList/1";
		$navMenu ["2"] ["count_list_main"] = "";
		$navMenu ["2"] ["list"] = array ();

		$navMenu ["2"] ["list"] ["1"] ["name"] = "Доска заказов";
		$navMenu ["2"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_list_desk'];
		$navMenu ["2"] ["list"] ["1"] ["url"] = "/reservations/calendar";
		$navMenu ["2"] ["list"] ["1"] ["count_list"] = "";
		$navMenu ["2"] ["list"] ["2"] ["name"] = "Заказы";
		$navMenu ["2"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_list_orders'];
		$navMenu ["2"] ["list"] ["2"] ["url"] = "/reservations/RList/1";

		// if ($isread_count <> 0){
		// $navMenu ["2"] ["list"] ["2"] ["count_list"] = '<span
		// class="redAlert">'.$isread_count.'</span>';
		// }else{
		$navMenu ["2"] ["list"] ["2"] ["count_list"] = '';
		// }

		if ($isread_count != 0) {
			$navMenu ["2"] ["list"] ["8"] ["count_list"] = '<span class="redAlert">' . $isread_count . '</span>';
			$navMenu ["2"] ["list"] ["8"] ["name"] = "Новые заказы";
			$navMenu ["2"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_new_orders'];
			$navMenu ["2"] ["list"] ["8"] ["url"] = "/reservations/RnewList/1";
		}
		$navMenu ["2"] ["list"] ["3"] ["name"] = "Карта дня";
		$navMenu ["2"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_today_map'];
		$navMenu ["2"] ["list"] ["3"] ["url"] = "/reservations/ReservationToDayList/1";
		$navMenu ["2"] ["list"] ["3"] ["count_list"] = "";
		$navMenu ["2"] ["list"] ["3"] ["list_2"][0]["name"] = $navMenuDic['navigation_root_today_map'];
		$navMenu ["2"] ["list"] ["3"] ["list_2"][0]["url"] = "/reservations/ReservationToDayList/1";
		$navMenu ["2"] ["list"] ["3"] ["list_2"][0]["count_list"] = "";
		if($fms_active == 1){
			$navMenu ["2"] ["list"] ["3"] ["list_2"][1]["name"] = "Карта дня ФМС";
			$navMenu ["2"] ["list"] ["3"] ["list_2"][1]["name"] = $navMenuDic['navigation_root_today_map_fms'];
			$navMenu ["2"] ["list"] ["3"] ["list_2"][1]["url"] = "/reservations/ReservationToDayList_fms/1";
			$navMenu ["2"] ["list"] ["3"] ["list_2"][1]["count_list"] = "";
		}
		$navMenu ["2"] ["list"] ["4"] ["name"] = "Ожидаемые";
		$navMenu ["2"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_cooming_orders'];
		$navMenu ["2"] ["list"] ["4"] ["url"] = "/reservations/ReservationExpectedList/1";
		if ($expected_count != 0) {
			$navMenu ["2"] ["list"] ["4"] ["count_list"] = '<span class="redAlert">' . $expected_count . '</span>';
		} else {
			$navMenu ["2"] ["list"] ["4"] ["count_list"] = "";
		}

		$navMenu ["2"] ["list"] ["9"] ["name"] = "Ночной аудит";
		$navMenu ["2"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_night_audit'];
		$navMenu ["2"] ["list"] ["9"] ["url"] = "/reservations/CloseDayList/1";
		if ($close_day_count != 0) {
			$navMenu ["2"] ["list"] ["9"] ["count_list"] = '<span class="redAlert">' . $close_day_count . '</span>';
		} else {
			$navMenu ["2"] ["list"] ["9"] ["count_list"] = "";
		}

		$navMenu ["2"] ["list"] ["5"] ["name"] = "Корзина";
		$navMenu ["2"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_trash'];
		$navMenu ["2"] ["list"] ["5"] ["url"] = "/reservations/ReservationCancelList/1";
		$navMenu ["2"] ["list"] ["5"] ["count_list"] = "";

		$navMenu ["2"] ["list"] ["7"] ["name"] = "+";
		$navMenu ["2"] ["list"] ["7"] ["url"] = "/reservations/create";
		$navMenu ["2"] ["list"] ["7"] ["count_list"] = "";

		$navMenu ["10"] ["name"] = "Услуги";
		$navMenu ["10"] ["name"] = $navMenuDic['navigation_root_services'];
		$navMenu ["10"] ["url"] = "/payments/Services/1";
		$navMenu ["10"] ["count_list_main"] = "";
		$navMenu ["10"] ["list"] = array ();
		// $navMenu["3"]["list"]["1"]["name"] = "Оплаты по дате заезда";
		// $navMenu["3"]["list"]["1"]["url"] = "/payments/PaymentList/1";
		$navMenu ["10"] ["list"] ["2"] ["name"] = "Услуги";
		$navMenu ["10"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_services'];
		$navMenu ["10"] ["list"] ["2"] ["url"] = "/payments/Services/1";
		$navMenu ["10"] ["list"] ["2"] ["count_list"] = "";
		$navMenu ["10"] ["list"] ["3"] ["name"] = "Карта дня";
		$navMenu ["10"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_today_map'];
		$navMenu ["10"] ["list"] ["3"] ["url"] = "/payments/ServicesToDayList/1";
		$navMenu ["10"] ["list"] ["3"] ["count_list"] = "";

		$navMenu ["3"] ["name"] = "Отчеты";
		$navMenu ["3"] ["name"] = $navMenuDic['navigation_root_reports'];
		$navMenu ["3"] ["url"] = "/payments/PaymentListDate/1";
		$navMenu ["3"] ["count_list_main"] = "";
		$navMenu ["3"] ["list"] = array ();
		// $navMenu["3"]["list"]["1"]["name"] = "Оплаты по дате заезда";
		// $navMenu["3"]["list"]["1"]["url"] = "/payments/PaymentList/1";
		$navMenu ["3"] ["list"] ["2"] ["name"] = "Оплаты";
		$navMenu ["3"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_payments'];
		$navMenu ["3"] ["list"] ["2"] ["url"] = "/payments/PaymentListDate/1";
		$navMenu ["3"] ["list"] ["2"] ["count_list"] = "";
		if($bso_active == 1){
			$navMenu ["3"] ["list"] ["9"] ["name"] = "БСО";
			$navMenu ["3"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_bso'];
			$navMenu ["3"] ["list"] ["9"] ["url"] = "/bso/records_list";
			$navMenu ["3"] ["list"] ["9"] ["count_list"] = "";
		}
		if($fms_active == 1){
			$navMenu ["3"] ["list"] ["10"] ["name"] = "ФМС";
			//$navMenu ["3"] ["list"] ["10"] ["name"] = $navMenuDic['navigation_root_fms'];
			$navMenu ["3"] ["list"] ["10"] ["url"] = "/fms/recordlist";
			$navMenu ["3"] ["list"] ["10"] ["count_list"] = "";
		}
		$navMenu ["3"] ["list"] ["8"] ["name"] = "Внешние оплаты";
		$navMenu ["3"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_external_payments'];
		$navMenu ["3"] ["list"] ["8"] ["url"] = "/payments/ExternalPaymentList/1";
		$navMenu ["3"] ["list"] ["8"] ["count_list"] = "";
		$navMenu ["3"] ["list"] ["3"] ["name"] = "Общий отчет";
		$navMenu ["3"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_total_report'];
		$navMenu ["3"] ["list"] ["3"] ["url"] = "/payments/TotalBalance";
		$navMenu ["3"] ["list"] ["3"] ["count_list"] = "";
		// if ($_SESSION ['user'] ['role_name'] == 5) {
		//$navMenu ["3"] ["list"] ["4"] ["name"] = "Услуги";
		//$navMenu ["3"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_services'];
		//$navMenu ["3"] ["list"] ["4"] ["url"] = "/payments/Services/1";
		//$navMenu ["3"] ["list"] ["4"] ["count_list"] = "";
		$navMenu ["3"] ["list"] ["5"] ["name"] = "Дилерский баланс";
		$navMenu ["3"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_dealerships_balance'];
		$navMenu ["3"] ["list"] ["5"] ["url"] = "/payments/DealerBalance";
		$navMenu ["3"] ["list"] ["5"] ["count_list"] = "";
		$navMenu ["3"] ["list"] ["6"] ["name"] = "Загрузка";
		$navMenu ["3"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_download'];
		$navMenu ["3"] ["list"] ["6"] ["url"] = "/reservations/loading";
		$navMenu ["3"] ["list"] ["6"] ["count_list"] = "";
		$navMenu ["3"] ["list"] ["7"] ["name"] = "Отзывы";
		$navMenu ["3"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_reviews_rlist'];
		$navMenu ["3"] ["list"] ["7"] ["url"] = "/reviews/rlist/1";
		$navMenu ["3"] ["list"] ["7"] ["count_list"] = "";

		$navMenu ["4"] ["name"] = "Справочники";
		$navMenu ["4"] ["name"] = $navMenuDic['navigation_root_directories'];
		$navMenu ["4"] ["url"] = "/reservations/PriceList2";
		$navMenu ["4"] ["count_list_main"] = "";
		$navMenu ["10"] ["list"] ["3"] ["count_list"] = "";
		$navMenu ["4"] ["list"] = array ();
		$navMenu ["4"] ["list"] ["1"] ["name"] = "Справочник цен";
		$navMenu ["4"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_prices'];
		$navMenu ["4"] ["list"] ["1"] ["url"] = "/reservations/PriceList2";
		$navMenu ["4"] ["list"] ["1"] ["count_list"] = "";
		$navMenu ["4"] ["list"] ["2"] ["name"] = "Справочник номеров";
		$navMenu ["4"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_rooms_ref'];
		$navMenu ["4"] ["list"] ["2"] ["url"] = "/reservations/RoomList/1";
		$navMenu ["4"] ["list"] ["2"] ["count_list"] = "";
		$navMenu ["4"] ["list"] ["3"] ["name"] = "Справочник гостей";
		$navMenu ["4"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_guests_ref'];
		$navMenu ["4"] ["list"] ["3"] ["url"] = "/reservations/AllGuestsList/1";
		$navMenu ["4"] ["list"] ["3"] ["count_list"] = "";
		$navMenu ["4"] ["list"] ["5"] ["name"] = "Предприятия партнеры";
		$navMenu ["4"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_customers'];
		$navMenu ["4"] ["list"] ["5"] ["url"] = "/admin_company_customers/CustomersList/1";
		$navMenu ["4"] ["list"] ["5"] ["count_list"] = "";
		$navMenu ["4"] ["list"] ["4"] ["name"] = "Справочник услуг";
		$navMenu ["4"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_services'];
		$navMenu ["4"] ["list"] ["4"] ["url"] = "/services/ServicesList";
		$navMenu ["4"] ["list"] ["4"] ["count_list"] = "";

		// }

		if ($_SESSION ['user'] ['journal_active'] == 1) {
			$navMenu ["5"] ["name"] = "Обслуживание";
			$navMenu ["5"] ["url"] = "/reservations/CleanList/1";
			$navMenu ["5"] ["count_list_main"] = "";
			$navMenu ["5"] ["list"] = array ();
			// $navMenu["5"]["list"]["1"]["name"] = "Журнал граждан Украины";
			// $navMenu["5"]["list"]["1"]["url"] = "/reservations/GuestsList/1";
			// $navMenu["5"]["list"]["2"]["name"] = "Журнал иностранцев";
			// $navMenu["5"]["list"]["2"]["url"] =
			// "/reservations/GuestsalienList/1";
			$navMenu ["5"] ["list"] ["3"] ["name"] = "Табель горничной";
			$navMenu ["5"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_cleanlist'];
			$navMenu ["5"] ["list"] ["3"] ["url"] = "/reservations/CleanList/1";
			$navMenu ["5"] ["list"] ["3"] ["count_list"] = "";
			$navMenu ["5"] ["list"] ["4"] ["name"] = "Журнал охраны";
			$navMenu ["5"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_reporttoday1'];
			$navMenu ["5"] ["list"] ["4"] ["url"] = "/reservations/reporttoday/1";
			$navMenu ["5"] ["list"] ["4"] ["count_list"] = "";
			$navMenu ["5"] ["list"] ["5"] ["name"] = "Журнал работников пляжа";
			$navMenu ["5"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reporttoday2'];
			$navMenu ["5"] ["list"] ["5"] ["url"] = "/reservations/reporttoday/2";
			$navMenu ["5"] ["list"] ["5"] ["count_list"] = "";
			$navMenu ["5"] ["list"] ["6"] ["name"] = "Журнал администратора";
			$navMenu ["5"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reporttoday3'];
			$navMenu ["5"] ["list"] ["6"] ["url"] = "/reservations/reporttoday/3";
			$navMenu ["5"] ["list"] ["6"] ["count_list"] = "";
		}
		if (isset($_SESSION ['user'] ['tasks_active'])) {

		} else {
		    $_SESSION ['user'] ['tasks_active'] = 0;
		}
		if ($_SESSION ['user'] ['tasks_active'] == 1) {
			$navMenu ["15"]["name"] = "Задачи";
			$navMenu ["15"]["name"] = $navMenuDic['navigation_root_tasklist'];
			$navMenu ["15"]["url"] = "/tasks/tasklist/1";
			$navMenu ["15"]["count_list_main"] = "";

			$navMenu ["15"] ["list"] ["1"] ["name"] = "Задачи";
			$navMenu ["15"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_tasklist'];
			$navMenu ["15"] ["list"] ["1"] ["url"] = "/tasks/tasklist/1";
			$navMenu ["15"] ["list"] ["1"] ["count_list"] = "";
			$navMenu ["15"] ["list"] ["2"] ["name"] = "Карта дня";
			$navMenu ["15"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_today_map'];
			$navMenu ["15"] ["list"] ["2"] ["url"] = "/tasks/today_map/1";
			$navMenu ["15"] ["list"] ["2"] ["count_list"] = "";
			$navMenu ["15"] ["list"] ["3"] ["name"] = "Календарь";
			$navMenu ["15"] ["list"] ["3"] ["name"] = "Календарь";
			$navMenu ["15"] ["list"] ["3"] ["url"] = "/tasks/calendar/1";
			$navMenu ["15"] ["list"] ["3"] ["count_list"] = "";
		}

		$navMenu ["6"] ["name"] = "Пропущенное";
		$navMenu ["6"] ["name"] = $navMenuDic['navigation_root_missed'];
		$navMenu ["6"] ["url"] = "/reservations/Reservation_noclose_List";
		$navMenu ["6"] ["count_list_main"] = "";
		$navMenu ["6"] ["list"] = array ();
		$navMenu ["6"] ["list"] ["1"] ["name"] = "Просрочен \"Выезд\"";
		$navMenu ["6"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_noclose'];
		$navMenu ["6"] ["list"] ["1"] ["url"] = "/reservations/Reservation_noclose_List";
		$navMenu ["6"] ["list"] ["1"] ["count_list"] = "";
		$navMenu ["6"] ["list"] ["2"] ["name"] = "Просрочен \"Заезд\"";
		$navMenu ["6"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_nolive'];
		$navMenu ["6"] ["list"] ["2"] ["url"] = "/reservations/Reservation_nolive_List";
		$navMenu ["6"] ["list"] ["2"] ["count_list"] = "";
		$navMenu ["6"] ["list"] ["3"] ["name"] = "Не оплаченные заказы";
		$navMenu ["6"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_nopay'];
		$navMenu ["6"] ["list"] ["3"] ["url"] = "/reservations/Reservation_nopay_List";
		$navMenu ["6"] ["list"] ["3"] ["count_list"] = "";
		$navMenu ["6"] ["list"] ["4"] ["name"] = "Ночной аудит";
		$navMenu ["6"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_closeday'];
		$navMenu ["6"] ["list"] ["4"] ["url"] = "/reservations/CloseDayList/1";
		$navMenu ["6"] ["list"] ["4"] ["count_list"] = "";
		$navMenu ["6"] ["list"] ["5"] ["name"] = "Просроченные заказы";
		$navMenu ["6"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_timereservations'];
		$navMenu ["6"] ["list"] ["5"] ["url"] = "/reservations/TimeReservations/1";
		$navMenu ["6"] ["list"] ["5"] ["count_list"] = "";
		if ($_SESSION ['user'] ['instruments_active'] == 1) {
			$navMenu ["7"] ["name"] = "Инструменты";
			$navMenu ["7"] ["name"] = $navMenuDic['navigation_root_instruments'];
			$navMenu ["7"] ["url"] = "/instruments";
			$navMenu ["7"] ["count_list_main"] = "";
			$navMenu ["7"] ["list"] = array ();
			$navMenu ["7"] ["list"] ["1"] ["name"] = "Фискальный регистратор";
			$navMenu ["7"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_fiskal'];
			$navMenu ["7"] ["list"] ["1"] ["url"] = "/instruments";
			$navMenu ["7"] ["list"] ["1"] ["count_list"] = "";
			// $navMenu["7"]["list"]["1"]["name"] = "Мария 301";
			// $navMenu["7"]["list"]["1"]["url"] = "/instruments";
			// $navMenu["7"]["list"]["2"]["name"] = "Мария 301 +";
			// $navMenu["7"]["list"]["2"]["url"] = "/tools";
		}

		$navMenu ["14"] ["name"] = "Почта";
		$navMenu ["14"] ["name"] = $navMenuDic['navigation_root_mail'];

		$navMenu ["14"] ["url"] = "/mailbox/messageslist/1/1";

		if ($isread_messages_count != 0) {

			$navMenu ["14"] ["count_list_main"] = '<span id="email-ind"">' . $isread_messages_count . '</span>';
		} else {
			$navMenu ["14"] ["count_list_main"] = "";
		}

		$navMenu ["14"] ["list"] = array ();
		$navMenu ["14"] ["list"] ["1"] ["name"] = "Входящие";
		$navMenu ["14"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_messageslist'];
		$navMenu ["14"] ["list"] ["1"] ["url"] = "/mailbox/messageslist/1/1";
		$navMenu ["14"] ["list"] ["1"] ["count_list"] = "";
		$navMenu ["14"] ["list"] ["2"] ["name"] = "Новые";
		$navMenu ["14"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_newmessageslist'];
		$navMenu ["14"] ["list"] ["2"] ["url"] = "/mailbox/messageslist/1/2";
		if ($isread_messages_count != 0) {
			$navMenu ["14"] ["list"] ["2"] ["count_list"] = '<span class="redAlert">' . $isread_messages_count . '</span>';
		} else {
			$navMenu ["14"] ["list"] ["2"] ["count_list"] = "";
		}
		$navMenu ["14"] ["list"] ["3"] ["name"] = "Важные";
		$navMenu ["14"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_messageslist2'];
		$navMenu ["14"] ["list"] ["3"] ["url"] = "/mailbox/messageslist/1/3";
		if ($important_messages_count != 0) {
			$navMenu ["14"] ["list"] ["3"] ["count_list"] = '<span class="redAlert">' . $important_messages_count . '</span>';
		} else {
			$navMenu ["14"] ["list"] ["3"] ["count_list"] = "";
		}

		if ($_SESSION ['user'] ['isadministrator'] == 1) {
			$navMenu ["8"] ["name"] = "Настройки";
			$navMenu ["8"] ["name"] = $navMenuDic['navigation_root_configuration'];
			$navMenu ["8"] ["url"] = "/home/adminpage";
			$navMenu ["8"] ["count_list_main"] = "";
			$navMenu ["8"] ["list"] = array ();

			$navMenu ["11"] ["name"] = "Синхронизация";
			$navMenu ["11"] ["name"] = $navMenuDic['navigation_root_channelmanager'];
			$navMenu ["11"] ["url"] = "/chmanager/uploadrates";
			$navMenu ["11"] ["count_list_main"] = "";
			$navMenu ["11"] ["list"] = array ();

			if ($_SESSION ['user'] ['login'] == "volodimir@cellreload.com" or $_SESSION ['user'] ['login'] == "ferents.yurij@gmail.com" or $_SESSION ['user'] ['login'] == "support@otelms.com" or $_SESSION ['user'] ['login'] == "volodimir@dealpak.com.ua") {
				$navMenu ["12"] ["name"] = "Мастерская";
				$navMenu ["12"] ["name"] = $navMenuDic['navigation_root_adminpage'];
				// $navMenu["9"]["url"] = "/reservations/ReservationList2/1/8";
				$navMenu ["12"] ["url"] = "/home/adminpage_v";
				$navMenu ["12"] ["count_list_main"] = "";
				$navMenu ["12"] ["list"] = array ();

				$navMenu ["12"] ["list"] ["4"] ["name"] = "Закрытие дня";
				$navMenu ["12"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_reservationdaylist'];
				$navMenu ["12"] ["list"] ["4"] ["url"] = "/reservations/ReservationDayList/1";
				$navMenu ["12"] ["list"] ["4"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["5"] ["name"] = "Неправильные брони";
				$navMenu ["12"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist2'];
				$navMenu ["12"] ["list"] ["5"] ["url"] = "/reservations/ReservationList2/1/7";
				$navMenu ["12"] ["list"] ["5"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["6"] ["name"] = "Нету deskofdays";
				$navMenu ["12"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist2_1'];
				$navMenu ["12"] ["list"] ["6"] ["url"] = "/reservations/ReservationList2/1/8";
				$navMenu ["12"] ["list"] ["6"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["7"] ["name"] = "deskofdays без резервации";
				$navMenu ["12"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist2_2'];
				$navMenu ["12"] ["list"] ["7"] ["url"] = "/reservations/ReservationList2/1/9";
				$navMenu ["12"] ["list"] ["7"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["8"] ["name"] = "Брони с общими днями";
				$navMenu ["12"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist2_3'];
				$navMenu ["12"] ["list"] ["8"] ["url"] = "/reservations/ReservationList2/1/10";
				$navMenu ["12"] ["list"] ["8"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["9"] ["name"] = "Брони без номера";
				$navMenu ["12"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist2_4'];
				$navMenu ["12"] ["list"] ["9"] ["url"] = "/reservations/Reservation_noroom_List/";
				$navMenu ["12"] ["list"] ["9"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["10"] ["name"] = "!-Не закрытые брони";
				$navMenu ["12"] ["list"] ["10"] ["name"] = $navMenuDic['navigation_root_reservationlist2_5'];
				$navMenu ["12"] ["list"] ["10"] ["url"] = "/reservations/ReservationList2/1/3";
				$navMenu ["12"] ["list"] ["10"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["11"] ["name"] = "!-Не поселенные брони";
				$navMenu ["12"] ["list"] ["11"] ["name"] = $navMenuDic['navigation_root_reservationlist2_6'];
				$navMenu ["12"] ["list"] ["11"] ["url"] = "/reservations/ReservationList2/1/4";
				$navMenu ["12"] ["list"] ["11"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["12"] ["name"] = "!-Не оплаченные брони";
				$navMenu ["12"] ["list"] ["12"] ["name"] = $navMenuDic['navigation_root_reservationlist2_7'];
				$navMenu ["12"] ["list"] ["12"] ["url"] = "/reservations/ReservationList2/1/11";
				$navMenu ["12"] ["list"] ["12"] ["count_list"] = "";
				$navMenu ["12"] ["list"] ["13"] ["name"] = "Форма Тест";
				$navMenu ["12"] ["list"] ["13"] ["name"] = $navMenuDic['navigation_root_amountupdate'];
				$navMenu ["12"] ["list"] ["13"] ["url"] = "/reservations/amountupdate";
				$navMenu ["12"] ["list"] ["13"] ["count_list"] = "";
			}
		}

		$customdebug = $this->frontdesk->get_customdebug ();
		$html_version = $this->frontdesk->get_html_version ();

		//if ((strpos($customdebug, 'hmsc2=true') !== FALSE) || ($html_version == 1)) {
			$navMenu ["16"] ["name"] = "HMS v2.0";
			$navMenu ["16"] ["url"] = "/reservation_c2/calendar";
			$navMenu ["16"] ["count_list_main"] = "";
			$navMenu ["16"] ["list"] = array ();
		//}
		if (false) {
			$navMenu ["13"] ["name"] = "helpcenter";
			$navMenu ["13"] ["url"] = "/helpcenter";
			$navMenu ["13"] ["count_list_main"] = "";
			$navMenu ["13"] ["list"] ["3"] ["count_list"] = "";
			$navMenu ["13"] ["list"] = array ();
			$navMenu ["13"] ["list"] ["1"] ["name"] = "helpcenter";
			$navMenu ["13"] ["list"] ["1"] ["url"] = "/helpcenter";
			$navMenu ["13"] ["list"] ["1"] ["count_list"] = "";
		}
		// echo "<pre>";
		// print_r($navMenu);
		return $navMenu;
	}
	function getadminmenulist() {
		$adminMenu = array ();

		$navMenuDic = array();
	    $this->mlanguages->getdictionary("navigation_root_list", "", $navMenuDic);



		$adminMenu ["admin"] ["11"] ["name"] = "Базовое";
		$adminMenu ["admin"] ["11"] ["name"] = $navMenuDic['navigation_root_adminnode_11'];

		//$adminMenu ["admin"] ["11"] ["name"] = $navMenuDic['navigation_admin_amountupdate'];
		$adminMenu ["admin"] ["11"] ["url"] = "/admin_dealers/DealersList/1";
		$adminMenu ["admin"] ["11"] ["list"] = array ();
		$adminMenu ["admin"] ["11"] ["list"] ["1"] ["name"] = "Диллеры";
		$adminMenu ["admin"] ["11"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_11_1'];
		$adminMenu ["admin"] ["11"] ["list"] ["1"] ["url"] = "/admin_dealers/DealersList/1";
		$adminMenu ["admin"] ["11"] ["list"] ["2"] ["name"] = "Контрагенты";
		$adminMenu ["admin"] ["11"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_11_2'];
		$adminMenu ["admin"] ["11"] ["list"] ["2"] ["url"] = "/admin_partners/PartnersList/1";
		$adminMenu ["admin"] ["11"] ["list"] ["3"] ["name"] = "Типы платежей";
		$adminMenu ["admin"] ["11"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_11_3'];
		$adminMenu ["admin"] ["11"] ["list"] ["3"] ["url"] = "/admin_payment/PaymentType";
		$adminMenu ["admin"] ["11"] ["list"] ["4"] ["name"] = "Услуги";
		$adminMenu ["admin"] ["11"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_adminnode_11_4'];
		$adminMenu ["admin"] ["11"] ["list"] ["4"] ["url"] = "/admin_reservations/ServicesType";
		$adminMenu ["admin"] ["11"] ["list"] ["6"] ["name"] = "Услуги базовые";
		$adminMenu ["admin"] ["11"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_adminnode_11_6'];
		$adminMenu ["admin"] ["11"] ["list"] ["6"] ["url"] = "/admin_reservations/MainServicesType";
		$adminMenu ["admin"] ["11"] ["list"] ["5"] ["name"] = "Шаблоны";
		$adminMenu ["admin"] ["11"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_adminnode_11_5'];
		$adminMenu ["admin"] ["11"] ["list"] ["5"] ["url"] = "/admin_partners/Templates";

		// $adminMenu ["admin"]["11"] ["list"] ["6"] ["name"] = "on-line
		// booking";
		// $adminMenu ["admin"]["11"] ["list"] ["6"] ["url"] =
		// "/admin_gateway/gateway_config";
		$adminMenu ["admin"] ["11"] ["list"] ["7"] ["name"] = "Дополнительно";
		$adminMenu ["admin"] ["11"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_adminnode_11_7'];
		$adminMenu ["admin"] ["11"] ["list"] ["7"] ["url"] = "/admin_payment/pay_config";
		$adminMenu ["admin"] ["11"] ["list"] ["8"] ["name"] = "Фискальный регистратор";
		$adminMenu ["admin"] ["11"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_adminnode_11_8'];
		$adminMenu ["admin"] ["11"] ["list"] ["8"] ["url"] = "/admin_payment/fiscal_reestrator/1";
		$adminMenu ["admin"] ["11"] ["list"] ["9"] ["name"] = "Дисконтные карты";
		$adminMenu ["admin"] ["11"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_adminnode_11_9'];
		$adminMenu ["admin"] ["11"] ["list"] ["9"] ["url"] = "/admin_discount/dlist";

		$adminMenu ["admin"] ["12"] ["name"] = "Номера";
		$adminMenu ["admin"] ["12"] ["name"] = $navMenuDic['navigation_root_adminnode_12'];
		$adminMenu ["admin"] ["12"] ["url"] = "/admin_rooms/RoomList/1";
		$adminMenu ["admin"] ["12"] ["list"] = array ();
		$adminMenu ["admin"] ["12"] ["list"] ["1"] ["name"] = "Номера";
		$adminMenu ["admin"] ["12"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_12_1'];
		$adminMenu ["admin"] ["12"] ["list"] ["1"] ["url"] = "/admin_rooms/RoomList/1";
		$adminMenu ["admin"] ["12"] ["list"] ["2"] ["name"] = "Категории номеров";
		$adminMenu ["admin"] ["12"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_12_2'];
		$adminMenu ["admin"] ["12"] ["list"] ["2"] ["url"] = "/admin_roomscategories/";
		$adminMenu ["admin"] ["12"] ["list"] ["3"] ["name"] = "Комплектации";
		$adminMenu ["admin"] ["12"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_12_3'];
		$adminMenu ["admin"] ["12"] ["list"] ["3"] ["url"] = "/admin_rooms/equipment";
		$adminMenu ["admin"] ["12"] ["list"] ["4"] ["name"] = "Этаж";
		$adminMenu ["admin"] ["12"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_adminnode_12_4'];
		$adminMenu ["admin"] ["12"] ["list"] ["4"] ["url"] = "/admin_rooms/floor";
		$adminMenu ["admin"] ["12"] ["list"] ["5"] ["name"] = "Сторона";
		$adminMenu ["admin"] ["12"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_adminnode_12_5'];
		$adminMenu ["admin"] ["12"] ["list"] ["5"] ["url"] = "/admin_rooms/side";
		$adminMenu ["admin"] ["12"] ["list"] ["6"] ["name"] = "Зоны обслуживания";
		$adminMenu ["admin"] ["12"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_adminnode_12_6'];
		$adminMenu ["admin"] ["12"] ["list"] ["6"] ["url"] = "/admin_rooms/zone";

		$adminMenu ["admin"] ["13"] ["name"] = "Сезоны и тарифы";
		$adminMenu ["admin"] ["13"] ["name"] = $navMenuDic['navigation_root_adminnode_13'];
		$adminMenu ["admin"] ["13"] ["url"] = "/admin_seasons/";
		$adminMenu ["admin"] ["13"] ["list"] = array ();
		$adminMenu ["admin"] ["13"] ["list"] ["1"] ["name"] = "Сезоны";
		$adminMenu ["admin"] ["13"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_13_1'];
		$adminMenu ["admin"] ["13"] ["list"] ["1"] ["url"] = "/admin_seasons/";
		$adminMenu ["admin"] ["13"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu ["admin"] ["13"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_13_2'];
		$adminMenu ["admin"] ["13"] ["list"] ["2"] ["url"] = "/admin_rates/RateList/1";
		$adminMenu ["admin"] ["13"] ["list"] ["3"] ["name"] = "Приоритетные цены";
		$adminMenu ["admin"] ["13"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_13_3'];
		$adminMenu ["admin"] ["13"] ["list"] ["3"] ["url"] = "/chmanager/deskofrates_price";
		$adminMenu ["admin"] ["13"] ["list"] ["5"] ["name"] = "Тарифы on-line";
		$adminMenu ["admin"] ["13"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_adminnode_13_5'];
		$adminMenu ["admin"] ["13"] ["list"] ["5"] ["url"] = "/admin_onlinerates/RateList/1";
		$adminMenu ["admin"] ["13"] ["list"] ["6"] ["name"] = "Скидки on-line";
		$adminMenu ["admin"] ["13"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_adminnode_13_6'];
		$adminMenu ["admin"] ["13"] ["list"] ["6"] ["url"] = "/admin_onlinediscount/DiscountList/1";
		$adminMenu ["admin"] ["13"] ["list"] ["4"] ["name"] = "Ограничения";
		$adminMenu ["admin"] ["13"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_adminnode_13_4'];
		$adminMenu ["admin"] ["13"] ["list"] ["4"] ["url"] = "/restrictions/restrictionsList/1";
		// $adminMenu ["admin"] ["13"] ["list"] ["7"] ["name"] = "Доска ограничений";
		// $adminMenu ["admin"] ["13"] ["list"] ["7"] ["url"] = "/chmanager/deskofrates";

		$adminMenu ["admin"] ["14"] ["name"] = "Отчеты";
		$adminMenu ["admin"] ["14"] ["name"] = $navMenuDic['navigation_root_adminnode_14'];
		$adminMenu ["admin"] ["14"] ["url"] = "/admin_logers/LogList/1";
		$adminMenu ["admin"] ["14"] ["list"] = array ();
		$adminMenu ["admin"] ["14"] ["list"] ["1"] ["name"] = "Журнал";
		$adminMenu ["admin"] ["14"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_14_1'];
		$adminMenu ["admin"] ["14"] ["list"] ["1"] ["url"] = "/admin_logers/LogList/1";
		$adminMenu ["admin"] ["14"] ["list"] ["2"] ["name"] = "Журнал админ. изменений";
		$adminMenu ["admin"] ["14"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_14_2'];
		$adminMenu ["admin"] ["14"] ["list"] ["2"] ["url"] = "/admin_logers/AdminLogList/1";
		$adminMenu ["admin"] ["14"] ["list"] ["3"] ["name"] = "Журнал dc setup изменений";
		//$adminMenu ["admin"] ["14"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_14_2'];
		$adminMenu ["admin"] ["14"] ["list"] ["3"] ["url"] = "/admin_logers/AdminLogList_dc_setup/1";

		$adminMenu ["admin"] ["15"] ["name"] = "Пользователи";
		$adminMenu ["admin"] ["15"] ["name"] = $navMenuDic['navigation_root_adminnode_15'];
		$adminMenu ["admin"] ["15"] ["url"] = "/admin_users/UserList/1";
		$adminMenu ["admin"] ["15"] ["list"] = array ();
		$adminMenu ["admin"] ["15"] ["list"] ["1"] ["name"] = "Список пользователей";
		$adminMenu ["admin"] ["15"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_15_1'];
		$adminMenu ["admin"] ["15"] ["list"] ["1"] ["url"] = "/admin_users/UserList/1";
		$adminMenu ["admin"] ["15"] ["list"] ["3"] ["name"] = "Права доступа";
		$adminMenu ["admin"] ["15"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_15_3'];
		$adminMenu ["admin"] ["15"] ["list"] ["3"] ["url"] = "/admin_users/page_access_list/";
		$adminMenu ["admin"] ["15"] ["list"] ["2"] ["name"] = "Групы";
		$adminMenu ["admin"] ["15"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_15_2'];
		$adminMenu ["admin"] ["15"] ["list"] ["2"] ["url"] = "/admin_users/GroupList/1";

		$adminMenu ["admin"] ["22"] ["name"] = "Оформление";
		$adminMenu ["admin"] ["22"] ["name"] = $navMenuDic['navigation_root_adminnode_22'];
		$adminMenu ["admin"] ["22"] ["url"] = "/admin_markers/MarkersList/1";
		$adminMenu ["admin"] ["22"] ["list"] = array ();
		$adminMenu ["admin"] ["22"] ["list"] ["1"] ["name"] = "Маркеры";
		$adminMenu ["admin"] ["22"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_22_1'];
		$adminMenu ["admin"] ["22"] ["list"] ["1"] ["url"] = "/admin_markers/MarkersList/1";
		$adminMenu ["admin"] ["22"] ["list"] ["2"] ["name"] = "Доска заказов";
		$adminMenu ["admin"] ["22"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_22_2'];
		$adminMenu ["admin"] ["22"] ["list"] ["2"] ["url"] = "/admin_markers/reservation_board";

		$adminMenu ["admin"] ["16"] ["name"] = "Разное";
		$adminMenu ["admin"] ["16"] ["name"] = $navMenuDic['navigation_root_adminnode_16'];
		$adminMenu ["admin"] ["16"] ["url"] = "/admin_dealers/DealersList/1";
		$adminMenu ["admin"] ["16"] ["list"] = array ();
		$adminMenu ["admin"] ["16"] ["list"] ["1"] ["name"] = "Пересчитать заказы";
		$adminMenu ["admin"] ["16"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_16_1'];
		$adminMenu ["admin"] ["16"] ["list"] ["1"] ["url"] = "/admin_dealers/DealersList/1";
		$adminMenu ["admin"] ["16"] ["list"] ["2"] ["name"] = "Мастер начальной настройки";
		$adminMenu ["admin"] ["16"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_16_2'];
		$adminMenu ["admin"] ["16"] ["list"] ["2"] ["url"] = "/wizard/step1";
		/*
		 * if ($_SESSION ["channel_manager"] == true) { $adminMenu ["admin"] ["19"] ["name"] = "Менеджер каналов"; $adminMenu ["admin"] ["19"] ["url"] = "/channelmanager/Links"; $adminMenu ["admin"] ["19"] ["list"] = array (); $adminMenu ["admin"] ["19"] ["list"] ["1"] ["name"] = "Связи"; $adminMenu ["admin"] ["19"] ["list"] ["1"] ["url"] = "/channelmanager/Links"; $adminMenu ["admin"] ["19"] ["list"] ["2"] ["name"] = "Параметры"; $adminMenu ["admin"] ["19"] ["list"] ["2"] ["url"] = "/channelmanager/Parameters"; $adminMenu ["admin"] ["19"] ["list"] ["3"] ["name"] = "Експорт"; $adminMenu ["admin"] ["19"] ["list"] ["3"] ["url"] = "/channelmanager/Export"; $adminMenu ["admin"] ["19"] ["list"] ["5"] ["name"] = "Експорт2"; $adminMenu ["admin"] ["19"] ["list"] ["5"] ["url"] = "/channelmanager/Export2"; $adminMenu ["admin"] ["19"] ["list"] ["4"] ["name"] = "setfreerooms"; $adminMenu ["admin"] ["19"] ["list"] ["4"] ["url"] = "/channelmanager/setfreerooms"; }
		 */
		$adminMenu ["admin"] ["20"] ["name"] = "Оплаты";
		$adminMenu ["admin"] ["20"] ["name"] = $navMenuDic['navigation_root_adminnode_20'];
		$adminMenu ["admin"] ["20"] ["url"] = "/billing/payment";
		$adminMenu ["admin"] ["20"] ["list"] = array ();
		$adminMenu ["admin"] ["20"] ["list"] ["1"] ["name"] = "Оплаты";
		$adminMenu ["admin"] ["20"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_20_1'];
		$adminMenu ["admin"] ["20"] ["list"] ["1"] ["url"] = "/billing/payment";

		$adminMenu ["admin"] ["21"] ["name"] = "BSO";
		$adminMenu ["admin"] ["21"] ["name"] = $navMenuDic['navigation_root_adminnode_21'];
		$adminMenu ["admin"] ["21"] ["url"] = "/bso/options";
		$adminMenu ["admin"] ["21"] ["list"] = array ();
		$adminMenu ["admin"] ["21"] ["list"] ["1"] ["name"] = "БСО настройки";
		$adminMenu ["admin"] ["21"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_adminnode_21_1'];
		$adminMenu ["admin"] ["21"] ["list"] ["1"] ["url"] = "/bso/options";
		$adminMenu ["admin"] ["21"] ["list"] ["2"] ["name"] = "БСО принтеры";
		$adminMenu ["admin"] ["21"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_adminnode_21_2'];
		$adminMenu ["admin"] ["21"] ["list"] ["2"] ["url"] = "/bso/account_list";

		$adminMenu ["admin"] ["21"] ["list"] ["3"] ["name"] = "ФМС настройки";
		$adminMenu ["admin"] ["21"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_adminnode_21_3'];
		$adminMenu ["admin"] ["21"] ["list"] ["3"] ["url"] = "/fms/options";
		$adminMenu ["admin"] ["21"] ["list"] ["4"] ["name"] = "ФМС агенты";
		$adminMenu ["admin"] ["21"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_adminnode_21_4'];
		$adminMenu ["admin"] ["21"] ["list"] ["4"] ["url"] = "/fms/account_list";
		$adminMenu ["admin"] ["21"] ["list"] ["5"] ["name"] = "ФМС ответственные";
		$adminMenu ["admin"] ["21"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_adminnode_21_5'];
		$adminMenu ["admin"] ["21"] ["list"] ["5"] ["url"] = "/fms/users";
		return $adminMenu;
	}
	function getadminmenulist_2() {
	    $navMenuDic = array();
	    $this->mlanguages->getdictionary("navigation_root_list", "", $navMenuDic);
	    $this->mlanguages->getdictionary("dc_airbnb_c2", "", $navMenuDic);

		$adminMenu_authorize = array ();

		$adminMenu_authorize ["admin"] ["33"] ["name"] = "Каналы";
		$adminMenu_authorize ["admin"] ["33"] ["name"] = $navMenuDic['navigation_root_reservationlist_33'];
		$adminMenu_authorize ["admin"] ["33"] ["url"] = "/chmanager/chanel_list";
		$adminMenu_authorize ["admin"] ["33"] ["url_c2"] = "/chmanager_c2/chanel_list";
		$adminMenu_authorize ["admin"] ["33"] ["list"] = array ();

		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["1"] ["url"] = "/dc_booking/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["1"] ["url_c2"] = "/dc_booking_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["7"] ["url"] = "/dc_booking/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["7"] ["url_c2"] = "/dc_booking_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["2"] ["url"] = "/dc_booking/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["2"] ["url_c2"] = "/dc_booking_c2/rates_edit";
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_3'];
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["3"] ["url"] = "/dc_booking/syncform";
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_5'];
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["5"] ["url"] = "/dc_booking/xml_availability_form";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["6"] ["url"] = "/dc_booking/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["6"] ["url_c2"] = "/dc_booking_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["8"] ["url"] = "/dc_booking/options";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["8"] ["url_c2"] = "/dc_booking_c2/options";
// 	if($this->hotelix_config->get_record("booking_opportunities_show", "int") == 1){
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["9"] ["name"] = "Возможности";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_9'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["9"] ["url"] = "/dc_booking/opportunities";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["9"] ["url_c2"] = "/dc_booking_c2/opportunities";
// 	}
		if ($this->releases->booking_scores() == 1) {
		//$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["11"] ["name"] = "Рейтинг отелей";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["11"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_11'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["11"] ["url"] = "/dc_booking/property_score";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["11"] ["url_c2"] = "/dc_booking_c2/property_score";
		}

//		if($this->hotelix_config->get_record("booking_promotions_show", "int") == 1){
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["10"] ["name"] = "Спецпредложения";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["10"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_10'];
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["10"] ["url"] = "/dc_booking/promotion";
		$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["10"] ["url_c2"] = "/dc_booking_c2/promotions_list";
//		}

		
		$develop = $this->session->userdata('global_modify') ? true : false;
		if ($develop) {
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["name"] = "Contracts";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["name"] = 'Contracts';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["url"] = "dc_booking_c2/contracts_list";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["url_c2"] = "/dc_booking_c2/contracts_list";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["13"] ["name"] = "Properties";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["13"] ["name"] = 'Properties';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["13"] ["url"] = "dc_booking_c2/properties_list";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["13"] ["url_c2"] = "/dc_booking_c2/properties_list";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["14"] ["name"] = "Rooms";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["14"] ["name"] = 'Rooms';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["14"] ["url"] = "dc_booking_c2/rooms_list";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["14"] ["url_c2"] = "/dc_booking_c2/rooms_list";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["15"] ["name"] = "Rates";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["15"] ["name"] = 'Rates';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["15"] ["url"] = "dc_booking_c2/rates_list";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["15"] ["url_c2"] = "/dc_booking_c2/rates_list";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["16"] ["name"] = "Restaurant";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["16"] ["name"] = 'Restaurant';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["16"] ["url"] = "dc_booking_c2/restaurant";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["16"] ["url_c2"] = "/dc_booking_c2/restaurant";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["17"] ["name"] = "License";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["17"] ["name"] = 'License';
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["17"] ["url"] = "/dc_booking_fsi/license";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["17"] ["url_c2"] = "/dc_booking_fsi/license";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["18"] ["name"] = "Upload photos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["18"] ["name"] = 'Upload photos';
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["18"] ["url"] = "/dc_booking_fsi/upload_fotos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["18"] ["url_c2"] = "/dc_booking_fsi/upload_fotos";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["19"] ["name"] = "Photos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["19"] ["name"] = 'Photos';
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["19"] ["url"] = "/dc_booking_fsi/photos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["19"] ["url_c2"] = "/dc_booking_fsi/photos";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["20"] ["name"] = "Panoramic photos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["20"] ["name"] = 'Panoramic photos';
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["20"] ["url"] = "/dc_booking_fsi/panoramic_photos";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["20"] ["url_c2"] = "/dc_booking_fsi/panoramic_photos";
		    
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["21"] ["name"] = "Gallery";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["21"] ["name"] = 'Gallery';
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["21"] ["url"] = "/dc_booking_fsi/get_gallery";
		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["21"] ["url_c2"] = "/dc_booking_fsi/get_gallery";
		}
		
		
// 		if ($this->releases->booking_messages() == 1) {
// 		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["name"] = "{clt_messages}";
// 		    //$adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_12'];
// 		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["url"] = "";
// 		    $adminMenu_authorize ["admin"] ["33"] ["1"] ["list"] ["12"] ["url_c2"] = "/dc_booking_c2/messages_list";
// 		}

		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_1'];
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["1"] ["url"] = "/dc_ostrovok/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["1"] ["url_c2"] = "/dc_ostrovok_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_7'];
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["7"] ["url"] = "/dc_ostrovok/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["7"] ["url_c2"] = "/dc_ostrovok_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_2'];
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["2"] ["url"] = "/dc_ostrovok/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["2"] ["url_c2"] = "/dc_ostrovok_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["3"] ["url"] = "/dc_ostrovok/uploadrates";
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["5"] ["url"] = "/dc_ostrovok/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_6'];
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["6"] ["url"] = "/dc_ostrovok/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["6"] ["url_c2"] = "/dc_ostrovok_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_2_8'];
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["8"] ["url"] = "/dc_ostrovok/options";
		$adminMenu_authorize ["admin"] ["33"] ["2"] ["list"] ["8"] ["url_c2"] = "/dc_ostrovok_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_1'];
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["1"] ["url"] = "/dc_hostelsclub/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["1"] ["url_c2"] = "/dc_hostelsclub_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_7'];
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["7"] ["url"] = "/dc_hostelsclub/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["7"] ["url_c2"] = "/dc_hostelsclub_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_2'];
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["2"] ["url"] = "/dc_hostelsclub/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["2"] ["url_c2"] = "/dc_hostelsclub_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["5"] ["name"] = "Выгрузка номеров";
// 		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["5"] ["url"] = "/dc_hostelsclub/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_6'];
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["6"] ["url"] = "/dc_hostelsclub/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["6"] ["url_c2"] = "/dc_hostelsclub_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_3_8'];
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["8"] ["url"] = "/dc_hostelsclub/options";
		$adminMenu_authorize ["admin"] ["33"] ["3"] ["list"] ["8"] ["url_c2"] = "/dc_hostelsclub_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_4_1'];
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["1"] ["url"] = "/dc_hostelworld/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["1"] ["url_c2"] = "/dc_hostelworld_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_4_7'];
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["7"] ["url"] = "/dc_hostelworld/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["7"] ["url_c2"] = "/dc_hostelworld_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_4_2'];
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["2"] ["url"] = "/dc_hostelworld/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["2"] ["url_c2"] = "/dc_hostelworld_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["5"] ["name"] = "Выгрузка номеров";
// 		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["5"] ["name"] = $navMenuDic ['navigation_root_reservationlist_33_4_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["5"] ["url"] = "/dc_hostelworld/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_4_6'];
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["6"] ["url"] = "/dc_hostelworld/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["6"] ["url_c2"] = "/dc_hostelworld_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_4_8'];
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["8"] ["url"] = "/dc_hostelworld/options";
		$adminMenu_authorize ["admin"] ["33"] ["4"] ["list"] ["8"] ["url_c2"] = "/dc_hostelworld_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["1"] ["url"] = "/dc_expedia/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["1"] ["url_c2"] = "/dc_expedia_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["7"] ["url"] = "/dc_expedia/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["7"] ["url_c2"] = "/dc_expedia_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["2"] ["url"] = "/dc_expedia/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["2"] ["url_c2"] = "/dc_expedia_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["3"] ["url"] = "/dc_expedia/uploadrates";
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["5"] ["url"] = "/dc_expedia/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["6"] ["url"] = "/dc_expedia/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["6"] ["url_c2"] = "/dc_expedia_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["8"] ["url"] = "/dc_expedia/options";
		$adminMenu_authorize ["admin"] ["33"] ["5"] ["list"] ["8"] ["url_c2"] = "/dc_expedia_c2/options";
		if ($this->releases->dc_expedia_promo() == 1) {

                // -------------------------------------------------------------------------------------------------------------------
            $adminMenu_authorize["admin"]["33"]["5"]["list"]["9"]["name"] = "Промоакции";
            $adminMenu_authorize["admin"]["33"]["5"]["list"]["9"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_9'];
            $adminMenu_authorize["admin"]["33"]["5"]["list"]["9"]["url"] = "/dc_expedia_promo/get_promotions";
            $adminMenu_authorize["admin"]["33"]["5"]["list"]["9"]["url_c2"] = "/dc_expedia_promo/get_promotions";
		    // -------------------------------------------------------------------------------------------------------------------
		}
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_1'];
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["1"] ["url"] = "/dc_agoda/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["1"] ["url_c2"] = "/dc_agoda_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["7"] ["url"] = "/dc_agoda/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["7"] ["url_c2"] = "/dc_agoda_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_2'];
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["2"] ["url"] = "/dc_agoda/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["2"] ["url_c2"] = "/dc_agoda_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["3"] ["url"] = "/dc_agoda/uploadrates";
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["5"] ["url"] = "/dc_agoda/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["6"] ["url"] = "/dc_agoda/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["6"] ["url_c2"] = "/dc_agoda_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["8"] ["url"] = "/dc_agoda/options";
		$adminMenu_authorize ["admin"] ["33"] ["6"] ["list"] ["8"] ["url_c2"] = "/dc_agoda_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_1'];
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["1"] ["url"] = "/dc_hotel_inn/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["1"] ["url_c2"] = "/dc_hotel_inn_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_7'];
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["7"] ["url"] = "/dc_hotel_inn/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["7"] ["url_c2"] = "/dc_hotel_inn_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_2'];
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["2"] ["url"] = "/dc_hotel_inn/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["2"] ["url_c2"] = "/dc_hotel_inn_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["3"] ["url"] = "/dc_hotel_inn/syncform";
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["5"] ["url"] = "/dc_hotel_inn/xml_availability_form";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_6'];
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["6"] ["url"] = "/dc_hotel_inn/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["6"] ["url_c2"] = "/dc_hotel_inn_c2/reservations_form";
		//$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["8"] ["name"] = "Цены и ограничения";
		//$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_8'];
		//$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["8"] ["url"] = "/dc_hotel_inn/setrestrict";
		//$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["8"] ["url_c2"] = "/dc_hotel_inn_c2/setrestrict";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["9"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_9'];
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["9"] ["url"] = "/dc_hotel_inn/options";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["9"] ["url_c2"] = "/dc_hotel_inn_c2/options";
		$adminMenu_authorize ["admin"] ["33"] ["7"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_7_9'];

		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_1'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["1"] ["url"] = "/dc_oktogo/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["1"] ["url_c2"] = "/dc_oktogo_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_7'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["7"] ["url"] = "/dc_oktogo/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["7"] ["url_c2"] = "/dc_oktogo_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_2'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["2"] ["url"] = "/dc_oktogo/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["2"] ["url_c2"] = "/dc_oktogo_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["3"] ["url"] = "/dc_oktogo/syncform";
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["5"] ["url"] = "/dc_oktogo/xml_availability_form";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_6'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["6"] ["url"] = "/dc_oktogo/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["6"] ["url_c2"] = "/dc_oktogo_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["8"] ["name"] = "Цены и ограничения";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_8'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["8"] ["url"] = "/dc_oktogo/setrestrict";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["8"] ["url_c2"] = "/dc_oktogo_c2/setrestrict";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["9"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_8_9'];
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["9"] ["url"] = "/dc_oktogo/options";
		$adminMenu_authorize ["admin"] ["33"] ["8"] ["list"] ["9"] ["url_c2"] = "/dc_oktogo_c2/options";


		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_1'];
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["1"] ["url"] = "/dc_101otel/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["1"] ["url_c2"] = "/dc_101otel_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_7'];
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["7"] ["url"] = "/dc_101otel/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["7"] ["url_c2"] = "/dc_101otel_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_2'];
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["2"] ["url"] = "/dc_101otel/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["2"] ["url_c2"] = "/dc_101otel_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["3"] ["url"] = "/dc_101otel/uploadrates";
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["5"] ["url"] = "/dc_101otel/upload_rooms";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_6'];
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["6"] ["url"] = "/dc_101otel/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["6"] ["url_c2"] = "/dc_101otel_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["9"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_9_9'];
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["9"] ["url"] = "/dc_101otel/options";
		$adminMenu_authorize ["admin"] ["33"] ["9"] ["list"] ["9"] ["url_c2"] = "/dc_101otel_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["1"] ["name"] = "Guestbe.com";
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_10_1'];
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["1"] ["url"] = "/admin_gateway/gateway_config";
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["1"] ["url_c2"] = "/admin_gateway_c2/gateway_config";
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["2"] ["name"] = "Персональный модуль";
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_10_2'];
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["2"] ["url"] = "/admin_gateway/gateway_config_personal";
		$adminMenu_authorize ["admin"] ["33"] ["10"] ["list"] ["2"] ["url_c2"] = "/admin_gateway_c2/gateway_config_personal";

		$wubook_activity = $this->dcm_wubook->get_wubook_activity ();
		if ($wubook_activity == 1) {

			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["1"] ["name"] = "Параметры загруженности";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["1"] ["url"] = "/dc_wubook/ra_params_edit";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["1"] ["url_c2"] = "/dc_wubook_c2/ra_params_edit";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["7"] ["name"] = "Категории";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["7"] ["url"] = "/dc_wubook/catgories_edit";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["7"] ["url_c2"] = "/dc_wubook_c2/catgories_edit";

// 			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["5"] ["url"] = "/dc_wubook/upload_rooms";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["6"] ["name"] = "Загрузка заказов";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["6"] ["url"] = "/dc_wubook/reservations_form";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["6"] ["url_c2"] = "/dc_wubook_c2/reservations_form";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["9"] ["name"] = "Настройки";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["9"] ["url"] = "/dc_wubook/options";
			$adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["9"] ["url_c2"] = "/dc_wubook_c2/options";
		}

		// $adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		// $adminMenu_authorize ["admin"] ["33"] ["11"] ["list"] ["1"] ["url"] = "/dc_101otel/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_12_7'];
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["7"] ["url"] = "/dc_hrs/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["7"] ["url_c2"] = "/dc_hrs_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["8"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_12_8'];
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["8"] ["url"] = "/dc_hrs/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["8"] ["url_c2"] = "/dc_hrs_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["name"] = "Группировка тарифов";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_12_11'];
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["url"] = "/dc_hrs/rate_list";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["url_c2"] = "/dc_hrs_c2/rate_list";
		// $adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["9"] ["name"] = "Выгрузка тарифов";
		// $adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["9"] ["url"] = "/dc_hrs/sync";
		// $adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["name"] = "Выгрузка загруженности";
		// $adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["11"] ["url"] = "/dc_hrs/upload_rooms";
		/*$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["12"] ["name"] = "Выгрузка тарифов";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["12"] ["url"] = "/dc_hrs/add_rate";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["13"] ["name"] = "Выгрузка доп. категорий";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["13"] ["url"] = "/dc_hrs/savecategory";
		*/
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_12_6'];
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["6"] ["url"] = "/dc_hrs/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["6"] ["url_c2"] = "/dc_hrs_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["10"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["10"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_12_10'];
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["10"] ["url"] = "/dc_hrs/options";
		$adminMenu_authorize ["admin"] ["33"] ["12"] ["list"] ["10"] ["url_c2"] = "/dc_hrs_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["5"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_13_5'];
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["5"] ["url"] = "/dc_vashotel/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["5"] ["url_c2"] = "/dc_vashotel_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["1"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_13_1'];
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["1"] ["url"] = "/dc_vashotel/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["1"] ["url_c2"] = "/dc_vashotel_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_13_2'];
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["2"] ["url"] = "/dc_vashotel/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["2"] ["url_c2"] = "/dc_vashotel_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["4"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_13_4'];
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["4"] ["url"] = "/dc_vashotel/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["4"] ["url_c2"] = "/dc_vashotel_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["3"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_13_3'];
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["3"] ["url"] = "/dc_vashotel/options";
		$adminMenu_authorize ["admin"] ["33"] ["13"] ["list"] ["3"] ["url_c2"] = "/dc_vashotel_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_1'];
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["1"] ["url"] = "/dc_bronevik/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["1"] ["url_c2"] = "/dc_bronevik_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_7'];
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["7"] ["url"] = "/dc_bronevik/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["7"] ["url_c2"] = "/dc_bronevik_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_2'];
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["2"] ["url"] = "/dc_bronevik/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["2"] ["url_c2"] = "/dc_bronevik_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["3"] ["name"] = "Выгрузка тарифов";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_3'];
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["3"] ["url"] = "/dc_bronevik/uploadrates";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["5"] ["name"] = "Выгрузка загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["5"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_5'];
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["5"] ["url"] = "/dc_bronevik/upload_rooms";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["6"] ["name"] = "Загрузка заказов";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_6'];
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["6"] ["url"] = "/dc_bronevik/reservations_form";
// 		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["6"] ["url_c2"] = "/dc_bronevik_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["9"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["9"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_14_9'];
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["9"] ["url"] = "/dc_bronevik/options";
		$adminMenu_authorize ["admin"] ["33"] ["14"] ["list"] ["9"] ["url_c2"] = "/dc_bronevik_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["1"] ["url"] = "/dc_hotels24/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["1"] ["url_c2"] = "/dc_hotels24_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["7"] ["url"] = "/dc_hotels24/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["7"] ["url_c2"] = "/dc_hotels24_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["2"] ["url"] = "/dc_hotels24/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["2"] ["url_c2"] = "/dc_hotels24_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["6"] ["url"] = "/dc_hotels24/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["6"] ["url_c2"] = "/dc_hotels24_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["8"] ["url"] = "/dc_hotels24/options";
		$adminMenu_authorize ["admin"] ["33"] ["15"] ["list"] ["8"] ["url_c2"] = "/dc_hotels24_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["1"] ["url"] = "/dc_ozon/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["1"] ["url_c2"] = "/dc_ozon_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["7"] ["url"] = "/dc_ozon/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["7"] ["url_c2"] = "/dc_ozon_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["2"] ["url"] = "/dc_ozon/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["2"] ["url_c2"] = "/dc_ozon_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["6"] ["url"] = "/dc_ozon/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["6"] ["url_c2"] = "/dc_ozon_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["8"] ["url"] = "/dc_ozon/options";
		$adminMenu_authorize ["admin"] ["33"] ["16"] ["list"] ["8"] ["url_c2"] = "/dc_ozon_c2/options";

// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["1"] ["name"] = "Параметры загруженности";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["1"] ["url"] = "/dc_tripadvisor/ra_params_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["1"] ["url_c2"] = "/dc_tripadvisor_c2/ra_params_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["7"] ["name"] = "Категории";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["7"] ["url"] = "/dc_tripadvisor/catgories_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["7"] ["url_c2"] = "/dc_tripadvisor_c2/catgories_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["2"] ["name"] = "Тарифы";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["2"] ["url"] = "/dc_tripadvisor/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["2"] ["url_c2"] = "/dc_tripadvisor_c2/rates_edit";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["6"] ["name"] = "Загрузка заказов";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["6"] ["url"] = "/dc_tripadvisor/reservations_form";
// 		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["6"] ["url_c2"] = "/dc_tripadvisor_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["8"] ["url"] = "/dc_tripadvisor/options";
		$adminMenu_authorize ["admin"] ["33"] ["17"] ["list"] ["8"] ["url_c2"] = "/dc_tripadvisor_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_1'];
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["1"] ["url"] = "/dc_hotelbook/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["1"] ["url_c2"] = "/dc_hotelbook_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["7"] ["url"] = "/dc_hotelbook/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["7"] ["url_c2"] = "/dc_hotelbook_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_2'];
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["2"] ["url"] = "/dc_hotelbook/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["2"] ["url_c2"] = "/dc_hotelbook_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["6"] ["url"] = "/dc_hotelbook/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["6"] ["url_c2"] = "/dc_hotelbook_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["8"] ["url"] = "/dc_hotelbook/options";
		$adminMenu_authorize ["admin"] ["33"] ["18"] ["list"] ["8"] ["url_c2"] = "/dc_hotelbook_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["1"] ["url"] = "/dc_eholiday/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["1"] ["url_c2"] = "/dc_eholiday_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["7"] ["url"] = "/dc_eholiday/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["7"] ["url_c2"] = "/dc_eholiday_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["2"] ["url"] = "/dc_eholiday/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["2"] ["url_c2"] = "/dc_eholiday_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["6"] ["url"] = "/dc_eholiday/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["6"] ["url_c2"] = "/dc_eholiday_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["8"] ["url"] = "/dc_eholiday/options";
		$adminMenu_authorize ["admin"] ["33"] ["19"] ["list"] ["8"] ["url_c2"] = "/dc_eholiday_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_1'];
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["1"] ["url"] = "/dc_dobovo/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["1"] ["url_c2"] = "/dc_dobovo_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["7"] ["url"] = "/dc_dobovo/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["7"] ["url_c2"] = "/dc_dobovo_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_2'];
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["2"] ["url"] = "/dc_dobovo/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["2"] ["url_c2"] = "/dc_dobovo_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["6"] ["url"] = "/dc_dobovo/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["6"] ["url_c2"] = "/dc_dobovo_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["8"] ["url"] = "/dc_dobovo/options";
		$adminMenu_authorize ["admin"] ["33"] ["20"] ["list"] ["8"] ["url_c2"] = "/dc_dobovo_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_1'];
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["1"] ["url"] = "/dc_dorms/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["1"] ["url_c2"] = "/dc_dorms_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["7"] ["url"] = "/dc_dorms/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["7"] ["url_c2"] = "/dc_dorms_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_2'];
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["2"] ["url"] = "/dc_dorms/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["2"] ["url_c2"] = "/dc_dorms_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["6"] ["url"] = "/dc_dorms/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["6"] ["url_c2"] = "/dc_dorms_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["8"] ["url"] = "/dc_dorms/options";
		$adminMenu_authorize ["admin"] ["33"] ["21"] ["list"] ["8"] ["url_c2"] = "/dc_dorms_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_1'];
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["1"] ["url"] = "/dc_cbooking/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["1"] ["url_c2"] = "/dc_cbooking_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["7"] ["url"] = "/dc_cbooking/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["7"] ["url_c2"] = "/dc_cbooking_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_2'];
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["2"] ["url"] = "/dc_cbooking/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["2"] ["url_c2"] = "/dc_cbooking_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["6"] ["url"] = "/dc_cbooking/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["6"] ["url_c2"] = "/dc_cbooking_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["8"] ["url"] = "/dc_cbooking/options";
		$adminMenu_authorize ["admin"] ["33"] ["22"] ["list"] ["8"] ["url_c2"] = "/dc_cbooking_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["7"] ["name"] = "Обявления";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["7"] ["url"] = "/dc_airbnb/roomlist/1";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["7"] ["url_c2"] = "/dc_airbnb_c2/roomlist/1";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_6'];
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["6"] ["url"] = "/dc_airbnb/reservations_load";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["6"] ["url_c2"] = "/dc_airbnb_c2/reservations_load";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["8"] ["url"] = "/dc_airbnb/options";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["8"] ["url_c2"] = "/dc_airbnb_c2/options";
		//
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["9"] ["name"] = "Connect";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["9"] ["name"] = "{Connect}";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["9"] ["url"] = "/dc_airbnb/connect";
		$adminMenu_authorize ["admin"] ["33"] ["23"] ["list"] ["9"] ["url_c2"] = "/dc_airbnb_c2/connect";


		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["1"] ["name"] = "Параметры загруженности";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		//$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["1"] ["url"] = "/dc_expedia/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["1"] ["url_c2"] = "/dc_roomp_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["7"] ["name"] = "Категории";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		//$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["7"] ["url"] = "/dc_expedia/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["7"] ["url_c2"] = "/dc_roomp_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["2"] ["name"] = "Тарифы";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		//$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["2"] ["url"] = "/dc_expedia/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["2"] ["url_c2"] = "/dc_roomp_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["6"] ["name"] = "Загрузка заказов";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		//$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["6"] ["url"] = "/dc_expedia/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["6"] ["url_c2"] = "/dc_roomp_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["8"] ["name"] = "Настройки";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		//$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["8"] ["url"] = "/dc_expedia/options";
		$adminMenu_authorize ["admin"] ["33"] ["24"] ["list"] ["8"] ["url_c2"] = "/dc_roomp_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["1"] ["url_c2"] = "/dc_axis_travel_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["7"] ["url_c2"] = "/dc_axis_travel_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["2"] ["url_c2"] = "/dc_axis_travel_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["6"] ["url_c2"] = "/dc_axis_travel_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["25"] ["list"] ["8"] ["url_c2"] = "/dc_axis_travel_c2/options";


		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["1"] ["url_c2"] = "/dc_onetwotrip_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["7"] ["url_c2"] = "/dc_onetwotrip_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["2"] ["url_c2"] = "/dc_onetwotrip_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["6"] ["url_c2"] = "/dc_onetwotrip_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["26"] ["list"] ["8"] ["url_c2"] = "/dc_onetwotrip_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["1"] ["url_c2"] = "/dc_tvil_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["7"] ["url_c2"] = "/dc_tvil_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["2"] ["url_c2"] = "/dc_tvil_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["6"] ["url_c2"] = "/dc_tvil_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["27"] ["list"] ["8"] ["url_c2"] = "/dc_tvil_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_1'];
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["1"] ["url_c2"] = "/dc_academ_service_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_7'];
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["7"] ["url_c2"] = "/dc_academ_service_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_2'];
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["2"] ["url_c2"] = "/dc_academ_service_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_6'];
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["6"] ["url_c2"] = "/dc_academ_service_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_1_8'];
		$adminMenu_authorize ["admin"] ["33"] ["28"] ["list"] ["8"] ["url_c2"] = "/dc_academ_service_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["1"] ["url_c2"] = "/dc_aanda_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["7"] ["url_c2"] = "/dc_aanda_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["2"] ["url_c2"] = "/dc_aanda_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["6"] ["url_c2"] = "/dc_aanda_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["29"] ["list"] ["8"] ["url_c2"] = "/dc_aanda_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["1"] ["url_c2"] = "/dc_nash_travel_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["7"] ["url_c2"] = "/dc_nash_travel_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["2"] ["url_c2"] = "/dc_nash_travel_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["6"] ["url_c2"] = "/dc_nash_travel_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["30"] ["list"] ["8"] ["url_c2"] = "/dc_nash_travel_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["1"] ["url_c2"] = "/dc_sutochno/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["7"] ["url_c2"] = "/dc_sutochno/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["2"] ["url_c2"] = "/dc_sutochno/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["6"] ["url_c2"] = "/dc_sutochno/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["31"] ["list"] ["8"] ["url_c2"] = "/dc_sutochno/options";

		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["1"] ["url_c2"] = "/dc_101hotels_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["7"] ["url_c2"] = "/dc_101hotels_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["2"] ["url_c2"] = "/dc_101hotels_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["6"] ["url_c2"] = "/dc_101hotels_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["32"] ["list"] ["8"] ["url_c2"] = "/dc_101hotels_c2/options";

		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["1"] ["url_c2"] = "/dc_ctrip_c2/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["7"] ["url_c2"] = "/dc_ctrip_c2/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["2"] ["url_c2"] = "/dc_ctrip_c2/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["6"] ["url_c2"] = "/dc_ctrip_c2/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["33"] ["list"] ["8"] ["url_c2"] = "/dc_ctrip_c2/options";
		
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["1"] ["url_c2"] = "/dc_su/ra_params_edit";
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["7"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["7"] ["url_c2"] = "/dc_su/catgories_edit";
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["2"] ["url_c2"] = "/dc_su/rates_edit";
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["6"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["6"] ["url_c2"] = "/dc_su/reservations_form";
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["8"] ["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
		$adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["8"] ["url_c2"] = "/dc_su/options";
		
		$develop = $this->session->userdata('global_modify') ? true : false;
		if ($develop) {
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["9"] ["name"] = "Properties";
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["9"] ["name"] = 'Properties';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["9"] ["url_c2"] = "/dc_su/properties_list";
		
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["10"] ["name"] = "Rooms";
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["10"] ["name"] = 'Rooms';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["10"] ["url_c2"] = "/dc_su/rooms_list";
		
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["11"] ["name"] = "Rates";
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["11"] ["name"] = 'Rates';//$navMenuDic['navigation_root_reservationlist_33_1_12'];
		    $adminMenu_authorize ["admin"] ["33"] ["37"] ["list"] ["11"] ["url_c2"] = "/dc_su/rates_list";
		}
		
		//
		$adminMenu_authorize ["admin"] ["33"] ["34"] ["list"] ["1"] ["name"] = "{cb_connect_rest}";
		$adminMenu_authorize ["admin"] ["33"] ["34"] ["list"] ["1"] ["url_c2"] = "/dc_avito/connect";

		if ($this->releases->dc_avito() == 1) {

            $avito_cfg = $this->db->select('str_value')
                ->get_where('dc_avito_xml_cfg', array(
                'name' => 'refresh_token'
            ))
                ->row_array();
            $avito_refresh_token = $avito_cfg ? $avito_cfg['str_value'] : "";

            if ($avito_refresh_token != "") {
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["2"]["name"] = $navMenuDic['navigation_root_reservationlist_33_6_7'];
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["2"]["url_c2"] = "/dc_avito/catgories_edit";
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["4"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["4"]["url_c2"] = "/dc_avito/reservations_form";
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["3"]["name"] = $navMenuDic['navigation_root_reservationlist_33_6_8'];
                $adminMenu_authorize["admin"]["33"]["34"]["list"]["3"]["url_c2"] = "/dc_avito/settings";
            }
        }
        
        $adminMenu_authorize ["admin"] ["33"] ["35"] ["list"] ["3"] ["name"] = "{cb_connect_rest}";
        $adminMenu_authorize ["admin"] ["33"] ["35"] ["list"] ["3"] ["url_c2"] = "/dc_yandex/connect";
        
        if ($this->releases->dc_ya() == 1) {
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["1"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["1"]["url_c2"] = "/dc_yandex/ra_params_edit";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["7"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["7"]["url_c2"] = "/dc_yandex/catgories_edit";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["2"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["2"]["url_c2"] = "/dc_yandex/rates_edit";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["6"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["6"]["url_c2"] = "/dc_yandex/reservations_form";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["8"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["8"]["url_c2"] = "/dc_yandex/options";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["9"]["name"] = "{clt_ya_wizard}";
            $adminMenu_authorize["admin"]["33"]["35"]["list"]["9"]["url_c2"] = "/dc_yandex/export_step_1";
        }
        
        $adminMenu_authorize ["admin"] ["33"] ["36"] ["list"] ["3"] ["name"] = "{cb_connect_rest}";
        $adminMenu_authorize ["admin"] ["33"] ["36"] ["list"] ["3"] ["url_c2"] = "/dc_hotelbeds/connect";
        
        if ($this->releases->dc_hotelbeds() == 1) {
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["1"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_1'];
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["1"]["url_c2"] = "/dc_hotelbeds/ra_params_edit";
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["7"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_7'];
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["7"]["url_c2"] = "/dc_hotelbeds/catgories_edit";
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["2"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_2'];
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["2"]["url_c2"] = "/dc_hotelbeds/rates_edit";
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["6"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_6'];
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["6"]["url_c2"] = "/dc_hotelbeds/reservations_form";
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["8"]["name"] = $navMenuDic['navigation_root_reservationlist_33_5_8'];
            $adminMenu_authorize["admin"]["33"]["36"]["list"]["8"]["url_c2"] = "/dc_hotelbeds/options";
        }

		$adminMenu_authorize ["admin"] ["28"] ["name"] = "Очередь";
		$adminMenu_authorize ["admin"] ["28"] ["name"] = $navMenuDic['navigation_root_node_28'];
		$adminMenu_authorize ["admin"] ["28"] ["url"] = "/chmanager/syncstatus";
		$adminMenu_authorize ["admin"] ["28"] ["url_c2"] = "/chmanager_c2/syncstatus";
		$adminMenu_authorize ["admin"] ["28"] ["list"] = array ();

		$adminMenu_authorize ["admin"] ["27"] ["name"] = "Ошибки";
		$adminMenu_authorize ["admin"] ["27"] ["name"] = $navMenuDic['navigation_root_node_27'];
		$adminMenu_authorize ["admin"] ["27"] ["url"] = "/chmanager/dcerrors";
		$adminMenu_authorize ["admin"] ["27"] ["url_c2"] = "/chmanager_c2/dcerrors";
		$adminMenu_authorize ["admin"] ["27"] ["list"] = array ();

		$adminMenu_authorize ["admin"] ["23"] ["name"] = "Общее";
		$adminMenu_authorize ["admin"] ["23"] ["name"] = $navMenuDic['navigation_root_node_23'];
		$adminMenu_authorize ["admin"] ["23"] ["url"] = "/chmanager/uploadrates";
		$adminMenu_authorize ["admin"] ["23"] ["url_c2"] = "/chmanager_c2/uploadrates";
		$adminMenu_authorize ["admin"] ["23"] ["list"] = array ();

		$adminMenu_authorize ["admin"] ["23"] ["list"] ["1"] ["name"] = "Доска ограничений";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["1"] ["name"] = $navMenuDic['navigation_root_reservationlist_23_1'];
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["1"] ["url"] = "/chmanager/deskofrates";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["1"] ["url_c2"] = "/chmanager_c2/deskofrates";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["2"] ["name"] = "Выгрузка тарифов";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["2"] ["name"] = $navMenuDic['navigation_root_reservationlist_23_2'];
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["2"] ["url"] = "/chmanager/uploadrates";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["2"] ["url_c2"] = "/chmanager_c2/uploadrates";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["3"] ["name"] = "Выгрузка загруженности";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["3"] ["name"] = $navMenuDic['navigation_root_reservationlist_23_3'];
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["3"] ["url"] = "/chmanager/uploadrooms";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["3"] ["url_c2"] = "/chmanager_c2/uploadrooms";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["4"] ["name"] = "Настройка";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["4"] ["name"] = $navMenuDic['navigation_root_reservationlist_23_4'];
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["4"] ["url"] = "/chmanager/options";
		$adminMenu_authorize ["admin"] ["23"] ["list"] ["4"] ["url_c2"] = "/chmanager_c2/options";

		return $adminMenu_authorize;
	}
	function getnotelist($id) {
		$list = $this->getrootlist ( $id );
		if (isset ( $list [$id] )) {
			return $list [$id] ["list"];
		} else
			return null;
	}
	function getnotelist_2($id, $id_2 = 0) {
		//$navMenu ["2"] ["list"] ["3"] ["list_2"][0]["name"]
		$list = $this->getrootlist ( $id );
		//echo "<pre>";
		//print_r($list);

		if (isset ( $list [$id] )) {
			if ($id_2 == 0) {
				if (isset ( $list [$id] ["list"] )) {
					return $list [$id] ["list"];
				} else {
					return null;
				}
			} else {
				if (isset ( $list [$id] ["list"] [$id_2] )) {
					return $list [$id] ["list"] [$id_2] ["list_2"];
				} else {
					return null;
				}
			}
		} else
			return null;
	}
	function getnotelist_admin($id) {
		$list = $this->getadminmenulist ();
		if (isset ( $list ["admin"] [$id] )) {
			return $list ["admin"] [$id] ["list"];
		} else
			return null;
	}
	function getnotelist_admin_2($id, $service_type_id = 0) {
		$list = $this->getadminmenulist_2 ();
		if ($service_type_id == 0) {
			if (isset ( $list ["admin"] [$id] )) {
				return $list ["admin"] [$id] ["list"];
			} else {
				return null;
			}
		} else {
			if (isset ( $list ["admin"] [$id] [$service_type_id] )) {
				return $list ["admin"] [$id] [$service_type_id] ["list"];
			} else {
				return null;
			}
		}
	}
	function get_chain_menulist() {
		$chain_menu = array ();

		$chain_menu ["chain"] ["1"] ["name"] = "Главная";
		$chain_menu ["chain"] ["1"] ["url"] = "/chain";

		$chain_menu ["chain"] ["2"] ["name"] = "Доска заказов";
		$chain_menu ["chain"] ["2"] ["url"] = "/chain/desk";

		$chain_menu ["chain"] ["3"] ["name"] = "Заказы";
		$chain_menu ["chain"] ["3"] ["url"] = "/chain/orderlist";

		$chain_menu ["chain"] ["4"] ["name"] = "Карта дня";
		$chain_menu ["chain"] ["4"] ["url"] = "/chain/todaylist";

		return $chain_menu;
	}
	function getnotelist_chain($id_current) {
		$chain_menu = array ();
		$list = $this->get_chain_menulist ();

		if (isset ( $list ["chain"] )) {

			$arr_keys = array_keys ( $list ["chain"] );
			if (count ( $arr_keys ) != 0) {
				foreach ( $arr_keys as $key ) {
					if ($key == $id_current) {
						$current = 'id="corent"';
					} else {
						$current = "";
					}
					array_push ( $chain_menu, array (
							"name" => $list ["chain"] [$key] ["name"],
							"url" => $list ["chain"] [$key] ["url"],
							"current" => $current
					) );
				}
				return $chain_menu;
			} else {
				return null;
			}
		}
	}
	function getnotelist_admin_mainmenu($id_current) {
		$list = $this->getadminmenulist ();
		$main_adminmenu = array ();
		if (isset ( $list ["admin"] )) {

			$arr_keys = array_keys ( $list ["admin"] );
			if (count ( $arr_keys ) != 0) {
				foreach ( $arr_keys as $key ) {
					if ($key == $id_current) {
						$current = 'id="corent"';
					} else {
						$current = "";
					}
					array_push ( $main_adminmenu, array (
							"name" => $list ["admin"] [$key] ["name"],
							"url" => $list ["admin"] [$key] ["url"],
							"current" => $current
					) );
				}
				return $main_adminmenu;
			} else {
				return null;
			}
		}
	}
	function getnotelist_admin_mainmenu_2($id_current) {
		$list = $this->getadminmenulist_2 ();
		$main_adminmenu = array ();
		if (isset ( $list ["admin"] )) {

			$arr_keys = array_keys ( $list ["admin"] );
			if (count ( $arr_keys ) != 0) {
				foreach ( $arr_keys as $key ) {
					if ($key == $id_current) {
						$current = 'id="corent"';
					} else {
						$current = "";
					}
					array_push ( $main_adminmenu, array (
							"name" => $list ["admin"] [$key] ["name"],
							"url" => $list ["admin"] [$key] ["url"],
							"current" => $current
					) );
				}
				return $main_adminmenu;
			} else {
				return null;
			}
		}
	}
}
?>