<?
class hotelbeds_content_model extends dcm_abstract
{
    private $ob_user = 'HC860767';
    private $ob_password = 'TEST';
    private $ob_endpoint = 'https://acquisition-cm-connectivity.int.hotelbeds.com';

    function __construct()
    {
        parent::__construct();
    }
    
    public function create_property_test()
    {
           
        $property = array(
            'hotelName'                 => "test", // property->name
            'establishmentType'         => "L", // map from dictionary property->class to hotelbeds.property_types
            'currency'                  => "EUR", // general settings -> currency () https://dev-ul2.otelms.com/admin_settings_c2/global_settings
            'hotelCategory'             => "THREE_STAR", // property->star_rating
            'urlWebsite'                => "https://hotelterem.com/", //  property->web_address
            'numberOfRooms'             => 3, // 
            'email'                     => "sales@hotelterem.com", // property->email
            'phone'                     => "52233422", //property->reception_phone
            'address'                   => array(
                'roadType'      => "AV", // map from dictionary hotelbeds.street_types
                'streetName'    => "Dera", // poroperty->street_lat - Ñ€Ð¾Ð·Ð±Ð¸Ñ‚Ð¸ Ð¿Ð¾ ÐºÐ¾Ð¼Ñ–, Ð²Ð·Ñ�Ñ‚Ð¸ 1 ÐµÐ»ÐµÐ¼ÐµÐ½Ñ‚
                'streetNumber'  => 34, // poroperty->street_lat - Ñ€Ð¾Ð·Ð±Ð¸Ñ‚Ð¸ Ð¿Ð¾ ÐºÐ¾Ð¼Ñ–, Ð²Ð·Ñ�Ñ‚Ð¸ 2 ÐµÐ»ÐµÐ¼ÐµÐ½Ñ‚
                'postCode'      => "35222", // property->post_code
                'city'          => "Slavsk", // property->city_lat
                'country'       => "RO", // strict dictionary
                'county'        => "a2c5t000000DX95AAG", // map from dictionary ajax
            ),
            'contact'                   => array(
                'salutation'    => "Dr.", // strict dictionary
                'name'          => "support",
                'lastName'      => "test",
                'email'         => "test@support.com",
                'phone'         => "34222344",
                'language'      => "ENG",// strict dictionary contactLanguages
            ),
            'coordinates'               => array(
                'latitude'  => 48.8188396,
                'longitude' => 23.4461794,
            ),
            'hotelFiscalInformation'    => array(
                'number'        => 37737930,
                'name'          => "ФОП Тест",
                'phone'         => "525353535",
                'city'          => "Stambul",
                'country'       => "TR",
                'county'        => "a2c5t000000DXPZAA4", // map from dictionary
                'streetName'    => "Jurchosi",
                'postCode'      => "432444",
                'email'         => "test@support.com",
            ),
            'additionalGuests'          => array(
                array(
                    'maxAge'        => 99,
                    'paxCode'       => 'ADULT',
                    'order'         => 1,
                    'amount'        => 200, // can be percent node instead
                ), array(
                    'maxAge'        => 7,
                    'paxCode'       => 'CHILD',
                    'order'         => 1,
                    'amount'        => 50, // can be percent node instead
                ),array(
                    'maxAge'        => 17,
                    'paxCode'       => 'INFANT',
                    'order'         => 1,
                    'amount'        => 100, // can be percent node instead
                )
            ),
            'ageCategories'             => array(
                'infantMaximumAge'  => 17,
                'childMaximumAge'   => 7
            ),
            'baseBoardType'             => "HALF_BOARD", // ROOM_ONLY, BED_AND_BREAKFAST, HALF_BOARD, FULL_BOARD, ALL_INCLUSIVE
            'cancellationPolicies'      => array( // only 1 policy is allowed
                array(
                    'applicationType'   => 'STAY',
                    'days'              => 14,
                    'percentage'        => 30,
                    'deadlineHour'      => 14,
                )
            ),
            'nrfSpecificRate'           => false,
            'pricingModel'              => 'OCCUPANCY_BASED_PRICING',
            'channelManagerURL'         => 'https://site.com/',//production: 'https://xml.otelms.com/dc_hotelbeds/endpoint',
        );
    
        $property_json = json_encode($property);
        echo $property_json."<br><br><br>";
    
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->ob_endpoint . '/api/2.0/createProperty',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_USERPWD => $this->ob_user . ':' . $this->ob_password,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $property_json,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));
        $buffer = curl_exec($curl);
        echo $buffer;
        curl_close($curl);
        $response = json_decode($buffer, 1);
        echo "<pre>";
        print_r($response);
        die();
       
    
//         if( isset( $response['requestId'] ) ){
             
//             $ob_arr = [
//                 'request_id'    => $response['requestId'],
//                 'request_date'  => date('Y-m-d H:i:s'),
//             ];
//             $this->db->where('property_id', $this->input->post('property_id'))->set($ob_arr)->update('hotelbeds.onboard_status');
//             echo '<meta http-equiv="refresh" content="0; url=/index.php/hotelbeds_onboard/initial">';
//         } else {
//             $this->dump([$property_json, $response]);
//         }
    }
    
    function get_star_rating($star_int){
        $star_ratings = array(
            0 => "",
            1 => "ONE_STAR",
            2 => "TWO_STAR",
            3 => "THREE_STAR",
            4 => "FOUR_STAR",
            5 => "FIVE_STAR"
        );
        return $star_ratings [$star_int];
    }
    
//     public function get_counties( $country, $output = null )
//     {
//         $dict = $country != null ? "countries/{$country}/counties" : "countries/UA/counties";
         
//         $curl = curl_init();
//         curl_setopt_array($curl, array(
//             CURLOPT_URL => $this->ob_endpoint . '/api/1.0/concepts/' . $dict,
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_USERPWD => $this->ob_user . ':' . $this->ob_password,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//         ));
//         $response = curl_exec($curl);
//         curl_close($curl);
    
//         if( $output == 'text' ){
//             echo $response;
//             return true;
//         }
    
//         return $response;
//     }
    
    public function create_property()
    {
        $property_id = 2;
        $property_data = $this->property_model->get_property_data($property_id);
        echo "<pre>";
        print_r($property_data);
        //die();
        $default_partner_id = $this->db->select('id')->get_where('partners', array('isdefault' => 1 ))->row()->id;
        $partner_data = $this->mpartners->get_partner_data($default_partner_id);
        
        foreach ($property_data as $property_cell) {
            list ($latitude, $longitude) = explode(",", $property_cell ['gps_coordinates']);
            $age_acb_ranges_arr = array();
            $infant_maxage = 999;
            $chld_maxage = 999;
            $query_res = $this->db->get_where('age_ranges_acb', "range_id = ".$property_cell ['range_id']." AND `from` <> -1")->result();
            if (!empty($query_res)){
                foreach ($query_res as $range) {
                    $to = $range->to;
                    switch ($range->id) {
                        case 1:
                            $infant_maxage = $to;
                            $paxCode = "INFANT";
                            break;
                        case 2:
                            $chld_maxage = $to;
                            $paxCode = "CHILD";
                            break;
                        case 3:
                            $paxCode = "ADULT";;
                            break;
                    }
                    array_push($age_acb_ranges_arr, array(
                        'maxAge' => $to,
                        'paxCode' => $paxCode,
                        'order' => 1, // ????????
                        'amount' => 100 // ????????
                    ));
                }
            }
            
            
            $property = array(
                'hotelName' => $property_cell ['property_name'], // property->name
                'establishmentType' => "L", // ???
                'currency' => "EUR", // ???
                'hotelCategory' => $this->get_star_rating($property_cell ['star_rating']),
                'urlWebsite' => $property_cell ['web_address'], // property->web_address
                'numberOfRooms' => $this->mcategory->get_category_active_count(), //
                'email' => $property_cell ['email'], // property->email
                'phone' => $property_cell ['reception_phone'], // property->reception_phone
                'address' => array(
                    'roadType' => "AV", // тип вулиці ???
                    'streetName' => $property_cell ['address_line_1'], 
                    'streetNumber' => $property_cell ['address_line_2'],
                    'postCode' => $property_cell ['post_code'], 
                    'city' => $property_cell ['city'],
                    'country' => "RO", // ???? $property_cell ['country']
                    'county' => "a2c5t000000DX5UAAW"// ???
                ), // map from dictionary ajax

                'contact' => array(
                    'salutation' => "Dr.", // ????
                    'name' => "support",
                    'lastName' => "test",
                    'email' => $property_cell ['email'],
                    'phone' => $property_cell ['reception_phone'],
                    'language' => "ENG" // ?????
                ), // strict dictionary contactLanguages

                'coordinates' => array(
                    'latitude' => $latitude,
                    'longitude' => $longitude
                ),
                'hotelFiscalInformation' => array(
                    'number' => $partner_data ['DOC_INN'],
                    'name' => $partner_data ['legal_name'],
                    'phone' => "525353535", // ????
                    'city' => $partner_data ['city'],
                    'country' => "TR", // ?????????
                    'county' => "a2c5t000000DXPZAA4", // ????????
                    'streetName' => $partner_data ['addrLine1'],
                    'postCode' => $partner_data ['postcode'],
                    'email' => $partner_data ['email']
                ),
                'additionalGuests' => $age_acb_ranges_arr,
                'ageCategories' => array(
                    'infantMaximumAge' => $infant_maxage, // ????????
                    'childMaximumAge' => $chld_maxage // ?????
                ),
                'baseBoardType' => "HALF_BOARD", // ROOM_ONLY, BED_AND_BREAKFAST, HALF_BOARD, FULL_BOARD, ALL_INCLUSIVE
                'cancellationPolicies' => array( // only 1 policy is allowed
                    array(
                        'applicationType' => 'STAY',
                        'days' => 14,
                        'percentage' => 30,
                        'deadlineHour' => 14
                    )
                ),
                'nrfSpecificRate' => false,
                'pricingModel' => 'OCCUPANCY_BASED_PRICING',
                'channelManagerURL' => 'https://site.com/'
            ) // production: 'https://xml.otelms.com/dc_hotelbeds/endpoint',
;
            echo "<pre>";
            print_r($property);
            //die();
            $property_json = json_encode($property);
            echo $property_json . "<br><br><br>";
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->ob_endpoint . '/api/2.0/createProperty',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_USERPWD => $this->ob_user . ':' . $this->ob_password,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $property_json,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                )
            ));
            $buffer = curl_exec($curl);
            echo $buffer;
            curl_close($curl);
            $response = json_decode($buffer, 1);
            echo "<pre>";
            print_r($response);
            die();
        }
    
        //         if( isset( $response['requestId'] ) ){
         
        //             $ob_arr = [
        //                 'request_id'    => $response['requestId'],
        //                 'request_date'  => date('Y-m-d H:i:s'),
        //             ];
        //             $this->db->where('property_id', $this->input->post('property_id'))->set($ob_arr)->update('hotelbeds.onboard_status');
        //             echo '<meta http-equiv="refresh" content="0; url=/index.php/hotelbeds_onboard/initial">';
        //         } else {
        //             $this->dump([$property_json, $response]);
        //         }
    }
    
    public function check_property_status( $request_id )
    {
        $this->load->database();
        $this->load->library('parser');

    
        $request = array(
            'requestId' => $request_id
        );
    
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->ob_endpoint . '/api/1.0/checkPropertyStatus',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_USERPWD => $this->ob_user . ':' . $this->ob_password,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($request),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));
    
        $buffer = curl_exec($curl);
        curl_close($curl);
    
        $response = json_decode($buffer, 1);
    
        echo $buffer;
        echo "<pre>";
        print_r($response);
        die();;
        
        
//         if( $response ['status'] == 'OK'){
//             $this->db->where('id', $property['id'])
//             ->set(
//                 ['status' => $response['status'],
//                     'hotel_id' => $response['hotelId'],
//                     'last_checked' => date('Y-m-d H:i:s')]
//                 )
//                 ->update('hotelbeds.onboard_status');
//         } else {
//             $this->db->where('id', $property['id'])
//             ->set(
//                 ['status' => $response['status'],
//                     'last_checked' => date('Y-m-d H:i:s')]
//                 )
//                 ->update('hotelbeds.onboard_status');
//         }
//         echo $buffer;
    }
    
     // [requestId] => HC-20230907155216001
    public function get_properties() // Ð¼ÐµÑ‚Ð¾Ð´ Ð³Ð»Ð¾Ð±Ð°Ð»ÑŒÐ½Ð¾ Ð±ÐµÑ€Ðµ Ð²Ñ�Ñ– Ð¿Ñ€Ð¸Ð²'Ñ�Ð·Ð°Ð½Ñ– Ð´Ð¾ Ð½Ð°Ñ� Ð¿Ñ€Ð¾Ð¿ÐµÑ€Ñ‚Ñ–
    {
        //die();
        $this->load->library('parser');
        $data = array(
            'user' => $this->ob_user,
            'password' => $this->ob_password
        );
    
        $xml = $this->parser->parse('dc_hotelbeds/hotelList', $data, true);
    
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->hsi_endpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $xml,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/xml'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
    
        echo '<pre>';
        $xml = new SimpleXMLElement($response);
        $result = $xml->xpath('//HSI_HotelListRS');
    
        print_r($result);
    }

    public function create_room()
    {
        $dc_account_id = 1;
        $authparam = $this->hotelbeds_model->getauthparam($dc_account_id);
        
        $categories = $this->mcategory->get_active_categories_data();
        //print_r($categories);
        foreach ($categories as $cat_data) {
            $room = array(
                'roomCode' => "SGL", // ????????
                'hotelRoomDescription' => strtoupper($cat_data['comment']),
                'pmsRoomCode' => $cat_data['id'],
                'featureCode' => "B1-7", // ??????
                'occupancyForBasePrice' => $cat_data['base_price'],
                'roomOccupancies' => array(
                    'adults' => $cat_data['places'],
                    'children' => $cat_data['baby_places'],
                    'infants' => $cat_data['baby_places'],
                    'minAdults' => 1,
                    'total' => $cat_data['add_places']
                ),
                'additionalGuests' => array(
                    array(
                        'maxAge' => $this->input->post('infant_max_age'),
                        'paxCode' => 'INFANT',
                        'order' => 1,
                        'amount' => $this->input->post('infant_surcharge')
                    ),
                    array(
                        'maxAge' => $this->input->post('child_max_age'),
                        'paxCode' => 'CHILD',
                        'order' => 1,
                        'amount' => $this->input->post('child_surcharge')
                    ),
                    array(
                        'maxAge' => 99,
                        'paxCode' => 'ADULT',
                        'order' => 1,
                        'amount' => $this->input->post('adult_surcharge')
                    )
                )
            );
            
            echo "<pre>";
            print_r($room);
            //die();
            
            $request = json_encode($room);

            $hotel_id = $authparam ["hotel_id"];
            $user = (string) $authparam ["user"];
            $password = (string) $authparam ["password"];
            
            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->ob_endpoint . "/api/1.0/hotels/$hotel_id/rooms",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $request,
                CURLOPT_USERPWD => $user . ':' . $password,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                )
            ));
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            
            $response = curl_exec($curl);
            $information = curl_getinfo($curl);
            curl_close($curl);
            
            echo $response;
            print_r($information);
            die();
        }
    }
    
    public function create_rate()
    {
        $rooms = array();
        $categories = $this->mcategory->get_active_categories_data();
        $rate2categories = $this->frontdesk_c2->get_rate2categories_data();
        $rates_data = $this->mrates->get_rates_data();
        $currencies = $this->frontdesk_c2->get_currency_array();
        
        foreach( $categories as $cat_data ){
            array_push($rooms, array(
                'roomCode' => "SGL", // ????????
                'featureCode' => "B1-7", // ??????
                'occupancyForBasePrice' => $cat_data['base_price'],
                'roomOccupancies' => array(
                    'adults' => $cat_data['places'],
                    'children' => $cat_data['baby_places'],
                    'infants' => $cat_data['baby_places'],
                    'minAdults' => 1,
                    'total' => $cat_data['add_places']
                )
            ));
            
        }
            // $this->dump($rooms);
        foreach ($rates_data as $rate_cell) {
            $currency = "EUR";
            if(isset($currencies[$rate_cell['currency']])){
                $currency = $currencies[$rate_cell['currency']];
            }
            
            $policy_data = $this->mrates->get_rate_policy_data($rate_cell['cancellation_policy_id']);
            $rate = array(
                'hotelId' => 998499,
                'name' => strtoupper($rate_cell['rate_name']),
                'travelWindow' => array(
                    'from' => "", // ???????
                    'to' => "", // ?????
                ) 
,
                'rateAcquisition' => "", // ?????????,
                'commissionPercentage' => 0, // ??????
                'pricingModel' => 'OCCUPANCY_BASED_PRICING', // ????????
                'ratePlanType' => 'STANDALONE', // ???????
                'boardType' => " ", // ???????,
                'currencyCode' => $currency,
                'ageCategories' => array(
                    'infantMaximumAge' => $this->input->post('infant_max_age'),
                    'childMaximumAge' => $this->input->post('child_max_age')
                ),
                'additionalGuests' => array(
                    array(
                        'maxAge' => $this->input->post('infant_max_age'),
                        'paxCode' => 'INFANT',
                        'order' => 1,
                        'amount' => $this->input->post('infant_surcharge')
                    ),
                    array(
                        'maxAge' => $this->input->post('child_max_age'),
                        'paxCode' => 'CHILD',
                        'order' => 1,
                        'amount' => $this->input->post('child_surcharge')
                    ),
                    array(
                        'maxAge' => 99,
                        'paxCode' => 'ADULT',
                        'order' => 1,
                        'amount' => $this->input->post('adult_surcharge')
                    )
                ),
                'rooms' => $rooms,
                'cancellationPolicies' => array(
                    array(
                        'applicationType' => 'FIRST_NIGHT', // FIRST_NIGHT, STAY, NRF
                        'days' => 1,
                        'percentage' => 200,
                        'deadlineHour' => 14,
                        'travelWindow' => array(
                            'from' => $this->input->post('from'),
                            'to' => $this->input->post('to')
                        )
                    )
                    
                ),
                'lengthOfStay' => array(
                    'min' => 1,
                    'max' => 99
                )
            );
            ;
            
            echo "<pre>";
            print_r($rate);
            //die();
            
            if ($rate['rateAcquisition'] == 'NET_RATE') {
                $rate['commissionPercentage'] = 0;
            }
            
            $request = json_encode($rate);
            
            $dc_account_id = 1;
            $authparam = $this->hotelbeds_model->getauthparam($dc_account_id);
            $hotel_id = $authparam ["hotel_id"];
            $user = (string) $authparam ["user"];
            $password = (string) $authparam ["password"];
            
            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => $this->ob_endpoint . "/api/1.0/createRatePlan",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $request,
                CURLOPT_USERPWD => $user . ':' . $password,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                )
            ));
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            
            $buffer = curl_exec($curl);
            $information = curl_getinfo($curl);
            curl_close($curl);
            
            $response = json_decode($buffer, 1);
            
            echo $buffer;
            print_r($information);
            die();
        }
        
    }
}