<?

class frontdesk_c2 extends CI_model {
	public $mono_mode;
	public $stripe_period_start;
	public $stripe_period_end;

	function __construct() {
		parent::__construct();
		$this->mono_mode = 0;
		$this->load->model('hotelix_config');
		$this->load->model('internationalfields');
		//$this->load->model ( 'image_core' );
		if(php_sapi_name()=== 'cli') {
		} else {
// 			$this->mono_mode = $this->get_mono_mode();
// 			$this->stripe_period_start = $this->hotelix_config->get_record("stripe_sub_current_period_start", "int");
// 			$this->stripe_period_end = $this->hotelix_config->get_record("stripe_sub_current_period_end", "int");
		}
	}

	function get_country_phone() {
		$global_country_3char = $this->hotelix_config->get_record("global_country", "str");
		if($global_country_3char == "") {
			$query = $this->db->query("SELECT id_country_3c FROM visitka.config WHERE id = " . 
									  $this->config->item("hotel_id"));
			if($query->num_rows()> 0) {
				$row = $query->row();
				$global_country_3char = $row->id_country_3c;
			}
		}
		$phone = "";
		$query = $this->db->query("SELECT phone FROM global_fms_base.countries_phones WHERE id_country_3c LIKE '" . 
								  $global_country_3char . 
								  "'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			$phone = $row->phone;
		}
		if($phone == "") {
			$phone = "+44 (20) 3514-1117";
		}
		return $phone;
	}

	function get_country_3c() {
		$global_country_3char = $this->hotelix_config->get_record("global_country", "str");
		$global_country_3char = "";
		if($global_country_3char == "") {
			$query = $this->db->query("SELECT id_country_3c FROM visitka.config WHERE id = " . 
									  $this->config->item("hotel_id"));
			if($query->num_rows()> 0) {
				$row = $query->row();
				$global_country_3char = $row->id_country_3c;
			}
		}
		return $global_country_3char;
	}

	function get_cc_namber($reservation_id) {
		$CardNumber = "";
		$query_card = $this->db->query("SELECT CardNumber FROM tbl_CreditCards WHERE reservation_id = " . 
									   $reservation_id);
		if($query_card->num_rows()> 0) {
			$row_card = $query_card->row();
			$CardNumber = $row_card->CardNumber;
		}
		return $CardNumber;
	}

	function get_vcc_data($reservation_id) {
		$return_data = array();
		$return_data['cc_activation_date'] = "";
		$return_data['amount'] = "";
		$return_data['currency'] = "";
		$sql = "SELECT tbl_CreditCards.cc_activation_date, payment_deffered.amount, payment_deffered.currency FROM tbl_CreditCards
	            LEFT JOIN payment_deffered ON tbl_CreditCards.id = payment_deffered.tcc_id
	            WHERE reservation_id = " . $reservation_id;
		$query_card = $this->db->query($sql);
		if($query_card->num_rows()> 0) {
			$row_card = $query_card->row();
			$return_data['cc_activation_date'] = $row_card->cc_activation_date;
			$return_data['amount'] = $row_card->amount;
			$return_data['currency'] = $row_card->currency;
		}
		return $return_data;
	}

	function get_wifi_pass($reservation_id, $guest_id) {
		$wifi_password = "";
		$query_card = $this->db->query("SELECT password FROM wifi_radius_vouchers WHERE guest_id = $guest_id AND res_id = " . 
									   $reservation_id);
		if($query_card->num_rows()> 0) {
			$row_card = $query_card->row();
			$wifi_password = $row_card->password;
		}
		return $wifi_password;
	}
	
	/*
	 * повертає корекцію по к-сті вільних номерів для каналів при завантаженні на канал
	 *
	 */
	function availability_count_correction($availability_count = NULL, $startdate = null, $enddate = null) {
	    
	    return $availability_count; //kicked mono logic
	    
	    
		// перевірка монорежиму, якщо включений, тоді обнуляємо к-сть
		//$mono_mode = $this->get_mono_mode();
		//echo $mono_mode;
		//die();
		$mono_control_bydate = $this->frontdesk_c2->mono_control_bydate($startdate, $enddate);
		if($mono_control_bydate == 1) {
			$availability_count = 0;
		}
		return $availability_count;
	}

	function mono_control($user_id = 0, $die_option = 1) {
		// визначаємо стан моно режиму вкл/викл
		$mono_mode = $this->get_mono_mode($user_id);
		if($mono_mode == 1) {
			// масив обмежень для контроллерів та ф-цій
			$permissions_array = $this->get_mono_mode_permissions();
			// поточні контроллер та метод
			$class = $this->router->fetch_class();
			$method = $this->router->fetch_method();
			//for  any function is allowed
			if($class == 'stripe_concept2') {
				$method = 'all_functions';
			}
			if(!isset($permissions_array[$class][$method])&& $die_option == 1) {
				$version = 1;
				$sql = "SELECT value FROM hotelix_config WHERE name LIKE 'version'";
				// echo $sql."<br>";
				$query = $this->db->query($sql);
				if($query->num_rows()> 0) {
					$row = $query->row();
					$version = $row->value;
				}
				if($version == 2) {
					die("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/51/accessmono'>");
				} else {
					die("<meta http-equiv='refresh' content='0;url=/errors/FreeError/51/accessmono'>");
				}
			}
		}
	}

	function mono_control_bydate($datein, $dateout) {
		// визначаємо стан моно режиму вкл/викл
		if($this->mono_mode == 1) {
			$intdatetoday_ms = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
			list($datein_year, $datein_month, $datein_day)= explode("-", $datein);
			$reservation_intdatein_ms = mktime(0, 0, 0, $datein_month, $datein_day, $datein_year);
			list($dateout_year, $dateout_month, $dateout_day)= explode("-", $dateout);
			$reservation_intdateout_ms = mktime(0, 0, 0, $dateout_month, $dateout_day, $dateout_year);
			if($this->stripe_period_start == 0 || $this->stripe_period_end == 0 ||($intdatetoday_ms > $this->stripe_period_end)) {
				$was_updated = $this->session->userdata('sub_ages_was_updated');
				if($was_updated != 1) {
					$this->load->model('stripe_billing_m2');
					$res = $this->stripe_billing_m2->subscription_period_edges_uptodating();
					$this->stripe_period_start = $res->subscription->current_period_start;
					$this->stripe_period_end = $res->subscription->current_period_end;
					$this->session->set_userdata(array('sub_ages_was_updated' => 1));
				}
			}
			if($reservation_intdatein_ms <= $this->stripe_period_end && $reservation_intdateout_ms >= $this->stripe_period_start) {
				return 1;
			} else {
				return 0;
			}
		}
		return 0;
	}

	function get_mono_mode($user_id = 0) {
		// 	    $mono_status = 0;
		// 	    $sql = "SELECT hotelstateid FROM visitka.config WHERE id = ".$this->config->item("hotel_id");
		// 	    $query = $this->db->query($sql);
		// 	    if ($query->num_rows()) {
		// 	        $row = $query->row();
		// 	        $mono_status = $row->hotelstateid;
		// 	    }
		// 	    if($mono_status == 11){
		// 	        return 1;
		// 	    }else{
		// 	        return 0;
		// 	    }
		return 0;
		return $this->hotelix_config->get_record("hms_billing_mono", "int");
	}

	function get_mono_mode_permissions() {
		$permissions_array = array();
		$permissions_array["admin_settings_c2"]["global_settings"] = 1;
		$permissions_array["setup_smtp_c2"]["configuration"] = 1;
		$permissions_array["errors_c2"]["view_error"] = 1;
		$permissions_array["reservation_c2"]["calendar"] = 1;
		$permissions_array["home"]["feedback_c2"] = 1;
		$permissions_array["support"]["ticketslist_c2"] = 1;
		$permissions_array["support"]["view_ticket_c2"] = 1;
		$permissions_array["stripe_concept2"]["all_functions"] = 1;
		$permissions_array["billing_c2"]["blist"] = 1;
		// 	    $permissions_array["stripe_concept2"]["summary"] = 1;
		// 	    $permissions_array["stripe_concept2"]["charges"] = 1;
		// 	    $permissions_array["stripe_concept2"]["invoices"] = 1;
		$permissions_array["wizard_c2"]["step_1"] = 1;
		$permissions_array["wizard_c2"]["step_2"] = 1;
		$permissions_array["wizard_c2"]["step_3"] = 1;
		$permissions_array["wizard_c2"]["step_4"] = 1;
		$permissions_array["wizard_c2"]["step_5"] = 1;
		$permissions_array["wizard_c2"]["step_6"] = 1;
		$permissions_array["wizard_c2"]["step_7"] = 1;
		$permissions_array["wizard_c2"]["step_8"] = 1;
		$permissions_array["wizard_c2"]["step_9"] = 1;
		$permissions_array["reservation_c2"]["folio"] = 1;
		//old version
		$permissions_array["reservations"]["calendar"] = 1;
		$permissions_array["errors"]["FreeError"] = 1;
		return $permissions_array;
	}
	// ф-я, яка повертає масив активних мов для редагування назви, опису і тому подібне;
	// $international_array масив проставлених значень з бази даних;
	function get_language_tabs_array($international_array) {
		$global_language = $this->hotelix_config->get_record("global_language", "int");
		$languages_name_array = array();
		$languages_tab_name_array = array();
		$sql = "SELECT * FROM `descriptionlanguages`  WHERE is_active = 1 ORDER BY FIND_IN_SET(id,'" . $global_language . "') DESC";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$active_bool = 0;

			foreach($query->result()as $row) {
				if($active_bool == 0) {
					$languages_tab_name_array[$row->id]["class_active"] = "active";
					$languages_name_array[$row->id]["class_active"] = "active";
					$active_bool ++;
				} else {
					switch($row->name) {
						case "pl" : $tab_class = "pol";
						break;
						case "pt" : $tab_class = "pa";
						break;
						default : $tab_class = $row->name;
						break;
					}
					//             if($row->name == "pl"){
					//                 $tab_class = "pol";
					//             }else{
					//                 $tab_class = $row->name;
					//             }
					$languages_tab_name_array[$row->id]["class_active"] = $tab_class;
					$languages_name_array[$row->id]["class_active"] = $tab_class;
				}
				$languages_tab_name_array[$row->id]["id"] = $row->id;
				$languages_tab_name_array[$row->id]["lang_name"] = $row->name_original;
				//====================================================
				$languages_name_array[$row->id]["lang_id"] = $row->id;
				$languages_name_array[$row->id]["lang_name"] = $row->name_original;
				$languages_name_array[$row->id]["international_name"] = "";
				$languages_name_array[$row->id]["dir_tag"] = "";
				if(isset($international_array[$row->id])) {
					if($international_array[$row->id] != "") {
						$languages_name_array[$row->id]["international_name"] = $international_array[$row->id];
					}
				}
				switch($row->id) {
					case "50" : $languages_name_array[$row->id]["dir_tag"] = 'dir="rtl"';
					break;
					case "198" : $languages_name_array[$row->id]["dir_tag"] = 'dir="rtl"';
					break;
				}
			}
		}
		$return_array = array();
		$return_array["languages_tab_name_array"] = $languages_tab_name_array;
		$return_array["languages_name_array"] = $languages_name_array;
		return $return_array;
	}

	function get_fine_value($data, $debug = 0) {
		$amount = $data["amount"];
		$datein = $data["datein"];
		$checkintime = $data["checkintime"];
		$cancel_datetime = $data["cancel_date"];
		$cancellation_policy_id = $data["cancellation_policy_id"];
		if($debug == 1) {
			echo "amount: " . $amount . "<br>";
			echo "datein: " . $datein . "<br>";
			echo "checkintime: " . $checkintime . "<br>";
			echo "cancel_datetime: " . $cancel_datetime . "<br>";
			echo "cancellation_policy_id: " . $cancellation_policy_id . "<br><hr>";
		}
		list($datein_year, $datein_month, $datein_day)= explode("-", $datein);
		$intdatein = round(gmmktime(0, 0, 0, $datein_month, $datein_day, $datein_year)/ 86400);
		$cancel_datetime_mass = explode(" ", $cancel_datetime);
		$cancel_date = $cancel_datetime_mass[0];
		$cancel_time = $cancel_datetime_mass[1];
		list($cancel_date_year, $cancel_date_month, $cancel_date_day)= explode("-", $cancel_date);
		$cancel_intdatein = round(gmmktime(0, 0, 0, $cancel_date_month, $cancel_date_day, $cancel_date_year)/ 86400);
		$fine = 0;
		$sql = "SELECT * FROM global_hotelix_common.dc_cancelationpolicy_list WHERE id = " . $cancellation_policy_id;
		$query = $this->db->query($sql);
		if($query->num_rows()) {
			$row = $query->row();
			$take_penalty_bool = 0;
			$deadline_days = $row->deadline_days;
			$deadline_hours = $row->deadline_hours;
			$penalty_ad = $row->penalty_ad;
			$penalty_ad_nights = $row->penalty_ad_nights;
			$penalty_ar = $row->penalty_ar;
			$days_diff = $intdatein - $cancel_intdatein;
			if($debug == 1) {
				echo "Термін відміни (днів): " . $deadline_days . "<br>";
				echo "Термін відміни (години): " . $deadline_hours . "<br>";
				echo "Штраф за ануляцію бронювання після закінчення терміну відміни (%): " . $penalty_ad . "<br>";
				echo "Штраф за ануляцію бронювання після закінчення терміну відміни (Ночей): " . $penalty_ad_nights . "<br>";
				echo "Штраф за ануляцію бронювання (%): " . $penalty_ar . "<br><hr>";
				echo "days_diff: " . $days_diff . "<br>";
			}
			if($deadline_days > 0) {
				// перевірка по дням
				if($deadline_days >($days_diff)) {
					$take_penalty_bool = 1;
				} elseif($penalty_ar > 0) {
					$fine =($amount / 100)* $penalty_ar;
					return $fine;
				}
			} else {
				if($deadline_hours > 0) {
					// перевірка по годинам
					$datein_hours = 0;
					$checkintime_arr = array();
					if($checkintime != "") {
						$checkintime_arr = explode(":", $checkintime);
						$hours = $checkintime_arr[0];
						$minutes = $checkintime_arr[1];
						// $datein_hours к-сть годин до заїзду
						$datein_hours = round(gmmktime($hours, $minutes, 0, $datein_month, $datein_day, $datein_year)/ 3600);
					}
					$cancel_hours = 0;
					$cancel_time_arr = explode(":", $cancel_time);
					$hours = $cancel_time_arr[0];
					$minutes = $checkintime_arr[1];
					// $cancel_hours к-сть годин до відміни
					$cancel_hours = round(gmmktime($hours, $minutes, 0, $cancel_date_month, $cancel_date_day, $cancel_date_year)/ 3600);
					// echo "cancel_hours: ".$cancel_hours." <br> datein_hours: ".$datein_hours."<br>";
					$hours_diff = $datein_hours - $cancel_hours;
					if($debug == 1) {
						echo "hours_diff: " . $hours_diff . "<br>";
					}
					if($deadline_hours > $hours_diff) {
						$take_penalty_bool = 1;
					} elseif($penalty_ar > 0) {
						$fine =($amount / 100)* $penalty_ar;
						return $fine;
					}
				}
			}
			if($take_penalty_bool == 1) {
				if($penalty_ad > 0) {
					$fine =($amount / 100)* $penalty_ad;
				} elseif($penalty_ad_nights > 0) {
					$days_amount = 0;
					$count_penalty_days_inc = 1;

					foreach($data["reservation_day_prices"] as $cell) {
						$days_amount += $cell["price"];
						if($count_penalty_days_inc == $penalty_ad_nights) {
							break;
						}
						$count_penalty_days_inc ++;
					}
					$fine = $days_amount * $penalty_ad_nights;
				}
			}
		}
		//echo $fine;
		return $fine;
	}

	function get_room_name($id) {
		$sql = "SELECT name FROM rooms WHERE id = " . $id;
		$query = $this->db->query($sql);
		if($query->num_rows()) {
			$row = $query->row();
			return $row->name;
		} else {
			return 0;
		}
	}

	function get_dev_revision_hotelix_config_value() {
		$sql = "SELECT value FROM hotelix_config WHERE name LIKE 'dev_revision'";
		$query = $this->db->query($sql);
		if($query->num_rows()) {
			$row = $query->row();
			return $row->value;
		} else {
			return 0;
		}
	}

	function get_fms_module_state() {
		$fms_module_state = 0;
		$query = $this->db->query("SELECT is_active FROM modules WHERE name LIKE 'fms'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			$fms_module_state = $row->is_active;
		}
		return $fms_module_state;
	}

	function get_dev_revision_value() {
		$dev_revision = $this->config->item('dev_revision');
		$query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'dev_revision'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			if($row->value > 0)
				$dev_revision = $row->value;
		}
		return $dev_revision;
	}

	function get_auto_prolongation() {
		$auto_prolongation = 0;
		$query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'auto_prolongation'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			$auto_prolongation = $row->value;
		}
		return $auto_prolongation;
	}

	function save_global_settings($data) {
		$this->frontdesk->MonopolyMode();
		$data_1 = $this->Loger_admin->get_values_col("hotelix_config");
		if(isset($data["language"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('global_language', '" . 
																					   $data["language"] . 
																					   "') ON DUPLICATE KEY UPDATE value = " . 
																					   $data["language"]);
		}
		if(isset($data["currency"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('global_currency', '" . 
																					   $data["currency"] . 
																					   "') ON DUPLICATE KEY UPDATE value = " . 
																					   $data["currency"]);
		}
		if(isset($data["timezone"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, str_value) VALUES('timezone', '" . 
																						   addslashes($data["timezone"]). 
																									  "') ON DUPLICATE KEY UPDATE str_value = '" . 
																									  addslashes($data["timezone"]). 
																												 "'");
		}
		if(isset($data["country"])&& $data["country"] != "") {
			$insert_data = array('name' => 'global_country',
								 'str_value' =>$data["country"]);
			$keys = array('name');
			$this->db_insert_on_duplicate_key_update('`hotelix_config`', $insert_data, $keys);
		}
		if(isset($data["report_time"])) {
			$query = $this->db->query("UPDATE visitka.config SET report_time = " . 
									  $data["report_time"] . 
									  " WHERE host LIKE '" . 
									  $_SERVER["HTTP_HOST"] . 
									  "'");
		}
		if(isset($data["tourtax"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('tourtax', '" . 
																					   $data["tourtax"] . 
																					   "') ON DUPLICATE KEY UPDATE value = " . 
																					   $data["tourtax"]);
		}
		if(isset($data["overbooking_category_id"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('overbooking_category_id', '" . 
																					   $data["overbooking_category_id"] . 
																					   "') ON DUPLICATE KEY UPDATE value = '" . 
																					   $data["overbooking_category_id"] . 
																					   "'");
		}
		if(isset($data["date_format"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('date_format', '" . 
																					   $data["date_format"] . 
																					   "') ON DUPLICATE KEY UPDATE value = " . 
																					   $data["date_format"]);
		}
		if(isset($data["disallow_notify"])) {
			$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('disallow_notify', '" . 
																					   $data["disallow_notify"] . 
																					   "') ON DUPLICATE KEY UPDATE value = " . 
																					   $data["disallow_notify"]);
		}
		$data_2 = $this->Loger_admin->get_values_col("hotelix_config");
		$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "hotelix_config", "edit");
	}

	function deskofdays_close_insert($data) {
		list($year, $month, $day)= explode("-", $data['datein']);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $data['dateout']);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		for($i = $intdatein;
		$i < $intdateout;
		$i ++ ) {
			$sql = "INSERT INTO deskofdays (intdate, date, price, room_id, reservation_id)
			VALUES('" . $i . "', '" . gmdate("Y-m-d", $i * 86400). "', '0', '" . $data['room_id'] . "', '0')
			ON DUPLICATE KEY UPDATE reservation_id=reservation_id";
			$query = $this->db->query($sql);
		}
		$room_name = $this->get_room_name($data['room_id']);
		$log_data = array();
		$log_data["datein"] = $data['datein'];
		$log_data["dateout"] = $data['dateout'];
		$log_data["room_id"] = $data['room_id'];
		$log_data["room_name"] = $room_name;
		$log_data["lock"] = 1;
		$this->Loger_admin->Save_SyncData($data['datein'], $data['dateout'], json_encode($log_data), 0, 0, true, "days_close", "days_close");
	}

	function deskofdays_open_insert($data) {
		list($year, $month, $day)= explode("-", $data['datein']);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $data['dateout']);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		$sql = "DELETE FROM deskofdays WHERE reservation_id = 0 AND intdate >= $intdatein AND intdate < $intdateout AND room_id = " . $data['room_id'];
		$query = $this->db->query($sql);
		$room_name = $this->get_room_name($data['room_id']);
		$log_data = array();
		$log_data["datein"] = $data['datein'];
		$log_data["dateout"] = $data['dateout'];
		$log_data["room_id"] = $data['room_id'];
		$log_data["room_name"] = $room_name;
		$log_data["lock"] = 0;
		$this->Loger_admin->Save_SyncData($data['datein'], $data['dateout'], json_encode($log_data), 0, 0, true, "days_open", "days_open");
	}

	function get_main_guest_id($reservation_id) {
		$guest_id = 0;
		$query = $this->db->query("SELECT guest_id FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$guest_id = $row->guest_id;
		}
		return $guest_id;
	}

	function payments_make_refill_param($coef_mass, $refillsum) {
		// повертає розбивку суми поповнення пропорційно коефіцієнтам
		//print_r($coef_mass);
		//echo $refillsum."===<br>";
		$coef_sum = array_sum($coef_mass);
		//echo $coef_sum."qqq<br>";
		$max_value = 0;
		$max_value_key = 0;
		$result_mas = array();

		foreach($coef_mass as $key => $value) {
			$result_mas[$key] = round($refillsum * $value / $coef_sum, 2);
			if($value > $max_value) {
				$max_value = $value;
				$max_value_key = $key;
			}
		}
		$delta = $refillsum - array_sum($result_mas);
		if($max_value_key > 0)
			$result_mas[$max_value_key] = $result_mas[$max_value_key] + $delta;
		return $result_mas;
	}

	function unset_intgroupid($reservation_id) {
		$query = $this->db->query("SELECT * FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		$temp_data_old_1 = array();

		foreach($query->result_array()as $row) {
			$temp_data_old_1 = $row;
		}
		$sql = "UPDATE deskofreservation SET intgroupid = 0 WHERE id = " . $reservation_id;
		$query = $this->db->query($sql);
		$query = $this->db->query("SELECT * FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		$temp_data_new_1 = array();

		foreach($query->result_array()as $row) {
			$temp_data_new_1 = $row;
		}
		$log_data["description"] = $this->loger->StoreDescription($temp_data_old_1, $temp_data_new_1);
		$log_data["s_id"] = $reservation_id;
		$this->loger->SaveLog($log_data, "reservation", "edit");
	}

	function set_main_guset($reservation_id, $guest_id) {
		$main_guest_id = 0;
		$query = $this->db->query("SELECT guest_id FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$main_guest_id = $row->guest_id;
		}
		if($main_guest_id <> $guest_id) {
			$sql = "DELETE FROM guests_deskofreservation WHERE reservation_id = " . $reservation_id . " AND guest_id = " . $guest_id;
			$query = $this->db->query($sql);
			$sql = "INSERT INTO guests_deskofreservation (reservation_id, guest_id) VALUES(" . $reservation_id . ", " . $guest_id . ") ";
			$query = $this->db->query($sql);
			$sql = "UPDATE deskofreservation SET guest_id = " . $guest_id . " WHERE id = " . $reservation_id;
			$query = $this->db->query($sql);
		}
	}

	function update_reservation_identifiers($data) {
		$sql = "UPDATE deskofreservation SET groupid = '" . $data["groupid"] . "', dc_reservationid = '" . $data["dc_reservationid"] . "',
		dc_roomreservation_id = '" . $data["dc_roomreservation_id"] . "', dc_uuid = '" . $data["dc_uuid"] . "',
		origin_categoryid = '" . $data["origin_categoryid"] . "' WHERE id = " . $data["reservation_id"];
		$query = $this->db->query($sql);
	}

	function get_service_amount($service_id) {
		$price = 0;
		$query = $this->db->query("SELECT baseprice FROM services_types WHERE id = " . 
								  $service_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$price = $row->baseprice;
		}
		return $price;
	}

	function turn_status($reservation_id) {
		$price = 0;
		$log_data = array();
		$temp_reservation_data_old_1 = $this->get_reservation_logdata($reservation_id);
		$query = $this->db->query("SELECT status FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$status = $row->status;
			switch($status) {
				case 1 : $sql = "UPDATE deskofreservation SET status = 1 WHERE id = " . $reservation_id;
				$query = $this->db->query($sql);
				break;
				case 2 : $sql = "UPDATE deskofreservation SET status = 1 WHERE id = " . $reservation_id;
				$query = $this->db->query($sql);
				break;
				case 3 : $sql = "UPDATE deskofreservation SET status = 2 WHERE id = " . $reservation_id;
				$query = $this->db->query($sql);
				break;
			}
			$temp_reservation_data_new_1 = $this->get_reservation_logdata($reservation_id);
			$log_data["s_id"] = $reservation_id;
			$log_data["description"] = $this->loger->StoreDescription($temp_reservation_data_old_1, $temp_reservation_data_new_1);
			$this->loger->SaveLog($log_data, "reservation", "edit");
		}
	}

	function get_statuses_from_db() {
		$statuses_arr = array();
		$prefix = $this->mlanguages->get_language_prefix();
		$status_table_name = "global_hotelix_languages." . $prefix . "_statusofreservation";
		$query = $this->db->query("SELECT id, name FROM $status_table_name ORDER BY id ASC");

		foreach($query->result()as $row) {
			$statuses_arr[$row->id]["status_id"] = $row->id;
			$statuses_arr[$row->id]["status_name"] = $row->name;
		}
		return $statuses_arr;
	}

	function get_all_services_types_from_db() {
		$services_types = array();
		$query = $this->db->query("SELECT id, name, is_active FROM services_types ORDER BY id ASC");

		foreach($query->result()as $row) {
			$services_types[$row->id]["id"] = $row->id;
			$services_types[$row->id]["name"] = $row->name;
			$services_types[$row->id]["is_active"] = $row->is_active;
		}
		return $services_types;
	}

	function short_update_reservation($data) {
		$reservation_id = $data["reservation_id"];
		$avoidtime = 0;
		if(isset($data["avoidtime_days"])) {
			if($data["avoidtime_days"] > 0) {
				$avoidtime += 86400 * $data["avoidtime_days"];
			}
		}
		if(isset($data["avoidtime_hours"])) {
			if($data["avoidtime_hours"] > 0) {
				$avoidtime += 3600 * $data["avoidtime_hours"];
			}
		}
		if(isset($data["avoidtime_minutes"])) {
			if($data["avoidtime_minutes"] > 0) {
				$avoidtime += 60 * $data["avoidtime_minutes"];
			}
		}
		if($avoidtime > 0) {
			//$data ['avoidtime'] = $avoidtime;
			//$data ['duetime_null'] = 1;
			//$data ["autocancel"] = 'view2';
			$duetime = date("U", mktime(date("H"), date("i"), date("s")+ $avoidtime, date("m"), date("d"), date("Y")));
		} else {
			$duetime = 0;
		}
		$this->frontdesk->guests_reservation_delete($reservation_id, $data["guest_id"]);
		$log_data = array();
		if($data["guest_id"] == $data["insert_or_update_guest_id"]) {
			$guest_id = $data["guest_id"];
			
			/*
			 * ======== SAVE GUEST DATA ------------
			 *
			 */
			$temp_guest_data_old_2 = $this->get_guest_logdata($data["guest_id"]);
			$sql = "UPDATE guests SET firstname = '" . htmlspecialchars(addslashes($data["firstname"])). "', lastname = '" . htmlspecialchars(addslashes($data["lastname"])). "',
				    middlename = '" . htmlspecialchars(addslashes($data["middlename"])). "',
		            phone = '" . $data["phone"] . "', email = '" . $data["email"] . "' WHERE id = " . $data["guest_id"];
			// echo $sql;
			$query = $this->db->query($sql);
			$temp_guest_data_new_2 = $this->get_guest_logdata($data["guest_id"]);
			$log_data["description"] = $this->loger->StoreDescription($temp_guest_data_old_2, $temp_guest_data_new_2);
		} else {
			$guest_id = $data["insert_or_update_guest_id"];
			$log_data["description"] = "";
		}
		// якщо is_guest тоді пише в звязну таблицю
		if(isset($data["is_guest"])) {
			if($data["is_guest"] == 1) {
				$this->frontdesk->guests_reservation_insert($guest_id, $reservation_id);
			}
		} else {
			$this->frontdesk->guests_reservation_delete($reservation_id, $guest_id);
		}
		
		/*
		 * ======== SAVE RESERVATION DATA ------------
		 *
		 */
		$temp_reservation_data_old_1 = $this->get_reservation_logdata($reservation_id);
		$sql = "UPDATE deskofreservation SET guest_id = " . $guest_id . ", duetime = " . $duetime . ", avoidtime = " . $avoidtime . ", description = '" . addslashes($data['description']). "',
		marker_id = " . $data["marker"] . ", id_dealer = '" . $data["dealer"] . "', id_partner = '" . $data["partner"] . "', 
		id_user = '" . $data["user"] . "'    
		WHERE id = " . $reservation_id;
		//echo $sql;
		$query = $this->db->query($sql);
		$temp_reservation_data_new_1 = $this->get_reservation_logdata($reservation_id);
		$log_data["s_id"] = $reservation_id;
		$log_data["description"] .= $this->loger->StoreDescription($temp_reservation_data_old_1, $temp_reservation_data_new_1);
		$this->loger->SaveLog($log_data, "reservation", "edit");
	}

	function get_guest_logdata($guest_id) {
		$guest_data = array();
		$query = $this->db->query("SELECT * FROM guests WHERE id = " . 
								  $guest_id);
		$temp_data_old_2 = array();

		foreach($query->result_array()as $row) {
			$guest_data = $row;
		}
		return $guest_data;
	}

	function get_reservation_logdata($reservation_id) {
		$reservation_data = array();
		$query = $this->db->query("SELECT deskofreservation.*, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE deskofreservation.id = " . 
								  $reservation_id);
		$temp_data_old_1 = array();

		foreach($query->result_array()as $row) {
			$reservation_data = $row;
		}
		return $reservation_data;
	}

	function get_reservation_cc_data($reservation_id) {
		$reservation_data = array();
		$query = $this->db->query("SELECT * FROM tbl_CreditCards WHERE reservation_id = " . 
								  $reservation_id);
		$temp_data_old_1 = array();

		foreach($query->result_array()as $row) {
			$reservation_data = $row;
		}
		return $reservation_data;
	}

	function ajax_check_group_list($data) {
		$search = $data["term"];
		if($search == " ") {
			$sql = "SELECT id, name FROM groupreservations WHERE 1 ORDER BY id DESC LIMIT 0, 10";
		} else {
			$sql = "SELECT id, name FROM groupreservations WHERE name LIKE '%$search%' LIMIT 0, 20";
		}
		//echo $sql;
		$list = array();
		$b = 1;
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$hotel_id = 0;
			if(isset($row->hotel_id)) {
				$hotel_id = $row->hotel_id;
			}
			array_push($list, array('id' => $row->id, 'b' => $b, 'name' => $row->name));
			$b ++;
		}
		$data = array("list" =>$list);
		echo json_encode($data);
	}

	function get_reservation_auto_list($reservation_id) {
		$reservation_auto_data = array();
		$sql = "SELECT * FROM reservation_cars WHERE reservation_cars.reservation_id = " . $reservation_id;
		//echo $sql;
		$query = $this->db->query($sql);
		$temp_data_old_1 = array();

		foreach($query->result_array()as $row) {
			array_push($reservation_auto_data, array("car_id" => $row["id"], "reservation_id" => $reservation_id, "car_name_list" => $row["name"], "car_color" => $row["car_color"], "car_number_list" => $row["car_number"]));
		}
		return $reservation_auto_data;
	}

	function GetAuto($id) {
		$data = array();
		$sql = "SELECT * FROM reservation_cars WHERE id = " . $id;
		//echo $sql;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row_array();
			return $row;
		}
		return $data;
	}

	function get_airbnb_category_data($id) {
		$data = array();
		$sql = "SELECT * FROM dc_airbnb_room_param WHERE category_id = " . $id;
		//echo $sql;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row_array();
			return $row;
		}
		return $data;
	}

	function save_airbnb_category_data($data) {
		if(isset($data["bookconfirm"])) {
			$bookconfirm = $data["bookconfirm"];
		} else {
			$bookconfirm = 0;
		}
		if(isset($data["display_location"])) {
			$display_location = $data["display_location"];
		} else {
			$display_location = 0;
		}
		$sql = "INSERT INTO dc_airbnb_room_param (category_id, listing_type_id, cancelation_policy, cleaningfee, securedeposit,
		extraperson, hours, bookconfirm, monthly_price_factor, weekly_price_factor, display_location)
		VALUES('" . $data["category_id"] . "', '" . $data["listing_type_id"] . "', '" . $data["cancelation_policy"] . "',
		'" . $data["cleaningfee"] . "', '" . $data["securedeposit"] . "', '" . $data["extraperson"] . "',
		'" . $data["hours"] . "', '" . $bookconfirm . "', '" . $data["monthly_price_factor"] . "', '" . $data["weekly_price_factor"] . "', '" . $display_location . "')
		ON DUPLICATE KEY UPDATE
		listing_type_id = '" . $data["listing_type_id"] . "', cancelation_policy = '" . $data["cancelation_policy"] . "',
		cleaningfee = '" . $data["cleaningfee"] . "', securedeposit = '" . $data["securedeposit"] . "',
		extraperson = '" . $data["extraperson"] . "', hours = '" . $data["hours"] . "',
		bookconfirm = '" . $bookconfirm . "', monthly_price_factor = '" . $data["monthly_price_factor"] . "',
		weekly_price_factor = '" . $data["weekly_price_factor"] . "',
		display_location = '" . $display_location . "'";
		$query = $this->db->query($sql);
	}

	function GetAuto_empty() {
		$data = array();
		$data["name"] = "";
		$data["car_number"] = "";
		$data["car_color"] = "";
		return $data;
	}

	function updateCar($data, $car_id) {
		$this->db->where('id', $car_id);
		$this->db->update('reservation_cars', $data);
	}

	function insertCar($data) {
		$this->db->insert('reservation_cars', $data);
	}

	function deleteCar($id) {
		$this->db->where('id', $id);
		$this->db->delete('reservation_cars');
	}

	function get_reservation_comment_list($reservation_id) {
		$reservation_comments_data = array();
		$sql = "SELECT reservation_comments.*, users.fullname, users.lastname FROM reservation_comments
		LEFT JOIN users ON users.id = reservation_comments.user_id
		WHERE reservation_comments.reservation_id = " . $reservation_id;
		//echo $sql;
		$query = $this->db->query($sql);
		$temp_data_old_1 = array();

		foreach($query->result_array()as $row) {
			array_push($reservation_comments_data, array("comment_id" => $row["id"], "reservation_id" => $reservation_id, "comment_date" => $row["date"], "comment_user" => $row["fullname"] . " " . $row["lastname"], "comment" => $row["comment"]));
		}
		return $reservation_comments_data;
	}

	function GetComment($id) {
		$data = array();
		$sql = "SELECT * FROM reservation_comments WHERE id = " . $id;
		//echo $sql;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row_array();
			return $row;
		}
		return $data;
	}

	function GetComment_empty() {
		$data = array();
		//$data ["user_id"] = $_SESSION ['user'] ['id'];
		$data["comment"] = "";
		//$data ["date"] = gmdate("Y-m-d H:i:s");
		return $data;
	}

	function updateComment($data, $car_id) {
		$this->db->where('id', $car_id);
		$this->db->update('reservation_comments', $data);
	}

	function insertComment($data) {
		$this->db->insert('reservation_comments', $data);
	}

	function deleteComment($id) {
		$this->db->where('id', $id);
		$this->db->delete('reservation_comments');
	}

	function get_guest_res_count($guest_id) {
		$res_count = 0;
		$sum_amount = 0;
		$sum_duration = 0;
// 		$sql = "SELECT count(1) as res_count, SUM(deskofreservation.duration) as sum_duration, SUM(deskofreservation.amount) as sum_amount
// 				FROM deskofreservation
// 				INNER JOIN guests ON deskofreservation.guest_id = guests.id
// 				WHERE deskofreservation.guest_id = " . $guest_id;
// 		$query = $this->db->query($sql);
// 		if($query->num_rows()> 0) {
// 			$row = $query->row();
// 			$res_count += $row->res_count;
// 			$sum_amount += $row->sum_amount;
// 			$sum_duration += $row->sum_duration;
// 		}
		$sql = "SELECT count(1) as res_count, SUM(deskofreservation.duration) as sum_duration, SUM(deskofreservation.amount) as sum_amount
				FROM guests_deskofreservation
				INNER JOIN guests ON guests_deskofreservation.guest_id = guests.id
				INNER JOIN deskofreservation ON deskofreservation.id = guests_deskofreservation.reservation_id
				WHERE guests_deskofreservation.guest_id = " . $guest_id;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$res_count += $row->res_count;
			$sum_amount += $row->sum_amount;
			$sum_duration += $row->sum_duration;
		}
		$return_data = array();
		$return_data["res_count"] = $res_count;
		$return_data["sum_amount"] = $sum_amount;
		$return_data["sum_duration"] = $sum_duration;
		return $return_data;
	}

	function get_guest_agescale($date_1, $date_2) {
		// повертає 'a' - дорослий >=14, 'c' - 4 <= дитина <14, 'b' - немовля <4
		try {
			$date_1 = new DateTime($date_1);
			$date_2 = new DateTime($date_2);
		}
		catch(Exception $e) {
			echo 'in frontdesk_c2/get_guest_agescale: ', $e->getMessage(), "\n";
			//вивід повідомлень можна закоментувати
			echo "<br>", 'a - adult is returned';
			return 'a';
		}
		$interval_years = $date_1->diff($date_2)->y;
		if(14 <= $interval_years) {
			return 'a';
		} elseif($interval_years < 4) {
			return 'b';
		} else {
			return 'c';
		}
	}

	function get_weekday_name($date) {
		$day_names_array = array("7" => '{mlw_full_suanday}',
								 "1" => '{mlw_full_monday}',
								 "2" => '{mlw_full_tuesday}',
								 "3" => '{mlw_full_wednesday}',
								 "4" => '{mlw_full_thursday}',
								 "5" => '{mlw_full_friday}',
								 "6" => '{mlw_full_saturday}');
		list($year, $month, $day)= explode("-", $date);
		$day_week_id = date("N", mktime(0, 0, 0, $month, $day, $year));
		$dayin_name = $day_names_array[$day_week_id];
		return $dayin_name;
	}

	function get_messages_list() {
		$url_data = array('url_type' => 'channel_mc_view');
		$url_mc = $this->messages_model->get_mc_urls($url_data);
		$messages_data = array();
		$sql = "SELECT id, subject, time FROM messages
		WHERE isread = 0 AND isdeleted = 0 ORDER BY id DESC LIMIT 0, 50";
		$query = $this->db->query($sql);

		foreach($query->result_array()as $row) {
			array_push($messages_data, array("message_id" => $row["id"], "message_time" => $row["time"], "url_mc" => $url_mc, //"subject_name" => $this->mlanguages->get_translated_str("mailbox_messageslist", $lang = "", $row["subject"])
			"subject_name" => $row["subject"]));
		}
		return $messages_data;
	}

	function price_style($price) {
		$price_mass = explode(".", $price);
		$return_value = $price;
		if(isset($price_mass[1])) {
			$return_value = $price_mass[0];
			$return_value .= '.<span class="sm_number">' . $price_mass[1] . '</span>';
		}
		return $return_value;
	}

	function free_days_verification_by_roomid($datein, $dateout, $room_id, $early_check_in_close = 0, $late_check_out_close = 0) {
		list($year, $month, $day)= explode("-", $datein);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $dateout);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day - 1, $year)/ 86400);
		if($early_check_in_close == 1) {
			$intdatein = $intdatein - 1;
			$datein = date("Y-m-d", $intdatein * 86400);
		}
		if($late_check_out_close == 1) {
			$intdateout = $intdateout + 1;
			$dateout = date("Y-m-d", $intdateout * 86400);
		}
		$sql = "SELECT * FROM deskofdays
        LEFT JOIN (SELECT deskofreservation.id as res_id, deskofreservation.room_id as res_room_id, deskofreservation.datein,
        deskofreservation.dateout FROM deskofreservation
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        WHERE deskofreservation.datein <= $dateout AND deskofreservation.dateout >= $datein AND deskofreservation.room_id = $room_id
        AND deskofreservation.deleted = 0 AND deskofreservation.cancel = 0) as t1
        ON deskofdays.reservation_id = t1.res_id AND deskofdays.room_id = $room_id
        WHERE deskofdays.room_id = " . $room_id . " AND deskofdays.intdate >= " . $intdatein . " AND deskofdays.intdate <= " . $intdateout . " ORDER BY deskofdays.date ASC";
		//echo $sql;
		//die();
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			return 0;
		} else {
			return 1;
		}
	}

	function get_cancel_ajax_data($res_data) {
		$res = array();
		$res["ok"] = 1;
		$res["resrvation_id"] = $res_data["reservation_id"];
		$res["room_id"] = $res_data["room_id"];
		list($year, $month, $day)= explode("-", $res_data['datein']);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $res_data['dateout']);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		if($res_data["early_check_in_close"] == 1) {
			$intdatein = $intdatein - 1;
		}
		if($res_data["late_check_out_close"] == 0) {
			$intdateout = $intdateout - 1;
		}
		$res["intdatein"] = $intdatein;
		$res["intdateout"] = $intdateout;
		$query = $this->db->query("SELECT category_id FROM rooms WHERE id = " . 
								  $res["room_id"]);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$category_id = $row->category_id;
		}
		$availability_arr = $this->frontdesk->get_categories_freerooms_period($res_data['datein'], $res_data['dateout'], 1, 1, $category_id);
		//echo "<pre>";
		//print_r ( $result );
		//print_r ( $availability_arr );
		//die ();
		$res['availability_arr'] = $availability_arr;
		return $res;
	}

	function get_yield_prices($startintdate, $endintdate, $category_id = 0, $rate_id = 0, $categories_array = 0, $rates_array = 0) {
		$select = '';
		if($category_id <> 0) {
			$select .= 'yieldprice.category_id = ' . $category_id . ' AND ';
		}
		if($rate_id <> 0) {
			$select .= 'yieldprice.id_restrict_rate = ' . $rate_id . ' AND ';
		}
		if($categories_array <> 0) {
			$cat_count = count($categories_array);
			if($cat_count > 0) {
				$counter = 1;
				$select .= 'yieldprice.category_id IN (';

				foreach($categories_array as $cat_id) {
					if($cat_count == $counter) {
						$select .= $cat_id;
					} else {
						$select .= $cat_id . ',';
					}
					$counter ++;
				}
				$select .= ') AND ';
			}
		}
		if($rates_array <> 0) {
			$rates_count = count($rates_array);
			if($rates_count > 0) {
				$counter = 1;
				$select .= 'yieldprice.id_restrict_rate IN (';

				foreach($rates_array as $cell_rate_id) {
					if($rates_count == $counter) {
						$select .= $cell_rate_id;
					} else {
						$select .= $cell_rate_id . ',';
					}
					$counter ++;
				}
				$select .= ') AND ';
			}
		}
		$yieldprice_array = array();
		$sql = "SELECT * FROM yieldprice
		WHERE " . $select . " intdate >= " . $startintdate . " AND intdate <= " . $endintdate;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["price"] = $row->price;
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["perperson_price"] = $row->perperson_price;
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["extrabed_price"] = $row->extrabed_price;
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["additional_bed_price"] = $row->additional_bed_price;
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["baby_2price"] = $row->baby_2price;
				$yieldprice_array[$row->category_id][$row->id_restrict_rate][$row->intdate]["singleuseprice"] = $row->singleuseprice;
			}
		}
		return $yieldprice_array;
	}

	function get_prices($startintdate, $endintdate, $category_id = 0, $rate_id = 0, $categories_array = 0, $rates_array = 0) {
		$select = '';
		if($category_id <> 0) {
			$select .= 'seasonspricelist.category_id = ' . $category_id . ' AND ';
		}
		if($rate_id <> 0) {
			$select .= 'seasonspricelist.rate_id = ' . $rate_id . ' AND ';
		}
		if($categories_array <> 0) {
			$cat_count = count($categories_array);
			if($cat_count > 0) {
				$counter = 1;
				$select .= 'seasonspricelist.category_id IN (';

				foreach($categories_array as $cat_id) {
					if($cat_count == $counter) {
						$select .= $cat_id;
					} else {
						$select .= $cat_id . ',';
					}
					$counter ++;
				}
				$select .= ') AND ';
			}
		}
		if($rates_array <> 0) {
			$rates_count = count($rates_array);
			if($rates_count > 0) {
				$counter = 1;
				$select .= 'seasonspricelist.rate_id IN (';

				foreach($rates_array as $cell_rate_id) {
					if($rates_count == $counter) {
						$select .= $cell_rate_id;
					} else {
						$select .= $cell_rate_id . ',';
					}
					$counter ++;
				}
				$select .= ') AND ';
			}
		}
		$array_prices = array();
		$sql = "SELECT categories.id as cat_id, deskofdaysseason.intdate,
        seasonspricelist.rate_id, seasonspricelist.price, seasonspricelist.perperson_price,
        seasonspricelist.extrabed_price, seasonspricelist.additional_bed_price, seasonspricelist.baby_2price,
        seasonspricelist.singleuse_price
        FROM seasonspricelist
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN deskofdaysseason ON deskofdaysseason.seasonid = seasons.id
        WHERE $select categories.is_active = 1 AND intdate >= " . $startintdate . " AND intdate <= " . $endintdate;
		//echo $sql;
		//die();
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["price"] = $row->price;
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["perperson_price"] = $row->perperson_price;
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["extrabed_price"] = $row->extrabed_price;
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["additional_bed_price"] = $row->additional_bed_price;
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["baby_2price"] = $row->baby_2price;
				$array_prices[$row->cat_id][$row->rate_id][$row->intdate]["singleuseprice"] = $row->singleuse_price;
			}
		}
		return $array_prices;
	}

	function get_active_rates() {
		$rates = array();
		$query = $this->db->query("SELECT id, caption FROM rate WHERE isactive = 1 ORDER BY `caption` ASC");
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$rates[$row->id]["rate_id"] = $row->id;
				$rates[$row->id]["rate_name"] = $row->caption;
			}
		}
		return $rates;
	}
	
	function get_active_policies($data) {
	    $select = "";
	    if(isset($data['policies_ids'])) {
	        $policies_ids = implode ( ",", $data['policies_ids'] );
	        $select .= " dc_cancelationpolicy.dc_cancelation_policy_id IN ($policies_ids) AND ";
	    }
		$policies = array();
		$query = $this->db->query("SELECT dc_cancelationpolicy.dc_cancelation_policy_id, global_policy.name as policy_name, 
		                           global_policy.deadline_hours, global_policy.penalty_ad, global_policy.penalty_ad_nights
		                           FROM dc_cancelationpolicy 
		                           INNER JOIN global_hotelix_common.dc_cancelationpolicy_list as global_policy ON 
		                           global_policy.id = dc_cancelationpolicy.dc_cancelation_policy_id
		                           WHERE $select 1");
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$policies[$row->dc_cancelation_policy_id]["policy_id"] = $row->dc_cancelation_policy_id;
				$policies[$row->dc_cancelation_policy_id]["policy_name"] = $row->policy_name;
				$policies[$row->dc_cancelation_policy_id]["deadline_hours"] = $row->deadline_hours;
				$policies[$row->dc_cancelation_policy_id]["penalty_ad"] = $row->penalty_ad;
				$policies[$row->dc_cancelation_policy_id]["penalty_ad_nights"] = $row->penalty_ad_nights;
			}
		}
		return $policies;
	}

	function get_active_categories($property_id = 0, $active = 1, $web_booking = 0) {
		$categories = array();
		$select = "";
		if($active == 1) {
			$select .= " categories.is_active = 1 AND ";
		}
		if($web_booking == 1) {
		    $select .= " categories.web_booking = 1 AND ";
		}
		if($property_id > 0) {
			$select .= " categories.property_id = " . $property_id . " AND ";
		}
		$select .= " 1 ";
		$query = $this->db->query("SELECT id, shortname, name FROM categories WHERE $select ORDER BY `order` ASC");
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				if($row->shortname == "") {
					$shortname = $row->name;
				} else {
					$shortname = $row->shortname;
				}
				$categories[$row->id]["category_id"] = $row->id;
				$categories[$row->id]["category_name"] = $shortname;
				$categories[$row->id]["category_fullname"] = $row->name;
				$categories[$row->id]["selected"] = "";
			}
		}
		return $categories;
	}

	function get_categories($property_id = 0) {
		$global_language = $this->hotelix_config->get_record("global_language", "int");
		$select = "";
		if($property_id > 0) {
			$select .= " property_id = " . $property_id . " AND ";
		}
		$categories = array();
		$query = $this->db->query("SELECT id, shortname, name, property_id, add_places, places, comment, size, size_type, base_price 
		                           FROM categories WHERE $select 1 ORDER BY `order` ASC");
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				if($row->shortname == "") {
					$shortname = $row->name;
				} else {
					$shortname = $row->shortname;
				}
				$international_name_array = $this->internationalfields->get_value("category", $row->id, "international_name", $global_language);
				if(isset($international_name_array[$global_language])) {
					$international_name = $international_name_array[$global_language];
				} else {
					$international_name = $row->name;
				}
				
				$international_comment_array = $this->internationalfields->get_value("category", $row->id, "international_comment", $global_language);
				if(isset($international_comment_array[$global_language])) {
				    $international_description = $international_comment_array[$global_language];
				} else {
				    $international_description = $row->comment;
				}
				
				$categories[$row->id]["category_id"] = $row->id;
				$categories[$row->id]["category_name"] = $shortname;
				$categories[$row->id]["category_fullname"] = $international_name;
				$categories[$row->id]["category_description"] = $international_description;
				$categories[$row->id]["category_property_id"] = $row->property_id;
				$categories[$row->id]["category_add_places"] = $row->add_places;
				$categories[$row->id]["category_places"] = $row->places;
				$categories[$row->id]["category_size"] = $row->size;
				$categories[$row->id]["category_size_type"] = $row->size_type;
				$categories[$row->id]["category_base_price"] = $row->base_price;
				$categories[$row->id]["selected"] = "";
			}
		}
		return $categories;
	}
	
	function get_categories_data($data) {
	    $global_language = $this->hotelix_config->get_record("global_language", "int");
	    $select = "";
	    if(isset($data['property_id'])) {
	        $select .= " categories.property_id = " . $property_id . " AND ";
	    }
	    if(isset($data['category_ids'])) {
	        $category_ids = implode ( ",", $data['category_ids'] );
	        $select .= " categories.id IN ($category_ids) AND ";
	    }
	    
	    $categories = array();
	    $sql = "SELECT categories.id, categories.shortname, categories.name, categories.property_id, categories.places, 
	    categories.add_places, categories.baby_places, categories.comment, categories.size, categories.size_type, categories.base_price,
	    room_types.name as type_name
	    FROM categories 
	    LEFT JOIN room_types ON room_types.id = categories.room_type_id            
	    WHERE $select 1 ORDER BY `order` ASC";
// 	    echo $sql;
// 	    die();
	    $query = $this->db->query( $sql );
	    if($query->num_rows()> 0) {
	
	        foreach($query->result()as $row) {
	            if($row->shortname == "") {
	                $shortname = $row->name;
	            } else {
	                $shortname = $row->shortname;
	            }
	            $international_name_array = $this->internationalfields->get_value("category", $row->id, "international_name", $global_language);
	            if(isset($international_name_array[$global_language])) {
	                $international_name = $international_name_array[$global_language];
	            } else {
	                $international_name = $row->name;
	            }
	            
	            $international_comment_array = $this->internationalfields->get_value("category", $row->id, "international_comment", $global_language);
	            if(isset($international_comment_array[$global_language])) {
	                $international_description = $international_comment_array[$global_language];
	            } else {
	                $international_description = $row->comment;
	            }
	            
	            $categories[$row->id]["category_id"] = $row->id;
	            $categories[$row->id]["category_name"] = $shortname;
	            $categories[$row->id]["category_fullname"] = $international_name;
	            $categories[$row->id]["category_description"] = $international_description;
	            $categories[$row->id]["category_property_id"] = $row->property_id;
	            $categories[$row->id]["category_places"] = $row->places;
	            $categories[$row->id]["category_add_places"] = $row->add_places;
	            $categories[$row->id]["category_baby_places"] = $row->baby_places;
	            $categories[$row->id]["category_type_name"] = $row->type_name;
	            $categories[$row->id]["category_comment"] = $row->comment;
	            $categories[$row->id]["category_size"] = $row->size;
	            $categories[$row->id]["category_size_type"] = $row->size_type;
	            $categories[$row->id]["category_base_price"] = $row->base_price;
	            $categories[$row->id]["selected"] = "";;
	        }
	    }
	    return $categories;
	}
	
	function get_rates_data($data) {
	    $global_language = $this->hotelix_config->get_record("global_language", "int");
	    $select = "";

	    if(isset($data['category_ids'])) {
	        $category_ids = implode ( ",", $data['category_ids'] );
	        $select .= " id IN ($category_ids) AND ";
	    }
	     
	    $rates = array();
	    $sql = "SELECT id, caption, cancellation_policy_id, meal_policy_id FROM rate WHERE $select 1 ORDER BY id ASC";
	    // 	    echo $sql;
	    // 	    die();
	    $query = $this->db->query( $sql );
        if ($query->num_rows() > 0) {
            
            foreach ($query->result() as $row) {  
//                 $international_name_array = $this->internationalfields->get_value("rate", $row->id, "international_name", $global_language);
//                 if (isset($international_name_array[$global_language])) {
//                     $international_name = $international_name_array[$global_language];
//                 } else {
//                     $international_name = $row->caption;
//                 }
                
                $rates[$row->id]["rate_id"] = $row->id;
                $rates[$row->id]["rate_name"] = $row->caption;
                $rates[$row->id]["rate_cancellation_policy_id"] = $row->cancellation_policy_id;
                $rates[$row->id]["rate_meal_policy_id"] = $row->meal_policy_id;
                $rates[$row->id]["rate_description"] = "";
            }
        }
	    return $rates;
	}
	
	function get_rate2categories_data() {
	    $return_data = array();
	    $sql = "SELECT rate_id, category_id FROM ratetocategory WHERE onlinebook = 1";
	    $query = $this->db->query( $sql );
	    if ($query->num_rows() > 0) {
	        foreach ($query->result() as $row) {
	            $return_data[$row->rate_id][$row->category_id]["category_id"] = $row->category_id;
	        }
	    }
	    return $return_data;
	}

	function get_rooms_info($category_id = 0) {
		$select = "";
		if($category_id > 0) {
			$select .= " rooms.category_id = " . $category_id . " AND ";
		}
		$data = array();
		$sql = "SELECT rooms.id as room_id, rooms.name as room_name, rooms.id_floor as floor, categories.shortname as category_shortname,
        property_information.property_name
        FROM rooms
        INNER JOIN categories ON categories.id = rooms.category_id
        INNER JOIN property_information ON property_information.id = categories.property_id
        WHERE $select 1";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$data[$row->room_id]["room_id"] = $row->room_id;
				$data[$row->room_id]["room_name"] = $row->room_name;
				$data[$row->room_id]["category_shortname"] = $row->category_shortname;
				$data[$row->room_id]["property_name"] = $row->property_name;
				$data[$row->room_id]["room_floor"] = $row->floor;
			}
		}
		return $data;
	}

	function get_property_names() {
		$property_information = array();
		$query = $this->db->query('SELECT * FROM property_information');
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$property_information[$row->id]["id"] = $row->id;
				$property_information[$row->id]["name"] = $row->property_name;
				$property_information[$row->id]["selected"] = "";
			}
		}
		return $property_information;
	}

	function get_property_types() {
		$property_types = array();
		$sql2 = "SELECT id, name, dwelling FROM global_hotelix_common.property_type WHERE 1";
		$query2 = $this->db->query($sql2);
		if($query2->num_rows()> 0) {

			foreach($query2->result()as $row2) {
				$property_types[$row2->dwelling][$row2->id]["property_type_id"] = $row2->id;
				$property_types[$row2->dwelling][$row2->id]["property_type_name"] = "{-" . $row2->name . "-}";
				$property_types[$row2->dwelling][$row2->id]["property_type_selected"] = "";
			}
		}
		return $property_types;
	}

	function get_property_list() {
		$countries = $this->fms_core->get_dict_country("global_fms_base", 1);
		$property_types = $this->get_property_types();
		$property_information = array();
		$user_language = $_SESSION['user']['language'];
		switch($user_language) {
			case "rus" : $list_lang = "NAME";
			break;
			default : $list_lang = "native_name";
			//"NAME_LAT";
		}
		$query = $this->db->query('SELECT id, property_name, dwelling, property_type, country, city, state FROM property_information');
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$property_information[$row->id]["property_id"] = $row->id;
				$property_information[$row->id]["property_name"] = $row->property_name;
				$property_information[$row->id]["property_country"] = "";
				if(isset($countries[$row->country][$list_lang])) {
					$property_information[$row->id]["property_country"] = $countries[$row->country][$list_lang];
				}
				$property_information[$row->id]["property_type"] = "";
				if(isset($property_types[$row->dwelling][$row->property_type])) {
					$property_information[$row->id]["property_type"] = $property_types[$row->dwelling][$row->property_type]["property_type_name"];
				}
				$property_information[$row->id]["property_state"] = $row->state;
				$property_information[$row->id]["property_city"] = $row->city;
				$property_information[$row->id]["property_country"] = $row->country;
			}
		}
		return $property_information;
	}

	function get_first_prperty_id() {
		$property_id = 0;
		$sql = "SELECT id FROM property_information WHERE 1 ORDER BY id ASC LIMIT 0,1";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$property_id = $row->id;
		}
		return $property_id;
	}

	function get_seasons() {
		$seasons = array();
		$query = $this->db->query('SELECT id, name, startdate, enddate FROM seasons');
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$seasons[$row->id]["id"] = $row->id;
				$seasons[$row->id]["name"] = $row->name;
				$seasons[$row->id]["startdate"] = $row->startdate;
				$seasons[$row->id]["enddate"] = $row->enddate;
				$seasons[$row->id]["selected"] = "";
			}
		}
		return $seasons;
	}

	function get_partners($conditions = array()) {
		$where_str = "";
		if(isset($conditions['only_active'])&& $conditions['only_active'] == 1) {
			$where_str .= " WHERE is_active = 1";
		}
		$partners = array();
		$query = $this->db->query("SELECT id, name FROM partners $where_str");
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$partners[$row->id]["id"] = $row->id;
				$partners[$row->id]["name"] = $row->name;
				$partners[$row->id]["selected"] = "";
			}
		}
		return $partners;
	}

	function get_restricts_rates() {
		$restrictList = array();
		$query = $this->db->query("SELECT * FROM dc_global_restrict_rate");

		foreach($query->result()as $row) {

			foreach($query->result()as $row) {
				$restrictList[$row->rate_id]["rate_id"] = $row->rate_id;
				$restrictList[$row->rate_id]["rate_name"] = $row->name;
			}
		}
		return $restrictList;
	}

	function get_restricts($date_from, $date_to, $category_id = 0, $rate_id = 0) {
		$restricts = array();
		$select = "";
		if($category_id > 0) {
			$select .= " deskofrate.category_id = " . $category_id . " AND ";
		}
		if($rate_id > 0) {
			$select .= " deskofrate.rate_id = " . $rate_id . " AND ";
		}
		list($year, $month, $day)= explode("-", $date_from);
		$startintdate = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $date_to);
		$endintdate = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		$sql = "SELECT deskofrate.* FROM deskofrate
		INNER JOIN categories ON categories.id = deskofrate.category_id
		INNER JOIN dc_global_restrict_rate ON dc_global_restrict_rate.rate_id = deskofrate.rate_id
		WHERE " . $select . " categories.is_active=1 AND intdate >= " . $startintdate . " AND intdate <= " . $endintdate;
		$query = $this->db->query($sql);
		$hook = 0;

		foreach($query->result()as $row) {
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["minstay"] = $row->minstay;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["maxstay"] = $row->maxstay;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["minstayarrival"] = $row->minstayarrival;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["minstaythrought"] = $row->minstaythrought;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["closed"] = $row->closed;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["closedonarrival"] = $row->closedonarrival;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["closedondeparture"] = $row->closedondeparture;
			$restricts[$row->category_id][$row->rate_id][$row->intdate]["day"] = date("d", $row->intdate * 86400);
		}
		return $restricts;
	}

	function get_online_module_restricts($date_from, $date_to) {
		list($year, $month, $day)= explode("-", $date_from);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $date_to);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		$deskofrate_array = array();
		$sql = "SELECT deskofrate.maxstay, deskofrate.minstaythrought, deskofrate.minstayarrival, deskofrate.closed, deskofrate.closedonarrival,
		deskofrate.closedondeparture, deskofrate.intdate, categories.id as category_id, rate.id as rate_id
        FROM deskofrate
		INNER JOIN categories ON categories.id = deskofrate.category_id
	    INNER JOIN onlinerates ON onlinerates.restrictid = deskofrate.rate_id
		INNER JOIN rate ON rate.id = onlinerates.rateid
		WHERE deskofrate.intdate >= " . $intdatein . " AND deskofrate.intdate <= " . $intdateout . " AND categories.is_active = 1 AND categories.web_booking = 1";
		//echo $sql . "<br>";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				// count_rooms_booking
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["date"] = date("Y-m-d", $row->intdate * 86400);
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["closed"] = $row->closed;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["minstaythrought"] = $row->minstaythrought;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["minstayarrival"] = $row->minstayarrival;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["maxstay"] = $row->maxstay;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["closedonarrival"] = $row->closedonarrival;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["closedondeparture"] = $row->closedondeparture;
				$deskofrate_array[$row->category_id][$row->rate_id][$row->intdate]["closedonarrival"] = $row->closedonarrival;
			}
		}
		//echo "<pre>";
		//print_r($deskofrate_array);
		return $deskofrate_array;
	}

	function check_date_range($data) {
		$max_days_count = 1095;
		$diff = $data['intdate_end'] - $data['intdate_start'];
		return($diff > $max_days_count)? 0 : 1;
	}

	function setrestrict_desksave($data, $return_type = "") {
		//echo "<pre>";
		$log_data = array();
		$new_log_json_save = 1;
		if(isset($data["datein"])and isset($data["dateout"])) {
			$datein = $data["datein"];
			$dateout = $data["dateout"];
			$log_data["datein"] = $data["datein"];
			list($year, $month, $day)= explode("-", $data["datein"]);
			$data["datein"] = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
			list($year, $month, $day)= explode("-", $data["dateout"]);
			$data["dateout"] = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
			$date_range_data = array();
			$date_range_data['intdate_start'] = $data["datein"];
			$date_range_data['intdate_end'] = $data["dateout"];
			$isvalid_date_range = $this->check_date_range($date_range_data);
			// перевірка чи проміжок по датам не перевищує максимальне допустиме значення (вказане в ф-ї)
			if($isvalid_date_range == 1) {
				$log_data["dateout"] = gmdate("Y-m-d",($data["dateout"] + 1)* 86400);
				$log_data["category_id"] = $data["category_id"];
				$log_data["rate_id"] = $data["rate_id"];
				if($new_log_json_save == 0) {
					$data_1 = $this->Loger_admin->get_values_multicol("deskofrate", $datein, $dateout, $data['rate_id'], $data['category_id']);
				}
				if($data["delete_action"] == 1) {
					$data_1 = array();
					$data_1[0]["category_id"] = 0;
					$data_1[0]["rate_id"] = 0;
					$data_1[0]["intdate"] = 0;
					$data_1[0]["minstay"] = 0;
					$data_1[0]["maxstay"] = 0;
					$data_1[0]["minstayarrival"] = 0;
					$data_1[0]["minstaythrought"] = 0;
					$data_1[0]["closed"] = 0;
					$data_1[0]["closedonarrival"] = 0;
					$data_1[0]["closedondeparture"] = 0;
					$data_2 = array();
					$data_2[0]["category_id"] = 0;
					$data_2[0]["rate_id"] = 0;
					$data_2[0]["intdate"] = 0;
					$data_2[0]["minstay"] = 0;
					$data_2[0]["maxstay"] = 0;
					$data_2[0]["minstayarrival"] = 0;
					$data_2[0]["minstaythrought"] = 0;
					$data_2[0]["closed"] = 0;
					$data_2[0]["closedonarrival"] = 0;
					$data_2[0]["closedondeparture"] = 0;
				}
				for($i = $data["datein"];
				$i <= $data["dateout"];
				$i ++ ) {
					$week_day = gmdate("w", $i * 86400);
					$i_str = gmdate("Y-m-d", $i * 86400);
					if(isset($data["week"][$week_day])) {
						if($data["delete_action"] == 1) {
							// $data_1 = $this->Loger_admin->get_values_multicol ( "deskofrate", $i_str, $i_str, $data ['rate_id'], $data ['category_id'] );
							$this->db->where('category_id', $data['category_id']);
							$this->db->where('rate_id', $data['rate_id']);
							$this->db->where('intdate', $i);
							$this->db->delete('deskofrate');
							// $data_2 = array();
							// $data_2[0]["category_id"] = 0;
							// $data_2[0]["rate_id"] = 0;
							// $data_2[0]["intdate"] = 0;
							// $data_2[0]["minstay"] = 0;
							// $data_2[0]["maxstay"] = 0;
							// $data_2[0]["minstayarrival"] = 0;
							// $data_2[0]["minstaythrought"] = 0;
							// $data_2[0]["closed"] = 0;
							// $data_2[0]["closedonarrival"] = 0;
							// $data_2[0]["closedondeparture"] = 0;
						} else {
							$this->db->select('intdate');
							$this->db->where('category_id', $data['category_id']);
							$this->db->where('rate_id', $data['rate_id']);
							$this->db->where('intdate', $i);
							$query = $this->db->get('deskofrate');
							$cell = array();
							if($data['closed'] != 2)
								$cell['closed'] = $data['closed'];
							if($data['closedonarrival'] != 2)
								$cell['closedonarrival'] = $data['closedonarrival'];
							if($data['closedondeparture'] != 2)
								$cell['closedondeparture'] = $data['closedondeparture'];
							if($data['maxstay'] === '') {
								// $cell ['maxstay'] = 0;
							} else 
								$cell['maxstay'] = (int) $data['maxstay'];
							if($data['minstayarrival'] === '') {
							} else {
								$cell['minstayarrival'] = (int) $data['minstayarrival'];
							}
							if($data['minstaythrought'] === '') {
							} else {
								$cell['minstaythrought'] = (int) $data['minstaythrought'];
							}
							// print_r($cell);
							// die();
							if(sizeof($cell)== 0) {
								switch($return_type) {
									case "ajax_mode" : $result = array();
									$result["ok"] = 0;
									return $result;
									break;
									default : die("<meta http-equiv='refresh' content='0;url=/reservation_c2/restrict_calendar'>");
									break;
								}
							}
							if($query->num_rows()> 0) {
								// echo "++";
								// $data_1 = $this->Loger_admin->get_values_multicol ( "deskofrate", $i_str, $i_str, $data ['rate_id'], $data ['category_id'] );
								$this->db->where('category_id', $data['category_id']);
								$this->db->where('rate_id', $data['rate_id']);
								$this->db->where('intdate', $i);
								$this->db->update('deskofrate', $cell);
							} else {
								// echo "--";
								// $data_1 = array();
								// $data_1[0]["category_id"] = 0;
								// $data_1[0]["rate_id"] = 0;
								// $data_1[0]["intdate"] = 0;
								// $data_1[0]["minstay"] = 0;
								// $data_1[0]["maxstay"] = 0;
								// $data_1[0]["minstayarrival"] = 0;
								// $data_1[0]["minstaythrought"] = 0;
								// $data_1[0]["closed"] = 0;
								// $data_1[0]["closedonarrival"] = 0;
								// $data_1[0]["closedondeparture"] = 0;
								$cell['category_id'] = $data['category_id'];
								$cell['rate_id'] = $data['rate_id'];
								$cell['intdate'] = $i;
								// print_r($cell);
								$this->db->insert('deskofrate', $cell);
							}
							// $data_2 = $this->Loger_admin->get_values_multicol ( "deskofrate", $i_str, $i_str, $data ['rate_id'], $data ['category_id'] );
						}
					}
					// echo "<pre>";
					// print_r($data_1);
					// print_r($data_2);
					// die();
					// $this->Loger_admin->SaveLog_multicol ( $data_1, $data_2, "loger_admin", "deskofrate", "edit" );
				}
				if($new_log_json_save == 0) {
					if($data["delete_action"] != 1) {
						$data_2 = $this->Loger_admin->get_values_multicol("deskofrate", $datein, $dateout, $data['rate_id'], $data['category_id']);
					}
					$this->Loger_admin->SaveLog_multicol($data_1, $data_2, "loger_admin", "deskofrate", "edit");
				} else {
					$category_name = $this->db->select('shortname')->get_where('categories', array('id' => $_POST['category_id']))->row()->shortname;
					$rate_name = $this->db->select('name')->get_where('dc_global_restrict_rate', array('rate_id' => $_POST['rate_id']))->row()->name;
					$json_array = array();
					$json_array['category_name'] = $category_name;
					$json_array['rate_name'] = $rate_name;
					$json_array['datein'] = $_POST['datein'];
					$json_array['dateout'] = $_POST['dateout'];
					$json_array['closed'] = $_POST['closed'];
					$json_array['minstaythrought'] = $_POST['minstaythrought'];
					$json_array['closedonarrival'] = $_POST['closedonarrival'];
					$json_array['maxstay'] = $_POST['maxstay'];
					$json_array['closedondeparture'] = $_POST['closedondeparture'];
					$json_array['minstayarrival'] = $_POST['minstayarrival'];
					$json_array['week'] = $_POST['week'];
					$savelog_data = array();
					$savelog_data['json'] = json_encode($json_array);
					$this->Loger_admin->SaveLog_json($savelog_data, "loger_admin", "deskofrate", "edit");
				}
				
				/*
				 * UPDATE dc_log
				 *
				 */
				$this->frontdesk->dc_log_update($log_data, 0, 1);
				// $this->frontdesk->dc_log_update($log_data, 0, 1);
				$this->frontdesk->dc_log_restrict_update($log_data, 0);
				$this->db->where('closed', 0);
				$this->db->where('closedonarrival', 0);
				$this->db->where('closedondeparture', 0);
				$this->db->where('minstayarrival', 0);
				$this->db->where('minstaythrought', 0);
				// $this->db->where ( 'minstay', 0 );
				$this->db->where('maxstay', 0);
				$this->db->delete('deskofrate');
			} else {
				$newdata = array('header_msg_text' => "{clt_period_range_error}");
				$this->session->set_userdata($newdata);
			}
		}
		switch($return_type) {
			case "ajax_mode" : $result = array();
			if($isvalid_date_range == 1) {
				$result["ok"] = 1;
			} else {
				$result["ok"] = 0;
			}
			return $result;
			break;
			default : die("<meta http-equiv='refresh' content='0;url=/reservation_c2/restrict_calendar'>");
			break;
		}
	}

	function restrict_delete($data, $return_type = "") {
		//echo "<pre>";
		$log_data = array();
		if(isset($data["datein"])and isset($data["dateout"])) {
			$datein = $data["datein"];
			$dateout = $data["dateout"];
			$log_data["datein"] = $data["datein"];
			list($year, $month, $day)= explode("-", $data["datein"]);
			$data["datein"] = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
			list($year, $month, $day)= explode("-", $data["dateout"]);
			$data["dateout"] = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
			$log_data["dateout"] = gmdate("Y-m-d",($data["dateout"] + 1)* 86400);
			$log_data["category_id"] = $data["category_id"];
			$log_data["rate_id"] = $data["rate_id"];
			//$data_1 = $this->Loger_admin->get_values_multicol ( "deskofrate", $datein, $dateout, $data ['rate_id'], $data ['category_id'] );
			for($i = $data["datein"];
			$i <= $data["dateout"];
			$i ++ ) {
				$week_day = gmdate("w", $i * 86400);
				$i_str = gmdate("Y-m-d", $i * 86400);
				if($data["delete_action"] == 1) {
					//$data_1 = $this->Loger_admin->get_values_multicol ( "deskofrate", $i_str, $i_str, $data ['rate_id'], $data ['category_id'] );
					$this->db->where('category_id', $data['category_id']);
					$this->db->where('rate_id', $data['rate_id']);
					$this->db->where('intdate', $i);
					$this->db->delete('deskofrate');
					// 					$data_2 = array ();
					// 					$data_2 [0] ["category_id"] = 0;
					// 					$data_2 [0] ["rate_id"] = 0;
					// 					$data_2 [0] ["intdate"] = 0;
					// 					$data_2 [0] ["minstay"] = 0;
					// 					$data_2 [0] ["maxstay"] = 0;
					// 					$data_2 [0] ["minstayarrival"] = 0;
					// 					$data_2 [0] ["minstaythrought"] = 0;
					// 					$data_2 [0] ["closed"] = 0;
					// 					$data_2 [0] ["closedonarrival"] = 0;
					// 					$data_2 [0] ["closedondeparture"] = 0;
				}
				//$this->Loger_admin->SaveLog_multicol ( $data_1, $data_2, "loger_admin", "deskofrate", "edit" );
			}
			$data_1 = array();
			$data_1[0]["datein"] = $datein;
			$data_1[0]["dateout"] = $dateout;
			$data_1[0]["rate_id"] = $data["rate_id"];
			$data_1[0]["category_id"] = $data["category_id"];
			$data_2 = array();
			$data_2[0]["datein"] = $datein;
			$data_2[0]["dateout"] = $dateout;
			$data_2[0]["rate_id"] = $data["rate_id"];
			$data_2[0]["category_id"] = $data["category_id"];
			$this->Loger_admin->SaveLog_multicol($data_1, $data_2, "loger_admin", "deskofrate", "delete");
			
			/*
			 * UPDATE dc_log
			 *
			 */
			$this->frontdesk->dc_log_update($log_data, 0, 1);
			$this->frontdesk->dc_log_restrict_update($log_data, 0);
		}
		switch($return_type) {
			case "ajax_mode" : $result = array();
			$result["ok"] = 1;
			return $result;
			break;
			default : die("<meta http-equiv='refresh' content='0;url=/reservation_c2/restrict_calendar'>");
			break;
		}
	}

	function get_version() {
		$version = 1;
		$query = $this->db->query("SELECT value FROM hotelix_config WHERE name LIKE 'version'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			$version = $row->value;
		}
		return $version;
	}

	function company_customer_ajax_autocomplete($search) {
		$search = addslashes($search);
		$list = array();
		$sql = "SELECT * FROM  tbl_company_customers WHERE name LIKE '%$search%' LIMIT 0, 20";
		//echo $sql;
		$b = 1;
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			array_push($list, array('id' => $row->id, 'b' => $b, 'name' => $row->name, 'zkpo' => $row->zkpo, 'address' => $row->address, 'accountnumber' => $row->accountnumber, 'bankname' => $row->bankname, 'mfo' => $row->mfo, 'doc_inn' => $row->doc_inn, 'correspondent_account' => $row->correspondent_account));
			$b ++;
		}
		$data = array("list" =>$list);
		echo json_encode($data);
	}

	function get_currency_array() {
		$list = array();
		$sql = "SELECT code, name FROM  global_hotelix.currency WHERE 1";
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$list[$row->code] = $row->name;
		}
		return $list;
	}

	function get_currency_symbol_byid($currency_id) {
		$currency_symbol = "";
		//         $sql = "SELECT `".$this->db->database."`.currency.symbol FROM `global_hotelix`.currency
		//             INNER JOIN `".$this->db->database."`.currency ON `".$this->db->database."`.currency.code = `global_hotelix`.currency.code WHERE `global_hotelix`.currency.id = ".$currency_id;
		$sql = "SELECT `global_hotelix`.currency.symbol FROM `global_hotelix`.currency
           WHERE `global_hotelix`.currency.id = " . $currency_id;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$currency_symbol = $row->symbol;
		}
		return $currency_symbol;
	}

	function get_currency_data_byid($currency_id) {
		$currency_code = "";
		$currency_3char_name = "";
		$sql = "SELECT `global_hotelix`.currency.code, `global_hotelix`.currency.name FROM `global_hotelix`.currency
                WHERE `global_hotelix`.currency.id = " . $currency_id;
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$currency_code = $row->code;
			$currency_3char_name = $row->name;
		}
		return array("currency_code" =>$currency_code,
					 "currency_3char_name" =>$currency_3char_name);
	}
	
	function get_global_languages_str($language_code) {
	    $currency_code = "";
	    $currency_3char_name = "";
	    $sql = "SELECT 2char as str2char, 3char as str3char FROM `global_hotelix_languages`.dic_languages
                WHERE `global_hotelix_languages`.dic_languages.code = " . $language_code;
	    $query = $this->db->query($sql);
	    if($query->num_rows()> 0) {
	        $row = $query->row();
	        $language_2char = $row->str2char;
	        $language_3char = $row->str3char;
	    }
	    return array("language_2char" => $language_2char,
	        "language_3char" => $language_3char);
	}

	function dev_revision($value = 1005) {
		$data = array();
		$data["header"] = $this->htmltpl->getHeader_new();
		$data["dev_revision_value"] = $value;
		$dev_revision = $this->get_dev_revision_value();
		if($dev_revision < $value) {
			$this->mlanguages->getdictionary("home_messages", "", $data);
			$this->parser->parse('templates/home_c2_under_construct_view.html', $data);
			return 1;
		} else {
			return 0;
		}
	}

	function view_property_information_foto_small($id) {
		$query = $this->db->query("SELECT logo_small FROM  property_information WHERE id = " . 
								  $id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$image = base64_decode($row->logo_small);
			header("Content-type: image/*");
			echo $image;
		}
	}

	function view_property_information_foto_medium($id) {
		$query = $this->db->query("SELECT logo_original FROM  property_information WHERE id = " . 
								  $id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$image = base64_decode($row->logo_original);
			header("Content-type: image/*");
			echo $image;
		}
	}

	function view_property_foto_medium($id, $id_position) {
		$external_property_image = $this->images_core->get_external_property_image_value();
		if($external_property_image) {
			$imgdata = array();
			$imgdata["hms_id"] = $this->config->item('hotel_id');
			$imgdata["property_id"] = $id;
			$imgdata["id_position"] = $id_position;
			$imgdata["size"] = 2;
			$image = $this->images_core->get_property_image($imgdata);
			header("Content-type: image/jpeg");
			echo $image;
		} else {
			$query = $this->db->query("SELECT img_medium FROM property_images WHERE property_id = " . 
									  $id . 
									  " AND id_position = " . 
									  $id_position);
			if($query->num_rows()> 0) {
				$row = $query->row();
				$image = base64_decode($row->img_medium);
				header("Content-type: image/*");
				echo $image;
			}
		}
	}

	function view_property_foto_small($property_id, $id_position) {
		$external_property_image = $this->images_core->get_external_property_image_value();
		if($external_property_image) {
			$imgdata = array();
			$imgdata["hms_id"] = $this->config->item('hotel_id');
			$imgdata["property_id"] = $property_id;
			$imgdata["id_position"] = $id_position;
			$imgdata["size"] = 1;
			$image = $this->images_core->get_property_image($imgdata);
			header("Content-type: image/jpeg");
			echo $image;
		} else {
			$query = $this->db->query("SELECT img_small FROM property_images WHERE property_id = " . 
									  $property_id . 
									  " AND id_position = " . 
									  $id_position);
			if($query->num_rows()> 0) {
				$row = $query->row();
				$image = base64_decode($row->img_small);
				header("Content-type: image/*");
				echo $image;
			}
		}
	}

	function update_property_fotos($property_id, $file_data) {
		// 		echo "<pre>";
		// 		print_r ( $_POST );
		// 		print_r ( $_FILES );
		// 		print_r ( $file_data );
		// 		die ();
		// $id_position = $data ["id_position"];
		//$id_position = 1;

		foreach($file_data["files"]['name'] as $property_id => $positions) {

			foreach($positions as $id_position => $name) {
				if(!empty($name)) {
					// Проверяем, что при загрузке не произошло ошибок
					if($file_data["files"]['error'][$property_id][$id_position] == 0) {
						// Если файл загружен успешно, то проверяем - графический ли он
						if(substr($file_data["files"]['type'][$property_id][$id_position], 0, 5)== 'image') {
							$file_original = "/tmp/" . rand(1, 10000). $name;
							$fileTo = "/tmp/" . rand(1, 10000). $name;
							$fileTo2 = "/tmp/" . rand(1, 10000). $name;
							// echo $fileTo;
							// die();
							if(move_uploaded_file($file_data["files"]['tmp_name'][$property_id][$id_position], $fileTo)) {
								// move posted file...
								if(copy($fileTo, $file_original)) {
									$image_original = chunk_split(base64_encode(file_get_contents($file_original)));
								} else {
									echo "Error copy";
									die();
								}
								if(copy($fileTo, $fileTo2)) {
									// ResizeImage ( $fileTo2, $fileTo2, 560 );
									$this->frontdesk->ResizeImage($fileTo2, $fileTo2, 800);
								} else {
									echo "Error copy";
									die();
								}
								$this->frontdesk->ResizeImage($fileTo, $fileTo, 175, 1);
							} else {
							}
							$image = chunk_split(base64_encode(file_get_contents($fileTo)));
							$image_2 = chunk_split(base64_encode(file_get_contents($fileTo2)));
							unlink($file_original);
							unlink($fileTo);
							unlink($fileTo2);
							$external_property_image = $this->images_core->get_external_property_image_value();
							// $external_guest_image = 1;
							if($external_property_image) {
								// Формируем запрос на добавление файла в базу данных
								$sql = "DELETE FROM property_images_registry WHERE property_id = " . $property_id . " AND id_position = " . $id_position;
								$query = $this->db->query($sql);
								$sql = 'INSERT INTO property_images_registry (property_id, id_position, is_new  ) VALUES(' . $property_id . ', ' . $id_position . ', 0)';
								$query = $this->db->query($sql);
								$imgdata = array();
								$imgdata["hms_id"] = $this->config->item('hotel_id');
								$imgdata["property_id"] = $property_id;
								$imgdata["id_position"] = $id_position;
								$imgdata["img_small"] = $image;
								$imgdata["img_medium"] = $image_2;
								$imgdata["img_original"] = $image_original;
								$this->images_core->external_store_property_image_save($imgdata);
							} else {
								$query = $this->db->query("SELECT id FROM property_images
							     WHERE property_id = " . 
														  $property_id . 
														  " AND id_position = " . 
														  $id_position);
								if($query->num_rows()> 0) {
									$update_arr = array('img_small' =>$image,
														'img_medium' =>$image_2,
														'time_stamp' => time());
									$where_arr = array('property_id' =>$property_id,
													   'id_position' =>$id_position);
									$this->db->update('property_images', $update_arr, $where_arr);
								} else {
									$query = $this->db->query('INSERT INTO property_images (property_id, img_small,img_medium, id_position, is_new) VALUES(' . 
																																				   $property_id . 
																																				   ', "' . 
																																				   $image . 
																																				   '", "' . 
																																				   $image_2 . 
																																				   '", ' . 
																																				   $id_position . 
																																				   ', 0)');
								}
							}
							// После чего остается только выполнить данный запрос к базе
							// данных
							// mysql_query ( $query );
						}
					}
				}
				// $id_position ++;
			}
		}
	}

	function dalete_property_foto_tags($property_id, $foto_id) {
		$sql = "DELETE FROM property_fototags WHERE property_id = " . $property_id . " AND foto_id = " . $foto_id;
		$this->db->query($sql);
	}

	function save_property_foto_tags($data) {

		foreach($data["tags"] as $tag_id) {
			$sql = "INSERT INTO property_fototags (property_id, foto_id, tag_id)
			VALUES('" . $data["property_id"] . "', '" . $data["foto_id"] . "', '" . $tag_id . "')";
			$this->db->query($sql);
		}
	}

	function save_property_children_settings($data) {
		$query = $this->db->query("INSERT INTO property_config (property_id, name, value) VALUES('" . 
																								 $data["property_id"] . 
																								 "', 'baby_age_start', '" . 
																								 $data["baby_age_start"] . 
																								 "') ON DUPLICATE KEY UPDATE value = '" . 
																								 $data["baby_age_start"] . 
																								 "'");
		$query = $this->db->query("INSERT INTO property_config (property_id, name, value) VALUES('" . 
																								 $data["property_id"] . 
																								 "', 'baby_age_end', '" . 
																								 $data["baby_age_end"] . 
																								 "') ON DUPLICATE KEY UPDATE value = '" . 
																								 $data["baby_age_end"] . 
																								 "'");
		$query = $this->db->query("INSERT INTO property_config (property_id, name, value) VALUES('" . 
																								 $data["property_id"] . 
																								 "', 'child_age_start', '" . 
																								 $data["child_age_start"] . 
																								 "') ON DUPLICATE KEY UPDATE value = '" . 
																								 $data["child_age_start"] . 
																								 "'");
		$query = $this->db->query("INSERT INTO property_config (property_id, name, value) VALUES('" . 
																								 $data["property_id"] . 
																								 "', 'child_age_end', '" . 
																								 $data["child_age_end"] . 
																								 "') ON DUPLICATE KEY UPDATE value = '" . 
																								 $data["child_age_end"] . 
																								 "'");
	}

	function delete_ages_settings_OLD() {
		$this->db->empty_table("age_ranges_acb");
	}

	function delete_acb_ages_settings($range_id) {
		$this->db->delete('age_ranges_acb', array('range_id' => $range_id));
	}

	function save_acb_ages_settings($data) {
		$this->db->insert_batch('age_ranges_acb', $data);
	}

	function delete_ages_settings($range_id) {
		$this->db->delete('age_ranges', array('range_id' => $range_id));
	}

	function save_ages_settings($data) {
		$this->db->insert_batch('age_ranges', $data);
	}

	function delete_range($range_id) {
		$this->db->delete('range_list', array('id' => $range_id));
	}

	function get_property_dwelling() {
		$dwelling_array = array();
		// $dwelling_array[0]["dwelling_id"] = 0;
		// $dwelling_array[0]["dwelling_name"] = "---";
		// $dwelling_array[0]["dwelling_selected"] = "";
		$dwelling_array[1]["dwelling_id"] = 1;
		$dwelling_array[1]["dwelling_name"] = "{-Single-}";
		$dwelling_array[1]["dwelling_selected"] = "";
		$dwelling_array[2]["dwelling_id"] = 2;
		$dwelling_array[2]["dwelling_name"] = "{-Multi-}";
		$dwelling_array[2]["dwelling_selected"] = "";
		return $dwelling_array;
	}

	function skip_dwelling() {
		switch($this->config->item("hotel_id")) {
			case 92 : return 1;
			break;
			case 11460 : return 1;
			break;
			case 6119 : return 1;
			break;
			case 10749 : return 1;
			break;
			default : return 0;
			break;
		}
	}

	function save_property_fee_tax_policies($data) {
		$property_id = $data["id"];

		foreach($data["value"] as $tax_fee_list_id => $value) {
			//$value = $value;
			$value_type = $data["value_type"][$tax_fee_list_id];
			$is_active = 0;
			if(isset($data["is_active"][$tax_fee_list_id])) {
				$is_active = $data["is_active"][$tax_fee_list_id];
			}
			$is_include = 0;
			if(isset($data["is_include"][$tax_fee_list_id])) {
				$is_include = $data["is_include"][$tax_fee_list_id];
			}
			//$is_include = $data["is_include"][$tax_fee_list_id];
			$query = $this->db->query("INSERT INTO tbl_tax_fee_list_value (tbl_tax_fee_list_id, property_id, is_active, value, value_type, is_include)
			VALUES('" . 
				   $tax_fee_list_id . 
				   "', '" . 
				   $property_id . 
				   "', '" . 
				   $is_active . 
				   "', '" . 
				   $value . 
				   "', '" . 
				   $value_type . 
				   "', '" . 
				   $is_include . 
				   "')
			ON DUPLICATE KEY UPDATE is_active = '" . 
				   $is_active . 
				   "', value = '" . 
				   $value . 
				   "', value_type = '" . 
				   $value_type . 
				   "', is_include = '" . 
				   $is_include . 
				   "'");
		}
	}

	function fms_registration_command($data) {
		$query = $this->db->query("INSERT INTO fms_registration_order2guest (guest_id, order_id, skip_registry)
		VALUES('" . 
			   $data["guest_id"] . 
			   "', '" . 
			   $data["reservation_id"] . 
			   "', '" . 
			   $data["skip_registry"] . 
			   "')
		ON DUPLICATE KEY UPDATE skip_registry = '" . 
			   $data["skip_registry"] . 
			   "'");
	}

	function get_datepicker_dateformat_by_systemdateformat() {
		$format = 'yyyy-mm-dd';
		$query = $this->db->get_where('hotelix_config', array('name' => 'date_format'));
		if($query->num_rows()> 0) {
			switch($query->row()->value) {
				case 0 : $format = 'yyyy-mm-dd';
				break;
				case 1 : $format = 'dd.mm.yyyy';
				break;
				case 2 : $format = 'dd-mm-yyyy';
				break;
			}
		}
		return $format;
	}

	function db_insert_on_duplicate_key_update($tbl_name, $data, $keys) {
		$sql_str = $this->db->insert_string($tbl_name, $data);
		$sql_str .= " ON DUPLICATE KEY ";

		foreach($keys as $key) {
			unset($data[$key]);
		}
		$sql_str .= $this->db->update_string($tbl_name, $data, "1");
		$sql_str = str_replace(" $tbl_name SET", "", $sql_str);
		$sql_str = str_replace(" WHERE 1", "", $sql_str);
		$this->db->query($sql_str);
	}

	function get_reservation_rate($reservation_id) {
		$rate_id = 0;
		$query = $this->db->query("SELECT price_type FROM deskofreservation WHERE id = " . 
								  $reservation_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$rate_id = $row->price_type;
		}
		return $rate_id;
	}

	function get_stripe_acquiring_available_in_country($id_country_3c) {
		//return 1 - ok,Accept payments; 0 - NOT Accept payments
		$is_allowed = 0;
        $allowed_countries_arr = array(
            'AUS',
            'AUT',
            'BEL',
            'BRA',
            'BGR',
            'CAN',
            'HRV',
            'CYP',
            'CZE',
            'DNK',
            'EST',
            'FIN',
            'FRA',
            'DEU',
            'GHA',
            'GIB',
            'GRC',
            'HKG',
            'HUN',
            'IND',
            'IDN',
            'IRL',
            'ITA',
            'JPN',
            'KEN',
            'LVA',
            'LIE',
            'LTU',
            'LUX',
            'MYS',
            'MLT',
            'MEX',
            'NLD',
            'NZL',
            'NGA',
            'NOR',
            'POL',
            'PRT',
            'ROU',
            'SGP',
            'SVK',
            'SVN',
            'ZAF',
            'ESP',
            'SWE',
            'CHE',
            'THA',
            'ARE',
            'GBR',
            'USA'
        );
		if(in_array($id_country_3c, $allowed_countries_arr)) {
			$is_allowed = 1;
		}
		return $is_allowed;
	}

	function liqpay_kays_save($data) {
		if(isset($data["ligpay_publickey"])) {
			$query = $this->db->query("INSERT INTO gatewayoforder_personal (name, str_text) VALUES('publickey', '" . 
																								   $data["ligpay_publickey"] . 
																								   "')
	       ON DUPLICATE KEY UPDATE str_text = '" . 
																								   $data["ligpay_publickey"] . 
																								   "'");
		}
		if(isset($data["liqpay_privat_key"])) {
			$query = $this->db->query("INSERT INTO gatewayoforder_personal (name, str_text) VALUES('liqpay_privat_key', '" . 
																								   $data["liqpay_privat_key"] . 
																								   "')
	       ON DUPLICATE KEY UPDATE str_text = '" . 
																								   $data["liqpay_privat_key"] . 
																								   "'");
		}
	}

	function config_save($data) {
		$this->frontdesk->MonopolyMode();
		$data_1 = $this->Loger_admin->get_values_col("hotelix_config");
		//$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('use_actual_point', '".$data["use_actual_point"]."') ON DUPLICATE KEY UPDATE value = " .$data["use_actual_point"]);
		//$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('closedayTime', '".$data["closeday_time"]."') ON DUPLICATE KEY UPDATE value = " .$data["closeday_time"]);
		$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('tourtax', '" . 
																				   $data["tourtax"] . 
																				   "') ON DUPLICATE KEY UPDATE value = " . 
																				   $data["tourtax"]);
		$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('overbooking_category_id', '" . 
																				   $data["overbooking_category_id"] . 
																				   "') ON DUPLICATE KEY UPDATE value = '" . 
																				   $data["overbooking_category_id"] . 
																				   "'");
		//$query = $this->db->query("INSERT INTO hotelix_config (name, str_value) VALUES('hotel_email', '".addslashes($data["hotel_email"])."') ON DUPLICATE KEY UPDATE str_value = '" .addslashes($data["hotel_email"])."'");
		//$query = $this->db->query("INSERT INTO hotelix_config (name, str_value) VALUES('online_booking_url', '".addslashes($data["online_booking_url"])."') ON DUPLICATE KEY UPDATE str_value = '" .addslashes($data["online_booking_url"])."'");
		$query = $this->db->query("INSERT INTO hotelix_config (name, value) VALUES('date_format', '" . 
																				   $data["date_format"] . 
																				   "') ON DUPLICATE KEY UPDATE value = " . 
																				   $data["date_format"]);
		$data_2 = $this->Loger_admin->get_values_col("hotelix_config");
		$this->Loger_admin->SaveLog_col($data_1, $data_2, "loger_admin", "hotelix_config", "edit");
	}
	//check property checkin_time and checkout_time
	function get_property_check_in_out_time($property_id = 0, $field_name = "") {
		$return_data = array();
		if($field_name != "") {
			$this->db->select($field_name);
		} else {
			$this->db->select('check_in_time, check_out_time');
		}
		$query = $this->db->get_where('property_information', array('id' => $property_id));
		if($query->num_rows()> 0) {
			$row = $query->row_array();
			return $row;
		} else {
			$return_array = array();
			$return_array['check_in_time'] = $this->hotelix_config->get_record("checkintime");
			$return_array['check_out_time'] = $this->hotelix_config->get_record("checkouttime");
			return $return_array;
		}
	}

	function get_property_id($room_id = 0, $category_id = 0) {
		$porperty_id = 0;
		$sql = "";
		if($room_id > 0) {
			$sql = "SELECT categories.property_id FROM rooms
		  INNER JOIN categories ON categories.id = rooms.category_id
		  WHERE rooms.id = " . $room_id;
		} else {
			if($category_id > 0) {
				$sql = "SELECT property_id FROM categories
		          WHERE id = " . $category_id;
			}
		}
		if($sql != "") {
			$query = $this->db->query($sql);
			if($query->num_rows()> 0) {
				$row = $query->row();
				$porperty_id = $row->property_id;
			}
		}
		return $porperty_id;
	}
	
	/*
	 *  get gender for guest
	 *
	 */
	function get_gender_array() {
		$gender_array = array();
		$gender_array[0]["gender_value"] = 0;
		$gender_array[0]["gender_name"] = "---";
		$gender_array[0]["gender_selected"] = "";
		$gender_array[1]["gender_value"] = 1;
		$gender_array[1]["gender_name"] = "{mlw_male}";
		$gender_array[1]["gender_selected"] = "";
		$gender_array[2]["gender_value"] = 2;
		$gender_array[2]["gender_name"] = "{mlw_female}";
		$gender_array[2]["gender_selected"] = "";
		return $gender_array;
	}

	function get_age_array() {
		$age_array = array();
		$gender_array[0]["age_value_min"] = 4;
		$gender_array[0]["age_value_max"] = 16;
		$gender_array[0]["age_value_min_str"] = "4";
		$gender_array[0]["age_value_max_str"] = "16";
		$gender_array[0]["age_value"] = 1;
		$gender_array[1]["age_value_min"] = 17;
		$gender_array[1]["age_value_max"] = 26;
		$gender_array[1]["age_value_min_str"] = "17";
		$gender_array[1]["age_value_max_str"] = "26";
		$gender_array[1]["age_value"] = 2;
		$gender_array[2]["age_value_min"] = 27;
		$gender_array[2]["age_value_max"] = 45;
		$gender_array[2]["age_value_min_str"] = "27";
		$gender_array[2]["age_value_max_str"] = "45";
		$gender_array[2]["age_value"] = 3;
		$gender_array[3]["age_value_min"] = 46;
		$gender_array[3]["age_value_max"] = 100;
		$gender_array[3]["age_value_min_str"] = "26";
		$gender_array[3]["age_value_max_str"] = "100";
		$gender_array[3]["age_value"] = 4;
		return $gender_array;
	}

	function get_property_data() {
		$return_array = array();
		$total = 0;
		$apart_count = 0;
		$hotel_count = 0;
		$sql = "SELECT COUNT(1) as total, SUM(if(dwelling = 1, 1, 0)) as apart_count, SUM(if(dwelling = 2, 1, 0)) as hotel_count
        		FROM property_information";
		$query = $this->db->query($sql);
		$row = $query->row();
		$return_array["total"] = $row->total;
		$return_array["apart_count"] = $row->apart_count;
		$return_array["hotel_count"] = $row->hotel_count;
		return $return_array;
	}

	function stripe_basic_data_get_record($name, $valuename = "str") {
		$query = $this->db->query("SELECT * FROM `stripe_info` WHERE name LIKE '" . 
								  $name . 
								  "'");
		$result = null;
		if($valuename == "int") {
			$result = 0;
			if($query->num_rows()> 0) {
				$row = $query->row();
				$result = $row->value;
			}
		} elseif($valuename == "str") {
			$result = "";
			if($query->num_rows()> 0) {
				$row = $query->row();
				$result = $row->str_value;
			}
		}
		return $result;
	}

	function stripe_save_basic_data($data) {

		foreach($data as $key => $value) {
			switch($key) {
				case "firstname" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "lastname" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "email" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "phone" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				// 	            case "user_language":
				// 	                $sql = "INSERT INTO  stripe_info (name, value) VALUES('" . $key . "', '" . $value . "') ON DUPLICATE KEY UPDATE value = '" . $value . "'";
				// 	                $query = $this->db->query($sql);
				// 	                break;
				case "street" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "additional_information" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "city" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "state" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "post_code" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
				case "country" : $sql = "INSERT INTO  stripe_info (name, str_value) VALUES('" . $key . "', '" . addslashes($value). "') ON DUPLICATE KEY UPDATE str_value = '" . addslashes($value). "'";
				$query = $this->db->query($sql);
				break;
			}
		}
	}

	function get_category_active_rooms_count($without_over_cat_id = 0) {
		$return_data = array();
		$select_over_cat = "";
		if($without_over_cat_id == 1) {
			$overbooking_category_id = $this->frontdesk->get_overbooking_category();
			$select_over_cat = " AND categories.id <> " . $overbooking_category_id;
		}
		$sql = "SELECT categories.id AS cat_id, COUNT( rooms.id ) AS count_rooms
FROM rooms
INNER JOIN categories ON categories.id = rooms.category_id
WHERE rooms.is_active =1
AND categories.is_active =1
AND categories.web_booking =1
" . $select_over_cat . "
GROUP BY categories.id";
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$return_data[$row->cat_id] = $row->count_rooms;
		}
		return $return_data;
	}

	function get_active_category_and_active_rooms() {
		$return_data = array();
		$sql = "SELECT categories.id AS cat_id, rooms.id AS room_id
                FROM rooms
                INNER JOIN categories ON categories.id = rooms.category_id
                WHERE rooms.is_active = 1 AND categories.is_active = 1";
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$return_data[$row->cat_id]['rooms'][$row->room_id] = $row->room_id;
		}
		return $return_data;
	}

	function get_hms_id_by_dbname($db_name) {
		$hms_hotel_id = "";
		$sql = "SELECT id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
		$query = $this->db->query($sql);
		if($query->num_rows()!= 0) {
			$row = $query->row();
			$hms_hotel_id = $row->id;
		}
		return $hms_hotel_id;
	}
	//================== GET AVAILABILITIES FROM DESOKOFDAYS_AVAILABILITY TABLE ==========
	function get_deskofdays_availibility($datein, $dateout, $category_id = 0, $web_booking = 0) {
		list($year, $month, $day)= explode("-", $datein);
		$date_in_unix = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $dateout);
		$date_out_unix = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		$category_id_str = "";
		if($category_id > 0) {
			$category_id_str = " AND categories.id = " . $category_id;
		}
		$select = "";
		if($web_booking == 1) {
			$select .= " categories.web_booking = 1 AND ";
		}
		$return_data = array();
		$sql = "SELECT deskofdays_availability.* FROM deskofdays_availability
        INNER JOIN categories ON deskofdays_availability.category_id = categories.id
        WHERE categories.is_active = 1 AND $select deskofdays_availability.intdate >= " . $date_in_unix . " " . $category_id_str . " AND deskofdays_availability.intdate <= " . $date_out_unix;
		// 	    echo $sql;
		//         die();
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$return_data[$row->category_id][$row->intdate] = (int) $row->count;
		}
		return $return_data;
	}

	function get_online_rates() {
		// get online rates
		$online_rates = array();
		$sql = "SELECT rateid FROM onlinerates WHERE 1";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$online_rates[$row->rateid]["rateid"] = $row->rateid;
			}
		}
		return $online_rates;
	}
	// ф-я отримення трьох різних комбінацій дат, на які є вільні номера
	// використовується тоді, якщо поточні дати, які користувач вибрав - зайняті.
	function get_personal_module_nofreerooms_combinations($datein, $dateout, $debug = 0) {
		// змінна максимальної кількості зсуву днів в минуле і майбутнє
		$nofree_rooms_days_shift = 5;
		$now_date = date("Y-m-d");
		list($year_now, $month_now, $day_now)= explode("-", $now_date);
		$now_intdatein = round(gmmktime(0, 0, 0, $month_now, $day_now, $year_now)/ 86400);
		list($year, $month, $day)= explode("-", $datein);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $dateout);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		// $intdateout_new = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );
		// $freerooms_dateout = gmdate("Y-m-d", $intdateout_new * 86400);
		// ====== $intdatein_shift and $intdateout_shift - dates with shift
		$intdatein_shift = $intdatein - $nofree_rooms_days_shift;
		// щоб дата не заходила в минуле
		if($intdatein_shift < $now_intdatein) {
			$intdatein_shift = $now_intdatein;
		}
		$intdateout_shift = $intdateout + $nofree_rooms_days_shift;
		$datein_shift = gmdate("Y-m-d", $intdatein_shift * 86400);
		$dateout_shift = gmdate("Y-m-d", $intdateout_shift * 86400);
		// $freerooms_dateout = gmdate("Y-m-d", $intdateout_shift * 86400);
		$duration = $intdateout - $intdatein;
		// ======= get deskofdays availability array ======
		// web_booking - тільки активні для онлайн бронювання номери
		$web_booking = 1;
		$deskofdays_availibility = $this->get_deskofdays_availibility($datein_shift, $dateout_shift, 0, $web_booking);
		$onlinebook_array = array();
		$sql = "SELECT category_id, rate_id FROM ratetocategory WHERE onlinebook = 1";
		$query = $this->db->query($sql);

		foreach($query->result()as $row) {
			$onlinebook_array[$row->category_id][$row->rate_id] = 1;
		}
		$online_rates = $this->get_online_rates();
		$online_rates_count = count($online_rates);
		// добавляєм масив онлайн рейтів в $deskofdays_availibility

		foreach($deskofdays_availibility as $category_id => $intdate_data) {
			unset($deskofdays_availibility[$category_id]);
			if($online_rates_count > 0) {

				foreach($online_rates as $rate_id => $rate_data) {
					if(isset($onlinebook_array[$category_id][$rate_id])) {
						$deskofdays_availibility[$category_id][$rate_id] = $intdate_data;
					}
				}
			}
		}
		// === формуємо масив обмежень ===
		$deskofrate_array = $this->frontdesk_c2->get_online_module_restricts($datein_shift, $dateout_shift);
		// обнуляємо дні, які закриті для зв'язки категорія - рейт

		foreach($deskofdays_availibility as $categoty_id => $rate_data) {

			foreach($rate_data as $rate_id => $date_data) {

				foreach($date_data as $intdate => $availability) {
					// перевірка чи день не закритий
					if(isset($deskofrate_array[$categoty_id][$rate_id][$intdate]["closed"])) {
						if($deskofrate_array[$categoty_id][$rate_id][$intdate]["closed"] == 1) {
							$deskofdays_availibility[$categoty_id][$rate_id][$intdate] = 0;
						}
					}
				}
			}
		}
		//echo "<pre>".$duration;
		//print_r($deskofrate_array);
		//print_r($deskofdays_availibility);
		// die();
		// =====================================================================================
		if($debug == 1) {
			echo "<pre>duration = $duration<br>$intdatein - $intdateout<br>$datein - $dateout<br>";
			print_r($deskofdays_availibility);
			// die();
		}
		// calculate max duration shift
		$min_cut_value = round(($duration / 100)* 33);
		if($min_cut_value > 0) {
			$min_duration = $duration - $min_cut_value;
		} else {
			$min_duration = $duration;
		}
		$category_can_insert = array();
		$avail_cat_array = array();
		// змінна, яка відповідає за к-сть днів бронювання, і яку ми зменшуємо на 1 при кожній ітерації, поки вона не буде рівна $min_duration
		$duration_temp = $duration;
		if($debug == 1) {
			echo $duration_temp . " ||| " . $min_duration . "<br>";
		}
		// змінна підрахунку к-сті комбінацій, в даному випадку 3 комбінації ми виводимо
		$get_3_combo = 0;
		// змінна, яка сигналізує, що 3 комбінації вже набрано
		$get_3_combo_done = 0;
		//$k = 0;
		do {

			foreach($deskofdays_availibility as $cat_id => $rate_data) {

				foreach($rate_data as $rate_id => $intdate_data) {
					if(!isset($category_can_insert["duration=" . $duration_temp + 1][$cat_id])) {
						// змінна підрахунку к-сті вільних днів на відрізку
						$duration_counter = 0;
						$avail_intdatein = "";
						$avail_intdateout = "";
						// логіка 1

						foreach($intdate_data as $intdate => $count) {
							if($count > 0) {
								// фіксація початкової дати вільного відрізку
								if($duration_counter == 0) {
									$avail_intdatein = $intdate;
								}
								$duration_counter ++;
							} else {
								// якщо на поточну дату немає вільних номерів - скидуємо лічильник $duration_counter в 0
								$duration_counter = 0;
								$avail_intdatein = $intdate;
							}
							if($duration_counter == $duration_temp) {
								// фіксація кінцевої дати вільного відрізку
								$avail_intdateout = $intdate;
								$current_duration =($avail_intdateout + 1)- $avail_intdatein;
								//echo $current_duration ." = ".$avail_intdateout." - ".$avail_intdatein."<br>";
								// ================ СТАРТ перевірка на обмеження відрізку ===================
								$restrict_continue_value = 0;
								if(isset($deskofrate_array[$cat_id][$rate_id])) {

									foreach($deskofrate_array[$cat_id][$rate_id] as $intdate => $cell) {
										if($intdate <($avail_intdateout + 1)) {
											if($current_duration > $cell["maxstay"] && $cell["maxstay"] > 0) {
												$restrict_continue_value = 1;
												break;
											}
											if($current_duration < $cell["minstaythrought"] && $cell["minstaythrought"] > 0) {
												$restrict_continue_value = 1;
												break;
											}
											if(($intdate == $avail_intdatein)&&($cell["closedonarrival"] == 1)) {
												$restrict_continue_value = 1;
												break;
											}
										} else {
											if(($intdate ==($avail_intdateout + 1))&&($cell["closedondeparture"] == 1)) {
												$restrict_continue_value = 1;
												break;
											}
										}
									}
								}
								//echo "restrict_continue_value:".$restrict_continue_value."<br>";
								if($restrict_continue_value == 1) {
									// скидуємо лічильник $duration_counter в 0, для нового відрізку
									$duration_counter = 0;
									continue;
								}
								if(isset($category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout])) {
									// перевірка на дублювання записів
									//if ($category_can_insert["duration=" . $duration_temp][$avail_intdatein."-".$cat_id]["cat_id"] == $cat_id) {
									$duration_counter = 0;
									continue;
									//}
								}
								//  ================ КІНЕЦЬ перевірка на обмеження відрізку ====================
								$avail_datein = gmdate("Y-m-d", $avail_intdatein * 86400);
								$avail_dateout = gmdate("Y-m-d",($avail_intdateout + 1)* 86400);
								// $category_can_insert["duration=" . $duration_temp][$cat_id][$k]["avail_intdatein"] = $avail_intdatein;
								// $category_can_insert["duration=" . $duration_temp][$cat_id][$k]["avail_intdateout"] = $avail_intdateout;
								// $category_can_insert["duration=" . $duration_temp][$cat_id][$k]["avail_datein"] = $avail_datein;
								// $category_can_insert["duration=" . $duration_temp][$cat_id][$k]["avail_dateout"] = $avail_dateout;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["avail_intdatein"] = $avail_intdatein;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["avail_intdateout"] = $avail_intdateout;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["avail_datein"] = $avail_datein;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["avail_dateout"] = $avail_dateout;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["amount"] = 0;
								$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["cat_id"] = $cat_id;
								if(isset($category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout])) {
									// echo $avail_intdatein . " ||| " . $avail_intdateout . " --- " . $cat_id . " --- " . $default_rate_id . "<br>";
									$prices_arr = $this->get_prices($avail_intdatein, $avail_intdateout, $cat_id, $rate_id);
									$yield_prices_arr = $this->get_yield_prices($avail_intdatein, $avail_intdateout, $cat_id, $rate_id);
									// echo "<pre>";
									//echo "rate_price<br>";
									//print_r($prices_arr);
									//echo "yield_price<br>";
									//print_r($yield_prices_arr);
									// die();
									$price = 0;
									for($i = $avail_intdatein;
									$i <= $avail_intdateout;
									$i ++ ) {
										if(isset($yield_prices_arr[$cat_id][$rate_id][$i])) {
											$price += $yield_prices_arr[$cat_id][$rate_id][$i]["singleuseprice"];
										} else {
											if(isset($prices_arr[$cat_id][$rate_id][$i])) {
												$price += $prices_arr[$cat_id][$rate_id][$i]["singleuseprice"];
											}
										}
									}
									$category_can_insert["duration=" . $duration_temp][$avail_intdatein . "-" . $avail_intdateout]["amount"] = $price;
								}
								// $k ++;
								// ==================================
								// скидуємо лічильник $duration_counter в 0, для нового відрізку
								$duration_counter = 0;
								$get_3_combo ++;
								//echo "<br>".$get_3_combo."<br>";
								//echo "<br>avail_intdatein: ".$avail_intdatein."||".$current_duration."==".$cat_id."--".$rate_id."<br>";
								//print_r($category_can_insert);
								// === якщо вже знайшло 3 комбінації для вставки тоді виходимо з цикла
								if($get_3_combo == 3) {
									$get_3_combo_done = 1;
									break;
								}
							}
						}
					}
					if($get_3_combo_done == 1) {
						break;
					}
				}
				if($get_3_combo_done == 1) {
					break;
				}
			}
			if($get_3_combo_done == 1) {
				break;
			}
			$duration_temp -= 1;
		}

		while($duration_temp >= $min_duration)
			;
		//print_r($deskofdays_availibility);
		//print_r($category_can_insert);
		//die();
		if($debug == 1) {
			print_r($category_can_insert);
			die();
		}
		return $category_can_insert;
	}

	function get_report_times() {
		$report_times_array = array();
		$report_times_array[0]["option_name"] = "0 - 3";
		$report_times_array[0]["option_value"] = 3;
		$report_times_array[0]["option_selected"] = "";
		$report_times_array[1]["option_name"] = "3 - 6";
		$report_times_array[1]["option_value"] = 6;
		$report_times_array[1]["option_selected"] = "";
		$report_times_array[2]["option_name"] = "6 - 9";
		$report_times_array[2]["option_value"] = 9;
		$report_times_array[2]["option_selected"] = "";
		$report_times_array[3]["option_name"] = "9 - 12";
		$report_times_array[3]["option_value"] = 12;
		$report_times_array[3]["option_selected"] = "";
		$report_times_array[4]["option_name"] = "12 - 15";
		$report_times_array[4]["option_value"] = 15;
		$report_times_array[4]["option_selected"] = "";
		$report_times_array[5]["option_name"] = "15 - 18";
		$report_times_array[5]["option_value"] = 18;
		$report_times_array[5]["option_selected"] = "";
		$report_times_array[6]["option_name"] = "18 - 21";
		$report_times_array[6]["option_value"] = 21;
		$report_times_array[6]["option_selected"] = "";
		$report_times_array[7]["option_name"] = "21 - 24";
		$report_times_array[7]["option_value"] = 24;
		$report_times_array[7]["option_selected"] = "";
		return $report_times_array;
	}

	function get_deskofdays_price_by_reservation_id($reservation_id) {
		$full_deskoddays_price = 0;
		$query = $this->db->query("SELECT SUM(price) as full_price FROM deskofdays WHERE reservation_id = " . 
											  $reservation_id);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$full_deskoddays_price = $row->full_price;
		}
		return $full_deskoddays_price;
	}
	// type_id = 1 - loger table
	// type_id = 2 - loger_admin table
	// type_id = 3 - loger_admin_setup table
	// show_log_type_id = 1 - якщо дивились лог
	function set_admin_log_stat($type_id, $show_log_type_id) {
		$hms_id = $this->config->item('hotel_id');
		$user_id = $_SESSION["user"]["id"];
		$date_time = date("Y-m-d H:i:s");
		$sql = "INSERT INTO global_hotelix_analitycs.admin_log_stat(hms_id, user_id, type_id, show_log_type_id, datetime)
        VALUES('" . $hms_id . "', '" . $user_id . "', '" . $type_id . "', '" . $show_log_type_id . "', '" . $date_time . "')";
		$query = $this->db->query($sql);
	}

	function toggle_hotelstate_mono_active($toggle_to_mono = true) {
		if($toggle_to_mono) {
			$hotelstate = 11;
			// MONOSTATE ID
		} else {
			$hotelstate = 4;
			//ACTIVESTATE ID
		}
		$hotel_id = $this->config->item("hotel_id");
		$update_arr = array('hotelstateid' =>$hotelstate);
		$this->db->update('visitka.config', $update_arr, array('id' => $hotel_id));
	}

	function get_whole_age_range_start_and_end() {
		return array('start' => 0,
					 'end' => 999);
	}
	// function to validate email
	function email_validation($email) {
		return(!preg_match("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$^", $email))? FALSE : TRUE;
	}

	function email_validation_2($email) {
		// Remove all illegal characters from email
		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		// Validate email
		if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	function get_ranges() {
		$r_list = array();
		$sql = "SELECT id, name, is_extended FROM range_list ORDER BY id ASC";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$r_list[$row->id]["id"] = $row->id;
				$r_list[$row->id]["name"] = $row->name;
				$r_list[$row->id]["is_extended"] = $row->is_extended;
				$r_list[$row->id]["selected"] = "";
			}
		}
		return $r_list;
	}

	function get_local_active_localization_languages() {
		$array_languages = array();
		$sql = "SELECT global_hotelix_languages.localization.code FROM descriptionlanguages
        INNER JOIN global_hotelix_languages.localization ON global_hotelix_languages.localization.code_int = descriptionlanguages.code
        WHERE descriptionlanguages.is_active = 1";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {

			foreach($query->result()as $row) {
				$array_languages[$row->code] = 1;
			}
		}
		return $array_languages;
	}

	function insert_order_pending_log($data) {
		$this->db->insert('global_hotelix.order_pending_log', $data);
	}

	function set_order_pending_log_status($data) {
		$sql_data = array("status" =>$data["status"]);
		$this->db->where('hotel_id', $data["hotel_id"]);
		$this->db->where('reservation_id', $data["reservation_id"]);
		$this->db->update('global_hotelix.order_pending_log', $sql_data);
	}

	function set_hms_billing_mono() {
		$mono_value = 1;
		$this->hotelix_config->set_record("hms_billing_mono", $mono_value, "int");
		$days_diff = 90;
		$datein = date("Y-m-d");
		$dateout = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+ $days_diff, date("Y")));
		list($year, $month, $day)= explode("-", $datein);
		$intdatein = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		list($year, $month, $day)= explode("-", $dateout);
		$intdateout = round(gmmktime(0, 0, 0, $month, $day, $year)/ 86400);
		// save deskofdays_availability
		$save_availability = 1;
		$save_availability = $this->config->item("deskofdays_availability_save");
		if($save_availability == 1) {
			$sql = "SELECT id FROM categories WHERE is_active = 1";
			$query = $this->db->query($sql);
			if($query->num_rows()> 0) {

				foreach($query->result()as $row) {
					$this->frontdesk->save_availability($datein, $dateout, $row->id);
				}
			}
		}
		$dc_services = $this->dc_model->get_active_dc_channels();
		$this->dc_model->upload_rooms_fon($dc_services, $intdatein, $intdateout);
		//  ======== CLOSE MONO DAYS START
		//         $stripe_period_start = $this->hotelix_config->get_record("stripe_sub_current_period_start", "int");
		//         $stripe_period_end = $this->hotelix_config->get_record("stripe_sub_current_period_end", "int");
		//         $startdate = date("Y-m-d", $stripe_period_start);
		//         $enddate = date("Y-m-d", $stripe_period_end);
		//         $categories_data = $this->get_active_category_and_active_rooms();
		//         foreach($categories_data as $category_id => $rooms){
		//             foreach($rooms['rooms'] as $room_id){
		//                 $data = array();
		//                 $data["datein"] = $startdate;
		//                 $data["dateout"] = $enddate;
		//                 $data["room_id"] = $room_id;
		//                 $this->deskofdays_close_insert($data);
		//                 $dc_log_data = array ();
		//                 $dc_log_data ["datein"] = $startdate;
		//                 $dc_log_data ["dateout"] = $enddate;
		//                 $dc_log_data ["category_id"] = $category_id;
		//                 $this->frontdesk->dc_log_update ( $dc_log_data, 0, 0, 0, 0 );
		//             }
		//         }
		//  ======== CLOSE MONO DAYS END
	}

	function unset_hms_billing_mono() {
		$mono_value = 0;
		$this->hotelix_config->set_record("hms_billing_mono", $mono_value, "int");
		//  ======== OPEN MONO DAYS START
		//         $stripe_period_start = $this->hotelix_config->get_record("stripe_sub_current_period_start", "int");
		//         $stripe_period_end = $this->hotelix_config->get_record("stripe_sub_current_period_end", "int");
		//         $startdate = date("Y-m-d", $stripe_period_start);
		//         $enddate = date("Y-m-d", $stripe_period_end);
		//         $categories_data = $this->get_active_category_and_active_rooms();
		//         foreach($categories_data as $category_id => $rooms){
		//             foreach($rooms['rooms'] as $room_id){
		//                 $data = array();
		//                 $data["datein"] = $startdate;
		//                 $data["dateout"] = $enddate;
		//                 $data["room_id"] = $room_id;
		//                 $this->deskofdays_open_insert($data);
		//                 $dc_log_data = array ();
		//                 $dc_log_data ["datein"] = $startdate;
		//                 $dc_log_data ["dateout"] = $enddate;
		//                 $dc_log_data ["category_id"] = $category_id;
		//                 $this->frontdesk->dc_log_update ( $dc_log_data, 0, 0, 0, 0 );
		//             }
		//         }
		//  ======== OPEN MONO DAYS END
	}

	function save_hms_billing_mono_value($hms_billing_mono) {
		$this->hotelix_config->set_record("hms_billing_mono", $hms_billing_mono, "int");
	}

	function save_user_desktop_data_value($user_desktop_data) {
		$this->hotelix_config->set_record("user_desktop_data", $user_desktop_data, "int");
	}

	function get_guests($reservation_id, $without_guest_id = 0) {
		$guestsList = array();
		$select_guest = "";
		if($without_guest_id > 0) {
			$select_guest .= " AND guests.id <> $without_guest_id";
		}
		$sql = "SELECT guests.gender, guests.email, guests.dob, guests.firstname, guests.lastname, guests.middlename,
        guests.id as guest_id_list, reservation_details.*, guests.nationality, guests.citizenship_code
        FROM guests_deskofreservation
        INNER JOIN guests ON guests_deskofreservation.guest_id = guests.id
        INNER JOIN deskofreservation ON deskofreservation.id = guests_deskofreservation.reservation_id
        LEFT JOIN reservation_details ON (reservation_details.guest_id = guests.id AND reservation_details.reservation_id = deskofreservation.id)
        WHERE deskofreservation.id = $reservation_id " . $select_guest;
		// echo $sql;
		$query2 = $this->db->query($sql);

		foreach($query2->result()as $row2) {
			switch($row2->gender) {
				case 1 : $gender = "{mlw_men}";
				break;
				case 2 : $gender = "{mlw_women}";
				break;
				default : $gender = " ";
				break;
			}
			array_push($guestsList, array('guest_id_list' => $row2->guest_id_list, 'firstname_list' => $row2->firstname, 'lastname_list' => $row2->lastname, 'middlename_list' => $row2->middlename, 'email_list' => $row2->email, 'dob_list' => $row2->dob, 'gender_list' => $gender, 'citizenship_code_list' => $row2->citizenship_code));
		}
		return $guestsList;
	}

	function check_representative($dob, $datein) {
		$representative_age = $this->config->item('representative_age');
		if($dob != '0000-00-00') {
			list($date_year, $date_month, $date_day)= explode("-", $dob);
			$dob_intdatein = round(gmmktime(0, 0, 0, $date_month, $date_day, $date_year)/ 86400);
			list($date_year, $date_month, $date_day)= explode("-", $datein);
			$datein_intdatein = round(gmmktime(0, 0, 0, $date_month, $date_day, $date_year)/ 86400);
			$dif = floor(($datein_intdatein - $dob_intdatein)/ 365);
			if($dif < $representative_age) {
				return 1;
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}

	function get_booking_is_no_show_reservation($reservation_id) {
		return $this->db->get_where("dc_booking_is_no_show", array('hms_reseervation_id' => $reservation_id))->num_rows();
	}

	function get_avoidtime_data() {
		$return_data = array();
		$avoidtime_mass = array("{mlw_notuse}",
								"1 {mlw_min}",
								"3 {mlw_min}",
								"15 {mlw_min}",
								"30 {mlw_min}",
								"1 {mlw_hour}",
								"3 {mlw_hour2}",
								"24 {mlw_hour2}",
								"3 {mlw_day}",
								"7 {mlw_day2}",
								"14 {mlw_day2}");
		$avoidtime_mass_seconds = array(0,
										60,
										180,
										900,
										1800,
										3600,
										10800,
										86400,
										259200,
										604800,
										1209600);

		foreach($avoidtime_mass as $key => $name) {
			array_push($return_data, array('avoid_name' => $name, 'avoid_val' => $avoidtime_mass_seconds[$key], 'selected' => ''));
		}
		return $return_data;
	}

	function insert_deskofreservation_needpay($data) {
		$this->db->insert('deskofreservation_needpay', $data);
	}

	function insert_hms_order4pay_semafor($data) {
		$sql = "SELECT hotelid FROM global_hotelix.hms_order4pay_semafor WHERE hotelid = " . $data['hotelid'];
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$this->db->where('hotelid', $data['hotelid']);
			$this->db->update('global_hotelix.hms_order4pay_semafor', $data);
		} else {
			$this->db->insert('global_hotelix.hms_order4pay_semafor', $data);
		}
	}

	function needpay($data) {
		
		/* Блок вставки в таблицю deskofreservation_needpay (таблиця контролю статуса і оплати з модуля)
		 * поля таблиці deskofreservation_needpay:
		 * - status - відповідає за дію над бронюванням, якщо це бронювання не було вчасно оплачене.
		 *            0 - початкове значення ( ставиться при створенні бронювання )
		 *            1 - без відміни і трансферу бронювання
		 *           -1 - відміна бронювання
		 *            2 - трансфер бронювання
		 * - is_pay - вказує чи бронювання було оплачене (0/1)
		 * - duetime - час до якого повинно бути оплачене бронювання
		 */
		$query = $this->db->query("select ccforce from deskofreservation inner join rate
            on deskofreservation.price_type = rate.id where deskofreservation.id=" . 
								  $data['reservation_id']);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$ccforce = $row->ccforce;
		}
		if($ccforce == 1) {
			$avoidtime = 0;
			$query = $this->db->query("SELECT value FROM gatewayoforder_personal WHERE name LIKE 'avoidtime'");
			if($query->num_rows()> 0) {
				$row = $query->row();
				$avoidtime = $row->value;
			}
			$duetime_int = date("U")+ $avoidtime;
			$this->db->update('deskofreservation', array('avoidtime' => $avoidtime, 'duetime' => $duetime_int), array('id' => $data['reservation_id']));
			$duetime = date("Y-m-d H:i:s", mktime(date("H"), date("i"), date("s")+ $avoidtime, date("m"), date("d"), date("Y")));
			$needpay_array = array();
			$needpay_array['reservation_id'] = $data['reservation_id'];
			$needpay_array['duetime'] = $duetime;
			$this->insert_deskofreservation_needpay($needpay_array);
			// == блок вставки / оновлення семафору для готелю.
			$semafor_insert_data = array();
			$semafor_insert_data['hotelid'] = $this->config->item('hotel_id');
			$semafor_insert_data['inserttime'] = date('U');
			$this->insert_hms_order4pay_semafor($semafor_insert_data);
		}
	}

	function update_hms_order4pay_semafor($hotelid, $data) {
		$this->db->where('hotelid', $hotelid);
		$this->db->update('global_hotelix.hms_order4pay_semafor', $data);
	}

	function insert_cases_crm($data) {
		$max_id = 0;
		$sql = "SELECT max(id) as max_id FROM cases_crm";
		$query = $this->db->query($sql);
		if($query->num_rows()> 0) {
			$row = $query->row();
			$max_id = $row->max_id;
		}
		$next_id = $max_id + 1;
		$query = $this->db->query("INSERT INTO cases_crm (id, message, state)
		VALUES(" . 
			   $next_id . 
			   ", '" . 
			   addslashes($data['message']). 
						  "', 1)");
	}

	function insert_hms_notifications($data) {
		$this->db->insert('hms_notifications', $data);
	}
	//     function remove_hms_notifications($id){
	//         $this->db->where('id', $id);
	//         $this->db->delete('hms_notifications');
	//     }

	function remove_hms_notifications($id) {
		$data = array('state' => 2);
		$this->db->where('id', $id);
		$this->db->update('hms_notifications', $data);
	}

	function remove_all_hms_notifications() {
		$data = array('state' => 2);
		$this->db->update('hms_notifications', $data);
	}

	function remindlater_hms_notifications($id) {
		$readtime = date("Y-m-d H:i:s");
		$data = array('time' =>$readtime);
		$this->db->where('id', $id);
		$this->db->update('hms_notifications', $data);
	}

	function get_nopay_action() {
		$nopay_action = 0;
		$query = $this->db->query("SELECT value FROM  gatewayoforder_personal WHERE name LIKE 'nopay_action'");
		if($query->num_rows()> 0) {
			$row = $query->row();
			$nopay_action = $row->value;
		}
		return $nopay_action;
	}

	function get_airbnb_testmode_value() {
		$sql = "SELECT int_value FROM dc_airbnb_xml_cfg WHERE name LIKE 'airbnb_testmode'";
		$query = $this->db->query($sql);
		if($query->num_rows()) {
			$row = $query->row();
			return $row->int_value;
		} else {
			return 0;
		}
	}

	function get_vc_reservations($data) {
		$date = $this->session->userdata('report_virtual_cc_list_date_range');
		$dealer = $this->session->userdata('report_virtual_cc_list_dealer');
		$sort_checkin = $this->session->userdata('report_vcc_list_sort_checkin');
		$sort_checkout = $this->session->userdata('report_vcc_list_sort_checkout');
		$select = "";
		if($dealer > 0) {
			$select .= " dr.id_dealer = " . $dealer . " AND";
		}
		if($date != "") {
			list($datein, $dateout)= explode(' - ', $date);
			if($datein != "" and $dateout != "") {
				$select .= " dr.datein <= '" . $dateout . "' AND dr.dateout >= '" . $datein . "' AND";
			}
		}
		$select .= " 1";
		$select_sort = "";
		if($sort_checkin != "" or $sort_checkout != "") {
			switch($sort_checkin) {
				case "21" : $select_sort = "ORDER by dr.datein ASC";
				break;
				case "22" : $select_sort = "ORDER by dr.datein DESC";
				break;
			}
			switch($sort_checkout) {
				case "11" : $select_sort = "ORDER by dr.dateout ASC";
				break;
				case "12" : $select_sort = "ORDER by dr.dateout DESC";
				break;
			}
		}
		$sql = "SELECT dr.id as res_id, dr.date, dr.balance, concat(guests.lastname, ' ',
        guests.firstname) as guest_name, dr.datein, dr.dateout, t_cc.cc_activation_date,
        t_cc.CardNumber as cc_number, dr.dc_id, pd.id as pay_deff_id, pd.state,
        appex_payments.status_id as appex_pay_status, dr.dc_id, pd.amount, pd.currency
        FROM payment_deffered as pd
        INNER JOIN tbl_CreditCards as t_cc ON t_cc.id = pd.tcc_id
        INNER JOIN deskofreservation as dr ON dr.id = t_cc.reservation_id
        INNER JOIN guests ON guests.id = dr.guest_id
        LEFT JOIN payment ON payment.reservation_id = dr.id
        LEFT JOIN appex_payments ON appex_payments.hms_payment_id = payment.id
        WHERE t_cc.CardNumber <> '' AND $select $select_sort
        LIMIT " . $data['page_first_line'] . ", " . $data['lines_per_page'];
		return $this->db->query($sql)->result_array();
	}

	function get_vc_vpos_reservations($data) {
		$date = $this->session->userdata('report_virtual_cc_list_date_range');
		$dealer = $this->session->userdata('report_virtual_cc_list_dealer');
		$sort_checkin = $this->session->userdata('report_vcc_list_sort_checkin');
		$sort_checkout = $this->session->userdata('report_vcc_list_sort_checkout');
		$select = "";
		if($dealer > 0) {
			$select .= " dr.id_dealer = " . $dealer . " AND";
		}
		if($date != "") {
			list($datein, $dateout)= explode(' - ', $date);
			if($datein != "" and $dateout != "") {
				$select .= " dr.datein <= '" . $dateout . "' AND dr.dateout >= '" . $datein . "' AND";
			}
		}
		$select .= " 1";
		$select_sort = "";
		if($sort_checkin != "" or $sort_checkout != "") {
			switch($sort_checkin) {
				case "21" : $select_sort = "ORDER by dr.datein ASC";
				break;
				case "22" : $select_sort = "ORDER by dr.datein DESC";
				break;
			}
			switch($sort_checkout) {
				case "11" : $select_sort = "ORDER by dr.dateout ASC";
				break;
				case "12" : $select_sort = "ORDER by dr.dateout DESC";
				break;
			}
		}
		$sql = "SELECT SQL_CALC_FOUND_ROWS 1 as number, p2cc.res_id, p2cc.pay_id, dr.date, dr.balance, concat(guests.lastname, ' ',
        guests.firstname) as guest_name, dr.datein, dr.dateout, t_ccp.expmonth, t_ccp.expyear,
        t_ccp.cardnumber as cc_number, dr.dc_id, p2cc.state as p2cc_state, dr.dc_id, payment.amount, '' as currency,
        payment.vpos, payment.create_time, p2cc.transID, p2cc.transID_str, p2cc.error_desc, p2cc.error_code
        FROM  payment2creditcard as p2cc

        INNER JOIN deskofreservation as dr ON dr.id = p2cc.res_id
        INNER JOIN guests ON guests.id = dr.guest_id
        INNER JOIN payment ON payment.reservation_id = dr.id AND payment.id = p2cc.pay_id
        INNER JOIN tbl_CreditCards_payment as t_ccp ON t_ccp.id = p2cc.cc_id
        LEFT JOIN appex_payments ON appex_payments.hms_payment_id = payment.id
        WHERE payment.vpos = 1 AND t_ccp.cardnumber <> '' AND $select $select_sort GROUP BY p2cc.res_id, p2cc.pay_id
        ORDER BY p2cc.id DESC LIMIT " . $data['page_first_line'] . ", " . $data['lines_per_page'];
		//         echo $sql;
		//         die();
		return $this->db->query($sql)->result_array();
	}

	function get_dealers() {
		return $this->db->select('id, name')->get('dealers')->result_array();
	}
	
	/*
	 *
	 * ===== блок операцій над бронюванням (відновлення та переміщення бронювання) =====
	 * ===== якщо бронювання оплатили ======= ?? nopay_action rename ispay_action
	 */
	function nopay_action($reservation_id) {
		$action_result = "";
		$nopay_action = $this->frontdesk_c2->get_nopay_action();
		switch($nopay_action) {
			case 1 : // якщо бронювання відмінили ще до оплати, ми його відновлюємо
			$cancel = 0;
			$query = $this->db->query("SELECT cancel FROM  deskofreservation WHERE id = " . 
									  $reservation_id);
			if($query->num_rows()> 0) {
				$row = $query->row();
				$cancel = $row->cancel;
			}
			if($cancel == 1) {
				$this->cancel->CancelBack($reservation_id, 0, 1);
				$action_result = "cancel done";
			}
			// завершення відновлення
			break;
			case 2 : 
			/*
			 *  ====== TRANSFER RESERVATION FROM OVERBOOKING GATEGORY TO ORIGIN CATEGORY ====
			 *
			 */
			$reservation_data = $this->frontdesk->GetReservation($reservation_id);
			if($reservation_data['origin_categoryid'] > 0) {
				$action_result = "datein: " . $reservation_data['datein'] . "; dateout: " . $reservation_data['dateout'] . "; origin_categoryid: " . $reservation_data['origin_categoryid'] . "; ";
				$room_id = $this->frontdesk->getfreeroomlist($reservation_data['datein'], $reservation_data['dateout'], $reservation_data["origin_categoryid"]);
				if($room_id > 0) {
					$action_result .= "new room_id = $room_id; ";
					$transfer_data = array();
					$transfer_data['reservation_id'] = $reservation_id;
					$transfer_data['room'] = $room_id;
					$skip_die = 1;
					$c2 = "";
					$this->frontdesk->ToSwap($transfer_data, $c2, $skip_die);
					$query = $this->db->query("UPDATE deskofreservation SET origin_categoryid = 0 WHERE id = $reservation_id");
					$action_result .= "UPDATE deskofreservation SET origin_categoryid = 0 WHERE id = $reservation_id";
				}
			}
			break;
		}
		return $action_result;
	}

	public function convert_currencies($props = ArrayObject::STD_PROP_LIST) {
		//Example $props: array('currency_from'=>'USA', 'currency_to'=>'UAH', 'amount'=>100)
		//On errors returns array('Error'=>'error description')
		//On sucsess returns $converted_amount
		if(isset($props['currency_from'])&& $props['currency_from'] != '') {
			$currency_from = $props['currency_from'];
		} else {
			return array('Error' => 'currency_from not set');
		}
		if(isset($props['currency_to'])&& $props['currency_to'] != '') {
			$currency_to = $props['currency_to'];
		} else {
			return array('Error' => 'currency_to not set');
		}
		if(isset($props['amount'])&& $props['amount'] != 0) {
			$amount = $props['amount'];
		} else {
			return array('Error' => 'amount not set');
		}
		//start validation complete
		$tbl = 'global_hotelix.currency_rates_today';
		$rate_to = $this->db->select('rate')->get_where($tbl, array('name' => $currency_to))->row();
		$rate_from = $this->db->select('rate')->get_where($tbl, array('name' => $currency_from))->row();
		if($rate_from && $rate_to) {
			$rate_to = $rate_to->rate;
			$rate_from = $rate_from->rate;
			$rates_koef = $rate_to / $rate_from;
			$converted_amount = round($amount * $rates_koef, 2);
			return array('amount' =>$converted_amount);
		} else {
			return array('Error' => "not converted from $currency_from to $currency_to, rates are invalid;");
		}
	}

	function get_reservation_payments($reservation_id) {
		$paymentList = array();
		$query = $this->db->query("SELECT deskofreservation.id_partner,
		payment_deffered.amount as total,
		rooms.name as room_name, categories.name as categories_name
		FROM deskofreservation
		INNER JOIN tbl_CreditCards ON deskofreservation.id = tbl_CreditCards.reservation_id
        INNER JOIN payment_deffered ON tbl_CreditCards.id = payment_deffered.tcc_id
		INNER JOIN rooms ON rooms.id = deskofreservation.room_id
		INNER JOIN categories ON categories.id = rooms.category_id

		WHERE payment_deffered.state = 0 AND deskofreservation.id = " . 
								  $reservation_id);
		//         LEFT JOIN payment ON payment.reservation_id = deskofreservation.id
		//         JOIN partners ON payment.id_partner = partners.id
		//         LEFT JOIN checkprn_gate ON checkprn_gate.payment_id = payment.id
		//         LEFT JOIN bso_records ON  bso_records.payment_id = payment.id
		//         LEFT JOIN appex_payments ON  appex_payments.hms_payment_id = payment.id
		//         LEFT JOIN payment_types ON payment_types.id = payment.type
		//         LEFT JOIN kkm_checks ON kkm_checks.pay_or_ref_id = payment.id AND kkm_checks.pay_or_ref = 0

		foreach($query->result()as $row2) {
			$appex_str = '';
			$appex_form = '';
			if($row2->appex_status_id <> NULL) {
				$appex_str = '(<b>' . $row2->appex_status_name . ', ' . $row2->appex_transID . '</b>)';
				if($row2->appex_status_id == 2) {
					$appex_form = '<form target="_blank" id="appex_form_' . $row2->id_payment . '" action="' . $row2->ACSURL . '" method=POST>
 				<input type="hidden" name="PaReq" value="' . $row2->PaReq . '">
				<input type="hidden"   name="MD" value="' . $row2->MD . '">
				<input type="hidden"   name="TermUrl" value="https://' . $hms_url . '/api_appex/response_3d/' . $reservation_id . '">
				</form>
				<a class="appex_pay_submit" href="#" pay_id="' . $row2->id_payment . '">appex_submit</a>';
				}
			}
			array_push($paymentList, array(//'pay_inc' => $pay_inc,
			'id_payment' => 0, 'parent_id' => 0, 'typename' => "", 'total' => $this->frontdesk->showcurrency($row2->total), 'create_time' => "", 'operationtime' => "", 'payment_type' => "", 'pay_description' => "", 'bso_td_value' => "", 'appex_str' => "", 'appex_form' => "", 'fiscalise_check_text' => "", //'payment_delete_allow_class' => (!isset($row2->id_kkm_check) && $payment_delete_allow_state) ? "":"d0",
			'wait_status' => "", 'pay_partner_name' => "", 'vcc_payment_link' => '<a id="make_virtual_pay"  class="btn-primary btn uppnone mw-130 " href="#">Оплатить виртуальной картой</a>',));
		}
		return $paymentList;
	}
	
	public function get_billing_params(){
	    $overbooking_category_id = $this->hotelix_config->get_record("overbooking_category_id", "int");
	    $sql = "SELECT prop_rooms.dwelling, SUM(prop_rooms.rooms_count) as sum_rooms, COUNT(1) as prop_type_count 
	            FROM (SELECT p_i.id as prop_id, p_i.dwelling, COUNT(rooms.id) as rooms_count
	            FROM property_information as p_i
	            LEFT JOIN categories ON categories.property_id = p_i.id AND categories.id <> $overbooking_category_id
	            LEFT JOIN rooms ON rooms.category_id = categories.id
	            GROUP BY p_i.id) as prop_rooms
	            GROUP BY prop_rooms.dwelling";
	    
	    return $this->db->query($sql)->result_array();
	}
	
	public function hide_data($str_value, $start_pos, $hide_len){
	    return substr_replace($str_value, str_repeat("*", $hide_len), $start_pos, $hide_len);
	}
	
	public function get_reservation_isread_status($res_is = 0) {
	    $current_isread_status = 1;
	    if ($res_is) {
	        $query_row = $this->db->select('isread')->get_where('deskofreservation', array('id' => $res_is))->row();
	        if ($query_row) {
	            $current_isread_status = $query_row->isread;
	        }
	    }
	    return $current_isread_status;
	}
	
	public function update_reservation_isread_status($p = array('res_id' => '', 'isread_status' => null)) {
	    if (isset($p['res_id']) && $p['res_id'] != '' && isset($p['isread_status']) && !is_null($p['isread_status'])) {
	        $res_is = (int)$p['res_id'];
	        $this->db->update('deskofreservation', array('isread' => $p['isread_status']), array('id' => $res_is));
	    }
	    return;
	}
	
	public function get_hms_pm_url_versions(){
	    $versions = array();
	    $versions[0]['name'] = "custom";
	    $versions[0]['value'] = 0;
	    $versions[0]['selected'] = "";
	    $versions[1]['name'] = "general url pm v2";
	    $versions[1]['value'] = 1;
	    $versions[1]['selected'] = "";
	    $versions[2]['name'] = "general url pm v3";
	    $versions[2]['value'] = 2;
	    $versions[2]['selected'] = "";
	    return $versions;
	}
}
