<?php 
class dcm_sutochno extends dcm_abstract{
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'Curl_model' );
		$this->load->model ( 'hotelix_config' );
		$this->dc_id = 30;
		$this->table_name_r2c = "dc_sutochno_rate2category_link";
		$this->table_name_dc_category2occupancy = "dc_sutochno_category2occupancy";
		$this->table_name_dc2hms_category_link = "dc_sutochno_room_categories_link";
		
		$this->sql_dc_r2rlink = "select dc_rate_id, restrict_id as hms_restrict_id from dc_sutochno_rates";
		$this->sql_dc_rates = "select  CONCAT(dc_sutochno_rates.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id, dc_sutochno_rates.dc_hotel_id, dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_sutochno_rates";
		$this->sql_dc_category_link = "select dc_sutochno_room_categories.dc_hotel_id, dc_sutochno_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_sutochno_room_categories_link.dc_category_id as dc_category_id, dc_sutochno_room_categories_strtoint_link.dc_room_id as dc_category_id_str,
            hms_category_id as hms_category_id
            from dc_sutochno_room_categories_link
            inner join dc_sutochno_room_categories on
            dc_sutochno_room_categories_link.dc_category_id = dc_sutochno_room_categories.dc_room_id
		    inner join dc_sutochno_room_categories_strtoint_link on
            dc_sutochno_room_categories_link.dc_category_id = dc_sutochno_room_categories_strtoint_link.id
        	LEFT join categories on
            categories.id = dc_sutochno_room_categories_link.hms_category_id";
		$this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id,
        	CONCAT(dc_sutochno_room_categories.dc_hotel_id, '_', dc_rate_id) as dc_hotel_rate_id
            from dc_sutochno_rate2category_link
        	inner join dc_sutochno_room_categories on
            dc_sutochno_rate2category_link.dc_category_id = dc_sutochno_room_categories.dc_room_id ";
		
		$this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name, roomcategory from dc_sutochno_occupancy ORDER BY id ASC";
		$this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
		
		$this->sql_dc_category_list = "select dc_sutochno_xml_cfg.int_value as dc_hotel_id, dc_sutochno_room_categories.name as dc_category_name,
            dc_room_id as dc_category_id, active from dc_sutochno_room_categories
        	left join dc_sutochno_xml_cfg on
            dc_sutochno_room_categories.dc_hotel_id = dc_sutochno_xml_cfg.int_value and dc_sutochno_xml_cfg.name='hotel_id'";
		$this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_sutochno_category2occupancy";
		
		$this->form_action_c2o_post_c2 = "/dc_sutochno/categories_edit_post";
		$this->form_action_r2c_post_c2 = "/dc_sutochno/rates_edit_post";
    }
    
    function getauthparam($dc_account_id = 0)
	{
	    $hotel_id = "";	  
	    if ($dc_account_id != 0) {
            $sql = "SELECT str_value FROM dc_sutochno_xml_cfg WHERE dc_account_id = " . $dc_account_id . " AND name LIKE 'hotel_id'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hotel_id = $row->str_value;
            }
        }
	    
	    $url = "https://api.sutochno.ru";
	    $token = "Ltfa48Ll1B+8C6RYRX/0Wg279460879";
	    
	    $data = array();
	    $data["url"] = $url;
	    $data["token"] = $token;
	    $data["hotel_id"] = $hotel_id;
	    $data["hotel_id_int"] = $dc_account_id;
	    
	    return $data;
	}
	
	function get_dc_room_id_by_str_value($dc_room_id){
	    $query_arr = $this->db->select('id')->get_where('dc_sutochno_room_categories_strtoint_link', array('dc_room_id' => $dc_room_id))->row_array();
	    return $query_arr['id'];
	}
	
	function get_dc_room_id_str_value(){
	    $query_arr = $this->db->select('dc_room_id')->get('dc_sutochno_room_categories_strtoint_link')->result_array();
	    return $query_arr;
	}
	
	function rate2category_save_booking($r2c)
	{
	    if (sizeof($r2c)) {} else {
	        return;
	    }
// 	    echo "<pre>";
// 	    print_r($r2c);
// 	    die();
	    $this->db->query("delete from " . $this->table_name_r2c);
	
	    foreach ($r2c as $dc_rate_id => $dc_category_list) {
	        foreach ($dc_category_list["categories"] as $dc_category_id => $cell) {
	            //foreach ($occupancy as $key => $cell) {
	                $sql = "insert into " . $this->table_name_r2c . "  (dc_rate_id, dc_category_id, hms_rate_id) values
	                ($dc_rate_id, $dc_category_id, " . $cell['hms_rate_id'] . ") on duplicate key update
                hms_rate_id=" . $cell['hms_rate_id'] . "";
	                // echo $sql . "\n";
	                $this->db->query($sql);
	            //}
	        }
	        
	        $sql = "UPDATE dc_sutochno_rates SET restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
	        $this->db->query ( $sql );
	        
// 	        $sql = "INSERT INTO dc_sutochno_rates (dc_hotel_id, dc_rate_id, restrict_id) 
// 	                   values (".$r2c[$dc_rate_id]['dc_hotel_id'].", $dc_rate_id, ".$r2c[$dc_rate_id]['hms_restrict_id'].")
// 			           on duplicate key update restrict_id = ".$r2c[$dc_rate_id]['hms_restrict_id'];
// 	        $this->db->query ( $sql );
	    }
	}
	
	function options_save($data)
	{
	    $data_1 = array();
	    $query = $this->db->query("SELECT * FROM dc_sutochno_xml_cfg WHERE name LIKE 'general_update'");
	
	    if ($query->num_rows() > 0) {
	        $row = $query->row_array();
	        $data_1["general_update"] = $row["int_value"];
	    }
	    $sql = "INSERT INTO dc_sutochno_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'dealer_id', '" . $data["dealer"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["dealer"];
	    $query = $this->db->query($sql);
	    $sql = "INSERT INTO dc_sutochno_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'overbooking_category_id', '" . $data["overbooking_category"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["overbooking_category"];
	    $query = $this->db->query($sql);
	    $sql = "INSERT INTO dc_sutochno_xml_cfg (dc_account_id, name, int_value) VALUES(0, 'general_update', '" . $data["general_update"] . "') ON DUPLICATE KEY UPDATE int_value = " . $data["general_update"];
	    $query = $this->db->query($sql);
	
	    $data_2 = array();
	    $query = $this->db->query("SELECT * FROM dc_sutochno_xml_cfg WHERE name LIKE 'general_update'");
	
	    if ($query->num_rows() > 0) {
	        $row = $query->row_array();
	        $data_2["general_update"] = $row["int_value"];
	    }
	
	    $this->Loger_admin->SaveLog($data_1, $data_2, "loger_admin", 0, "dc_sutochno_xml_cfg", "edit");
	}
	
	function build_rate2category ($occupancy_bool = 0, $roomstorate = 0, $price_func = 0)
	{
	    //$occupancy_bool = 0;
	    $sql = $this->sql_dc_rates;
	    //echo $sql."<br>";
	    $query = $this->db->query($sql);
	    $rate2category = array();
	    $hms_rates_list = $this->build_hms_rates();
	    $hms_restrictions_list = $this->build_hms_restrictions();
	   
	    $c2o = $this->get_category2occupancy();
	
	    $r2c_link = $this->get_r2c_link();
	    //         echo "<pre>";
	    //         print_r($r2c_link);
	    //         die();
	    foreach ($query->result() as $rate_row) {
	        $sql = $this->sql_dc_category_link;
	
	        //if($roomstorate == 1){
	        //	$sql .= $this->sql_roomstorate." ".$rate_row->dc_rate_id;
	         
	        //}
	        //echo $sql."<br>";
	        $query2 = $this->db->query($sql);
	
	        //$rate2category[$rate_row->dc_rate_id] = array();
	        $rate2category[$rate_row->dc_rate_id]['dc_rate_name'] = $rate_row->dc_rate_name;
	        $rate2category[$rate_row->dc_rate_id]['dc_rate_id'] = $rate_row->dc_rate_id;
	        if(isset($rate_row->dc_hotel_id)){
	            $rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = $rate_row->dc_hotel_id;
	        }else{
	            $rate2category[$rate_row->dc_rate_id]['dc_hotel_id'] = "";
	        }
	        if (isset($rate_row->dc_property_name)) {
	            $rate2category[$rate_row->dc_rate_id]['dc_property_name'] = $rate_row->dc_property_name;
	        } else {
	            $rate2category[$rate_row->dc_rate_id]['dc_property_name'] = "";
	        }
	
	        if(isset($rate_row->active)){
	            $rate2category[$rate_row->dc_rate_id]['active'] = $rate_row->active;
	        }else{
	            $rate2category[$rate_row->dc_rate_id]['active'] = "active";
	        }
	        // ================================================================================
	        if (isset($rate_row->restrict_name)) {
	            $rate2category[$rate_row->dc_rate_id]['restrict_name'] = $rate_row->restrict_name;
	        } else {
	            $rate2category[$rate_row->dc_rate_id]['restrict_name'] = "";
	        }
	        // ================================================================================
	        foreach ($query2->result() as $category_row) {
	            if($roomstorate == 1){
	                if(isset($r2c_link[$rate_row->dc_rate_id][$category_row->dc_category_id])){
	                     
	                }else{
	                    //echo "+++"."1";
	                    //die();
	                    continue;
	                }
	            }
	            if(isset($category_row->dc_hotel_id)){
	                //echo $category_row->dc_hotel_id."|||".$rate_row->dc_hotel_id."<br>";
	                if($category_row->dc_hotel_id == $rate_row->dc_hotel_id){
	                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_name'] = $category_row->dc_category_name;
	                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id'] = $category_row->dc_category_id;
	                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_category_id_str'] = $category_row->dc_category_id_str;
	                    if(isset($category_row->hms_category_name)){
	                        $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = $category_row->hms_category_name;
	                    }else{
	                        $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_name'] = "";
	                    }
	                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['hms_category_id'] = $category_row->hms_category_id;
	                    $rate2category[$rate_row->dc_rate_id]['category_list'][$category_row->dc_category_id]['dc_rate_id'] = $rate_row->dc_rate_id;

	                    $rate2category [$rate_row->dc_rate_id] ['category_list'] [$category_row->dc_category_id]['hms_rates_list'] = $hms_rates_list;	                   
	                    $rate2category[$rate_row->dc_rate_id]['hms_restrictions_list'] = $hms_restrictions_list;
	                }
	            }
	        }
	    }
// 	    echo "<pre>";
// 	    print_r($rate2category);
// 	    print_r($c2o);
// 	    die();
	    //
	    $sql = $this->sql_dc_r2c;
	    $query = $this->db->query($sql);
	    // echo $sql;
	    foreach ($query->result() as $row) {
	       $rate2category[$row->dc_rate_id]['category_list'][$row->dc_category_id]['hms_rates_list'][$row->hms_rate_id]['selected'] = 'selected';
	    }
	
	    if ($this->sql_dc_r2rlink !== "") {
	        $sql = $this->sql_dc_r2rlink;
	        $query = $this->db->query($sql);
	        // echo $sql;
	        foreach ($query->result() as $row) {
	            $rate2category[$row->dc_rate_id]['hms_restrictions_list'][$row->hms_restrict_id]['selected'] = 'selected';
	        }
	    }
	    // echo "<pre>";
	    // print_r($rate2category);
	    return $rate2category;
	}
	
	function get_bookings($data, $db_name = "", $debug = false, $object_id = "") {
	    $rates = array ();
	    $query = $this->db->query ( "  SELECT dc_sutochno_rate2category_link.hms_rate_id, dc_sutochno_rate2category_link.dc_rate_id,
	                                   dc_sutochno_room_categories_strtoint_link.dc_room_id as dc_category_id
	                                   FROM dc_sutochno_rate2category_link
	                                   INNER JOIN  dc_sutochno_room_categories_strtoint_link
	                                   ON dc_sutochno_room_categories_strtoint_link.id = dc_sutochno_rate2category_link.dc_category_id" );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $rates [$row->dc_rate_id] [$row->dc_category_id] = $row->hms_rate_id;
	        }
	    }
	
	    $rates_names = array ();
	    $query = $this->db->query ( "SELECT name, dc_rate_id FROM  dc_sutochno_rates" );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $rates_names [$row->dc_rate_id] ["dc_rate_name"] = $row->name;
	        }
	    }
	
	    $categories = array ();
	    $query = $this->db->query ( "SELECT dc_sutochno_room_categories_strtoint_link.dc_room_id as dc_category_id, dc_sutochno_room_categories_link.hms_category_id
	                                 FROM dc_sutochno_room_categories_link
	                                 INNER JOIN  dc_sutochno_room_categories_strtoint_link
	                                 ON dc_sutochno_room_categories_strtoint_link.id = dc_sutochno_room_categories_link.dc_category_id" );
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories [$row->dc_category_id] = $row->hms_category_id;
	        }
	    }
	
	    $categories_names = array ();
	    $query = $this->db->query ( "SELECT id, name FROM categories" );
	
	    if ($query->num_rows () > 0) {
	        foreach ( $query->result () as $row ) {
	            $categories_names [$row->id] = $row->name;
	        }
	    }
	
	    $query = $this->db->query ( "SELECT id FROM rate WHERE isdefault = 1" );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $price_type = $row->id;
	    }
	
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_sutochno_xml_cfg WHERE name LIKE 'dealer_id'" );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $dealer = $row->int_value;
	    }
	
	    $query = $this->db->query ( "SELECT int_value FROM dc_sutochno_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $overbooking_category_id = $row->int_value;
	    }
	
	    $autoclosedaychicho = 0;
	    $query = $this->db->query ( "SELECT int_value FROM dc_sutochno_xml_cfg WHERE name LIKE 'autoclosedaychicho'" );
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $autoclosedaychicho = $row->int_value;
	    }
	
	    $timezone = "";
	    $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'");
	    if ($query->num_rows () > 0) {
	        $row = $query->row ();
	        $timezone = $row->str_value;
	    }else{
	        $timezone = "America/Los_Angeles";
	    }
	
	    $date_today = date('Y-m-d');
	
	    $checkin_checkout_arr = $this->frontdesk->get_check_in_out_time();
	
	    $result_array = array ();
	    //print_r($data );
	    if (isset ( $data ["data"]["objects"] )) {
	        $reservations = array ();
	        if (isset ( $data ["data"]["objects"] [0] )) {
	            $reservations = $data ["data"]["objects"];
	        } else {
	            $reservations [0] = $data ["data"]["objects"];
	        }
	        $dc_rate_id = 1;
	        $counter = 0;
	        //echo "<pre>";
	        //print_r($reservations);
	        $otelms_rooms = array();
	        foreach ($reservations as $reservation) {
	            $dc_room_id = $reservation["id"];
	
	            // === вибираємо всі бронювання категорії $dc_room_id, дата заїзду в яких, більша за поточну дату ==
	            $this->db->select('dc_reservationid, id, dc_uuid');
	            $this->db->where("deleted = 0 AND cancel = 0 AND dc_id = 30 AND dc_uuid LIKE '%".$dc_room_id."%' AND datein >= '".$date_today."'");
	            $query = $this->db->get('deskofreservation');
	            foreach ($query->result_array() as $row) {
	                $otelms_rooms[$row['dc_uuid']]['otelms_reservation_id'] = $row['id'];
	                $otelms_rooms[$row['dc_uuid']]['status'] = 0;
	                $otelms_rooms[$row['dc_uuid']]['dc_reservationid'] = $row['dc_reservationid'];
	            }
	
	            print_r($otelms_rooms);
	            //die();
	
	            if (isset($reservation["events"])) {
	                if (isset($reservation["events"][0])) {
	                    $events = $reservation["events"];
	                } else {
	                    $events[0] = $reservation["events"];
	                }
	
	
	                if(isset($rates [$dc_rate_id] [$dc_room_id])){
	                    $price_type = $rates [$dc_rate_id] [$dc_room_id];
	                }
	                $counter_2 = 0;
	                foreach ($events as $event) {
	                    if (isset($event["event_id"])) {
	                        $event["booking_id"] = $event["event_id"];
	
	                        // print_r($otelms_rooms);
	
	                        $rooms_count = $event["rooms_count"];
	
	                        for ($j = 0; $j < $rooms_count; $j ++) {
	
	                            $dc_total_price = 0;
	                            $k = 0;
	                            $PerDay_data = array();
	
	
	                            $date_begin = explode(" ", $event["date_begin"]);
	                            $datein = $date_begin[0];
	                            $checkin_time = isset($date_begin[1])?$date_begin[1]:'';
	
	                            $date_end = explode(" ", $event["date_end"]);
	                            $dateout = $date_end[0];
	                            $checkout_time =  isset($date_end[1])?$date_end[1]:'';
	
	                            // ========================================
	                            $result_array["reservations"][$counter][$counter_2]["checksum"] = json_encode($event);
	                            $result_array["reservations"][$counter][$counter_2]["checksum_md5"] = md5(json_encode($event));
	
	                            $result_array["reservations"][$counter][$counter_2]["guests"] = array();
	
	                            $result_array["reservations"][$counter][$counter_2]["dc_rate_id"] = $dc_rate_id;
	                            $result_array["reservations"][$counter][$counter_2]["currencycode"] = $event["currency"];
	
	                            $result_array["reservations"][$counter][$counter_2]["card"]["cc_cvc"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["card"]["ExpMonth"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["card"]["ExpYear"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["card"]["CardHolder"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["card"]["CardNumber"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["card"]["cc_type"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["address"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["city"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["email"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["firstname"] = $event["name"];
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["lastname"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["phone"] = $event["phone"];
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["country"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["guest"]["passportid"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["status"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["dc_reservationid"] = $event["booking_id"];
	
	                            $created_datetime = explode(" ", $event["date_add"]);
	                            $created_date = $created_datetime[0];
	                            $created_time = $created_datetime[1];
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_id"] = 30;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["commissionamount"] = 0;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["date"] = $created_date;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_reservationid"] = $event["booking_id"];
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["time"] = $created_time;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_date"] = $created_date;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_time"] = $created_time;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_updatetime"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["isNew"] = 1;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["datein"] = $datein;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["checkintime"] = $checkin_time;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dateout"] = $dateout;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["checkouttime"] = $checkout_time;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_roomreservation_id"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_uuid"] = $event["booking_id"] . "_" . $dc_room_id."_".$j;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["category_id"] = $dc_room_id;
	                            if (isset($categories_names[$categories[$dc_room_id]])) {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["reservation_type_name"] = $categories_names[$categories[$dc_room_id]];
	                            } else {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["reservation_type_name"] = "";
	                            }
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["placement_id"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["add_places"] = 0;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["baby_places"] = 0;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["amount"] = $event["price"];
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["price_type"] = $price_type;
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["description"] = "";
	                            if (isset($_SESSION["user"]["id"])) {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["user"] = $_SESSION["user"]["id"];
	                            } else {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["user"] = - 1;
	                            }
	
	                            if (isset($categories[$dc_room_id])) {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["type_id"] = $categories[$dc_room_id];
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_type_id"] = $dc_room_id;
	                            } else {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["type_id"] = 0;
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_type_id"] = 0;
	                            }
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dealer"] = $dealer;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_guestname"] = $event["name"];
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_numberofguest"] = $event["guests"];
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_countrycode"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_currencycode"] = $event["currency"];
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_city"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_customerremarks"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_roomremarks"] = "";
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["description"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["dc_totalprice"] = $event["price"];
	
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["smoking"] = "";
	
	                            $result_array["reservations"][$counter][$counter_2]["roomreservation_id"] = "";
	
	                            // =============================================================================
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["early_check_in_close"] = 0;
	                            $result_array["reservations"][$counter][$counter_2]["reservation"]["late_check_out_close"] = 0;
	
	                            if ($rooms_count > 1) {
	                                $result_array["reservations"][$counter][$counter_2]["reservation"]["groupid"] = $event["booking_id"];
	                            }
	
	                            list($year, $month, $day) = explode("-", $datein);
	                            $intdatein = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            list($year, $month, $day) = explode("-", $dateout);
	                            $intdateout = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
	                            $duration = $intdateout - $intdatein;
	
	                            $daily_price = $event["price"] / $duration;
	
	                            for($k = 0; $k < $duration; $k++){
	                                $date = date("Y-m-d", ($intdatein+$k)*86400);
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["dc_currencycode"] = $event["currency"];
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["dc_reservation_id"] = $event["booking_id"];
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["price"] = $daily_price;
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["dc_rate_id"] = $dc_rate_id;
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["dc_rate_name"] = $rates_names[$dc_rate_id]["dc_rate_name"];
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["intdate"] = $intdatein+$k;
	                                $result_array["reservations"][$counter][$counter_2] ["per_day"] [$k] ["date_rate"] = $date;
	                            }
	
	                            $counter_2 ++;
	                        }
	
	                    }
	                }
	                $counter ++;
	            }
	        }
	    }
	    echo "<pre>";
	    print_r ( $result_array );
	    // 	    die ();
	
	    $host = "";
	    if($db_name <> ""){
	        $query = $this->db->query ( "SELECT host FROM visitka.config WHERE db_name LIKE '".$db_name."'" );
	
	        if ($query->num_rows () > 0) {
	            $row = $query->row ();
	            $host = $row->host;
	        }
	    }else{
	        if ($_SERVER ["HTTP_HOST"]) {
	            $host = $_SERVER ["HTTP_HOST"];
	        }
	    }
	
	    $reservationpush = array ();
	
	    if (isset ( $result_array ["reservations"] )) {
	        $k = 0;
	
	        $bool_cancel = 0;
	        $guest_array = array ();
	        $guest_counter = 1;
	
	        foreach ( $result_array ["reservations"] as $key => $reservations ) {
	            $dc_reservationid = $reservations [0] ["dc_reservationid"];
	            //$dc_room_id = $reservations [0] ["category_id"];
	            $dc_status = $reservations [0] ["status"];
	            $res_count = count ( $reservations );
	            $bool_guest = 0;
	            //$confirm_fail = 0;
	            for($i = 0; $i < $res_count; $i ++) {
	                $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_date = '" . $reservations [$i] ["reservation"] ["dc_date"] . "' AND dc_time = '" . $reservations [$i] ["reservation"] ["dc_time"] . "' AND dc_id = 30 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
	
	                $query = $this->db->query ( $sql );
	                $hms_reservation_id = 0;
	                $otelms_room_id = 0;
	                if ($query->num_rows () > 0) {
	                    $row = $query->row ();
	
	                    if(isset($otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]])){
	                        $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                    }
	
	                    $reservationpush [$k] ["response"] = "skip";
	                    $reservationpush [$k] ["status"] = "skip";
	                    $reservationpush [$k] ["hms_reservation_id"] = $row->id;
	                    $reservationpush [$k] ["dc_reservationid"] = $dc_reservationid;
	                    $result_array ["reservations"] [$key] [$i] ["status"] = "skip";
	                    $k ++;
	                    // die();
	                    continue;
	                }
	
	                //=========================================================================
	
	                $calculate_data = array ();
	                $calculate_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
	                $calculate_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
	                $calculate_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
	                $calculate_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
	                $calculate_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
	                $calculate_data ["addbedplace"] = 0;
	                $calculate_data ["babyplace2"] = 0;
	                $calculate_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
	
	                $temp_amount = $this->frontdesk->getpricecalculation ( $calculate_data );
	                $otelms_amount = 0;
	                for($p = 0; $p < count ( $temp_amount ); $p ++) {
	                    $otelms_amount += $temp_amount [$p] ["amount"];
	                }
	                $booking_amount = $reservations [$i] ["reservation"] ["amount"];
	                $reservations [$i] ["reservation"] ["discount"] = 0;
	                if ($booking_amount != $otelms_amount) {
	                    //if ($otelms_amount != 0) {
	                    $reservations [$i] ["reservation"] ["discount"] = $otelms_amount - $booking_amount;
	                    //}
	                }
	
	                //=====================================================
	                //=====================================================
	                //=====================================================
	
	                $datein = $reservations [$i] ["reservation"] ["datein"];
	                $dateout = $reservations [$i] ["reservation"] ["dateout"];
	                $type_id = $reservations [$i] ["reservation"] ["type_id"];
	                $sql = "SELECT id, room_id FROM deskofreservation WHERE dc_id = 30 AND cancel=0 AND deleted = 0 AND dc_uuid LIKE '" . $reservations [$i] ["reservation"] ["dc_uuid"] . "' AND dc_reservationid = ".$reservations [$i] ["reservation"] ["dc_reservationid"]." ORDER BY id DESC ";
	                //echo $sql;
	                $query = $this->db->query ( $sql );
	                $hms_reservation_id = 0;
	                $otelms_room_id = 0;
	                if ($query->num_rows () > 0) {
	                    $row = $query->row ();
	                    $hms_reservation_id = $row->id;
	                    $otelms_room_id = $row->room_id;
	                }
	
	                if (isset ( $reservations [$i] ["per_day"] )) {
	
	                    $this->dc_rate_intdate_insert ( $reservations [$i] ["per_day"] );
	                }
	
	                if ($reservations [$i] ["status"] == "cancelled") {
	                    if(isset($otelms_rooms  [$reservations [$i]["reservation"] ["dc_uuid"]])){
	                        $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                    }
	                    $query2 = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, rooms.category_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id WHERE dc_id = 30 AND deskofreservation.id = $hms_reservation_id" );
	
	                    if ($query2->num_rows () > 0) {
	                        $row2 = $query2->row ();
	                        $datein = $row2->datein;
	                        $dateout = $row2->dateout;
	                        $type_id = $row2->category_id;
	                    }
	
	                    $time2 = date ( "Y-m-d H:i:s" );
	                    $status = 5;
	                    $query2 = $this->db->query ( "SELECT id FROM  services_main WHERE reservation_id = " . $hms_reservation_id . " AND type = 2" );
	
	                    if ($query2->num_rows () > 0) {
	                        $reservationpush [$k] ["response"] = "failed";
	                        $reservationpush [$k] ["text"] = "есть уже отмена";
	                        $reservationpush [$k] ["status"] = "cancel";
	
	                        $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                        $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                        $k ++;
	
	                        $dc_log_data = array ();
	                        $dc_log_data ["datein"] = $datein;
	                        $dc_log_data ["dateout"] = $dateout;
	                        $dc_log_data ["category_id"] = $type_id;
	                        $this->frontdesk->dc_log_update ( $dc_log_data );
	                    } else {
	                        $sql = "SELECT id FROM deskofreservation WHERE id = " . $hms_reservation_id;
	                        echo $sql;
	                        $query2 = $this->db->query ( $sql );
	
	                        if ($query2->num_rows () > 0) {
	                            $data_cancel = array ();
	
	                            $data_cancel ["res_id"] = $hms_reservation_id;
	                            $data_cancel ["charge"] = 0;
	                            $data_cancel ["status"] = 5;
	                            ;
	                            $data_cancel ["description"] = "cancel from 101otel";
	                            $data_cancel ["guestbe_request"] = 0;
	                            $data_cancel ["user"] = - 1;
	                            // ====================
	                            $this->Cancel->Insert ( $data_cancel );
	                            // ====================
	                            $query2 = $this->db->query ( "UPDATE deskofreservation SET dc_updatetime = '".$reservations [$i] ["reservation"] ["dc_updatetime"]."' WHERE id = " . $hms_reservation_id );
	                            $reservationpush [$k] ["response"] = "ok";
	                            $reservationpush [$k] ["text"] = "";
	                            $reservationpush [$k] ["status"] = "cancel";
	                            $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                            $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                            $k ++;
	                        } else {
	                            //$confirm_fail = 0;
	                            $reservationpush [$k] ["response"] = "failed";
	                            $reservationpush [$k] ["text"] = "нет брони для отмены";
	                            $reservationpush [$k] ["status"] = "skip";
	
	                            $reservationpush [$k] ["hms_reservation_id"] = 0;
	                            $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                            $k ++;
	                        }
	                    }
	                } else {
	
	                    if($hms_reservation_id == 0){
	                        /*
	                         * NEW RESERVATION BLOCK
	                         */
	
	
	
	                        $room_id = 0;
	
	                        if ($type_id == 0 or $type_id == "") {
	                            $query2 = $this->db->query ( "SELECT int_value FROM  dc_sutochno_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                            if ($query2->num_rows () > 0) {
	                                $row2 = $query2->row ();
	                                $type_id = $row2->int_value;
	                            }
	                        }
	                        if ($type_id == 0 or $type_id == "") {
	                            //$confirm_fail = 1;
	                            $reservationpush [$k] ["response"] = "error";
	                            $reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
	                            $reservationpush [$k] ["status"] = "new";
	                            $reservationpush [$k] ["hms_reservation_id"] = $row->id;
	                            $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                            $result_array ["reservations"] [$key] [$i] ["status"] = "new";
	                            $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                            $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                            $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                            $k ++;
	                        } else {
	                            $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservations [$i] ["reservation"]["early_check_in_close"], $reservations [$i] ["reservation"]["late_check_out_close"] );
	                            if ($room_id == 0) {
	
	                                if (isset ( $overbooking_category_id )) {
	                                    $reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
	                                    $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservations [$i] ["reservation"]["early_check_in_close"], $reservations [$i] ["reservation"]["late_check_out_close"] );
	
	                                    $insert_over_room_bool = 0;
	                                    if ($room_id == 0) {
	                                        $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                        $insert_over_room_bool = 1;
	                                    }
	                                } else {
	                                    // $confirm_fail = 1;
	                                    $reservationpush [$k] ["response"] = "failed";
	                                    $reservationpush [$k] ["text"] = "no overbooking_category_id";
	                                    $reservationpush [$k] ["status"] = "new";
	                                    $reservationpush [$k] ["hms_reservation_id"] = 0;
	                                    $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                                    $reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
	                                    $result_array ["reservations"] [$key] [$i] ["status"] = "new";
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                }
	                            }
	                            $reservations [$i] ["reservation"] ["room_id"] = $room_id;
	
	                            //if ($bool_guest == 0) {
	                            $guest_id = $this->frontdesk->Guest_insert ( $reservations [$i] ["guest"] );
	                            //$bool_guest = 1;
	                            //}
	                            //print_r($reservations [$i] ["reservation"]);
	                            //die();
	                            $hms_reservation_id = $this->frontdesk->Reservation_insert ( $reservations [$i] ["reservation"], $guest_id, 0, 1 );
	
	                            if(isset($otelms_rooms [$reservations [$i] ["reservation"] ["dc_uuid"]])){
	                                $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                            }
	
	                             
	                            // 	                            list($event_id, $object_id, $counter_id) = explode("_", $reservations [$i] ["reservation"]["dc_uuid"]);
	                            // 	                            $connection_data = array();
	                            // 	                            $connection_data ['object_id'] = $object_id;
	                            // 	                            $connection_data ['event_id'] = $event_id;
	                            // 	                            $connection_data ['counter_id'] = $counter_id;
	                            // 	                            $connection_data ['hms_res_id'] = $hms_reservation_id;
	                            // 	                            $connection_data ['date'] = $reservations [$i] ["reservation"]["dc_date"];
	                            // 	                            $connection_data ['state'] = 0;
	                            // 	                            $this->insert_reservation_connections ( $connection_data );
	                             
	                             
	                            if (isset ( $reservations [$i] ["card"] )) {
	                                $this->frontdesk->insert_tbl_CreditCards ( $reservations [$i] ["card"], $guest_id, $hms_reservation_id );
	                            }
	
	                            if ($hms_reservation_id > 0) {
	                                // ==== фіксація чексуми для бронювання в базіданих ====
	                                $data_checksum = array();
	                                $data_checksum ['hms_reservation_id'] = $hms_reservation_id;
	                                $data_checksum ['checksum'] = $reservations [$i] ["checksum"];
	                                $data_checksum ['checksum_md5'] = $reservations [$i] ["checksum_md5"];
	                                $this->set_reservation_checksum($data_checksum);
	                                 
	                                /*
	                                 *  ==== ADD SERVICES ======
	                                 */
	                                //$this->del_addons($reservations [$i] ["reservation"] ["dc_uuid"]);
	                                //$this->add_addons($reservations [$i] ["addons"], $hms_reservation_id, $services_types_dc);
	                                /*
	                                 * =========================
	                                 */
	                                $reservationpush [$k] ["response"] = "ok";
	                                $reservationpush [$k] ["text"] = "";
	                                $reservationpush [$k] ["status"] = "new";
	                                $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                                $reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
	                                $result_array ["reservations"] [$key] [$i] ["status"] = "new";
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                $k ++;
	                            } else {
	                                //$confirm_fail = 1;
	                                $reservationpush [$k] ["response"] = "failed";
	                                $reservationpush [$k] ["text"] = "undferror";
	                                $reservationpush [$k] ["status"] = "new";
	                                $reservationpush [$k] ["hms_reservation_id"] = 0;
	                                $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                                $reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
	                                $result_array ["reservations"] [$key] [$i] ["status"] = "new";
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                $k ++;
	                            }
	                        }
	                    }else{
	                        /*
	                         * UPDATE RESERVATION BLOCK
	                         *
	                         */
	
	                        // ==== START перевірка чексуми ========
	                        $checksum_db = $this->get_reservation_checksum($hms_reservation_id);
	                        $checksum_dc = $reservations [$i] ["checksum_md5"];
	                         
	                        if($checksum_db == $checksum_dc){
	                            if(isset($otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]])){
	                                $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                            }
	                             
	                            $reservationpush [$k] ["response"] = "skip";
	                            $reservationpush [$k] ["status"] = "modified";
	                            $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                            $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"] ["dc_reservationid"];
	                            $result_array ["reservations"] [$key] [$i] ["status"] = "skip";
	                            $k ++;
	                            // die();
	                            continue;
	                        }
	                        // ==== END перевірка чексуми ========
	                         
	                        $reservation_data = $this->frontdesk->GetReservation ( $hms_reservation_id );
	
	                        //$reservation_data ["user"] = $xml_array ["reservations"] [$dc_reservationid] ["room"] [$cell ["dc_roomreservation_id"]] ["reservation"] ["user"];
	                        $reservation_data ["firstname"] = $reservations [$i] ["guest"] ["firstname"];
	                        $reservation_data ["lastname"] = $reservations [$i] ["guest"] ["lastname"];
	                        $reservation_data ["phone"] = $reservations [$i] ["guest"] ["phone"];
	                        $reservation_data ["email"] = $reservations [$i] ["guest"] ["email"];
	
	                        $reservation_data ["amount"] = $reservations [$i] ["reservation"] ["amount"];
	                        $reservation_data ["discount"] = $reservations [$i] ["reservation"] ["discount"];
	                        $reservation_data ["date"] = $reservations [$i] ["reservation"] ["date"];
	                        $reservation_data ["add_places"] = $reservations [$i] ["reservation"] ["add_places"];
	                        $reservation_data ["baby_places"] = $reservations [$i] ["reservation"] ["baby_places"];
	                        $reservation_data ["datein"] = $reservations [$i] ["reservation"] ["datein"];
	                        $reservation_data ["dateout"] = $reservations [$i] ["reservation"] ["dateout"];
	                        $reservation_data ["checkintime"] = $reservations [$i] ["reservation"] ["checkintime"];
	                        $reservation_data ["checkouttime"] = $reservations [$i] ["reservation"] ["checkouttime"];
	
	
	                        //$reservation_data ["type_id"] = $reservations [$i] ["reservation"] ["type_id"];
	                        $reservation_data ["price_type"] = $reservations [$i] ["reservation"] ["price_type"];
	                        $reservation_data ["guest_id_new"] = 0;
	                        $reservation_data ["free_places"] = 0;
	                        $reservation_data ["maid_description"] = "";
	                        $reservation_data ["isread"] = 0;
	                        $reservation_data ["dc_guestname"] = $reservations [$i] ["reservation"] ["dc_guestname"];
	                        $reservation_data ["dc_currencycode"] = $reservations [$i] ["reservation"] ["dc_currencycode"];
	                        $reservation_data ["dc_countrycode"] = $reservations [$i] ["reservation"] ["dc_countrycode"];
	                        $reservation_data ["dc_city"] = $reservations [$i] ["reservation"] ["dc_city"];
	                        $reservation_data ["dc_customerremarks"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
	                        $reservation_data ["dc_roomremarks"] = $reservations [$i] ["reservation"] ["dc_roomremarks"];
	                        $reservation_data ["dc_numberofguest"] = $reservations [$i] ["reservation"] ["dc_numberofguest"];
	                        $reservation_data ["dc_totalprice"] = $reservations [$i] ["reservation"] ["dc_totalprice"];
	                        $reservation_data ["smoking"] = $reservations [$i] ["reservation"] ["smoking"];
	
	                        $reservation_data ["description"] = $reservations [$i] ["reservation"] ["dc_customerremarks"];
	
	                        $reservation_data ["dc_date"] = $reservations [$i] ["reservation"] ["dc_date"];
	                        $reservation_data ["dc_time"] = $reservations [$i] ["reservation"] ["dc_time"];
	                        $reservation_data ["dc_updatetime"] = $reservations [$i] ["reservation"] ["dc_updatetime"];
	
	                        $reservation_data ["early_check_in_close"] = $reservations [$i] ["reservation"] ["early_check_in_close"];
	                        $reservation_data ["late_check_out_close"] = $reservations [$i] ["reservation"] ["late_check_out_close"];
	
	
	                        //=============================================================================
	                        if ($autoclosedaychicho == 1) {
	                            $str_checkintime = strtotime ( $reservations [$i] ["reservation"] ["checkintime"] );
	                            $str_checkouttime = strtotime ( $reservations [$i] ["reservation"] ["checkouttime"] );
	
	                            $system_checkouttime = strtotime ( $checkin_checkout_arr ["checkouttime"] );
	                            $system_checkintime = strtotime ( $checkin_checkout_arr ["checkintime"] );
	
	                            if ($str_checkintime < $system_checkouttime) {
	                                $reservation_data ["early_check_in_close"] = 1;
	                            }
	                            if ($str_checkouttime > $system_checkouttime) {
	                                $reservation_data ["late_check_out_close"] = 1;
	                            }
	                        }
	                        //=============================================================================
	                        // print_r($reservation_data);
	
	                        if ($reservation_data ["type_id"] == $type_id) {
	                            $can_resize = $this->frontdesk->qd_canresize($hms_reservation_id, $datein, $dateout, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"]  );
	                        } else {
	                            $can_resize = 0;
	                            $reservation_data ["type_id"] = $type_id;
	                        }
	
	                        if($can_resize == 1){
	
	                            $this->service_model->DeleteServicesDc($hms_reservation_id);
	                            $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	                             
	                             
	                             
	                            if(isset($otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]])){
	                                $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                            }
	                            if ($update_res == "FreeError") {
	                                //$confirm_fail = 1;
	                                $reservationpush [$k] ["response"] = "error";
	                                $reservationpush [$k] ["text"] = "";
	                                $reservationpush [$k] ["status"] = "modified";
	                                $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
	                                $result_array ["reservations"] [$key] [$i] ["status"] = "modified";
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
	                                $k ++;
	                            }else{
	                                // ==== фіксація чексуми для бронювання в базіданих ====
	                                $data_checksum = array();
	                                $data_checksum ['hms_reservation_id'] = $hms_reservation_id;
	                                $data_checksum ['checksum'] = $reservations [$i] ["checksum"];
	                                $data_checksum ['checksum_md5'] = $reservations [$i] ["checksum_md5"];
	                                $this->update_reservation_checksum($data_checksum);
	                                // 	                                list($event_id, $object_id, $counter_id) = explode("_", $reservation_data["dc_uuid"]);
	                                // 	                                $connection_data = array();
	                                // 	                                $connection_data ['object_id'] = $object_id;
	                                // 	                                $connection_data ['event_id'] = $event_id;
	                                // 	                                $connection_data ['counter_id'] = $counter_id;
	                                // 	                                $connection_data ['hms_res_id'] = $hms_reservation_id;
	                                // 	                                $connection_data ['date'] = $reservation_data["dc_date"];
	                                // 	                                $connection_data ['state'] = 0;
	                                // 	                                $this->insert_reservation_connections ( $connection_data );
	                                 
	                                $reservationpush [$k] ["response"] = "ok";
	                                $reservationpush [$k] ["text"] = "";
	                                $reservationpush [$k] ["alert"] = "";
	                                $reservationpush [$k] ["status"] = "modified";
	                                $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
	                                $result_array ["reservations"] [$key] [$i] ["status"] = "modified";
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
	                                $k ++;
	                            }
	                        }else{
	                            if ($type_id == 0 or $type_id == "") {
	                                $query2 = $this->db->query ( "SELECT int_value FROM  dc_sutochno_xml_cfg WHERE name LIKE 'overbooking_category_id'" );
	                                if ($query->num_rows () > 0) {
	                                    $row2 = $query2->row ();
	                                    $type_id = $row2->int_value;
	                                }
	                            }
	                            if ($type_id == 0 or $type_id == "") {
	                                //$confirm_fail = 1;
	                                $reservationpush [$k] ["response"] = "error";
	                                $reservationpush [$k] ["text"] = "UNKNOWN CATEGORY";
	                                $reservationpush [$k] ["status"] = "modified";
	                                $reservationpush [$k] ["hms_reservation_id"] = $row->id;
	                                $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                                $result_array ["reservations"] [$key] [$i] ["status"] = "modified";
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                $k ++;
	                            } else {
	                                $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $type_id, 0, 0, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"] );
	                                if ($room_id == 0) {
	
	                                    if (isset ( $overbooking_category_id )) {
	                                        $reservations [$i] ["reservation"] ["origin_categoryid"] = $type_id;
	                                        $room_id = $this->frontdesk->getfreeroomlist ( $datein, $dateout, $overbooking_category_id, 0, 0, $reservation_data ["early_check_in_close"], $reservation_data ["late_check_out_close"] );
	
	                                        $insert_over_room_bool = 0;
	                                        if ($room_id == 0) {
	                                            $room_id = $this->dc_model->dc_make_overbooking_room ( $overbooking_category_id );
	                                            $insert_over_room_bool = 1;
	                                        }
	                                    } else {
	                                        //$confirm_fail = 1;
	                                        $reservationpush [$k] ["response"] = "failed";
	                                        $reservationpush [$k] ["text"] = "no overbooking_category_id";
	                                        $reservationpush [$k] ["status"] = "new";
	                                        $reservationpush [$k] ["hms_reservation_id"] = 0;
	                                        $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["dc_reservationid"];
	                                        $reservationpush [$k] ["dc_room_id"] = $reservations [$i] ["reservation"] ["category_id"];
	                                        $result_array ["reservations"] [$key] [$i] ["status"] = "new";
	                                        $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = $reservationpush [$k] ["text"];
	                                        $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                        $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    }
	                                }
	                                $reservation_data ["room_id"] = $room_id;
	
	                                $this->service_model->DeleteServicesDc($hms_reservation_id);
	                                $update_res = $this->frontdesk->UpdateReservation ( $reservation_data, 0, 1 );
	
	                                if(isset($otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]])){
	                                    $otelms_rooms [$reservations [$i]["reservation"] ["dc_uuid"]]["status"] = 1;
	                                }
	
	                                if ($update_res == "FreeError") {
	                                    //$confirm_fail = 1;
	                                    $reservationpush [$k] ["response"] = "error";
	                                    $reservationpush [$k] ["text"] = "";
	                                    $reservationpush [$k] ["status"] = "modified";
	                                    $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    $result_array ["reservations"] [$key] [$i] ["status"] = "modified";
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
	                                    $k ++;
	                                }else{
	                                    // ==== фіксація чексуми для бронювання в базіданих ====
	                                    $data_checksum = array();
	                                    $data_checksum ['hms_reservation_id'] = $hms_reservation_id;
	                                    $data_checksum ['checksum'] = $reservations [$i] ["checksum"];
	                                    $data_checksum ['checksum_md5'] = $reservations [$i] ["checksum_md5"];
	                                    $this->update_reservation_checksum($data_checksum);
	                                    // 	                                    list($event_id, $object_id, $counter_id) = explode("_", $reservation_data["dc_uuid"]);
	                                    // 	                                    $connection_data = array();
	                                    // 	                                    $connection_data ['object_id'] = $object_id;
	                                    // 	                                    $connection_data ['event_id'] = $event_id;
	                                    // 	                                    $connection_data ['counter_id'] = $counter_id;
	                                    // 	                                    $connection_data ['hms_res_id'] = $hms_reservation_id;
	                                    // 	                                    $connection_data ['date'] = $reservation_data["dc_date"];
	                                    // 	                                    $connection_data ['state'] = 0;
	                                    // 	                                    $this->insert_reservation_connections ( $connection_data );
	                                     
	                                    $reservationpush [$k] ["response"] = "ok";
	                                    $reservationpush [$k] ["text"] = "";
	                                    $reservationpush [$k] ["alert"] = "";
	                                    $reservationpush [$k] ["status"] = "modified";
	                                    $reservationpush [$k] ["hms_reservation_id"] = $hms_reservation_id;
	                                    $result_array ["reservations"] [$key] [$i] ["status"] = "modified";
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["reservation_alert"] = "";
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["hms_reservation_id"] = $reservationpush [$k] ["hms_reservation_id"];
	                                    $result_array ["reservations"] [$key] [$i] ["reservation"] ["url"] = "https://" . $host . "/reservations/ReservationViewForm/" . $reservationpush [$k] ["hms_reservation_id"];
	                                    $reservationpush [$k] ["dc_reservationid"] = $reservations [$i] ["reservation"]["dc_reservationid"];
	                                    $k ++;
	                                }
	                            }
	                        }
	                    }
	                }
	                // }
	
	            }
	
	            //echo "=======================================";
	            /* if (isset ( $otelms_rooms [$dc_reservationid] ) && false) {
	             foreach ( $otelms_rooms [$dc_reservationid] as $cell ) {
	             if ($cell ["status"] == 0) {
	             $status = 5;
	             $data_cancel = array ();
	             $data_cancel ["res_id"] = $cell ["otelms_reservation_id"];
	             $data_cancel ["charge"] = 0;
	             $data_cancel ["status"] = $status;
	             $data_cancel ["description"] = "cancel from sutochno";
	             $data_cancel ["guestbe_request"] = 0;
	             $data_cancel ["user"] = - 1;
	             // ====================
	             $this->Cancel->Insert ( $data_cancel );
	             }
	             }
	             } */
	
	        }
	         
	        print_r ( $otelms_rooms );
	        //die();
	         
	        foreach ( $otelms_rooms as $cell ) {
	            if ($cell ["status"] == 0) {
	                $status = 5;
	                $data_cancel = array ();
	                $data_cancel ["res_id"] = $cell ["otelms_reservation_id"];
	                $data_cancel ["charge"] = 0;
	                $data_cancel ["status"] = $status;
	                $data_cancel ["description"] = "";
	                $data_cancel ["guestbe_request"] = 0;
	                $data_cancel ["user"] = - 1;
	                // ====================
	                $this->Cancel->Insert ( $data_cancel, true, 0, 1 );
	                 
	                $reservationpush [$k] ["response"] = "ok";
	                $reservationpush [$k] ["text"] = "";
	                $reservationpush [$k] ["status"] = "cancel";
	                $reservationpush [$k] ["hms_reservation_id"] = $cell ["otelms_reservation_id"];
	                $reservationpush [$k] ["dc_reservationid"] = $cell ["dc_reservationid"];
	                $k ++;
	            }
	        }
	         
	        //print_r ( $result_array );
	        //die();
	
	        $hotel_name = "";
	        $query = $this->db->query("SELECT * FROM logo");
	        if ($query->num_rows() > 0) {
	            $row = $query->row();
	            $hotel_name = stripslashes($row->logo_title);
	        }
	        //die();
	        $counter_r = 0;
	        $new_mass = array ();
	        foreach ( $result_array ["reservations"] as $cell ) {
	            $res_count = count ( $cell );
	            for($i = 0; $i < $res_count; $i ++) {
	                if ($cell [$i] ["status"] == "modified" or $cell [$i] ["status"] == "new") {
	                    $new_mass ['dcname'] = "Sutochno";
	                    $new_mass ['status'] = $cell [$i] ["status"];
	                    $new_mass ['dc_reservationid'] = $cell [$i] ["reservation"]["dc_reservationid"];
	                    $new_mass ['dc_channel_name'] = "Sutochno";
	                    $new_mass ['hotel_name'] = $hotel_name;
	                    // 	                    $new_mass ['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
	                    // 	                    $new_mass ['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
	                    // 	                    $new_mass ['guest_phone'] = $cell [$i] ["guest"] ["phone"];
	                    // 	                    $new_mass ['guest_email'] = $cell [$i] ["guest"] ["email"];
	
	                    $new_mass ["room"] [$counter_r]['guest_firstname'] = $cell [$i] ["guest"]  ["firstname"];
	                    $new_mass ["room"] [$counter_r]['guest_lastname'] = $cell [$i] ["guest"]  ["lastname"];
	                    $new_mass ["room"] [$counter_r]['guest_phone'] = $cell [$i] ["guest"] ["phone"];
	                    $new_mass ["room"] [$counter_r]['guest_email'] = $cell [$i] ["guest"] ["email"];
	                     
	                    $new_mass ["room"] [$counter_r]["reservation_current"] = $i;
	                    $new_mass ["room"] [$counter_r]["reservation_alert"] = $cell [$i] ["reservation"] ["reservation_alert"];
	                    $new_mass ["room"] [$counter_r]["hms_reservation_id"] = $cell [$i] ["reservation"] ["hms_reservation_id"];
	                    $new_mass ["room"] [$counter_r]["url"] = $cell [$i] ["reservation"] ["url"];
	                    $new_mass ["room"] [$counter_r]["dc_channel_name"] = "Sutochno";
	
	                    $new_mass ["room"] [$counter_r]["reservation_dc_reservationid"] = $cell [$i] ["reservation"] ["dc_reservationid"];
	                    $new_mass ["room"] [$counter_r]["reservation_dc_roomreservation_id"] = $cell [$i] ["reservation"] ["dc_roomreservation_id"];
	                    $new_mass ["room"] [$counter_r]["hotel_name"] = "hotel_name";
	                    $new_mass ["room"] [$counter_r]["reservation_date"] = $cell [$i] ["reservation"]["date"];
	                    $new_mass ["room"] [$counter_r]["status"] = $cell [$i] ["status"];
	                    $new_mass ["room"] [$counter_r]["reservation_datein"] = $cell [$i] ["reservation"]["datein"];
	                    $new_mass ["room"] [$counter_r]["reservation_dateout"] = $cell [$i] ["reservation"]["dateout"];
	                    $new_mass ["room"] [$counter_r]["reservation_type_name"] = $cell [$i] ["reservation"]["reservation_type_name"];
	                    $new_mass ["room"] [$counter_r]["reservation_category_id"] = $cell [$i] ["reservation"]["type_id"];
	                    $new_mass ["room"] [$counter_r]["reservation_dc_totalprice"] = $cell [$i] ["reservation"]["dc_totalprice"];
	                    $new_mass ["room"] [$counter_r]["reservation_dc_customerremarks"] = $cell [$i] ["reservation"]["dc_customerremarks"];
	
	                    $new_mass ["room"] [$counter_r]["dc_rate_intdate_data"] = $cell [$i] ["per_day"];
	
	                    $counter_r++;
	                }
	            }
	
	        }
	        //print_r($new_mass);
	        //die();
	        if(count($new_mass) > 0){
	            //print_r($new_mass);
	            $this->dc_model->send_notifyarray_new ( $new_mass, $debug );
	        }
	
	    }else{
	        // якщо дані від каналу пусті
	        if($object_id != ""){
	            // === вибираємо всі бронювання категорії $object_id, дата заїзду в яких, більша за поточну дату і видаляємо їх ==
	            $this->db->select('id, dc_reservationid');
	            $this->db->where("deleted = 0 AND cancel = 0 AND dc_id = 30 AND dc_uuid LIKE '%".$object_id."%' AND datein >= '".$date_today."'");
	            $query = $this->db->get('deskofreservation');
	            foreach ($query->result_array() as $row) {
	                $status = 5;
	                $data_cancel = array ();
	                $data_cancel ["res_id"] = $row ["id"];
	                $data_cancel ["charge"] = 0;
	                $data_cancel ["status"] = $status;
	                $data_cancel ["description"] = "";
	                $data_cancel ["guestbe_request"] = 0;
	                $data_cancel ["user"] = - 1;
	                // ====================
	                $this->Cancel->Insert ( $data_cancel, true, 0, 1 );
	                 
	                $reservationpush [$k] ["response"] = "ok";
	                $reservationpush [$k] ["text"] = "";
	                $reservationpush [$k] ["status"] = "cancel";
	                $reservationpush [$k] ["hms_reservation_id"] = $row ["id"];
	                $reservationpush [$k] ["dc_reservationid"] = $row ["dc_reservationid"];
	                $k ++;
	            }
	        }
	    }
	
	
	    //echo "<pre>";
	    //echo "\n\n --- XML reservationpush START --- \n\n";
	    //print_r ( $reservationpush );
	    //echo "\n\n --- XML reservationpush END --- \n\n";
	    //die();
	    foreach ( $reservationpush as $arg ) {
	        if ($arg ['status'] == "cancel") {
	            $data = array ();
	            $data ["hms_reservation_id"] = $arg ["hms_reservation_id"];
	            $data ['response'] = $arg ['response'];
	            $data ['resid'] = $arg ['dc_reservationid'];
	            $data ['dcname'] = "Sutochno";
	            $data ['status'] = $arg ['status'];
	            $data ['text'] = $arg ['text'];
	            $data ['host'] = $host;
	            $this->dc_model->send_notifyarray ( $data, $debug );
	        }
	    }
	    return json_encode($reservationpush, true);
	}
	
	function get_reservation_checksum($hms_reservation_id){
	    $checksum_md5 = "";
	    $result = $this->db->select('checksum_md5')->get_where('dc_sutochno_bookings_checksum', array('hms_reservation_id' => $hms_reservation_id))->row_array();
	    if(isset($result['checksum_md5'])){
	        $checksum_md5 = $result['checksum_md5'];
	    }
	    return $checksum_md5;
	}
	
	function set_reservation_checksum($data){
	    $this->db->insert('dc_sutochno_bookings_checksum', $data);
	}
	

	function update_reservation_checksum($data){
	    $this->db->where('hms_reservation_id', $data['hms_reservation_id']);
	    $this->db->update('dc_sutochno_bookings_checksum', array('checksum' => $data['checksum'], 'checksum_md5' => $data['checksum_md5']));
	}
	
	function dc_rate_intdate_insert($data) {
	    $count = count ( $data );
	    if ($count != 0) {
	        foreach ( $data as $cell ) {
	            $query = $this->db->query ( "DELETE FROM dc_sutochno_rate_intdate WHERE dc_reservation_id LIKE '" . $cell ["dc_reservation_id"]."'" );
	            break;
	        }
	        foreach ( $data as $cell ) {
	            $sql = "INSERT INTO dc_sutochno_rate_intdate (dc_reservation_id, dc_rate_id, intdate, price) VALUES('" . $cell ["dc_reservation_id"] . "',
		'" . $cell ["dc_rate_id"] . "', '" . $cell ["intdate"] . "', '" . $cell ["price"] . "')
		ON DUPLICATE KEY UPDATE price = '" . $cell ["price"] . "'";
	            // echo $sql;
	            $query = $this->db->query ( $sql );
	        }
	    }
	}
	
	function dc_sutochno_clear_reservation ($dc_reservation_id){
	
	    $reservation_id = $this->db->select('id')->get_where('deskofreservation', array('dc_reservationid'=>$dc_reservation_id, 'dc_id'=>30))->row()->id;
	
	    $fake_dc_reservationid = rand(0, 9999);
	    $fake_dc_roomreservation_id = rand(0, 9999);
	    $fake_dc_uuid = rand(0, 9999)."-dc_uuid";
	    $this->db->query("UPDATE deskofreservation SET dc_reservationid = $fake_dc_reservationid,
	        dc_roomreservation_id = $fake_dc_roomreservation_id, dc_uuid = '$fake_dc_uuid' WHERE dc_reservationid = $dc_reservation_id AND dc_id = 30");
	
	    // CANCEL
	    $cancel_data = array();
	    $cancel_data ['res_id'] = $reservation_id;
	    $cancel_data ['charge'] = 0;
	    $cancel_data ['user'] = $_SESSION['user']['id'];
	    $cancel_data ['description'] = "";
	    $return_page = 3; // не робити die
	    $this->Cancel->Insert($cancel_data, true, $return_page);
	    
	    // clear checksum
	    $this->db->query("DELETE FROM dc_sutochno_bookings_checksum WHERE hms_reservation_id = '$reservation_id'");
	}
}
?>