<?php 
class dcm_expedia_v2 extends dcm_abstract {
    public function __construct() {
        parent::__construct();
        
        $this->dc_id = 3;
        $this->overbooking_category_id = $this->get_dc_overbooking_category_id();
        
        $this->table_name_r2c = "dc_expedia_rate2category_link";
        $this->table_name_dc_category2occupancy = "dc_expedia_category2occupancy";
        $this->table_name_dc2hms_category_link = "dc_expedia_room_categories_link";
        
        $this->sql_r2r = "SELECT dc_rate_id as dc_rate_id, dc_category_id as dc_category_id, hms_restrict_id FROM  dc_expedia_rate2restrict where hms_restrict_id  > 0";
        
        $this->sql_category2rate = "select 
dc_expedia_room_categories.id as dc_category_id, dc_expedia_room_categories.dc_hotel_id,
dc_expedia_room_categories.name as dc_category_name,
dc_expedia_rates.rate_id as dc_rate_id, dc_expedia_rates.dc_hotel_id as rate_dc_hotel_id,
dc_expedia_rates.name as dc_rate_name, 
dc_expedia_category2occupancy.hms_occupancy_id as hms_occupancy_id, 
dc_expedia_occupancy.name as hms_occupancy_name, 
categories.id as hms_category_id,
categories.name as hms_category_name,
dc_expedia_rate2category_link.hms_rate_id as hms_rate_id,	
dc_expedia_rate2category_link.hms_restrict_id as hms_restrict_id, 	
dc_expedia_rate2category_link.hms_price_func_id as hms_price_func_id,
categories.add_places as cat_max_places, categories.places as cat_base_places

from dc_expedia_room_categories
inner join dc_expedia_rates on dc_expedia_rates.room_category = dc_expedia_room_categories.id
inner join dc_expedia_category2occupancy 
	on dc_expedia_category2occupancy.dc_category_id = dc_expedia_room_categories.id
inner join dc_expedia_occupancy 
	on dc_expedia_occupancy.id = dc_expedia_category2occupancy.hms_occupancy_id 
inner join dc_expedia_room_categories_link 
	on dc_expedia_room_categories_link.dc_category_id = dc_expedia_room_categories.id
inner join categories 
	on categories.id = dc_expedia_room_categories_link.hms_category_id
left join dc_expedia_rate2category_link
    on (dc_expedia_rate2category_link.dc_rate_id = dc_expedia_rates.rate_id 
    AND  dc_expedia_rate2category_link.dc_category_id = dc_expedia_rates.room_category
    AND  dc_expedia_rate2category_link.hms_occupancy_id = dc_expedia_category2occupancy.hms_occupancy_id) 
";
        
        $this->sql_dc_rates = "select  dc_rate_id as dc_rate_id, name as dc_rate_name, active from dc_expedia_rates";
        $this->sql_dc_category_link = "select dc_expedia_room_categories.name as dc_category_name, categories.name as hms_category_name,
            dc_expedia_room_categories_link.dc_category_id,
            hms_category_id as hms_category_id
            from dc_expedia_room_categories_link
            inner join dc_expedia_room_categories on dc_expedia_room_categories.id = dc_expedia_room_categories_link.dc_category_id
 
            LEFT join categories on categories.id = dc_expedia_room_categories_link.hms_category_id";
        $this->sql_dc_r2c = "select dc_rate_id as dc_rate_id,
            dc_category_id as dc_category_id,
            hms_rate_id as hms_rate_id,
            hms_price_func_id as hms_price_func_id,
            hms_restrict_id as hms_restrict_id,
            hms_occupancy_id as hms_occupancy_id
            from dc_expedia_rate2category_link";
        
       /* $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_expedia_occupancy ORDER BY id ASC";
          */
        
        $this->sql_get_occupancies = "select id as hms_occupancy_id,
           name as hms_occupancy_name from dc_expedia_occupancy ORDER BY id ASC";
        
        $this->sql_get_category_occupancies = "SELECT dc_expedia_category2occupancy.hms_occupancy_id,
        dc_expedia_category2occupancy.dc_category_id as roomcategory, dc_expedia_occupancy.name as hms_occupancy_name 
        FROM dc_expedia_category2occupancy
        INNER JOIN dc_expedia_occupancy ON dc_expedia_occupancy.id = dc_expedia_category2occupancy.hms_occupancy_id";
        
        $this->sql_build_hms_categories = "select id as hms_category_id,
            name as hms_category_name from categories";
        
        $this->sql_dc_category_list = "select name as dc_category_name,
            id as dc_category_id, active, dc_hotel_id from dc_expedia_room_categories";
        $this->sql_dc_category2occupancy_list = "select dc_category_id as dc_category_id,
            hms_occupancy_id as hms_occupancy_id from dc_expedia_category2occupancy";
        $this->form_action_c2o_post = "/dc_expedia/categories_edit_post_v2";
        $this->form_action_r2c_post = "/dc_expedia/rates_edit_post_v2";
        
        $this->form_action_c2o_post_c2 = "/dc_expedia_c2/categories_edit_post_v2";
        $this->form_action_r2c_post_c2 = "/dc_expedia_c2/rates_edit_post_v2";
    }
    
    function category2occupancy_save_expedia($c2o)
    {
    	$this->db->query("delete from " . $this->table_name_dc_category2occupancy);
    	foreach ($c2o as $dc_category_id => $cell) {
    		$sql = "insert into " . $this->table_name_dc2hms_category_link . "  (dc_category_id, hms_category_id) values
    		($dc_category_id, " . $cell['hms_category_id'] . ") on duplicate key update
                hms_category_id=" . $cell['hms_category_id'] . " ";
    		// echo $sql . "\n";
    		$this->db->query($sql);
    		if (isset($cell['occupancies'])) {
    			foreach ($cell['occupancies'] as $key => $state) {
    				$sql = "insert into " . $this->table_name_dc_category2occupancy . " (dc_category_id, hms_occupancy_id)
                    values (" . $dc_category_id . ", " . $key . ") on duplicate key update
                        dc_category_id = " . $dc_category_id . ", hms_occupancy_id = " . $key . "";
    				$this->db->query($sql);
    			}
    		}
    	}
    }
}
?>