<?php
class Dcm_booking_promotions extends CI_model{
    public function __construct() {

    }

    function get_auth_headers() {
    	$dc_user = $this->config->item ( 'dc_booking_xml_user' );
    	$dc_password = html_entity_decode ($this->config->item ( 'dc_booking_xml_pwd' ));
    	$auth = $dc_user . ":" . $dc_password;
    	
    	if ($this->config->item('booking_version') == 1) {
    	    $headers = array('Authorization: Basic ' . base64_encode($auth), 'Accept-Version: 1.1',
    	        'Content-Type: application/xml');
    	}else{
    	   $headers = array('Authorization: Basic ' . base64_encode($auth));
        }
    	return $headers;
    }

    function get_properties_ids(){
    	$res_arr = array();
    	$ids_arr = $this->db->select('int_value')->get_where('dc_booking_xml_cfg', array('name'=>'hotel_id'))->result_array();
    	foreach ($ids_arr as $val) {
    		array_push($res_arr, $val['int_value']);
    	}
    	return $res_arr;
    }

    function get_weekdays_arr() {
		$res_arr = array (
				'Mon' => array (
						'val' => 'Mon',
						'name_clt' => "{mlw_full_monday}",
						'selected' => ""
				),
				'Tue' => array (
						'val' => 'Tue',
						'name_clt' => "{mlw_full_tuesday}",
						'selected' => ""
				),
				'Wed' => array (
						'val' => 'Wed',
						'name_clt' => "{mlw_full_wednesday}",
						'selected' => ""
				),
				'Thu' => array (
						'val' => 'Thu',
						'name_clt' => "{mlw_full_thursday}",
						'selected' => ""
				),
				'Fri' => array (
						'val' => 'Fri',
						'name_clt' => "{mlw_full_friday}",
						'selected' => ""
				),
				'Sat' => array (
						'val' => 'Sat',
						'name_clt' => "{mlw_full_saturday}",
						'selected' => ""
				),
				'Sun' => array (
						'val' => 'Sun',
						'name_clt' => "{mlw_full_suanday}",//sUandey....в словнику тре поправити
						'selected' => ""
				),
		);
		return $res_arr;
    }

    function retreive_roomrates($dc_hotel_id){
    	if( $dc_hotel_id == null ){exit('Please provide a property');}
    	$dc_user = $this->config->item ( 'dc_booking_xml_user' );
    	$dc_password = $this->config->item ( 'dc_booking_xml_pwd' );
        $url = $this->config->item('dc_booking_xml_host') .'hotels/xml/roomrates';
        
    	$request =	<<<EOT
<request>
<username>$dc_user</username>
<password>$dc_password</password>
<hotel_id>$dc_hotel_id</hotel_id>
<show_rates_status>0</show_rates_status>
<version>1.0</version>
</request>
EOT;

    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    	curl_setopt($ch, CURLOPT_URL, $url);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
    	curl_setopt($ch, CURLOPT_POST, true);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    	if ($this->config->item('booking_version') == 1) {
    	    $headers = array(
    	        'Accept-Version: 1.1',
    	        'Authorization: Basic THVjLVNhbXVlbMblhWTdlOCghQ29qaU9pNmxlWSpIWXU9OigvS2meQpQ12puj',
    	        'Content-Type: application/xml'
    	    );
    	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	}
    	curl_setopt($ch, CURLOPT_VERBOSE, true);
    	
    	$response = curl_exec($ch);
    	curl_close($ch);
     	$response = json_decode(json_encode(simplexml_load_string($response)), true);
    	return $response;

    }

    function get_rooms_rates_arrs($dc_hotel_id) {
        $res_arr['rooms'] = $res_arr['rates'] = $res_arr = array();
    	$response = $this->retreive_roomrates($dc_hotel_id);
    	$rooms_arr = $response;
    	if (!isset($response['room'][0])){// only 1 room
    		$rooms_arr = array();
    		$rooms_arr['room'][0] = $response['room'];
    	}
    	foreach ($rooms_arr['room'] as $room) {
			$res_arr ['rooms'] [$room ['@attributes'] ['id']] = array (
					'id' => $room ['@attributes'] ['id'],
					'name' => $room ['@attributes'] ['room_name'],
					'selected' => ""
			);
			$rates_arr = $room['rates']['rate'];
			if (!isset($room['rates']['rate'][0])){// only 1 rate
				$rates_arr = array();
				$rates_arr[0] = $room['rates']['rate'];
			}
			foreach ($rates_arr as $rate) {
				$res_arr ['rates'] [$rate ['@attributes'] ['id']] = array (
						'id' => $rate ['@attributes'] ['id'],
						'name' => $rate ['@attributes'] ['rate_name'],
						'selected' => ""
				);
			}
    	}
    	return $res_arr;
    }

    function get_hours_arr() {
    	$hours_arr = array();
    	for ($i = 0; $i <= 24; $i++) {
    		$hours_arr[$i] = array('val'=>$i, 'str'=>$i.":00", 'selected' => "");
    	}
    	return $hours_arr;
    }

    function get_promotion_types_arr($concrete_promotion_type="") {
        $res_arr = array(
            'basic' => array(
                'val' => 'basic',
                'name_clt' => "{caption_basic}",
                'selected' => ""
            ),
            'last_minute' => array(
                'val' => 'last_minute',
                'name_clt' => "{caption_last_minute}",
                'selected' => ""
            ),
            'early_booker' => array(
                'val' => 'early_booker',
                'name_clt' => "{caption_early_booker}",
                'selected' => ""
            ),
            'business_booker' => array(
                'val' => 'business_booker',
                'name_clt' => "{caption_business_booker}",
                'selected' => ""
            ),
            'geo_rate' => array(
                'val' => 'geo_rate',
                'name_clt' => "{caption_geo_rate}",
                'selected' => ""
            ),
            'mobile_rate' => array(
                'val' => 'mobile_rate',
                'name_clt' => "{caption_mobile_rate}",
                'selected' => ""
            )
        );
		if ($concrete_promotion_type != "") {
            if ($concrete_promotion_type == "preset") {
                $res_arr['preset'] = array(
                    'val' => 'preset',
                    'name_clt' => "---",
                    'selected' => "selected"
                );
            } else {
                $res_arr = array(
                    $concrete_promotion_type => $res_arr[$concrete_promotion_type]
                );
            }
		}
		return $res_arr;
    }

    function get_target_channels_arr()
    {
        $res = array(
            'public' => array(
                'val' => 'public',
                'name_clt' => "{caption_public}",
                'class_for_choose' => 'basic last_minute early_booker',
                'selected' => ""
            ),
            'subscribers' => array(
                'val' => 'subscribers',
                'name_clt' => "{caption_subscribers}",
                'class_for_choose' => 'basic last_minute early_booker',
                'selected' => ""
            ),
            'china' => array(
                'val' => 'china',
                'name_clt' => "{caption_china}",
                'class_for_choose' => 'basic last_minute early_booker',
                'selected' => ""
            ),
            'app' => array(
                'val' => 'app',
                'name_clt' => "{clt_app_target}",
                'class_for_choose' => 'mobile_rate',
                'selected' => ""
            ),
            'all' => array(
                'val' => 'all',
                'name_clt' => "{clt_all_target}",
                'class_for_choose' => 'mobile_rate',
                'selected' => ""
            )
        );
        $geo_rate_promotion_targets_pos = $this->get_geo_rate_promotion_targets_pos();
        foreach ($geo_rate_promotion_targets_pos as $geo_targets_pos) {
            $res[$geo_targets_pos] = array(
                'val' => $geo_targets_pos,
                'name_clt' => $geo_targets_pos, // maybe get translated country names?
                'class_for_choose' => 'geo_rate',
                'selected' => ""
            );
        }
        return $res;
    }

    public function get_geo_rate_promotion_targets_pos () {
        return array(
            'algeria_pos',
            'argentina_pos',
            'australia_pos',
            'algeria_pos',
            'belarus_pos',
            'brazil_pos',
            'canada_pos',
            'chile_pos',
            'colombia_pos',
            'domestic_pos',
            'eu_pos',
            'hong_kong_pos',
            'india_pos',
            'indonesia_pos',
            'international_pos',
            'iran_pos',
            'israel_pos',
            'japan_pos',
            'kazakhstan_pos',
            'kuwait_pos',
            'malaysia_pos',
            'mexico_pos',
            'argentina_pos',
            'new_zealand_pos',
            'oman_pos',
            'pakistan_pos',
            'peru_pos',
            'philippines_pos',
            'qatar_pos',
            'russia_pos',
            'saudi_arabia_pos',
            'singapore_pos',
            'south_africa_pos',
            'south_korea_pos',
            'switzerland_pos',
            'taiwan_pos',
            'thailand_pos',
            'trinidad_&_tobago_pos',
            'turkey_pos',
            'ukraine_pos',
            'united_arab_emirates_pos',
            'united_states_pos',
            'vietnam_pos'
        );
    }

    function get_last_minute_units_arr() {
    	return array (
    			'day' => array (
    					'val' => 'day',
    					'name_clt' => "{mlw_day1}",
    					'selected' => ""
    			),
    			'hour' => array (
    					'val' => 'hour',
    					'name_clt' => "{mlw_hour}",
    					'selected' => ""
    			)
    	);
    }

    function save_promotion($prom_data) {
    	$dc_hotel_id				= $prom_data['dc_hotel_id'];
    	$promotion_id 				= $prom_data['promotion_id'] != "" ? 'id="'.$prom_data['promotion_id'].'"' : "";
    	$name 						= isset($prom_data['name']) ? $prom_data['name'] : "";
    	$type 						= $prom_data['type'];
    	$target_channel 			= isset($prom_data['target_channel']) ? $prom_data['target_channel'] : "";
    	$discount 					= (int)$prom_data['discount'];

    	$request = '';
    	$excluded_dates_str			= '';
    	if( $prom_data['excluded_dates'] != null ){
    	    $excluded_dates_str			= '<excluded_dates/>';
    	    $excluded_dates_str		= '<excluded_dates>';
    	    if( preg_match( '/,/' , $prom_data['excluded_dates']) ){
    	        $excluded_dates = explode(',', $prom_data['excluded_dates']);
    	        foreach( $excluded_dates as $v ){
    	            $excluded_dates_str	.= '<excluded_date>'.date('Y-m-d', strtotime(trim($v)) ).'</excluded_date>';
    	        }
    	    } else {
    	        $excluded_dates_str	.= '<excluded_date>'.date('Y-m-d', strtotime($prom_data['excluded_dates']) ).'</excluded_date>';
    	    }
    	    $excluded_dates_str		.= '</excluded_dates>';
    	}
    	switch ($type) {
            case "basic":
            case "early_booker":
            case "last_minute":
                $min_stay_through			= $prom_data['min_stay_through'];
                $non_refundable 			= isset($prom_data['non_refundable']) ? 1 : 0;
                $no_cc_promotion 			= isset($prom_data['no_cc_promotion']) ? 1 : 0;
                $book_date_str				= "";
                $last_minute_str			= "";
                $early_booker_str			= "";
                $book_time_str				= '<book_time/>';
                if (isset($prom_data['book_time_start']) && isset($prom_data['book_time_end'])){
                    $book_time_str				= '<book_time start="'.$prom_data['book_time_start'].'" end="'.$prom_data['book_time_end'].'"/>';
                }

                $stay_date 					= explode( ' - ', $prom_data['stay_date'] );
                $stay_date_start 			= date('Y-m-d', strtotime($stay_date[0]) );
                $stay_date_end 				= date('Y-m-d', strtotime($stay_date[1]) );

                $active_weekdays_str		= "<active_weekdays/>";
                if (isset($prom_data['active_weekday'])){
                    $active_weekdays_str = '<active_weekdays>';
                    foreach ($prom_data['active_weekday'] as $active_day) {
                        $active_weekdays_str .= "<active_weekday>$active_day</active_weekday>";
                    }
                    $active_weekdays_str .= '</active_weekdays>';
                }
                $additional_dates_str		= '<additional_dates/>';
                if( $prom_data['additional_dates'] != null ){
                    $additional_dates_str		= '<additional_dates>';
                    if( preg_match( '/,/' , $prom_data['additional_dates']) ){
                        $additional_dates = explode(',', $prom_data['additional_dates']);
                        foreach( $additional_dates as $v ){
                            $additional_dates_str	.= '<additional_date>'.date('Y-m-d', strtotime(trim($v)) ).'</additional_date>';
                        }
                    } else {
                        $additional_dates_str	.= '<additional_date>'.date('Y-m-d', strtotime($prom_data['additional_dates']) ).'</additional_date>';
                    }
                    $additional_dates_str		.= '</additional_dates>';
                }

                switch ($type) {
                    case "basic":
                        if (isset($prom_data['book_date']) && $prom_data['book_date'] != ""){
                            $book_date 			= explode(' - ', $prom_data['book_date']);
                            $book_date_start 	= date('Y-m-d', strtotime($book_date[0]) );
                            $book_date_end 		= date('Y-m-d', strtotime($book_date[1]) );
                            $book_date_str		= '<book_date start="'.$book_date_start.'" end="'.$book_date_end.'" />';
                        }else{
                            $book_date_str		= '<book_date/>';
                        }
                        break;
                    case "early_booker":
                        if(isset($prom_data['early_booker_value']) && $prom_data['early_booker_value'] != ""){
                            $early_booker_str   = '<early_booker value="'.$prom_data['early_booker_value'].'" />';
                        }
                        break;
                    case "last_minute":
                        if (isset($prom_data['last_minute_value']) && $prom_data['last_minute_value'] != ""){
                            $last_minute_str    = '<last_minute unit="'.$prom_data['last_minute_unit'].'" value="'.$prom_data['last_minute_value'].'"/>';
                        }
                        break;
                }

                $rooms = "";
                if (isset($prom_data['rooms'])){
                    foreach ($prom_data['rooms'] as $room) {
                        $rooms .= '<room id="'.$room.'"/>';
                    }
                }
                $parent_rates = "";
                if (isset($prom_data['parent_rates'])){
                    foreach ($prom_data['parent_rates'] as $parent_rate) {
                        $parent_rates .= '<parent_rate id="'.$parent_rate.'"/>';
                    }
                }
                $request = '<request>
						<hotel_id>'.$dc_hotel_id.'</hotel_id>
					    <promotion '.$promotion_id.'
					    		name="'.$name.'"
					    		type="'.$type.'"
					    		target_channel="'.$target_channel.'"
					    		min_stay_through="'.$min_stay_through.'"
					    		non_refundable="'.$non_refundable.'"
					    		no_cc_promotion="'.$no_cc_promotion.'">
					    	'.$last_minute_str.'
					    	'.$early_booker_str.
					    	$book_date_str.
					    	$book_time_str.
					    	'<stay_date start="'.$stay_date_start.'" end="'.$stay_date_end.'">'
					    	    .$active_weekdays_str
					    	    .$excluded_dates_str.
					    	    '</stay_date>'
					    	        .$additional_dates_str.
					    	        '<rooms>
						    	'.$rooms.'
        					</rooms>
        					<parent_rates>
						    	'.$parent_rates.'
        					</parent_rates>
						    <discount value="'.$discount.'" />
					    </promotion>
					</request>';
                break;
            case "geo_rate":
            case "mobile_rate":
            case "business_booker":
                $target_channel_str = ($type != 'business_booker') ? 'target_channel="'.$target_channel.'"' : '';
                $request = '<request>
        						<hotel_id>'.$dc_hotel_id.'</hotel_id>
        					    <promotion '.$promotion_id.' type="'.$type.'" '.$target_channel_str.'>
                                    <stay_date>
                                        '.$excluded_dates_str.'
                                    </stay_date>
                                    <discount value="'.$discount.'" />
        					    </promotion>
    					   </request>';
                break;
        }
    	$headers = $this->get_auth_headers();
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    	curl_setopt($ch, CURLOPT_URL, 'https://supply-xml.booking.com/hotels/xml/promotions');
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	curl_setopt($ch, CURLOPT_POST, true);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    	if ($this->config->item('booking_version') == 1) {
    	    $headers = array(
    	        'Accept-Version: 1.1',
    	        'Authorization: Basic THVjLVNhbXVlbMblhWTdlOCghQ29qaU9pNmxlWSpIWXU9OigvS2meQpQ12puj',
    	        'Content-Type: application/xml'
    	    );
    	    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	}
    	curl_setopt($ch, CURLOPT_VERBOSE, true);
    	$response = curl_exec($ch);
    	curl_close($ch);
    	$response = json_decode(json_encode(simplexml_load_string($response)), true);
    	if( ! isset( $response['id'] ) ){
    		$this->session->set_userdata ( array('header_msg_text' =>  $response['fault']['string']));
    	}
    }

    function delete_promotion_OLD($dc_hotel_id, $promotion_id){
    	if( $dc_hotel_id == null || $promotion_id == null ){ exit('Not sufficient data'); }
    	$headers = $this->get_auth_headers();
    	$url = 'https://supply-xml.booking.com/hotels/xml/promotions?id=' . $promotion_id . '&hotel_id=' .$dc_hotel_id;
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $url);
    	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
    	$response = curl_exec($ch);
    	curl_close($ch);
    	$response = json_decode(json_encode(simplexml_load_string($response)), true);
    	if( ! isset( $response['id'] ) ){ $this->session->set_userdata ( array('header_msg_text' =>  $response['fault']['string']));}
    }
    
    function delete_promotion($dc_hotel_id, $promotion_id){
        if( $dc_hotel_id == null || $promotion_id == null ){ exit('Not sufficient data'); }
        $headers = $this->get_auth_headers();
        $url = 'https://supply-xml.booking.com/hotels/xml/promotions?id=' . $promotion_id . '&hotel_id=' .$dc_hotel_id;
         
        // ------- LOG DATA --------<
        $request = 'DELETE';
         
        $request_log_data = array();
        $request_log_data ['request'] = $request;
        $request_log_data ['headers'] = $headers;
        $json_request = json_encode( $request_log_data );
        if ($this->config->item('loger_v2') == 1) {
        } else {
            $log_data = array(
                'request' => $json_request,
                'url' => $url
            );
            $this->db->insert('dc_booking_log', $log_data);
            $log_id = $this->db->insert_id();
        }
        // ------- LOG DATA -------->
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request);
        $timestart = microtime(true);
        $response = curl_exec($ch);
    
        $http_code = - 1;
         
        if (! curl_errno($ch)) {
            $info = curl_getinfo($ch);
            $http_code = $info['http_code'];
            if ($http_code == 500) {
                $response = "500, Internal Server Error" . $response;
            }
        }
        curl_close($ch);
         
        // ------- LOG DATA --------<
        $log_data = array(
            'response' => $response,
            'responseint' => $http_code,
            'stime' => (microtime(true) - $timestart)
        );
         
        if ($this->config->item('loger_v2') == 1) {
            $log_data ["request"] = $json_request;
            $log_data ["url"] = $url;
            $log_data ["dc_id"] = 1;
            $log_id = $this->loger_dc->SaveLog_v2($log_data);
        } else {
            $this->db->update('dc_booking_log', $log_data, array(
                'id' => $log_id
            ));
        }
         
        $this->Loger_admin->Save_SyncData ( "", "", $response, 1, 19, $log_id );
        // ------- LOG DATA -------->
         
        $response = json_decode(json_encode(simplexml_load_string($response)), true);
        if( ! isset( $response['id'] ) ){ $this->session->set_userdata ( array('header_msg_text' =>  $response['fault']['string']));}
    }

    function activate_promotion($dc_hotel_id, $promotion_id){
        $headers = $this->get_auth_headers();
        $request = "<request>
                        <hotel_id>$dc_hotel_id</hotel_id>
                         <promotion
                             id='$promotion_id'>
                         </promotion>
                     </request>";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://supply-xml.booking.com/hotels/xml/promotions');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
        $response = curl_exec($ch);
        curl_close($ch);
        $response = json_decode(json_encode(simplexml_load_string($response)), true);
        if( ! isset( $response['id'] ) ){ $this->session->set_userdata ( array('header_msg_text' =>  $response['fault']['string']));}
    }

}