<?php

class Reservation_import extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('htmltpl');
		$this->load->model('Authorization');
		$this->load->model('frontdesk');
		$this->Authorization->IsLogined();
		// libraries
		$this->load->library('Excel');
		$this->load->model('Reservation_import_model');
	}

	function read() {
		$data = array();
		$this->parser->parse('/reservation_import/reservation_import_read_view.php', $data);
	}

	function ajax_read() {
		// read excel file
		$inputFileName = $_FILES ? $_FILES['0']['tmp_name'] : false;
		if($inputFileName) {
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
			// get only the Cell Collection
			$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
			$highestColumm = $objPHPExcel->setActiveSheetIndex(0)->getHighestColumn();
			// extract to a PHP readable array format

			foreach($cell_collection as $cell) {
				$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
				$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
				$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getFormattedValue();
				if($row > '10') {
					// how many row we show
					break;
				}
				// The header will/should be in row 1 only. of course, this can be modified to suit your need.
				if($row == 1) {
					$header[] = array('head_name' =>$data_value);
					$colums[] = array('col_name' =>$column);
				} else {
					$arr_data[$row]['name'][] = array('val_name' =>$data_value);
				}
			}
			$data['headers'] = $header;
			$data['values'] = $arr_data;
			$data['colums'] = $colums;
			$data['columm_list'] = $this->Reservation_import_model->get_colummList();
			
			$this->mlanguages->getdictionary("reservations_reservationedit", "", $data);
			$this->mlanguages->getdictionary("modaldatacreate", "", $data);
			$this->mlanguages->getdictionary("mlw_order", "", $data);
			$content = $this->parser->parse('templates/reservation_import/ajax_show_table.html', $data, true);
			echo json_encode($content);
		}
	}

	function ajax_get_category() {
		// read excel file
		$category_col = $_POST['category_col'];
		$miss_row = $_POST['miss_row'];
		$inputFileName = $_FILES ? $_FILES['0']['tmp_name'] : false;
		if($inputFileName) {
			$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
			$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
			$highestRow = $objPHPExcel->setActiveSheetIndex(0)->getHighestDataRow();
			for($i = $miss_row + 1;
			$i <= $highestRow;
			$i ++ ) {
				$cat_arr[$i] = $objPHPExcel->getActiveSheet()->getCell("$category_col" . 
																	   $i)->getFormattedValue();
			}

			foreach(array_unique($cat_arr)as $key => $value) {
				$cat_arr_unique[] = array('name' =>$value? : '———',
										  'row' =>$key);
			}
			$sql = "SELECT name, id FROM categories WHERE is_active = 1";
			$query = $this->db->query($sql);

			foreach($query->result()as $row) {
				$cat_list[] = array('name' =>$row->name,
									'id' =>$row->id);
			}
			$this->session->set_userdata('reservation_import_category', $cat_arr_unique);
			$data = array();
			$data['cat_list'] = $cat_list;
			$data['cat_arr_unique'] = $cat_arr_unique;
			//print_r($cat_arr_unique);
			$content = $this->parser->parse('templates/reservation_import/ajax_get_category.html', $data, true);
			echo json_encode($content);
		}
	}

	function ajax_preview() {
		$post = $this->input->post();
		//print_r($post);
		$miss_row = $post['miss_row'];
		$inputFileName = $_FILES ? $_FILES['0']['tmp_name'] : false;
		$add_arr = array();
		if($inputFileName) {
			$add_arr = $this->Reservation_import_model->prepare_array($inputFileName, $miss_row, $post);
			$data['arr'] = $add_arr;
			$this->parser->parse('/reservation_import/import_preview.php', $data);
		}
	}

	function add_reservations() {
		$post = $this->input->post();
		$miss_row = $post['miss_row'];
		$inputFileName = $_FILES ? $_FILES['file_data']['tmp_name'] : false;
		$add_arr = array();
		$data = array('success' => array(),
					  'unsuccess' => array(),
					 );
		if($inputFileName) {
			$add_arr = $this->Reservation_import_model->prepare_array($inputFileName, $miss_row, $post, 0);
			if($add_arr) {
				$data['add_arr'] = $add_arr;

				foreach($add_arr as $reservation) {
					if(!empty($reservation['datein'])&& !empty($reservation['dateout'])) {
						$reservation['room_id'] = $this->frontdesk->getfreeroomlist($reservation['datein'], $reservation['dateout'], $reservation['type_id'], 0, 0, 0, 0);
						if(!empty($reservation['room_id'])) {
							$data_guest = array();
							$data_guest['phone'] = isset($reservation["customer_phone"])? $reservation["customer_phone"] : '';
							$data_guest['email'] = isset($reservation["customer_email"])? $reservation["customer_email"] : '';
							$data_guest['dob'] = isset($reservation["customer_dob"])? date_format(date_create($reservation["customer_dob"]), "Y-m-d"): '';
							$data_guest['passportid'] = isset($reservation["customer_doc_number"])? $reservation["customer_doc_number"] : '';
							$data_guest['firstname'] = isset($reservation["customer_first_name"])? $reservation["customer_first_name"] : '';
							$data_guest['lastname'] = isset($reservation["customer_last_name"])? $reservation["customer_last_name"] : '';
							$guest_id = $this->frontdesk->Guest_insert($data_guest);
							$reservation_id = $this->frontdesk->Reservation_insert($reservation, $guest_id);
							$data['success'][] = $reservation;
						} else {
							$data['unsuccess'][] = $reservation;
						}
					} else {
						$data['unsuccess'][] = $reservation;
					}
				}
			}
			$this->parser->parse('/reservation_import/add_reservations.php', $data);
		}
	}

	function post_excel_write_to_db() {
		// read excel file
		print_r($_POST);
		$inputFileName = $_FILES['file_data']['tmp_name'];
		$start_row = 2;
		// $file = './files/test.xlsx';
		$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);

		foreach($objPHPExcel->getWorksheetIterator()as $worksheet)// цикл обходит страницы файла
		 {
			$highestRow = $worksheet->getHighestRow();
			// получаем количество строк
			$highestColumn = $worksheet->getHighestColumn();
			// а так можно получить количество колонок
			for($row = $start_row;
			$row <= $highestRow;
			++ $row )// обходим все строки начиная с $start_row
			 {
				// $cell1 = $worksheet->getCellByColumnAndRow('A', $row);
				$cell1 = $worksheet->getCell("A" . 
											 $row);
				$cell2 = $worksheet->getCell("B" . 
											 $row);
				$cell3 = $worksheet->getCell("C" . 
											 $row);
				$cell4 = $worksheet->getCell("D" . 
											 $row);
				$sql = "INSERT INTO `price` (`article`,`name`,`quantity`,`price`,`currency`,`unit`) VALUES
                ('$cell1','$cell2','$cell3','$cell4')";
				// $query = mysql_query($sql) or die('Ошибка чтения записи: '.mysql_error());
			}
		}
	}

	function post_excel_read() {
		// read excel file
		$inputFileName = $_FILES['file_data']['tmp_name'];
		// $file = './files/test.xlsx';
		$objPHPExcel = PHPExcel_IOFactory::load($inputFileName);
		// get only the Cell Collection
		$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
		// extract to a PHP readable array format

		foreach($cell_collection as $cell) {
			$column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
			$row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
			$data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
			// The header will/should be in row 1 only. of course, this can be modified to suit your need.
			if($row == 1) {
				$header[$row][$column] = $data_value;
			} else {
				$arr_data[$row][$column] = $data_value;
			}
		}
		// send the data in an array format
		$data['header'] = $header;
		$data['values'] = $arr_data;
		print_r($data);
	}

	function doc2html() {
		
		/*
		 * $phpWord = \PhpOffice\PhpWord\IOFactory::load('./files/test.docx');
		 * $htmlWriter = new \PhpOffice\PhpWord\Writer\HTML($phpWord);
		 * $htmlWriter->save('./img/test.html');
		 */
		require_once APPPATH . '/third_party/PhpWord/TemplateProcessor.php';
		$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor('./files/test.docx');
		$templateProcessor->setValue('val1', 'John');
		$templateProcessor->setValue('val2', 'Doe');
		$templateProcessor->saveAs('./img/test.docx');
	}
}