<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Paypal extends CI_Controller
{

    // otelMS data
    public $merchant_parent; // otelms merchant
    public $clientId; // клиент айди otelMS
    public $clientSecret; // клиент секрет otelMS
    public $hotel_id;
    //

    // Динамические поля
    public $track; // отслеживание клиента нужно далее для запросов
    public $token; // токен
    public $merchant_seller; // мерчант айди аккаунта клиента
    public $api_url;

    public function __construct()
    {
        parent::__construct();
        $this->load->model('mlanguages');
        $this->load->model('htmltpl');
        $this->load->model('paypal_mdl');
        $this->load->model('pay_c2');
        $this->load->model('mpartners');
        $this->load->model('Authorization');
        $this->Authorization->IsLogined();

        $this->api_url = $this->paypal_mdl->get_api_url();
        $this->clientId = $this->paypal_mdl->get_clientId();
        $this->clientSecret = $this->paypal_mdl->get_clientSecret();

        $this->merchant_parent = $this->paypal_mdl->get_merchant_parent();
        $this->merchant_seller = $this->paypal_mdl->get_merchant_seller();

        $this->token = $this->paypal_mdl->getToken();
        $this->track = $this->paypal_mdl->getTrack();

        $this->hotel_id = $this->config->item('hotel_id');
        $this->hotel_host = $_SERVER['HTTP_HOST'];
    }

    public function settings()
    {
//         $seleer = $this->paypal_mdl->checkAccount();
//         echo "<pre>";
//         print_r($seleer);
//         die("DIED by A Department at paypal.php settings() on 27 апр. 2022 г. 15:22:46");

        $this->load->view ( 'paypal/settings_view.php');
    }

    public function handleCallback()
    {
//         Array
//         (
//             [merchantId] => 5010-5b1b68a9abf4d2cd155c81a9225fd158
//             [merchantIdInPayPal] => Z77HDTSEGWU4S
//             [permissionsGranted] => true
//             [consentStatus] => true
//             [productIntentId] => addipmt
//             [productIntentID] => addipmt
//             [isEmailConfirmed] => true
//             [accountStatus] => BUSINESS_ACCOUNT
//             )

        $data = array();
        $data = $this->input->get();
        if (isset($data['merchantIdInPayPal'])){
            $this->paypal_mdl->set_merchant_seller($data['merchantIdInPayPal']);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/paypal/settings/'>" );
    }

    public function disconnect()
    {
        $this->paypal_mdl->unset_merchant_seller();
        die ( "<meta http-equiv='refresh' content='0;url=/paypal/settings/'>" );
    }
    
    function settings_v2(){
        $this->load->view ( 'paypal/settings_v2_view.php');
    }
    
    function settings_v2_post(){
        $post = $_POST;
        if(isset($post['paypal_clientID'])){
            $this->hotelix_config->set_record('paypal_clientID', $post['paypal_clientID'], 'str');
        }
        if(isset($post['payment_type'])){
            $this->hotelix_config->set_record('paypal_payment_type', $post['payment_type'], 'int');
        }
        if(isset($post['id_partner'])){
            $this->hotelix_config->set_record('paypal_id_partner', $post['id_partner'], 'int');
        }
        
        die ( "<meta http-equiv='refresh' content='0;url=/paypal/settings_v2'>" );
    }
}