<?php
class Kkm extends CI_Controller {
	public function __construct() {
		parent::__construct ();
		$this->load->model ( 'bso_core' );
		$this->load->model ( 'frontdesk' );
		$this->load->model ( 'htmltpl' );
		$this->load->model ( 'Authorization' );
		$this->load->model ( 'localehelper' );
		$this->load->model ( 'kkm_model' );
		$this->load->model ( 'pay_c2' );
		$this->load->model ( 'releases' );
		$this->load->model ( 'hotelix_config' );
		$this->Authorization->IsLogined ();
	}
	function server_settings() { // ККМ налаштування сервера
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'kkm_server_settings_view.php', $data );
	}
	function server_settings_post() { // ККМ налаштування сервера POST
		$data = $_POST;
// 		echo "<pre>";
// 		print_r($data);
// 		die("DIE in kkm/server_settings_post");
		$kkm_print_always = 0;
		if (isset($data['kkm_print_always'])){
			$kkm_print_always = 1;
		}
		$this->kkm_model->update_kkm_print_always($kkm_print_always);
		$this->kkm_model->update_server_url($data['srv_url']);
		$this->kkm_model->update_device_policy($data['device_policy']);
		die ( "<meta http-equiv='refresh' content='0;url=/kkm/server_settings'>" );
	}

	function devices_list() { // ККМ список пристроїв
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'kkm_devices_list_view.php', $data );
	}
	function devices_operations() { // ККМ операції з пристроями
		$data = array();
		$this->load->library ( 'parser' );
		$this->load->view ( 'kkm_devices_operations_view.php', $data );
	}
	function devices_list_post() { // ККМ список пристроїв POST
		$data = array();
		if (isset($_POST['DevicesList'])){
			$data = json_decode ( $_POST ['DevicesList'], true );
			if (isset($data ['ListUnit'])){
				foreach ( $data ['ListUnit'] as $device ) {
					$this->kkm_model->save_kkm_device ( $device );
				}
			}
		}
		if (isset($_POST['delete_kkm_id'])){
			$data['delete_kkm_id'] = $_POST['delete_kkm_id'];
			$this->kkm_model->delete_kkm_device ( $data ['delete_kkm_id'] );
		}
		die ( "<meta http-equiv='refresh' content='0;url=/kkm/devices_list'>" );
	}

	function edit_device(){
		$data = $_POST;
// 		echo "<pre>";
// 		print_r($data);
// 		die('DIE IN kkm/edit_device');

		$this->load->library ( 'parser' );
		$this->load->view ( 'kkm_edit_device_view.php', $data );
	}
	function update_device(){
		$data = $_POST;
// 		echo "<pre>";
// 		print_r($data);
// 		die('DIE IN kkm/update_device');
		$this->kkm_model->update_kkm_device($data);
		die ( "<meta http-equiv='refresh' content='0;url=/kkm/devices_list'>" );
	}
	function delete_device(){
		$data = $_POST;
		// 		echo "<pre>";
		// 		print_r($data);
		// 		die('DIE IN kkm/delete_device');
		$this->kkm_model->delete_kkm_device ( $data ['edit_kkm_id'] );
		die ( "<meta http-equiv='refresh' content='0;url=/kkm/devices_list'>" );
	}

	function RegisterCheck_tmpl (){
        $data = array();
        $this->load->library ( 'parser' );
        $this->load->view ( 'kkm_ajax_RegisterCheck_tmpl.php', $data );
	}

	public function ajax_Get_Check_Strings (){
        $result = $this->kkm_model->get_RegisterCheck_strings_data($this->input->post());
        echo json_encode($result);
	}

	public function ajax_Get_Check_Strings_best (){
	    $result = $this->kkm_model->get_RegisterCheck_strings_data_best($this->input->post());
	    echo json_encode($result);
	}

	function save_fiscal_refund ($fiscal_provider = 0){//call by ajax, from now is law for fiscal refunds!
	    $data = $_POST;
	    $data ["fiscal_provider"] = $fiscal_provider;
	    $data ['res_id'] = $data['reservation_id'];
	    $data ["reason"] = "0";
	    $result = array();
	    $result['ref_id'] = $this->frontdesk->Insert_refund ($data, 1);
	    $this->pay_c2->update_wasrefunded_payment($data ['payid'], $result['ref_id']);
	    switch ($fiscal_provider) {
	        case 1://kkm
	            //save kkm_refund_log (need to create tbl)
	            break;
	        default://2-APEX, 99-oter, maybe else in futere
	            // do nothing on this stage of progress
	    }
	    echo json_encode($result, true);
	}

	function RecoverCheck (){
	    $post = $this->input->post();// Ajax POST
	    echo "<pre>";
	    print_r($post);
	    die("DIED by A Department at kkm.php RecoverCheck() on 27 июл. 2021 г. 13:11:03");
		$data = array();
		if (isset($post['pay_id'])) {
		    $pay_id = $post['pay_id'];
		} else {
			$pay_id = 0;
		}
		$rezult = array();
		if (isset($post['KkmServerResponce']) && $post['KkmServerResponce'] != ''){
		    $recover_data = json_decode($post['KkmServerResponce'], true);
            $data = array(
                'pay_id' => $pay_id,
                'pay_or_ref' => 0,
                'fiscal_provider_id' => 1, // check is printed by KKM
                "CheckNumber" => $recover_data['RegisterCheck']['FiscalNumber'],
                'SessionNumber' => 0,
                'QRCode' => $recover_data['QRCode'],
                'Command' => "RecoverCheck\r\n" . $recover_data['Command'],
                'IdCommand' => $recover_data['IdCommand'],
                'kkm_MethodCalculation' => $post['MethodCalculation'],
                'RegisterCheckStrings' => $post['KkmServerResponce']
            );
			$kkm_MethodCalculation_arr = $this->kkm_model->get_MethodCalculation_arr ();
			$kkm_MethodCalculation_arr[0] = '???';
			$rezult ["pay_id"] = $pay_id;
			$rezult ["kkm_check_id"] = "KKM С:".$data['SessionNumber'].", Ч:".$data['CheckNumber'].
	            					" (".$this->kkm_model->Insert_kkm_check ($data, 0).", ".
	            					 $kkm_MethodCalculation_arr[$data ['kkm_MethodCalculation']]. ")";
		}else {
			$rezult ["pay_id"] = 0;
			$rezult ["kkm_check_id"] = "";
		}

		echo json_encode( $rezult ) ;
	}

	public function ajax_InsertKkmCheck($pay_or_ref = 0) {
	        $post = $this->input->post();// Ajax POST


	        echo json_encode($post);


	        /* // 	        pay_id : pay_id, OR ref_id : ref_id
	        // 	        KkmServerResponce : KkmServerResponce,
	        // 	        RegisterCheckStrings : RegisterCheckStrings,//можливо будемо порівнювати при дофіскалізації чи відновленні
	        // 	        payment_type_id : $("#payment_type_id").val(),//actualy payment method?
	        //          MethodCalculation : $("#kkm_MethodCalculation").val(),
	        $result = array('errors'=>array());
	        if ($pay_or_ref == 1){//1 - refund
	            //наразі таблиця логування рефундів не існує
	            // 	           $pay_or_ref_id = $post ['ref_id'];
	            // 	            $fild_name = 'ref_id';
	        }else{//0 - payment
	            $log_tbl = 'kkm_payment_log';
	            $fild_name = 'pay_id';
	            $pay_or_ref_id = $post ['pay_id'];
	            $this->db->update($log_tbl, array('response' => $post['KkmServerResponce']), array($fild_name => $pay_or_ref_id));//коли буде таблиця kkm_refunds_log, винести з іф
	        }
	        $kkm_check_id = $this->kkm_model->Insert_kkm_check ($post, $pay_or_ref);
	        if(isset($post['landing_page_notbe_reloaded'])){// дофіскалізація, відновлення чеку, може ще щось
	            $data_for_kkm_str = array(
	                'kkm_check_id' => $kkm_check_id,
	            );
	            $result ["kkm_str_after_ajax"] = $this->kkm_model->make_kkm_str_after_ajax($data_for_kkm_str);
	        }
	        echo json_encode($result); */
	}

	function InsertKkmCheck ($pay_or_ref = 0){
	    $data = array();
	    if (isset($_POST['KkmServerResponce'])) {
	        $response = $_POST['KkmServerResponce'];
	    } else {
	        $response = "";
	    }
	    if (isset($_POST['pay_id'])) {
	        $pay_id = $_POST['pay_id'];
	    } else {
	        $pay_id = 0;
	    }
	    $this->db->update('kkm_payment_log', array('response' => $response), array('pay_id' => $pay_id));
// 	    $data['body'] = json_encode($_POST, true);
// 	    $data['hms_id'] = $this->config->item ( 'hotel_id' );
// 	    $data['pr_id'] = $pay_or_ref;
// 	    $data['pay_id'] = $pay_id;
// 	    $data['response'] = $response;
// 	    $data['strings'] = $_POST['RegisterCheckStrings'];
// 	    $this->db->insert('global_hotelix.kkm_log', $data);

// 		echo '<pre>';
// 		print_r($data);
// 		die('IDE IN kkm/InsertKkmCheck');
	    $data = $_POST;
		$data["KkmServerResponce"] = json_decode($_POST["KkmServerResponce"], true);
		foreach ($data["KkmServerResponce"] as $key => $value){
			$data [$key] = $value;
		}
		$tmp = json_decode($data["RegisterCheckStrings"], true);
		if (isset($tmp['CheckStrings'][0]['Register']['SignMethodCalculation'])) {
		  $data ['kkm_MethodCalculation'] = $tmp['CheckStrings'][0]['Register']['SignMethodCalculation'];
		} else {
		    $data ['kkm_MethodCalculation'] = 0;
		}
		$rezult = array();
		$kkm_MethodCalculation_arr = $this->kkm_model->get_MethodCalculation_arr ();
		$kkm_MethodCalculation_arr[0] = '???';
		if ($pay_or_ref == 0){
			$rezult ["pay_or_ref_id"] = $data ['pay_id'];
		}else{
			$rezult ["pay_or_ref_id"] = $data ['refund_id'];
		}

		$rezult ["kkm_check_id"] = "KKM С:".$data['SessionNumber'].", Ч:".$data['CheckNumber'].
	            					" (".$this->kkm_model->Insert_kkm_check ($data, $pay_or_ref).", ".
	            					 $kkm_MethodCalculation_arr[$data ['kkm_MethodCalculation']]. ")";
		echo json_encode( $rezult ) ;
	}

	function InsertAppexFiscalCheck (){
	    $data = $_POST;
	    $rezult = array();
	    $rezult ["payment_id"] = $data ['pay_id'];
	    $rezult ["fiscal_check_id"] = $this->kkm_model->InsertAppexFiscalCheck($data, 0)  . " (APPEX)";
	    echo json_encode( $rezult ) ;
	}
	function InsertOtherFiscalCheck (){
		$data = $_POST;
		$rezult = array();
		$rezult ["payment_id"] = $data ['pay_id'];
		$rezult ["fiscal_check_id"] = $this->kkm_model->InsertOtherFiscalCheck($data, 0)  . " (OTHER)";
		echo json_encode( $rezult ) ;
	}
	function ajax_get_kkm_devices_list(){
		$kkm_devices_list = $this->kkm_model->get_kkm_devices_list ();
		$select_kkmdevice_options = array();
		foreach ($kkm_devices_list as $device) {
			if ($device['partner_id'] == $_POST['id_partner']){
				array_push($select_kkmdevice_options, array('id_device' => $device['IdDevice'],
															'device_name' => $device['NameDevice'],
															'is_selected' => ($device['is_default'] == 1) ? 1 : 0,
															'has_TaxVariants_attr' => (strlen($device['TaxVariant']) > 1) ? 1:0
														));
			}
		}
		$devices_list = array();
		$devices_list["select_options"] = $select_kkmdevice_options;
		echo json_encode($devices_list);
	}

	function use_conditions (){
		$menu_data = $this->htmltpl->get_left_settings_menu ( 8, 6 );
		$data = array (
			'header' => $this->htmltpl->getHeader_new (),
			'footer_html' => $this->htmltpl->getFooter_new(),
			'settings_main_menu' => $menu_data ["main_menu"],
			'settings_sub_menu' => $menu_data ["sub_menu"],
		);
		$this->mlanguages->getdictionary("kkm", "", $data);
		$this->parser->parse ( 'templates/kkm_use_conditions_view.html', $data );
	}

	function ajax_get_TaxVariants_arr($device_id) {//get_kkm_device_by_id($id)
		$TaxVariants_arr = $this->kkm_model->get_TaxVariants_arr();
		$TaxVariant_data = $this->db->get_where('kkm_devices', array('IdDevice'=>$device_id))->row()->TaxVariant;
		$curr_TaxVariants = explode( ',', $TaxVariant_data );
		$TaxVariants_select_options_arr = array();
		foreach ($curr_TaxVariants as $TaxVariant_id) {
			array_push ( $TaxVariants_select_options_arr, array (
			'val' => $TaxVariant_id,
			'name' =>  $TaxVariants_arr[$TaxVariant_id],
			) );
		}
// 		array_unshift ( $TaxVariants_select_options_arr, array (
// 				'val' => "",
// 				'name' => "Автоматический выбор СНО",
// 		) );
		echo json_encode(array('select_options' => $TaxVariants_select_options_arr));
	}

	function ajax_log_device_operation() {
	    $post = $this->input->post();
		$tbl = "kkm_operation_log";
		$request = $post['request'];
		$responce = $post['responce'];
		$insert_arr = array (
				'request' => json_encode ( $request ),
				'responce' => json_encode ( $responce )
		);
		$Log_ajax_responce = array();
		$this->db->insert($tbl, $insert_arr);
		array_push($Log_ajax_responce, array('table'=>$tbl,'id'=>$this->db->insert_id()));
		$shift_operations_arr = array('OpenShift', 'CloseShift');

		if (in_array($responce['Command'], $shift_operations_arr)){
		    $tbl = "kkm_shifts_log";
		    $kkm_devices_id = $this->db->select('id')->get_where('kkm_devices', array('IdDevice'=>$request['IdDevice']))->row()->id;
		    switch ($responce['Command']) {
		        case 'OpenShift':
		            $insert_arr = array (
		                'SessionNumber' => $responce['SessionNumber'],
		                'kkm_device_id' => $kkm_devices_id
		            );
		            $this->db->insert($tbl, $insert_arr);
		            array_push($Log_ajax_responce, array('table'=>$tbl,'insert_arr'=>$insert_arr));
		            break;
		        case 'CloseShift':
		            $update_arr = array (
		                'close_time' => date('Y-m-d H:i:s'),
		            );
                    $this->db->update($tbl, $update_arr, array(
                        'SessionNumber' => $responce['SessionNumber'],
                        'kkm_device_id' => $kkm_devices_id,
                        'close_time' => date('0000-00-00 00:00:00'),
                    ));
                    array_push($Log_ajax_responce, array('table'=>$tbl,'update_arr'=>$update_arr));
                    break;
		    }
		}
		echo json_encode($Log_ajax_responce);
	}

	public function ajax_Log_KKM_Operation() {
	    $post = $this->input->post();
	    $tbl = "kkm_operation_log";
	    $request = $post['request'];
	    $responce = $post['responce'];
	    $insert_arr = array (
	        'request' => json_encode ( $request ),
	        'responce' => json_encode ( $responce )
	    );
	    $Log_ajax_responce = array();
	    $this->db->insert($tbl, $insert_arr);
	    array_push($Log_ajax_responce, array('table'=>$tbl,'id'=>$this->db->insert_id()));
	    $shift_operations_arr = array('OpenShift', 'CloseShift');

	    if (in_array($responce['Command'], $shift_operations_arr)){
	        $tbl = "kkm_shifts_log";
	        $kkm_devices_id = $this->db->select('id')->get_where('kkm_devices', array('IdDevice'=>$request['IdDevice']))->row()->id;
	        switch ($responce['Command']) {
	            case 'OpenShift':
	                $insert_arr = array (
	                'SessionNumber' => $responce['SessionNumber'],
	                'OpenCheckNumber' => $responce['CheckNumber'],
	                'kkm_device_id' => $kkm_devices_id
	                );
	                $this->db->insert($tbl, $insert_arr);
	                array_push($Log_ajax_responce, array('table'=>$tbl,'insert_arr'=>$insert_arr));
	                break;
	            case 'CloseShift':
	                $update_arr = array (
	                'close_time' => date('Y-m-d H:i:s'),
	                'CloseCheckNumber' => $responce['CheckNumber'],
	                );
	                $this->db->update($tbl, $update_arr, array(
	                    'SessionNumber' => $responce['SessionNumber'],
	                    'kkm_device_id' => $kkm_devices_id,
	                    'close_time' => date('0000-00-00 00:00:00'),
	                ));
	                array_push($Log_ajax_responce, array('table'=>$tbl,'update_arr'=>$update_arr));
	                break;
	        }
	    }
	    echo json_encode($Log_ajax_responce);
	}

	public function check_settings() {
	    $data = array();
	    $this->load->library ( 'parser' );
	    $this->load->view ( 'kkm_check_settings_view.php', $data );
	}

	public function check_settings_post() {
	    $post = $this->input->post();
	    $this->hotelix_config->set_record ("kkm_check_nomenclatura_state", (isset($post['nomenclatura'])) ? 1 : 0, "int");
	    $this->hotelix_config->set_record ("kkm_check_nomenclatura_fullname_state", (isset($post['nomenclatura_fullname'])) ? 1 : 0, "int");
        die ( "<meta http-equiv='refresh' content='0;url=/kkm/check_settings'>" );
	}

	public function ajax_get_cashier_data () {
	    $cashier = $this->kkm_model->get_cashier_data();
	    echo json_encode($cashier);
	}
}