<?php
//use Stripe\ApiOperations\Retrieve;
function objectToArray($object) {
    if (! is_object ( $object ) && ! is_array ( $object )) {
        return $object;
    }
    if (is_object ( $object )) {
        $object = get_object_vars ( $object );
    }
    return array_map ( 'objectToArray', $object );
}
class Gateway extends CI_Controller {
    public function __construct() {
        parent::__construct ();

        if ($this->input->ip_address() == "77.120.43.118" || $this->input->ip_address() == "194.44.237.222") {
            //echo $this->input->ip_address();
            //$this->output->enable_profiler(TRUE);
        }

        //$this->load->model('stripe_billing_m2');
        $this->load->model ( 'Access' );
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'releases' );
        $this->load->model ( 'service_model' );
        $this->load->model ( 'dc_model' );
        $this->load->model ( 'qd_model' );
        $this->load->model ( 'cancel' );
        $this->load->model ( 'Wubook' );
        $this->load->model ( 'pay' );
        $this->load->model ( 'Curl_model' );
        $this->load->model ( 'formsprinter_model_v2' );
        $this->load->model ( 'monline_module' );
        $this->load->model ( 'gateway_model' );
        // echo "++";
    }
    
    function index() {
        
    }
    
    function Order() {
        $query = $this->db->query ( "SELECT value FROM gatewayoforder WHERE name LIKE 'dealerID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $dealer = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM gatewayoforder WHERE name LIKE 'categoryID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $default_categoryid = $row->value;
        }

        $data = $_POST;
        $query = $this->db->query ( "SELECT * FROM categories WHERE id = " . $data ["category"] );
        if ($query->num_rows () > 0) {
            $category = $data ["category"];
        } else {
            $category = $default_categoryid;
        }

        if ($data ["command"] == "check") {
            $result = $this->getfreeroomlist ( $data ["datein"], $data ["dateout"], $category );
            if ($result != 0) {
                echo "success";
                exit ();
            } else {
                echo "failed 1";
                exit ();
            }
        }

        if ($data ["command"] == "reserv") {
            $result = $this->getfreeroomlist ( $data ["datein"], $data ["dateout"], $category );
            if ($result > 0) {
                $guest_id = $this->frontdesk->Guest_insert ( $data );
                $data ["room_id"] = $result;
                $data ["type_id"] = $category;
                $data ['dealer'] = $dealer;
                $data ['isNew'] = 1;
                $result = $this->frontdesk->Reservation_insert ( $data, $guest_id, $small = 0 );
                if ($result > 0) {
                    echo "success";
                } else {
                    echo "failed 2";
                }
            } else {
                echo "failed 3";
            }
        }
    }
    function getfreeroomlist($datein, $dateout, $category, $currency = 0) {
        $date_in_unix = $this->DateToUnixIn ( $datein );
        // echo "date_in_unix".$date_in_unix;
        $date_out_unix = $this->DateToUnixIn ( $dateout );
        // echo "date_out_unix".$date_out_unix;

        $sql = "SELECT deskofreservation.id, deskofreservation.room_id, deskofreservation.datein,
        deskofreservation.dateout FROM deskofreservation
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        WHERE rooms.category_id = $category AND deskofreservation.deleted = 0 AND deskofreservation.cancel = 0";

        // echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $data [$row->id] ["datein"] = $this->DateToUnixIn ( $row->datein );
                $data [$row->id] ["dateout"] = $this->DateToUnixOut ( $row->dateout );
                $data [$row->id] ["room_id"] = $row->room_id;
            }
            $keys = array_keys ( $data );
            $i = 0;
            $mass_not_free_rooms = array ();
            foreach ( $keys as $key ) {
                $in = $data [$key] ["datein"];
                $out = $data [$key] ["dateout"];
                if ((($data [$key] ["datein"] <= $date_in_unix) and ($data [$key] ["dateout"] >= $date_in_unix)) or (($data [$key] ["datein"] >= $date_in_unix) and ($data [$key] ["datein"] < $date_out_unix) and ($data [$key] ["dateout"] <= $date_out_unix)) or (($data [$key] ["datein"] >= $date_in_unix) and ($data [$key] ["datein"] < $date_out_unix) and ($data [$key] ["dateout"] >= $date_out_unix))) {
                    $mass_not_free_rooms [$i] = $data [$key] ["room_id"];
                    $i ++;
                }
            }
            $mass_all_rooms = array ();
            $sql = "SELECT id FROM rooms WHERE category_id = $category";

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $i = 0;
                foreach ( $query->result () as $row ) {
                    $mass_all_rooms [$i] = $row->id;
                    $i ++;
                }
            }
            // print_r($mass_all_rooms);
            // echo "+++";
            // print_r($mass_not_free_rooms);
            for($i = 0; $i < count ( $mass_all_rooms ); $i ++) {
                $bool = 1;
                for($j = 0; $j < count ( $mass_not_free_rooms ); $j ++) {
                    if ($mass_all_rooms [$i] == $mass_not_free_rooms [$j]) {
                        $bool = 0;
                        break;
                    }
                }
                if ($bool == 1) {
                    return $mass_all_rooms [$i];
                }
            }
            return $bool;
        } else {
            $sql = "SELECT * FROM rooms WHERE category_id = " . $category;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    return $row->id;
                    break;
                }
                // return 0;
            } else {
                // echo "=========";
                return 0;
            }
        }
        // return $select;
    }
    function DateToUnixIn($date) {
        list ( $year_in, $month_in, $day_in ) = explode ( "-", $date );
        $date_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
        return $date_unix;
    }
    function DateToUnixOut($date) {
        list ( $year_in, $month_in, $day_in ) = explode ( "-", $date );
        $date_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in - 1, $year_in ) ) / (3600 * 24) );
        return $date_unix;
    }
    function GetFreeCategoryList($datein, $dateout) {
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $temp_1 = array ();
        $sql = "SELECT * FROM rooms";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] [$row ["id"]] ["name"] = $row ["name"];
            }
        }

        echo '<table><tr><td valign="top">';
        echo "<pre>";
        print_r ( $temp_1 );
        echo "</td>";
        $temp_2 = array ();
        $sql = "SELECT rooms.id, rooms.category_id, rooms.name FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        WHERE deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] [$row ["id"]] ["name"] = $row ["name"];
            }
        }
        echo '<td valign="top">';
        echo "<pre>";
        print_r ( $temp_2 );
        echo "</td>";
        $temp_3 = array ();
        $temp_keys_1 = array_keys ( $temp_1 );
        foreach ( $temp_keys_1 as $key_1 ) {
            $temp_keys_2 = array_keys ( $temp_1 [$key_1] );
            foreach ( $temp_keys_2 as $key_2 ) {
                if (! isset ( $temp_2 [$key_1] [$key_2] )) {
                    $temp_3 [$key_1] [$key_2] ["name"] = $temp_1 [$key_1] [$key_2] ["name"];
                }
            }
        }
        echo '<td valign="top">';
        echo "<pre>";
        print_r ( $temp_3 );
        echo "</td>";
        echo "</tr></table>";
    }
    function getfreeroomsarrayAll($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }
        // print_r($hosts);
        // die();
        // $this->output->enable_profiler(TRUE);

        // $hosts[1]["host"] = "zmis.otelms.com";
        // $hosts[1]["dbname"] = "hotelix_zmis";
        // $hosts[2]["host"] = "terem.otelms.com";
        // $hosts[2]["dbname"] = "hotelix_terem";
        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        $all_array = array ();
        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $rate = 1;
            $hotel_currency = 1;
            $query = $this->db->query ( "SELECT value FROM " . $db_name . ".gatewayoforder
				 WHERE name LIKE 'currencyID'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $hotel_currency = $row->value;
            }
            $query = $this->db->query ( "SELECT Rate FROM visitka.currencyrate
				 WHERE Basecurrency = " . $currency . " AND Hotelcurrency = " . $hotel_currency );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $rate = $row->Rate;
            }
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();
            $sql = "SELECT  count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM " . $db_name . ".rooms
		INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
		WHERE " . $db_name . ".categories.web_booking = 1
		GROUP by " . $db_name . ".rooms.category_id";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }
            $temp_2 = array ();
            $sql = "SELECT  count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
			FROM " . $db_name . ".deskofdays
			INNER JOIN " . $db_name . ".deskofreservation ON " . $db_name . ".deskofreservation.id = " . $db_name . ".deskofdays.reservation_id
			INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.id = " . $db_name . ".deskofreservation.room_id
			INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
			WHERE " . $db_name . ".categories.web_booking = 1 AND " . $db_name . ".deskofdays.intdate >= $intdatein AND " . $db_name . ".deskofdays.intdate <= $intdateout GROUP BY " . $db_name . ".rooms.category_id";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                }
            }

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $sss = array ();
                $sss = $this->getpricecalculation ( $post_data, 0, 1, $db_name );
                $total = 0;
                for($i = 0; $i < count ( $sss ); $i ++) {
                    $total += $sss [$i] ["amount"];
                }

                if ($total == 0) {
                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                }
                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = $temp_1 [$key] ["count"];
                }
                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    $temp_3 ["categories"] [$key] ["amount"] = $total * $rate;
                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        echo $output;
        // print_r($output);
    }
    function getfreeroomsarrayAlltoday($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }

        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        $all_array = array ();

        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $rate = 1;
            // $rate = $this->frontdesk->get_rate();
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();
            $sql = "SELECT  10 as count, categories.id as category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM  " . $db_name . ".categories 	WHERE " . $db_name . ".categories.web_booking = 1
		GROUP by categories.id";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                    $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }

            // =========================
            if ($price_type == 0 or $price_type == '') {
                $price_name_id = 1;
            } else {
                // $sql = "SELECT table_name FROM rate WHERE id = " . $data
                // ["price_type"];
                // $query = $this->db->query ( $sql );
                // $row = $query->row ();
                $price_name_id = $price_type;
            }
            $array_prices_seasons = array ();

            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
            FROM $db_name.seasonspricelist
            INNER JOIN $db_name.seasons ON $db_name.seasons.id = $db_name.seasonspricelist.season_id
            INNER JOIN $db_name.rate ON $db_name.rate.id = $db_name.seasonspricelist.rate_id
            INNER JOIN $db_name.categories ON $db_name.categories.id = $db_name.seasonspricelist.category_id
            WHERE $db_name.categories.web_booking = 1
            AND $db_name.rate.id = $price_name_id
            GROUP BY $db_name.seasonspricelist.category_id, $db_name.seasons.id
            ";

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                }
            }

            $sql = "SELECT * FROM $db_name.seasons";
            $query = $this->db->query ( $sql );
            $season_data = array ();
            foreach ( $query->result () as $row ) {
                // print_r( $row) . "\n";
                $season_data [$row->id] ["from"] = $row->startdate;
                $season_data [$row->id] ["to"] = $row->enddate;
            }

            // =========================

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
                $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
                $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

                $sss = array ();
                $sss = $this->getpricecalculation2 ( $post_data, 0, 1, $db_name, $array_prices_seasons, $season_data );
                // echo "<pre>";
                // print_r($sss);
                $total = 0;
                for($i = 0; $i < count ( $sss ); $i ++) {
                    $total += $sss [$i] ["amount"];
                }

                if ($total == 0) {
                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                }

                $count_rooms = $temp_1 [$key] ["count"];

                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    $temp_3 ["categories"] [$key] ["amount"] = $total * $rate;
                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        echo $output;
        // print_r($output);
    }
    function getfreeroomsarrayAll2($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }

        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        $all_array = array ();

        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $rate = 1;
            // $rate = $this->frontdesk->get_rate();
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();
            $sql = "SELECT  count(rooms.id) count, categories.id as category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM  " . $db_name . ".categories
		 INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.category_id = " . $db_name . ".categories.id
		 WHERE " . $db_name . ".categories.web_booking = 1
		GROUP by categories.id";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                    $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }

            // =========================
            if ($price_type == 0 or $price_type == '') {
                $price_name_id = 1;
            } else {
                // $sql = "SELECT table_name FROM rate WHERE id = " . $data
                // ["price_type"];
                // $query = $this->db->query ( $sql );
                // $row = $query->row ();
                $price_name_id = $price_type;
            }
            $array_prices_seasons = array ();

            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
            FROM $db_name.seasonspricelist
            INNER JOIN $db_name.seasons ON $db_name.seasons.id = $db_name.seasonspricelist.season_id
            INNER JOIN $db_name.rate ON $db_name.rate.id = $db_name.seasonspricelist.rate_id
            INNER JOIN $db_name.categories ON $db_name.categories.id = $db_name.seasonspricelist.category_id
            WHERE $db_name.categories.web_booking = 1
            AND $db_name.rate.id = $price_name_id
            GROUP BY $db_name.seasonspricelist.category_id, $db_name.seasons.id
            ";

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                }
            }

            $sql = "SELECT * FROM $db_name.seasons";
            $query = $this->db->query ( $sql );
            $season_data = array ();
            foreach ( $query->result () as $row ) {
                // print_r( $row) . "\n";
                $season_data [$row->id] ["from"] = $row->startdate;
                $season_data [$row->id] ["to"] = $row->enddate;
            }

            // =========================

            $temp_2 = array ();
            $sql = "SELECT  count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
			FROM " . $db_name . ".deskofdays
			INNER JOIN " . $db_name . ".deskofreservation ON " . $db_name . ".deskofreservation.id = " . $db_name . ".deskofdays.reservation_id
			INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.id = " . $db_name . ".deskofreservation.room_id
			INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
			WHERE " . $db_name . ".categories.web_booking = 1 AND " . $db_name . ".deskofdays.intdate >= $intdatein AND " . $db_name . ".deskofdays.intdate <= $intdateout GROUP BY " . $db_name . ".rooms.category_id";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                }
            }

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
                $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
                $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

                $sss = array ();
                $sss = $this->getpricecalculation2 ( $post_data, 0, 1, $db_name, $array_prices_seasons, $season_data );
                // echo "<pre>";
                // print_r($sss);
                $total = 0;
                for($i = 0; $i < count ( $sss ); $i ++) {
                    $total += $sss [$i] ["amount"];
                }

                if ($total == 0) {
                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                }

                // $count_rooms = $temp_1 [$key] ["count"];
                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = $temp_1 [$key] ["count"];
                }
                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    $temp_3 ["categories"] [$key] ["amount"] = $total * $rate;
                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";
        // print_r($all_array);
        // die();
        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        echo $output;
        // print_r($output);
    }
    function getfreeroomsarrayprices_maxminavarage($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }

        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        $all_array = array ();

        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $rate = 1;
            // $rate = $this->frontdesk->get_rate();
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();
            $sql = "SELECT  count(rooms.id) count, categories.id as category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM  " . $db_name . ".categories
		 INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.category_id = " . $db_name . ".categories.id
		 WHERE " . $db_name . ".categories.web_booking = 1
		GROUP by categories.id";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                    $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }

            // =========================
            if ($price_type == 0 or $price_type == '') {
                $price_name_id = 1;
            } else {
                // $sql = "SELECT table_name FROM rate WHERE id = " . $data
                // ["price_type"];
                // $query = $this->db->query ( $sql );
                // $row = $query->row ();
                $price_name_id = $price_type;
            }
            $array_prices_seasons = array ();

            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
            FROM $db_name.seasonspricelist
            INNER JOIN $db_name.seasons ON $db_name.seasons.id = $db_name.seasonspricelist.season_id
            INNER JOIN $db_name.rate ON $db_name.rate.id = $db_name.seasonspricelist.rate_id
            INNER JOIN $db_name.categories ON $db_name.categories.id = $db_name.seasonspricelist.category_id
            WHERE $db_name.categories.web_booking = 1
            AND $db_name.rate.id = $price_name_id
            GROUP BY $db_name.seasonspricelist.category_id, $db_name.seasons.id
            ";

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                }
            }

            $sql = "SELECT * FROM $db_name.seasons";
            $query = $this->db->query ( $sql );
            $season_data = array ();
            foreach ( $query->result () as $row ) {
                // print_r( $row) . "\n";
                $season_data [$row->id] ["from"] = $row->startdate;
                $season_data [$row->id] ["to"] = $row->enddate;
            }

            // =========================

            $temp_2 = array ();
            $sql = "SELECT  count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
			FROM " . $db_name . ".deskofdays
			INNER JOIN " . $db_name . ".deskofreservation ON " . $db_name . ".deskofreservation.id = " . $db_name . ".deskofdays.reservation_id
			INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.id = " . $db_name . ".deskofreservation.room_id
			INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
			WHERE " . $db_name . ".categories.web_booking = 1 AND " . $db_name . ".deskofdays.intdate >= $intdatein AND " . $db_name . ".deskofdays.intdate <= $intdateout GROUP BY " . $db_name . ".rooms.category_id";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                }
            }

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
                $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
                $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

                $sss = array ();
                $sss = $this->getpricecalculation2 ( $post_data, 0, 1, $db_name, $array_prices_seasons, $season_data );
                // echo "<pre>";
                // print_r($sss);
                $total = 0;
                for($i = 0; $i < count ( $sss ); $i ++) {
                    $total += $sss [$i] ["amount"];
                }

                if ($total == 0) {
                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                }

                // $count_rooms = $temp_1 [$key] ["count"];
                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = $temp_1 [$key] ["count"];
                }
                if ($count_rooms != 0) {
                    // $temp_3["categories"] [$key] ["count"] = $count_rooms;
                    // $temp_3["categories"] [$key] ["name"] = $temp_1 [$key]
                    // ["name"];
                    // $temp_3["categories"] [$key] ["shortname"] = $temp_1
                    // [$key] ["shortname"];
                    // $temp_3["categories"] [$key] ["places"] = $temp_1 [$key]
                    // ["places"];
                    $temp_3 ["categories"] [$key] = $total * $rate;
                    // $temp_3["categories"] [$key] ["comment"] = $temp_1 [$key]
                    // ["comment"];
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        echo $output;
        // print_r($output);
    }
    function getfreeroomsarrayAlloneday($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }
        // print_r($hosts);
        // die();
        // $this->output->enable_profiler(TRUE);

        // $hosts[1]["host"] = "zmis.otelms.com";
        // $hosts[1]["dbname"] = "hotelix_zmis";
        // $hosts[2]["host"] = "terem.otelms.com";
        // $hosts[2]["dbname"] = "hotelix_terem";
        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdate = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $all_array = array ();
        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $query = $this->db->query ( "SELECT seasonid FROM " . $db_name . ".deskofdaysseason
                WHERE intdate = $intdate" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $seasonid = $row->seasonid;
            }
            $rate_id = 0;
            $query = $this->db->query ( "SELECT id FROM " . $db_name . ". rate
		WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $rate_id = $row->id;
            }
            if ($rate_id == 0) {
                $rate_id = 1;
            }
            $rate = 1;
            $hotel_currency = 1;
            $query = $this->db->query ( "SELECT value FROM " . $db_name . ".gatewayoforder
				 WHERE name LIKE 'currencyID'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $hotel_currency = $row->value;
            }
            $query = $this->db->query ( "SELECT Rate FROM visitka.currencyrate
				 WHERE Basecurrency = " . $currency . " AND Hotelcurrency = " . $hotel_currency );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $rate = $row->Rate;
            }
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();

            $sql = "SELECT  count(rooms.id) count, rooms.category_id, categories.base_price as pr1,
				seasonspricelist.price as pr2, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM " . $db_name . ".rooms
		INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
		INNER JOIN " . $db_name . ".seasonspricelist ON " . $db_name . ".seasonspricelist.category_id = " . $db_name . ".categories.id
		WHERE " . $db_name . ".categories.web_booking = 1 AND
		" . $db_name . ".seasonspricelist.rate_id = $rate_id AND " . $db_name . ".seasonspricelist.season_id = $seasonid
		GROUP by " . $db_name . ".rooms.category_id";

            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["pr1"] * $rate . "(" . $row ["pr2"] * $rate . ")";
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }
            // echo "<pre>";
            // print_r($temp_1);
            $temp_2 = array ();
            $sql = "SELECT  count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
			FROM " . $db_name . ".deskofdays
			INNER JOIN " . $db_name . ".deskofreservation ON " . $db_name . ".deskofreservation.id = " . $db_name . ".deskofdays.reservation_id
			INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.id = " . $db_name . ".deskofreservation.room_id
			INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
			WHERE " . $db_name . ".categories.web_booking = 1 AND " . $db_name . ".deskofdays.intdate >= $intdatein AND " . $db_name . ".deskofdays.intdate <= $intdateout GROUP BY " . $db_name . ".rooms.category_id";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                }
            }

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $sss = array ();
                // $sss = $this->getpricecalculation ( $post_data, 0 , 1,
                // $db_name);
                $total = 0;
                // for($i = 0; $i < count ( $sss ); $i ++) {
                // $total += $sss [$i] ["amount"];
                // }

                // if ($total == 0){
                // $total += $temp_1 [$key]
                // ["base_price"]*($intdateout-$intdatein);
                // }
                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = $temp_1 [$key] ["count"];
                }
                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    $temp_3 ["categories"] [$key] ["amount"] = $temp_1 [$key] ["base_price"];
                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                    // print_r($temp_3);
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";

        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        echo $output;
        // print_r($output);
    }
    function getfreeroomsarray($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1) {
        $temp_time_1 = microtime ( true );
        // $this->output->enable_profiler(TRUE);
        // $rate = $this->frontdesk->getrate($currency);
        // echo $rate;
        // require_once('JSON.php');
        // $json = new Services_JSON();
        if ($price_type == 0) {
            $sql = "SELECT value FROM gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1
		GROUP by rooms.category_id";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $temp_3 ["categories"] = array ();
        $temp_keys = array_keys ( $temp_1 );
        foreach ( $temp_keys as $key ) {
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;

            $sss = $this->getpricecalculation ( $post_data, 0 );
            // echo "<pre>";
            // print_r($sss);
            $total = 0;
            for($i = 0; $i < count ( $sss ); $i ++) {
                $total += $sss [$i] ["amount"];
            }

            if ($total == 0) {
                $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
            }
            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $total."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["amount"] = $total*$rate;
                $temp_3 ["categories"] [$key] ["amount"] = $total;
                $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
            }
        }
        $temp_time_2 = microtime ( true );

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $temp_3 );
        print_r ( $output );
        // echo $output;
    }
    function getfreeroomsarray2($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1) {
        $temp_time_1 = microtime ( true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }
        // $this->output->enable_profiler(TRUE);
        // $rate = $this->frontdesk->getrate($currency);
        // echo $rate;
        // require_once('JSON.php');
        // $json = new Services_JSON();
        if ($price_type == 0) {
            $sql = "SELECT value FROM gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }

        if ($price_type == 0 or $price_type == '') {
            $price_name_id = 1;
        } else {
            // $sql = "SELECT table_name FROM rate WHERE id = " . $data
            // ["price_type"];
            // $query = $this->db->query ( $sql );
            // $row = $query->row ();
            $price_name_id = $price_type;
        }
        $array_prices_seasons = array ();

        $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        WHERE categories.web_booking = 1
        AND rate.id = $price_name_id
        GROUP BY seasonspricelist.category_id, seasons.id
        ";

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $array_prices_seasons [$row->category_id] [$row->season_id] ["price"] = $row->price;
                $array_prices_seasons [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                $array_prices_seasons [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
            }
        }

        $sql = "SELECT * FROM seasons";
        $query = $this->db->query ( $sql );
        $season_data = array ();
        foreach ( $query->result () as $row ) {
            // print_r( $row) . "\n";
            $season_data [$row->id] ["from"] = $row->startdate;
            $season_data [$row->id] ["to"] = $row->enddate;
        }

        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.add_places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $temp_3 ["categories"] = array ();
        $temp_keys = array_keys ( $temp_1 );
        foreach ( $temp_keys as $key ) {
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;

            $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
            $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

            $sss = $this->getpricecalculation2 ( $post_data, 0, 1, "", $array_prices_seasons, $season_data );
            // echo "<pre>";
            // print_r($sss);
            $total = 0;
            $add_places_total = 0;
            for($i = 0; $i < count ( $sss ); $i ++) {
                $total += $sss [$i] ["amount"];
                $add_places_total += $sss [$i] ["add_places_amount"];
            }

            if ($total == 0) {
                $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
            }
            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $total."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["amount"] = $total*$rate;
                $temp_3 ["categories"] [$key] ["add_price"] = $add_places_total;
                $temp_3 ["categories"] [$key] ["amount"] = $total;

                $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
            }
        }

        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
            }
        }
        $temp_time_2 = microtime ( true );

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $temp_3 );
        print_r ( $output );
        // echo $output;
    }
    function getfreeroomsarray2_3($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1, $personal_type = 1, $discountpromocode = 0, $language = "ru", $countplaces = 0, $forceroomid = 0) {
        $worktime_start = round ( time () );
        $my_rates = array ();
        // echo $countplaces;
        /*
         * $my_rates [0] ["rateid"] = 21; $my_rates [0] ["restrict_id"] = 3; $my_rates [0] ["place_count"] = 0; $my_rates [1] ["rateid"] = 22; $my_rates [1] ["restrict_id"] = 1; $my_rates [1] ["place_count"] = 0; $my_rates [2] ["rateid"] = 23; $my_rates [2] ["restrict_id"] = 3; $my_rates [2] ["place_count"] = 0;
         */
        $forceroomid_sql_1 = " ";
        $forceroomid_sql_2 = " ";
        if ($forceroomid != 0) {
            $forceroomid_sql_1 = "AND category_id = " . $forceroomid . " ";
            $forceroomid_sql_2 = "AND categories.id = " . $forceroomid . " ";
        }

        $sql = "SELECT * FROM onlinerates INNER JOIN rate ON rate.id = onlinerates.rateid";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                if ($row->rateid != 0) {
                    array_push ( $my_rates, array (
                        "rateid" => $row->rateid,
                        "restrictid" => $row->restrictid,
                        "timeshift" => $row->timeshift
                    ) );
                }
            }
        }

        $count_myrates = count ( $my_rates );

        $rate_2_sql = "";
        for($i = 0; $i < $count_myrates; $i ++) {
            if ($i == ($count_myrates - 1)) {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . " ";
            } else {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . ", ";
            }
        }
        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;

        $duration = $intdateout - $intdatein;
        $temp_time_1 = microtime ( true );
        // $_POST['debug'] = true;
        $discount_percent = 0;

        $discount_code_array = array ();
        $sql = "SELECT * FROM onlinediscount WHERE datestart <= '" . $datein . "' AND dateend >= '" . $dateout . "'";
        // echo $sql;
        $query = $this->db->query ( $sql );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $discount_code_array [$row->code] = $row->percent;
            }
        }

        if (isset ( $discount_code_array [$discountpromocode] )) {
            $discount_percent = $discount_code_array [$discountpromocode];
        }
        // if ($discountpromocode == "777") {
        // $discount_percent = 10;
        // }

        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
            }
        }

        // $this->output->enable_profiler(TRUE);

        if ($personal_type == 2) {
            $personal_table = "gatewayoforder_personal";
        } else {
            $personal_table = "gatewayoforder";
        }
        // $personal_table = "gatewayoforder_personal";

        $rate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'rate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $rate_restrictID = $row->value;
        }

        $additionalrate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalrate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalrate_restrictID = $row->value;
        }

        $deskofrates = array ();

        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout $forceroomid_sql_1 GROUP BY rate_id, category_id";
        // echo $sql;
        // die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }

        $deskof_restrictedprice = array ();
        $deskof_restrictedprice = $this->frontdesk->get_yieldprice ( $intdatein, $intdateout );

        $rate_strategy = $this->frontdesk->GetRateStrategy ();

        /*
         * $sql = "SELECT * FROM yieldprice WHERE intdate >= $intdatein AND intdate < $intdateout "; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { foreach ( $query->result () as $row ) { $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["perperson_price"] = $row->perperson_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["extrabed_price"] = $row->extrabed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["baby_2price"] = $row->baby_2price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice; } }
         */

        // echo "<pre>";
        // print_r ( $deskofrates );
        $additionalplaces = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalplaces'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalplaces = $row->value;
        }

        if ($price_type == 0) {
            $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }

        if ($price_type == 0 or $price_type == '') {
            $price_name_id = 1;
        } else {
            $price_name_id = $price_type;
        }
        $rates = array ();
        $temp_categories_places = array ();
        $sql = "SELECT id, add_places, places FROM categories";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                // $rates [0] [$row->id] ["id"] = 0;
                // $rates [0] [$row->id] ["description"] = "";
                // $rates [0] [$row->id] ["add_place"] = 0;
                // $rates [0] [$row->id] ["baseplace"] = $row->places;

                $temp_categories_places [$row->id] ["add_places"] = $row->add_places;
                $temp_categories_places [$row->id] ["places"] = $row->places;
            }
        }
        $additional_price_type = 0;
        $sql = "SELECT value FROM $personal_table WHERE name LIKE 'additional_rateID'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additional_price_type = $row->value;
        }

        $ratetocategory = array ();
        $sql = "SELECT category_id, rate_id, onlinebook FROM ratetocategory";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $ratetocategory [$row->category_id] [$row->rate_id] ["onlinebook"] = $row->onlinebook;
            }
        }

        $rate_select_sql = $price_type;
        if ($additional_price_type != 0) {
            $rate_select_sql = $price_type . "," . $additional_price_type;
        }

        $global_array_restrict = array ();
        $global_array_restrict ["main"] ["rate"] = $price_type;
        $global_array_restrict ["main"] ["rate_restrict"] = $rate_restrictID;

        $global_array_restrict ["additional"] ["rate"] = $additional_price_type;
        $global_array_restrict ["additional"] ["rate_restrict"] = $additionalrate_restrictID;

        $array_prices_seasons = array ();
        $debug = array ();
        $debug ['countplaces'] = $countplaces;

        // =================================================================================================
        // =================================================================================================
        // =================================================================================================
        $query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'overbooking_category_id'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $overbookcatid = $row->value;
        }

        $categories_rooms = array ();
        // $sql = "SELECT count(1) as count, categories.id FROM categories INNER JOIN rooms ON rooms.category_id = categories.id WHERE categories.is_active = 1 AND rooms.is_active = 1 GROUP BY categories.id";
        $sql = "SELECT count(1) as count, categories.id FROM categories INNER JOIN rooms ON rooms.category_id = categories.id WHERE categories.is_active = 1 AND categories.web_booking = 1 GROUP BY categories.id";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $categories_rooms [$row->id] = $row->count;
        }
        //echo "<pre>";
        //print_r($categories_rooms);
        $sql = "SELECT categories.id as category_id, deskofdays.intdate, count(1) as notfree_count  FROM deskofdays
	INNER JOIN deskofreservation ON deskofreservation.id=deskofdays.reservation_id
	INNER JOIN rooms ON rooms.id=deskofreservation.room_id
	INNER JOIN categories ON categories.id=rooms.category_id
	WHERE categories.web_booking = 1 AND intdate >=" . $intdatein . " AND intdate <" . $intdateout . " AND deskofreservation.cancel <> 1 AND deskofreservation.deleted <> 1 GROUP BY categories.id, deskofdays.intdate";
        // echo $sql . "<br>";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $categories_rooms_insystem [$row->category_id] [$row->intdate] ['not_free_count'] = $row->notfree_count;
        }
        //echo "<pre>";
        //print_r($categories_rooms_insystem);
        $overbooking_reservations_array = array ();
        $sql = "SELECT deskofreservation.origin_categoryid,  deskofdays.intdate, count(1) as obc  FROM deskofdays
INNER JOIN deskofreservation ON deskofreservation.id=deskofdays.reservation_id
INNER JOIN rooms ON rooms.id=deskofdays.room_id
INNER JOIN guests ON guests.id=deskofreservation.guest_id
LEFT JOIN dealers ON dealers.id=deskofreservation.id_dealer
WHERE origin_categoryid <> 0 AND intdate >=" . $intdatein . " AND intdate < " . $intdateout . "
AND rooms.category_id = $overbookcatid AND deskofreservation.cancel <> 1 AND deskofreservation.deleted <> 1 group by origin_categoryid, deskofdays.intdate";
        // echo $sql . "<br>";
        // die();
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $overbooking_reservations_array [$row->origin_categoryid] [$row->intdate] = $row->obc;
        }

        $timeline = $intdateout - $intdatein;
        $categories_select_arr = array();
        $cat_i = 0;
        foreach ( $categories_rooms as $category_id => $value ) {
            for($i = 0; $i < $timeline; $i ++) {
                if (isset ( $overbooking_reservations_array [$category_id] [$intdatein + $i] )) {
                    if (isset ( $categories_rooms_insystem [$category_id] [$intdatein + $i] ["not_free_count"] )) {
                        $sum_rooms = ($categories_rooms [$category_id] - $categories_rooms_insystem [$category_id] [$intdatein + $i] ["not_free_count"]) - ($overbooking_reservations_array [$category_id] [$intdatein + $i]);
                    } else {
                        $sum_rooms = $categories_rooms [$category_id] - ($overbooking_reservations_array [$category_id] [$intdatein + $i]);
                    }
                } else {
                    if (! isset ( $categories_rooms_insystem [$category_id] [$intdatein + $i] ["not_free_count"] )) {
                        $sum_rooms = $categories_rooms [$category_id];
                    } else {
                        $sum_rooms = ($categories_rooms [$category_id] - $categories_rooms_insystem [$category_id] [$intdatein + $i] ["not_free_count"]);
                    }
                }
            }
            if($sum_rooms > 0 ){
                $categories_select_arr[$category_id] = $sum_rooms;
                $cat_i++;
            }
        }
        $categories_select = "";
        $count_categories = count($categories_select_arr);
        if($count_categories > 0){
            $categories_select .= " categories.id IN (";
            $i = 0;
            foreach($categories_select_arr as $category_id => $summ){
                if(($i+1) == $count_categories){
                    $categories_select .= $category_id.") AND ";
                }else{
                    $categories_select .= $category_id.", ";
                }
                $i++;
            }
        }
        //echo "<pre>";
        //print_r($categories_select_arr);
        // ========================================================================================================================================
        // ========================================================================================================================================
        // ========================================================================================================================================

        $sql = "SELECT  $personal_table.name, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng, ratetocategory.description_ua
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN $personal_table ON $personal_table.value = rate.id
        WHERE $categories_select ratetocategory.onlinebook = 1 AND categories.web_booking = 1 AND ($personal_table.name LIKE 'rateID' OR $personal_table.name LIKE 'additional_rateID')
        AND rate.id in ( $rate_select_sql ) $forceroomid_sql_2
        GROUP BY $personal_table.name,seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY $personal_table.name DESC
        ";
        // echo $sql."<br>";
        $debug ['sql'] = $sql;

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $rates = array ();
            foreach ( $query->result () as $row ) {
                $description = "";
                $baseplace = 0;
                $maxplace = 0;
                /*
                 * $query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id ); if ($query2->num_rows () > 0) { $row2 = $query2->row (); switch ($language) { case "ua" : $description = $row2->description_ua; break; case "en" : $description = $row2->description_eng; break; case "ru" : $description = $row2->description; break; default : $description = $row2->description; break; } $baseplace = $row2->baseplace; $maxplace = $row2->maxplace; }
                 */

                switch ($language) {
                    case "ua" :
                        $description = $row->description_ua;
                        break;
                    case "en" :
                        $description = $row->description_eng;
                        break;
                    case "ru" :
                        $description = $row->description;
                        break;
                    default :
                        $description = $row->description;
                        break;
                }

                $baseplace = $row->baseplace;
                $maxplace = $row->maxplace;

                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                $rates [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                $rates [$row->rate_id] [$row->category_id] ["description"] = $description;

                $rates [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                $rates [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                if ($maxplace == 0) {
                    $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                } else {
                    // $maxplace = $row2->maxplace;
                }
                if ($baseplace == 0) {
                    $baseplace = $temp_categories_places [$row->category_id] ["places"];
                } else {
                    // $baseplace = $row2->baseplace;
                }

                if (($maxplace - $baseplace) > $additionalplaces) {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                } else {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                }
                $rates [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;

                if ($row->name == "rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $rate_restrictID;
                }
                if ($row->name == "additional_rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $additionalrate_restrictID;
                }
            }
        }

        // echo "<pre>";
        // print_r ( $rates );

        /*
         * rates_2
         */
        $rates_2 = array ();
        if ($count_myrates > 0) {
            $array_prices_seasons_2 = array ();
            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, onlinerates.restrictid,
            seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
            ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng, ratetocategory.description_ua
            FROM seasonspricelist
            INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
            INNER JOIN rate ON rate.id = seasonspricelist.rate_id
            INNER JOIN categories ON categories.id = seasonspricelist.category_id
            INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
            INNER JOIN onlinerates ON rate.id = onlinerates.rateid
            WHERE $categories_select ratetocategory.onlinebook = 1 AND categories.web_booking = 1 $forceroomid_sql_2
            GROUP BY seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY onlinerates.id ASC
            ";
            // echo $sql."<br>";
            $debug ['sql'] = $sql;

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {

                foreach ( $query->result () as $row ) {
                    $description = "";
                    $baseplace = 0;
                    $maxplace = 0;
                    /*
                     * $query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id ); if ($query2->num_rows () > 0) { $row2 = $query2->row (); switch ($language) { case "ua" : $description = $row2->description_ua; break; case "en" : $description = $row2->description_eng; break; case "ru" : $description = $row2->description; break; default : $description = $row2->description; break; } $baseplace = $row2->baseplace; $maxplace = $row2->maxplace; }
                     */
                    switch ($language) {
                        case "ua" :
                            $description = $row->description_ua;
                            break;
                        case "en" :
                            $description = $row->description_eng;
                            break;
                        case "ru" :
                            $description = $row->description;
                            break;
                        default :
                            $description = $row->description;
                            break;
                    }

                    $baseplace = $row->baseplace;
                    $maxplace = $row->maxplace;

                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                    $rates_2 [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                    $rates_2 [$row->rate_id] [$row->category_id] ["description"] = $description;

                    $rates_2 [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                    $rates_2 [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                    if ($maxplace == 0) {
                        $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                    } else {
                        // $maxplace = $row2->maxplace;
                    }
                    if ($baseplace == 0) {
                        $baseplace = $temp_categories_places [$row->category_id] ["places"];
                    } else {
                        // $baseplace = $row2->baseplace;
                    }

                    if (($maxplace - $baseplace) > $additionalplaces) {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                    } else {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                    }
                    $rates_2 [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;
                    $rates_2 [$row->rate_id] [$row->category_id] ["restrictid"] = $row->restrictid;
                }
            }
        }

        /*
         * end rates_2
         */
        // echo "<pre>";
        // print_r ( $rates_2 );

        // $debug['ar_pr_season'] = $array_prices_seasons;
        $debug ['rates'] = $rates;
        $debug ['restrict'] = $deskofrates;
        $debug ['restrict_prices'] = $deskof_restrictedprice;
        // echo "<pre>";
        // print_r($rates);

        /*
         * $sql = "SELECT * FROM seasons"; $query = $this->db->query ( $sql ); $season_data = array (); foreach ( $query->result () as $row ) { $season_data [$row->id] ["from"] = $row->startdate; $season_data [$row->id] ["to"] = $row->enddate; } $seasontable = array (); $seasontable = $this->getcosttable ( $datein, $dateout, $season_data ); $debug ['seasontable'] = $seasontable;
         */
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
        categories.baby_price, categories.name as c_name, categories.shortname, categories.comment, categories.comment_ru, categories.comment_eng, categories.comment_ua,
        categories.name_ru, categories.name_eng, categories.name_ua,
        categories.places, categories.add_places, categories.settlementtype FROM rooms
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE $categories_select categories.web_booking = 1 $forceroomid_sql_2
        GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                // $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                switch ($language) {
                    case "ua" :
                        if ($row ["name_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ua"];
                        }
                        if ($row ["comment_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ua"];
                        }
                        break;
                    case "en" :
                        if ($row ["name_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_eng"];
                        }
                        if ($row ["comment_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_eng"];
                        }
                        break;
                    case "ru" :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                    default :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                }
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                // $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }

        $temp_3 = array ();
        $max_places_select_arr = array ();
        $debug ["temp_1"] = $temp_1;
        $temp_3 ['debug'] = $debug;
        $temp_3 ["categories"] = array ();

        $temp_keys = array_keys ( $temp_1 );

        foreach ( $temp_keys as $key ) {
            $row_count = 0;
            $base_row_count = 0;
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;
            if ($discount_percent != 0) {
                $discount_value = ($temp_1 [$key] ["base_price"] / 100) * $discount_percent;
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"] - $discount_value;
                $post_data ["original_price"] = $temp_1 [$key] ["base_price"];
            } else {
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            }
            // $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
            $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

            $post_data ["rate_restricted"] [$price_type] = $rate_restrictID;
            $post_data ["rate_restricted"] [$additional_price_type] = $additionalrate_restrictID;


            $temp_3 ["categories"] [$key] ["count"] = $categories_select_arr[$key];
            $temp_3 ["categories"] [$key] ["name"] = stripslashes ( $temp_1 [$key] ["name"] );
            $temp_3 ["categories"] [$key] ["online_name"] = stripslashes ( $temp_1 [$key] ["name"] );
            $temp_3 ["categories"] [$key] ["shortname"] = stripslashes ( $temp_1 [$key] ["shortname"] );
            $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
            // $temp_3["categories"] [$key] ["places"] = $temp_1 [$key]
            // ["places"];
            $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
            // $temp_3["categories"] [$key] ["amount"] = $total*$rate;

            $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
            $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
            $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
            $arr_keys = array_keys ( $rates );
            if (count ( $rates ) != 0) {
                $temp_nonrefundable = "non";
                $temp_breakfast = "non";
                foreach ( $arr_keys as $row ) {
                    $insert_rate_category = 1;

                    $conditions_bool_count = 0;
                    $debug ['rate_category'] [$key] [$row] = $insert_rate_category;
                    if ($insert_rate_category == 1) {

                        $bool_restrict = 0;
                        if ($temp_nonrefundable != "non" and $temp_breakfast != "non") {
                            if ($temp_nonrefundable == $rates [$row] [$key] ["nonrefundable"] and $temp_breakfast == $rates [$row] [$key] ["breakfast"]) {
                            } else {
                                $conditions_bool_count = 1;
                            }
                        }

                        if (isset ( $rates [$row] [$key] ["restrictid"] )) {
                            $rate_restrict = $rates [$row] [$key] ["restrictid"];
                        }

                        if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                            if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                $bool_restrict = 1;
                            }
                        }
                        if ($bool_restrict == 0) {
                            $row_count ++;
                            $rate_i = $row;

                            $time_1 = microtime ( true );
                            if ($rate_i != 0) {

                                $post_data ["price_type"] = $row;
                                $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy );
                            } else {
                                $sss = array ();
                            }

                            $debug ['tariff'] [$rate_i] = $sss;
                            $time_2 = microtime ( true );
                            $total = 0;
                            $add_places_total = 0;
                            for($i = 0; $i < count ( $sss ); $i ++) {
                                $total += $sss [$i] ["amount"];
                                $add_places_total += $sss [$i] ["add_places_amount"];
                            }
                            if ($total == 0) {
                                $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                            }
                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] = $rates [$row] [$key] ["baseplace"];
                            $max_places_select_arr [$rates [$row] [$key] ["baseplace"]] = true;
                            if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] and $countplaces != 0) {
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = 0;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = 0;
                                for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {
                                    $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $i] = true;
                                }
                            } else {
                                for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {

                                    if ($discount_percent != 0) {
                                        $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                    } else {
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                    }
                                    // $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"] = $i;
                                    $row_count ++;
                                    if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = $add_places_total * $i;
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"];
                                    }

                                    $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]] = true;
                                }
                            }

                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_price"] = $add_places_total;
                            if ($discount_percent != 0) {
                                $discount_value = ($total / 100) * $discount_percent;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total - $discount_value;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["original_price"] = $total;
                            } else {
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total;
                            }
                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["time"] = $time_2 - $time_1;
                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["description"] = $rates [$row] [$key] ["description"];
                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["nonrefundable"] = $rates [$row] [$key] ["nonrefundable"];
                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["breakfast"] = $rates [$row] [$key] ["breakfast"];

                            $temp_nonrefundable = $rates [$row] [$key] ["nonrefundable"];
                            $temp_breakfast = $rates [$row] [$key] ["breakfast"];

                            $temp_3 ["categories"] [$key] ['rates'] [$row] ['c_row_bool_count'] = $conditions_bool_count;

                            $base_row_count ++;
                        }
                    }
                }
            } else {
            }

            $new_count_my_rates = 0;
            // echo $count_myrates;
            $count_rate_2 = count ( $rates_2 );
            for($r = 0; $r < $count_rate_2; $r ++) {
                $timeshift_bool = 0;
                $timeshift = $my_rates [$r] ["timeshift"];

                if ($timeshift != 0) {
                    if ($timeshift < 0) {
                        if (($datein_hours + $timeshift) < $datenow_hours) {
                            $timeshift_bool = 1;
                        }
                    }
                    if ($timeshift > 0) {
                        if (($datein_hours - $datenow_hours) > $timeshift) {
                            $timeshift_bool = 1;
                        }
                    }
                } else {
                    $timeshift_bool = 1;
                }
                if ($timeshift_bool == 1) {
                    $bool_restrict = 0;
                    if ($my_rates [$r] ["restrictid"] != 0 and $my_rates [$r] ["restrictid"] != "") {
                        $rate_restrict = $my_rates [$r] ["restrictid"];
                        if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                            if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                $bool_restrict = 1;
                            }
                        }
                    }
                    if ($bool_restrict == 0) {
                        // echo "11111112222222222222<br>";
                        // $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] = $temp_3 ["categories"] [$key] ['rates'] [1];
                        $rate_i = $my_rates [$r] ["rateid"];
                        // echo $rate_i."<br>";
                        if (isset ( $rates_2 [$rate_i] [$key] )) {
                            // echo "++";
                            $time_1 = microtime ( true );
                            if ($rate_i != 0) {
                                // $sss = $this->getpricecalculation3 (
                                // $post_data,
                                // 0, 1, "", $array_prices_seasons [$rate_i],
                                // $season_data, $seasontable );
                                $post_data ["price_type"] = $rate_i;
                                $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy );
                            } else {
                                $sss = array ();
                            }
                            // echo "<pre>$rate_i".$rates_2 [$rate_i] [$key] ["baseplace"];
                            // print_r($sss);
                            // die();
                            $debug ['tariff'] [$rate_i] = $sss;
                            $time_2 = microtime ( true );
                            $total = 0;
                            $add_places_total = 0;
                            for($i = 0; $i < count ( $sss ); $i ++) {
                                $total += $sss [$i] ["amount"];
                                $add_places_total += $sss [$i] ["add_places_amount"];
                            }
                            if ($total == 0) {
                                $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                            }
                            // echo $rate_i." ".$key."<br>";
                            $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                            // ==============================================
                            // ==============================================
                            // ==============================================
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                            $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                            if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] and $countplaces != 0) {
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = 0;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = 0;
                                for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {
                                    $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $i] = true;
                                }
                            } else {
                                for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {

                                    if ($discount_percent != 0) {
                                        $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                    } else {
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                    }
                                    // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i;
                                    $row_count ++;
                                    if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = $add_places_total * $i;
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"];
                                    }

                                    $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true;
                                }
                            }
                            // ==============================================
                            // ==============================================
                            // ==============================================

                            /*
                             * for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) { if ($discount_percent != 0) { $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i); } else { $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); } // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i; $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true; $row_count ++; }
                             */
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                            ;
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_price"] = $add_places_total;
                            if ($discount_percent != 0) {
                                $discount_value = ($total / 100) * $discount_percent;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total - $discount_value;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["original_price"] = $total;
                            } else {
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total;
                            }
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["time"] = $time_2 - $time_1;
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["description"] = $rates_2 [$rate_i] [$key] ["description"];
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["nonrefundable"] = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["breakfast"] = $rates_2 [$rate_i] [$key] ["breakfast"];

                            $temp_nonrefundable = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                            $temp_breakfast = $rates_2 [$rate_i] [$key] ["breakfast"];
                            if (! isset ( $conditions_bool_count )) {
                                $conditions_bool_count = 0;
                            }
                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ['c_row_bool_count'] = $conditions_bool_count;

                            $row_count ++;

                            $new_count_my_rates ++;
                        }
                    }
                }
            }

            // $temp_3 ["categories"] [$key] ['c_row_bool_count'] = $conditions_bool_count;
            $temp_3 ["categories"] [$key] ['row_count'] = $row_count;
            $temp_3 ["categories"] [$key] ['base_row_count'] = $base_row_count + $new_count_my_rates;
            if (isset ( $temp_3 ["categories"] [$key] ['rates'] )) {
            } else {
                unset ( $temp_3 ["categories"] [$key] );
            }
        }

        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
                $temp_3 ["services"] [$row ["id"]] ["description"] = $row ["description"];
            }
        }
        $temp_time_2 = microtime ( true );
        $temp_3 ['debug'] = $debug;

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>+++++++++++++++++++++++++++++++++++++";
        // print_r ( $temp_3 );
        if ($countplaces != 0) {
            $temp_keys = array_keys ( $temp_3 ["categories"] );

            foreach ( $temp_keys as $key ) {
                $arr_keys = array_keys ( $temp_3 ["categories"] [$key] ['rates'] );
                $unset_bool = 0;
                foreach ( $arr_keys as $row ) {
                    if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] )) {
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"];
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"];
                        // $temp_3 ["categories"] [$key] ['row_count'] = 1;
                        // $temp_3 ["categories"] [$key] ['base_row_count'] = 1;
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list);

                        $unset_bool = 1;
                    } else {
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list + 1);
                        $temp_3 ["categories"] [$key] ['base_row_count'] = $temp_3 ["categories"] [$key] ['base_row_count'] - 1;
                    }
                }
                if ($unset_bool == 0) {
                    unset ( $temp_3 ["categories"] [$key] );
                }
            }
        }
        // print_r ( $temp_3 );
        $max_places_select_arr [0] = 1;
        $temp_3 ["max_places_select_arr"] = $max_places_select_arr;
        $temp_3 ['debug'] = "skip";
        $output = json_encode ( $temp_3 );

        $worktime_end = round ( time () );
        $worktime = $worktime_end - $worktime_start;
        $sql = "INSERT INTO global_hotelix_analitycs.freeroom_request(hmsid, funcid, host, worktime, timestamp) VALUES(" . $this->config->item ( 'hotel_id' ) . ", 1, '', '" . $worktime . "', '" . date ( "Y-m-d H:i:s" ) . "')";
        $query = $this->db->query ( $sql );

        echo $output;
    }

    function get_online_services(){
        $online_services = array();
        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $online_services ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $online_services ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
                $online_services ["services"] [$row ["id"]] ["description"] = $row ["description"];
            }
        }
        $output = json_encode ( $online_services );

        echo $output;
    }

    function getfreeroomsarray2_2($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1, $personal_type = 1, $discountpromocode = 0, $language = "ru", $countplaces = 0, $forceroomid = 0) {
        //return ;
        $worktime_start = round ( time ( ));
        $my_rates = array ();
        // echo $countplaces;
        /*
         * $my_rates [0] ["rateid"] = 21; $my_rates [0] ["restrict_id"] = 3; $my_rates [0] ["place_count"] = 0; $my_rates [1] ["rateid"] = 22; $my_rates [1] ["restrict_id"] = 1; $my_rates [1] ["place_count"] = 0; $my_rates [2] ["rateid"] = 23; $my_rates [2] ["restrict_id"] = 3; $my_rates [2] ["place_count"] = 0;
         */
        $forceroomid_sql_1 = " ";
        $forceroomid_sql_2 = " ";
        if($forceroomid <> 0){
            $forceroomid_sql_1 = "AND category_id = ".$forceroomid." ";
            $forceroomid_sql_2 = "AND categories.id = ".$forceroomid." ";
        }

        $sql = "SELECT * FROM onlinerates INNER JOIN rate ON rate.id = onlinerates.rateid";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                if ($row->rateid != 0) {
                    array_push ( $my_rates, array (
                        "rateid" => $row->rateid,
                        "restrictid" => $row->restrictid,
                        "timeshift" => $row->timeshift
                    ) );
                }
            }
        }

        $count_myrates = count ( $my_rates );

        $rate_2_sql = "";
        for($i = 0; $i < $count_myrates; $i ++) {
            if ($i == ($count_myrates - 1)) {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . " ";
            } else {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . ", ";
            }
        }
        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;

        $duration = $intdateout - $intdatein;
        $temp_time_1 = microtime ( true );
        // $_POST['debug'] = true;
        $discount_percent = 0;

        $discount_code_array = array ();
        $sql = "SELECT * FROM onlinediscount WHERE datestart <= '" . $datein . "' AND dateend >= '" . $dateout . "'";
        // echo $sql;
        $query = $this->db->query ( $sql );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $discount_code_array [$row->code] = $row->percent;
            }
        }
        //print_r($discount_code_array);
        if (isset ( $discount_code_array [$discountpromocode] )) {
            $discount_percent = $discount_code_array [$discountpromocode];
        }
        // if ($discountpromocode == "777") {
        // $discount_percent = 10;
        // }
        //echo $discount_percent;
        //die();
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
            }
        }

        // $this->output->enable_profiler(TRUE);

        if ($personal_type == 2) {
            $personal_table = "gatewayoforder_personal";
        } else {
            $personal_table = "gatewayoforder";
        }
        // $personal_table = "gatewayoforder_personal";

        $rate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'rate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $rate_restrictID = $row->value;
        }

        $additionalrate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalrate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalrate_restrictID = $row->value;
        }

        $deskofrates = array ();

        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout $forceroomid_sql_1 GROUP BY rate_id, category_id";
        // echo $sql;
        // die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }

        $deskof_restrictedprice = array ();
        $deskof_restrictedprice = $this->frontdesk->get_yieldprice ( $intdatein, $intdateout );

        $rate_strategy = $this->frontdesk->GetRateStrategy ();

        /*
         * $sql = "SELECT * FROM yieldprice WHERE intdate >= $intdatein AND intdate < $intdateout "; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { foreach ( $query->result () as $row ) { $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["perperson_price"] = $row->perperson_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["extrabed_price"] = $row->extrabed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["baby_2price"] = $row->baby_2price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice; } }
         */

        // echo "<pre>";
        // print_r ( $deskofrates );
        $additionalplaces = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalplaces'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalplaces = $row->value;
        }

        if ($price_type == 0) {
            $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }

        if ($price_type == 0 or $price_type == '') {
            $price_name_id = 1;
        } else {
            $price_name_id = $price_type;
        }
        $rates = array ();
        $temp_categories_places = array ();
        $sql = "SELECT id, add_places, places FROM categories";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                // $rates [0] [$row->id] ["id"] = 0;
                // $rates [0] [$row->id] ["description"] = "";
                // $rates [0] [$row->id] ["add_place"] = 0;
                // $rates [0] [$row->id] ["baseplace"] = $row->places;

                $temp_categories_places [$row->id] ["add_places"] = $row->add_places;
                $temp_categories_places [$row->id] ["places"] = $row->places;
            }
        }
        $additional_price_type = 0;
        $sql = "SELECT value FROM $personal_table WHERE name LIKE 'additional_rateID'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additional_price_type = $row->value;
        }

        $ratetocategory = array ();
        $sql = "SELECT category_id, rate_id, onlinebook FROM ratetocategory";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $ratetocategory [$row->category_id] [$row->rate_id] ["onlinebook"] = $row->onlinebook;
            }
        }

        $rate_select_sql = $price_type;
        if ($additional_price_type != 0) {
            $rate_select_sql = $price_type . "," . $additional_price_type;
        }

        $global_array_restrict = array ();
        $global_array_restrict ["main"] ["rate"] = $price_type;
        $global_array_restrict ["main"] ["rate_restrict"] = $rate_restrictID;

        $global_array_restrict ["additional"] ["rate"] = $additional_price_type;
        $global_array_restrict ["additional"] ["rate_restrict"] = $additionalrate_restrictID;

        $array_prices_seasons = array ();
        $debug = array ();
        $debug ['countplaces'] = $countplaces;

        $sql = "SELECT  $personal_table.name, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng,  ratetocategory.description_pl, ratetocategory.description_ua
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN $personal_table ON $personal_table.value = rate.id
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1 AND ($personal_table.name LIKE 'rateID' OR $personal_table.name LIKE 'additional_rateID')
        AND rate.id in ( $rate_select_sql ) $forceroomid_sql_2
        GROUP BY $personal_table.name,seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY $personal_table.name DESC
        ";
        //echo $sql."<br>";
        $debug ['sql'] = $sql;

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $rates = array ();
            foreach ( $query->result () as $row ) {
                $description = "";
                $baseplace = 0;
                $maxplace = 0;
                /*
                 $query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id );
                 if ($query2->num_rows () > 0) {
                 $row2 = $query2->row ();

                 switch ($language) {
                 case "ua" :
                 $description = $row2->description_ua;
                 break;
                 case "en" :
                 $description = $row2->description_eng;
                 break;
                 case "ru" :
                 $description = $row2->description;
                 break;
                 default :
                 $description = $row2->description;
                 break;
                 }

                 $baseplace = $row2->baseplace;
                 $maxplace = $row2->maxplace;
                 }
                 */

                switch ($language) {
                    case "ua" :
                        $description = $row->description_ua;
                        break;
                    case "en" :
                        $description = $row->description_eng;
                        break;
                    case "ru" :
                        $description = $row->description;
                        break;
                    case "pl" :
                        $description = $row->description_pl;
                        break;
                    default :
                        $description = $row->description;
                        break;
                }

                $baseplace = $row->baseplace;
                $maxplace = $row->maxplace;

                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                $rates [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                $rates [$row->rate_id] [$row->category_id] ["description"] = $description;

                $rates [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                $rates [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                if ($maxplace == 0) {
                    $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                } else {
                    //$maxplace = $row2->maxplace;
                }
                if ($baseplace == 0) {
                    $baseplace = $temp_categories_places [$row->category_id] ["places"];
                } else {
                    //$baseplace = $row2->baseplace;
                }

                if (($maxplace - $baseplace) > $additionalplaces) {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                } else {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                }
                $rates [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;

                if ($row->name == "rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $rate_restrictID;
                }
                if ($row->name == "additional_rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $additionalrate_restrictID;
                }
            }
        }

        // echo "<pre>";
        //print_r ( $rates );

        /*
         * rates_2
         */
        $rates_2 = array ();
        if ($count_myrates > 0) {
            $array_prices_seasons_2 = array ();
            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, onlinerates.restrictid,
            seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
            ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng,
            ratetocategory.description_pl, ratetocategory.description_ua
            FROM seasonspricelist
            INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
            INNER JOIN rate ON rate.id = seasonspricelist.rate_id
            INNER JOIN categories ON categories.id = seasonspricelist.category_id
            INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
            INNER JOIN onlinerates ON rate.id = onlinerates.rateid
            WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1 $forceroomid_sql_2
            GROUP BY seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY onlinerates.id ASC
            ";
            //echo $sql."<br>";
            $debug ['sql'] = $sql;

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {

                foreach ( $query->result () as $row ) {
                    $description = "";
                    $baseplace = 0;
                    $maxplace = 0;
                    /*$query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id );
                     if ($query2->num_rows () > 0) {
                     $row2 = $query2->row ();

                     switch ($language) {
                     case "ua" :
                     $description = $row2->description_ua;
                     break;
                     case "en" :
                     $description = $row2->description_eng;
                     break;
                     case "ru" :
                     $description = $row2->description;
                     break;
                     default :
                     $description = $row2->description;
                     break;
                     }

                     $baseplace = $row2->baseplace;
                     $maxplace = $row2->maxplace;
                     }
                     */
                    switch ($language) {
                        case "ua" :
                            $description = $row->description_ua;
                            break;
                        case "en" :
                            $description = $row->description_eng;
                            break;
                        case "ru" :
                            $description = $row->description;
                            break;
                        case "pl" :
                            $description = $row->description_pl;
                            break;
                        default :
                            $description = $row->description;
                            break;
                    }

                    $baseplace = $row->baseplace;
                    $maxplace = $row->maxplace;

                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                    $rates_2 [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                    $rates_2 [$row->rate_id] [$row->category_id] ["description"] = $description;

                    $rates_2 [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                    $rates_2 [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                    if ($maxplace == 0) {
                        $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                    } else {
                        //$maxplace = $row2->maxplace;
                    }
                    if ($baseplace == 0) {
                        $baseplace = $temp_categories_places [$row->category_id] ["places"];
                    } else {
                        //$baseplace = $row2->baseplace;
                    }

                    if (($maxplace - $baseplace) > $additionalplaces) {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                    } else {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                    }
                    $rates_2 [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;
                    $rates_2 [$row->rate_id] [$row->category_id] ["restrictid"] = $row->restrictid;
                }
            }
        }

        /*
         * end rates_2
         */
        // echo "<pre>";
        // print_r ( $rates_2 );

        // $debug['ar_pr_season'] = $array_prices_seasons;
        $debug ['rates'] = $rates;
        $debug ['restrict'] = $deskofrates;
        $debug ['restrict_prices'] = $deskof_restrictedprice;
        // echo "<pre>";
        // print_r($rates);

        /*
         $sql = "SELECT * FROM seasons";
         $query = $this->db->query ( $sql );
         $season_data = array ();
         foreach ( $query->result () as $row ) {
         $season_data [$row->id] ["from"] = $row->startdate;
         $season_data [$row->id] ["to"] = $row->enddate;
         }

         $seasontable = array ();
         $seasontable = $this->getcosttable ( $datein, $dateout, $season_data );
         $debug ['seasontable'] = $seasontable;
         */
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
        categories.baby_price, categories.name as c_name, categories.shortname, categories.comment, categories.comment_ru, categories.comment_eng, categories.comment_ua,
        categories.name_ru, categories.name_eng, categories.name_ua, categories.name_pl, categories.comment_pl,
        categories.places, categories.add_places, categories.settlementtype FROM rooms
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 $forceroomid_sql_2
        GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                // $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                switch ($language) {
                    case "ua" :
                        if ($row ["name_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ua"];
                        }
                        if ($row ["comment_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ua"];
                        }
                        break;
                    case "en" :
                        if ($row ["name_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_eng"];
                        }
                        if ($row ["comment_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_eng"];
                        }
                        break;
                    case "ru" :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                    case "pl" :
                        if ($row ["name_pl"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_pl"];
                        }
                        if ($row ["comment_pl"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_pl"];
                        }
                        break;
                    default :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                }
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                // $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= ($intdateout-1)  $forceroomid_sql_2 GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $debug ['sql2'] = $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $max_places_select_arr = array ();
        $debug ["temp_1"] = $temp_1;
        $temp_3 ['debug'] = $debug;
        $temp_3 ["categories"] = array ();

        $temp_keys = array_keys ( $temp_1 );

        foreach ( $temp_keys as $key ) {
            $row_count = 0;
            $base_row_count = 0;
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;
            if ($discount_percent != 0) {
                $discount_value = ($temp_1 [$key] ["base_price"] / 100) * $discount_percent;
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"] - $discount_value;
                $post_data ["original_price"] = $temp_1 [$key] ["base_price"];
            } else {
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            }
            // $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
            $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

            $post_data ["rate_restricted"] [$price_type] = $rate_restrictID;
            $post_data ["rate_restricted"] [$additional_price_type] = $additionalrate_restrictID;

            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $count_rooms."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = stripslashes($temp_1 [$key] ["name"]);
                $temp_3 ["categories"] [$key] ["online_name"] = stripslashes($temp_1 [$key] ["name"]);
                $temp_3 ["categories"] [$key] ["shortname"] = stripslashes($temp_1 [$key] ["shortname"]);
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["places"] = $temp_1 [$key]
                // ["places"];
                $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["amount"] = $total*$rate;

                $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
                $arr_keys = array_keys ( $rates );
                if (count ( $rates ) != 0) {
                    $temp_nonrefundable = "non";
                    $temp_breakfast = "non";
                    foreach ( $arr_keys as $row ) {
                        $insert_rate_category = 1;
                        /*
                         * if (isset ( $ratetocategory [$key] [$row] ["onlinebook"] )) { if ($ratetocategory [$key] [$row] ["onlinebook"] == 0) { $insert_rate_category = 0; } }
                         */
                        // echo $insert_rate_category."<br>";
                        $conditions_bool_count = 0;
                        $debug ['rate_category'] [$key] [$row] = $insert_rate_category;
                        if ($insert_rate_category == 1) {

                            $bool_restrict = 0;
                            if ($temp_nonrefundable != "non" and $temp_breakfast != "non") {
                                if ($temp_nonrefundable == $rates [$row] [$key] ["nonrefundable"] and $temp_breakfast == $rates [$row] [$key] ["breakfast"]) {
                                } else {
                                    $conditions_bool_count = 1;
                                }
                            }
                            // if ($row == $global_array_restrict ["main"] ["rate"])
                            // {
                            // $rate_restrict = $global_array_restrict ["main"]
                            // ["rate_restrict"];
                            // //echo $rate_restrict."<br>";
                            // if ($rate_restrict != 0) {
                            // if(isset($deskofrates [$key] [$rate_restrict]))
                            // if ($deskofrates [$key] [$rate_restrict]
                            // ["max_closed"] > 0 or $deskofrates [$key]
                            // [$rate_restrict] ["max_minstaythrought"] >=
                            // $duration-1) {
                            // $bool_restrict = 1;
                            // }
                            // }
                            // }

                            // if ($row == $global_array_restrict ["additional"]
                            // ["rate"]) {
                            // $rate_restrict = $global_array_restrict
                            // ["additional"] ["rate_restrict"];
                            // if ($rate_restrict != 0) {
                            // if(isset($deskofrates [$key] [$rate_restrict]))
                            // if ($deskofrates [$key] [$rate_restrict]
                            // ["max_closed"] > 0 or $deskofrates [$key]
                            // [$rate_restrict] ["max_minstaythrought"] >=
                            // $duration-1) {
                            // $bool_restrict = 1;
                            // }
                            // }
                            // }

                            if (isset ( $rates [$row] [$key] ["restrictid"] )) {
                                $rate_restrict = $rates [$row] [$key] ["restrictid"];
                            }

                            if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                                if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                    $bool_restrict = 1;
                                }
                            }
                            if ($bool_restrict == 0) {
                                $row_count ++;
                                $rate_i = $row;
                                // echo $row."<br>";
                                $time_1 = microtime ( true );
                                if ($rate_i != 0) {
                                    // $sss = $this->getpricecalculation3 (
                                    // $post_data,
                                    // 0, 1, "", $array_prices_seasons [$rate_i],
                                    // $season_data, $seasontable );
                                    $post_data ["price_type"] = $row;
                                    $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy );
                                } else {
                                    $sss = array ();
                                }
                                // echo "<pre>";
                                // print_r($sss);
                                // die();
                                $debug ['tariff'] [$rate_i] = $sss;
                                $time_2 = microtime ( true );
                                $total = 0;
                                $add_places_total = 0;
                                for($i = 0; $i < count ( $sss ); $i ++) {
                                    $total += $sss [$i] ["amount"];
                                    $add_places_total += $sss [$i] ["add_places_amount"];
                                }
                                if ($total == 0) {
                                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] = $rates [$row] [$key] ["baseplace"];
                                $max_places_select_arr [$rates [$row] [$key] ["baseplace"]] = true;
                                if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] and $countplaces != 0) {
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = 0;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = 0;
                                    for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {
                                        $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $i] = true;
                                    }
                                } else {
                                    for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {

                                        if ($discount_percent != 0) {
                                            $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                        } else {
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        }
                                        // $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"] = $i;
                                        $row_count ++;
                                        if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = $add_places_total * $i;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"];
                                        }

                                        $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]] = true;
                                    }
                                }

                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_price"] = $add_places_total;
                                if ($discount_percent != 0) {
                                    $discount_value = ($total / 100) * $discount_percent;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total - $discount_value;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["original_price"] = $total;
                                } else {
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["time"] = $time_2 - $time_1;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["description"] = $rates [$row] [$key] ["description"];
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["nonrefundable"] = $rates [$row] [$key] ["nonrefundable"];
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["breakfast"] = $rates [$row] [$key] ["breakfast"];

                                $temp_nonrefundable = $rates [$row] [$key] ["nonrefundable"];
                                $temp_breakfast = $rates [$row] [$key] ["breakfast"];

                                $temp_3 ["categories"] [$key] ['rates'] [$row] ['c_row_bool_count'] = $conditions_bool_count;

                                $base_row_count ++;
                            }
                        }
                    }
                } else {
                    // echo "000000000000000";
                    // unset($temp_3 ["categories"] [$key]);
                }
                // print_r($my_rates);
                // echo "datein: ".($intdatein * 24) . "<br>";
                // echo "dateout: ".($intdateout * 24) . "<br>";
                // echo "now: ".($intdatenow * 24) . "<br>";
                $new_count_my_rates = 0;
                // echo $count_myrates;
                $count_rate_2 = count ( $my_rates );
                for($r = 0; $r < $count_rate_2; $r ++) {
                    $timeshift_bool = 0;
                    $timeshift = $my_rates [$r] ["timeshift"];

                    if ($timeshift != 0) {
                        if ($timeshift < 0) {
                            if (($datein_hours + $timeshift) < $datenow_hours) {
                                $timeshift_bool = 1;
                            }
                        }
                        if ($timeshift > 0) {
                            if (($datein_hours - $datenow_hours) > $timeshift) {
                                $timeshift_bool = 1;
                            }
                        }
                    } else {
                        $timeshift_bool = 1;
                    }
                    if ($timeshift_bool == 1) {
                        $bool_restrict = 0;
                        if ($my_rates [$r] ["restrictid"] != 0 and $my_rates [$r] ["restrictid"] != "") {
                            $rate_restrict = $my_rates [$r] ["restrictid"];
                            if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                                if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                    $bool_restrict = 1;
                                }
                            }
                        }
                        if ($bool_restrict == 0) {
                            // echo "11111112222222222222<br>";
                            // $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] = $temp_3 ["categories"] [$key] ['rates'] [1];
                            $rate_i = $my_rates [$r] ["rateid"];
                            // echo $rate_i."<br>";
                            if (isset ( $rates_2 [$rate_i] [$key] )) {
                                // echo "++";
                                $time_1 = microtime ( true );
                                if ($rate_i != 0) {
                                    // $sss = $this->getpricecalculation3 (
                                    // $post_data,
                                    // 0, 1, "", $array_prices_seasons [$rate_i],
                                    // $season_data, $seasontable );
                                    $post_data ["price_type"] = $rate_i;
                                    $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy);
                                } else {
                                    $sss = array ();
                                }
                                // echo "<pre>$rate_i".$rates_2 [$rate_i] [$key] ["baseplace"];
                                // print_r($sss);
                                // die();
                                $debug ['tariff'] [$rate_i] = $sss;
                                $time_2 = microtime ( true );
                                $total = 0;
                                $add_places_total = 0;
                                for($i = 0; $i < count ( $sss ); $i ++) {
                                    $total += $sss [$i] ["amount"];
                                    $add_places_total += $sss [$i] ["add_places_amount"];
                                }
                                if ($total == 0) {
                                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                                }
                                // echo $rate_i." ".$key."<br>";
                                $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                                // ==============================================
                                // ==============================================
                                // ==============================================
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                                $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                                if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] and $countplaces != 0) {
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = 0;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = 0;
                                    for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {
                                        $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $i] = true;
                                    }
                                } else {
                                    for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {

                                        if ($discount_percent != 0) {
                                            $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                        } else {
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        }
                                        // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i;
                                        $row_count ++;
                                        if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = $add_places_total * $i;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"];
                                        }

                                        $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true;
                                    }
                                }
                                // ==============================================
                                // ==============================================
                                // ==============================================

                                /*
                                 * for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) { if ($discount_percent != 0) { $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i); } else { $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); } // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i; $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true; $row_count ++; }
                                 */
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                                ;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_price"] = $add_places_total;
                                if ($discount_percent != 0) {
                                    $discount_value = ($total / 100) * $discount_percent;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total - $discount_value;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["original_price"] = $total;
                                } else {
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["time"] = $time_2 - $time_1;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["description"] = $rates_2 [$rate_i] [$key] ["description"];
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["nonrefundable"] = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["breakfast"] = $rates_2 [$rate_i] [$key] ["breakfast"];

                                $temp_nonrefundable = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                                $temp_breakfast = $rates_2 [$rate_i] [$key] ["breakfast"];
                                if (! isset ( $conditions_bool_count )) {
                                    $conditions_bool_count = 0;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ['c_row_bool_count'] = $conditions_bool_count;

                                $row_count ++;

                                $new_count_my_rates ++;
                                // if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] ["add_places_list"] )) {
                                // $row_count += count ( $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] ["add_places_list"] );
                                // /}
                            }
                        }
                    }
                }

                // $temp_3 ["categories"] [$key] ['c_row_bool_count'] = $conditions_bool_count;
                $temp_3 ["categories"] [$key] ['row_count'] = $row_count;
                $temp_3 ["categories"] [$key] ['base_row_count'] = $base_row_count + $new_count_my_rates;
                if (isset ( $temp_3 ["categories"] [$key] ['rates'] )) {
                } else {
                    unset ( $temp_3 ["categories"] [$key] );
                }
            }
        }

        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
                $temp_3 ["services"] [$row ["id"]] ["description"] = $row ["description"];
            }
        }
        $temp_time_2 = microtime ( true );
        $temp_3 ['debug'] = $debug;

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>+++++++++++++++++++++++++++++++++++++";
        // print_r ( $temp_3 );
        if ($countplaces != 0) {
            $temp_keys = array_keys ( $temp_3 ["categories"] );

            foreach ( $temp_keys as $key ) {
                $arr_keys = array_keys ( $temp_3 ["categories"] [$key] ['rates'] );
                $unset_bool = 0;
                foreach ( $arr_keys as $row ) {
                    if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] )) {
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"];
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"];
                        // $temp_3 ["categories"] [$key] ['row_count'] = 1;
                        // $temp_3 ["categories"] [$key] ['base_row_count'] = 1;
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list);

                        $unset_bool = 1;
                    } else {
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list + 1);
                        $temp_3 ["categories"] [$key] ['base_row_count'] = $temp_3 ["categories"] [$key] ['base_row_count'] - 1;
                    }
                }
                if ($unset_bool == 0) {
                    unset ( $temp_3 ["categories"] [$key] );
                }
            }
        }
        // print_r ( $temp_3 );
        $max_places_select_arr [0] = 1;
        $temp_3 ["max_places_select_arr"] = $max_places_select_arr;
        $temp_3 ['debug'] = "skip";
        $output = json_encode ( $temp_3 );

        $worktime_end = round ( time ( ));
        $worktime = $worktime_end - $worktime_start;
        $sql = "INSERT INTO global_hotelix_analitycs.freeroom_request(hmsid, funcid, host, worktime, timestamp) VALUES(" . $this->config->item ( 'hotel_id' ) . ", 1, '', '" . $worktime . "', '" . date ( "Y-m-d H:i:s" ) . "')";
        $query = $this->db->query ( $sql );

        echo $output;
    }

    // ф-я отримення трьох різних комбінацій дат, на які є вільні номера
    // використовується тоді, якщо поточні дати, які користувач вибрав - зайняті.
    function get_combo() {
        $postdata = file_get_contents ( "php://input" );

        $data = json_decode ( $postdata, true );
        $datein = $data ["datein"];
        $dateout = $data ["dateout"];

        $debug_on = 0;
        if(isset($data ["debug_on"])){
            if($data ["debug_on"] == 1){
                $debug_on = $data ["debug_on"];
            }
        }
        $combo_array = $this->frontdesk_c2->get_personal_module_nofreerooms_combinations($datein, $dateout, $debug_on);


        echo json_encode($combo_array);
    }

    function getfreeroomsarray_debug_2() {
        $postdata = file_get_contents ( "php://input" );

        $data = json_decode ( $postdata, true );
        $datein = $data ["datein"];
        $dateout = $data ["dateout"];
        $add_places = $data ["add_places"];
        $baby_places = $data ["baby_places"];
        $discountpromocode = $data ["discountpromocode"];

        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $duration = $intdateout - $intdatein;

        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;
        // 		echo $datein." ".$dateout." ".$datein_hours." ".$dateout_hours." ".$datenow_hours;
        // 		die();

        $discount_percent = 0;
        $is_discount_class = "d0";
        $discount_code_array = array ();
        $sql = "SELECT * FROM onlinediscount WHERE datestart <= '" . $datein . "' AND dateend >= '" . $dateout . "'";
        // echo $sql;
        $query = $this->db->query ( $sql );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $discount_code_array [$row->code] = $row->percent;
            }
        }
        //print_r($discount_code_array);
        if (isset ( $discount_code_array [$discountpromocode] )) {
            $discount_percent = $discount_code_array [$discountpromocode];
            $is_discount_class = "";
        }

        $deskofrates = array ();
        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout GROUP BY rate_id, category_id";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }

        /*
         *
         * === GET RESTRICT ARRAY ===
         *
         */

        $deskofrate_array = $this->frontdesk_c2->get_online_module_restricts($datein, $dateout);

        //==========================================================================================================================

        $categories = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
		categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,

		categories.places, categories.add_places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1 AND rooms.is_active = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
                $categories [$row ["category_id"]] ["count"] = $row ["count"];
                $categories [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $categories [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $categories [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $categories [$row ["category_id"]] ["places"] = $row ["places"];
                $categories [$row ["category_id"]] ["add_places"] = $row ["add_places"];
            }
        }
        // 	    echo "<pre>";
        // 	    print_r($categories);
        // 	    print_r($deskofrate_array);
        $availability_politics_value = false;

        if ($availability_politics_value) {
            $reservaed_array = array();
            $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id
            FROM deskofdays
            LEFT JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
            INNER JOIN rooms ON rooms.id = deskofdays.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY rooms.category_id";
            // echo $sql . "\n";
            $debug['sql2'] = $sql;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $row) {
                    $reservaed_array[$row["category_id"]]["count"] = $row["count"];
                }
            }

            foreach ($categories as $c_id => $cell) {
                if (isset($reservaed_array[$c_id])) {
                    $categories[$c_id]["count"] = $categories[$c_id]["count"] - $reservaed_array[$c_id]["count"];
                }
            }
        }else{
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $freerooms_intdateout = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );

            $freerooms_dateout = gmdate("Y-m-d", $freerooms_intdateout * 86400);
            $availability_arr = $this->frontdesk->get_categories_freerooms_period($datein, $freerooms_dateout, 0, 0);
            //             echo "<pre>";
            //             print_r($availability_arr);
            foreach($categories as $c_id => $cell){
                if (isset($availability_arr[$c_id])) {
                    $categories[$c_id]["count"] = $availability_arr[$c_id];
                }else{
                    $categories[$c_id]["count"] = 0;
                }
            }

        }

        // =========== test combinations of no rooms ===========
        // =====================================================
        $nofree_rooms = 1;
        foreach($categories as $i => $cell){
            if($cell["count"] > 0){
                $nofree_rooms = 0;
                break;
            }
        }
        //echo $nofree_rooms."<br>";

        if(isset($data ["debug_on"])){
            if($data ["debug_on"] == 1){
                // norooms logic
                $categories = $this->frontdesk_c2->get_personal_module_nofreerooms_combinations($datein, $dateout, $data ["debug_on"]);
            }
        }

        $timezone = "Europe/Kiev";
        $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $timezone = $row->str_value;
        }

        $rates_2 = array ();

        $array_prices_seasons_2 = array ();

        //========================================================================================================
        $sql = "SELECT  rate.ccforce, online_rate_data.ccamount, online_rate_data.ccamount_type, rate.caption as rate_name,
        SUM(if(yieldprice.price > 0, yieldprice.price, seasonspricelist.price)) as sum_price,
        SUM(if(if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice),
        (seasonspricelist.singleuse_price)) > 0, 1, 0)) as singleuse_price_count,
        SUM(if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice), (seasonspricelist.singleuse_price))) as sum_singleuse_price,
        SUM(if(yieldprice.perperson_price > 0, (yieldprice.perperson_price), (seasonspricelist.perperson_price))) as sum_perperson_price,
        deskofdaysseason.intdate, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        onlinerates.restrictid, onlinerates.timeshift as onlinerate_timeshift,
        seasonspricelist.price, seasonspricelist.singleuse_price, seasonspricelist.perperson_price,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description,
        yieldprice.price as yield_price, yieldprice.singleuseprice as yield_singleuse_price,
        yieldprice.perperson_price as yield_perperson_price, ratetocategory.description,
        property_information.check_in_time,
        property_information.timezone
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN property_information ON property_information.id = categories.property_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN onlinerates ON rate.id = onlinerates.rateid
        INNER JOIN online_rate_data ON rate.id = online_rate_data.rate_id
        LEFT JOIN yieldprice ON (yieldprice.id_restrict_rate = ratetocategory.rate_id
        AND yieldprice.category_id = ratetocategory.category_id
        AND deskofdaysseason.intdate = yieldprice.intdate)
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1
        AND deskofdaysseason.intdate >= $intdatein AND deskofdaysseason.intdate < $intdateout
        GROUP BY seasonspricelist.rate_id, seasonspricelist.category_id ORDER BY seasonspricelist.category_id, seasonspricelist.rate_id ASC";

        // 	    echo $sql."<br>";
        // 	    die();
        $query = $this->db->query ( $sql );
        $counter = 0;
        if ($query->num_rows () > 0) {

            foreach ( $query->result () as $row ) {
                $restrict_continue_value = 0;
                if(isset($deskofrate_array[$row->category_id][$row->rate_id])){
                    foreach($deskofrate_array[$row->category_id][$row->rate_id] as $intdate => $cell){
                        if ($intdate < $intdateout) {
                            if ($cell["closed"] == 1) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if ($duration > $cell["maxstay"] && $cell["maxstay"] > 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if ($duration < $cell["minstaythrought"] && $cell["minstaythrought"] > 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if (($intdate == $intdatein) && ($cell["closedonarrival"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        } else {
                            if (($intdate == $intdateout) && ($cell["closedondeparture"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        }
                    }
                }

                if($restrict_continue_value == 1){
                    continue;
                }

                if($row->baseplace == 0){
                    $baseplace = $categories [$row->category_id] ["places"];
                }else{
                    $baseplace = $row->baseplace;
                }

                if($row->maxplace == 0){
                    $maxplace = $categories [$row->category_id] ["add_places"];
                }else{
                    $maxplace = $row->maxplace;;
                }

                // враховуєм значення з таблиці обмежень
                $bool_restrict = 0;
                if (isset ( $deskofrates [$row->category_id] [$row->restrictid] )) {
                    if ($deskofrates [$row->category_id] [$row->restrictid] ["max_closed"] > 0
                        or $deskofrates [$row->category_id] [$row->restrictid] ["max_minstaythrought"] > $duration) {
                            $bool_restrict = 1;
                        }
                }

                // враховуєм спецпропозицію з налаштувань онлайн рейтів /online_module/rates
                $timeshift_bool = 0;
                $timeshift = $row->onlinerate_timeshift;


                // визначаємо дату заїзду в годинах
                $check_in_time = $row->check_in_time;
                list ( $hour, $minute ) = explode ( ":", $check_in_time );
                list ( $year, $month, $day ) = explode ( "-", $datein );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datein_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );


                // визначаємо поточний час з врахуванням часової зони об'єкта
                if(trim($row->timezone) != ""){
                    $timezone = $row->timezone;
                }

                $date = new DateTime('NOW', new DateTimeZone($timezone));
                $datenow = $date->format('Y-m-d');
                $timenow = $date->format('H:i');

                list ( $hour, $minute ) = explode ( ":", $timenow );
                list ( $year, $month, $day ) = explode ( "-", $datenow );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datenow_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );

                //echo $datein_hours." ".$datenow_hours." ".($datein_hours + $timeshift)." timeshift ".$timeshift."<br>";
                if ($timeshift != 0) {
                    if ($timeshift < 0) {
                        if (($datein_hours + $timeshift) <= $datenow_hours) {
                            $timeshift_bool = 1;
                        }
                    }
                    if ($timeshift > 0) {
                        if (($datein_hours - $datenow_hours) >= $timeshift) {
                            $timeshift_bool = 1;
                        }
                    }
                } else {
                    $timeshift_bool = 1;
                }
                //echo $bool_restrict."||".$timeshift_bool."<br>";
                if ($bool_restrict == 0 && $timeshift_bool == 1) {
                    $rates_2[$row->category_id][$row->rate_id]["rate_id"] = $row->rate_id;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["rate_name"] = $row->rate_name;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["description"] = $row->description;
                    $rates_2[$row->category_id][$row->rate_id]["baseplace"] = $row->baseplace;
                    $rates_2[$row->category_id][$row->rate_id]["maxplace"] = $row->maxplace;
                    $rates_2[$row->category_id][$row->rate_id]["restrictid"] = $row->restrictid;

                    $rates_2[$row->category_id][$row->rate_id]["ccforce"] = $row->ccforce;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount_type"] = $row->ccamount_type;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount"] = $row->ccamount;

                    $places_diff = $maxplace - $baseplace;
                    if ($baseplace == 1) {
                        //$places_diff -= 1;
                    }
                    if ($row->sum_singleuse_price == 0) {
                        $sum_singleuse_price = $categories[$row->category_id]["base_price"] * $duration;
                    } else {
                        $sum_singleuse_price = $row->sum_singleuse_price;
                    }
                    // echo $row->singleuse_price_count." - ".$duration."<br>";
                    // die();
                    if ($places_diff > 0) {
                        if ($row->sum_singleuse_price > 0 && $row->singleuse_price_count == $duration && $baseplace > 1) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                            if ($discount_percent != 0) {
                                $discount_value = ($row->sum_singleuse_price / 100) * $discount_percent;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price - $discount_value;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->sum_singleuse_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                            } else {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price;
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price;

                            // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;

                            // daily_price START
                            // 	                        $price_calculation_data = array();
                            // 	                        $price_calculation_data["price_type"] = $row->rate_id;
                            // 	                        $price_calculation_data["type_id"] = $row->category_id;
                            // 	                        $price_calculation_data["datein"] = $datein;
                            // 	                        $price_calculation_data["dateout"] = $dateout;
                            // 	                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"] = $this->getpricecalculation ( $price_calculation_data, 0 );
                            // daily_price END


                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                            $counter ++;
                        }


                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = 0;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["is_discount_class"] = $is_discount_class;
                        if ($discount_percent != 0) {
                            $discount_value = ($row->sum_price / 100) * $discount_percent;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price - $discount_value;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] = $row->sum_price;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = $discount_percent;
                        } else {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price;
                        }
                        //$rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price;


                        // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][1]["icons"] = $people_icon." ".$people_icon;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                        $counter ++;
                        for ($pl = 1; $pl <= $places_diff; $pl ++) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["occupancy_places"] = $baseplace + $pl;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["is_discount_class"] = $is_discount_class;
                            if ($discount_percent != 0) {
                                $discount_value = (($row->sum_price + ($row->sum_perperson_price * $pl)) / 100) * $discount_percent;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = ($row->sum_price + ($row->sum_perperson_price * $pl)) - $discount_value;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["original_price"] = $row->sum_price + ($row->sum_perperson_price * $pl);
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["discount_percent_value"] = $discount_percent;
                            } else {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $row->sum_price + ($row->sum_perperson_price * $pl);
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $row->sum_price + ($row->sum_perperson_price * $pl);

                            /*
                             * $people_icon_str_mass = ' ';
                             *
                             * for($pi = 0; $pi <= $pl; $pi++){
                             * if($row->baseplace == $pi){
                             * for($p_i = 1; $p_i <= $baseplace; $p_i++){
                             * $people_icon_str_mass .= $people_icon.' ';
                             * }
                             * $people_icon_str_mass .= ' <span class="plusm">+</span> ';
                             * }else{
                             * $people_icon_str_mass .= $people_icon.' ';
                             * }
                             * }
                             * $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][$pl+1]["icons"] = $people_icon_str_mass;
                             */
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["counter"] = $counter;
                            $counter ++;
                        }
                    } else {
                        if ($baseplace > 1) {
                            if ($row->sum_singleuse_price > 0 && $row->singleuse_price_count == $duration) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                                if ($discount_percent != 0) {
                                    $discount_value = ($row->sum_singleuse_price / 100) * $discount_percent;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price - $discount_value;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->sum_singleuse_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                                } else {
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price;
                                }
                                //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_singleuse_price;

                                // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            }

                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["is_discount_class"] = $is_discount_class;
                            if ($discount_percent != 0) {
                                $discount_value = ($row->sum_price / 100) * $discount_percent;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price - $discount_value;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] = $row->sum_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = $discount_percent;
                            } else {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price;
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->sum_price;


                            // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][1]["icons"] = $people_icon." ".$people_icon;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                            $counter ++;
                        } else {
                            if ($baseplace == 1) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                                if ($discount_percent != 0) {
                                    $discount_value = ($row->sum_price / 100) * $discount_percent;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_price - $discount_value;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->sum_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                                } else {
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_price;
                                }
                                //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->sum_price;


                                // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            } else {}
                        }
                    }
                }
            }
        }

        // 	    echo "<pre>";
        // 	    print_r($rates_2);
        // 	    print_r($categories);
        // 	    die();

        $result_array = array();
        foreach($categories as $cat_id => $cell){
            if(isset($rates_2[$cat_id])){
                $categories[$cat_id]["rates"] = $rates_2[$cat_id];
            }else{
                unset($categories[$cat_id]);
            }

        }

        // 	    echo "<pre>";
        // 	    print_r($categories);
        // 	    die();
        // 	    echo "<pre>";
        // 	    print_r($categories);
        //die();
        $output = json_encode ( $categories );

        echo $output;
    }

    function getfreeroomsarray_debug_2_new() {
        $postdata = file_get_contents ( "php://input" );
        $categories = array();
        $data = json_decode ( $postdata, true );
//         echo "<pre>";
//         print_r($data);
        $datein = $data ["datein"];
        $dateout = $data ["dateout"];
        $add_places = $data ["add_places"];
        $baby_places = $data ["baby_places"];
        $discountpromocode = $data ["discountpromocode"];

        $valid_datein = strtotime($datein);
        $valid_dateout = strtotime($dateout);
        if($valid_datein == null){
            $output = json_encode ( $categories );
            echo $output;
            return;
        }
        if($valid_dateout == null){
            $output = json_encode ( $categories );
            echo $output;
            return;
        }

        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $duration = $intdateout - $intdatein;

        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;
        // 		echo $datein." ".$dateout." ".$datein_hours." ".$dateout_hours." ".$datenow_hours;
        // 		die();
        $promocode_id = 0;
        $promocodes2categories_rates = array();
        $discount_percent = 0;
        $is_discount_class = "d0";
        $price_class = "pricemod2";

        // ========== PROMOCODE VERSION 1 =============
        if ($this->releases->online_propmocodes_veersion() == 1) {
            $discount_code_array = array();
            $sql = "SELECT * FROM onlinediscount WHERE datestart <= '" . $datein . "' AND dateend >= '" . $dateout . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $discount_code_array[$row->code] = $row->percent;
                }
            }
            if (isset($discount_code_array[$discountpromocode])) {
                $discount_percent = $discount_code_array[$discountpromocode];
                $is_discount_class = "";
                $price_class = "pricemod";
            }
        }
        //echo "datein: ".$datein." dateout: ".$dateout;
        // ========== PROMOCODE VERSION 2 =============
        if ($this->releases->online_propmocodes_veersion() == 2) {
            $promo_dates = array('datestart' => $datein, 'dateend' => $dateout);
            $promocodes_data = $this->monline_module->get_promocodes_data($promo_dates);
            foreach($promocodes_data as $code_id_key => $cell){
                //echo "----".$promocodes_data[$code_id_key]['code']."   ||||   ".$discountpromocode."++++";
                //echo $promocodes_data[$code_id_key]['id']."<br>";
                if ($promocodes_data[$code_id_key]['code'] === $discountpromocode){
                    $promocode_id = $promocodes_data[$code_id_key]['id'];
                    break;
                }
            }
            
            if ($promocode_id > 0){
                $is_discount_class = "";
                $price_class = "pricemod";
                $promocodes2categories_rates = $this->monline_module->get_promocodes2categories_rates($promocode_id);
            }
        }

        $discount_main_data = array();
        $discount_main_data ['discount_percent'] = $discount_percent;

        $discount_main_data ['promocode_id'] = $promocode_id;
        if($promocode_id > 0){
            $discount_main_data ['promocode_main_data'] = $promocodes_data[$promocode_id];
            $discount_main_data ['promocodes2categories_rates'] = $promocodes2categories_rates;
        }

        $deskofrates = array ();
        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout GROUP BY rate_id, category_id";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }

        /*
         *
         * === GET RESTRICT ARRAY ===
         *
         */

        $deskofrate_array = $this->frontdesk_c2->get_online_module_restricts($datein, $dateout);

        //==========================================================================================================================

        $categories = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
		categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,

		categories.places, categories.add_places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1 AND rooms.is_active = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
                $categories [$row ["category_id"]] ["count"] = $row ["count"];
                $categories [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $categories [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $categories [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $categories [$row ["category_id"]] ["places"] = $row ["places"];
                $categories [$row ["category_id"]] ["add_places"] = $row ["add_places"];
            }
        }
        // 	    echo "<pre>";
        // 	    print_r($categories);
        // 	    print_r($deskofrate_array);
        $availability_politics_value = false;

        if ($availability_politics_value) {
            $reservaed_array = array();
            $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id
            FROM deskofdays
            LEFT JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
            INNER JOIN rooms ON rooms.id = deskofdays.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY rooms.category_id";
            // echo $sql . "\n";
            $debug['sql2'] = $sql;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $row) {
                    $reservaed_array[$row["category_id"]]["count"] = $row["count"];
                }
            }

            foreach ($categories as $c_id => $cell) {
                if (isset($reservaed_array[$c_id])) {
                    $categories[$c_id]["count"] = $categories[$c_id]["count"] - $reservaed_array[$c_id]["count"];
                }
            }
        }else{
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $freerooms_intdateout = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );

            $freerooms_dateout = gmdate("Y-m-d", $freerooms_intdateout * 86400);
            $availability_arr = $this->frontdesk->get_categories_freerooms_period($datein, $freerooms_dateout, 0, 0);
            //             echo "<pre>";
            //             print_r($availability_arr);
            foreach($categories as $c_id => $cell){
                if (isset($availability_arr[$c_id])) {
                    $categories[$c_id]["count"] = $availability_arr[$c_id];
                }else{
                    $categories[$c_id]["count"] = 0;
                }
            }

        }

        // =========== test combinations of no rooms ===========
        // =====================================================
        $nofree_rooms = 1;
        foreach($categories as $i => $cell){
            if($cell["count"] > 0){
                $nofree_rooms = 0;
                break;
            }
        }
        //echo $nofree_rooms."<br>";

        if(isset($data ["debug_on"])){
            if($data ["debug_on"] == 1){
                // norooms logic
                $categories = $this->frontdesk_c2->get_personal_module_nofreerooms_combinations($datein, $dateout, $data ["debug_on"]);
            }
        }

        $timezone = "Europe/Kiev";
        $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $timezone = $row->str_value;
        }

        $rates_2 = array ();

        $array_prices_seasons_2 = array ();

        //========================================================================================================
        $sql = "SELECT  rate.ccforce, online_rate_data.ccamount, online_rate_data.ccamount_type, rate.caption as rate_name,
        if(yieldprice.price > 0, yieldprice.price, seasonspricelist.price) as price,
        if(if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice),
        (seasonspricelist.singleuse_price)) > 0, 1, 0) as singleuse_price_count,
        if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice), (seasonspricelist.singleuse_price)) as singleuse_price,
        if(yieldprice.perperson_price > 0, (yieldprice.perperson_price), (seasonspricelist.perperson_price)) as perperson_price,
        deskofdaysseason.intdate, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        onlinerates.restrictid, onlinerates.timeshift as onlinerate_timeshift,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description,
        yieldprice.price as yield_price, yieldprice.singleuseprice as yield_singleuse_price,
        yieldprice.perperson_price as yield_perperson_price, ratetocategory.description,
        property_information.check_in_time,
        property_information.timezone
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN property_information ON property_information.id = categories.property_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN onlinerates ON rate.id = onlinerates.rateid
        LEFT JOIN online_rate_data ON rate.id = online_rate_data.rate_id
        LEFT JOIN yieldprice ON (yieldprice.id_restrict_rate = ratetocategory.rate_id
        AND yieldprice.category_id = ratetocategory.category_id
        AND deskofdaysseason.intdate = yieldprice.intdate)
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1
        AND deskofdaysseason.intdate >= $intdatein AND deskofdaysseason.intdate < $intdateout
        GROUP BY seasonspricelist.rate_id, seasonspricelist.category_id, deskofdaysseason.intdate ORDER BY seasonspricelist.category_id, seasonspricelist.rate_id ASC";

         	    	    //echo $sql."<br>";
        // 	    	    die();
        $query = $this->db->query ( $sql );
        $counter = 0;
        if ($query->num_rows () > 0) {

            foreach ( $query->result () as $row ) {
                $restrict_continue_value = 0;
                $discount_main_data['category_id'] = $row->category_id;
                $discount_main_data['rate_id'] = $row->rate_id;
                $minstayarrival_done = 0;
                if(isset($deskofrate_array[$row->category_id][$row->rate_id])){
                    foreach($deskofrate_array[$row->category_id][$row->rate_id] as $intdate => $cell){
                        if ($intdate < $intdateout) {
                            if ($cell["closed"] == 1) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if ($duration > $cell["maxstay"] && $cell["maxstay"] > 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            
                            if ($intdate == $intdatein) {
                                if ($cell["minstayarrival"] > 0) {
                                    if ($duration < $cell["minstayarrival"]) {
                                        $restrict_continue_value = 1;
                                        break;
                                    }
                                    $minstayarrival_done = 1;
                                } else {
                                    if ($duration < $cell["minstaythrought"] && $cell["minstaythrought"] > 0) {
                                        $restrict_continue_value = 1;
                                        break;
                                    }
                                }
                            }
                            //echo $minstayarrival_done;
                            if ($duration < $cell["minstaythrought"] && $cell["minstaythrought"] > 0 && $minstayarrival_done == 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            
//                             if (($intdate == $intdatein) && ($duration < $cell["minstayarrival"]) && ($cell["minstayarrival"] > 0)) {
//                                 $restrict_continue_value = 1;
//                                 break;
//                             }
                            
                            if (($intdate == $intdatein) && ($cell["closedonarrival"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        } else {
                            if (($intdate == $intdateout) && ($cell["closedondeparture"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        }
                    }
                }
                
                //echo $row->category_id." ".$row->rate_id." ".$restrict_continue_value."<br>";
                
                
                if($restrict_continue_value == 1){
                    continue;
                }

                if($row->baseplace == 0){
                    $baseplace = $categories [$row->category_id] ["places"];
                }else{
                    $baseplace = $row->baseplace;
                }

                if($row->maxplace == 0){
                    $maxplace = $categories [$row->category_id] ["add_places"];
                }else{
                    $maxplace = $row->maxplace;
                }

                // враховуєм значення з таблиці обмежень
                $bool_restrict = 0;
//                 if (isset ( $deskofrates [$row->category_id] [$row->restrictid] )) {
//                     if ($deskofrates [$row->category_id] [$row->restrictid] ["max_closed"] > 0
//                         or $deskofrates [$row->category_id] [$row->restrictid] ["max_minstaythrought"] > $duration) {
//                             $bool_restrict = 1;
//                         }
//                 }

                // враховуєм спецпропозицію з налаштувань онлайн рейтів /online_module/rates
                $timeshift_bool = 0;
                $timeshift = $row->onlinerate_timeshift;


                // визначаємо дату заїзду в годинах
                $check_in_time = $row->check_in_time;
                
                if($check_in_time == ""){
                    $check_in_time = "12:00";
                }
                
                list ( $hour, $minute ) = explode ( ":", $check_in_time );
                list ( $year, $month, $day ) = explode ( "-", $datein );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datein_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );


                // визначаємо поточний час з врахуванням часової зони об'єкта
                if(trim($row->timezone) != ""){
                    $timezone = $row->timezone;
                }

                $date = new DateTime('NOW', new DateTimeZone($timezone));
                $datenow = $date->format('Y-m-d');
                $timenow = $date->format('H:i');

                list ( $hour, $minute ) = explode ( ":", $timenow );
                list ( $year, $month, $day ) = explode ( "-", $datenow );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datenow_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );

                //echo $datein_hours." ".$datenow_hours." ".($datein_hours + $timeshift)." timeshift ".$timeshift."<br>";
                if ($timeshift != 0) {
                    if ($timeshift < 0) {
                        if (($datein_hours + $timeshift) <= $datenow_hours) {
                            $timeshift_bool = 1;
                        }
                    }
                    if ($timeshift > 0) {
                        if (($datein_hours - $datenow_hours) >= $timeshift) {
                            $timeshift_bool = 1;
                        }
                    }
                } else {
                    $timeshift_bool = 1;
                }
                //echo $bool_restrict."||".$timeshift_bool."<br>";
                if ($bool_restrict == 0 && $timeshift_bool == 1) {
                    $rates_2[$row->category_id][$row->rate_id]["rate_id"] = $row->rate_id;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["rate_name"] = $row->rate_name;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["description"] = $row->description;
                    $rates_2[$row->category_id][$row->rate_id]["baseplace"] = $row->baseplace;
                    $rates_2[$row->category_id][$row->rate_id]["maxplace"] = $row->maxplace;
                    $rates_2[$row->category_id][$row->rate_id]["restrictid"] = $row->restrictid;

                    $rates_2[$row->category_id][$row->rate_id]["ccforce"] = $row->ccforce;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount_type"] = $row->ccamount_type;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount"] = $row->ccamount;

                    $places_diff = $maxplace - $baseplace;
                    if ($baseplace == 1) {
                        //$places_diff -= 1;
                    }
                    if ($row->singleuse_price == 0) {
                        $singleuse_price = $categories[$row->category_id]["base_price"] * $duration;
                    } else {
                        $singleuse_price = $row->singleuse_price;
                    }
                    // echo $row->singleuse_price_count." - ".$duration."<br>";
                    // die();
                    if ($places_diff > 0) {
                        if ($row->singleuse_price > 0 && $baseplace > 1) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price_class"] = $price_class;
                            if ($discount_percent != 0 || $promocode_id > 0) {
                                // === calculate discount ======
                                $discount_main_data['amount'] = $row->singleuse_price;
                                $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->singleuse_price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] += $row->singleuse_price;
                                }

                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $discount_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                            } else {
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->singleuse_price;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->singleuse_price;
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;

                            // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;

                            // daily_price START
                            // 	                        $price_calculation_data = array();
                            // 	                        $price_calculation_data["price_type"] = $row->rate_id;
                            // 	                        $price_calculation_data["type_id"] = $row->category_id;
                            // 	                        $price_calculation_data["datein"] = $datein;
                            // 	                        $price_calculation_data["dateout"] = $dateout;
                            // 	                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"] = $this->getpricecalculation ( $price_calculation_data, 0 );
                            // daily_price END

                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                            }
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                            $counter ++;
                        }


                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = 0;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["is_discount_class"] = $is_discount_class;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price_class"] = $price_class;
                        if ($discount_percent != 0 || $promocode_id > 0) {
                            // === calculate discount ======
                            $discount_main_data['amount'] = $row->price;
                            $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $discount_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] = $row->price;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $discount_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] += $row->price;
                            }

                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $discount_price;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = $discount_percent;
                        } else {
                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $row->price;
                            }
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $row->price;
                        }
                        //$rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;


                        // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][1]["icons"] = $people_icon." ".$people_icon;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                        $counter ++;
                        for ($pl = 1; $pl <= $places_diff; $pl ++) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["occupancy_places"] = $baseplace + $pl;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["is_discount_class"] = $is_discount_class;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price_class"] = $price_class;
                            if ($discount_percent != 0 || $promocode_id > 0) {
                                // === calculate discount ======
                                $discount_main_data['amount'] = $row->price + ($row->perperson_price * $pl);
                                $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["original_price"] = $row->price + ($row->perperson_price * $pl);
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] += $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["original_price"] += $row->price + ($row->perperson_price * $pl);
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["daily_price"][$row->intdate]["price"] = $discount_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["discount_percent_value"] = $discount_percent;
                            } else {
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $row->price + ($row->perperson_price * $pl);
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] += $row->price + ($row->perperson_price * $pl);
                                }

                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["daily_price"][$row->intdate]["price"] = $row->price + ($row->perperson_price * $pl);
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $row->price + ($row->perperson_price * $pl);

                            /*
                             * $people_icon_str_mass = ' ';
                             *
                             * for($pi = 0; $pi <= $pl; $pi++){
                             * if($row->baseplace == $pi){
                             * for($p_i = 1; $p_i <= $baseplace; $p_i++){
                             * $people_icon_str_mass .= $people_icon.' ';
                             * }
                             * $people_icon_str_mass .= ' <span class="plusm">+</span> ';
                             * }else{
                             * $people_icon_str_mass .= $people_icon.' ';
                             * }
                             * }
                             * $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][$pl+1]["icons"] = $people_icon_str_mass;
                             */
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["counter"] = $counter;
                            $counter ++;
                        }
                    } else {
                        if ($baseplace > 1) {
                            if ($row->singleuse_price > 0) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price_class"] = $price_class;
                                if ($discount_percent != 0 || $promocode_id > 0) {
                                    // === calculate discount ======
                                    $discount_main_data['amount'] = $row->singleuse_price;
                                    $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                                    if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $discount_price;
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->singleuse_price;
                                    }else{
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $discount_price;
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] += $row->singleuse_price;
                                    }
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                                } else {
                                    if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;
                                    }else{
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->singleuse_price;
                                    }
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->singleuse_price;
                                }
                                //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;

                                // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;

                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            }

                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = 0;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["is_discount_class"] = $is_discount_class;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price_class"] = $price_class;
                            if ($discount_percent != 0 || $promocode_id > 0) {
                                // === calculate discount ======
                                $discount_main_data['amount'] = $row->price;
                                $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] = $row->price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["original_price"] += $row->price;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $discount_price;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["discount_percent_value"] = $discount_percent;
                            } else {
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $row->price;
                                }

                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $row->price;
                            }
                            //$rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;


                            // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][1]["icons"] = $people_icon." ".$people_icon;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                            $counter ++;
                        } else {
                            if ($baseplace == 1) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = 0;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["is_discount_class"] = $is_discount_class;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price_class"] = $price_class;
                                if ($discount_percent != 0 || $promocode_id > 0) {
                                    // === calculate discount ======
                                    $discount_main_data['amount'] = $row->price;
                                    $discount_price = $this->monline_module->get_discount_price($discount_main_data);

                                    if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $discount_price;
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] = $row->price;
                                    }else{
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $discount_price;
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["original_price"] += $row->price;
                                    }
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $discount_price;
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["discount_percent_value"] = $discount_percent;
                                } else {
                                    if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->price;
                                    }else{
                                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->price;
                                    }
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->price;
                                }
                                //$rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->price;


                                // $rates_2 [$row->category_id] [$row->rate_id] ["occupancy"][0]["icons"] = $people_icon;

                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            } else {}
                        }
                    }
                }
            }
        }




        foreach ($rates_2 as $cat_id => $category_cell) {
            foreach ($category_cell as $rate_id => $rate_cell) {
                foreach ($rate_cell["occupancy"] as $occupancy_inc => $occupancy_cell) {
                    // видалення одномісного заселення, якщо базова к-сть місць в номері більша за 1 і ціна одномісного заселення хоча б за один день рівна 0
                    if ($occupancy_inc == 0) {
                        if ($occupancy_cell["baseplace"] > 1) {
                            if ($occupancy_cell["singleuse_price_count"] != $duration) {
                                unset($rates_2[$cat_id][$rate_id]["occupancy"][0]);
                            }
                        }
                    }

                    // видалення варіантів заселення, якщо ціна рівна 0
                    if ($occupancy_cell["price"] == 0) {
                        unset($rates_2[$cat_id][$rate_id]["occupancy"][$occupancy_inc]);
                        if(count($rates_2[$cat_id][$rate_id]["occupancy"]) == 0){
                            unset($rates_2[$cat_id][$rate_id]);
                            if(count($rates_2[$cat_id]) == 0){
                                unset($rates_2[$cat_id]);
                            }
                        }
                    }
                }
            }
        }

        //         echo "<pre>";
        //         print_r($rates_2);
        //         print_r($categories);
        //         die();

        $result_array = array();
        foreach($categories as $cat_id => $cell){
            if(isset($rates_2[$cat_id])){
                $categories[$cat_id]["rates"] = $rates_2[$cat_id];
            }else{
                unset($categories[$cat_id]);
            }

        }

        // 	    echo "<pre>";
        // 	    print_r($categories);
        // 	    die();
        // 	    echo "<pre>";
        // 	    print_r($categories);
        //die();
        $output = json_encode ( $categories );

        echo $output;
    }

    public function get_free_proprooms_pmv3() {
        $postdata = file_get_contents ( "php://input" );
        
        $categories = array();
        
        $data = json_decode ( $postdata, true );

        $datein = $data ["datein"];
        $dateout = $data ["dateout"];
        $add_places = $data ["add_places"];
        $baby_places = $data ["baby_places"];
        $promocode = $data ["discountpromocode"];
        $prop_id_where_sql_str = '';
        if (isset($data ['prop_id'])) {
            $prop_id = $data ['prop_id'];
            $prop_id_where_sql_str = "AND categories.property_id = $prop_id";
        }
        $valid_datein = strtotime($datein);
        $valid_dateout = strtotime($dateout);
        if($valid_datein == null){
            $output = json_encode ( $categories );
            echo $output;
            return;
        }
        if($valid_dateout == null){
            $output = json_encode ( $categories );
            echo $output;
            return;
        }
        
        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        
        $duration = $intdateout - $intdatein;
        
        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;

        //=========== promocode START =========
        $promocode_is_valid = $promocode_needs_calculation = false;
        $promo_data = array();
        if ($promocode != ''){
            $promo_version = $this->releases->online_propmocodes_veersion();
            /*версія
             * 1 - стара логіка з промо
             * 2 - нова логіка
             */
            /*тип знижки
             *  percent = 1;
             *  fixed = 2;
             */
            switch ($promo_version) {
                case 1:
                    $tbl = 'onlinediscount';
                    $query_row = $this->db->select('percent')
                    ->from($tbl)
                    ->where(array(
                        'code' => $promocode
                    ))
                    ->where("'$datein' BETWEEN datestart AND dateend AND '$dateout' BETWEEN datestart AND dateend", NULL, false)
                    ->get()
                    ->row();
                    if ($query_row) {
                        $promocode_is_valid = true;
                        $promo_data['type_txt'] = 'percent';
                        $promo_data['type_id'] = 1;
                        $promo_data['value'] = $query_row->percent;
                    }
                    break;
                case 2:
                    
                    $tbl = 'promocodes';
                    $query_row = $this->db->select('id, discount_value, discount_type')
                    ->from($tbl)
                    ->where(array(
                        'code' => $promocode,
                        'status' => 1
                    ))
                    ->where("'$datein' BETWEEN datestart AND dateend AND '$dateout' BETWEEN datestart AND dateend AND counter > 0", NULL, false)
                    ->get()
                    ->row();
                    
                    if ($query_row) {
                        $promocode_needs_calculation = true;
                        
                        $whr_arr = array('promocode_id ' => $query_row->id);
                        
                        $tbl = 'promocodes2categories';
                        $promoted_cats = array();
                        $query_promoted_cats = $this->db->select('category_id as id')->get_where($tbl, $whr_arr)->result();
                        foreach ($query_promoted_cats as $cat) {
                            array_push($promoted_cats, $cat->id);
                        }
                        
                        $tbl = 'promocodes2rates';
                        $promoted_rates = array();
                        $query_promoted_rates = $this->db->select('rate_id as id')->get_where($tbl, $whr_arr)->result();
                        foreach ($query_promoted_rates as $rate) {
                            array_push($promoted_rates, $rate->id);
                        }
                        
                        if (count($promoted_cats) && count($promoted_rates)) {
                            $promocode_is_valid = true;
                            $promo_data['type_txt'] = $query_row->discount_type == 1 ? 'percent' : 'fixed';
                            $promo_data['type_id'] = $query_row->discount_type == 1 ? 1 : 2;
                            $promo_data['value'] = $query_row->discount_value;
                        }
                    }
                    break;
            }
        }
        //=========== promocode FINAL =========
        
        $deskofrates = array ();
        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout GROUP BY rate_id, category_id";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }
        
        /*
         *
         * === GET RESTRICT ARRAY ===
         *
         */
        
        $deskofrate_array = $this->frontdesk_c2->get_online_module_restricts($datein, $dateout);
        
        //==========================================================================================================================
        
        $categories = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price, categories.property_id,
		categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		categories.places, categories.add_places, categories.settlementtype,
        property_information.dwelling, property_information.property_type

        FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id $prop_id_where_sql_str
		INNER JOIN property_information ON property_information.id = categories.property_id
		WHERE categories.web_booking = 1 AND rooms.is_active = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $categories [$row ["category_id"]] ["category_id"] = $row ["category_id"];
                $categories [$row ["category_id"]] ["count"] = $row ["count"];
                $categories [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $categories [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $categories [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $categories [$row ["category_id"]] ["places"] = $row ["places"];
                $categories [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                $categories [$row ["category_id"]] ["property_id"] = $row ["property_id"];
                $categories [$row ["category_id"]] ["property_dwelling"] = $row ["dwelling"];
                $categories [$row ["category_id"]] ["property_type"] = $row ["property_type"];
            }
        }
        // 	    echo "<pre>";
        // 	    print_r($categories);
        // 	    print_r($deskofrate_array);
        $availability_politics_value = false;
        
        if ($availability_politics_value) {
            $reservaed_array = array();
            $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id
            FROM deskofdays
            LEFT JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
            INNER JOIN rooms ON rooms.id = deskofdays.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY rooms.category_id";
            // echo $sql . "\n";
            $debug['sql2'] = $sql;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $row) {
                    $reservaed_array[$row["category_id"]]["count"] = $row["count"];
                }
            }
            
            foreach ($categories as $c_id => $cell) {
                if (isset($reservaed_array[$c_id])) {
                    $categories[$c_id]["count"] = $categories[$c_id]["count"] - $reservaed_array[$c_id]["count"];
                }
            }
        }else{
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $freerooms_intdateout = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );
            
            $freerooms_dateout = gmdate("Y-m-d", $freerooms_intdateout * 86400);
            $availability_arr = $this->frontdesk->get_categories_freerooms_period($datein, $freerooms_dateout, 0, 0);
            //             echo "<pre>";
            //             print_r($availability_arr);
            foreach($categories as $c_id => $cell){
                if (isset($availability_arr[$c_id])) {
                    $categories[$c_id]["count"] = $availability_arr[$c_id];
                }else{
                    $categories[$c_id]["count"] = 0;
                }
            }
            
        }
        
        // =========== test combinations of no rooms ===========
        // =====================================================
        $nofree_rooms = 1;
        foreach($categories as $i => $cell){
            if($cell["count"] > 0){
                $nofree_rooms = 0;
                break;
            }
        }
        //echo $nofree_rooms."<br>";
        
        if(isset($data ["debug_on"])){
            if($data ["debug_on"] == 1){
                // norooms logic
                $categories = $this->frontdesk_c2->get_personal_module_nofreerooms_combinations($datein, $dateout, $data ["debug_on"]);
            }
        }
        
        $timezone = "Europe/Kiev";
        $query = $this->db->query ( "SELECT str_value FROM hotelix_config WHERE name LIKE 'timezone'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $timezone = $row->str_value;
        }
        
        $rates_2 = array ();
        
        $array_prices_seasons_2 = array ();
        //========================================================================================================
        $sql = "SELECT  rate.ccforce, online_rate_data.ccamount, online_rate_data.ccamount_type, rate.caption as rate_name,
        if(yieldprice.price > 0, yieldprice.price, seasonspricelist.price) as price,
        if(if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice),
        (seasonspricelist.singleuse_price)) > 0, 1, 0) as singleuse_price_count,
        if(yieldprice.singleuseprice > 0, (yieldprice.singleuseprice), (seasonspricelist.singleuse_price)) as singleuse_price,
        if(yieldprice.perperson_price > 0, (yieldprice.perperson_price), (seasonspricelist.perperson_price)) as perperson_price,
        deskofdaysseason.intdate, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        onlinerates.restrictid, onlinerates.timeshift as onlinerate_timeshift,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description,
        yieldprice.price as yield_price, yieldprice.singleuseprice as yield_singleuse_price,
        yieldprice.perperson_price as yield_perperson_price, ratetocategory.description,
        property_information.check_in_time, property_information.timezone
        
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN deskofdaysseason ON seasons.id = deskofdaysseason.seasonid
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id $prop_id_where_sql_str
        INNER JOIN property_information ON property_information.id = categories.property_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN onlinerates ON rate.id = onlinerates.rateid
        INNER JOIN online_rate_data ON rate.id = online_rate_data.rate_id
        LEFT JOIN yieldprice ON (yieldprice.id_restrict_rate = ratetocategory.rate_id
        AND yieldprice.category_id = ratetocategory.category_id
        AND deskofdaysseason.intdate = yieldprice.intdate)
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1
        AND deskofdaysseason.intdate >= $intdatein AND deskofdaysseason.intdate < $intdateout
        GROUP BY seasonspricelist.rate_id, seasonspricelist.category_id, deskofdaysseason.intdate ORDER BY seasonspricelist.category_id, seasonspricelist.rate_id ASC";
        
        $query = $this->db->query ( $sql );
        $counter = 0;
        if ($query->num_rows () > 0) {
            
            foreach ( $query->result () as $row ) {
                $restrict_continue_value = 0;
                if(isset($deskofrate_array[$row->category_id][$row->rate_id])){
                    foreach($deskofrate_array[$row->category_id][$row->rate_id] as $intdate => $cell){
                        if ($intdate < $intdateout) {
                            if ($cell["closed"] == 1) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if ($duration > $cell["maxstay"] && $cell["maxstay"] > 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if ($duration < $cell["minstaythrought"] && $cell["minstaythrought"] > 0) {
                                $restrict_continue_value = 1;
                                break;
                            }
                            if (($intdate == $intdatein) && ($cell["closedonarrival"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        } else {
                            if (($intdate == $intdateout) && ($cell["closedondeparture"] == 1)) {
                                $restrict_continue_value = 1;
                                break;
                            }
                        }
                    }
                }
                
                if($restrict_continue_value == 1){
                    continue;
                }
                
                if($row->baseplace == 0){
                    $baseplace = $categories [$row->category_id] ["places"];
                }else{
                    $baseplace = $row->baseplace;
                }
                
                if($row->maxplace == 0){
                    $maxplace = $categories [$row->category_id] ["add_places"];
                }else{
                    $maxplace = $row->maxplace;
                }
                
                // враховуєм значення з таблиці обмежень
                $bool_restrict = 0;
                if (isset ( $deskofrates [$row->category_id] [$row->restrictid] )) {
                    if ($deskofrates [$row->category_id] [$row->restrictid] ["max_closed"] > 0
                        or $deskofrates [$row->category_id] [$row->restrictid] ["max_minstaythrought"] > $duration) {
                            $bool_restrict = 1;
                        }
                }
                
                // враховуєм спецпропозицію з налаштувань онлайн рейтів /online_module/rates
                $timeshift_bool = 0;
                $timeshift = $row->onlinerate_timeshift;
                
                
                // визначаємо дату заїзду в годинах
                $check_in_time = $row->check_in_time != '' ? $row->check_in_time : '12:00';
               
                list ( $hour, $minute ) = explode ( ":", $check_in_time );
                list ( $year, $month, $day ) = explode ( "-", $datein );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datein_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );
                
                
                // визначаємо поточний час з врахуванням часової зони об'єкта
                if(trim($row->timezone) != ""){
                    $timezone = $row->timezone;
                }
                
                $date = new DateTime('NOW', new DateTimeZone($timezone));
                $datenow = $date->format('Y-m-d');
                $timenow = $date->format('H:i');
                
                list ( $hour, $minute ) = explode ( ":", $timenow );
                list ( $year, $month, $day ) = explode ( "-", $datenow );
                // $datenow_hours поточний час з врахуванням часової зони об'єкта в годинах
                $datenow_hours = round ( gmmktime ( $hour, $minute, 0, $month, $day, $year ) / 3600 );
                
                //echo $datein_hours." ".$datenow_hours." ".($datein_hours + $timeshift)." timeshift ".$timeshift."<br>";
                if ($timeshift != 0) {
                    if ($timeshift < 0) {
                        if (($datein_hours + $timeshift) <= $datenow_hours) {
                            $timeshift_bool = 1;
                        }
                    }
                    if ($timeshift > 0) {
                        if (($datein_hours - $datenow_hours) >= $timeshift) {
                            $timeshift_bool = 1;
                        }
                    }
                } else {
                    $timeshift_bool = 1;
                }
                //echo $bool_restrict."||".$timeshift_bool."<br>";
                if ($bool_restrict == 0 && $timeshift_bool == 1) {
                    $rates_2[$row->category_id][$row->rate_id]["rate_id"] = $row->rate_id;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["rate_name"] = $row->rate_name;
                    // $rates_2 [$row->category_id] [$row->rate_id] ["description"] = $row->description;
                    $rates_2[$row->category_id][$row->rate_id]["baseplace"] = $row->baseplace;
                    $rates_2[$row->category_id][$row->rate_id]["maxplace"] = $row->maxplace;
                    $rates_2[$row->category_id][$row->rate_id]["restrictid"] = $row->restrictid;
                    
                    $rates_2[$row->category_id][$row->rate_id]["ccforce"] = $row->ccforce;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount_type"] = $row->ccamount_type;
                    $rates_2[$row->category_id][$row->rate_id]["ccamount"] = $row->ccamount;
                    
                    $places_diff = $maxplace - $baseplace;
                    if ($baseplace == 1) {
                        //$places_diff -= 1;
                    }
                    if ($row->singleuse_price == 0) {
                        $singleuse_price = $categories[$row->category_id]["base_price"] * $duration;
                    } else {
                        $singleuse_price = $row->singleuse_price;
                    }
                    // echo $row->singleuse_price_count." - ".$duration."<br>";
                    // die();
                    if ($places_diff > 0) {
                        if ($row->singleuse_price > 0 && $baseplace > 1) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->singleuse_price;
                            }
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->singleuse_price;
                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                            }
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                            $counter ++;
                        }
                        
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                        if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;
                        }else{
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $row->price;
                        }
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $row->price;
                        $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                        $counter ++;
                        for ($pl = 1; $pl <= $places_diff; $pl ++) {
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["occupancy_places"] = $baseplace + $pl;
                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] = $row->price + ($row->perperson_price * $pl);
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["price"] += $row->price + ($row->perperson_price * $pl);
                            }
                            
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["daily_price"][$row->intdate]["price"] = $row->price + ($row->perperson_price * $pl);
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][$pl + 1]["counter"] = $counter;
                            $counter ++;
                        }
                    } else {
                        if ($baseplace > 1) {
                            if ($row->singleuse_price > 0) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->singleuse_price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->singleuse_price;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->singleuse_price;
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            }
                            
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["cid"] = $row->category_id;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["occupancy_places"] = $baseplace;
                            if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"])){
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] = $row->price;
                            }else{
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["price"] += $row->price;
                            }
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["daily_price"][$row->intdate]["price"] = $row->price;
                            $rates_2[$row->category_id][$row->rate_id]["occupancy"][1]["counter"] = $counter;
                            $counter ++;
                        } else {
                            if ($baseplace == 1) {
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["cid"] = $row->category_id;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["occupancy_places"] = 1;
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] = $row->price;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["price"] += $row->price;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["daily_price"][$row->intdate]["price"] = $row->price;
                                if(!isset($rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"])){
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] = $row->singleuse_price_count;
                                }else{
                                    $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["singleuse_price_count"] += $row->singleuse_price_count;
                                }
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["baseplace"] = $baseplace;
                                $rates_2[$row->category_id][$row->rate_id]["occupancy"][0]["counter"] = $counter;
                                $counter ++;
                            } else {}
                        }
                    }
                }
            }
        }
        
        foreach ($rates_2 as $cat_id => $category_cell) {
            foreach ($category_cell as $rate_id => $rate_cell) {
                foreach ($rate_cell["occupancy"] as $occupancy_inc => $occupancy_cell) {
                    // видалення одномісного заселення, якщо базова к-сть місць в номері більша за 1 і ціна одномісного заселення хоча б за один день рівна 0
                    if ($occupancy_inc == 0) {
                        if ($occupancy_cell["baseplace"] > 1) {
                            if ($occupancy_cell["singleuse_price_count"] != $duration) {
                                unset($rates_2[$cat_id][$rate_id]["occupancy"][0]);
                            }
                        }
                    }
                    
                    // видалення варіантів заселення, якщо ціна рівна 0
                    if ($occupancy_cell["price"] == 0) {
                        unset($rates_2[$cat_id][$rate_id]["occupancy"][$occupancy_inc]);
                        if(count($rates_2[$cat_id][$rate_id]["occupancy"]) == 0){
                            unset($rates_2[$cat_id][$rate_id]);
                            if(count($rates_2[$cat_id]) == 0){
                                unset($rates_2[$cat_id]);
                            }
                        }
                    }
                }
            }
        }
        
        //         echo "<pre>";
        //         print_r($rates_2);
        //         print_r($categories);
        //         die();
        
        $result_array = array();
        foreach($categories as $cat_id => $cell){
            if(isset($rates_2[$cat_id]) && $cell['count']){
                foreach ($rates_2[$cat_id] as $rate_id => &$rate_set) {
                    if (isset($rate_set['occupancy'])) {
                        foreach ($rate_set['occupancy'] as &$occupancy) {
                            $occupancy['rate_id'] = $rate_id;
                        }
                    };
                    // promo
                    $is_set_cat_rate_is_promoted = false;
                    if ($promocode_is_valid) {
                        if ($promocode_needs_calculation) { // v2
                            if (in_array($cat_id, $promoted_cats) && in_array($rate_id, $promoted_rates)) {
                                $is_set_cat_rate_is_promoted = true;
                            }
                        } else { // v1
                            $is_set_cat_rate_is_promoted = true; // v1 all gategories and rates are promoted
                        }
                    }
                    $rate_set['promoted'] = $is_set_cat_rate_is_promoted;
                    $rate_set['promo_data'] = $is_set_cat_rate_is_promoted ? $promo_data : array();
                    //promo END
                }
                $categories[$cat_id]["rates"] = $rates_2[$cat_id];
                $categories[$cat_id] ["rooms_remaining"] = $cell ["count"];
            }else{
                unset($categories[$cat_id]);
            }
            
        }
        
        $response['response'] =  array();
        if (count($categories)) {
            $response['response']['hms_free_proprooms'] = $categories;
        }
        echo json_encode ( $response );
    }//props_pmv3
    
    function getfreeroomsarray_pm3(){
        $request = file_get_contents("php://input");
        $request = json_decode($request, true);
        $response_data = array(
            'request' => $request
        );

        // 	    $request = array();
        // 	    $request['date_range'] = "2020-09-17 - 2020-09-19";
        // 	    $request['parties'] = array(array('adults'=>2));
        //echo "<pre>";
        //print_r($request);

        $response = array();
        $date_range_exploded = explode(" - ", $request['date_range']);
        $date_in = $response['date_in'] = $date_range_exploded[0];
        $date_out = $response['date_out'] = $date_range_exploded[1];
        $int_datein = round(strtotime($date_in) / 86400);
        $int_dateout = round(strtotime($date_out) / 86400);
        $requested_rooms_count = $response['requested_rooms_count'] = count($request['parties']);
        $hms_guests_set = array();
        $max_requested_persons = 1;
        foreach ($request['parties'] as $party) {
            $hms_guests = $this->party_to_hms_guests((object)$party);
            array_push($hms_guests_set, $hms_guests);
            $children_count = (isset($party['children'])) ? count($party['children']) : 0;
            $party_guests_count = $party['adults'] + $children_count;
            if ($party_guests_count > $max_requested_persons) {
                $max_requested_persons = $party_guests_count;
            }
        }
        $response['max_requested_persons'] = $max_requested_persons;
        $sql = "SELECT  t1.category_id, t1.count as rooms_remaining, COUNT(1) AS duration, categories.property_id,
        IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places, ratetocategory.rate_id
        FROM deskofdays_availability AS t1
        JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
        JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
        JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
        JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
        WHERE t1.intdate BETWEEN $int_datein AND $int_dateout AND t1.count >= $requested_rooms_count
        GROUP BY t1.category_id, rate.id
        HAVING 	duration >= ($int_dateout-$int_datein) AND max_room_places >= $max_requested_persons";
        //echo $sql;
        // $sql = "SELECT t1.category_id, t1.count as rooms_remaining,
        // COUNT(1) AS duration, SUM(IFNULL(yieldprice.price, seasonspricelist.price)) AS total_price,
        // IF(ratetocategory.maxplace, ratetocategory.maxplace, categories.add_places) AS max_room_places,
        // ratetocategory.rate_id
        // FROM deskofdays_availability AS t1
        // JOIN categories ON categories.id = t1.category_id AND categories.web_booking = 1
        // JOIN ratetocategory ON ratetocategory.category_id = t1.category_id AND ratetocategory.onlinebook = 1
        // JOIN rate ON rate.id = ratetocategory.rate_id AND rate.isactive = 1
        // JOIN onlinerates ON onlinerates.rateid = ratetocategory.rate_id
        // LEFT JOIN yieldprice ON yieldprice.id_restrict_rate = rate.id AND yieldprice.category_id = categories.id AND yieldprice.intdate = t1.intdate
        // JOIN deskofdaysseason ON deskofdaysseason.intdate = t1.intdate
        // JOIN seasons ON seasons.id = deskofdaysseason.seasonid AND seasons.is_active = 1
        // JOIN seasonspricelist ON seasonspricelist.rate_id = rate.id AND seasonspricelist.category_id = categories.id AND seasonspricelist.season_id = seasons.id
        // WHERE t1.intdate BETWEEN $int_datein AND $int_dateout AND t1.count >= $requested_rooms_count
        // GROUP BY t1.category_id, rate.id
        // HAVING duration >= ($int_dateout-$int_datein+1) AND max_room_places >= $max_requested_persons";

        $query_res = $this->db->query($sql)->result_array();
        $free_rooms = $suitable_categories = $suitable_rates = array();

        $TEMP_hms_guests = array();

        foreach ($query_res as $set) {
            if (! isset($response['duration'])) {
                $response['duration'] = $set['duration'];
            }
            $hms_parties_total_amount = 0;
            $data_for_hms_party_amount = array();
            $data_for_hms_party_tf_amount = array();
            $data_for_hms_party_amount['prop_id'] = $data_for_hms_party_tf_amount['property_id'] = $set['property_id'];
            $data_for_hms_party_amount['type_id'] = $set['category_id'];
            $data_for_hms_party_amount['price_type'] = $set['rate_id'];
            $data_for_hms_party_amount['datein'] = $date_in;
            $data_for_hms_party_amount['dateout'] = $date_out;
            $hms_all_parties_amount = 0;
            $data_for_hms_party_tf_amount['duration'] = $response['duration'];
            $hms_all_parties_tf_amount = 0;
            foreach ($request['parties'] as $party) {
                $hms_guests = $data_for_hms_party_tf_amount['guests'] = $this->party_to_hms_guests((object) $party, $set['category_id']);
                $data_for_hms_party_amount = array_merge($data_for_hms_party_amount, $hms_guests);
                $hms_party_amount = $this->frontdesk->get_otelms_amount($data_for_hms_party_amount);
                $hms_all_parties_amount += $hms_party_amount;
                $data_for_hms_party_tf_amount['amount'] = $hms_party_amount;
                $data_for_hms_party_tf_amount['guest_ages'] = $this->party_to_hms_guests_ages((object) $party);
                $tfs = $this->taxesfees_model->get_services_tf_data_by_property($data_for_hms_party_tf_amount);
                $hms_party_tf_amount = 0;
                foreach ($tfs as $tf_data) {
                    $hms_party_tf_amount += $tf_data['amount'];
                }
                $hms_all_parties_tf_amount += $hms_party_tf_amount;
                // 	            array_push($TEMP_hms_guests, array(
                // 	                'data' => $data_for_hms_party_amount,
                // 	                'guest_ages' => $data_for_hms_party_tf_amount['guest_ages'],
                // 	                'amount' => $hms_party_amount,
                // 	                'tf_amount' => $hms_party_tf_amount
                // 	            ));
            }
            $hms_parties_total_amount = $hms_all_parties_amount + $hms_all_parties_tf_amount;

            // 	        array_push($TEMP_hms_guests, array(
            // 	            'total' => $hms_parties_total_amount,
            // 	            'price' => $hms_all_parties_amount,
            // 	            'tf' => $hms_all_parties_tf_amount
            // 	        ));

            if (! isset($free_rooms[$set['category_id']])) {
                // 	            if (! in_array($set['category_id'], $suitable_categories)) {
                // 	                array_push($suitable_categories, $set['category_id']);
                // 	            }
                $free_rooms[$set['category_id']] = array(
                    'category_id' => $set['category_id'],
                    'rooms_remaining' => $set['rooms_remaining'],
                    'max_room_places' => $set['max_room_places']
                );
            }
            $free_rooms[$set['category_id']]['rates'][$set['rate_id']] = array(
                'rate_id' => $set['rate_id'],
                'price' => $hms_parties_total_amount
            );
            // 	        if (! in_array($set['rate_id'], $suitable_rates)) {
            // 	            array_push($suitable_rates, $set['rate_id']);
            // 	        }
        }
        //$response['suitable_categories'] = $suitable_categories;
        //$response['suitable_rates'] = $suitable_rates;
        $response['hms_free_rooms'] = $free_rooms;

        //$response['TEMP_hms_guests'] = $TEMP_hms_guests;
        // 	    echo "<pre>";
        // 	    print_r($response);
        // 	    die();
        $response_data['response'] = $response;
        echo json_encode($response_data);
    }

    function party_to_hms_guests($party, $cat_id=0) {
        $babies_count = 0;
        $over_children_count = 0;
        $ta_children = (isset($party->children)) ? $party->children : array();
        if (!empty($ta_children) && $cat_id){
            $sql = "SELECT t1.baby_places, t3.to AS max_baby_age, t4.to AS max_child_age
            FROM categories AS t1
            JOIN property_information AS t2 ON t1.property_id = t2.id
            LEFT JOIN age_ranges_acb AS t3 ON t2.range_id = t3.range_id AND t3.id = 1
            LEFT JOIN age_ranges_acb AS t4 ON t2.range_id = t4.range_id AND t4.id = 2
            WHERE t1.id = $cat_id";
            $row_rezult = $this->db->query($sql)->row();
            if (!empty($row_rezult)){
                $max_babies_and_children_places = $row_rezult->baby_places;
                $max_baby_age = isset($row_rezult->max_baby_age) ? (int)$row_rezult->max_baby_age : 0;
                $max_child_age = isset($row_rezult->max_child_age) ? (int)$row_rezult->max_child_age : 0;
                foreach ($ta_children as $ta_child_age) {
                    if($ta_child_age <= $max_baby_age){
                        $babies_count ++;
                    }elseif (($ta_child_age <= $max_child_age) && $max_babies_and_children_places > 0){
                        $max_babies_and_children_places--;
                    }else{
                        $over_children_count++;
                    }
                }
            }
        }
        $guests = array();
        $guests['adults'] = $party->adults + $over_children_count;
        $guests['baby_places'] = count($ta_children) - $over_children_count - $babies_count;
        $guests['babyplace2'] = $babies_count;
        return $guests;
    }

    function party_to_hms_guests_ages($party) {
        //$t = &$this->db_tables;
        $ages = array();
        $adults_min_age = 35;
        $adults = $party->adults;
        while ($adults > 0) {
            array_push($ages, $adults_min_age);
            $adults--;
        }
        if (isset($party->children)){
            foreach ($party->children as $child_age) {
                array_push($ages, $child_age);
            }
        }
        return $ages;
    }

    function getfreeroomsarray_debug() {
        // echo "test";
        $postdata = file_get_contents ( "php://input" );

        $data = json_decode ( $postdata, true );
        // echo "<pre>";
        // print_r($data);
        // die();
        // =======================================
        $datein = $data ["datein"];
        $dateout = $data ["dateout"];
        $add_places = $data ["add_places"];
        $baby_places = $data ["baby_places"];
        $price_type = $data ["price_type"];
        $currency = $data ["currency"];
        $personal_type = $data ["personal_type"];
        $discountpromocode = $data ["discountpromocode"];
        $language = $data ["language"];
        $countplaces = $data ["countplaces"];
        $forceroomid = $data ["forceroomid"];
        // =======================================

        $worktime_start = round ( time () );
        $my_rates = array ();
        // echo $countplaces;
        /*
         * $my_rates [0] ["rateid"] = 21; $my_rates [0] ["restrict_id"] = 3; $my_rates [0] ["place_count"] = 0; $my_rates [1] ["rateid"] = 22; $my_rates [1] ["restrict_id"] = 1; $my_rates [1] ["place_count"] = 0; $my_rates [2] ["rateid"] = 23; $my_rates [2] ["restrict_id"] = 3; $my_rates [2] ["place_count"] = 0;
         */
        $forceroomid_sql_1 = " ";
        $forceroomid_sql_2 = " ";
        if ($forceroomid != 0) {
            $forceroomid_sql_1 = "AND category_id = " . $forceroomid . " ";
            $forceroomid_sql_2 = "AND categories.id = " . $forceroomid . " ";
        }

        $sql = "SELECT * FROM onlinerates INNER JOIN rate ON rate.id = onlinerates.rateid";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                if ($row->rateid != 0) {
                    array_push ( $my_rates, array (
                        "rateid" => $row->rateid,
                        "restrictid" => $row->restrictid,
                        "timeshift" => $row->timeshift
                    ) );
                }
            }
        }

        $count_myrates = count ( $my_rates );

        $rate_2_sql = "";
        for($i = 0; $i < $count_myrates; $i ++) {
            if ($i == ($count_myrates - 1)) {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . " ";
            } else {
                $rate_2_sql .= $my_rates [$i] ["rateid"] . ", ";
            }
        }
        list ( $year, $month, $day ) = explode ( "-", date ( "Y-m-d" ) );
        $intdatenow = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

        $datein_hours = $intdatein * 24;
        $dateout_hours = $intdateout * 24;
        $datenow_hours = $intdatenow * 24;

        $duration = $intdateout - $intdatein;
        $temp_time_1 = microtime ( true );
        // $_POST['debug'] = true;
        $discount_percent = 0;

        $discount_code_array = array ();
        $sql = "SELECT * FROM onlinediscount WHERE datestart <= '" . $datein . "' AND dateend >= '" . $dateout . "'";
        // echo $sql;
        $query = $this->db->query ( $sql );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $discount_code_array [$row->code] = $row->percent;
            }
        }

        if (isset ( $discount_code_array [$discountpromocode] )) {
            $discount_percent = $discount_code_array [$discountpromocode];
        }
        // if ($discountpromocode == "777") {
        // $discount_percent = 10;
        // }

        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
            }
        }

        // $this->output->enable_profiler(TRUE);

        if ($personal_type == 2) {
            $personal_table = "gatewayoforder_personal";
        } else {
            $personal_table = "gatewayoforder";
        }
        // $personal_table = "gatewayoforder_personal";

        $rate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'rate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $rate_restrictID = $row->value;
        }

        $additionalrate_restrictID = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalrate_restrictID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalrate_restrictID = $row->value;
        }

        $deskofrates = array ();

        $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
        FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout $forceroomid_sql_1 GROUP BY rate_id, category_id";
        // echo $sql;
        // die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                $i ++;
            }
        }

        $deskof_restrictedprice = array ();
        $deskof_restrictedprice = $this->frontdesk->get_yieldprice ( $intdatein, $intdateout );

        $rate_strategy = $this->frontdesk->GetRateStrategy ();

        /*
         * $sql = "SELECT * FROM yieldprice WHERE intdate >= $intdatein AND intdate < $intdateout "; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { foreach ( $query->result () as $row ) { $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["perperson_price"] = $row->perperson_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["extrabed_price"] = $row->extrabed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["baby_2price"] = $row->baby_2price; $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice; } }
         */

        // echo "<pre>";
        // print_r ( $deskofrates );
        $additionalplaces = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalplaces'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additionalplaces = $row->value;
        }

        if ($price_type == 0) {
            $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }

        if ($price_type == 0 or $price_type == '') {
            $price_name_id = 1;
        } else {
            $price_name_id = $price_type;
        }
        $rates = array ();
        $temp_categories_places = array ();
        $sql = "SELECT id, add_places, places FROM categories";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                // $rates [0] [$row->id] ["id"] = 0;
                // $rates [0] [$row->id] ["description"] = "";
                // $rates [0] [$row->id] ["add_place"] = 0;
                // $rates [0] [$row->id] ["baseplace"] = $row->places;

                $temp_categories_places [$row->id] ["add_places"] = $row->add_places;
                $temp_categories_places [$row->id] ["places"] = $row->places;
            }
        }
        $additional_price_type = 0;
        $sql = "SELECT value FROM $personal_table WHERE name LIKE 'additional_rateID'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $additional_price_type = $row->value;
        }

        $ratetocategory = array ();
        $sql = "SELECT category_id, rate_id, onlinebook FROM ratetocategory";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $ratetocategory [$row->category_id] [$row->rate_id] ["onlinebook"] = $row->onlinebook;
            }
        }

        $rate_select_sql = $price_type;
        if ($additional_price_type != 0) {
            $rate_select_sql = $price_type . "," . $additional_price_type;
        }

        $global_array_restrict = array ();
        $global_array_restrict ["main"] ["rate"] = $price_type;
        $global_array_restrict ["main"] ["rate_restrict"] = $rate_restrictID;

        $global_array_restrict ["additional"] ["rate"] = $additional_price_type;
        $global_array_restrict ["additional"] ["rate_restrict"] = $additionalrate_restrictID;

        $array_prices_seasons = array ();
        $debug = array ();
        $debug ['countplaces'] = $countplaces;

        $sql = "SELECT  $personal_table.name, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
        seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
        ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng,  ratetocategory.description_pl, ratetocategory.description_ua
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
        INNER JOIN $personal_table ON $personal_table.value = rate.id
        WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1 AND ($personal_table.name LIKE 'rateID' OR $personal_table.name LIKE 'additional_rateID')
        AND rate.id in ( $rate_select_sql ) $forceroomid_sql_2
        GROUP BY $personal_table.name,seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY $personal_table.name DESC
        ";
        // echo $sql."<br>";
        $debug ['sql'] = $sql;

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $rates = array ();
            foreach ( $query->result () as $row ) {
                $description = "";
                $baseplace = 0;
                $maxplace = 0;
                /*
                 * $query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id ); if ($query2->num_rows () > 0) { $row2 = $query2->row (); switch ($language) { case "ua" : $description = $row2->description_ua; break; case "en" : $description = $row2->description_eng; break; case "ru" : $description = $row2->description; break; default : $description = $row2->description; break; } $baseplace = $row2->baseplace; $maxplace = $row2->maxplace; }
                 */

                switch ($language) {
                    case "ua" :
                        $description = $row->description_ua;
                        break;
                    case "en" :
                        $description = $row->description_eng;
                        break;
                    case "ru" :
                        $description = $row->description;
                        break;
                    case "pl" :
                        $description = $row->description_pl;
                        break;
                    default :
                        $description = $row->description;
                        break;
                }

                $baseplace = $row->baseplace;
                $maxplace = $row->maxplace;

                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                $rates [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                $rates [$row->rate_id] [$row->category_id] ["description"] = $description;

                $rates [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                $rates [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                if ($maxplace == 0) {
                    $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                } else {
                    // $maxplace = $row2->maxplace;
                }
                if ($baseplace == 0) {
                    $baseplace = $temp_categories_places [$row->category_id] ["places"];
                } else {
                    // $baseplace = $row2->baseplace;
                }

                if (($maxplace - $baseplace) > $additionalplaces) {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                } else {
                    $rates [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                }
                $rates [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;

                if ($row->name == "rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $rate_restrictID;
                }
                if ($row->name == "additional_rateID") {
                    $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $additionalrate_restrictID;
                }
            }
        }

        // echo "<pre>";
        // print_r ( $rates );

        /*
         * rates_2
         */
        $rates_2 = array ();
        if ($count_myrates > 0) {
            $array_prices_seasons_2 = array ();
            $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, onlinerates.restrictid,
            seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price, rate.breakfast, rate.nonrefundable,
            ratetocategory.maxplace, ratetocategory.baseplace, ratetocategory.description, ratetocategory.description_eng, ratetocategory.description_pl, ratetocategory.description_ua
            FROM seasonspricelist
            INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
            INNER JOIN rate ON rate.id = seasonspricelist.rate_id
            INNER JOIN categories ON categories.id = seasonspricelist.category_id
            INNER JOIN ratetocategory ON (categories.id = ratetocategory.category_id AND rate.id = ratetocategory.rate_id)
            INNER JOIN onlinerates ON rate.id = onlinerates.rateid
            WHERE ratetocategory.onlinebook = 1 AND categories.web_booking = 1 $forceroomid_sql_2
            GROUP BY seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY onlinerates.id ASC
            ";
            // echo $sql."<br>";
            $debug ['sql'] = $sql;

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {

                foreach ( $query->result () as $row ) {
                    $description = "";
                    $baseplace = 0;
                    $maxplace = 0;
                    /*
                     * $query2 = $this->db->query ( "SELECT maxplace, baseplace, description, description_eng, description_ua FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id ); if ($query2->num_rows () > 0) { $row2 = $query2->row (); switch ($language) { case "ua" : $description = $row2->description_ua; break; case "en" : $description = $row2->description_eng; break; case "ru" : $description = $row2->description; break; default : $description = $row2->description; break; } $baseplace = $row2->baseplace; $maxplace = $row2->maxplace; }
                     */
                    switch ($language) {
                        case "ua" :
                            $description = $row->description_ua;
                            break;
                        case "en" :
                            $description = $row->description_eng;
                            break;
                        case "ru" :
                            $description = $row->description;
                            break;
                        case "pl" :
                            $description = $row->description_pl;
                            break;
                        default :
                            $description = $row->description;
                            break;
                    }

                    $baseplace = $row->baseplace;
                    $maxplace = $row->maxplace;

                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons_2 [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                    $rates_2 [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                    $rates_2 [$row->rate_id] [$row->category_id] ["description"] = $description;

                    $rates_2 [$row->rate_id] [$row->category_id] ["nonrefundable"] = $row->nonrefundable;
                    $rates_2 [$row->rate_id] [$row->category_id] ["breakfast"] = $row->breakfast;

                    if ($maxplace == 0) {
                        $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                    } else {
                        // $maxplace = $row2->maxplace;
                    }
                    if ($baseplace == 0) {
                        $baseplace = $temp_categories_places [$row->category_id] ["places"];
                    } else {
                        // $baseplace = $row2->baseplace;
                    }

                    if (($maxplace - $baseplace) > $additionalplaces) {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                    } else {
                        $rates_2 [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                    }
                    $rates_2 [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;
                    $rates_2 [$row->rate_id] [$row->category_id] ["restrictid"] = $row->restrictid;
                }
            }
        }

        /*
         * end rates_2
         */
        // echo "<pre>";
        // print_r ( $rates_2 );

        // $debug['ar_pr_season'] = $array_prices_seasons;
        $debug ['rates'] = $rates;
        $debug ['restrict'] = $deskofrates;
        $debug ['restrict_prices'] = $deskof_restrictedprice;
        // echo "<pre>";
        // print_r($rates);

        /*
         * $sql = "SELECT * FROM seasons"; $query = $this->db->query ( $sql ); $season_data = array (); foreach ( $query->result () as $row ) { $season_data [$row->id] ["from"] = $row->startdate; $season_data [$row->id] ["to"] = $row->enddate; } $seasontable = array (); $seasontable = $this->getcosttable ( $datein, $dateout, $season_data ); $debug ['seasontable'] = $seasontable;
         */
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
        categories.baby_price, categories.name as c_name, categories.shortname, categories.comment, categories.comment_ru, categories.comment_eng, categories.comment_ua,
        categories.name_ru, categories.name_eng, categories.name_ua, categories.name_pl, categories.comment_pl,
        categories.places, categories.add_places, categories.settlementtype FROM rooms
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 $forceroomid_sql_2
        GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                // $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                switch ($language) {
                    case "ua" :
                        if ($row ["name_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ua"];
                        }
                        if ($row ["comment_ua"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ua"];
                        }
                        break;
                    case "en" :
                        if ($row ["name_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_eng"];
                        }
                        if ($row ["comment_eng"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_eng"];
                        }
                        break;
                    case "ru" :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                    case "pl" :
                        if ($row ["name_pl"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_pl"];
                        }
                        if ($row ["comment_pl"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_pl"];
                        }
                        break;
                    default :
                        if ($row ["name_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["name"] = $row ["name_ru"];
                        }
                        if ($row ["comment_ru"] == "") {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                        } else {
                            $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment_ru"];
                        }
                        break;
                }
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                // $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout $forceroomid_sql_2 GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $debug ['sql2'] = $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $max_places_select_arr = array ();
        $debug ["temp_1"] = $temp_1;
        $temp_3 ['debug'] = $debug;
        $temp_3 ["categories"] = array ();

        $temp_keys = array_keys ( $temp_1 );

        foreach ( $temp_keys as $key ) {
            $row_count = 0;
            $base_row_count = 0;
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;
            if ($discount_percent != 0) {
                $discount_value = ($temp_1 [$key] ["base_price"] / 100) * $discount_percent;
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"] - $discount_value;
                $post_data ["original_price"] = $temp_1 [$key] ["base_price"];
            } else {
                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            }
            // $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
            $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

            $post_data ["rate_restricted"] [$price_type] = $rate_restrictID;
            $post_data ["rate_restricted"] [$additional_price_type] = $additionalrate_restrictID;

            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $count_rooms."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = stripslashes ( $temp_1 [$key] ["name"] );
                $temp_3 ["categories"] [$key] ["online_name"] = stripslashes ( $temp_1 [$key] ["name"] );
                $temp_3 ["categories"] [$key] ["shortname"] = stripslashes ( $temp_1 [$key] ["shortname"] );
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["places"] = $temp_1 [$key]
                // ["places"];
                $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["amount"] = $total*$rate;

                $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
                $arr_keys = array_keys ( $rates );
                if (count ( $rates ) != 0) {
                    $temp_nonrefundable = "non";
                    $temp_breakfast = "non";
                    foreach ( $arr_keys as $row ) {
                        $insert_rate_category = 1;
                        /*
                         * if (isset ( $ratetocategory [$key] [$row] ["onlinebook"] )) { if ($ratetocategory [$key] [$row] ["onlinebook"] == 0) { $insert_rate_category = 0; } }
                         */
                        // echo $insert_rate_category."<br>";
                        $conditions_bool_count = 0;
                        $debug ['rate_category'] [$key] [$row] = $insert_rate_category;
                        if ($insert_rate_category == 1) {

                            $bool_restrict = 0;
                            if ($temp_nonrefundable != "non" and $temp_breakfast != "non") {
                                if ($temp_nonrefundable == $rates [$row] [$key] ["nonrefundable"] and $temp_breakfast == $rates [$row] [$key] ["breakfast"]) {
                                } else {
                                    $conditions_bool_count = 1;
                                }
                            }
                            // if ($row == $global_array_restrict ["main"] ["rate"])
                            // {
                            // $rate_restrict = $global_array_restrict ["main"]
                            // ["rate_restrict"];
                            // //echo $rate_restrict."<br>";
                            // if ($rate_restrict != 0) {
                            // if(isset($deskofrates [$key] [$rate_restrict]))
                            // if ($deskofrates [$key] [$rate_restrict]
                            // ["max_closed"] > 0 or $deskofrates [$key]
                            // [$rate_restrict] ["max_minstaythrought"] >=
                            // $duration-1) {
                            // $bool_restrict = 1;
                            // }
                            // }
                            // }

                            // if ($row == $global_array_restrict ["additional"]
                            // ["rate"]) {
                            // $rate_restrict = $global_array_restrict
                            // ["additional"] ["rate_restrict"];
                            // if ($rate_restrict != 0) {
                            // if(isset($deskofrates [$key] [$rate_restrict]))
                            // if ($deskofrates [$key] [$rate_restrict]
                            // ["max_closed"] > 0 or $deskofrates [$key]
                            // [$rate_restrict] ["max_minstaythrought"] >=
                            // $duration-1) {
                            // $bool_restrict = 1;
                            // }
                            // }
                            // }

                            if (isset ( $rates [$row] [$key] ["restrictid"] )) {
                                $rate_restrict = $rates [$row] [$key] ["restrictid"];
                            }

                            if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                                if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                    $bool_restrict = 1;
                                }
                            }
                            if ($bool_restrict == 0) {
                                $row_count ++;
                                $rate_i = $row;
                                // echo $row."<br>";
                                $time_1 = microtime ( true );
                                if ($rate_i != 0) {
                                    // $sss = $this->getpricecalculation3 (
                                    // $post_data,
                                    // 0, 1, "", $array_prices_seasons [$rate_i],
                                    // $season_data, $seasontable );
                                    $post_data ["price_type"] = $row;
                                    $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy );
                                } else {
                                    $sss = array ();
                                }
                                // echo "<pre>";
                                // print_r($sss);
                                // die();
                                $debug ['tariff'] [$rate_i] = $sss;
                                $time_2 = microtime ( true );
                                $total = 0;
                                $add_places_total = 0;
                                for($i = 0; $i < count ( $sss ); $i ++) {
                                    $total += $sss [$i] ["amount"];
                                    $add_places_total += $sss [$i] ["add_places_amount"];
                                }
                                if ($total == 0) {
                                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] = $rates [$row] [$key] ["baseplace"];
                                $max_places_select_arr [$rates [$row] [$key] ["baseplace"]] = true;
                                if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] and $countplaces != 0) {
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = 0;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = 0;
                                    for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {
                                        $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $i] = true;
                                    }
                                } else {
                                    for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {

                                        if ($discount_percent != 0) {
                                            $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                        } else {
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        }
                                        // $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"] = $i;
                                        $row_count ++;
                                        if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"] = $add_places_total * $i;
                                            $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"];
                                        }

                                        $max_places_select_arr [$rates [$row] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"]] = true;
                                    }
                                }

                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_price"] = $add_places_total;
                                if ($discount_percent != 0) {
                                    $discount_value = ($total / 100) * $discount_percent;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total - $discount_value;
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["original_price"] = $total;
                                } else {
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["time"] = $time_2 - $time_1;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["description"] = $rates [$row] [$key] ["description"];
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["nonrefundable"] = $rates [$row] [$key] ["nonrefundable"];
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["breakfast"] = $rates [$row] [$key] ["breakfast"];

                                $temp_nonrefundable = $rates [$row] [$key] ["nonrefundable"];
                                $temp_breakfast = $rates [$row] [$key] ["breakfast"];

                                $temp_3 ["categories"] [$key] ['rates'] [$row] ['c_row_bool_count'] = $conditions_bool_count;

                                $base_row_count ++;
                            }
                        }
                    }
                } else {
                    // echo "000000000000000";
                    // unset($temp_3 ["categories"] [$key]);
                }
                // print_r($my_rates);
                // echo "datein: ".($intdatein * 24) . "<br>";
                // echo "dateout: ".($intdateout * 24) . "<br>";
                // echo "now: ".($intdatenow * 24) . "<br>";
                $new_count_my_rates = 0;
                // echo $count_myrates;
                $count_rate_2 = count ( $my_rates );
                for($r = 0; $r < $count_rate_2; $r ++) {
                    $timeshift_bool = 0;
                    $timeshift = $my_rates [$r] ["timeshift"];

                    if ($timeshift != 0) {
                        if ($timeshift < 0) {
                            if (($datein_hours + $timeshift) < $datenow_hours) {
                                $timeshift_bool = 1;
                            }
                        }
                        if ($timeshift > 0) {
                            if (($datein_hours - $datenow_hours) > $timeshift) {
                                $timeshift_bool = 1;
                            }
                        }
                    } else {
                        $timeshift_bool = 1;
                    }
                    if ($timeshift_bool == 1) {
                        $bool_restrict = 0;
                        if ($my_rates [$r] ["restrictid"] != 0 and $my_rates [$r] ["restrictid"] != "") {
                            $rate_restrict = $my_rates [$r] ["restrictid"];
                            if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                                if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                    $bool_restrict = 1;
                                }
                            }
                        }
                        if ($bool_restrict == 0) {
                            // echo "11111112222222222222<br>";
                            // $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] = $temp_3 ["categories"] [$key] ['rates'] [1];
                            $rate_i = $my_rates [$r] ["rateid"];
                            // echo $rate_i."<br>";
                            if (isset ( $rates_2 [$rate_i] [$key] )) {
                                // echo "++";
                                $time_1 = microtime ( true );
                                if ($rate_i != 0) {
                                    // $sss = $this->getpricecalculation3 (
                                    // $post_data,
                                    // 0, 1, "", $array_prices_seasons [$rate_i],
                                    // $season_data, $seasontable );
                                    $post_data ["price_type"] = $rate_i;
                                    $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice, $rate_strategy );
                                } else {
                                    $sss = array ();
                                }
                                // echo "<pre>$rate_i".$rates_2 [$rate_i] [$key] ["baseplace"];
                                // print_r($sss);
                                // die();
                                $debug ['tariff'] [$rate_i] = $sss;
                                $time_2 = microtime ( true );
                                $total = 0;
                                $add_places_total = 0;
                                for($i = 0; $i < count ( $sss ); $i ++) {
                                    $total += $sss [$i] ["amount"];
                                    $add_places_total += $sss [$i] ["add_places_amount"];
                                }
                                if ($total == 0) {
                                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                                }
                                // echo $rate_i." ".$key."<br>";
                                $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                                // ==============================================
                                // ==============================================
                                // ==============================================
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                                $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"]] = true;
                                if ($countplaces == $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] and $countplaces != 0) {
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = 0;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = 0;
                                    for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {
                                        $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $i] = true;
                                    }
                                } else {
                                    for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) {

                                        if ($discount_percent != 0) {
                                            $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i);
                                        } else {
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        }
                                        // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                        $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i;
                                        $row_count ++;
                                        if ($countplaces == ($temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]) and $countplaces != 0) {
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["amount"] = $add_places_total * $i;
                                            $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["fixed"] ["addplaces"] = $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"];
                                        }

                                        $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true;
                                    }
                                }
                                // ==============================================
                                // ==============================================
                                // ==============================================

                                /*
                                 * for($i = 1; $i <= $rates_2 [$rate_i] [$key] ["add_place"]; $i ++) { if ($discount_percent != 0) { $discount_value = (($total + ($add_places_total * $i)) / 100) * $discount_percent; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = ($total + ($add_places_total * $i)) - $discount_value; $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["original_price"] = $total + ($add_places_total * $i); } else { $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); } // $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i); $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"] = $i; $max_places_select_arr [$rates_2 [$rate_i] [$key] ["baseplace"] + $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_places_list"] [$i] ["addplaces"]] = true; $row_count ++; }
                                 */
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["baseplace"] = $rates_2 [$rate_i] [$key] ["baseplace"];
                                ;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["add_price"] = $add_places_total;
                                if ($discount_percent != 0) {
                                    $discount_value = ($total / 100) * $discount_percent;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total - $discount_value;
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["original_price"] = $total;
                                } else {
                                    $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["amount"] = $total;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["time"] = $time_2 - $time_1;
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["description"] = $rates_2 [$rate_i] [$key] ["description"];
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["nonrefundable"] = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ["breakfast"] = $rates_2 [$rate_i] [$key] ["breakfast"];

                                $temp_nonrefundable = $rates_2 [$rate_i] [$key] ["nonrefundable"];
                                $temp_breakfast = $rates_2 [$rate_i] [$key] ["breakfast"];
                                if (! isset ( $conditions_bool_count )) {
                                    $conditions_bool_count = 0;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$rate_i] ['c_row_bool_count'] = $conditions_bool_count;

                                $row_count ++;

                                $new_count_my_rates ++;
                                // if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] ["add_places_list"] )) {
                                // $row_count += count ( $temp_3 ["categories"] [$key] ['rates'] [$my_rates [$r] ["rateid"]] ["add_places_list"] );
                                // /}
                            }
                        }
                    }
                }

                // $temp_3 ["categories"] [$key] ['c_row_bool_count'] = $conditions_bool_count;
                $temp_3 ["categories"] [$key] ['row_count'] = $row_count;
                $temp_3 ["categories"] [$key] ['base_row_count'] = $base_row_count + $new_count_my_rates;
                if (isset ( $temp_3 ["categories"] [$key] ['rates'] )) {
                } else {
                    unset ( $temp_3 ["categories"] [$key] );
                }
            }
        }

        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
                $temp_3 ["services"] [$row ["id"]] ["description"] = $row ["description"];
            }
        }
        $temp_time_2 = microtime ( true );
        $temp_3 ['debug'] = $debug;

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>+++++++++++++++++++++++++++++++++++++";
        // print_r ( $temp_3 );
        if ($countplaces != 0) {
            $temp_keys = array_keys ( $temp_3 ["categories"] );

            foreach ( $temp_keys as $key ) {
                $arr_keys = array_keys ( $temp_3 ["categories"] [$key] ['rates'] );
                $unset_bool = 0;
                foreach ( $arr_keys as $row ) {
                    if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] )) {
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["addplaces"];
                        $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] += $temp_3 ["categories"] [$key] ['rates'] [$row] ["fixed"] ["amount"];
                        // $temp_3 ["categories"] [$key] ['row_count'] = 1;
                        // $temp_3 ["categories"] [$key] ['base_row_count'] = 1;
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list);

                        $unset_bool = 1;
                    } else {
                        $count_add_places_list = 0;
                        if (isset ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] )) {
                            $count_add_places_list = count ( $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] );
                        }
                        unset ( $temp_3 ["categories"] [$key] ['rates'] [$row] );

                        $temp_3 ["categories"] [$key] ['row_count'] = $temp_3 ["categories"] [$key] ['row_count'] - ($count_add_places_list + 1);
                        $temp_3 ["categories"] [$key] ['base_row_count'] = $temp_3 ["categories"] [$key] ['base_row_count'] - 1;
                    }
                }
                if ($unset_bool == 0) {
                    unset ( $temp_3 ["categories"] [$key] );
                }
            }
        }
        // print_r ( $temp_3 );
        $max_places_select_arr [0] = 1;
        $temp_3 ["max_places_select_arr"] = $max_places_select_arr;
        $temp_3 ['debug'] = "skip";
        $output = json_encode ( $temp_3 );

        $worktime_end = round ( time () );
        $worktime = $worktime_end - $worktime_start;
        $sql = "INSERT INTO global_hotelix_analitycs.freeroom_request(hmsid, funcid, host, worktime, timestamp) VALUES(" . $this->config->item ( 'hotel_id' ) . ", 1, '', '" . $worktime . "', '" . date ( "Y-m-d H:i:s" ) . "')";
        $query = $this->db->query ( $sql );

        echo $output;
    }

    function getfreeroomsarray2_2_quota($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1, $personal_type = 1, $agent_id = 0) {
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $duration = $intdateout - $intdatein;
        $temp_time_1 = microtime ( true );
        // $_POST['debug'] = true;
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
            }
        }
        if ($agent_id != 0 and $agent_id != "") {
            // $this->output->enable_profiler(TRUE);

            if ($personal_type == 2) {
                $personal_table = "gatewayoforder_personal";
            } else {
                $personal_table = "gatewayoforder";
            }
            // $personal_table = "gatewayoforder_personal";

            $rate_restrictID = 0;
            $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'rate_restrictID'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $rate_restrictID = $row->value;
            }

            $additionalrate_restrictID = 0;
            $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalrate_restrictID'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $additionalrate_restrictID = $row->value;
            }

            $deskofrates = array ();

            $sql = "SELECT intdate, rate_id, category_id, MAX(closed) as max_closed, MAX(minstaythrought) as max_minstaythrought
            FROM deskofrate WHERE  intdate >= $intdatein AND intdate < $intdateout GROUP BY rate_id, category_id";
            // echo $sql;
            // die();
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $i = 0;
                foreach ( $query->result () as $row ) {
                    $deskofrates [$row->category_id] [$row->rate_id] ["max_closed"] = $row->max_closed;
                    $deskofrates [$row->category_id] [$row->rate_id] ["max_minstaythrought"] = $row->max_minstaythrought;
                    $i ++;
                }
            }

            $deskof_restrictedprice = array ();

            $sql = "SELECT intdate, id_restrict_rate, category_id, price
            FROM yieldprice WHERE  intdate >= $intdatein AND intdate < $intdateout ";
            // echo $sql;
            // die();
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
                }
            }

            // echo "<pre>";
            // print_r ( $deskofrates );
            $additionalplaces = 0;
            $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'additionalplaces'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $additionalplaces = $row->value;
            }

            if ($price_type == 0) {
                $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $price_type = $row->value;
                }
            }

            if ($price_type == 0 or $price_type == '') {
                $price_name_id = 1;
            } else {
                $price_name_id = $price_type;
            }
            $rates = array ();
            $temp_categories_places = array ();
            $sql = "SELECT id, add_places, places FROM categories";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $rates [0] [$row->id] ["id"] = 0;
                    $rates [0] [$row->id] ["description"] = "";
                    $rates [0] [$row->id] ["add_place"] = 0;
                    $row->add_places;
                    $rates [0] [$row->id] ["baseplace"] = $row->places;

                    $temp_categories_places [$row->id] ["add_places"] = $row->add_places;
                    $temp_categories_places [$row->id] ["places"] = $row->places;
                }
            }
            $additional_price_type = 0;
            $sql = "SELECT value FROM $personal_table WHERE name LIKE 'additional_rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $additional_price_type = $row->value;
            }

            $rate_select_sql = $price_type;
            if ($additional_price_type != 0) {
                $rate_select_sql = $price_type . "," . $additional_price_type;
            }

            $global_array_restrict = array ();
            $global_array_restrict ["main"] ["rate"] = $price_type;
            $global_array_restrict ["main"] ["rate_restrict"] = $rate_restrictID;

            $global_array_restrict ["additional"] ["rate"] = $additional_price_type;
            $global_array_restrict ["additional"] ["rate_restrict"] = $additionalrate_restrictID;

            $array_prices_seasons = array ();
            $debug = array ();

            $sql = "SELECT  $personal_table.name, seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id,
            seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
            FROM seasonspricelist
            INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
            INNER JOIN rate ON rate.id = seasonspricelist.rate_id
            INNER JOIN categories ON categories.id = seasonspricelist.category_id
            INNER JOIN $personal_table ON $personal_table.value = rate.id
            WHERE categories.web_booking = 1 AND ($personal_table.name LIKE 'rateID' OR $personal_table.name LIKE 'additional_rateID')
            AND rate.id in ( $rate_select_sql )
            GROUP BY $personal_table.name,seasonspricelist.category_id, seasonspricelist.rate_id,seasons.id ORDER BY $personal_table.name DESC
            ";
            // echo $sql;
            $debug ['sql'] = $sql;

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $rates = array ();
                foreach ( $query->result () as $row ) {
                    $description = "";
                    $baseplace = 0;
                    $maxplace = 0;
                    $query2 = $this->db->query ( "SELECT maxplace, baseplace, description FROM ratetocategory WHERE category_id = " . $row->category_id . " AND rate_id = " . $row->rate_id );
                    if ($query2->num_rows () > 0) {
                        $row2 = $query2->row ();
                        $description = $row2->description;
                        $baseplace = $row2->baseplace;
                        $maxplace = $row2->maxplace;
                    }
                    $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["price"] = $row->price;
                    $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["perperson_price"] = $row->perperson_price;
                    $array_prices_seasons [$row->rate_id] [$row->category_id] [$row->season_id] ["extrabed_price"] = $row->extrabed_price;
                    $rates [$row->rate_id] [$row->category_id] ["id"] = $row->rate_id;
                    $rates [$row->rate_id] [$row->category_id] ["description"] = $description;
                    if ($maxplace == 0) {
                        $maxplace = $temp_categories_places [$row->category_id] ["add_places"];
                    } else {
                        $maxplace = $row2->maxplace;
                    }
                    if ($baseplace == 0) {
                        $baseplace = $temp_categories_places [$row->category_id] ["places"];
                    } else {
                        $baseplace = $row2->baseplace;
                    }

                    if (($maxplace - $baseplace) > $additionalplaces) {
                        $rates [$row->rate_id] [$row->category_id] ["add_place"] = $additionalplaces;
                    } else {
                        $rates [$row->rate_id] [$row->category_id] ["add_place"] = $maxplace - $baseplace;
                    }
                    $rates [$row->rate_id] [$row->category_id] ["baseplace"] = $baseplace;

                    if ($row->name == "rateID") {
                        $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $rate_restrictID;
                    }
                    if ($row->name == "additional_rateID") {
                        $rates [$row->rate_id] [$row->category_id] ["restrictid"] = $additionalrate_restrictID;
                    }
                }
            }

            // $debug['ar_pr_season'] = $array_prices_seasons;
            $debug ['rates'] = $rates;
            $debug ['restrict'] = $deskofrates;
            $debug ['restrict_prices'] = $deskof_restrictedprice;
            // echo "<pre>";
            // print_r($rates);

            $sql = "SELECT * FROM seasons";
            $query = $this->db->query ( $sql );
            $season_data = array ();
            foreach ( $query->result () as $row ) {
                $season_data [$row->id] ["from"] = $row->startdate;
                $season_data [$row->id] ["to"] = $row->enddate;
            }

            $seasontable = array ();
            $seasontable = $this->getcosttable ( $datein, $dateout, $season_data );
            $debug ['seasontable'] = $seasontable;

            $temp_1 = array ();
            $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.add_places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = stripslashes ( $row ["c_name"] );
                    $temp_1 [$row ["category_id"]] ["shortname"] = stripslashes ( $row ["shortname"] );
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                    $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                    $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
                }
            }
            $temp_2 = array ();
            $sql = "SELECT t.category_id, t.shortname, SUM(if(t.count >= $duration, 1, 0)) AS count  FROM (SELECT count(rooms.id) as count, rooms.category_id, rooms.name, categories.shortname
            FROM deskofreservation
            INNER JOIN deskofdays ON deskofdays.reservation_id= deskofreservation.id
            INNER JOIN rooms ON rooms.id = deskofreservation.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            WHERE categories.web_booking = 1 AND deskofreservation.id_dealer = $agent_id AND deskofreservation.status = 4 AND
            deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY deskofreservation .room_id) as t GROUP BY t.category_id";
            // echo $sql . "\n\n\n\n\n\n\n<br><br><br>";
            $debug ['sql2'] = $sql;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = stripslashes ( $row ["shortname"] );
                }
            }

            $temp_3 = array ();
            $debug ["temp_1"] = $temp_1;
            $temp_3 ['debug'] = $debug;
            $temp_3 ["categories"] = array ();

            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $row_count = 0;
                $base_row_count = 0;
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
                $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
                $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

                $post_data ["rate_restricted"] [$price_type] = $rate_restrictID;
                $post_data ["rate_restricted"] [$additional_price_type] = $additionalrate_restrictID;

                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = 0;
                }
                // echo $count_rooms."<br>";
                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    // $temp_3["categories"] [$key] ["places"] = $temp_1 [$key]
                    // ["places"];
                    $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
                    // $temp_3["categories"] [$key] ["amount"] = $total*$rate;

                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                    $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                    $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
                    $arr_keys = array_keys ( $rates );
                    if (count ( $rates ) != 0) {
                        foreach ( $arr_keys as $row ) {
                            $bool_restrict = 0;
                            $rate_restrict = 0;
                            if (isset ( $rates [$row] [$key] ["restrictid"] )) {
                                $rate_restrict = $rates [$row] [$key] ["restrictid"];
                            }

                            if (isset ( $deskofrates [$key] [$rate_restrict] )) {
                                if ($deskofrates [$key] [$rate_restrict] ["max_closed"] > 0 or $deskofrates [$key] [$rate_restrict] ["max_minstaythrought"] > $duration) {
                                    $bool_restrict = 1;
                                }
                            }
                            if ($bool_restrict == 0) {
                                $row_count ++;
                                $rate_i = $row;
                                // echo $row."<br>";
                                $time_1 = microtime ( true );
                                if ($rate_i != 0) {
                                    // $sss = $this->getpricecalculation3 (
                                    // $post_data,
                                    // 0, 1, "", $array_prices_seasons
                                    // [$rate_i],
                                    // $season_data, $seasontable );
                                    $post_data ["price_type"] = $row;
                                    $sss = $this->getpricecalculation31 ( $post_data, 0, 0, $deskof_restrictedprice );
                                } else {
                                    $sss = array ();
                                }
                                // echo "<pre>";
                                // print_r($sss);
                                // die();
                                $debug ['tariff'] [$rate_i] = $sss;
                                $time_2 = microtime ( true );
                                $total = 0;
                                $add_places_total = 0;
                                for($i = 0; $i < count ( $sss ); $i ++) {
                                    $total += $sss [$i] ["amount"];
                                    $add_places_total += $sss [$i] ["add_places_amount"];
                                }
                                if ($total == 0) {
                                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                                }
                                for($i = 1; $i <= $rates [$rate_i] [$key] ["add_place"]; $i ++) {
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["amount"] = $total + ($add_places_total * $i);
                                    $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_places_list"] [$i] ["addplaces"] = $i;
                                    $row_count ++;
                                }
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["baseplace"] = $rates [$row] [$key] ["baseplace"];
                                ;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["add_price"] = $add_places_total;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["amount"] = $total;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["time"] = $time_2 - $time_1;
                                $temp_3 ["categories"] [$key] ['rates'] [$row] ["description"] = $rates [$row] [$key] ["description"];
                                $base_row_count ++;
                            }
                        }
                    } else {
                        // echo "000000000000000";
                        // unset($temp_3 ["categories"] [$key]);
                    }
                    $temp_3 ["categories"] [$key] ['row_count'] = $row_count;
                    $temp_3 ["categories"] [$key] ['base_row_count'] = $base_row_count;
                    if (isset ( $temp_3 ["categories"] [$key] ['rates'] )) {
                    } else {
                        unset ( $temp_3 ["categories"] [$key] );
                    }
                }
            }

            $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                    $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
                    $temp_3 ["services"] [$row ["id"]] ["description"] = $row ["description"];
                }
            }
            $temp_time_2 = microtime ( true );
            $temp_3 ['debug'] = $debug;

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            // echo "<pre>";
            // print_r ( $temp_3 );
            $output = json_encode ( $temp_3 );

            echo $output;
        }
    }
    function getfreeroomsarray_quota_testOLD($intdatein, $intdateout) {
        // list ( $year, $month, $day ) = explode ( "-", $datein );
        // $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) /
        // 86400 );
        // list ( $year, $month, $day ) = explode ( "-", $dateout );
        // $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) /
        // 86400 );
        $duration = $intdateout - $intdatein;
        $temp_time_1 = microtime ( true );
        // $_POST['debug'] = true;
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
            }
        }

        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofreservation.status = 4 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY rooms.category_id";
        echo $sql . "\n";
        $debug ['sql2'] = $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }
        echo "<pre>";
        print_r ( $temp_2 );
    }
    function getfreeroomsarraygroup($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1, $personal_type = 1) {
        $temp_time_1 = microtime ( true );
        // $this->output->enable_profiler(TRUE);
        // $rate = $this->frontdesk->getrate($currency);
        // echo $rate;
        // require_once('JSON.php');
        // $json = new Services_JSON();
        if ($price_type == 0) {
            $sql = "SELECT value FROM gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }
        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.is_active = 1
		GROUP by rooms.category_id";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $temp_3 ["categories"] = array ();
        $temp_keys = array_keys ( $temp_1 );
        foreach ( $temp_keys as $key ) {
            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $total."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
            }
        }
        $temp_time_2 = microtime ( true );

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        echo "<pre>";
        print_r ( $temp_3 );
        // $output = $json->encode($temp_3);
        $output = json_encode ( $temp_3 );
        print_r ( $output );
        // echo $output;
        return $temp_3;
    }
    function getfreeroomsarray2_1($datein, $dateout, $add_places = 0, $baby_places = 0, $price_type = 0, $currency = 1) {
        $temp_time_1 = microtime ( true );
        if (isset ( $_POST ['debug'] )) {
            if ($_POST ['debug'] == true) {
                $this->output->enable_profiler ( TRUE );
                $data = array ();
                $data ['debug'] = true;
                // $output = json_encode ( $data );
                // echo $output;
                // return ;
            }
        }
        // $this->output->enable_profiler(TRUE);
        // $rate = $this->frontdesk->getrate($currency);
        // echo $rate;
        // require_once('JSON.php');
        // $json = new Services_JSON();

        $select_rates = "";
        $query = $this->db->query ( "SELECT DISTINCT rate_id FROM  ratetocategory" );
        if ($query->num_rows () > 0) {
            $select_rates = " rate.id IN (";
            $k = 1;
            foreach ( $query->result () as $row ) {
                if ($query->num_rows () > $k) {
                    $select_rates .= $row->rate_id . ",";
                } else {
                    $select_rates .= $row->rate_id;
                }
                $k ++;
            }
            $select_rates .= ") ";
        }
        if ($price_type == 0) {
            $sql = "SELECT value FROM gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
        }

        if ($price_type == 0 or $price_type == '') {
            $price_name_id = 1;
        } else {
            // $sql = "SELECT table_name FROM rate WHERE id = " . $data
            // ["price_type"];
            // $query = $this->db->query ( $sql );
            // $row = $query->row ();
            $price_name_id = $price_type;
        }
        $array_prices_seasons = array ();

        $sql = "SELECT  seasonspricelist.rate_id, seasonspricelist.season_id, seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price, seasonspricelist.extrabed_price
        FROM seasonspricelist
        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        INNER JOIN categories ON categories.id = seasonspricelist.category_id
        WHERE categories.web_booking = 1
        AND $select_rates
        GROUP BY seasonspricelist.category_id, rate.id, seasons.id
        ";
        // echo $sql;

        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $array_prices_seasons [$row->category_id] [$row->rate_id] [$row->season_id] ["price"] = $row->price;
                $array_prices_seasons [$row->category_id] [$row->rate_id] ["perperson_price"] = $row->perperson_price;
                $array_prices_seasons [$row->category_id] [$row->rate_id] ["extrabed_price"] = $row->extrabed_price;
            }
        }

        $sql = "SELECT * FROM seasons";
        $query = $this->db->query ( $sql );
        $season_data = array ();
        foreach ( $query->result () as $row ) {
            // print_r( $row) . "\n";
            $season_data [$row->id] ["from"] = $row->startdate;
            $season_data [$row->id] ["to"] = $row->enddate;
        }

        list ( $year, $month, $day ) = explode ( "-", $datein );
        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        list ( $year, $month, $day ) = explode ( "-", $dateout );
        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
        $temp_1 = array ();
        $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.add_price,
			categories.baby_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places, categories.add_places, categories.settlementtype FROM rooms
		INNER JOIN categories ON categories.id = rooms.category_id
		WHERE categories.web_booking = 1
		GROUP by rooms.category_id ORDER BY categories.order ASC";
        // echo "<pre>" . $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                $temp_1 [$row ["category_id"]] ["add_price"] = $row ["add_price"];
                $temp_1 [$row ["category_id"]] ["baby_price"] = $row ["baby_price"];
                $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                $temp_1 [$row ["category_id"]] ["add_places"] = $row ["add_places"];
                $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                $temp_1 [$row ["category_id"]] ["settlementtype"] = $row ["settlementtype"];
            }
        }
        $temp_2 = array ();
        $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
        FROM deskofdays
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
        INNER JOIN categories ON categories.id = rooms.category_id
        WHERE categories.web_booking = 1 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout GROUP BY rooms.category_id";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
            }
        }

        $temp_3 = array ();
        $temp_3 ["categories"] = array ();
        $temp_keys = array_keys ( $temp_1 );
        foreach ( $temp_keys as $key ) {
            $post_data = array ();
            $post_data ["type_id"] = $key;
            $post_data ["datein"] = $datein;
            $post_data ["dateout"] = $dateout;
            $post_data ["add_places"] = $add_places;
            $post_data ["baby_places"] = $baby_places;
            $post_data ["price_type"] = $price_type;

            $post_data ["base_price"] = $temp_1 [$key] ["base_price"];
            $post_data ["add_price"] = $temp_1 [$key] ["add_price"];
            $post_data ["baby_price"] = $temp_1 [$key] ["baby_price"];

            $sss = $this->getpricecalculation2 ( $post_data, 0, 1, "", $array_prices_seasons, $season_data );
            // echo "<pre>";
            // print_r($sss);
            $total = 0;
            $add_places_total = 0;
            for($i = 0; $i < count ( $sss ); $i ++) {
                $total += $sss [$i] ["amount"];
                $add_places_total += $sss [$i] ["add_places_amount"];
            }

            if ($total == 0) {
                $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
            }
            if (isset ( $temp_2 [$key] ["count"] )) {
                $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
            } else {
                $count_rooms = $temp_1 [$key] ["count"];
            }
            // echo $total."<br>";
            if ($count_rooms != 0) {
                $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                $temp_3 ["categories"] [$key] ["add_places"] = $temp_1 [$key] ["add_places"] - $temp_1 [$key] ["places"];
                // $temp_3["categories"] [$key] ["amount"] = $total*$rate;
                $temp_3 ["categories"] [$key] ["add_price"] = $add_places_total;
                $temp_3 ["categories"] [$key] ["amount"] = $total;

                $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                $temp_3 ["categories"] [$key] ["settlementtype"] = $temp_1 [$key] ["settlementtype"];
                $temp_3 ["categories"] [$key] ["base_price"] = $temp_1 [$key] ["base_price"];
            }
        }

        $sql = "SELECT * FROM  services_types WHERE online_booking = 1";
        // echo $sql . "\n";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {
                $temp_3 ["services"] [$row ["id"]] ["name"] = $row ["name"];
                $temp_3 ["services"] [$row ["id"]] ["baseprice"] = $row ["baseprice"];
            }
        }
        $temp_time_2 = microtime ( true );

        $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $temp_3 );
        print_r ( $output );
        // echo $output;
    }
    function getroomsarrayAll($datein, $dateout) {
        // return 1;
        // print_r($_POST);
        // print_r($_GET);
        $hosts = array ();
        $hosts = json_decode ( $_POST ['hosts'], true );
        // print_r($hosts);
        // die();
        // $this->output->enable_profiler(TRUE);

        // $hosts[1]["host"] = "zmis.otelms.com";
        // $hosts[1]["dbname"] = "hotelix_zmis";
        // $hosts[2]["host"] = "terem.otelms.com";
        // $hosts[2]["dbname"] = "hotelix_terem";
        $add_places = 0;
        $baby_places = 0;
        $temp_time_1 = microtime ( true );
        $currency = 1;
        // $rate = $this->frontdesk->getrate($currency);
        $all_array = array ();
        for($host_i = 0; $host_i < count ( $hosts ); $host_i ++) {
            $query = $this->db->query ( "SELECT db_name FROM visitka.config
				 WHERE host LIKE '" . $hosts [$host_i] . "'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
                $db_name = "`" . $db_name . "`";
            }
            $rate = 1;
            $hotel_currency = 1;
            $query = $this->db->query ( "SELECT value FROM " . $db_name . ".gatewayoforder
				 WHERE name LIKE 'currencyID'" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $hotel_currency = $row->value;
            }
            $query = $this->db->query ( "SELECT Rate FROM visitka.currencyrate
				 WHERE Basecurrency = " . $currency . " AND Hotelcurrency = " . $hotel_currency );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $rate = $row->Rate;
            }
            // echo $rate;

            // require_once('JSON.php');
            // $json = new Services_JSON();
            $sql = "SELECT value FROM " . $db_name . ".gatewayoforder WHERE name LIKE 'rateID'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $price_type = $row->value;
            }
            list ( $year, $month, $day ) = explode ( "-", $datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            $temp_1 = array ();
            $sql = "SELECT count(rooms.id) count, rooms.category_id, categories.base_price, categories.name as c_name, categories.shortname, categories.comment,
		 categories.places FROM " . $db_name . ".rooms
		INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
		WHERE " . $db_name . ".categories.web_booking = 1
		GROUP by " . $db_name . ".rooms.category_id";
            // echo "<pre>" . $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_1 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_1 [$row ["category_id"]] ["name"] = $row ["c_name"];
                    $temp_1 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                    $temp_1 [$row ["category_id"]] ["base_price"] = $row ["base_price"];
                    $temp_1 [$row ["category_id"]] ["places"] = $row ["places"];
                    $temp_1 [$row ["category_id"]] ["comment"] = $row ["comment"];
                }
            }
            $temp_2 = array ();
            $sql = "SELECT count(distinct rooms.id) as count, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname
			FROM " . $db_name . ".deskofdays
			INNER JOIN " . $db_name . ".deskofreservation ON " . $db_name . ".deskofreservation.id = " . $db_name . ".deskofdays.reservation_id
			INNER JOIN " . $db_name . ".rooms ON " . $db_name . ".rooms.id = " . $db_name . ".deskofreservation.room_id
			INNER JOIN " . $db_name . ".categories ON " . $db_name . ".categories.id = " . $db_name . ".rooms.category_id
			WHERE " . $db_name . ".categories.web_booking = 1 AND " . $db_name . ".deskofdays.intdate >= $intdatein AND " . $db_name . ".deskofdays.intdate <= $intdateout GROUP BY " . $db_name . ".rooms.category_id";
            // echo $sql . "\n";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $temp_2 [$row ["category_id"]] ["count"] = $row ["count"];
                    $temp_2 [$row ["category_id"]] ["shortname"] = $row ["shortname"];
                }
            }

            $temp_3 = array ();
            $temp_3 ["categories"] = array ();
            $temp_keys = array_keys ( $temp_1 );
            foreach ( $temp_keys as $key ) {
                $post_data = array ();
                $post_data ["type_id"] = $key;
                $post_data ["datein"] = $datein;
                $post_data ["dateout"] = $dateout;
                $post_data ["add_places"] = $add_places;
                $post_data ["baby_places"] = $baby_places;
                $post_data ["price_type"] = $price_type;

                $sss = $this->getpricecalculation ( $post_data, 0, 1, $db_name );
                $total = 0;
                for($i = 0; $i < count ( $sss ); $i ++) {
                    $total += $sss [$i] ["amount"];
                }

                if ($total == 0) {
                    $total += $temp_1 [$key] ["base_price"] * ($intdateout - $intdatein);
                }
                if (isset ( $temp_2 [$key] ["count"] )) {
                    $count_rooms = $temp_1 [$key] ["count"] - $temp_2 [$key] ["count"];
                } else {
                    $count_rooms = $temp_1 [$key] ["count"];
                }
                if ($count_rooms != 0) {
                    $temp_3 ["categories"] [$key] ["count"] = $count_rooms;
                    $temp_3 ["categories"] [$key] ["name"] = $temp_1 [$key] ["name"];
                    $temp_3 ["categories"] [$key] ["shortname"] = $temp_1 [$key] ["shortname"];
                    $temp_3 ["categories"] [$key] ["places"] = $temp_1 [$key] ["places"];
                    $temp_3 ["categories"] [$key] ["amount"] = $total * $rate;
                    $temp_3 ["categories"] [$key] ["comment"] = $temp_1 [$key] ["comment"];
                }
            }
            $temp_time_2 = microtime ( true );

            $temp_3 ["time"] = $temp_time_2 - $temp_time_1;
            $all_array [$host_i] ["categories"] = $temp_3 ["categories"];
            $all_array [$host_i] ["host"] = $hosts [$host_i];
        }
        // echo "<pre>";
        // print_r($temp_3);
        // $output = $json->encode($temp_3);
        $output = json_encode ( $all_array );
        // echo $output;
        print_r ( $output );
    }
    function getpricecalculation($data, $reservetion_id, $func_allcategories = 0, $dbname = "") {
        $result = array ();
        // if($reservetion_id <> 0){
        // $data = $this->frontdesk->GetReservation ( $reservetion_id );
        // }
        $tarif = array ();
        // echo "dateIN - ".$datein." dateOUT - ". $dateout;
        list ( $year_in, $month_in, $day_in ) = explode ( "-", $data ["datein"] );
        // transform datain in unix
        $date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
        // echo $date_in_unix."===";
        // parse dataout

        // $dateout = "2010-11-25";
        list ( $year_out, $month_out, $day_out ) = explode ( "-", $data ["dateout"] );
        // transform dataout in unix
        $date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) );
        // echo $date_out_unix."====";
        // $sss .= "date_in_unix - $date_in_unix ; date_out_unix -
        // $date_out_unix ;";

        $duration = $date_out_unix - $date_in_unix;
        // $date_out_unix = round(date("U", mktime(0, 0, 0, $month_out,
        // $day_out-1, $year_out))/(3600*24));
        if ($func_allcategories == 0) {
            $sql = "SELECT * FROM seasons";
        } else {
            $sql = "SELECT * FROM $dbname.seasons";
        }
        $query = $this->db->query ( $sql );
        $season_data = array ();
        foreach ( $query->result () as $row ) {
            // print_r( $row) . "\n";
            $season_data [$row->id] ["from"] = $row->startdate;
            $season_data [$row->id] ["to"] = $row->enddate;
        }
        // print_r($season_data);
        $keys = array_keys ( $season_data );
        foreach ( $keys as $key ) {
            $from = $season_data [$key] ["from"];

            list ( $from_year_season, $from_month_season, $from_day_season ) = explode ( "-", $from );
            $from_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $from_month_season, $from_day_season, $from_year_season ) ) / (3600 * 24) );
            // echo $key." - ".$from_date_season_unix."====";
            $to = $season_data [$key] ["to"];

            list ( $to_year_season, $to_month_season, $to_day_season ) = explode ( "-", $to );
            $to_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $to_month_season, $to_day_season, $to_year_season ) ) / (3600 * 24) );
            // echo $key." - ".$to_date_season_unix."====";
            if (($date_in_unix <= $to_date_season_unix) and ($date_in_unix >= $from_date_season_unix)) {
                $tarif [$key] = ($to_date_season_unix - $date_in_unix) + 1;

                $sss = "$to_date_season_unix - $date_in_unix ";
                // echo $sss."+++".$tarif[$key];
                // echo $duration;
                if ($date_out_unix <= $to_date_season_unix) {
                    $tarif [$key] = $duration;
                    // $sss .= "from_date_season_unix - $from_date_season_unix ;
                    // to_date_season_unix - $to_date_season_unix";
                    break;
                }
            }
            if (($date_out_unix >= $from_date_season_unix) and ($date_out_unix <= $to_date_season_unix)) {
                $tarif [$key] = $date_out_unix - $from_date_season_unix;
                // echo "+++".$date_out_unix."-".$from_date_season_unix;
                // $sss = $tarif[$key];
                if ($tarif [$key] == "") {
                    // echo "++++";
                    // $tarif[$key] = 1;
                }
                // $sss = $tarif[$key]."sss";
                // $sss .= "from_date_season_unix - $from_date_season_unix ;
                // to_date_season_unix - $to_date_season_unix";
            }
        }

        // print_r($tarif);

        $tarif = $this->getcosttable ( $data ['datein'], $data ['dateout'], $season_data );
        // print_r($tarif);
        $seasons_toprice = array_keys ( $tarif );
        $total = 0;
        $seasons_days_count = 0;
        if ($data ["price_type"] == 0 or $data ["price_type"] == '') {
            $price_name_id = 1;
        } else {
            // $sql = "SELECT table_name FROM rate WHERE id = " . $data
            // ["price_type"];
            // $query = $this->db->query ( $sql );
            // $row = $query->row ();
            $price_name_id = $data ["price_type"];
        }
        $k = 0;
        $typeid = $data ['type_id'];
        foreach ( $seasons_toprice as $key ) {
            if ($key == 0) {
                if ($func_allcategories == 0) {
                    $query = $this->db->query ( "SELECT * FROM categories WHERE id = $typeid" );
                } else {
                    $query = $this->db->query ( "SELECT * FROM $dbname.categories WHERE id = $typeid" );
                }
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    // $seasons_days_count += $tarif [$key];
                    $total += $tarif [$key] * $row->base_price;
                    $temp = $tarif [$key] * $row->base_price;
                    $result [$k] ["category_id"] = $typeid;
                    $result [$k] ["price_type"] = $data ["price_type"];
                    $result [$k] ["season_id"] = $key;
                    $result [$k] ["type_place"] = 1;
                    $result [$k] ["price"] = $row->base_price;
                    $result [$k] ["count"] = $tarif [$key];
                    $result [$k] ["amount"] = $temp;
                    $k ++;
                }
            } else {
                if ($func_allcategories == 0) {
                    $query = $this->db->query ( "SELECT seasonspricelist.category_id, seasonspricelist.price,
                        seasonspricelist.perperson_price, seasonspricelist.extrabed_price
                        FROM seasonspricelist
                        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
                        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
                        WHERE rate.id = $price_name_id AND seasons.id LIKE '$key' AND seasonspricelist.category_id = $typeid" );
                } else {
                    $query = $this->db->query ( "SELECT seasonspricelist.category_id, seasonspricelist.price,
                        seasonspricelist.perperson_price, seasonspricelist.extrabed_price
                        FROM $dbname.seasonspricelist
                        INNER JOIN $dbname.seasons ON $dbname.seasons.id = $dbname.seasonspricelist.season_id
                        INNER JOIN $dbname.rate ON $dbname.rate.id = $dbname.seasonspricelist.rate_id
                        WHERE $dbname.rate.id = $price_name_id AND $dbname.seasons.id LIKE '$key' AND $dbname.seasonspricelist.category_id = $typeid" );
                }
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $seasons_days_count += $tarif [$key];
                    $total += $tarif [$key] * $row->price;
                    $temp = $tarif [$key] * $row->price;
                    $result [$k] ["category_id"] = $row->category_id;
                    $result [$k] ["price_type"] = $data ["price_type"];
                    $result [$k] ["season_id"] = $key;
                    $result [$k] ["type_place"] = 1;
                    $result [$k] ["price"] = $row->price;
                    $result [$k] ["count"] = $tarif [$key];
                    $result [$k] ["amount"] = $temp;
                    $k ++;
                }
            }
        }

        if (count ( $seasons_toprice ) > 1) {
            if ($seasons_days_count < $duration) {
                $base_count = $duration - $seasons_days_count;
                if ($func_allcategories == 0) {
                    $sql = "SELECT * FROM categories WHERE id = $typeid";
                } else {
                    $sql = "SELECT * FROM $dbname.categories WHERE id = $typeid";
                }
                // echo $sql;
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $base_price = $row->base_price;
                }
                $total += $base_count * $base_price;
                // echo "+++$duration-$seasons_days_count+++";
            }
        }
        if ($total == 0) {
            if ($func_allcategories == 0) {
                $query = $this->db->query ( "SELECT base_price FROM categories WHERE id = $typeid" );
            } else {
                $query = $this->db->query ( "SELECT base_price FROM $dbname.categories WHERE id = $typeid" );
            }
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $total += $duration * $row->base_price;
            }
        }
        // $sql = "SELECT * FROM categories WHERE id = ".$typeid;
        // echo $sql;
        if (count ( $seasons_toprice ) != 0) {
            foreach ( $seasons_toprice as $key ) {
                if ($key == 0) {
                    if ($func_allcategories == 0) {
                        $query = $this->db->query ( "SELECT * FROM categories WHERE id = $typeid" );
                    } else {
                        $query = $this->db->query ( "SELECT * FROM $dbname.categories WHERE id = $typeid" );
                    }
                    if ($query->num_rows () > 0) {
                        $row = $query->row ();
                        // $seasons_days_count += $tarif[$key];
                        // $total += $tarif[$key]*$row->price;
                        if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {
                            $total += $tarif [$key] * $row->add_price * $data ['add_places'];
                            $temp = $tarif [$key] * $row->add_price * $data ['add_places'];
                            for($i = 1; $i <= 1; $i ++) {
                                $result [$k] ["season_id"] = $key;
                                $result [$k] ["category_id"] = $row->id;
                                $result [$k] ["price_type"] = $data ["price_type"];
                                $result [$k] ["type_place"] = 2;
                                $result [$k] ["price"] = $row->add_price * $data ['add_places'];
                                $result [$k] ["count"] = $tarif [$key];
                                $result [$k] ["amount"] = $temp;
                                $k ++;
                            }
                        }
                        if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) {
                            $total += $tarif [$key] * $row->baby_price * $data ['baby_places'];
                            $temp = $tarif [$key] * $row->baby_price * $data ['baby_places'];
                            for($i = 1; $i <= 1; $i ++) {
                                $result [$k] ["season_id"] = $key;
                                $result [$k] ["category_id"] = $row->id;
                                $result [$k] ["price_type"] = $data ["price_type"];
                                $result [$k] ["type_place"] = 3;
                                $result [$k] ["price"] = $row->baby_price * $data ['baby_places'];
                                $result [$k] ["count"] = $tarif [$key];
                                $result [$k] ["amount"] = $temp;
                                $k ++;
                            }
                        }
                    }
                } else {
                    if ($func_allcategories == 0) {
                        $sql = "SELECT seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price,
                        seasonspricelist.extrabed_price
                        FROM seasonspricelist
                        INNER JOIN seasons ON seasons.id = seasonspricelist.season_id
                        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
                        WHERE rate.id = $price_name_id AND seasons.id = $key AND seasonspricelist.category_id = $typeid";
                    } else {
                        $sql = "SELECT seasonspricelist.category_id, seasonspricelist.price, seasonspricelist.perperson_price,
                        seasonspricelist.extrabed_price
                        FROM $dbname.seasonspricelist
                        INNER JOIN $dbname.seasons ON $dbname.seasons.id = $dbname.seasonspricelist.season_id
                        INNER JOIN $dbname.rate ON $dbname.rate.id = $dbname.seasonspricelist.rate_id
                        WHERE $dbname.rate.id = $price_name_id AND $dbname.seasons.id = $key AND $dbname.seasonspricelist.category_id = $typeid";
                    }
                    $query = $this->db->query ( $sql );
                    if ($query->num_rows () > 0) {
                        $row = $query->row ();
                        // $seasons_days_count += $tarif[$key];
                        // $total += $tarif[$key]*$row->price;
                        if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {
                            $total += $tarif [$key] * $row->perperson_price * $data ['add_places'];
                            $temp = $tarif [$key] * $row->perperson_price * $data ['add_places'];
                            for($i = 1; $i <= 1; $i ++) {
                                $result [$k] ["season_id"] = $key;
                                $result [$k] ["category_id"] = $row->category_id;
                                $result [$k] ["price_type"] = $data ["price_type"];
                                $result [$k] ["type_place"] = 2;
                                $result [$k] ["price"] = $row->perperson_price * $data ['add_places'];
                                $result [$k] ["count"] = $tarif [$key];
                                $result [$k] ["amount"] = $temp;
                                $k ++;
                            }
                        }
                        if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) {
                            $total += $tarif [$key] * $row->extrabed_price * $data ['baby_places'];
                            $temp = $tarif [$key] * $row->extrabed_price * $data ['baby_places'];
                            for($i = 1; $i <= 1; $i ++) {
                                $result [$k] ["season_id"] = $key;
                                $result [$k] ["category_id"] = $row->category_id;
                                $result [$k] ["price_type"] = $data ["price_type"];
                                $result [$k] ["type_place"] = 3;
                                $result [$k] ["price"] = $row->extrabed_price * $data ['baby_places'];
                                $result [$k] ["count"] = $tarif [$key];
                                $result [$k] ["amount"] = $temp;
                                $k ++;
                            }
                        }
                    }
                }
            }
        }

        // print_r($result);
        return $result;
    }
    function getpricecalculation2($data, $reservetion_id, $func_allcategories = 0, $dbname = "", $array_prices_seasons, $season_data) {
        $result = array ();
        $tarif = array ();
        list ( $year_in, $month_in, $day_in ) = explode ( "-", $data ["datein"] );
        // transform datain in unix
        $date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
        // parse dataout
        list ( $year_out, $month_out, $day_out ) = explode ( "-", $data ["dateout"] );
        // transform dataout in unix
        $date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) );
        $duration = $date_out_unix - $date_in_unix;
        $keys = array_keys ( $season_data );
        foreach ( $keys as $key ) {
            $from = $season_data [$key] ["from"];

            list ( $from_year_season, $from_month_season, $from_day_season ) = explode ( "-", $from );
            $from_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $from_month_season, $from_day_season, $from_year_season ) ) / (3600 * 24) );
            $to = $season_data [$key] ["to"];

            list ( $to_year_season, $to_month_season, $to_day_season ) = explode ( "-", $to );
            $to_date_season_unix = round ( date ( "U", mktime ( 0, 0, 0, $to_month_season, $to_day_season, $to_year_season ) ) / (3600 * 24) );
            if (($date_in_unix <= $to_date_season_unix) and ($date_in_unix >= $from_date_season_unix)) {
                $tarif [$key] = ($to_date_season_unix - $date_in_unix) + 1;
                $sss = "$to_date_season_unix - $date_in_unix ";
                if ($date_out_unix <= $to_date_season_unix) {
                    $tarif [$key] = $duration;
                    break;
                }
            }
            if (($date_out_unix >= $from_date_season_unix) and ($date_out_unix <= $to_date_season_unix)) {
                $tarif [$key] = $date_out_unix - $from_date_season_unix;
                if ($tarif [$key] == "") {
                }
            }
        }

        // print_r($tarif);

        $tarif = $this->getcosttable ( $data ['datein'], $data ['dateout'], $season_data );
        $seasons_toprice = array_keys ( $tarif );
        $total = 0;
        $add_places_total = 0;
        $seasons_days_count = 0;
        if ($data ["price_type"] == 0 or $data ["price_type"] == '') {
            $price_name_id = 1;
        } else {
            $price_name_id = $data ["price_type"];
        }

        $k = 0;
        $typeid = $data ['type_id'];
        foreach ( $seasons_toprice as $key ) {
            if ($key == 0) {

                // $seasons_days_count += $tarif [$key];
                $total += $tarif [$key] * $data ["base_price"];
                $temp = $tarif [$key] * $data ["base_price"];

                $add_places_total += $tarif [$key] * $data ["add_price"];
                $add_places_temp = $tarif [$key] * $data ["add_price"];

                $result [$k] ["category_id"] = $typeid;
                $result [$k] ["price_type"] = $data ["price_type"];
                $result [$k] ["season_id"] = $key;
                $result [$k] ["type_place"] = 1;
                $result [$k] ["price"] = $data ["base_price"];
                $result [$k] ["count"] = $tarif [$key];
                $result [$k] ["amount"] = $temp;
                $result [$k] ["add_places_amount"] = $add_places_temp;
                // $result [$k] ["amount_1"] =
                // $array_prices_seasons[$typeid][$key]["add_olace"]
                // $result [$k]['cost'] = $tarif;
                $k ++;
            } else {
                if (isset ( $tarif [$key] ) && isset ( $array_prices_seasons [$typeid] [$key] )) {
                    $seasons_days_count += $tarif [$key];
                    $total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["price"];
                    $temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["price"];

                    $add_places_total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"];
                    $add_places_temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"];
                    $result [$k] ["category_id"] = $typeid;
                    $result [$k] ["price_type"] = $data ["price_type"];
                    $result [$k] ["season_id"] = $key;
                    $result [$k] ["type_place"] = 1;
                    $result [$k] ["price"] = $array_prices_seasons [$typeid] [$key] ["price"];
                    $result [$k] ["count"] = $tarif [$key];
                    $result [$k] ["amount"] = $temp;
                    $result [$k] ["add_places_amount"] = $add_places_temp;
                    // $result [$k]['cost2'] = $tarif;
                    $k ++;
                }
            }
        }

        if (count ( $seasons_toprice ) > 1) {
            if ($seasons_days_count < $duration) {
                $base_count = $duration - $seasons_days_count;
                $base_price = $data ["base_price"];
                $total += $base_count * $base_price;
                // echo "+++$duration-$seasons_days_count+++";
            }
        }
        if ($total == 0) {
            $total += $duration * $data ["base_price"];
        }
        if (count ( $seasons_toprice ) != 0) {
            foreach ( $seasons_toprice as $key ) {
                if ($key == 0) {
                    if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {
                        $total += $tarif [$key] * $data ["add_price"] * $data ['add_places'];
                        $temp = $tarif [$key] * $data ["add_price"] * $data ['add_places'];
                        for($i = 1; $i <= 1; $i ++) {
                            $result [$k] ["season_id"] = $key;
                            $result [$k] ["category_id"] = $typeid;
                            $result [$k] ["price_type"] = $data ["price_type"];
                            $result [$k] ["type_place"] = 2;
                            $result [$k] ["price"] = $data ["add_price"] * $data ['add_places'];
                            $result [$k] ["count"] = $tarif [$key];
                            $result [$k] ["amount"] = $temp;
                            // $result [$k]['cost3'] = $tarif;
                            $k ++;
                        }
                    }
                    if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) {
                        $total += $tarif [$key] * $data ["baby_price"] * $data ['baby_places'];
                        $temp = $tarif [$key] * $data ["baby_price"] * $data ['baby_places'];
                        for($i = 1; $i <= 1; $i ++) {
                            $result [$k] ["season_id"] = $key;
                            $result [$k] ["category_id"] = $typeid;
                            $result [$k] ["price_type"] = $data ["price_type"];
                            $result [$k] ["type_place"] = 3;
                            $result [$k] ["price"] = $data ["baby_price"] * $data ['baby_places'];
                            $result [$k] ["count"] = $tarif [$key];
                            $result [$k] ["amount"] = $temp;
                            // $result [$k]['cost4'] = $tarif;
                            $k ++;
                        }
                    }
                } else {
                    if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {
                        $total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"] * $data ['add_places'];
                        $temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"] * $data ['add_places'];
                        for($i = 1; $i <= 1; $i ++) {
                            $result [$k] ["season_id"] = $key;
                            $result [$k] ["category_id"] = $typeid;
                            $result [$k] ["price_type"] = $data ["price_type"];
                            $result [$k] ["type_place"] = 2;
                            $result [$k] ["price"] = $array_prices_seasons [$typeid] [$key] ["perperson_price"] * $data ['add_places'];
                            $result [$k] ["count"] = $tarif [$key];
                            $result [$k] ["amount"] = $temp;
                            // $result [$k]['cost5'] = $tarif;
                            $k ++;
                        }
                    }
                    if (($data ['baby_places'] != 0) and ($data ['baby_places'] != "")) {
                        $total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["extrabed_price"] * $data ['baby_places'];
                        $temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["extrabed_price"] * $data ['baby_places'];
                        for($i = 1; $i <= 1; $i ++) {
                            $result [$k] ["season_id"] = $key;
                            $result [$k] ["category_id"] = $typeid;
                            $result [$k] ["price_type"] = $data ["price_type"];
                            $result [$k] ["type_place"] = 3;
                            $result [$k] ["price"] = $array_prices_seasons [$typeid] [$key] ["extrabed_price"] * $data ['baby_places'];
                            $result [$k] ["count"] = $tarif [$key];
                            $result [$k] ["amount"] = $temp;
                            // $result [$k]['cost6'] = $tarif;
                            $k ++;
                        }
                    }
                }
            }
        }
        return $result;
    }
    function getpricecalculation31($data, $reservetion_id = 0, $ajax_data = 0, $deskof_restrictedprice = 0, $rate_strategy = 0) {
        // echo "<pre>";
        // print_r($data);
        if ($reservetion_id != 0 and $ajax_data == 0) {
            $data = $this->GetReservation ( $reservetion_id );
        }

        if($rate_strategy == 0){
            $rate_strategy = $this->frontdesk->GetRateStrategy ();
        }
        $tarif = array ();
        list ( $year_in, $month_in, $day_in ) = explode ( "-", $data ["datein"] );
        $date_in_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_in, $day_in, $year_in ) ) / (3600 * 24) );
        list ( $year_out, $month_out, $day_out ) = explode ( "-", $data ["dateout"] );
        $date_out_unix = round ( date ( "U", mktime ( 0, 0, 0, $month_out, $day_out, $year_out ) ) / (3600 * 24) );
        $duration = $date_out_unix - $date_in_unix;

        if ($data ["price_type"] == 0 or $data ["price_type"] == '') {
            $price_name_id = 1;
            // return 0;
        } else {
            $price_name_id = $data ["price_type"];
        }
        $k = 0;
        $typeid = $data ['type_id'];

        /*$deskof_restrictedprice = array ();

        $sql = "SELECT *
        FROM yieldprice WHERE  intdate >= $date_in_unix AND intdate <= $date_out_unix-1 ";
        // echo $sql;
        // die();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
        foreach ( $query->result () as $row ) {
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["perperson_price"] = $row->perperson_price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["extrabed_price"] = $row->extrabed_price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["additional_bed_price"] = $row->additional_bed_price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["baby_2price"] = $row->baby_2price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["price"] = $row->price;
        $deskof_restrictedprice [$row->category_id] [$row->id_restrict_rate] [$row->intdate] ["singleuseprice"] = $row->singleuseprice;
        }
        }
        */
        if($deskof_restrictedprice == 0){
            $deskof_restrictedprice = $this->frontdesk->get_yieldprice ( $date_in_unix, $date_out_unix );
        }

        $new_arr = array ();
        $sql = "SELECT seasonspricelist.*, deskofdaysseason.intdate FROM deskofdaysseason
        INNER JOIN seasonspricelist ON seasonspricelist.season_id = deskofdaysseason.seasonid
        INNER JOIN rate ON rate.id = seasonspricelist.rate_id
        WHERE deskofdaysseason.intdate >= $date_in_unix AND deskofdaysseason.intdate <= $date_out_unix-1 AND
        rate.id = $price_name_id AND seasonspricelist.category_id = $typeid";
        // echo $sql;
        // die ();
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $new_arr [$row->intdate] ["rate_id"] = $row->rate_id;
                $new_arr [$row->intdate] ["category_id"] = $row->category_id;
                $new_arr [$row->intdate] ["season_id"] = $row->season_id;
                $new_arr [$row->intdate] ["perperson_price"] = $row->perperson_price;
                $new_arr [$row->intdate] ["extrabed_price"] = $row->extrabed_price;
                $new_arr [$row->intdate] ["price"] = $row->price;
                $new_arr [$row->intdate] ["price1"] = $row->price1;
                $new_arr [$row->intdate] ["price2"] = $row->price2;
                $new_arr [$row->intdate] ["price3"] = $row->price3;
                $new_arr [$row->intdate] ["price4"] = $row->price4;
                $new_arr [$row->intdate] ["price5"] = $row->price5;
                $new_arr [$row->intdate] ["price6"] = $row->price6;
                $new_arr [$row->intdate] ["price7"] = $row->price7;

                $new_arr [$row->intdate] ["perperson_price1"] = $row->perperson_price1;
                $new_arr [$row->intdate] ["perperson_price2"] = $row->perperson_price2;
                $new_arr [$row->intdate] ["perperson_price3"] = $row->perperson_price3;
                $new_arr [$row->intdate] ["perperson_price4"] = $row->perperson_price4;
                $new_arr [$row->intdate] ["perperson_price5"] = $row->perperson_price5;
                $new_arr [$row->intdate] ["perperson_price6"] = $row->perperson_price6;
                $new_arr [$row->intdate] ["perperson_price7"] = $row->perperson_price7;

                $new_arr [$row->intdate] ["extrabed_price1"] = $row->extrabed_price1;
                $new_arr [$row->intdate] ["extrabed_price2"] = $row->extrabed_price2;
                $new_arr [$row->intdate] ["extrabed_price3"] = $row->extrabed_price3;
                $new_arr [$row->intdate] ["extrabed_price4"] = $row->extrabed_price4;
                $new_arr [$row->intdate] ["extrabed_price5"] = $row->extrabed_price5;
                $new_arr [$row->intdate] ["extrabed_price6"] = $row->extrabed_price6;
                $new_arr [$row->intdate] ["extrabed_price7"] = $row->extrabed_price7;

                $new_arr [$row->intdate] ["singleuse_price1"] = $row->singleuse_price1;
                $new_arr [$row->intdate] ["singleuse_price2"] = $row->singleuse_price2;
                $new_arr [$row->intdate] ["singleuse_price3"] = $row->singleuse_price3;
                $new_arr [$row->intdate] ["singleuse_price4"] = $row->singleuse_price4;
                $new_arr [$row->intdate] ["singleuse_price5"] = $row->singleuse_price5;
                $new_arr [$row->intdate] ["singleuse_price6"] = $row->singleuse_price6;
                $new_arr [$row->intdate] ["singleuse_price7"] = $row->singleuse_price7;
            }
        }
        $result = array ();
        $new_result = array ();
        // echo "<pre>";
        // /print_r($new_arr);
        $add_places_amount = 0;
        for($i = $date_in_unix; $i <= ($date_out_unix - 1); $i ++) {
            // $temp_keys = array_keys ( $new_arr );
            // foreach ( $temp_keys as $intdate_season ) {
            if (isset ( $new_arr [$i] )) {
                $week_day = date ( "w", $i * 86400 );
                $price = 0;

                if (isset ( $deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["price"] )) {

                    if ($deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["price"] != 0) {

                        // $price = $deskof_restrictedprice [$row->id]
                        // [$row->rate_id] [$row->intdate] ["price"];
                        $add_places_amount = 0;
                        // if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {

                        if ($deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["perperson_price"] == 0) {
                            switch ($rate_strategy) {
                                case 1 :
                                    // $add_places_amount = $new_arr [$i] ["perperson_price"] * $data ['add_places'];
                                    $add_places_amount = $new_arr [$i] ["perperson_price"];
                                    break;
                                case 2 :
                                    if ($week_day != 0) {
                                        // $add_places_amount = $new_arr [$i] ["perperson_price$week_day"] * $data ['add_places'];
                                        $add_places_amount = $new_arr [$i] ["perperson_price$week_day"];
                                    } else {
                                        // $add_places_amount = $new_arr [$i] ["perperson_price7"] * $data ['add_places'];
                                        $add_places_amount = $new_arr [$i] ["perperson_price7"];
                                    }
                                    break;
                            }
                        } else {
                            // $add_places_amount = $deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["perperson_price"] * $data ['add_places'];
                            $add_places_amount = $deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["perperson_price"];
                        }
                        // }

                        $price = $deskof_restrictedprice [$typeid] [$price_name_id] [$i] ["price"];
                    }
                } else {
                    switch ($rate_strategy) {
                        case 1 :
                            $add_places_price = 0;
                            if (($data ['add_places'] != 0) and ($data ['add_places'] != "")) {
                                $add_places_price = $new_arr [$i] ["perperson_price"];
                            }
                            $baby_places_price = 0;

                            $price = $new_arr [$i] ["price"];
                            $add_places_amount = $new_arr [$i] ["perperson_price"];
                            break;
                        case 2 :
                            switch ($week_day) {
                                case 1 :

                                    $price = $new_arr [$i] ["price1"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price1"];
                                    break;
                                case 2 :
                                    $price = $new_arr [$i] ["price2"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price2"];
                                    break;
                                case 3 :
                                    $price = $new_arr [$i] ["price3"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price3"];
                                    break;
                                case 4 :
                                    $price = $new_arr [$i] ["price4"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price4"];
                                    break;
                                case 5 :
                                    $price = $new_arr [$i] ["price5"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price5"];
                                    break;
                                case 6 :
                                    $price = $new_arr [$i] ["price6"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price6"];
                                    break;
                                case 0 :
                                    $price = $new_arr [$i] ["price7"];
                                    $add_places_amount = $new_arr [$i] ["perperson_price7"];
                                    break;
                            }
                            break;
                    }

                    /*
                     * SET RESTRICTED PRICE $post_data ["rate_restricted"][$price_type] = $rate_restrictID; $post_data ["rate_restricted"][$additional_price_type] = $additionalrate_restrictID;
                     */

                    /*if (isset ( $data ["rate_restricted"] [$price_name_id] )) {
                     $restrictID_rate = $data ["rate_restricted"] [$price_name_id];
                     if (isset ( $restricted_prices_array [$typeid] [$restrictID_rate] [$i] ["price"] )) {
                     $price = $restricted_prices_array [$typeid] [$restrictID_rate] [$i] ["price"];
                     }
                     }*/
                }
                $result [$k] ["amount"] = $price;
                $result [$k] ["add_places_amount"] = $add_places_amount;
                $k ++;
            } else {

                $price = 0;
                $query = $this->db->query ( "SELECT * FROM categories WHERE id = " . $typeid );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $base_price = $row->base_price;
                    $add_price = $row->add_price;
                    $baby_price = $row->baby_price;
                }
                $price = $base_price;
                $result [$k] ["amount"] = $price;
                $result [$k] ["add_places_amount"] = $add_price;
                $k ++;
            }
        }
        // echo "<pre>";
        // print_r ( $result );
        // die ();
        return $result;
    }
    function getpricecalculation3($data, $reservetion_id, $func_allcategories = 0, $dbname = "", $array_prices_seasons, $season_data, &$tarif) {
        $result = array ();
        $time_1 = microtime ( true );
        $seasons_toprice = array_keys ( $tarif );
        $total = 0;
        $add_places_total = 0;
        $seasons_days_count = 0;
        $k = 0;
        // echo "<pre>";
        // print_r($array_prices_seasons);

        // print_r($season_data);
        // print_r($tarif);
        // echo "+++";
        $typeid = $data ['type_id'];
        foreach ( $seasons_toprice as $key ) {
            if ($key == 0) {
                // $seasons_days_count += $tarif [$key];
                $total += $tarif [$key] * $data ["base_price"];
                $temp = $tarif [$key] * $data ["base_price"];
                $add_places_total += $tarif [$key] * $data ["add_price"];
                $add_places_temp = $tarif [$key] * $data ["add_price"];
                $result [$k] ["amount"] = $temp;
                $result [$k] ["add_places_amount"] = $add_places_temp;
                // $result [$k] ['cost'] = $tarif;
                $k ++;
            } else {
                $seasons_days_count += $tarif [$key];
                $total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["price"];
                $temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["price"];

                $add_places_total += $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"];
                $add_places_temp = $tarif [$key] * $array_prices_seasons [$typeid] [$key] ["perperson_price"];
                $result [$k] ["amount"] = $temp;
                $result [$k] ["add_places_amount"] = $add_places_temp;
                // $result [$k] ['cost2'] = $tarif;
                $k ++;
            }
        }
        $k --;
        $time_2 = microtime ( true );
        $result [$k] ['time'] = $time_2 - $time_1;
        return $result;
    }
    function getcosttable($from, $to, $a) {
        // $to = date('Y-m-d',(intval(strtotime($to)/3600/24) - 0)*3600*24);
        $newdate = strtotime ( '-1 day', strtotime ( $to ) );
        $newdate = date ( 'Y-m-j', $newdate );
        $to = $newdate;

        $r = array ();
        $from = intval ( strtotime ( $from ) / 3600 / 24 );
        $to = intval ( strtotime ( $to ) / 3600 / 24 );
        $in_range = range ( $from, $to );

        foreach ( $a as $k => $v ) {
            $v_from = intval ( strtotime ( $v ['from'] ) / 3600 / 24 );
            $v_to = intval ( strtotime ( $v ['to'] ) / 3600 / 24 );
            $test_range = range ( $v_from, $v_to );
            $x = count ( array_intersect ( $in_range, $test_range ) );
            $x > 0 ? $r [$k] = $x : 0;
        }
        $diff = $to - $from + 1 - array_sum ( $r );
        $diff > 0 ? $r [0] = $diff : 0;
        return $r;
    }
    function SaveReservations($daily_prepayment = 0) {
        // echo "++";
        require_once ('JSON.php');
        $json = new Services_JSON ();
        // die();
        $data = $_POST ["order_data"];
        $data = $json->decode ( $data );
        $data = objectToArray ( $data );

        // print_r($data);
        // die();
        $count_rooms = count ( $data ["order"] ["rooms"] );
        $count_services = 0;
        if (isset ( $data ["order"] ["services"] ))
            $count_services = count ( $data ["order"] ["services"] );
            $result = array ();
            if ($count_rooms > 0) {

                // $this->db->trans_begin ();
                $this->db->trans_start ();
                $price_type = 0;
                $sql = "SELECT value FROM gatewayoforder WHERE name LIKE 'rateID'";
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $price_type = $row->value;
                }
                $countries = $this->config->item ( "countries" );
                $reservation = array ();
                $reservation ["guest"] = $data ["order"] ["guest"];
                $reservation ["description"] = $data ["order"] ["description"];
                $data_new = array ();
                $reservation ["price_type"] = $price_type;
                $data_new ['phone'] = $reservation ["guest"] ["phone"];
                $data_new ['address'] = $reservation ["guest"] ["address"];
                $data_new ['email'] = $reservation ["guest"] ["email_1"];
                $data_new ['city'] = $reservation ["guest"] ["city"];
                $data_new ['country'] = $countries [$reservation ["guest"] ["country"]];
                $data_new ['index'] = $reservation ["guest"] ["index"];

                $data_new ['card_number'] = $data ["card"] ["number"];
                $data_new ['card_XID'] = $data ["card"] ["XID"];
                $data_new ['card_Rrn'] = $data ["card"] ["Rrn"];
                $data_new ['card_TotalAmount'] = $data ["card"] ["TotalAmount"];

                // $data_new ['card_type'] = $data["guest"]["card_type"];
                // $data_new ['card_number'] = $data["guest"]["card_number"];
                // $data_new ['card_owner'] = $data["guest"]["card_owner"];
                // $data_new ['cvc_code'] = $data["guest"]["cvc_code"];
                // $data_new ['card_date'] =
                // $data["guest"]["card_date_month"].".".$data["guest"]["card_date_year"];
                $reservation ["upc"] = $data ["upc"];
                $insert_service_bool = 0;
                $bool_daily = 0;
                for($i = 0; $i < $count_rooms; $i ++) {
                    $reservation ["room"] = $data ["order"] ["rooms"] [$i];
                    // print_r($reservation);
                    // die();
                    $data_new ['firstname'] = $reservation ["room"] ["firstname"];
                    $data_new ['lastname'] = $reservation ["room"] ["lastname"];
                    $guest_id = $this->frontdesk->Guest_insert ( $data_new );
                    $id = $this->Insert_reservations ( $reservation, $guest_id );
                    if ($insert_service_bool == 0) {
                        for($s = 0; $s < $count_services; $s ++) {
                            $insert_service_bool = 1;
                            $services_data = array ();
                            $services_data ["res_id"] = $id;
                            $services_data ["dealer"] = 0;
                            $services_data ["type"] = $data ["order"] ["services"] [$s] ["id_service"];
                            $services_data ["description"] = "";
                            $services_data ["amount"] = $data ["order"] ["services"] [$s] ["price"];
                            $this->service_model->Insert_Service ( $services_data, 1 );
                        }
                    }

                    $bool = false;
                    if ($id > 0) {
                        $bool = true;
                        if ($reservation ["upc"] == 1) {

                            if (isset ( $daily_prepayment ) and $daily_prepayment == 1) {
                                if ($bool_daily != 1) {
                                    $query = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $id . " AND type = 1" );
                                    if ($query->num_rows () > 0) {
                                        $row = $query->row ();
                                        $id_main = $row->id;
                                        $amount = $row->amount;
                                        $this->Payment_save ( $data_new, $id, 1 );
                                        $bool_daily = 1;
                                    }
                                }
                            } else {
                                $this->Payment_save ( $data_new, $id );
                            }
                        }
                    } else {
                        // $this->db->trans_rollback ();
                        // $result = array();
                    }
                    $query = $this->db->query ( "SELECT guests.lastname, guests.firstname, deskofreservation.datein,
                        deskofreservation.dateout, deskofreservation.amount, rooms.name as room_name, categories.name as cat_name,
                        categories.id as cat_id FROM deskofreservation
                        INNER JOIN guests ON deskofreservation.guest_id=guests.id
                        LEFT JOIN rooms ON rooms.id=deskofreservation.room_id
                        LEFT JOIN categories ON categories.id=rooms.category_id
                        WHERE deskofreservation.id = $id" );

                    if ($query->num_rows () > 0) {
                        $row = $query->row_array ();
                        // $rate = $this->frontdesk->getrate(1);
                        $amount = $row ['amount'];

                        $query2 = $this->db->query ( "SELECT services.amount, services_types.name FROM services
                            INNER JOIN services_types ON services_types.id = services.type WHERE services.reservation_id = $id" );
                        $services_mass = array ();
                        if ($query2->num_rows () > 0) {
                            $k = 0;
                            foreach ( $query2->result () as $row2 ) {
                                $services_mass [$k] ["name"] = $row2->name;
                                $services_mass [$k] ["price"] = $row2->amount;
                                $k ++;
                            }
                        }
                        array_push ( $result, array (
                            'reservatiom_id' => $id,
                            'status' => $bool,
                            "amount" => $amount,
                            "services_mass" => $services_mass,
                            "datein" => $row ['datein'],
                            "dateout" => $row ['dateout'],
                            "cat_id" => $row ['cat_id'],
                            "cat_name" => $row ['cat_name'],
                            "room_name" => $row ['room_name'],
                            "lastname" => $row ['lastname'],
                            "firstname" => $row ['firstname'],
                            "guest_name" => $row ['firstname'] . " " . $row ['lastname']
                        ) );
                    }
                    // if ($this->db->trans_status () === FALSE) {
                    // $this->db->trans_rollback ();
                    // redirect ( '/reservations/error/' );
                    // } else {
                    // $this->db->trans_commit ();
                    // }
                    // $this->db->trans_rollback();

                    // $url = "http://booking.hottour24.com.ua/foo/step5";
                    // $result = $this->CurlPlug($result, $url);
                }
                $this->db->trans_complete ();
                $output = $json->encode ( $result );
                print_r ( $output );
            }
    }
    function CutInsertReservation($data) {
        $user_id = - 1;

        $query = $this->db->query ( "SELECT status FROM deskofreservation WHERE id = " . $data ["res_id"] );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $status = $row->status;
        } else {
            $status = 0;
        }
        // echo $status;
        // die();
        if ($status == 4) {
            // print_r($_POST);

            $result1 = $this->frontdesk->ReservationForDate ( $data ["datein"], $data ["dateout"], $data ["room_id"] );
            // echo "<pre>";
            // print_r($result1);
            if (count ( $result1 ) > 1) {
                list ( $year, $month, $day ) = explode ( "-", $data ["datein"] );
                $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                list ( $year, $month, $day ) = explode ( "-", $data ["dateout"] );
                $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                $result2 = $this->frontdesk->f ( $result1, $intdatein, $intdateout - 1 );
                // print_r($result2);
                // die();
                $this->frontdesk->MultyCutQuota ( $result2 );
            } else {
                $result_for_freequotapart = $this->frontdesk->CutReservation ( $data ["res_id"], $data ["datein"], $data ["dateout"] );
            }
            // $result = $this->frontdesk->SaveMainForm ( 3 );
            $data ["canceltoquota"] = 1;
            $reservation_id = $this->frontdesk->Reservation_insert ( $data, $data ["guest_id"] );
            if (count ( $result1 ) > 1) {
                foreach ( $result2 as $key => $days_to_cut ) {
                    $query = $this->db->query ( "INSERT INTO loger (user_id,data,type,id_transaction,description, status) VALUES($user_id,'" . date ( "Y-m-d H:i:s" ) . "', 'reservation', " . $key . ", '{[sysjournal],[редактирование],[Создан заказ № " . $reservation_id . "]},', 'edit')" );
                }
            } else {
                $query = $this->db->query ( "INSERT INTO loger (user_id,data,type,id_transaction,description, status) VALUES($user_id,'" . date ( "Y-m-d H:i:s" ) . "', 'reservation', " . $data ["res_id"] . ", '{[sysjournal],[редактирование],[Создан заказ № " . $reservation_id . "]},', 'edit')" );
                // $query = $this->db->query ( "UPDATE deskofreservation SET
                // description = 'Создан заказ № ".$result."' WHERE id =
                // ".$_POST ["res_id"]);
                if ($result_for_freequotapart != 0) {
                    $query = $this->db->query ( "INSERT INTO loger (user_id,data,type,id_transaction,description, status) VALUES($user_id,'" . date ( "Y-m-d H:i:s" ) . "', 'reservation', " . $result_for_freequotapart . ", '{[sysjournal],[редактирование],[Создан заказ № " . $reservation_id . "]},', 'edit')" );
                    // $query = $this->db->query ( "UPDATE deskofreservation SET
                    // description = 'Создан заказ № ".$result."' WHERE id =
                    // ".$result_for_freequotapart);
                }
            }
            return $reservation_id;
            // die();
        }
    }
    function SaveReservations_2($daily_prepayment = 0, $personal_type = 1) {
        // $DB2 = $this->load->database('default', TRUE);
        // echo "<pre>";

        // print_r ( $_SERVER );
        // echo "++";
        require_once ('JSON.php');
        $json = new Services_JSON ();
        // die();
        $data = $_POST ["order_data"];
        $data = $json->decode ( $data );
        $data = objectToArray ( $data );
        //=====================================
        if(trim($data ["order"] ["rooms"] [0] ["datein"]) == "" || trim($data ["order"] ["rooms"] [0] ["dateout"]) == ""){
            die();
        }
        //=====================================
        if ($personal_type == 2) {
            $personal_table = "gatewayoforder_personal";
        } else {
            $personal_table = "gatewayoforder";
        }

        $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";

        // echo $sql;
        $query = $this->db->query ( $sql );
        // echo "<br>+<br><br>";


        // 		echo "<pre>";
        // 		print_r($data);
        //die();
        $count_rooms = count ( $data ["order"] ["rooms"] );
        if (isset ( $data ["order"] ["currencyID"] )) {
            switch ($data ["order"] ["currencyID"]) {
                case 978 :
                    $currencycaption = "EUR";
                    break;
                case 840 :
                    $currencycaption = "USD";
                    break;
                case 643 :
                    $currencycaption = "RUB";
                    break;
                case 980 :
                    $currencycaption = "UAH";
                    break;
                case 974 :
                    $currencycaption = "BYR";
                    break;
                case 933 :
                    $currencycaption = "BYN";
                    break;
                case 498 :
                    $currencycaption = "MDL";
                    break;
                case 985 :
                    $currencycaption = "PLN";
                    break;
                case 944:
                    $currencycaption = "AZN";
                    break;
                case 51 :
                    $currencycaption = "AMD";
                    break;
                case 981 :
                    $currencycaption = "GEL";
                    break;
                case 398 :
                    $currencycaption = "KZT";
                    break;
                case 944 :
                    $currencycaption = "AZN";
                    break;
                default :
                    $currencycaption = "???";
                    break;
            }
        } else {
            $currencycaption = "UAH";
        }

        $count_services = 0;
        if (isset ( $data ["order"] ["services"] ))
            $count_services = count ( $data ["order"] ["services"] );

            if (isset ( $data ["order"] ["globaldiscount"] )) {
                $globaldiscount = $data ["order"] ["globaldiscount"];
            } else {
                $globaldiscount = 0;
            }

            $discount_percent = 0;
            if (isset ( $data ["order"] ["discountpromocode"] )) {
                $discount_code_array = array ();
                $query = $this->db->query ( "SELECT * FROM onlinediscount WHERE 1" );

                if ($query->num_rows () > 0) {
                    foreach ( $query->result () as $row ) {
                        $discount_code_array [$row->code] ["percent"] = $row->percent;

                        list ( $year, $month, $day ) = explode ( "-", $row->datestart );
                        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                        list ( $year, $month, $day ) = explode ( "-", $row->dateend );
                        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );

                        $discount_code_array [$row->code] ["datestart"] = $intdatein;
                        $discount_code_array [$row->code] ["dateend"] = $intdateout;
                    }
                }

                if (isset ( $discount_code_array [$data ["order"] ["discountpromocode"]] )) {
                    if (isset ( $data ["order"] ["rooms"] [0] ["datein"] )) {
                        list ( $year, $month, $day ) = explode ( "-", $data ["order"] ["rooms"] [0] ["datein"] );
                        $intdatein_room = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                        list ( $year, $month, $day ) = explode ( "-", $data ["order"] ["rooms"] [0] ["dateout"] );
                        $intdateout_room = round ( gmmktime ( 0, 0, 0, $month, $day - 1, $year ) / 86400 );

                        $discount_datestart = $discount_code_array [$data ["order"] ["discountpromocode"]] ["datestart"];
                        $discount_dateend = $discount_code_array [$data ["order"] ["discountpromocode"]] ["dateend"];
                        if ($discount_datestart <= $intdatein_room && $discount_dateend >= $intdateout_room) {
                            $discount_percent = $discount_code_array [$data ["order"] ["discountpromocode"]] ["percent"];
                            $globaldiscount = $discount_percent;
                        }
                    }
                }

                // if ($data ["order"] ["discountpromocode"] == "777") {
                // $discount_percent = 10;
                // $globaldiscount = $discount_percent;
                // }
            }

            $result = array ();
            if ($count_rooms > 0) {

                // $this->db->trans_begin ();
                $this->db->trans_start ();
                $price_type = 0;
                $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $price_type = $row->value;
                }
                $countries = $this->config->item ( "countries" );
                $reservation = array ();
                $reservation ["guest"] = $data ["order"] ["guest"];
                $reservation ["description"] = $data ["order"] ["description"];
                $reservation ["percent_discount"] = $discount_percent;
                if (isset ( $data ["uniteller"] )) {

                    $reservation ["uniteller"] = $data ["uniteller"];
                }
                $data_new = array ();
                $reservation ["price_type"] = $price_type;
                $data_new ['phone'] = $reservation ["guest"] ["phone"];
                $data_new ['address'] = $reservation ["guest"] ["address"];
                $data_new ['email'] = $reservation ["guest"] ["email"];
                $data_new ['city'] = $reservation ["guest"] ["city"];
                if (isset ( $countries [$reservation ["guest"] ["country"]] )) {
                    $data_new ['country'] = $countries [$reservation ["guest"] ["country"]];
                } else {
                    $data_new ['country'] = "";
                }
                $data_new ['index'] = $reservation ["guest"] ["index"];

                $data_new ['card_number'] = $data ["card"] ["number"];
                $data_new ['card_XID'] = $data ["card"] ["XID"];
                $data_new ['card_Rrn'] = $data ["card"] ["Rrn"];
                $data_new ['card_TotalAmount'] = $data ["card"] ["TotalAmount"];

                // $data_new ['card_type'] = $data["guest"]["card_type"];
                // $data_new ['card_number'] = $data["guest"]["card_number"];
                // $data_new ['card_owner'] = $data["guest"]["card_owner"];
                // $data_new ['cvc_code'] = $data["guest"]["cvc_code"];
                // $data_new ['card_date'] =
                // $data["guest"]["card_date_month"].".".$data["guest"]["card_date_year"];
                $reservation ["upc"] = $data ["upc"];
                if (isset ( $data ["dc_id"] )) {
                    $reservation ["dc_id"] = $data ["dc_id"];
                }
                if (isset ( $data ["groupid"] )) {
                    $reservation ["groupid"] = $data ["groupid"];
                }
                $insert_service_bool = 0;
                $bool_daily = 0;
                if (! isset ( $data ["utm_source"] )) {
                    $utm_source = "undefined";
                } else {
                    $utm_source = $data ["utm_source"];
                }
                if (! isset ( $data ["cookie"] )) {
                    $cookie = "";
                } else {
                    $cookie = $data ["cookie"];
                }
                $data_new ['firstname'] = $reservation ["guest"] ["firstname"];
                $data_new ['lastname'] = $reservation ["guest"] ["lastname"];

                $guest_id = $this->frontdesk->Guest_insert ( $data_new );

                for($i = 0; $i < $count_rooms; $i ++) {
                    $service_pay = 0;
                    $reservation ["room"] = $data ["order"] ["rooms"] [$i];

                    // print_r($reservation);
                    // die();
                    $reservation ["dc_guestname"] = $reservation ["room"] ["firstname"] . " " . $reservation ["room"] ["lastname"];
                    $reservation ["globaldiscount"] = $globaldiscount;
                    // $data_new ['firstname'] = $reservation ["room"]
                    // ["firstname"];
                    // $data_new ['lastname'] = $reservation ["room"]
                    // ["lastname"];
                    // $guest_id = $this->frontdesk->Guest_insert ( $data_new );
                    $id = 0;
                    if (isset ( $data ["order"] ["rooms"] [$i] ["agent_id"] )) {
                        $dealer_defaultrate = 0;
                        $sql = "SELECT defaultrate FROM dealers WHERE id = " . $data ["order"] ["rooms"] [$i] ["agent_id"];
                        $query = $this->db->query ( $sql );
                        if ($query->num_rows () > 0) {
                            $row = $query->row ();
                            $dealer_defaultrate = $row->defaultrate;
                        }
                        $res_id = 0;
                        $agent_id = $data ["order"] ["rooms"] [$i] ["agent_id"];
                        $id_category = $data ["order"] ["rooms"] [$i] ["id_category"];
                        list ( $year, $month, $day ) = explode ( "-", $data ["order"] ["rooms"] [$i] ["datein"] );
                        $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );

                        list ( $year, $month, $day ) = explode ( "-", $data ["order"] ["rooms"] [$i] ["dateout"] );
                        $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                        $duration = $intdateout - $intdatein;
                        $sql = "SELECT deskofreservation.id, rooms.id as room_id, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname FROM deskofreservation
                        INNER JOIN deskofdays ON deskofdays.reservation_id= deskofreservation.id
                        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
                        INNER JOIN categories ON categories.id = rooms.category_id
                        WHERE categories.web_booking = 1 AND deskofreservation.id_dealer = $agent_id AND deskofreservation.status = 4 AND categories.id = $id_category AND
                        deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY deskofreservation.room_id";
                        // echo $sql;

                        $sql = "SELECT duration, id, room_id, category_id, name, c_name, shortname FROM (SELECT  count(1) as duration, deskofreservation.id, rooms.id as room_id, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname FROM deskofdays
                        INNER JOIN deskofreservation
                        ON deskofdays.reservation_id = deskofreservation.id INNER JOIN rooms  ON deskofdays.room_id = rooms.id	INNER JOIN categories ON categories.id = rooms.category_id
                        WHERE  deskofdays.intdate >= $intdatein  AND deskofdays.intdate < $intdateout  AND deskofreservation.status = 4
                        AND rooms.category_id = $id_category AND deskofreservation.id_dealer = $agent_id
                        GROUP BY deskofdays.room_id ) as t WHERE duration = " . $duration . " LIMIT 0,1";

                        // die();
                        /*
                         * $sql = "SELECT deskofreservation.id, rooms.id as room_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id INNER JOIN categories ON categories.id = rooms.category_id WHERE deskofreservation.id_dealer = $agent_id AND categories.web_booking = 1 AND categories.id = $id_category AND deskofreservation.status = 4 AND deskofreservation.datein <= '" . $data ["order"] ["rooms"] [$i] ["datein"] . "' AND deskofreservation.dateout >= '" . $data ["order"] ["rooms"] [$i] ["dateout"] . "' LIMIT 0,1";
                         */
                        $query = $this->db->query ( $sql );
                        if ($query->num_rows () > 0) {
                            $row = $query->row ();
                            $res_id = $row->id;
                            $room_id = $row->room_id;
                        }
                        // echo $room_id;
                        if ($res_id != 0) {
                            $data_quota = array ();
                            $data_quota ["res_id"] = $res_id;
                            $data_quota ["room_id"] = $room_id;
                            $data_quota ["datein"] = $data ["order"] ["rooms"] [$i] ["datein"];
                            $data_quota ["dateout"] = $data ["order"] ["rooms"] [$i] ["dateout"];
                            $data_quota ["price_type"] = $dealer_defaultrate;
                            $data_quota ["guest_id"] = $guest_id;
                            $data_quota ['dealer'] = $agent_id;
                            $id = $this->CutInsertReservation ( $data_quota );
                        }
                    } else {
                        // 					echo "<pre>";
                        // 					print_r($reservation);
                        //die();
                        $id = $this->Insert_reservations ( $reservation, $guest_id, $personal_table, $utm_source, $cookie );
                    }
                    if (isset ( $data ["insertorderid"] ) and $id != 0) {
                        $global_hotelix_dbl_res_arr = array ();
                        $global_hotelix_dbl_res_arr ["order_id"] = $data ["insertorderid"];
                        $global_hotelix_dbl_res_arr ["reservation_id"] = $id;
                        $this->InsertOrderId ( $global_hotelix_dbl_res_arr );
                    }

                    if (isset ( $data ["tbl_CreditCards"] )) {
                        $this->frontdesk->insert_tbl_CreditCards ( $data ["tbl_CreditCards"], $guest_id, $id );
                    }

                    $data_new ['services_full_price'] = 0;
                    $data_new ['services_ids'] = array ();
                    if ($insert_service_bool == 0) {

                        $dealer = 0;
                        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'dealerID'" );
                        if ($query->num_rows () > 0) {
                            $row = $query->row ();
                            $dealer = $row->value;
                        }

                        $query = $this->db->query ( "SELECT id FROM partners WHERE isdefault = 1" );
                        if ($query->num_rows () > 0) {
                            $row = $query->row ();
                            $partner = $row->id;
                        }else{
                            $partner = 0;
                        }

                        for($s = 0; $s < $count_services; $s ++) {
                            // echo "++++++++++++1";
                            $insert_service_bool = 1;
                            $services_data = array ();
                            $services_data ["res_id"] = $id;
                            $services_data ["dealer"] = $dealer;
                            $services_data ["partner"] = $partner;
                            $services_data ["count"] = 1;
                            $services_data ["type"] = $data ["order"] ["services"] [$s] ["id_service"];
                            $services_data ["description"] = "";
                            $services_data ["price"] = $data ["order"] ["services"] [$s] ["price"];
                            $services_data ["amount"] = $data ["order"] ["services"] [$s] ["price"];
                            $service_insert_id = $this->service_model->Insert_Service ( $services_data, 1 );

                            $data_new ['services_full_price'] += $data ["order"] ["services"] [$s] ["price"];
                            // if ($service_pay == 0){
                            $data_new ['services_ids'] [$s] = $service_insert_id;
                            // }
                        }
                    }

                    $bool = false;
                    if ($id > 0) {
                        $bool = true;
                        if ($reservation ["upc"] == 1) {

                            if (isset ( $daily_prepayment ) and $daily_prepayment == 1) {
                                if ($bool_daily != 1) {
                                    $query = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $id . " AND type = 1" );
                                    if ($query->num_rows () > 0) {
                                        $row = $query->row ();
                                        $id_main = $row->id;
                                        $amount = $row->amount;
                                        $this->Payment_save ( $data_new, $id, 1 );
                                        $bool_daily = 1;
                                    }
                                }
                            } else {
                                $this->Payment_save ( $data_new, $id );
                                // $service_pay = 1;
                                // unset($data_new ['services_ids']);
                            }
                        }
                    } else {
                        // $this->db->trans_rollback ();
                        // $result = array();
                    }

                    $this->frontdesk->SetReservationBalance ( $id );
                    $sql = "SELECT guests.lastname, guests.firstname, deskofreservation.datein, deskofreservation.groupid,
                    deskofreservation.dateout, deskofreservation.amount, rooms.name as room_name, categories.name as cat_name,
                    categories.id as cat_id FROM deskofreservation
                    INNER JOIN guests ON deskofreservation.guest_id=guests.id
                    LEFT JOIN rooms ON rooms.id=deskofreservation.room_id
                    LEFT JOIN categories ON categories.id=rooms.category_id
                    WHERE deskofreservation.id = $id";
                    $query = $this->db->query ( $sql );

                    // echo $sql;
                    if ($bool == true) {
                        $status = 1;
                    } else {
                        $status = 0;
                    }
                    if ($query->num_rows () > 0) {
                        $row = $query->row_array ();
                        // $rate = $this->frontdesk->getrate(1);
                        $amount = $row ['amount'];

                        $query2 = $this->db->query ( "SELECT services.amount, services_types.name FROM services
                            INNER JOIN services_types ON services_types.id = services.type WHERE services.reservation_id = $id" );
                        $services_mass = array ();
                        if ($query2->num_rows () > 0) {
                            $k = 0;
                            foreach ( $query2->result () as $row2 ) {
                                $services_mass [$k] ["name"] = $row2->name;
                                $services_mass [$k] ["price"] = $row2->amount;
                                $k ++;
                            }
                        }

                        array_push ( $result, array (
                            'goupid' => $row ['groupid'],
                            'reservatiom_id' => $id,
                            'status' => $status,
                            "amount" => $amount,
                            "services_mass" => $services_mass,
                            "datein" => $row ['datein'],
                            "dateout" => $row ['dateout'],
                            "cat_id" => $row ['cat_id'],
                            "cat_name" => $row ['cat_name'],
                            "room_name" => $row ['room_name'],
                            "lastname" => $row ['lastname'],
                            "firstname" => $row ['firstname'],
                            "guest_name" => $row ['firstname'] . " " . $row ['lastname']
                        ) );
                    }
                    // if ($this->db->trans_status () === FALSE) {
                    // $this->db->trans_rollback ();
                    // redirect ( '/reservations/error/' );
                    // } else {
                    // $this->db->trans_commit ();
                    // }
                    // $this->db->trans_rollback();

                    // $url = "http://booking.hottour24.com.ua/foo/step5";
                    // $result = $this->CurlPlug($result, $url);
                }
                // print_r($result);
                $msg = "";
                for($i = 0; $i < count ( $result ); $i ++) {
                    $data = array ();
                    $data ['response'] = "ok";
                    $data ['resid'] = $result [$i] ["reservatiom_id"];
                    if ($result [$i] ["goupid"] != "") {
                        $data ["goupid"] = $result [$i] ["goupid"];
                        $str_count_guestbe = substr_count ( $result [$i] ["goupid"], "guestbe" );
                        $str_count_zatoka = substr_count ( $result [$i] ["goupid"], "zatoka" );
                        $str_count_personal = substr_count ( $result [$i] ["goupid"], "personal" );
                        if ($str_count_guestbe > 0) {
                            $temp = explode ( "_", $result [$i] ["goupid"] );
                            $goupid = 'GGB - ' . $temp [1];
                        } elseif ($str_count_zatoka > 0) {
                            $temp = explode ( "_", $result [$i] ["goupid"] );
                            $goupid = 'GZ - ' . $temp [1];
                        } elseif ($str_count_personal > 0) {
                            $temp = explode ( "_", $result [$i] ["goupid"] );
                            $goupid = 'GP - ' . $temp [1];
                        } elseif ($str_count_personal == 0 and $str_count_zatoka == 0 and $str_count_guestbe == 0) {
                            $temp = explode ( "_", $result [$i] ["goupid"] );
                            $goupid = 'G';
                        }
                    } else {
                        $data ["goupid"] = "";
                        $goupid = "";
                    }
                    $data ["hms_reservation_id"] = $result [$i] ["reservatiom_id"];
                    if ($personal_type == 2) {
                        $data ['dcname'] = "On-line form";
                    } else {
                        $data ['dcname'] = "Guestbe.com";
                    }
                    $dcname = $data ['dcname'];
                    $data ['status'] = $result [$i] ["status"];
                    $data ['currencycaption'] = $currencycaption;
                    $msg .= $this->dc_model->msg_txt ( $data, false );
                }

                $this->dc_model->send_notifyarray_dc ( $msg, $dcname, $goupid, false );

                $this->db->trans_complete ();
                $output = $json->encode ( $result );
                print_r ( $output );
            }
    }

    function SaveReservations_c2($daily_prepayment = 0, $personal_type = 1)
    {
        // $DB2 = $this->load->database('default', TRUE);
        // echo "<pre>";

        // print_r ( $_SERVER );
        // echo "++";
        require_once ('JSON.php');
        $json = new Services_JSON();
        // die();
        $data = $_POST["order_data"];
        $data = $json->decode($data);
        $data = objectToArray($data);
        // =====================================
        if (trim($data["order"]["rooms"][0]["datein"]) == "" || trim($data["order"]["rooms"][0]["dateout"]) == "") {
            die();
        }
        // =====================================
        if ($personal_type == 2) {
            $personal_table = "gatewayoforder_personal";
        } else {
            $personal_table = "gatewayoforder";
        }

        $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";

        // echo $sql;
        $query = $this->db->query($sql);
        // echo "<br>+<br><br>";

//         echo "<pre>";
//         print_r($data);
//         die();
        $count_rooms = count($data["order"]["rooms"]);
        if (isset($data["order"]["currencyID"])) {
            switch ($data["order"]["currencyID"]) {
                case 978:
                    $currencycaption = "EUR";
                    break;
                case 840:
                    $currencycaption = "USD";
                    break;
                case 643:
                    $currencycaption = "RUB";
                    break;
                case 980:
                    $currencycaption = "UAH";
                    break;
                case 974:
                    $currencycaption = "BYR";
                    break;
                case 933:
                    $currencycaption = "BYN";
                    break;
                case 498:
                    $currencycaption = "MDL";
                    break;
                case 985:
                    $currencycaption = "PLN";
                    break;
                case 944:
                    $currencycaption = "AZN";
                    break;
                case 51:
                    $currencycaption = "AMD";
                    break;
                case 981:
                    $currencycaption = "GEL";
                    break;
                case 398:
                    $currencycaption = "KZT";
                    break;
                case 944:
                    $currencycaption = "AZN";
                    break;
                default:
                    $currencycaption = "???";
                    break;
            }
        } else {
            $currencycaption = "UAH";
        }

        $count_services = 0;
        if (isset($data["order"]["services"]))
            $count_services = count($data["order"]["services"]);

            if (isset($data["order"]["globaldiscount"])) {
                $globaldiscount = $data["order"]["globaldiscount"];
            } else {
                $globaldiscount = 0;
            }

            $discount_percent = 0;
        if (isset($data["order"]["discountpromocode"])) {
            
            // ========== PROMOCODE VERSION 1 =============
            if ($this->releases->online_propmocodes_veersion() == 1) {
                
                $discount_code_array = array();
                $query = $this->db->query("SELECT * FROM onlinediscount WHERE 1");
                
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $row) {
                        $discount_code_array[$row->code]["percent"] = $row->percent;
                        
                        list ($year, $month, $day) = explode("-", $row->datestart);
                        $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        list ($year, $month, $day) = explode("-", $row->dateend);
                        $intdateout = round(gmmktime(0, 0, 0, $month, $day - 1, $year) / 86400);
                        
                        $discount_code_array[$row->code]["datestart"] = $intdatein;
                        $discount_code_array[$row->code]["dateend"] = $intdateout;
                    }
                }
                
                if (isset($discount_code_array[$data["order"]["discountpromocode"]])) {
                    if (isset($data["order"]["rooms"][0]["datein"])) {
                        list ($year, $month, $day) = explode("-", $data["order"]["rooms"][0]["datein"]);
                        $intdatein_room = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        list ($year, $month, $day) = explode("-", $data["order"]["rooms"][0]["dateout"]);
                        $intdateout_room = round(gmmktime(0, 0, 0, $month, $day - 1, $year) / 86400);
                        
                        $discount_datestart = $discount_code_array[$data["order"]["discountpromocode"]]["datestart"];
                        $discount_dateend = $discount_code_array[$data["order"]["discountpromocode"]]["dateend"];
                        if ($discount_datestart <= $intdatein_room && $discount_dateend >= $intdateout_room) {
                            $discount_percent = $discount_code_array[$data["order"]["discountpromocode"]]["percent"];
                            $globaldiscount = $discount_percent;
                        }
                    }
                }
            }
            
            
        }

            $id_template_bookconfirmation = $this->monline_module->get_id_template_bookconfirmation();
            $id_template_bookconfirmation_isglobal = $this->monline_module->get_id_template_bookconfirmation_isglobal();

            $result = array();
            if ($count_rooms > 0) {

                // $this->db->trans_begin ();
                $this->db->trans_start();
                $price_type = 0;
                $sql = "SELECT value FROM $personal_table WHERE name LIKE 'rateID'";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $price_type = $row->value;
                }
                $countries = $this->config->item("countries");
                $reservation = array();
                if(isset($data["dc_reservationid"])){
                    $reservation["dc_reservationid"] = $data["dc_reservationid"];
                }
                $reservation["guest"] = $data["order"]["guest"];
                $reservation["description"] = $data["order"]["description"];
                $reservation["percent_discount"] = $discount_percent;
                if (isset($data["uniteller"])) {

                    $reservation["uniteller"] = $data["uniteller"];
                }
                
                $reservation["price_type"] = $price_type;
                $data_new['phone'] = $reservation["guest"]["phone"];
                $data_new['address'] = $reservation["guest"]["address"];
                $data_new['email'] = $reservation["guest"]["email"];
                $data_new['city'] = $reservation["guest"]["city"];
                if (isset($countries[$reservation["guest"]["country"]])) {
                    $data_new['country'] = $countries[$reservation["guest"]["country"]];
                } else {
                    $data_new['country'] = "";
                }
                $data_new['index'] = $reservation["guest"]["index"];

                $data_new['card_number'] = $data["card"]["number"];
                $data_new['card_XID'] = $data["card"]["XID"];
                $data_new['card_Rrn'] = $data["card"]["Rrn"];
                $data_new['card_TotalAmount'] = $data["card"]["TotalAmount"];

                // $data_new ['card_type'] = $data["guest"]["card_type"];
                // $data_new ['card_number'] = $data["guest"]["card_number"];
                // $data_new ['card_owner'] = $data["guest"]["card_owner"];
                // $data_new ['cvc_code'] = $data["guest"]["cvc_code"];
                // $data_new ['card_date'] =
                // $data["guest"]["card_date_month"].".".$data["guest"]["card_date_year"];
                $reservation["upc"] = $data["upc"];
                if (isset($data["dc_id"])) {
                    $reservation["dc_id"] = $data["dc_id"];
                }
                if (isset($data["groupid"])) {
                    $reservation["groupid"] = $data["groupid"];
                }
                $insert_service_bool = 0;
                $bool_daily = 0;
                if (! isset($data["utm_source"])) {
                    $utm_source = "undefined";
                } else {
                    $utm_source = $data["utm_source"];
                }
                if (! isset($data["cookie"])) {
                    $cookie = "";
                } else {
                    $cookie = $data["cookie"];
                }
                $data_new['firstname'] = $reservation["guest"]["firstname"];
                $data_new['lastname'] = $reservation["guest"]["lastname"];

                // $guest_id = $this->frontdesk->Guest_insert ( $data_new );

                $guest_id = $this->frontdesk->Guest_insert($data_new);

                $insert_main_guest_bool = 0;
                for ($i = 0; $i < $count_rooms; $i ++) {
                $service_pay = 0;
                $reservation["room"] = $data["order"]["rooms"][$i];
                
                if (isset($data["order"]["discountpromocode"])) {
                    
                    // ========== PROMOCODE VERSION 2 =============
                    if ($this->releases->online_propmocodes_veersion() == 2) {
                        $reservation["room"]["amount"] = $data["order"]["rooms"][$i]["dc_totalprice"];
                        $calculate_data = array();
                        $calculate_data["type_id"] = $data["order"]["rooms"][$i]["id_category"];
                        $calculate_data["datein"] = $data["order"]["rooms"][$i]["datein"];
                        $calculate_data["dateout"] = $data["order"]["rooms"][$i]["dateout"];
                        $calculate_data["add_places"] = $data["order"]["rooms"][$i]["add_places"];
                        $calculate_data["baby_places"] = 0;
                        $calculate_data["addbedplace"] = 0;
                        $calculate_data["babyplace2"] = 0;
                        $calculate_data["price_type"] = $data["order"]["rooms"][$i]["rate_id"];
                        
                        $temp_amount = $this->frontdesk->getpricecalculation($calculate_data);
                        $otelms_amount = 0;
                        for ($p = 0; $p < count($temp_amount); $p ++) {
                            $otelms_amount += $temp_amount[$p]["amount"];
                        }
                        $module_amount = $data["order"]["rooms"][$i]["dc_totalprice"];
                        $reservation["room"]["discount"] = 0;
                        if ($module_amount != $otelms_amount) {
                            $reservation["room"]["discount"] = $otelms_amount - $module_amount;
                        }
                    }else{
                        $reservation["globaldiscount"] = $globaldiscount;
                    }
                }
                    
                    
                    /*
                     *
                     * ======== INSERT GUEST LIST ====
                     *
                     */
                    if (false) { // skip guest list
                        if (isset($data["order"]["rooms"][$i]["guests"])) {
                            foreach ($data["order"]["rooms"][$i]["guests"] as $guest_inc => $guest_cell) {
                                if (trim($guest_cell["firstname"]) != "") {
                                    $guest_id = $this->frontdesk->Guest_insert($guest_cell);
                                } else {
                                    if ($insert_main_guest_bool == 0) {
                                        $guest_id = $this->frontdesk->Guest_insert($data_new);
                                    }
                                    $insert_main_guest_bool = 1;
                                }
                                break;
                            }
                        } else {
                            if ($insert_main_guest_bool == 0) {
                                $guest_id = $this->frontdesk->Guest_insert($data_new);
                            }
                            $insert_main_guest_bool = 1;
                        }
                    }
                    // print_r($reservation);
                    // die();

                    $reservation["dc_guestname"] = $reservation["guest"]["firstname"]." ".$reservation["guest"]["lastname"];
                    // $reservation ["dc_guestname"] = $reservation ["room"] ["firstname"] . " " . $reservation ["room"] ["lastname"];
                    
                    // $data_new ['firstname'] = $reservation ["room"]
                    // ["firstname"];
                    // $data_new ['lastname'] = $reservation ["room"]
                    // ["lastname"];
                    // $guest_id = $this->frontdesk->Guest_insert ( $data_new );
                    $id = 0;
                    if (isset($data["order"]["rooms"][$i]["agent_id"])) {
                        $dealer_defaultrate = 0;
                        $sql = "SELECT defaultrate FROM dealers WHERE id = " . $data["order"]["rooms"][$i]["agent_id"];
                        $query = $this->db->query($sql);
                        if ($query->num_rows() > 0) {
                            $row = $query->row();
                            $dealer_defaultrate = $row->defaultrate;
                        }
                        $res_id = 0;
                        $agent_id = $data["order"]["rooms"][$i]["agent_id"];
                        $id_category = $data["order"]["rooms"][$i]["id_category"];
                        list ($year, $month, $day) = explode("-", $data["order"]["rooms"][$i]["datein"]);
                        $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);

                        list ($year, $month, $day) = explode("-", $data["order"]["rooms"][$i]["dateout"]);
                        $intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                        $duration = $intdateout - $intdatein;
                        $sql = "SELECT deskofreservation.id, rooms.id as room_id, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname FROM deskofreservation
                        INNER JOIN deskofdays ON deskofdays.reservation_id= deskofreservation.id
                        INNER JOIN rooms ON rooms.id = deskofreservation.room_id
                        INNER JOIN categories ON categories.id = rooms.category_id
                        WHERE categories.web_booking = 1 AND deskofreservation.id_dealer = $agent_id AND deskofreservation.status = 4 AND categories.id = $id_category AND
                        deskofdays.intdate >= $intdatein AND deskofdays.intdate < $intdateout GROUP BY deskofreservation.room_id";
                        // echo $sql;

                        $sql = "SELECT duration, id, room_id, category_id, name, c_name, shortname FROM (SELECT  count(1) as duration, deskofreservation.id, rooms.id as room_id, rooms.category_id, rooms.name, categories.name as c_name, categories.shortname FROM deskofdays
                        INNER JOIN deskofreservation
                        ON deskofdays.reservation_id = deskofreservation.id INNER JOIN rooms  ON deskofdays.room_id = rooms.id	INNER JOIN categories ON categories.id = rooms.category_id
                        WHERE  deskofdays.intdate >= $intdatein  AND deskofdays.intdate < $intdateout  AND deskofreservation.status = 4
                        AND rooms.category_id = $id_category AND deskofreservation.id_dealer = $agent_id
                        GROUP BY deskofdays.room_id ) as t WHERE duration = " . $duration . " LIMIT 0,1";

                        // die();
                        /*
                         * $sql = "SELECT deskofreservation.id, rooms.id as room_id FROM deskofreservation INNER JOIN rooms ON rooms.id = deskofreservation.room_id INNER JOIN categories ON categories.id = rooms.category_id WHERE deskofreservation.id_dealer = $agent_id AND categories.web_booking = 1 AND categories.id = $id_category AND deskofreservation.status = 4 AND deskofreservation.datein <= '" . $data ["order"] ["rooms"] [$i] ["datein"] . "' AND deskofreservation.dateout >= '" . $data ["order"] ["rooms"] [$i] ["dateout"] . "' LIMIT 0,1";
                         */
                        $query = $this->db->query($sql);
                        if ($query->num_rows() > 0) {
                            $row = $query->row();
                            $res_id = $row->id;
                            $room_id = $row->room_id;
                        }
                        // echo $room_id;
                        if ($res_id != 0) {
                            $data_quota = array();
                            $data_quota["res_id"] = $res_id;
                            $data_quota["room_id"] = $room_id;
                            $data_quota["datein"] = $data["order"]["rooms"][$i]["datein"];
                            $data_quota["dateout"] = $data["order"]["rooms"][$i]["dateout"];
                            $data_quota["price_type"] = $dealer_defaultrate;
                            $data_quota["guest_id"] = $guest_id;
                            $data_quota['dealer'] = $agent_id;
                            $id = $this->CutInsertReservation($data_quota);
                        }
                    } else {
                        //print_r($reservation);
                        $id = $this->Insert_reservations($reservation, $guest_id, $personal_table, $utm_source, $cookie);

                        if (false) { // skip guests insert ===
                            if (isset($data["order"]["rooms"][$i]["guests"])) {
                                foreach ($data["order"]["rooms"][$i]["guests"] as $guest_inc => $guest_cell) {
                                    if ($guest_inc > 1) {
                                        if (trim($guest_cell["firstname"]) != "" || trim($guest_cell["lastname"]) != "") {
                                            $add_guest_id = $this->frontdesk->Guest_insert($guest_cell);

                                            $this->frontdesk->guests_reservation_insert($add_guest_id, $id);

                                            $reservation_details = array();
                                            $reservation_details["reservation_id"] = $id;
                                            $reservation_details["guest_id"] = $add_guest_id;
                                            $this->frontdesk->set_guests_reservation_details($reservation_details);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if(isset($data["order"]["rooms"][$i]["ccforce"])){
                        if($data["order"]["rooms"][$i]["ccforce"] == 1){
                            $global_hotelix_order_pending_log = array();
                            $global_hotelix_order_pending_log["hotel_id"] = $this->config->item("hotel_id");
                            $global_hotelix_order_pending_log["reservation_id"] = $id;
                            $global_hotelix_order_pending_log["time"] = date("Y-m-d H:i:s");
                            $global_hotelix_order_pending_log["cc_processor"] = $data["cc_processor"];
                            $global_hotelix_order_pending_log["status"] = 0;
                            $this->frontdesk_c2->insert_order_pending_log($global_hotelix_order_pending_log);
                        }
                    }

                    if (isset($data["insertorderid"]) and $id != 0) {
                        $global_hotelix_dbl_res_arr = array();
                        $global_hotelix_dbl_res_arr["order_id"] = $data["insertorderid"];
                        $global_hotelix_dbl_res_arr["reservation_id"] = $id;
                        $this->InsertOrderId($global_hotelix_dbl_res_arr);
                    }

                    if (isset($data["tbl_CreditCards"])) {
                        $this->frontdesk->insert_tbl_CreditCards($data["tbl_CreditCards"], $guest_id, $id);
                    }

                    $data_new['services_full_price'] = 0;
                    $data_new['services_ids'] = array();
                    if ($insert_service_bool == 0) {
                        for ($s = 0; $s < $count_services; $s ++) {
                            // echo "++++++++++++1";
                            $insert_service_bool = 1;
                            $services_data = array();
                            $services_data["res_id"] = $id;
                            $services_data["dealer"] = 0;
                            $services_data["partner"] = 0;
                            $services_data["count"] = 1;
                            $services_data["type"] = $data["order"]["services"][$s]["id_service"];
                            $services_data["description"] = "";
                            $services_data["price"] = $data["order"]["services"][$s]["price"];
                            $services_data["amount"] = $data["order"]["services"][$s]["price"];
                            $addons_date =  $reservation["room"]["datein"];
                            if(isset($reservation["room"]["checkintime"])){
                                if($reservation["room"]["checkintime"] != ""){
                                    $addons_date =  $reservation["room"]["datein"]." ".$reservation["room"]["checkintime"];
                                }
                            }
                            $services_data["addons_date"] = $addons_date;
                            $service_insert_id = $this->service_model->Insert_Service($services_data, 1);

                            $data_new['services_full_price'] += $data["order"]["services"][$s]["price"];
                            // if ($service_pay == 0){
                            $data_new['services_ids'][$s] = $service_insert_id;
                            // }
                        }
                    }

                    $bool = false;
                    if ($id > 0) {
                        $bool = true;
                        if ($reservation["upc"] == 1) {

                            if (isset($daily_prepayment) and $daily_prepayment == 1) {
                                if ($bool_daily != 1) {
                                    $query = $this->db->query("SELECT * FROM services_main WHERE reservation_id = " . $id . " AND type = 1");
                                    if ($query->num_rows() > 0) {
                                        $row = $query->row();
                                        $id_main = $row->id;
                                        $amount = $row->amount;
                                        $this->Payment_save($data_new, $id, 1);
                                        $bool_daily = 1;
                                    }
                                }
                            } else {
                                $this->Payment_save($data_new, $id);
                                // $service_pay = 1;
                                // unset($data_new ['services_ids']);
                            }
                        }
                    } else {
                        // $this->db->trans_rollback ();
                        // $result = array();
                    }

                    $this->frontdesk->SetReservationBalance($id);
                    $sql = "SELECT guests.lastname, guests.firstname, deskofreservation.datein, deskofreservation.groupid,
                    deskofreservation.dateout, deskofreservation.amount, rooms.name as room_name, categories.name as cat_name,
                    categories.id as cat_id FROM deskofreservation
                    INNER JOIN guests ON deskofreservation.guest_id=guests.id
                    LEFT JOIN rooms ON rooms.id=deskofreservation.room_id
                    LEFT JOIN categories ON categories.id=rooms.category_id
                    WHERE deskofreservation.id = $id";
                    $query = $this->db->query($sql);

                    // echo $sql;
                    if ($bool == true) {
                        $status = 1;
                    } else {
                        $status = 0;
                    }
                    if ($query->num_rows() > 0) {
                        $row = $query->row_array();
                        // $rate = $this->frontdesk->getrate(1);
                        $amount = $row['amount'];

                        $query2 = $this->db->query("SELECT services.amount, services_types.name FROM services
                            INNER JOIN services_types ON services_types.id = services.type WHERE services.reservation_id = $id");
                        $services_mass = array();
                        if ($query2->num_rows() > 0) {
                            $k = 0;
                            foreach ($query2->result() as $row2) {
                                $services_mass[$k]["name"] = $row2->name;
                                $services_mass[$k]["price"] = $row2->amount;
                                $k ++;
                            }
                        }

                        array_push($result, array(
                            'goupid' => $row['groupid'],
                            'reservatiom_id' => $id,
                            'status' => $status,
                            "amount" => $amount,
                            "services_mass" => $services_mass,
                            "datein" => $row['datein'],
                            "dateout" => $row['dateout'],
                            "cat_id" => $row['cat_id'],
                            "cat_name" => $row['cat_name'],
                            "room_name" => $row['room_name'],
                            "lastname" => $row['lastname'],
                            "firstname" => $row['firstname'],
                            "guest_name" => $row['firstname'] . " " . $row['lastname']
                        ));
                    }
                    // if ($this->db->trans_status () === FALSE) {
                    // $this->db->trans_rollback ();
                    // redirect ( '/reservations/error/' );
                    // } else {
                    // $this->db->trans_commit ();
                    // }
                    // $this->db->trans_rollback();

                    // $url = "http://booking.hottour24.com.ua/foo/step5";
                    // $result = $this->CurlPlug($result, $url);

                    $client_data_email = array();
                    $client_data_email ["reservation_id"] = $id;
                    $client_data_email ["guest_id"] = $guest_id;
                    $client_data_email ["send_id_template"] = $id_template_bookconfirmation;
                    $client_data_email ["location_type"] = "local";
                    if($id_template_bookconfirmation_isglobal == 1){
                        $client_data_email ["location_type"] = "global";
                    }
                    $client_data_email ["send_email"] = $reservation["guest"]["email"];
                    //print_r($client_data_email);
                    $this->formsprinter_model_v2->send_template_toemail_curl($client_data_email, false, 1);

                    // ========= log reservation notify ==========
                    $log_data = array();
                    $log_data ["s_id"] = $id;
                    $log_data ["description"] = "send";
                    $this->loger->SaveLog ( $log_data, "reservation", "order notify" );

                }
                // print_r($result);
                $msg = "";
                $hms_reservation_id = 0;
                for ($i = 0; $i < count($result); $i ++) {
                    $data = array();
                    $data['response'] = "ok";
                    $data['resid'] = $result[$i]["reservatiom_id"];
                    if ($result[$i]["goupid"] != "") {
                        $data["goupid"] = $result[$i]["goupid"];
                        $str_count_guestbe = substr_count($result[$i]["goupid"], "guestbe");
                        $str_count_zatoka = substr_count($result[$i]["goupid"], "zatoka");
                        $str_count_personal = substr_count($result[$i]["goupid"], "personal");
                        if ($str_count_guestbe > 0) {
                            $temp = explode("_", $result[$i]["goupid"]);
                            $goupid = 'GGB - ' . $temp[1];
                        } elseif ($str_count_zatoka > 0) {
                            $temp = explode("_", $result[$i]["goupid"]);
                            $goupid = 'GZ - ' . $temp[1];
                        } elseif ($str_count_personal > 0) {
                            $temp = explode("_", $result[$i]["goupid"]);
                            $goupid = 'GP - ' . $temp[1];
                        } elseif ($str_count_personal == 0 and $str_count_zatoka == 0 and $str_count_guestbe == 0) {
                            $temp = explode("_", $result[$i]["goupid"]);
                            $goupid = 'G';
                        }
                    } else {
                        $data["goupid"] = "";
                        $goupid = "";
                    }
                    $data["hms_reservation_id"] = $result[$i]["reservatiom_id"];
                    $hms_reservation_id = $result[$i]["reservatiom_id"];
                    if ($personal_type == 2) {
                        $data['dcname'] = "On-line form";
                    } else {
                        $data['dcname'] = "Guestbe.com";
                    }
                    $dcname = $data['dcname'];
                    $data['status'] = $result[$i]["status"];
                    $data['currencycaption'] = $currencycaption;
                    $msg .= $this->dc_model->msg_txt($data, false);
                }

                $this->dc_model->send_notifyarray_dc($msg, $dcname, $goupid, false, "non", $hms_reservation_id);

                // відправка емейла з унікальними лінками для персонального модуля С2 на кожне замовлення.
                //             $this->dc_model->send_personal_message($result, $dcname);
                //             die();
                $this->db->trans_complete();
                $output = $json->encode($result);
                print_r($output);
            }
            
    }

    function Insert_reservations($data, $guest_id, $personal_table, $utm_source = "undefined", $cookie = "") {
        $overbooking_category_id = 0;
        $query = $this->db->query ( "SELECT value FROM  hotelix_config WHERE name LIKE 'overbooking_category_id'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $overbooking_category_id = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'dealerID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $dealer = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'categoryID'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $default_categoryid = $row->value;
        }

        $query = $this->db->query ( "SELECT * FROM categories WHERE id = " . $data ["room"] ["id_category"] );
        if ($query->num_rows () > 0) {
            $category = $data ["room"] ["id_category"];
        } else {
            $category = $default_categoryid;
        }

        $origin_categoryid = 0;

        $data_new = array();
        // якщо є предоплата, тоді поміщаємо бронювання в категорію overbooking
        if($data ["room"] ["ccforce"] == 1){
            //$origin_categoryid = $category;
            //$category = $overbooking_category_id;
        }

        $avoidtime = 0;
        $query = $this->db->query ( "SELECT value FROM $personal_table WHERE name LIKE 'avoidtime'" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $avoidtime = $row->value;
        }
        //$result = $this->getfreeroomlist ( $data ["room"] ["datein"], $data ["room"] ["dateout"], $category );
        $result = 0;
        $is_available = $this->frontdesk->getfreeroomlist_overboking ( $data ["room"] ["datein"], $data ["room"] ["dateout"], $category );
        //echo $is_available;
        if ($is_available == 0) {
            $result = $this->frontdesk->getfreeroomlist($data["room"]["datein"], $data["room"]["dateout"], $category);
            if ($result == 0) {
                //$result = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                if (isset($overbooking_category_id)) {
                    $origin_categoryid = $category;
                    $result = $this->frontdesk->getfreeroomlist($data["room"]["datein"], $data["room"]["dateout"], $overbooking_category_id);
                    if ($result == 0) {
                        $result = $this->dc_model->dc_make_overbooking_room($overbooking_category_id);
                    }
                }
            }
        }

        if ($result > 0) {
            if (isset ( $data ["dc_id"] )) {
                $data_new ["dc_id"] = $data ["dc_id"];
            }
            if (isset ( $data ["groupid"] ) && isset ( $data ["dc_id"] )) {
                $data_new ["groupid"] = $data ["groupid"];
            } else {
                $data_new ['groupid'] = $data ["room"] ["groupid"];
            }
            $data_new ["utm_source"] = $utm_source;
            $data_new ["cookie"] = $cookie;
            $data_new ["room_id"] = $result;
            $data_new ["type_id"] = $category;
            $data_new ["origin_categoryid"] = $origin_categoryid;
            $data_new ['dealer'] = $dealer;
            $data_new ['isNew'] = 1;
            $data_new ['datein'] = $data ["room"] ["datein"];
            $data_new ['dateout'] = $data ["room"] ["dateout"];

            if (isset ( $data ["room"] ["amount"] )) {
                $data_new ["amount"] = $data ["room"] ["amount"];
            }
            if (isset ( $data ["room"] ["discount"]  )) {
                $data_new ["discount"] = $data ["room"] ["discount"];
            }
            
            if(isset($data ["room"] ["checkintime"])){
                $data_new ['checkintime'] = $data ["room"] ["checkintime"];
            }else{
                $data_new ['checkintime'] = "";
            }

            if(isset($data ["room"] ["checkouttime"])){
                $data_new ['checkouttime'] = $data ["room"] ["checkouttime"];
            }else{
                $data_new ['checkouttime'] = "";
            }

            $data_new ['description'] = $data ["description"];
            $data_new ['dc_customerremarks'] = $data ["description"];
            $data_new ['user'] = - 1;
            if (isset ( $data ["percent_discount"] )) {
                if ($data ["percent_discount"] != 0) {
                    $data_new ['percent_discount'] = $data ["percent_discount"];
                }
            }

            if(isset($data ["globaldiscount"])){
                $data_new ['globaldiscount'] = $data ["globaldiscount"];
            }
            $data_new ['price_type'] = $data ["room"] ["rate_id"];
            if(isset($data ["room"] ["adults"])){
                $data_new ['adults'] = $data ["room"] ["adults"];
            }
            $data_new ['add_places'] = $data ["room"] ["add_places"];
            $data_new ['avoidtime'] = $avoidtime;
            $data_new ["autocancel"] = "";
            $data_new ["dc_guestname"] = $data ["dc_guestname"];
            if (isset ( $data ["uniteller"] )) {
                $data_new ["uniteller"] = $data ["uniteller"];
            }
            if ($avoidtime > 0) {
                $data_new ["autocancel"] = "view2";
                $data_new ["duetime_null"] = 1;
            } else {
                $data_new ["duetime_null"] = 0;
            }

            if(isset($data["dc_reservationid"])){
                $data_new["dc_reservationid"] = $data["dc_reservationid"];
            }

            if(isset($data["room"]["dc_totalprice"])){
                $data_new["dc_totalprice"] = $data["room"]["dc_totalprice"];
            }

            //print_r($data_new);
            //die();
            $reservation_id = $this->frontdesk->Reservation_insert ( $data_new, $guest_id, $small = 0 );

            // die();
            if ($reservation_id > 0) {
                $amount = 0;
                $db_name = "";
                $hotel_id = 0;
                $host = "";
                $query = $this->db->query ( "SELECT amount FROM deskofreservation WHERE id = " . $reservation_id );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $amount = $row->amount;
                }

                //                 if ($data["room"]["ccforce"] == 1) {
                //                     $duetime = date ( "Y-m-d H:i:s", mktime ( date ( "H" ), date ( "i" ), date ( "s" ) + $avoidtime, date ( "m" ), date ( "d" ), date ( "Y" ) ) );
                //                     $needpay_array = array();
                //                     $needpay_array['reservation_id'] = $reservation_id;
                //                     $needpay_array['duetime'] = $duetime;
                //                     $this->frontdesk_c2->insert_deskofreservation_needpay($needpay_array);

                //                     $semafor_insert_data = array();
                //                     $semafor_insert_data['hotelid'] = $this->config->item('hotel_id');
                //                     $semafor_insert_data['inserttime'] = date ('U');
                //                     $this->frontdesk_c2->insert_hms_order4pay_semafor($semafor_insert_data);
                //                 }

                //                 if ($data["room"]["ccforce"] == 1) {
                //                     $needpay_data = array();
                //                     $needpay_data['reservation_id'] = $reservation_id;
                //                     $this->frontdesk_c2->needpay($needpay_data);
                //                 }

                $needpay_data = array();
                $needpay_data['reservation_id'] = $reservation_id;
                $this->frontdesk_c2->needpay($needpay_data);

                $query = $this->db->query ( "SELECT DATABASE() as db_name" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $db_name = $row->db_name;
                }

                if (1 == 2) {

                    if (! $link = mysqli_connect ( $this->config->item ( 'visitka_host' ),
                        $this->config->item ( 'visitka_user' ),
                        $this->config->item ( 'visitka_pass' ) ))
                        die ( 'ERROR MySQL' );
                        mysqli_select_db ( $link, "visitka" );

                        $result = mysqli_query ( $link, "SELECT id, host FROM  config WHERE db_name LIKE '" . $db_name . "'" );
                        while ( $row_visitka = mysqli_fetch_array ( $result ) ) {
                            $hotel_id = $row_visitka ["id"];
                            $host = $row_visitka ["host"];
                        }
                        mysqli_close ( $link );

                        if (! $link = mysqli_connect ( $this->config->item ( 'visitka_host' ),
                            $this->config->item ( 'visitka_user' ),
                            $this->config->item ( 'visitka_pass' ) ))
                            die ( 'ERROR MySQL' );
                            mysqli_select_db ( $link, "global_hotelix" );

                            $result = mysqli_query ( $link, "INSERT INTO double_reservation (hotel_id, reservation_id, amount,
				host, db_name) VALUES('" . $hotel_id . "','" . $reservation_id . "','" . $amount . "','" . $host . "',
				'" . $db_name . "')" );
                            mysqli_close ( $link );
                }
                // die("736278ry823r382");
            } else {
                // $this->db->trans_rollback ();
            }
        } else {
            // $result_id = 0;
            // $this->db->trans_rollback ();
        }

        return $reservation_id;
    }
    function Payment_save($data, $reservation_id, $daily_prepayment = 0) {
        if ($daily_prepayment == 0) {
            $amount = 0;
            $query = $this->db->query ( "SELECT * FROM services_main WHERE reservation_id = " . $reservation_id . " AND type = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_main = $row->id;
                $amount = $row->amount;
            }

            if (isset ( $data ["services_full_price"] )) {
                $amount += $data ["services_full_price"];
            }
        } else {
            $query = $this->db->query ( "SELECT services_main.id, services_main.amount, deskofreservation.duration FROM services_main INNER JOIN  deskofreservation ON  deskofreservation.id = services_main.reservation_id WHERE services_main.reservation_id = " . $reservation_id . " AND services_main.type = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_main = $row->id;
                $amount = $row->amount / $row->duration;
            }
        }
        $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $id_partner = $row->id;
        }
        $time = date ( "Y-m-d H:i:s" );
        if (! isset ( $data ["card_type"] )) {
            $data ["card_type"] = 0;
        }
        $time = date ( "Y-m-d H:i:s" );

        $sql = "
		INSERT INTO `payment` (reservation_id, clear_pay, amount, id_partner,
		type, card_type, card_holder, card_number, card_validity, card_protective_code,
		description, create_time) VALUES(" . $reservation_id . ",
		0, " . $amount . ", '" . $id_partner . "', 2,
		'0', '',
		'" . addslashes ( $data ["card_number"] ) . "',
		'',
		'',
		'card_XID - " . $data ["card_XID"] . "; card_Rrn - " . $data ["card_Rrn"] . "; card_TotalAmount - " . $data ["card_TotalAmount"] . "; card_Number - " . addslashes ( $data ["card_number"] ) . "', '" . $time . "')";

        // echo $sql."<br>";

        $query = $this->db->query ( "
		INSERT INTO `payment` (reservation_id, clear_pay, amount, id_partner,
		type, card_type, card_holder, card_number, card_validity, card_protective_code,
		description, create_time) VALUES(" . $reservation_id . ",
		0, " . $amount . ", '" . $id_partner . "', 2,
		'0', '',
		'" . addslashes ( $data ["card_number"] ) . "',
		'',
		'',
		'card_XID - " . $data ["card_XID"] . "; card_Rrn - " . $data ["card_Rrn"] . "; card_TotalAmount - " . $data ["card_TotalAmount"] . "; card_Number - " . addslashes ( $data ["card_number"] ) . "', '" . $time . "')" );

        $pay_id = $this->db->insert_id ();

        // id_main - insert
        // $query = $this->db->query ( "INSERT INTO `check_payment_items`
        // (reservation_id, check_payment_id, item_service_table_id, item_id)
        // VALUES($reservation_id,$pay_id, 2,$id_main)" );
        // id_main - insert

        if (isset ( $data ["services_ids"] )) {
            for($i = 0; $i < count ( $data ["services_ids"] ); $i ++) {
                $id = $data ["services_ids"] [$i];
                $query = $this->db->query ( "INSERT INTO `check_payment_items` (reservation_id,check_payment_id, item_service_table_id, item_id) VALUES($reservation_id,$pay_id, 1,$id)" );
            }
        }

        // $log_data = $_POST;
        $log_data ["s_id"] = $pay_id;
        $log_data ["description"] = "all fields";
        $log_data ["res_id"] = $reservation_id;
        $log_data ["amount"] = $amount;
        $this->loger->SaveLog ( $log_data, "pay", "save" );
        $query = $this->db->query ( "INSERT INTO `check_payment_items` (reservation_id, check_payment_id, item_service_table_id, item_id) VALUES($reservation_id,$pay_id, 2,$id_main)" );


    }

    function appex_billing_update(){

        error_reporting(E_ALL);

        $this->load->model('stripe_billing_m2');


        $data = $_POST ["order_data"];
        $data = json_decode ( $data, true );
        print_r($data);
        $invoice_id = $data["invoice_id"];


        echo "-***-";

        $this->stripe = new \Stripe\Stripe();
        $this->customer = new \Stripe\Customer();
        $this->charge = new \Stripe\Charge();
        $this->invoice = new \Stripe\Invoice();

        echo "-0-";

        $secret_key = $this->stripe_billing_m2->get_secret_key();

        echo "-1-";

        $this->stripe->setApiKey($secret_key);

        echo "-2-";

        $invoice_obj = $this->invoice->retrieve($invoice_id);

        echo "-3-";

        $invoice_obj->pay(array('paid_out_of_band' => true));


        echo "-4-";
        die();
    }

    function appex_payment_update(){

        $data = $_POST ["order_data"];
        $data = json_decode ( $data, true );

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }
            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            $this->db->query ( "INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			card_number, card_validity, card_protective_code, create_time, operationtime)
			VALUES('".$user."', " . $data ["oid"] . ", " . 0 . ", " . $data ["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			'', '', '', '" . $time . "', '" . $time . "')" );
            $pay_id = $this->db->insert_id ();

            if($pay_id > 0){
                $description_array = array();
                $description_array["payment_id"] = $data ["transID"];
                $description_array["amount"] = $data ["amount"];
                $description_array["currency"] = $data ["currency"];
                $description_array["order_id"] = $data ["order_id"];
                $description_array =  json_encode($description_array);
                $this->db->query ( "UPDATE `payment` SET description = '".$description_array."' WHERE id = ".$pay_id);

                /*
                 * UPDATE BALANCE
                 */
                $this->frontdesk->SetReservationBalance($data ["oid"]);

                /*
                 * підтвердження бронювання (скидування avoidtime i duetime в 0)
                 */
                $this->frontdesk->set_reservation_avoidtime($data ["oid"]);

                /*
                 * фіксація вдалої оплати в global_hotelix таблиця order_pending_log (status = 1)
                 */
                $pending_log_data = array();
                $pending_log_data["hotel_id"] = $data ["hms_id"];
                $pending_log_data["reservation_id"] = $data ["oid"];
                $pending_log_data["status"] = 1;
                $this->frontdesk_c2->set_order_pending_log_status($pending_log_data);

                /*
                 * SAVE LOG
                 */
                $log_data ["s_id"] = $pay_id;
                $log_data ["description"] = "all fields";
                $log_data ["res_id"] = $data ["oid"];
                $log_data ["amount"] = $data ["amount"];
                $this->loger->SaveLog ( $log_data, "pay", "save" );

                $result = array (
                    "payment_result" => "paymentOK"
                );
                $output = json_encode ( $result );
                print_r ( $output );
            }
        }
    }

    function appex_payment_update_ibm_OLD(){

        $data = $_POST ["order_data"];
        $data = json_decode ( $data, true );

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            $reservation_id = 0;
            $intgroupid = 0;
            $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE dc_id = 999 AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $reservation_id = $row->id;
                $intgroupid = $row->intgroupid;
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            $this->db->query ( "INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			card_number, card_validity, card_protective_code, create_time, operationtime)
			VALUES('".$user."', " . $reservation_id . ", " . 0 . ", " . $data ["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			'', '', '', '" . $time . "', '" . $time . "')" );
            $pay_id = $this->db->insert_id ();

            if($pay_id > 0){
                $description_array = array();
                $description_array["payment_id"] = $data ["transID"];
                $description_array["amount"] = $data ["amount"];
                $description_array["currency"] = $data ["currency"];
                $description_array["order_id"] = $data ["order_id"];
                $description_array =  json_encode($description_array);
                $this->db->query ( "UPDATE `payment` SET description = '".$description_array."' WHERE id = ".$pay_id);

                if($intgroupid > 0){
                    $group_reservations = $this->db->select('id')->get_where('deskofreservation', array('intgroupid' => $intgroupid))->result_array();
                    foreach($group_reservations as $cell){
                        $group_res_id = $cell['id'];
                        $this->db->query ( "UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = ".$group_res_id);
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    }
                }else{
                    $this->db->query ( "UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = ".$reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);
                }



                /*
                 * UPDATE BALANCE
                 */
                $this->frontdesk->SetReservationBalance($reservation_id);


                /*
                 * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                 */
                $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                // insert user message
                $msg_data = array();
                $msg_data['reservation_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data ["s_id"] = $pay_id;
                $log_data ["description"] = "all fields";
                //$log_data ["res_id"] = $data ["oid"];
                $log_data ["res_id"] = $reservation_id;
                $log_data ["amount"] = $data ["amount"];
                $this->loger->SaveLog ( $log_data, "pay", "save" );

                $result = array (
                    "payment_result" => "paymentOK",
                    "transfer_result" => $action_result
                );
                $output = json_encode ( $result );
                print_r ( $output );
            }
        }
    }

    function appex_payment_update_ibm(){

        $data = $_POST ["order_data"];
        $data = json_decode ( $data, true );

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            $reservation_id = 0;
            $intgroupid = 0;
            $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $reservation_id = $row->id;
                $intgroupid = $row->intgroupid;
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                // $log_data ["res_id"] = $data ["oid"];
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function paypal_v2_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            //             if(isset($_SESSION ['user']["id"])){
            //                 $user = $_SESSION ['user']["id"];
            //             }
            //$payment_type = 2;

            $payment_type = $this->hotelix_config->get_record('paypal_payment_type', 'int');

            if ($payment_type == 0 || $payment_type == ""){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = $this->hotelix_config->get_record('paypal_id_partner', 'int');
            if ($id_partner == 0 || $id_partner == ""){
                $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $id_partner = $row->id;
                }
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();


                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }


                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);

                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
                        //                         $cancel_data = array();
                        //                         $cancel_data["description"] = "";
                        //                         $cancel_data["res_id"] = $group_res_id;
                        //                         $cancel_data["charge"] = 0;
                        //                         $cancel_data["guestbe_request"] = 1;
                        //                         $cancel_data["status"] = 5;
                        //                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {
                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function mandarin_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
//             if(isset($_SESSION ['user']["id"])){
//                 $user = $_SESSION ['user']["id"];
//             }
            //$payment_type = 2;

            $payment_type = $this->hotelix_config->get_record('mandarin_payment_type', 'int');

            if ($payment_type == 0 || $payment_type == ""){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = $this->hotelix_config->get_record('mandarin_id_partner', 'int');
            if ($id_partner == 0 || $id_partner == ""){
                $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $id_partner = $row->id;
                }
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();


                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }


                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);

                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {
                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function ipay_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE (dc_id = 999 OR dc_id = 31) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function monobank_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;
            
            
            //========================= checking if payment already saved START
            $tbl_invoices_register = 'monobank_invoice2payment';
            if (isset($data ['monobank_invoice_id'])) {
                $monobank_invoice_id = $data ['monobank_invoice_id'];
                $query_invoice_exist = $this->db->select('payment_id')->get_where($tbl_invoices_register, array('invoice_id' => $monobank_invoice_id))->row();
                if ($query_invoice_exist) {
                    $result = array(
                        "payment_result" => "OK, payment already saved",
                        "payment_id" => $query_invoice_exist->payment_id,
                        "invoice_id" => $monobank_invoice_id,
                    );
                    echo json_encode($result);
                    exit();
                }
            }
            //========================= checking if payment already saved FINAL

            //$payment_type = $this->frontdesk->get_uniteller_payment_type();
            $payment_type = $this->hotelix_config->get_record('monobank_payment_type', 'int');
            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = $this->hotelix_config->get_record('monobank_partner', 'int');
            if ($id_partner == 0){
                $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $id_partner = $row->id;
                }
            }
            
            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array['invoice_id'] = isset($data ['monobank_invoice_id']) ? $data ['monobank_invoice_id'] : null;
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array['invoice_id'] = isset($data ['monobank_invoice_id']) ? $data ['monobank_invoice_id'] : null;
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {
                
                if (isset($monobank_invoice_id)) {
                    $this->db->insert($tbl_invoices_register, array('invoice_id' => $monobank_invoice_id, 'payment_id' => $pay_id));
                }

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }
    
    function bog_payment_update(){
        
        $data = file_get_contents("php://input");
        $data = json_decode($data, true);
        
        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";
            
            $this->db = $this->load->database ( $config, true );
            
            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;
            
            
            //========================= checking if payment already saved START
            $tbl_invoices_register = 'bog_invoice2payment';
            if (isset($data ['bog_invoice_id'])) {
                $bog_invoice_id = $data ['bog_order_id'];
                $query_invoice_exist = $this->db->select('payment_id')->get_where($tbl_invoices_register, array('invoice_id' => $bog_invoice_id))->row();
                if ($query_invoice_exist) {
                    $result = array(
                        "payment_result" => "OK, payment already saved",
                        "payment_id" => $query_invoice_exist->payment_id,
                        "invoice_id" => $bog_invoice_id,
                    );
                    echo json_encode($result);
                    exit();
                }
            }
            //========================= checking if payment already saved FINAL
            
            $payment_type = $this->frontdesk->get_uniteller_payment_type();
            
            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }
            
            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }
            
            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }
            
            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();
                
                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }
                
                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {
                            
                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);
                    
                    $pay_id = $this->pay->fastpayment_c2($cell);
                    
                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);
                    
                    
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array['invoice_id'] = isset($data ['monobank_invoice_id']) ? $data ['monobank_invoice_id'] : null;
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
                        //                         $cancel_data = array();
                        //                         $cancel_data["description"] = "";
                        //                         $cancel_data["res_id"] = $group_res_id;
                        //                         $cancel_data["charge"] = 0;
                        //                         $cancel_data["guestbe_request"] = 1;
                        //                         $cancel_data["status"] = 5;
                        //                         $this->cancel->Insert($data);
                    }
                    
                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {
                
                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();
                
                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array['invoice_id'] = isset($data ['monobank_invoice_id']) ? $data ['monobank_invoice_id'] : null;
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);
                    
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);
                    
                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }
            
            if ($pay_id > 0) {
                
                if (isset($monobank_invoice_id)) {
                    $this->db->insert($tbl_invoices_register, array('invoice_id' => $monobank_invoice_id, 'payment_id' => $pay_id));
                }
                
                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);
                
                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");
                
                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function przelewy24_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                     if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function transbank_payment_update(){

        $data = file_get_contents("php://input");
        $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            if (isset($data['hms_res_id']) && $data['hms_res_id'] != 0) {
                $reservation_id = $data['hms_res_id'];
                $intgroupid = 0;
            }else{
                $reservation_id = 0;
                $intgroupid = 0;
                $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
                        //                         $cancel_data = array();
                        //                         $cancel_data["description"] = "";
                        //                         $cancel_data["res_id"] = $group_res_id;
                        //                         $cancel_data["charge"] = 0;
                        //                         $cancel_data["guestbe_request"] = 1;
                        //                         $cancel_data["status"] = 5;
                        //                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array['cc_processor'] = $data ['cc_processor'];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data = array();
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function paypal_payment_update(){

        $data = file_get_contents("php://input");
	    $data = json_decode($data, true);

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }

            $reservation_id = 0;
            $intgroupid = 0;
            $query = $this->db->query ( "SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = ".$data ["dc_reservationid"]. " ORDER BY id DESC LIMIT 0,1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $reservation_id = $row->id;
                $intgroupid = $row->intgroupid;
            }

            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            if ($intgroupid > 0) {
                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                //print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                //print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);

                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);


                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);
                }
            } else {

                $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			                         card_number, card_validity, card_protective_code, create_time, operationtime)
			                         VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			                         '', '', '', '" . $time . "', '" . $time . "')");
                $pay_id = $this->db->insert_id();

                if ($pay_id > 0) {
                    $description_array = array();
                    $description_array["payment_id"] = $data["transID"];
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];
                    $description_array["order_id"] = $data["order_id"];
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($reservation_id);
                }
            }

            if ($pay_id > 0) {

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * SAVE LOG
                 */
                $log_data["s_id"] = $pay_id;
                $log_data["description"] = "all fields";
                // $log_data ["res_id"] = $data ["oid"];
                $log_data["res_id"] = $reservation_id;
                $log_data["amount"] = $data["amount"];
                $this->loger->SaveLog($log_data, "pay", "save");

                $result = array(
                    "payment_result" => "paymentOK",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }else{
                $result = array(
                    "payment_result" => "paymentERROR",
                    "transfer_result" => "unknown"
                );
                $output = json_encode($result);
                print_r($output);
            }
        }
    }

    function stripe_payment_update(){

        $data = $_POST ["order_data"];
        $data = json_decode ( $data, true );

        //print_r($data);
        //die();
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            // echo $db_name;
            // die();
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";

            $this->db = $this->load->database ( $config, true );

            $time = date ( "Y-m-d H:i:s" );
            $user = -1;
            if(isset($_SESSION ['user']["id"])){
                $user = $_SESSION ['user']["id"];
            }
            //$payment_type = 2;

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                } else {
                    echo " - Payment exeption 6839! - ";
                }
            }
            $id_partner = 1;
            $query = $this->db->query ( "SELECT * FROM partners WHERE isdefault = 1" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $id_partner = $row->id;
            }

            $this->db->query ( "INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
			card_number, card_validity, card_protective_code, create_time, operationtime)
			VALUES('".$user."', " . $data ["oid"] . ", " . 0 . ", " . $data ["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
			'', '', '', '" . $time . "', '" . $time . "')" );
            $pay_id = $this->db->insert_id ();

            if($pay_id > 0){
                $description_array = array();
                $description_array["payment_id"] = $pay_id;
                $description_array["amount"] = $data ["amount"];
                $description_array["currency"] = $data ["currency"];
                $description_array["order_id"] = $data ["order_id"];
                $description_array =  json_encode($description_array);
                $this->db->query ( "UPDATE `payment` SET description = '".$description_array."' WHERE id = ".$pay_id);

                /*
                 * UPDATE BALANCE
                 */
                $this->frontdesk->SetReservationBalance($data ["oid"]);

                /*
                 * підтвердження бронювання (скидування avoidtime i duetime в 0)
                 */
                $this->frontdesk->set_reservation_avoidtime($data ["oid"]);

                /*
                 * фіксація вдалої оплати в global_hotelix таблиця order_pending_log (status = 1)
                 */
                $pending_log_data = array();
                $pending_log_data["hotel_id"] = $data ["hms_id"];
                $pending_log_data["reservation_id"] = $data ["oid"];
                $pending_log_data["status"] = 1;
                $this->frontdesk_c2->set_order_pending_log_status($pending_log_data);

                /*
                 * SAVE LOG
                 */
                $log_data ["s_id"] = $pay_id;
                $log_data ["description"] = "all fields";
                $log_data ["res_id"] = $data ["oid"];
                $log_data ["amount"] = $data ["amount"];
                $this->loger->SaveLog ( $log_data, "pay", "save" );

                $result = array (
                    "payment_result" => "paymentOK"
                );
                $output = json_encode ( $result );
                print_r ( $output );
            }
        }
    }

    function stripe_sca_payment_insert()
    {
        $data = $_POST;
        if (isset($data["hms_id"])) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data["hms_id"] . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() != 0) {
                $row = $query->row();
                $db_name = $row->db_name;
            }
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);

            $payment_type = $this->frontdesk->get_uniteller_payment_type();

            if ($payment_type == 0){
                $query = $this->db->query ( "SELECT id FROM payment_types" );
                if ($query->num_rows () > 0) {
                    $row = $query->row ();
                    $payment_type = $row->id;
                }
            }

            $id_partner = $this->db->select('id')
            ->get_where('partners', array(
                'isdefault' => 1
            ))
            ->row()->id;
            $intgroupid = 0;
            //             echo "<pre>";
            //             print_r($data);
            //                 die();
            $hms_reservation_id = $data["reservation_id"];

            // FROM ONLINE MODULE V2
            if (isset($data["dc_reservation_id"])) {
                if ($data["dc_reservation_id"] > 0) {
                    $query = $this->db->query("SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = " . $data["dc_reservation_id"] . " ORDER BY id DESC LIMIT 0,1");
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $hms_reservation_id = $row->id;
                        $intgroupid = $row->intgroupid;
                    }
                }
            }


            // vertex FROM ONLINE MODULE V3
            if ($data["order_id_type"] == "vertex") {
                $query = $this->db->query("SELECT id, intgroupid FROM deskofreservation WHERE ( dc_id = 999 OR dc_id = 31 ) AND dc_reservationid = " . $data["reservation_id"] . " ORDER BY id DESC LIMIT 0,1");
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $hms_reservation_id = $row->id;
                    $intgroupid = $row->intgroupid;
                }
            }
            $stripe_is_pay = $this->db->select('id')
            ->get_where('stripe_payments', array(
                'intent_id' => $data['intent_id'],
                'hms_payment_id >' => 0
            ))
            ->num_rows();
            if($stripe_is_pay > 0){
                $result = array(
                    "insert_payment_result" => "OK"
                );
                echo json_encode($result);
                return;
            }

            if ($intgroupid > 0) {
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();
                foreach ($group_reservations as $cell) {
                    $group_res_id = $cell['id'];
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($group_res_id);
                }

                foreach($group_reservations as $res_ids){
                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($res_ids['id']);
                }

                // ================================================

                $gid = $this->pay->create_grouppayments_id($intgroupid);
                $group_reservations = $this->db->select('id')
                ->get_where('deskofreservation', array(
                    'intgroupid' => $intgroupid
                ))
                ->result_array();
                $s_type = 2;
                $service_type_id = 1;
                $sql = "SELECT deskofreservation.id as res_id, services_main.id as services_id, services_main.amount
                FROM deskofreservation
                INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
                INNER JOIN services_types_main ON  services_types_main.id = services_main.type
                WHERE deskofreservation.deleted = 0 AND deskofreservation.intgroupid = $intgroupid
                GROUP BY res_id";
                // echo $sql ."\n";
                $mass = array();
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $mass[$s_type][$service_type_id][$row->res_id] = $row->amount;
                }
                // echo "<pre>".$data["amount"];
                // print_r($mass);
                $res_info_final = array();
                foreach ($mass as $main_key => $sersicetype) {
                    foreach ($sersicetype as $id_key => $data2refill) {
                        $refillRS = $this->frontdesk_c2->payments_make_refill_param($data2refill, $data["amount"]);
                        foreach ($refillRS as $key => $value) {

                            if (! isset($res_info_final[$key])) {
                                $res_info_final[$key] = array();
                            }
                            array_push($res_info_final[$key], array(
                                'reservation_id' => $key,
                                's_type' => $s_type,
                                'type' => $service_type_id,
                                'operationtime' => date("Y-m-d"),
                                'paymenttype' => $payment_type,
                                'needtopay' => $value,
                                'id_partner' => $id_partner
                            ));
                        }
                    }
                }
                // print_r($res_info_final);
                foreach ($res_info_final as $reservation_id => $cell) {
                    //$services_all_amount = $this->pay->check_services_amount($group_res_id); // перевірка чи сума оплати не перевищує сумму всіх сервісів
                    //if($services_all_amount < $cell['needtopay']){
                        //continue;
                    //}
                    $group_res_id = $reservation_id;
                    $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $group_res_id);


                    $pay_id = $this->pay->fastpayment_c2($cell);

                    $this->pay->insert_grouppaymentsitems($gid, $pay_id);

                    $description_array = array();
                    $description_array["payment_id"] = "";
                    $description_array["amount"] = $data["amount"];
                    $description_array["currency"] = $data["currency"];

                    $description_array["order_id"] = isset($data["dc_reservation_id"]) ? $data["dc_reservation_id"] : $reservation_id;
                    $description_array = json_encode($description_array);
                    $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);
                    if ($pay_id > 0) {
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    } else {
                        /*
                         * виклик ф-ї анулювання.
                         */
//                         $cancel_data = array();
//                         $cancel_data["description"] = "";
//                         $cancel_data["res_id"] = $group_res_id;
//                         $cancel_data["charge"] = 0;
//                         $cancel_data["guestbe_request"] = 1;
//                         $cancel_data["status"] = 5;
//                         $this->cancel->Insert($data);
                    }

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($group_res_id);

                }
            } else {
                // $this->db->query("INSERT INTO `payment` (id_user, reservation_id, clear_pay, amount, id_partner, type, card_type, card_holder,
                // card_number, card_validity, card_protective_code, create_time, operationtime)
                // VALUES('" . $user . "', " . $reservation_id . ", " . 0 . ", " . $data["amount"] . ", '" . $id_partner . "', " . $payment_type . ", '', '',
                // '', '', '', '" . $time . "', '" . $time . "')");
                // $pay_id = $this->db->insert_id();
                $pay_id = 0;

                //$services_all_amount = $this->pay->check_services_amount($hms_reservation_id); // перевірка чи сума оплати не перевищує сумму всіх сервісів
                if ( 1 ) {

                    $insert_payment_arr = array(
                        'id_user' => - 1,
                        'reservation_id' => $hms_reservation_id,
                        'amount' => $data['amount'],
                        'id_partner' => $id_partner,
                        'type' => 5, // ?????????????????????????????????????????????????????????????????? card from stripe, i set as 'internet payment' id = 5
                        'create_time' => date("Y-m-d H:i:s", $data['create_timestamp']),
                        'operationtime' => date("Y-m-d H:i:s"),
                        'description' => ""
                    );
                    $this->db->insert('payment', $insert_payment_arr);
                    $pay_id = $this->db->insert_id();

                    if ($pay_id > 0) {
                        $description_array = array();
                        $description_array["payment_id"] = "";
                        $description_array["amount"] = $data["amount"];
                        $description_array["currency"] = $data["currency"];

                        $description_array["order_id"] = isset($data["dc_reservation_id"]) ? $data["dc_reservation_id"] : $hms_reservation_id;
                        $description_array = json_encode($description_array);
                        $this->db->query("UPDATE `payment` SET description = '" . $description_array . "' WHERE id = " . $pay_id);

                        $this->db->query("UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = " . $hms_reservation_id);
                        /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($hms_reservation_id);

                    /*
                     * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                     */
                    $nopay_action_result = $this->frontdesk_c2->nopay_action($hms_reservation_id);

                    /*
                     * UPDATE BALANCE
                     */
                    $this->frontdesk->SetReservationBalance($hms_reservation_id);
                    }
                }
            }

            if ($pay_id > 0) {


                $json_data = json_encode(array(
                    'amount' => $data['amount'],
                    'currency' => $data['currency'],
                    'order_id' => $hms_reservation_id,
                    'intent_id' => $data['intent_id'],
                    'push_log_id' => $data['push_log_id']
                ));

                $data_sp = array();
                $data_sp['intent_id'] = $data['intent_id'];
                $data_sp['hms_payment_id'] = $pay_id;
                $data_sp['transID'] = 0;
                $data_sp['status'] = 0;
                $data_sp['number'] = $data['hms_id'] . '-' . $hms_reservation_id;
                $data_sp['json'] = $json_data;

                $this->db->insert('stripe_payments', $data_sp);

                // insert user message
                $msg_data = array();
                $msg_data['item_id'] = $hms_reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $hms_reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $msg_data['notify_type'] = 2; // reservation payment
                $msg_data['create_time'] = date('Y-m-d H:i:s');
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * фіксація вдалої оплати в global_hotelix таблиця order_pending_log (status = 1)
                 */
                $pending_log_data = array();
                $pending_log_data["hotel_id"] = $data["hms_id"];
                $pending_log_data["reservation_id"] = $hms_reservation_id;
                $pending_log_data["status"] = 1;
                $this->frontdesk_c2->set_order_pending_log_status($pending_log_data);

                /* SAVE LOG */
                $log_data = array(
                    's_id' => $pay_id,
                    'description' => "all fields",
                    'res_id' => $hms_reservation_id,
                    'amount' => $data["amount"]
                );
                $this->loger->SaveLog($log_data, "pay", "save");
                $result = array(
                    "insert_payment_result" => "OK"
                );
                echo json_encode($result);
            } else {
                $result = array(
                    "insert_payment_result" => "ERROR"
                );
                echo json_encode($result);
            }
        } else {
            // error incoming data
            $result = array(
                "incoming_data" => "ERROR"
            );
            echo json_encode($result);
        }
    }

    function stripe_sca_payment_insert_OLD() {
        $data = $_POST;
        if (isset ( $data ["hms_id"] )) {
            $db_name = "";
            $sql = "SELECT db_name FROM visitka.config WHERE id = '" . $data ["hms_id"] . "'";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () != 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            $config = array ();
            $config ['hostname'] = $this->config->item ( 'visitka_host' );
            $config ['username'] = $this->config->item ( 'visitka_user' );
            $config ['password'] = $this->config->item ( 'visitka_pass' );
            $config ['database'] = $db_name;
            $config ['dbdriver'] = "mysqli";
            $config ['dbprefix'] = "";
            $config ['pconnect'] = FALSE;
            $config ['db_debug'] = TRUE;
            $config ['cache_on'] = FALSE;
            $config ['cachedir'] = "";
            $config ['char_set'] = "utf8";
            $config ['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database ( $config, true );

            $id_partner = $this->db->select('id')->get_where('partners', array('isdefault'=>1))->row()->id;
            $intgroupid = 0;
            switch ($data['order_id_type']) {
                case "hms":
                    $hms_reservation_id = $data['reservation_id'];
                    break;
                case "vertex":
                    $hms_reservation_id = 0;
                    $query = $this->db->query("SELECT id, intgroupid FROM deskofreservation WHERE dc_id = 999 AND dc_reservationid = " . $data["reservation_id"] . " ORDER BY id DESC LIMIT 0,1");
                    if ($query->num_rows() > 0) {
                        $row = $query->row();
                        $hms_reservation_id = $row->id;
                        $intgroupid = $row->intgroupid;
                    }
                    //                     $hms_reservation_id = $this->db->select('id')
                    //                         ->get_where('deskofreservation', array(
                    //                         'dc_id' => 999,
                    //                         'dc_reservationid' => $data['reservation_id']
                    //                     ))
                    //                         ->row()->id;
                    break;
                default:
                    $hms_reservation_id = $data['reservation_id'];
                    break;
            }

            $insert_payment_arr = array(
                'id_user' => -1,
                'reservation_id' => $hms_reservation_id,
                'amount' => $data['amount'],
                'id_partner' => $id_partner,
                'type' => 5,//?????????????????????????????????????????????????????????????????? card from stripe, i set as 'internet payment' id = 5
                'create_time' => date( "Y-m-d H:i:s", $data['create_timestamp']),
                'operationtime' => date ( "Y-m-d H:i:s" ),
                'description' => json_encode(array(
                    'amount' => $data['amount'],
                    'currency' => $data['currency'],
                    'order_id' => $hms_reservation_id,
                    'intent_id' => $data['intent_id'],
                    'push_log_id' => $data['push_log_id']
                ))
            );
            $this->db->insert('payment', $insert_payment_arr);
            $pay_id = $this->db->insert_id ();

            if($pay_id > 0){
                if($intgroupid > 0){
                    $group_reservations = $this->db->select('id')->get_where('deskofreservation', array('intgroupid' => $intgroupid))->result_array();
                    foreach($group_reservations as $cell){
                        $group_res_id = $cell['id'];
                        $this->db->query ( "UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = ".$group_res_id);
                        /*
                         * підтвердження бронювання (скидування avoidtime i duetime в 0)
                         */
                        $this->frontdesk->set_reservation_avoidtime($group_res_id);
                    }
                }else{
                    $this->db->query ( "UPDATE `deskofreservation_needpay` SET is_pay = 1 WHERE reservation_id = ".$hms_reservation_id);
                    /*
                     * підтвердження бронювання (скидування avoidtime i duetime в 0)
                     */
                    $this->frontdesk->set_reservation_avoidtime($hms_reservation_id);
                }



                /*
                 * UPDATE BALANCE
                 */
                $this->frontdesk->SetReservationBalance($hms_reservation_id);


                /*
                 * виклик ф-ї відновлення та переміщення бронювання при успішній оплаті.
                 */
                $nopay_action_result = $this->frontdesk_c2->nopay_action($hms_reservation_id);

                // insert user message
                $msg_data = array();
                $msg_data['reservation_id'] = $hms_reservation_id;
                $msg_data['message'] = "{clt_get_pay}:" . $hms_reservation_id;
                $msg_data['type'] = 1;
                $msg_data['state'] = 1;
                $this->frontdesk_c2->insert_hms_notifications($msg_data);

                /*
                 * фіксація вдалої оплати в global_hotelix таблиця order_pending_log (status = 1)
                 */
                $pending_log_data = array();
                $pending_log_data["hotel_id"] = $data ["hms_id"];
                $pending_log_data["reservation_id"] = $hms_reservation_id;
                $pending_log_data["status"] = 1;
                $this->frontdesk_c2->set_order_pending_log_status($pending_log_data);

                /* SAVE LOG */
                $log_data = array(
                    's_id' => $pay_id,
                    'description' => "all fields",
                    'res_id' => $hms_reservation_id,
                    'amount' => $data["amount"]
                );
                $this->loger->SaveLog ( $log_data, "pay", "save" );
                $result = array (
                    "insert_payment_result" => "OK"
                );
                echo json_encode ( $result );
            }else{
                $result = array (
                    "insert_payment_result" => "ERROR"
                );
                echo json_encode ( $result );
            }
        }else {
            //error incoming data
            $result = array (
                "incoming_data" => "ERROR"
            );
            echo json_encode ( $result );
        }
    }

    function integration2($host = "") {
        // if ($host == "")
        $host = $_SERVER ["HTTP_HOST"];
        // echo "<pre>";
        // print_r($_SERVER);
        // die();
        $data = array ();
        $booking_host = $this->config->item ( 'booking_host' );
        $booking_user = $this->config->item ( 'booking_user' );
        $booking_pass = $this->config->item ( 'booking_pass' );
        $link = mysqli_connect ( $this->config->item ( 'visitka_host' ),
            $this->config->item ( 'visitka_user' ),
            $this->config->item ( 'visitka_pass' ) );
        $query = "SELECT * FROM visitka.config WHERE host LIKE '$host'";
        $result = mysqli_query ( $link, $query );
        while ( $row = mysqli_fetch_array ( $result ) ) {
            // $base_url = "https://".$row["base_url"];
            $hotel_id = $row ["id"];
            $host = $row ["host"];
            $data ["hotel_id"] = $row ["id"];
            $data ["host"] = $row ["host"];
        }
        mysqli_close ( $link );
        $category_images_mass = array ();
        $i = 1;
        $sql = "SELECT * FROM categories_images";
        $query = $this->db->query ( $sql );
        foreach ( $query->result_array () as $row ) {
            $category_images_mass [$i] = $row;
            $i ++;
        }

        $hotel_images_mass = array ();
        $i = 1;
        $sql = "SELECT * FROM hotel_images";
        $query = $this->db->query ( $sql );
        foreach ( $query->result_array () as $row ) {
            $hotel_images_mass [$i] = $row;
            $i ++;
        }

        // echo "<pre>";
        // print_r($category_images_mass);
        // die();

        $List = array ();
        $sql = "SELECT * FROM gatewayoforder";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $value = "";
            switch ($row->name) {
                case "dealerID" :
                    $value = $row->value;
                    break;
                case "categoryID" :
                    $value = $row->value;

                    break;
                case "rateID" :

                    break;
                case "avoidtime" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                    /*
                     * case "ip_key": $value = $row->str_value; $data[$row->name] = $value; break;
                     */
                case "cityID" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "currencyID" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "regionID" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "hotel_name" :
                    $value = $row->str_text;
                    $data [$row->name] = $value;
                    break;
                case "email" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "phone" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "upc_allowordertype" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "upc_daily_prepayment" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "fast_allowordertype" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "upc_signature" :
                    $value = $row->str_text;
                    $data [$row->name] = $value;
                    break;
                case "server_certificate" :
                    $value = $row->str_text;
                    $data [$row->name] = $value;
                    break;
                case "upc_merchantid" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "upc_terminalid" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "upc_host" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "upc_host" :
                    $value = $row->str_value;
                    $data [$row->name] = $value;
                    break;
                case "allowordertype3" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "rating" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "onlypersonalpage" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_1" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_2" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_3" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_4" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_5" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_6" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_7" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_8" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_9" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_10" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_11" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "sf_12" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                case "additionalplaces" :
                    $value = $row->value;
                    $data [$row->name] = $value;
                    break;
                default :
                    if ($row->name != "additional_rateID") {
                        $value = $row->str_text;
                        $data [$row->name] = $value;
                    }
                    break;
            }
        }
        // echo "<pre>";
        // print_r($data);
        // echo $booking_host." ".$booking_user." ".$booking_pass;
        // die();

        $link = mysqli_connect ( $booking_host, $booking_user, $booking_pass );
        $sql_insert = "(";
        $sql_update = "";
        $count_data = count ( $data );
        $i = 1;
        $arr_keys = array_keys ( $data );
        foreach ( $arr_keys as $key ) {
            if ($i == $count_data) {
                $sql_insert .= $key;
            } else {
                $sql_insert .= $key . ", ";
            }
            $i ++;
        }
        $sql_insert .= ") VALUES (";
        $i = 1;
        foreach ( $arr_keys as $key ) {
            if ($i == $count_data) {
                $sql_insert .= "'" . addslashes ( $data [$key] ) . "' ";
            } else {
                $sql_insert .= "'" . addslashes ( $data [$key] ) . "', ";
            }
            $i ++;
        }
        $sql_insert .= ") ";
        $i = 1;
        foreach ( $arr_keys as $key ) {
            if ($i == $count_data) {
                $sql_update .= $key . " = '" . addslashes ( $data [$key] ) . "' ";
            } else {
                $sql_update .= $key . " = '" . addslashes ( $data [$key] ) . "', ";
            }
            $i ++;
        }

        $result = mysqli_query ( $link, "SET NAMES 'utf8'" );

        $sql = "INSERT INTO booking_otelms.hotels " . $sql_insert . "ON DUPLICATE KEY UPDATE " . $sql_update;
        $result = mysqli_query ( $link, $sql );
        // echo $sql;
        // die();
        $sql = "DELETE FROM booking_otelms.categories_images WHERE 	hotel_id = " . $data ["hotel_id"];
        $result = mysqli_query ( $link, $sql );

        for($i = 1; $i <= count ( $category_images_mass ); $i ++) {
            $sql = "INSERT INTO booking_otelms.categories_images (category_id,hotel_id,img_small,img_medium,id_position)
			VALUES ( '" . $category_images_mass [$i] ["category_id"] . "',  '" . $data ["hotel_id"] . "',
			 '" . $category_images_mass [$i] ["img_small"] . "',  '" . $category_images_mass [$i] ["img_medium"] . "',
			 '" . $category_images_mass [$i] ["id_position"] . "')";
            $result = mysqli_query ( $link, $sql );
        }

        $sql = "DELETE FROM booking_otelms.hotel_images WHERE 	hotel_id = " . $data ["hotel_id"];
        $result = mysqli_query ( $link, $sql );

        for($i = 1; $i <= count ( $hotel_images_mass ); $i ++) {
            if (isset ( $hotel_images_mass [$i] ["classic_img"] ) && $hotel_images_mass [$i] ["classic_img"] != 0) {
                $sql = "INSERT INTO booking_otelms.hotel_images (hotel_id,img_small,img_medium,classic_img)
			VALUES ( '" . $data ["hotel_id"] . "',
			 '" . $hotel_images_mass [$i] ["img_small"] . "',  '" . $hotel_images_mass [$i] ["img_medium"] . "',
			   '" . $hotel_images_mass [$i] ["classic_img"] . "')";
            } else {
                $sql = "INSERT INTO booking_otelms.hotel_images (hotel_id,img_small,img_medium,type)
			VALUES ( '" . $data ["hotel_id"] . "',
			 '" . $hotel_images_mass [$i] ["img_small"] . "',  '" . $hotel_images_mass [$i] ["img_medium"] . "',
			   '" . $hotel_images_mass [$i] ["type"] . "')";
            }
            $result = mysqli_query ( $link, $sql );
        }

        mysqli_close ( $link );

        $url = "http://" . $this->config->item ( 'booking_foto_link' ) . "/bookit/MakeFoto/" . $data ["hotel_id"];
        // require_once ('JSON.php');
        // $json = new Services_JSON ( );
        $result = $this->CurlPlug ( $url );
        // $result = array("s"=>33);
        // $output = $json->encode ( $result );
        // print_r ( $output );
        // die($result);
    }
    function ReservationDelete($id_reservation) {
        $this->frontdesk->DeleteReservation ( $id_reservation );
    }
    function ReservationCancel($id_reservation) {
        $data = array ();
        $data ["description"] = "";
        $data ["res_id"] = $id_reservation;
        $data ["charge"] = 0;
        $data ["guestbe_request"] = 1;
        $data ["status"] = 5;
        $this->cancel->Insert ( $data );

        $data_notify = array ();
        $data_notify ['resid'] = $id_reservation;
        $data_notify ['dcname'] = "Guestbe.com";
        $data_notify ['status'] = "Cancel";
        $this->dc_model->send_notifyarray ( $data_notify, false );
    }
    function CurlPlug($url) {
        $ch = curl_init ();
        $POSTFIELDS = "";
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        // curl_setopt ( $ch, CURLOPT_FAILONERROR, 1 );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_TIMEOUT, 7 );
        // curl_setopt ( $ch, CURLOPT_SSL_VERIFYHOST, FALSE );
        // curl_setopt($ch, CURLOPT_COOKIEJAR, "/tmp/cookieFileName");
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        // curl_setopt ( $ch, CURLOPT_POST, 1 );
        // curl_setopt ( $ch, CURLOPT_POSTFIELDS, $POSTFIELDS );
        // curl_setopt ($ch, CURLOPT_INTERFACE, "65.61.130.234");
        $result = curl_exec ( $ch ); // execute the curl command
        if (curl_errno ( $ch )) {
            echo 'Curl error: ' . curl_error ( $ch );
        }
        curl_close ( $ch );
        unset ( $ch );
        return $result;
    }
    function save_cancel() {
        // echo "<pre>";
        require_once ('JSON.php');
        $json = new Services_JSON ();
        // print_r($_POST);
        // die();

        $data = $_POST ["order_data"];
        $data = $json->decode ( $data );
        $data = objectToArray ( $data );

        $guest_id = 0;
        $email = "";
        $cancellation_policy_id = 0;
        $dc_totalprice = 0;
        $sql = "SELECT deskofreservation.guest_id, guests.email, deskofreservation.datein,
		deskofreservation.checkintime, rate.cancellation_policy_id as cancellation_policy_id, deskofreservation.dc_totalprice
		FROM deskofreservation
		INNER JOIN guests ON deskofreservation.guest_id = guests.id
		INNER JOIN rate ON rate.id = deskofreservation.price_type
		WHERE deskofreservation.id = " . $data ["res_id"];
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $guest_id = $row->guest_id;
            $email = $row->email;
            $datein = $row->datein;
            $checkintime = $row->checkintime;
            $dc_totalprice = $row->dc_totalprice;
            $cancellation_policy_id = $row->cancellation_policy_id;
        }

        // get fine
        $reservation_day_prices = $this->frontdesk->getpricecalculation(array(), $data ["res_id"]);

        $data_charge = array();
        $data_charge["amount"] = $dc_totalprice;
        $data_charge["reservation_day_prices"] = $reservation_day_prices;
        $data_charge["datein"] = $datein;
        $data_charge["checkintime"] = $checkintime;
        $data_charge["cancel_date"] = date("Y-m-d H:i:s");
        $data_charge["cancellation_policy_id"] = $cancellation_policy_id;

        $data["charge"] = $this->frontdesk_c2->get_fine_value($data_charge);

        $this->cancel->Insert ( $data );

        $data_notify = array ();
        $data_notify ["hms_reservation_id"] = $data ["res_id"];
        $data_notify ['resid'] = $data ["res_id"];
        $data_notify ['dcname'] = "Guestbe.com";
        $data_notify ['dcname'] = $data ["dcname"];
        $data_notify ['status'] = "cancel";
        $this->dc_model->send_notifyarray ( $data_notify, false );

        // send email to client

        $id_template_bookcancel = $this->monline_module->get_id_template_bookcancel();
        $id_template_bookcancel_isglobal = $this->monline_module->get_id_template_bookcancel_isglobal();

        $client_data_email = array();
        $client_data_email ["reservation_id"] = $data ["res_id"];
        $client_data_email ["guest_id"] = $guest_id;
        $client_data_email ["send_id_template"] = $id_template_bookcancel;
        $client_data_email ["location_type"] = "local";
        if($id_template_bookcancel_isglobal == 1){
            $client_data_email ["location_type"] = "global";
        }
        $client_data_email ["send_email"] = $email;

        $this->formsprinter_model_v2->send_template_toemail_curl($client_data_email, false, 1);
        
    }
    function getreservationstatus($reservation_id = 0) {
        $arr = array ();
        $status = "";
        $description = "";
        $amount = "";
        $discount = "";
        $id = 0;
        $query = $this->db->query ( "SELECT services_main.description, services_main.amount FROM  services_main
		INNER JOIN deskofreservation ON deskofreservation.id = services_main.reservation_id
		WHERE deskofreservation.id = " . $reservation_id . " AND services_main.type = 2" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $description = $row->description;
            $amount = $row->amount;
        }

        $query = $this->db->query ( "SELECT deskofreservation.discount, statusofreservation.name, statusofreservation.id FROM statusofreservation
		INNER JOIN deskofreservation ON deskofreservation.status = statusofreservation.id
		WHERE deskofreservation.id = " . $reservation_id );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $status = $row->name;
            $discount = $row->discount;
            $id = $row->id;
        }
        $arr ['status'] = $status;
        $arr ['cancel_description'] = $description;
        $arr ['otelms_amount'] = $amount;
        $arr ['otelms_discount'] = $discount;
        $arr ['status_id'] = $id;
        $output = json_encode ( $arr );
        print_r ( $output );
    }
    function Getreservation_data($reservation_id = 0, $get_services = 0) {
        $arr = array ();

        $cancel = 0;
        $query = $this->db->query ( "SELECT cancel FROM deskofreservation WHERE id = " . $reservation_id );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $cancel = $row->cancel;
        }

        $select = "AND services_main.type = 1";
        if($cancel == 1){
            $select = "AND services_main.type = 2";
        }

        $query = $this->db->query ( "SELECT deskofreservation.datein, deskofreservation.dateout, deskofreservation.cancel,
		categories.shortname, guests.lastname, guests.firstname, deskofreservation.checkintime, deskofreservation.checkouttime,
		guests.email, guests.phone, guests.firstname, deskofreservation.amount, categories.property_id,
		deskofreservation.date, deskofreservation.dc_date, deskofreservation.dc_time, deskofreservation.dc_totalprice,
		services_main.amount as services_main_amount, services_main.type as services_main_type,
		services_main.time as services_main_time,
		SUM(payment.amount) as payment_amount, rate.caption as rate_name, rate.cancellation_policy_id as cancellation_policy_id,
		deskofreservation.price_type as rate_id, categories.id as category_id
		FROM deskofreservation
		INNER JOIN guests ON guests.id  = deskofreservation.guest_id
		INNER JOIN rooms ON rooms.id  = deskofreservation.room_id
		INNER JOIN categories ON  categories.id  = rooms.category_id
		INNER JOIN rate ON rate.id  = deskofreservation.price_type
		INNER JOIN services_main ON services_main.reservation_id  = deskofreservation.id
		LEFT JOIN payment ON payment.reservation_id = deskofreservation.id
		WHERE deskofreservation.id = " . $reservation_id . " ".$select." GROUP BY deskofreservation.id" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $arr ['datein'] = $row->datein;
            $arr ['dateout'] = $row->dateout;
            $arr ['checkintime'] = $row->checkintime;
            $arr ['checkouttime'] = $row->checkouttime;
            $arr ['category_name'] = $row->shortname;
            $arr ['guest_name'] = $row->firstname . " " . $row->lastname;
            $arr ['firstname'] = $row->firstname;
            $arr ['lastname'] = $row->lastname;
            $arr ['email'] = $row->email;
            $arr ['phone'] = $row->phone;
            $arr ['amount'] = $row->amount;
            $arr ['services_main_type'] = $row->services_main_type;
            $arr ['services_main_amount'] = $row->services_main_amount;
            $arr ['property_id'] = $row->property_id;
            $arr ['date'] = $row->date;
            $arr ['dc_date'] = $row->dc_date;
            $arr ['dc_time'] = $row->dc_time;
            $arr ['payment_amount'] = $row->payment_amount;
            $arr ['rate_name'] = $row->rate_name;
            $arr ['cancel'] = $row->cancel;
            $arr ['category_id'] = $row->category_id;
            $arr ['rate_id'] = $row->rate_id;

            // get_fine value
            if ( $row->cancellation_policy_id > 0 && $cancel == 0) {
                $reservation_day_prices = $this->frontdesk->getpricecalculation(array(), $reservation_id);
                $data = array();

                $data["amount"] = $row->dc_totalprice;
                $data["reservation_day_prices"] = $reservation_day_prices;
                $data["datein"] = $row->datein;
                $data["checkintime"] = $row->checkintime;
                $data["cancel_date"] = date("Y-m-d H:i:s");
                $data["cancellation_policy_id"] = $row->cancellation_policy_id;

                $fine = $this->frontdesk_c2->get_fine_value($data);

                $arr ['fine'] = $fine;
                //echo $row->amount." ".$fine;
            }

            if($cancel == 1){
                $arr ['fine'] = $row->services_main_amount;
            }
        }

        if ($get_services == 1) {
            $ServicesList = array();
            $query2 = $this->db->query("SELECT services_types.name as services_name,
		      services.id as services_id, services.action_time as services_action_time,
		      services.count as services_count, services.description as services_description,
		      services.amount, services.price
		      FROM deskofreservation
		      INNER JOIN guests ON deskofreservation.guest_id=guests.id
		      INNER JOIN services ON services.reservation_id = deskofreservation.id
		      INNER JOIN  services_types ON  services_types.id = services.type
		      WHERE deskofreservation.id = " . $reservation_id . "
		      ORDER by services.action_time ASC");
            foreach ($query2->result() as $row2) {
                array_push($ServicesList, array(
                    'services_id' => $row2->services_id,
                    'services_name' => $row2->services_name,
                    'services_description' => $row2->services_description,
                    'services_count' => $row2->services_count,
                    'services_unit_amount' => $this->frontdesk->showcurrency($row2->price),
                    'services_summ' => $this->frontdesk->showcurrency($row2->services_count * $row2->price),
                    'services_summ_calc' => $row2->services_count * $row2->price
                ));
            }

            $arr ['services_list'] = $ServicesList;
        }



        $output = json_encode ( $arr );
        print_r ( $output );
    }

    function Get_ta_reservations_data() {
        $ta_res_id = $_POST['ta_res_id'];
        $tbl_ta_to_hms_ids = 'ta_reservations';
        $reservation_ids = "";
        $where_reservations_in_arr_str = "";
        $res_or_group_id = $this->db->get_where($tbl_ta_to_hms_ids, array('id'=>$ta_res_id))->row();
        if (!is_null($res_or_group_id->hms_group_id)){
            $query_result = $this->db->select('id')->get_where('deskofreservation', array('intgroupid'=>$res_or_group_id->hms_group_id))->result();
            foreach ($query_result as $res_data) {
                $reservation_ids .= $res_data->id.', ';
            }
            $reservation_ids = substr($reservation_ids, 0, -2);
        }else{
            $reservation_ids = $res_or_group_id->hms_res_id;
        }
        $where_reservations_in_arr_str = " t1.id IN ($reservation_ids) ";
        $sql = "SELECT COUNT(1) as rooms_quantity, t1.datein, t1.dateout, t1.checkintime, t1.checkouttime, t1.cancel, t1.date, SUM(t1.amount) as amount,
        t2.lastname, t2.firstname, t2.email, t2.phone, t2.firstname,
        t3.id as category_id, t3.property_id,
        t4.property_name_lat,	t4.street_lat,	t4.additional_information_lat,	t4.city_lat, t4.state_lat,
        t5.NAME_LAT as country
        FROM deskofreservation as t1
        JOIN guests as t2 ON t2.id  = t1.guest_id
        JOIN rooms ON rooms.id  = t1.room_id
        JOIN categories as t3 ON  t3.id  = rooms.category_id
        JOIN property_information as t4 ON t4.id = t3.property_id
        JOIN global_fms_base.dict_country as t5 ON t5.id = t4.country
        WHERE $where_reservations_in_arr_str";
        $query_res = $this->db->query ($sql)->row_array();

        // 		if ($query->num_rows () > 0) {
        // 			$row = $query->row ();
        // 			$reservation ['datein'] = $row->datein;
        // 			$reservation ['dateout'] = $row->dateout;
        // 			$reservation ['checkintime'] = $row->checkintime;
        // 			$reservation ['checkouttime'] = $row->checkouttime;
        // 			$reservation ['category_name'] = $row->shortname;
        // 			$reservation ['guest_name'] = $row->firstname . " " . $row->lastname;
        // 			$reservation ['firstname'] = $row->firstname;
        // 			$reservation ['lastname'] = $row->lastname;
        // 			$reservation ['email'] = $row->email;
        // 			$reservation ['phone'] = $row->phone;
        // 			$reservation ['amount'] = $row->amount;
        // 			$reservation ['services_main_type'] = $row->services_main_type;
        // 			$reservation ['services_main_amount'] = $row->services_main_amount;
        // 			$reservation ['property_id'] = $row->property_id;
        // 			$reservation ['date'] = $row->date;
        // 			$reservation ['dc_date'] = $row->dc_date;
        // 			$reservation ['dc_time'] = $row->dc_time;
        // 			$reservation ['payment_amount'] = $row->payment_amount;
        // 			$reservation ['rate_name'] = $row->rate_name;
        // 			$reservation ['cancel'] = $row->cancel;
        // 			$reservation ['category_id'] = $row->category_id;
        // 			$reservation ['rate_id'] = $row->rate_id;
        // 		}
        echo json_encode($query_res);
    }

    function Get_tvg_reservations_data() {
        $tvg_res_id = $_POST['tvg_res_id'];
        $tbl_tvg_to_hms_ids = 'tvg_reservations';
        $reservation_ids = "";
        $where_reservations_in_arr_str = "";
        $res_or_group_id = $this->db->get_where($tbl_tvg_to_hms_ids, array('id'=>$tvg_res_id))->row();
        if (!is_null($res_or_group_id->hms_group_id)){
            $query_result = $this->db->select('id')->get_where('deskofreservation', array('intgroupid'=>$res_or_group_id->hms_group_id))->result();
            foreach ($query_result as $res_data) {
                $reservation_ids .= $res_data->id.', ';
            }
            $reservation_ids = substr($reservation_ids, 0, -2);
        }else{
            $reservation_ids = $res_or_group_id->hms_res_id;
        }
        $where_reservations_in_arr_str = " t1.id IN ($reservation_ids) ";
        $sql = "SELECT COUNT(1) as rooms_quantity, t1.datein, t1.dateout, t1.checkintime, t1.checkouttime, t1.cancel, t1.date, SUM(t1.amount) as amount,
        t2.lastname, t2.firstname, t2.email, t2.phone, t2.firstname,
        t3.id as category_id, t3.property_id,
        t4.property_name_lat,	t4.street_lat,	t4.additional_information_lat,	t4.city_lat, t4.state_lat,
        t5.NAME_LAT as country
        FROM deskofreservation as t1
        JOIN guests as t2 ON t2.id  = t1.guest_id
        JOIN rooms ON rooms.id  = t1.room_id
        JOIN categories as t3 ON  t3.id  = rooms.category_id
        JOIN property_information as t4 ON t4.id = t3.property_id
        JOIN global_fms_base.dict_country as t5 ON t5.id = t4.country
        WHERE $where_reservations_in_arr_str";
        $query_res = $this->db->query ($sql)->row_array();
        echo json_encode($query_res);
    }

    function Confirm_reservation($reservation_id = 0) {
        if ($reservation_id != 0) {
            $query = $this->db->query ( "UPDATE deskofreservation SET isconffirmed = 1 WHERE id = " . $reservation_id );
        }
        /*
         * $arr = array(); $arr['status'] = $status; $arr['status_id'] = $id; $output = json_encode ( $arr ); print_r ( $output );
         */
    }
    function testfreerooms() {
        $datein = "2013-01-8";
        $dateout = "2013-01-14";
        $this->frontdesk->GetFreeRooms ( $datein, $dateout );
    }
    function InsertOrderId($data) {

        // $data = $_POST ["order_data"];
        // $data = json_decode ( $data );
        // $data = objectToArray ( $data );
        $query = $this->db->query ( "SELECT DATABASE() as db_name" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $db_name = $row->db_name;
        }

        if (! $link = mysqli_connect ( $this->config->item ( 'visitka_host' ),
            $this->config->item ( 'visitka_user' ),
            $this->config->item ( 'visitka_pass' ) ))
            die ( 'ERROR MySQL' );
            mysqli_select_db ( $link, "visitka" );

            $result = mysqli_query ( $link, "SELECT id, host FROM  config WHERE db_name LIKE '" . $db_name . "'" );
            while ( $row_visitka = mysqli_fetch_array ( $result ) ) {
                $hotel_id = $row_visitka ["id"];
                $host = $row_visitka ["host"];
            }
            mysqli_close ( $link );
            if (! $link = mysqli_connect ( $this->config->item ( 'visitka_host' ),
                $this->config->item ( 'visitka_user' ),
                $this->config->item ( 'visitka_pass' ) ))
                die ( 'ERROR MySQL' );
                mysqli_select_db ( $link, "global_hotelix" );
                $sql = "UPDATE double_reservation SET order_id = " . $data ["order_id"] . " WHERE hotel_id = " . $hotel_id . " AND reservation_id = " . $data ["reservation_id"];
                // echo $sql;
                $result = mysqli_query ( $link, $sql );
                mysqli_close ( $link );
    }
    function GetFreeRooms($hotel_id, $datein, $dateout) {
        $this->output->enable_profiler ( TRUE );
        // $datein = "2012-01-01";
        // $dateout = "2013-07-01";
        // $vhost = "zmis.hottour24.com.ua";
        $query = $this->db->query ( "SELECT id, db_name, host FROM visitka.config
            WHERE id = $hotel_id" );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            // $hotel_id = $row->id;
            $vhost = $row->host;
        } else {
            die ();
        }

        $data = $this->Wubook->GetFreeRooms_Gate ( $datein, $dateout, $vhost );
        // echo "<pre>";
        // print_r($data);
        // die();
        $output = json_encode ( $data );
        $url = "http://rconnect-dev.guestbe.com/gate/updatedata/$hotel_id";
        $result = $this->Curl_model->CurlPlugMass ( $output, $url );
        echo $result;
    }
    function hosts_freerooms($datein = "2012-01-01", $dateout = "2013-04-01") {
        $this->Wubook->hosts_freerooms ( $datein, $dateout );
    }
    public function test() {
        die("dropped 13089");
        $data = array ();
        $this->load->view ( 'test_form', $data );
    }
    function loaddesk() {
        return;
        $worktime_start = time ( );
        $post = $_POST ["order_data"];
        $post = json_decode ( $post );
        $post = objectToArray ( $post );
        $intdatein = $post ["intdatein"];
        $intdateout = $post ["intdateout"];

        $rate_ID = 0;
        $additionalrate_ID = 0;

        $rate_restrictID = 0;
        $additionalrate_restrictID = 0;

        $query = $this->db->query ( "SELECT value FROM gatewayoforder_personal WHERE name = 'rateID'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();

            $rate_ID = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM gatewayoforder_personal WHERE name = 'additional_rateID'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();

            $additionalrate_ID = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM gatewayoforder_personal WHERE name = 'rate_restrictID'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();

            $rate_restrictID = $row->value;
        }

        $query = $this->db->query ( "SELECT value FROM gatewayoforder_personal WHERE name = 'additionalrate_restrictID'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();

            $additionalrate_restrictID = $row->value;
        }

        $categories_rooms_all = array ();

        $sql = "SELECT categories.id, categories.name, COUNT( 1 ) AS count_rooms FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id

		WHERE rooms.is_active = 1 AND categories.is_active = 1 AND categories.web_booking = 1 GROUP BY rooms.category_id";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                for($i = $intdatein; $i <= $intdateout; $i ++) {
                    $date_year = date ( "Y", $i * 86400 );
                    $date_day = date ( "d", $i * 86400 );
                    $date_month = date ( "m", $i * 86400 );

                    $categories_rooms_all [$row->id] ["free_day"] [$i] ["cell"] = "-";
                    $categories_rooms_all [$row->id] ["free_day"] [$i] ["date_year"] = $date_year;
                    $categories_rooms_all [$row->id] ["free_day"] [$i] ["date_day"] = $date_day;
                    $categories_rooms_all [$row->id] ["free_day"] [$i] ["date_month"] = $date_month;
                }
                $categories_rooms_all [$row->id] ["c_name"] = stripslashes ( $row->name );
                $categories_rooms_all [$row->id] ["category_id"] = $row->id;
                $categories_rooms_all [$row->id] ["count_rooms"] = $row->count_rooms;
            }
        }

        // echo "<pre>";
        // print_r($categories_rooms_all);

        $categories_rooms_deskofdays_intdate = array ();
        $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_rooms FROM `rooms`
        INNER JOIN categories ON categories.id = rooms.category_id
        INNER JOIN deskofdays ON deskofdays.room_id = rooms.id
        INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
        WHERE deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
        GROUP BY deskofdays.intdate, rooms.category_id";

        // echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $categories_rooms_deskofdays_intdate [$row->id] ["days"] [$row->intdate] ["notfree_count"] = $row->count_rooms;
            }
        }

        // print_r ( $categories_rooms_deskofdays_intdate );
        $select = "";
        if ($rate_restrictID != 0) {
            $select .= " AND (rate_id = " . $rate_restrictID . " ";
        }

        if ($additionalrate_restrictID != 0) {
            if ($rate_restrictID != 0) {
                $select .= " OR rate_id = " . $additionalrate_restrictID . ") ";
            } else {
                $select .= " AND rate_id = " . $additionalrate_restrictID . " ";
            }
        } else {
            if ($rate_restrictID != 0) {
                $select .= ") ";
            }
        }

        $deskofrate_intdate = array ();

        if (($rate_restrictID == 0 and $additionalrate_restrictID == 0) || ($additionalrate_ID != 0 and $additionalrate_restrictID == 0) || ($rate_ID != 0 and $rate_restrictID == 0)) {
            // echo "++++++++++++++++++";
        } else {
            $sql = "SELECT deskofrate.* FROM `deskofrate`
            INNER JOIN categories ON categories.id = deskofrate.category_id
            WHERE deskofrate.intdate >= $intdatein AND deskofrate.intdate <= $intdateout $select
            ";

            // echo $sql;

            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $deskofrate_intdate [$row->category_id] [$row->rate_id] ["days"] [$row->intdate] ["minstaythrought"] = $row->minstaythrought;
                    $deskofrate_intdate [$row->category_id] [$row->rate_id] ["days"] [$row->intdate] ["closed"] = $row->closed;
                }
            }
        }
        // echo "<pre>";
        // print_r($deskofrate_intdate);
        // die();
        $array_category_keys = array_keys ( $categories_rooms_all );
        foreach ( $array_category_keys as $category ) {
            for($i = $intdatein; $i <= $intdateout; $i ++) {
                if (isset ( $categories_rooms_deskofdays_intdate [$category] ["days"] [$i] ["notfree_count"] )) {
                    $free_rooms = $categories_rooms_all [$category] ["count_rooms"] - $categories_rooms_deskofdays_intdate [$category] ["days"] [$i] ["notfree_count"];
                    if ($free_rooms > 0) {
                        $free_rooms_bool = "+";
                        $free_rooms_tdstyle = "rooms-open";
                    } else {
                        $free_rooms_bool = "-";
                        $free_rooms_tdstyle = "rooms-close";
                    }
                } else {
                    $free_rooms_bool = "+";
                    $free_rooms_tdstyle = "rooms-open";
                }
                if ($rate_restrictID != 0 and $additionalrate_restrictID == 0) {
                    if (isset ( $deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] )) {
                        if ($deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["minstaythrought"] != 0) {
                            $free_rooms_bool = $deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["minstaythrought"];
                            $free_rooms_tdstyle = "min";
                        }
                        if ($deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["closed"] != 0) {
                            $free_rooms_bool = "-";
                            $free_rooms_tdstyle = "rooms-close";
                        }
                    }
                }
                if ($additionalrate_restrictID != 0 and $rate_restrictID == 0) {
                    if (isset ( $deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] )) {
                        if ($deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["minstaythrought"] != 0) {
                            $free_rooms_bool = $deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["minstaythrought"];
                            $free_rooms_tdstyle = "min";
                        }
                        if ($deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["closed"] != 0) {
                            $free_rooms_bool = "-";
                            $free_rooms_tdstyle = "rooms-close";
                        }
                    }
                }
                if ($additionalrate_restrictID != 0 and $rate_restrictID != 0) {
                    if (isset ( $deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ) and isset ( $deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] )) {
                        if (($deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["minstaythrought"] != 0) and ($deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["minstaythrought"] != 0)) {
                            if ($deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["minstaythrought"] > $deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["minstaythrought"]) {
                                $free_rooms_bool = $deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["minstaythrought"];
                            } else {
                                $free_rooms_bool = $deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["minstaythrought"];
                            }
                            $free_rooms_tdstyle = "min";
                        }
                        if (($deskofrate_intdate [$category] [$additionalrate_restrictID] ["days"] [$i] ["closed"] != 0) and ($deskofrate_intdate [$category] [$rate_restrictID] ["days"] [$i] ["closed"] != 0)) {
                            $free_rooms_bool = "-";
                            $free_rooms_tdstyle = "rooms-close";
                        }
                    }
                }
                /*
                 * if (isset ( $deskofrate_intdate [$category] ["days"] [$i] )) { if ($deskofrate_intdate [$category] ["days"] [$i] ["minstaythrought"] != 0) { $free_rooms_bool = $deskofrate_intdate [$category] ["days"] [$i] ["minstaythrought"]; $free_rooms_tdstyle = "min"; } if ($deskofrate_intdate [$category] ["days"] [$i] ["closed"] != 0) { $free_rooms_bool = "-"; $free_rooms_tdstyle = "rooms-close"; } }
                 */
                $categories_rooms_all [$category] ["free_day"] [$i] ["cell"] = $free_rooms_bool;
                $categories_rooms_all [$category] ["free_day"] [$i] ["cellstyle"] = $free_rooms_tdstyle;
            }
        }
        // echo "<pre>";
        // print_r ( $categories_rooms_all );
        $output = json_encode ( $categories_rooms_all );
        // print_r ( $output );
        $worktime_end = time();
        $worktime = $worktime_end - $worktime_start;
        $sql = "INSERT INTO global_hotelix_analitycs.freeroom_request(hmsid, funcid, host, worktime, timestamp) VALUES(" . $this->config->item ( 'hotel_id' ) . ", 2, '', '" . $worktime . "', '" . date ( "Y-m-d H:i:s" ) . "')";
        $query = $this->db->query ( $sql );
        echo $output;
    }
    function loaddesk_agent() {
        $post = $_POST ["order_data"];
        $post = json_decode ( $post );
        $post = objectToArray ( $post );
        $intdatein = $post ["intdatein"];
        $intdateout = $post ["intdateout"];
        $agent_id = $post ["agent_id"];
        // echo date ( "Y-m-d", $post ["intdatein"] * 86400 ) . " ";
        // echo date ( "Y-m-d", $post ["intdateout"] * 86400 );
        // echo $agent_id;
        $categories_rooms_all = array ();

        if ($agent_id != "" and $agent_id != 0) {

            $sql = "SELECT categories.id, categories.name, COUNT( 1 ) AS count_rooms FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id

		WHERE rooms.is_active = 1 AND categories.is_active = 1 AND categories.web_booking = 1 GROUP BY rooms.category_id";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    for($i = $intdatein; $i <= $intdateout; $i ++) {
                        $date_year = date ( "Y", $i * 86400 );
                        $date_day = date ( "d", $i * 86400 );
                        $date_month = date ( "m", $i * 86400 );

                        // $categories_rooms_all [$row->id] ["free_day"] [$i]
                        // ["cell"] = "-";
                        $categories_rooms_all [$row->id] ["days"] [$i] ["date_year"] = $date_year;
                        $categories_rooms_all [$row->id] ["days"] [$i] ["date_day"] = $date_day;
                        $categories_rooms_all [$row->id] ["days"] [$i] ["date_month"] = $date_month;

                        // $categories_rooms_all [$row->id] ["free_day"] [$i]
                        // ["c_name"] = $row->name;
                        // $categories_rooms_all [$row->id] ["free_day"] [$i]
                        // ["category_id"] = $row->id;
                        $categories_rooms_all [$row->id] ["days"] [$i] ["count_quota"] = 0;
                        $categories_rooms_all [$row->id] ["days"] [$i] ["cell"] = "-";
                    }
                    $categories_rooms_all [$row->id] ["c_name"] = stripslashes ( $row->name );
                    $categories_rooms_all [$row->id] ["category_id"] = $row->id;
                    // $categories_rooms_all [$row->id] ["count_rooms"] =
                    // $row->count_rooms;
                }
            }

            // echo "<pre>";
            // print_r($categories_rooms_all);

            $categories_rooms_deskofdays_intdate = array ();
            $sql = "SELECT categories.id, deskofdays.intdate, COUNT( 1 ) AS count_quota FROM deskofreservation
            INNER JOIN rooms ON rooms.id = deskofreservation.room_id
            INNER JOIN categories ON categories.id = rooms.category_id
            INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
            WHERE deskofreservation.id_dealer = $agent_id AND deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND deskofreservation.status = 4 AND deskofdays.intdate >= $intdatein AND deskofdays.intdate <= $intdateout
            GROUP BY deskofdays.intdate, rooms.category_id";

            // echo $sql;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result () as $row ) {
                    $categories_rooms_all [$row->id] ["days"] [$row->intdate] ["count_quota"] = $row->count_quota;

                    $categories_rooms_all [$row->id] ["days"] [$row->intdate] ["cell"] = $row->count_quota;
                    // $categories_rooms_all [$category] ["free_day"] [$i]
                    // ["cellstyle"] = $free_rooms_tdstyle;
                }
            }

            // print_r ( $categories_rooms_deskofdays_intdate );

            // echo "<pre>";
            // print_r ( $categories_rooms_all );

            // $this->loaddesk3 ( $post ["intdatein"], $post ["intdateout"] );
            // die ();
        }
        $output = json_encode ( $categories_rooms_all );
        // print_r ( $output );
        echo $output;
    }
    function loaddesk3($intdatein, $intdateout) {
        $categories_rooms_all = array ();

        $sql = "SELECT categories.id, categories.name, COUNT( 1 ) AS count_rooms FROM `rooms`
		INNER JOIN categories ON categories.id = rooms.category_id

		WHERE rooms.is_active = 1 AND categories.is_active = 1 AND categories.web_booking = 1 GROUP BY rooms.category_id";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $categories_rooms_all [$row->id] ["intdatein"] = date ( "Y-m-d", $intdatein * 86400 );
                $categories_rooms_all [$row->id] ["intdateout"] = date ( "Y-m-d", $intdateout * 86400 );
                $categories_rooms_all [$row->id] ["count_quota"] = 0;
            }
        }

        // echo "<pre>";
        // print_r($categories_rooms_all);

        $categories_rooms_deskofdays_intdate = array ();
        $sql = "SELECT categories.id, COUNT( 1 ) AS count_quota FROM deskofreservation
		INNER JOIN rooms ON rooms.id = deskofreservation.room_id
		INNER JOIN categories ON categories.id = rooms.category_id
		INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
		WHERE deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND deskofreservation.status = 4
		AND deskofreservation.datein <= '" . date ( "Y-m-d", $intdatein * 86400 ) . "' AND deskofreservation.dateout >= '" . date ( "Y-m-d", $intdateout * 86400 ) . "'
		GROUP BY rooms.category_id";

        // echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $categories_rooms_all [$row->id] ["count_quota"] = $row->count_quota;
            }
        }

        // print_r ( $categories_rooms_deskofdays_intdate );

        echo "<pre>";
        print_r ( $categories_rooms_all );
    }

    function test_xmlparse() {
        $doc = new DOMDocument ();
        $doc->load ( 'test1.xml' ); // xml file loading here

        $dates = $doc->getElementsByTagName ( "date" );
        $username = $doc->getElementsByTagName ( "username" );
        foreach ( $dates as $date ) {
            $roomstosells = $date->getElementsByTagName ( "roomstosell" );
            $roomstosell = $roomstosells->item ( 0 )->nodeValue;

            $prices = $date->getElementsByTagName ( "price" );
            $price = $prices->item ( 0 )->nodeValue;

            $closeds = $date->getElementsByTagName ( "closed" );
            $closed = $closeds->item ( 0 )->nodeValue;

            $minimumstays = $date->getElementsByTagName ( "minimumstay" );
            $minimumstay = $minimumstays->item ( 0 )->nodeValue;

            $maximumstays = $date->getElementsByTagName ( "maximumstay" );
            $maximumstay = $maximumstays->item ( 0 )->nodeValue;

            $closedonarrivals = $date->getElementsByTagName ( "closedonarrival" );
            $closedonarrival = $closedonarrivals->item ( 0 )->nodeValue;

            $closedondepartures = $date->getElementsByTagName ( "closedondeparture" );
            $closedondeparture = $closedondepartures->item ( 0 )->nodeValue;

            echo "<b>$username - $roomstosell - $price - $closed - $minimumstay - $maximumstay - $closedonarrival - $closedondeparture\n</b><br>";
        }
    }
    function get_dealer() {
        // print_r($_POST);
        $dealer_id = 0;
        $dealer_name = "";
        $dealer_defaultrate = 0;
        $response = "";
        $login = $_POST ["login"];
        $password = $_POST ["password"];
        $sql = "SELECT id, name, defaultrate FROM dealers WHERE agentid LIKE '" . $login . "' AND agentpassword LIKE '" . $password . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $dealer_id = $row->id;
            $dealer_name = $row->name;
            $dealer_defaultrate = $row->defaultrate;
            $response = true;
        } else {
            $response = false;
        }
        $array = array (
            "dealer_id" => $dealer_id,
            "dealer_name" => $dealer_name,
            "dealer_defaultrate" => $dealer_defaultrate,
            "response" => $response
        );
        $output = json_encode ( $array );

        echo $output;
    }
    function get_orders($agent_id = 0) {
        $orders = array ();
        // print_r($_POST);
        if ($agent_id != 0) {
            $increment = 0;
            $sql = "
            SELECT guests.id, guests.phone, guests.firstname, rate.caption as tarif, guests.lastname,
            statusofreservation.name as status_name, deskofreservation.date,
            deskofreservation.datein, deskofreservation.date as date_s, deskofreservation.dateout, deskofreservation.duration,
            deskofreservation.amount, deskofreservation.deleted, deskofreservation.balance, deskofreservation.discount, deskofreservation.id as reservation_id,
            rooms.name as room_name,
            categories.name as categories_name
            FROM deskofreservation INNER JOIN guests ON deskofreservation.guest_id=guests.id
            INNER JOIN rooms ON rooms.id=deskofreservation.room_id
            INNER JOIN categories ON categories.id=rooms.category_id
            INNER JOIN statusofreservation ON deskofreservation.status=statusofreservation.id
            LEFT JOIN rate ON deskofreservation.price_type = rate.id
            WHERE deskofreservation.status <> 4 AND deskofreservation.id_dealer = $agent_id
            GROUP BY deskofreservation.id ORDER BY deskofreservation.id DESC ";
            // echo $sql;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                foreach ( $query->result_array () as $row ) {
                    $row ["i"] = $increment;
                    if ($row ["deleted"] == 1) {
                        $row ["status_name"] = "Удалена";
                    }
                    $row ["i"] = $increment;
                    array_push ( $orders, $row );
                    $increment ++;
                }
            }

            $output = json_encode ( $orders );

            echo $output;
        }
    }
    function get_order_byid($order_id = 0) {
        $data = array ();
        // print_r($_POST);
        if ($order_id != 0) {
            $sql = "
            SELECT guests.id, guests.phone, guests.firstname, rate.caption as tarif, guests.lastname,
            statusofreservation.name as status_name, deskofreservation.date, deskofreservation.id_dealer,
            deskofreservation.datein, deskofreservation.date as date_s, deskofreservation.dateout, deskofreservation.duration,
            deskofreservation.amount, deskofreservation.balance, deskofreservation.status, deskofreservation.discount, deskofreservation.id as reservation_id,
            rooms.name as room_name,
            categories.name as categories_name
            FROM deskofreservation INNER JOIN guests ON deskofreservation.guest_id=guests.id
            INNER JOIN rooms ON rooms.id=deskofreservation.room_id
            INNER JOIN categories ON categories.id=rooms.category_id
            INNER JOIN statusofreservation ON deskofreservation.status=statusofreservation.id
            LEFT JOIN rate ON deskofreservation.price_type = rate.id
            WHERE deskofreservation.id = $order_id
            GROUP BY deskofreservation.id";
            // echo $sql;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row_array ();
                array_push ( $data, $row );
            }

            $output = json_encode ( $data );

            echo $output;
        }
    }
    function cancel_order($order_id = 0, $id_dealer = 0) {
        if ($order_id != 0) {
            $this->db->trans_begin ();
            $data = array ();
            $data ["description"] = "";
            $data ["res_id"] = $order_id;
            $data ["charge"] = 0;
            $data ["guestbe_request"] = 1;
            $data ["status"] = 5;
            $this->cancel->Insert ( $data );
            if ($this->db->trans_status () === FALSE) {
                $this->db->trans_rollback ();
                echo "transaction error cancel order";
            } else {
                $this->db->trans_commit ();
            }
            $data_reservation = $this->frontdesk->GetReservation ( $order_id );
            if ($data_reservation ["canceltoquota"] == 1) {
                /*
                 * INSERT RESERVATION
                 */

                $reservation = array ();

                $data_new = array ();

                $data_new ['firstname'] = "guest";
                $data_new ['lastname'] = "";

                $guest_id = $this->frontdesk->Guest_insert ( $data_new );
                $data_new_quota = array ();
                $data_new_quota ["room_id"] = $data_reservation ["room_id"];
                $data_new_quota ['dealer'] = $id_dealer;
                $data_new_quota ['isNew'] = 1;
                $data_new_quota ['status'] = 4;
                $data_new_quota ['datein'] = $data_reservation ["datein"];
                $data_new_quota ['dateout'] = $data_reservation ["dateout"];

                $data_new_quota ['user'] = - 1;

                $result_id = $this->frontdesk->Reservation_insert ( $data_new_quota, $guest_id, $small = 0 );

                if ($this->db->trans_status () === FALSE) {
                    $this->db->trans_rollback ();
                    echo "transaction error insert order";
                } else {
                    $this->db->trans_commit ();
                }

                if ($result_id > 0) {
                    echo "succes";
                } else {
                    echo "Вставка брони";
                }
            } else {
                echo "canceltoquota not 1";
            }
        } else {
            echo "error";
        }
    }
    function curl_getfreerooms() {
        // print_r($_POST);
        $post = $_POST;
        list ( $day, $month, $year ) = explode ( "/", $post ["datein"] );
        $datein = date ( "Y-m-d", gmmktime ( 0, 0, 0, $month, $day, $year ) );
        list ( $day, $month, $year ) = explode ( "/", $post ["dateout"] );
        $dateout = date ( "Y-m-d", gmmktime ( 0, 0, 0, $month, $day, $year ) );
        $result = $this->frontdesk->qd_canresize ( $post ["reservation_id"], $datein, $dateout );
        // echo $result;

        // $result_array = array();
        // $result_array["response"] = $result;
        // $output = json_encode ( $result_array );
        $bool = 0;
        // echo $output;
        if ($result == 1) {
            $bool = 1;
        } else {
            $room_id = $this->frontdesk->qd_findfreeroom ( $post ["reservation_id"], $datein, $dateout );
            // echo $room_id;
            if ($room_id != 0) {
                $bool = 1;
            }
        }
        echo $bool;
    }
    function curl_transform() {
        $data = array ();
        $post = $_POST;
        // print_r($post);
        list ( $day, $month, $year ) = explode ( "/", $post ["datein"] );
        $datein = date ( "Y-m-d", gmmktime ( 0, 0, 0, $month, $day, $year ) );
        list ( $day, $month, $year ) = explode ( "/", $post ["dateout"] );
        $dateout = date ( "Y-m-d", gmmktime ( 0, 0, 0, $month, $day, $year ) );
        $rid = $post ["reservation_id"];

        // $rid = 4541;

        // $datein = "2014-3-29";
        // $dateout = "2014-04-02";

        // echo $datein;
        // echo $dateout;

        $r = $this->frontdesk->qd_canresize ( $rid, $datein, $dateout );
        if ($r == 1) {
            $data ['room_id'] = 0;
            // echo "--";
            /*
             * $sql = "SELECT room_id, id_dealer, datein, dateout FROM deskofreservation WHERE id = " . $rid; $query = $this->db->query ( $sql ); if ($query->num_rows () > 0) { $row = $query->row (); $data['room_id'] = $row->room_id; }
             */
        } else {
            $r = $this->frontdesk->qd_findfreeroom ( $rid, $datein, $dateout );
            $data ['room_id'] = $r;
            // echo "==";
        }

        /*
         * if($data['room_id'] == 0){ echo 0; echo "++"; return; }
         */

        $data ['datein'] = $datein;
        $data ['dateout'] = $dateout;
        $data ['res_id'] = $rid;
        // print_r($data);
        $r = $this->qd_model->qd_cutinsertreservation ( $data );

        foreach ( $r ['date_lines'] as $line ) {
            $data = array ();
            $data ["room_id"] = $r ["room_out_id"];
            $data ['dealer'] = $r ["dealer"];
            $data ['datein'] = $line ["datein"];
            $data ['dateout'] = $line ["dateout"];
            $temp = $this->qd_model->qd_restorequota ( $data );
        }
        if (isset ( $r ['response'] )) {
            if ($r ['response'] == 1) {
                echo 1;
            } else {
                echo 0;
            }
        } else {
            echo 0;
        }
    }
    function uniteller_get_reservations($groupid) {
        $result = array ();
        $sql = "SELECT guests.lastname, guests.firstname, deskofreservation.datein, deskofreservation.groupid, deskofreservation.id,
				deskofreservation.dateout, deskofreservation.amount, rooms.name as room_name, categories.name as cat_name,
				categories.id as cat_id FROM deskofreservation
				INNER JOIN guests ON deskofreservation.guest_id=guests.id
				LEFT JOIN rooms ON rooms.id=deskofreservation.room_id
				LEFT JOIN categories ON categories.id=rooms.category_id
				WHERE deskofreservation.groupid LIKE '" . $groupid . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result_array () as $row ) {

                $query2 = $this->db->query ( "SELECT services.amount, services_types.name FROM services
						INNER JOIN services_types ON services_types.id = services.type WHERE services.reservation_id = " . $row ["id"] );
                $services_mass = array ();
                if ($query2->num_rows () > 0) {
                    $k = 0;
                    foreach ( $query2->result () as $row2 ) {
                        $services_mass [$k] ["name"] = $row2->name;
                        $services_mass [$k] ["price"] = $row2->amount;
                        $k ++;
                    }
                }

                array_push ( $result, array (
                    'goupid' => $groupid,
                    'reservatiom_id' => $row ["id"],
                    'status' => 0,
                    "amount" => $row ['amount'],
                    "services_mass" => $services_mass,
                    "datein" => $row ['datein'],
                    "dateout" => $row ['dateout'],
                    "cat_id" => $row ['cat_id'],
                    "cat_name" => $row ['cat_name'],
                    "room_name" => $row ['room_name'],
                    "lastname" => $row ['lastname'],
                    "firstname" => $row ['firstname'],
                    "guest_name" => $row ['firstname'] . " " . $row ['lastname']
                ) );
            }
        }
        $output = json_encode ( $result );
        print_r ( $output );
    }
    function UpdateReservations($hotel_id) {
        $timestamp = time ();
        $data = $_POST ["order_data"];
        $reservations = json_decode ( $data, true );

        $payment_sid = $hotel_id . "-" . $reservations [0] ["reservatiom_id"] . "-" . $timestamp;
        $reservation_count = count ( $reservations );

        if ($reservation_count > 1) {
            $groupid = $reservations [0] ["reservatiom_id"] . "-" . $timestamp;
        } else {
            $groupid = "";
        }

        for($i = 0; $i < $reservation_count; $i ++) {
            $res_id = $reservations [$i] ["reservatiom_id"];
            $sql = "UPDATE deskofreservation SET payment_sid = '" . $payment_sid . "', groupid = '" . $groupid . "' WHERE id = " . $res_id;
            $query = $this->db->query ( $sql );
        }
        $result = array (
            "payment_sid" => $payment_sid
        );
        $output = json_encode ( $result );
        print_r ( $output );
    }
    function uni_payment() {
        if(!isset($_POST ["send_data"])){
            $data = $_POST ["order_data"];
        }else{
            $data = $_POST ["send_data"];
        }
        $curl_data = json_decode ( $data, true );
        $reservation_data = array ();
        $query = $this->db->query ( "SELECT id FROM deskofreservation WHERE payment_sid LIKE '" . $curl_data ["payment_sid"] . "'" );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                array_push ( $reservation_data, $row->id );
            }
        }

        $payment_type = 2;
        $query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'uniteller_pay_type'" );

        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $payment_type = $row->value;
        } else {
            $query = $this->db->query ( "SELECT id FROM payment_types" );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $payment_type = $row->id;
            } else {
                echo " - Payment exeption 6839! - ";
            }
        }

        $all_amount = $curl_data ["amount"];
        for($i = 0; $i < count ( $reservation_data ); $i ++) {
            $query = $this->db->query ( "SELECT id, amount FROM services_main WHERE reservation_id = " . $reservation_data [$i] . " AND type = 1" );

            if ($query->num_rows () > 0) {
                $row = $query->row ();

                $res_amount = $row->amount;
                $item_id = $row->id;
                $query2 = $this->db->query ( "SELECT amount FROM check_payment_items WHERE item_id = $item_id AND item_service_table_id = 2 AND reservation_id = " . $reservation_data [$i] );
                $already_pay = 0;
                if ($query2->num_rows () > 0) {
                    foreach ( $query2->result () as $row2 ) {
                        $already_pay += $row2->amount;
                    }
                }

                $pay_db = ($res_amount - $already_pay);
                // echo "pay_db=" . $pay_db . "<br>";
                if ($curl_data ["amount"] > $pay_db) {
                    if (isset ( $reservation_data [$i + 1] )) {
                        if ($pay_db > 0) {
                            $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $pay_db, date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                            $curl_data ["amount"] = $curl_data ["amount"] - $pay_db;
                            // echo "pay_amount=" . $post ["pay_amount"] . "|||<br>";
                        }
                    } else {
                        $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $curl_data ["amount"], date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                        // echo "pay_amount=" . $post ["pay_amount"] . "\\\<br>";
                        /*
                         * $data_single_paty = array(); $data_single_paty["reservation_id"] = $_POST ["selected_reservation"] [$i]; $data_single_paty["id_partner"] = $_POST ["id_partner"]; $data_single_paty["amount"] = $post["pay_amount"]; $data_single_paty ["operationtime"] = date("Y-m-d"); $data_single_paty ["type"] = $_POST ["type"]; $data_single_paty ["clear_pay"] = 0; $data_single_paty ["card_type"] = ""; $data_single_paty ["card_holder"] = ""; $data_single_paty ["card_number"] = ""; $data_single_paty ["card_validity"] = ""; $data_single_paty ["card_protective_code"] = ""; $data_single_paty ["description"] = ""; $this->pay->Insert_payment_new ( $data_single_paty );
                         */
                    }
                } else {

                    $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $curl_data ["amount"], date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                    // echo "pay_amount=" . $post ["pay_amount"] . "///<br>";

                    /*
                     * $data_single_paty = array(); $data_single_paty["reservation_id"] = $_POST ["selected_reservation"] [$i]; $data_single_paty["id_partner"] = $_POST ["id_partner"]; $data_single_paty["amount"] = $post["pay_amount"]; $data_single_paty ["operationtime"] = date("Y-m-d"); $data_single_paty ["type"] = $_POST ["type"]; $data_single_paty ["clear_pay"] = 0; $data_single_paty ["card_type"] = ""; $data_single_paty ["card_holder"] = ""; $data_single_paty ["card_number"] = ""; $data_single_paty ["card_validity"] = ""; $data_single_paty ["card_protective_code"] = ""; $data_single_paty ["description"] = ""; $this->pay->Insert_payment_new ( $data_single_paty );
                     */
                    break;
                }
            }
            // $this->pay->fastpayment ( $_POST ["selected_reservation"] [$i], $_POST ["id_partner"], $_POST ["type"] );
            // die();
        }
        echo "paymentOK";
    }
    function uniteller_external_pay_save() {
        if(!isset($_POST ["send_data"])){
            $data = $_POST ["order_data"];
        }else{
            $data = $_POST ["send_data"];
        }
        $curl_data = json_decode ( $data, true );

        $res_id = 0;
        $payment_sid_array = explode ( "-", $curl_data ["payment_sid"] );

        if (isset($curl_data["processor"])){
            if (isset ( $payment_sid_array [1] ))
                $res_id = $payment_sid_array [1];
        }else{
            if (isset ( $payment_sid_array [3] ))
                $res_id = $payment_sid_array [3];
        }

        $external_payment_bool = 1;
        $reservation_data = array ();
        $query = $this->db->query ( "SELECT id FROM deskofreservation WHERE deskofreservation.id = " . $res_id );

        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                array_push ( $reservation_data, $row->id );
                $external_payment_bool = 0;
            }
        }

        if ($external_payment_bool == 0) {
            $payment_type = 2;
            $query = $this->db->query ( "SELECT value FROM hotelix_config WHERE name LIKE 'uniteller_pay_type'" );

            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $payment_type = $row->value;
            }

            $all_amount = $curl_data ["amount"];
            for($i = 0; $i < count ( $reservation_data ); $i ++) {
                $query = $this->db->query ( "SELECT id, amount FROM services_main WHERE reservation_id = " . $reservation_data [$i] . " AND type = 1" );

                if ($query->num_rows () > 0) {
                    $row = $query->row ();

                    $res_amount = $row->amount;
                    $item_id = $row->id;
                    $query2 = $this->db->query ( "SELECT amount FROM check_payment_items WHERE item_id = $item_id AND item_service_table_id = 2 AND reservation_id = " . $reservation_data [$i] );
                    $already_pay = 0;
                    if ($query2->num_rows () > 0) {
                        foreach ( $query2->result () as $row2 ) {
                            $already_pay += $row2->amount;
                        }
                    }

                    $pay_db = ($res_amount - $already_pay);
                    // echo "pay_db=" . $pay_db . "<br>";
                    if ($curl_data ["amount"] > $pay_db) {
                        if (isset ( $reservation_data [$i + 1] )) {
                            if ($pay_db > 0) {
                                $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $pay_db, date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                                $curl_data ["amount"] = $curl_data ["amount"] - $pay_db;
                                // echo "pay_amount=" . $post ["pay_amount"] . "|||<br>";
                            }
                        } else {
                            $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $curl_data ["amount"], date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                            // echo "pay_amount=" . $post ["pay_amount"] . "\\\<br>";
                            /*
                             * $data_single_paty = array(); $data_single_paty["reservation_id"] = $_POST ["selected_reservation"] [$i]; $data_single_paty["id_partner"] = $_POST ["id_partner"]; $data_single_paty["amount"] = $post["pay_amount"]; $data_single_paty ["operationtime"] = date("Y-m-d"); $data_single_paty ["type"] = $_POST ["type"]; $data_single_paty ["clear_pay"] = 0; $data_single_paty ["card_type"] = ""; $data_single_paty ["card_holder"] = ""; $data_single_paty ["card_number"] = ""; $data_single_paty ["card_validity"] = ""; $data_single_paty ["card_protective_code"] = ""; $data_single_paty ["description"] = ""; $this->pay->Insert_payment_new ( $data_single_paty );
                             */
                        }
                    } else {

                        $this->pay->fastpayment ( $reservation_data [$i], 1, $payment_type, $curl_data ["amount"], date ( "Y-m-d" ), 1, $curl_data ["payment_sid"], $all_amount );
                        // echo "pay_amount=" . $post ["pay_amount"] . "///<br>";

                        /*
                         * $data_single_paty = array(); $data_single_paty["reservation_id"] = $_POST ["selected_reservation"] [$i]; $data_single_paty["id_partner"] = $_POST ["id_partner"]; $data_single_paty["amount"] = $post["pay_amount"]; $data_single_paty ["operationtime"] = date("Y-m-d"); $data_single_paty ["type"] = $_POST ["type"]; $data_single_paty ["clear_pay"] = 0; $data_single_paty ["card_type"] = ""; $data_single_paty ["card_holder"] = ""; $data_single_paty ["card_number"] = ""; $data_single_paty ["card_validity"] = ""; $data_single_paty ["card_protective_code"] = ""; $data_single_paty ["description"] = ""; $this->pay->Insert_payment_new ( $data_single_paty );
                         */
                        break;
                    }
                }
                // $this->pay->fastpayment ( $_POST ["selected_reservation"] [$i], $_POST ["id_partner"], $_POST ["type"] );
                // die();
            }
        } else {

            $sql = "INSERT INTO external_payment (ext_order_id, amount, time) VALUES('" . $curl_data ["payment_sid"] . "', '" . $curl_data ["amount"] . "', '" . date ( "Y-m-d H:i:s" ) . "' )";
            $query = $this->db->query ( $sql );
        }

        echo "paymentOK";
    }
    function config_setcurrency($currency = "UAH") {
        $tbl_name = '`visitka`.`config`';
        $id = 92;
        $data = array('id' => $id, 'currency' => $currency);
        $keys = array('id' => $id);
        $this->frontdesk->db_insert_on_duplicate_key_update($tbl_name, $data, $keys);
    }
    
    public function get_extended_acc()
    {
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = "visitka";
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database($config, true);
        
        $postdata = file_get_contents("php://input");
        $postdata = json_decode($postdata, true);

//         $postdata = array();
//         $postdata['method'] = "";
//         $postdata['signature'] = "";
//         $postdata['data'] = array();
//         $postdata['data']['hms_id'] = 92;
        
        $extended_data = array();
        if (isset($postdata['method'])) {
            $password = "otelms00#";
            $signature = md5(json_encode($postdata['data']) . $password);
            if ($signature != $postdata['signature']) {
                $extended_data['error'] = "fail signature";
                //echo "+++";
            } else {
                $hms_id = $postdata['data']['hms_id'];
                $hotel_data = $this->db->get_where('config', array(
                    'id' => $hms_id
                ))->row_array();
                $db_name = $hotel_data['db_name'];
    
                $hotel_statuses_names = $this->gateway_model->get_hotel_statuses_names();
                $hotelstateid = $hotel_data['hotelstateid'];
                $hotel_statuses_name = "";
                if (isset($hotel_statuses_names[$hotelstateid])) {
                    $hotel_statuses_name = $hotel_statuses_names[$hotelstateid]['name'];
                }
    
                $overbooking_category_id = $this->db->select('value')
                ->get_where('`'.$db_name.'`'.'.hotelix_config', array(
                    'name' => 'overbooking_category_id'
                ))
                ->row()->value;
    
                $sql = "SELECT SUM(1) as count_rooms FROM `$db_name`.rooms
                INNER JOIN `$db_name`.categories ON categories.id = rooms.category_id
                WHERE categories.is_active = 1 AND categories.id <> $overbooking_category_id";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $row = $query->row();
                    $count_rooms = $row->count_rooms;
                }
    
                $hotel_users = array();
                $hotel_users_data = $this->gateway_model->get_hotel_users($db_name);
                foreach ($hotel_users_data as $user_cell) {
                    $isAdministrator = false;
                    if ($user_cell['isAdministrator'] == 1) {
                        $isAdministrator = true;
                    }
                    array_push($hotel_users, array(
                        'firstName' => $user_cell['fullname'],
                        'lastName' => $user_cell['lastname'],
                        'middleName' => $user_cell['middlename'],
                        'admin' => $isAdministrator,
                        'position' => $user_cell['position'],
                        'systemLang' => $user_cell['language'],
                        'emailAddress' => $user_cell['login']
                    ));
                }
    
                //$last_logs_data = $this->gateway_model->get_last_logs($db_name);
                $last_logs_data = $this->gateway_model->get_logauthip_list($db_name);
    
                $channels_data = $this->gateway_model->get_channels_data($db_name);
    
                $properties = $this->gateway_model->get_properties_data($db_name);
    
                $legal_entities = $this->gateway_model->get_legal_entities_data($db_name);
    
                $additional_services = $this->gateway_model->get_additional_services_data($db_name);
    
                $errors_count = $this->db->select('COUNT(1) as errors_count')->get($db_name.'.dc_log_errors')->row()->errors_count;
               
                $partners_data = array();
                foreach ($legal_entities as $parner_cell) {
                    array_push($partners_data, array(
                        'name' => $parner_cell['name'],
                        'country' => $parner_cell['country'],
                        'typeOfCompany' => $parner_cell['type_of_company'],
                        'addrLine1' => $parner_cell['addrLine1'],
                        'addrLine2' => $parner_cell['addrLine2'],
                        'city' => $parner_cell['city'],
                        'state' => $parner_cell['state'],
                        'postcode' => $parner_cell['postcode'],
                        'email' => $parner_cell['email'],
                        'docSn' => $parner_cell['DOC_SN'],
                        'docInn' => $parner_cell['DOC_INN'],
                        'docType' => $parner_cell['DOC_type'],
                        'zkpo' => $parner_cell['ZKPO'],
                        'nds' => $parner_cell['nds'],
                        'ndsNumber' => $parner_cell['nds_number'],
                        'isFiscalable' => $parner_cell['is_fiscalable'],
                        'bankName' => $parner_cell['bankname'],
                        'swift' => $parner_cell['swift'],
                        'bic' => $parner_cell['bic'],
                        'accountNumber' => $parner_cell['accountnumber'],
                        'correspondentAccount' => $parner_cell['correspondent_account'],
                        'is_default' => $parner_cell['isdefault']
                    ));
                }
    
                $extended_data['postdata'] = $postdata;
                
                $extended_data['hmsID'] = $hms_id;
                $extended_data['billingAddressCountry'] = $hotel_data['id_country_3c'];
                $extended_data['hmsUrl'] = $hotel_data['base_url'];
                $extended_data['status'] = $hotelstateid;
                $extended_data['status_str'] = $hotel_statuses_name;
                $extended_data['happines'] = "";
                $extended_data['rooms'] = $count_rooms;
                $extended_data['errors'] = $errors_count;
                $extended_data['version'] = $hotel_data['version'];
                $extended_data['hms_users'] = $hotel_users;
                $extended_data['activity_log'] = $last_logs_data;
                $extended_data['channels'] = $channels_data;
                $extended_data['properties'] = $properties;
                $extended_data['legal_entities'] = $partners_data;
                $extended_data['additional_services'] = $additional_services;
                
                $extended_data['active_channels'] = array();
                
                $channels_general_update = $this->dc_model->get_active_channels($db_name);
                $channels_names = $this->dc_model->get_dc_channels_names();
                foreach($channels_general_update as $dc_id => $general_update){
                    array_push($extended_data['active_channels'], array(
                        strtolower($channels_names[$dc_id]) => (bool)$general_update
                    ));
                }
                
            }
        }
        //         echo "<pre>";
        //         print_r($extended_data);
        echo json_encode($extended_data);
    }
}