<?php
if (! defined('BASEPATH'))
    exit('No direct script access allowed');

class dc_yandex extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        
        $this->load->model('curl_model');
        $this->load->model('htmltpl');
        $this->load->model('Authorization');
        $this->load->model('Access');
        $this->load->model('images_core');
        
        $newdata = array(
            'REQUEST_URI' => $_SERVER["REQUEST_URI"]
        );
        $this->session->set_userdata($newdata);
        $this->Authorization->IsLogined("admin_access");
        
        // ==== billing plan access start ==========
        $data_access = array(
            'module_name' => 'channel_manager'
        );
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if ($billing_plan_access == 0) {
            die("<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>");
        }
        // ==== billing plan access end ==========
        $this->load->model('dcm_abstract');
        $this->load->model('dcm_yandex');
        $this->load->model('dcm_booking');
        $this->load->model('dc_model');
        $this->load->model('mrates');
    }

    function connect($success_type = 0)
    {
        // ===== check xml dc_booking config data
        $this->dcm_yandex->set_xml_hotel_config_data();
        
        switch ($success_type) {
            case 1: // error
                break;
            case 2: // succcess
                $this->dcm_yandex->update_hotels_list();
                break;
        }
        
        $data = array(
            'success_type' => $success_type
        );
        $this->load->library('parser');
        $this->load->view('/dc_yandex/connect_view.php', $data);
    }

    function connect_success()
    {
        echo "AUTH OK";
    }

    function clear_hotel($hotel_id)
    {
        $this->dcm_yandex->clear_hotel($hotel_id);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/connect'>");
    }

    function set_photos()
    {
        $this->dcm_yandex->set_photos();
    }

    public function get_rooms($die_option)
    {
        $accounts = array();
        $sql = "SELECT * FROM dc_yandex_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $accounts[$row->dc_account_id][$row->name]["str_value"] = $row->str_value;
            $accounts[$row->dc_account_id][$row->name]["int_value"] = $row->int_value;
        }
        // echo "<pre>";
        // print_r ( $accounts );
        // die();
        
        $curl_result = "";
        foreach ($accounts as $dc_account_id => $account_data) {
            // $dc_hotel_id = $account_data["hotel_id"]["int_value"];
            $authparam = $this->dcm_yandex->getauthparam($dc_account_id);
            $hotel_id = $authparam["hotel_id"];
            $access_token = $authparam["token"];
            $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/categories";
            
            $curl_data = array();
            $curl_data['access_token'] = $access_token;
            $curl_data['url'] = $url;
            $curl_data["returntype"] = "array";
            
            $data_result = $this->Curl_model->curl_yandex($curl_data);
            
            $result_array = $data_result['result'];
            $curl_result .= print_r($data_result['result'], true);
            $this->Loger_admin->Save_SyncData("", "", json_encode($data_result['result']), 36, 13, $data_result['dc_log_id'], false, "import", "-");
            
            // echo "<pre>";
            // print_r ( $result_array );
            // die ();
            
            if ($die_option == 0) {
                // echo $result;
                echo "<pre>";
                print_r($result_array);
                // die ();
            }
            if (isset($result_array[0])) {
                if (isset($result_array[0])) {
                    $rooms_array = $result_array;
                } else {
                    $rooms_array[0] = $result_array;
                }
                
                $sql = "UPDATE dc_yandex_room_categories SET active = 0 WHERE 1 AND dc_hotel_id = " . $hotel_id;
                $query = $this->db->query($sql);
                
                $curl_occupancy_data = array();
                $curl_occupancy_data['access_token'] = $access_token;
                $curl_occupancy_data["returntype"] = "array";
                
                foreach ($rooms_array as $room) {
                    $dc_category_id = $room["id"];
                    $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/categories/$dc_category_id/placements";
                    $curl_occupancy_data['url'] = $url;
                    $data_occupancies_result = $this->Curl_model->curl_yandex($curl_occupancy_data);
                    $result_occupancies = $data_occupancies_result['result'];
                    // echo "<pre>";
                    // print_r ( $result_occupancies );
                    // die ();
                    $placements = array();
                    foreach ($result_occupancies as $capacity_data) {
                        $placements[$capacity_data['id']]['capacity'] = $capacity_data['capacity'];
                    }
                    $curl_result .= print_r($placements, true);
                    $save_data = array();
                    $save_data['hotel_id'] = $hotel_id;
                    $save_data['id'] = $room['id'];
                    $save_data['hms_room_id'] = 0;
                    $save_data['internal_name'] = $room['internal_name'];
                    $save_data['occupancies'] = $result_occupancies;
                    $this->dcm_yandex->save_room_data($save_data);
                }
            }
        }
        // die();
        if ($die_option == 1) {
            $_SESSION["dc_msg"]["text"] = $curl_result;
            
            die("<meta http-equiv='refresh' content='0;url=/dc_yandex/catgories_edit'>");
        }
    }

    public function get_rates($die_option)
    {
        $accounts = array();
        $sql = "SELECT * FROM dc_yandex_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $accounts[$row->dc_account_id][$row->name]["str_value"] = $row->str_value;
            $accounts[$row->dc_account_id][$row->name]["int_value"] = $row->int_value;
        }
        // echo "<pre>";
        // print_r ( $accounts );
        // die();
        
        $r2c_old = array();
        $sql = "SELECT dc_rate_id, dc_category_id FROM dc_yandex_rate2category_link WHERE 1";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $r2c_old[$row->dc_rate_id][$row->dc_category_id] = 0;
        }
        // echo "<pre>";
        // print_r ( $r2c_old );
        $curl_result = "";
        foreach ($accounts as $dc_account_id => $account_data) {
            // $dc_hotel_id = $account_data["hotel_id"]["int_value"];
            $authparam = $this->dcm_yandex->getauthparam($dc_account_id);
            $hotel_id = $authparam["hotel_id"];
            $access_token = $authparam["token"];
            $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/rate_plans";
            // echo $url;
            $curl_data = array();
            $curl_data['access_token'] = $access_token;
            $curl_data['url'] = $url;
            $curl_data["returntype"] = "array";
            
            $data_result = $this->Curl_model->curl_yandex($curl_data);
            
            $result_array = $data_result['result'];
            $curl_result .= print_r($data_result['result'], true);
            $this->Loger_admin->Save_SyncData("", "", json_encode($data_result['result']), 36, 13, $data_result['dc_log_id'], false, "import", "-");
            
            // echo "<pre>";
            // print_r ( $result_array );
            
            if (isset($result_array[0])) {
                if (isset($result_array[0])) {
                    $rates_array = $result_array;
                } else {
                    $rates_array[0] = $result_array;
                }
                $sql = "UPDATE dc_yandex_rates SET active = 0 WHERE 1 AND dc_hotel_id = " . $hotel_id;
                $query = $this->db->query($sql);
                foreach ($rates_array as $rate) {
                    $save_data = array();
                    $save_data['hotel_id'] = $hotel_id;
                    $save_data['id'] = $rate['id'];
                    $save_data['hms_rate_id'] = 0;
                    $save_data['name'] = $rate['name'];
                    $save_data['applicable_category_ids'] = array();
                    foreach ($rate['applicable_category_ids'] as $category_id) {
                        $save_data['applicable_category_ids'][$category_id] = 1;
                        
                        // compare new & old r2c links
                        if (isset($r2c_old[$rate['id']][$category_id])) {
                            $r2c_old[$rate['id']][$category_id] = 1;
                        }
                    }
                    
                    // echo "---------------";
                    // print_r ( $r2c_old );
                    $this->dcm_yandex->save_rate_data($save_data);
                }
                
                foreach ($r2c_old as $rate_id => $categories) {
                    foreach ($categories as $category_id => $value) {
                        if ($value == 0) {
                            $this->db->delete('dc_yandex_rate2category_link', array(
                                'dc_rate_id' => $rate_id,
                                'dc_category_id' => $category_id
                            ));
                        }
                    }
                }
            }
        }
        
        // echo $curl_result;
        // die();
        // die ();
        if ($die_option == 1) {
            $_SESSION["dc_msg"]["text"] = $curl_result;
            
            die("<meta http-equiv='refresh' content='0;url=/dc_yandex/rates_edit'>");
        }
    }

    public function dump($wtf)
    {
        echo '<pre>';
        print_r($wtf);
        die();
    }

    function info()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/dc_yandex_info_view.php', $data);
    }

    function catgories_edit()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/catgories_edit_view.php', $data);
    }

    function categories_edit_post()
    {
        $categories_link = $this->input->post('categories', true);
        $data_1 = $this->Loger_admin->get_dccategories_multivalues("dc_yandex_room_categories_link");
        $data_category2occupancy_1 = $this->Loger_admin->get_dccategories_multivalues("dc_yandex_category2occupancy", 1);
        $c2o = $_POST['c2o'];
        
        $this->dcm_yandex->category2occupancy_save($c2o);
        
        $data_2 = $this->Loger_admin->get_dccategories_multivalues("dc_yandex_room_categories_link");
        $data_category2occupancy_2 = $this->Loger_admin->get_dccategories_multivalues("dc_yandex_category2occupancy", 1);
        
        $this->Loger_admin->SaveLog_dc_multicol($data_1, $data_2, "loger_admin", "dc_yandex_room_categories_link", "edit");
        $this->Loger_admin->SaveLog_dc_multicol($data_category2occupancy_1, $data_category2occupancy_2, "loger_admin", "dc_yandex_category2occupancy", "edit", 2);
        // exit();
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/catgories_edit'>");
    }

    function category_delete($dc_category_id)
    {
        $sql = "DELETE FROM dc_yandex_room_categories WHERE dc_room_id = " . $dc_category_id;
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_yandex_room_categories_link WHERE dc_category_id = " . $dc_category_id;
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_yandex_category2occupancy WHERE dc_category_id = " . $dc_category_id;
        $query = $this->db->query($sql);
        // $sql = "DELETE FROM dc_yandex_rate2category_link WHERE dc_category_id = ".$dc_category_id;
        // $query = $this->db->query ( $sql );
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/catgories_edit'>");
    }

    function truncate_categories()
    {
        $sql = "DELETE FROM dc_yandex_room_categories WHERE 1";
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_yandex_room_categories_link WHERE 1";
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_yandex_category2occupancy WHERE 1";
        $query = $this->db->query($sql);
        $sql = "DELETE FROM dc_yandex_occupancy WHERE 1";
        $query = $this->db->query($sql);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/catgories_edit'>");
    }

    function rates_edit()
    {
        // echo "<pre>";
        // print_r($_SESSION);
        // die();
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/rates_edit_view.php', $data);
    }

    function rates_edit_post()
    {
        $r2c = $_POST['r2c'];
        // echo "<pre>";
        // print_r($r2c);
        // die();
        $data_rate2category_link_1 = $this->Loger_admin->get_dcrate_multivalues("dc_yandex_rate2category_link", 1);
        $restricts = $_POST['restricts'];
        $this->dcm_yandex->rate2category_save_yanda($r2c, $restricts);
        
        $data_rate2category_link_2 = $this->Loger_admin->get_dcrate_multivalues("dc_yandex_rate2category_link", 1);
        $this->Loger_admin->SaveLog_dc_multicol($data_rate2category_link_1, $data_rate2category_link_2, "loger_admin", "dc_yandex_rate2category_link", "edit", 1);
        
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/rates_edit'>");
    }

    function rate_delete($dc_rate_id, $dc_category_id)
    {
        $sql = "DELETE FROM  dc_yandex_rate2category_link WHERE dc_rate_id = " . $dc_rate_id . " AND dc_category_id = " . $dc_category_id;
        $query = $this->db->query($sql);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/rates_edit'>");
    }

    function rate_full_delete($dc_rate_id)
    {
        $sql = "DELETE FROM  dc_yandex_rate2category_link WHERE dc_rate_id = " . $dc_rate_id;
        $query = $this->db->query($sql);
        
        $sql = "DELETE FROM  dc_yandex_rates WHERE dc_rate_id = " . $dc_rate_id;
        $query = $this->db->query($sql);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/rates_edit'>");
    }

    function truncate_rates()
    {
        $sql = "DELETE FROM dc_yandex_rates WHERE 1";
        $query = $this->db->query($sql);
        
        $sql = "DELETE FROM dc_yandex_rate2category_link WHERE 1";
        $query = $this->db->query($sql);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/rates_edit'>");
    }

    function delete_hotel_fromdb($dc_account_id)
    {
        // $sql = "DELETE clink
        // FROM dc_yandex_room_categories_link clink
        // INNER JOIN dc_yandex_room_categories rc ON rc.dc_room_id = clink.dc_category_id
        // WHERE rc.dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        
        // $sql = "DELETE co_link
        // FROM dc_yandex_category2occupancy co_link
        // INNER JOIN dc_yandex_room_categories rc ON rc.dc_room_id = co_link.dc_category_id
        // WHERE rc.dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        
        // $sql = "DELETE o
        // FROM dc_yandex_occupancy o
        // INNER JOIN dc_yandex_room_categories rc ON rc.dc_room_id = o.roomcategory
        // WHERE rc.dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        
        // $sql = "DELETE FROM dc_yandex_room_categories WHERE dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        
        // $sql = "DELETE r2c
        // FROM dc_yandex_rate2category_link r2c
        // INNER JOIN dc_yandex_rates r ON r.id = r2c.dc_rate_id
        // WHERE r.dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        
        // $sql = "DELETE FROM dc_yandex_rates WHERE dc_hotel_id = $hotel_id";
        // $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_yandex_xml_cfg WHERE dc_account_id = $dc_account_id";
        $query = $this->db->query($sql);
        
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/connect'>");
    }

    function ra_params_edit()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/ra_params_edit_view.php', $data);
    }

    function ra_params_edit_post()
    {
        $ra_params = $this->input->post('ra');
        $rooms = $this->input->post('rooms');
        $restrict_rate = $this->input->post('restrict_rate');
        
        foreach ($rooms as $dc_room_id => $cell) {
            $this->db->update('dc_yandex_room_categories_link', array(
                'min' => $cell['min'],
                'max' => $cell['max']
            ), array(
                'dc_category_id' => $dc_room_id
            ));
        }
        
        $this->dcm_yandex->save_restrict_rate($restrict_rate);
        
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/ra_params_edit'>");
    }

    function options()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/options_view.php', $data);
    }

    function options_post()
    {
        $post = $_POST;
        $this->dcm_yandex->options_save($post);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/options'>");
    }

    public function update_hotels_list()
    {
        $this->dcm_yandex->update_hotels_list();
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/connect'>");
    }

    function export_step_1()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/export_step_1_view.php', $data);
    }

    function export_step_1_post()
    {
        $newdata = array(
            'yandex_category2hotel' => $_POST['category_to_hotel']
        );
        $this->session->set_userdata($newdata);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/export_step_2'>");
    }

    function export_step_2()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/export_step_2_view.php', $data);
    }

    function export_step_2_post()
    {
        $newdata = array(
            'yandex_rates2hotel' => $_POST['rates_to_hotel']
        );
        $this->session->set_userdata($newdata);
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/export_step_3'>");
    }

    function export_step_3()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/export_step_3_view.php', $data);
    }

    function export_links()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/export_links_view.php', $data);
    }

    function export_end()
    {
        // echo "<pre>";
        // print_r($this->session->userdata('yandex_category2hotel'));
        // echo "-----------------";
        // print_r($this->session->userdata('yandex_rates2hotel'));
        // echo "-----------------";
        // print_r($this->session->userdata('yandex_policies2hotel'));
        // print_r($_POST);
        // die();
        $category2hotel = $this->session->userdata('yandex_category2hotel');
        $rates2hotel = $this->session->userdata('yandex_rates2hotel');
        $policies2hotel = $this->session->userdata('yandex_policies2hotel');
        
        $this->session->unset_userdata('yandex_category2hotel');
        $this->session->unset_userdata('yandex_rates2hotel');
        $this->session->unset_userdata('yandex_policies2hotel');
        
        // die();
        
        $hotels2start = array();
        foreach ($category2hotel as $room_id => $hotel_id) {
            if ($hotel_id > 0) {
                $hotels2start[$hotel_id] = 1;
            }
        }
        
        foreach ($rates2hotel as $rate_id => $hotels_cell) {
            $hotel_ids = array_keys($hotels_cell);
            foreach ($hotel_ids as $hotel_id) {
                $hotels2start[$hotel_id] = 1;
            }
        }
        
        foreach ($policies2hotel as $hms_policy_id => $hotels_cell) {
            $hotel_ids = array_keys($hotels_cell);
            foreach ($hotel_ids as $hotel_id) {
                $hotels2start[$hotel_id] = 1;
            }
        }
        
        // print_r($hotels2start);
        
        // ====== SYNC ERROR =========
        // $this->dcm_yandex->sync_error(29);
        // die();
        
        // ====== SYNC START =========
        $hotel_ids = array_keys($hotels2start);
        foreach ($hotel_ids as $hotel_id) {
            $this->dcm_yandex->sync_start($hotel_id);
        }
        
        // ====== CREATE ROOMS =========
        $create_data = array();
        $create_data['rooms2hotel'] = $category2hotel;
        $this->dcm_yandex->create_rooms($create_data);
        
        // ====== SET PHOTOS =========
        $this->dcm_yandex->set_photos();
        
        // ====== CREATE POLICIES =========
        $create_data = array();
        $create_data['policies2hotel'] = $policies2hotel;
        $this->dcm_yandex->create_policies($create_data);
        // echo "-----------------";
        // print_r($this->session->userdata('yandex_policy2policy'));
        // ====== CREATE RATES =========
        $create_data = array();
        $create_data['rates2hotel'] = $rates2hotel;
        $this->dcm_yandex->create_rates($create_data);
        
        // ====== SET PRICES =========
        $start_stat_time = time();
        $type = 36;
        $upload_type = "r";
        $dbname = $this->db->database;
        $sql = "SELECT dc_account_id, int_value FROM dc_yandex_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $hotel_id = $row->int_value;
            $dc_account_id = $row->dc_account_id;
            $data = $this->dc_model->get_rate_lastchanged_36($upload_type, $dc_account_id);
            // print_r($data);
            // die();
            $data['dbname'] = $dbname;
            $data['debug'] = 0;
            if ($this->session->userdata('global_debug') == 1) {
                $data['debug'] = 1;
            }
            $return_data = $this->dc_model->set_rate_lastchanged_36($data, $upload_type, $dc_account_id);
            
            // array_push($return_data_all, $return_data);
            
            switch ($return_data['response']) {
                case 1:
                    echo $dbname . " " . $type . "($hotel_id) passed.\n";
                    break;
                case 2:
                    echo $dbname . " " . $type . "($hotel_id) skip.\n";
                    break;
                case 3:
                    echo $dbname . " " . $type . "($hotel_id) no data.\n";
                    break;
                case 4:
                    echo $dbname . " " . $type . "($hotel_id) passed no data.\n";
                    break;
                default:
                    echo $dbname . " " . $type . "($hotel_id) error:\n";
                    print_r($return_data);
                    echo "\n";
                    if (isset($return_data["errmsg"])) {
                        $error_body = $return_data["errmsg"];
                    } else {
                        if (isset($return_data["responsebody"])) {
                            $error_body = $return_data["responsebody"];
                        } else {
                            $error_body = "";
                        }
                    }
                    $warning = 0;
                    if ($type == 1) {
                        if (isset($return_data["warning"])) {
                            $warning = 1;
                        }
                    }
                    
                    // $this->dc_save_error($type, $error_body, $dbname, $warning);
                    
                    break;
            }
            
            if ($return_data['response'] != 2 and $return_data['response'] != 3 and $return_data['response'] != 4 and ! isset($return_data['hrs_error']) and $type != 11) {
                $end_stat_time = time();
                $duration_totaltime = $end_stat_time - $start_stat_time;
                $this->Loger_admin->Save_SyncData($return_data['datein'], $return_data['dateout'], print_r($return_data["responsebody"], true), $type, 1, $return_data["dc_log_id"], false, "", "", $duration_totaltime);
            }
        }
        
        // ====== SET QUOTA =========
        $sql = "SELECT dc_account_id, int_value FROM dc_yandex_xml_cfg WHERE name LIKE 'hotel_id' GROUP BY dc_account_id";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $hotel_id = $row->int_value;
            $dc_account_id = $row->dc_account_id;
            $return_data = $this->dcm_booking->setavailability_lastchanged_36($dc_account_id);
            
            // array_push($return_data_all, $return_data);
            
            switch ($return_data['response']) {
                case 1:
                    echo $dbname . " " . $type . "($hotel_id) passed.\n";
                    break;
                case 2:
                    echo $dbname . " " . $type . "($hotel_id) skip.\n";
                    break;
                case 3:
                    echo $dbname . " " . $type . "($hotel_id) no data.\n";
                    break;
                case 4:
                    echo $dbname . " " . $type . "($hotel_id) passed no data.\n";
                    break;
                default:
                    echo $dbname . " " . $type . "($hotel_id) error:\n";
                    print_r($return_data);
                    echo "\n";
                    if (isset($return_data["errmsg"])) {
                        $error_body = $return_data["errmsg"];
                    } else {
                        if (isset($return_data["responsebody"])) {
                            $error_body = $return_data["responsebody"];
                        } else {
                            $error_body = "";
                        }
                    }
                    $warning = 0;
                    if ($type == 1) {
                        if (isset($return_data["warning"])) {
                            $warning = 1;
                        }
                    }
                    
                    // $this->dc_save_error($type, $error_body, $db_name, $warning);
                    
                    break;
            }
            
            if ($return_data['response'] != 2 and $return_data['response'] != 3 and $return_data['response'] != 4 and ! isset($return_data['hrs_error']) and $type != 11) {
                
                $this->Loger_admin->Save_SyncData($return_data['datein'], $return_data['dateout'], print_r($return_data["responsebody"], true), $type, 2, $return_data["dc_log_id"]);
            }
        }
        
        if (isset($_POST['set_finish'])) {
            // ====== SYNC FINISH =========
            $hotel_ids = array_keys($hotels2start);
            foreach ($hotel_ids as $hotel_id) {
                // if($hotel_id == 23){
                $this->dcm_yandex->sync_finish($hotel_id);
                // }
            }
        }
        
        if ($this->session->userdata('global_debug') == 1) {
            die();
        }
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/catgories_edit'>");
    }

    function export_step_3_post()
    {
        $newdata = array(
            'yandex_policies2hotel' => $_POST['policy_to_hotel']
        );
        $this->session->set_userdata($newdata);
        
        die("<meta http-equiv='refresh' content='0;url=/dc_yandex/export_links'>");
    }

    function reservations_form()
    {
        $data = array();
        $this->load->library('parser');
        $this->load->view('/dc_yandex/reservations_form_view.php', $data);
    }

    function reservations_post()
    {
        // echo "<pre>";
        // print_r ( $_POST );
        // die();
        $post = $_POST;
        
        $dc_hotel_id = $post['dc_hotel_id'];
        
        $authparam = $this->dcm_yandex->getauthparam();
        $access_token = $authparam["token"];
        
        list ($from, $to) = explode(' - ', $post['date']);
        $start_date = $from . 'T00:00:00+0000';
        $end_date = $to . 'T23:59:59+0000';
        
        $data = array(
            'booking_range_start' => $start_date,
            'booking_range_end' => $end_date
        );
        
        $date_range_str = http_build_query($data);
        $url = $authparam["url"] . "/extranet/v1/hotels/$dc_hotel_id/bookings?$date_range_str";
        
        $curl_data = array();
        $curl_data['access_token'] = $access_token;
        $curl_data['url'] = $url;
        $curl_data["returntype"] = "array";
        // echo "<pre>";
        // print_r($curl_data);
        // die();
        $data_result = $this->Curl_model->curl_yandex($curl_data);
        
        $book_data = $data_result;
        $book_data['dc_hotel_id'] = $dc_hotel_id;
        $book_data['debug'] = 1;
        $hms_result = $this->dcm_yandex->get_bookings($book_data);
        
        $this->Loger_admin->Save_SyncData("", "", $hms_result, 36, 10, $data_result["dc_log_id"]);
    }

    // function get_bookings_formfile(){
    // $str_data = file_get_contents ( $_FILES ['file_data'] ['tmp_name'] );
    
    // $encoding = $this->input->post ( 'encoding' );
    // switch ($encoding) {
    // case "windows1251" :
    // $str_data = iconv ( "windows-1251", "utf-8", $str_data );
    // break;
    // case "utf8" :
    // break;
    // default :
    // //$str_data = iconv ( "windows-1251", "utf-8", $str_data );
    // break;
    // }
    // echo $str_data;
    // $result_array = json_decode($str_data, 1);
    // $this->dcm_academservice->get_bookings ( $result_array );
    // }
    function get_bookings_withID()
    {
        $hotel_id = $_POST["dc_hotel_id"];
        $dc_reservation_id = $_POST['dc_reservation_id'];
        
        $authparam = $this->dcm_yandex->getauthparam();
        $access_token = $authparam["token"];
        $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/bookings/$dc_reservation_id";
        
        $curl_data = array();
        $curl_data['access_token'] = $access_token;
        $curl_data['url'] = $url;
        $curl_data["returntype"] = "array";
        echo "<pre>";
        print_r($curl_data);
        // die();
        $data_result = $this->Curl_model->curl_yandex($curl_data);
        
        $book_data['dc_hotel_id'] = $hotel_id;
        $book_data['debug'] = 1;
        $book_data['result'] = array();
        $book_data['result'][0] = $data_result['result'];
        
        $hms_result = $this->dcm_yandex->get_bookings($book_data);
        
        $this->Loger_admin->Save_SyncData("", "", $hms_result, 36, 10, $data_result["dc_log_id"]);
    }
    
    function book_test(){
        $str_json = '[{"booking_ref":"YA-4392-0428-0523:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"79288104809"},"room_stays":[{"id":149,"placements":[{"id":7161,"name":"Base 2","amount":1}],"guests":[{"name":"Даниил Поделякин"},{"name":"Никита Крутов"}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2333,"description":"2-х местный «Стандарт» —2 основных места, 1 дополнительное.\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (двуспальная кровать)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"a8d77f28-ec96-45ef-b9bc-e3fab68959c7","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-8278-7355-0241:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"+79993602740"},"room_stays":[{"id":150,"placements":[{"id":7169,"name":"Base 2","amount":1}],"guests":[{"name":"Даниил Поделякин"},{"name":"Никита Крутов"}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"21ccf6d0-46fe-4fff-a701-b8e1657478a9","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-9902-4824-7365:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"79288104809"},"room_stays":[{"id":145,"placements":[{"id":7169,"name":"Base 2","amount":1}],"guests":[{"name":"Даниил Поделякин"},{}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"a4ac52cd-20e4-4264-97d0-14ed7023f226","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-8440-9908-3289:0","status":"ANNULLED","customer_info":{"full_name":"Artyr Anohin","email":"packtheshpack@yandex.ru","phone":"79883472201"},"room_stays":[{"id":197,"placements":[{"id":7161,"name":"Base 2","amount":1}],"guests":[{"name":"Artyr Anohin"},{"name":"Анастасия Соколова"}],"check_in":"2023-07-26","check_out":"2023-07-28","room_category":{"id":2333,"description":"2-х местный «Стандарт» —2 основных места, 1 дополнительное.\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (двуспальная кровать)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"NON_REFUNDABLE","starts_at":"2023-07-19T00:00:00+0000"}]}],"booking_price":{"total_amount":12000.00,"yandex_fee":1800.00,"payable_online":12000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"9908a570-8e0a-4241-bf0d-972940c50df0","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-7904-2328-0144:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"79288104809"},"room_stays":[{"id":146,"placements":[{"id":7169,"name":"Base 2","amount":1}],"guests":[{"name":"Даниил Поделякин"},{"name":"Никита Крутов"}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"084386c8-e30e-438d-891e-509287b97b3e","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-6777-3060-5076:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"79288104809"},"room_stays":[{"id":147,"placements":[{"id":7168,"name":"Base 1","amount":1}],"guests":[{"name":"Даниил Поделякин"}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"4913b62f-1701-4257-a880-c40a59da791f","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-4251-0058-4435:0","status":"ANNULLED","customer_info":{"full_name":"Даниил Поделякин","email":"podeliakin2011@yandex.ru","phone":"79288104809"},"room_stays":[{"id":148,"placements":[{"id":7169,"name":"Base 2","amount":1}],"guests":[{"name":"Даниил Поделякин"},{"name":"Никита Крутов"}],"check_in":"2023-08-11","check_out":"2023-08-14","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-04T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-04T00:00:00+0000"}]}],"booking_price":{"total_amount":18000.00,"yandex_fee":2700.00,"payable_online":18000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"471ad0d2-fa03-4b69-a2ce-db55cd4437ee","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-3971-1475-2505:0","status":"ANNULLED","customer_info":{"full_name":"Евгений Морозкин","email":"morozkina-1987@mail.ru","phone":"89220637563"},"room_stays":[{"id":154,"placements":[{"id":7191,"name":"Base 4","amount":1},{"id":7192,"name":"Extra","amount":1}],"guests":[{"name":"Евгений Морозкин"},{"name":"Раушания Морозкина"},{"name":"Арсений Морозкин","age":1},{"name":"Ангелина Морозкина","age":10},{"name":"Артём Морозкин","age":12}],"check_in":"2023-08-17","check_out":"2023-08-22","room_category":{"id":2344},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-10T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-10T00:00:00+0000"}]}],"booking_price":{"total_amount":80000.00,"yandex_fee":12000.00,"payable_online":80000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"f22fc84f-883c-403d-8499-63652008b8b3","created_at":"2023-07-27T13:35:23+0000","updated_at":"2023-07-27T13:35:23+0000"},{"booking_ref":"YA-2807-8405-7812:0","status":"CONFIRMED","customer_info":{"full_name":"Artyr Anohin","email":"packtheshpack@yandex.ru","phone":"79883472201"},"room_stays":[{"id":207,"placements":[{"id":7169,"name":"Base 2","amount":1}],"guests":[{"name":"Artyr Anohin"},{"name":"Анастасия Соколова"}],"check_in":"2023-07-26","check_out":"2023-07-28","room_category":{"id":2336,"description":"2-х местный «Стандарт» —2 основных места (2 раздельные кровати)\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (две раздельные кровати)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"NON_REFUNDABLE","starts_at":"2023-07-19T00:00:00+0000"}]}],"booking_price":{"total_amount":12000.00,"yandex_fee":1800.00,"payable_online":12000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"e7ee9a9f-5d6d-4636-9bd0-cf90a5f8cff2","created_at":"2023-07-25T14:26:56+0000","updated_at":"2023-07-25T14:27:41+0000"},{"booking_ref":"YA-0300-6535-4233:0","status":"CONFIRMED","customer_info":{"full_name":"Ксения Кочегарова","email":"kochegarova.ksenia@mail.ru","phone":"+79032610837"},"room_stays":[{"id":274,"placements":[{"id":7161,"name":"Base 2","amount":1},{"id":7162,"name":"Extra","amount":1}],"guests":[{"name":"Ксения Кочегарова"},{},{"age":10}],"check_in":"2023-07-27","check_out":"2023-07-30","room_category":{"id":2333,"description":"2-х местный «Стандарт» —2 основных места, 1 дополнительное.\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (двуспальная кровать)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"NON_REFUNDABLE","starts_at":"2023-07-20T00:00:00+0000"}]}],"booking_price":{"total_amount":24000.00,"yandex_fee":3600.00,"payable_online":24000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"82f912a3-1385-4d3b-bdb1-36bf3558e986","created_at":"2023-07-26T09:18:13+0000","updated_at":"2023-07-26T09:19:36+0000"},{"booking_ref":"YA-9585-2649-6118:0","status":"CONFIRMED","customer_info":{"full_name":"Алина Потемкина","email":"alina.t@bk.ru","phone":"79037491912"},"room_stays":[{"id":279,"placements":[{"id":7171,"name":"Base 2","amount":1},{"id":7172,"name":"Extra","amount":1}],"guests":[{"name":"Алина Потемкина"},{"name":"Андрей Потёмкин"},{"name":"Виктория Потёмкина"}],"check_in":"2023-08-14","check_out":"2023-08-25","room_category":{"id":2337,"description":"Площадь номера - 45 кв.м\n\n2 основных места, 2 дополнительных (мягкий раскладной диван).\n\nНомер состоит из одной спальной, одной гостиной, ванной комнаты и балкона.\n\n\nВ номере имеется: телевизор, телефон, стол с зеркалом, двуспальная кровать 160×200 см. (DR), холодильник-мини-бар, климат-контроль.\n\nВанная комната: душ, умывальник, санузел, зеркало, фен.\n\nНа каждого гостя: полотенца, тапочки, продукция индивидуального пользования.","internal_name":"Люкс"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-08-07T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-08-07T00:00:00+0000"}]}],"booking_price":{"total_amount":132000.00,"yandex_fee":19800.00,"payable_online":132000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"cf0e0710-16a6-4713-b7df-91e74b5e6ef4","created_at":"2023-07-26T09:44:47+0000","updated_at":"2023-07-26T09:45:30+0000"},{"booking_ref":"YA-4703-0604-1242:0","status":"CONFIRMED","customer_info":{"full_name":"Сергей Школовой","email":"cshkolovoj@yandex.ru","phone":"79652921295"},"room_stays":[{"id":332,"placements":[{"id":7161,"name":"Base 2","amount":1},{"id":7162,"name":"Extra","amount":1}],"guests":[{"name":"Сергей Школовой"},{},{"age":9}],"check_in":"2023-08-07","check_out":"2023-08-11","room_category":{"id":2333,"description":"2-х местный «Стандарт» —2 основных места, 1 дополнительное.\nПлощадь номера - 14, 2 кв.м\nВ номере: телевизор, телефон, мини-бар, фен, банные принадлежности, сан /узел (душ/кабина), сплит - система, балкон.","internal_name":"2-х местный Стандарт (двуспальная кровать)"},"rate_plan":{"id":608,"name":"Базовый","meal_type":"BED_BREAKFAST"},"refund_rules":[{"type":"FULLY_REFUNDABLE","ends_at":"2023-07-31T00:00:00+0000"},{"type":"NON_REFUNDABLE","starts_at":"2023-07-31T00:00:00+0000"}]}],"booking_price":{"total_amount":32000.00,"yandex_fee":4800.00,"payable_online":32000.00,"payable_at_property":0.00},"sync_status":"AWAITING","confirmation_token":"1ad763d9-ff98-4a9d-b2e1-90512c9a841d","created_at":"2023-07-26T17:24:11+0000","updated_at":"2023-07-26T17:24:53+0000"}]';
        $data = array();
        $data["result"] =  json_decode($str_json,1);
//         echo "<pre>";
//         print_r($data);
//         die();
        $hms_result = $this->dcm_yandex->get_bookings($data);
    }

    function create_booking()
    {
        $this->dcm_yandex->create_booking();
    }

    function get_all_bookings()
    {
        echo " ======= get_all_bookings =========<br>";
        $this->dcm_yandex->get_all_bookings(23);
        // echo "<h3> ======= get_reservation_by_id =========</h3><br>";
        // $this->dcm_yandex->get_reservation_by_id();
    }

    public function get_placements($hotel_id, $category_id)
    {
        
        // $hotel_id = 25;
        // $category_id = 369;
        $authparam = $this->dcm_yandex->getauthparam();
        $access_token = $authparam["token"];
        $url = $authparam["url"] . "/extranet/v1/hotels/$hotel_id/categories/$category_id/placements";
        
        $headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $access_token
        );
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYPEER => false,
            // CURLOPT_POSTFIELDS => $request,
            CURLOPT_HTTPHEADER => $headers
        ));
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        
        $information = curl_getinfo($curl);
        $response = curl_exec($curl);
        curl_close($curl);
        
        $this->dump(array(
            json_decode($response, 1),
            $headers,
            $information
        ));
    }
}
?>