<?php
class Dc_cron_tools extends CI_Controller {
	public function __construct() {
		parent::__construct ();
	}

    function chechdeskdays_hotel($db_name, $xdays = 0){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = $this->db->select('id')->get_where('visitka.config', array('db_name'=>$db_name))->row()->id;
        $from_date = date('Y-m-d');
        $from_intdate = round ( mktime ( 0, 0, 0, date('m'), date('d') + $xdays, date('Y') ) / 86400 );
        $end_date = date('Y-m-d', $from_intdate * 86400);
        
        $fail_reservations = array();
        $sql = "SELECT deskofreservation.id AS hms_res_id, deskofreservation.room_id,
        deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration,
        deskofdays.intdate, deskofdays.date as deskofdays_date, COUNT(deskofdays.id) as dod_count,
        deskofreservation.early_check_in_close, deskofreservation.late_check_out_close
        FROM deskofreservation
        LEFT JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
        WHERE deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND 
        deskofreservation.datein < '$end_date' AND deskofreservation.dateout > '$from_date'
        GROUP BY deskofreservation.id";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                
                $res_data = array();
                $res_data['res_id'] = $row->hms_res_id;
                $res_data['clear'] = 0;
                $res_data['rlist'] = array();
                
                list ($year, $month, $day) = explode("-", $row->datein);
                $intdatein = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                list ($year, $month, $day) = explode("-", $row->dateout);
                $intdateout = round(gmmktime(0, 0, 0, $month, $day, $year) / 86400);
                
                if ($row->early_check_in_close == 1) {
                    $intdatein -= 1;
                }
                if ($row->late_check_out_close == 1) {
                    $intdateout += 1;
                }
                
                $room_id = $row->room_id;
                // check rdays
                if (($intdateout - $intdatein) == $row->dod_count) {
                    $res_data['rdays'] = 1;
                } else {
                    $res_data['rdays'] = 0;
                }
                
                // check clear
                $sql_2 = "SELECT deskofdays.reservation_id
            FROM deskofdays
            INNER JOIN deskofreservation ON deskofdays.reservation_id = deskofreservation.id
            WHERE deskofdays.room_id = $room_id AND deskofdays.intdate >= $intdatein
            AND deskofdays.intdate < $intdateout AND deskofdays.reservation_id <> $row->hms_res_id
            GROUP BY deskofdays.reservation_id";
                $query_2 = $this->db->query($sql_2);
                if ($query_2->num_rows() > 0) {
                    $res_data['clear'] = 0;
                    $res_data['rlist'] = $query_2->result_array();
                } else {
                    $res_data['clear'] = 1;
                }
                if($res_data['clear'] == 0 || $res_data['rdays'] == 0){
                   array_push($fail_reservations, $res_data); 
                }
            }
        }
        if (count($fail_reservations) > 0) {
            
            $result_array = array();
            $result_array['hms_id'] = $hms_id;
            $result_array['response'] = json_encode($fail_reservations);
            $result_array['date_from'] = $from_date;
            $result_array['date_to'] = $end_date;
            
            $this->db->insert('global_hotelix_analitycs.dod_fails', $result_array);
            echo "<pre>";
            print_r($result_array);
        }
    }
    
    function dc_push_get_resid(){
        $sql = "SELECT id as push_id, post FROM dc_booking.101otel_http_push_v3 ORDER BY id DESC";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $push_id = $row->push_id;
                $post = json_decode ( $row->post, true );
                $push_data = json_decode ( $post['booking'], true );
//                 echo "<pre>";
//                 print_r($push_data);
//                 die();
                $dc_res_id = $push_data['id'];
                $hotel_id = $push_data['hotel_id'];
                $sql2 = "UPDATE dc_booking.101otel_http_push_v3 SET hotel_id = '$hotel_id', dc_res_id = '$dc_res_id' WHERE id = $push_id";
                $this->db->query($sql2);
            }
        }
    }
}
?>