<?php
class Dc_cron_analytic extends CI_Controller {
    public function __construct() {
        parent::__construct ();
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'frontdesk_c2' );
        $this->load->model ( 'debugmodel' );
        $this->load->model ( 'mstats' );
        $this->load->model ( 'fms_core' );
        $this->load->model ( 'dcm_airbnb' );
        $this->load->model ( 'curl_model' );
        $this->load->model ( 'xlsfactory_model' );
    }
    
    function get_missed_rooms($db_name){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
    
        $this->db = $this->load->database ( $config, true );
        $hms_id = $this->db->select('id')->get_where('visitka.config', array('db_name' => $db_name))->row()->id;

        $res_array = array();
        $sql = "SELECT id FROM deskofreservation WHERE type_id = 0 AND room_id = 0";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                array_push($res_array, $row->id);
            }
        }
        
        $res_array = $this->db->select('id')->get_where('deskofreservation', array('type_id' => 0, 'room_id' => 0))->result_array();
        if (count($res_array) > 0) {
            $insert_array = array();
            foreach ($res_array as $cell) {
                array_push($insert_array, array(
                    'hms_id' => $hms_id,
                    'res_id' => $cell["id"],
                    'db_name' => $db_name
                ));
            }
            $this->db->insert_batch('global_hotelix_analitycs.missed_rooms', $insert_array);
        }else{
            echo "NO BOOKINGS!";
        }
    }
    
    function make_dc_list_state($db_name){
        /*
         *
         * === hotelbook 17, dorms 20, booking 1 ========
         *
         */
        
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        
        /*
         *
         * ======= Booking set ============
         *
         */
        $dc_id = 1;
        $dc_hotels = array();
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $dc_hotels[$row->int_value]["dc_hotel_id"] = $row->int_value;
            }
        }
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_booking_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $general_update = $row->int_value;
        }
        
        //delete data from DB "global_hotelix_analitycs", table "dc_list_state"
        
        $this->db->where('dc_id', $dc_id);
        $this->db->where('hms_id', $hms_id);
        $this->db->delete('global_hotelix_analitycs.dc_list_state');
        
        // insert data to DB "global_hotelix_analitycs", table "dc_list_state"
        
        foreach ( $dc_hotels as $cell ) {
            $data = array(
                'dc_id' => $dc_id,
                'hms_id' => $hms_id,
                'dc_hotel_id' => $cell["dc_hotel_id"],
                'db_name' => $db_name,
                'sync' => $general_update
            );
            
            $this->db->insert('global_hotelix_analitycs.dc_list_state', $data);
        }
        
        /*
         *
         * ======= Hotelbook set ============
         *
         */
        $dc_id = 17;
        $dc_hotels = array();
        $sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $dc_hotels[$row->int_value]["dc_hotel_id"] = $row->int_value;
            }
        }
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_hotelbook_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $general_update = $row->int_value;
        }
        
        //delete data from DB "global_hotelix_analitycs", table "dc_list_state"
        
        $this->db->where('dc_id', $dc_id);
        $this->db->where('hms_id', $hms_id);
        $this->db->delete('global_hotelix_analitycs.dc_list_state');
        
        // insert data to DB "global_hotelix_analitycs", table "dc_list_state"
        
        foreach ( $dc_hotels as $cell ) {
            $data = array(
                'dc_id' => $dc_id,
                'hms_id' => $hms_id,
                'dc_hotel_id' => $cell["dc_hotel_id"],
                'db_name' => $db_name,
                'sync' => $general_update
            );
            
            $this->db->insert('global_hotelix_analitycs.dc_list_state', $data);
        }
        
        /*
         *
         * ======= DORMS set ============
         *
         */
        $dc_id = 20;
        $dc_hotels = array();
        $sql = "SELECT int_value FROM dc_dorms_xml_cfg WHERE dc_account_id > 0 AND name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $dc_hotels[$row->int_value]["dc_hotel_id"] = $row->int_value;
            }
        }
        
        $general_update = 0;
        $sql = "SELECT int_value FROM dc_dorms_xml_cfg WHERE name LIKE 'general_update'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $general_update = $row->int_value;
        }
        
        //delete data from DB "global_hotelix_analitycs", table "dc_list_state"
        
        $this->db->where('dc_id', $dc_id);
        $this->db->where('hms_id', $hms_id);
        $this->db->delete('global_hotelix_analitycs.dc_list_state');
        
        // insert data to DB "global_hotelix_analitycs", table "dc_list_state"
        
        foreach ( $dc_hotels as $cell ) {
            $data = array(
                'dc_id' => $dc_id,
                'hms_id' => $hms_id,
                'dc_hotel_id' => $cell["dc_hotel_id"],
                'db_name' => $db_name,
                'sync' => $general_update
            );
            
            $this->db->insert('global_hotelix_analitycs.dc_list_state', $data);
        }
    }
    
    function group_res_hotel_proportion($db_name = "hotelix_test-hotel-dev_ZIP") {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            
            $sql = "SELECT  COUNT(1) as total_res_count, SUM(IF(groupid <> '', 1, 0)) as group_res_count
					FROM deskofreservation
					WHERE deleted = 0 AND cancel = 0";
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $sql_2 = "INSERT INTO global_hotelix_analitycs.group_res_proportion (hms_id, group_res_count, total_res_count)
			              VALUES('" . $hms_id . "', '" . $row->group_res_count . "', '" . $row->total_res_count . "')
	               		  ON DUPLICATE KEY UPDATE group_res_count = '" . $row->group_res_count . "', total_res_count = '" . $row->total_res_count . "'";
                $query = $this->db->query ( $sql_2 );
                // витерти все вниз до дужки, всі ехо
                echo "Таблиця:  global_hotelix_analitycs.group_res_proportion <br>";
                echo "Готель ІД: ",  $hms_id, "<br>";
                echo "Групових замовлень: ",  $row->group_res_count, "<br>";
                echo "Всього замовлень: ",  $row->total_res_count, "<br>";
            }
        }
    }
    function check_bso($db_name = "hotelix_test-hotel-dev_ZIP", $year = '', $month = '') {
        if ($year == '' OR $month == ''){
            $year = gmdate('Y');
            $month = gmdate('m');
            //echo $year, '   ', $month;
        }
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            
            $sql = "SELECT  SUM(IF(state =1, total, 0)) as total_active,
							SUM(IF(state = 1, 1, 0)) as count_active,
					        SUM(IF(state = 2, 1, 0))  as count_deleted
					FROM bso_records
		      		WHERE month(date) =  " . $month . " AND year(date) = " . $year;
            
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                if (!(($row->count_active == 0) AND ($row->count_deleted == 0))) {
                    $sql_2 = "INSERT INTO global_hotelix_analitycs.annual_bso
						              (hms_id, year, month, count_active, total_active,  count_deleted)
			              VALUES('" . $hms_id . "', '" . $year . "', '" . $month . "', '" . $row->count_active . "', '" . $row->total_active . "',  '" . $row->count_deleted . "')
	               		  ON DUPLICATE KEY UPDATE count_active = '" . $row->count_active . "', total_active = '" . $row->total_active . "',  count_deleted = '" . $row->count_deleted . "'";
                    //echo $sql_2;
                    $query = $this->db->query ( $sql_2 );
                }
            }
        }
    }
    function checkpayment($db_name = "", $year, $month) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $phone = "";
        $email = "";
        $country = "";
        $sql = "SELECT config.id, users.useremail as email, users.userphone as phone  FROM visitka.config
		INNER JOIN visitka.users ON users.site_address = config.base_url
		WHERE db_name LIKE '".$db_name."'";
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            $phone = $row->phone;
            $email = $row->email;
            $phone_substr = substr($phone, 0, 3);
            
            /*
             * ========== RU SECTOR =============
             */
            //echo $phone."++";
            
            if (trim ( $phone ) != "") {
                if (substr_count ( $phone, '+7', 0, 2 ) > 0) {
                    $country = "ru";
                }
                if (substr_count ( $phone, '7', 0, 1 ) > 0) {
                    $country = "ru";
                }
            }
            if(substr_count($email, '.ru') > 0){
                $country = "ru";
            }
            /*
             * ========== UA SECTOR =============
             */
            if (trim ( $phone ) != "") {
                if (substr_count ( $phone, '063', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '093', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '066', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '067', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '068', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '096', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '097', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '098', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '050', 0, 3 ) > 0) {
                    $country = "ua";
                }
                
                if (substr_count ( $phone, '+063', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+093', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+066', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+067', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+068', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+096', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+097', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+098', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+050', 0, 4 ) > 0) {
                    $country = "ua";
                }
            }
            if(substr_count($email, '.ua') > 0){
                $country = "ua";
            }
        }
        if ($country == "ua") {
            
        } else {
            exit();
        }
        
        $sql = "SELECT COUNT(1) as count, SUM(payment.amount) as total  FROM payment
		INNER JOIN deskofreservation ON deskofreservation.id = payment.reservation_id
		WHERE deskofreservation.deleted = 0 AND deskofreservation.cancel = 0 AND month(operationtime) = ".$month." and year(operationtime) = ".$year;
        //echo $sql."<br>";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            //secho $hms_id." ".$year."/".$month." ".$row->total." ".$row->count;
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_payment (hms_id, db_name, year, month, total, `count`, country, email, phone)
			VALUES('".$hms_id."', '".$db_name."', '".$year."', '".$month."', '".$row->total."', '".$row->count."', '".$country."', '".$email."', '".$phone."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', total = '".$row->total."', `count` = '".$row->count."', country = '".$country."', email = '".$email."', phone = '".$phone."'";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
    }
    
    function gueststats($db_name = "", $year, $month) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $phone = "";
        $email = "";
        $country = "";
        $sql = "SELECT config.id, users.useremail as email, users.userphone as phone  FROM visitka.config
		INNER JOIN visitka.users ON users.site_address = config.base_url
		WHERE db_name LIKE '".$db_name."'";
        //echo $sql;
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            $phone = $row->phone;
            $email = $row->email;
            $phone_substr = substr($phone, 0, 3);
            
            /*
             * ========== RU SECTOR =============
             */
            //echo $phone."++";
            
            if (trim ( $phone ) != "") {
                if (substr_count ( $phone, '+7', 0, 2 ) > 0) {
                    $country = "ru";
                }
                if (substr_count ( $phone, '7', 0, 1 ) > 0) {
                    $country = "ru";
                }
            }
            if(substr_count($email, '.ru') > 0){
                $country = "ru";
            }
            /*
             * ========== UA SECTOR =============
             */
            if (trim ( $phone ) != "") {
                if (substr_count ( $phone, '063', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '093', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '066', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '067', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '068', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '096', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '097', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '098', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '050', 0, 3 ) > 0) {
                    $country = "ua";
                }
                
                if (substr_count ( $phone, '+063', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+093', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+066', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+067', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+068', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+096', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+097', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+038', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+098', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+050', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '095', 0, 3 ) > 0) {
                    $country = "ua";
                }
                //echo $phone;
                if (substr_count ( $phone, '(+38', 0, 4 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '+38', 0, 3 ) > 0) {
                    $country = "ua";
                }
                if (substr_count ( $phone, '03', 0, 2 ) > 0) {
                    $country = "ua";
                }
            }
            if(substr_count($email, '.ua') > 0){
                $country = "ua";
            }
        }
        //echo $country;
        if ($country == "ru") {
            
        } else {
            exit();
        }
        $sql = "SELECT id, COUNT(1) as count, COUNT(reservation_id) as total  FROM deskofreservation	left join guests_deskofreservation
	    on guests_deskofreservation.reservation_id = deskofreservation.id
            
		WHERE deskofreservation.status in (1, 2 ,3, 4) AND deskofreservation.deleted = 0
	        AND deskofreservation.cancel = 0 AND month(datein) = ".$month." and year(datein) = ".$year;
        // echo $sql."<br>";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            if ($row->count) {
                
            } else {
                exit();
            }
            
            //secho $hms_id." ".$year."/".$month." ".$row->total." ".$row->count;
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_guests (hms_id, db_name, year, month, total, `count`, country, email, phone)
			VALUES('".$hms_id."', '".$db_name."', '".$year."', '".$month."', '".($row->total+$row->count)."', '".$row->count."', '".$country."', '".$email."', '".$phone."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', total = '".($row->total+$row->count)."', `count` = '".$row->count."', country = '".$country."', email = '".$email."', phone = '".$phone."'";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
    }
    
    function check_dc($db_name = "", $year, $month) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $sql = "SELECT config.id, config.id_country_3c, users.useremail as email, users.userphone as phone  FROM visitka.config
		INNER JOIN visitka.users ON users.site_address = config.base_url
		WHERE db_name LIKE '".$db_name."'";
        // echo $sql;
        
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            $id_country_3c = $row->id_country_3c;
            $phone = $row->phone;
            $email = $row->email;
            $phone_substr = substr($phone, 0, 3);
            
            /*
             * ========== RU SECTOR =============
             */
            //echo $phone."++";
            
            
        }
        $sql = "SELECT dc_id, COUNT(1) as count, SUM(amount) as total  FROM
	        deskofreservation
		WHERE deskofreservation.status in (1, 2 ,3) AND deskofreservation.deleted = 0
	        AND deskofreservation.cancel = 0 AND month(datein) = ".$month." and year(datein) = ".$year . " group by dc_id";
        //echo $sql."<br>";
        $query = $this->db->query ( $sql );
        
        foreach ($query->result() as $row) {
            //secho $hms_id." ".$year."/".$month." ".$row->total." ".$row->count;
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc (hms_id, id_country_3c, db_name, dc_id, year, month, total, count)
			VALUES('".$hms_id."', '".$id_country_3c."', '".$db_name."', '".$row->dc_id."', '".$year."', '".$month."', '".$row->total."', '".$row->count."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', total = ".$row->total.", count = ".$row->count."";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
    }
    
    
    function get_data($tblname, $dc_id, $hms_id, $db_name) {
        $data = array();
        $data['hotel_id'] = 0;
        $data['active'] = 0;
        $sql = "SELECT int_value  FROM " . $tblname . "
		WHERE name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row();
            $data['hotel_id'] = $row->int_value;
        }
        
        $sql = "SELECT int_value  FROM " . $tblname . "
		WHERE name LIKE 'general_update'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row();
            $data['active'] = $row->int_value;
        }
        
        if ($data['hotel_id'] != 0) {
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc2 (hms_id, db_name, dc_id, active, hotel_id)
			VALUES('".$hms_id."', '".$db_name."', '".$dc_id."', '".$data['active']."',  '".$data['hotel_id']."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', active = ".$data['active'].", hotel_id = ".$data['hotel_id']."";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
        
    }
    
    
    
    
    function check_dc2($db_name = "") {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $sql = "SELECT config.id, users.useremail as email, users.userphone as phone  FROM visitka.config
		INNER JOIN visitka.users ON users.site_address = config.base_url
		WHERE db_name LIKE '".$db_name."'";
        // echo $sql;
        
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            $phone = $row->phone;
            $email = $row->email;
            $phone_substr = substr($phone, 0, 3);
            
            /*
             * ========== RU SECTOR =============
             */
            //echo $phone."++";
            
            
        }
        
        $data = $this->get_data("dc_booking_xml_cfg", 1, $hms_id, $db_name);
        $data = $this->get_data("dc_ostrovok_xml_cfg", 2, $hms_id, $db_name);
        $data = $this->get_data("dc_expedia_xml_cfg", 3, $hms_id, $db_name);
        $data = $this->get_data("dc_oktogo_xml_cfg", 7, $hms_id, $db_name);
        $data = $this->get_data("dc_101otel_xml_cfg", 9, $hms_id, $db_name);
        $data = $this->get_data("dc_hrs_xml_cfg", 11, $hms_id, $db_name);
        $data = $this->get_data("dc_vashotel_xml_cfg", 12, $hms_id, $db_name);
        $data = $this->get_data("dc_bronevik_xml_cfg", 13, $hms_id, $db_name);
        $data = $this->get_data("dc_ozon_xml_cfg", 15, $hms_id, $db_name);
        
        
        die();
        
        
        $sql = "SELECT dc_id, COUNT(1) as count, SUM(amount) as total  FROM
	        deskofreservation
		WHERE deskofreservation.status in (1, 2 ,3) AND deskofreservation.deleted = 0
	        AND deskofreservation.cancel = 0 AND month(datein) = ".$month." and year(datein) = ".$year . " group by dc_id";
        //echo $sql."<br>";
        $query = $this->db->query ( $sql );
        
        foreach ($query->result() as $row) {
            //secho $hms_id." ".$year."/".$month." ".$row->total." ".$row->count;
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc (hms_id, db_name, dc_id, year, month, total, count)
			VALUES('".$hms_id."', '".$db_name."', '".$row->dc_id."', '".$year."', '".$month."', '".$row->total."', '".$row->count."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', total = ".$row->total.", count = ".$row->count."";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
    }
    
    
    function check_dc_adr($db_name = "", $year) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $sql = "SELECT config.id   FROM visitka.config
		WHERE db_name LIKE '".$db_name."'";
        // echo $sql;
        
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            
        }
        
        $data = $this->get_data("dc_booking_xml_cfg", 1, $hms_id, $db_name);
        
        
        $sql = "SELECT COUNT(1) as count, SUM(duration) as total  FROM
	        deskofreservation
		WHERE deskofreservation.status in (1, 2 ,3) AND deskofreservation.deleted = 0
	        AND deskofreservation.cancel = 0 AND  year(datein) = ".$year . " ";
        
        echo $sql."\n\n";
        
        $query = $this->db->query ( $sql );
        $row = $query->row();
        $res_count = $row->count;
        $days_total = $row->total;
        
        
        $sql = "
	        SELECT currency, count(1) as count, sum((services_main.amount/deskofreservation.duration) ) as daytotal,
sum(duration) as duration
FROM  `deskofdays`
INNER JOIN deskofreservation ON deskofreservation.id = deskofdays.reservation_id
INNER JOIN services_main ON services_main.reservation_id = deskofreservation.id
inner join rate on rate.id = deskofreservation.price_type
            
WHERE year(datein) = ".$year . "  and deskofreservation.status in (1, 2, 3)
and deskofreservation.cancel =0 and deskofreservation.deleted = 0
group by rate.currency
	        ";
        
        //WHERE deskofdays.`intdate` >= 17134 and deskofdays.`intdate` <= 17134 and deskofreservation.status in (1, 2, 3)
        echo $sql;
        //die();
        $result = $this->db->query($sql);
        
        
        
        $data = array();
        
        $tblname= "dc_ostrovok_xml_cfg";
        
        $data['is_ostrovok'] = 0;
        $data['is_ostrovok_active'] = 0;
        $sql = "SELECT int_value  FROM " . $tblname . "
		WHERE name LIKE 'hotel_id'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row();
            $data['is_ostrovok'] = $row->int_value;
        }
        
        $sql = "SELECT int_value  FROM " . $tblname . "
		WHERE name LIKE 'general_update'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row();
            $data['is_ostrovok_active'] = $row->int_value;
        }
        
        foreach ($result->result() as $row) {
            $data['hms_id'] = $hms_id;
            $data['db_name'] = $db_name;
            $data['year'] = $year;
            //$data['month'] = $month;
            $data['res_count'] = $res_count;
            $data['days_total'] = $days_total;
            $data['currency'] = $row->currency;
            $data['adr'] = $row->daytotal / $row->count;
            $data['losavr'] = round($days_total / $res_count);
            //$data['is_ostrovok'] = $is_ostrovok;
            //$data['is_ostrovok_active'] = $is_ostrovok_active;
            
            // 	        $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc_adr (hms_id, db_name, year, month, 	res_count, days_total,
            // 	            currency, adr, losavr, is_ostrovok, is_ostrovok_active)
            // 			VALUES('".$hms_id."', '".$db_name."', '".$year."', '".$month."'
            // 			    , '".$data['res_count']."', '".$data['days_total']."'
            // 			        , '".$data['currency']."', '".$data['adr']."'
            // 			            , '".$data['losavr']."', '".$data['is_ostrovok']."'
            // 			                , '".$data['is_ostrovok_active']."'
            // 			        )
            // 			ON DUPLICATE KEY UPDATE db_name = '".$db_name."'
            // 			    , res_count = ".$data['res_count'].", days_total = ".$data['days_total']."
            // 			        , currency = ".$data['currency'].", adr = ".$data['adr']."
            // 			            , losavr = ".$data['losavr'].", is_ostrovok = ".$data['is_ostrovok']."
            // 			                , is_ostrovok_active = ".$data['is_ostrovok_active']."
            // 			        ";
            
            //$query = $this->db->query ( $sql_2 );
            
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc_adr_year (hms_id, db_name, year, 	res_count, days_total,
	            currency, adr, losavr, is_ostrovok, is_ostrovok_active)
			VALUES('".$hms_id."', '".$db_name."', '".$year."'
			    , '".$data['res_count']."', '".$data['days_total']."'
			        , '".$data['currency']."', '".$data['adr']."'
			            , '".$data['losavr']."', '".$data['is_ostrovok']."'
			                , '".$data['is_ostrovok_active']."'
			        )
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."'
			    , res_count = ".$data['res_count'].", days_total = ".$data['days_total']."
			        , currency = ".$data['currency'].", adr = ".$data['adr']."
			            , losavr = ".$data['losavr'].", is_ostrovok = ".$data['is_ostrovok']."
			                , is_ostrovok_active = ".$data['is_ostrovok_active']."
			        ";
            
            $query = $this->db->query ( $sql_2 );
            
            print_r($data);
        }
        
        die();
        
        
        $sql = "SELECT dc_id, COUNT(1) as count, SUM(amount) as total  FROM
	        deskofreservation
		WHERE deskofreservation.status in (1, 2 ,3) AND deskofreservation.deleted = 0
	        AND deskofreservation.cancel = 0 AND month(datein) = ".$month." and year(datein) = ".$year . " group by dc_id";
        //echo $sql."<br>";
        $query = $this->db->query ( $sql );
        
        foreach ($query->result() as $row) {
            //secho $hms_id." ".$year."/".$month." ".$row->total." ".$row->count;
            $sql_2 = "INSERT INTO `global_hotelix_analitycs`.annual_dc (hms_id, db_name, dc_id, year, month, total, count)
			VALUES('".$hms_id."', '".$db_name."', '".$row->dc_id."', '".$year."', '".$month."', '".$row->total."', '".$row->count."')
			ON DUPLICATE KEY UPDATE db_name = '".$db_name."', total = ".$row->total.", count = ".$row->count."";
            //echo $sql_2;
            $query = $this->db->query ( $sql_2 );
        }
    }
    function count_bso_by_month($db_name = "", $month_in = 0) {//рахує к-ть БСО за вказаний місяць, 2й параметр зсув місяців вліво
        $month = gmdate('m', strtotime("-".$month_in."month"));
        $year = gmdate('Y', strtotime("-".$month_in."month"));
        
        // 		$year = gmdate('Y', strtotime("-".((12 - (int)gmdate('m') + $month_in)%12)."year"));
        
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $this->frontdesk->timezone_set ();
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        //echo $sql;
        $query = $this->db->query ( $sql );
        
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
            
            $sql = "SELECT  *
					FROM bso_records
		      		WHERE month(date) =  " . $month . " AND year(date) = " . $year;
            
            $query = $this->db->query ( $sql );
            $count_bso = $query->num_rows ();
            $sql_2 = "INSERT INTO global_hotelix_analitycs.count_bso (hms_id, year, month, count_bso)
			                 VALUES('" . $hms_id . "', '" . $year . "', '" . $month . "', '" . $count_bso . "')
	               		     ON DUPLICATE KEY UPDATE count_bso = '" . $count_bso . "'";
            // echo $sql_2;
            $query = $this->db->query ( $sql_2 );
            echo "Year: ", $year, "<br>", "Month: ", $month, "<br>", "Count BSO: ", $count_bso, "<br>";
        }
    }
    function income_stats($db_name = "hotelix_test-hotel-dev_ZIP"){
        $target_tbl = "`global_hotelix_analitycs`.`income_stat`";
        $hms_id = 0;
        $periods = array(array('year' => "2017", 'month' => "12"),
            array('year' => "2018", 'month' => "1"),
            array('year' => "2018", 'month' => "2"));
        
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '".$db_name."'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        $sql_periods= array();
        foreach ($periods as $period){
            array_push($sql_periods, array( 'year' => date('Y', strtotime("first day of ".$period['year']."-".$period['month'])),
                'month' => date('m', strtotime("first day of ".$period['year']."-".$period['month'])),
                'start_date' => date('Y-m-d', strtotime("first day of ".$period['year']."-".$period['month'])),
                'end_date' => date('Y-m-d', strtotime("last day of ".$period['year']."-".$period['month']))
            ));
        }
        // 		print_r($sql_periods);
        $reult_arr = array();
        foreach ($sql_periods as $period){
            $reult_arr [$period['start_date']] ['hms_id'] = $hms_id;
            $reult_arr [$period['start_date']] ['year'] = $period['year'];
            $reult_arr [$period['start_date']] ['month'] = $period['month'];
            $sql = "SELECT COUNT(1) as count_all_res, SUM(amount) as amount_all_res
					FROM deskofreservation
					WHERE datein BETWEEN '" . $period['start_date'] . " 00:00:00' AND '".$period['end_date']." 00:00:00'
							AND cancel = 0 AND deleted = 0";
            $row = $this->db->query($sql)->row();
            $reult_arr [$period['start_date']] ['count_all_res'] = $row->count_all_res;
            $reult_arr [$period['start_date']] ['amount_all_res'] = is_null($row->amount_all_res) ? 0 : $row->amount_all_res;
            $sql = "SELECT COUNT(1) as count_checkouted, SUM(amount) as amount_checkouted
					FROM deskofreservation
					WHERE datein BETWEEN '" . $period['start_date'] . " 00:00:00' AND '".$period['end_date']." 00:00:00'
							AND cancel = 0 AND deleted = 0 AND status = 3";
            $row = $this->db->query($sql)->row();
            $reult_arr [$period['start_date']] ['count_checkouted'] = $row->count_checkouted;
            $reult_arr [$period['start_date']] ['amount_checkouted'] = is_null($row->amount_checkouted) ? 0 : $row->amount_checkouted;
            
            $sql = "SELECT SUM(payment.amount) pay_all_amount
					FROM deskofreservation
					LEFT JOIN payment ON payment.reservation_id = deskofreservation.id
					WHERE datein BETWEEN '" . $period['start_date'] . " 00:00:00' AND '".$period['end_date']." 00:00:00'
							AND cancel = 0 AND deleted = 0";
            $row = $this->db->query($sql)->row();
            $reult_arr [$period['start_date']] ['pay_all_amount'] = is_null($row->pay_all_amount) ? 0 : $row->pay_all_amount;
        }
        foreach ($reult_arr as $res_node){
            $sql_str = $this->db->insert_string($target_tbl, $res_node);
            $sql_str .= " ON DUPLICATE KEY ";
            $sql_str .= $this->db->update_string($target_tbl, $res_node, "1");
            $sql_str = str_replace( "$target_tbl SET", "", $sql_str );
            $sql_str = str_replace( " WHERE 1", "", $sql_str );
            echo "<pre>", $sql_str, "<br>";
            $this->db->query ( $sql_str );
            
        }
        echo "<pre>";
        print_r($reult_arr);
    }
    function import_hms_ids_from_xls_file() {/*імпорт hms ids для наралізу к-ті БСО і вставки в "`global_hotelix_analitycs`.`count_bso`"*/
        $data = array ();
        $this->parser->parse ( 'templates/debug/dc_cron_analytic_import_from_xls_file.html', $data );
    }
    function post_import_hms_ids_from_xls_file() { // ПОСТ імпорт hms ids для наралізу к-ті БСО
        $tab_number = $_POST ['tab_number'];
        include './application/libraries/xls/Classes/PHPExcel/IOFactory.php';
        //     	print_r($_FILES);
        //     	die();
        $inputFileName = $_FILES ['file_data'] ['tmp_name'];
        try {
            $inputFileType = PHPExcel_IOFactory::identify ( $inputFileName );
            $objReader = PHPExcel_IOFactory::createReader ( $inputFileType );
            $objPHPExcel = $objReader->load ( $inputFileName );
        } catch ( Exception $e ) {
            die ( 'Error loading file "' . pathinfo ( $inputFileName, PATHINFO_BASENAME ) . '": ' . $e->getMessage () );
        }
        // Get worksheet dimensions
        $sheet = $objPHPExcel->getSheet ( $tab_number - 1 );
        $highestRow = $sheet->getHighestRow ();
        $highestColumn = "A";//$sheet->getHighestColumn ();//
        $rowData = $sheet->rangeToArray ( 'A2:' . $highestColumn . $highestRow, NULL, FALSE, TRUE, TRUE );
        echo "<pre>";
        $table_content = array ();
        foreach ($rowData as $value){
            array_push($table_content, trim($value['A']));
            $insert_data = array('hms_id'=>trim($value['A']));
            $this->db->insert("`global_hotelix_analitycs`.`count_bso_hms_ids`", $insert_data);
        }
        // 		print_r($table_content);die;
        // 		$tmp_visual_result_arr = array();
        // 		//=======================================================================================
        // 		$global_tbl = "`global_hotelix_analitycs`.`count_bso`";
        // 		$insert_data_keys = array('hms_id', 'year', 'month');
        // 		$year = '';//'2018';
        // 		if (isset ( $_POST ["type"])) {
        // 			foreach ($table_content as $hms_id){
        // 				$sql = "SELECT db_name FROM `visitka`.config WHERE config.id =" . $hms_id;
        // 				$query = $this->db->query ( $sql );
        // 				if ($query->num_rows()>0){
        
        // 					$tmp_visual_result_arr[$hms_id] = array();
        
        // 					$db_name = $query->row()->db_name;
        // 					$counts_res_arr = $this->debugmodel->count_bso_local($db_name, 0, $year);
        // 					foreach ($counts_res_arr as $count_res_arr){
        
        // 						array_push($tmp_visual_result_arr[$hms_id], $count_res_arr);
        
        // 						$insert_data = array (
        // 								'hms_id' => $hms_id,
        // 								'year' => $count_res_arr ['year'],
        // 								'month' => $count_res_arr ['month'],
        // 								'count_bso' => $count_res_arr ['count_bso']
        // 						);
        // 						$this->debugmodel->db_insert_on_duplicate_key_update($global_tbl, $insert_data, $insert_data_keys);
        // 					}
        // 				}
        // 			}
        // 			echo "DB IS updated whith data:";
        // 		} else {
        // 			echo "DB is NOT updated whith data:";
        // 		}
        // 		//=======================================================================================
        echo '<br><a href="/dc_cron_analytic/import_hms_ids_from_xls_file"><input type="button" value="OK" /></a><br>';
        echo "<pre>";
        // 		print_r ( $tmp_visual_result_arr );
        print_r ( $table_content );
        echo '<br><a href="/dc_cron_analytic/import_hms_ids_from_xls_file"><input type="button" value="OK" /></a><br>';
    }
    function count_bso_from_tbl_count_bso_hms_ids($hms_id="", $year = "") {/*бере нмс_ід з `global_hotelix_analitycs`.`count_bso_hms_ids` рахує і вставляє в `count_bso`*/
        $global_tbl = "`global_hotelix_analitycs`.`count_bso`";
        $insert_data_keys = array('hms_id', 'year', 'month');
        $sql = "SELECT db_name FROM `visitka`.config WHERE config.id =" . $hms_id;
        $query = $this->db->query ( $sql );
        if ($query->num_rows()>0){
            $db_name = $query->row()->db_name;
            $counts_res_arr = $this->debugmodel->count_bso_local($db_name, 0, $year);
            foreach ($counts_res_arr as $count_res_arr){
                $insert_data = array (
                    'hms_id' => $hms_id,
                    'year' => $count_res_arr ['year'],
                    'month' => $count_res_arr ['month'],
                    'count_bso' => $count_res_arr ['count_bso']
                );
                $this->debugmodel->db_insert_on_duplicate_key_update($global_tbl, $insert_data, $insert_data_keys);
            }
        }
    }
    
    function make_activity_stat($db_name) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        $this->db = $this->load->database ( $config, true );
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        $query = $this->db->query("select min(time) as mint, max(time) as maxt from logauthip");
        $row = $query->row();
        echo 'first in: ',$row->mint . "\n", 'last in: ', $row->maxt . "\n";
        $first_in = round(strtotime($row->mint) / (60*60*24));
        $last_in = round(strtotime($row->maxt) / (60*60*24));
        
        $query = $this->db->query("select max(intday) as maxt from activity");
        $row = $query->row();
        echo 'last activity: ', date("Y-m-d", $row->maxt*60*60*24) . "\n";
        $last_activity = $row->maxt;
        
        $query = $this->db->query("select count(id) as total, max(date) as maxt from deskofreservation");
        $row = $query->row();
        echo 'orders total: ', $row->total . "\n", 'last order: ', $row->maxt . "\n";
        
        //$last_order = round(strtotime($row->maxt) / (60*60*24));
        
        $last_order = 0;
        if ($row->maxt != "") {
            list ($date, $time) = explode(" ", $row->maxt);
            if ($date != "") {
                list ( $year, $month, $day ) = explode ( "-", $date );
                $last_order = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            }
        }
        
        
        $order_count = $row->total;
        
        $query = $this->db->query("select value as payment_type from hotelix_config where name = 'stripe_billing_offline'");
        $payment_type = 0;
        
        if ($query->num_rows()>0){
            $row = $query->row();
            $payment_type = $row->payment_type;
        }
        
        $this->db->query("insert into global_hotelix_analitycs.activity_stat (hms_id, first_in, last_in, last_activity, order_count, last_order, payment_type)
            values ('$hms_id', '$first_in', '$last_in', '$last_activity', '$order_count', '$last_order', '$payment_type')
            on duplicate key update
            first_in = '$first_in', last_in = '$last_in', last_activity = '$last_activity', order_count = '$order_count', last_order = '$last_order', payment_type = '$payment_type'");
    }
    
    // 	function make_activity_stat($db_name) {// old version, to delete
    // 	    $config = array ();
    // 	    $config ['hostname'] = $this->config->item ( 'visitka_host' );
    // 	    $config ['username'] = $this->config->item ( 'visitka_user' );
    // 	    $config ['password'] = $this->config->item ( 'visitka_pass' );
    // 	    $config ['database'] = $db_name;
    // 	    $config ['dbdriver'] = "mysqli";
    // 	    $config ['dbprefix'] = "";
    // 	    $config ['pconnect'] = FALSE;
    // 	    $config ['db_debug'] = TRUE;
    // 	    $config ['cache_on'] = FALSE;
    // 	    $config ['cachedir'] = "";
    // 	    $config ['char_set'] = "utf8";
    // 	    $config ['dbcollat'] = "utf8_general_ci";
    
    // 	    $this->db = $this->load->database ( $config, true );
    
    
    // 	    $hms_id = 0;
    // 	    $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
    // 	    $query = $this->db->query ( $sql );
    // 	    if ($query->num_rows () > 0) {
    // 	        $row = $query->row ();
    // 	        $hms_id = $row->id;
    // 	    }
    
    
    
    // 	    $now = time();
    
    // 	    $query = $this->db->query("select min(time) as mint, max(time) as maxt from logauthip");
    // 	    $row = $query->row();
    // 	    echo $row->mint . "\n";
    // 	    echo $row->maxt . "\n";
    
    
    // 	    $begintime = strtotime($row->mint);
    // 	    $lasttime = strtotime($row->maxt);
    
    
    // 	    $first_in = round(($now - $begintime) / (60*60*24));
    // 	    $last_in = round(($now - $lasttime) / (60*60*24));
    
    // 	    echo round(($now - $begintime) / (60*60*24)) . "\n";
    // 	    echo round(($now - $lasttime) / (60*60*24)) . "\n";
    
    // 	    $query = $this->db->query("select min(data) as mint, max(data) as maxt from loger");
    // 	    $row = $query->row();
    // 	    echo $row->mint . "\n";
    // 	    echo $row->maxt . "\n";
    
    // 	    $begintime = strtotime($row->mint);
    // 	    $lasttime = strtotime($row->maxt);
    
    // 	    echo round(($now - $begintime) / (60*60*24)) . "\n";
    // 	    echo round(($now - $lasttime) / (60*60*24)) . "\n";
    
    // 	    $last_activity = round(($now - $lasttime) / (60*60*24));
    
    
    // 	    $query = $this->db->query("select count(id) as total, max(date) as maxt from deskofreservation");
    // 	    $row = $query->row();
    // 	    echo $row->total . "\n";
    // 	    echo $row->maxt . "\n";
    
    
    // 	    $lasttime = strtotime($row->maxt);
    
    // 	    echo $row->total . "\n";
    // 	    echo round(($now - $lasttime) / (60*60*24)) . "\n";
    
    // 	    $order_count = $row->total;
    // 	    $last_order = round(($now - $lasttime) / (60*60*24));
    
    // 	    $this->db->query("insert into global_hotelix_analitycs.activity_stat (hms_id, first_in, last_in, last_activity, order_count, last_order)
    // 	        values ($hms_id, $first_in, $last_in, $last_activity, $order_count, $last_order)
    // 	        on duplicate key update
    // 	        first_in = $first_in, last_in = $last_in, last_activity = $last_activity, order_count = $order_count, last_order = $last_order");
    // 	}
    
    function make_stat_01($db_name = "")
    {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        
        $hotel_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hotel_id = $row->id;
        }
        
        $categories_rooms_data = $this->frontdesk_c2->get_category_active_rooms_count(1);
        $channels_data = $this->mstats->get_active_channels();
        
        //         echo "<pre>";
        //         print_r($categories_rooms_data);
        //         print_r($channels_data);
        
        $all_room_count = 0;
        $category_count = 0;
        foreach($categories_rooms_data as $cat_id => $rooms_count){
            $all_room_count += $rooms_count;
            $category_count ++;
        }
        
        $db_data = array();
        $db_data ["hms_id"] = $hotel_id;
        $db_data ["room_count"] = $all_room_count;
        $db_data ["category_count"] = $category_count;
        $db_data ["dc_channel_count"] = $channels_data["count_active_dc_channels"];
        
        foreach($channels_data["dc_channels_active"] as $dc_id => $cell){
            $db_data ["dc_".$dc_id."_active"] = $cell["active"];
        }
        
        //print_r($db_data);
        //die();
        $updt_str = '';
        foreach ($db_data as $k => $v) {
            $updt_str = $updt_str.' '.$k.' = '.$v.',';
        }
        $updt_str = substr_replace($updt_str,";", -1);
        $this->db->query($this->db->insert_string('global_hotelix_analitycs.stat_01', $db_data).' ON DUPLICATE KEY UPDATE '.$updt_str);
        //$this->db->on_duplicate('global_hotelix_analitycs.stat_01', $db_data);
    }
    function get_local_activity_update_global_activity($db_name = "", $past_days = 1) {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
            }
        }else {
            $hms_id = $this->config->item('hotel_id');
        }
        $start_date = date("Y-m-d", strtotime("-$past_days day"));
        $sql = "SELECT *
        FROM activity
        WHERE intday * 86400 >= UNIX_TIMESTAMP('$start_date')";
        $query_result = $this->db->query($sql)->result_array();
        $tbl_name = "`global_hotelix_analitycs`.`activity_hms_ids`";
        $keys = array('hms_id',	'intday');
        foreach ($query_result as $value) {
            $insert_data = array (
                'hms_id' => $hms_id,
                'intday' => $value ['intday'],
                'count_view' => $value ['count_view'],
                'count_edit' => $value ['count_edit'],
            );
            $this->debugmodel->db_insert_on_duplicate_key_update($tbl_name, $insert_data, $keys);
        }
        echo "table $tbl_name was updated hms_id - $hms_id data /n/n";
    }
    
    function property_info ($db_name = "") {
        if ($db_name != ""){
            $config = array();
            $config['hostname'] = $this->config->item('visitka_host');
            $config['username'] = $this->config->item('visitka_user');
            $config['password'] = $this->config->item('visitka_pass');
            $config['database'] = $db_name;
            $config['dbdriver'] = "mysqli";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";
            $this->db = $this->load->database($config, true);
            $hms_id = 0;
            $host = "";
            $sql = "SELECT id, host FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $hms_id = $row->id;
            }
        }else {
            $hms_id = $this->config->item('hotel_id');
        }
        $sql = "SELECT * FROM property_information";
        $query_result = $this->db->query($sql)->result_array();
        $tbl_name = "`global_hotelix_analitycs`.`properties_info`";
        $keys = array('hms_id',	'id');
        if (empty($query_result)){
            $insert_data['hms_id'] = $hms_id;
            $insert_data['id'] = 0;
            $insert_data['property_name'] = "-";
            $this->debugmodel->db_insert_on_duplicate_key_update($tbl_name, $insert_data, $keys);
        }else{
            foreach ($query_result as $value) {
                $insert_data = $value;
                $insert_data['hms_id'] = $hms_id;
                $this->debugmodel->db_insert_on_duplicate_key_update($tbl_name, $insert_data, $keys);
            }
        }
        echo "table $tbl_name was updated hms_id - $hms_id data /n/n";
    }
    
    function for_tvil($db_name) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        
        $sql = "SELECT month(datein) as month, year(datein) as year, count(1) as total, sum(duration) as days
FROM  `deskofreservation`
WHERE  `datein` >=  '2018-01-01'
AND  `datein` <  '2019-12-31'
AND  `status`
IN ( 1, 2, 3 ) group by month, year";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            
            $data = array();
            $data['hms_id'] = $hms_id;
            $data['month'] = $row->month;
            $data['year'] = $row->year;
            
            $this->db->delete("global_hotelix_analitycs.for_tvil", $data);
            
            $data['days'] = $row->days;
            $data['total'] = $row->total;
            
            print_r($data);
            //$this->db->query("delete from global_hotelix_analitycs.for_tvil");
            
            $this->db->insert('global_hotelix_analitycs.for_tvil', $data);
        }
    }
    
    function for_tvil_2($db_name) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        
        $sql = "SELECT month(datein) as month, year(datein) as year, count(1) as total, sum(duration) as days
FROM  `deskofreservation`
WHERE  `datein` >=  '2018-01-01'
AND  `datein` <  '2019-12-31'
AND  `status`
IN ( 1, 2, 3 ) group by month, year";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            
            $data = array();
            $data['hms_id'] = $hms_id;
            $data['month'] = $row->month;
            $data['year'] = $row->year;
            
            $this->db->delete("global_hotelix_analitycs.for_tvil_2", $data);
            
            $data['days'] = $row->days;
            $data['total'] = $row->total;
            
            print_r($data);
            //$this->db->query("delete from global_hotelix_analitycs.for_tvil");
            
            $this->db->insert('global_hotelix_analitycs.for_tvil_2', $data);
        }
    }
    
    
    
    
    function make_stats_dc_orders_v2 ($db_name, $channel_id, $year = "", $month = ""){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            $hms_id =  $row->id;
        }
        
        if($month == "" && $year == ""){
            $month = date('m') == 1 ? 12 : (date('m') - 1);
            $year = date('m') == 1 ? (date('Y') - 1) : date('Y');
        }
        echo $month."/".$year."<br>";
        // 21 - c-booking
        // 24 - axis travel
        
        //$channel_id = 21;
        
        $sql = "SELECT $hms_id as hms_id, deskofreservation.id as hms_res_id, deskofreservation.dc_id, deskofreservation.dc_reservationid as dc_booking_id,
        deskofreservation.datein, deskofreservation.dateout, deskofreservation.amount, guests.firstname as guest_firstname,
        guests.lastname as guest_lastname, IF((deskofreservation.deleted = 1 OR deskofreservation.cancel = 1), 1, 0) as iscanceled
        FROM deskofreservation
        INNER JOIN guests ON guests.id = deskofreservation.guest_id
        WHERE deskofreservation.dc_id = $channel_id AND YEAR(deskofreservation.dateout) = $year AND MONTH(deskofreservation.dateout) = $month";
        //WHERE deskofreservation.dc_id = $channel_id ";
        //echo $sql;
        //die();
        $query = $this->db->query ( $sql );
        $result_array = array();
        if ($query->num_rows () > 0) {
            $result_array = $query->result_array ();
        }
        //echo "<pre>";
        //print_r($result_array);
        foreach($result_array as $cell){
            
            $sql = "INSERT INTO global_hotelix_analitycs.stats_dc_orders (hms_id, hms_res_id, dc_id, dc_booking_id, guest_firstname, guest_lastname,
	        datein, dateout, amount, iscanceled)
	        VALUES('".$cell["hms_id"]."', '".$cell["hms_res_id"]."', '".$cell["dc_id"]."', '".$cell["dc_booking_id"]."',
	        '".$cell["guest_firstname"]."', '".$cell["guest_lastname"]."', '".$cell["datein"]."', '".$cell["dateout"]."',
	        '".$cell["amount"]."', '".$cell["iscanceled"]."')
	        ON DUPLICATE KEY UPDATE dc_id = '".$cell["dc_id"]."', dc_booking_id = '".$cell["dc_booking_id"]."', guest_firstname = '".$cell["guest_firstname"]."',
	        guest_lastname = '".$cell["guest_lastname"]."', datein = '".$cell["datein"]."', dateout = '".$cell["dateout"]."', amount = '".$cell["amount"]."',
	        iscanceled = '".$cell["iscanceled"]."'";
            $query = $this->db->query ( $sql );
            
        }
        // 	    if(count($result_array) > 0){
        // 	        $this->db->insert_batch('global_hotelix_analitycs.stats_dc_orders', $result_array);
        // 	    }
    }
    
    function make_stats_dc_orders ($db_name, $channel_id, $year, $month){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            $hms_id =  $row->id;
        }
        
        // 21 - c-booking
        // 24 - axis travel
        
        //$channel_id = 21;
        
        $sql = "SELECT $hms_id as hms_id, deskofreservation.id as hms_res_id, deskofreservation.dc_id, deskofreservation.dc_reservationid as dc_booking_id,
        deskofreservation.datein, deskofreservation.dateout, deskofreservation.amount, guests.firstname as guest_firstname,
        guests.lastname as guest_lastname, IF((deskofreservation.deleted = 1 OR deskofreservation.cancel = 1), 1, 0) as iscanceled
        FROM deskofreservation
        INNER JOIN guests ON guests.id = deskofreservation.guest_id
        
        WHERE deskofreservation.dc_id = $channel_id ";
        //WHERE deskofreservation.dc_id = $channel_id AND YEAR(deskofreservation.dateout) = $year AND MONTH(deskofreservation.dateout) = $month";
        // 	    echo $sql;
        
        $query = $this->db->query ( $sql );
        $result_array = array();
        if ($query->num_rows () > 0) {
            $result_array = $query->result_array ();
        }
        // 	    echo "<pre>";
        // 	    print_r($result_array);
        foreach($result_array as $cell){
            
            $sql = "INSERT INTO global_hotelix_analitycs.stats_dc_orders (hms_id, hms_res_id, dc_id, dc_booking_id, guest_firstname, guest_lastname,
	        datein, dateout, amount, iscanceled)
	        VALUES('".$cell["hms_id"]."', '".$cell["hms_res_id"]."', '".$cell["dc_id"]."', '".$cell["dc_booking_id"]."',
	        '".$cell["guest_firstname"]."', '".$cell["guest_lastname"]."', '".$cell["datein"]."', '".$cell["dateout"]."',
	        '".$cell["amount"]."', '".$cell["iscanceled"]."')
	        ON DUPLICATE KEY UPDATE dc_id = '".$cell["dc_id"]."', dc_booking_id = '".$cell["dc_booking_id"]."', guest_firstname = '".$cell["guest_firstname"]."',
	        guest_lastname = '".$cell["guest_lastname"]."', datein = '".$cell["datein"]."', dateout = '".$cell["dateout"]."', amount = '".$cell["amount"]."',
	        iscanceled = '".$cell["iscanceled"]."'";
            $query = $this->db->query ( $sql );
            
        }
        // 	    if(count($result_array) > 0){
        // 	        $this->db->insert_batch('global_hotelix_analitycs.stats_dc_orders', $result_array);
        // 	    }
    }
    
    function hapaj_babaj(){
        $days_value = 5;
        $hms_ids = array(13553, 13785, 13875);
        $hms_ids = array(13553, 13785, 13875, 13814, 13861, 13867, 14014, 13894, 13899, 13972, 13983, 13809);
        
        $date_from = date("Y-m-d", mktime( 0, 0, 0, date('m'), date('d') - $days_value, date('Y') ));
        
        foreach($hms_ids as $hms_id){
            $db_name = "";
            $sql = "SELECT config.db_name FROM visitka.config WHERE id = " . $hms_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $db_name = $row->db_name;
            }
            
            if($db_name != ""){
                $config = array ();
                $config ['hostname'] = $this->config->item ( 'visitka_host' );
                $config ['username'] = $this->config->item ( 'visitka_user' );
                $config ['password'] = $this->config->item ( 'visitka_pass' );
                $config ['database'] = $db_name;
                $config ['dbdriver'] = "mysqli";
                $config ['dbprefix'] = "";
                $config ['pconnect'] = FALSE;
                $config ['db_debug'] = TRUE;
                $config ['cache_on'] = FALSE;
                $config ['cachedir'] = "";
                $config ['char_set'] = "utf8";
                $config ['dbcollat'] = "utf8_general_ci";
                
                $this->db = $this->load->database ( $config, true );
                
                $sql = "SELECT * FROM logauthip WHERE time > '$date_from'";
                $query = $this->db->query($sql);
                foreach ($query->result() as $row) {
                    $sql2 = "INSERT INTO global_hotelix_analitycs.hms_logauthip (hms_id, id_user, username, ip, response, time)
                    VALUES($hms_id, '".$row->id_user."', '".$row->username."', '".$row->ip."', '".$row->response."', '".$row->time."')";
                    $this->db->query($sql2);
                }
            }
        }
    }
    
    function check_reservation_without_deskofdays ($db_name = ""){
        $db_name = $db_name == "" ? $this->db->database : $db_name;
        
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query( $sql );
        if ($query->num_rows() > 0)
        {
            $row = $query->row();
            $hms_id =  $row->id;
        }
        
        $date_now = date('Y-m-d');
        
        $sql = "SELECT $hms_id as hms_id, deskofreservation.id as hms_res_id
        FROM deskofreservation
        WHERE deskofreservation.cancel = 0 AND deskofreservation.deleted = 0
        AND deskofreservation.dateout > '$date_now' AND deskofreservation.id NOT IN (SELECT reservation_id FROM deskofdays)";
        
        // 	    $sql = "SELECT $hms_id AS hms_id, deskofreservation.id AS hms_res_id
        // FROM deskofreservation
        // LEFT JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
        // WHERE deskofreservation.cancel = 0
        // AND deskofreservation.deleted = 0
        // AND deskofreservation.dateout > '$date_now'
        // AND deskofdays.reservation_id IS NULL";
        // 	    echo $sql;
        // die();
        $query = $this->db->query ( $sql );
        $result_array = array();
        if ($query->num_rows () > 0) {
            $result_array = $query->result_array ();
        }
        
        echo "<pre>";
        print_r($result_array);
    }
    
    function parse_payments_xls()
    {
        $file_path = "/tmp/test_expedia.xlsx";
        if (file_exists($file_path)) {
            echo "Файл $file_path существует";
        } else {
            echo "Файл $file_path не существует";
        }
        
        include './application/libraries/xls/Classes/PHPExcel/IOFactory.php';
        
        $inputFileName = $file_path;
        
        try {
            $inputFileType = PHPExcel_IOFactory::identify ( $inputFileName );
            $objReader = PHPExcel_IOFactory::createReader ( $inputFileType );
            $objPHPExcel = $objReader->load ( $inputFileName );
        } catch ( Exception $e ) {
            die ( 'Error loading file "' . pathinfo ( $inputFileName, PATHINFO_BASENAME ) . '": ' . $e->getMessage () );
        }
        //die();
        $sheet = $objPHPExcel->getSheet ( 0 );
        //echo "<pre>";
        //print_r($sheet);
        //die();
        $highestRow = $sheet->getHighestRow ();
        $highestColumn = $sheet->getHighestColumn ();
        $rowData = $sheet->rangeToArray ( 'A1:' . $highestColumn . '1', NULL, FALSE, TRUE, TRUE ); // get titles, 1 row
        $data = array ();
        for ($row = 2; $row <= $highestRow; $row ++) { // Loop through each row of the worksheet in turn from 2
            // Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, FALSE, FALSE, TRUE);
            // Insert row data array into your database of choice here
            //print_r($rowData);
            //die();
            
            if($rowData[$row]['D'] != ""){
                list($hms_id, $reservation_id) = explode("-", $rowData[$row]['D']);
                array_push($data, array(
                    'hms_id' => $hms_id,
                    'reservation_id' => $reservation_id
                ));
            }
        }
        
        $this->db->insert_batch('global_hotelix_analitycs.hotel_payments', $data);
        
        echo "Дані записані в базу";
        
        echo "<pre>";
        print_r($data);
    }
    
    function translate_lithuania_xls()
    {
        $file_path = "/tmp/language_ltu.xlsx";
        if (file_exists($file_path)) {
            echo "Файл $file_path существует";
        } else {
            echo "Файл $file_path не существует";
        }
        
        include './application/libraries/xls/Classes/PHPExcel/IOFactory.php';
        
        $inputFileName = $file_path;
        
        try {
            $inputFileType = PHPExcel_IOFactory::identify ( $inputFileName );
            $objReader = PHPExcel_IOFactory::createReader ( $inputFileType );
            $objPHPExcel = $objReader->load ( $inputFileName );
        } catch ( Exception $e ) {
            die ( 'Error loading file "' . pathinfo ( $inputFileName, PATHINFO_BASENAME ) . '": ' . $e->getMessage () );
        }
        //die();
        $sheet = $objPHPExcel->getSheet ( 0 );
        //         echo "<pre>";
        //         print_r($sheet);
        //         die();
        $highestRow = $sheet->getHighestRow ();
        $highestColumn = $sheet->getHighestColumn ();
        $rowData = $sheet->rangeToArray ( 'A1:' . $highestColumn . '1', NULL, FALSE, TRUE, TRUE ); // get titles, 1 row
        $data = array ();
        for ($row = 2; $row <= $highestRow; $row ++) { // Loop through each row of the worksheet in turn from 2
            // Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, FALSE, FALSE, TRUE);
            // Insert row data array into your database of choice here
            //             print_r($rowData);
            //             die();
            
            if($rowData[$row]['B'] != ""){
                
                array_push($data, array(
                    'page' => $rowData[$row]['B'],
                    'caption' => $rowData[$row]['C'],
                    'lang_lit' => $rowData[$row]['D'],
                ));
                
                $sql = "UPDATE global_hotelix_languages.languages222 SET lang_lit = '".addslashes($rowData[$row]['D'])."' WHERE page LIKE '".$rowData[$row]['B']."'
                        AND caption LIKE '".addslashes($rowData[$row]['C'])."'";
                $query = $this->db->query ( $sql );
            }
        }
        //echo "<pre>";
        //print_r($data);
        //die();
        
        //$this->db->update_batch('global_hotelix_languages.languages222', $data, array('page', 'caption'));
        
        echo "Дані записані в базу";
        
        echo "<pre>";
        print_r($data);
    }
    
    function check_lost_payments(){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = "visitka";
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        
        $sql = "SELECT * FROM global_hotelix_analitycs.hotel_payments WHERE state = 0";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $i = 0;
            foreach ( $query->result () as $row ) {
                $sql2 = "SELECT db_name FROM visitka.config WHERE id = ".$row->hms_id;
                $query2 = $this->db->query ( $sql2 );
                if ($query2->num_rows () != 0) {
                    $row2 = $query2->row ();
                    $db_name = $row2->db_name;
                    
                    $sql3 = "SELECT id as pay_id FROM $db_name.payment WHERE reservation_id = ".$row->reservation_id;
                    $query3 = $this->db->query ( $sql3 );
                    if ($query3->num_rows () != 0) {
                        $update_data = array(
                            'state' => 1
                        );
                        $where_data = array(
                            'reservation_id' => $row->reservation_id,
                            'hms_id' => $row->hms_id,
                        );
                        $this->db->update('global_hotelix_analitycs.hotel_payments', $update_data, $where_data);
                    }
                }
            }
        }
    }
    
    public function airbnb_wo_response() {
        echo "<pre>";
        $query = $this->db->select('id, hms_url')->get_where('dc_booking.airbnb_hms_hotels', array())->result();
        $i = 0;
        $j = 0;
        foreach ($query as $row) {
            $j++;
            echo $j . " - (" . $i . ") ";
            //echo $row->hms_url . " - ";
            $data = array();
            $url = $row->hms_url . "dc_airbnb_gate/check_refresh";
            
            $result = $this->Curl_model->CurlPlugRaw_clean( json_encode ( $data ), $url);
            if ($result == "EMPTY") {
                echo $result;
                $this->db->update('dc_booking.airbnb_hms_hotels', array('refresh'=>0), array('id'=>$row->id));
            } else {
                if ($result == "OK!") {
                    $i++;
                    echo $result;
                    $this->db->update('dc_booking.airbnb_hms_hotels', array('refresh'=>1), array('id'=>$row->id));
                } else {
                    echo "WRONG";
                    $this->db->update('dc_booking.airbnb_hms_hotels', array('refresh'=>-1), array('id'=>$row->id));
                }
            }
            
            echo " - " . $url . "";
            echo "\n";
        }
        
        //echo $query->num_rows() . " - " . $i;
    }
    
    function airbnb_task_17784728_all(){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = "dc_booking";
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        
        $sql = "SELECT db_name, host, id as hms_hotel_id FROM visitka.config WHERE bup=1";
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row ) {
            $host = $row->host;
            if(trim($row->db_name) != ""){
                $array_info = array();
                
                $hms_id = $row->hms_hotel_id;
                $db_name = $row->db_name;
                $this->db->where('hms_id', $hms_id);
                $this->db->delete('global_hotelix_analitycs.airbnb_task_17784728');
                
                $global_language = $this->db->select('value')->get_where($db_name.'.hotelix_config', array('name'=>"global_language"))->row()->value;
                
                
                $sql = "SELECT property_information.id as property_id, categories.id as category_id,
                property_information.street, property_information.gps_coordinates, property_information.city,
                property_information.additional_information, property_information.post_code,
                property_information.state, property_information.country, property_information.property_name,
                property_information.reception_phone, property_information.email
                FROM `$db_name`.property_information
                INNER JOIN `$db_name`.categories ON property_information.id = categories.property_id
                INNER JOIN `$db_name`.rooms ON rooms.category_id = categories.id
                WHERE categories.is_active = 1 AND property_information.country <> '' AND property_information.city <> ''
                GROUP BY property_information.id, categories.id";
                //echo $sql."<br>";
                //                 die();
                $query = $this->db->query ( $sql );
                if ($query->num_rows () > 0) {
                    foreach ( $query->result () as $row ) {
                        $category_name_arr = array();
                        $sql2 = "SELECT language_id, value FROM `$db_name`.internationalfields
                        WHERE table_type LIKE 'category' AND name LIKE 'international_name'
                        AND table_id = ".$row->category_id . " AND language_id = ".$global_language;
                        $query2 = $this->db->query( $sql2 );
                        if($query2->num_rows() > 0){
                            foreach ( $query2->result () as $row2 ) {
                                $category_name_arr[$row2->language_id] = $row2->value;
                            }
                        }
                        
                        $category_name = isset($category_name_arr[$global_language]) ? $category_name_arr[$global_language] : "";
                        
                        $property_name = ($row->property_name == '') ? '' : $row->property_name;
                        $additional_information = ($row->additional_information == '') ? '' : $row->additional_information;
                        $state = ($row->state == '') ? '' : $row->state;
                        $city = ($row->city == '') ? '' : $row->city;
                        $post_code = ($row->post_code == '') ? '' : $row->post_code;
                        $country = ($row->country == '') ? '' : $row->country;
                        $reception_phone = ($row->reception_phone == '') ? '' : $row->reception_phone;
                        $email = ($row->email == '') ? '' : $row->email;
                        $gps_coordinates = ($row->gps_coordinates == '') ? '' : $row->gps_coordinates;
                        
                        array_push($array_info, array(
                            "hms_id" => $hms_id,
                            "category" => $category_name,
                            "property" => $property_name,
                            "address" => $additional_information,
                            "state" => $state,
                            "city" => $city,
                            "zip" => $post_code,
                            "country" => $country,
                            "phone" => $reception_phone,
                            "email" => $email,
                            "gps" => $gps_coordinates
                        ));
                    }
                }
                if(count($array_info) > 0)
                    $this->db->insert_batch('global_hotelix_analitycs.airbnb_task_17784728', $array_info);
                    
                    //                 $url = "https://" . $row->host . "/dc_airbnb_gate/check_categories";
                    //                 $data = array();
                    //                 $result = $this->Curl_model->CurlPlugRaw_clean( json_encode ( $data ), $url);
                    
                    //                 $array_info = json_decode($result, true);
                    //                 $this->db->insert_batch('global_hotelix_analitycs.airbnb_task_17784728', $array_info);
                    
                    
            }
        }
        
    }
    
    function airbnb_task_17784728($db_name){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = $this->db->select('id')->get_where('visitka.config', array('db_name'=>$db_name))->row()->id;
        
        $global_language = $this->hotelix_config->get_record("global_language", "int");
        
        $array_info = array();
        $sql = "SELECT property_information.id as property_id, categories.id as category_id,
        property_information.street, property_information.gps_coordinates, property_information.city,
        property_information.additional_information, property_information.post_code,
        property_information.state, property_information.country, property_information.property_name,
        property_information.reception_phone, property_information.email
        FROM property_information
        INNER JOIN categories ON property_information.id = categories.property_id
        INNER JOIN rooms ON rooms.category_id = categories.id
        WHERE categories.is_active = 1 AND property_information.country <> '' AND property_information.city <> ''";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            foreach ( $query->result () as $row ) {
                $category_name_arr = $this->internationalfields->get_value("category", $row->category_id, "international_name", $global_language);
                
                $category_name = isset($category_name_arr[$global_language]) ? $category_name_arr[$global_language] : "";
                
                array_push($array_info, array(
                    "hms_id" => $hms_id,
                    "category" => $category_name,
                    "property" => $row->property_name,
                    "address" => $row->additional_information,
                    "state" => $row->state,
                    "city" => $row->city,
                    "zip" => $row->post_code,
                    "country" => $row->country,
                    "phone" => $row->reception_phone,
                    "email" => $row->email,
                    "gps" => $row->gps_coordinates
                ));
            }
        }
        
        
        $this->db->insert_batch('global_hotelix_analitycs.airbnb_task_17784728', $array_info);
    }
    
    function get_users_active_emails($db_name = "") {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $id_country_3c = "";
        $sql = "SELECT id, id_country_3c FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hms_id = $row->id;
            $id_country_3c = $row->id_country_3c;
        }
        
        $lang_code = 0;
        $sql = "SELECT value as lang_code FROM  hotelix_config WHERE name LIKE 'global_language'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $lang_code = $row->lang_code;
        }
        
        $config_language = "";
        if($lang_code != 0){
            $sql = "SELECT 3char as languages_3char FROM global_hotelix.dic_languages WHERE code = ".$lang_code;
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $row = $query->row();
                $config_language = $row->languages_3char;
            }
        }
        
        $query = $this->db->query("SELECT login, language FROM users");
        foreach ($query->result() as $row) {
            $email = filter_var($row->login, FILTER_SANITIZE_EMAIL);
            if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $insert_data = array(
                    'hms_id' => $hms_id,
                    'email' => $row->login,
                    'country' => $id_country_3c,
                    'user_language' => $row->language,
                    'config_language' => $config_language
                );
                $this->db->insert('global_hotelix_analitycs.users_emails_active', $insert_data);
            }
        }
    }
    
    public function airbnb_blocked_client_list($db_name = "") {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        echo $db_name . " - ";
        $this->db = $this->load->database ( $config, true );
        $database_exist_row = $this->db->query("SELECT id AS hms_id FROM visitka.config WHERE db_name LIKE '$db_name'")->row();
        if ($database_exist_row){
            $hms_id = $database_exist_row->hms_id;
            echo  $hms_id . " - ";
            
            $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
            if ($user_id == 0) {
                echo "zero_user_id - " . "";
                
                $row = $this->db->get_where("global_hotelix_analitycs.airbnb_hms_hotels", array('dbname'=>$db_name))->row();
                if ($row) {
                    if ($row->user_id != 0) {
                        echo " update_user_id=" . $row->user_id . " - ";
                        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '" . $row->user_id . "')
                            on duplicate key update int_value='" . $row->user_id . "'");
                    }
                }
            }
            $refresh_token = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
            
            if (strlen($refresh_token) == 0) {
                echo $refresh_token . "=zero_refresh_token - " . "";
            } else {
                echo $refresh_token . " - ";
            }
            
            $this->dcm_airbnb->validate_token();
            $authparam = $this->dcm_airbnb->authparam();
            $curl_auth_param = array();
            $curl_auth_param ['clientid'] = $authparam['clientid'];
            $curl_auth_param ['access_token'] = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
            $url = "https://api.airbnb.com/v2/listings/?user_id=$user_id&has_availability=false&exclude_cohosted_listings=true&_limit=50";
            $data_result = $this->curl_model->curl_airbnb(array(), $curl_auth_param, $url, array ("returntype" => "array"));
            $result = $data_result["result"];
            $result = json_decode($result, true);
            if (isset($result['listings'])) {
                echo sizeof($result['listings']) . " listing - " . "";
            }
            if (isset($result["error"]) && $result["error"] == 'suspended_state_appeal') {
                $tbl = "global_hotelix_analitycs.airbnb_suspended_state_clients";
                $this->db->insert($tbl, array('hms_id'=>$hms_id));
                echo " =REDIRECT= - ";
            }
            
            echo "\n";
        }
    }
    
    public function update_global_listing2imports_table_by_cron($db_name = "") {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        echo $db_name . " - ";
        $this->db = $this->load->database ( $config, true );
        $database_exist_row = $this->db->query("SELECT id AS hms_id FROM visitka.config WHERE db_name LIKE '$db_name'")->row();
        if ($database_exist_row){
            $hms_id = $database_exist_row->hms_id;
            echo  $hms_id . " - ";
            
            $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
            if ($user_id == 0) {
                echo "zero_user_id - " . "";
                
                $row = $this->db->get_where("global_hotelix_analitycs.airbnb_hms_hotels", array('dbname'=>$db_name))->row();
                if ($row) {
                    if ($row->user_id != 0) {
                        echo " update_user_id=" . $row->user_id . " - ";
                        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '" . $row->user_id . "')
                            on duplicate key update int_value='" . $row->user_id . "'");
                    }
                }
            }
            $tbl = 'dc_booking.dc_airbnb_hmsid2listing2imports';
            $this->dcm_airbnb->validate_token();
            $authparam = $this->dcm_airbnb->authparam();
            $max_loop_cycles = 10;
            $next_cursor = '';
            $curl_auth_param = array();
            $curl_auth_param ['clientid'] = $authparam['clientid'];
            $curl_auth_param ['access_token'] = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
            do {
                $max_loop_cycles --;
                $url = "https://api.airbnb.com/v2/listings/?user_id=$user_id&has_availability=false&exclude_cohosted_listings=true&_limit=50$next_cursor";
                $data_result = $this->curl_model->curl_airbnb(array(), $curl_auth_param, $url, array ("returntype" => "array"));
                $result = $data_result["result"];
                $result = json_decode($result, true);
                if (isset($result["listings"])) {
                    foreach($result["listings"] as $listing){
                        $insert_arr = array (
                            'listing_id' => $listing ["id"],
                            'hms_id' => $hms_id
                        );
                        
                        // ======== DELETE =========
                        $this->db->where(array('listing_id' => $insert_arr['listing_id'], 'hms_id <>' => $hms_id));
                        $this->db->delete($tbl);
                        // ======== UPDATE / INSERT =========
                        $where_arr = array('listing_id'=>$insert_arr['listing_id'], 'hms_id'=>$hms_id);
                        $exist_hmsid_to_listingid = $this->db->get_where($tbl, $where_arr)->row();
                        if ($exist_hmsid_to_listingid){
                            $this->db->update($tbl, $insert_arr, $where_arr);
                            echo " listing - " .$listing ["id"]. " - updated \n";
                        }else{
                            $this->db->insert($tbl, $insert_arr);
                            echo " listing - " .$listing ["id"]. " - inserted \n";
                        }
                    }
                }
                $need_looping = false;
                if(isset($result['paging']['next_cursor']) && ($result['paging']['next_cursor'] != '' || $result['paging']['next_cursor'] != null)){
                    $need_looping = true;
                    $next_cursor = '&_cursor='.$result['paging']['next_cursor'];
                }
            } while ($need_looping && $max_loop_cycles > 0);
            echo "\n\n";
        }
    }
    
    public function get_duplicates_global_listing2imports_table_by_cron() {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = "dc_booking";
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $double_listings = array();
        $sql = "SELECT s1.listing_id, dc_airbnb_hmsid2listing2imports.hms_id FROM
(SELECT `listing_id` , COUNT( 1 ) AS doubles
FROM dc_airbnb_hmsid2listing2imports
GROUP BY listing_id
) AS s1
INNER JOIN dc_airbnb_hmsid2listing2imports ON dc_airbnb_hmsid2listing2imports.listing_id = s1.listing_id AND s1.doubles > 1";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $double_listings [$row->listing_id][$row->hms_id] = 1;
        }
        
        echo "<pre>";
        print_r($double_listings);
        die();
    }
    
    function get_dc_range_amount($db_name = "", $range = 30) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT id, id_country_3c FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            $hms_id = $row->id;
        }
        
        $now_date = date("Y-m-d");
        $date_from = date("Y-m-d", mktime ( 0, 0, 0, date("m"), date("d") - $range, date("Y")));
        
        $sql = "SELECT deskofreservation.dc_payment_method, deskofreservation.dc_currencycode, deskofreservation.dc_totalprice,
                deskofreservation.id as res_id, deskofreservation.dc_id, payment_deffered.id as pay_deff_id
                FROM deskofreservation
                LEFT JOIN tbl_CreditCards ON tbl_CreditCards.reservation_id = deskofreservation.id
                LEFT JOIN payment_deffered ON payment_deffered.tcc_id = tbl_CreditCards.id
                WHERE dc_id IN(1, 3) AND cancel = 0 AND
                deskofreservation.datein BETWEEN '" . $date_from . " 00:00:00' AND '" . $now_date . " 23:59:59'";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $is_virtual_pay = 0;
            if($row->dc_payment_method == "VirtualCard" || $row->pay_deff_id > 0){
                $is_virtual_pay = 1;
            }
            $insert_data = array(
                'hms_id' => $hms_id,
                'dc_id' => $row->dc_id,
                'res_id' => $row->res_id,
                'virtual' => $is_virtual_pay,
                'amount' => $row->dc_totalprice,
                'currency' => $row->dc_currencycode
            );
            $this->db->insert('global_hotelix_analitycs.dc_range_amount', $insert_data);
        }
    }
    
    function google_hotels()
    {
        echo "start";
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = "dc_booking";
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database($config, true);
        $xls_data = array();
        $sql = "SELECT db_name, host, id as hms_hotel_id FROM visitka.config WHERE hotelstateid IN (0,1,4,11)"; //hotelstateid IN (0,1,4,11)
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $hms_id = $row->hms_hotel_id;
            $db_name = $row->db_name;
            $host = $row->host;
            
            $sql = "SELECT property_information.id as property_id,
        property_information.street, property_information.gps_coordinates, property_information.city,
        property_information.additional_information, property_information.post_code,
        property_information.state, property_information.country, property_information.property_name,
        property_information.reception_phone, property_information.email
        FROM `".$db_name."`.property_information
        WHERE property_information.dwelling = 2";
            $query2 = $this->db->query ( $sql );
            if ($query2->num_rows () > 0) {
                foreach ( $query2->result () as $row2 ) {
                    //$category_name_arr = $this->internationalfields->get_value("category", $row->category_id, "international_name", $global_language);
                    //$category_name = isset($category_name_arr[$global_language]) ? $category_name_arr[$global_language] : "";
                    
                    $gps_coordinates = explode(",", $row2->gps_coordinates);
                    
                    $latitude = $gps_coordinates[0];
                    
                    $longitude = "";
                    if(isset($gps_coordinates[1])){
                        $longitude = $gps_coordinates[1];
                    }
                    array_push($xls_data, array(
                        "id" => $hms_id."-".$row2->property_id,
                        "name" => $row2->property_name,
                        "addr1" => $row2->street,
                        "addr2" => $row2->additional_information,
                        "city" => $row2->city,
                        "state" => $row2->state,
                        "country" => $row2->country,
                        "phone" => $row2->reception_phone,
                        "zip" => $row2->post_code,
                        "latitude" => $latitude,
                        "longitude" => $longitude
                    ));
                }
            }
            
        }
        
        //echo "<pre>";
        //print_r($xls_data);
        //die();
        $get_only_content = 1;
        $writetofile = 1;
        
        $location = "/tmp";
        
        $fields_list = array();
        $fields_list["id"] = 'string';
        $fields_list["name"] = 'string';
        $fields_list["addr1"] = 'string';
        $fields_list["addr2"] = 'string';
        $fields_list["city"] = 'string';
        $fields_list["state"] = 'string';
        $fields_list["country"] = 'string';
        $fields_list["phone"] = 'string';
        $fields_list["zip"] = 'string';
        $fields_list["latitude"] = 'string';
        $fields_list["longitude"] = 'string';
        
        $filename = "google_hotels.xlsx";
        $this->xlsfactory_model->uploadxlsbyarray($fields_list, $xls_data, $filename, $get_only_content, $writetofile, $location);
        echo "end ".count($xls_data);
    }
    
    function get_dc_simple_ids_xls($dc_id){
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = "global_hotelix_analitycs";
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database($config, true);
        
        $xls_data = array();
        $sql = "SELECT t1.dc_id, t1.hms_id, t1.dc_account_id, t2.dc_count
FROM dc_channels_simple_ids AS t1
INNER JOIN (SELECT `hms_id` , SUM( 1 ) AS dc_count, `dc_account_id`
FROM `dc_channels_simple_ids`
WHERE `dc_id` =1
GROUP BY `dc_account_id`
) AS t2 ON t2.dc_account_id = t1.dc_account_id AND t2.dc_count > 1
WHERE t1.dc_account_id > 0
ORDER BY t1.dc_account_id ASC";
        
        $query2 = $this->db->query ( $sql );
        if ($query2->num_rows () > 0) {
            foreach ( $query2->result () as $row2 ) {
                array_push($xls_data, array(
                    "hms_id" => $row2->hms_id,
                    "sum" => $row2->dc_count,
                    "dc_account_id" => $row2->dc_account_id,
                    "dc_id" => $dc_id
                ));
            }
        }
        
        $get_only_content = 1;
        $writetofile = 1;
        
        $location = "/temp";
        
        $fields_list = array();
        $fields_list["hms_id"] = 'string';
        $fields_list["sum"] = 'string';
        $fields_list["dc_account_id"] = 'string';
        $fields_list["dc_id"] = 'string';
        
        $filename = "dc_channels_simple_ids.xlsx";
        $this->xlsfactory_model->uploadxlsbyarray($fields_list, $xls_data, $filename, $get_only_content, $writetofile, $location);
        echo "end ".count($xls_data);
    }
    
    
    function get_data_for_academ_service_xls(){
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = "visitka";
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database($config, true);
        $xls_data = array();
        $sql = "SELECT config.db_name, users.company, users.userlastname, users.userfirstname,
                users.useremail, users.userphone FROM config
                INNER JOIN users ON users.site_address LIKE config.host
            WHERE config.hotelstateid IN (0,4,11)";
        
        $sql = "SELECT config.id as hms_id, dbname, config.db_name  , users.company, users.userlastname, users.userfirstname,
                users.useremail, users.userphone
FROM
dc_booking.academ_service_hms_hotels
INNER JOIN visitka.config ON config.db_name=dc_booking.academ_service_hms_hotels.dbname
INNER JOIN visitka.users ON users.site_address LIKE config.host
            WHERE visitka.config.hotelstateid IN (0,4,11)";
        
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            $db_name = $row->db_name;
            $hms_id = $row->hms_id;
            $general_update = 0;
            $autoclosedaychicho = 0;
            
            $sql2 = "SELECT int_value FROM `" . $db_name . "`.dc_academ_service_xml_cfg
                     WHERE name LIKE 'general_update'";
            $query2 = $this->db->query($sql2);
            if ($query2->num_rows() > 0) {
                $row2 = $query2->row();
                $general_update = $row2->int_value;
            }
            
            $sql2 = "SELECT int_value FROM `" . $db_name . "`.dc_academ_service_xml_cfg
                     WHERE name LIKE 'autoclosedaychicho'";
            $query2 = $this->db->query($sql2);
            if ($query2->num_rows() > 0) {
                $row2 = $query2->row();
                $autoclosedaychicho = $row2->int_value;
            }
            
            if($autoclosedaychicho == 1 && $general_update == 1){
                array_push($xls_data, array(
                    "hms_id" => $row->hms_id,
                    "company" => $row->company,
                    "userlastname" => $row->userlastname,
                    "userfirstname" => $row->userfirstname,
                    "useremail" => $row->useremail,
                    "userphone" => $row->userphone,
                ));
            }
            
        }
        
        $get_only_content = 1;
        $writetofile = 1;
        
        $location = "/temp";
        
        $fields_list = array();
        $fields_list["hms_id"] = 'string';
        $fields_list["company"] = 'string';
        $fields_list["userlastname"] = 'string';
        $fields_list["userfirstname"] = 'string';
        $fields_list["useremail"] = 'string';
        $fields_list["userphone"] = 'string';
        
        $filename = "dc_academservice_data.xlsx";
        $this->xlsfactory_model->uploadxlsbyarray($fields_list, $xls_data, $filename, $get_only_content, $writetofile, $location);
        echo "end ".count($xls_data);
    }
    
    function chechdeskdays($reservation_id){
        $return_data = array();
        $return_data['clear'] = 0;
        $return_data['rlist'] = array();
        $sql = "SELECT deskofreservation.id AS hms_res_id, deskofreservation.room_id,
        deskofreservation.datein, deskofreservation.dateout, deskofreservation.duration,
        deskofdays.intdate, deskofdays.date as deskofdays_date,
        deskofreservation.early_check_in_close, deskofreservation.late_check_out_close
        FROM deskofreservation
        INNER JOIN deskofdays ON deskofdays.reservation_id = deskofreservation.id
        WHERE deskofreservation.id = $reservation_id";
        //echo $sql."<br><br>";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            $row = $query->row();
            
            list ( $year, $month, $day ) = explode ( "-", $row->datein );
            $intdatein = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            list ( $year, $month, $day ) = explode ( "-", $row->dateout );
            $intdateout = round ( gmmktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
            
            if($row->early_check_in_close == 1){
                $intdatein -= 1;
            }
            if($row->late_check_out_close == 1){
                $intdateout += 1;
            }
            
            $room_id = $row->room_id;
            // check rdays
            if(($intdateout - $intdatein) == $query->num_rows()){
                $return_data['rdays'] = 1;
            }else{
                $return_data['rdays'] = 0;
            }
            
            //check clear
            $sql_2 = "SELECT deskofdays.reservation_id
            FROM deskofdays
            INNER JOIN deskofreservation ON deskofdays.reservation_id = deskofreservation.id
            WHERE deskofdays.room_id = $room_id AND deskofdays.intdate >= $intdatein
            AND deskofdays.intdate < $intdateout AND deskofdays.reservation_id <> $reservation_id
            GROUP BY deskofdays.reservation_id";
            //echo $sql_2;
            $query_2 = $this->db->query($sql_2);
            if ($query_2->num_rows() > 0) {
                $return_data['clear'] = 0;
                $return_data['rlist'] = $query_2->result_array();
            }else{
                $return_data['clear'] = 1;
            }
        }else{
            $return_data['rdays'] = 0;
        }
        
        echo "<pre>";
        print_r($return_data);
        
        return $return_data;
    }
    
    function airbnb_property_data_2($db_name){
        
        //die();
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = "dc_booking";
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        //$this->db->query("DELETE FROM global_hotelix_analitycs.airbnb_property_data");
        
        $array_info = array();
        $sql = "SELECT config.db_name, config.host, config.id as hms_hotel_id, users.company, users.useremail FROM visitka.config
                INNER JOIN visitka.users ON users.site_address LIKE config.base_url
                WHERE hotelstateid = 4 and bup=1 limit 10";
        
        
        $sql = "SELECT config.db_name, config.host, config.id as hms_hotel_id, users.company, users.useremail FROM visitka.config
                INNER JOIN visitka.users ON users.site_address LIKE config.base_url
                WHERE config.db_name ='" . $db_name . "'";
        
        $query = $this->db->query ( $sql );
        foreach ( $query->result () as $row_base ) {
            $host = $row_base->host;
            if(trim($row_base->db_name) != ""){
                
                
                $hms_id = $row_base->hms_hotel_id;
                $db_name = $row_base->db_name;
                $hotel_name = $row_base->company;
                $hotel_email = $row_base->useremail;
                
                //                 $airbnb_is_active = 0;
                //                 $query_2 = $this->db->query( "show tables like '".$db_name.".dc_airbnb_xml_cfg'");
                
                //                 echo "    show tables like '".$db_name.".dc_airbnb_xml_cfg'    ";
                //                 if ($query_2->num_rows () > 0) {
                
                //                     echo " -------- ";
                //                     $is_active_query_row = $this->db->like('name', 'general_update')->get('`'.$db_name.'`.airbnb_xml_cfg')->row();
                //                     $airbnb_is_active = ($is_active_query_row) ? $is_active_query_row->int_value : 0;
                //                 } else {
                //                     echo " ++++++++++++++ ";
                //                 }
                
                
                $airbnb_is_active = 0;
                
                
                $is_active_query_row = $this->db->like('name', 'general_update')->get('`'.$db_name.'`.dc_airbnb_xml_cfg')->row();
                $airbnb_is_active = ($is_active_query_row) ? $is_active_query_row->int_value : 0;
                
                
                
                
                
                $sql_2 = "SELECT SUM(t1.rooms_count) as sum_rooms, COUNT(t1.categories_id) as cat_count, t1.* FROM (SELECT categories.id as categories_id, COUNT(rooms.id) as rooms_count,
                property_information.id as property_id,
                property_information.street, property_information.gps_coordinates, property_information.city,
                property_information.additional_information, property_information.post_code,
                property_information.state, property_information.country, property_information.property_name,
                property_information.reception_phone, property_information.email
                FROM `$db_name`.property_information
                INNER JOIN `$db_name`.categories ON property_information.id = categories.property_id
                INNER JOIN `$db_name`.rooms ON rooms.category_id = categories.id
                WHERE categories.is_active = 1 AND property_information.country <> '' AND property_information.city <> ''
                GROUP BY property_information.id, categories.id) as t1 GROUP BY t1.property_id";
                echo $db_name."<br>";
                echo $sql_2."<br>";
                //                 die();
                $query_2 = $this->db->query ( $sql_2 );
                if ($query_2->num_rows () > 0) {
                    foreach ( $query_2->result () as $row ) {
                        $property_name = ($row->property_name == '') ? '' : $row->property_name;
                        $additional_information = ($row->additional_information == '') ? '' : $row->additional_information;
                        $state = ($row->state == '') ? '' : $row->state;
                        $city = ($row->city == '') ? '' : $row->city;
                        $post_code = ($row->post_code == '') ? '' : $row->post_code;
                        $country = ($row->country == '') ? '' : $row->country;
                        $reception_phone = ($row->reception_phone == '') ? '' : $row->reception_phone;
                        $email = ($row->email == '') ? '' : $row->email;
                        $gps_coordinates = ($row->gps_coordinates == '') ? '' : $row->gps_coordinates;
                        
                        array_push($array_info, array(
                            "hms_id" => $hms_id,
                            "hotel_name" => $hotel_name,
                            "hotel_email" => $hotel_email,
                            "property" => $property_name,
                            "categories_count" => $row->cat_count,
                            "rooms_count" => $row->sum_rooms,
                            "address" => $additional_information,
                            "state" => $state,
                            "city" => $city,
                            "zip" => $post_code,
                            "country" => $country,
                            "phone" => $reception_phone,
                            "email" => $email,
                            "gps" => $gps_coordinates,
                            "airbnb_active" => $airbnb_is_active
                        ));
                    }
                } else {
                    echo "skip ! <br>";
                }
                
            }
            
        }
        echo "<pre>";
        print_r($array_info);
        //die();
        if(count($array_info) > 0){
            $this->db->insert_batch('global_hotelix_analitycs.airbnb_property_data', $array_info);
        }
        echo "OK";
    }
    
    function fms_check($db_name) {
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        $fms_module = 0;
        $sql = "SELECT is_active FROM modules WHERE name LIKE 'fms'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $fms_module = $row ['is_active'];
        }
        
        $sql = "INSERT INTO global_hotelix_analitycs.fms_stats (hms_id, fms) VALUES($hms_id, $fms_module) ON DUPLICATE KEY UPDATE fms = $fms_module";
        $this->db->query ( $sql );
    }
    
    function hms_activity_check($db_name, $year, $month){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database ( $config, true );
        
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        $login_count = 0;
        $sql = "SELECT COUNT( logauthip.id ) AS login_count
        FROM logauthip
        INNER JOIN users ON users.id = logauthip.id_user
        WHERE users.login <> 'support@otelms.com'
        AND users.login <> 'info@otelms.com'
        AND YEAR( logauthip.time ) = $year
        AND Month( logauthip.time ) = $month";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $login_count = $row ['login_count'];
        }
        
        $order_count  = 0;
        $sql = "SELECT COUNT( deskofreservation.id ) AS res_count
        FROM deskofreservation
        WHERE deskofreservation.cancel <> 1
        AND deskofreservation.deleted <> 1
        AND YEAR( deskofreservation.date ) = $year
        AND Month( deskofreservation.date ) = $month";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $order_count = $row ['res_count'];
        }
        
        $order_canceled  = 0;
        $sql = "SELECT COUNT( deskofreservation.id ) AS res_count
        FROM deskofreservation
        WHERE deskofreservation.cancel = 1
        AND deskofreservation.deleted = 1
        AND YEAR( deskofreservation.date ) = $year
        AND Month( deskofreservation.date ) = $month";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $order_canceled = $row ['res_count'];
        }
        
        $payment_count  = 0;
        $sql = "SELECT COUNT( payment.id ) AS payment_count
        FROM payment
        WHERE YEAR( payment.create_time ) = $year
        AND Month( payment.create_time ) = $month";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $payment_count = $row ['payment_count'];
        }
        
        $payment_amount  = 0;
        $sql = "SELECT SUM( payment.amount ) AS payment_amount
        FROM payment
        WHERE YEAR( payment.create_time ) = $year
        AND Month( payment.create_time ) = $month";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row_array ();
            $payment_amount = $row ['payment_amount'];
        }
        
        $sql = "INSERT INTO global_hotelix_analitycs.hms_activity_check (hms_id, year, month, login_count, order_count, order_canceled, payment_count, payment_amount)
        VALUES($hms_id, $year, $month, $login_count, $order_count, $order_canceled, $payment_count, '$payment_amount')
        ON DUPLICATE KEY UPDATE login_count = $login_count, order_count = $order_count, order_canceled = $order_canceled,
        payment_count = $payment_count, payment_amount = '$payment_amount'";
        $this->db->query ( $sql );
    }
    
    function wizard_check_time() {
        $config = array();
        $config['hostname'] = $this->config->item('visitka_host');
        $config['username'] = $this->config->item('visitka_user');
        $config['password'] = $this->config->item('visitka_pass');
        $config['database'] = "visitka";
        $config['dbdriver'] = "mysqli";
        $config['dbprefix'] = "";
        $config['pconnect'] = FALSE;
        $config['db_debug'] = TRUE;
        $config['cache_on'] = FALSE;
        $config['cachedir'] = "";
        $config['char_set'] = "utf8";
        $config['dbcollat'] = "utf8_general_ci";
        
        $this->db = $this->load->database($config, true);
        
        $sql = "SELECT visitka.config.id as hotel_id, visitka.config.db_name, visitka.users.time
        FROM visitka.config LEFT JOIN visitka.users ON visitka.users.site_address = visitka.config.base_url
        WHERE 1 AND hotelstateid in (0,1,2,4,11) ORDER BY visitka.config.id DESC";
        $query = $this->db->query ( $sql );
        
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $wizard_done = 0;
                $registration_datetime = $row->time;
                list ( $registration_date, $registration_time ) = explode ( " ", $registration_datetime );
                
                $db_name = $row->db_name;
                $hotel_id = $row->hotel_id;
                
                
                $query_cfg = $this->db->query("SELECT value FROM `$db_name`.`hotelix_config` WHERE name LIKE 'wizardsetup'");
                if ($query_cfg->num_rows() > 0) {
                    $row_cfg = $query_cfg->row();
                    $wizard_done = $row_cfg->value;
                }
                
                list ( $year, $month, $day ) = explode ( "-", date('Y-m-d') );
                $intdate_today = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                list ( $year, $month, $day ) = explode ( "-", $registration_date );
                $intdate_registration = round ( mktime ( 0, 0, 0, $month, $day, $year ) / 86400 );
                
                $reg_diff = $intdate_today - $intdate_registration;
                echo $hotel_id . " - WITH WIZARD <br>";
                if($reg_diff > 30){
                    if($wizard_done == 0) {
                        echo $hotel_id . " - NO WIZARD <br>";
                        
                        
                        $data_w = array(
                            'hms_id' => $hotel_id,
                            'reg_date' => $registration_datetime,
                            'days_left' => $reg_diff
                        );
                        
                        $this->db->insert('global_hotelix_analitycs.wizard_hms_expiry_dates', $data_w);
                        
                        $this->db->update('visitka.config', array('hotelstateid'=> 7), array('id' => $hotel_id));
                        
                        die("asdasda");
                    }
                }
                
            }
        }
    }
    
    function fms_get_guest_data($db_name, $guest_id){
        $config = array ();
        $config ['hostname'] = $this->config->item ( 'visitka_host' );
        $config ['username'] = $this->config->item ( 'visitka_user' );
        $config ['password'] = $this->config->item ( 'visitka_pass' );
        $config ['database'] = $db_name;
        $config ['dbdriver'] = "mysqli";
        $config ['dbprefix'] = "";
        $config ['pconnect'] = FALSE;
        $config ['db_debug'] = TRUE;
        $config ['cache_on'] = FALSE;
        $config ['cachedir'] = "";
        $config ['char_set'] = "utf8";
        $config ['dbcollat'] = "utf8_general_ci";
    
        $this->db = $this->load->database ( $config, true );
    
        $hms_id = 0;
        $sql = "SELECT config.id FROM visitka.config WHERE db_name LIKE '" . $db_name . "'";
        $query = $this->db->query ( $sql );
        if ($query->num_rows () > 0) {
            $row = $query->row ();
            $hms_id = $row->id;
        }
        
        $guest_data = $this->frontdesk->GetGuest($guest_id);
        //$reservation_details = $this->frontdesk->GetGuest_reservation_details($guest_id, $reservation_id);
        
        $image_bool = 0;
        $image_row = $this->db->select('id')->get_where('guests_images_registry', array('id_guest' => $guest_id))->row_array();
        if(isset($image_row['id'])){
            $image_bool = 1;
        }
        
        $legalsystem = $this->frontdesk->getlegalsystem();//
        $legalsystem_db = $this->frontdesk->getlegalsystem_db($legalsystem);
        
        $dict_documenttype_mass = $this->fms_core->get_dict_documenttype($legalsystem_db);
        
        $doc_type = "";
        foreach($dict_documenttype_mass as $key => $value) {
            if ($guest_data["doc_type"] == $value["id"]) {
                $doc_type = $dict_documenttype_mass [$key] ["name"];
                break;
            }
        }
        
        $guest_data_new = array();
        $guest_data_new ['id'] = $guest_data ['id'];
        $guest_data_new ['firstname'] = $guest_data ['firstname'];
        $guest_data_new ['lastname'] = $guest_data ['lastname'];
        $guest_data_new ['middlename'] = $guest_data ['middlename'];
        $guest_data_new ['email'] = $guest_data ['email'];
        $guest_data_new ['phone'] = $guest_data ['phone'];
        $guest_data_new ['citizenship'] = $guest_data ['citizenship'];
        $guest_data_new ['state'] = $guest_data ['state'];
        $guest_data_new ['city'] = $guest_data ['city'];
        $guest_data_new ['address'] = $guest_data ['address'];
        $guest_data_new ['addrbuilding'] = $guest_data ['addrbuilding'];
        $guest_data_new ['addrapt'] = $guest_data ['addrapt'];
        $guest_data_new ['addrhousing'] = $guest_data ['addrhousing'];
        $guest_data_new ['postcode'] = $guest_data ['postcode'];
        $guest_data_new ['pob_registration_date'] = $guest_data ['pob_registration_date'];
        //$guest_data_new ['fias'] = $guest_data ['fias'];
        $guest_data_new ['doc_type'] = $doc_type;
        $guest_data_new ['passportid'] = $guest_data ['passportid'];
        $guest_data_new ['doc_precode'] = $guest_data ['doc_precode'];
        $guest_data_new ['doc_date_open'] = $guest_data ['doc_date_open'];
        $guest_data_new ['doc_date_till'] = $guest_data ['doc_date_till'];
        $guest_data_new ['passportissuedby'] = $guest_data ['passportissuedby'];
        $guest_data_new ['dict_officialorgan_fmsCODE'] = $guest_data ['dict_officialorgan_fmsCODE'];
        $guest_data_new ['decision_number'] = $guest_data ['decision_number'];
        $guest_data_new ['decision_date'] = $guest_data ['decision_date'];
        
        $guest_data_new ['image_bool'] = $image_bool;
        echo "<pre>";
        print_r($guest_data_new);
        die();
        
    }
}

?>