<?php
class dc_airbnb_c2 extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('dcm_airbnb');
        $this->load->model('dc_airbnb_rest');
        $this->load->model ( 'htmltpl' );
        $this->load->model ( 'frontdesk' );
        $this->load->model ( 'Authorization' );
        $this->load->model ( 'mRooms' );
        $this->load->model ( 'curl_model' );

        $this->Authorization->IsLogined ( "admin_access" );
        
        // ==== billing plan access start ==========
        $data_access = array('module_name' => 'channel_manager');
        $billing_plan_access = $this->Access->get_billing_plan_access($data_access);
        if($billing_plan_access == 0){
            die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/52'>" );
        }
        // ==== billing plan access end ==========
    }

    function change_airbnb_testmode_state($current_state){
        if ($current_state === "ON"){
            $current_state = 0;
        }else{
            $current_state = 1;
        }
        $this->db->query ( "INSERT INTO dc_airbnb_xml_cfg (name, int_value) VALUES ('airbnb_testmode', ".$current_state.") ON DUPLICATE KEY UPDATE int_value=".$current_state);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v/'>" );
    }

    function set_state($state){
        $this->dcm_airbnb->set_state($state);
        die ( "<meta http-equiv='refresh' content='0;url=/home/adminpage_v'>" );
    }


    function airbnb_book_test(){
        $json_data = '{"reservation":{"booked_at":"2019-12-22T15:59:49Z","updated_at":"2019-12-22T15:59:49Z",
            "cancellation_policy":"flexible_grace_peroid_at_most_48","cancellation_policy_category":"flexible","confirmation_code":"HM4DRD5P4B",
            "created_at":"2019-12-22T15:58:00Z","end_date":"2020-01-04","expected_payout_amount":4434,"expected_payout_amount_accurate":"4434.40",
            "guest_details":{"localized_description":"2 guests","number_of_adults":2,"number_of_children":0,"number_of_infants":0},
            "guest_email":"user-wclea6i03p7g25gj@guest.airbnb.com","guest_first_name":"Юлия","guest_id":310182649,"guest_last_name":"Юдахина",
            "guest_phone_numbers":["79277441234"],"guest_preferred_locale":"ru","host_currency":"RUB","host_id":154279036,"listing_base_price":4600,
            "listing_base_price_accurate":"4600.00","listing_cancellation_host_fee":165,"listing_cancellation_host_fee_accurate":"165.60",
            "listing_cancellation_payout":4434,"listing_cancellation_payout_accurate":"4434.40","listing_cleaning_fee":0,
            "listing_cleaning_fee_accurate":"0.00","listing_host_fee":165,"listing_host_fee_accurate":"165.60","listing_id":33945386,
            "listing_security_price":0,"listing_security_price_accurate":"0.00","nights":2,"number_of_guests":2,"occupancy_tax_amount_paid_to_host":0,
            "occupancy_tax_amount_paid_to_host_accurate":"0.00","special_offer_id":null,"standard_fees_details":[],"start_date":"2020-01-02",
            "status_type":"accept","thread_id":816219339,"total_paid_amount":4434,"total_paid_amount_accurate":"4434.40","transient_occupancy_tax_details":[],
            "transient_occupancy_tax_paid_amount":0,"transient_occupancy_tax_paid_amount_accurate":"0.00","promotion_details":[]},"confirmed_at":1578105078,
            "action":"payout_notification"}';
        $this->dcm_airbnb->get_bookings($json_data);
    }
    function roomlist($id_c) {
        // 		$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        if (isset ( $_POST ["rooms"] )) {
            $room = $_POST ["rooms"];
            $newdata = array (
                'room_name' => $room
            );
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["types"] )) {
            $types = $_POST ["types"];
            $newdata = array (
                'types' => $types
            );
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["floor"] )) {
            $floor = $_POST ["floor"];
            $newdata = array (
                'floor' => $floor
            );
            $this->session->set_userdata ( $newdata );
        }
        if (isset ( $_POST ["side"] )) {
            $side = $_POST ["side"];
            $newdata = array (
                'side' => $side
            );
            $this->session->set_userdata ( $newdata );
        }
        $data = array (
            'id' => $id_c
        );
        $this->load->view ( 'dc_airbnb_c2_roomlist_view', $data );
    }
    function roomdetails($id) {
        // 		$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $result = $this->mRooms->getRoom ( $id );
        $data = array (
            'room_record' => $result
        );
        $this->load->view ( 'dc_airbnb_c2_roomdetails_view', $data );
    }

    function roomsave() {
        $post = $this->input->post(NULL, true);
        //print_r($post);
        $sql = "insert into dc_airbnb_room2listing (room_id, listing_id) values (" . (integer) $post['room_id'] . ", " . (integer) $post['listing_id'] . ")
	        on duplicate key update listing_id=" . (integer) $post['listing_id'];
        $this->db->query($sql);
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $post['room_id'] . "'>" );
    }

    function deletelisting($listing_id, $room_id){
        echo "<pre>";
        //https://api.airbnb.com/v2/listing_imports/:id


        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];


        $url = "https://api.airbnb.com/v2/listing_imports/" . $listing_id;  //сюда юзек з gettoken()

        $ch = curl_init ();

        // set the url, number of POST vars, POST data
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt ( $ch, CURLOPT_POST, 1 );
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/6/data.xml";
        //curl_setopt ( $ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $xml . "\",\"synchronization_frequency\":\"hourly\"}" );

        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array (
            'Content-Type: application/json' ,
            "X-Airbnb-Oauth-Token: " . $access_token, //сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ) );
        $response = curl_exec ( $ch );
        $result = json_decode($response, true);
        // 	    if (1) {
        // 	       print_r($result);
        // 	       die();
        // 	    }
        curl_close ( $ch );
        $newdata = array (
            'air_bnb_last' => $result
        );
        $this->session->set_userdata ( $newdata );
        if (isset($result['listing_import'])) {
            $this->db->query("delete from dc_airbnb_room2listing where room_id=" . $room_id);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );
    }


    function deletelistingtrash($listing_id){
        echo "<pre>";
        //https://api.airbnb.com/v2/listing_imports/:id


        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];

        $log_data = array();
        $log_data["access_token"] = $access_token;
        $log_data["clientid"] = $clientid;



        $url = "https://api.airbnb.com/v2/listing_imports/" . $listing_id;  //сюда юзек з gettoken()

        $datalog = array(
            'request' => json_encode($log_data),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();

        $ch = curl_init ();

        // set the url, number of POST vars, POST data
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt ( $ch, CURLOPT_POST, 1 );
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/6/data.xml";
        //curl_setopt ( $ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $xml . "\",\"synchronization_frequency\":\"hourly\"}" );

        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array (
            'Content-Type: application/json' ,
            "X-Airbnb-Oauth-Token: " . $access_token, //сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ) );

        $timestart = time();
        $response = curl_exec ( $ch );

        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));

        curl_close ( $ch );
        $result = json_decode($response, true);

        if (isset($result['error_code'])) {
            if ($result['error_code'] == 400) {
                print_r($result);
                die();
            }
        }

        if (1) {
            echo  "debug <pre>";
            print_r($result);
            die();
        }


        $newdata = array (
            'air_bnb_last' => $result
        );
        $this->session->set_userdata ( $newdata );
        if (isset($result['listing_import'])) {
            $this->db->query("delete from dc_airbnb_room2listing where listing_id=" . $listing_id);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms/'>" );
    }

    function deletelisting_custom(){
        echo "<pre>";
        //https://api.airbnb.com/v2/listing_imports/:id

        $listing_id = $this->input->post('listing_id', true);


        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];


        $url = "https://api.airbnb.com/v2/listing_imports/" . $listing_id;  //сюда юзек з gettoken()

        $log_data = array();
        $log_data["access_token"] = $access_token;
        $log_data["clientid"] = $clientid;
        $datalog = array(
            'request' => json_encode($log_data),
            'url' => $url
        );
        $this->db->insert('dc_airbnb_log', $datalog);
        $id = $this->db->insert_id();

        $ch = curl_init ();

        // set the url, number of POST vars, POST data
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, FALSE );
        curl_setopt ( $ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)" );
        curl_setopt ( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt' );
        curl_setopt ( $ch, CURLOPT_COOKIEFILE, 'cookie.txt' );
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt ( $ch, CURLOPT_POST, 1 );
        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/6/data.xml";
        //curl_setopt ( $ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"synchronization_frequency\":\"hourly\"}" );

        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array (
            'Content-Type: application/json' ,
            "X-Airbnb-Oauth-Token: " . $access_token, //сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ) );
        $timestart = time();
        $response = curl_exec ( $ch );
        $result = json_decode($response, true);
        print_r($result);
        curl_close ( $ch );


        $data = array(
            'response' => $response,
            'stime' => (microtime(true) - $timestart)
        );
        $this->db->update('dc_airbnb_log', $data, array(
            'id' => $id
        ));

        $newdata = array (
            'air_bnb_last' => $result
        );
        $this->session->set_userdata ( $newdata );
        if (isset($result['listing_import'])) {
            $this->db->query("delete from dc_airbnb_room2listing where listing_id=" . $listing_id);
        }
    }

    function listcreate($room_id)
    {

        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $url = "https://api.airbnb.com/v2/listing_imports/"; // сюда юзек з gettoken()

        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_POST, 1);

        //$url = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/" . $room_id . "/data.xml";


        $url = $this->dcm_airbnb->build_data_url($room_id);

        curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"document_format\":\"airbnb-xml-v1\",\"document_uri\":\"" . $url . "\",\"synchronization_frequency\":\"hourly\"}");

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ));
        $response = curl_exec ( $ch );
        $result = json_decode($response, true);
        //print_r($result);
        curl_close ( $ch );
        $newdata = array (
            'air_bnb_last' => $result
        );
        $this->session->set_userdata ( $newdata );
        if (isset($result['listing_import'])) {
            $listing_id = $result['listing_import']['id'];
            $sql = "insert into dc_airbnb_room2listing (room_id, listing_id) values (" . (integer) $room_id . ", " . (integer) $listing_id . ")
	        on duplicate key update listing_id=" . (integer) $listing_id;
            $this->db->query($sql);
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );
    }

    function saveauthcode() {

        $authcode = $this->input->post('authcode', true);

        $this->db->query("delete from dc_airbnb_xml_cfg where name='authcode'");
        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('authcode', '" . $authcode . "')");
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/connect'>" );
    }

    function saveauthcode2($phrase) {



        $data = json_decode(base64_decode(urldecode($phrase)), true);

        if (isset($data['code'])) {
            $authcode =  $data['code'] ;
        } else {
            // 	        echo "1";
            // 	        echo $phrase;
            // 	        echo "<pre>";
            // 	        print_r($data);
            // 	        die();
        }

        if ($authcode == "") {

            echo $authcode;
            echo "<pre>";



            print_r($data);
            echo "+++";
            die();
        } else {

        }

        $secure = "stranger";

        $signature = sha1($data['hms_id'] . $data['code'] . $data['salt'] . $secure);


        if ($data['signature'] == $signature) {

        } else {
            echo "Hello World!";
            die();
        }

        $hms_id = $this->config->item ( 'hotel_id' );

        if ($data['hms_id'] == $hms_id) {

        } else {
            echo "Hello World2!";
            die();
        }




        //$authcode = $this->input->post('authcode', true);
        $newdata = array (
            'air_bnb_last' => "Authcode succefully stored!"
        );
        $this->session->set_userdata ( $newdata );

        $this->db->query("delete from dc_airbnb_xml_cfg where name='authcode'");
        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('authcode', '" . $authcode . "')");

        $this->dcm_airbnb->gettoken();

        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/connecttoairbnb/success'>" );

    }

    function options() {
        // 		$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( 'dc_airbnb_c2_options_view.php', $data );
    }
    function connect() {
        // 		$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( 'dc_airbnb_c2_connect_view.php', $data );
    }
    function options_post() {
        $post = $_POST;
        $this->dcm_airbnb->options_save ( $post );
        if(isset($post['landing_page'])){
            switch ($post ['landing_page']) {
                case "airbnb_settings" :
                    die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/settings'>" );
                    break;
                default :
                    die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/options'>" );
                    break;
            }
        }
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/options'>" );
    }

    function reservations_load() {
        // 		$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( 'dc_airbnb_c2_reservations_load_view.php', $data );
    }

    function listimport()
    {
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];

        $url = "https://api.airbnb.com/v2/listing_imports/?user_id=" . $user_id; // сюда юзек з gettoken()

        $ch = curl_init();
        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ));
        $response = curl_exec($ch);
        curl_close($ch);
        echo "<pre>";
        $result = json_decode($response, true);
        print_r($result);
        //var_dump($result);

    }

    function gettoken()
    {
        $url = "https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true";

        $authcode = $this->dcm_airbnb->getxmlcfgvalue('authcode', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $clientsecret = $authparam['clientsecret'];

        // $params=array( "code"=> "35gx77nb7q0m9r9ici6sqc2ya");
        $params = array(
            "code" => $authcode
        );

        // echo "URl="+$url+$params."<br>";
        $ch = curl_init();

        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $clientid . ":" . $clientsecret);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        $response = curl_exec($ch);
        curl_close($ch);
        echo "<pre>";
        $result = json_decode($response, true);
        print_r($result);
        if (isset($result['error_code'])) {
            return;
        }
        $access_token = $result['access_token'];
        $refresh_token = $result['refresh_token'];
        $expires_at = $result['expires_at'];
        $user_id = $result['user_id'];

        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update
            str_value='$access_token'");

        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('refresh_token', '$refresh_token') on duplicate key update
            str_value='$refresh_token'");

        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('expires_at', '$expires_at') on duplicate key update
            int_value='$expires_at'");

        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '$user_id') on duplicate key update
            int_value='$user_id'");


        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }

        $db_host = $this->config->item ( 'xml_gate_db_host' );
        $db_user = $this->config->item ( 'xml_gate_db_user' );
        $db_pass = $this->config->item ( 'xml_gate_db_password' );

        @$link = mysql_connect ( $db_host, $db_user, $db_pass );
        if (! $link) {
            return 'Could not connect: ' . mysql_error ();
            // die ( 'Could not connect: ' . mysql_error () );
        }
        // выбор базы даных
        mysql_select_db ( 'dc_booking', $link );
        // установки кодировки
        mysql_query ( 'SET NAMES utf8' );

        $sql = "INSERT INTO dc_booking.airbnb_hms_hotels (user_id, hms_url)
	        VALUES('" . $result['user_id'] . "', 'https://" . $host . "/') ON DUPLICATE KEY UPDATE hms_url = 'https://" . $host . "/'";
        mysql_query ( $sql, $link );


    }

    function refreshtoken()
    {

        $refreshtoken = $this->dcm_airbnb->getxmlcfgvalue('refresh_token', 'str');
        $url = "https://api.airbnb.com/v2/oauth2/authorizations?_unwrapped=true";
        $params = array(
            "refresh_token" => $refreshtoken,
            "reset_refresh_token" => 0
        );
        // echo "URl="+$url+$params."<br>";
        $ch = curl_init();

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];
        $clientsecret = $authparam['clientsecret'];

        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $clientid . ":" . $clientsecret);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        $response = curl_exec($ch);
        //var_dump($result);
        curl_close($ch);

        // 	    $newdata = array (
        // 	        'air_bnb_last' => $result
        // 	    );
        // 	    $this->session->set_userdata ( $newdata );




        $result = json_decode($response, true);
        echo "<pre>";
        print_r($result);

        if (isset($result['error_code'])) {
            //die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );
        }

        $access_token = $result['access_token'];
        $expires_at = $result['expires_at'];
        $user_id = $result['user_id'];

        $this->db->query("insert into dc_airbnb_xml_cfg (name, str_value) values ('access_token', '$access_token') on duplicate key update
            str_value='$access_token'");

        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('expires_at', '$expires_at') on duplicate key update
            int_value='$expires_at'");

        $this->db->query("insert into dc_airbnb_xml_cfg (name, int_value) values ('user_id', '$user_id') on duplicate key update
            int_value='$user_id'");


        $hotel_id = $this->config->item ( 'hotel_id' );
        if ($hotel_id != "") {
            $sql = "SELECT host, db_name FROM visitka.config WHERE id = " . $hotel_id;
            $query = $this->db->query ( $sql );
            if ($query->num_rows () > 0) {
                $row = $query->row ();
                $host = $row->host;
            }
        }

        $db_host = $this->config->item ( 'xml_gate_db_host' );
        $db_user = $this->config->item ( 'xml_gate_db_user' );
        $db_pass = $this->config->item ( 'xml_gate_db_password' );

        @$link = mysql_connect ( $db_host, $db_user, $db_pass );
        if (! $link) {
            return 'Could not connect: ' . mysql_error ();
            // die ( 'Could not connect: ' . mysql_error () );
        }
        // выбор базы даных
        mysql_select_db ( 'dc_booking', $link );
        // установки кодировки
        mysql_query ( 'SET NAMES utf8' );

        $sql = "INSERT INTO dc_booking.airbnb_hms_hotels (user_id, hms_url)
	        VALUES('" . $result['user_id'] . "', 'https://" . $host . "/') ON DUPLICATE KEY UPDATE hms_url = 'https://" . $host . "/'";
        mysql_query ( $sql, $link );

        //die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );
    }

    function listupdate($listing_id, $room_id)
    {

        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];

        $list_id = 450448; //LIST ID !!!!!   ["id"]=>int(437175)
        $list_id = $listing_id;

        $url = "https://api.airbnb.com/v2/listing_imports/" . $list_id; // сюда юзек з gettoken()

        $ch = curl_init();

        // set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie_jat.txt');
        curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');
        curl_setopt($ch, CURLOPT_URL, $url);


        //$xml = "https://dev-ul2.otelms.com/gatepublic/dcairbnb_listing/" . $room_id . "/data.xml";

        $xml = $this->dcm_airbnb->build_data_url($room_id);


        //    curl_setopt($ch, CURLOPT_PUT, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, '{
  "document_format": "airbnb-xml-v1",
  "document_uri": "' . $xml . '",
  "synchronization_frequency": "hourly",
  "on_demand_synchronization_requested": true
}');

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            "X-Airbnb-Oauth-Token: " . $access_token, // сюда токен з gettoken()
            "X-Airbnb-API-Key: " . $clientid,
            "X-AIRBNB-REQ-API-VERSION: 2022.12.31"
        ));

        $response = curl_exec($ch);

        $info = curl_getinfo($ch);
        curl_close($ch);


        $result = json_decode($response, true);
        //print_r($result);

        $newdata = array (
            'air_bnb_last' => $result
        );
        $this->session->set_userdata ( $newdata );


        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/roomdetails/" . $room_id . "'>" );

    }

    function connecttoairbnb() {
        $this->dcm_airbnb->transfer_hms_config();
        //$airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_airbnb/dc_airbnb_c2_connecttoairbnb_view.php', $data );
    }

    function settings() {
        $airbnb_state = $this->dcm_airbnb->get_airbnb_state();
        // 		if($airbnb_state == 0){
        // 			die ( "<meta http-equiv='refresh' content='0;url=/home_c2/under_construct'>" );
        // 		}
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_airbnb/dc_airbnb_c2_settings_view.php', $data );
    }

    function rooms($debug_on_off = "") {
        $data = array ();
        $this->load->library ( 'parser' );
        $room_page_version = $this->dcm_airbnb->get_room_page_version();
        // 		echo $room_page_version;
        // 		die();
        if ($room_page_version == 1){
            switch ($debug_on_off) {
                case "debug_on":
                    $this->session->set_userdata ( array ('dc_airbnb_room_v3_debug_on' => "on") );
                    break;
                case "debug_off":
                    $this->session->set_userdata ( array ('dc_airbnb_room_v3_debug_on' => "") );
                    break;
            }
            $this->load->view ( '/dc_airbnb/dc_airbnb_c2_rooms_v3_view.php', $data );
        }else{
            $this->load->view ( '/dc_airbnb/dc_airbnb_c2_rooms_view.php', $data );
        }
    }

    function rooms_v3_post(){
        $sql = "DELETE FROM dc_airbnb_listingtocategory";
        $this->db->query( $sql );

        $airbnb_state = $this->dcm_airbnb->save_category_listing($_POST);
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms_v3'>" );
    }

    function rooms_v2() {
        $data = array ();
        $this->load->library ( 'parser' );
        $this->load->view ( '/dc_airbnb/dc_airbnb_c2_rooms_v2_view.php', $data );
    }

    function rooms_v2_post(){
        //echo "<pre>";
        //print_r($_POST);
        //die();
        $categories_link = $this->input->post ( 'categories', true );
        $sync_type_link = $this->input->post ( 'sync_type', true );

        $data_1 = $this->Loger_admin->get_dccategories_multivalues ( "dc_airbnb_listing_link" );

        $array_keys = array_keys ( $categories_link );
        foreach ( $array_keys as $key ) {
            $sync_type = 0;
            if(isset($sync_type_link[$key])){
                $sync_type = $sync_type_link[$key];
            }
            $sql = "INSERT INTO dc_airbnb_listing_link (listing_id, hms_category_id, sync_type)
	        values (".$key.", ".$categories_link[$key].", ".$sync_type.")
	        on duplicate key update hms_category_id = ".$categories_link[$key].", sync_type = ".$sync_type;
            $this->db->query ( $sql );

            // echo $sql . "<br>";
        }

        $data_2 = $this->Loger_admin->get_dccategories_multivalues ( "dc_airbnb_listing_link" );
        $this->Loger_admin->SaveLog_dc_multicol ( $data_1, $data_2, "loger_admin", "dc_airbnb_listing_link", "edit" );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms_v2'>" );
    }

    function room_delete($listing_id){
        $sql = "DELETE FROM dc_airbnb_listing WHERE listing_id = " . $listing_id;
        $query = $this->db->query ( $sql );
        $sql = "DELETE FROM dc_airbnb_listing_link WHERE listing_id = " . $listing_id;
        $query = $this->db->query ( $sql );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms_v2'>" );
    }

    function ajax_edit_category(){
        $category_id = $_POST["reservations"][0]["category_id"];
        echo $this->htmltpl->get_modal_ajax_airbnb_edit_category($category_id);
    }

    function ajax_edit_category_post(){
        $post = $_POST;
        //echo "<pre>";
        //print_r($post);
        //die();
        $this->frontdesk_c2->save_airbnb_category_data($post);

        $listing_types = $this->frontdesk->get_listing_types();
        $dc_airbnb_cancelation_policy = $this->frontdesk->get_dc_airbnb_cancelation_policy();

        $listingType = "";
        if(isset($listing_types[$post["listing_type_id"]])){
            $listingType = $listing_types[$post["listing_type_id"]]["airbnb"];
        }

        $cancelation_policy = "";
        if(isset($dc_airbnb_cancelation_policy[$post["cancelation_policy"]])){
            $cancelation_policy = $dc_airbnb_cancelation_policy[$post["cancelation_policy"]]["cancelation_policy_name"];
        }

        if(isset($post["bookconfirm"])){
            $bookconfirm = $post["bookconfirm"];
        }else{
            $bookconfirm = 0;
        }

        if(isset($post["display_location"])){
            $display_location = $post["display_location"];
        }else{
            $display_location = 0;
        }

        $result = array();
        $result["category_id"] = $post["category_id"];
        $result["cleaningfee"] = $post["cleaningfee"];
        $result["securedeposit"] = $post["securedeposit"];
        $result["extraperson"] = $post["extraperson"];
        $result["hours"] = $post["hours"];
        $result["bookconfirm"] = $bookconfirm;
        $result["listing_type"] = $listingType;
        $result["cancelation_policy"] = $cancelation_policy;
        $result["display_location"] = $display_location;
        //echo "<pre>";
        //print_r($result);
        echo json_encode ( $result );
        //die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms'>" );
    }

    function ajax_room_connect(){
        $room_id = $_POST["reservations"][0]["room_id"];
        $check_airbnb_price = $this->releases->check_airbnb_price(); // значення, яке відповідає чи включена перевірка цін
        // ф-я перевірки цін
        $is_correct_price = 1; // якщо перевірка не включена, по замовчуванню ціна коректна
        if($check_airbnb_price == 1){
            $correct_price_array = $this->dcm_airbnb->is_correct_price($room_id);
            $is_correct_price = $correct_price_array['result'];
        }

        if($is_correct_price == 0){
            $fail_price_str = $this->mlanguages->getdictionaryword ( "dc_airbnb_c2", "", "{clt_fail_price}" );
            $html_data = array();
            $html_data["room_id"] = $room_id;
            $html_data["response"] = json_encode(array('response' => $fail_price_str, 'price_type' => $correct_price_array['price_type']));

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = "";
            $result["listing_id"] = "";
            $result["room_id"] = $room_id;
            echo json_encode($result);
        }else {
            $data_result = $this->dcm_airbnb->listcreate($room_id);

            $html_data = array();
            $html_data["room_id"] = $room_id;
            $html_data["response"] = $data_result["response"];
            // echo $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = $data_result["status_category"];
            $result["listing_id"] = $data_result["listing_id"];
            $result["room_id"] = $room_id;
            echo json_encode($result);
        }
    }

    function ajax_room_migrate()
    {
        $cat_id = $_POST["category_id"];
        $import_id = $_POST["import_id"];
        $sync_type = $_POST["sync_type"];

        if ($this->config->item('airbnb_rest') == 1) {

            $data_result = $this->dcm_airbnb->migrate($import_id);

            $html_data = array();
            $html_data["room_id"] = "";
            $html_data["response"] = $data_result["response"];
            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = $data_result["status_category"];
            $result["listing_id"] = $data_result["listing_id"];
            $result["response_status"] = $data_result["response_status"];
            $result["cat_id"] = $cat_id;
            echo json_encode($result);
            return;

            echo json_encode($result);

            return;
        }
    }

    function ajax_room_connect_v3(){

//         	    print_r($_POST);
//         	    die();



        $cat_id = $_POST["category_id"];
        $listing_id = $_POST["listing_id"];
        $sync_type = $_POST["sync_type"];
        if (isset($_POST['airbnb_rest'])) {
            if ($this->config->item('airbnb_rest') == 1) {

                // print_r($_POST);
                if ($listing_id == 0) {
                    $data_result = $this->dcm_airbnb->create_listing($cat_id, $sync_type);
                    $h_resp = $data_result['response'];

                    if ($data_result["listing_id"] != 0) {
                        $data_result = $this->dcm_airbnb->connect_listing_rest($data_result["listing_id"], $cat_id, $sync_type);
                    }

                    $html_data = array();
                    $html_data["room_id"] = "";
                    $html_data["response"] = $data_result["response"];
                    $result = array();
                    $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
                    $result["status_category"] = $data_result["status_category"];
                    $result["listing_id"] = $data_result["listing_id"];
                    $result["response_status"] = $data_result["response_status"];
                    $result["cat_id"] = $cat_id;
                    $result["response"] =  $h_resp . " | " . $data_result["response"];
                    $result["POST"] = $_POST;
                    echo json_encode($result);
                    return;
                } else {

                    $data_result = $this->dcm_airbnb->connect_listing_rest($listing_id, $cat_id, $sync_type);
                    
                    $html_data = array();
                    $html_data["room_id"] = "";
                    $html_data["response"] = $data_result["response"];
                    $result = array();
                    $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
                    $result["status_category"] = $data_result["status_category"];
                    $result["listing_id"] = $data_result["listing_id"];
                    $result["response_status"] = $data_result["response_status"];
                    $result["cat_id"] = $cat_id;
                    $result["response"] =  $data_result["response"];
                    $result["POST"] = $_POST;
                    echo json_encode($result);
                    return;

                }

                $result = array();
                $result["html"] = "????";
                $result["POST"] = $_POST;

                echo json_encode($result);

                return;
            }
        }



        $check_airbnb_price = $this->releases->check_airbnb_price(); // значення, яке відповідає чи включена перевірка цін
        // ф-я перевірки цін
        $is_correct_price = 1; // якщо перевірка не включена, по замовчуванню ціна коректна
        if($check_airbnb_price == 1){
            $correct_price_array = $this->dcm_airbnb->is_correct_price(0, $cat_id);
            $is_correct_price = $correct_price_array['result'];
        }

        if ($is_correct_price == 0) {
            $fail_price_str = $this->mlanguages->getdictionaryword("dc_airbnb_c2", "", "{clt_fail_price}");
            $html_data = array();
            $html_data["room_id"] = "";
            $html_data["response"] = json_encode(array(
                'response' => $fail_price_str,
                'price_type' => $correct_price_array['price_type']
            ));

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = "";
            $result["listing_id"] = "";
            $result["cat_id"] = $cat_id;
            echo json_encode($result);
        } else {
            if (true) {
                $row = $this->db->get_where("dc_airbnb_importtolisting", array(
                    'listing_id' => $listing_id
                ))->row();

                if (isset($row->import_id)) {
                    $import_id = $row->import_id;
                } else {
                    $import_id = 0;
                }

                if ((int) $import_id != 0) {
                    $data = array();
                    $data['category_id'] = $cat_id;
                    $data['listing_id'] = $listing_id;
                    $data['sync_type'] = $sync_type;
                    $this->db->insert("dc_airbnb_listingtocategory", $data);

                    $result = array();
                    $result["html"] = "Restored connection.";
                    $result["status_category"] = "Restored.";
                    $result["listing_id"] = $listing_id;
                    $result["response_status"] = "Response empty.";
                    $result["cat_id"] = $cat_id;
                    $result["POST"] = $_POST;
                    echo json_encode($result);
                    return;
                }
            }

            $data_result = $this->dcm_airbnb->listing_imports_create($cat_id, $listing_id, 0, $sync_type);

            $html_data = array();
            $html_data["room_id"] = "";
            $html_data["response"] = $data_result["response"];
            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = $data_result["status_category"];
            $result["listing_id"] = $data_result["listing_id"];
            $result["response_status"] = $data_result["response_status"];
            $result["cat_id"] = $cat_id;
            $result["POST"] = $_POST;
            echo json_encode($result);
        }
    }

    function ajax_room_disconnect(){
        $room_id = $_POST["reservations"][0]["room_id"];
        $listing_id = $_POST["reservations"][0]["listing_id"];

        $data_result = $this->dcm_airbnb->deletelisting($listing_id, $room_id);
        $response = $data_result["response"];

        $view_data = array();
        $view_data["response"] = $response;
        $view_data["room_id"] = $room_id;
        $view_data["cat_id"] = "";
        $view_data["listing_id"] = $listing_id;
        echo $this->htmltpl->get_modal_ajax_airbnb_room_disconnect($view_data);
        //echo $this->htmltpl->get_modal_ajax_airbnb_room_disconnect($room_id, $listing_id);
    }

    function ajax_room_disconnect_v3(){
        $cat_id = $_POST["category_id"];
        $listing_id = $_POST["listing_id"];
        $entity_type = $_POST["entity_type"];
        $disconnect_type = $_POST['disconnect_type'];

        $listing_id = (int) $listing_id;
        if ($listing_id == 0) {
            $row = $this->db->get_where("dc_airbnb_listingtocategory", array('category_id'=>$cat_id))->row();
            $listing_id = $row->listing_id;
        }

//          echo "<pre>";
//          print_r($_POST);
//          die();

        $import_id = $this->dcm_airbnb->get_import_id($listing_id);
        if ($import_id) {
            $data_result = $this->dcm_airbnb->deletelisting_v3($import_id, $cat_id, $entity_type, $listing_id);
        } else {
            if ($disconnect_type == "delete") {
                $data_result = $this->dcm_airbnb->deletelisting_rest($listing_id);
            } else {
                $data_result = $this->dcm_airbnb->detach_listing($listing_id);
            }

        }
        $response = $data_result["response"];
        $view_data = array();
        $view_data["response"] = $response;
        $view_data["room_id"] = "";
        $view_data["cat_id"] = $cat_id;
        $view_data["listing_id"] = $listing_id;
        $result = array();
        $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_disconnect($view_data);
        $result["POST"] = $_POST;
        echo json_encode ($result);

    }

    function ajax_room_get_status(){
        $listing_id = $_POST["reservations"][0]["listing_id"];

        $data_result = $this->dcm_airbnb->listimport($listing_id);

        $html_data = array();
        $html_data ["listing_id"] = $listing_id;
        $html_data ["response"] = $data_result["response"];

        $result = array();
        $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_check_status($html_data);
        $result["rooms_statuses"] = $data_result["rooms_statuses"];
        $result["current_get_status"] = $data_result["current_get_status"];
        //$result["room_id"] = $room_id;
        echo json_encode ( $result );
    }

    function ajax_room_get_status_v3(){
        $listing_id = $_POST["listing_id"];
        $cat_id = $_POST["category_id"];

        //$data_result = $this->dcm_airbnb->listimport_v3($listing_id);
        $view_info = 1;
        $data_result = $this->dcm_airbnb->listing_imports_create($cat_id, $listing_id, $view_info);

        $html_data = array();
        $html_data ["listing_id"] = $listing_id;
        $html_data ["response"] = $data_result["response"];

        $result = array();
        $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_check_status($html_data);
        $result["rooms_statuses"] = $data_result["rooms_statuses"];
        $result["current_get_status"] = $data_result["current_get_status"];
        //$result["room_id"] = $room_id;
        echo json_encode ( $result );
    }

    function ajax_room_check_status(){
        //$room_id = 0;
        //echo $this->htmltpl->get_modal_ajax_airbnb_check_status($room_id);
        $data_result = $this->dcm_airbnb->listimport();

        $html_data = array();
        //$html_data ["room_id"] = $room_id;
        $html_data ["response"] = $data_result["response"];

        $result = array();
        $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_check_status($html_data);
        $result["rooms_statuses"] = $data_result["rooms_statuses"];
        //$result["room_id"] = $room_id;
        echo json_encode ( $result );
    }


    function ajax_room_check_status_v3(){
        $listings_data_result = $this->dcm_airbnb->get_listings();
        $listing_imports_result = $this->dcm_airbnb->get_listing_imports();

        $html_data = array();
        //$html_data ["room_id"] = $room_id;
        $html_data ["response_2"] = $listings_data_result;
        $html_data ["response"] = $listing_imports_result;

        $result = array();
        $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_check_status($html_data);
        //$result["rooms_statuses"] = $data_result["rooms_statuses"];
        //$result["room_id"] = $room_id;
        echo json_encode ( $result );
    }

    function room_check_status_session(){
        $room_id = 0;
        if(isset($_SESSION["dc_airbnb_incoherent_rooms"])){
            unset($_SESSION["dc_airbnb_incoherent_rooms"]);
        }
        $data_result = $this->dcm_airbnb->listimport(0, 1);

        //echo "<pre>";
        //print_r($data_result ["session_array"]);
        //die();

        $_SESSION["dc_airbnb_incoherent_rooms"] = $data_result ["session_array"];

        //$result = array();
        //$result["rooms_statuses"] = $data_result["rooms_statuses"];
        //$result["room_id"] = $room_id;
        //echo json_encode ( $result );
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms'>" );
    }

    function ajax_room_update(){

        $room_id = $_POST["reservations"][0]["room_id"];
        $listing_id = $_POST["reservations"][0]["listing_id"];

        $check_airbnb_price = $this->releases->check_airbnb_price(); // значення, яке відповідає чи включена перевірка цін
        // ф-я перевірки цін
        $is_correct_price = 1; // якщо перевірка не включена, по замовчуванню ціна коректна
        if($check_airbnb_price == 1){
            $correct_price_array = $this->dcm_airbnb->is_correct_price($room_id);
            $is_correct_price = $correct_price_array['result'];
        }

        if ($is_correct_price == 0) {
            $fail_price_str = $this->mlanguages->getdictionaryword("dc_airbnb_c2", "", "{clt_fail_price}");
            $html_data = array();
            $html_data["room_id"] = $room_id;
            $html_data["response"] = json_encode(array(
                'response' => $fail_price_str,
                'price_type' => $correct_price_array['price_type']
            ));

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_update($html_data);
            $result["status_category"] = "";
            $result["room_id"] = $room_id;
            echo json_encode($result);
        } else {
            $data_result = $this->dcm_airbnb->listupdate($listing_id, $room_id);

            $html_data = array();
            $html_data["room_id"] = $room_id;
            $html_data["response"] = $data_result["response"];

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_update($html_data);
            $result["status_category"] = $data_result["status_category"];
            $result["room_id"] = $room_id;
            echo json_encode($result);
        }
    }

    function ajax_room_update_v3(){

        $category_id = $_POST["category_id"];
        $listing_id = $_POST["listing_id"];
        $sync_type = $_POST["sync_type"];

        $check_airbnb_price = $this->releases->check_airbnb_price(); // значення, яке відповідає чи включена перевірка цін
        // ф-я перевірки цін
        $is_correct_price = 1; // якщо перевірка не включена, по замовчуванню ціна коректна
        if($check_airbnb_price == 1){
            $correct_price_array = $this->dcm_airbnb->is_correct_price(0, $category_id);
            $is_correct_price = $correct_price_array['result'];
        }
        
        $pricing_model = @$this->db->select('pricing_model')->get_where('dc_airbnb_listings_details', array('listing_id' => $listing_id))->row()->pricing_model;

        if($pricing_model != 'STANDARD'){
            $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
            $authparam = $this->dcm_airbnb->authparam();
            
            $curl_auth_param = array();
            $curl_auth_param ['clientid'] = $authparam['clientid'];
            $curl_auth_param ['access_token'] = $access_token;
            
            $curl_data = array();
            $curl_data ['pricing_model'] = 'STANDARD';
            
            $url = "https://api.airbnb.com/v2/pricing_and_availability/$listing_id";
            $data_result = $this->curl_model->curl_airbnb_set_pricing($curl_data, $curl_auth_param, $url, array (
                "returntype" => "array"
            ));
        }
//         echo "+++".$listing_id.$pricing_model."---";
//         die();

        if ($is_correct_price == 0) {
            $fail_price_str = $this->mlanguages->getdictionaryword("dc_airbnb_c2", "", "{clt_fail_price}");
            $html_data = array();
            $html_data["room_id"] = "";
            $html_data["response"] = json_encode(array(
                'response' => $fail_price_str,
                'price_type' => $correct_price_array['price_type']
            ));

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_room_connect($html_data);
            $result["status_category"] = "";
            $result["listing_id"] = "";
            $result["cat_id"] = $category_id;
            echo json_encode($result);
        } else {
            $import_id = $this->dcm_airbnb->get_import_id($listing_id);

            $data_result2 = "";

            if ($import_id > 0) {
                $data_result = $this->dcm_airbnb->listupdate_v3($import_id, $category_id, $sync_type);
            } else {
                $data_result = $this->dcm_airbnb->listupdate_rest($listing_id, $category_id, $sync_type);

                if ($sync_type == "sync_all") {
                    $data_result2 = $this->dc_airbnb_rest->update_airbnb($listing_id, $category_id, 1);
                } else {
                    $data_result2 = $this->dc_airbnb_rest->update_airbnb($listing_id, $category_id, 0);
                }
            }

            $html_data = array();
            $html_data["room_id"] = "";
            $html_data["response"] = $data_result["response"];
            $html_data["response"] .= json_encode($data_result2);

            $result = array();
            $result["html"] = $this->htmltpl->get_modal_ajax_airbnb_update($html_data);
            $result["status_category"] = $data_result["status_category"];
            $result["category_id"] = $category_id;
            $result["response_status"] = $data_result["response_status"];
            $result["response2"] = $data_result2;
            $result["POST"] = $_POST;
            echo json_encode($result);
        }
    }

    function ajax_room_error(){
        $room_id = $_POST["reservations"][0]["room_id"];
        $response = $this->dcm_airbnb->get_room_error($room_id);
        $html_data = array();
        $html_data ["room_id"] = "";
        $html_data ["response"] = $response;
        echo $this->htmltpl->get_modal_ajax_airbnb_error($html_data);
    }

    function ajax_room_error_v3(){
        $category_id = $_POST["category_id"];
        $response = $this->dcm_airbnb->get_room_error_v3($category_id);
        $html_data = array();
        $html_data ["room_id"] = "";
        $html_data ["response"] = stripslashes($response);

        echo $this->htmltpl->get_modal_ajax_airbnb_error($html_data);
    }

    function clear_listing(){
        $this->dcm_airbnb->clear_listing();

        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms'>" );
    }

    function clear_listing_v3(){
        $this->dcm_airbnb->clear_listing_v3();

        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms_v3'>" );
    }

    function deactivate(){
        $this->dcm_airbnb->deactivate();
        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/connecttoairbnb'>" );
    }

    function connecttoairbnb_refreshtoken(){
        $this->dcm_airbnb->refreshtoken();

        die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/connecttoairbnb'>" );
    }

    function get_listings($die_option = 0){
        $user_id = $this->dcm_airbnb->getxmlcfgvalue('user_id', 'int');
        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');

        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];

        $curl_auth_param = array();
        $curl_auth_param ['clientid'] = $authparam['clientid'];
        $curl_auth_param ['access_token'] = $access_token;

        $url = "https://api.airbnb.com/v2/listings/?user_id=" . $user_id .
        "&has_availability=false&exclude_cohosted_listings=true&_limit=50"; // сюда юзек з gettoken()

        $data_result = $this->curl_model->curl_airbnb(array(), $curl_auth_param, $url, array (
            "returntype" => "array"
        ));
        $result = $data_result["result"];
        echo "<pre>";
        $result = json_decode($result, true);
        print_r($result);

        if (isset($result["listings"])) {
            if (count($result["listings"]) > 0) {
                $sql = "UPDATE dc_airbnb_listing SET active = 0 WHERE 1";
                $query = $this->db->query($sql);
            }
            foreach ($result["listings"] as $listing_cell) {
                $sql = "INSERT INTO dc_airbnb_listing(listing_id, name, active)
					VALUES('" . $listing_cell["id"] . "', '" . addslashes($listing_cell["name"]) . "', 1)
					ON DUPLICATE KEY UPDATE name = '" . addslashes($listing_cell["name"]) . "', active = 1";
                $query = $this->db->query($sql);

                // save_listing_details
                $sql = "INSERT INTO dc_airbnb_listing_details(listing_id, property_type_category, city, street)
					VALUES('" . $listing_cell["id"] . "', '" . addslashes($listing_cell["property_type_category"]) . "',
					'" . addslashes($listing_cell["city"]) . "', '" . addslashes($listing_cell["street"]) . "')
					ON DUPLICATE KEY UPDATE property_type_category = '" . addslashes($listing_cell["property_type_category"]) . "',
					city = '" . addslashes($listing_cell["city"]) . "', street = '" . addslashes($listing_cell["street"]) . "'";
                $query = $this->db->query($sql);
            }
        }

        $this->Loger_admin->Save_SyncData ( "", "", $data_result['result'], 22, 13, $data_result ["dc_log_id"] );
        //die();
        if($die_option == 1){
            $_SESSION["dc_msg"]["text"] = print_r($result["listings"], true);
            die ( "<meta http-equiv='refresh' content='0;url=/dc_airbnb_c2/rooms_v2'>" );
        }
    }

    public function get_user_data()
    {

        $access_token = $this->dcm_airbnb->getxmlcfgvalue('access_token', 'str');
        $authparam = $this->dcm_airbnb->authparam();
        $clientid = $authparam['clientid'];

        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'.$access_token,
            'X-Airbnb-API-Key:' . $clientid,
            'X-AIRBNB-REQ-API-VERSION: 2022.12.31'
        );
        $url = 'https://api.airbnb.com/v2/users/me';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        echo "<pre>";
        print_r(json_decode($buffer, true));
        die();
        return json_decode($buffer, true);
    }

    public function l2u() {
        $data = array();
        $data['clientid'] = 'awkk3fb3oa4o67f5zbjg8eees';
        $data['clientsecret'] = '39qswxnwqbatb6mipl0ahktyl';

        $headers = array(
            'Content-Type:application/json',
            'X-Airbnb-Oauth-Token:'.$token,
            'X-Airbnb-API-Key:' . $client_id,
            'X-AIRBNB-REQ-API-VERSION: 2022.12.31'
        );
        $url = 'https://api.airbnb.com/v2/listings?user_id=' . $host_id . '&has_availability=false&exclude_cohosted_listings=true&_limit=50';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $buffer = curl_exec($ch);
        curl_close($ch);
        return json_decode($buffer, true);
    }

    public function responselog($listing_id, $category_id, $short =  0) {
        $row = $this->db->get_where("dc_airbnb_listingtocategory", array('listing_id'=>$listing_id))->row();
        if ($row) {
            $response = $row->response;
            echo "<pre>";
            $data = json_decode($response, true);
            if ($short == 1) {
                foreach ($data as $key => $value) {
                    if (isset($data[$key]['request'])) {
                        $data[$key]['request'] = json_decode($data[$key]['request'], true);
                    }
                    if (isset($data[$key]['response'])) {
                        $data[$key]['response'] = json_decode($data[$key]['response'], true);
                    }
                }
            }
            //echo $response;
            print_r($data);
        }
    }
}

