<?php
// ========================= set date ranges START ================================
$system_date_format = $this->frontdesk->get_systemdateformat();
$daterangepicker_date_format = $this->frontdesk->get_systemdateformat('for_daterangepicker');
$date_range = $this->session->userdata('stripe_charges_date_range');
if ($date_range != ""){
	list ( $start_date, $end_date ) = explode ( ' - ',  $date_range);
	$start_date_timestamp = strtotime($start_date." 00:00");
	$end_date_timestamp = strtotime($end_date." 23:59");
}else {
	$start_date_timestamp = strtotime("first day of this month 00:00");
	$end_date_timestamp = strtotime("last day of this month 23:59");
	$start_date = date($system_date_format, $start_date_timestamp);
	$end_date = date($system_date_format, $end_date_timestamp);
}
// ========================= set date ranges FIN ==================================
$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
if ($stripe_billing_customer_id == ""){//нема кастомера
	$charges_arr = array();
}else{//є кастомер
	$customer_id = $stripe_billing_customer_id;
	$secret_key = $this->stripe_billing_m2->get_secret_key();
	$this->stripe->setApiKey($secret_key);
	$charges_list = $this->charge->all ( array (
			"customer" => $customer_id,
			"created" => array (
					"gte" => $start_date_timestamp,
					"lte" => $end_date_timestamp
			)
	) );
	$charges_list = $charges_list->__toArray(true);
	//================================== pagination START =============================
	if ($this->session->userdata ( 'stripe_charges_lines_per_page' ) != ""){
		$lines_per_page = $this->session->userdata ( 'stripe_charges_lines_per_page' );
	}else{
		$lines_per_page = 50;
	}
	$cur_page = $current_page;
	$page_first_line = ($cur_page - 1) * $lines_per_page;
	$lines_per_current_page = $page_first_line+1;
	$url_for_pagination = "/stripe_concept/charges/";
	$all_lines_count = count($charges_list['data']);
	//================================== pagination FIN ===============================
	$charges_arr = array();
	foreach ($charges_list['data'] as $charge) {
		array_push ( $charges_arr, array (
		'n' => $lines_per_current_page,
		'id' => $charge ['id'],
		'amount' => $this->frontdesk->showcurrency(((int)$charge ['amount'])/100),
		'created' => date("Y-m-d H:i", $charge ['created']),
		'currency' => strtoupper ( $charge ['currency'] ),
		'description' => $charge ['description'],
		'last4' => $charge ['source']['last4'],
		'status' => "{clt_".$charge ['status']."}",
		) );
		$lines_per_current_page++;
	}
}

$menu_data = $this->htmltpl->get_left_settings_menu ( 99, 5 );
$data = array (
		'header' => $this->htmltpl->getHeader_new (0, 1, 0, "stripe_charges"),
		'footer_html' => $this->htmltpl->getFooter_new(),
		'settings_main_menu' => $menu_data ["main_menu"],
		'settings_sub_menu' => $menu_data ["sub_menu"],
		'charges_arr' => $charges_arr,
		'daterangepicker_date_format' => $daterangepicker_date_format,
		'start_date' => $start_date,
		'end_date' => $end_date,
		'pagination' => $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination),
);
$this->mlanguages->getdictionary("pagination", "", $data);
$this->mlanguages->getdictionary("stripe_charges", "", $data);
$this->mlanguages->getdictionary("stripe_statuses", "", $data);
$this->parser->parse ( 'templates/stripe_concept2/charges_view.html', $data );
