<?php
$stripe_billing_customer_id = $this->hotelix_config->get_record("stripe_billing_customer_id");
if ($stripe_billing_customer_id == ""){//нема кастомера
	$balance_block_pars_arr = array();
	$no_customer_hide_class = "d0";
}else{//є кастомер
	$no_customer_hide_class = "";
	$system_date_format = $this->frontdesk->get_systemdateformat();
	$secret_key = $this->stripe_billing_m->get_secret_key();
	$this->stripe->setApiKey($secret_key);
	try {
		$customer_obj = $this->customer->retrieve($stripe_billing_customer_id);
	} catch (\Stripe\Error\InvalidRequest $e) {
		$body = $e->getJsonBody();
		$err  = $body['error'];
		$error_text = $err['message'];
		$this->session->set_userdata ( array('error_page_message' => $error_text) );
		die ( "<meta http-equiv='refresh' content='0;url=/errors_c2/view_error/0/'>" );
	}
	$customer = $customer_obj->__toArray(true);
	//============== discount block START ====================================
	$coupon_arr = $customer['discount']['coupon'];
	$discount_arr = array();
	$discount_arr_pars = array();
	$discount_hide_class = "d0";
	if (isset($coupon_arr['id']) && $coupon_arr['id'] != ""){
		$discount_hide_class = "";
		$discount_arr['name'] = $coupon_arr['name'];
		$discount_arr['duration'] = $coupon_arr['duration'];
		if ($coupon_arr['amount_off'] != ""){//скидка фіксованва
			$discount_arr['amount'] = $this->frontdesk->showcurrency(((int)$coupon_arr['amount_off'])/100);
			$discount_arr['currency'] = strtoupper($coupon_arr['currency']);
		}else{//скидка відсоткова
			$discount_arr['amount'] = $coupon_arr['percent_off'];
			$discount_arr['currency'] = "%";
		}
		array_push($discount_arr_pars, $discount_arr);
	}
	//============== discount block FINISH ====================================
	$is_ok = false;
	if (isset($customer['subscriptions'])) {
		foreach ($customer['subscriptions']['data'] as $id=>$cell) {
			if (isset($cell['metadata']['is_main'])) {
				if ($cell['metadata']['is_main'] == 1 && isset($cell['plan'])) {
					$is_ok = true;
					$main_sub_data = $cell;
					//======================= ціна плану в залежності від проперті(готель/апарт) СТАРТ ===================
					$current_plan_amount = 0;
					$type_id_arr = $this->stripe_billing_m->get_property_type_id_arr_for_plans();
					$type_id = $type_id_arr['type_id'];
					if ($type_id == 2){//hotels
						$current_plan_amount = (int)$main_sub_data['plan']['amount']/100;
					}
					if ($type_id == 1){//aparts
						$tires_quantity = $cell['quantity'];
						if ($this->config->item('hms_stripe_billing_test') == 1) {
							$table_stripe_plans = "stripe_plans_test";
						} else {
							$table_stripe_plans = "stripe_plans";
						}
						$current_plan_id = $main_sub_data['plan']['id'];
						$sql = "SELECT $table_stripe_plans.plan_id, $table_stripe_plans.currency, stripe_plans_tiers.*
						FROM `global_hotelix`.$table_stripe_plans
						JOIN global_hotelix.stripe_plans_tiers ON stripe_plans_tiers.plan_id = $table_stripe_plans.plan_id
						WHERE `$table_stripe_plans`.`plan_id` = '$current_plan_id'";
						$query = $this->db->query($sql);
						if ($query->num_rows() > 0) {
							$res_tier_arr = $query->result_array();
							$tiers_price = $this->stripe_billing_m->tiers_price($res_tier_arr, $tires_quantity);
							$current_plan_amount = $tiers_price;
						}
					}
					$current_plan_amount = $this->frontdesk->showcurrency($current_plan_amount);
					//======================= ціна плану в залежності від проперті(готель/апарт) ФІНІШ ===================
					break;
				}
			}
		}
	}
	//========================== made balance block data START ============================
	$balance_block_pars_arr = array();
	$clt_is_absent = "{mlw_no}";
	$sub_period_start = ($is_ok) ? date("$system_date_format H:i", $main_sub_data['current_period_start']) : "";
	$sub_period_end = ($is_ok) ? date("$system_date_format H:i", $main_sub_data['current_period_end']) : "";
	$stripe_balance = (int)$customer['account_balance']/100  * (-1);
	$opened_invoices_balance = 0;
	$opened_invoices = $this->stripe_billing_m->get_opened_invoices();
	foreach ($opened_invoices as $opened_invoice) {
		$opened_invoices_balance += $opened_invoice['amount_due'];
	}
	$account_balance = $this->frontdesk->showcurrency(bcadd($stripe_balance, -$opened_invoices_balance, 2));
	$balance_block_pars_arr['account_balance'] = $account_balance;
	$balance_block_pars_arr['plan_name'] = ($is_ok) ? $main_sub_data['plan']['nickname'] : "";
	$balance_block_pars_arr['plan_amount'] = ($is_ok) ? $current_plan_amount : $clt_is_absent;
	$balance_block_pars_arr['currency'] = strtoupper($customer['currency']);
	$balance_block_pars_arr['plan_currency'] = ($is_ok) ? strtoupper($customer['currency']) : "";
	$balance_block_pars_arr['sub_period'] = ($is_ok) ? $sub_period_start.' - '.$sub_period_end : $clt_is_absent;
	$balance_block_pars_arr['sub_created'] = ($is_ok) ? date("$system_date_format H:i", $main_sub_data['created']) : $clt_is_absent;
	$biling_type = "";
	$charge_automatically_button = '';
	if ($is_ok){
		$biling_type = $main_sub_data['billing'];
		$balance_block_pars_arr['sub_billing'] = ($biling_type == "charge_automatically") ?  '{mlw_yes}' : '{mlw_no}';
		switch ($biling_type) {
			case "charge_automatically" :
				$activate_prolongation_hide_class = 'd0';
				$page_url = "/stripe_concept/set_charge_mode_post/off";
				$charge_automatically_button = '<a href="{page_url}"><button id="btn_1"
		 class="btn-danger pull-left btn mw-85" >{clt_deactivate_prolongation}</button></a>';
				break;
			case "send_invoice" :
				$deactivate_prolongation_hide_class = 'd0';
				$page_url = "/stripe_concept/set_charge_mode_post/on";
				$charge_automatically_button = '<a href="{page_url}"><button id="btn_2"
		 class="btn-success pull-left btn mw-85" >{clt_activate_prolongation}</button></a>';
				break;
		}
	}else{
		$balance_block_pars_arr['sub_billing'] = $clt_is_absent;
	}
	//========================== made balance block data END   ============================
	//========================== get upcoming invoice START ============================
	$invoice_hide_class = '';
	$invoice_pars_arr = array();
	try {
		$upcoming_invoice_data = $this->invoice->upcoming(array("customer" => $stripe_billing_customer_id));
		$error = 0;
	} catch ( \Stripe\Error\InvalidRequest $e ) {
		$body = $e->getJsonBody();
		$error = count($body['error']);
		$upcoming_invoice_data = array();
		$invoice_hide_class = 'd0';
	}
	if ($error == 0){
		$upcoming_invoice_data = $upcoming_invoice_data->__toArray(true);
		$upcoming_invoice_data['date'] = date("$system_date_format H:i", $upcoming_invoice_data['date']);
		$upcoming_invoice_data['currency'] = strtoupper($upcoming_invoice_data['currency']);
		$upcoming_invoice_data['total'] = $this->frontdesk->showcurrency(((int)$upcoming_invoice_data['total'])/100);
		$upcoming_invoice_data['total'] = $this->frontdesk->showcurrency(((int)$upcoming_invoice_data['amount_remaining'])/100);
		$invoice_lines_arr = array();
		foreach ($upcoming_invoice_data['lines']['data'] as $line) {
			array_push ( $invoice_lines_arr, array (
			'line_description' => $line ['description'],
			'amount' => $this->frontdesk->showcurrency(((int)$line ['amount'])/100),
			) );
		}
		$upcoming_invoice_data['lines'] = $invoice_lines_arr;
	}
	array_push($invoice_pars_arr, $upcoming_invoice_data);
	//========================== get upcoming invoice END   ============================
	//============== cards selector START ====================================
	$cards_select_options_arr = array();
	foreach ($customer['sources']['data'] as $source) {
		array_push ( $cards_select_options_arr, array (
		'id' => $source ['id'],
		'address_zip' => $source ['address_zip'],
		'address_zip_check' => $source ['address_zip_check'],
		'brand' => strtoupper ( $source ['brand'] ),
		'country' => $source ['country'],
		'exp_month' => $source ['exp_month'],
		'exp_year' => $source ['exp_year'],
		'funding' => $source ['funding'],
		'last4' => $source ['last4'],
		'name' => '**** '.$source ['last4'],
		) );
	}
	array_push ( $cards_select_options_arr, array (
	'id' => 'add_new_card',
	'address_zip' => $source ['address_zip'],
	'address_zip_check' => $source ['address_zip_check'],
	'brand' => '',
	'country' => $source ['country'],
	'exp_month' => $source ['exp_month'],
	'exp_year' => $source ['exp_year'],
	'funding' => $source ['funding'],
	'last4' => $source ['last4'],
	'name' => '{clt_add_new_card}',
	) );
	//============== cards selector FINIS ====================================
//======================= lock till open section START =======================
	$lock_till_open_hide_class = "d0";
	$lock_till_open_date = $this->hotelix_config->get_record("lock_till_open");
	if (!empty($lock_till_open_date) && strtotime($lock_till_open_date) > strtotime("today")){
		$lock_till_open_hide_class = "";
		$lock_till_open_date = date("$system_date_format", strtotime($lock_till_open_date));
	}
//======================= lock till open section FINAL =======================

	$pay_debts_hide_class = "d0";
	$opened_invoices = $this->stripe_billing_m->get_opened_invoices();
	if (count($opened_invoices) > 0){
		$pay_debts_hide_class = "";
	}

}
$menu_data = $this->htmltpl->get_left_settings_menu ( 99, 2 );
$data = array (
		'header' => $this->htmltpl->getHeader_new (0, 1, 0, "stripe_rate"),
		'footer_html' => $this->htmltpl->getFooter_new(),
		'settings_main_menu' => $menu_data ["main_menu"],
		'settings_sub_menu' => $menu_data ["sub_menu"],
		'radio_pars_arr' => $invoice_pars_arr,
		'invoice_pars_arr' => $invoice_pars_arr,
		'invoice_hide_class' => $invoice_hide_class,
		'customer_id' => $customer['id'],
		'discount_arr_pars' => $discount_arr_pars,
		'discount_hide_class' => $discount_hide_class,
		'cards_select_options_arr' => $cards_select_options_arr,
        'charge_automatically_button' => $charge_automatically_button,
		'pay_debts_hide_class' => $pay_debts_hide_class,
        'page_url' => $page_url,
		'no_customer_hide_class' => $no_customer_hide_class,
		'lock_till_open_hide_class' => $lock_till_open_hide_class,
		'lock_till_open_date' => $lock_till_open_date,
		'activate_prolongation_hide_class' => $activate_prolongation_hide_class,
		'deactivate_prolongation_hide_class' => $deactivate_prolongation_hide_class,
);
$data = array_merge($data, $balance_block_pars_arr);
$this->mlanguages->getdictionary("stripe_invoices", "", $data);
$this->mlanguages->getdictionary("stripe_summary", "", $data);
$this->parser->parse ( 'templates/stripe_concept/summary_view.html', $data );

