<?php
$cur_page = $current_page;
if ($this->session->userdata ( 'rws_dashboard_lines_per_page' ) != ""){
    $lines_per_page = $this->session->userdata ( 'rws_dashboard_lines_per_page' );
}else{
    $lines_per_page = 50;
}
$page_first_line = ($cur_page - 1) * $lines_per_page;
$url_for_pagination = "/reviews_c2/dashboard/";
$system_dateformat = $this->frontdesk->get_systemdateformat();
$picker_dateformat = $this->frontdesk->get_systemdateformat('for_daterangepicker');

$ses_data = (object) $this->session->userdata ( 'rws_dashboard_session_data' );
if (!isset($ses_data->date_range)){
    $start_date = date($system_dateformat, strtotime("- 7 days"));
    $end_date = date($system_dateformat, strtotime("now"));
}else{
    list ( $start_date, $end_date ) = explode ( ' - ', $ses_data->date_range );
}

$all_channels = $this->mreviews->get_all_channels_list();
$affected_channels = $this->mreviews->get_affected_channels();
$delta_length = 365;//days
$delta_period = array('start_date'=>date('Y-m-d H:i:s', strtotime("- $delta_length days")), 'end_date'=>date('Y-m-d H:i:s'), 'delta_length'=>$delta_length);
$deltas_data = $this->mreviews->get_deltas_periods_data(array('period'=>$delta_period));
$header_channels = $channels_select_options = $booking_multi_props_select_options = array();
$booking_dc_id = 1;
foreach ($affected_channels as $affected_channel) {
    if($affected_channel->in_header == 1){
        $header_channels[$affected_channel->dc_id] = $all_channels[$affected_channel->dc_id];
//         $header_channels[$affected_channel->dc_id]['hotel_id'] = $affected_channel->hotel_id;
        $header_channels[$affected_channel->dc_id]['id'] = $affected_channel->dc_id;
        $header_channels[$affected_channel->dc_id]['score'] = $affected_channel->score;
        $header_channels[$affected_channel->dc_id]['count'] = $affected_channel->count;
        $header_channels[$affected_channel->dc_id]['delta_txt'] = isset($deltas_data[$affected_channel->dc_id]['delta_txt'])? $deltas_data[$affected_channel->dc_id]['delta_txt'] : "{clt_nodata}";
    };
    if($affected_channel->in_reviews == 1){
        $channels_select_options[$affected_channel->dc_id] = $all_channels[$affected_channel->dc_id];
        $channels_select_options[$affected_channel->dc_id]['id'] = $affected_channel->dc_id;
        if ($affected_channel->dc_id == $booking_dc_id){
            $booking_props = $this->mreviews->get_booking_props();
            if ($booking_props->is_multi){
                $booking_multi_props_select_options = $booking_props->hotels;
            }
        }
    }
}
$scores_option_arr = $this->mreviews->get_review_scores_set();
$sort_options_arr = $this->mreviews->get_review_sort_options_arr();
$sql_where_str = "WHERE created BETWEEN '".date('Y-m-d H:i:s', strtotime("$start_date 0:0:0"))."' AND '".date('Y-m-d H:i:s', strtotime("$end_date 23:59:59"))."'";
if (isset($ses_data->scores) && count($ses_data->scores) != count($scores_option_arr)){
    $score_where_str = '';
    foreach ($scores_option_arr as $score_id => &$score) {
        if (!in_array($score_id, $ses_data->scores)){
            $score['selected'] = '';
        }else{
            $score_where_str .= " OR (score >= $score_id AND score < $score_id+1)";
        }
    }
    if ($score_where_str != ''){
        $score_where_str = substr_replace($score_where_str, '', 0, 3);
        $sql_where_str .= " AND ($score_where_str) ";
    }
}
if (isset($ses_data->text) && $ses_data->text != ''){
    $search_text = trim($ses_data->text);
    $sql_where_str .= " AND body LIKE '%$search_text%'";
}else{
    $search_text = '';
}
if (isset($ses_data->dc_id) && $ses_data->dc_id != ''){
    $channels_select_options[$ses_data->dc_id]['selected'] = 'selected';
    $sql_where_str .= " AND dc_id = $ses_data->dc_id";
    if (isset($ses_data->booking_multi_prop_id) && $ses_data->booking_multi_prop_id != '' && $ses_data->dc_id == $booking_dc_id){
        foreach ($booking_multi_props_select_options as &$multi_hotel) {
            if ($multi_hotel->id == $ses_data->booking_multi_prop_id){
                $multi_hotel->selected = 'selected';
            }
        }
        $sql_where_str .= " AND dc_hotel_id = $ses_data->booking_multi_prop_id";
    }
}
$sql_order_str = '';
if (isset($ses_data->sort) && $ses_data->sort != ''){
    $sort_options_arr[$ses_data->sort]['selected'] = 'selected';
    $sql_order_str = "ORDER BY score $ses_data->sort";
}

$tbl = "reviews_all_channels";
$sql = "SELECT SQL_CALC_FOUND_ROWS *
        FROM $tbl
        $sql_where_str
        $sql_order_str
        ORDER BY created DESC
        LIMIT $page_first_line, $lines_per_page";
$query_rws = $this->db->query($sql)->result();
$all_lines_count = $this->db->query ( "SELECT FOUND_ROWS() AS all_lines_count" )->row()->all_lines_count;
$reviews = array();
foreach ($query_rws as $rw) {
    $rw->eye_class = ($rw->block_1 || $rw->block_2)? 'fa fa-eye':'fa fa-eye-slash';
    $review_pars_block = "";
    switch ($rw->dc_id) {
        case 0:
            $review_pars_block = $this->mreviews->get_otelms_rw_block($rw);
            break;
        case 1:
            $review_pars_block = $this->mreviews->get_booking_rw_block($rw);
            break;
        case 22:
            $review_pars_block = $this->mreviews->get_airbnb_rw_block($rw);
            break;
    }
    array_push($reviews, array('rw_block'=>$review_pars_block));
}
$sql = "SELECT SUM(IF(block_1, 1, 0)) AS blocks1_count, SUM(IF(block_2, 1, 0)) AS blocks2_count
        FROM $tbl
        WHERE (block_1 OR block_2) = 1";
$query_row = $this->db->query($sql)->row();
$module_active_blocks1_count = $query_row->blocks1_count;
$module_active_blocks2_count = $query_row->blocks2_count;
$module_active_blocks_max_count = 10;
$data = array ();
$data["start_date"] = $start_date;
$data["end_date"] = $end_date;
$data['sort_options_arr'] = $sort_options_arr;
$data['search_text'] = $search_text;
$data["chnnls"] = $header_channels;
$data['chnnls_select_options'] = $channels_select_options;
$data['booking_multi_props_select_options'] = $booking_multi_props_select_options;
$data['scores_option_arr'] = $scores_option_arr;
$data['rws_by_chnnls'] = $reviews;

$data['is_booking_multi_props'] = isset($booking_props->is_multi) ? $booking_props->is_multi : 0;

$data["header"] = $this->htmltpl->getHeader_new ();
$data["footer_html"] = $this->htmltpl->getFooter_new ();
$data["left_menu"] = $this->htmltpl->get_left_menu (7, 2);
$data["picker_dateformat"] = $picker_dateformat;
$data["pagination"] = $this->htmltpl->pagination ($all_lines_count, $lines_per_page, $cur_page, $url_for_pagination);
$data["abil_count_block1"] = $module_active_blocks_max_count - $module_active_blocks1_count;
$data["abil_count_block2"] = $module_active_blocks_max_count - $module_active_blocks2_count;
$data["all_count_block1"] = $data["all_count_block2"] = $module_active_blocks_max_count;


$this->mlanguages->getdictionary("reviews_reputation", "", $data);

$this->parser->parse ( 'templates/reviews_c2/dashboard_view.html', $data );

?>