<?php
$data = array ();

$periods = array();
$periods[0]['period_name'] = "{clt_custom_period}";
$periods[0]['period_value'] = 0;
$periods[0]['period_checked'] = "";
$periods[0]['option'] = 3*100;

$periods[1]['period_name'] = "-7 / + 7 {clt_days}";
$periods[1]['period_value'] = 7;
$periods[1]['period_checked'] = "";
$periods[1]['option'] = 1*100;
$periods[2]['period_name'] = "-14 / + 14 {clt_days}";
$periods[2]['period_value'] = 14;
$periods[2]['period_checked'] = "";
$periods[2]['option'] = 2*100;

$comment_options = array();
$comment_options[0]['comment_opt_name'] = "{caption_hide_comment}";
$comment_options[0]['comment_opt_value'] = 0;
$comment_options[0]['comment_opt_checked'] = "";
$comment_options[0]['comment_opt_option'] = 1*101;
$comment_options[1]['comment_opt_name'] = "{caption_main_comment}";
$comment_options[1]['comment_opt_value'] = 1;
$comment_options[1]['comment_opt_checked'] = "";
$comment_options[1]['comment_opt_option'] = 2*101;
$comment_options[2]['comment_opt_name'] = "{caption_all_comments}";
$comment_options[2]['comment_opt_value'] = 2;
$comment_options[2]['comment_opt_checked'] = "";
$comment_options[2]['comment_opt_option'] = 3*101;

$balance_options = array();
$balance_options[0]['balance_opt_name'] = "{caption_donotshow}";
$balance_options[0]['balance_opt_value'] = 0;
$balance_options[0]['balance_opt_checked'] = "";
$balance_options[0]['balance_opt_option'] = 1*102;
$balance_options[1]['balance_opt_name'] = "{caption_absolute}";
$balance_options[1]['balance_opt_value'] = 1;
$balance_options[1]['balance_opt_checked'] = "";
$balance_options[1]['balance_opt_option'] = 2*102;
$balance_options[2]['balance_opt_name'] = "{caption_at_current_date}";
$balance_options[2]['balance_opt_value'] = 2;
$balance_options[2]['balance_opt_checked'] = "";
$balance_options[2]['balance_opt_option'] = 3*102;

$checkintime_options = array();
$checkintime_options[0]['checkintime_opt_name'] = "{caption_donotshow}";
$checkintime_options[0]['checkintime_opt_value'] = 0;
$checkintime_options[0]['checkintime_opt_checked'] = "";
$checkintime_options[0]['checkintime_opt_option'] = 1*103;
$checkintime_options[1]['checkintime_opt_name'] = "{caption_earlylate}";
$checkintime_options[1]['checkintime_opt_value'] = 1;
$checkintime_options[1]['checkintime_opt_checked'] = "";
$checkintime_options[1]['checkintime_opt_option'] = 2*103;
$checkintime_options[2]['checkintime_opt_name'] = "{caption_always}";
$checkintime_options[2]['checkintime_opt_value'] = 2;
$checkintime_options[2]['checkintime_opt_checked'] = "";
$checkintime_options[2]['checkintime_opt_option'] = 3*103;

$data['reception_desk_options'] = array();
$data['reception_desk_options'][0]['option_name'] = "{clt_closed}";
$data['reception_desk_options'][0]['option_value'] = 0;
$data['reception_desk_options'][0]['option_selected'] = "";
$data['reception_desk_options'][1]['option_name'] = "{clt_open}";
$data['reception_desk_options'][1]['option_value'] = 1;
$data['reception_desk_options'][1]['option_selected'] = "";
$data['reception_desk_options'][2]['option_name'] = "{clt_last}";
$data['reception_desk_options'][2]['option_value'] = 2;
$data['reception_desk_options'][2]['option_selected'] = "";

$data['date_range'] = "";
$data['days_past'] = "";
$data['days_ahead'] = "";

$data['custom_checked'] = "";
$data['custom_data_hidden_class'] = '';

$user_desktopdata = $this->musers_c2->get_userdesktop_data();

if (count($user_desktopdata) == 0) {
    $this->musers_c2->set_default_userdesktop_data();
    
    $user_desktopdata = $this->musers_c2->get_userdesktop_data();
}
foreach ($user_desktopdata as $cell) {
    $field_name = $cell['name'];
    switch ($field_name) {
        case 'date_range':
            if ($cell['int_value'] > 0) {
                $data['custom_data_hidden_class'] = 'd0';
                foreach ($periods as $key => $period_data) {
                    if ($period_data['period_value'] == $cell['int_value']) {
                        $periods[$key]['period_checked'] = "selected";
                    }
                }
            } else {
                $data['custom_checked'] = "checked";
            }
            break;
        case 'days_past':
            $data['days_past'] = $cell['int_value'];
            break;
        case 'days_ahead':
            $data['days_ahead'] = $cell['int_value'];
            break;
        case 'comment':
            foreach ($comment_options as $key => $comment_data) {
                if ($comment_data['comment_opt_value'] == $cell['int_value']) {
                    $comment_options[$key]['comment_opt_checked'] = "selected";
                }
            }
            break;
        case 'balance':
            foreach ($balance_options as $key => $balance_data) {
                if ($balance_data['balance_opt_value'] == $cell['int_value']) {
                    $balance_options[$key]['balance_opt_checked'] = "selected";
                }
            }
            break;
        case 'checkintime':
            foreach ($checkintime_options as $key => $checkintime_data) {
                if ($checkintime_data['checkintime_opt_value'] == $cell['int_value']) {
                    $checkintime_options[$key]['checkintime_opt_checked'] = "selected";
                }
            }
            break;
        case 'reception_desk':
            
            if (isset($data['reception_desk_options'][$cell['int_value']])) {
                $data['reception_desk_options'][$cell['int_value']]['option_selected'] = "selected";
            }
            break;
        default:
            $data[$field_name] = $cell['active'];
            if ($cell['active'] == 1) {
                $data[$field_name . '_checked'] = "checked";
            } else {
                $data[$field_name . '_checked'] = "";
            }
            break;
    }
}
$unread_reservations_visual_indication = array();
if ($this->releases->unread_reservations_visual_indication()) {
    $unread_reservations_visual_indication = array(array());
}

$data['periods'] = $periods;
$data['comment_options'] = $comment_options;
$data['balance_options'] = $balance_options;
$data['checkintime_options'] = $checkintime_options;
$data['unread_reservations_visual_indication'] = $unread_reservations_visual_indication;
// echo "<pre>";
// print_r($data);
// die();
$this->mlanguages->getdictionary("reservations_calendar", "", $data);
$this->mlanguages->getdictionary("reservations_reservationviewform", "", $data);
$this->parser->parse ( 'templates/reservation_c2_ajax_user_calendar_options_modal.html', $data );
?>