<?php
$selected_booking_prop_id = $booking_prop_id;
$selected_hms_property_id = null;
$properties_conections = $this->booking_api_mdl->get_properties_conections(array('method' => 'connected'));
$hms_properties = $this->booking_api_mdl->get_hms_properties();
foreach ($properties_conections as &$conection) {
    $property_attributes = $this->booking_api_mdl->get_property_attributes($conection->booking_property_id);
    $conection->booking_property_name = $property_attributes->Properties->Property->attributes()->HotelName;
    $conection->booking_status = $property_attributes->Properties->Property->TPA_Extensions->attributes()->HotelStatus;
    $conection->created = $property_attributes->Properties->Property->TPA_Extensions->attributes()->Created;
    $conection->hms_property_name = '';
    if (!$conection->hms_property_id) {
        $hms_property_binded = false;
        $conection->hms_property_id = '';
    }else {
        if ($conection->booking_property_id == $selected_booking_prop_id) {
            $selected_hms_property_id = $conection->hms_property_id;
        }
        $hms_property_binded = true;
        $conection->hms_property_name = $hms_properties[$conection->hms_property_id]->property_name;
        unset($hms_properties[$conection->hms_property_id]);
    }
    $conection->unbinded_hide_class = $hms_property_binded ? 'd0' : '';
    $conection->binded_hide_class = $hms_property_binded ? '' : 'd0';
    $conection->hms_property_hide_class = $hms_property_binded ? '' : 'd0';
}
$rooms_conections = $hms_property_rooms = $unbinded_booking_rooms_pars_arr = array();
array_push($unbinded_booking_rooms_pars_arr, array('bk_room_id' => '', 'bk_room_name' => '---'));

if (!is_null($selected_booking_prop_id)) {
    $hms_property_rooms = $this->booking_api_mdl->get_hms_property_rooms($selected_hms_property_id);
    $conected_rooms = $this->booking_api_mdl->get_rooms_conections($selected_booking_prop_id);
    $booking_rooms = $this->booking_api_mdl->get_booking_property_rooms($selected_booking_prop_id);
    foreach ($booking_rooms as &$booking_room) {
        $booking_room->hms_room_name = '';
        $booking_room->hms_room_id = '';
        if (!in_array($booking_room->ID, array_keys($conected_rooms))) {
            $hms_room_binded = false;
            array_push($unbinded_booking_rooms_pars_arr, array('bk_room_id' => $booking_room->ID, 'bk_room_name' => $booking_room->DescriptiveText));
        }else {
            $hms_room_binded = true;
            $booking_room->hms_room_name = $hms_property_rooms[$conected_rooms[$booking_room->ID]->category_id]->shortname;
            $booking_room->hms_room_id = $conected_rooms[$booking_room->ID]->category_id;
            unset($hms_property_rooms[$conected_rooms[$booking_room->ID]->category_id]);
        }
        $booking_room->unbinded_hide_class = $hms_room_binded ? 'd0' : '';
        $booking_room->binded_hide_class = $hms_room_binded ? '' : 'd0';
        $booking_room->active_hide_class = $booking_room->Active ? '' : 'd0';
        $booking_room->unactive_hide_class = $booking_room->Active ? 'd0' : '';
        array_push($rooms_conections, $booking_room);
    }
}
foreach ($hms_property_rooms as &$hms_property_room) {
    $hms_property_room->unbinded_booking_rooms_pars_arr = $unbinded_booking_rooms_pars_arr;
}
unset($hms_property_room);

$menu_data = $this->htmltpl->get_left_settings_menu ( 7, 1 );
$submenulist = $this->navigation->getnotelist_admin_2 ( 33, 1 );
$develop = $this->session->userdata('global_modify') ? true : false;
if ($develop) {
    $submenulist [14] ['active'] = 'class="active"';
}
$data = array(
    'submenulist' => $submenulist,
    'header' => $this->htmltpl->getHeader_new(),
    'footer' => $this->htmltpl->getFooter_new(),
    'settings_main_menu' => $menu_data["main_menu"],
    'settings_sub_menu' => $menu_data["sub_menu"],
    'properties_conections_data' => count($properties_conections) ? array(array('properties_conections' => $properties_conections)) : array(),
    'hms_rooms' => $hms_property_rooms,
    'rooms_conections_data' => count($rooms_conections) ? array(array('rooms_conections' => $rooms_conections)) : array(),
    'selected_booking_prop_id' => $selected_booking_prop_id,
    'selected_hms_property_id' => $selected_hms_property_id,
);
$this->mlanguages->getdictionary ( "dc_cannal_all_options", "", $data );
$this->parser->parse ( 'templates/dc_booking/rooms_list.html', $data );